<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$categories_view = new categories_view();

// Run the page
$categories_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$categories_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$categories_view->isExport()) { ?>
<script>
var fcategoriesview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fcategoriesview = currentForm = new ew.Form("fcategoriesview", "view");
	loadjs.done("fcategoriesview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$categories_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $categories_view->ExportOptions->render("body") ?>
<?php $categories_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $categories_view->showPageHeader(); ?>
<?php
$categories_view->showMessage();
?>
<form name="fcategoriesview" id="fcategoriesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="categories">
<input type="hidden" name="modal" value="<?php echo (int)$categories_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($categories_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_id"><?php echo $categories_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $categories_view->id->cellAttributes() ?>>
<span id="el_categories_id">
<span<?php echo $categories_view->id->viewAttributes() ?>><?php echo $categories_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($categories_view->courses_id->Visible) { // courses_id ?>
	<tr id="r_courses_id">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_courses_id"><?php echo $categories_view->courses_id->caption() ?></span></td>
		<td data-name="courses_id" <?php echo $categories_view->courses_id->cellAttributes() ?>>
<span id="el_categories_courses_id">
<span<?php echo $categories_view->courses_id->viewAttributes() ?>><?php echo $categories_view->courses_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($categories_view->category_name->Visible) { // category_name ?>
	<tr id="r_category_name">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_category_name"><?php echo $categories_view->category_name->caption() ?></span></td>
		<td data-name="category_name" <?php echo $categories_view->category_name->cellAttributes() ?>>
<span id="el_categories_category_name">
<span<?php echo $categories_view->category_name->viewAttributes() ?>><?php echo $categories_view->category_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($categories_view->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_description"><?php echo $categories_view->description->caption() ?></span></td>
		<td data-name="description" <?php echo $categories_view->description->cellAttributes() ?>>
<span id="el_categories_description">
<span<?php echo $categories_view->description->viewAttributes() ?>><?php echo $categories_view->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($categories_view->time->Visible) { // time ?>
	<tr id="r_time">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_time"><?php echo $categories_view->time->caption() ?></span></td>
		<td data-name="time" <?php echo $categories_view->time->cellAttributes() ?>>
<span id="el_categories_time">
<span<?php echo $categories_view->time->viewAttributes() ?>><?php echo $categories_view->time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($categories_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $categories_view->TableLeftColumnClass ?>"><span id="elh_categories_estado"><?php echo $categories_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $categories_view->estado->cellAttributes() ?>>
<span id="el_categories_estado">
<span<?php echo $categories_view->estado->viewAttributes() ?>><?php echo $categories_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$categories_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$categories_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$categories_view->terminate();
?>