<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for clientes
 */
class clientes extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_cliente;
	public $nombre_cliente;
	public $telefono_cliente;
	public $email_cliente;
	public $direccion_cliente;
	public $status_cliente;
	public $date_added;
	public $doc;
	public $vendedor;
	public $pais;
	public $departamento;
	public $provincia;
	public $distrito;
	public $cuenta;
	public $tipo1;
	public $tienda;
	public $users;
	public $deuda;
	public $debe;
	public $tipo_documento;
	public $n_documento;
	public $deuda1;
	public $debe1;
	public $tipo;
	public $estado;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'clientes';
		$this->TableName = 'clientes';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`clientes`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_cliente
		$this->id_cliente = new DbField('clientes', 'clientes', 'x_id_cliente', 'id_cliente', '`id_cliente`', '`id_cliente`', 3, 11, -1, FALSE, '`id_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_cliente->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_cliente->IsPrimaryKey = TRUE; // Primary key field
		$this->id_cliente->Sortable = TRUE; // Allow sort
		$this->id_cliente->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_cliente'] = &$this->id_cliente;

		// nombre_cliente
		$this->nombre_cliente = new DbField('clientes', 'clientes', 'x_nombre_cliente', 'nombre_cliente', '`nombre_cliente`', '`nombre_cliente`', 200, 255, -1, FALSE, '`nombre_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombre_cliente->Nullable = FALSE; // NOT NULL field
		$this->nombre_cliente->Required = TRUE; // Required field
		$this->nombre_cliente->Sortable = TRUE; // Allow sort
		$this->fields['nombre_cliente'] = &$this->nombre_cliente;

		// telefono_cliente
		$this->telefono_cliente = new DbField('clientes', 'clientes', 'x_telefono_cliente', 'telefono_cliente', '`telefono_cliente`', '`telefono_cliente`', 200, 30, -1, FALSE, '`telefono_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->telefono_cliente->Nullable = FALSE; // NOT NULL field
		$this->telefono_cliente->Required = TRUE; // Required field
		$this->telefono_cliente->Sortable = TRUE; // Allow sort
		$this->fields['telefono_cliente'] = &$this->telefono_cliente;

		// email_cliente
		$this->email_cliente = new DbField('clientes', 'clientes', 'x_email_cliente', 'email_cliente', '`email_cliente`', '`email_cliente`', 200, 64, -1, FALSE, '`email_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->email_cliente->Nullable = FALSE; // NOT NULL field
		$this->email_cliente->Required = TRUE; // Required field
		$this->email_cliente->Sortable = TRUE; // Allow sort
		$this->fields['email_cliente'] = &$this->email_cliente;

		// direccion_cliente
		$this->direccion_cliente = new DbField('clientes', 'clientes', 'x_direccion_cliente', 'direccion_cliente', '`direccion_cliente`', '`direccion_cliente`', 200, 255, -1, FALSE, '`direccion_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->direccion_cliente->Sortable = TRUE; // Allow sort
		$this->fields['direccion_cliente'] = &$this->direccion_cliente;

		// status_cliente
		$this->status_cliente = new DbField('clientes', 'clientes', 'x_status_cliente', 'status_cliente', '`status_cliente`', '`status_cliente`', 16, 4, -1, FALSE, '`status_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status_cliente->Sortable = TRUE; // Allow sort
		$this->status_cliente->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status_cliente'] = &$this->status_cliente;

		// date_added
		$this->date_added = new DbField('clientes', 'clientes', 'x_date_added', 'date_added', '`date_added`', CastDateFieldForLike("`date_added`", 0, "DB"), 135, 19, 0, FALSE, '`date_added`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date_added->Sortable = TRUE; // Allow sort
		$this->date_added->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['date_added'] = &$this->date_added;

		// doc
		$this->doc = new DbField('clientes', 'clientes', 'x_doc', 'doc', '`doc`', '`doc`', 200, 15, -1, FALSE, '`doc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->doc->Sortable = TRUE; // Allow sort
		$this->fields['doc'] = &$this->doc;

		// vendedor
		$this->vendedor = new DbField('clientes', 'clientes', 'x_vendedor', 'vendedor', '`vendedor`', '`vendedor`', 200, 100, -1, FALSE, '`vendedor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vendedor->Sortable = TRUE; // Allow sort
		$this->fields['vendedor'] = &$this->vendedor;

		// pais
		$this->pais = new DbField('clientes', 'clientes', 'x_pais', 'pais', '`pais`', '`pais`', 201, 65535, -1, FALSE, '`pais`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pais->Sortable = TRUE; // Allow sort
		$this->fields['pais'] = &$this->pais;

		// departamento
		$this->departamento = new DbField('clientes', 'clientes', 'x_departamento', 'departamento', '`departamento`', '`departamento`', 201, 65535, -1, FALSE, '`departamento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->departamento->Sortable = TRUE; // Allow sort
		$this->fields['departamento'] = &$this->departamento;

		// provincia
		$this->provincia = new DbField('clientes', 'clientes', 'x_provincia', 'provincia', '`provincia`', '`provincia`', 201, 65535, -1, FALSE, '`provincia`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->provincia->Sortable = TRUE; // Allow sort
		$this->fields['provincia'] = &$this->provincia;

		// distrito
		$this->distrito = new DbField('clientes', 'clientes', 'x_distrito', 'distrito', '`distrito`', '`distrito`', 201, 65535, -1, FALSE, '`distrito`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->distrito->Sortable = TRUE; // Allow sort
		$this->fields['distrito'] = &$this->distrito;

		// cuenta
		$this->cuenta = new DbField('clientes', 'clientes', 'x_cuenta', 'cuenta', '`cuenta`', '`cuenta`', 201, 65535, -1, FALSE, '`cuenta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->cuenta->Sortable = TRUE; // Allow sort
		$this->fields['cuenta'] = &$this->cuenta;

		// tipo1
		$this->tipo1 = new DbField('clientes', 'clientes', 'x_tipo1', 'tipo1', '`tipo1`', '`tipo1`', 3, 11, -1, FALSE, '`tipo1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo1->Sortable = TRUE; // Allow sort
		$this->tipo1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo1'] = &$this->tipo1;

		// tienda
		$this->tienda = new DbField('clientes', 'clientes', 'x_tienda', 'tienda', '`tienda`', '`tienda`', 3, 11, -1, FALSE, '`tienda`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tienda->Sortable = TRUE; // Allow sort
		$this->tienda->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tienda'] = &$this->tienda;

		// users
		$this->users = new DbField('clientes', 'clientes', 'x_users', 'users', '`users`', '`users`', 3, 11, -1, FALSE, '`users`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->users->Sortable = TRUE; // Allow sort
		$this->users->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['users'] = &$this->users;

		// deuda
		$this->deuda = new DbField('clientes', 'clientes', 'x_deuda', 'deuda', '`deuda`', '`deuda`', 131, 10, -1, FALSE, '`deuda`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->deuda->Sortable = TRUE; // Allow sort
		$this->deuda->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['deuda'] = &$this->deuda;

		// debe
		$this->debe = new DbField('clientes', 'clientes', 'x_debe', 'debe', '`debe`', '`debe`', 131, 10, -1, FALSE, '`debe`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->debe->Sortable = TRUE; // Allow sort
		$this->debe->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['debe'] = &$this->debe;

		// tipo_documento
		$this->tipo_documento = new DbField('clientes', 'clientes', 'x_tipo_documento', 'tipo_documento', '`tipo_documento`', '`tipo_documento`', 3, 11, -1, FALSE, '`tipo_documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_documento->Sortable = TRUE; // Allow sort
		$this->tipo_documento->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_documento'] = &$this->tipo_documento;

		// n_documento
		$this->n_documento = new DbField('clientes', 'clientes', 'x_n_documento', 'n_documento', '`n_documento`', '`n_documento`', 200, 15, -1, FALSE, '`n_documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->n_documento->Sortable = TRUE; // Allow sort
		$this->fields['n_documento'] = &$this->n_documento;

		// deuda1
		$this->deuda1 = new DbField('clientes', 'clientes', 'x_deuda1', 'deuda1', '`deuda1`', '`deuda1`', 131, 12, -1, FALSE, '`deuda1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->deuda1->Sortable = TRUE; // Allow sort
		$this->deuda1->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['deuda1'] = &$this->deuda1;

		// debe1
		$this->debe1 = new DbField('clientes', 'clientes', 'x_debe1', 'debe1', '`debe1`', '`debe1`', 131, 12, -1, FALSE, '`debe1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->debe1->Sortable = TRUE; // Allow sort
		$this->debe1->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['debe1'] = &$this->debe1;

		// tipo
		$this->tipo = new DbField('clientes', 'clientes', 'x_tipo', 'tipo', '`tipo`', '`tipo`', 3, 11, -1, FALSE, '`tipo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo->Sortable = TRUE; // Allow sort
		$this->tipo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo'] = &$this->tipo;

		// estado
		$this->estado = new DbField('clientes', 'clientes', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Nullable = FALSE; // NOT NULL field
		$this->estado->Required = TRUE; // Required field
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`clientes`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_cliente->setDbValue($conn->insert_ID());
			$rs['id_cliente'] = $this->id_cliente->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_cliente', $rs))
				AddFilter($where, QuotedName('id_cliente', $this->Dbid) . '=' . QuotedValue($rs['id_cliente'], $this->id_cliente->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_cliente->DbValue = $row['id_cliente'];
		$this->nombre_cliente->DbValue = $row['nombre_cliente'];
		$this->telefono_cliente->DbValue = $row['telefono_cliente'];
		$this->email_cliente->DbValue = $row['email_cliente'];
		$this->direccion_cliente->DbValue = $row['direccion_cliente'];
		$this->status_cliente->DbValue = $row['status_cliente'];
		$this->date_added->DbValue = $row['date_added'];
		$this->doc->DbValue = $row['doc'];
		$this->vendedor->DbValue = $row['vendedor'];
		$this->pais->DbValue = $row['pais'];
		$this->departamento->DbValue = $row['departamento'];
		$this->provincia->DbValue = $row['provincia'];
		$this->distrito->DbValue = $row['distrito'];
		$this->cuenta->DbValue = $row['cuenta'];
		$this->tipo1->DbValue = $row['tipo1'];
		$this->tienda->DbValue = $row['tienda'];
		$this->users->DbValue = $row['users'];
		$this->deuda->DbValue = $row['deuda'];
		$this->debe->DbValue = $row['debe'];
		$this->tipo_documento->DbValue = $row['tipo_documento'];
		$this->n_documento->DbValue = $row['n_documento'];
		$this->deuda1->DbValue = $row['deuda1'];
		$this->debe1->DbValue = $row['debe1'];
		$this->tipo->DbValue = $row['tipo'];
		$this->estado->DbValue = $row['estado'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_cliente` = @id_cliente@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_cliente', $row) ? $row['id_cliente'] : NULL;
		else
			$val = $this->id_cliente->OldValue !== NULL ? $this->id_cliente->OldValue : $this->id_cliente->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_cliente@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "clienteslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "clientesview.php")
			return $Language->phrase("View");
		elseif ($pageName == "clientesedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "clientesadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "clienteslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("clientesview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("clientesview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "clientesadd.php?" . $this->getUrlParm($parm);
		else
			$url = "clientesadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("clientesedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("clientesadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("clientesdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_cliente:" . JsonEncode($this->id_cliente->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_cliente->CurrentValue != NULL) {
			$url .= "id_cliente=" . urlencode($this->id_cliente->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_cliente") !== NULL)
				$arKeys[] = Param("id_cliente");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_cliente->CurrentValue = $key;
			else
				$this->id_cliente->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_cliente->setDbValue($rs->fields('id_cliente'));
		$this->nombre_cliente->setDbValue($rs->fields('nombre_cliente'));
		$this->telefono_cliente->setDbValue($rs->fields('telefono_cliente'));
		$this->email_cliente->setDbValue($rs->fields('email_cliente'));
		$this->direccion_cliente->setDbValue($rs->fields('direccion_cliente'));
		$this->status_cliente->setDbValue($rs->fields('status_cliente'));
		$this->date_added->setDbValue($rs->fields('date_added'));
		$this->doc->setDbValue($rs->fields('doc'));
		$this->vendedor->setDbValue($rs->fields('vendedor'));
		$this->pais->setDbValue($rs->fields('pais'));
		$this->departamento->setDbValue($rs->fields('departamento'));
		$this->provincia->setDbValue($rs->fields('provincia'));
		$this->distrito->setDbValue($rs->fields('distrito'));
		$this->cuenta->setDbValue($rs->fields('cuenta'));
		$this->tipo1->setDbValue($rs->fields('tipo1'));
		$this->tienda->setDbValue($rs->fields('tienda'));
		$this->users->setDbValue($rs->fields('users'));
		$this->deuda->setDbValue($rs->fields('deuda'));
		$this->debe->setDbValue($rs->fields('debe'));
		$this->tipo_documento->setDbValue($rs->fields('tipo_documento'));
		$this->n_documento->setDbValue($rs->fields('n_documento'));
		$this->deuda1->setDbValue($rs->fields('deuda1'));
		$this->debe1->setDbValue($rs->fields('debe1'));
		$this->tipo->setDbValue($rs->fields('tipo'));
		$this->estado->setDbValue($rs->fields('estado'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_cliente
		// nombre_cliente
		// telefono_cliente
		// email_cliente
		// direccion_cliente
		// status_cliente
		// date_added
		// doc
		// vendedor
		// pais
		// departamento
		// provincia
		// distrito
		// cuenta
		// tipo1
		// tienda
		// users
		// deuda
		// debe
		// tipo_documento
		// n_documento
		// deuda1
		// debe1
		// tipo
		// estado
		// id_cliente

		$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
		$this->id_cliente->ViewCustomAttributes = "";

		// nombre_cliente
		$this->nombre_cliente->ViewValue = $this->nombre_cliente->CurrentValue;
		$this->nombre_cliente->ViewCustomAttributes = "";

		// telefono_cliente
		$this->telefono_cliente->ViewValue = $this->telefono_cliente->CurrentValue;
		$this->telefono_cliente->ViewCustomAttributes = "";

		// email_cliente
		$this->email_cliente->ViewValue = $this->email_cliente->CurrentValue;
		$this->email_cliente->ViewCustomAttributes = "";

		// direccion_cliente
		$this->direccion_cliente->ViewValue = $this->direccion_cliente->CurrentValue;
		$this->direccion_cliente->ViewCustomAttributes = "";

		// status_cliente
		$this->status_cliente->ViewValue = $this->status_cliente->CurrentValue;
		$this->status_cliente->ViewValue = FormatNumber($this->status_cliente->ViewValue, 0, -2, -2, -2);
		$this->status_cliente->ViewCustomAttributes = "";

		// date_added
		$this->date_added->ViewValue = $this->date_added->CurrentValue;
		$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
		$this->date_added->ViewCustomAttributes = "";

		// doc
		$this->doc->ViewValue = $this->doc->CurrentValue;
		$this->doc->ViewCustomAttributes = "";

		// vendedor
		$this->vendedor->ViewValue = $this->vendedor->CurrentValue;
		$this->vendedor->ViewCustomAttributes = "";

		// pais
		$this->pais->ViewValue = $this->pais->CurrentValue;
		$this->pais->ViewCustomAttributes = "";

		// departamento
		$this->departamento->ViewValue = $this->departamento->CurrentValue;
		$this->departamento->ViewCustomAttributes = "";

		// provincia
		$this->provincia->ViewValue = $this->provincia->CurrentValue;
		$this->provincia->ViewCustomAttributes = "";

		// distrito
		$this->distrito->ViewValue = $this->distrito->CurrentValue;
		$this->distrito->ViewCustomAttributes = "";

		// cuenta
		$this->cuenta->ViewValue = $this->cuenta->CurrentValue;
		$this->cuenta->ViewCustomAttributes = "";

		// tipo1
		$this->tipo1->ViewValue = $this->tipo1->CurrentValue;
		$this->tipo1->ViewValue = FormatNumber($this->tipo1->ViewValue, 0, -2, -2, -2);
		$this->tipo1->ViewCustomAttributes = "";

		// tienda
		$this->tienda->ViewValue = $this->tienda->CurrentValue;
		$this->tienda->ViewValue = FormatNumber($this->tienda->ViewValue, 0, -2, -2, -2);
		$this->tienda->ViewCustomAttributes = "";

		// users
		$this->users->ViewValue = $this->users->CurrentValue;
		$this->users->ViewValue = FormatNumber($this->users->ViewValue, 0, -2, -2, -2);
		$this->users->ViewCustomAttributes = "";

		// deuda
		$this->deuda->ViewValue = $this->deuda->CurrentValue;
		$this->deuda->ViewValue = FormatNumber($this->deuda->ViewValue, 2, -2, -2, -2);
		$this->deuda->ViewCustomAttributes = "";

		// debe
		$this->debe->ViewValue = $this->debe->CurrentValue;
		$this->debe->ViewValue = FormatNumber($this->debe->ViewValue, 2, -2, -2, -2);
		$this->debe->ViewCustomAttributes = "";

		// tipo_documento
		$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
		$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
		$this->tipo_documento->ViewCustomAttributes = "";

		// n_documento
		$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
		$this->n_documento->ViewCustomAttributes = "";

		// deuda1
		$this->deuda1->ViewValue = $this->deuda1->CurrentValue;
		$this->deuda1->ViewValue = FormatNumber($this->deuda1->ViewValue, 2, -2, -2, -2);
		$this->deuda1->ViewCustomAttributes = "";

		// debe1
		$this->debe1->ViewValue = $this->debe1->CurrentValue;
		$this->debe1->ViewValue = FormatNumber($this->debe1->ViewValue, 2, -2, -2, -2);
		$this->debe1->ViewCustomAttributes = "";

		// tipo
		$this->tipo->ViewValue = $this->tipo->CurrentValue;
		$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
		$this->tipo->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// id_cliente
		$this->id_cliente->LinkCustomAttributes = "";
		$this->id_cliente->HrefValue = "";
		$this->id_cliente->TooltipValue = "";

		// nombre_cliente
		$this->nombre_cliente->LinkCustomAttributes = "";
		$this->nombre_cliente->HrefValue = "";
		$this->nombre_cliente->TooltipValue = "";

		// telefono_cliente
		$this->telefono_cliente->LinkCustomAttributes = "";
		$this->telefono_cliente->HrefValue = "";
		$this->telefono_cliente->TooltipValue = "";

		// email_cliente
		$this->email_cliente->LinkCustomAttributes = "";
		$this->email_cliente->HrefValue = "";
		$this->email_cliente->TooltipValue = "";

		// direccion_cliente
		$this->direccion_cliente->LinkCustomAttributes = "";
		$this->direccion_cliente->HrefValue = "";
		$this->direccion_cliente->TooltipValue = "";

		// status_cliente
		$this->status_cliente->LinkCustomAttributes = "";
		$this->status_cliente->HrefValue = "";
		$this->status_cliente->TooltipValue = "";

		// date_added
		$this->date_added->LinkCustomAttributes = "";
		$this->date_added->HrefValue = "";
		$this->date_added->TooltipValue = "";

		// doc
		$this->doc->LinkCustomAttributes = "";
		$this->doc->HrefValue = "";
		$this->doc->TooltipValue = "";

		// vendedor
		$this->vendedor->LinkCustomAttributes = "";
		$this->vendedor->HrefValue = "";
		$this->vendedor->TooltipValue = "";

		// pais
		$this->pais->LinkCustomAttributes = "";
		$this->pais->HrefValue = "";
		$this->pais->TooltipValue = "";

		// departamento
		$this->departamento->LinkCustomAttributes = "";
		$this->departamento->HrefValue = "";
		$this->departamento->TooltipValue = "";

		// provincia
		$this->provincia->LinkCustomAttributes = "";
		$this->provincia->HrefValue = "";
		$this->provincia->TooltipValue = "";

		// distrito
		$this->distrito->LinkCustomAttributes = "";
		$this->distrito->HrefValue = "";
		$this->distrito->TooltipValue = "";

		// cuenta
		$this->cuenta->LinkCustomAttributes = "";
		$this->cuenta->HrefValue = "";
		$this->cuenta->TooltipValue = "";

		// tipo1
		$this->tipo1->LinkCustomAttributes = "";
		$this->tipo1->HrefValue = "";
		$this->tipo1->TooltipValue = "";

		// tienda
		$this->tienda->LinkCustomAttributes = "";
		$this->tienda->HrefValue = "";
		$this->tienda->TooltipValue = "";

		// users
		$this->users->LinkCustomAttributes = "";
		$this->users->HrefValue = "";
		$this->users->TooltipValue = "";

		// deuda
		$this->deuda->LinkCustomAttributes = "";
		$this->deuda->HrefValue = "";
		$this->deuda->TooltipValue = "";

		// debe
		$this->debe->LinkCustomAttributes = "";
		$this->debe->HrefValue = "";
		$this->debe->TooltipValue = "";

		// tipo_documento
		$this->tipo_documento->LinkCustomAttributes = "";
		$this->tipo_documento->HrefValue = "";
		$this->tipo_documento->TooltipValue = "";

		// n_documento
		$this->n_documento->LinkCustomAttributes = "";
		$this->n_documento->HrefValue = "";
		$this->n_documento->TooltipValue = "";

		// deuda1
		$this->deuda1->LinkCustomAttributes = "";
		$this->deuda1->HrefValue = "";
		$this->deuda1->TooltipValue = "";

		// debe1
		$this->debe1->LinkCustomAttributes = "";
		$this->debe1->HrefValue = "";
		$this->debe1->TooltipValue = "";

		// tipo
		$this->tipo->LinkCustomAttributes = "";
		$this->tipo->HrefValue = "";
		$this->tipo->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_cliente
		$this->id_cliente->EditAttrs["class"] = "form-control";
		$this->id_cliente->EditCustomAttributes = "";
		$this->id_cliente->EditValue = $this->id_cliente->CurrentValue;
		$this->id_cliente->ViewCustomAttributes = "";

		// nombre_cliente
		$this->nombre_cliente->EditAttrs["class"] = "form-control";
		$this->nombre_cliente->EditCustomAttributes = "";
		if (!$this->nombre_cliente->Raw)
			$this->nombre_cliente->CurrentValue = HtmlDecode($this->nombre_cliente->CurrentValue);
		$this->nombre_cliente->EditValue = $this->nombre_cliente->CurrentValue;
		$this->nombre_cliente->PlaceHolder = RemoveHtml($this->nombre_cliente->caption());

		// telefono_cliente
		$this->telefono_cliente->EditAttrs["class"] = "form-control";
		$this->telefono_cliente->EditCustomAttributes = "";
		if (!$this->telefono_cliente->Raw)
			$this->telefono_cliente->CurrentValue = HtmlDecode($this->telefono_cliente->CurrentValue);
		$this->telefono_cliente->EditValue = $this->telefono_cliente->CurrentValue;
		$this->telefono_cliente->PlaceHolder = RemoveHtml($this->telefono_cliente->caption());

		// email_cliente
		$this->email_cliente->EditAttrs["class"] = "form-control";
		$this->email_cliente->EditCustomAttributes = "";
		if (!$this->email_cliente->Raw)
			$this->email_cliente->CurrentValue = HtmlDecode($this->email_cliente->CurrentValue);
		$this->email_cliente->EditValue = $this->email_cliente->CurrentValue;
		$this->email_cliente->PlaceHolder = RemoveHtml($this->email_cliente->caption());

		// direccion_cliente
		$this->direccion_cliente->EditAttrs["class"] = "form-control";
		$this->direccion_cliente->EditCustomAttributes = "";
		if (!$this->direccion_cliente->Raw)
			$this->direccion_cliente->CurrentValue = HtmlDecode($this->direccion_cliente->CurrentValue);
		$this->direccion_cliente->EditValue = $this->direccion_cliente->CurrentValue;
		$this->direccion_cliente->PlaceHolder = RemoveHtml($this->direccion_cliente->caption());

		// status_cliente
		$this->status_cliente->EditAttrs["class"] = "form-control";
		$this->status_cliente->EditCustomAttributes = "";
		$this->status_cliente->EditValue = $this->status_cliente->CurrentValue;
		$this->status_cliente->PlaceHolder = RemoveHtml($this->status_cliente->caption());

		// date_added
		$this->date_added->EditAttrs["class"] = "form-control";
		$this->date_added->EditCustomAttributes = "";
		$this->date_added->EditValue = FormatDateTime($this->date_added->CurrentValue, 8);
		$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

		// doc
		$this->doc->EditAttrs["class"] = "form-control";
		$this->doc->EditCustomAttributes = "";
		if (!$this->doc->Raw)
			$this->doc->CurrentValue = HtmlDecode($this->doc->CurrentValue);
		$this->doc->EditValue = $this->doc->CurrentValue;
		$this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

		// vendedor
		$this->vendedor->EditAttrs["class"] = "form-control";
		$this->vendedor->EditCustomAttributes = "";
		if (!$this->vendedor->Raw)
			$this->vendedor->CurrentValue = HtmlDecode($this->vendedor->CurrentValue);
		$this->vendedor->EditValue = $this->vendedor->CurrentValue;
		$this->vendedor->PlaceHolder = RemoveHtml($this->vendedor->caption());

		// pais
		$this->pais->EditAttrs["class"] = "form-control";
		$this->pais->EditCustomAttributes = "";
		$this->pais->EditValue = $this->pais->CurrentValue;
		$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

		// departamento
		$this->departamento->EditAttrs["class"] = "form-control";
		$this->departamento->EditCustomAttributes = "";
		$this->departamento->EditValue = $this->departamento->CurrentValue;
		$this->departamento->PlaceHolder = RemoveHtml($this->departamento->caption());

		// provincia
		$this->provincia->EditAttrs["class"] = "form-control";
		$this->provincia->EditCustomAttributes = "";
		$this->provincia->EditValue = $this->provincia->CurrentValue;
		$this->provincia->PlaceHolder = RemoveHtml($this->provincia->caption());

		// distrito
		$this->distrito->EditAttrs["class"] = "form-control";
		$this->distrito->EditCustomAttributes = "";
		$this->distrito->EditValue = $this->distrito->CurrentValue;
		$this->distrito->PlaceHolder = RemoveHtml($this->distrito->caption());

		// cuenta
		$this->cuenta->EditAttrs["class"] = "form-control";
		$this->cuenta->EditCustomAttributes = "";
		$this->cuenta->EditValue = $this->cuenta->CurrentValue;
		$this->cuenta->PlaceHolder = RemoveHtml($this->cuenta->caption());

		// tipo1
		$this->tipo1->EditAttrs["class"] = "form-control";
		$this->tipo1->EditCustomAttributes = "";
		$this->tipo1->EditValue = $this->tipo1->CurrentValue;
		$this->tipo1->PlaceHolder = RemoveHtml($this->tipo1->caption());

		// tienda
		$this->tienda->EditAttrs["class"] = "form-control";
		$this->tienda->EditCustomAttributes = "";
		$this->tienda->EditValue = $this->tienda->CurrentValue;
		$this->tienda->PlaceHolder = RemoveHtml($this->tienda->caption());

		// users
		$this->users->EditAttrs["class"] = "form-control";
		$this->users->EditCustomAttributes = "";
		$this->users->EditValue = $this->users->CurrentValue;
		$this->users->PlaceHolder = RemoveHtml($this->users->caption());

		// deuda
		$this->deuda->EditAttrs["class"] = "form-control";
		$this->deuda->EditCustomAttributes = "";
		$this->deuda->EditValue = $this->deuda->CurrentValue;
		$this->deuda->PlaceHolder = RemoveHtml($this->deuda->caption());
		if (strval($this->deuda->EditValue) != "" && is_numeric($this->deuda->EditValue))
			$this->deuda->EditValue = FormatNumber($this->deuda->EditValue, -2, -2, -2, -2);
		

		// debe
		$this->debe->EditAttrs["class"] = "form-control";
		$this->debe->EditCustomAttributes = "";
		$this->debe->EditValue = $this->debe->CurrentValue;
		$this->debe->PlaceHolder = RemoveHtml($this->debe->caption());
		if (strval($this->debe->EditValue) != "" && is_numeric($this->debe->EditValue))
			$this->debe->EditValue = FormatNumber($this->debe->EditValue, -2, -2, -2, -2);
		

		// tipo_documento
		$this->tipo_documento->EditAttrs["class"] = "form-control";
		$this->tipo_documento->EditCustomAttributes = "";
		$this->tipo_documento->EditValue = $this->tipo_documento->CurrentValue;
		$this->tipo_documento->PlaceHolder = RemoveHtml($this->tipo_documento->caption());

		// n_documento
		$this->n_documento->EditAttrs["class"] = "form-control";
		$this->n_documento->EditCustomAttributes = "";
		if (!$this->n_documento->Raw)
			$this->n_documento->CurrentValue = HtmlDecode($this->n_documento->CurrentValue);
		$this->n_documento->EditValue = $this->n_documento->CurrentValue;
		$this->n_documento->PlaceHolder = RemoveHtml($this->n_documento->caption());

		// deuda1
		$this->deuda1->EditAttrs["class"] = "form-control";
		$this->deuda1->EditCustomAttributes = "";
		$this->deuda1->EditValue = $this->deuda1->CurrentValue;
		$this->deuda1->PlaceHolder = RemoveHtml($this->deuda1->caption());
		if (strval($this->deuda1->EditValue) != "" && is_numeric($this->deuda1->EditValue))
			$this->deuda1->EditValue = FormatNumber($this->deuda1->EditValue, -2, -2, -2, -2);
		

		// debe1
		$this->debe1->EditAttrs["class"] = "form-control";
		$this->debe1->EditCustomAttributes = "";
		$this->debe1->EditValue = $this->debe1->CurrentValue;
		$this->debe1->PlaceHolder = RemoveHtml($this->debe1->caption());
		if (strval($this->debe1->EditValue) != "" && is_numeric($this->debe1->EditValue))
			$this->debe1->EditValue = FormatNumber($this->debe1->EditValue, -2, -2, -2, -2);
		

		// tipo
		$this->tipo->EditAttrs["class"] = "form-control";
		$this->tipo->EditCustomAttributes = "";
		$this->tipo->EditValue = $this->tipo->CurrentValue;
		$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_cliente);
					$doc->exportCaption($this->nombre_cliente);
					$doc->exportCaption($this->telefono_cliente);
					$doc->exportCaption($this->email_cliente);
					$doc->exportCaption($this->direccion_cliente);
					$doc->exportCaption($this->status_cliente);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->doc);
					$doc->exportCaption($this->vendedor);
					$doc->exportCaption($this->pais);
					$doc->exportCaption($this->departamento);
					$doc->exportCaption($this->provincia);
					$doc->exportCaption($this->distrito);
					$doc->exportCaption($this->cuenta);
					$doc->exportCaption($this->tipo1);
					$doc->exportCaption($this->tienda);
					$doc->exportCaption($this->users);
					$doc->exportCaption($this->deuda);
					$doc->exportCaption($this->debe);
					$doc->exportCaption($this->tipo_documento);
					$doc->exportCaption($this->n_documento);
					$doc->exportCaption($this->deuda1);
					$doc->exportCaption($this->debe1);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->estado);
				} else {
					$doc->exportCaption($this->id_cliente);
					$doc->exportCaption($this->nombre_cliente);
					$doc->exportCaption($this->telefono_cliente);
					$doc->exportCaption($this->email_cliente);
					$doc->exportCaption($this->direccion_cliente);
					$doc->exportCaption($this->status_cliente);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->doc);
					$doc->exportCaption($this->vendedor);
					$doc->exportCaption($this->tipo1);
					$doc->exportCaption($this->tienda);
					$doc->exportCaption($this->users);
					$doc->exportCaption($this->deuda);
					$doc->exportCaption($this->debe);
					$doc->exportCaption($this->tipo_documento);
					$doc->exportCaption($this->n_documento);
					$doc->exportCaption($this->deuda1);
					$doc->exportCaption($this->debe1);
					$doc->exportCaption($this->tipo);
					$doc->exportCaption($this->estado);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_cliente);
						$doc->exportField($this->nombre_cliente);
						$doc->exportField($this->telefono_cliente);
						$doc->exportField($this->email_cliente);
						$doc->exportField($this->direccion_cliente);
						$doc->exportField($this->status_cliente);
						$doc->exportField($this->date_added);
						$doc->exportField($this->doc);
						$doc->exportField($this->vendedor);
						$doc->exportField($this->pais);
						$doc->exportField($this->departamento);
						$doc->exportField($this->provincia);
						$doc->exportField($this->distrito);
						$doc->exportField($this->cuenta);
						$doc->exportField($this->tipo1);
						$doc->exportField($this->tienda);
						$doc->exportField($this->users);
						$doc->exportField($this->deuda);
						$doc->exportField($this->debe);
						$doc->exportField($this->tipo_documento);
						$doc->exportField($this->n_documento);
						$doc->exportField($this->deuda1);
						$doc->exportField($this->debe1);
						$doc->exportField($this->tipo);
						$doc->exportField($this->estado);
					} else {
						$doc->exportField($this->id_cliente);
						$doc->exportField($this->nombre_cliente);
						$doc->exportField($this->telefono_cliente);
						$doc->exportField($this->email_cliente);
						$doc->exportField($this->direccion_cliente);
						$doc->exportField($this->status_cliente);
						$doc->exportField($this->date_added);
						$doc->exportField($this->doc);
						$doc->exportField($this->vendedor);
						$doc->exportField($this->tipo1);
						$doc->exportField($this->tienda);
						$doc->exportField($this->users);
						$doc->exportField($this->deuda);
						$doc->exportField($this->debe);
						$doc->exportField($this->tipo_documento);
						$doc->exportField($this->n_documento);
						$doc->exportField($this->deuda1);
						$doc->exportField($this->debe1);
						$doc->exportField($this->tipo);
						$doc->exportField($this->estado);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>