<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class interesados_list extends interesados
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'interesados';

	// Page object name
	public $PageObjName = "interesados_list";

	// Grid form hidden field names
	public $FormName = "finteresadoslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (interesados)
		if (!isset($GLOBALS["interesados"]) || get_class($GLOBALS["interesados"]) == PROJECT_NAMESPACE . "interesados") {
			$GLOBALS["interesados"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["interesados"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "interesadosadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "interesadosdelete.php";
		$this->MultiUpdateUrl = "interesadosupdate.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'interesados');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option finteresadoslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $interesados;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($interesados);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idinteresado'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idinteresado->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->idinteresado->setVisibility();
		$this->id_usuarioencargado->setVisibility();
		$this->fecha->setVisibility();
		$this->_email->setVisibility();
		$this->cursos->setVisibility();
		$this->categorias->setVisibility();
		$this->nombres->setVisibility();
		$this->apellidos->setVisibility();
		$this->direccion->setVisibility();
		$this->ciudad->setVisibility();
		$this->provincia->setVisibility();
		$this->pais->setVisibility();
		$this->telefono->setVisibility();
		$this->tipo_certificado->setVisibility();
		$this->tipo_pago->setVisibility();
		$this->nombretarjeta->setVisibility();
		$this->numerotarjeta->setVisibility();
		$this->mes->setVisibility();
		$this->anio->setVisibility();
		$this->tipo_tarjeta->setVisibility();
		$this->nombrepaypal->setVisibility();
		$this->montopaypal->setVisibility();
		$this->emailpaypal->setVisibility();
		$this->don->setVisibility();
		$this->tipo_condicion->setVisibility();
		$this->acciones->setVisibility();
		$this->solicitud->setVisibility();
		$this->examen->setVisibility();
		$this->estado->setVisibility();
		$this->tipo->setVisibility();
		$this->codigo_certificado->setVisibility();
		$this->estado_entrega->setVisibility();
		$this->idioma->setVisibility();
		$this->tipo_documento->setVisibility();
		$this->n_documento->setVisibility();
		$this->condicion1->setVisibility();
		$this->condicion2->setVisibility();
		$this->consulta->setVisibility();
		$this->status->setVisibility();
		$this->codlogin->setVisibility();
		$this->idproyecto->setVisibility();
		$this->id_producto->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->idinteresado->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->idinteresado->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->idinteresado->AdvancedSearch->toJson(), ","); // Field idinteresado
		$filterList = Concat($filterList, $this->id_usuarioencargado->AdvancedSearch->toJson(), ","); // Field id_usuarioencargado
		$filterList = Concat($filterList, $this->fecha->AdvancedSearch->toJson(), ","); // Field fecha
		$filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
		$filterList = Concat($filterList, $this->cursos->AdvancedSearch->toJson(), ","); // Field cursos
		$filterList = Concat($filterList, $this->categorias->AdvancedSearch->toJson(), ","); // Field categorias
		$filterList = Concat($filterList, $this->nombres->AdvancedSearch->toJson(), ","); // Field nombres
		$filterList = Concat($filterList, $this->apellidos->AdvancedSearch->toJson(), ","); // Field apellidos
		$filterList = Concat($filterList, $this->direccion->AdvancedSearch->toJson(), ","); // Field direccion
		$filterList = Concat($filterList, $this->ciudad->AdvancedSearch->toJson(), ","); // Field ciudad
		$filterList = Concat($filterList, $this->provincia->AdvancedSearch->toJson(), ","); // Field provincia
		$filterList = Concat($filterList, $this->pais->AdvancedSearch->toJson(), ","); // Field pais
		$filterList = Concat($filterList, $this->telefono->AdvancedSearch->toJson(), ","); // Field telefono
		$filterList = Concat($filterList, $this->tipo_certificado->AdvancedSearch->toJson(), ","); // Field tipo_certificado
		$filterList = Concat($filterList, $this->tipo_pago->AdvancedSearch->toJson(), ","); // Field tipo_pago
		$filterList = Concat($filterList, $this->nombretarjeta->AdvancedSearch->toJson(), ","); // Field nombretarjeta
		$filterList = Concat($filterList, $this->numerotarjeta->AdvancedSearch->toJson(), ","); // Field numerotarjeta
		$filterList = Concat($filterList, $this->mes->AdvancedSearch->toJson(), ","); // Field mes
		$filterList = Concat($filterList, $this->anio->AdvancedSearch->toJson(), ","); // Field anio
		$filterList = Concat($filterList, $this->tipo_tarjeta->AdvancedSearch->toJson(), ","); // Field tipo_tarjeta
		$filterList = Concat($filterList, $this->nombrepaypal->AdvancedSearch->toJson(), ","); // Field nombrepaypal
		$filterList = Concat($filterList, $this->montopaypal->AdvancedSearch->toJson(), ","); // Field montopaypal
		$filterList = Concat($filterList, $this->emailpaypal->AdvancedSearch->toJson(), ","); // Field emailpaypal
		$filterList = Concat($filterList, $this->don->AdvancedSearch->toJson(), ","); // Field don
		$filterList = Concat($filterList, $this->tipo_condicion->AdvancedSearch->toJson(), ","); // Field tipo_condicion
		$filterList = Concat($filterList, $this->acciones->AdvancedSearch->toJson(), ","); // Field acciones
		$filterList = Concat($filterList, $this->solicitud->AdvancedSearch->toJson(), ","); // Field solicitud
		$filterList = Concat($filterList, $this->examen->AdvancedSearch->toJson(), ","); // Field examen
		$filterList = Concat($filterList, $this->estado->AdvancedSearch->toJson(), ","); // Field estado
		$filterList = Concat($filterList, $this->tipo->AdvancedSearch->toJson(), ","); // Field tipo
		$filterList = Concat($filterList, $this->codigo_certificado->AdvancedSearch->toJson(), ","); // Field codigo_certificado
		$filterList = Concat($filterList, $this->estado_entrega->AdvancedSearch->toJson(), ","); // Field estado_entrega
		$filterList = Concat($filterList, $this->idioma->AdvancedSearch->toJson(), ","); // Field idioma
		$filterList = Concat($filterList, $this->tipo_documento->AdvancedSearch->toJson(), ","); // Field tipo_documento
		$filterList = Concat($filterList, $this->n_documento->AdvancedSearch->toJson(), ","); // Field n_documento
		$filterList = Concat($filterList, $this->condicion1->AdvancedSearch->toJson(), ","); // Field condicion1
		$filterList = Concat($filterList, $this->condicion2->AdvancedSearch->toJson(), ","); // Field condicion2
		$filterList = Concat($filterList, $this->consulta->AdvancedSearch->toJson(), ","); // Field consulta
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->codlogin->AdvancedSearch->toJson(), ","); // Field codlogin
		$filterList = Concat($filterList, $this->idproyecto->AdvancedSearch->toJson(), ","); // Field idproyecto
		$filterList = Concat($filterList, $this->id_producto->AdvancedSearch->toJson(), ","); // Field id_producto
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "finteresadoslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field idinteresado
		$this->idinteresado->AdvancedSearch->SearchValue = @$filter["x_idinteresado"];
		$this->idinteresado->AdvancedSearch->SearchOperator = @$filter["z_idinteresado"];
		$this->idinteresado->AdvancedSearch->SearchCondition = @$filter["v_idinteresado"];
		$this->idinteresado->AdvancedSearch->SearchValue2 = @$filter["y_idinteresado"];
		$this->idinteresado->AdvancedSearch->SearchOperator2 = @$filter["w_idinteresado"];
		$this->idinteresado->AdvancedSearch->save();

		// Field id_usuarioencargado
		$this->id_usuarioencargado->AdvancedSearch->SearchValue = @$filter["x_id_usuarioencargado"];
		$this->id_usuarioencargado->AdvancedSearch->SearchOperator = @$filter["z_id_usuarioencargado"];
		$this->id_usuarioencargado->AdvancedSearch->SearchCondition = @$filter["v_id_usuarioencargado"];
		$this->id_usuarioencargado->AdvancedSearch->SearchValue2 = @$filter["y_id_usuarioencargado"];
		$this->id_usuarioencargado->AdvancedSearch->SearchOperator2 = @$filter["w_id_usuarioencargado"];
		$this->id_usuarioencargado->AdvancedSearch->save();

		// Field fecha
		$this->fecha->AdvancedSearch->SearchValue = @$filter["x_fecha"];
		$this->fecha->AdvancedSearch->SearchOperator = @$filter["z_fecha"];
		$this->fecha->AdvancedSearch->SearchCondition = @$filter["v_fecha"];
		$this->fecha->AdvancedSearch->SearchValue2 = @$filter["y_fecha"];
		$this->fecha->AdvancedSearch->SearchOperator2 = @$filter["w_fecha"];
		$this->fecha->AdvancedSearch->save();

		// Field email
		$this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
		$this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
		$this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
		$this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
		$this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
		$this->_email->AdvancedSearch->save();

		// Field cursos
		$this->cursos->AdvancedSearch->SearchValue = @$filter["x_cursos"];
		$this->cursos->AdvancedSearch->SearchOperator = @$filter["z_cursos"];
		$this->cursos->AdvancedSearch->SearchCondition = @$filter["v_cursos"];
		$this->cursos->AdvancedSearch->SearchValue2 = @$filter["y_cursos"];
		$this->cursos->AdvancedSearch->SearchOperator2 = @$filter["w_cursos"];
		$this->cursos->AdvancedSearch->save();

		// Field categorias
		$this->categorias->AdvancedSearch->SearchValue = @$filter["x_categorias"];
		$this->categorias->AdvancedSearch->SearchOperator = @$filter["z_categorias"];
		$this->categorias->AdvancedSearch->SearchCondition = @$filter["v_categorias"];
		$this->categorias->AdvancedSearch->SearchValue2 = @$filter["y_categorias"];
		$this->categorias->AdvancedSearch->SearchOperator2 = @$filter["w_categorias"];
		$this->categorias->AdvancedSearch->save();

		// Field nombres
		$this->nombres->AdvancedSearch->SearchValue = @$filter["x_nombres"];
		$this->nombres->AdvancedSearch->SearchOperator = @$filter["z_nombres"];
		$this->nombres->AdvancedSearch->SearchCondition = @$filter["v_nombres"];
		$this->nombres->AdvancedSearch->SearchValue2 = @$filter["y_nombres"];
		$this->nombres->AdvancedSearch->SearchOperator2 = @$filter["w_nombres"];
		$this->nombres->AdvancedSearch->save();

		// Field apellidos
		$this->apellidos->AdvancedSearch->SearchValue = @$filter["x_apellidos"];
		$this->apellidos->AdvancedSearch->SearchOperator = @$filter["z_apellidos"];
		$this->apellidos->AdvancedSearch->SearchCondition = @$filter["v_apellidos"];
		$this->apellidos->AdvancedSearch->SearchValue2 = @$filter["y_apellidos"];
		$this->apellidos->AdvancedSearch->SearchOperator2 = @$filter["w_apellidos"];
		$this->apellidos->AdvancedSearch->save();

		// Field direccion
		$this->direccion->AdvancedSearch->SearchValue = @$filter["x_direccion"];
		$this->direccion->AdvancedSearch->SearchOperator = @$filter["z_direccion"];
		$this->direccion->AdvancedSearch->SearchCondition = @$filter["v_direccion"];
		$this->direccion->AdvancedSearch->SearchValue2 = @$filter["y_direccion"];
		$this->direccion->AdvancedSearch->SearchOperator2 = @$filter["w_direccion"];
		$this->direccion->AdvancedSearch->save();

		// Field ciudad
		$this->ciudad->AdvancedSearch->SearchValue = @$filter["x_ciudad"];
		$this->ciudad->AdvancedSearch->SearchOperator = @$filter["z_ciudad"];
		$this->ciudad->AdvancedSearch->SearchCondition = @$filter["v_ciudad"];
		$this->ciudad->AdvancedSearch->SearchValue2 = @$filter["y_ciudad"];
		$this->ciudad->AdvancedSearch->SearchOperator2 = @$filter["w_ciudad"];
		$this->ciudad->AdvancedSearch->save();

		// Field provincia
		$this->provincia->AdvancedSearch->SearchValue = @$filter["x_provincia"];
		$this->provincia->AdvancedSearch->SearchOperator = @$filter["z_provincia"];
		$this->provincia->AdvancedSearch->SearchCondition = @$filter["v_provincia"];
		$this->provincia->AdvancedSearch->SearchValue2 = @$filter["y_provincia"];
		$this->provincia->AdvancedSearch->SearchOperator2 = @$filter["w_provincia"];
		$this->provincia->AdvancedSearch->save();

		// Field pais
		$this->pais->AdvancedSearch->SearchValue = @$filter["x_pais"];
		$this->pais->AdvancedSearch->SearchOperator = @$filter["z_pais"];
		$this->pais->AdvancedSearch->SearchCondition = @$filter["v_pais"];
		$this->pais->AdvancedSearch->SearchValue2 = @$filter["y_pais"];
		$this->pais->AdvancedSearch->SearchOperator2 = @$filter["w_pais"];
		$this->pais->AdvancedSearch->save();

		// Field telefono
		$this->telefono->AdvancedSearch->SearchValue = @$filter["x_telefono"];
		$this->telefono->AdvancedSearch->SearchOperator = @$filter["z_telefono"];
		$this->telefono->AdvancedSearch->SearchCondition = @$filter["v_telefono"];
		$this->telefono->AdvancedSearch->SearchValue2 = @$filter["y_telefono"];
		$this->telefono->AdvancedSearch->SearchOperator2 = @$filter["w_telefono"];
		$this->telefono->AdvancedSearch->save();

		// Field tipo_certificado
		$this->tipo_certificado->AdvancedSearch->SearchValue = @$filter["x_tipo_certificado"];
		$this->tipo_certificado->AdvancedSearch->SearchOperator = @$filter["z_tipo_certificado"];
		$this->tipo_certificado->AdvancedSearch->SearchCondition = @$filter["v_tipo_certificado"];
		$this->tipo_certificado->AdvancedSearch->SearchValue2 = @$filter["y_tipo_certificado"];
		$this->tipo_certificado->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_certificado"];
		$this->tipo_certificado->AdvancedSearch->save();

		// Field tipo_pago
		$this->tipo_pago->AdvancedSearch->SearchValue = @$filter["x_tipo_pago"];
		$this->tipo_pago->AdvancedSearch->SearchOperator = @$filter["z_tipo_pago"];
		$this->tipo_pago->AdvancedSearch->SearchCondition = @$filter["v_tipo_pago"];
		$this->tipo_pago->AdvancedSearch->SearchValue2 = @$filter["y_tipo_pago"];
		$this->tipo_pago->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_pago"];
		$this->tipo_pago->AdvancedSearch->save();

		// Field nombretarjeta
		$this->nombretarjeta->AdvancedSearch->SearchValue = @$filter["x_nombretarjeta"];
		$this->nombretarjeta->AdvancedSearch->SearchOperator = @$filter["z_nombretarjeta"];
		$this->nombretarjeta->AdvancedSearch->SearchCondition = @$filter["v_nombretarjeta"];
		$this->nombretarjeta->AdvancedSearch->SearchValue2 = @$filter["y_nombretarjeta"];
		$this->nombretarjeta->AdvancedSearch->SearchOperator2 = @$filter["w_nombretarjeta"];
		$this->nombretarjeta->AdvancedSearch->save();

		// Field numerotarjeta
		$this->numerotarjeta->AdvancedSearch->SearchValue = @$filter["x_numerotarjeta"];
		$this->numerotarjeta->AdvancedSearch->SearchOperator = @$filter["z_numerotarjeta"];
		$this->numerotarjeta->AdvancedSearch->SearchCondition = @$filter["v_numerotarjeta"];
		$this->numerotarjeta->AdvancedSearch->SearchValue2 = @$filter["y_numerotarjeta"];
		$this->numerotarjeta->AdvancedSearch->SearchOperator2 = @$filter["w_numerotarjeta"];
		$this->numerotarjeta->AdvancedSearch->save();

		// Field mes
		$this->mes->AdvancedSearch->SearchValue = @$filter["x_mes"];
		$this->mes->AdvancedSearch->SearchOperator = @$filter["z_mes"];
		$this->mes->AdvancedSearch->SearchCondition = @$filter["v_mes"];
		$this->mes->AdvancedSearch->SearchValue2 = @$filter["y_mes"];
		$this->mes->AdvancedSearch->SearchOperator2 = @$filter["w_mes"];
		$this->mes->AdvancedSearch->save();

		// Field anio
		$this->anio->AdvancedSearch->SearchValue = @$filter["x_anio"];
		$this->anio->AdvancedSearch->SearchOperator = @$filter["z_anio"];
		$this->anio->AdvancedSearch->SearchCondition = @$filter["v_anio"];
		$this->anio->AdvancedSearch->SearchValue2 = @$filter["y_anio"];
		$this->anio->AdvancedSearch->SearchOperator2 = @$filter["w_anio"];
		$this->anio->AdvancedSearch->save();

		// Field tipo_tarjeta
		$this->tipo_tarjeta->AdvancedSearch->SearchValue = @$filter["x_tipo_tarjeta"];
		$this->tipo_tarjeta->AdvancedSearch->SearchOperator = @$filter["z_tipo_tarjeta"];
		$this->tipo_tarjeta->AdvancedSearch->SearchCondition = @$filter["v_tipo_tarjeta"];
		$this->tipo_tarjeta->AdvancedSearch->SearchValue2 = @$filter["y_tipo_tarjeta"];
		$this->tipo_tarjeta->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_tarjeta"];
		$this->tipo_tarjeta->AdvancedSearch->save();

		// Field nombrepaypal
		$this->nombrepaypal->AdvancedSearch->SearchValue = @$filter["x_nombrepaypal"];
		$this->nombrepaypal->AdvancedSearch->SearchOperator = @$filter["z_nombrepaypal"];
		$this->nombrepaypal->AdvancedSearch->SearchCondition = @$filter["v_nombrepaypal"];
		$this->nombrepaypal->AdvancedSearch->SearchValue2 = @$filter["y_nombrepaypal"];
		$this->nombrepaypal->AdvancedSearch->SearchOperator2 = @$filter["w_nombrepaypal"];
		$this->nombrepaypal->AdvancedSearch->save();

		// Field montopaypal
		$this->montopaypal->AdvancedSearch->SearchValue = @$filter["x_montopaypal"];
		$this->montopaypal->AdvancedSearch->SearchOperator = @$filter["z_montopaypal"];
		$this->montopaypal->AdvancedSearch->SearchCondition = @$filter["v_montopaypal"];
		$this->montopaypal->AdvancedSearch->SearchValue2 = @$filter["y_montopaypal"];
		$this->montopaypal->AdvancedSearch->SearchOperator2 = @$filter["w_montopaypal"];
		$this->montopaypal->AdvancedSearch->save();

		// Field emailpaypal
		$this->emailpaypal->AdvancedSearch->SearchValue = @$filter["x_emailpaypal"];
		$this->emailpaypal->AdvancedSearch->SearchOperator = @$filter["z_emailpaypal"];
		$this->emailpaypal->AdvancedSearch->SearchCondition = @$filter["v_emailpaypal"];
		$this->emailpaypal->AdvancedSearch->SearchValue2 = @$filter["y_emailpaypal"];
		$this->emailpaypal->AdvancedSearch->SearchOperator2 = @$filter["w_emailpaypal"];
		$this->emailpaypal->AdvancedSearch->save();

		// Field don
		$this->don->AdvancedSearch->SearchValue = @$filter["x_don"];
		$this->don->AdvancedSearch->SearchOperator = @$filter["z_don"];
		$this->don->AdvancedSearch->SearchCondition = @$filter["v_don"];
		$this->don->AdvancedSearch->SearchValue2 = @$filter["y_don"];
		$this->don->AdvancedSearch->SearchOperator2 = @$filter["w_don"];
		$this->don->AdvancedSearch->save();

		// Field tipo_condicion
		$this->tipo_condicion->AdvancedSearch->SearchValue = @$filter["x_tipo_condicion"];
		$this->tipo_condicion->AdvancedSearch->SearchOperator = @$filter["z_tipo_condicion"];
		$this->tipo_condicion->AdvancedSearch->SearchCondition = @$filter["v_tipo_condicion"];
		$this->tipo_condicion->AdvancedSearch->SearchValue2 = @$filter["y_tipo_condicion"];
		$this->tipo_condicion->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_condicion"];
		$this->tipo_condicion->AdvancedSearch->save();

		// Field acciones
		$this->acciones->AdvancedSearch->SearchValue = @$filter["x_acciones"];
		$this->acciones->AdvancedSearch->SearchOperator = @$filter["z_acciones"];
		$this->acciones->AdvancedSearch->SearchCondition = @$filter["v_acciones"];
		$this->acciones->AdvancedSearch->SearchValue2 = @$filter["y_acciones"];
		$this->acciones->AdvancedSearch->SearchOperator2 = @$filter["w_acciones"];
		$this->acciones->AdvancedSearch->save();

		// Field solicitud
		$this->solicitud->AdvancedSearch->SearchValue = @$filter["x_solicitud"];
		$this->solicitud->AdvancedSearch->SearchOperator = @$filter["z_solicitud"];
		$this->solicitud->AdvancedSearch->SearchCondition = @$filter["v_solicitud"];
		$this->solicitud->AdvancedSearch->SearchValue2 = @$filter["y_solicitud"];
		$this->solicitud->AdvancedSearch->SearchOperator2 = @$filter["w_solicitud"];
		$this->solicitud->AdvancedSearch->save();

		// Field examen
		$this->examen->AdvancedSearch->SearchValue = @$filter["x_examen"];
		$this->examen->AdvancedSearch->SearchOperator = @$filter["z_examen"];
		$this->examen->AdvancedSearch->SearchCondition = @$filter["v_examen"];
		$this->examen->AdvancedSearch->SearchValue2 = @$filter["y_examen"];
		$this->examen->AdvancedSearch->SearchOperator2 = @$filter["w_examen"];
		$this->examen->AdvancedSearch->save();

		// Field estado
		$this->estado->AdvancedSearch->SearchValue = @$filter["x_estado"];
		$this->estado->AdvancedSearch->SearchOperator = @$filter["z_estado"];
		$this->estado->AdvancedSearch->SearchCondition = @$filter["v_estado"];
		$this->estado->AdvancedSearch->SearchValue2 = @$filter["y_estado"];
		$this->estado->AdvancedSearch->SearchOperator2 = @$filter["w_estado"];
		$this->estado->AdvancedSearch->save();

		// Field tipo
		$this->tipo->AdvancedSearch->SearchValue = @$filter["x_tipo"];
		$this->tipo->AdvancedSearch->SearchOperator = @$filter["z_tipo"];
		$this->tipo->AdvancedSearch->SearchCondition = @$filter["v_tipo"];
		$this->tipo->AdvancedSearch->SearchValue2 = @$filter["y_tipo"];
		$this->tipo->AdvancedSearch->SearchOperator2 = @$filter["w_tipo"];
		$this->tipo->AdvancedSearch->save();

		// Field codigo_certificado
		$this->codigo_certificado->AdvancedSearch->SearchValue = @$filter["x_codigo_certificado"];
		$this->codigo_certificado->AdvancedSearch->SearchOperator = @$filter["z_codigo_certificado"];
		$this->codigo_certificado->AdvancedSearch->SearchCondition = @$filter["v_codigo_certificado"];
		$this->codigo_certificado->AdvancedSearch->SearchValue2 = @$filter["y_codigo_certificado"];
		$this->codigo_certificado->AdvancedSearch->SearchOperator2 = @$filter["w_codigo_certificado"];
		$this->codigo_certificado->AdvancedSearch->save();

		// Field estado_entrega
		$this->estado_entrega->AdvancedSearch->SearchValue = @$filter["x_estado_entrega"];
		$this->estado_entrega->AdvancedSearch->SearchOperator = @$filter["z_estado_entrega"];
		$this->estado_entrega->AdvancedSearch->SearchCondition = @$filter["v_estado_entrega"];
		$this->estado_entrega->AdvancedSearch->SearchValue2 = @$filter["y_estado_entrega"];
		$this->estado_entrega->AdvancedSearch->SearchOperator2 = @$filter["w_estado_entrega"];
		$this->estado_entrega->AdvancedSearch->save();

		// Field idioma
		$this->idioma->AdvancedSearch->SearchValue = @$filter["x_idioma"];
		$this->idioma->AdvancedSearch->SearchOperator = @$filter["z_idioma"];
		$this->idioma->AdvancedSearch->SearchCondition = @$filter["v_idioma"];
		$this->idioma->AdvancedSearch->SearchValue2 = @$filter["y_idioma"];
		$this->idioma->AdvancedSearch->SearchOperator2 = @$filter["w_idioma"];
		$this->idioma->AdvancedSearch->save();

		// Field tipo_documento
		$this->tipo_documento->AdvancedSearch->SearchValue = @$filter["x_tipo_documento"];
		$this->tipo_documento->AdvancedSearch->SearchOperator = @$filter["z_tipo_documento"];
		$this->tipo_documento->AdvancedSearch->SearchCondition = @$filter["v_tipo_documento"];
		$this->tipo_documento->AdvancedSearch->SearchValue2 = @$filter["y_tipo_documento"];
		$this->tipo_documento->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_documento"];
		$this->tipo_documento->AdvancedSearch->save();

		// Field n_documento
		$this->n_documento->AdvancedSearch->SearchValue = @$filter["x_n_documento"];
		$this->n_documento->AdvancedSearch->SearchOperator = @$filter["z_n_documento"];
		$this->n_documento->AdvancedSearch->SearchCondition = @$filter["v_n_documento"];
		$this->n_documento->AdvancedSearch->SearchValue2 = @$filter["y_n_documento"];
		$this->n_documento->AdvancedSearch->SearchOperator2 = @$filter["w_n_documento"];
		$this->n_documento->AdvancedSearch->save();

		// Field condicion1
		$this->condicion1->AdvancedSearch->SearchValue = @$filter["x_condicion1"];
		$this->condicion1->AdvancedSearch->SearchOperator = @$filter["z_condicion1"];
		$this->condicion1->AdvancedSearch->SearchCondition = @$filter["v_condicion1"];
		$this->condicion1->AdvancedSearch->SearchValue2 = @$filter["y_condicion1"];
		$this->condicion1->AdvancedSearch->SearchOperator2 = @$filter["w_condicion1"];
		$this->condicion1->AdvancedSearch->save();

		// Field condicion2
		$this->condicion2->AdvancedSearch->SearchValue = @$filter["x_condicion2"];
		$this->condicion2->AdvancedSearch->SearchOperator = @$filter["z_condicion2"];
		$this->condicion2->AdvancedSearch->SearchCondition = @$filter["v_condicion2"];
		$this->condicion2->AdvancedSearch->SearchValue2 = @$filter["y_condicion2"];
		$this->condicion2->AdvancedSearch->SearchOperator2 = @$filter["w_condicion2"];
		$this->condicion2->AdvancedSearch->save();

		// Field consulta
		$this->consulta->AdvancedSearch->SearchValue = @$filter["x_consulta"];
		$this->consulta->AdvancedSearch->SearchOperator = @$filter["z_consulta"];
		$this->consulta->AdvancedSearch->SearchCondition = @$filter["v_consulta"];
		$this->consulta->AdvancedSearch->SearchValue2 = @$filter["y_consulta"];
		$this->consulta->AdvancedSearch->SearchOperator2 = @$filter["w_consulta"];
		$this->consulta->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field codlogin
		$this->codlogin->AdvancedSearch->SearchValue = @$filter["x_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator = @$filter["z_codlogin"];
		$this->codlogin->AdvancedSearch->SearchCondition = @$filter["v_codlogin"];
		$this->codlogin->AdvancedSearch->SearchValue2 = @$filter["y_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator2 = @$filter["w_codlogin"];
		$this->codlogin->AdvancedSearch->save();

		// Field idproyecto
		$this->idproyecto->AdvancedSearch->SearchValue = @$filter["x_idproyecto"];
		$this->idproyecto->AdvancedSearch->SearchOperator = @$filter["z_idproyecto"];
		$this->idproyecto->AdvancedSearch->SearchCondition = @$filter["v_idproyecto"];
		$this->idproyecto->AdvancedSearch->SearchValue2 = @$filter["y_idproyecto"];
		$this->idproyecto->AdvancedSearch->SearchOperator2 = @$filter["w_idproyecto"];
		$this->idproyecto->AdvancedSearch->save();

		// Field id_producto
		$this->id_producto->AdvancedSearch->SearchValue = @$filter["x_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator = @$filter["z_id_producto"];
		$this->id_producto->AdvancedSearch->SearchCondition = @$filter["v_id_producto"];
		$this->id_producto->AdvancedSearch->SearchValue2 = @$filter["y_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator2 = @$filter["w_id_producto"];
		$this->id_producto->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->_email, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombres, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->apellidos, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->direccion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ciudad, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->provincia, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pais, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->telefono, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombretarjeta, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->numerotarjeta, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->anio, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tipo_tarjeta, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombrepaypal, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->montopaypal, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->emailpaypal, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->don, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->codigo_certificado, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->consulta, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->codlogin, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->idinteresado); // idinteresado
			$this->updateSort($this->id_usuarioencargado); // id_usuarioencargado
			$this->updateSort($this->fecha); // fecha
			$this->updateSort($this->_email); // email
			$this->updateSort($this->cursos); // cursos
			$this->updateSort($this->categorias); // categorias
			$this->updateSort($this->nombres); // nombres
			$this->updateSort($this->apellidos); // apellidos
			$this->updateSort($this->direccion); // direccion
			$this->updateSort($this->ciudad); // ciudad
			$this->updateSort($this->provincia); // provincia
			$this->updateSort($this->pais); // pais
			$this->updateSort($this->telefono); // telefono
			$this->updateSort($this->tipo_certificado); // tipo_certificado
			$this->updateSort($this->tipo_pago); // tipo_pago
			$this->updateSort($this->nombretarjeta); // nombretarjeta
			$this->updateSort($this->numerotarjeta); // numerotarjeta
			$this->updateSort($this->mes); // mes
			$this->updateSort($this->anio); // anio
			$this->updateSort($this->tipo_tarjeta); // tipo_tarjeta
			$this->updateSort($this->nombrepaypal); // nombrepaypal
			$this->updateSort($this->montopaypal); // montopaypal
			$this->updateSort($this->emailpaypal); // emailpaypal
			$this->updateSort($this->don); // don
			$this->updateSort($this->tipo_condicion); // tipo_condicion
			$this->updateSort($this->acciones); // acciones
			$this->updateSort($this->solicitud); // solicitud
			$this->updateSort($this->examen); // examen
			$this->updateSort($this->estado); // estado
			$this->updateSort($this->tipo); // tipo
			$this->updateSort($this->codigo_certificado); // codigo_certificado
			$this->updateSort($this->estado_entrega); // estado_entrega
			$this->updateSort($this->idioma); // idioma
			$this->updateSort($this->tipo_documento); // tipo_documento
			$this->updateSort($this->n_documento); // n_documento
			$this->updateSort($this->condicion1); // condicion1
			$this->updateSort($this->condicion2); // condicion2
			$this->updateSort($this->consulta); // consulta
			$this->updateSort($this->status); // status
			$this->updateSort($this->codlogin); // codlogin
			$this->updateSort($this->idproyecto); // idproyecto
			$this->updateSort($this->id_producto); // id_producto
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->idinteresado->setSort("");
				$this->id_usuarioencargado->setSort("");
				$this->fecha->setSort("");
				$this->_email->setSort("");
				$this->cursos->setSort("");
				$this->categorias->setSort("");
				$this->nombres->setSort("");
				$this->apellidos->setSort("");
				$this->direccion->setSort("");
				$this->ciudad->setSort("");
				$this->provincia->setSort("");
				$this->pais->setSort("");
				$this->telefono->setSort("");
				$this->tipo_certificado->setSort("");
				$this->tipo_pago->setSort("");
				$this->nombretarjeta->setSort("");
				$this->numerotarjeta->setSort("");
				$this->mes->setSort("");
				$this->anio->setSort("");
				$this->tipo_tarjeta->setSort("");
				$this->nombrepaypal->setSort("");
				$this->montopaypal->setSort("");
				$this->emailpaypal->setSort("");
				$this->don->setSort("");
				$this->tipo_condicion->setSort("");
				$this->acciones->setSort("");
				$this->solicitud->setSort("");
				$this->examen->setSort("");
				$this->estado->setSort("");
				$this->tipo->setSort("");
				$this->codigo_certificado->setSort("");
				$this->estado_entrega->setSort("");
				$this->idioma->setSort("");
				$this->tipo_documento->setSort("");
				$this->n_documento->setSort("");
				$this->condicion1->setSort("");
				$this->condicion2->setSort("");
				$this->consulta->setSort("");
				$this->status->setSort("");
				$this->codlogin->setSort("");
				$this->idproyecto->setSort("");
				$this->id_producto->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = $this->ListOptions["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = $this->ListOptions["delete"];
		if ($Security->isLoggedIn())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->idinteresado->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = $this->AddUrl != "" && $Security->isLoggedIn();
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"finteresadoslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"finteresadoslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.finteresadoslist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idinteresado->setDbValue($row['idinteresado']);
		$this->id_usuarioencargado->setDbValue($row['id_usuarioencargado']);
		$this->fecha->setDbValue($row['fecha']);
		$this->_email->setDbValue($row['email']);
		$this->cursos->setDbValue($row['cursos']);
		$this->categorias->setDbValue($row['categorias']);
		$this->nombres->setDbValue($row['nombres']);
		$this->apellidos->setDbValue($row['apellidos']);
		$this->direccion->setDbValue($row['direccion']);
		$this->ciudad->setDbValue($row['ciudad']);
		$this->provincia->setDbValue($row['provincia']);
		$this->pais->setDbValue($row['pais']);
		$this->telefono->setDbValue($row['telefono']);
		$this->tipo_certificado->setDbValue($row['tipo_certificado']);
		$this->tipo_pago->setDbValue($row['tipo_pago']);
		$this->nombretarjeta->setDbValue($row['nombretarjeta']);
		$this->numerotarjeta->setDbValue($row['numerotarjeta']);
		$this->mes->setDbValue($row['mes']);
		$this->anio->setDbValue($row['anio']);
		$this->tipo_tarjeta->setDbValue($row['tipo_tarjeta']);
		$this->nombrepaypal->setDbValue($row['nombrepaypal']);
		$this->montopaypal->setDbValue($row['montopaypal']);
		$this->emailpaypal->setDbValue($row['emailpaypal']);
		$this->don->setDbValue($row['don']);
		$this->tipo_condicion->setDbValue($row['tipo_condicion']);
		$this->acciones->setDbValue($row['acciones']);
		$this->solicitud->setDbValue($row['solicitud']);
		$this->examen->setDbValue($row['examen']);
		$this->estado->setDbValue($row['estado']);
		$this->tipo->setDbValue($row['tipo']);
		$this->codigo_certificado->setDbValue($row['codigo_certificado']);
		$this->estado_entrega->setDbValue($row['estado_entrega']);
		$this->idioma->setDbValue($row['idioma']);
		$this->tipo_documento->setDbValue($row['tipo_documento']);
		$this->n_documento->setDbValue($row['n_documento']);
		$this->condicion1->setDbValue($row['condicion1']);
		$this->condicion2->setDbValue($row['condicion2']);
		$this->consulta->setDbValue($row['consulta']);
		$this->status->setDbValue($row['status']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idproyecto->setDbValue($row['idproyecto']);
		$this->id_producto->setDbValue($row['id_producto']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idinteresado'] = NULL;
		$row['id_usuarioencargado'] = NULL;
		$row['fecha'] = NULL;
		$row['email'] = NULL;
		$row['cursos'] = NULL;
		$row['categorias'] = NULL;
		$row['nombres'] = NULL;
		$row['apellidos'] = NULL;
		$row['direccion'] = NULL;
		$row['ciudad'] = NULL;
		$row['provincia'] = NULL;
		$row['pais'] = NULL;
		$row['telefono'] = NULL;
		$row['tipo_certificado'] = NULL;
		$row['tipo_pago'] = NULL;
		$row['nombretarjeta'] = NULL;
		$row['numerotarjeta'] = NULL;
		$row['mes'] = NULL;
		$row['anio'] = NULL;
		$row['tipo_tarjeta'] = NULL;
		$row['nombrepaypal'] = NULL;
		$row['montopaypal'] = NULL;
		$row['emailpaypal'] = NULL;
		$row['don'] = NULL;
		$row['tipo_condicion'] = NULL;
		$row['acciones'] = NULL;
		$row['solicitud'] = NULL;
		$row['examen'] = NULL;
		$row['estado'] = NULL;
		$row['tipo'] = NULL;
		$row['codigo_certificado'] = NULL;
		$row['estado_entrega'] = NULL;
		$row['idioma'] = NULL;
		$row['tipo_documento'] = NULL;
		$row['n_documento'] = NULL;
		$row['condicion1'] = NULL;
		$row['condicion2'] = NULL;
		$row['consulta'] = NULL;
		$row['status'] = NULL;
		$row['codlogin'] = NULL;
		$row['idproyecto'] = NULL;
		$row['id_producto'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idinteresado")) != "")
			$this->idinteresado->OldValue = $this->getKey("idinteresado"); // idinteresado
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->examen->FormValue == $this->examen->CurrentValue && is_numeric(ConvertToFloatString($this->examen->CurrentValue)))
			$this->examen->CurrentValue = ConvertToFloatString($this->examen->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idinteresado
		// id_usuarioencargado
		// fecha
		// email
		// cursos
		// categorias
		// nombres
		// apellidos
		// direccion
		// ciudad
		// provincia
		// pais
		// telefono
		// tipo_certificado
		// tipo_pago
		// nombretarjeta
		// numerotarjeta
		// mes
		// anio
		// tipo_tarjeta
		// nombrepaypal
		// montopaypal
		// emailpaypal
		// don
		// tipo_condicion
		// acciones
		// solicitud
		// examen
		// estado
		// tipo
		// codigo_certificado
		// estado_entrega
		// idioma
		// tipo_documento
		// n_documento
		// condicion1
		// condicion2
		// consulta
		// status
		// codlogin
		// idproyecto
		// id_producto

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idinteresado
			$this->idinteresado->ViewValue = $this->idinteresado->CurrentValue;
			$this->idinteresado->ViewCustomAttributes = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->ViewValue = $this->id_usuarioencargado->CurrentValue;
			$this->id_usuarioencargado->ViewValue = FormatNumber($this->id_usuarioencargado->ViewValue, 0, -2, -2, -2);
			$this->id_usuarioencargado->ViewCustomAttributes = "";

			// fecha
			$this->fecha->ViewValue = $this->fecha->CurrentValue;
			$this->fecha->ViewValue = FormatDateTime($this->fecha->ViewValue, 0);
			$this->fecha->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// cursos
			$this->cursos->ViewValue = $this->cursos->CurrentValue;
			$this->cursos->ViewValue = FormatNumber($this->cursos->ViewValue, 0, -2, -2, -2);
			$this->cursos->ViewCustomAttributes = "";

			// categorias
			$this->categorias->ViewValue = $this->categorias->CurrentValue;
			$this->categorias->ViewValue = FormatNumber($this->categorias->ViewValue, 0, -2, -2, -2);
			$this->categorias->ViewCustomAttributes = "";

			// nombres
			$this->nombres->ViewValue = $this->nombres->CurrentValue;
			$this->nombres->ViewCustomAttributes = "";

			// apellidos
			$this->apellidos->ViewValue = $this->apellidos->CurrentValue;
			$this->apellidos->ViewCustomAttributes = "";

			// direccion
			$this->direccion->ViewValue = $this->direccion->CurrentValue;
			$this->direccion->ViewCustomAttributes = "";

			// ciudad
			$this->ciudad->ViewValue = $this->ciudad->CurrentValue;
			$this->ciudad->ViewCustomAttributes = "";

			// provincia
			$this->provincia->ViewValue = $this->provincia->CurrentValue;
			$this->provincia->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// telefono
			$this->telefono->ViewValue = $this->telefono->CurrentValue;
			$this->telefono->ViewCustomAttributes = "";

			// tipo_certificado
			$this->tipo_certificado->ViewValue = $this->tipo_certificado->CurrentValue;
			$this->tipo_certificado->ViewValue = FormatNumber($this->tipo_certificado->ViewValue, 0, -2, -2, -2);
			$this->tipo_certificado->ViewCustomAttributes = "";

			// tipo_pago
			$this->tipo_pago->ViewValue = $this->tipo_pago->CurrentValue;
			$this->tipo_pago->ViewValue = FormatNumber($this->tipo_pago->ViewValue, 0, -2, -2, -2);
			$this->tipo_pago->ViewCustomAttributes = "";

			// nombretarjeta
			$this->nombretarjeta->ViewValue = $this->nombretarjeta->CurrentValue;
			$this->nombretarjeta->ViewCustomAttributes = "";

			// numerotarjeta
			$this->numerotarjeta->ViewValue = $this->numerotarjeta->CurrentValue;
			$this->numerotarjeta->ViewCustomAttributes = "";

			// mes
			$this->mes->ViewValue = $this->mes->CurrentValue;
			$this->mes->ViewCustomAttributes = "";

			// anio
			$this->anio->ViewValue = $this->anio->CurrentValue;
			$this->anio->ViewCustomAttributes = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->ViewValue = $this->tipo_tarjeta->CurrentValue;
			$this->tipo_tarjeta->ViewCustomAttributes = "";

			// nombrepaypal
			$this->nombrepaypal->ViewValue = $this->nombrepaypal->CurrentValue;
			$this->nombrepaypal->ViewCustomAttributes = "";

			// montopaypal
			$this->montopaypal->ViewValue = $this->montopaypal->CurrentValue;
			$this->montopaypal->ViewCustomAttributes = "";

			// emailpaypal
			$this->emailpaypal->ViewValue = $this->emailpaypal->CurrentValue;
			$this->emailpaypal->ViewCustomAttributes = "";

			// don
			$this->don->ViewValue = $this->don->CurrentValue;
			$this->don->ViewCustomAttributes = "";

			// tipo_condicion
			$this->tipo_condicion->ViewValue = $this->tipo_condicion->CurrentValue;
			$this->tipo_condicion->ViewValue = FormatNumber($this->tipo_condicion->ViewValue, 0, -2, -2, -2);
			$this->tipo_condicion->ViewCustomAttributes = "";

			// acciones
			$this->acciones->ViewValue = $this->acciones->CurrentValue;
			$this->acciones->ViewValue = FormatNumber($this->acciones->ViewValue, 0, -2, -2, -2);
			$this->acciones->ViewCustomAttributes = "";

			// solicitud
			$this->solicitud->ViewValue = $this->solicitud->CurrentValue;
			$this->solicitud->ViewValue = FormatNumber($this->solicitud->ViewValue, 0, -2, -2, -2);
			$this->solicitud->ViewCustomAttributes = "";

			// examen
			$this->examen->ViewValue = $this->examen->CurrentValue;
			$this->examen->ViewValue = FormatNumber($this->examen->ViewValue, 2, -2, -2, -2);
			$this->examen->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// tipo
			$this->tipo->ViewValue = $this->tipo->CurrentValue;
			$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
			$this->tipo->ViewCustomAttributes = "";

			// codigo_certificado
			$this->codigo_certificado->ViewValue = $this->codigo_certificado->CurrentValue;
			$this->codigo_certificado->ViewCustomAttributes = "";

			// estado_entrega
			$this->estado_entrega->ViewValue = $this->estado_entrega->CurrentValue;
			$this->estado_entrega->ViewValue = FormatNumber($this->estado_entrega->ViewValue, 0, -2, -2, -2);
			$this->estado_entrega->ViewCustomAttributes = "";

			// idioma
			$this->idioma->ViewValue = $this->idioma->CurrentValue;
			$this->idioma->ViewValue = FormatNumber($this->idioma->ViewValue, 0, -2, -2, -2);
			$this->idioma->ViewCustomAttributes = "";

			// tipo_documento
			$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
			$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
			$this->tipo_documento->ViewCustomAttributes = "";

			// n_documento
			$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
			$this->n_documento->ViewValue = FormatNumber($this->n_documento->ViewValue, 0, -2, -2, -2);
			$this->n_documento->ViewCustomAttributes = "";

			// condicion1
			$this->condicion1->ViewValue = $this->condicion1->CurrentValue;
			$this->condicion1->ViewValue = FormatNumber($this->condicion1->ViewValue, 0, -2, -2, -2);
			$this->condicion1->ViewCustomAttributes = "";

			// condicion2
			$this->condicion2->ViewValue = $this->condicion2->CurrentValue;
			$this->condicion2->ViewValue = FormatNumber($this->condicion2->ViewValue, 0, -2, -2, -2);
			$this->condicion2->ViewCustomAttributes = "";

			// consulta
			$this->consulta->ViewValue = $this->consulta->CurrentValue;
			$this->consulta->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idproyecto
			$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
			$this->idproyecto->ViewValue = FormatNumber($this->idproyecto->ViewValue, 0, -2, -2, -2);
			$this->idproyecto->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
			$this->id_producto->ViewCustomAttributes = "";

			// idinteresado
			$this->idinteresado->LinkCustomAttributes = "";
			$this->idinteresado->HrefValue = "";
			$this->idinteresado->TooltipValue = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->LinkCustomAttributes = "";
			$this->id_usuarioencargado->HrefValue = "";
			$this->id_usuarioencargado->TooltipValue = "";

			// fecha
			$this->fecha->LinkCustomAttributes = "";
			$this->fecha->HrefValue = "";
			$this->fecha->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// cursos
			$this->cursos->LinkCustomAttributes = "";
			$this->cursos->HrefValue = "";
			$this->cursos->TooltipValue = "";

			// categorias
			$this->categorias->LinkCustomAttributes = "";
			$this->categorias->HrefValue = "";
			$this->categorias->TooltipValue = "";

			// nombres
			$this->nombres->LinkCustomAttributes = "";
			$this->nombres->HrefValue = "";
			$this->nombres->TooltipValue = "";

			// apellidos
			$this->apellidos->LinkCustomAttributes = "";
			$this->apellidos->HrefValue = "";
			$this->apellidos->TooltipValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";
			$this->direccion->TooltipValue = "";

			// ciudad
			$this->ciudad->LinkCustomAttributes = "";
			$this->ciudad->HrefValue = "";
			$this->ciudad->TooltipValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";
			$this->provincia->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// telefono
			$this->telefono->LinkCustomAttributes = "";
			$this->telefono->HrefValue = "";
			$this->telefono->TooltipValue = "";

			// tipo_certificado
			$this->tipo_certificado->LinkCustomAttributes = "";
			$this->tipo_certificado->HrefValue = "";
			$this->tipo_certificado->TooltipValue = "";

			// tipo_pago
			$this->tipo_pago->LinkCustomAttributes = "";
			$this->tipo_pago->HrefValue = "";
			$this->tipo_pago->TooltipValue = "";

			// nombretarjeta
			$this->nombretarjeta->LinkCustomAttributes = "";
			$this->nombretarjeta->HrefValue = "";
			$this->nombretarjeta->TooltipValue = "";

			// numerotarjeta
			$this->numerotarjeta->LinkCustomAttributes = "";
			$this->numerotarjeta->HrefValue = "";
			$this->numerotarjeta->TooltipValue = "";

			// mes
			$this->mes->LinkCustomAttributes = "";
			$this->mes->HrefValue = "";
			$this->mes->TooltipValue = "";

			// anio
			$this->anio->LinkCustomAttributes = "";
			$this->anio->HrefValue = "";
			$this->anio->TooltipValue = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->LinkCustomAttributes = "";
			$this->tipo_tarjeta->HrefValue = "";
			$this->tipo_tarjeta->TooltipValue = "";

			// nombrepaypal
			$this->nombrepaypal->LinkCustomAttributes = "";
			$this->nombrepaypal->HrefValue = "";
			$this->nombrepaypal->TooltipValue = "";

			// montopaypal
			$this->montopaypal->LinkCustomAttributes = "";
			$this->montopaypal->HrefValue = "";
			$this->montopaypal->TooltipValue = "";

			// emailpaypal
			$this->emailpaypal->LinkCustomAttributes = "";
			$this->emailpaypal->HrefValue = "";
			$this->emailpaypal->TooltipValue = "";

			// don
			$this->don->LinkCustomAttributes = "";
			$this->don->HrefValue = "";
			$this->don->TooltipValue = "";

			// tipo_condicion
			$this->tipo_condicion->LinkCustomAttributes = "";
			$this->tipo_condicion->HrefValue = "";
			$this->tipo_condicion->TooltipValue = "";

			// acciones
			$this->acciones->LinkCustomAttributes = "";
			$this->acciones->HrefValue = "";
			$this->acciones->TooltipValue = "";

			// solicitud
			$this->solicitud->LinkCustomAttributes = "";
			$this->solicitud->HrefValue = "";
			$this->solicitud->TooltipValue = "";

			// examen
			$this->examen->LinkCustomAttributes = "";
			$this->examen->HrefValue = "";
			$this->examen->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";
			$this->tipo->TooltipValue = "";

			// codigo_certificado
			$this->codigo_certificado->LinkCustomAttributes = "";
			$this->codigo_certificado->HrefValue = "";
			$this->codigo_certificado->TooltipValue = "";

			// estado_entrega
			$this->estado_entrega->LinkCustomAttributes = "";
			$this->estado_entrega->HrefValue = "";
			$this->estado_entrega->TooltipValue = "";

			// idioma
			$this->idioma->LinkCustomAttributes = "";
			$this->idioma->HrefValue = "";
			$this->idioma->TooltipValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";
			$this->tipo_documento->TooltipValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";
			$this->n_documento->TooltipValue = "";

			// condicion1
			$this->condicion1->LinkCustomAttributes = "";
			$this->condicion1->HrefValue = "";
			$this->condicion1->TooltipValue = "";

			// condicion2
			$this->condicion2->LinkCustomAttributes = "";
			$this->condicion2->HrefValue = "";
			$this->condicion2->TooltipValue = "";

			// consulta
			$this->consulta->LinkCustomAttributes = "";
			$this->consulta->HrefValue = "";
			$this->consulta->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idproyecto
			$this->idproyecto->LinkCustomAttributes = "";
			$this->idproyecto->HrefValue = "";
			$this->idproyecto->TooltipValue = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"finteresadoslistsrch\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>