<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for kp_clientes
 */
class kp_clientes extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_reg;
	public $estado;
	public $idempresa;
	public $codcliente;
	public $codclienteemp;
	public $tipocliente;
	public $numruc;
	public $numdni;
	public $nomcliente;
	public $nomclientecorp;
	public $dircliente;
	public $dirclientefis;
	public $refcliente;
	public $coddpto;
	public $codprov;
	public $coddist;
	public $codubigeo;
	public $numtelefono;
	public $numtelefono2;
	public $emailcliente;
	public $nomclienteaut;
	public $numtelefonoaut;
	public $numdniaut;
	public $fecha_reg;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'kp_clientes';
		$this->TableName = 'kp_clientes';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`kp_clientes`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_reg
		$this->id_reg = new DbField('kp_clientes', 'kp_clientes', 'x_id_reg', 'id_reg', '`id_reg`', '`id_reg`', 3, 11, -1, FALSE, '`id_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_reg->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_reg->IsPrimaryKey = TRUE; // Primary key field
		$this->id_reg->Sortable = TRUE; // Allow sort
		$this->id_reg->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_reg'] = &$this->id_reg;

		// estado
		$this->estado = new DbField('kp_clientes', 'kp_clientes', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Nullable = FALSE; // NOT NULL field
		$this->estado->Required = TRUE; // Required field
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// idempresa
		$this->idempresa = new DbField('kp_clientes', 'kp_clientes', 'x_idempresa', 'idempresa', '`idempresa`', '`idempresa`', 3, 11, -1, FALSE, '`idempresa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idempresa->Nullable = FALSE; // NOT NULL field
		$this->idempresa->Required = TRUE; // Required field
		$this->idempresa->Sortable = TRUE; // Allow sort
		$this->idempresa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idempresa'] = &$this->idempresa;

		// codcliente
		$this->codcliente = new DbField('kp_clientes', 'kp_clientes', 'x_codcliente', 'codcliente', '`codcliente`', '`codcliente`', 3, 11, -1, FALSE, '`codcliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codcliente->Sortable = TRUE; // Allow sort
		$this->codcliente->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['codcliente'] = &$this->codcliente;

		// codclienteemp
		$this->codclienteemp = new DbField('kp_clientes', 'kp_clientes', 'x_codclienteemp', 'codclienteemp', '`codclienteemp`', '`codclienteemp`', 200, 20, -1, FALSE, '`codclienteemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codclienteemp->Sortable = TRUE; // Allow sort
		$this->fields['codclienteemp'] = &$this->codclienteemp;

		// tipocliente
		$this->tipocliente = new DbField('kp_clientes', 'kp_clientes', 'x_tipocliente', 'tipocliente', '`tipocliente`', '`tipocliente`', 200, 2, -1, FALSE, '`tipocliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipocliente->Nullable = FALSE; // NOT NULL field
		$this->tipocliente->Required = TRUE; // Required field
		$this->tipocliente->Sortable = TRUE; // Allow sort
		$this->fields['tipocliente'] = &$this->tipocliente;

		// numruc
		$this->numruc = new DbField('kp_clientes', 'kp_clientes', 'x_numruc', 'numruc', '`numruc`', '`numruc`', 200, 11, -1, FALSE, '`numruc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numruc->Sortable = TRUE; // Allow sort
		$this->fields['numruc'] = &$this->numruc;

		// numdni
		$this->numdni = new DbField('kp_clientes', 'kp_clientes', 'x_numdni', 'numdni', '`numdni`', '`numdni`', 200, 11, -1, FALSE, '`numdni`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numdni->Sortable = TRUE; // Allow sort
		$this->fields['numdni'] = &$this->numdni;

		// nomcliente
		$this->nomcliente = new DbField('kp_clientes', 'kp_clientes', 'x_nomcliente', 'nomcliente', '`nomcliente`', '`nomcliente`', 200, 80, -1, FALSE, '`nomcliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomcliente->Sortable = TRUE; // Allow sort
		$this->fields['nomcliente'] = &$this->nomcliente;

		// nomclientecorp
		$this->nomclientecorp = new DbField('kp_clientes', 'kp_clientes', 'x_nomclientecorp', 'nomclientecorp', '`nomclientecorp`', '`nomclientecorp`', 200, 80, -1, FALSE, '`nomclientecorp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomclientecorp->Sortable = TRUE; // Allow sort
		$this->fields['nomclientecorp'] = &$this->nomclientecorp;

		// dircliente
		$this->dircliente = new DbField('kp_clientes', 'kp_clientes', 'x_dircliente', 'dircliente', '`dircliente`', '`dircliente`', 200, 100, -1, FALSE, '`dircliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dircliente->Sortable = TRUE; // Allow sort
		$this->fields['dircliente'] = &$this->dircliente;

		// dirclientefis
		$this->dirclientefis = new DbField('kp_clientes', 'kp_clientes', 'x_dirclientefis', 'dirclientefis', '`dirclientefis`', '`dirclientefis`', 200, 100, -1, FALSE, '`dirclientefis`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dirclientefis->Sortable = TRUE; // Allow sort
		$this->fields['dirclientefis'] = &$this->dirclientefis;

		// refcliente
		$this->refcliente = new DbField('kp_clientes', 'kp_clientes', 'x_refcliente', 'refcliente', '`refcliente`', '`refcliente`', 200, 100, -1, FALSE, '`refcliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->refcliente->Sortable = TRUE; // Allow sort
		$this->fields['refcliente'] = &$this->refcliente;

		// coddpto
		$this->coddpto = new DbField('kp_clientes', 'kp_clientes', 'x_coddpto', 'coddpto', '`coddpto`', '`coddpto`', 200, 5, -1, FALSE, '`coddpto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->coddpto->Sortable = TRUE; // Allow sort
		$this->fields['coddpto'] = &$this->coddpto;

		// codprov
		$this->codprov = new DbField('kp_clientes', 'kp_clientes', 'x_codprov', 'codprov', '`codprov`', '`codprov`', 200, 5, -1, FALSE, '`codprov`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codprov->Sortable = TRUE; // Allow sort
		$this->fields['codprov'] = &$this->codprov;

		// coddist
		$this->coddist = new DbField('kp_clientes', 'kp_clientes', 'x_coddist', 'coddist', '`coddist`', '`coddist`', 200, 5, -1, FALSE, '`coddist`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->coddist->Sortable = TRUE; // Allow sort
		$this->fields['coddist'] = &$this->coddist;

		// codubigeo
		$this->codubigeo = new DbField('kp_clientes', 'kp_clientes', 'x_codubigeo', 'codubigeo', '`codubigeo`', '`codubigeo`', 200, 10, -1, FALSE, '`codubigeo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codubigeo->Sortable = TRUE; // Allow sort
		$this->fields['codubigeo'] = &$this->codubigeo;

		// numtelefono
		$this->numtelefono = new DbField('kp_clientes', 'kp_clientes', 'x_numtelefono', 'numtelefono', '`numtelefono`', '`numtelefono`', 200, 20, -1, FALSE, '`numtelefono`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numtelefono->Sortable = TRUE; // Allow sort
		$this->fields['numtelefono'] = &$this->numtelefono;

		// numtelefono2
		$this->numtelefono2 = new DbField('kp_clientes', 'kp_clientes', 'x_numtelefono2', 'numtelefono2', '`numtelefono2`', '`numtelefono2`', 200, 20, -1, FALSE, '`numtelefono2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numtelefono2->Sortable = TRUE; // Allow sort
		$this->fields['numtelefono2'] = &$this->numtelefono2;

		// emailcliente
		$this->emailcliente = new DbField('kp_clientes', 'kp_clientes', 'x_emailcliente', 'emailcliente', '`emailcliente`', '`emailcliente`', 200, 80, -1, FALSE, '`emailcliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emailcliente->Sortable = TRUE; // Allow sort
		$this->fields['emailcliente'] = &$this->emailcliente;

		// nomclienteaut
		$this->nomclienteaut = new DbField('kp_clientes', 'kp_clientes', 'x_nomclienteaut', 'nomclienteaut', '`nomclienteaut`', '`nomclienteaut`', 200, 80, -1, FALSE, '`nomclienteaut`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomclienteaut->Sortable = TRUE; // Allow sort
		$this->fields['nomclienteaut'] = &$this->nomclienteaut;

		// numtelefonoaut
		$this->numtelefonoaut = new DbField('kp_clientes', 'kp_clientes', 'x_numtelefonoaut', 'numtelefonoaut', '`numtelefonoaut`', '`numtelefonoaut`', 200, 20, -1, FALSE, '`numtelefonoaut`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numtelefonoaut->Sortable = TRUE; // Allow sort
		$this->fields['numtelefonoaut'] = &$this->numtelefonoaut;

		// numdniaut
		$this->numdniaut = new DbField('kp_clientes', 'kp_clientes', 'x_numdniaut', 'numdniaut', '`numdniaut`', '`numdniaut`', 200, 11, -1, FALSE, '`numdniaut`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->numdniaut->Sortable = TRUE; // Allow sort
		$this->fields['numdniaut'] = &$this->numdniaut;

		// fecha_reg
		$this->fecha_reg = new DbField('kp_clientes', 'kp_clientes', 'x_fecha_reg', 'fecha_reg', '`fecha_reg`', CastDateFieldForLike("`fecha_reg`", 0, "DB"), 135, 19, 0, FALSE, '`fecha_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fecha_reg->Sortable = TRUE; // Allow sort
		$this->fecha_reg->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fecha_reg'] = &$this->fecha_reg;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`kp_clientes`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_reg->setDbValue($conn->insert_ID());
			$rs['id_reg'] = $this->id_reg->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_reg', $rs))
				AddFilter($where, QuotedName('id_reg', $this->Dbid) . '=' . QuotedValue($rs['id_reg'], $this->id_reg->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_reg->DbValue = $row['id_reg'];
		$this->estado->DbValue = $row['estado'];
		$this->idempresa->DbValue = $row['idempresa'];
		$this->codcliente->DbValue = $row['codcliente'];
		$this->codclienteemp->DbValue = $row['codclienteemp'];
		$this->tipocliente->DbValue = $row['tipocliente'];
		$this->numruc->DbValue = $row['numruc'];
		$this->numdni->DbValue = $row['numdni'];
		$this->nomcliente->DbValue = $row['nomcliente'];
		$this->nomclientecorp->DbValue = $row['nomclientecorp'];
		$this->dircliente->DbValue = $row['dircliente'];
		$this->dirclientefis->DbValue = $row['dirclientefis'];
		$this->refcliente->DbValue = $row['refcliente'];
		$this->coddpto->DbValue = $row['coddpto'];
		$this->codprov->DbValue = $row['codprov'];
		$this->coddist->DbValue = $row['coddist'];
		$this->codubigeo->DbValue = $row['codubigeo'];
		$this->numtelefono->DbValue = $row['numtelefono'];
		$this->numtelefono2->DbValue = $row['numtelefono2'];
		$this->emailcliente->DbValue = $row['emailcliente'];
		$this->nomclienteaut->DbValue = $row['nomclienteaut'];
		$this->numtelefonoaut->DbValue = $row['numtelefonoaut'];
		$this->numdniaut->DbValue = $row['numdniaut'];
		$this->fecha_reg->DbValue = $row['fecha_reg'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_reg` = @id_reg@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_reg', $row) ? $row['id_reg'] : NULL;
		else
			$val = $this->id_reg->OldValue !== NULL ? $this->id_reg->OldValue : $this->id_reg->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_reg@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "kp_clienteslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "kp_clientesview.php")
			return $Language->phrase("View");
		elseif ($pageName == "kp_clientesedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "kp_clientesadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "kp_clienteslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("kp_clientesview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("kp_clientesview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "kp_clientesadd.php?" . $this->getUrlParm($parm);
		else
			$url = "kp_clientesadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("kp_clientesedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("kp_clientesadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("kp_clientesdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_reg:" . JsonEncode($this->id_reg->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_reg->CurrentValue != NULL) {
			$url .= "id_reg=" . urlencode($this->id_reg->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_reg") !== NULL)
				$arKeys[] = Param("id_reg");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_reg->CurrentValue = $key;
			else
				$this->id_reg->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_reg->setDbValue($rs->fields('id_reg'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->idempresa->setDbValue($rs->fields('idempresa'));
		$this->codcliente->setDbValue($rs->fields('codcliente'));
		$this->codclienteemp->setDbValue($rs->fields('codclienteemp'));
		$this->tipocliente->setDbValue($rs->fields('tipocliente'));
		$this->numruc->setDbValue($rs->fields('numruc'));
		$this->numdni->setDbValue($rs->fields('numdni'));
		$this->nomcliente->setDbValue($rs->fields('nomcliente'));
		$this->nomclientecorp->setDbValue($rs->fields('nomclientecorp'));
		$this->dircliente->setDbValue($rs->fields('dircliente'));
		$this->dirclientefis->setDbValue($rs->fields('dirclientefis'));
		$this->refcliente->setDbValue($rs->fields('refcliente'));
		$this->coddpto->setDbValue($rs->fields('coddpto'));
		$this->codprov->setDbValue($rs->fields('codprov'));
		$this->coddist->setDbValue($rs->fields('coddist'));
		$this->codubigeo->setDbValue($rs->fields('codubigeo'));
		$this->numtelefono->setDbValue($rs->fields('numtelefono'));
		$this->numtelefono2->setDbValue($rs->fields('numtelefono2'));
		$this->emailcliente->setDbValue($rs->fields('emailcliente'));
		$this->nomclienteaut->setDbValue($rs->fields('nomclienteaut'));
		$this->numtelefonoaut->setDbValue($rs->fields('numtelefonoaut'));
		$this->numdniaut->setDbValue($rs->fields('numdniaut'));
		$this->fecha_reg->setDbValue($rs->fields('fecha_reg'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_reg
		// estado
		// idempresa
		// codcliente
		// codclienteemp
		// tipocliente
		// numruc
		// numdni
		// nomcliente
		// nomclientecorp
		// dircliente
		// dirclientefis
		// refcliente
		// coddpto
		// codprov
		// coddist
		// codubigeo
		// numtelefono
		// numtelefono2
		// emailcliente
		// nomclienteaut
		// numtelefonoaut
		// numdniaut
		// fecha_reg
		// id_reg

		$this->id_reg->ViewValue = $this->id_reg->CurrentValue;
		$this->id_reg->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
		$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
		$this->idempresa->ViewCustomAttributes = "";

		// codcliente
		$this->codcliente->ViewValue = $this->codcliente->CurrentValue;
		$this->codcliente->ViewValue = FormatNumber($this->codcliente->ViewValue, 0, -2, -2, -2);
		$this->codcliente->ViewCustomAttributes = "";

		// codclienteemp
		$this->codclienteemp->ViewValue = $this->codclienteemp->CurrentValue;
		$this->codclienteemp->ViewCustomAttributes = "";

		// tipocliente
		$this->tipocliente->ViewValue = $this->tipocliente->CurrentValue;
		$this->tipocliente->ViewCustomAttributes = "";

		// numruc
		$this->numruc->ViewValue = $this->numruc->CurrentValue;
		$this->numruc->ViewCustomAttributes = "";

		// numdni
		$this->numdni->ViewValue = $this->numdni->CurrentValue;
		$this->numdni->ViewCustomAttributes = "";

		// nomcliente
		$this->nomcliente->ViewValue = $this->nomcliente->CurrentValue;
		$this->nomcliente->ViewCustomAttributes = "";

		// nomclientecorp
		$this->nomclientecorp->ViewValue = $this->nomclientecorp->CurrentValue;
		$this->nomclientecorp->ViewCustomAttributes = "";

		// dircliente
		$this->dircliente->ViewValue = $this->dircliente->CurrentValue;
		$this->dircliente->ViewCustomAttributes = "";

		// dirclientefis
		$this->dirclientefis->ViewValue = $this->dirclientefis->CurrentValue;
		$this->dirclientefis->ViewCustomAttributes = "";

		// refcliente
		$this->refcliente->ViewValue = $this->refcliente->CurrentValue;
		$this->refcliente->ViewCustomAttributes = "";

		// coddpto
		$this->coddpto->ViewValue = $this->coddpto->CurrentValue;
		$this->coddpto->ViewCustomAttributes = "";

		// codprov
		$this->codprov->ViewValue = $this->codprov->CurrentValue;
		$this->codprov->ViewCustomAttributes = "";

		// coddist
		$this->coddist->ViewValue = $this->coddist->CurrentValue;
		$this->coddist->ViewCustomAttributes = "";

		// codubigeo
		$this->codubigeo->ViewValue = $this->codubigeo->CurrentValue;
		$this->codubigeo->ViewCustomAttributes = "";

		// numtelefono
		$this->numtelefono->ViewValue = $this->numtelefono->CurrentValue;
		$this->numtelefono->ViewCustomAttributes = "";

		// numtelefono2
		$this->numtelefono2->ViewValue = $this->numtelefono2->CurrentValue;
		$this->numtelefono2->ViewCustomAttributes = "";

		// emailcliente
		$this->emailcliente->ViewValue = $this->emailcliente->CurrentValue;
		$this->emailcliente->ViewCustomAttributes = "";

		// nomclienteaut
		$this->nomclienteaut->ViewValue = $this->nomclienteaut->CurrentValue;
		$this->nomclienteaut->ViewCustomAttributes = "";

		// numtelefonoaut
		$this->numtelefonoaut->ViewValue = $this->numtelefonoaut->CurrentValue;
		$this->numtelefonoaut->ViewCustomAttributes = "";

		// numdniaut
		$this->numdniaut->ViewValue = $this->numdniaut->CurrentValue;
		$this->numdniaut->ViewCustomAttributes = "";

		// fecha_reg
		$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
		$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
		$this->fecha_reg->ViewCustomAttributes = "";

		// id_reg
		$this->id_reg->LinkCustomAttributes = "";
		$this->id_reg->HrefValue = "";
		$this->id_reg->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// idempresa
		$this->idempresa->LinkCustomAttributes = "";
		$this->idempresa->HrefValue = "";
		$this->idempresa->TooltipValue = "";

		// codcliente
		$this->codcliente->LinkCustomAttributes = "";
		$this->codcliente->HrefValue = "";
		$this->codcliente->TooltipValue = "";

		// codclienteemp
		$this->codclienteemp->LinkCustomAttributes = "";
		$this->codclienteemp->HrefValue = "";
		$this->codclienteemp->TooltipValue = "";

		// tipocliente
		$this->tipocliente->LinkCustomAttributes = "";
		$this->tipocliente->HrefValue = "";
		$this->tipocliente->TooltipValue = "";

		// numruc
		$this->numruc->LinkCustomAttributes = "";
		$this->numruc->HrefValue = "";
		$this->numruc->TooltipValue = "";

		// numdni
		$this->numdni->LinkCustomAttributes = "";
		$this->numdni->HrefValue = "";
		$this->numdni->TooltipValue = "";

		// nomcliente
		$this->nomcliente->LinkCustomAttributes = "";
		$this->nomcliente->HrefValue = "";
		$this->nomcliente->TooltipValue = "";

		// nomclientecorp
		$this->nomclientecorp->LinkCustomAttributes = "";
		$this->nomclientecorp->HrefValue = "";
		$this->nomclientecorp->TooltipValue = "";

		// dircliente
		$this->dircliente->LinkCustomAttributes = "";
		$this->dircliente->HrefValue = "";
		$this->dircliente->TooltipValue = "";

		// dirclientefis
		$this->dirclientefis->LinkCustomAttributes = "";
		$this->dirclientefis->HrefValue = "";
		$this->dirclientefis->TooltipValue = "";

		// refcliente
		$this->refcliente->LinkCustomAttributes = "";
		$this->refcliente->HrefValue = "";
		$this->refcliente->TooltipValue = "";

		// coddpto
		$this->coddpto->LinkCustomAttributes = "";
		$this->coddpto->HrefValue = "";
		$this->coddpto->TooltipValue = "";

		// codprov
		$this->codprov->LinkCustomAttributes = "";
		$this->codprov->HrefValue = "";
		$this->codprov->TooltipValue = "";

		// coddist
		$this->coddist->LinkCustomAttributes = "";
		$this->coddist->HrefValue = "";
		$this->coddist->TooltipValue = "";

		// codubigeo
		$this->codubigeo->LinkCustomAttributes = "";
		$this->codubigeo->HrefValue = "";
		$this->codubigeo->TooltipValue = "";

		// numtelefono
		$this->numtelefono->LinkCustomAttributes = "";
		$this->numtelefono->HrefValue = "";
		$this->numtelefono->TooltipValue = "";

		// numtelefono2
		$this->numtelefono2->LinkCustomAttributes = "";
		$this->numtelefono2->HrefValue = "";
		$this->numtelefono2->TooltipValue = "";

		// emailcliente
		$this->emailcliente->LinkCustomAttributes = "";
		$this->emailcliente->HrefValue = "";
		$this->emailcliente->TooltipValue = "";

		// nomclienteaut
		$this->nomclienteaut->LinkCustomAttributes = "";
		$this->nomclienteaut->HrefValue = "";
		$this->nomclienteaut->TooltipValue = "";

		// numtelefonoaut
		$this->numtelefonoaut->LinkCustomAttributes = "";
		$this->numtelefonoaut->HrefValue = "";
		$this->numtelefonoaut->TooltipValue = "";

		// numdniaut
		$this->numdniaut->LinkCustomAttributes = "";
		$this->numdniaut->HrefValue = "";
		$this->numdniaut->TooltipValue = "";

		// fecha_reg
		$this->fecha_reg->LinkCustomAttributes = "";
		$this->fecha_reg->HrefValue = "";
		$this->fecha_reg->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_reg
		$this->id_reg->EditAttrs["class"] = "form-control";
		$this->id_reg->EditCustomAttributes = "";
		$this->id_reg->EditValue = $this->id_reg->CurrentValue;
		$this->id_reg->ViewCustomAttributes = "";

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// idempresa
		$this->idempresa->EditAttrs["class"] = "form-control";
		$this->idempresa->EditCustomAttributes = "";
		$this->idempresa->EditValue = $this->idempresa->CurrentValue;
		$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

		// codcliente
		$this->codcliente->EditAttrs["class"] = "form-control";
		$this->codcliente->EditCustomAttributes = "";
		$this->codcliente->EditValue = $this->codcliente->CurrentValue;
		$this->codcliente->PlaceHolder = RemoveHtml($this->codcliente->caption());

		// codclienteemp
		$this->codclienteemp->EditAttrs["class"] = "form-control";
		$this->codclienteemp->EditCustomAttributes = "";
		if (!$this->codclienteemp->Raw)
			$this->codclienteemp->CurrentValue = HtmlDecode($this->codclienteemp->CurrentValue);
		$this->codclienteemp->EditValue = $this->codclienteemp->CurrentValue;
		$this->codclienteemp->PlaceHolder = RemoveHtml($this->codclienteemp->caption());

		// tipocliente
		$this->tipocliente->EditAttrs["class"] = "form-control";
		$this->tipocliente->EditCustomAttributes = "";
		if (!$this->tipocliente->Raw)
			$this->tipocliente->CurrentValue = HtmlDecode($this->tipocliente->CurrentValue);
		$this->tipocliente->EditValue = $this->tipocliente->CurrentValue;
		$this->tipocliente->PlaceHolder = RemoveHtml($this->tipocliente->caption());

		// numruc
		$this->numruc->EditAttrs["class"] = "form-control";
		$this->numruc->EditCustomAttributes = "";
		if (!$this->numruc->Raw)
			$this->numruc->CurrentValue = HtmlDecode($this->numruc->CurrentValue);
		$this->numruc->EditValue = $this->numruc->CurrentValue;
		$this->numruc->PlaceHolder = RemoveHtml($this->numruc->caption());

		// numdni
		$this->numdni->EditAttrs["class"] = "form-control";
		$this->numdni->EditCustomAttributes = "";
		if (!$this->numdni->Raw)
			$this->numdni->CurrentValue = HtmlDecode($this->numdni->CurrentValue);
		$this->numdni->EditValue = $this->numdni->CurrentValue;
		$this->numdni->PlaceHolder = RemoveHtml($this->numdni->caption());

		// nomcliente
		$this->nomcliente->EditAttrs["class"] = "form-control";
		$this->nomcliente->EditCustomAttributes = "";
		if (!$this->nomcliente->Raw)
			$this->nomcliente->CurrentValue = HtmlDecode($this->nomcliente->CurrentValue);
		$this->nomcliente->EditValue = $this->nomcliente->CurrentValue;
		$this->nomcliente->PlaceHolder = RemoveHtml($this->nomcliente->caption());

		// nomclientecorp
		$this->nomclientecorp->EditAttrs["class"] = "form-control";
		$this->nomclientecorp->EditCustomAttributes = "";
		if (!$this->nomclientecorp->Raw)
			$this->nomclientecorp->CurrentValue = HtmlDecode($this->nomclientecorp->CurrentValue);
		$this->nomclientecorp->EditValue = $this->nomclientecorp->CurrentValue;
		$this->nomclientecorp->PlaceHolder = RemoveHtml($this->nomclientecorp->caption());

		// dircliente
		$this->dircliente->EditAttrs["class"] = "form-control";
		$this->dircliente->EditCustomAttributes = "";
		if (!$this->dircliente->Raw)
			$this->dircliente->CurrentValue = HtmlDecode($this->dircliente->CurrentValue);
		$this->dircliente->EditValue = $this->dircliente->CurrentValue;
		$this->dircliente->PlaceHolder = RemoveHtml($this->dircliente->caption());

		// dirclientefis
		$this->dirclientefis->EditAttrs["class"] = "form-control";
		$this->dirclientefis->EditCustomAttributes = "";
		if (!$this->dirclientefis->Raw)
			$this->dirclientefis->CurrentValue = HtmlDecode($this->dirclientefis->CurrentValue);
		$this->dirclientefis->EditValue = $this->dirclientefis->CurrentValue;
		$this->dirclientefis->PlaceHolder = RemoveHtml($this->dirclientefis->caption());

		// refcliente
		$this->refcliente->EditAttrs["class"] = "form-control";
		$this->refcliente->EditCustomAttributes = "";
		if (!$this->refcliente->Raw)
			$this->refcliente->CurrentValue = HtmlDecode($this->refcliente->CurrentValue);
		$this->refcliente->EditValue = $this->refcliente->CurrentValue;
		$this->refcliente->PlaceHolder = RemoveHtml($this->refcliente->caption());

		// coddpto
		$this->coddpto->EditAttrs["class"] = "form-control";
		$this->coddpto->EditCustomAttributes = "";
		if (!$this->coddpto->Raw)
			$this->coddpto->CurrentValue = HtmlDecode($this->coddpto->CurrentValue);
		$this->coddpto->EditValue = $this->coddpto->CurrentValue;
		$this->coddpto->PlaceHolder = RemoveHtml($this->coddpto->caption());

		// codprov
		$this->codprov->EditAttrs["class"] = "form-control";
		$this->codprov->EditCustomAttributes = "";
		if (!$this->codprov->Raw)
			$this->codprov->CurrentValue = HtmlDecode($this->codprov->CurrentValue);
		$this->codprov->EditValue = $this->codprov->CurrentValue;
		$this->codprov->PlaceHolder = RemoveHtml($this->codprov->caption());

		// coddist
		$this->coddist->EditAttrs["class"] = "form-control";
		$this->coddist->EditCustomAttributes = "";
		if (!$this->coddist->Raw)
			$this->coddist->CurrentValue = HtmlDecode($this->coddist->CurrentValue);
		$this->coddist->EditValue = $this->coddist->CurrentValue;
		$this->coddist->PlaceHolder = RemoveHtml($this->coddist->caption());

		// codubigeo
		$this->codubigeo->EditAttrs["class"] = "form-control";
		$this->codubigeo->EditCustomAttributes = "";
		if (!$this->codubigeo->Raw)
			$this->codubigeo->CurrentValue = HtmlDecode($this->codubigeo->CurrentValue);
		$this->codubigeo->EditValue = $this->codubigeo->CurrentValue;
		$this->codubigeo->PlaceHolder = RemoveHtml($this->codubigeo->caption());

		// numtelefono
		$this->numtelefono->EditAttrs["class"] = "form-control";
		$this->numtelefono->EditCustomAttributes = "";
		if (!$this->numtelefono->Raw)
			$this->numtelefono->CurrentValue = HtmlDecode($this->numtelefono->CurrentValue);
		$this->numtelefono->EditValue = $this->numtelefono->CurrentValue;
		$this->numtelefono->PlaceHolder = RemoveHtml($this->numtelefono->caption());

		// numtelefono2
		$this->numtelefono2->EditAttrs["class"] = "form-control";
		$this->numtelefono2->EditCustomAttributes = "";
		if (!$this->numtelefono2->Raw)
			$this->numtelefono2->CurrentValue = HtmlDecode($this->numtelefono2->CurrentValue);
		$this->numtelefono2->EditValue = $this->numtelefono2->CurrentValue;
		$this->numtelefono2->PlaceHolder = RemoveHtml($this->numtelefono2->caption());

		// emailcliente
		$this->emailcliente->EditAttrs["class"] = "form-control";
		$this->emailcliente->EditCustomAttributes = "";
		if (!$this->emailcliente->Raw)
			$this->emailcliente->CurrentValue = HtmlDecode($this->emailcliente->CurrentValue);
		$this->emailcliente->EditValue = $this->emailcliente->CurrentValue;
		$this->emailcliente->PlaceHolder = RemoveHtml($this->emailcliente->caption());

		// nomclienteaut
		$this->nomclienteaut->EditAttrs["class"] = "form-control";
		$this->nomclienteaut->EditCustomAttributes = "";
		if (!$this->nomclienteaut->Raw)
			$this->nomclienteaut->CurrentValue = HtmlDecode($this->nomclienteaut->CurrentValue);
		$this->nomclienteaut->EditValue = $this->nomclienteaut->CurrentValue;
		$this->nomclienteaut->PlaceHolder = RemoveHtml($this->nomclienteaut->caption());

		// numtelefonoaut
		$this->numtelefonoaut->EditAttrs["class"] = "form-control";
		$this->numtelefonoaut->EditCustomAttributes = "";
		if (!$this->numtelefonoaut->Raw)
			$this->numtelefonoaut->CurrentValue = HtmlDecode($this->numtelefonoaut->CurrentValue);
		$this->numtelefonoaut->EditValue = $this->numtelefonoaut->CurrentValue;
		$this->numtelefonoaut->PlaceHolder = RemoveHtml($this->numtelefonoaut->caption());

		// numdniaut
		$this->numdniaut->EditAttrs["class"] = "form-control";
		$this->numdniaut->EditCustomAttributes = "";
		if (!$this->numdniaut->Raw)
			$this->numdniaut->CurrentValue = HtmlDecode($this->numdniaut->CurrentValue);
		$this->numdniaut->EditValue = $this->numdniaut->CurrentValue;
		$this->numdniaut->PlaceHolder = RemoveHtml($this->numdniaut->caption());

		// fecha_reg
		$this->fecha_reg->EditAttrs["class"] = "form-control";
		$this->fecha_reg->EditCustomAttributes = "";
		$this->fecha_reg->EditValue = FormatDateTime($this->fecha_reg->CurrentValue, 8);
		$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_reg);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->codcliente);
					$doc->exportCaption($this->codclienteemp);
					$doc->exportCaption($this->tipocliente);
					$doc->exportCaption($this->numruc);
					$doc->exportCaption($this->numdni);
					$doc->exportCaption($this->nomcliente);
					$doc->exportCaption($this->nomclientecorp);
					$doc->exportCaption($this->dircliente);
					$doc->exportCaption($this->dirclientefis);
					$doc->exportCaption($this->refcliente);
					$doc->exportCaption($this->coddpto);
					$doc->exportCaption($this->codprov);
					$doc->exportCaption($this->coddist);
					$doc->exportCaption($this->codubigeo);
					$doc->exportCaption($this->numtelefono);
					$doc->exportCaption($this->numtelefono2);
					$doc->exportCaption($this->emailcliente);
					$doc->exportCaption($this->nomclienteaut);
					$doc->exportCaption($this->numtelefonoaut);
					$doc->exportCaption($this->numdniaut);
					$doc->exportCaption($this->fecha_reg);
				} else {
					$doc->exportCaption($this->id_reg);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->codcliente);
					$doc->exportCaption($this->codclienteemp);
					$doc->exportCaption($this->tipocliente);
					$doc->exportCaption($this->numruc);
					$doc->exportCaption($this->numdni);
					$doc->exportCaption($this->nomcliente);
					$doc->exportCaption($this->nomclientecorp);
					$doc->exportCaption($this->dircliente);
					$doc->exportCaption($this->dirclientefis);
					$doc->exportCaption($this->refcliente);
					$doc->exportCaption($this->coddpto);
					$doc->exportCaption($this->codprov);
					$doc->exportCaption($this->coddist);
					$doc->exportCaption($this->codubigeo);
					$doc->exportCaption($this->numtelefono);
					$doc->exportCaption($this->numtelefono2);
					$doc->exportCaption($this->emailcliente);
					$doc->exportCaption($this->nomclienteaut);
					$doc->exportCaption($this->numtelefonoaut);
					$doc->exportCaption($this->numdniaut);
					$doc->exportCaption($this->fecha_reg);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_reg);
						$doc->exportField($this->estado);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->codcliente);
						$doc->exportField($this->codclienteemp);
						$doc->exportField($this->tipocliente);
						$doc->exportField($this->numruc);
						$doc->exportField($this->numdni);
						$doc->exportField($this->nomcliente);
						$doc->exportField($this->nomclientecorp);
						$doc->exportField($this->dircliente);
						$doc->exportField($this->dirclientefis);
						$doc->exportField($this->refcliente);
						$doc->exportField($this->coddpto);
						$doc->exportField($this->codprov);
						$doc->exportField($this->coddist);
						$doc->exportField($this->codubigeo);
						$doc->exportField($this->numtelefono);
						$doc->exportField($this->numtelefono2);
						$doc->exportField($this->emailcliente);
						$doc->exportField($this->nomclienteaut);
						$doc->exportField($this->numtelefonoaut);
						$doc->exportField($this->numdniaut);
						$doc->exportField($this->fecha_reg);
					} else {
						$doc->exportField($this->id_reg);
						$doc->exportField($this->estado);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->codcliente);
						$doc->exportField($this->codclienteemp);
						$doc->exportField($this->tipocliente);
						$doc->exportField($this->numruc);
						$doc->exportField($this->numdni);
						$doc->exportField($this->nomcliente);
						$doc->exportField($this->nomclientecorp);
						$doc->exportField($this->dircliente);
						$doc->exportField($this->dirclientefis);
						$doc->exportField($this->refcliente);
						$doc->exportField($this->coddpto);
						$doc->exportField($this->codprov);
						$doc->exportField($this->coddist);
						$doc->exportField($this->codubigeo);
						$doc->exportField($this->numtelefono);
						$doc->exportField($this->numtelefono2);
						$doc->exportField($this->emailcliente);
						$doc->exportField($this->nomclienteaut);
						$doc->exportField($this->numtelefonoaut);
						$doc->exportField($this->numdniaut);
						$doc->exportField($this->fecha_reg);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>