<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kp_clientes_add extends kp_clientes
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kp_clientes';

	// Page object name
	public $PageObjName = "kp_clientes_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kp_clientes)
		if (!isset($GLOBALS["kp_clientes"]) || get_class($GLOBALS["kp_clientes"]) == PROJECT_NAMESPACE . "kp_clientes") {
			$GLOBALS["kp_clientes"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kp_clientes"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kp_clientes');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kp_clientes;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kp_clientes);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "kp_clientesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_reg'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_reg->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kp_clienteslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_reg->Visible = FALSE;
		$this->estado->setVisibility();
		$this->idempresa->setVisibility();
		$this->codcliente->setVisibility();
		$this->codclienteemp->setVisibility();
		$this->tipocliente->setVisibility();
		$this->numruc->setVisibility();
		$this->numdni->setVisibility();
		$this->nomcliente->setVisibility();
		$this->nomclientecorp->setVisibility();
		$this->dircliente->setVisibility();
		$this->dirclientefis->setVisibility();
		$this->refcliente->setVisibility();
		$this->coddpto->setVisibility();
		$this->codprov->setVisibility();
		$this->coddist->setVisibility();
		$this->codubigeo->setVisibility();
		$this->numtelefono->setVisibility();
		$this->numtelefono2->setVisibility();
		$this->emailcliente->setVisibility();
		$this->nomclienteaut->setVisibility();
		$this->numtelefonoaut->setVisibility();
		$this->numdniaut->setVisibility();
		$this->fecha_reg->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id_reg") !== NULL) {
				$this->id_reg->setQueryStringValue(Get("id_reg"));
				$this->setKey("id_reg", $this->id_reg->CurrentValue); // Set up key
			} else {
				$this->setKey("id_reg", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("kp_clienteslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "kp_clienteslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "kp_clientesview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id_reg->CurrentValue = NULL;
		$this->id_reg->OldValue = $this->id_reg->CurrentValue;
		$this->estado->CurrentValue = 1;
		$this->idempresa->CurrentValue = NULL;
		$this->idempresa->OldValue = $this->idempresa->CurrentValue;
		$this->codcliente->CurrentValue = NULL;
		$this->codcliente->OldValue = $this->codcliente->CurrentValue;
		$this->codclienteemp->CurrentValue = NULL;
		$this->codclienteemp->OldValue = $this->codclienteemp->CurrentValue;
		$this->tipocliente->CurrentValue = NULL;
		$this->tipocliente->OldValue = $this->tipocliente->CurrentValue;
		$this->numruc->CurrentValue = NULL;
		$this->numruc->OldValue = $this->numruc->CurrentValue;
		$this->numdni->CurrentValue = NULL;
		$this->numdni->OldValue = $this->numdni->CurrentValue;
		$this->nomcliente->CurrentValue = NULL;
		$this->nomcliente->OldValue = $this->nomcliente->CurrentValue;
		$this->nomclientecorp->CurrentValue = NULL;
		$this->nomclientecorp->OldValue = $this->nomclientecorp->CurrentValue;
		$this->dircliente->CurrentValue = NULL;
		$this->dircliente->OldValue = $this->dircliente->CurrentValue;
		$this->dirclientefis->CurrentValue = NULL;
		$this->dirclientefis->OldValue = $this->dirclientefis->CurrentValue;
		$this->refcliente->CurrentValue = NULL;
		$this->refcliente->OldValue = $this->refcliente->CurrentValue;
		$this->coddpto->CurrentValue = NULL;
		$this->coddpto->OldValue = $this->coddpto->CurrentValue;
		$this->codprov->CurrentValue = NULL;
		$this->codprov->OldValue = $this->codprov->CurrentValue;
		$this->coddist->CurrentValue = NULL;
		$this->coddist->OldValue = $this->coddist->CurrentValue;
		$this->codubigeo->CurrentValue = NULL;
		$this->codubigeo->OldValue = $this->codubigeo->CurrentValue;
		$this->numtelefono->CurrentValue = NULL;
		$this->numtelefono->OldValue = $this->numtelefono->CurrentValue;
		$this->numtelefono2->CurrentValue = NULL;
		$this->numtelefono2->OldValue = $this->numtelefono2->CurrentValue;
		$this->emailcliente->CurrentValue = NULL;
		$this->emailcliente->OldValue = $this->emailcliente->CurrentValue;
		$this->nomclienteaut->CurrentValue = NULL;
		$this->nomclienteaut->OldValue = $this->nomclienteaut->CurrentValue;
		$this->numtelefonoaut->CurrentValue = NULL;
		$this->numtelefonoaut->OldValue = $this->numtelefonoaut->CurrentValue;
		$this->numdniaut->CurrentValue = NULL;
		$this->numdniaut->OldValue = $this->numdniaut->CurrentValue;
		$this->fecha_reg->CurrentValue = NULL;
		$this->fecha_reg->OldValue = $this->fecha_reg->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'idempresa' first before field var 'x_idempresa'
		$val = $CurrentForm->hasValue("idempresa") ? $CurrentForm->getValue("idempresa") : $CurrentForm->getValue("x_idempresa");
		if (!$this->idempresa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idempresa->Visible = FALSE; // Disable update for API request
			else
				$this->idempresa->setFormValue($val);
		}

		// Check field name 'codcliente' first before field var 'x_codcliente'
		$val = $CurrentForm->hasValue("codcliente") ? $CurrentForm->getValue("codcliente") : $CurrentForm->getValue("x_codcliente");
		if (!$this->codcliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codcliente->Visible = FALSE; // Disable update for API request
			else
				$this->codcliente->setFormValue($val);
		}

		// Check field name 'codclienteemp' first before field var 'x_codclienteemp'
		$val = $CurrentForm->hasValue("codclienteemp") ? $CurrentForm->getValue("codclienteemp") : $CurrentForm->getValue("x_codclienteemp");
		if (!$this->codclienteemp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codclienteemp->Visible = FALSE; // Disable update for API request
			else
				$this->codclienteemp->setFormValue($val);
		}

		// Check field name 'tipocliente' first before field var 'x_tipocliente'
		$val = $CurrentForm->hasValue("tipocliente") ? $CurrentForm->getValue("tipocliente") : $CurrentForm->getValue("x_tipocliente");
		if (!$this->tipocliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipocliente->Visible = FALSE; // Disable update for API request
			else
				$this->tipocliente->setFormValue($val);
		}

		// Check field name 'numruc' first before field var 'x_numruc'
		$val = $CurrentForm->hasValue("numruc") ? $CurrentForm->getValue("numruc") : $CurrentForm->getValue("x_numruc");
		if (!$this->numruc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numruc->Visible = FALSE; // Disable update for API request
			else
				$this->numruc->setFormValue($val);
		}

		// Check field name 'numdni' first before field var 'x_numdni'
		$val = $CurrentForm->hasValue("numdni") ? $CurrentForm->getValue("numdni") : $CurrentForm->getValue("x_numdni");
		if (!$this->numdni->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numdni->Visible = FALSE; // Disable update for API request
			else
				$this->numdni->setFormValue($val);
		}

		// Check field name 'nomcliente' first before field var 'x_nomcliente'
		$val = $CurrentForm->hasValue("nomcliente") ? $CurrentForm->getValue("nomcliente") : $CurrentForm->getValue("x_nomcliente");
		if (!$this->nomcliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomcliente->Visible = FALSE; // Disable update for API request
			else
				$this->nomcliente->setFormValue($val);
		}

		// Check field name 'nomclientecorp' first before field var 'x_nomclientecorp'
		$val = $CurrentForm->hasValue("nomclientecorp") ? $CurrentForm->getValue("nomclientecorp") : $CurrentForm->getValue("x_nomclientecorp");
		if (!$this->nomclientecorp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomclientecorp->Visible = FALSE; // Disable update for API request
			else
				$this->nomclientecorp->setFormValue($val);
		}

		// Check field name 'dircliente' first before field var 'x_dircliente'
		$val = $CurrentForm->hasValue("dircliente") ? $CurrentForm->getValue("dircliente") : $CurrentForm->getValue("x_dircliente");
		if (!$this->dircliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dircliente->Visible = FALSE; // Disable update for API request
			else
				$this->dircliente->setFormValue($val);
		}

		// Check field name 'dirclientefis' first before field var 'x_dirclientefis'
		$val = $CurrentForm->hasValue("dirclientefis") ? $CurrentForm->getValue("dirclientefis") : $CurrentForm->getValue("x_dirclientefis");
		if (!$this->dirclientefis->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dirclientefis->Visible = FALSE; // Disable update for API request
			else
				$this->dirclientefis->setFormValue($val);
		}

		// Check field name 'refcliente' first before field var 'x_refcliente'
		$val = $CurrentForm->hasValue("refcliente") ? $CurrentForm->getValue("refcliente") : $CurrentForm->getValue("x_refcliente");
		if (!$this->refcliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->refcliente->Visible = FALSE; // Disable update for API request
			else
				$this->refcliente->setFormValue($val);
		}

		// Check field name 'coddpto' first before field var 'x_coddpto'
		$val = $CurrentForm->hasValue("coddpto") ? $CurrentForm->getValue("coddpto") : $CurrentForm->getValue("x_coddpto");
		if (!$this->coddpto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->coddpto->Visible = FALSE; // Disable update for API request
			else
				$this->coddpto->setFormValue($val);
		}

		// Check field name 'codprov' first before field var 'x_codprov'
		$val = $CurrentForm->hasValue("codprov") ? $CurrentForm->getValue("codprov") : $CurrentForm->getValue("x_codprov");
		if (!$this->codprov->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codprov->Visible = FALSE; // Disable update for API request
			else
				$this->codprov->setFormValue($val);
		}

		// Check field name 'coddist' first before field var 'x_coddist'
		$val = $CurrentForm->hasValue("coddist") ? $CurrentForm->getValue("coddist") : $CurrentForm->getValue("x_coddist");
		if (!$this->coddist->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->coddist->Visible = FALSE; // Disable update for API request
			else
				$this->coddist->setFormValue($val);
		}

		// Check field name 'codubigeo' first before field var 'x_codubigeo'
		$val = $CurrentForm->hasValue("codubigeo") ? $CurrentForm->getValue("codubigeo") : $CurrentForm->getValue("x_codubigeo");
		if (!$this->codubigeo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codubigeo->Visible = FALSE; // Disable update for API request
			else
				$this->codubigeo->setFormValue($val);
		}

		// Check field name 'numtelefono' first before field var 'x_numtelefono'
		$val = $CurrentForm->hasValue("numtelefono") ? $CurrentForm->getValue("numtelefono") : $CurrentForm->getValue("x_numtelefono");
		if (!$this->numtelefono->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numtelefono->Visible = FALSE; // Disable update for API request
			else
				$this->numtelefono->setFormValue($val);
		}

		// Check field name 'numtelefono2' first before field var 'x_numtelefono2'
		$val = $CurrentForm->hasValue("numtelefono2") ? $CurrentForm->getValue("numtelefono2") : $CurrentForm->getValue("x_numtelefono2");
		if (!$this->numtelefono2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numtelefono2->Visible = FALSE; // Disable update for API request
			else
				$this->numtelefono2->setFormValue($val);
		}

		// Check field name 'emailcliente' first before field var 'x_emailcliente'
		$val = $CurrentForm->hasValue("emailcliente") ? $CurrentForm->getValue("emailcliente") : $CurrentForm->getValue("x_emailcliente");
		if (!$this->emailcliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emailcliente->Visible = FALSE; // Disable update for API request
			else
				$this->emailcliente->setFormValue($val);
		}

		// Check field name 'nomclienteaut' first before field var 'x_nomclienteaut'
		$val = $CurrentForm->hasValue("nomclienteaut") ? $CurrentForm->getValue("nomclienteaut") : $CurrentForm->getValue("x_nomclienteaut");
		if (!$this->nomclienteaut->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomclienteaut->Visible = FALSE; // Disable update for API request
			else
				$this->nomclienteaut->setFormValue($val);
		}

		// Check field name 'numtelefonoaut' first before field var 'x_numtelefonoaut'
		$val = $CurrentForm->hasValue("numtelefonoaut") ? $CurrentForm->getValue("numtelefonoaut") : $CurrentForm->getValue("x_numtelefonoaut");
		if (!$this->numtelefonoaut->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numtelefonoaut->Visible = FALSE; // Disable update for API request
			else
				$this->numtelefonoaut->setFormValue($val);
		}

		// Check field name 'numdniaut' first before field var 'x_numdniaut'
		$val = $CurrentForm->hasValue("numdniaut") ? $CurrentForm->getValue("numdniaut") : $CurrentForm->getValue("x_numdniaut");
		if (!$this->numdniaut->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numdniaut->Visible = FALSE; // Disable update for API request
			else
				$this->numdniaut->setFormValue($val);
		}

		// Check field name 'fecha_reg' first before field var 'x_fecha_reg'
		$val = $CurrentForm->hasValue("fecha_reg") ? $CurrentForm->getValue("fecha_reg") : $CurrentForm->getValue("x_fecha_reg");
		if (!$this->fecha_reg->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_reg->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_reg->setFormValue($val);
			$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
		}

		// Check field name 'id_reg' first before field var 'x_id_reg'
		$val = $CurrentForm->hasValue("id_reg") ? $CurrentForm->getValue("id_reg") : $CurrentForm->getValue("x_id_reg");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->idempresa->CurrentValue = $this->idempresa->FormValue;
		$this->codcliente->CurrentValue = $this->codcliente->FormValue;
		$this->codclienteemp->CurrentValue = $this->codclienteemp->FormValue;
		$this->tipocliente->CurrentValue = $this->tipocliente->FormValue;
		$this->numruc->CurrentValue = $this->numruc->FormValue;
		$this->numdni->CurrentValue = $this->numdni->FormValue;
		$this->nomcliente->CurrentValue = $this->nomcliente->FormValue;
		$this->nomclientecorp->CurrentValue = $this->nomclientecorp->FormValue;
		$this->dircliente->CurrentValue = $this->dircliente->FormValue;
		$this->dirclientefis->CurrentValue = $this->dirclientefis->FormValue;
		$this->refcliente->CurrentValue = $this->refcliente->FormValue;
		$this->coddpto->CurrentValue = $this->coddpto->FormValue;
		$this->codprov->CurrentValue = $this->codprov->FormValue;
		$this->coddist->CurrentValue = $this->coddist->FormValue;
		$this->codubigeo->CurrentValue = $this->codubigeo->FormValue;
		$this->numtelefono->CurrentValue = $this->numtelefono->FormValue;
		$this->numtelefono2->CurrentValue = $this->numtelefono2->FormValue;
		$this->emailcliente->CurrentValue = $this->emailcliente->FormValue;
		$this->nomclienteaut->CurrentValue = $this->nomclienteaut->FormValue;
		$this->numtelefonoaut->CurrentValue = $this->numtelefonoaut->FormValue;
		$this->numdniaut->CurrentValue = $this->numdniaut->FormValue;
		$this->fecha_reg->CurrentValue = $this->fecha_reg->FormValue;
		$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_reg->setDbValue($row['id_reg']);
		$this->estado->setDbValue($row['estado']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->codcliente->setDbValue($row['codcliente']);
		$this->codclienteemp->setDbValue($row['codclienteemp']);
		$this->tipocliente->setDbValue($row['tipocliente']);
		$this->numruc->setDbValue($row['numruc']);
		$this->numdni->setDbValue($row['numdni']);
		$this->nomcliente->setDbValue($row['nomcliente']);
		$this->nomclientecorp->setDbValue($row['nomclientecorp']);
		$this->dircliente->setDbValue($row['dircliente']);
		$this->dirclientefis->setDbValue($row['dirclientefis']);
		$this->refcliente->setDbValue($row['refcliente']);
		$this->coddpto->setDbValue($row['coddpto']);
		$this->codprov->setDbValue($row['codprov']);
		$this->coddist->setDbValue($row['coddist']);
		$this->codubigeo->setDbValue($row['codubigeo']);
		$this->numtelefono->setDbValue($row['numtelefono']);
		$this->numtelefono2->setDbValue($row['numtelefono2']);
		$this->emailcliente->setDbValue($row['emailcliente']);
		$this->nomclienteaut->setDbValue($row['nomclienteaut']);
		$this->numtelefonoaut->setDbValue($row['numtelefonoaut']);
		$this->numdniaut->setDbValue($row['numdniaut']);
		$this->fecha_reg->setDbValue($row['fecha_reg']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id_reg'] = $this->id_reg->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		$row['idempresa'] = $this->idempresa->CurrentValue;
		$row['codcliente'] = $this->codcliente->CurrentValue;
		$row['codclienteemp'] = $this->codclienteemp->CurrentValue;
		$row['tipocliente'] = $this->tipocliente->CurrentValue;
		$row['numruc'] = $this->numruc->CurrentValue;
		$row['numdni'] = $this->numdni->CurrentValue;
		$row['nomcliente'] = $this->nomcliente->CurrentValue;
		$row['nomclientecorp'] = $this->nomclientecorp->CurrentValue;
		$row['dircliente'] = $this->dircliente->CurrentValue;
		$row['dirclientefis'] = $this->dirclientefis->CurrentValue;
		$row['refcliente'] = $this->refcliente->CurrentValue;
		$row['coddpto'] = $this->coddpto->CurrentValue;
		$row['codprov'] = $this->codprov->CurrentValue;
		$row['coddist'] = $this->coddist->CurrentValue;
		$row['codubigeo'] = $this->codubigeo->CurrentValue;
		$row['numtelefono'] = $this->numtelefono->CurrentValue;
		$row['numtelefono2'] = $this->numtelefono2->CurrentValue;
		$row['emailcliente'] = $this->emailcliente->CurrentValue;
		$row['nomclienteaut'] = $this->nomclienteaut->CurrentValue;
		$row['numtelefonoaut'] = $this->numtelefonoaut->CurrentValue;
		$row['numdniaut'] = $this->numdniaut->CurrentValue;
		$row['fecha_reg'] = $this->fecha_reg->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_reg")) != "")
			$this->id_reg->OldValue = $this->getKey("id_reg"); // id_reg
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id_reg
		// estado
		// idempresa
		// codcliente
		// codclienteemp
		// tipocliente
		// numruc
		// numdni
		// nomcliente
		// nomclientecorp
		// dircliente
		// dirclientefis
		// refcliente
		// coddpto
		// codprov
		// coddist
		// codubigeo
		// numtelefono
		// numtelefono2
		// emailcliente
		// nomclienteaut
		// numtelefonoaut
		// numdniaut
		// fecha_reg

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_reg
			$this->id_reg->ViewValue = $this->id_reg->CurrentValue;
			$this->id_reg->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// codcliente
			$this->codcliente->ViewValue = $this->codcliente->CurrentValue;
			$this->codcliente->ViewValue = FormatNumber($this->codcliente->ViewValue, 0, -2, -2, -2);
			$this->codcliente->ViewCustomAttributes = "";

			// codclienteemp
			$this->codclienteemp->ViewValue = $this->codclienteemp->CurrentValue;
			$this->codclienteemp->ViewCustomAttributes = "";

			// tipocliente
			$this->tipocliente->ViewValue = $this->tipocliente->CurrentValue;
			$this->tipocliente->ViewCustomAttributes = "";

			// numruc
			$this->numruc->ViewValue = $this->numruc->CurrentValue;
			$this->numruc->ViewCustomAttributes = "";

			// numdni
			$this->numdni->ViewValue = $this->numdni->CurrentValue;
			$this->numdni->ViewCustomAttributes = "";

			// nomcliente
			$this->nomcliente->ViewValue = $this->nomcliente->CurrentValue;
			$this->nomcliente->ViewCustomAttributes = "";

			// nomclientecorp
			$this->nomclientecorp->ViewValue = $this->nomclientecorp->CurrentValue;
			$this->nomclientecorp->ViewCustomAttributes = "";

			// dircliente
			$this->dircliente->ViewValue = $this->dircliente->CurrentValue;
			$this->dircliente->ViewCustomAttributes = "";

			// dirclientefis
			$this->dirclientefis->ViewValue = $this->dirclientefis->CurrentValue;
			$this->dirclientefis->ViewCustomAttributes = "";

			// refcliente
			$this->refcliente->ViewValue = $this->refcliente->CurrentValue;
			$this->refcliente->ViewCustomAttributes = "";

			// coddpto
			$this->coddpto->ViewValue = $this->coddpto->CurrentValue;
			$this->coddpto->ViewCustomAttributes = "";

			// codprov
			$this->codprov->ViewValue = $this->codprov->CurrentValue;
			$this->codprov->ViewCustomAttributes = "";

			// coddist
			$this->coddist->ViewValue = $this->coddist->CurrentValue;
			$this->coddist->ViewCustomAttributes = "";

			// codubigeo
			$this->codubigeo->ViewValue = $this->codubigeo->CurrentValue;
			$this->codubigeo->ViewCustomAttributes = "";

			// numtelefono
			$this->numtelefono->ViewValue = $this->numtelefono->CurrentValue;
			$this->numtelefono->ViewCustomAttributes = "";

			// numtelefono2
			$this->numtelefono2->ViewValue = $this->numtelefono2->CurrentValue;
			$this->numtelefono2->ViewCustomAttributes = "";

			// emailcliente
			$this->emailcliente->ViewValue = $this->emailcliente->CurrentValue;
			$this->emailcliente->ViewCustomAttributes = "";

			// nomclienteaut
			$this->nomclienteaut->ViewValue = $this->nomclienteaut->CurrentValue;
			$this->nomclienteaut->ViewCustomAttributes = "";

			// numtelefonoaut
			$this->numtelefonoaut->ViewValue = $this->numtelefonoaut->CurrentValue;
			$this->numtelefonoaut->ViewCustomAttributes = "";

			// numdniaut
			$this->numdniaut->ViewValue = $this->numdniaut->CurrentValue;
			$this->numdniaut->ViewCustomAttributes = "";

			// fecha_reg
			$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
			$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
			$this->fecha_reg->ViewCustomAttributes = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// codcliente
			$this->codcliente->LinkCustomAttributes = "";
			$this->codcliente->HrefValue = "";
			$this->codcliente->TooltipValue = "";

			// codclienteemp
			$this->codclienteemp->LinkCustomAttributes = "";
			$this->codclienteemp->HrefValue = "";
			$this->codclienteemp->TooltipValue = "";

			// tipocliente
			$this->tipocliente->LinkCustomAttributes = "";
			$this->tipocliente->HrefValue = "";
			$this->tipocliente->TooltipValue = "";

			// numruc
			$this->numruc->LinkCustomAttributes = "";
			$this->numruc->HrefValue = "";
			$this->numruc->TooltipValue = "";

			// numdni
			$this->numdni->LinkCustomAttributes = "";
			$this->numdni->HrefValue = "";
			$this->numdni->TooltipValue = "";

			// nomcliente
			$this->nomcliente->LinkCustomAttributes = "";
			$this->nomcliente->HrefValue = "";
			$this->nomcliente->TooltipValue = "";

			// nomclientecorp
			$this->nomclientecorp->LinkCustomAttributes = "";
			$this->nomclientecorp->HrefValue = "";
			$this->nomclientecorp->TooltipValue = "";

			// dircliente
			$this->dircliente->LinkCustomAttributes = "";
			$this->dircliente->HrefValue = "";
			$this->dircliente->TooltipValue = "";

			// dirclientefis
			$this->dirclientefis->LinkCustomAttributes = "";
			$this->dirclientefis->HrefValue = "";
			$this->dirclientefis->TooltipValue = "";

			// refcliente
			$this->refcliente->LinkCustomAttributes = "";
			$this->refcliente->HrefValue = "";
			$this->refcliente->TooltipValue = "";

			// coddpto
			$this->coddpto->LinkCustomAttributes = "";
			$this->coddpto->HrefValue = "";
			$this->coddpto->TooltipValue = "";

			// codprov
			$this->codprov->LinkCustomAttributes = "";
			$this->codprov->HrefValue = "";
			$this->codprov->TooltipValue = "";

			// coddist
			$this->coddist->LinkCustomAttributes = "";
			$this->coddist->HrefValue = "";
			$this->coddist->TooltipValue = "";

			// codubigeo
			$this->codubigeo->LinkCustomAttributes = "";
			$this->codubigeo->HrefValue = "";
			$this->codubigeo->TooltipValue = "";

			// numtelefono
			$this->numtelefono->LinkCustomAttributes = "";
			$this->numtelefono->HrefValue = "";
			$this->numtelefono->TooltipValue = "";

			// numtelefono2
			$this->numtelefono2->LinkCustomAttributes = "";
			$this->numtelefono2->HrefValue = "";
			$this->numtelefono2->TooltipValue = "";

			// emailcliente
			$this->emailcliente->LinkCustomAttributes = "";
			$this->emailcliente->HrefValue = "";
			$this->emailcliente->TooltipValue = "";

			// nomclienteaut
			$this->nomclienteaut->LinkCustomAttributes = "";
			$this->nomclienteaut->HrefValue = "";
			$this->nomclienteaut->TooltipValue = "";

			// numtelefonoaut
			$this->numtelefonoaut->LinkCustomAttributes = "";
			$this->numtelefonoaut->HrefValue = "";
			$this->numtelefonoaut->TooltipValue = "";

			// numdniaut
			$this->numdniaut->LinkCustomAttributes = "";
			$this->numdniaut->HrefValue = "";
			$this->numdniaut->TooltipValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
			$this->fecha_reg->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// idempresa
			$this->idempresa->EditAttrs["class"] = "form-control";
			$this->idempresa->EditCustomAttributes = "";
			$this->idempresa->EditValue = HtmlEncode($this->idempresa->CurrentValue);
			$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

			// codcliente
			$this->codcliente->EditAttrs["class"] = "form-control";
			$this->codcliente->EditCustomAttributes = "";
			$this->codcliente->EditValue = HtmlEncode($this->codcliente->CurrentValue);
			$this->codcliente->PlaceHolder = RemoveHtml($this->codcliente->caption());

			// codclienteemp
			$this->codclienteemp->EditAttrs["class"] = "form-control";
			$this->codclienteemp->EditCustomAttributes = "";
			if (!$this->codclienteemp->Raw)
				$this->codclienteemp->CurrentValue = HtmlDecode($this->codclienteemp->CurrentValue);
			$this->codclienteemp->EditValue = HtmlEncode($this->codclienteemp->CurrentValue);
			$this->codclienteemp->PlaceHolder = RemoveHtml($this->codclienteemp->caption());

			// tipocliente
			$this->tipocliente->EditAttrs["class"] = "form-control";
			$this->tipocliente->EditCustomAttributes = "";
			if (!$this->tipocliente->Raw)
				$this->tipocliente->CurrentValue = HtmlDecode($this->tipocliente->CurrentValue);
			$this->tipocliente->EditValue = HtmlEncode($this->tipocliente->CurrentValue);
			$this->tipocliente->PlaceHolder = RemoveHtml($this->tipocliente->caption());

			// numruc
			$this->numruc->EditAttrs["class"] = "form-control";
			$this->numruc->EditCustomAttributes = "";
			if (!$this->numruc->Raw)
				$this->numruc->CurrentValue = HtmlDecode($this->numruc->CurrentValue);
			$this->numruc->EditValue = HtmlEncode($this->numruc->CurrentValue);
			$this->numruc->PlaceHolder = RemoveHtml($this->numruc->caption());

			// numdni
			$this->numdni->EditAttrs["class"] = "form-control";
			$this->numdni->EditCustomAttributes = "";
			if (!$this->numdni->Raw)
				$this->numdni->CurrentValue = HtmlDecode($this->numdni->CurrentValue);
			$this->numdni->EditValue = HtmlEncode($this->numdni->CurrentValue);
			$this->numdni->PlaceHolder = RemoveHtml($this->numdni->caption());

			// nomcliente
			$this->nomcliente->EditAttrs["class"] = "form-control";
			$this->nomcliente->EditCustomAttributes = "";
			if (!$this->nomcliente->Raw)
				$this->nomcliente->CurrentValue = HtmlDecode($this->nomcliente->CurrentValue);
			$this->nomcliente->EditValue = HtmlEncode($this->nomcliente->CurrentValue);
			$this->nomcliente->PlaceHolder = RemoveHtml($this->nomcliente->caption());

			// nomclientecorp
			$this->nomclientecorp->EditAttrs["class"] = "form-control";
			$this->nomclientecorp->EditCustomAttributes = "";
			if (!$this->nomclientecorp->Raw)
				$this->nomclientecorp->CurrentValue = HtmlDecode($this->nomclientecorp->CurrentValue);
			$this->nomclientecorp->EditValue = HtmlEncode($this->nomclientecorp->CurrentValue);
			$this->nomclientecorp->PlaceHolder = RemoveHtml($this->nomclientecorp->caption());

			// dircliente
			$this->dircliente->EditAttrs["class"] = "form-control";
			$this->dircliente->EditCustomAttributes = "";
			if (!$this->dircliente->Raw)
				$this->dircliente->CurrentValue = HtmlDecode($this->dircliente->CurrentValue);
			$this->dircliente->EditValue = HtmlEncode($this->dircliente->CurrentValue);
			$this->dircliente->PlaceHolder = RemoveHtml($this->dircliente->caption());

			// dirclientefis
			$this->dirclientefis->EditAttrs["class"] = "form-control";
			$this->dirclientefis->EditCustomAttributes = "";
			if (!$this->dirclientefis->Raw)
				$this->dirclientefis->CurrentValue = HtmlDecode($this->dirclientefis->CurrentValue);
			$this->dirclientefis->EditValue = HtmlEncode($this->dirclientefis->CurrentValue);
			$this->dirclientefis->PlaceHolder = RemoveHtml($this->dirclientefis->caption());

			// refcliente
			$this->refcliente->EditAttrs["class"] = "form-control";
			$this->refcliente->EditCustomAttributes = "";
			if (!$this->refcliente->Raw)
				$this->refcliente->CurrentValue = HtmlDecode($this->refcliente->CurrentValue);
			$this->refcliente->EditValue = HtmlEncode($this->refcliente->CurrentValue);
			$this->refcliente->PlaceHolder = RemoveHtml($this->refcliente->caption());

			// coddpto
			$this->coddpto->EditAttrs["class"] = "form-control";
			$this->coddpto->EditCustomAttributes = "";
			if (!$this->coddpto->Raw)
				$this->coddpto->CurrentValue = HtmlDecode($this->coddpto->CurrentValue);
			$this->coddpto->EditValue = HtmlEncode($this->coddpto->CurrentValue);
			$this->coddpto->PlaceHolder = RemoveHtml($this->coddpto->caption());

			// codprov
			$this->codprov->EditAttrs["class"] = "form-control";
			$this->codprov->EditCustomAttributes = "";
			if (!$this->codprov->Raw)
				$this->codprov->CurrentValue = HtmlDecode($this->codprov->CurrentValue);
			$this->codprov->EditValue = HtmlEncode($this->codprov->CurrentValue);
			$this->codprov->PlaceHolder = RemoveHtml($this->codprov->caption());

			// coddist
			$this->coddist->EditAttrs["class"] = "form-control";
			$this->coddist->EditCustomAttributes = "";
			if (!$this->coddist->Raw)
				$this->coddist->CurrentValue = HtmlDecode($this->coddist->CurrentValue);
			$this->coddist->EditValue = HtmlEncode($this->coddist->CurrentValue);
			$this->coddist->PlaceHolder = RemoveHtml($this->coddist->caption());

			// codubigeo
			$this->codubigeo->EditAttrs["class"] = "form-control";
			$this->codubigeo->EditCustomAttributes = "";
			if (!$this->codubigeo->Raw)
				$this->codubigeo->CurrentValue = HtmlDecode($this->codubigeo->CurrentValue);
			$this->codubigeo->EditValue = HtmlEncode($this->codubigeo->CurrentValue);
			$this->codubigeo->PlaceHolder = RemoveHtml($this->codubigeo->caption());

			// numtelefono
			$this->numtelefono->EditAttrs["class"] = "form-control";
			$this->numtelefono->EditCustomAttributes = "";
			if (!$this->numtelefono->Raw)
				$this->numtelefono->CurrentValue = HtmlDecode($this->numtelefono->CurrentValue);
			$this->numtelefono->EditValue = HtmlEncode($this->numtelefono->CurrentValue);
			$this->numtelefono->PlaceHolder = RemoveHtml($this->numtelefono->caption());

			// numtelefono2
			$this->numtelefono2->EditAttrs["class"] = "form-control";
			$this->numtelefono2->EditCustomAttributes = "";
			if (!$this->numtelefono2->Raw)
				$this->numtelefono2->CurrentValue = HtmlDecode($this->numtelefono2->CurrentValue);
			$this->numtelefono2->EditValue = HtmlEncode($this->numtelefono2->CurrentValue);
			$this->numtelefono2->PlaceHolder = RemoveHtml($this->numtelefono2->caption());

			// emailcliente
			$this->emailcliente->EditAttrs["class"] = "form-control";
			$this->emailcliente->EditCustomAttributes = "";
			if (!$this->emailcliente->Raw)
				$this->emailcliente->CurrentValue = HtmlDecode($this->emailcliente->CurrentValue);
			$this->emailcliente->EditValue = HtmlEncode($this->emailcliente->CurrentValue);
			$this->emailcliente->PlaceHolder = RemoveHtml($this->emailcliente->caption());

			// nomclienteaut
			$this->nomclienteaut->EditAttrs["class"] = "form-control";
			$this->nomclienteaut->EditCustomAttributes = "";
			if (!$this->nomclienteaut->Raw)
				$this->nomclienteaut->CurrentValue = HtmlDecode($this->nomclienteaut->CurrentValue);
			$this->nomclienteaut->EditValue = HtmlEncode($this->nomclienteaut->CurrentValue);
			$this->nomclienteaut->PlaceHolder = RemoveHtml($this->nomclienteaut->caption());

			// numtelefonoaut
			$this->numtelefonoaut->EditAttrs["class"] = "form-control";
			$this->numtelefonoaut->EditCustomAttributes = "";
			if (!$this->numtelefonoaut->Raw)
				$this->numtelefonoaut->CurrentValue = HtmlDecode($this->numtelefonoaut->CurrentValue);
			$this->numtelefonoaut->EditValue = HtmlEncode($this->numtelefonoaut->CurrentValue);
			$this->numtelefonoaut->PlaceHolder = RemoveHtml($this->numtelefonoaut->caption());

			// numdniaut
			$this->numdniaut->EditAttrs["class"] = "form-control";
			$this->numdniaut->EditCustomAttributes = "";
			if (!$this->numdniaut->Raw)
				$this->numdniaut->CurrentValue = HtmlDecode($this->numdniaut->CurrentValue);
			$this->numdniaut->EditValue = HtmlEncode($this->numdniaut->CurrentValue);
			$this->numdniaut->PlaceHolder = RemoveHtml($this->numdniaut->caption());

			// fecha_reg
			$this->fecha_reg->EditAttrs["class"] = "form-control";
			$this->fecha_reg->EditCustomAttributes = "";
			$this->fecha_reg->EditValue = HtmlEncode(FormatDateTime($this->fecha_reg->CurrentValue, 8));
			$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

			// Add refer script
			// estado

			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";

			// codcliente
			$this->codcliente->LinkCustomAttributes = "";
			$this->codcliente->HrefValue = "";

			// codclienteemp
			$this->codclienteemp->LinkCustomAttributes = "";
			$this->codclienteemp->HrefValue = "";

			// tipocliente
			$this->tipocliente->LinkCustomAttributes = "";
			$this->tipocliente->HrefValue = "";

			// numruc
			$this->numruc->LinkCustomAttributes = "";
			$this->numruc->HrefValue = "";

			// numdni
			$this->numdni->LinkCustomAttributes = "";
			$this->numdni->HrefValue = "";

			// nomcliente
			$this->nomcliente->LinkCustomAttributes = "";
			$this->nomcliente->HrefValue = "";

			// nomclientecorp
			$this->nomclientecorp->LinkCustomAttributes = "";
			$this->nomclientecorp->HrefValue = "";

			// dircliente
			$this->dircliente->LinkCustomAttributes = "";
			$this->dircliente->HrefValue = "";

			// dirclientefis
			$this->dirclientefis->LinkCustomAttributes = "";
			$this->dirclientefis->HrefValue = "";

			// refcliente
			$this->refcliente->LinkCustomAttributes = "";
			$this->refcliente->HrefValue = "";

			// coddpto
			$this->coddpto->LinkCustomAttributes = "";
			$this->coddpto->HrefValue = "";

			// codprov
			$this->codprov->LinkCustomAttributes = "";
			$this->codprov->HrefValue = "";

			// coddist
			$this->coddist->LinkCustomAttributes = "";
			$this->coddist->HrefValue = "";

			// codubigeo
			$this->codubigeo->LinkCustomAttributes = "";
			$this->codubigeo->HrefValue = "";

			// numtelefono
			$this->numtelefono->LinkCustomAttributes = "";
			$this->numtelefono->HrefValue = "";

			// numtelefono2
			$this->numtelefono2->LinkCustomAttributes = "";
			$this->numtelefono2->HrefValue = "";

			// emailcliente
			$this->emailcliente->LinkCustomAttributes = "";
			$this->emailcliente->HrefValue = "";

			// nomclienteaut
			$this->nomclienteaut->LinkCustomAttributes = "";
			$this->nomclienteaut->HrefValue = "";

			// numtelefonoaut
			$this->numtelefonoaut->LinkCustomAttributes = "";
			$this->numtelefonoaut->HrefValue = "";

			// numdniaut
			$this->numdniaut->LinkCustomAttributes = "";
			$this->numdniaut->HrefValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->idempresa->Required) {
			if (!$this->idempresa->IsDetailKey && $this->idempresa->FormValue != NULL && $this->idempresa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idempresa->caption(), $this->idempresa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idempresa->FormValue)) {
			AddMessage($FormError, $this->idempresa->errorMessage());
		}
		if ($this->codcliente->Required) {
			if (!$this->codcliente->IsDetailKey && $this->codcliente->FormValue != NULL && $this->codcliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codcliente->caption(), $this->codcliente->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->codcliente->FormValue)) {
			AddMessage($FormError, $this->codcliente->errorMessage());
		}
		if ($this->codclienteemp->Required) {
			if (!$this->codclienteemp->IsDetailKey && $this->codclienteemp->FormValue != NULL && $this->codclienteemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codclienteemp->caption(), $this->codclienteemp->RequiredErrorMessage));
			}
		}
		if ($this->tipocliente->Required) {
			if (!$this->tipocliente->IsDetailKey && $this->tipocliente->FormValue != NULL && $this->tipocliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipocliente->caption(), $this->tipocliente->RequiredErrorMessage));
			}
		}
		if ($this->numruc->Required) {
			if (!$this->numruc->IsDetailKey && $this->numruc->FormValue != NULL && $this->numruc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numruc->caption(), $this->numruc->RequiredErrorMessage));
			}
		}
		if ($this->numdni->Required) {
			if (!$this->numdni->IsDetailKey && $this->numdni->FormValue != NULL && $this->numdni->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numdni->caption(), $this->numdni->RequiredErrorMessage));
			}
		}
		if ($this->nomcliente->Required) {
			if (!$this->nomcliente->IsDetailKey && $this->nomcliente->FormValue != NULL && $this->nomcliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomcliente->caption(), $this->nomcliente->RequiredErrorMessage));
			}
		}
		if ($this->nomclientecorp->Required) {
			if (!$this->nomclientecorp->IsDetailKey && $this->nomclientecorp->FormValue != NULL && $this->nomclientecorp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomclientecorp->caption(), $this->nomclientecorp->RequiredErrorMessage));
			}
		}
		if ($this->dircliente->Required) {
			if (!$this->dircliente->IsDetailKey && $this->dircliente->FormValue != NULL && $this->dircliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dircliente->caption(), $this->dircliente->RequiredErrorMessage));
			}
		}
		if ($this->dirclientefis->Required) {
			if (!$this->dirclientefis->IsDetailKey && $this->dirclientefis->FormValue != NULL && $this->dirclientefis->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dirclientefis->caption(), $this->dirclientefis->RequiredErrorMessage));
			}
		}
		if ($this->refcliente->Required) {
			if (!$this->refcliente->IsDetailKey && $this->refcliente->FormValue != NULL && $this->refcliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->refcliente->caption(), $this->refcliente->RequiredErrorMessage));
			}
		}
		if ($this->coddpto->Required) {
			if (!$this->coddpto->IsDetailKey && $this->coddpto->FormValue != NULL && $this->coddpto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->coddpto->caption(), $this->coddpto->RequiredErrorMessage));
			}
		}
		if ($this->codprov->Required) {
			if (!$this->codprov->IsDetailKey && $this->codprov->FormValue != NULL && $this->codprov->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codprov->caption(), $this->codprov->RequiredErrorMessage));
			}
		}
		if ($this->coddist->Required) {
			if (!$this->coddist->IsDetailKey && $this->coddist->FormValue != NULL && $this->coddist->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->coddist->caption(), $this->coddist->RequiredErrorMessage));
			}
		}
		if ($this->codubigeo->Required) {
			if (!$this->codubigeo->IsDetailKey && $this->codubigeo->FormValue != NULL && $this->codubigeo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codubigeo->caption(), $this->codubigeo->RequiredErrorMessage));
			}
		}
		if ($this->numtelefono->Required) {
			if (!$this->numtelefono->IsDetailKey && $this->numtelefono->FormValue != NULL && $this->numtelefono->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numtelefono->caption(), $this->numtelefono->RequiredErrorMessage));
			}
		}
		if ($this->numtelefono2->Required) {
			if (!$this->numtelefono2->IsDetailKey && $this->numtelefono2->FormValue != NULL && $this->numtelefono2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numtelefono2->caption(), $this->numtelefono2->RequiredErrorMessage));
			}
		}
		if ($this->emailcliente->Required) {
			if (!$this->emailcliente->IsDetailKey && $this->emailcliente->FormValue != NULL && $this->emailcliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emailcliente->caption(), $this->emailcliente->RequiredErrorMessage));
			}
		}
		if ($this->nomclienteaut->Required) {
			if (!$this->nomclienteaut->IsDetailKey && $this->nomclienteaut->FormValue != NULL && $this->nomclienteaut->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomclienteaut->caption(), $this->nomclienteaut->RequiredErrorMessage));
			}
		}
		if ($this->numtelefonoaut->Required) {
			if (!$this->numtelefonoaut->IsDetailKey && $this->numtelefonoaut->FormValue != NULL && $this->numtelefonoaut->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numtelefonoaut->caption(), $this->numtelefonoaut->RequiredErrorMessage));
			}
		}
		if ($this->numdniaut->Required) {
			if (!$this->numdniaut->IsDetailKey && $this->numdniaut->FormValue != NULL && $this->numdniaut->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numdniaut->caption(), $this->numdniaut->RequiredErrorMessage));
			}
		}
		if ($this->fecha_reg->Required) {
			if (!$this->fecha_reg->IsDetailKey && $this->fecha_reg->FormValue != NULL && $this->fecha_reg->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_reg->caption(), $this->fecha_reg->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha_reg->FormValue)) {
			AddMessage($FormError, $this->fecha_reg->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, 0, strval($this->estado->CurrentValue) == "");

		// idempresa
		$this->idempresa->setDbValueDef($rsnew, $this->idempresa->CurrentValue, 0, FALSE);

		// codcliente
		$this->codcliente->setDbValueDef($rsnew, $this->codcliente->CurrentValue, NULL, FALSE);

		// codclienteemp
		$this->codclienteemp->setDbValueDef($rsnew, $this->codclienteemp->CurrentValue, NULL, FALSE);

		// tipocliente
		$this->tipocliente->setDbValueDef($rsnew, $this->tipocliente->CurrentValue, "", FALSE);

		// numruc
		$this->numruc->setDbValueDef($rsnew, $this->numruc->CurrentValue, NULL, FALSE);

		// numdni
		$this->numdni->setDbValueDef($rsnew, $this->numdni->CurrentValue, NULL, FALSE);

		// nomcliente
		$this->nomcliente->setDbValueDef($rsnew, $this->nomcliente->CurrentValue, NULL, FALSE);

		// nomclientecorp
		$this->nomclientecorp->setDbValueDef($rsnew, $this->nomclientecorp->CurrentValue, NULL, FALSE);

		// dircliente
		$this->dircliente->setDbValueDef($rsnew, $this->dircliente->CurrentValue, NULL, FALSE);

		// dirclientefis
		$this->dirclientefis->setDbValueDef($rsnew, $this->dirclientefis->CurrentValue, NULL, FALSE);

		// refcliente
		$this->refcliente->setDbValueDef($rsnew, $this->refcliente->CurrentValue, NULL, FALSE);

		// coddpto
		$this->coddpto->setDbValueDef($rsnew, $this->coddpto->CurrentValue, NULL, FALSE);

		// codprov
		$this->codprov->setDbValueDef($rsnew, $this->codprov->CurrentValue, NULL, FALSE);

		// coddist
		$this->coddist->setDbValueDef($rsnew, $this->coddist->CurrentValue, NULL, FALSE);

		// codubigeo
		$this->codubigeo->setDbValueDef($rsnew, $this->codubigeo->CurrentValue, NULL, FALSE);

		// numtelefono
		$this->numtelefono->setDbValueDef($rsnew, $this->numtelefono->CurrentValue, NULL, FALSE);

		// numtelefono2
		$this->numtelefono2->setDbValueDef($rsnew, $this->numtelefono2->CurrentValue, NULL, FALSE);

		// emailcliente
		$this->emailcliente->setDbValueDef($rsnew, $this->emailcliente->CurrentValue, NULL, FALSE);

		// nomclienteaut
		$this->nomclienteaut->setDbValueDef($rsnew, $this->nomclienteaut->CurrentValue, NULL, FALSE);

		// numtelefonoaut
		$this->numtelefonoaut->setDbValueDef($rsnew, $this->numtelefonoaut->CurrentValue, NULL, FALSE);

		// numdniaut
		$this->numdniaut->setDbValueDef($rsnew, $this->numdniaut->CurrentValue, NULL, FALSE);

		// fecha_reg
		$this->fecha_reg->setDbValueDef($rsnew, UnFormatDateTime($this->fecha_reg->CurrentValue, 0), NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kp_clienteslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>