<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for lotes
 */
class lotes extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_producto;
	public $id_proyecto;
	public $codigo_producto;
	public $nombre_producto;
	public $status_producto;
	public $date_added;
	public $precio_producto;
	public $costo_producto;
	public $mon_costo;
	public $mon_venta;
	public $marca;
	public $modelo;
	public $color;
	public $b1;
	public $b2;
	public $b3;
	public $b4;
	public $b5;
	public $b6;
	public $cat_pro;
	public $pro_ser;
	public $foto1;
	public $foto2;
	public $foto3;
	public $foto4;
	public $web;
	public $pre_web;
	public $descripcion;
	public $descripcion1;
	public $megusta;
	public $nomegusta;
	public $precio2;
	public $precio3;
	public $und_pro;
	public $barras;
	public $stockmin;
	public $id_grupo;
	public $talla;
	public $mostrarcolor;
	public $lote;
	public $manzana;
	public $etapa;
	public $estado;
	public $icon;
	public $topy;
	public $leftx;
	public $codlogin;
	public $id_cliente;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'lotes';
		$this->TableName = 'lotes';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`lotes`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_producto
		$this->id_producto = new DbField('lotes', 'lotes', 'x_id_producto', 'id_producto', '`id_producto`', '`id_producto`', 3, 11, -1, FALSE, '`id_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_producto->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_producto->IsPrimaryKey = TRUE; // Primary key field
		$this->id_producto->Sortable = TRUE; // Allow sort
		$this->id_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_producto'] = &$this->id_producto;

		// id_proyecto
		$this->id_proyecto = new DbField('lotes', 'lotes', 'x_id_proyecto', 'id_proyecto', '`id_proyecto`', '`id_proyecto`', 3, 11, -1, FALSE, '`id_proyecto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_proyecto->Nullable = FALSE; // NOT NULL field
		$this->id_proyecto->Required = TRUE; // Required field
		$this->id_proyecto->Sortable = TRUE; // Allow sort
		$this->id_proyecto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_proyecto'] = &$this->id_proyecto;

		// codigo_producto
		$this->codigo_producto = new DbField('lotes', 'lotes', 'x_codigo_producto', 'codigo_producto', '`codigo_producto`', '`codigo_producto`', 200, 20, -1, FALSE, '`codigo_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codigo_producto->Nullable = FALSE; // NOT NULL field
		$this->codigo_producto->Required = TRUE; // Required field
		$this->codigo_producto->Sortable = TRUE; // Allow sort
		$this->fields['codigo_producto'] = &$this->codigo_producto;

		// nombre_producto
		$this->nombre_producto = new DbField('lotes', 'lotes', 'x_nombre_producto', 'nombre_producto', '`nombre_producto`', '`nombre_producto`', 200, 200, -1, FALSE, '`nombre_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombre_producto->Sortable = TRUE; // Allow sort
		$this->fields['nombre_producto'] = &$this->nombre_producto;

		// status_producto
		$this->status_producto = new DbField('lotes', 'lotes', 'x_status_producto', 'status_producto', '`status_producto`', '`status_producto`', 16, 4, -1, FALSE, '`status_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status_producto->Sortable = TRUE; // Allow sort
		$this->status_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status_producto'] = &$this->status_producto;

		// date_added
		$this->date_added = new DbField('lotes', 'lotes', 'x_date_added', 'date_added', '`date_added`', CastDateFieldForLike("`date_added`", 0, "DB"), 135, 19, 0, FALSE, '`date_added`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date_added->Sortable = TRUE; // Allow sort
		$this->date_added->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['date_added'] = &$this->date_added;

		// precio_producto
		$this->precio_producto = new DbField('lotes', 'lotes', 'x_precio_producto', 'precio_producto', '`precio_producto`', '`precio_producto`', 131, 12, -1, FALSE, '`precio_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio_producto->Sortable = TRUE; // Allow sort
		$this->precio_producto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio_producto'] = &$this->precio_producto;

		// costo_producto
		$this->costo_producto = new DbField('lotes', 'lotes', 'x_costo_producto', 'costo_producto', '`costo_producto`', '`costo_producto`', 131, 12, -1, FALSE, '`costo_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->costo_producto->Sortable = TRUE; // Allow sort
		$this->costo_producto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['costo_producto'] = &$this->costo_producto;

		// mon_costo
		$this->mon_costo = new DbField('lotes', 'lotes', 'x_mon_costo', 'mon_costo', '`mon_costo`', '`mon_costo`', 131, 6, -1, FALSE, '`mon_costo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mon_costo->Sortable = TRUE; // Allow sort
		$this->mon_costo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mon_costo'] = &$this->mon_costo;

		// mon_venta
		$this->mon_venta = new DbField('lotes', 'lotes', 'x_mon_venta', 'mon_venta', '`mon_venta`', '`mon_venta`', 131, 12, -1, FALSE, '`mon_venta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mon_venta->Sortable = TRUE; // Allow sort
		$this->mon_venta->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mon_venta'] = &$this->mon_venta;

		// marca
		$this->marca = new DbField('lotes', 'lotes', 'x_marca', 'marca', '`marca`', '`marca`', 200, 50, -1, FALSE, '`marca`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->marca->Sortable = TRUE; // Allow sort
		$this->fields['marca'] = &$this->marca;

		// modelo
		$this->modelo = new DbField('lotes', 'lotes', 'x_modelo', 'modelo', '`modelo`', '`modelo`', 200, 50, -1, FALSE, '`modelo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->modelo->Sortable = TRUE; // Allow sort
		$this->fields['modelo'] = &$this->modelo;

		// color
		$this->color = new DbField('lotes', 'lotes', 'x_color', 'color', '`color`', '`color`', 200, 50, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Sortable = TRUE; // Allow sort
		$this->fields['color'] = &$this->color;

		// b1
		$this->b1 = new DbField('lotes', 'lotes', 'x_b1', 'b1', '`b1`', '`b1`', 131, 12, -1, FALSE, '`b1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b1->Sortable = TRUE; // Allow sort
		$this->b1->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b1'] = &$this->b1;

		// b2
		$this->b2 = new DbField('lotes', 'lotes', 'x_b2', 'b2', '`b2`', '`b2`', 131, 12, -1, FALSE, '`b2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b2->Sortable = TRUE; // Allow sort
		$this->b2->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b2'] = &$this->b2;

		// b3
		$this->b3 = new DbField('lotes', 'lotes', 'x_b3', 'b3', '`b3`', '`b3`', 131, 12, -1, FALSE, '`b3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b3->Sortable = TRUE; // Allow sort
		$this->b3->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b3'] = &$this->b3;

		// b4
		$this->b4 = new DbField('lotes', 'lotes', 'x_b4', 'b4', '`b4`', '`b4`', 131, 12, -1, FALSE, '`b4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b4->Sortable = TRUE; // Allow sort
		$this->b4->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b4'] = &$this->b4;

		// b5
		$this->b5 = new DbField('lotes', 'lotes', 'x_b5', 'b5', '`b5`', '`b5`', 131, 12, -1, FALSE, '`b5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b5->Sortable = TRUE; // Allow sort
		$this->b5->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b5'] = &$this->b5;

		// b6
		$this->b6 = new DbField('lotes', 'lotes', 'x_b6', 'b6', '`b6`', '`b6`', 131, 12, -1, FALSE, '`b6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b6->Sortable = TRUE; // Allow sort
		$this->b6->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b6'] = &$this->b6;

		// cat_pro
		$this->cat_pro = new DbField('lotes', 'lotes', 'x_cat_pro', 'cat_pro', '`cat_pro`', '`cat_pro`', 3, 11, -1, FALSE, '`cat_pro`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cat_pro->Sortable = TRUE; // Allow sort
		$this->cat_pro->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cat_pro'] = &$this->cat_pro;

		// pro_ser
		$this->pro_ser = new DbField('lotes', 'lotes', 'x_pro_ser', 'pro_ser', '`pro_ser`', '`pro_ser`', 3, 11, -1, FALSE, '`pro_ser`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pro_ser->Sortable = TRUE; // Allow sort
		$this->pro_ser->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pro_ser'] = &$this->pro_ser;

		// foto1
		$this->foto1 = new DbField('lotes', 'lotes', 'x_foto1', 'foto1', '`foto1`', '`foto1`', 200, 100, -1, FALSE, '`foto1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto1->Sortable = TRUE; // Allow sort
		$this->fields['foto1'] = &$this->foto1;

		// foto2
		$this->foto2 = new DbField('lotes', 'lotes', 'x_foto2', 'foto2', '`foto2`', '`foto2`', 200, 100, -1, FALSE, '`foto2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto2->Sortable = TRUE; // Allow sort
		$this->fields['foto2'] = &$this->foto2;

		// foto3
		$this->foto3 = new DbField('lotes', 'lotes', 'x_foto3', 'foto3', '`foto3`', '`foto3`', 200, 100, -1, FALSE, '`foto3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto3->Sortable = TRUE; // Allow sort
		$this->fields['foto3'] = &$this->foto3;

		// foto4
		$this->foto4 = new DbField('lotes', 'lotes', 'x_foto4', 'foto4', '`foto4`', '`foto4`', 200, 100, -1, FALSE, '`foto4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto4->Sortable = TRUE; // Allow sort
		$this->fields['foto4'] = &$this->foto4;

		// web
		$this->web = new DbField('lotes', 'lotes', 'x_web', 'web', '`web`', '`web`', 3, 11, -1, FALSE, '`web`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->web->Sortable = TRUE; // Allow sort
		$this->web->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['web'] = &$this->web;

		// pre_web
		$this->pre_web = new DbField('lotes', 'lotes', 'x_pre_web', 'pre_web', '`pre_web`', '`pre_web`', 131, 12, -1, FALSE, '`pre_web`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pre_web->Sortable = TRUE; // Allow sort
		$this->pre_web->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pre_web'] = &$this->pre_web;

		// descripcion
		$this->descripcion = new DbField('lotes', 'lotes', 'x_descripcion', 'descripcion', '`descripcion`', '`descripcion`', 201, 65535, -1, FALSE, '`descripcion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->descripcion->Sortable = TRUE; // Allow sort
		$this->fields['descripcion'] = &$this->descripcion;

		// descripcion1
		$this->descripcion1 = new DbField('lotes', 'lotes', 'x_descripcion1', 'descripcion1', '`descripcion1`', '`descripcion1`', 201, 65535, -1, FALSE, '`descripcion1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->descripcion1->Sortable = TRUE; // Allow sort
		$this->fields['descripcion1'] = &$this->descripcion1;

		// megusta
		$this->megusta = new DbField('lotes', 'lotes', 'x_megusta', 'megusta', '`megusta`', '`megusta`', 3, 11, -1, FALSE, '`megusta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->megusta->Sortable = TRUE; // Allow sort
		$this->megusta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['megusta'] = &$this->megusta;

		// nomegusta
		$this->nomegusta = new DbField('lotes', 'lotes', 'x_nomegusta', 'nomegusta', '`nomegusta`', '`nomegusta`', 3, 11, -1, FALSE, '`nomegusta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomegusta->Sortable = TRUE; // Allow sort
		$this->nomegusta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['nomegusta'] = &$this->nomegusta;

		// precio2
		$this->precio2 = new DbField('lotes', 'lotes', 'x_precio2', 'precio2', '`precio2`', '`precio2`', 131, 12, -1, FALSE, '`precio2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio2->Sortable = TRUE; // Allow sort
		$this->precio2->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio2'] = &$this->precio2;

		// precio3
		$this->precio3 = new DbField('lotes', 'lotes', 'x_precio3', 'precio3', '`precio3`', '`precio3`', 131, 12, -1, FALSE, '`precio3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio3->Sortable = TRUE; // Allow sort
		$this->precio3->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio3'] = &$this->precio3;

		// und_pro
		$this->und_pro = new DbField('lotes', 'lotes', 'x_und_pro', 'und_pro', '`und_pro`', '`und_pro`', 3, 11, -1, FALSE, '`und_pro`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->und_pro->Sortable = TRUE; // Allow sort
		$this->und_pro->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['und_pro'] = &$this->und_pro;

		// barras
		$this->barras = new DbField('lotes', 'lotes', 'x_barras', 'barras', '`barras`', '`barras`', 200, 20, -1, FALSE, '`barras`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->barras->Sortable = TRUE; // Allow sort
		$this->fields['barras'] = &$this->barras;

		// stockmin
		$this->stockmin = new DbField('lotes', 'lotes', 'x_stockmin', 'stockmin', '`stockmin`', '`stockmin`', 131, 10, -1, FALSE, '`stockmin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stockmin->Sortable = TRUE; // Allow sort
		$this->stockmin->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stockmin'] = &$this->stockmin;

		// id_grupo
		$this->id_grupo = new DbField('lotes', 'lotes', 'x_id_grupo', 'id_grupo', '`id_grupo`', '`id_grupo`', 3, 11, -1, FALSE, '`id_grupo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_grupo->Sortable = TRUE; // Allow sort
		$this->id_grupo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_grupo'] = &$this->id_grupo;

		// talla
		$this->talla = new DbField('lotes', 'lotes', 'x_talla', 'talla', '`talla`', '`talla`', 200, 110, -1, FALSE, '`talla`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->talla->Sortable = TRUE; // Allow sort
		$this->fields['talla'] = &$this->talla;

		// mostrarcolor
		$this->mostrarcolor = new DbField('lotes', 'lotes', 'x_mostrarcolor', 'mostrarcolor', '`mostrarcolor`', '`mostrarcolor`', 3, 11, -1, FALSE, '`mostrarcolor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mostrarcolor->Sortable = TRUE; // Allow sort
		$this->mostrarcolor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mostrarcolor'] = &$this->mostrarcolor;

		// lote
		$this->lote = new DbField('lotes', 'lotes', 'x_lote', 'lote', '`lote`', '`lote`', 200, 10, -1, FALSE, '`lote`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lote->Sortable = TRUE; // Allow sort
		$this->fields['lote'] = &$this->lote;

		// manzana
		$this->manzana = new DbField('lotes', 'lotes', 'x_manzana', 'manzana', '`manzana`', '`manzana`', 200, 10, -1, FALSE, '`manzana`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->manzana->Sortable = TRUE; // Allow sort
		$this->fields['manzana'] = &$this->manzana;

		// etapa
		$this->etapa = new DbField('lotes', 'lotes', 'x_etapa', 'etapa', '`etapa`', '`etapa`', 3, 11, -1, FALSE, '`etapa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->etapa->Sortable = TRUE; // Allow sort
		$this->etapa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['etapa'] = &$this->etapa;

		// estado
		$this->estado = new DbField('lotes', 'lotes', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// icon
		$this->icon = new DbField('lotes', 'lotes', 'x_icon', 'icon', '`icon`', '`icon`', 200, 255, -1, FALSE, '`icon`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->icon->Sortable = TRUE; // Allow sort
		$this->fields['icon'] = &$this->icon;

		// topy
		$this->topy = new DbField('lotes', 'lotes', 'x_topy', 'topy', '`topy`', '`topy`', 200, 255, -1, FALSE, '`topy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->topy->Sortable = TRUE; // Allow sort
		$this->fields['topy'] = &$this->topy;

		// leftx
		$this->leftx = new DbField('lotes', 'lotes', 'x_leftx', 'leftx', '`leftx`', '`leftx`', 200, 255, -1, FALSE, '`leftx`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->leftx->Sortable = TRUE; // Allow sort
		$this->fields['leftx'] = &$this->leftx;

		// codlogin
		$this->codlogin = new DbField('lotes', 'lotes', 'x_codlogin', 'codlogin', '`codlogin`', '`codlogin`', 200, 100, -1, FALSE, '`codlogin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codlogin->Sortable = TRUE; // Allow sort
		$this->fields['codlogin'] = &$this->codlogin;

		// id_cliente
		$this->id_cliente = new DbField('lotes', 'lotes', 'x_id_cliente', 'id_cliente', '`id_cliente`', '`id_cliente`', 3, 11, -1, FALSE, '`id_cliente`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_cliente->Sortable = TRUE; // Allow sort
		$this->id_cliente->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_cliente'] = &$this->id_cliente;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`lotes`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_producto->setDbValue($conn->insert_ID());
			$rs['id_producto'] = $this->id_producto->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_producto', $rs))
				AddFilter($where, QuotedName('id_producto', $this->Dbid) . '=' . QuotedValue($rs['id_producto'], $this->id_producto->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_producto->DbValue = $row['id_producto'];
		$this->id_proyecto->DbValue = $row['id_proyecto'];
		$this->codigo_producto->DbValue = $row['codigo_producto'];
		$this->nombre_producto->DbValue = $row['nombre_producto'];
		$this->status_producto->DbValue = $row['status_producto'];
		$this->date_added->DbValue = $row['date_added'];
		$this->precio_producto->DbValue = $row['precio_producto'];
		$this->costo_producto->DbValue = $row['costo_producto'];
		$this->mon_costo->DbValue = $row['mon_costo'];
		$this->mon_venta->DbValue = $row['mon_venta'];
		$this->marca->DbValue = $row['marca'];
		$this->modelo->DbValue = $row['modelo'];
		$this->color->DbValue = $row['color'];
		$this->b1->DbValue = $row['b1'];
		$this->b2->DbValue = $row['b2'];
		$this->b3->DbValue = $row['b3'];
		$this->b4->DbValue = $row['b4'];
		$this->b5->DbValue = $row['b5'];
		$this->b6->DbValue = $row['b6'];
		$this->cat_pro->DbValue = $row['cat_pro'];
		$this->pro_ser->DbValue = $row['pro_ser'];
		$this->foto1->DbValue = $row['foto1'];
		$this->foto2->DbValue = $row['foto2'];
		$this->foto3->DbValue = $row['foto3'];
		$this->foto4->DbValue = $row['foto4'];
		$this->web->DbValue = $row['web'];
		$this->pre_web->DbValue = $row['pre_web'];
		$this->descripcion->DbValue = $row['descripcion'];
		$this->descripcion1->DbValue = $row['descripcion1'];
		$this->megusta->DbValue = $row['megusta'];
		$this->nomegusta->DbValue = $row['nomegusta'];
		$this->precio2->DbValue = $row['precio2'];
		$this->precio3->DbValue = $row['precio3'];
		$this->und_pro->DbValue = $row['und_pro'];
		$this->barras->DbValue = $row['barras'];
		$this->stockmin->DbValue = $row['stockmin'];
		$this->id_grupo->DbValue = $row['id_grupo'];
		$this->talla->DbValue = $row['talla'];
		$this->mostrarcolor->DbValue = $row['mostrarcolor'];
		$this->lote->DbValue = $row['lote'];
		$this->manzana->DbValue = $row['manzana'];
		$this->etapa->DbValue = $row['etapa'];
		$this->estado->DbValue = $row['estado'];
		$this->icon->DbValue = $row['icon'];
		$this->topy->DbValue = $row['topy'];
		$this->leftx->DbValue = $row['leftx'];
		$this->codlogin->DbValue = $row['codlogin'];
		$this->id_cliente->DbValue = $row['id_cliente'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_producto` = @id_producto@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_producto', $row) ? $row['id_producto'] : NULL;
		else
			$val = $this->id_producto->OldValue !== NULL ? $this->id_producto->OldValue : $this->id_producto->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_producto@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "loteslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "lotesview.php")
			return $Language->phrase("View");
		elseif ($pageName == "lotesedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "lotesadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "loteslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("lotesview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("lotesview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "lotesadd.php?" . $this->getUrlParm($parm);
		else
			$url = "lotesadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("lotesedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("lotesadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("lotesdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_producto:" . JsonEncode($this->id_producto->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_producto->CurrentValue != NULL) {
			$url .= "id_producto=" . urlencode($this->id_producto->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_producto") !== NULL)
				$arKeys[] = Param("id_producto");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_producto->CurrentValue = $key;
			else
				$this->id_producto->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_producto->setDbValue($rs->fields('id_producto'));
		$this->id_proyecto->setDbValue($rs->fields('id_proyecto'));
		$this->codigo_producto->setDbValue($rs->fields('codigo_producto'));
		$this->nombre_producto->setDbValue($rs->fields('nombre_producto'));
		$this->status_producto->setDbValue($rs->fields('status_producto'));
		$this->date_added->setDbValue($rs->fields('date_added'));
		$this->precio_producto->setDbValue($rs->fields('precio_producto'));
		$this->costo_producto->setDbValue($rs->fields('costo_producto'));
		$this->mon_costo->setDbValue($rs->fields('mon_costo'));
		$this->mon_venta->setDbValue($rs->fields('mon_venta'));
		$this->marca->setDbValue($rs->fields('marca'));
		$this->modelo->setDbValue($rs->fields('modelo'));
		$this->color->setDbValue($rs->fields('color'));
		$this->b1->setDbValue($rs->fields('b1'));
		$this->b2->setDbValue($rs->fields('b2'));
		$this->b3->setDbValue($rs->fields('b3'));
		$this->b4->setDbValue($rs->fields('b4'));
		$this->b5->setDbValue($rs->fields('b5'));
		$this->b6->setDbValue($rs->fields('b6'));
		$this->cat_pro->setDbValue($rs->fields('cat_pro'));
		$this->pro_ser->setDbValue($rs->fields('pro_ser'));
		$this->foto1->setDbValue($rs->fields('foto1'));
		$this->foto2->setDbValue($rs->fields('foto2'));
		$this->foto3->setDbValue($rs->fields('foto3'));
		$this->foto4->setDbValue($rs->fields('foto4'));
		$this->web->setDbValue($rs->fields('web'));
		$this->pre_web->setDbValue($rs->fields('pre_web'));
		$this->descripcion->setDbValue($rs->fields('descripcion'));
		$this->descripcion1->setDbValue($rs->fields('descripcion1'));
		$this->megusta->setDbValue($rs->fields('megusta'));
		$this->nomegusta->setDbValue($rs->fields('nomegusta'));
		$this->precio2->setDbValue($rs->fields('precio2'));
		$this->precio3->setDbValue($rs->fields('precio3'));
		$this->und_pro->setDbValue($rs->fields('und_pro'));
		$this->barras->setDbValue($rs->fields('barras'));
		$this->stockmin->setDbValue($rs->fields('stockmin'));
		$this->id_grupo->setDbValue($rs->fields('id_grupo'));
		$this->talla->setDbValue($rs->fields('talla'));
		$this->mostrarcolor->setDbValue($rs->fields('mostrarcolor'));
		$this->lote->setDbValue($rs->fields('lote'));
		$this->manzana->setDbValue($rs->fields('manzana'));
		$this->etapa->setDbValue($rs->fields('etapa'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->icon->setDbValue($rs->fields('icon'));
		$this->topy->setDbValue($rs->fields('topy'));
		$this->leftx->setDbValue($rs->fields('leftx'));
		$this->codlogin->setDbValue($rs->fields('codlogin'));
		$this->id_cliente->setDbValue($rs->fields('id_cliente'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_producto
		// id_proyecto
		// codigo_producto
		// nombre_producto
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// lote
		// manzana
		// etapa
		// estado
		// icon
		// topy
		// leftx
		// codlogin
		// id_cliente
		// id_producto

		$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewCustomAttributes = "";

		// id_proyecto
		$this->id_proyecto->ViewValue = $this->id_proyecto->CurrentValue;
		$this->id_proyecto->ViewValue = FormatNumber($this->id_proyecto->ViewValue, 0, -2, -2, -2);
		$this->id_proyecto->ViewCustomAttributes = "";

		// codigo_producto
		$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
		$this->codigo_producto->ViewCustomAttributes = "";

		// nombre_producto
		$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
		$this->nombre_producto->ViewCustomAttributes = "";

		// status_producto
		$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
		$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
		$this->status_producto->ViewCustomAttributes = "";

		// date_added
		$this->date_added->ViewValue = $this->date_added->CurrentValue;
		$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
		$this->date_added->ViewCustomAttributes = "";

		// precio_producto
		$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
		$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
		$this->precio_producto->ViewCustomAttributes = "";

		// costo_producto
		$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
		$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
		$this->costo_producto->ViewCustomAttributes = "";

		// mon_costo
		$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
		$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
		$this->mon_costo->ViewCustomAttributes = "";

		// mon_venta
		$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
		$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 2, -2, -2, -2);
		$this->mon_venta->ViewCustomAttributes = "";

		// marca
		$this->marca->ViewValue = $this->marca->CurrentValue;
		$this->marca->ViewCustomAttributes = "";

		// modelo
		$this->modelo->ViewValue = $this->modelo->CurrentValue;
		$this->modelo->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// b1
		$this->b1->ViewValue = $this->b1->CurrentValue;
		$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
		$this->b1->ViewCustomAttributes = "";

		// b2
		$this->b2->ViewValue = $this->b2->CurrentValue;
		$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
		$this->b2->ViewCustomAttributes = "";

		// b3
		$this->b3->ViewValue = $this->b3->CurrentValue;
		$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
		$this->b3->ViewCustomAttributes = "";

		// b4
		$this->b4->ViewValue = $this->b4->CurrentValue;
		$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
		$this->b4->ViewCustomAttributes = "";

		// b5
		$this->b5->ViewValue = $this->b5->CurrentValue;
		$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
		$this->b5->ViewCustomAttributes = "";

		// b6
		$this->b6->ViewValue = $this->b6->CurrentValue;
		$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
		$this->b6->ViewCustomAttributes = "";

		// cat_pro
		$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
		$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
		$this->cat_pro->ViewCustomAttributes = "";

		// pro_ser
		$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
		$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
		$this->pro_ser->ViewCustomAttributes = "";

		// foto1
		$this->foto1->ViewValue = $this->foto1->CurrentValue;
		$this->foto1->ViewCustomAttributes = "";

		// foto2
		$this->foto2->ViewValue = $this->foto2->CurrentValue;
		$this->foto2->ViewCustomAttributes = "";

		// foto3
		$this->foto3->ViewValue = $this->foto3->CurrentValue;
		$this->foto3->ViewCustomAttributes = "";

		// foto4
		$this->foto4->ViewValue = $this->foto4->CurrentValue;
		$this->foto4->ViewCustomAttributes = "";

		// web
		$this->web->ViewValue = $this->web->CurrentValue;
		$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
		$this->web->ViewCustomAttributes = "";

		// pre_web
		$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
		$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
		$this->pre_web->ViewCustomAttributes = "";

		// descripcion
		$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
		$this->descripcion->ViewCustomAttributes = "";

		// descripcion1
		$this->descripcion1->ViewValue = $this->descripcion1->CurrentValue;
		$this->descripcion1->ViewCustomAttributes = "";

		// megusta
		$this->megusta->ViewValue = $this->megusta->CurrentValue;
		$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
		$this->megusta->ViewCustomAttributes = "";

		// nomegusta
		$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
		$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
		$this->nomegusta->ViewCustomAttributes = "";

		// precio2
		$this->precio2->ViewValue = $this->precio2->CurrentValue;
		$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
		$this->precio2->ViewCustomAttributes = "";

		// precio3
		$this->precio3->ViewValue = $this->precio3->CurrentValue;
		$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
		$this->precio3->ViewCustomAttributes = "";

		// und_pro
		$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
		$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
		$this->und_pro->ViewCustomAttributes = "";

		// barras
		$this->barras->ViewValue = $this->barras->CurrentValue;
		$this->barras->ViewCustomAttributes = "";

		// stockmin
		$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
		$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
		$this->stockmin->ViewCustomAttributes = "";

		// id_grupo
		$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
		$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
		$this->id_grupo->ViewCustomAttributes = "";

		// talla
		$this->talla->ViewValue = $this->talla->CurrentValue;
		$this->talla->ViewCustomAttributes = "";

		// mostrarcolor
		$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
		$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
		$this->mostrarcolor->ViewCustomAttributes = "";

		// lote
		$this->lote->ViewValue = $this->lote->CurrentValue;
		$this->lote->ViewCustomAttributes = "";

		// manzana
		$this->manzana->ViewValue = $this->manzana->CurrentValue;
		$this->manzana->ViewCustomAttributes = "";

		// etapa
		$this->etapa->ViewValue = $this->etapa->CurrentValue;
		$this->etapa->ViewValue = FormatNumber($this->etapa->ViewValue, 0, -2, -2, -2);
		$this->etapa->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// icon
		$this->icon->ViewValue = $this->icon->CurrentValue;
		$this->icon->ViewCustomAttributes = "";

		// topy
		$this->topy->ViewValue = $this->topy->CurrentValue;
		$this->topy->ViewCustomAttributes = "";

		// leftx
		$this->leftx->ViewValue = $this->leftx->CurrentValue;
		$this->leftx->ViewCustomAttributes = "";

		// codlogin
		$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
		$this->codlogin->ViewCustomAttributes = "";

		// id_cliente
		$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
		$this->id_cliente->ViewValue = FormatNumber($this->id_cliente->ViewValue, 0, -2, -2, -2);
		$this->id_cliente->ViewCustomAttributes = "";

		// id_producto
		$this->id_producto->LinkCustomAttributes = "";
		$this->id_producto->HrefValue = "";
		$this->id_producto->TooltipValue = "";

		// id_proyecto
		$this->id_proyecto->LinkCustomAttributes = "";
		$this->id_proyecto->HrefValue = "";
		$this->id_proyecto->TooltipValue = "";

		// codigo_producto
		$this->codigo_producto->LinkCustomAttributes = "";
		$this->codigo_producto->HrefValue = "";
		$this->codigo_producto->TooltipValue = "";

		// nombre_producto
		$this->nombre_producto->LinkCustomAttributes = "";
		$this->nombre_producto->HrefValue = "";
		$this->nombre_producto->TooltipValue = "";

		// status_producto
		$this->status_producto->LinkCustomAttributes = "";
		$this->status_producto->HrefValue = "";
		$this->status_producto->TooltipValue = "";

		// date_added
		$this->date_added->LinkCustomAttributes = "";
		$this->date_added->HrefValue = "";
		$this->date_added->TooltipValue = "";

		// precio_producto
		$this->precio_producto->LinkCustomAttributes = "";
		$this->precio_producto->HrefValue = "";
		$this->precio_producto->TooltipValue = "";

		// costo_producto
		$this->costo_producto->LinkCustomAttributes = "";
		$this->costo_producto->HrefValue = "";
		$this->costo_producto->TooltipValue = "";

		// mon_costo
		$this->mon_costo->LinkCustomAttributes = "";
		$this->mon_costo->HrefValue = "";
		$this->mon_costo->TooltipValue = "";

		// mon_venta
		$this->mon_venta->LinkCustomAttributes = "";
		$this->mon_venta->HrefValue = "";
		$this->mon_venta->TooltipValue = "";

		// marca
		$this->marca->LinkCustomAttributes = "";
		$this->marca->HrefValue = "";
		$this->marca->TooltipValue = "";

		// modelo
		$this->modelo->LinkCustomAttributes = "";
		$this->modelo->HrefValue = "";
		$this->modelo->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// b1
		$this->b1->LinkCustomAttributes = "";
		$this->b1->HrefValue = "";
		$this->b1->TooltipValue = "";

		// b2
		$this->b2->LinkCustomAttributes = "";
		$this->b2->HrefValue = "";
		$this->b2->TooltipValue = "";

		// b3
		$this->b3->LinkCustomAttributes = "";
		$this->b3->HrefValue = "";
		$this->b3->TooltipValue = "";

		// b4
		$this->b4->LinkCustomAttributes = "";
		$this->b4->HrefValue = "";
		$this->b4->TooltipValue = "";

		// b5
		$this->b5->LinkCustomAttributes = "";
		$this->b5->HrefValue = "";
		$this->b5->TooltipValue = "";

		// b6
		$this->b6->LinkCustomAttributes = "";
		$this->b6->HrefValue = "";
		$this->b6->TooltipValue = "";

		// cat_pro
		$this->cat_pro->LinkCustomAttributes = "";
		$this->cat_pro->HrefValue = "";
		$this->cat_pro->TooltipValue = "";

		// pro_ser
		$this->pro_ser->LinkCustomAttributes = "";
		$this->pro_ser->HrefValue = "";
		$this->pro_ser->TooltipValue = "";

		// foto1
		$this->foto1->LinkCustomAttributes = "";
		$this->foto1->HrefValue = "";
		$this->foto1->TooltipValue = "";

		// foto2
		$this->foto2->LinkCustomAttributes = "";
		$this->foto2->HrefValue = "";
		$this->foto2->TooltipValue = "";

		// foto3
		$this->foto3->LinkCustomAttributes = "";
		$this->foto3->HrefValue = "";
		$this->foto3->TooltipValue = "";

		// foto4
		$this->foto4->LinkCustomAttributes = "";
		$this->foto4->HrefValue = "";
		$this->foto4->TooltipValue = "";

		// web
		$this->web->LinkCustomAttributes = "";
		$this->web->HrefValue = "";
		$this->web->TooltipValue = "";

		// pre_web
		$this->pre_web->LinkCustomAttributes = "";
		$this->pre_web->HrefValue = "";
		$this->pre_web->TooltipValue = "";

		// descripcion
		$this->descripcion->LinkCustomAttributes = "";
		$this->descripcion->HrefValue = "";
		$this->descripcion->TooltipValue = "";

		// descripcion1
		$this->descripcion1->LinkCustomAttributes = "";
		$this->descripcion1->HrefValue = "";
		$this->descripcion1->TooltipValue = "";

		// megusta
		$this->megusta->LinkCustomAttributes = "";
		$this->megusta->HrefValue = "";
		$this->megusta->TooltipValue = "";

		// nomegusta
		$this->nomegusta->LinkCustomAttributes = "";
		$this->nomegusta->HrefValue = "";
		$this->nomegusta->TooltipValue = "";

		// precio2
		$this->precio2->LinkCustomAttributes = "";
		$this->precio2->HrefValue = "";
		$this->precio2->TooltipValue = "";

		// precio3
		$this->precio3->LinkCustomAttributes = "";
		$this->precio3->HrefValue = "";
		$this->precio3->TooltipValue = "";

		// und_pro
		$this->und_pro->LinkCustomAttributes = "";
		$this->und_pro->HrefValue = "";
		$this->und_pro->TooltipValue = "";

		// barras
		$this->barras->LinkCustomAttributes = "";
		$this->barras->HrefValue = "";
		$this->barras->TooltipValue = "";

		// stockmin
		$this->stockmin->LinkCustomAttributes = "";
		$this->stockmin->HrefValue = "";
		$this->stockmin->TooltipValue = "";

		// id_grupo
		$this->id_grupo->LinkCustomAttributes = "";
		$this->id_grupo->HrefValue = "";
		$this->id_grupo->TooltipValue = "";

		// talla
		$this->talla->LinkCustomAttributes = "";
		$this->talla->HrefValue = "";
		$this->talla->TooltipValue = "";

		// mostrarcolor
		$this->mostrarcolor->LinkCustomAttributes = "";
		$this->mostrarcolor->HrefValue = "";
		$this->mostrarcolor->TooltipValue = "";

		// lote
		$this->lote->LinkCustomAttributes = "";
		$this->lote->HrefValue = "";
		$this->lote->TooltipValue = "";

		// manzana
		$this->manzana->LinkCustomAttributes = "";
		$this->manzana->HrefValue = "";
		$this->manzana->TooltipValue = "";

		// etapa
		$this->etapa->LinkCustomAttributes = "";
		$this->etapa->HrefValue = "";
		$this->etapa->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// icon
		$this->icon->LinkCustomAttributes = "";
		$this->icon->HrefValue = "";
		$this->icon->TooltipValue = "";

		// topy
		$this->topy->LinkCustomAttributes = "";
		$this->topy->HrefValue = "";
		$this->topy->TooltipValue = "";

		// leftx
		$this->leftx->LinkCustomAttributes = "";
		$this->leftx->HrefValue = "";
		$this->leftx->TooltipValue = "";

		// codlogin
		$this->codlogin->LinkCustomAttributes = "";
		$this->codlogin->HrefValue = "";
		$this->codlogin->TooltipValue = "";

		// id_cliente
		$this->id_cliente->LinkCustomAttributes = "";
		$this->id_cliente->HrefValue = "";
		$this->id_cliente->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_producto
		$this->id_producto->EditAttrs["class"] = "form-control";
		$this->id_producto->EditCustomAttributes = "";
		$this->id_producto->EditValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewCustomAttributes = "";

		// id_proyecto
		$this->id_proyecto->EditAttrs["class"] = "form-control";
		$this->id_proyecto->EditCustomAttributes = "";
		$this->id_proyecto->EditValue = $this->id_proyecto->CurrentValue;
		$this->id_proyecto->PlaceHolder = RemoveHtml($this->id_proyecto->caption());

		// codigo_producto
		$this->codigo_producto->EditAttrs["class"] = "form-control";
		$this->codigo_producto->EditCustomAttributes = "";
		if (!$this->codigo_producto->Raw)
			$this->codigo_producto->CurrentValue = HtmlDecode($this->codigo_producto->CurrentValue);
		$this->codigo_producto->EditValue = $this->codigo_producto->CurrentValue;
		$this->codigo_producto->PlaceHolder = RemoveHtml($this->codigo_producto->caption());

		// nombre_producto
		$this->nombre_producto->EditAttrs["class"] = "form-control";
		$this->nombre_producto->EditCustomAttributes = "";
		if (!$this->nombre_producto->Raw)
			$this->nombre_producto->CurrentValue = HtmlDecode($this->nombre_producto->CurrentValue);
		$this->nombre_producto->EditValue = $this->nombre_producto->CurrentValue;
		$this->nombre_producto->PlaceHolder = RemoveHtml($this->nombre_producto->caption());

		// status_producto
		$this->status_producto->EditAttrs["class"] = "form-control";
		$this->status_producto->EditCustomAttributes = "";
		$this->status_producto->EditValue = $this->status_producto->CurrentValue;
		$this->status_producto->PlaceHolder = RemoveHtml($this->status_producto->caption());

		// date_added
		$this->date_added->EditAttrs["class"] = "form-control";
		$this->date_added->EditCustomAttributes = "";
		$this->date_added->EditValue = FormatDateTime($this->date_added->CurrentValue, 8);
		$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

		// precio_producto
		$this->precio_producto->EditAttrs["class"] = "form-control";
		$this->precio_producto->EditCustomAttributes = "";
		$this->precio_producto->EditValue = $this->precio_producto->CurrentValue;
		$this->precio_producto->PlaceHolder = RemoveHtml($this->precio_producto->caption());
		if (strval($this->precio_producto->EditValue) != "" && is_numeric($this->precio_producto->EditValue))
			$this->precio_producto->EditValue = FormatNumber($this->precio_producto->EditValue, -2, -2, -2, -2);
		

		// costo_producto
		$this->costo_producto->EditAttrs["class"] = "form-control";
		$this->costo_producto->EditCustomAttributes = "";
		$this->costo_producto->EditValue = $this->costo_producto->CurrentValue;
		$this->costo_producto->PlaceHolder = RemoveHtml($this->costo_producto->caption());
		if (strval($this->costo_producto->EditValue) != "" && is_numeric($this->costo_producto->EditValue))
			$this->costo_producto->EditValue = FormatNumber($this->costo_producto->EditValue, -2, -2, -2, -2);
		

		// mon_costo
		$this->mon_costo->EditAttrs["class"] = "form-control";
		$this->mon_costo->EditCustomAttributes = "";
		$this->mon_costo->EditValue = $this->mon_costo->CurrentValue;
		$this->mon_costo->PlaceHolder = RemoveHtml($this->mon_costo->caption());
		if (strval($this->mon_costo->EditValue) != "" && is_numeric($this->mon_costo->EditValue))
			$this->mon_costo->EditValue = FormatNumber($this->mon_costo->EditValue, -2, -2, -2, -2);
		

		// mon_venta
		$this->mon_venta->EditAttrs["class"] = "form-control";
		$this->mon_venta->EditCustomAttributes = "";
		$this->mon_venta->EditValue = $this->mon_venta->CurrentValue;
		$this->mon_venta->PlaceHolder = RemoveHtml($this->mon_venta->caption());
		if (strval($this->mon_venta->EditValue) != "" && is_numeric($this->mon_venta->EditValue))
			$this->mon_venta->EditValue = FormatNumber($this->mon_venta->EditValue, -2, -2, -2, -2);
		

		// marca
		$this->marca->EditAttrs["class"] = "form-control";
		$this->marca->EditCustomAttributes = "";
		if (!$this->marca->Raw)
			$this->marca->CurrentValue = HtmlDecode($this->marca->CurrentValue);
		$this->marca->EditValue = $this->marca->CurrentValue;
		$this->marca->PlaceHolder = RemoveHtml($this->marca->caption());

		// modelo
		$this->modelo->EditAttrs["class"] = "form-control";
		$this->modelo->EditCustomAttributes = "";
		if (!$this->modelo->Raw)
			$this->modelo->CurrentValue = HtmlDecode($this->modelo->CurrentValue);
		$this->modelo->EditValue = $this->modelo->CurrentValue;
		$this->modelo->PlaceHolder = RemoveHtml($this->modelo->caption());

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		if (!$this->color->Raw)
			$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->PlaceHolder = RemoveHtml($this->color->caption());

		// b1
		$this->b1->EditAttrs["class"] = "form-control";
		$this->b1->EditCustomAttributes = "";
		$this->b1->EditValue = $this->b1->CurrentValue;
		$this->b1->PlaceHolder = RemoveHtml($this->b1->caption());
		if (strval($this->b1->EditValue) != "" && is_numeric($this->b1->EditValue))
			$this->b1->EditValue = FormatNumber($this->b1->EditValue, -2, -2, -2, -2);
		

		// b2
		$this->b2->EditAttrs["class"] = "form-control";
		$this->b2->EditCustomAttributes = "";
		$this->b2->EditValue = $this->b2->CurrentValue;
		$this->b2->PlaceHolder = RemoveHtml($this->b2->caption());
		if (strval($this->b2->EditValue) != "" && is_numeric($this->b2->EditValue))
			$this->b2->EditValue = FormatNumber($this->b2->EditValue, -2, -2, -2, -2);
		

		// b3
		$this->b3->EditAttrs["class"] = "form-control";
		$this->b3->EditCustomAttributes = "";
		$this->b3->EditValue = $this->b3->CurrentValue;
		$this->b3->PlaceHolder = RemoveHtml($this->b3->caption());
		if (strval($this->b3->EditValue) != "" && is_numeric($this->b3->EditValue))
			$this->b3->EditValue = FormatNumber($this->b3->EditValue, -2, -2, -2, -2);
		

		// b4
		$this->b4->EditAttrs["class"] = "form-control";
		$this->b4->EditCustomAttributes = "";
		$this->b4->EditValue = $this->b4->CurrentValue;
		$this->b4->PlaceHolder = RemoveHtml($this->b4->caption());
		if (strval($this->b4->EditValue) != "" && is_numeric($this->b4->EditValue))
			$this->b4->EditValue = FormatNumber($this->b4->EditValue, -2, -2, -2, -2);
		

		// b5
		$this->b5->EditAttrs["class"] = "form-control";
		$this->b5->EditCustomAttributes = "";
		$this->b5->EditValue = $this->b5->CurrentValue;
		$this->b5->PlaceHolder = RemoveHtml($this->b5->caption());
		if (strval($this->b5->EditValue) != "" && is_numeric($this->b5->EditValue))
			$this->b5->EditValue = FormatNumber($this->b5->EditValue, -2, -2, -2, -2);
		

		// b6
		$this->b6->EditAttrs["class"] = "form-control";
		$this->b6->EditCustomAttributes = "";
		$this->b6->EditValue = $this->b6->CurrentValue;
		$this->b6->PlaceHolder = RemoveHtml($this->b6->caption());
		if (strval($this->b6->EditValue) != "" && is_numeric($this->b6->EditValue))
			$this->b6->EditValue = FormatNumber($this->b6->EditValue, -2, -2, -2, -2);
		

		// cat_pro
		$this->cat_pro->EditAttrs["class"] = "form-control";
		$this->cat_pro->EditCustomAttributes = "";
		$this->cat_pro->EditValue = $this->cat_pro->CurrentValue;
		$this->cat_pro->PlaceHolder = RemoveHtml($this->cat_pro->caption());

		// pro_ser
		$this->pro_ser->EditAttrs["class"] = "form-control";
		$this->pro_ser->EditCustomAttributes = "";
		$this->pro_ser->EditValue = $this->pro_ser->CurrentValue;
		$this->pro_ser->PlaceHolder = RemoveHtml($this->pro_ser->caption());

		// foto1
		$this->foto1->EditAttrs["class"] = "form-control";
		$this->foto1->EditCustomAttributes = "";
		if (!$this->foto1->Raw)
			$this->foto1->CurrentValue = HtmlDecode($this->foto1->CurrentValue);
		$this->foto1->EditValue = $this->foto1->CurrentValue;
		$this->foto1->PlaceHolder = RemoveHtml($this->foto1->caption());

		// foto2
		$this->foto2->EditAttrs["class"] = "form-control";
		$this->foto2->EditCustomAttributes = "";
		if (!$this->foto2->Raw)
			$this->foto2->CurrentValue = HtmlDecode($this->foto2->CurrentValue);
		$this->foto2->EditValue = $this->foto2->CurrentValue;
		$this->foto2->PlaceHolder = RemoveHtml($this->foto2->caption());

		// foto3
		$this->foto3->EditAttrs["class"] = "form-control";
		$this->foto3->EditCustomAttributes = "";
		if (!$this->foto3->Raw)
			$this->foto3->CurrentValue = HtmlDecode($this->foto3->CurrentValue);
		$this->foto3->EditValue = $this->foto3->CurrentValue;
		$this->foto3->PlaceHolder = RemoveHtml($this->foto3->caption());

		// foto4
		$this->foto4->EditAttrs["class"] = "form-control";
		$this->foto4->EditCustomAttributes = "";
		if (!$this->foto4->Raw)
			$this->foto4->CurrentValue = HtmlDecode($this->foto4->CurrentValue);
		$this->foto4->EditValue = $this->foto4->CurrentValue;
		$this->foto4->PlaceHolder = RemoveHtml($this->foto4->caption());

		// web
		$this->web->EditAttrs["class"] = "form-control";
		$this->web->EditCustomAttributes = "";
		$this->web->EditValue = $this->web->CurrentValue;
		$this->web->PlaceHolder = RemoveHtml($this->web->caption());

		// pre_web
		$this->pre_web->EditAttrs["class"] = "form-control";
		$this->pre_web->EditCustomAttributes = "";
		$this->pre_web->EditValue = $this->pre_web->CurrentValue;
		$this->pre_web->PlaceHolder = RemoveHtml($this->pre_web->caption());
		if (strval($this->pre_web->EditValue) != "" && is_numeric($this->pre_web->EditValue))
			$this->pre_web->EditValue = FormatNumber($this->pre_web->EditValue, -2, -2, -2, -2);
		

		// descripcion
		$this->descripcion->EditAttrs["class"] = "form-control";
		$this->descripcion->EditCustomAttributes = "";
		$this->descripcion->EditValue = $this->descripcion->CurrentValue;
		$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

		// descripcion1
		$this->descripcion1->EditAttrs["class"] = "form-control";
		$this->descripcion1->EditCustomAttributes = "";
		$this->descripcion1->EditValue = $this->descripcion1->CurrentValue;
		$this->descripcion1->PlaceHolder = RemoveHtml($this->descripcion1->caption());

		// megusta
		$this->megusta->EditAttrs["class"] = "form-control";
		$this->megusta->EditCustomAttributes = "";
		$this->megusta->EditValue = $this->megusta->CurrentValue;
		$this->megusta->PlaceHolder = RemoveHtml($this->megusta->caption());

		// nomegusta
		$this->nomegusta->EditAttrs["class"] = "form-control";
		$this->nomegusta->EditCustomAttributes = "";
		$this->nomegusta->EditValue = $this->nomegusta->CurrentValue;
		$this->nomegusta->PlaceHolder = RemoveHtml($this->nomegusta->caption());

		// precio2
		$this->precio2->EditAttrs["class"] = "form-control";
		$this->precio2->EditCustomAttributes = "";
		$this->precio2->EditValue = $this->precio2->CurrentValue;
		$this->precio2->PlaceHolder = RemoveHtml($this->precio2->caption());
		if (strval($this->precio2->EditValue) != "" && is_numeric($this->precio2->EditValue))
			$this->precio2->EditValue = FormatNumber($this->precio2->EditValue, -2, -2, -2, -2);
		

		// precio3
		$this->precio3->EditAttrs["class"] = "form-control";
		$this->precio3->EditCustomAttributes = "";
		$this->precio3->EditValue = $this->precio3->CurrentValue;
		$this->precio3->PlaceHolder = RemoveHtml($this->precio3->caption());
		if (strval($this->precio3->EditValue) != "" && is_numeric($this->precio3->EditValue))
			$this->precio3->EditValue = FormatNumber($this->precio3->EditValue, -2, -2, -2, -2);
		

		// und_pro
		$this->und_pro->EditAttrs["class"] = "form-control";
		$this->und_pro->EditCustomAttributes = "";
		$this->und_pro->EditValue = $this->und_pro->CurrentValue;
		$this->und_pro->PlaceHolder = RemoveHtml($this->und_pro->caption());

		// barras
		$this->barras->EditAttrs["class"] = "form-control";
		$this->barras->EditCustomAttributes = "";
		if (!$this->barras->Raw)
			$this->barras->CurrentValue = HtmlDecode($this->barras->CurrentValue);
		$this->barras->EditValue = $this->barras->CurrentValue;
		$this->barras->PlaceHolder = RemoveHtml($this->barras->caption());

		// stockmin
		$this->stockmin->EditAttrs["class"] = "form-control";
		$this->stockmin->EditCustomAttributes = "";
		$this->stockmin->EditValue = $this->stockmin->CurrentValue;
		$this->stockmin->PlaceHolder = RemoveHtml($this->stockmin->caption());
		if (strval($this->stockmin->EditValue) != "" && is_numeric($this->stockmin->EditValue))
			$this->stockmin->EditValue = FormatNumber($this->stockmin->EditValue, -2, -2, -2, -2);
		

		// id_grupo
		$this->id_grupo->EditAttrs["class"] = "form-control";
		$this->id_grupo->EditCustomAttributes = "";
		$this->id_grupo->EditValue = $this->id_grupo->CurrentValue;
		$this->id_grupo->PlaceHolder = RemoveHtml($this->id_grupo->caption());

		// talla
		$this->talla->EditAttrs["class"] = "form-control";
		$this->talla->EditCustomAttributes = "";
		if (!$this->talla->Raw)
			$this->talla->CurrentValue = HtmlDecode($this->talla->CurrentValue);
		$this->talla->EditValue = $this->talla->CurrentValue;
		$this->talla->PlaceHolder = RemoveHtml($this->talla->caption());

		// mostrarcolor
		$this->mostrarcolor->EditAttrs["class"] = "form-control";
		$this->mostrarcolor->EditCustomAttributes = "";
		$this->mostrarcolor->EditValue = $this->mostrarcolor->CurrentValue;
		$this->mostrarcolor->PlaceHolder = RemoveHtml($this->mostrarcolor->caption());

		// lote
		$this->lote->EditAttrs["class"] = "form-control";
		$this->lote->EditCustomAttributes = "";
		if (!$this->lote->Raw)
			$this->lote->CurrentValue = HtmlDecode($this->lote->CurrentValue);
		$this->lote->EditValue = $this->lote->CurrentValue;
		$this->lote->PlaceHolder = RemoveHtml($this->lote->caption());

		// manzana
		$this->manzana->EditAttrs["class"] = "form-control";
		$this->manzana->EditCustomAttributes = "";
		if (!$this->manzana->Raw)
			$this->manzana->CurrentValue = HtmlDecode($this->manzana->CurrentValue);
		$this->manzana->EditValue = $this->manzana->CurrentValue;
		$this->manzana->PlaceHolder = RemoveHtml($this->manzana->caption());

		// etapa
		$this->etapa->EditAttrs["class"] = "form-control";
		$this->etapa->EditCustomAttributes = "";
		$this->etapa->EditValue = $this->etapa->CurrentValue;
		$this->etapa->PlaceHolder = RemoveHtml($this->etapa->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// icon
		$this->icon->EditAttrs["class"] = "form-control";
		$this->icon->EditCustomAttributes = "";
		if (!$this->icon->Raw)
			$this->icon->CurrentValue = HtmlDecode($this->icon->CurrentValue);
		$this->icon->EditValue = $this->icon->CurrentValue;
		$this->icon->PlaceHolder = RemoveHtml($this->icon->caption());

		// topy
		$this->topy->EditAttrs["class"] = "form-control";
		$this->topy->EditCustomAttributes = "";
		if (!$this->topy->Raw)
			$this->topy->CurrentValue = HtmlDecode($this->topy->CurrentValue);
		$this->topy->EditValue = $this->topy->CurrentValue;
		$this->topy->PlaceHolder = RemoveHtml($this->topy->caption());

		// leftx
		$this->leftx->EditAttrs["class"] = "form-control";
		$this->leftx->EditCustomAttributes = "";
		if (!$this->leftx->Raw)
			$this->leftx->CurrentValue = HtmlDecode($this->leftx->CurrentValue);
		$this->leftx->EditValue = $this->leftx->CurrentValue;
		$this->leftx->PlaceHolder = RemoveHtml($this->leftx->caption());

		// codlogin
		$this->codlogin->EditAttrs["class"] = "form-control";
		$this->codlogin->EditCustomAttributes = "";
		if (!$this->codlogin->Raw)
			$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
		$this->codlogin->EditValue = $this->codlogin->CurrentValue;
		$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

		// id_cliente
		$this->id_cliente->EditAttrs["class"] = "form-control";
		$this->id_cliente->EditCustomAttributes = "";
		$this->id_cliente->EditValue = $this->id_cliente->CurrentValue;
		$this->id_cliente->PlaceHolder = RemoveHtml($this->id_cliente->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->id_proyecto);
					$doc->exportCaption($this->codigo_producto);
					$doc->exportCaption($this->nombre_producto);
					$doc->exportCaption($this->status_producto);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->precio_producto);
					$doc->exportCaption($this->costo_producto);
					$doc->exportCaption($this->mon_costo);
					$doc->exportCaption($this->mon_venta);
					$doc->exportCaption($this->marca);
					$doc->exportCaption($this->modelo);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->b1);
					$doc->exportCaption($this->b2);
					$doc->exportCaption($this->b3);
					$doc->exportCaption($this->b4);
					$doc->exportCaption($this->b5);
					$doc->exportCaption($this->b6);
					$doc->exportCaption($this->cat_pro);
					$doc->exportCaption($this->pro_ser);
					$doc->exportCaption($this->foto1);
					$doc->exportCaption($this->foto2);
					$doc->exportCaption($this->foto3);
					$doc->exportCaption($this->foto4);
					$doc->exportCaption($this->web);
					$doc->exportCaption($this->pre_web);
					$doc->exportCaption($this->descripcion);
					$doc->exportCaption($this->descripcion1);
					$doc->exportCaption($this->megusta);
					$doc->exportCaption($this->nomegusta);
					$doc->exportCaption($this->precio2);
					$doc->exportCaption($this->precio3);
					$doc->exportCaption($this->und_pro);
					$doc->exportCaption($this->barras);
					$doc->exportCaption($this->stockmin);
					$doc->exportCaption($this->id_grupo);
					$doc->exportCaption($this->talla);
					$doc->exportCaption($this->mostrarcolor);
					$doc->exportCaption($this->lote);
					$doc->exportCaption($this->manzana);
					$doc->exportCaption($this->etapa);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->icon);
					$doc->exportCaption($this->topy);
					$doc->exportCaption($this->leftx);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->id_cliente);
				} else {
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->id_proyecto);
					$doc->exportCaption($this->codigo_producto);
					$doc->exportCaption($this->nombre_producto);
					$doc->exportCaption($this->status_producto);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->precio_producto);
					$doc->exportCaption($this->costo_producto);
					$doc->exportCaption($this->mon_costo);
					$doc->exportCaption($this->mon_venta);
					$doc->exportCaption($this->marca);
					$doc->exportCaption($this->modelo);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->b1);
					$doc->exportCaption($this->b2);
					$doc->exportCaption($this->b3);
					$doc->exportCaption($this->b4);
					$doc->exportCaption($this->b5);
					$doc->exportCaption($this->b6);
					$doc->exportCaption($this->cat_pro);
					$doc->exportCaption($this->pro_ser);
					$doc->exportCaption($this->foto1);
					$doc->exportCaption($this->foto2);
					$doc->exportCaption($this->foto3);
					$doc->exportCaption($this->foto4);
					$doc->exportCaption($this->web);
					$doc->exportCaption($this->pre_web);
					$doc->exportCaption($this->megusta);
					$doc->exportCaption($this->nomegusta);
					$doc->exportCaption($this->precio2);
					$doc->exportCaption($this->precio3);
					$doc->exportCaption($this->und_pro);
					$doc->exportCaption($this->barras);
					$doc->exportCaption($this->stockmin);
					$doc->exportCaption($this->id_grupo);
					$doc->exportCaption($this->talla);
					$doc->exportCaption($this->mostrarcolor);
					$doc->exportCaption($this->lote);
					$doc->exportCaption($this->manzana);
					$doc->exportCaption($this->etapa);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->icon);
					$doc->exportCaption($this->topy);
					$doc->exportCaption($this->leftx);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->id_cliente);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_producto);
						$doc->exportField($this->id_proyecto);
						$doc->exportField($this->codigo_producto);
						$doc->exportField($this->nombre_producto);
						$doc->exportField($this->status_producto);
						$doc->exportField($this->date_added);
						$doc->exportField($this->precio_producto);
						$doc->exportField($this->costo_producto);
						$doc->exportField($this->mon_costo);
						$doc->exportField($this->mon_venta);
						$doc->exportField($this->marca);
						$doc->exportField($this->modelo);
						$doc->exportField($this->color);
						$doc->exportField($this->b1);
						$doc->exportField($this->b2);
						$doc->exportField($this->b3);
						$doc->exportField($this->b4);
						$doc->exportField($this->b5);
						$doc->exportField($this->b6);
						$doc->exportField($this->cat_pro);
						$doc->exportField($this->pro_ser);
						$doc->exportField($this->foto1);
						$doc->exportField($this->foto2);
						$doc->exportField($this->foto3);
						$doc->exportField($this->foto4);
						$doc->exportField($this->web);
						$doc->exportField($this->pre_web);
						$doc->exportField($this->descripcion);
						$doc->exportField($this->descripcion1);
						$doc->exportField($this->megusta);
						$doc->exportField($this->nomegusta);
						$doc->exportField($this->precio2);
						$doc->exportField($this->precio3);
						$doc->exportField($this->und_pro);
						$doc->exportField($this->barras);
						$doc->exportField($this->stockmin);
						$doc->exportField($this->id_grupo);
						$doc->exportField($this->talla);
						$doc->exportField($this->mostrarcolor);
						$doc->exportField($this->lote);
						$doc->exportField($this->manzana);
						$doc->exportField($this->etapa);
						$doc->exportField($this->estado);
						$doc->exportField($this->icon);
						$doc->exportField($this->topy);
						$doc->exportField($this->leftx);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->id_cliente);
					} else {
						$doc->exportField($this->id_producto);
						$doc->exportField($this->id_proyecto);
						$doc->exportField($this->codigo_producto);
						$doc->exportField($this->nombre_producto);
						$doc->exportField($this->status_producto);
						$doc->exportField($this->date_added);
						$doc->exportField($this->precio_producto);
						$doc->exportField($this->costo_producto);
						$doc->exportField($this->mon_costo);
						$doc->exportField($this->mon_venta);
						$doc->exportField($this->marca);
						$doc->exportField($this->modelo);
						$doc->exportField($this->color);
						$doc->exportField($this->b1);
						$doc->exportField($this->b2);
						$doc->exportField($this->b3);
						$doc->exportField($this->b4);
						$doc->exportField($this->b5);
						$doc->exportField($this->b6);
						$doc->exportField($this->cat_pro);
						$doc->exportField($this->pro_ser);
						$doc->exportField($this->foto1);
						$doc->exportField($this->foto2);
						$doc->exportField($this->foto3);
						$doc->exportField($this->foto4);
						$doc->exportField($this->web);
						$doc->exportField($this->pre_web);
						$doc->exportField($this->megusta);
						$doc->exportField($this->nomegusta);
						$doc->exportField($this->precio2);
						$doc->exportField($this->precio3);
						$doc->exportField($this->und_pro);
						$doc->exportField($this->barras);
						$doc->exportField($this->stockmin);
						$doc->exportField($this->id_grupo);
						$doc->exportField($this->talla);
						$doc->exportField($this->mostrarcolor);
						$doc->exportField($this->lote);
						$doc->exportField($this->manzana);
						$doc->exportField($this->etapa);
						$doc->exportField($this->estado);
						$doc->exportField($this->icon);
						$doc->exportField($this->topy);
						$doc->exportField($this->leftx);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->id_cliente);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>