<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class procesos_nuevo_view extends procesos_nuevo
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'procesos_nuevo';

	// Page object name
	public $PageObjName = "procesos_nuevo_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (procesos_nuevo)
		if (!isset($GLOBALS["procesos_nuevo"]) || get_class($GLOBALS["procesos_nuevo"]) == PROJECT_NAMESPACE . "procesos_nuevo") {
			$GLOBALS["procesos_nuevo"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["procesos_nuevo"];
		}
		$keyUrl = "";
		if (Get("codigo") !== NULL) {
			$this->RecKey["codigo"] = Get("codigo");
			$keyUrl .= "&amp;codigo=" . urlencode($this->RecKey["codigo"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'procesos_nuevo');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $procesos_nuevo;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($procesos_nuevo);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "procesos_nuevoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['codigo'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->codigo->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("procesos_nuevolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->codigo->setVisibility();
		$this->codigo_proceso->setVisibility();
		$this->no->setVisibility();
		$this->usuarios->setVisibility();
		$this->SEC_EJEC->setVisibility();
		$this->TIPO_MODALIDAD->setVisibility();
		$this->SECUENCIA->setVisibility();
		$this->AMBIENTE->setVisibility();
		$this->RUC_ENTIDAD->setVisibility();
		$this->LOCAL->setVisibility();
		$this->DEPARTAMENTO->setVisibility();
		$this->PROVINCIA->setVisibility();
		$this->DISTRITO->setVisibility();
		$this->AREA->setVisibility();
		$this->OFICINA->setVisibility();
		$this->PISO_OFICINA->setVisibility();
		$this->NRO_DOC_IDENT_PERSONAL->setVisibility();
		$this->APELLIDO_PATERNO->setVisibility();
		$this->APELLIDO_MATERNO->setVisibility();
		$this->NOMBRES->setVisibility();
		$this->OPERATIVO->setVisibility();
		$this->TIPO_DOC_IDENTIDAD->setVisibility();
		$this->MODALIDAD_CONTRATO->setVisibility();
		$this->CODIGO_PATRIMONIAL->setVisibility();
		$this->DENOMINACION_BIEN->setVisibility();
		$this->TIPO_CAUSAL_ALTA->setVisibility();
		$this->NRO_DOC_ADQUISICION->setVisibility();
		$this->FECHA_ADQUISICION->setVisibility();
		$this->VALOR_ADQUISICION->setVisibility();
		$this->FECHA_DEPRECIACION->setVisibility();
		$this->VALOR_DEPREC_EJERCICIO->setVisibility();
		$this->VALOR_DEPREC_ACUMULADO->setVisibility();
		$this->VALOR_NETO->setVisibility();
		$this->TIP_USO_CUENTA->setVisibility();
		$this->TIPO_CUENTA->setVisibility();
		$this->NRO_CUENTA_CONTABLE->setVisibility();
		$this->CTA_CON_SEGURO->setVisibility();
		$this->ESTADO_BIEN->setVisibility();
		$this->CONDICION->setVisibility();
		$this->MARCA->setVisibility();
		$this->MODELO->setVisibility();
		$this->TIPO->setVisibility();
		$this->COLOR->setVisibility();
		$this->SERIE->setVisibility();
		$this->DIMENSION->setVisibility();
		$this->PLACA->setVisibility();
		$this->NRO_MOTOR->setVisibility();
		$this->NRO_CHASIS->setVisibility();
		$this->MATRICULA->setVisibility();
		$this->ANIO_FABRICACION->setVisibility();
		$this->LONGITUD->setVisibility();
		$this->ALTURA->setVisibility();
		$this->ANCHO->setVisibility();
		$this->RAZA->setVisibility();
		$this->ESPECIE->setVisibility();
		$this->EDAD->setVisibility();
		$this->PAIS->setVisibility();
		$this->OTRAS_CARACT->setVisibility();
		$this->DESCRIPCION_UBICACION_BIEN->setVisibility();
		$this->CAUSAL_BAJA->setVisibility();
		$this->NRO_RESOLUCION_BAJA->setVisibility();
		$this->FECHA_BAJA->setVisibility();
		$this->ACTO_DISPOSICION_BIEN->setVisibility();
		$this->NRO_RESOLUCION_DISP->setVisibility();
		$this->FECHA_DISPOSICION->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setVisibility();
		$this->MOTIVO_ELIMINACION_BIEN->setVisibility();
		$this->ACTO_ADMINISTRACION_BIEN->setVisibility();
		$this->NUM_RESOLUCION_ADMINISTRACION->setVisibility();
		$this->FECHA_ADMINISTRACION->setVisibility();
		$this->FECHA_VENC_ACTO_ADMIN->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setVisibility();
		$this->DOC_ALTA_SBN->setVisibility();
		$this->DOC_BAJA_SBN->setVisibility();
		$this->DEPENDENCIAS->setVisibility();
		$this->NUMERO_FICHA->setVisibility();
		$this->CODIGO_INTERNO->setVisibility();
		$this->ESTADO->setVisibility();
		$this->USO->setVisibility();
		$this->STICKER->setVisibility();
		$this->SEDE->setVisibility();
		$this->SBN->setVisibility();
		$this->ETIQUETA->setVisibility();
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setVisibility();
		$this->PLACA_RODAJE->setVisibility();
		$this->CODIGO_ACTUAL->setVisibility();
		$this->CODIGO_ANTERIOR->setVisibility();
		$this->PROPIEDAD->setVisibility();
		$this->SITUACION->setVisibility();
		$this->OBSERVACIONES->setVisibility();
		$this->FECHA_REGISTRO->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("codigo") !== NULL) {
				$this->codigo->setQueryStringValue(Get("codigo"));
				$this->RecKey["codigo"] = $this->codigo->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->codigo->setQueryStringValue(Key(0));
				$this->RecKey["codigo"] = $this->codigo->QueryStringValue;
			} elseif (Post("codigo") !== NULL) {
				$this->codigo->setFormValue(Post("codigo"));
				$this->RecKey["codigo"] = $this->codigo->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->codigo->setFormValue(Route(2));
				$this->RecKey["codigo"] = $this->codigo->FormValue;
			} else {
				$returnUrl = "procesos_nuevolist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "procesos_nuevolist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "procesos_nuevolist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl != "" && $Security->isLoggedIn());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->isLoggedIn());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl != "" && $Security->isLoggedIn());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl != "" && $Security->isLoggedIn());

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->codigo->setDbValue($row['codigo']);
		$this->codigo_proceso->setDbValue($row['codigo_proceso']);
		$this->no->setDbValue($row['no']);
		$this->usuarios->setDbValue($row['usuarios']);
		$this->SEC_EJEC->setDbValue($row['SEC_EJEC']);
		$this->TIPO_MODALIDAD->setDbValue($row['TIPO_MODALIDAD']);
		$this->SECUENCIA->setDbValue($row['SECUENCIA']);
		$this->AMBIENTE->setDbValue($row['AMBIENTE']);
		$this->RUC_ENTIDAD->setDbValue($row['RUC_ENTIDAD']);
		$this->LOCAL->setDbValue($row['LOCAL']);
		$this->DEPARTAMENTO->setDbValue($row['DEPARTAMENTO']);
		$this->PROVINCIA->setDbValue($row['PROVINCIA']);
		$this->DISTRITO->setDbValue($row['DISTRITO']);
		$this->AREA->setDbValue($row['AREA']);
		$this->OFICINA->setDbValue($row['OFICINA']);
		$this->PISO_OFICINA->setDbValue($row['PISO_OFICINA']);
		$this->NRO_DOC_IDENT_PERSONAL->setDbValue($row['NRO_DOC_IDENT_PERSONAL']);
		$this->APELLIDO_PATERNO->setDbValue($row['APELLIDO_PATERNO']);
		$this->APELLIDO_MATERNO->setDbValue($row['APELLIDO_MATERNO']);
		$this->NOMBRES->setDbValue($row['NOMBRES']);
		$this->OPERATIVO->setDbValue($row['OPERATIVO']);
		$this->TIPO_DOC_IDENTIDAD->setDbValue($row['TIPO_DOC_IDENTIDAD']);
		$this->MODALIDAD_CONTRATO->setDbValue($row['MODALIDAD_CONTRATO']);
		$this->CODIGO_PATRIMONIAL->setDbValue($row['CODIGO_PATRIMONIAL']);
		$this->DENOMINACION_BIEN->setDbValue($row['DENOMINACION_BIEN']);
		$this->TIPO_CAUSAL_ALTA->setDbValue($row['TIPO_CAUSAL_ALTA']);
		$this->NRO_DOC_ADQUISICION->setDbValue($row['NRO_DOC_ADQUISICION']);
		$this->FECHA_ADQUISICION->setDbValue($row['FECHA_ADQUISICION']);
		$this->VALOR_ADQUISICION->setDbValue($row['VALOR_ADQUISICION']);
		$this->FECHA_DEPRECIACION->setDbValue($row['FECHA_DEPRECIACION']);
		$this->VALOR_DEPREC_EJERCICIO->setDbValue($row['VALOR_DEPREC_EJERCICIO']);
		$this->VALOR_DEPREC_ACUMULADO->setDbValue($row['VALOR_DEPREC_ACUMULADO']);
		$this->VALOR_NETO->setDbValue($row['VALOR_NETO']);
		$this->TIP_USO_CUENTA->setDbValue($row['TIP_USO_CUENTA']);
		$this->TIPO_CUENTA->setDbValue($row['TIPO_CUENTA']);
		$this->NRO_CUENTA_CONTABLE->setDbValue($row['NRO_CUENTA_CONTABLE']);
		$this->CTA_CON_SEGURO->setDbValue($row['CTA_CON_SEGURO']);
		$this->ESTADO_BIEN->setDbValue($row['ESTADO_BIEN']);
		$this->CONDICION->setDbValue($row['CONDICION']);
		$this->MARCA->setDbValue($row['MARCA']);
		$this->MODELO->setDbValue($row['MODELO']);
		$this->TIPO->setDbValue($row['TIPO']);
		$this->COLOR->setDbValue($row['COLOR']);
		$this->SERIE->setDbValue($row['SERIE']);
		$this->DIMENSION->setDbValue($row['DIMENSION']);
		$this->PLACA->setDbValue($row['PLACA']);
		$this->NRO_MOTOR->setDbValue($row['NRO_MOTOR']);
		$this->NRO_CHASIS->setDbValue($row['NRO_CHASIS']);
		$this->MATRICULA->setDbValue($row['MATRICULA']);
		$this->ANIO_FABRICACION->setDbValue($row['ANIO_FABRICACION']);
		$this->LONGITUD->setDbValue($row['LONGITUD']);
		$this->ALTURA->setDbValue($row['ALTURA']);
		$this->ANCHO->setDbValue($row['ANCHO']);
		$this->RAZA->setDbValue($row['RAZA']);
		$this->ESPECIE->setDbValue($row['ESPECIE']);
		$this->EDAD->setDbValue($row['EDAD']);
		$this->PAIS->setDbValue($row['PAIS']);
		$this->OTRAS_CARACT->setDbValue($row['OTRAS_CARACT']);
		$this->DESCRIPCION_UBICACION_BIEN->setDbValue($row['DESCRIPCION_UBICACION_BIEN']);
		$this->CAUSAL_BAJA->setDbValue($row['CAUSAL_BAJA']);
		$this->NRO_RESOLUCION_BAJA->setDbValue($row['NRO_RESOLUCION_BAJA']);
		$this->FECHA_BAJA->setDbValue($row['FECHA_BAJA']);
		$this->ACTO_DISPOSICION_BIEN->setDbValue($row['ACTO_DISPOSICION_BIEN']);
		$this->NRO_RESOLUCION_DISP->setDbValue($row['NRO_RESOLUCION_DISP']);
		$this->FECHA_DISPOSICION->setDbValue($row['FECHA_DISPOSICION']);
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION']);
		$this->MOTIVO_ELIMINACION_BIEN->setDbValue($row['MOTIVO_ELIMINACION_BIEN']);
		$this->ACTO_ADMINISTRACION_BIEN->setDbValue($row['ACTO_ADMINISTRACION_BIEN']);
		$this->NUM_RESOLUCION_ADMINISTRACION->setDbValue($row['NUM_RESOLUCION_ADMINISTRACION']);
		$this->FECHA_ADMINISTRACION->setDbValue($row['FECHA_ADMINISTRACION']);
		$this->FECHA_VENC_ACTO_ADMIN->setDbValue($row['FECHA_VENC_ACTO_ADMIN']);
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_ADMIN']);
		$this->DOC_ALTA_SBN->setDbValue($row['DOC_ALTA_SBN']);
		$this->DOC_BAJA_SBN->setDbValue($row['DOC_BAJA_SBN']);
		$this->DEPENDENCIAS->setDbValue($row['DEPENDENCIAS']);
		$this->NUMERO_FICHA->setDbValue($row['NUMERO_FICHA']);
		$this->CODIGO_INTERNO->setDbValue($row['CODIGO_INTERNO']);
		$this->ESTADO->setDbValue($row['ESTADO']);
		$this->USO->setDbValue($row['USO']);
		$this->STICKER->setDbValue($row['STICKER']);
		$this->SEDE->setDbValue($row['SEDE']);
		$this->SBN->setDbValue($row['SBN']);
		$this->ETIQUETA->setDbValue($row['ETIQUETA']);
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setDbValue($row['NOMBRE_BENEFICIARIO_ACTO_ADMIN']);
		$this->PLACA_RODAJE->setDbValue($row['PLACA_RODAJE']);
		$this->CODIGO_ACTUAL->setDbValue($row['CODIGO_ACTUAL']);
		$this->CODIGO_ANTERIOR->setDbValue($row['CODIGO_ANTERIOR']);
		$this->PROPIEDAD->setDbValue($row['PROPIEDAD']);
		$this->SITUACION->setDbValue($row['SITUACION']);
		$this->OBSERVACIONES->setDbValue($row['OBSERVACIONES']);
		$this->FECHA_REGISTRO->setDbValue($row['FECHA_REGISTRO']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['codigo'] = NULL;
		$row['codigo_proceso'] = NULL;
		$row['no'] = NULL;
		$row['usuarios'] = NULL;
		$row['SEC_EJEC'] = NULL;
		$row['TIPO_MODALIDAD'] = NULL;
		$row['SECUENCIA'] = NULL;
		$row['AMBIENTE'] = NULL;
		$row['RUC_ENTIDAD'] = NULL;
		$row['LOCAL'] = NULL;
		$row['DEPARTAMENTO'] = NULL;
		$row['PROVINCIA'] = NULL;
		$row['DISTRITO'] = NULL;
		$row['AREA'] = NULL;
		$row['OFICINA'] = NULL;
		$row['PISO_OFICINA'] = NULL;
		$row['NRO_DOC_IDENT_PERSONAL'] = NULL;
		$row['APELLIDO_PATERNO'] = NULL;
		$row['APELLIDO_MATERNO'] = NULL;
		$row['NOMBRES'] = NULL;
		$row['OPERATIVO'] = NULL;
		$row['TIPO_DOC_IDENTIDAD'] = NULL;
		$row['MODALIDAD_CONTRATO'] = NULL;
		$row['CODIGO_PATRIMONIAL'] = NULL;
		$row['DENOMINACION_BIEN'] = NULL;
		$row['TIPO_CAUSAL_ALTA'] = NULL;
		$row['NRO_DOC_ADQUISICION'] = NULL;
		$row['FECHA_ADQUISICION'] = NULL;
		$row['VALOR_ADQUISICION'] = NULL;
		$row['FECHA_DEPRECIACION'] = NULL;
		$row['VALOR_DEPREC_EJERCICIO'] = NULL;
		$row['VALOR_DEPREC_ACUMULADO'] = NULL;
		$row['VALOR_NETO'] = NULL;
		$row['TIP_USO_CUENTA'] = NULL;
		$row['TIPO_CUENTA'] = NULL;
		$row['NRO_CUENTA_CONTABLE'] = NULL;
		$row['CTA_CON_SEGURO'] = NULL;
		$row['ESTADO_BIEN'] = NULL;
		$row['CONDICION'] = NULL;
		$row['MARCA'] = NULL;
		$row['MODELO'] = NULL;
		$row['TIPO'] = NULL;
		$row['COLOR'] = NULL;
		$row['SERIE'] = NULL;
		$row['DIMENSION'] = NULL;
		$row['PLACA'] = NULL;
		$row['NRO_MOTOR'] = NULL;
		$row['NRO_CHASIS'] = NULL;
		$row['MATRICULA'] = NULL;
		$row['ANIO_FABRICACION'] = NULL;
		$row['LONGITUD'] = NULL;
		$row['ALTURA'] = NULL;
		$row['ANCHO'] = NULL;
		$row['RAZA'] = NULL;
		$row['ESPECIE'] = NULL;
		$row['EDAD'] = NULL;
		$row['PAIS'] = NULL;
		$row['OTRAS_CARACT'] = NULL;
		$row['DESCRIPCION_UBICACION_BIEN'] = NULL;
		$row['CAUSAL_BAJA'] = NULL;
		$row['NRO_RESOLUCION_BAJA'] = NULL;
		$row['FECHA_BAJA'] = NULL;
		$row['ACTO_DISPOSICION_BIEN'] = NULL;
		$row['NRO_RESOLUCION_DISP'] = NULL;
		$row['FECHA_DISPOSICION'] = NULL;
		$row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION'] = NULL;
		$row['MOTIVO_ELIMINACION_BIEN'] = NULL;
		$row['ACTO_ADMINISTRACION_BIEN'] = NULL;
		$row['NUM_RESOLUCION_ADMINISTRACION'] = NULL;
		$row['FECHA_ADMINISTRACION'] = NULL;
		$row['FECHA_VENC_ACTO_ADMIN'] = NULL;
		$row['ENTIDAD_BENEFICIADA_ACTO_ADMIN'] = NULL;
		$row['DOC_ALTA_SBN'] = NULL;
		$row['DOC_BAJA_SBN'] = NULL;
		$row['DEPENDENCIAS'] = NULL;
		$row['NUMERO_FICHA'] = NULL;
		$row['CODIGO_INTERNO'] = NULL;
		$row['ESTADO'] = NULL;
		$row['USO'] = NULL;
		$row['STICKER'] = NULL;
		$row['SEDE'] = NULL;
		$row['SBN'] = NULL;
		$row['ETIQUETA'] = NULL;
		$row['NOMBRE_BENEFICIARIO_ACTO_ADMIN'] = NULL;
		$row['PLACA_RODAJE'] = NULL;
		$row['CODIGO_ACTUAL'] = NULL;
		$row['CODIGO_ANTERIOR'] = NULL;
		$row['PROPIEDAD'] = NULL;
		$row['SITUACION'] = NULL;
		$row['OBSERVACIONES'] = NULL;
		$row['FECHA_REGISTRO'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// codigo
		// codigo_proceso
		// no
		// usuarios
		// SEC_EJEC
		// TIPO_MODALIDAD
		// SECUENCIA
		// AMBIENTE
		// RUC_ENTIDAD
		// LOCAL
		// DEPARTAMENTO
		// PROVINCIA
		// DISTRITO
		// AREA
		// OFICINA
		// PISO_OFICINA
		// NRO_DOC_IDENT_PERSONAL
		// APELLIDO_PATERNO
		// APELLIDO_MATERNO
		// NOMBRES
		// OPERATIVO
		// TIPO_DOC_IDENTIDAD
		// MODALIDAD_CONTRATO
		// CODIGO_PATRIMONIAL
		// DENOMINACION_BIEN
		// TIPO_CAUSAL_ALTA
		// NRO_DOC_ADQUISICION
		// FECHA_ADQUISICION
		// VALOR_ADQUISICION
		// FECHA_DEPRECIACION
		// VALOR_DEPREC_EJERCICIO
		// VALOR_DEPREC_ACUMULADO
		// VALOR_NETO
		// TIP_USO_CUENTA
		// TIPO_CUENTA
		// NRO_CUENTA_CONTABLE
		// CTA_CON_SEGURO
		// ESTADO_BIEN
		// CONDICION
		// MARCA
		// MODELO
		// TIPO
		// COLOR
		// SERIE
		// DIMENSION
		// PLACA
		// NRO_MOTOR
		// NRO_CHASIS
		// MATRICULA
		// ANIO_FABRICACION
		// LONGITUD
		// ALTURA
		// ANCHO
		// RAZA
		// ESPECIE
		// EDAD
		// PAIS
		// OTRAS_CARACT
		// DESCRIPCION_UBICACION_BIEN
		// CAUSAL_BAJA
		// NRO_RESOLUCION_BAJA
		// FECHA_BAJA
		// ACTO_DISPOSICION_BIEN
		// NRO_RESOLUCION_DISP
		// FECHA_DISPOSICION
		// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		// MOTIVO_ELIMINACION_BIEN
		// ACTO_ADMINISTRACION_BIEN
		// NUM_RESOLUCION_ADMINISTRACION
		// FECHA_ADMINISTRACION
		// FECHA_VENC_ACTO_ADMIN
		// ENTIDAD_BENEFICIADA_ACTO_ADMIN
		// DOC_ALTA_SBN
		// DOC_BAJA_SBN
		// DEPENDENCIAS
		// NUMERO_FICHA
		// CODIGO_INTERNO
		// ESTADO
		// USO
		// STICKER
		// SEDE
		// SBN
		// ETIQUETA
		// NOMBRE_BENEFICIARIO_ACTO_ADMIN
		// PLACA_RODAJE
		// CODIGO_ACTUAL
		// CODIGO_ANTERIOR
		// PROPIEDAD
		// SITUACION
		// OBSERVACIONES
		// FECHA_REGISTRO

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// codigo
			$this->codigo->ViewValue = $this->codigo->CurrentValue;
			$this->codigo->ViewCustomAttributes = "";

			// codigo_proceso
			$this->codigo_proceso->ViewValue = $this->codigo_proceso->CurrentValue;
			$this->codigo_proceso->ViewValue = FormatNumber($this->codigo_proceso->ViewValue, 0, -2, -2, -2);
			$this->codigo_proceso->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewValue = FormatNumber($this->no->ViewValue, 0, -2, -2, -2);
			$this->no->ViewCustomAttributes = "";

			// usuarios
			$this->usuarios->ViewValue = $this->usuarios->CurrentValue;
			$this->usuarios->ViewValue = FormatNumber($this->usuarios->ViewValue, 0, -2, -2, -2);
			$this->usuarios->ViewCustomAttributes = "";

			// SEC_EJEC
			$this->SEC_EJEC->ViewValue = $this->SEC_EJEC->CurrentValue;
			$this->SEC_EJEC->ViewCustomAttributes = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->ViewValue = $this->TIPO_MODALIDAD->CurrentValue;
			$this->TIPO_MODALIDAD->ViewCustomAttributes = "";

			// SECUENCIA
			$this->SECUENCIA->ViewValue = $this->SECUENCIA->CurrentValue;
			$this->SECUENCIA->ViewCustomAttributes = "";

			// AMBIENTE
			$this->AMBIENTE->ViewValue = $this->AMBIENTE->CurrentValue;
			$this->AMBIENTE->ViewCustomAttributes = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->ViewValue = $this->RUC_ENTIDAD->CurrentValue;
			$this->RUC_ENTIDAD->ViewCustomAttributes = "";

			// LOCAL
			$this->LOCAL->ViewValue = $this->LOCAL->CurrentValue;
			$this->LOCAL->ViewCustomAttributes = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->ViewValue = $this->DEPARTAMENTO->CurrentValue;
			$this->DEPARTAMENTO->ViewCustomAttributes = "";

			// PROVINCIA
			$this->PROVINCIA->ViewValue = $this->PROVINCIA->CurrentValue;
			$this->PROVINCIA->ViewCustomAttributes = "";

			// DISTRITO
			$this->DISTRITO->ViewValue = $this->DISTRITO->CurrentValue;
			$this->DISTRITO->ViewCustomAttributes = "";

			// AREA
			$this->AREA->ViewValue = $this->AREA->CurrentValue;
			$this->AREA->ViewCustomAttributes = "";

			// OFICINA
			$this->OFICINA->ViewValue = $this->OFICINA->CurrentValue;
			$this->OFICINA->ViewCustomAttributes = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->ViewValue = $this->PISO_OFICINA->CurrentValue;
			$this->PISO_OFICINA->ViewCustomAttributes = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->ViewValue = $this->NRO_DOC_IDENT_PERSONAL->CurrentValue;
			$this->NRO_DOC_IDENT_PERSONAL->ViewCustomAttributes = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->ViewValue = $this->APELLIDO_PATERNO->CurrentValue;
			$this->APELLIDO_PATERNO->ViewCustomAttributes = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->ViewValue = $this->APELLIDO_MATERNO->CurrentValue;
			$this->APELLIDO_MATERNO->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// OPERATIVO
			$this->OPERATIVO->ViewValue = $this->OPERATIVO->CurrentValue;
			$this->OPERATIVO->ViewCustomAttributes = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->ViewValue = $this->TIPO_DOC_IDENTIDAD->CurrentValue;
			$this->TIPO_DOC_IDENTIDAD->ViewCustomAttributes = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->ViewValue = $this->MODALIDAD_CONTRATO->CurrentValue;
			$this->MODALIDAD_CONTRATO->ViewCustomAttributes = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->ViewValue = $this->CODIGO_PATRIMONIAL->CurrentValue;
			$this->CODIGO_PATRIMONIAL->ViewCustomAttributes = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->ViewValue = $this->DENOMINACION_BIEN->CurrentValue;
			$this->DENOMINACION_BIEN->ViewCustomAttributes = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->ViewValue = $this->TIPO_CAUSAL_ALTA->CurrentValue;
			$this->TIPO_CAUSAL_ALTA->ViewCustomAttributes = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->ViewValue = $this->NRO_DOC_ADQUISICION->CurrentValue;
			$this->NRO_DOC_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->ViewValue = $this->FECHA_ADQUISICION->CurrentValue;
			$this->FECHA_ADQUISICION->ViewCustomAttributes = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->ViewValue = $this->VALOR_ADQUISICION->CurrentValue;
			$this->VALOR_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->ViewValue = $this->FECHA_DEPRECIACION->CurrentValue;
			$this->FECHA_DEPRECIACION->ViewCustomAttributes = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->ViewValue = $this->VALOR_DEPREC_EJERCICIO->CurrentValue;
			$this->VALOR_DEPREC_EJERCICIO->ViewCustomAttributes = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->ViewValue = $this->VALOR_DEPREC_ACUMULADO->CurrentValue;
			$this->VALOR_DEPREC_ACUMULADO->ViewCustomAttributes = "";

			// VALOR_NETO
			$this->VALOR_NETO->ViewValue = $this->VALOR_NETO->CurrentValue;
			$this->VALOR_NETO->ViewCustomAttributes = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->ViewValue = $this->TIP_USO_CUENTA->CurrentValue;
			$this->TIP_USO_CUENTA->ViewCustomAttributes = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->ViewValue = $this->TIPO_CUENTA->CurrentValue;
			$this->TIPO_CUENTA->ViewCustomAttributes = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->ViewValue = $this->NRO_CUENTA_CONTABLE->CurrentValue;
			$this->NRO_CUENTA_CONTABLE->ViewCustomAttributes = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->ViewValue = $this->CTA_CON_SEGURO->CurrentValue;
			$this->CTA_CON_SEGURO->ViewCustomAttributes = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->ViewValue = $this->ESTADO_BIEN->CurrentValue;
			$this->ESTADO_BIEN->ViewCustomAttributes = "";

			// CONDICION
			$this->CONDICION->ViewValue = $this->CONDICION->CurrentValue;
			$this->CONDICION->ViewCustomAttributes = "";

			// MARCA
			$this->MARCA->ViewValue = $this->MARCA->CurrentValue;
			$this->MARCA->ViewCustomAttributes = "";

			// MODELO
			$this->MODELO->ViewValue = $this->MODELO->CurrentValue;
			$this->MODELO->ViewCustomAttributes = "";

			// TIPO
			$this->TIPO->ViewValue = $this->TIPO->CurrentValue;
			$this->TIPO->ViewCustomAttributes = "";

			// COLOR
			$this->COLOR->ViewValue = $this->COLOR->CurrentValue;
			$this->COLOR->ViewCustomAttributes = "";

			// SERIE
			$this->SERIE->ViewValue = $this->SERIE->CurrentValue;
			$this->SERIE->ViewCustomAttributes = "";

			// DIMENSION
			$this->DIMENSION->ViewValue = $this->DIMENSION->CurrentValue;
			$this->DIMENSION->ViewCustomAttributes = "";

			// PLACA
			$this->PLACA->ViewValue = $this->PLACA->CurrentValue;
			$this->PLACA->ViewCustomAttributes = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->ViewValue = $this->NRO_MOTOR->CurrentValue;
			$this->NRO_MOTOR->ViewCustomAttributes = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->ViewValue = $this->NRO_CHASIS->CurrentValue;
			$this->NRO_CHASIS->ViewCustomAttributes = "";

			// MATRICULA
			$this->MATRICULA->ViewValue = $this->MATRICULA->CurrentValue;
			$this->MATRICULA->ViewCustomAttributes = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->ViewValue = $this->ANIO_FABRICACION->CurrentValue;
			$this->ANIO_FABRICACION->ViewCustomAttributes = "";

			// LONGITUD
			$this->LONGITUD->ViewValue = $this->LONGITUD->CurrentValue;
			$this->LONGITUD->ViewCustomAttributes = "";

			// ALTURA
			$this->ALTURA->ViewValue = $this->ALTURA->CurrentValue;
			$this->ALTURA->ViewCustomAttributes = "";

			// ANCHO
			$this->ANCHO->ViewValue = $this->ANCHO->CurrentValue;
			$this->ANCHO->ViewCustomAttributes = "";

			// RAZA
			$this->RAZA->ViewValue = $this->RAZA->CurrentValue;
			$this->RAZA->ViewCustomAttributes = "";

			// ESPECIE
			$this->ESPECIE->ViewValue = $this->ESPECIE->CurrentValue;
			$this->ESPECIE->ViewCustomAttributes = "";

			// EDAD
			$this->EDAD->ViewValue = $this->EDAD->CurrentValue;
			$this->EDAD->ViewCustomAttributes = "";

			// PAIS
			$this->PAIS->ViewValue = $this->PAIS->CurrentValue;
			$this->PAIS->ViewCustomAttributes = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->ViewValue = $this->OTRAS_CARACT->CurrentValue;
			$this->OTRAS_CARACT->ViewCustomAttributes = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->ViewValue = $this->DESCRIPCION_UBICACION_BIEN->CurrentValue;
			$this->DESCRIPCION_UBICACION_BIEN->ViewCustomAttributes = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->ViewValue = $this->CAUSAL_BAJA->CurrentValue;
			$this->CAUSAL_BAJA->ViewCustomAttributes = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->ViewValue = $this->NRO_RESOLUCION_BAJA->CurrentValue;
			$this->NRO_RESOLUCION_BAJA->ViewCustomAttributes = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->ViewValue = $this->FECHA_BAJA->CurrentValue;
			$this->FECHA_BAJA->ViewCustomAttributes = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->ViewValue = $this->ACTO_DISPOSICION_BIEN->CurrentValue;
			$this->ACTO_DISPOSICION_BIEN->ViewCustomAttributes = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->ViewValue = $this->NRO_RESOLUCION_DISP->CurrentValue;
			$this->NRO_RESOLUCION_DISP->ViewCustomAttributes = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->ViewValue = $this->FECHA_DISPOSICION->CurrentValue;
			$this->FECHA_DISPOSICION->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewCustomAttributes = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->ViewValue = $this->MOTIVO_ELIMINACION_BIEN->CurrentValue;
			$this->MOTIVO_ELIMINACION_BIEN->ViewCustomAttributes = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->ViewValue = $this->ACTO_ADMINISTRACION_BIEN->CurrentValue;
			$this->ACTO_ADMINISTRACION_BIEN->ViewCustomAttributes = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewValue = $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue;
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->ViewValue = $this->FECHA_ADMINISTRACION->CurrentValue;
			$this->FECHA_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->ViewValue = $this->FECHA_VENC_ACTO_ADMIN->CurrentValue;
			$this->FECHA_VENC_ACTO_ADMIN->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewCustomAttributes = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->ViewValue = $this->DOC_ALTA_SBN->CurrentValue;
			$this->DOC_ALTA_SBN->ViewCustomAttributes = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->ViewValue = $this->DOC_BAJA_SBN->CurrentValue;
			$this->DOC_BAJA_SBN->ViewCustomAttributes = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->ViewValue = $this->DEPENDENCIAS->CurrentValue;
			$this->DEPENDENCIAS->ViewCustomAttributes = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->ViewValue = $this->NUMERO_FICHA->CurrentValue;
			$this->NUMERO_FICHA->ViewCustomAttributes = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->ViewValue = $this->CODIGO_INTERNO->CurrentValue;
			$this->CODIGO_INTERNO->ViewCustomAttributes = "";

			// ESTADO
			$this->ESTADO->ViewValue = $this->ESTADO->CurrentValue;
			$this->ESTADO->ViewCustomAttributes = "";

			// USO
			$this->USO->ViewValue = $this->USO->CurrentValue;
			$this->USO->ViewCustomAttributes = "";

			// STICKER
			$this->STICKER->ViewValue = $this->STICKER->CurrentValue;
			$this->STICKER->ViewCustomAttributes = "";

			// SEDE
			$this->SEDE->ViewValue = $this->SEDE->CurrentValue;
			$this->SEDE->ViewCustomAttributes = "";

			// SBN
			$this->SBN->ViewValue = $this->SBN->CurrentValue;
			$this->SBN->ViewCustomAttributes = "";

			// ETIQUETA
			$this->ETIQUETA->ViewValue = $this->ETIQUETA->CurrentValue;
			$this->ETIQUETA->ViewCustomAttributes = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewValue = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue;
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewCustomAttributes = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->ViewValue = $this->PLACA_RODAJE->CurrentValue;
			$this->PLACA_RODAJE->ViewCustomAttributes = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->ViewValue = $this->CODIGO_ACTUAL->CurrentValue;
			$this->CODIGO_ACTUAL->ViewCustomAttributes = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->ViewValue = $this->CODIGO_ANTERIOR->CurrentValue;
			$this->CODIGO_ANTERIOR->ViewCustomAttributes = "";

			// PROPIEDAD
			$this->PROPIEDAD->ViewValue = $this->PROPIEDAD->CurrentValue;
			$this->PROPIEDAD->ViewCustomAttributes = "";

			// SITUACION
			$this->SITUACION->ViewValue = $this->SITUACION->CurrentValue;
			$this->SITUACION->ViewCustomAttributes = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->ViewValue = $this->OBSERVACIONES->CurrentValue;
			$this->OBSERVACIONES->ViewCustomAttributes = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->ViewValue = $this->FECHA_REGISTRO->CurrentValue;
			$this->FECHA_REGISTRO->ViewValue = FormatDateTime($this->FECHA_REGISTRO->ViewValue, 0);
			$this->FECHA_REGISTRO->ViewCustomAttributes = "";

			// codigo
			$this->codigo->LinkCustomAttributes = "";
			$this->codigo->HrefValue = "";
			$this->codigo->TooltipValue = "";

			// codigo_proceso
			$this->codigo_proceso->LinkCustomAttributes = "";
			$this->codigo_proceso->HrefValue = "";
			$this->codigo_proceso->TooltipValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// usuarios
			$this->usuarios->LinkCustomAttributes = "";
			$this->usuarios->HrefValue = "";
			$this->usuarios->TooltipValue = "";

			// SEC_EJEC
			$this->SEC_EJEC->LinkCustomAttributes = "";
			$this->SEC_EJEC->HrefValue = "";
			$this->SEC_EJEC->TooltipValue = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->LinkCustomAttributes = "";
			$this->TIPO_MODALIDAD->HrefValue = "";
			$this->TIPO_MODALIDAD->TooltipValue = "";

			// SECUENCIA
			$this->SECUENCIA->LinkCustomAttributes = "";
			$this->SECUENCIA->HrefValue = "";
			$this->SECUENCIA->TooltipValue = "";

			// AMBIENTE
			$this->AMBIENTE->LinkCustomAttributes = "";
			$this->AMBIENTE->HrefValue = "";
			$this->AMBIENTE->TooltipValue = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->LinkCustomAttributes = "";
			$this->RUC_ENTIDAD->HrefValue = "";
			$this->RUC_ENTIDAD->TooltipValue = "";

			// LOCAL
			$this->LOCAL->LinkCustomAttributes = "";
			$this->LOCAL->HrefValue = "";
			$this->LOCAL->TooltipValue = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->LinkCustomAttributes = "";
			$this->DEPARTAMENTO->HrefValue = "";
			$this->DEPARTAMENTO->TooltipValue = "";

			// PROVINCIA
			$this->PROVINCIA->LinkCustomAttributes = "";
			$this->PROVINCIA->HrefValue = "";
			$this->PROVINCIA->TooltipValue = "";

			// DISTRITO
			$this->DISTRITO->LinkCustomAttributes = "";
			$this->DISTRITO->HrefValue = "";
			$this->DISTRITO->TooltipValue = "";

			// AREA
			$this->AREA->LinkCustomAttributes = "";
			$this->AREA->HrefValue = "";
			$this->AREA->TooltipValue = "";

			// OFICINA
			$this->OFICINA->LinkCustomAttributes = "";
			$this->OFICINA->HrefValue = "";
			$this->OFICINA->TooltipValue = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->LinkCustomAttributes = "";
			$this->PISO_OFICINA->HrefValue = "";
			$this->PISO_OFICINA->TooltipValue = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->LinkCustomAttributes = "";
			$this->NRO_DOC_IDENT_PERSONAL->HrefValue = "";
			$this->NRO_DOC_IDENT_PERSONAL->TooltipValue = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_PATERNO->HrefValue = "";
			$this->APELLIDO_PATERNO->TooltipValue = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_MATERNO->HrefValue = "";
			$this->APELLIDO_MATERNO->TooltipValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";
			$this->NOMBRES->TooltipValue = "";

			// OPERATIVO
			$this->OPERATIVO->LinkCustomAttributes = "";
			$this->OPERATIVO->HrefValue = "";
			$this->OPERATIVO->TooltipValue = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->LinkCustomAttributes = "";
			$this->TIPO_DOC_IDENTIDAD->HrefValue = "";
			$this->TIPO_DOC_IDENTIDAD->TooltipValue = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->LinkCustomAttributes = "";
			$this->MODALIDAD_CONTRATO->HrefValue = "";
			$this->MODALIDAD_CONTRATO->TooltipValue = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->LinkCustomAttributes = "";
			$this->CODIGO_PATRIMONIAL->HrefValue = "";
			$this->CODIGO_PATRIMONIAL->TooltipValue = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->LinkCustomAttributes = "";
			$this->DENOMINACION_BIEN->HrefValue = "";
			$this->DENOMINACION_BIEN->TooltipValue = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->LinkCustomAttributes = "";
			$this->TIPO_CAUSAL_ALTA->HrefValue = "";
			$this->TIPO_CAUSAL_ALTA->TooltipValue = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->LinkCustomAttributes = "";
			$this->NRO_DOC_ADQUISICION->HrefValue = "";
			$this->NRO_DOC_ADQUISICION->TooltipValue = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->LinkCustomAttributes = "";
			$this->FECHA_ADQUISICION->HrefValue = "";
			$this->FECHA_ADQUISICION->TooltipValue = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->LinkCustomAttributes = "";
			$this->VALOR_ADQUISICION->HrefValue = "";
			$this->VALOR_ADQUISICION->TooltipValue = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->LinkCustomAttributes = "";
			$this->FECHA_DEPRECIACION->HrefValue = "";
			$this->FECHA_DEPRECIACION->TooltipValue = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_EJERCICIO->HrefValue = "";
			$this->VALOR_DEPREC_EJERCICIO->TooltipValue = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_ACUMULADO->HrefValue = "";
			$this->VALOR_DEPREC_ACUMULADO->TooltipValue = "";

			// VALOR_NETO
			$this->VALOR_NETO->LinkCustomAttributes = "";
			$this->VALOR_NETO->HrefValue = "";
			$this->VALOR_NETO->TooltipValue = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->LinkCustomAttributes = "";
			$this->TIP_USO_CUENTA->HrefValue = "";
			$this->TIP_USO_CUENTA->TooltipValue = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->LinkCustomAttributes = "";
			$this->TIPO_CUENTA->HrefValue = "";
			$this->TIPO_CUENTA->TooltipValue = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->LinkCustomAttributes = "";
			$this->NRO_CUENTA_CONTABLE->HrefValue = "";
			$this->NRO_CUENTA_CONTABLE->TooltipValue = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->LinkCustomAttributes = "";
			$this->CTA_CON_SEGURO->HrefValue = "";
			$this->CTA_CON_SEGURO->TooltipValue = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->LinkCustomAttributes = "";
			$this->ESTADO_BIEN->HrefValue = "";
			$this->ESTADO_BIEN->TooltipValue = "";

			// CONDICION
			$this->CONDICION->LinkCustomAttributes = "";
			$this->CONDICION->HrefValue = "";
			$this->CONDICION->TooltipValue = "";

			// MARCA
			$this->MARCA->LinkCustomAttributes = "";
			$this->MARCA->HrefValue = "";
			$this->MARCA->TooltipValue = "";

			// MODELO
			$this->MODELO->LinkCustomAttributes = "";
			$this->MODELO->HrefValue = "";
			$this->MODELO->TooltipValue = "";

			// TIPO
			$this->TIPO->LinkCustomAttributes = "";
			$this->TIPO->HrefValue = "";
			$this->TIPO->TooltipValue = "";

			// COLOR
			$this->COLOR->LinkCustomAttributes = "";
			$this->COLOR->HrefValue = "";
			$this->COLOR->TooltipValue = "";

			// SERIE
			$this->SERIE->LinkCustomAttributes = "";
			$this->SERIE->HrefValue = "";
			$this->SERIE->TooltipValue = "";

			// DIMENSION
			$this->DIMENSION->LinkCustomAttributes = "";
			$this->DIMENSION->HrefValue = "";
			$this->DIMENSION->TooltipValue = "";

			// PLACA
			$this->PLACA->LinkCustomAttributes = "";
			$this->PLACA->HrefValue = "";
			$this->PLACA->TooltipValue = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->LinkCustomAttributes = "";
			$this->NRO_MOTOR->HrefValue = "";
			$this->NRO_MOTOR->TooltipValue = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->LinkCustomAttributes = "";
			$this->NRO_CHASIS->HrefValue = "";
			$this->NRO_CHASIS->TooltipValue = "";

			// MATRICULA
			$this->MATRICULA->LinkCustomAttributes = "";
			$this->MATRICULA->HrefValue = "";
			$this->MATRICULA->TooltipValue = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->LinkCustomAttributes = "";
			$this->ANIO_FABRICACION->HrefValue = "";
			$this->ANIO_FABRICACION->TooltipValue = "";

			// LONGITUD
			$this->LONGITUD->LinkCustomAttributes = "";
			$this->LONGITUD->HrefValue = "";
			$this->LONGITUD->TooltipValue = "";

			// ALTURA
			$this->ALTURA->LinkCustomAttributes = "";
			$this->ALTURA->HrefValue = "";
			$this->ALTURA->TooltipValue = "";

			// ANCHO
			$this->ANCHO->LinkCustomAttributes = "";
			$this->ANCHO->HrefValue = "";
			$this->ANCHO->TooltipValue = "";

			// RAZA
			$this->RAZA->LinkCustomAttributes = "";
			$this->RAZA->HrefValue = "";
			$this->RAZA->TooltipValue = "";

			// ESPECIE
			$this->ESPECIE->LinkCustomAttributes = "";
			$this->ESPECIE->HrefValue = "";
			$this->ESPECIE->TooltipValue = "";

			// EDAD
			$this->EDAD->LinkCustomAttributes = "";
			$this->EDAD->HrefValue = "";
			$this->EDAD->TooltipValue = "";

			// PAIS
			$this->PAIS->LinkCustomAttributes = "";
			$this->PAIS->HrefValue = "";
			$this->PAIS->TooltipValue = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->LinkCustomAttributes = "";
			$this->OTRAS_CARACT->HrefValue = "";
			$this->OTRAS_CARACT->TooltipValue = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->LinkCustomAttributes = "";
			$this->DESCRIPCION_UBICACION_BIEN->HrefValue = "";
			$this->DESCRIPCION_UBICACION_BIEN->TooltipValue = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->LinkCustomAttributes = "";
			$this->CAUSAL_BAJA->HrefValue = "";
			$this->CAUSAL_BAJA->TooltipValue = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_BAJA->HrefValue = "";
			$this->NRO_RESOLUCION_BAJA->TooltipValue = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->LinkCustomAttributes = "";
			$this->FECHA_BAJA->HrefValue = "";
			$this->FECHA_BAJA->TooltipValue = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_DISPOSICION_BIEN->HrefValue = "";
			$this->ACTO_DISPOSICION_BIEN->TooltipValue = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_DISP->HrefValue = "";
			$this->NRO_RESOLUCION_DISP->TooltipValue = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->LinkCustomAttributes = "";
			$this->FECHA_DISPOSICION->HrefValue = "";
			$this->FECHA_DISPOSICION->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->TooltipValue = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->LinkCustomAttributes = "";
			$this->MOTIVO_ELIMINACION_BIEN->HrefValue = "";
			$this->MOTIVO_ELIMINACION_BIEN->TooltipValue = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_ADMINISTRACION_BIEN->HrefValue = "";
			$this->ACTO_ADMINISTRACION_BIEN->TooltipValue = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->LinkCustomAttributes = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->HrefValue = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->TooltipValue = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->LinkCustomAttributes = "";
			$this->FECHA_ADMINISTRACION->HrefValue = "";
			$this->FECHA_ADMINISTRACION->TooltipValue = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->FECHA_VENC_ACTO_ADMIN->HrefValue = "";
			$this->FECHA_VENC_ACTO_ADMIN->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->TooltipValue = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->LinkCustomAttributes = "";
			$this->DOC_ALTA_SBN->HrefValue = "";
			$this->DOC_ALTA_SBN->TooltipValue = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->LinkCustomAttributes = "";
			$this->DOC_BAJA_SBN->HrefValue = "";
			$this->DOC_BAJA_SBN->TooltipValue = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->LinkCustomAttributes = "";
			$this->DEPENDENCIAS->HrefValue = "";
			$this->DEPENDENCIAS->TooltipValue = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->LinkCustomAttributes = "";
			$this->NUMERO_FICHA->HrefValue = "";
			$this->NUMERO_FICHA->TooltipValue = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->LinkCustomAttributes = "";
			$this->CODIGO_INTERNO->HrefValue = "";
			$this->CODIGO_INTERNO->TooltipValue = "";

			// ESTADO
			$this->ESTADO->LinkCustomAttributes = "";
			$this->ESTADO->HrefValue = "";
			$this->ESTADO->TooltipValue = "";

			// USO
			$this->USO->LinkCustomAttributes = "";
			$this->USO->HrefValue = "";
			$this->USO->TooltipValue = "";

			// STICKER
			$this->STICKER->LinkCustomAttributes = "";
			$this->STICKER->HrefValue = "";
			$this->STICKER->TooltipValue = "";

			// SEDE
			$this->SEDE->LinkCustomAttributes = "";
			$this->SEDE->HrefValue = "";
			$this->SEDE->TooltipValue = "";

			// SBN
			$this->SBN->LinkCustomAttributes = "";
			$this->SBN->HrefValue = "";
			$this->SBN->TooltipValue = "";

			// ETIQUETA
			$this->ETIQUETA->LinkCustomAttributes = "";
			$this->ETIQUETA->HrefValue = "";
			$this->ETIQUETA->TooltipValue = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->HrefValue = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->TooltipValue = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->LinkCustomAttributes = "";
			$this->PLACA_RODAJE->HrefValue = "";
			$this->PLACA_RODAJE->TooltipValue = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->LinkCustomAttributes = "";
			$this->CODIGO_ACTUAL->HrefValue = "";
			$this->CODIGO_ACTUAL->TooltipValue = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->LinkCustomAttributes = "";
			$this->CODIGO_ANTERIOR->HrefValue = "";
			$this->CODIGO_ANTERIOR->TooltipValue = "";

			// PROPIEDAD
			$this->PROPIEDAD->LinkCustomAttributes = "";
			$this->PROPIEDAD->HrefValue = "";
			$this->PROPIEDAD->TooltipValue = "";

			// SITUACION
			$this->SITUACION->LinkCustomAttributes = "";
			$this->SITUACION->HrefValue = "";
			$this->SITUACION->TooltipValue = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->LinkCustomAttributes = "";
			$this->OBSERVACIONES->HrefValue = "";
			$this->OBSERVACIONES->TooltipValue = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->LinkCustomAttributes = "";
			$this->FECHA_REGISTRO->HrefValue = "";
			$this->FECHA_REGISTRO->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("procesos_nuevolist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>