<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class products_list extends products
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'products';

	// Page object name
	public $PageObjName = "products_list";

	// Grid form hidden field names
	public $FormName = "fproductslist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (products)
		if (!isset($GLOBALS["products"]) || get_class($GLOBALS["products"]) == PROJECT_NAMESPACE . "products") {
			$GLOBALS["products"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["products"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "productsadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "productsdelete.php";
		$this->MultiUpdateUrl = "productsupdate.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'products');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option fproductslistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $products;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($products);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id_producto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->Visible = FALSE;
		$this->estado->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->pais->setVisibility();
		$this->departamento->setVisibility();
		$this->distrito->setVisibility();
		$this->localidad->setVisibility();
		$this->zona->setVisibility();
		$this->tipo_inmueble->setVisibility();
		$this->tipo_negocio->setVisibility();
		$this->tiempo_alquiler->setVisibility();
		$this->moneda->setVisibility();
		$this->estado_inmueble->setVisibility();
		$this->area_construida->setVisibility();
		$this->area_privada->setVisibility();
		$this->area_terreno->setVisibility();
		$this->valor_administracion->setVisibility();
		$this->dormitorios->setVisibility();
		$this->banios->setVisibility();
		$this->garaje->setVisibility();
		$this->piso->setVisibility();
		$this->estrato->setVisibility();
		$this->direccion->Visible = FALSE;
		$this->codigo_postal->setVisibility();
		$this->mapa->setVisibility();
		$this->latitud->setVisibility();
		$this->longitud->setVisibility();
		$this->opciones_mapa->setVisibility();
		$this->red->setVisibility();
		$this->video->Visible = FALSE;
		$this->disponibilidad->setVisibility();
		$this->anio_construccion->setVisibility();
		$this->encargado->setVisibility();
		$this->comentario->Visible = FALSE;
		$this->visitas->setVisibility();
		$this->valor_comision->setVisibility();
		$this->tipo_comision->setVisibility();
		$this->certificado->setVisibility();
		$this->nombre_propietario->setVisibility();
		$this->movil_propietario->setVisibility();
		$this->telefono_propietario->setVisibility();
		$this->correo_propietario->setVisibility();
		$this->vinculo->setVisibility();
		$this->portales->Visible = FALSE;
		$this->notas->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->Visible = FALSE;
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->Visible = FALSE;
		$this->descripcion1->Visible = FALSE;
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->precio_mayorista->setVisibility();
		$this->precio_vendedor->setVisibility();
		$this->medida1->setVisibility();
		$this->medida2->setVisibility();
		$this->medida3->setVisibility();
		$this->codlogin->setVisibility();
		$this->idempresa->setVisibility();
		$this->urlstreetview->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->id_producto->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->id_producto->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->id_producto->AdvancedSearch->toJson(), ","); // Field id_producto
		$filterList = Concat($filterList, $this->codigo_producto->AdvancedSearch->toJson(), ","); // Field codigo_producto
		$filterList = Concat($filterList, $this->nombre_producto->AdvancedSearch->toJson(), ","); // Field nombre_producto
		$filterList = Concat($filterList, $this->estado->AdvancedSearch->toJson(), ","); // Field estado
		$filterList = Concat($filterList, $this->status_producto->AdvancedSearch->toJson(), ","); // Field status_producto
		$filterList = Concat($filterList, $this->date_added->AdvancedSearch->toJson(), ","); // Field date_added
		$filterList = Concat($filterList, $this->precio_producto->AdvancedSearch->toJson(), ","); // Field precio_producto
		$filterList = Concat($filterList, $this->costo_producto->AdvancedSearch->toJson(), ","); // Field costo_producto
		$filterList = Concat($filterList, $this->mon_costo->AdvancedSearch->toJson(), ","); // Field mon_costo
		$filterList = Concat($filterList, $this->mon_venta->AdvancedSearch->toJson(), ","); // Field mon_venta
		$filterList = Concat($filterList, $this->pais->AdvancedSearch->toJson(), ","); // Field pais
		$filterList = Concat($filterList, $this->departamento->AdvancedSearch->toJson(), ","); // Field departamento
		$filterList = Concat($filterList, $this->distrito->AdvancedSearch->toJson(), ","); // Field distrito
		$filterList = Concat($filterList, $this->localidad->AdvancedSearch->toJson(), ","); // Field localidad
		$filterList = Concat($filterList, $this->zona->AdvancedSearch->toJson(), ","); // Field zona
		$filterList = Concat($filterList, $this->tipo_inmueble->AdvancedSearch->toJson(), ","); // Field tipo_inmueble
		$filterList = Concat($filterList, $this->tipo_negocio->AdvancedSearch->toJson(), ","); // Field tipo_negocio
		$filterList = Concat($filterList, $this->tiempo_alquiler->AdvancedSearch->toJson(), ","); // Field tiempo_alquiler
		$filterList = Concat($filterList, $this->moneda->AdvancedSearch->toJson(), ","); // Field moneda
		$filterList = Concat($filterList, $this->estado_inmueble->AdvancedSearch->toJson(), ","); // Field estado_inmueble
		$filterList = Concat($filterList, $this->area_construida->AdvancedSearch->toJson(), ","); // Field area_construida
		$filterList = Concat($filterList, $this->area_privada->AdvancedSearch->toJson(), ","); // Field area_privada
		$filterList = Concat($filterList, $this->area_terreno->AdvancedSearch->toJson(), ","); // Field area_terreno
		$filterList = Concat($filterList, $this->valor_administracion->AdvancedSearch->toJson(), ","); // Field valor_administracion
		$filterList = Concat($filterList, $this->dormitorios->AdvancedSearch->toJson(), ","); // Field dormitorios
		$filterList = Concat($filterList, $this->banios->AdvancedSearch->toJson(), ","); // Field banios
		$filterList = Concat($filterList, $this->garaje->AdvancedSearch->toJson(), ","); // Field garaje
		$filterList = Concat($filterList, $this->piso->AdvancedSearch->toJson(), ","); // Field piso
		$filterList = Concat($filterList, $this->estrato->AdvancedSearch->toJson(), ","); // Field estrato
		$filterList = Concat($filterList, $this->direccion->AdvancedSearch->toJson(), ","); // Field direccion
		$filterList = Concat($filterList, $this->codigo_postal->AdvancedSearch->toJson(), ","); // Field codigo_postal
		$filterList = Concat($filterList, $this->mapa->AdvancedSearch->toJson(), ","); // Field mapa
		$filterList = Concat($filterList, $this->latitud->AdvancedSearch->toJson(), ","); // Field latitud
		$filterList = Concat($filterList, $this->longitud->AdvancedSearch->toJson(), ","); // Field longitud
		$filterList = Concat($filterList, $this->opciones_mapa->AdvancedSearch->toJson(), ","); // Field opciones_mapa
		$filterList = Concat($filterList, $this->red->AdvancedSearch->toJson(), ","); // Field red
		$filterList = Concat($filterList, $this->video->AdvancedSearch->toJson(), ","); // Field video
		$filterList = Concat($filterList, $this->disponibilidad->AdvancedSearch->toJson(), ","); // Field disponibilidad
		$filterList = Concat($filterList, $this->anio_construccion->AdvancedSearch->toJson(), ","); // Field anio_construccion
		$filterList = Concat($filterList, $this->encargado->AdvancedSearch->toJson(), ","); // Field encargado
		$filterList = Concat($filterList, $this->comentario->AdvancedSearch->toJson(), ","); // Field comentario
		$filterList = Concat($filterList, $this->visitas->AdvancedSearch->toJson(), ","); // Field visitas
		$filterList = Concat($filterList, $this->valor_comision->AdvancedSearch->toJson(), ","); // Field valor_comision
		$filterList = Concat($filterList, $this->tipo_comision->AdvancedSearch->toJson(), ","); // Field tipo_comision
		$filterList = Concat($filterList, $this->certificado->AdvancedSearch->toJson(), ","); // Field certificado
		$filterList = Concat($filterList, $this->nombre_propietario->AdvancedSearch->toJson(), ","); // Field nombre_propietario
		$filterList = Concat($filterList, $this->movil_propietario->AdvancedSearch->toJson(), ","); // Field movil_propietario
		$filterList = Concat($filterList, $this->telefono_propietario->AdvancedSearch->toJson(), ","); // Field telefono_propietario
		$filterList = Concat($filterList, $this->correo_propietario->AdvancedSearch->toJson(), ","); // Field correo_propietario
		$filterList = Concat($filterList, $this->vinculo->AdvancedSearch->toJson(), ","); // Field vinculo
		$filterList = Concat($filterList, $this->portales->AdvancedSearch->toJson(), ","); // Field portales
		$filterList = Concat($filterList, $this->notas->AdvancedSearch->toJson(), ","); // Field notas
		$filterList = Concat($filterList, $this->marca->AdvancedSearch->toJson(), ","); // Field marca
		$filterList = Concat($filterList, $this->modelo->AdvancedSearch->toJson(), ","); // Field modelo
		$filterList = Concat($filterList, $this->color->AdvancedSearch->toJson(), ","); // Field color
		$filterList = Concat($filterList, $this->b1->AdvancedSearch->toJson(), ","); // Field b1
		$filterList = Concat($filterList, $this->b2->AdvancedSearch->toJson(), ","); // Field b2
		$filterList = Concat($filterList, $this->b3->AdvancedSearch->toJson(), ","); // Field b3
		$filterList = Concat($filterList, $this->b4->AdvancedSearch->toJson(), ","); // Field b4
		$filterList = Concat($filterList, $this->b5->AdvancedSearch->toJson(), ","); // Field b5
		$filterList = Concat($filterList, $this->b6->AdvancedSearch->toJson(), ","); // Field b6
		$filterList = Concat($filterList, $this->cat_pro->AdvancedSearch->toJson(), ","); // Field cat_pro
		$filterList = Concat($filterList, $this->pro_ser->AdvancedSearch->toJson(), ","); // Field pro_ser
		$filterList = Concat($filterList, $this->foto1->AdvancedSearch->toJson(), ","); // Field foto1
		$filterList = Concat($filterList, $this->foto2->AdvancedSearch->toJson(), ","); // Field foto2
		$filterList = Concat($filterList, $this->foto3->AdvancedSearch->toJson(), ","); // Field foto3
		$filterList = Concat($filterList, $this->foto4->AdvancedSearch->toJson(), ","); // Field foto4
		$filterList = Concat($filterList, $this->web->AdvancedSearch->toJson(), ","); // Field web
		$filterList = Concat($filterList, $this->pre_web->AdvancedSearch->toJson(), ","); // Field pre_web
		$filterList = Concat($filterList, $this->descripcion->AdvancedSearch->toJson(), ","); // Field descripcion
		$filterList = Concat($filterList, $this->descripcion1->AdvancedSearch->toJson(), ","); // Field descripcion1
		$filterList = Concat($filterList, $this->megusta->AdvancedSearch->toJson(), ","); // Field megusta
		$filterList = Concat($filterList, $this->nomegusta->AdvancedSearch->toJson(), ","); // Field nomegusta
		$filterList = Concat($filterList, $this->precio2->AdvancedSearch->toJson(), ","); // Field precio2
		$filterList = Concat($filterList, $this->precio3->AdvancedSearch->toJson(), ","); // Field precio3
		$filterList = Concat($filterList, $this->und_pro->AdvancedSearch->toJson(), ","); // Field und_pro
		$filterList = Concat($filterList, $this->barras->AdvancedSearch->toJson(), ","); // Field barras
		$filterList = Concat($filterList, $this->stockmin->AdvancedSearch->toJson(), ","); // Field stockmin
		$filterList = Concat($filterList, $this->id_grupo->AdvancedSearch->toJson(), ","); // Field id_grupo
		$filterList = Concat($filterList, $this->talla->AdvancedSearch->toJson(), ","); // Field talla
		$filterList = Concat($filterList, $this->mostrarcolor->AdvancedSearch->toJson(), ","); // Field mostrarcolor
		$filterList = Concat($filterList, $this->precio_mayorista->AdvancedSearch->toJson(), ","); // Field precio_mayorista
		$filterList = Concat($filterList, $this->precio_vendedor->AdvancedSearch->toJson(), ","); // Field precio_vendedor
		$filterList = Concat($filterList, $this->medida1->AdvancedSearch->toJson(), ","); // Field medida1
		$filterList = Concat($filterList, $this->medida2->AdvancedSearch->toJson(), ","); // Field medida2
		$filterList = Concat($filterList, $this->medida3->AdvancedSearch->toJson(), ","); // Field medida3
		$filterList = Concat($filterList, $this->codlogin->AdvancedSearch->toJson(), ","); // Field codlogin
		$filterList = Concat($filterList, $this->idempresa->AdvancedSearch->toJson(), ","); // Field idempresa
		$filterList = Concat($filterList, $this->urlstreetview->AdvancedSearch->toJson(), ","); // Field urlstreetview
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fproductslistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id_producto
		$this->id_producto->AdvancedSearch->SearchValue = @$filter["x_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator = @$filter["z_id_producto"];
		$this->id_producto->AdvancedSearch->SearchCondition = @$filter["v_id_producto"];
		$this->id_producto->AdvancedSearch->SearchValue2 = @$filter["y_id_producto"];
		$this->id_producto->AdvancedSearch->SearchOperator2 = @$filter["w_id_producto"];
		$this->id_producto->AdvancedSearch->save();

		// Field codigo_producto
		$this->codigo_producto->AdvancedSearch->SearchValue = @$filter["x_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchOperator = @$filter["z_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchCondition = @$filter["v_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchValue2 = @$filter["y_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->SearchOperator2 = @$filter["w_codigo_producto"];
		$this->codigo_producto->AdvancedSearch->save();

		// Field nombre_producto
		$this->nombre_producto->AdvancedSearch->SearchValue = @$filter["x_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchOperator = @$filter["z_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchCondition = @$filter["v_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchValue2 = @$filter["y_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->SearchOperator2 = @$filter["w_nombre_producto"];
		$this->nombre_producto->AdvancedSearch->save();

		// Field estado
		$this->estado->AdvancedSearch->SearchValue = @$filter["x_estado"];
		$this->estado->AdvancedSearch->SearchOperator = @$filter["z_estado"];
		$this->estado->AdvancedSearch->SearchCondition = @$filter["v_estado"];
		$this->estado->AdvancedSearch->SearchValue2 = @$filter["y_estado"];
		$this->estado->AdvancedSearch->SearchOperator2 = @$filter["w_estado"];
		$this->estado->AdvancedSearch->save();

		// Field status_producto
		$this->status_producto->AdvancedSearch->SearchValue = @$filter["x_status_producto"];
		$this->status_producto->AdvancedSearch->SearchOperator = @$filter["z_status_producto"];
		$this->status_producto->AdvancedSearch->SearchCondition = @$filter["v_status_producto"];
		$this->status_producto->AdvancedSearch->SearchValue2 = @$filter["y_status_producto"];
		$this->status_producto->AdvancedSearch->SearchOperator2 = @$filter["w_status_producto"];
		$this->status_producto->AdvancedSearch->save();

		// Field date_added
		$this->date_added->AdvancedSearch->SearchValue = @$filter["x_date_added"];
		$this->date_added->AdvancedSearch->SearchOperator = @$filter["z_date_added"];
		$this->date_added->AdvancedSearch->SearchCondition = @$filter["v_date_added"];
		$this->date_added->AdvancedSearch->SearchValue2 = @$filter["y_date_added"];
		$this->date_added->AdvancedSearch->SearchOperator2 = @$filter["w_date_added"];
		$this->date_added->AdvancedSearch->save();

		// Field precio_producto
		$this->precio_producto->AdvancedSearch->SearchValue = @$filter["x_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchOperator = @$filter["z_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchCondition = @$filter["v_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchValue2 = @$filter["y_precio_producto"];
		$this->precio_producto->AdvancedSearch->SearchOperator2 = @$filter["w_precio_producto"];
		$this->precio_producto->AdvancedSearch->save();

		// Field costo_producto
		$this->costo_producto->AdvancedSearch->SearchValue = @$filter["x_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchOperator = @$filter["z_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchCondition = @$filter["v_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchValue2 = @$filter["y_costo_producto"];
		$this->costo_producto->AdvancedSearch->SearchOperator2 = @$filter["w_costo_producto"];
		$this->costo_producto->AdvancedSearch->save();

		// Field mon_costo
		$this->mon_costo->AdvancedSearch->SearchValue = @$filter["x_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchOperator = @$filter["z_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchCondition = @$filter["v_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchValue2 = @$filter["y_mon_costo"];
		$this->mon_costo->AdvancedSearch->SearchOperator2 = @$filter["w_mon_costo"];
		$this->mon_costo->AdvancedSearch->save();

		// Field mon_venta
		$this->mon_venta->AdvancedSearch->SearchValue = @$filter["x_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchOperator = @$filter["z_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchCondition = @$filter["v_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchValue2 = @$filter["y_mon_venta"];
		$this->mon_venta->AdvancedSearch->SearchOperator2 = @$filter["w_mon_venta"];
		$this->mon_venta->AdvancedSearch->save();

		// Field pais
		$this->pais->AdvancedSearch->SearchValue = @$filter["x_pais"];
		$this->pais->AdvancedSearch->SearchOperator = @$filter["z_pais"];
		$this->pais->AdvancedSearch->SearchCondition = @$filter["v_pais"];
		$this->pais->AdvancedSearch->SearchValue2 = @$filter["y_pais"];
		$this->pais->AdvancedSearch->SearchOperator2 = @$filter["w_pais"];
		$this->pais->AdvancedSearch->save();

		// Field departamento
		$this->departamento->AdvancedSearch->SearchValue = @$filter["x_departamento"];
		$this->departamento->AdvancedSearch->SearchOperator = @$filter["z_departamento"];
		$this->departamento->AdvancedSearch->SearchCondition = @$filter["v_departamento"];
		$this->departamento->AdvancedSearch->SearchValue2 = @$filter["y_departamento"];
		$this->departamento->AdvancedSearch->SearchOperator2 = @$filter["w_departamento"];
		$this->departamento->AdvancedSearch->save();

		// Field distrito
		$this->distrito->AdvancedSearch->SearchValue = @$filter["x_distrito"];
		$this->distrito->AdvancedSearch->SearchOperator = @$filter["z_distrito"];
		$this->distrito->AdvancedSearch->SearchCondition = @$filter["v_distrito"];
		$this->distrito->AdvancedSearch->SearchValue2 = @$filter["y_distrito"];
		$this->distrito->AdvancedSearch->SearchOperator2 = @$filter["w_distrito"];
		$this->distrito->AdvancedSearch->save();

		// Field localidad
		$this->localidad->AdvancedSearch->SearchValue = @$filter["x_localidad"];
		$this->localidad->AdvancedSearch->SearchOperator = @$filter["z_localidad"];
		$this->localidad->AdvancedSearch->SearchCondition = @$filter["v_localidad"];
		$this->localidad->AdvancedSearch->SearchValue2 = @$filter["y_localidad"];
		$this->localidad->AdvancedSearch->SearchOperator2 = @$filter["w_localidad"];
		$this->localidad->AdvancedSearch->save();

		// Field zona
		$this->zona->AdvancedSearch->SearchValue = @$filter["x_zona"];
		$this->zona->AdvancedSearch->SearchOperator = @$filter["z_zona"];
		$this->zona->AdvancedSearch->SearchCondition = @$filter["v_zona"];
		$this->zona->AdvancedSearch->SearchValue2 = @$filter["y_zona"];
		$this->zona->AdvancedSearch->SearchOperator2 = @$filter["w_zona"];
		$this->zona->AdvancedSearch->save();

		// Field tipo_inmueble
		$this->tipo_inmueble->AdvancedSearch->SearchValue = @$filter["x_tipo_inmueble"];
		$this->tipo_inmueble->AdvancedSearch->SearchOperator = @$filter["z_tipo_inmueble"];
		$this->tipo_inmueble->AdvancedSearch->SearchCondition = @$filter["v_tipo_inmueble"];
		$this->tipo_inmueble->AdvancedSearch->SearchValue2 = @$filter["y_tipo_inmueble"];
		$this->tipo_inmueble->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_inmueble"];
		$this->tipo_inmueble->AdvancedSearch->save();

		// Field tipo_negocio
		$this->tipo_negocio->AdvancedSearch->SearchValue = @$filter["x_tipo_negocio"];
		$this->tipo_negocio->AdvancedSearch->SearchOperator = @$filter["z_tipo_negocio"];
		$this->tipo_negocio->AdvancedSearch->SearchCondition = @$filter["v_tipo_negocio"];
		$this->tipo_negocio->AdvancedSearch->SearchValue2 = @$filter["y_tipo_negocio"];
		$this->tipo_negocio->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_negocio"];
		$this->tipo_negocio->AdvancedSearch->save();

		// Field tiempo_alquiler
		$this->tiempo_alquiler->AdvancedSearch->SearchValue = @$filter["x_tiempo_alquiler"];
		$this->tiempo_alquiler->AdvancedSearch->SearchOperator = @$filter["z_tiempo_alquiler"];
		$this->tiempo_alquiler->AdvancedSearch->SearchCondition = @$filter["v_tiempo_alquiler"];
		$this->tiempo_alquiler->AdvancedSearch->SearchValue2 = @$filter["y_tiempo_alquiler"];
		$this->tiempo_alquiler->AdvancedSearch->SearchOperator2 = @$filter["w_tiempo_alquiler"];
		$this->tiempo_alquiler->AdvancedSearch->save();

		// Field moneda
		$this->moneda->AdvancedSearch->SearchValue = @$filter["x_moneda"];
		$this->moneda->AdvancedSearch->SearchOperator = @$filter["z_moneda"];
		$this->moneda->AdvancedSearch->SearchCondition = @$filter["v_moneda"];
		$this->moneda->AdvancedSearch->SearchValue2 = @$filter["y_moneda"];
		$this->moneda->AdvancedSearch->SearchOperator2 = @$filter["w_moneda"];
		$this->moneda->AdvancedSearch->save();

		// Field estado_inmueble
		$this->estado_inmueble->AdvancedSearch->SearchValue = @$filter["x_estado_inmueble"];
		$this->estado_inmueble->AdvancedSearch->SearchOperator = @$filter["z_estado_inmueble"];
		$this->estado_inmueble->AdvancedSearch->SearchCondition = @$filter["v_estado_inmueble"];
		$this->estado_inmueble->AdvancedSearch->SearchValue2 = @$filter["y_estado_inmueble"];
		$this->estado_inmueble->AdvancedSearch->SearchOperator2 = @$filter["w_estado_inmueble"];
		$this->estado_inmueble->AdvancedSearch->save();

		// Field area_construida
		$this->area_construida->AdvancedSearch->SearchValue = @$filter["x_area_construida"];
		$this->area_construida->AdvancedSearch->SearchOperator = @$filter["z_area_construida"];
		$this->area_construida->AdvancedSearch->SearchCondition = @$filter["v_area_construida"];
		$this->area_construida->AdvancedSearch->SearchValue2 = @$filter["y_area_construida"];
		$this->area_construida->AdvancedSearch->SearchOperator2 = @$filter["w_area_construida"];
		$this->area_construida->AdvancedSearch->save();

		// Field area_privada
		$this->area_privada->AdvancedSearch->SearchValue = @$filter["x_area_privada"];
		$this->area_privada->AdvancedSearch->SearchOperator = @$filter["z_area_privada"];
		$this->area_privada->AdvancedSearch->SearchCondition = @$filter["v_area_privada"];
		$this->area_privada->AdvancedSearch->SearchValue2 = @$filter["y_area_privada"];
		$this->area_privada->AdvancedSearch->SearchOperator2 = @$filter["w_area_privada"];
		$this->area_privada->AdvancedSearch->save();

		// Field area_terreno
		$this->area_terreno->AdvancedSearch->SearchValue = @$filter["x_area_terreno"];
		$this->area_terreno->AdvancedSearch->SearchOperator = @$filter["z_area_terreno"];
		$this->area_terreno->AdvancedSearch->SearchCondition = @$filter["v_area_terreno"];
		$this->area_terreno->AdvancedSearch->SearchValue2 = @$filter["y_area_terreno"];
		$this->area_terreno->AdvancedSearch->SearchOperator2 = @$filter["w_area_terreno"];
		$this->area_terreno->AdvancedSearch->save();

		// Field valor_administracion
		$this->valor_administracion->AdvancedSearch->SearchValue = @$filter["x_valor_administracion"];
		$this->valor_administracion->AdvancedSearch->SearchOperator = @$filter["z_valor_administracion"];
		$this->valor_administracion->AdvancedSearch->SearchCondition = @$filter["v_valor_administracion"];
		$this->valor_administracion->AdvancedSearch->SearchValue2 = @$filter["y_valor_administracion"];
		$this->valor_administracion->AdvancedSearch->SearchOperator2 = @$filter["w_valor_administracion"];
		$this->valor_administracion->AdvancedSearch->save();

		// Field dormitorios
		$this->dormitorios->AdvancedSearch->SearchValue = @$filter["x_dormitorios"];
		$this->dormitorios->AdvancedSearch->SearchOperator = @$filter["z_dormitorios"];
		$this->dormitorios->AdvancedSearch->SearchCondition = @$filter["v_dormitorios"];
		$this->dormitorios->AdvancedSearch->SearchValue2 = @$filter["y_dormitorios"];
		$this->dormitorios->AdvancedSearch->SearchOperator2 = @$filter["w_dormitorios"];
		$this->dormitorios->AdvancedSearch->save();

		// Field banios
		$this->banios->AdvancedSearch->SearchValue = @$filter["x_banios"];
		$this->banios->AdvancedSearch->SearchOperator = @$filter["z_banios"];
		$this->banios->AdvancedSearch->SearchCondition = @$filter["v_banios"];
		$this->banios->AdvancedSearch->SearchValue2 = @$filter["y_banios"];
		$this->banios->AdvancedSearch->SearchOperator2 = @$filter["w_banios"];
		$this->banios->AdvancedSearch->save();

		// Field garaje
		$this->garaje->AdvancedSearch->SearchValue = @$filter["x_garaje"];
		$this->garaje->AdvancedSearch->SearchOperator = @$filter["z_garaje"];
		$this->garaje->AdvancedSearch->SearchCondition = @$filter["v_garaje"];
		$this->garaje->AdvancedSearch->SearchValue2 = @$filter["y_garaje"];
		$this->garaje->AdvancedSearch->SearchOperator2 = @$filter["w_garaje"];
		$this->garaje->AdvancedSearch->save();

		// Field piso
		$this->piso->AdvancedSearch->SearchValue = @$filter["x_piso"];
		$this->piso->AdvancedSearch->SearchOperator = @$filter["z_piso"];
		$this->piso->AdvancedSearch->SearchCondition = @$filter["v_piso"];
		$this->piso->AdvancedSearch->SearchValue2 = @$filter["y_piso"];
		$this->piso->AdvancedSearch->SearchOperator2 = @$filter["w_piso"];
		$this->piso->AdvancedSearch->save();

		// Field estrato
		$this->estrato->AdvancedSearch->SearchValue = @$filter["x_estrato"];
		$this->estrato->AdvancedSearch->SearchOperator = @$filter["z_estrato"];
		$this->estrato->AdvancedSearch->SearchCondition = @$filter["v_estrato"];
		$this->estrato->AdvancedSearch->SearchValue2 = @$filter["y_estrato"];
		$this->estrato->AdvancedSearch->SearchOperator2 = @$filter["w_estrato"];
		$this->estrato->AdvancedSearch->save();

		// Field direccion
		$this->direccion->AdvancedSearch->SearchValue = @$filter["x_direccion"];
		$this->direccion->AdvancedSearch->SearchOperator = @$filter["z_direccion"];
		$this->direccion->AdvancedSearch->SearchCondition = @$filter["v_direccion"];
		$this->direccion->AdvancedSearch->SearchValue2 = @$filter["y_direccion"];
		$this->direccion->AdvancedSearch->SearchOperator2 = @$filter["w_direccion"];
		$this->direccion->AdvancedSearch->save();

		// Field codigo_postal
		$this->codigo_postal->AdvancedSearch->SearchValue = @$filter["x_codigo_postal"];
		$this->codigo_postal->AdvancedSearch->SearchOperator = @$filter["z_codigo_postal"];
		$this->codigo_postal->AdvancedSearch->SearchCondition = @$filter["v_codigo_postal"];
		$this->codigo_postal->AdvancedSearch->SearchValue2 = @$filter["y_codigo_postal"];
		$this->codigo_postal->AdvancedSearch->SearchOperator2 = @$filter["w_codigo_postal"];
		$this->codigo_postal->AdvancedSearch->save();

		// Field mapa
		$this->mapa->AdvancedSearch->SearchValue = @$filter["x_mapa"];
		$this->mapa->AdvancedSearch->SearchOperator = @$filter["z_mapa"];
		$this->mapa->AdvancedSearch->SearchCondition = @$filter["v_mapa"];
		$this->mapa->AdvancedSearch->SearchValue2 = @$filter["y_mapa"];
		$this->mapa->AdvancedSearch->SearchOperator2 = @$filter["w_mapa"];
		$this->mapa->AdvancedSearch->save();

		// Field latitud
		$this->latitud->AdvancedSearch->SearchValue = @$filter["x_latitud"];
		$this->latitud->AdvancedSearch->SearchOperator = @$filter["z_latitud"];
		$this->latitud->AdvancedSearch->SearchCondition = @$filter["v_latitud"];
		$this->latitud->AdvancedSearch->SearchValue2 = @$filter["y_latitud"];
		$this->latitud->AdvancedSearch->SearchOperator2 = @$filter["w_latitud"];
		$this->latitud->AdvancedSearch->save();

		// Field longitud
		$this->longitud->AdvancedSearch->SearchValue = @$filter["x_longitud"];
		$this->longitud->AdvancedSearch->SearchOperator = @$filter["z_longitud"];
		$this->longitud->AdvancedSearch->SearchCondition = @$filter["v_longitud"];
		$this->longitud->AdvancedSearch->SearchValue2 = @$filter["y_longitud"];
		$this->longitud->AdvancedSearch->SearchOperator2 = @$filter["w_longitud"];
		$this->longitud->AdvancedSearch->save();

		// Field opciones_mapa
		$this->opciones_mapa->AdvancedSearch->SearchValue = @$filter["x_opciones_mapa"];
		$this->opciones_mapa->AdvancedSearch->SearchOperator = @$filter["z_opciones_mapa"];
		$this->opciones_mapa->AdvancedSearch->SearchCondition = @$filter["v_opciones_mapa"];
		$this->opciones_mapa->AdvancedSearch->SearchValue2 = @$filter["y_opciones_mapa"];
		$this->opciones_mapa->AdvancedSearch->SearchOperator2 = @$filter["w_opciones_mapa"];
		$this->opciones_mapa->AdvancedSearch->save();

		// Field red
		$this->red->AdvancedSearch->SearchValue = @$filter["x_red"];
		$this->red->AdvancedSearch->SearchOperator = @$filter["z_red"];
		$this->red->AdvancedSearch->SearchCondition = @$filter["v_red"];
		$this->red->AdvancedSearch->SearchValue2 = @$filter["y_red"];
		$this->red->AdvancedSearch->SearchOperator2 = @$filter["w_red"];
		$this->red->AdvancedSearch->save();

		// Field video
		$this->video->AdvancedSearch->SearchValue = @$filter["x_video"];
		$this->video->AdvancedSearch->SearchOperator = @$filter["z_video"];
		$this->video->AdvancedSearch->SearchCondition = @$filter["v_video"];
		$this->video->AdvancedSearch->SearchValue2 = @$filter["y_video"];
		$this->video->AdvancedSearch->SearchOperator2 = @$filter["w_video"];
		$this->video->AdvancedSearch->save();

		// Field disponibilidad
		$this->disponibilidad->AdvancedSearch->SearchValue = @$filter["x_disponibilidad"];
		$this->disponibilidad->AdvancedSearch->SearchOperator = @$filter["z_disponibilidad"];
		$this->disponibilidad->AdvancedSearch->SearchCondition = @$filter["v_disponibilidad"];
		$this->disponibilidad->AdvancedSearch->SearchValue2 = @$filter["y_disponibilidad"];
		$this->disponibilidad->AdvancedSearch->SearchOperator2 = @$filter["w_disponibilidad"];
		$this->disponibilidad->AdvancedSearch->save();

		// Field anio_construccion
		$this->anio_construccion->AdvancedSearch->SearchValue = @$filter["x_anio_construccion"];
		$this->anio_construccion->AdvancedSearch->SearchOperator = @$filter["z_anio_construccion"];
		$this->anio_construccion->AdvancedSearch->SearchCondition = @$filter["v_anio_construccion"];
		$this->anio_construccion->AdvancedSearch->SearchValue2 = @$filter["y_anio_construccion"];
		$this->anio_construccion->AdvancedSearch->SearchOperator2 = @$filter["w_anio_construccion"];
		$this->anio_construccion->AdvancedSearch->save();

		// Field encargado
		$this->encargado->AdvancedSearch->SearchValue = @$filter["x_encargado"];
		$this->encargado->AdvancedSearch->SearchOperator = @$filter["z_encargado"];
		$this->encargado->AdvancedSearch->SearchCondition = @$filter["v_encargado"];
		$this->encargado->AdvancedSearch->SearchValue2 = @$filter["y_encargado"];
		$this->encargado->AdvancedSearch->SearchOperator2 = @$filter["w_encargado"];
		$this->encargado->AdvancedSearch->save();

		// Field comentario
		$this->comentario->AdvancedSearch->SearchValue = @$filter["x_comentario"];
		$this->comentario->AdvancedSearch->SearchOperator = @$filter["z_comentario"];
		$this->comentario->AdvancedSearch->SearchCondition = @$filter["v_comentario"];
		$this->comentario->AdvancedSearch->SearchValue2 = @$filter["y_comentario"];
		$this->comentario->AdvancedSearch->SearchOperator2 = @$filter["w_comentario"];
		$this->comentario->AdvancedSearch->save();

		// Field visitas
		$this->visitas->AdvancedSearch->SearchValue = @$filter["x_visitas"];
		$this->visitas->AdvancedSearch->SearchOperator = @$filter["z_visitas"];
		$this->visitas->AdvancedSearch->SearchCondition = @$filter["v_visitas"];
		$this->visitas->AdvancedSearch->SearchValue2 = @$filter["y_visitas"];
		$this->visitas->AdvancedSearch->SearchOperator2 = @$filter["w_visitas"];
		$this->visitas->AdvancedSearch->save();

		// Field valor_comision
		$this->valor_comision->AdvancedSearch->SearchValue = @$filter["x_valor_comision"];
		$this->valor_comision->AdvancedSearch->SearchOperator = @$filter["z_valor_comision"];
		$this->valor_comision->AdvancedSearch->SearchCondition = @$filter["v_valor_comision"];
		$this->valor_comision->AdvancedSearch->SearchValue2 = @$filter["y_valor_comision"];
		$this->valor_comision->AdvancedSearch->SearchOperator2 = @$filter["w_valor_comision"];
		$this->valor_comision->AdvancedSearch->save();

		// Field tipo_comision
		$this->tipo_comision->AdvancedSearch->SearchValue = @$filter["x_tipo_comision"];
		$this->tipo_comision->AdvancedSearch->SearchOperator = @$filter["z_tipo_comision"];
		$this->tipo_comision->AdvancedSearch->SearchCondition = @$filter["v_tipo_comision"];
		$this->tipo_comision->AdvancedSearch->SearchValue2 = @$filter["y_tipo_comision"];
		$this->tipo_comision->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_comision"];
		$this->tipo_comision->AdvancedSearch->save();

		// Field certificado
		$this->certificado->AdvancedSearch->SearchValue = @$filter["x_certificado"];
		$this->certificado->AdvancedSearch->SearchOperator = @$filter["z_certificado"];
		$this->certificado->AdvancedSearch->SearchCondition = @$filter["v_certificado"];
		$this->certificado->AdvancedSearch->SearchValue2 = @$filter["y_certificado"];
		$this->certificado->AdvancedSearch->SearchOperator2 = @$filter["w_certificado"];
		$this->certificado->AdvancedSearch->save();

		// Field nombre_propietario
		$this->nombre_propietario->AdvancedSearch->SearchValue = @$filter["x_nombre_propietario"];
		$this->nombre_propietario->AdvancedSearch->SearchOperator = @$filter["z_nombre_propietario"];
		$this->nombre_propietario->AdvancedSearch->SearchCondition = @$filter["v_nombre_propietario"];
		$this->nombre_propietario->AdvancedSearch->SearchValue2 = @$filter["y_nombre_propietario"];
		$this->nombre_propietario->AdvancedSearch->SearchOperator2 = @$filter["w_nombre_propietario"];
		$this->nombre_propietario->AdvancedSearch->save();

		// Field movil_propietario
		$this->movil_propietario->AdvancedSearch->SearchValue = @$filter["x_movil_propietario"];
		$this->movil_propietario->AdvancedSearch->SearchOperator = @$filter["z_movil_propietario"];
		$this->movil_propietario->AdvancedSearch->SearchCondition = @$filter["v_movil_propietario"];
		$this->movil_propietario->AdvancedSearch->SearchValue2 = @$filter["y_movil_propietario"];
		$this->movil_propietario->AdvancedSearch->SearchOperator2 = @$filter["w_movil_propietario"];
		$this->movil_propietario->AdvancedSearch->save();

		// Field telefono_propietario
		$this->telefono_propietario->AdvancedSearch->SearchValue = @$filter["x_telefono_propietario"];
		$this->telefono_propietario->AdvancedSearch->SearchOperator = @$filter["z_telefono_propietario"];
		$this->telefono_propietario->AdvancedSearch->SearchCondition = @$filter["v_telefono_propietario"];
		$this->telefono_propietario->AdvancedSearch->SearchValue2 = @$filter["y_telefono_propietario"];
		$this->telefono_propietario->AdvancedSearch->SearchOperator2 = @$filter["w_telefono_propietario"];
		$this->telefono_propietario->AdvancedSearch->save();

		// Field correo_propietario
		$this->correo_propietario->AdvancedSearch->SearchValue = @$filter["x_correo_propietario"];
		$this->correo_propietario->AdvancedSearch->SearchOperator = @$filter["z_correo_propietario"];
		$this->correo_propietario->AdvancedSearch->SearchCondition = @$filter["v_correo_propietario"];
		$this->correo_propietario->AdvancedSearch->SearchValue2 = @$filter["y_correo_propietario"];
		$this->correo_propietario->AdvancedSearch->SearchOperator2 = @$filter["w_correo_propietario"];
		$this->correo_propietario->AdvancedSearch->save();

		// Field vinculo
		$this->vinculo->AdvancedSearch->SearchValue = @$filter["x_vinculo"];
		$this->vinculo->AdvancedSearch->SearchOperator = @$filter["z_vinculo"];
		$this->vinculo->AdvancedSearch->SearchCondition = @$filter["v_vinculo"];
		$this->vinculo->AdvancedSearch->SearchValue2 = @$filter["y_vinculo"];
		$this->vinculo->AdvancedSearch->SearchOperator2 = @$filter["w_vinculo"];
		$this->vinculo->AdvancedSearch->save();

		// Field portales
		$this->portales->AdvancedSearch->SearchValue = @$filter["x_portales"];
		$this->portales->AdvancedSearch->SearchOperator = @$filter["z_portales"];
		$this->portales->AdvancedSearch->SearchCondition = @$filter["v_portales"];
		$this->portales->AdvancedSearch->SearchValue2 = @$filter["y_portales"];
		$this->portales->AdvancedSearch->SearchOperator2 = @$filter["w_portales"];
		$this->portales->AdvancedSearch->save();

		// Field notas
		$this->notas->AdvancedSearch->SearchValue = @$filter["x_notas"];
		$this->notas->AdvancedSearch->SearchOperator = @$filter["z_notas"];
		$this->notas->AdvancedSearch->SearchCondition = @$filter["v_notas"];
		$this->notas->AdvancedSearch->SearchValue2 = @$filter["y_notas"];
		$this->notas->AdvancedSearch->SearchOperator2 = @$filter["w_notas"];
		$this->notas->AdvancedSearch->save();

		// Field marca
		$this->marca->AdvancedSearch->SearchValue = @$filter["x_marca"];
		$this->marca->AdvancedSearch->SearchOperator = @$filter["z_marca"];
		$this->marca->AdvancedSearch->SearchCondition = @$filter["v_marca"];
		$this->marca->AdvancedSearch->SearchValue2 = @$filter["y_marca"];
		$this->marca->AdvancedSearch->SearchOperator2 = @$filter["w_marca"];
		$this->marca->AdvancedSearch->save();

		// Field modelo
		$this->modelo->AdvancedSearch->SearchValue = @$filter["x_modelo"];
		$this->modelo->AdvancedSearch->SearchOperator = @$filter["z_modelo"];
		$this->modelo->AdvancedSearch->SearchCondition = @$filter["v_modelo"];
		$this->modelo->AdvancedSearch->SearchValue2 = @$filter["y_modelo"];
		$this->modelo->AdvancedSearch->SearchOperator2 = @$filter["w_modelo"];
		$this->modelo->AdvancedSearch->save();

		// Field color
		$this->color->AdvancedSearch->SearchValue = @$filter["x_color"];
		$this->color->AdvancedSearch->SearchOperator = @$filter["z_color"];
		$this->color->AdvancedSearch->SearchCondition = @$filter["v_color"];
		$this->color->AdvancedSearch->SearchValue2 = @$filter["y_color"];
		$this->color->AdvancedSearch->SearchOperator2 = @$filter["w_color"];
		$this->color->AdvancedSearch->save();

		// Field b1
		$this->b1->AdvancedSearch->SearchValue = @$filter["x_b1"];
		$this->b1->AdvancedSearch->SearchOperator = @$filter["z_b1"];
		$this->b1->AdvancedSearch->SearchCondition = @$filter["v_b1"];
		$this->b1->AdvancedSearch->SearchValue2 = @$filter["y_b1"];
		$this->b1->AdvancedSearch->SearchOperator2 = @$filter["w_b1"];
		$this->b1->AdvancedSearch->save();

		// Field b2
		$this->b2->AdvancedSearch->SearchValue = @$filter["x_b2"];
		$this->b2->AdvancedSearch->SearchOperator = @$filter["z_b2"];
		$this->b2->AdvancedSearch->SearchCondition = @$filter["v_b2"];
		$this->b2->AdvancedSearch->SearchValue2 = @$filter["y_b2"];
		$this->b2->AdvancedSearch->SearchOperator2 = @$filter["w_b2"];
		$this->b2->AdvancedSearch->save();

		// Field b3
		$this->b3->AdvancedSearch->SearchValue = @$filter["x_b3"];
		$this->b3->AdvancedSearch->SearchOperator = @$filter["z_b3"];
		$this->b3->AdvancedSearch->SearchCondition = @$filter["v_b3"];
		$this->b3->AdvancedSearch->SearchValue2 = @$filter["y_b3"];
		$this->b3->AdvancedSearch->SearchOperator2 = @$filter["w_b3"];
		$this->b3->AdvancedSearch->save();

		// Field b4
		$this->b4->AdvancedSearch->SearchValue = @$filter["x_b4"];
		$this->b4->AdvancedSearch->SearchOperator = @$filter["z_b4"];
		$this->b4->AdvancedSearch->SearchCondition = @$filter["v_b4"];
		$this->b4->AdvancedSearch->SearchValue2 = @$filter["y_b4"];
		$this->b4->AdvancedSearch->SearchOperator2 = @$filter["w_b4"];
		$this->b4->AdvancedSearch->save();

		// Field b5
		$this->b5->AdvancedSearch->SearchValue = @$filter["x_b5"];
		$this->b5->AdvancedSearch->SearchOperator = @$filter["z_b5"];
		$this->b5->AdvancedSearch->SearchCondition = @$filter["v_b5"];
		$this->b5->AdvancedSearch->SearchValue2 = @$filter["y_b5"];
		$this->b5->AdvancedSearch->SearchOperator2 = @$filter["w_b5"];
		$this->b5->AdvancedSearch->save();

		// Field b6
		$this->b6->AdvancedSearch->SearchValue = @$filter["x_b6"];
		$this->b6->AdvancedSearch->SearchOperator = @$filter["z_b6"];
		$this->b6->AdvancedSearch->SearchCondition = @$filter["v_b6"];
		$this->b6->AdvancedSearch->SearchValue2 = @$filter["y_b6"];
		$this->b6->AdvancedSearch->SearchOperator2 = @$filter["w_b6"];
		$this->b6->AdvancedSearch->save();

		// Field cat_pro
		$this->cat_pro->AdvancedSearch->SearchValue = @$filter["x_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchOperator = @$filter["z_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchCondition = @$filter["v_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchValue2 = @$filter["y_cat_pro"];
		$this->cat_pro->AdvancedSearch->SearchOperator2 = @$filter["w_cat_pro"];
		$this->cat_pro->AdvancedSearch->save();

		// Field pro_ser
		$this->pro_ser->AdvancedSearch->SearchValue = @$filter["x_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchOperator = @$filter["z_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchCondition = @$filter["v_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchValue2 = @$filter["y_pro_ser"];
		$this->pro_ser->AdvancedSearch->SearchOperator2 = @$filter["w_pro_ser"];
		$this->pro_ser->AdvancedSearch->save();

		// Field foto1
		$this->foto1->AdvancedSearch->SearchValue = @$filter["x_foto1"];
		$this->foto1->AdvancedSearch->SearchOperator = @$filter["z_foto1"];
		$this->foto1->AdvancedSearch->SearchCondition = @$filter["v_foto1"];
		$this->foto1->AdvancedSearch->SearchValue2 = @$filter["y_foto1"];
		$this->foto1->AdvancedSearch->SearchOperator2 = @$filter["w_foto1"];
		$this->foto1->AdvancedSearch->save();

		// Field foto2
		$this->foto2->AdvancedSearch->SearchValue = @$filter["x_foto2"];
		$this->foto2->AdvancedSearch->SearchOperator = @$filter["z_foto2"];
		$this->foto2->AdvancedSearch->SearchCondition = @$filter["v_foto2"];
		$this->foto2->AdvancedSearch->SearchValue2 = @$filter["y_foto2"];
		$this->foto2->AdvancedSearch->SearchOperator2 = @$filter["w_foto2"];
		$this->foto2->AdvancedSearch->save();

		// Field foto3
		$this->foto3->AdvancedSearch->SearchValue = @$filter["x_foto3"];
		$this->foto3->AdvancedSearch->SearchOperator = @$filter["z_foto3"];
		$this->foto3->AdvancedSearch->SearchCondition = @$filter["v_foto3"];
		$this->foto3->AdvancedSearch->SearchValue2 = @$filter["y_foto3"];
		$this->foto3->AdvancedSearch->SearchOperator2 = @$filter["w_foto3"];
		$this->foto3->AdvancedSearch->save();

		// Field foto4
		$this->foto4->AdvancedSearch->SearchValue = @$filter["x_foto4"];
		$this->foto4->AdvancedSearch->SearchOperator = @$filter["z_foto4"];
		$this->foto4->AdvancedSearch->SearchCondition = @$filter["v_foto4"];
		$this->foto4->AdvancedSearch->SearchValue2 = @$filter["y_foto4"];
		$this->foto4->AdvancedSearch->SearchOperator2 = @$filter["w_foto4"];
		$this->foto4->AdvancedSearch->save();

		// Field web
		$this->web->AdvancedSearch->SearchValue = @$filter["x_web"];
		$this->web->AdvancedSearch->SearchOperator = @$filter["z_web"];
		$this->web->AdvancedSearch->SearchCondition = @$filter["v_web"];
		$this->web->AdvancedSearch->SearchValue2 = @$filter["y_web"];
		$this->web->AdvancedSearch->SearchOperator2 = @$filter["w_web"];
		$this->web->AdvancedSearch->save();

		// Field pre_web
		$this->pre_web->AdvancedSearch->SearchValue = @$filter["x_pre_web"];
		$this->pre_web->AdvancedSearch->SearchOperator = @$filter["z_pre_web"];
		$this->pre_web->AdvancedSearch->SearchCondition = @$filter["v_pre_web"];
		$this->pre_web->AdvancedSearch->SearchValue2 = @$filter["y_pre_web"];
		$this->pre_web->AdvancedSearch->SearchOperator2 = @$filter["w_pre_web"];
		$this->pre_web->AdvancedSearch->save();

		// Field descripcion
		$this->descripcion->AdvancedSearch->SearchValue = @$filter["x_descripcion"];
		$this->descripcion->AdvancedSearch->SearchOperator = @$filter["z_descripcion"];
		$this->descripcion->AdvancedSearch->SearchCondition = @$filter["v_descripcion"];
		$this->descripcion->AdvancedSearch->SearchValue2 = @$filter["y_descripcion"];
		$this->descripcion->AdvancedSearch->SearchOperator2 = @$filter["w_descripcion"];
		$this->descripcion->AdvancedSearch->save();

		// Field descripcion1
		$this->descripcion1->AdvancedSearch->SearchValue = @$filter["x_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchOperator = @$filter["z_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchCondition = @$filter["v_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchValue2 = @$filter["y_descripcion1"];
		$this->descripcion1->AdvancedSearch->SearchOperator2 = @$filter["w_descripcion1"];
		$this->descripcion1->AdvancedSearch->save();

		// Field megusta
		$this->megusta->AdvancedSearch->SearchValue = @$filter["x_megusta"];
		$this->megusta->AdvancedSearch->SearchOperator = @$filter["z_megusta"];
		$this->megusta->AdvancedSearch->SearchCondition = @$filter["v_megusta"];
		$this->megusta->AdvancedSearch->SearchValue2 = @$filter["y_megusta"];
		$this->megusta->AdvancedSearch->SearchOperator2 = @$filter["w_megusta"];
		$this->megusta->AdvancedSearch->save();

		// Field nomegusta
		$this->nomegusta->AdvancedSearch->SearchValue = @$filter["x_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchOperator = @$filter["z_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchCondition = @$filter["v_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchValue2 = @$filter["y_nomegusta"];
		$this->nomegusta->AdvancedSearch->SearchOperator2 = @$filter["w_nomegusta"];
		$this->nomegusta->AdvancedSearch->save();

		// Field precio2
		$this->precio2->AdvancedSearch->SearchValue = @$filter["x_precio2"];
		$this->precio2->AdvancedSearch->SearchOperator = @$filter["z_precio2"];
		$this->precio2->AdvancedSearch->SearchCondition = @$filter["v_precio2"];
		$this->precio2->AdvancedSearch->SearchValue2 = @$filter["y_precio2"];
		$this->precio2->AdvancedSearch->SearchOperator2 = @$filter["w_precio2"];
		$this->precio2->AdvancedSearch->save();

		// Field precio3
		$this->precio3->AdvancedSearch->SearchValue = @$filter["x_precio3"];
		$this->precio3->AdvancedSearch->SearchOperator = @$filter["z_precio3"];
		$this->precio3->AdvancedSearch->SearchCondition = @$filter["v_precio3"];
		$this->precio3->AdvancedSearch->SearchValue2 = @$filter["y_precio3"];
		$this->precio3->AdvancedSearch->SearchOperator2 = @$filter["w_precio3"];
		$this->precio3->AdvancedSearch->save();

		// Field und_pro
		$this->und_pro->AdvancedSearch->SearchValue = @$filter["x_und_pro"];
		$this->und_pro->AdvancedSearch->SearchOperator = @$filter["z_und_pro"];
		$this->und_pro->AdvancedSearch->SearchCondition = @$filter["v_und_pro"];
		$this->und_pro->AdvancedSearch->SearchValue2 = @$filter["y_und_pro"];
		$this->und_pro->AdvancedSearch->SearchOperator2 = @$filter["w_und_pro"];
		$this->und_pro->AdvancedSearch->save();

		// Field barras
		$this->barras->AdvancedSearch->SearchValue = @$filter["x_barras"];
		$this->barras->AdvancedSearch->SearchOperator = @$filter["z_barras"];
		$this->barras->AdvancedSearch->SearchCondition = @$filter["v_barras"];
		$this->barras->AdvancedSearch->SearchValue2 = @$filter["y_barras"];
		$this->barras->AdvancedSearch->SearchOperator2 = @$filter["w_barras"];
		$this->barras->AdvancedSearch->save();

		// Field stockmin
		$this->stockmin->AdvancedSearch->SearchValue = @$filter["x_stockmin"];
		$this->stockmin->AdvancedSearch->SearchOperator = @$filter["z_stockmin"];
		$this->stockmin->AdvancedSearch->SearchCondition = @$filter["v_stockmin"];
		$this->stockmin->AdvancedSearch->SearchValue2 = @$filter["y_stockmin"];
		$this->stockmin->AdvancedSearch->SearchOperator2 = @$filter["w_stockmin"];
		$this->stockmin->AdvancedSearch->save();

		// Field id_grupo
		$this->id_grupo->AdvancedSearch->SearchValue = @$filter["x_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchOperator = @$filter["z_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchCondition = @$filter["v_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchValue2 = @$filter["y_id_grupo"];
		$this->id_grupo->AdvancedSearch->SearchOperator2 = @$filter["w_id_grupo"];
		$this->id_grupo->AdvancedSearch->save();

		// Field talla
		$this->talla->AdvancedSearch->SearchValue = @$filter["x_talla"];
		$this->talla->AdvancedSearch->SearchOperator = @$filter["z_talla"];
		$this->talla->AdvancedSearch->SearchCondition = @$filter["v_talla"];
		$this->talla->AdvancedSearch->SearchValue2 = @$filter["y_talla"];
		$this->talla->AdvancedSearch->SearchOperator2 = @$filter["w_talla"];
		$this->talla->AdvancedSearch->save();

		// Field mostrarcolor
		$this->mostrarcolor->AdvancedSearch->SearchValue = @$filter["x_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchOperator = @$filter["z_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchCondition = @$filter["v_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchValue2 = @$filter["y_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->SearchOperator2 = @$filter["w_mostrarcolor"];
		$this->mostrarcolor->AdvancedSearch->save();

		// Field precio_mayorista
		$this->precio_mayorista->AdvancedSearch->SearchValue = @$filter["x_precio_mayorista"];
		$this->precio_mayorista->AdvancedSearch->SearchOperator = @$filter["z_precio_mayorista"];
		$this->precio_mayorista->AdvancedSearch->SearchCondition = @$filter["v_precio_mayorista"];
		$this->precio_mayorista->AdvancedSearch->SearchValue2 = @$filter["y_precio_mayorista"];
		$this->precio_mayorista->AdvancedSearch->SearchOperator2 = @$filter["w_precio_mayorista"];
		$this->precio_mayorista->AdvancedSearch->save();

		// Field precio_vendedor
		$this->precio_vendedor->AdvancedSearch->SearchValue = @$filter["x_precio_vendedor"];
		$this->precio_vendedor->AdvancedSearch->SearchOperator = @$filter["z_precio_vendedor"];
		$this->precio_vendedor->AdvancedSearch->SearchCondition = @$filter["v_precio_vendedor"];
		$this->precio_vendedor->AdvancedSearch->SearchValue2 = @$filter["y_precio_vendedor"];
		$this->precio_vendedor->AdvancedSearch->SearchOperator2 = @$filter["w_precio_vendedor"];
		$this->precio_vendedor->AdvancedSearch->save();

		// Field medida1
		$this->medida1->AdvancedSearch->SearchValue = @$filter["x_medida1"];
		$this->medida1->AdvancedSearch->SearchOperator = @$filter["z_medida1"];
		$this->medida1->AdvancedSearch->SearchCondition = @$filter["v_medida1"];
		$this->medida1->AdvancedSearch->SearchValue2 = @$filter["y_medida1"];
		$this->medida1->AdvancedSearch->SearchOperator2 = @$filter["w_medida1"];
		$this->medida1->AdvancedSearch->save();

		// Field medida2
		$this->medida2->AdvancedSearch->SearchValue = @$filter["x_medida2"];
		$this->medida2->AdvancedSearch->SearchOperator = @$filter["z_medida2"];
		$this->medida2->AdvancedSearch->SearchCondition = @$filter["v_medida2"];
		$this->medida2->AdvancedSearch->SearchValue2 = @$filter["y_medida2"];
		$this->medida2->AdvancedSearch->SearchOperator2 = @$filter["w_medida2"];
		$this->medida2->AdvancedSearch->save();

		// Field medida3
		$this->medida3->AdvancedSearch->SearchValue = @$filter["x_medida3"];
		$this->medida3->AdvancedSearch->SearchOperator = @$filter["z_medida3"];
		$this->medida3->AdvancedSearch->SearchCondition = @$filter["v_medida3"];
		$this->medida3->AdvancedSearch->SearchValue2 = @$filter["y_medida3"];
		$this->medida3->AdvancedSearch->SearchOperator2 = @$filter["w_medida3"];
		$this->medida3->AdvancedSearch->save();

		// Field codlogin
		$this->codlogin->AdvancedSearch->SearchValue = @$filter["x_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator = @$filter["z_codlogin"];
		$this->codlogin->AdvancedSearch->SearchCondition = @$filter["v_codlogin"];
		$this->codlogin->AdvancedSearch->SearchValue2 = @$filter["y_codlogin"];
		$this->codlogin->AdvancedSearch->SearchOperator2 = @$filter["w_codlogin"];
		$this->codlogin->AdvancedSearch->save();

		// Field idempresa
		$this->idempresa->AdvancedSearch->SearchValue = @$filter["x_idempresa"];
		$this->idempresa->AdvancedSearch->SearchOperator = @$filter["z_idempresa"];
		$this->idempresa->AdvancedSearch->SearchCondition = @$filter["v_idempresa"];
		$this->idempresa->AdvancedSearch->SearchValue2 = @$filter["y_idempresa"];
		$this->idempresa->AdvancedSearch->SearchOperator2 = @$filter["w_idempresa"];
		$this->idempresa->AdvancedSearch->save();

		// Field urlstreetview
		$this->urlstreetview->AdvancedSearch->SearchValue = @$filter["x_urlstreetview"];
		$this->urlstreetview->AdvancedSearch->SearchOperator = @$filter["z_urlstreetview"];
		$this->urlstreetview->AdvancedSearch->SearchCondition = @$filter["v_urlstreetview"];
		$this->urlstreetview->AdvancedSearch->SearchValue2 = @$filter["y_urlstreetview"];
		$this->urlstreetview->AdvancedSearch->SearchOperator2 = @$filter["w_urlstreetview"];
		$this->urlstreetview->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->codigo_producto, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombre_producto, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pais, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->departamento, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->distrito, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->localidad, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->zona, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tipo_negocio, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tiempo_alquiler, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->moneda, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->estado_inmueble, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->area_construida, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->area_privada, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->area_terreno, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->valor_administracion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dormitorios, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->banios, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->garaje, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->piso, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->estrato, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->direccion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->codigo_postal, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mapa, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->latitud, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->longitud, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->opciones_mapa, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->red, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->video, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->disponibilidad, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->anio_construccion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->encargado, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->comentario, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->visitas, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->tipo_comision, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->certificado, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nombre_propietario, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->movil_propietario, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->telefono_propietario, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->correo_propietario, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->vinculo, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->portales, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->notas, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->marca, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->modelo, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->color, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->foto4, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->descripcion, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->descripcion1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->barras, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->talla, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->medida1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->medida2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->medida3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->codlogin, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->urlstreetview, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id_producto); // id_producto
			$this->updateSort($this->codigo_producto); // codigo_producto
			$this->updateSort($this->estado); // estado
			$this->updateSort($this->status_producto); // status_producto
			$this->updateSort($this->date_added); // date_added
			$this->updateSort($this->precio_producto); // precio_producto
			$this->updateSort($this->costo_producto); // costo_producto
			$this->updateSort($this->mon_costo); // mon_costo
			$this->updateSort($this->mon_venta); // mon_venta
			$this->updateSort($this->pais); // pais
			$this->updateSort($this->departamento); // departamento
			$this->updateSort($this->distrito); // distrito
			$this->updateSort($this->localidad); // localidad
			$this->updateSort($this->zona); // zona
			$this->updateSort($this->tipo_inmueble); // tipo_inmueble
			$this->updateSort($this->tipo_negocio); // tipo_negocio
			$this->updateSort($this->tiempo_alquiler); // tiempo_alquiler
			$this->updateSort($this->moneda); // moneda
			$this->updateSort($this->estado_inmueble); // estado_inmueble
			$this->updateSort($this->area_construida); // area_construida
			$this->updateSort($this->area_privada); // area_privada
			$this->updateSort($this->area_terreno); // area_terreno
			$this->updateSort($this->valor_administracion); // valor_administracion
			$this->updateSort($this->dormitorios); // dormitorios
			$this->updateSort($this->banios); // banios
			$this->updateSort($this->garaje); // garaje
			$this->updateSort($this->piso); // piso
			$this->updateSort($this->estrato); // estrato
			$this->updateSort($this->codigo_postal); // codigo_postal
			$this->updateSort($this->mapa); // mapa
			$this->updateSort($this->latitud); // latitud
			$this->updateSort($this->longitud); // longitud
			$this->updateSort($this->opciones_mapa); // opciones_mapa
			$this->updateSort($this->red); // red
			$this->updateSort($this->disponibilidad); // disponibilidad
			$this->updateSort($this->anio_construccion); // anio_construccion
			$this->updateSort($this->encargado); // encargado
			$this->updateSort($this->visitas); // visitas
			$this->updateSort($this->valor_comision); // valor_comision
			$this->updateSort($this->tipo_comision); // tipo_comision
			$this->updateSort($this->certificado); // certificado
			$this->updateSort($this->nombre_propietario); // nombre_propietario
			$this->updateSort($this->movil_propietario); // movil_propietario
			$this->updateSort($this->telefono_propietario); // telefono_propietario
			$this->updateSort($this->correo_propietario); // correo_propietario
			$this->updateSort($this->vinculo); // vinculo
			$this->updateSort($this->notas); // notas
			$this->updateSort($this->marca); // marca
			$this->updateSort($this->modelo); // modelo
			$this->updateSort($this->color); // color
			$this->updateSort($this->b1); // b1
			$this->updateSort($this->b2); // b2
			$this->updateSort($this->b3); // b3
			$this->updateSort($this->b4); // b4
			$this->updateSort($this->b5); // b5
			$this->updateSort($this->b6); // b6
			$this->updateSort($this->cat_pro); // cat_pro
			$this->updateSort($this->pro_ser); // pro_ser
			$this->updateSort($this->foto2); // foto2
			$this->updateSort($this->foto3); // foto3
			$this->updateSort($this->foto4); // foto4
			$this->updateSort($this->web); // web
			$this->updateSort($this->pre_web); // pre_web
			$this->updateSort($this->megusta); // megusta
			$this->updateSort($this->nomegusta); // nomegusta
			$this->updateSort($this->precio2); // precio2
			$this->updateSort($this->precio3); // precio3
			$this->updateSort($this->und_pro); // und_pro
			$this->updateSort($this->barras); // barras
			$this->updateSort($this->stockmin); // stockmin
			$this->updateSort($this->id_grupo); // id_grupo
			$this->updateSort($this->talla); // talla
			$this->updateSort($this->mostrarcolor); // mostrarcolor
			$this->updateSort($this->precio_mayorista); // precio_mayorista
			$this->updateSort($this->precio_vendedor); // precio_vendedor
			$this->updateSort($this->medida1); // medida1
			$this->updateSort($this->medida2); // medida2
			$this->updateSort($this->medida3); // medida3
			$this->updateSort($this->codlogin); // codlogin
			$this->updateSort($this->idempresa); // idempresa
			$this->updateSort($this->urlstreetview); // urlstreetview
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id_producto->setSort("");
				$this->codigo_producto->setSort("");
				$this->estado->setSort("");
				$this->status_producto->setSort("");
				$this->date_added->setSort("");
				$this->precio_producto->setSort("");
				$this->costo_producto->setSort("");
				$this->mon_costo->setSort("");
				$this->mon_venta->setSort("");
				$this->pais->setSort("");
				$this->departamento->setSort("");
				$this->distrito->setSort("");
				$this->localidad->setSort("");
				$this->zona->setSort("");
				$this->tipo_inmueble->setSort("");
				$this->tipo_negocio->setSort("");
				$this->tiempo_alquiler->setSort("");
				$this->moneda->setSort("");
				$this->estado_inmueble->setSort("");
				$this->area_construida->setSort("");
				$this->area_privada->setSort("");
				$this->area_terreno->setSort("");
				$this->valor_administracion->setSort("");
				$this->dormitorios->setSort("");
				$this->banios->setSort("");
				$this->garaje->setSort("");
				$this->piso->setSort("");
				$this->estrato->setSort("");
				$this->codigo_postal->setSort("");
				$this->mapa->setSort("");
				$this->latitud->setSort("");
				$this->longitud->setSort("");
				$this->opciones_mapa->setSort("");
				$this->red->setSort("");
				$this->disponibilidad->setSort("");
				$this->anio_construccion->setSort("");
				$this->encargado->setSort("");
				$this->visitas->setSort("");
				$this->valor_comision->setSort("");
				$this->tipo_comision->setSort("");
				$this->certificado->setSort("");
				$this->nombre_propietario->setSort("");
				$this->movil_propietario->setSort("");
				$this->telefono_propietario->setSort("");
				$this->correo_propietario->setSort("");
				$this->vinculo->setSort("");
				$this->notas->setSort("");
				$this->marca->setSort("");
				$this->modelo->setSort("");
				$this->color->setSort("");
				$this->b1->setSort("");
				$this->b2->setSort("");
				$this->b3->setSort("");
				$this->b4->setSort("");
				$this->b5->setSort("");
				$this->b6->setSort("");
				$this->cat_pro->setSort("");
				$this->pro_ser->setSort("");
				$this->foto2->setSort("");
				$this->foto3->setSort("");
				$this->foto4->setSort("");
				$this->web->setSort("");
				$this->pre_web->setSort("");
				$this->megusta->setSort("");
				$this->nomegusta->setSort("");
				$this->precio2->setSort("");
				$this->precio3->setSort("");
				$this->und_pro->setSort("");
				$this->barras->setSort("");
				$this->stockmin->setSort("");
				$this->id_grupo->setSort("");
				$this->talla->setSort("");
				$this->mostrarcolor->setSort("");
				$this->precio_mayorista->setSort("");
				$this->precio_vendedor->setSort("");
				$this->medida1->setSort("");
				$this->medida2->setSort("");
				$this->medida3->setSort("");
				$this->codlogin->setSort("");
				$this->idempresa->setSort("");
				$this->urlstreetview->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = $this->ListOptions["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = $this->ListOptions["delete"];
		if ($Security->isLoggedIn())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->id_producto->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = $this->AddUrl != "" && $Security->isLoggedIn();
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fproductslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproductslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.fproductslist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->estado->setDbValue($row['estado']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->pais->setDbValue($row['pais']);
		$this->departamento->setDbValue($row['departamento']);
		$this->distrito->setDbValue($row['distrito']);
		$this->localidad->setDbValue($row['localidad']);
		$this->zona->setDbValue($row['zona']);
		$this->tipo_inmueble->setDbValue($row['tipo_inmueble']);
		$this->tipo_negocio->setDbValue($row['tipo_negocio']);
		$this->tiempo_alquiler->setDbValue($row['tiempo_alquiler']);
		$this->moneda->setDbValue($row['moneda']);
		$this->estado_inmueble->setDbValue($row['estado_inmueble']);
		$this->area_construida->setDbValue($row['area_construida']);
		$this->area_privada->setDbValue($row['area_privada']);
		$this->area_terreno->setDbValue($row['area_terreno']);
		$this->valor_administracion->setDbValue($row['valor_administracion']);
		$this->dormitorios->setDbValue($row['dormitorios']);
		$this->banios->setDbValue($row['banios']);
		$this->garaje->setDbValue($row['garaje']);
		$this->piso->setDbValue($row['piso']);
		$this->estrato->setDbValue($row['estrato']);
		$this->direccion->setDbValue($row['direccion']);
		$this->codigo_postal->setDbValue($row['codigo_postal']);
		$this->mapa->setDbValue($row['mapa']);
		$this->latitud->setDbValue($row['latitud']);
		$this->longitud->setDbValue($row['longitud']);
		$this->opciones_mapa->setDbValue($row['opciones_mapa']);
		$this->red->setDbValue($row['red']);
		$this->video->setDbValue($row['video']);
		$this->disponibilidad->setDbValue($row['disponibilidad']);
		$this->anio_construccion->setDbValue($row['anio_construccion']);
		$this->encargado->setDbValue($row['encargado']);
		$this->comentario->setDbValue($row['comentario']);
		$this->visitas->setDbValue($row['visitas']);
		$this->valor_comision->setDbValue($row['valor_comision']);
		$this->tipo_comision->setDbValue($row['tipo_comision']);
		$this->certificado->setDbValue($row['certificado']);
		$this->nombre_propietario->setDbValue($row['nombre_propietario']);
		$this->movil_propietario->setDbValue($row['movil_propietario']);
		$this->telefono_propietario->setDbValue($row['telefono_propietario']);
		$this->correo_propietario->setDbValue($row['correo_propietario']);
		$this->vinculo->setDbValue($row['vinculo']);
		$this->portales->setDbValue($row['portales']);
		$this->notas->setDbValue($row['notas']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->precio_mayorista->setDbValue($row['precio_mayorista']);
		$this->precio_vendedor->setDbValue($row['precio_vendedor']);
		$this->medida1->setDbValue($row['medida1']);
		$this->medida2->setDbValue($row['medida2']);
		$this->medida3->setDbValue($row['medida3']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->urlstreetview->setDbValue($row['urlstreetview']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_producto'] = NULL;
		$row['codigo_producto'] = NULL;
		$row['nombre_producto'] = NULL;
		$row['estado'] = NULL;
		$row['status_producto'] = NULL;
		$row['date_added'] = NULL;
		$row['precio_producto'] = NULL;
		$row['costo_producto'] = NULL;
		$row['mon_costo'] = NULL;
		$row['mon_venta'] = NULL;
		$row['pais'] = NULL;
		$row['departamento'] = NULL;
		$row['distrito'] = NULL;
		$row['localidad'] = NULL;
		$row['zona'] = NULL;
		$row['tipo_inmueble'] = NULL;
		$row['tipo_negocio'] = NULL;
		$row['tiempo_alquiler'] = NULL;
		$row['moneda'] = NULL;
		$row['estado_inmueble'] = NULL;
		$row['area_construida'] = NULL;
		$row['area_privada'] = NULL;
		$row['area_terreno'] = NULL;
		$row['valor_administracion'] = NULL;
		$row['dormitorios'] = NULL;
		$row['banios'] = NULL;
		$row['garaje'] = NULL;
		$row['piso'] = NULL;
		$row['estrato'] = NULL;
		$row['direccion'] = NULL;
		$row['codigo_postal'] = NULL;
		$row['mapa'] = NULL;
		$row['latitud'] = NULL;
		$row['longitud'] = NULL;
		$row['opciones_mapa'] = NULL;
		$row['red'] = NULL;
		$row['video'] = NULL;
		$row['disponibilidad'] = NULL;
		$row['anio_construccion'] = NULL;
		$row['encargado'] = NULL;
		$row['comentario'] = NULL;
		$row['visitas'] = NULL;
		$row['valor_comision'] = NULL;
		$row['tipo_comision'] = NULL;
		$row['certificado'] = NULL;
		$row['nombre_propietario'] = NULL;
		$row['movil_propietario'] = NULL;
		$row['telefono_propietario'] = NULL;
		$row['correo_propietario'] = NULL;
		$row['vinculo'] = NULL;
		$row['portales'] = NULL;
		$row['notas'] = NULL;
		$row['marca'] = NULL;
		$row['modelo'] = NULL;
		$row['color'] = NULL;
		$row['b1'] = NULL;
		$row['b2'] = NULL;
		$row['b3'] = NULL;
		$row['b4'] = NULL;
		$row['b5'] = NULL;
		$row['b6'] = NULL;
		$row['cat_pro'] = NULL;
		$row['pro_ser'] = NULL;
		$row['foto1'] = NULL;
		$row['foto2'] = NULL;
		$row['foto3'] = NULL;
		$row['foto4'] = NULL;
		$row['web'] = NULL;
		$row['pre_web'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcion1'] = NULL;
		$row['megusta'] = NULL;
		$row['nomegusta'] = NULL;
		$row['precio2'] = NULL;
		$row['precio3'] = NULL;
		$row['und_pro'] = NULL;
		$row['barras'] = NULL;
		$row['stockmin'] = NULL;
		$row['id_grupo'] = NULL;
		$row['talla'] = NULL;
		$row['mostrarcolor'] = NULL;
		$row['precio_mayorista'] = NULL;
		$row['precio_vendedor'] = NULL;
		$row['medida1'] = NULL;
		$row['medida2'] = NULL;
		$row['medida3'] = NULL;
		$row['codlogin'] = NULL;
		$row['idempresa'] = NULL;
		$row['urlstreetview'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_producto")) != "")
			$this->id_producto->OldValue = $this->getKey("id_producto"); // id_producto
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->valor_comision->FormValue == $this->valor_comision->CurrentValue && is_numeric(ConvertToFloatString($this->valor_comision->CurrentValue)))
			$this->valor_comision->CurrentValue = ConvertToFloatString($this->valor_comision->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_mayorista->FormValue == $this->precio_mayorista->CurrentValue && is_numeric(ConvertToFloatString($this->precio_mayorista->CurrentValue)))
			$this->precio_mayorista->CurrentValue = ConvertToFloatString($this->precio_mayorista->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_vendedor->FormValue == $this->precio_vendedor->CurrentValue && is_numeric(ConvertToFloatString($this->precio_vendedor->CurrentValue)))
			$this->precio_vendedor->CurrentValue = ConvertToFloatString($this->precio_vendedor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// codigo_producto
		// nombre_producto
		// estado
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// pais
		// departamento
		// distrito
		// localidad
		// zona
		// tipo_inmueble
		// tipo_negocio
		// tiempo_alquiler
		// moneda
		// estado_inmueble
		// area_construida
		// area_privada
		// area_terreno
		// valor_administracion
		// dormitorios
		// banios
		// garaje
		// piso
		// estrato
		// direccion
		// codigo_postal
		// mapa
		// latitud
		// longitud
		// opciones_mapa
		// red
		// video
		// disponibilidad
		// anio_construccion
		// encargado
		// comentario
		// visitas
		// valor_comision
		// tipo_comision
		// certificado
		// nombre_propietario
		// movil_propietario
		// telefono_propietario
		// correo_propietario
		// vinculo
		// portales
		// notas
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// precio_mayorista
		// precio_vendedor
		// medida1
		// medida2
		// medida3
		// codlogin
		// idempresa
		// urlstreetview

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 0, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// departamento
			$this->departamento->ViewValue = $this->departamento->CurrentValue;
			$this->departamento->ViewCustomAttributes = "";

			// distrito
			$this->distrito->ViewValue = $this->distrito->CurrentValue;
			$this->distrito->ViewCustomAttributes = "";

			// localidad
			$this->localidad->ViewValue = $this->localidad->CurrentValue;
			$this->localidad->ViewCustomAttributes = "";

			// zona
			$this->zona->ViewValue = $this->zona->CurrentValue;
			$this->zona->ViewCustomAttributes = "";

			// tipo_inmueble
			$this->tipo_inmueble->ViewValue = $this->tipo_inmueble->CurrentValue;
			$this->tipo_inmueble->ViewValue = FormatNumber($this->tipo_inmueble->ViewValue, 0, -2, -2, -2);
			$this->tipo_inmueble->ViewCustomAttributes = "";

			// tipo_negocio
			$this->tipo_negocio->ViewValue = $this->tipo_negocio->CurrentValue;
			$this->tipo_negocio->ViewCustomAttributes = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->ViewValue = $this->tiempo_alquiler->CurrentValue;
			$this->tiempo_alquiler->ViewCustomAttributes = "";

			// moneda
			$this->moneda->ViewValue = $this->moneda->CurrentValue;
			$this->moneda->ViewCustomAttributes = "";

			// estado_inmueble
			$this->estado_inmueble->ViewValue = $this->estado_inmueble->CurrentValue;
			$this->estado_inmueble->ViewCustomAttributes = "";

			// area_construida
			$this->area_construida->ViewValue = $this->area_construida->CurrentValue;
			$this->area_construida->ViewCustomAttributes = "";

			// area_privada
			$this->area_privada->ViewValue = $this->area_privada->CurrentValue;
			$this->area_privada->ViewCustomAttributes = "";

			// area_terreno
			$this->area_terreno->ViewValue = $this->area_terreno->CurrentValue;
			$this->area_terreno->ViewCustomAttributes = "";

			// valor_administracion
			$this->valor_administracion->ViewValue = $this->valor_administracion->CurrentValue;
			$this->valor_administracion->ViewCustomAttributes = "";

			// dormitorios
			$this->dormitorios->ViewValue = $this->dormitorios->CurrentValue;
			$this->dormitorios->ViewCustomAttributes = "";

			// banios
			$this->banios->ViewValue = $this->banios->CurrentValue;
			$this->banios->ViewCustomAttributes = "";

			// garaje
			$this->garaje->ViewValue = $this->garaje->CurrentValue;
			$this->garaje->ViewCustomAttributes = "";

			// piso
			$this->piso->ViewValue = $this->piso->CurrentValue;
			$this->piso->ViewCustomAttributes = "";

			// estrato
			$this->estrato->ViewValue = $this->estrato->CurrentValue;
			$this->estrato->ViewCustomAttributes = "";

			// codigo_postal
			$this->codigo_postal->ViewValue = $this->codigo_postal->CurrentValue;
			$this->codigo_postal->ViewCustomAttributes = "";

			// mapa
			$this->mapa->ViewValue = $this->mapa->CurrentValue;
			$this->mapa->ViewCustomAttributes = "";

			// latitud
			$this->latitud->ViewValue = $this->latitud->CurrentValue;
			$this->latitud->ViewCustomAttributes = "";

			// longitud
			$this->longitud->ViewValue = $this->longitud->CurrentValue;
			$this->longitud->ViewCustomAttributes = "";

			// opciones_mapa
			$this->opciones_mapa->ViewValue = $this->opciones_mapa->CurrentValue;
			$this->opciones_mapa->ViewCustomAttributes = "";

			// red
			$this->red->ViewValue = $this->red->CurrentValue;
			$this->red->ViewCustomAttributes = "";

			// disponibilidad
			$this->disponibilidad->ViewValue = $this->disponibilidad->CurrentValue;
			$this->disponibilidad->ViewCustomAttributes = "";

			// anio_construccion
			$this->anio_construccion->ViewValue = $this->anio_construccion->CurrentValue;
			$this->anio_construccion->ViewCustomAttributes = "";

			// encargado
			$this->encargado->ViewValue = $this->encargado->CurrentValue;
			$this->encargado->ViewCustomAttributes = "";

			// visitas
			$this->visitas->ViewValue = $this->visitas->CurrentValue;
			$this->visitas->ViewCustomAttributes = "";

			// valor_comision
			$this->valor_comision->ViewValue = $this->valor_comision->CurrentValue;
			$this->valor_comision->ViewValue = FormatNumber($this->valor_comision->ViewValue, 2, -2, -2, -2);
			$this->valor_comision->ViewCustomAttributes = "";

			// tipo_comision
			$this->tipo_comision->ViewValue = $this->tipo_comision->CurrentValue;
			$this->tipo_comision->ViewCustomAttributes = "";

			// certificado
			$this->certificado->ViewValue = $this->certificado->CurrentValue;
			$this->certificado->ViewCustomAttributes = "";

			// nombre_propietario
			$this->nombre_propietario->ViewValue = $this->nombre_propietario->CurrentValue;
			$this->nombre_propietario->ViewCustomAttributes = "";

			// movil_propietario
			$this->movil_propietario->ViewValue = $this->movil_propietario->CurrentValue;
			$this->movil_propietario->ViewCustomAttributes = "";

			// telefono_propietario
			$this->telefono_propietario->ViewValue = $this->telefono_propietario->CurrentValue;
			$this->telefono_propietario->ViewCustomAttributes = "";

			// correo_propietario
			$this->correo_propietario->ViewValue = $this->correo_propietario->CurrentValue;
			$this->correo_propietario->ViewCustomAttributes = "";

			// vinculo
			$this->vinculo->ViewValue = $this->vinculo->CurrentValue;
			$this->vinculo->ViewCustomAttributes = "";

			// notas
			$this->notas->ViewValue = $this->notas->CurrentValue;
			$this->notas->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// precio_mayorista
			$this->precio_mayorista->ViewValue = $this->precio_mayorista->CurrentValue;
			$this->precio_mayorista->ViewValue = FormatNumber($this->precio_mayorista->ViewValue, 2, -2, -2, -2);
			$this->precio_mayorista->ViewCustomAttributes = "";

			// precio_vendedor
			$this->precio_vendedor->ViewValue = $this->precio_vendedor->CurrentValue;
			$this->precio_vendedor->ViewValue = FormatNumber($this->precio_vendedor->ViewValue, 2, -2, -2, -2);
			$this->precio_vendedor->ViewCustomAttributes = "";

			// medida1
			$this->medida1->ViewValue = $this->medida1->CurrentValue;
			$this->medida1->ViewCustomAttributes = "";

			// medida2
			$this->medida2->ViewValue = $this->medida2->CurrentValue;
			$this->medida2->ViewCustomAttributes = "";

			// medida3
			$this->medida3->ViewValue = $this->medida3->CurrentValue;
			$this->medida3->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// urlstreetview
			$this->urlstreetview->ViewValue = $this->urlstreetview->CurrentValue;
			$this->urlstreetview->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";
			$this->departamento->TooltipValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";
			$this->distrito->TooltipValue = "";

			// localidad
			$this->localidad->LinkCustomAttributes = "";
			$this->localidad->HrefValue = "";
			$this->localidad->TooltipValue = "";

			// zona
			$this->zona->LinkCustomAttributes = "";
			$this->zona->HrefValue = "";
			$this->zona->TooltipValue = "";

			// tipo_inmueble
			$this->tipo_inmueble->LinkCustomAttributes = "";
			$this->tipo_inmueble->HrefValue = "";
			$this->tipo_inmueble->TooltipValue = "";

			// tipo_negocio
			$this->tipo_negocio->LinkCustomAttributes = "";
			$this->tipo_negocio->HrefValue = "";
			$this->tipo_negocio->TooltipValue = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->LinkCustomAttributes = "";
			$this->tiempo_alquiler->HrefValue = "";
			$this->tiempo_alquiler->TooltipValue = "";

			// moneda
			$this->moneda->LinkCustomAttributes = "";
			$this->moneda->HrefValue = "";
			$this->moneda->TooltipValue = "";

			// estado_inmueble
			$this->estado_inmueble->LinkCustomAttributes = "";
			$this->estado_inmueble->HrefValue = "";
			$this->estado_inmueble->TooltipValue = "";

			// area_construida
			$this->area_construida->LinkCustomAttributes = "";
			$this->area_construida->HrefValue = "";
			$this->area_construida->TooltipValue = "";

			// area_privada
			$this->area_privada->LinkCustomAttributes = "";
			$this->area_privada->HrefValue = "";
			$this->area_privada->TooltipValue = "";

			// area_terreno
			$this->area_terreno->LinkCustomAttributes = "";
			$this->area_terreno->HrefValue = "";
			$this->area_terreno->TooltipValue = "";

			// valor_administracion
			$this->valor_administracion->LinkCustomAttributes = "";
			$this->valor_administracion->HrefValue = "";
			$this->valor_administracion->TooltipValue = "";

			// dormitorios
			$this->dormitorios->LinkCustomAttributes = "";
			$this->dormitorios->HrefValue = "";
			$this->dormitorios->TooltipValue = "";

			// banios
			$this->banios->LinkCustomAttributes = "";
			$this->banios->HrefValue = "";
			$this->banios->TooltipValue = "";

			// garaje
			$this->garaje->LinkCustomAttributes = "";
			$this->garaje->HrefValue = "";
			$this->garaje->TooltipValue = "";

			// piso
			$this->piso->LinkCustomAttributes = "";
			$this->piso->HrefValue = "";
			$this->piso->TooltipValue = "";

			// estrato
			$this->estrato->LinkCustomAttributes = "";
			$this->estrato->HrefValue = "";
			$this->estrato->TooltipValue = "";

			// codigo_postal
			$this->codigo_postal->LinkCustomAttributes = "";
			$this->codigo_postal->HrefValue = "";
			$this->codigo_postal->TooltipValue = "";

			// mapa
			$this->mapa->LinkCustomAttributes = "";
			$this->mapa->HrefValue = "";
			$this->mapa->TooltipValue = "";

			// latitud
			$this->latitud->LinkCustomAttributes = "";
			$this->latitud->HrefValue = "";
			$this->latitud->TooltipValue = "";

			// longitud
			$this->longitud->LinkCustomAttributes = "";
			$this->longitud->HrefValue = "";
			$this->longitud->TooltipValue = "";

			// opciones_mapa
			$this->opciones_mapa->LinkCustomAttributes = "";
			$this->opciones_mapa->HrefValue = "";
			$this->opciones_mapa->TooltipValue = "";

			// red
			$this->red->LinkCustomAttributes = "";
			$this->red->HrefValue = "";
			$this->red->TooltipValue = "";

			// disponibilidad
			$this->disponibilidad->LinkCustomAttributes = "";
			$this->disponibilidad->HrefValue = "";
			$this->disponibilidad->TooltipValue = "";

			// anio_construccion
			$this->anio_construccion->LinkCustomAttributes = "";
			$this->anio_construccion->HrefValue = "";
			$this->anio_construccion->TooltipValue = "";

			// encargado
			$this->encargado->LinkCustomAttributes = "";
			$this->encargado->HrefValue = "";
			$this->encargado->TooltipValue = "";

			// visitas
			$this->visitas->LinkCustomAttributes = "";
			$this->visitas->HrefValue = "";
			$this->visitas->TooltipValue = "";

			// valor_comision
			$this->valor_comision->LinkCustomAttributes = "";
			$this->valor_comision->HrefValue = "";
			$this->valor_comision->TooltipValue = "";

			// tipo_comision
			$this->tipo_comision->LinkCustomAttributes = "";
			$this->tipo_comision->HrefValue = "";
			$this->tipo_comision->TooltipValue = "";

			// certificado
			$this->certificado->LinkCustomAttributes = "";
			$this->certificado->HrefValue = "";
			$this->certificado->TooltipValue = "";

			// nombre_propietario
			$this->nombre_propietario->LinkCustomAttributes = "";
			$this->nombre_propietario->HrefValue = "";
			$this->nombre_propietario->TooltipValue = "";

			// movil_propietario
			$this->movil_propietario->LinkCustomAttributes = "";
			$this->movil_propietario->HrefValue = "";
			$this->movil_propietario->TooltipValue = "";

			// telefono_propietario
			$this->telefono_propietario->LinkCustomAttributes = "";
			$this->telefono_propietario->HrefValue = "";
			$this->telefono_propietario->TooltipValue = "";

			// correo_propietario
			$this->correo_propietario->LinkCustomAttributes = "";
			$this->correo_propietario->HrefValue = "";
			$this->correo_propietario->TooltipValue = "";

			// vinculo
			$this->vinculo->LinkCustomAttributes = "";
			$this->vinculo->HrefValue = "";
			$this->vinculo->TooltipValue = "";

			// notas
			$this->notas->LinkCustomAttributes = "";
			$this->notas->HrefValue = "";
			$this->notas->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// precio_mayorista
			$this->precio_mayorista->LinkCustomAttributes = "";
			$this->precio_mayorista->HrefValue = "";
			$this->precio_mayorista->TooltipValue = "";

			// precio_vendedor
			$this->precio_vendedor->LinkCustomAttributes = "";
			$this->precio_vendedor->HrefValue = "";
			$this->precio_vendedor->TooltipValue = "";

			// medida1
			$this->medida1->LinkCustomAttributes = "";
			$this->medida1->HrefValue = "";
			$this->medida1->TooltipValue = "";

			// medida2
			$this->medida2->LinkCustomAttributes = "";
			$this->medida2->HrefValue = "";
			$this->medida2->TooltipValue = "";

			// medida3
			$this->medida3->LinkCustomAttributes = "";
			$this->medida3->HrefValue = "";
			$this->medida3->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// urlstreetview
			$this->urlstreetview->LinkCustomAttributes = "";
			$this->urlstreetview->HrefValue = "";
			$this->urlstreetview->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fproductslistsrch\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>