<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class products_view extends products
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'products';

	// Page object name
	public $PageObjName = "products_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (products)
		if (!isset($GLOBALS["products"]) || get_class($GLOBALS["products"]) == PROJECT_NAMESPACE . "products") {
			$GLOBALS["products"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["products"];
		}
		$keyUrl = "";
		if (Get("id_producto") !== NULL) {
			$this->RecKey["id_producto"] = Get("id_producto");
			$keyUrl .= "&amp;id_producto=" . urlencode($this->RecKey["id_producto"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'products');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $products;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($products);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "productsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("productslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_producto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->setVisibility();
		$this->estado->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->pais->setVisibility();
		$this->departamento->setVisibility();
		$this->distrito->setVisibility();
		$this->localidad->setVisibility();
		$this->zona->setVisibility();
		$this->tipo_inmueble->setVisibility();
		$this->tipo_negocio->setVisibility();
		$this->tiempo_alquiler->setVisibility();
		$this->moneda->setVisibility();
		$this->estado_inmueble->setVisibility();
		$this->area_construida->setVisibility();
		$this->area_privada->setVisibility();
		$this->area_terreno->setVisibility();
		$this->valor_administracion->setVisibility();
		$this->dormitorios->setVisibility();
		$this->banios->setVisibility();
		$this->garaje->setVisibility();
		$this->piso->setVisibility();
		$this->estrato->setVisibility();
		$this->direccion->setVisibility();
		$this->codigo_postal->setVisibility();
		$this->mapa->setVisibility();
		$this->latitud->setVisibility();
		$this->longitud->setVisibility();
		$this->opciones_mapa->setVisibility();
		$this->red->setVisibility();
		$this->video->setVisibility();
		$this->disponibilidad->setVisibility();
		$this->anio_construccion->setVisibility();
		$this->encargado->setVisibility();
		$this->comentario->setVisibility();
		$this->visitas->setVisibility();
		$this->valor_comision->setVisibility();
		$this->tipo_comision->setVisibility();
		$this->certificado->setVisibility();
		$this->nombre_propietario->setVisibility();
		$this->movil_propietario->setVisibility();
		$this->telefono_propietario->setVisibility();
		$this->correo_propietario->setVisibility();
		$this->vinculo->setVisibility();
		$this->portales->setVisibility();
		$this->notas->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->setVisibility();
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->setVisibility();
		$this->descripcion1->setVisibility();
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->precio_mayorista->setVisibility();
		$this->precio_vendedor->setVisibility();
		$this->medida1->setVisibility();
		$this->medida2->setVisibility();
		$this->medida3->setVisibility();
		$this->codlogin->setVisibility();
		$this->idempresa->setVisibility();
		$this->urlstreetview->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id_producto") !== NULL) {
				$this->id_producto->setQueryStringValue(Get("id_producto"));
				$this->RecKey["id_producto"] = $this->id_producto->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id_producto->setQueryStringValue(Key(0));
				$this->RecKey["id_producto"] = $this->id_producto->QueryStringValue;
			} elseif (Post("id_producto") !== NULL) {
				$this->id_producto->setFormValue(Post("id_producto"));
				$this->RecKey["id_producto"] = $this->id_producto->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id_producto->setFormValue(Route(2));
				$this->RecKey["id_producto"] = $this->id_producto->FormValue;
			} else {
				$returnUrl = "productslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "productslist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "productslist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl != "" && $Security->isLoggedIn());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->isLoggedIn());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl != "" && $Security->isLoggedIn());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl != "" && $Security->isLoggedIn());

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->estado->setDbValue($row['estado']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->pais->setDbValue($row['pais']);
		$this->departamento->setDbValue($row['departamento']);
		$this->distrito->setDbValue($row['distrito']);
		$this->localidad->setDbValue($row['localidad']);
		$this->zona->setDbValue($row['zona']);
		$this->tipo_inmueble->setDbValue($row['tipo_inmueble']);
		$this->tipo_negocio->setDbValue($row['tipo_negocio']);
		$this->tiempo_alquiler->setDbValue($row['tiempo_alquiler']);
		$this->moneda->setDbValue($row['moneda']);
		$this->estado_inmueble->setDbValue($row['estado_inmueble']);
		$this->area_construida->setDbValue($row['area_construida']);
		$this->area_privada->setDbValue($row['area_privada']);
		$this->area_terreno->setDbValue($row['area_terreno']);
		$this->valor_administracion->setDbValue($row['valor_administracion']);
		$this->dormitorios->setDbValue($row['dormitorios']);
		$this->banios->setDbValue($row['banios']);
		$this->garaje->setDbValue($row['garaje']);
		$this->piso->setDbValue($row['piso']);
		$this->estrato->setDbValue($row['estrato']);
		$this->direccion->setDbValue($row['direccion']);
		$this->codigo_postal->setDbValue($row['codigo_postal']);
		$this->mapa->setDbValue($row['mapa']);
		$this->latitud->setDbValue($row['latitud']);
		$this->longitud->setDbValue($row['longitud']);
		$this->opciones_mapa->setDbValue($row['opciones_mapa']);
		$this->red->setDbValue($row['red']);
		$this->video->setDbValue($row['video']);
		$this->disponibilidad->setDbValue($row['disponibilidad']);
		$this->anio_construccion->setDbValue($row['anio_construccion']);
		$this->encargado->setDbValue($row['encargado']);
		$this->comentario->setDbValue($row['comentario']);
		$this->visitas->setDbValue($row['visitas']);
		$this->valor_comision->setDbValue($row['valor_comision']);
		$this->tipo_comision->setDbValue($row['tipo_comision']);
		$this->certificado->setDbValue($row['certificado']);
		$this->nombre_propietario->setDbValue($row['nombre_propietario']);
		$this->movil_propietario->setDbValue($row['movil_propietario']);
		$this->telefono_propietario->setDbValue($row['telefono_propietario']);
		$this->correo_propietario->setDbValue($row['correo_propietario']);
		$this->vinculo->setDbValue($row['vinculo']);
		$this->portales->setDbValue($row['portales']);
		$this->notas->setDbValue($row['notas']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->precio_mayorista->setDbValue($row['precio_mayorista']);
		$this->precio_vendedor->setDbValue($row['precio_vendedor']);
		$this->medida1->setDbValue($row['medida1']);
		$this->medida2->setDbValue($row['medida2']);
		$this->medida3->setDbValue($row['medida3']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->urlstreetview->setDbValue($row['urlstreetview']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_producto'] = NULL;
		$row['codigo_producto'] = NULL;
		$row['nombre_producto'] = NULL;
		$row['estado'] = NULL;
		$row['status_producto'] = NULL;
		$row['date_added'] = NULL;
		$row['precio_producto'] = NULL;
		$row['costo_producto'] = NULL;
		$row['mon_costo'] = NULL;
		$row['mon_venta'] = NULL;
		$row['pais'] = NULL;
		$row['departamento'] = NULL;
		$row['distrito'] = NULL;
		$row['localidad'] = NULL;
		$row['zona'] = NULL;
		$row['tipo_inmueble'] = NULL;
		$row['tipo_negocio'] = NULL;
		$row['tiempo_alquiler'] = NULL;
		$row['moneda'] = NULL;
		$row['estado_inmueble'] = NULL;
		$row['area_construida'] = NULL;
		$row['area_privada'] = NULL;
		$row['area_terreno'] = NULL;
		$row['valor_administracion'] = NULL;
		$row['dormitorios'] = NULL;
		$row['banios'] = NULL;
		$row['garaje'] = NULL;
		$row['piso'] = NULL;
		$row['estrato'] = NULL;
		$row['direccion'] = NULL;
		$row['codigo_postal'] = NULL;
		$row['mapa'] = NULL;
		$row['latitud'] = NULL;
		$row['longitud'] = NULL;
		$row['opciones_mapa'] = NULL;
		$row['red'] = NULL;
		$row['video'] = NULL;
		$row['disponibilidad'] = NULL;
		$row['anio_construccion'] = NULL;
		$row['encargado'] = NULL;
		$row['comentario'] = NULL;
		$row['visitas'] = NULL;
		$row['valor_comision'] = NULL;
		$row['tipo_comision'] = NULL;
		$row['certificado'] = NULL;
		$row['nombre_propietario'] = NULL;
		$row['movil_propietario'] = NULL;
		$row['telefono_propietario'] = NULL;
		$row['correo_propietario'] = NULL;
		$row['vinculo'] = NULL;
		$row['portales'] = NULL;
		$row['notas'] = NULL;
		$row['marca'] = NULL;
		$row['modelo'] = NULL;
		$row['color'] = NULL;
		$row['b1'] = NULL;
		$row['b2'] = NULL;
		$row['b3'] = NULL;
		$row['b4'] = NULL;
		$row['b5'] = NULL;
		$row['b6'] = NULL;
		$row['cat_pro'] = NULL;
		$row['pro_ser'] = NULL;
		$row['foto1'] = NULL;
		$row['foto2'] = NULL;
		$row['foto3'] = NULL;
		$row['foto4'] = NULL;
		$row['web'] = NULL;
		$row['pre_web'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcion1'] = NULL;
		$row['megusta'] = NULL;
		$row['nomegusta'] = NULL;
		$row['precio2'] = NULL;
		$row['precio3'] = NULL;
		$row['und_pro'] = NULL;
		$row['barras'] = NULL;
		$row['stockmin'] = NULL;
		$row['id_grupo'] = NULL;
		$row['talla'] = NULL;
		$row['mostrarcolor'] = NULL;
		$row['precio_mayorista'] = NULL;
		$row['precio_vendedor'] = NULL;
		$row['medida1'] = NULL;
		$row['medida2'] = NULL;
		$row['medida3'] = NULL;
		$row['codlogin'] = NULL;
		$row['idempresa'] = NULL;
		$row['urlstreetview'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->valor_comision->FormValue == $this->valor_comision->CurrentValue && is_numeric(ConvertToFloatString($this->valor_comision->CurrentValue)))
			$this->valor_comision->CurrentValue = ConvertToFloatString($this->valor_comision->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_mayorista->FormValue == $this->precio_mayorista->CurrentValue && is_numeric(ConvertToFloatString($this->precio_mayorista->CurrentValue)))
			$this->precio_mayorista->CurrentValue = ConvertToFloatString($this->precio_mayorista->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio_vendedor->FormValue == $this->precio_vendedor->CurrentValue && is_numeric(ConvertToFloatString($this->precio_vendedor->CurrentValue)))
			$this->precio_vendedor->CurrentValue = ConvertToFloatString($this->precio_vendedor->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// codigo_producto
		// nombre_producto
		// estado
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// pais
		// departamento
		// distrito
		// localidad
		// zona
		// tipo_inmueble
		// tipo_negocio
		// tiempo_alquiler
		// moneda
		// estado_inmueble
		// area_construida
		// area_privada
		// area_terreno
		// valor_administracion
		// dormitorios
		// banios
		// garaje
		// piso
		// estrato
		// direccion
		// codigo_postal
		// mapa
		// latitud
		// longitud
		// opciones_mapa
		// red
		// video
		// disponibilidad
		// anio_construccion
		// encargado
		// comentario
		// visitas
		// valor_comision
		// tipo_comision
		// certificado
		// nombre_propietario
		// movil_propietario
		// telefono_propietario
		// correo_propietario
		// vinculo
		// portales
		// notas
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// precio_mayorista
		// precio_vendedor
		// medida1
		// medida2
		// medida3
		// codlogin
		// idempresa
		// urlstreetview

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// nombre_producto
			$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
			$this->nombre_producto->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 0, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// departamento
			$this->departamento->ViewValue = $this->departamento->CurrentValue;
			$this->departamento->ViewCustomAttributes = "";

			// distrito
			$this->distrito->ViewValue = $this->distrito->CurrentValue;
			$this->distrito->ViewCustomAttributes = "";

			// localidad
			$this->localidad->ViewValue = $this->localidad->CurrentValue;
			$this->localidad->ViewCustomAttributes = "";

			// zona
			$this->zona->ViewValue = $this->zona->CurrentValue;
			$this->zona->ViewCustomAttributes = "";

			// tipo_inmueble
			$this->tipo_inmueble->ViewValue = $this->tipo_inmueble->CurrentValue;
			$this->tipo_inmueble->ViewValue = FormatNumber($this->tipo_inmueble->ViewValue, 0, -2, -2, -2);
			$this->tipo_inmueble->ViewCustomAttributes = "";

			// tipo_negocio
			$this->tipo_negocio->ViewValue = $this->tipo_negocio->CurrentValue;
			$this->tipo_negocio->ViewCustomAttributes = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->ViewValue = $this->tiempo_alquiler->CurrentValue;
			$this->tiempo_alquiler->ViewCustomAttributes = "";

			// moneda
			$this->moneda->ViewValue = $this->moneda->CurrentValue;
			$this->moneda->ViewCustomAttributes = "";

			// estado_inmueble
			$this->estado_inmueble->ViewValue = $this->estado_inmueble->CurrentValue;
			$this->estado_inmueble->ViewCustomAttributes = "";

			// area_construida
			$this->area_construida->ViewValue = $this->area_construida->CurrentValue;
			$this->area_construida->ViewCustomAttributes = "";

			// area_privada
			$this->area_privada->ViewValue = $this->area_privada->CurrentValue;
			$this->area_privada->ViewCustomAttributes = "";

			// area_terreno
			$this->area_terreno->ViewValue = $this->area_terreno->CurrentValue;
			$this->area_terreno->ViewCustomAttributes = "";

			// valor_administracion
			$this->valor_administracion->ViewValue = $this->valor_administracion->CurrentValue;
			$this->valor_administracion->ViewCustomAttributes = "";

			// dormitorios
			$this->dormitorios->ViewValue = $this->dormitorios->CurrentValue;
			$this->dormitorios->ViewCustomAttributes = "";

			// banios
			$this->banios->ViewValue = $this->banios->CurrentValue;
			$this->banios->ViewCustomAttributes = "";

			// garaje
			$this->garaje->ViewValue = $this->garaje->CurrentValue;
			$this->garaje->ViewCustomAttributes = "";

			// piso
			$this->piso->ViewValue = $this->piso->CurrentValue;
			$this->piso->ViewCustomAttributes = "";

			// estrato
			$this->estrato->ViewValue = $this->estrato->CurrentValue;
			$this->estrato->ViewCustomAttributes = "";

			// direccion
			$this->direccion->ViewValue = $this->direccion->CurrentValue;
			$this->direccion->ViewCustomAttributes = "";

			// codigo_postal
			$this->codigo_postal->ViewValue = $this->codigo_postal->CurrentValue;
			$this->codigo_postal->ViewCustomAttributes = "";

			// mapa
			$this->mapa->ViewValue = $this->mapa->CurrentValue;
			$this->mapa->ViewCustomAttributes = "";

			// latitud
			$this->latitud->ViewValue = $this->latitud->CurrentValue;
			$this->latitud->ViewCustomAttributes = "";

			// longitud
			$this->longitud->ViewValue = $this->longitud->CurrentValue;
			$this->longitud->ViewCustomAttributes = "";

			// opciones_mapa
			$this->opciones_mapa->ViewValue = $this->opciones_mapa->CurrentValue;
			$this->opciones_mapa->ViewCustomAttributes = "";

			// red
			$this->red->ViewValue = $this->red->CurrentValue;
			$this->red->ViewCustomAttributes = "";

			// video
			$this->video->ViewValue = $this->video->CurrentValue;
			$this->video->ViewCustomAttributes = "";

			// disponibilidad
			$this->disponibilidad->ViewValue = $this->disponibilidad->CurrentValue;
			$this->disponibilidad->ViewCustomAttributes = "";

			// anio_construccion
			$this->anio_construccion->ViewValue = $this->anio_construccion->CurrentValue;
			$this->anio_construccion->ViewCustomAttributes = "";

			// encargado
			$this->encargado->ViewValue = $this->encargado->CurrentValue;
			$this->encargado->ViewCustomAttributes = "";

			// comentario
			$this->comentario->ViewValue = $this->comentario->CurrentValue;
			$this->comentario->ViewCustomAttributes = "";

			// visitas
			$this->visitas->ViewValue = $this->visitas->CurrentValue;
			$this->visitas->ViewCustomAttributes = "";

			// valor_comision
			$this->valor_comision->ViewValue = $this->valor_comision->CurrentValue;
			$this->valor_comision->ViewValue = FormatNumber($this->valor_comision->ViewValue, 2, -2, -2, -2);
			$this->valor_comision->ViewCustomAttributes = "";

			// tipo_comision
			$this->tipo_comision->ViewValue = $this->tipo_comision->CurrentValue;
			$this->tipo_comision->ViewCustomAttributes = "";

			// certificado
			$this->certificado->ViewValue = $this->certificado->CurrentValue;
			$this->certificado->ViewCustomAttributes = "";

			// nombre_propietario
			$this->nombre_propietario->ViewValue = $this->nombre_propietario->CurrentValue;
			$this->nombre_propietario->ViewCustomAttributes = "";

			// movil_propietario
			$this->movil_propietario->ViewValue = $this->movil_propietario->CurrentValue;
			$this->movil_propietario->ViewCustomAttributes = "";

			// telefono_propietario
			$this->telefono_propietario->ViewValue = $this->telefono_propietario->CurrentValue;
			$this->telefono_propietario->ViewCustomAttributes = "";

			// correo_propietario
			$this->correo_propietario->ViewValue = $this->correo_propietario->CurrentValue;
			$this->correo_propietario->ViewCustomAttributes = "";

			// vinculo
			$this->vinculo->ViewValue = $this->vinculo->CurrentValue;
			$this->vinculo->ViewCustomAttributes = "";

			// portales
			$this->portales->ViewValue = $this->portales->CurrentValue;
			$this->portales->ViewCustomAttributes = "";

			// notas
			$this->notas->ViewValue = $this->notas->CurrentValue;
			$this->notas->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto1
			$this->foto1->ViewValue = $this->foto1->CurrentValue;
			$this->foto1->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// descripcion
			$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
			$this->descripcion->ViewCustomAttributes = "";

			// descripcion1
			$this->descripcion1->ViewValue = $this->descripcion1->CurrentValue;
			$this->descripcion1->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// precio_mayorista
			$this->precio_mayorista->ViewValue = $this->precio_mayorista->CurrentValue;
			$this->precio_mayorista->ViewValue = FormatNumber($this->precio_mayorista->ViewValue, 2, -2, -2, -2);
			$this->precio_mayorista->ViewCustomAttributes = "";

			// precio_vendedor
			$this->precio_vendedor->ViewValue = $this->precio_vendedor->CurrentValue;
			$this->precio_vendedor->ViewValue = FormatNumber($this->precio_vendedor->ViewValue, 2, -2, -2, -2);
			$this->precio_vendedor->ViewCustomAttributes = "";

			// medida1
			$this->medida1->ViewValue = $this->medida1->CurrentValue;
			$this->medida1->ViewCustomAttributes = "";

			// medida2
			$this->medida2->ViewValue = $this->medida2->CurrentValue;
			$this->medida2->ViewCustomAttributes = "";

			// medida3
			$this->medida3->ViewValue = $this->medida3->CurrentValue;
			$this->medida3->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// urlstreetview
			$this->urlstreetview->ViewValue = $this->urlstreetview->CurrentValue;
			$this->urlstreetview->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";
			$this->nombre_producto->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";
			$this->departamento->TooltipValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";
			$this->distrito->TooltipValue = "";

			// localidad
			$this->localidad->LinkCustomAttributes = "";
			$this->localidad->HrefValue = "";
			$this->localidad->TooltipValue = "";

			// zona
			$this->zona->LinkCustomAttributes = "";
			$this->zona->HrefValue = "";
			$this->zona->TooltipValue = "";

			// tipo_inmueble
			$this->tipo_inmueble->LinkCustomAttributes = "";
			$this->tipo_inmueble->HrefValue = "";
			$this->tipo_inmueble->TooltipValue = "";

			// tipo_negocio
			$this->tipo_negocio->LinkCustomAttributes = "";
			$this->tipo_negocio->HrefValue = "";
			$this->tipo_negocio->TooltipValue = "";

			// tiempo_alquiler
			$this->tiempo_alquiler->LinkCustomAttributes = "";
			$this->tiempo_alquiler->HrefValue = "";
			$this->tiempo_alquiler->TooltipValue = "";

			// moneda
			$this->moneda->LinkCustomAttributes = "";
			$this->moneda->HrefValue = "";
			$this->moneda->TooltipValue = "";

			// estado_inmueble
			$this->estado_inmueble->LinkCustomAttributes = "";
			$this->estado_inmueble->HrefValue = "";
			$this->estado_inmueble->TooltipValue = "";

			// area_construida
			$this->area_construida->LinkCustomAttributes = "";
			$this->area_construida->HrefValue = "";
			$this->area_construida->TooltipValue = "";

			// area_privada
			$this->area_privada->LinkCustomAttributes = "";
			$this->area_privada->HrefValue = "";
			$this->area_privada->TooltipValue = "";

			// area_terreno
			$this->area_terreno->LinkCustomAttributes = "";
			$this->area_terreno->HrefValue = "";
			$this->area_terreno->TooltipValue = "";

			// valor_administracion
			$this->valor_administracion->LinkCustomAttributes = "";
			$this->valor_administracion->HrefValue = "";
			$this->valor_administracion->TooltipValue = "";

			// dormitorios
			$this->dormitorios->LinkCustomAttributes = "";
			$this->dormitorios->HrefValue = "";
			$this->dormitorios->TooltipValue = "";

			// banios
			$this->banios->LinkCustomAttributes = "";
			$this->banios->HrefValue = "";
			$this->banios->TooltipValue = "";

			// garaje
			$this->garaje->LinkCustomAttributes = "";
			$this->garaje->HrefValue = "";
			$this->garaje->TooltipValue = "";

			// piso
			$this->piso->LinkCustomAttributes = "";
			$this->piso->HrefValue = "";
			$this->piso->TooltipValue = "";

			// estrato
			$this->estrato->LinkCustomAttributes = "";
			$this->estrato->HrefValue = "";
			$this->estrato->TooltipValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";
			$this->direccion->TooltipValue = "";

			// codigo_postal
			$this->codigo_postal->LinkCustomAttributes = "";
			$this->codigo_postal->HrefValue = "";
			$this->codigo_postal->TooltipValue = "";

			// mapa
			$this->mapa->LinkCustomAttributes = "";
			$this->mapa->HrefValue = "";
			$this->mapa->TooltipValue = "";

			// latitud
			$this->latitud->LinkCustomAttributes = "";
			$this->latitud->HrefValue = "";
			$this->latitud->TooltipValue = "";

			// longitud
			$this->longitud->LinkCustomAttributes = "";
			$this->longitud->HrefValue = "";
			$this->longitud->TooltipValue = "";

			// opciones_mapa
			$this->opciones_mapa->LinkCustomAttributes = "";
			$this->opciones_mapa->HrefValue = "";
			$this->opciones_mapa->TooltipValue = "";

			// red
			$this->red->LinkCustomAttributes = "";
			$this->red->HrefValue = "";
			$this->red->TooltipValue = "";

			// video
			$this->video->LinkCustomAttributes = "";
			$this->video->HrefValue = "";
			$this->video->TooltipValue = "";

			// disponibilidad
			$this->disponibilidad->LinkCustomAttributes = "";
			$this->disponibilidad->HrefValue = "";
			$this->disponibilidad->TooltipValue = "";

			// anio_construccion
			$this->anio_construccion->LinkCustomAttributes = "";
			$this->anio_construccion->HrefValue = "";
			$this->anio_construccion->TooltipValue = "";

			// encargado
			$this->encargado->LinkCustomAttributes = "";
			$this->encargado->HrefValue = "";
			$this->encargado->TooltipValue = "";

			// comentario
			$this->comentario->LinkCustomAttributes = "";
			$this->comentario->HrefValue = "";
			$this->comentario->TooltipValue = "";

			// visitas
			$this->visitas->LinkCustomAttributes = "";
			$this->visitas->HrefValue = "";
			$this->visitas->TooltipValue = "";

			// valor_comision
			$this->valor_comision->LinkCustomAttributes = "";
			$this->valor_comision->HrefValue = "";
			$this->valor_comision->TooltipValue = "";

			// tipo_comision
			$this->tipo_comision->LinkCustomAttributes = "";
			$this->tipo_comision->HrefValue = "";
			$this->tipo_comision->TooltipValue = "";

			// certificado
			$this->certificado->LinkCustomAttributes = "";
			$this->certificado->HrefValue = "";
			$this->certificado->TooltipValue = "";

			// nombre_propietario
			$this->nombre_propietario->LinkCustomAttributes = "";
			$this->nombre_propietario->HrefValue = "";
			$this->nombre_propietario->TooltipValue = "";

			// movil_propietario
			$this->movil_propietario->LinkCustomAttributes = "";
			$this->movil_propietario->HrefValue = "";
			$this->movil_propietario->TooltipValue = "";

			// telefono_propietario
			$this->telefono_propietario->LinkCustomAttributes = "";
			$this->telefono_propietario->HrefValue = "";
			$this->telefono_propietario->TooltipValue = "";

			// correo_propietario
			$this->correo_propietario->LinkCustomAttributes = "";
			$this->correo_propietario->HrefValue = "";
			$this->correo_propietario->TooltipValue = "";

			// vinculo
			$this->vinculo->LinkCustomAttributes = "";
			$this->vinculo->HrefValue = "";
			$this->vinculo->TooltipValue = "";

			// portales
			$this->portales->LinkCustomAttributes = "";
			$this->portales->HrefValue = "";
			$this->portales->TooltipValue = "";

			// notas
			$this->notas->LinkCustomAttributes = "";
			$this->notas->HrefValue = "";
			$this->notas->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";
			$this->foto1->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";
			$this->descripcion->TooltipValue = "";

			// descripcion1
			$this->descripcion1->LinkCustomAttributes = "";
			$this->descripcion1->HrefValue = "";
			$this->descripcion1->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// precio_mayorista
			$this->precio_mayorista->LinkCustomAttributes = "";
			$this->precio_mayorista->HrefValue = "";
			$this->precio_mayorista->TooltipValue = "";

			// precio_vendedor
			$this->precio_vendedor->LinkCustomAttributes = "";
			$this->precio_vendedor->HrefValue = "";
			$this->precio_vendedor->TooltipValue = "";

			// medida1
			$this->medida1->LinkCustomAttributes = "";
			$this->medida1->HrefValue = "";
			$this->medida1->TooltipValue = "";

			// medida2
			$this->medida2->LinkCustomAttributes = "";
			$this->medida2->HrefValue = "";
			$this->medida2->TooltipValue = "";

			// medida3
			$this->medida3->LinkCustomAttributes = "";
			$this->medida3->HrefValue = "";
			$this->medida3->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// urlstreetview
			$this->urlstreetview->LinkCustomAttributes = "";
			$this->urlstreetview->HrefValue = "";
			$this->urlstreetview->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("productslist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>