<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courses_add = new courses_add();

// Run the page
$courses_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courses_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fcoursesadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fcoursesadd = currentForm = new ew.Form("fcoursesadd", "add");

	// Validate form
	fcoursesadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($courses_add->time->Required) { ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->time->caption(), $courses_add->time->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($courses_add->time->errorMessage()) ?>");
			<?php if ($courses_add->courses_name->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_name");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->courses_name->caption(), $courses_add->courses_name->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_add->description->Required) { ?>
				elm = this.getElements("x" + infix + "_description");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->description->caption(), $courses_add->description->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_add->courses_name_in->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_name_in");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->courses_name_in->caption(), $courses_add->courses_name_in->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_add->description_in->Required) { ?>
				elm = this.getElements("x" + infix + "_description_in");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->description_in->caption(), $courses_add->description_in->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_add->image->Required) { ?>
				elm = this.getElements("x" + infix + "_image");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_add->image->caption(), $courses_add->image->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fcoursesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fcoursesadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fcoursesadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $courses_add->showPageHeader(); ?>
<?php
$courses_add->showMessage();
?>
<form name="fcoursesadd" id="fcoursesadd" class="<?php echo $courses_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courses">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$courses_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($courses_add->time->Visible) { // time ?>
	<div id="r_time" class="form-group row">
		<label id="elh_courses_time" for="x_time" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->time->caption() ?><?php echo $courses_add->time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->time->cellAttributes() ?>>
<span id="el_courses_time">
<input type="text" data-table="courses" data-field="x_time" name="x_time" id="x_time" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($courses_add->time->getPlaceHolder()) ?>" value="<?php echo $courses_add->time->EditValue ?>"<?php echo $courses_add->time->editAttributes() ?>>
</span>
<?php echo $courses_add->time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_add->courses_name->Visible) { // courses_name ?>
	<div id="r_courses_name" class="form-group row">
		<label id="elh_courses_courses_name" for="x_courses_name" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->courses_name->caption() ?><?php echo $courses_add->courses_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->courses_name->cellAttributes() ?>>
<span id="el_courses_courses_name">
<input type="text" data-table="courses" data-field="x_courses_name" name="x_courses_name" id="x_courses_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courses_add->courses_name->getPlaceHolder()) ?>" value="<?php echo $courses_add->courses_name->EditValue ?>"<?php echo $courses_add->courses_name->editAttributes() ?>>
</span>
<?php echo $courses_add->courses_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_add->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_courses_description" for="x_description" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->description->caption() ?><?php echo $courses_add->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->description->cellAttributes() ?>>
<span id="el_courses_description">
<input type="text" data-table="courses" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_add->description->getPlaceHolder()) ?>" value="<?php echo $courses_add->description->EditValue ?>"<?php echo $courses_add->description->editAttributes() ?>>
</span>
<?php echo $courses_add->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_add->courses_name_in->Visible) { // courses_name_in ?>
	<div id="r_courses_name_in" class="form-group row">
		<label id="elh_courses_courses_name_in" for="x_courses_name_in" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->courses_name_in->caption() ?><?php echo $courses_add->courses_name_in->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->courses_name_in->cellAttributes() ?>>
<span id="el_courses_courses_name_in">
<input type="text" data-table="courses" data-field="x_courses_name_in" name="x_courses_name_in" id="x_courses_name_in" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_add->courses_name_in->getPlaceHolder()) ?>" value="<?php echo $courses_add->courses_name_in->EditValue ?>"<?php echo $courses_add->courses_name_in->editAttributes() ?>>
</span>
<?php echo $courses_add->courses_name_in->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_add->description_in->Visible) { // description_in ?>
	<div id="r_description_in" class="form-group row">
		<label id="elh_courses_description_in" for="x_description_in" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->description_in->caption() ?><?php echo $courses_add->description_in->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->description_in->cellAttributes() ?>>
<span id="el_courses_description_in">
<input type="text" data-table="courses" data-field="x_description_in" name="x_description_in" id="x_description_in" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_add->description_in->getPlaceHolder()) ?>" value="<?php echo $courses_add->description_in->EditValue ?>"<?php echo $courses_add->description_in->editAttributes() ?>>
</span>
<?php echo $courses_add->description_in->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_add->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_courses_image" for="x_image" class="<?php echo $courses_add->LeftColumnClass ?>"><?php echo $courses_add->image->caption() ?><?php echo $courses_add->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_add->RightColumnClass ?>"><div <?php echo $courses_add->image->cellAttributes() ?>>
<span id="el_courses_image">
<input type="text" data-table="courses" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_add->image->getPlaceHolder()) ?>" value="<?php echo $courses_add->image->EditValue ?>"<?php echo $courses_add->image->editAttributes() ?>>
</span>
<?php echo $courses_add->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$courses_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courses_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courses_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$courses_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$courses_add->terminate();
?>