<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courses_edit = new courses_edit();

// Run the page
$courses_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courses_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fcoursesedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fcoursesedit = currentForm = new ew.Form("fcoursesedit", "edit");

	// Validate form
	fcoursesedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($courses_edit->id->Required) { ?>
				elm = this.getElements("x" + infix + "_id");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->id->caption(), $courses_edit->id->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_edit->time->Required) { ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->time->caption(), $courses_edit->time->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($courses_edit->time->errorMessage()) ?>");
			<?php if ($courses_edit->courses_name->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_name");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->courses_name->caption(), $courses_edit->courses_name->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_edit->description->Required) { ?>
				elm = this.getElements("x" + infix + "_description");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->description->caption(), $courses_edit->description->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_edit->courses_name_in->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_name_in");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->courses_name_in->caption(), $courses_edit->courses_name_in->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_edit->description_in->Required) { ?>
				elm = this.getElements("x" + infix + "_description_in");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->description_in->caption(), $courses_edit->description_in->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($courses_edit->image->Required) { ?>
				elm = this.getElements("x" + infix + "_image");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $courses_edit->image->caption(), $courses_edit->image->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fcoursesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fcoursesedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fcoursesedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $courses_edit->showPageHeader(); ?>
<?php
$courses_edit->showMessage();
?>
<form name="fcoursesedit" id="fcoursesedit" class="<?php echo $courses_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courses">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$courses_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($courses_edit->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_courses_id" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->id->caption() ?><?php echo $courses_edit->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->id->cellAttributes() ?>>
<span id="el_courses_id">
<span<?php echo $courses_edit->id->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($courses_edit->id->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="courses" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($courses_edit->id->CurrentValue) ?>">
<?php echo $courses_edit->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->time->Visible) { // time ?>
	<div id="r_time" class="form-group row">
		<label id="elh_courses_time" for="x_time" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->time->caption() ?><?php echo $courses_edit->time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->time->cellAttributes() ?>>
<span id="el_courses_time">
<input type="text" data-table="courses" data-field="x_time" name="x_time" id="x_time" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($courses_edit->time->getPlaceHolder()) ?>" value="<?php echo $courses_edit->time->EditValue ?>"<?php echo $courses_edit->time->editAttributes() ?>>
</span>
<?php echo $courses_edit->time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->courses_name->Visible) { // courses_name ?>
	<div id="r_courses_name" class="form-group row">
		<label id="elh_courses_courses_name" for="x_courses_name" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->courses_name->caption() ?><?php echo $courses_edit->courses_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->courses_name->cellAttributes() ?>>
<span id="el_courses_courses_name">
<input type="text" data-table="courses" data-field="x_courses_name" name="x_courses_name" id="x_courses_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courses_edit->courses_name->getPlaceHolder()) ?>" value="<?php echo $courses_edit->courses_name->EditValue ?>"<?php echo $courses_edit->courses_name->editAttributes() ?>>
</span>
<?php echo $courses_edit->courses_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_courses_description" for="x_description" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->description->caption() ?><?php echo $courses_edit->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->description->cellAttributes() ?>>
<span id="el_courses_description">
<input type="text" data-table="courses" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_edit->description->getPlaceHolder()) ?>" value="<?php echo $courses_edit->description->EditValue ?>"<?php echo $courses_edit->description->editAttributes() ?>>
</span>
<?php echo $courses_edit->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->courses_name_in->Visible) { // courses_name_in ?>
	<div id="r_courses_name_in" class="form-group row">
		<label id="elh_courses_courses_name_in" for="x_courses_name_in" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->courses_name_in->caption() ?><?php echo $courses_edit->courses_name_in->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->courses_name_in->cellAttributes() ?>>
<span id="el_courses_courses_name_in">
<input type="text" data-table="courses" data-field="x_courses_name_in" name="x_courses_name_in" id="x_courses_name_in" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_edit->courses_name_in->getPlaceHolder()) ?>" value="<?php echo $courses_edit->courses_name_in->EditValue ?>"<?php echo $courses_edit->courses_name_in->editAttributes() ?>>
</span>
<?php echo $courses_edit->courses_name_in->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->description_in->Visible) { // description_in ?>
	<div id="r_description_in" class="form-group row">
		<label id="elh_courses_description_in" for="x_description_in" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->description_in->caption() ?><?php echo $courses_edit->description_in->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->description_in->cellAttributes() ?>>
<span id="el_courses_description_in">
<input type="text" data-table="courses" data-field="x_description_in" name="x_description_in" id="x_description_in" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_edit->description_in->getPlaceHolder()) ?>" value="<?php echo $courses_edit->description_in->EditValue ?>"<?php echo $courses_edit->description_in->editAttributes() ?>>
</span>
<?php echo $courses_edit->description_in->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($courses_edit->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_courses_image" for="x_image" class="<?php echo $courses_edit->LeftColumnClass ?>"><?php echo $courses_edit->image->caption() ?><?php echo $courses_edit->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $courses_edit->RightColumnClass ?>"><div <?php echo $courses_edit->image->cellAttributes() ?>>
<span id="el_courses_image">
<input type="text" data-table="courses" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($courses_edit->image->getPlaceHolder()) ?>" value="<?php echo $courses_edit->image->EditValue ?>"<?php echo $courses_edit->image->editAttributes() ?>>
</span>
<?php echo $courses_edit->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$courses_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courses_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $courses_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$courses_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$courses_edit->terminate();
?>