<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courses_list = new courses_list();

// Run the page
$courses_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courses_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$courses_list->isExport()) { ?>
<script>
var fcourseslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fcourseslist = currentForm = new ew.Form("fcourseslist", "list");
	fcourseslist.formKeyCountName = '<?php echo $courses_list->FormKeyCountName ?>';
	loadjs.done("fcourseslist");
});
var fcourseslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fcourseslistsrch = currentSearchForm = new ew.Form("fcourseslistsrch");

	// Dynamic selection lists
	// Filters

	fcourseslistsrch.filterList = <?php echo $courses_list->getFilterList() ?>;
	loadjs.done("fcourseslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$courses_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($courses_list->TotalRecords > 0 && $courses_list->ExportOptions->visible()) { ?>
<?php $courses_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($courses_list->ImportOptions->visible()) { ?>
<?php $courses_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($courses_list->SearchOptions->visible()) { ?>
<?php $courses_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($courses_list->FilterOptions->visible()) { ?>
<?php $courses_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$courses_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$courses_list->isExport() && !$courses->CurrentAction) { ?>
<form name="fcourseslistsrch" id="fcourseslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fcourseslistsrch-search-panel" class="<?php echo $courses_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="courses">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $courses_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($courses_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($courses_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $courses_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($courses_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($courses_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($courses_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($courses_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $courses_list->showPageHeader(); ?>
<?php
$courses_list->showMessage();
?>
<?php if ($courses_list->TotalRecords > 0 || $courses->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($courses_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> courses">
<form name="fcourseslist" id="fcourseslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courses">
<div id="gmp_courses" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($courses_list->TotalRecords > 0 || $courses_list->isGridEdit()) { ?>
<table id="tbl_courseslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$courses->RowType = ROWTYPE_HEADER;

// Render list options
$courses_list->renderListOptions();

// Render list options (header, left)
$courses_list->ListOptions->render("header", "left");
?>
<?php if ($courses_list->id->Visible) { // id ?>
	<?php if ($courses_list->SortUrl($courses_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $courses_list->id->headerCellClass() ?>"><div id="elh_courses_id" class="courses_id"><div class="ew-table-header-caption"><?php echo $courses_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $courses_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->id) ?>', 1);"><div id="elh_courses_id" class="courses_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($courses_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->time->Visible) { // time ?>
	<?php if ($courses_list->SortUrl($courses_list->time) == "") { ?>
		<th data-name="time" class="<?php echo $courses_list->time->headerCellClass() ?>"><div id="elh_courses_time" class="courses_time"><div class="ew-table-header-caption"><?php echo $courses_list->time->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="time" class="<?php echo $courses_list->time->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->time) ?>', 1);"><div id="elh_courses_time" class="courses_time">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->time->caption() ?></span><span class="ew-table-header-sort"><?php if ($courses_list->time->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->time->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->courses_name->Visible) { // courses_name ?>
	<?php if ($courses_list->SortUrl($courses_list->courses_name) == "") { ?>
		<th data-name="courses_name" class="<?php echo $courses_list->courses_name->headerCellClass() ?>"><div id="elh_courses_courses_name" class="courses_courses_name"><div class="ew-table-header-caption"><?php echo $courses_list->courses_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="courses_name" class="<?php echo $courses_list->courses_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->courses_name) ?>', 1);"><div id="elh_courses_courses_name" class="courses_courses_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->courses_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courses_list->courses_name->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->courses_name->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->description->Visible) { // description ?>
	<?php if ($courses_list->SortUrl($courses_list->description) == "") { ?>
		<th data-name="description" class="<?php echo $courses_list->description->headerCellClass() ?>"><div id="elh_courses_description" class="courses_description"><div class="ew-table-header-caption"><?php echo $courses_list->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $courses_list->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->description) ?>', 1);"><div id="elh_courses_description" class="courses_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courses_list->description->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->description->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->courses_name_in->Visible) { // courses_name_in ?>
	<?php if ($courses_list->SortUrl($courses_list->courses_name_in) == "") { ?>
		<th data-name="courses_name_in" class="<?php echo $courses_list->courses_name_in->headerCellClass() ?>"><div id="elh_courses_courses_name_in" class="courses_courses_name_in"><div class="ew-table-header-caption"><?php echo $courses_list->courses_name_in->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="courses_name_in" class="<?php echo $courses_list->courses_name_in->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->courses_name_in) ?>', 1);"><div id="elh_courses_courses_name_in" class="courses_courses_name_in">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->courses_name_in->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courses_list->courses_name_in->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->courses_name_in->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->description_in->Visible) { // description_in ?>
	<?php if ($courses_list->SortUrl($courses_list->description_in) == "") { ?>
		<th data-name="description_in" class="<?php echo $courses_list->description_in->headerCellClass() ?>"><div id="elh_courses_description_in" class="courses_description_in"><div class="ew-table-header-caption"><?php echo $courses_list->description_in->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_in" class="<?php echo $courses_list->description_in->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->description_in) ?>', 1);"><div id="elh_courses_description_in" class="courses_description_in">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->description_in->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courses_list->description_in->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->description_in->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courses_list->image->Visible) { // image ?>
	<?php if ($courses_list->SortUrl($courses_list->image) == "") { ?>
		<th data-name="image" class="<?php echo $courses_list->image->headerCellClass() ?>"><div id="elh_courses_image" class="courses_image"><div class="ew-table-header-caption"><?php echo $courses_list->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $courses_list->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $courses_list->SortUrl($courses_list->image) ?>', 1);"><div id="elh_courses_image" class="courses_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courses_list->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courses_list->image->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($courses_list->image->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courses_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($courses_list->ExportAll && $courses_list->isExport()) {
	$courses_list->StopRecord = $courses_list->TotalRecords;
} else {

	// Set the last record to display
	if ($courses_list->TotalRecords > $courses_list->StartRecord + $courses_list->DisplayRecords - 1)
		$courses_list->StopRecord = $courses_list->StartRecord + $courses_list->DisplayRecords - 1;
	else
		$courses_list->StopRecord = $courses_list->TotalRecords;
}
$courses_list->RecordCount = $courses_list->StartRecord - 1;
if ($courses_list->Recordset && !$courses_list->Recordset->EOF) {
	$courses_list->Recordset->moveFirst();
	$selectLimit = $courses_list->UseSelectLimit;
	if (!$selectLimit && $courses_list->StartRecord > 1)
		$courses_list->Recordset->move($courses_list->StartRecord - 1);
} elseif (!$courses->AllowAddDeleteRow && $courses_list->StopRecord == 0) {
	$courses_list->StopRecord = $courses->GridAddRowCount;
}

// Initialize aggregate
$courses->RowType = ROWTYPE_AGGREGATEINIT;
$courses->resetAttributes();
$courses_list->renderRow();
while ($courses_list->RecordCount < $courses_list->StopRecord) {
	$courses_list->RecordCount++;
	if ($courses_list->RecordCount >= $courses_list->StartRecord) {
		$courses_list->RowCount++;

		// Set up key count
		$courses_list->KeyCount = $courses_list->RowIndex;

		// Init row class and style
		$courses->resetAttributes();
		$courses->CssClass = "";
		if ($courses_list->isGridAdd()) {
		} else {
			$courses_list->loadRowValues($courses_list->Recordset); // Load row values
		}
		$courses->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$courses->RowAttrs->merge(["data-rowindex" => $courses_list->RowCount, "id" => "r" . $courses_list->RowCount . "_courses", "data-rowtype" => $courses->RowType]);

		// Render row
		$courses_list->renderRow();

		// Render list options
		$courses_list->renderListOptions();
?>
	<tr <?php echo $courses->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courses_list->ListOptions->render("body", "left", $courses_list->RowCount);
?>
	<?php if ($courses_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $courses_list->id->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_id" class="courses_id">
<span<?php echo $courses_list->id->viewAttributes() ?>><?php echo $courses_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->time->Visible) { // time ?>
		<td data-name="time" <?php echo $courses_list->time->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_time" class="courses_time">
<span<?php echo $courses_list->time->viewAttributes() ?>><?php echo $courses_list->time->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->courses_name->Visible) { // courses_name ?>
		<td data-name="courses_name" <?php echo $courses_list->courses_name->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_courses_name" class="courses_courses_name">
<span<?php echo $courses_list->courses_name->viewAttributes() ?>><?php echo $courses_list->courses_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->description->Visible) { // description ?>
		<td data-name="description" <?php echo $courses_list->description->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_description" class="courses_description">
<span<?php echo $courses_list->description->viewAttributes() ?>><?php echo $courses_list->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->courses_name_in->Visible) { // courses_name_in ?>
		<td data-name="courses_name_in" <?php echo $courses_list->courses_name_in->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_courses_name_in" class="courses_courses_name_in">
<span<?php echo $courses_list->courses_name_in->viewAttributes() ?>><?php echo $courses_list->courses_name_in->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->description_in->Visible) { // description_in ?>
		<td data-name="description_in" <?php echo $courses_list->description_in->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_description_in" class="courses_description_in">
<span<?php echo $courses_list->description_in->viewAttributes() ?>><?php echo $courses_list->description_in->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courses_list->image->Visible) { // image ?>
		<td data-name="image" <?php echo $courses_list->image->cellAttributes() ?>>
<span id="el<?php echo $courses_list->RowCount ?>_courses_image" class="courses_image">
<span<?php echo $courses_list->image->viewAttributes() ?>><?php echo $courses_list->image->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courses_list->ListOptions->render("body", "right", $courses_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$courses_list->isGridAdd())
		$courses_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$courses->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($courses_list->Recordset)
	$courses_list->Recordset->Close();
?>
<?php if (!$courses_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$courses_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $courses_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courses_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($courses_list->TotalRecords == 0 && !$courses->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $courses_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$courses_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$courses_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$courses_list->terminate();
?>