<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cuota_edit = new cuota_edit();

// Run the page
$cuota_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cuota_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fcuotaedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fcuotaedit = currentForm = new ew.Form("fcuotaedit", "edit");

	// Validate form
	fcuotaedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($cuota_edit->id_cuota->Required) { ?>
				elm = this.getElements("x" + infix + "_id_cuota");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->id_cuota->caption(), $cuota_edit->id_cuota->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($cuota_edit->id_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_id_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->id_producto->caption(), $cuota_edit->id_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_producto");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($cuota_edit->id_producto->errorMessage()) ?>");
			<?php if ($cuota_edit->interes->Required) { ?>
				elm = this.getElements("x" + infix + "_interes");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->interes->caption(), $cuota_edit->interes->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($cuota_edit->plazo_meses->Required) { ?>
				elm = this.getElements("x" + infix + "_plazo_meses");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->plazo_meses->caption(), $cuota_edit->plazo_meses->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_plazo_meses");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($cuota_edit->plazo_meses->errorMessage()) ?>");
			<?php if ($cuota_edit->monto->Required) { ?>
				elm = this.getElements("x" + infix + "_monto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->monto->caption(), $cuota_edit->monto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_monto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($cuota_edit->monto->errorMessage()) ?>");
			<?php if ($cuota_edit->pagar_mensual->Required) { ?>
				elm = this.getElements("x" + infix + "_pagar_mensual");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->pagar_mensual->caption(), $cuota_edit->pagar_mensual->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pagar_mensual");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($cuota_edit->pagar_mensual->errorMessage()) ?>");
			<?php if ($cuota_edit->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cuota_edit->estado->caption(), $cuota_edit->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($cuota_edit->estado->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fcuotaedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fcuotaedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fcuotaedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $cuota_edit->showPageHeader(); ?>
<?php
$cuota_edit->showMessage();
?>
<form name="fcuotaedit" id="fcuotaedit" class="<?php echo $cuota_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cuota">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$cuota_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($cuota_edit->id_cuota->Visible) { // id_cuota ?>
	<div id="r_id_cuota" class="form-group row">
		<label id="elh_cuota_id_cuota" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->id_cuota->caption() ?><?php echo $cuota_edit->id_cuota->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->id_cuota->cellAttributes() ?>>
<span id="el_cuota_id_cuota">
<span<?php echo $cuota_edit->id_cuota->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($cuota_edit->id_cuota->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="cuota" data-field="x_id_cuota" name="x_id_cuota" id="x_id_cuota" value="<?php echo HtmlEncode($cuota_edit->id_cuota->CurrentValue) ?>">
<?php echo $cuota_edit->id_cuota->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->id_producto->Visible) { // id_producto ?>
	<div id="r_id_producto" class="form-group row">
		<label id="elh_cuota_id_producto" for="x_id_producto" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->id_producto->caption() ?><?php echo $cuota_edit->id_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->id_producto->cellAttributes() ?>>
<span id="el_cuota_id_producto">
<input type="text" data-table="cuota" data-field="x_id_producto" name="x_id_producto" id="x_id_producto" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($cuota_edit->id_producto->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->id_producto->EditValue ?>"<?php echo $cuota_edit->id_producto->editAttributes() ?>>
</span>
<?php echo $cuota_edit->id_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->interes->Visible) { // interes ?>
	<div id="r_interes" class="form-group row">
		<label id="elh_cuota_interes" for="x_interes" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->interes->caption() ?><?php echo $cuota_edit->interes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->interes->cellAttributes() ?>>
<span id="el_cuota_interes">
<input type="text" data-table="cuota" data-field="x_interes" name="x_interes" id="x_interes" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($cuota_edit->interes->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->interes->EditValue ?>"<?php echo $cuota_edit->interes->editAttributes() ?>>
</span>
<?php echo $cuota_edit->interes->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->plazo_meses->Visible) { // plazo_meses ?>
	<div id="r_plazo_meses" class="form-group row">
		<label id="elh_cuota_plazo_meses" for="x_plazo_meses" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->plazo_meses->caption() ?><?php echo $cuota_edit->plazo_meses->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->plazo_meses->cellAttributes() ?>>
<span id="el_cuota_plazo_meses">
<input type="text" data-table="cuota" data-field="x_plazo_meses" name="x_plazo_meses" id="x_plazo_meses" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($cuota_edit->plazo_meses->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->plazo_meses->EditValue ?>"<?php echo $cuota_edit->plazo_meses->editAttributes() ?>>
</span>
<?php echo $cuota_edit->plazo_meses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->monto->Visible) { // monto ?>
	<div id="r_monto" class="form-group row">
		<label id="elh_cuota_monto" for="x_monto" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->monto->caption() ?><?php echo $cuota_edit->monto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->monto->cellAttributes() ?>>
<span id="el_cuota_monto">
<input type="text" data-table="cuota" data-field="x_monto" name="x_monto" id="x_monto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($cuota_edit->monto->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->monto->EditValue ?>"<?php echo $cuota_edit->monto->editAttributes() ?>>
</span>
<?php echo $cuota_edit->monto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->pagar_mensual->Visible) { // pagar_mensual ?>
	<div id="r_pagar_mensual" class="form-group row">
		<label id="elh_cuota_pagar_mensual" for="x_pagar_mensual" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->pagar_mensual->caption() ?><?php echo $cuota_edit->pagar_mensual->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->pagar_mensual->cellAttributes() ?>>
<span id="el_cuota_pagar_mensual">
<input type="text" data-table="cuota" data-field="x_pagar_mensual" name="x_pagar_mensual" id="x_pagar_mensual" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($cuota_edit->pagar_mensual->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->pagar_mensual->EditValue ?>"<?php echo $cuota_edit->pagar_mensual->editAttributes() ?>>
</span>
<?php echo $cuota_edit->pagar_mensual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cuota_edit->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_cuota_estado" for="x_estado" class="<?php echo $cuota_edit->LeftColumnClass ?>"><?php echo $cuota_edit->estado->caption() ?><?php echo $cuota_edit->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cuota_edit->RightColumnClass ?>"><div <?php echo $cuota_edit->estado->cellAttributes() ?>>
<span id="el_cuota_estado">
<input type="text" data-table="cuota" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($cuota_edit->estado->getPlaceHolder()) ?>" value="<?php echo $cuota_edit->estado->EditValue ?>"<?php echo $cuota_edit->estado->editAttributes() ?>>
</span>
<?php echo $cuota_edit->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$cuota_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cuota_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $cuota_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$cuota_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$cuota_edit->terminate();
?>