<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$imagenes_inmueble_view = new imagenes_inmueble_view();

// Run the page
$imagenes_inmueble_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$imagenes_inmueble_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$imagenes_inmueble_view->isExport()) { ?>
<script>
var fimagenes_inmuebleview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fimagenes_inmuebleview = currentForm = new ew.Form("fimagenes_inmuebleview", "view");
	loadjs.done("fimagenes_inmuebleview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$imagenes_inmueble_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $imagenes_inmueble_view->ExportOptions->render("body") ?>
<?php $imagenes_inmueble_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $imagenes_inmueble_view->showPageHeader(); ?>
<?php
$imagenes_inmueble_view->showMessage();
?>
<form name="fimagenes_inmuebleview" id="fimagenes_inmuebleview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="imagenes_inmueble">
<input type="hidden" name="modal" value="<?php echo (int)$imagenes_inmueble_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($imagenes_inmueble_view->id_imagen->Visible) { // id_imagen ?>
	<tr id="r_id_imagen">
		<td class="<?php echo $imagenes_inmueble_view->TableLeftColumnClass ?>"><span id="elh_imagenes_inmueble_id_imagen"><?php echo $imagenes_inmueble_view->id_imagen->caption() ?></span></td>
		<td data-name="id_imagen" <?php echo $imagenes_inmueble_view->id_imagen->cellAttributes() ?>>
<span id="el_imagenes_inmueble_id_imagen">
<span<?php echo $imagenes_inmueble_view->id_imagen->viewAttributes() ?>><?php echo $imagenes_inmueble_view->id_imagen->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($imagenes_inmueble_view->id_producto->Visible) { // id_producto ?>
	<tr id="r_id_producto">
		<td class="<?php echo $imagenes_inmueble_view->TableLeftColumnClass ?>"><span id="elh_imagenes_inmueble_id_producto"><?php echo $imagenes_inmueble_view->id_producto->caption() ?></span></td>
		<td data-name="id_producto" <?php echo $imagenes_inmueble_view->id_producto->cellAttributes() ?>>
<span id="el_imagenes_inmueble_id_producto">
<span<?php echo $imagenes_inmueble_view->id_producto->viewAttributes() ?>><?php echo $imagenes_inmueble_view->id_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($imagenes_inmueble_view->num_imagen->Visible) { // num_imagen ?>
	<tr id="r_num_imagen">
		<td class="<?php echo $imagenes_inmueble_view->TableLeftColumnClass ?>"><span id="elh_imagenes_inmueble_num_imagen"><?php echo $imagenes_inmueble_view->num_imagen->caption() ?></span></td>
		<td data-name="num_imagen" <?php echo $imagenes_inmueble_view->num_imagen->cellAttributes() ?>>
<span id="el_imagenes_inmueble_num_imagen">
<span<?php echo $imagenes_inmueble_view->num_imagen->viewAttributes() ?>><?php echo $imagenes_inmueble_view->num_imagen->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($imagenes_inmueble_view->imagen->Visible) { // imagen ?>
	<tr id="r_imagen">
		<td class="<?php echo $imagenes_inmueble_view->TableLeftColumnClass ?>"><span id="elh_imagenes_inmueble_imagen"><?php echo $imagenes_inmueble_view->imagen->caption() ?></span></td>
		<td data-name="imagen" <?php echo $imagenes_inmueble_view->imagen->cellAttributes() ?>>
<span id="el_imagenes_inmueble_imagen">
<span><?php echo GetFileViewTag($imagenes_inmueble_view->imagen, $imagenes_inmueble_view->imagen->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($imagenes_inmueble_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $imagenes_inmueble_view->TableLeftColumnClass ?>"><span id="elh_imagenes_inmueble_estado"><?php echo $imagenes_inmueble_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $imagenes_inmueble_view->estado->cellAttributes() ?>>
<span id="el_imagenes_inmueble_estado">
<span<?php echo $imagenes_inmueble_view->estado->viewAttributes() ?>><?php echo $imagenes_inmueble_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$imagenes_inmueble_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$imagenes_inmueble_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$imagenes_inmueble_view->terminate();
?>