<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_citas_list = new kp_citas_list();

// Run the page
$kp_citas_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_citas_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_citas_list->isExport()) { ?>
<script>
var fkp_citaslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_citaslist = currentForm = new ew.Form("fkp_citaslist", "list");
	fkp_citaslist.formKeyCountName = '<?php echo $kp_citas_list->FormKeyCountName ?>';
	loadjs.done("fkp_citaslist");
});
var fkp_citaslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_citaslistsrch = currentSearchForm = new ew.Form("fkp_citaslistsrch");

	// Dynamic selection lists
	// Filters

	fkp_citaslistsrch.filterList = <?php echo $kp_citas_list->getFilterList() ?>;
	loadjs.done("fkp_citaslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_citas_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_citas_list->TotalRecords > 0 && $kp_citas_list->ExportOptions->visible()) { ?>
<?php $kp_citas_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_citas_list->ImportOptions->visible()) { ?>
<?php $kp_citas_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_citas_list->SearchOptions->visible()) { ?>
<?php $kp_citas_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_citas_list->FilterOptions->visible()) { ?>
<?php $kp_citas_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_citas_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_citas_list->isExport() && !$kp_citas->CurrentAction) { ?>
<form name="fkp_citaslistsrch" id="fkp_citaslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_citaslistsrch-search-panel" class="<?php echo $kp_citas_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_citas">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_citas_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_citas_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_citas_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_citas_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_citas_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_citas_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_citas_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_citas_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_citas_list->showPageHeader(); ?>
<?php
$kp_citas_list->showMessage();
?>
<?php if ($kp_citas_list->TotalRecords > 0 || $kp_citas->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_citas_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_citas">
<form name="fkp_citaslist" id="fkp_citaslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_citas">
<div id="gmp_kp_citas" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_citas_list->TotalRecords > 0 || $kp_citas_list->isGridEdit()) { ?>
<table id="tbl_kp_citaslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_citas->RowType = ROWTYPE_HEADER;

// Render list options
$kp_citas_list->renderListOptions();

// Render list options (header, left)
$kp_citas_list->ListOptions->render("header", "left");
?>
<?php if ($kp_citas_list->id_reg->Visible) { // id_reg ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->id_reg) == "") { ?>
		<th data-name="id_reg" class="<?php echo $kp_citas_list->id_reg->headerCellClass() ?>"><div id="elh_kp_citas_id_reg" class="kp_citas_id_reg"><div class="ew-table-header-caption"><?php echo $kp_citas_list->id_reg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_reg" class="<?php echo $kp_citas_list->id_reg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->id_reg) ?>', 1);"><div id="elh_kp_citas_id_reg" class="kp_citas_id_reg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->id_reg->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->id_reg->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->id_reg->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->idempresa->Visible) { // idempresa ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->idempresa) == "") { ?>
		<th data-name="idempresa" class="<?php echo $kp_citas_list->idempresa->headerCellClass() ?>"><div id="elh_kp_citas_idempresa" class="kp_citas_idempresa"><div class="ew-table-header-caption"><?php echo $kp_citas_list->idempresa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idempresa" class="<?php echo $kp_citas_list->idempresa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->idempresa) ?>', 1);"><div id="elh_kp_citas_idempresa" class="kp_citas_idempresa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->idempresa->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->idempresa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->idempresa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->numcompra->Visible) { // numcompra ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->numcompra) == "") { ?>
		<th data-name="numcompra" class="<?php echo $kp_citas_list->numcompra->headerCellClass() ?>"><div id="elh_kp_citas_numcompra" class="kp_citas_numcompra"><div class="ew-table-header-caption"><?php echo $kp_citas_list->numcompra->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numcompra" class="<?php echo $kp_citas_list->numcompra->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->numcompra) ?>', 1);"><div id="elh_kp_citas_numcompra" class="kp_citas_numcompra">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->numcompra->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->numcompra->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->numcompra->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->codcita->Visible) { // codcita ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->codcita) == "") { ?>
		<th data-name="codcita" class="<?php echo $kp_citas_list->codcita->headerCellClass() ?>"><div id="elh_kp_citas_codcita" class="kp_citas_codcita"><div class="ew-table-header-caption"><?php echo $kp_citas_list->codcita->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codcita" class="<?php echo $kp_citas_list->codcita->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->codcita) ?>', 1);"><div id="elh_kp_citas_codcita" class="kp_citas_codcita">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->codcita->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->codcita->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->codcita->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->codrampa->Visible) { // codrampa ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->codrampa) == "") { ?>
		<th data-name="codrampa" class="<?php echo $kp_citas_list->codrampa->headerCellClass() ?>"><div id="elh_kp_citas_codrampa" class="kp_citas_codrampa"><div class="ew-table-header-caption"><?php echo $kp_citas_list->codrampa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codrampa" class="<?php echo $kp_citas_list->codrampa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->codrampa) ?>', 1);"><div id="elh_kp_citas_codrampa" class="kp_citas_codrampa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->codrampa->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->codrampa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->codrampa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->idestado->Visible) { // idestado ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->idestado) == "") { ?>
		<th data-name="idestado" class="<?php echo $kp_citas_list->idestado->headerCellClass() ?>"><div id="elh_kp_citas_idestado" class="kp_citas_idestado"><div class="ew-table-header-caption"><?php echo $kp_citas_list->idestado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idestado" class="<?php echo $kp_citas_list->idestado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->idestado) ?>', 1);"><div id="elh_kp_citas_idestado" class="kp_citas_idestado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->idestado->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->idestado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->idestado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->fechacita->Visible) { // fechacita ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->fechacita) == "") { ?>
		<th data-name="fechacita" class="<?php echo $kp_citas_list->fechacita->headerCellClass() ?>"><div id="elh_kp_citas_fechacita" class="kp_citas_fechacita"><div class="ew-table-header-caption"><?php echo $kp_citas_list->fechacita->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fechacita" class="<?php echo $kp_citas_list->fechacita->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->fechacita) ?>', 1);"><div id="elh_kp_citas_fechacita" class="kp_citas_fechacita">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->fechacita->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->fechacita->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->fechacita->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->fechaatencion->Visible) { // fechaatencion ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->fechaatencion) == "") { ?>
		<th data-name="fechaatencion" class="<?php echo $kp_citas_list->fechaatencion->headerCellClass() ?>"><div id="elh_kp_citas_fechaatencion" class="kp_citas_fechaatencion"><div class="ew-table-header-caption"><?php echo $kp_citas_list->fechaatencion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fechaatencion" class="<?php echo $kp_citas_list->fechaatencion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->fechaatencion) ?>', 1);"><div id="elh_kp_citas_fechaatencion" class="kp_citas_fechaatencion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->fechaatencion->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->fechaatencion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->fechaatencion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->horaatencion->Visible) { // horaatencion ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->horaatencion) == "") { ?>
		<th data-name="horaatencion" class="<?php echo $kp_citas_list->horaatencion->headerCellClass() ?>"><div id="elh_kp_citas_horaatencion" class="kp_citas_horaatencion"><div class="ew-table-header-caption"><?php echo $kp_citas_list->horaatencion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="horaatencion" class="<?php echo $kp_citas_list->horaatencion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->horaatencion) ?>', 1);"><div id="elh_kp_citas_horaatencion" class="kp_citas_horaatencion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->horaatencion->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->horaatencion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->horaatencion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->tiposervicio->Visible) { // tiposervicio ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->tiposervicio) == "") { ?>
		<th data-name="tiposervicio" class="<?php echo $kp_citas_list->tiposervicio->headerCellClass() ?>"><div id="elh_kp_citas_tiposervicio" class="kp_citas_tiposervicio"><div class="ew-table-header-caption"><?php echo $kp_citas_list->tiposervicio->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tiposervicio" class="<?php echo $kp_citas_list->tiposervicio->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->tiposervicio) ?>', 1);"><div id="elh_kp_citas_tiposervicio" class="kp_citas_tiposervicio">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->tiposervicio->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->tiposervicio->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->tiposervicio->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->numtotal->Visible) { // numtotal ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->numtotal) == "") { ?>
		<th data-name="numtotal" class="<?php echo $kp_citas_list->numtotal->headerCellClass() ?>"><div id="elh_kp_citas_numtotal" class="kp_citas_numtotal"><div class="ew-table-header-caption"><?php echo $kp_citas_list->numtotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numtotal" class="<?php echo $kp_citas_list->numtotal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->numtotal) ?>', 1);"><div id="elh_kp_citas_numtotal" class="kp_citas_numtotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->numtotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->numtotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->numtotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_citas_list->fechareg->Visible) { // fechareg ?>
	<?php if ($kp_citas_list->SortUrl($kp_citas_list->fechareg) == "") { ?>
		<th data-name="fechareg" class="<?php echo $kp_citas_list->fechareg->headerCellClass() ?>"><div id="elh_kp_citas_fechareg" class="kp_citas_fechareg"><div class="ew-table-header-caption"><?php echo $kp_citas_list->fechareg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fechareg" class="<?php echo $kp_citas_list->fechareg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_citas_list->SortUrl($kp_citas_list->fechareg) ?>', 1);"><div id="elh_kp_citas_fechareg" class="kp_citas_fechareg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_citas_list->fechareg->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_citas_list->fechareg->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_citas_list->fechareg->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_citas_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_citas_list->ExportAll && $kp_citas_list->isExport()) {
	$kp_citas_list->StopRecord = $kp_citas_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_citas_list->TotalRecords > $kp_citas_list->StartRecord + $kp_citas_list->DisplayRecords - 1)
		$kp_citas_list->StopRecord = $kp_citas_list->StartRecord + $kp_citas_list->DisplayRecords - 1;
	else
		$kp_citas_list->StopRecord = $kp_citas_list->TotalRecords;
}
$kp_citas_list->RecordCount = $kp_citas_list->StartRecord - 1;
if ($kp_citas_list->Recordset && !$kp_citas_list->Recordset->EOF) {
	$kp_citas_list->Recordset->moveFirst();
	$selectLimit = $kp_citas_list->UseSelectLimit;
	if (!$selectLimit && $kp_citas_list->StartRecord > 1)
		$kp_citas_list->Recordset->move($kp_citas_list->StartRecord - 1);
} elseif (!$kp_citas->AllowAddDeleteRow && $kp_citas_list->StopRecord == 0) {
	$kp_citas_list->StopRecord = $kp_citas->GridAddRowCount;
}

// Initialize aggregate
$kp_citas->RowType = ROWTYPE_AGGREGATEINIT;
$kp_citas->resetAttributes();
$kp_citas_list->renderRow();
while ($kp_citas_list->RecordCount < $kp_citas_list->StopRecord) {
	$kp_citas_list->RecordCount++;
	if ($kp_citas_list->RecordCount >= $kp_citas_list->StartRecord) {
		$kp_citas_list->RowCount++;

		// Set up key count
		$kp_citas_list->KeyCount = $kp_citas_list->RowIndex;

		// Init row class and style
		$kp_citas->resetAttributes();
		$kp_citas->CssClass = "";
		if ($kp_citas_list->isGridAdd()) {
		} else {
			$kp_citas_list->loadRowValues($kp_citas_list->Recordset); // Load row values
		}
		$kp_citas->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_citas->RowAttrs->merge(["data-rowindex" => $kp_citas_list->RowCount, "id" => "r" . $kp_citas_list->RowCount . "_kp_citas", "data-rowtype" => $kp_citas->RowType]);

		// Render row
		$kp_citas_list->renderRow();

		// Render list options
		$kp_citas_list->renderListOptions();
?>
	<tr <?php echo $kp_citas->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_citas_list->ListOptions->render("body", "left", $kp_citas_list->RowCount);
?>
	<?php if ($kp_citas_list->id_reg->Visible) { // id_reg ?>
		<td data-name="id_reg" <?php echo $kp_citas_list->id_reg->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_id_reg" class="kp_citas_id_reg">
<span<?php echo $kp_citas_list->id_reg->viewAttributes() ?>><?php echo $kp_citas_list->id_reg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->idempresa->Visible) { // idempresa ?>
		<td data-name="idempresa" <?php echo $kp_citas_list->idempresa->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_idempresa" class="kp_citas_idempresa">
<span<?php echo $kp_citas_list->idempresa->viewAttributes() ?>><?php echo $kp_citas_list->idempresa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->numcompra->Visible) { // numcompra ?>
		<td data-name="numcompra" <?php echo $kp_citas_list->numcompra->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_numcompra" class="kp_citas_numcompra">
<span<?php echo $kp_citas_list->numcompra->viewAttributes() ?>><?php echo $kp_citas_list->numcompra->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->codcita->Visible) { // codcita ?>
		<td data-name="codcita" <?php echo $kp_citas_list->codcita->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_codcita" class="kp_citas_codcita">
<span<?php echo $kp_citas_list->codcita->viewAttributes() ?>><?php echo $kp_citas_list->codcita->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->codrampa->Visible) { // codrampa ?>
		<td data-name="codrampa" <?php echo $kp_citas_list->codrampa->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_codrampa" class="kp_citas_codrampa">
<span<?php echo $kp_citas_list->codrampa->viewAttributes() ?>><?php echo $kp_citas_list->codrampa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->idestado->Visible) { // idestado ?>
		<td data-name="idestado" <?php echo $kp_citas_list->idestado->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_idestado" class="kp_citas_idestado">
<span<?php echo $kp_citas_list->idestado->viewAttributes() ?>><?php echo $kp_citas_list->idestado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->fechacita->Visible) { // fechacita ?>
		<td data-name="fechacita" <?php echo $kp_citas_list->fechacita->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_fechacita" class="kp_citas_fechacita">
<span<?php echo $kp_citas_list->fechacita->viewAttributes() ?>><?php echo $kp_citas_list->fechacita->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->fechaatencion->Visible) { // fechaatencion ?>
		<td data-name="fechaatencion" <?php echo $kp_citas_list->fechaatencion->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_fechaatencion" class="kp_citas_fechaatencion">
<span<?php echo $kp_citas_list->fechaatencion->viewAttributes() ?>><?php echo $kp_citas_list->fechaatencion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->horaatencion->Visible) { // horaatencion ?>
		<td data-name="horaatencion" <?php echo $kp_citas_list->horaatencion->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_horaatencion" class="kp_citas_horaatencion">
<span<?php echo $kp_citas_list->horaatencion->viewAttributes() ?>><?php echo $kp_citas_list->horaatencion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->tiposervicio->Visible) { // tiposervicio ?>
		<td data-name="tiposervicio" <?php echo $kp_citas_list->tiposervicio->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_tiposervicio" class="kp_citas_tiposervicio">
<span<?php echo $kp_citas_list->tiposervicio->viewAttributes() ?>><?php echo $kp_citas_list->tiposervicio->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->numtotal->Visible) { // numtotal ?>
		<td data-name="numtotal" <?php echo $kp_citas_list->numtotal->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_numtotal" class="kp_citas_numtotal">
<span<?php echo $kp_citas_list->numtotal->viewAttributes() ?>><?php echo $kp_citas_list->numtotal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_citas_list->fechareg->Visible) { // fechareg ?>
		<td data-name="fechareg" <?php echo $kp_citas_list->fechareg->cellAttributes() ?>>
<span id="el<?php echo $kp_citas_list->RowCount ?>_kp_citas_fechareg" class="kp_citas_fechareg">
<span<?php echo $kp_citas_list->fechareg->viewAttributes() ?>><?php echo $kp_citas_list->fechareg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_citas_list->ListOptions->render("body", "right", $kp_citas_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_citas_list->isGridAdd())
		$kp_citas_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_citas->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_citas_list->Recordset)
	$kp_citas_list->Recordset->Close();
?>
<?php if (!$kp_citas_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_citas_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_citas_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_citas_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_citas_list->TotalRecords == 0 && !$kp_citas->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_citas_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_citas_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_citas_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_citas_list->terminate();
?>