<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_clientes_list = new kp_clientes_list();

// Run the page
$kp_clientes_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_clientes_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_clientes_list->isExport()) { ?>
<script>
var fkp_clienteslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkp_clienteslist = currentForm = new ew.Form("fkp_clienteslist", "list");
	fkp_clienteslist.formKeyCountName = '<?php echo $kp_clientes_list->FormKeyCountName ?>';
	loadjs.done("fkp_clienteslist");
});
var fkp_clienteslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkp_clienteslistsrch = currentSearchForm = new ew.Form("fkp_clienteslistsrch");

	// Dynamic selection lists
	// Filters

	fkp_clienteslistsrch.filterList = <?php echo $kp_clientes_list->getFilterList() ?>;
	loadjs.done("fkp_clienteslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_clientes_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kp_clientes_list->TotalRecords > 0 && $kp_clientes_list->ExportOptions->visible()) { ?>
<?php $kp_clientes_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_clientes_list->ImportOptions->visible()) { ?>
<?php $kp_clientes_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kp_clientes_list->SearchOptions->visible()) { ?>
<?php $kp_clientes_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kp_clientes_list->FilterOptions->visible()) { ?>
<?php $kp_clientes_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kp_clientes_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kp_clientes_list->isExport() && !$kp_clientes->CurrentAction) { ?>
<form name="fkp_clienteslistsrch" id="fkp_clienteslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkp_clienteslistsrch-search-panel" class="<?php echo $kp_clientes_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kp_clientes">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kp_clientes_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kp_clientes_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kp_clientes_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kp_clientes_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kp_clientes_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kp_clientes_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kp_clientes_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kp_clientes_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kp_clientes_list->showPageHeader(); ?>
<?php
$kp_clientes_list->showMessage();
?>
<?php if ($kp_clientes_list->TotalRecords > 0 || $kp_clientes->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kp_clientes_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kp_clientes">
<form name="fkp_clienteslist" id="fkp_clienteslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_clientes">
<div id="gmp_kp_clientes" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kp_clientes_list->TotalRecords > 0 || $kp_clientes_list->isGridEdit()) { ?>
<table id="tbl_kp_clienteslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kp_clientes->RowType = ROWTYPE_HEADER;

// Render list options
$kp_clientes_list->renderListOptions();

// Render list options (header, left)
$kp_clientes_list->ListOptions->render("header", "left");
?>
<?php if ($kp_clientes_list->id_reg->Visible) { // id_reg ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->id_reg) == "") { ?>
		<th data-name="id_reg" class="<?php echo $kp_clientes_list->id_reg->headerCellClass() ?>"><div id="elh_kp_clientes_id_reg" class="kp_clientes_id_reg"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->id_reg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_reg" class="<?php echo $kp_clientes_list->id_reg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->id_reg) ?>', 1);"><div id="elh_kp_clientes_id_reg" class="kp_clientes_id_reg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->id_reg->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->id_reg->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->id_reg->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->estado->Visible) { // estado ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $kp_clientes_list->estado->headerCellClass() ?>"><div id="elh_kp_clientes_estado" class="kp_clientes_estado"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $kp_clientes_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->estado) ?>', 1);"><div id="elh_kp_clientes_estado" class="kp_clientes_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->idempresa->Visible) { // idempresa ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->idempresa) == "") { ?>
		<th data-name="idempresa" class="<?php echo $kp_clientes_list->idempresa->headerCellClass() ?>"><div id="elh_kp_clientes_idempresa" class="kp_clientes_idempresa"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->idempresa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idempresa" class="<?php echo $kp_clientes_list->idempresa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->idempresa) ?>', 1);"><div id="elh_kp_clientes_idempresa" class="kp_clientes_idempresa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->idempresa->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->idempresa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->idempresa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->codcliente->Visible) { // codcliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->codcliente) == "") { ?>
		<th data-name="codcliente" class="<?php echo $kp_clientes_list->codcliente->headerCellClass() ?>"><div id="elh_kp_clientes_codcliente" class="kp_clientes_codcliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->codcliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codcliente" class="<?php echo $kp_clientes_list->codcliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->codcliente) ?>', 1);"><div id="elh_kp_clientes_codcliente" class="kp_clientes_codcliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->codcliente->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->codcliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->codcliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->codclienteemp->Visible) { // codclienteemp ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->codclienteemp) == "") { ?>
		<th data-name="codclienteemp" class="<?php echo $kp_clientes_list->codclienteemp->headerCellClass() ?>"><div id="elh_kp_clientes_codclienteemp" class="kp_clientes_codclienteemp"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->codclienteemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codclienteemp" class="<?php echo $kp_clientes_list->codclienteemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->codclienteemp) ?>', 1);"><div id="elh_kp_clientes_codclienteemp" class="kp_clientes_codclienteemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->codclienteemp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->codclienteemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->codclienteemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->tipocliente->Visible) { // tipocliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->tipocliente) == "") { ?>
		<th data-name="tipocliente" class="<?php echo $kp_clientes_list->tipocliente->headerCellClass() ?>"><div id="elh_kp_clientes_tipocliente" class="kp_clientes_tipocliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->tipocliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipocliente" class="<?php echo $kp_clientes_list->tipocliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->tipocliente) ?>', 1);"><div id="elh_kp_clientes_tipocliente" class="kp_clientes_tipocliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->tipocliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->tipocliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->tipocliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numruc->Visible) { // numruc ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numruc) == "") { ?>
		<th data-name="numruc" class="<?php echo $kp_clientes_list->numruc->headerCellClass() ?>"><div id="elh_kp_clientes_numruc" class="kp_clientes_numruc"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numruc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numruc" class="<?php echo $kp_clientes_list->numruc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numruc) ?>', 1);"><div id="elh_kp_clientes_numruc" class="kp_clientes_numruc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numruc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numruc->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numruc->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numdni->Visible) { // numdni ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numdni) == "") { ?>
		<th data-name="numdni" class="<?php echo $kp_clientes_list->numdni->headerCellClass() ?>"><div id="elh_kp_clientes_numdni" class="kp_clientes_numdni"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numdni->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numdni" class="<?php echo $kp_clientes_list->numdni->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numdni) ?>', 1);"><div id="elh_kp_clientes_numdni" class="kp_clientes_numdni">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numdni->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numdni->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numdni->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->nomcliente->Visible) { // nomcliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->nomcliente) == "") { ?>
		<th data-name="nomcliente" class="<?php echo $kp_clientes_list->nomcliente->headerCellClass() ?>"><div id="elh_kp_clientes_nomcliente" class="kp_clientes_nomcliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->nomcliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomcliente" class="<?php echo $kp_clientes_list->nomcliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->nomcliente) ?>', 1);"><div id="elh_kp_clientes_nomcliente" class="kp_clientes_nomcliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->nomcliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->nomcliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->nomcliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->nomclientecorp->Visible) { // nomclientecorp ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->nomclientecorp) == "") { ?>
		<th data-name="nomclientecorp" class="<?php echo $kp_clientes_list->nomclientecorp->headerCellClass() ?>"><div id="elh_kp_clientes_nomclientecorp" class="kp_clientes_nomclientecorp"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->nomclientecorp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomclientecorp" class="<?php echo $kp_clientes_list->nomclientecorp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->nomclientecorp) ?>', 1);"><div id="elh_kp_clientes_nomclientecorp" class="kp_clientes_nomclientecorp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->nomclientecorp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->nomclientecorp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->nomclientecorp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->dircliente->Visible) { // dircliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->dircliente) == "") { ?>
		<th data-name="dircliente" class="<?php echo $kp_clientes_list->dircliente->headerCellClass() ?>"><div id="elh_kp_clientes_dircliente" class="kp_clientes_dircliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->dircliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dircliente" class="<?php echo $kp_clientes_list->dircliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->dircliente) ?>', 1);"><div id="elh_kp_clientes_dircliente" class="kp_clientes_dircliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->dircliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->dircliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->dircliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->dirclientefis->Visible) { // dirclientefis ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->dirclientefis) == "") { ?>
		<th data-name="dirclientefis" class="<?php echo $kp_clientes_list->dirclientefis->headerCellClass() ?>"><div id="elh_kp_clientes_dirclientefis" class="kp_clientes_dirclientefis"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->dirclientefis->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dirclientefis" class="<?php echo $kp_clientes_list->dirclientefis->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->dirclientefis) ?>', 1);"><div id="elh_kp_clientes_dirclientefis" class="kp_clientes_dirclientefis">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->dirclientefis->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->dirclientefis->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->dirclientefis->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->refcliente->Visible) { // refcliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->refcliente) == "") { ?>
		<th data-name="refcliente" class="<?php echo $kp_clientes_list->refcliente->headerCellClass() ?>"><div id="elh_kp_clientes_refcliente" class="kp_clientes_refcliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->refcliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="refcliente" class="<?php echo $kp_clientes_list->refcliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->refcliente) ?>', 1);"><div id="elh_kp_clientes_refcliente" class="kp_clientes_refcliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->refcliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->refcliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->refcliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->coddpto->Visible) { // coddpto ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->coddpto) == "") { ?>
		<th data-name="coddpto" class="<?php echo $kp_clientes_list->coddpto->headerCellClass() ?>"><div id="elh_kp_clientes_coddpto" class="kp_clientes_coddpto"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->coddpto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="coddpto" class="<?php echo $kp_clientes_list->coddpto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->coddpto) ?>', 1);"><div id="elh_kp_clientes_coddpto" class="kp_clientes_coddpto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->coddpto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->coddpto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->coddpto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->codprov->Visible) { // codprov ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->codprov) == "") { ?>
		<th data-name="codprov" class="<?php echo $kp_clientes_list->codprov->headerCellClass() ?>"><div id="elh_kp_clientes_codprov" class="kp_clientes_codprov"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->codprov->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codprov" class="<?php echo $kp_clientes_list->codprov->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->codprov) ?>', 1);"><div id="elh_kp_clientes_codprov" class="kp_clientes_codprov">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->codprov->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->codprov->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->codprov->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->coddist->Visible) { // coddist ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->coddist) == "") { ?>
		<th data-name="coddist" class="<?php echo $kp_clientes_list->coddist->headerCellClass() ?>"><div id="elh_kp_clientes_coddist" class="kp_clientes_coddist"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->coddist->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="coddist" class="<?php echo $kp_clientes_list->coddist->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->coddist) ?>', 1);"><div id="elh_kp_clientes_coddist" class="kp_clientes_coddist">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->coddist->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->coddist->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->coddist->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->codubigeo->Visible) { // codubigeo ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->codubigeo) == "") { ?>
		<th data-name="codubigeo" class="<?php echo $kp_clientes_list->codubigeo->headerCellClass() ?>"><div id="elh_kp_clientes_codubigeo" class="kp_clientes_codubigeo"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->codubigeo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codubigeo" class="<?php echo $kp_clientes_list->codubigeo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->codubigeo) ?>', 1);"><div id="elh_kp_clientes_codubigeo" class="kp_clientes_codubigeo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->codubigeo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->codubigeo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->codubigeo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numtelefono->Visible) { // numtelefono ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numtelefono) == "") { ?>
		<th data-name="numtelefono" class="<?php echo $kp_clientes_list->numtelefono->headerCellClass() ?>"><div id="elh_kp_clientes_numtelefono" class="kp_clientes_numtelefono"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefono->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numtelefono" class="<?php echo $kp_clientes_list->numtelefono->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numtelefono) ?>', 1);"><div id="elh_kp_clientes_numtelefono" class="kp_clientes_numtelefono">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefono->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numtelefono->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numtelefono->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numtelefono2->Visible) { // numtelefono2 ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numtelefono2) == "") { ?>
		<th data-name="numtelefono2" class="<?php echo $kp_clientes_list->numtelefono2->headerCellClass() ?>"><div id="elh_kp_clientes_numtelefono2" class="kp_clientes_numtelefono2"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefono2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numtelefono2" class="<?php echo $kp_clientes_list->numtelefono2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numtelefono2) ?>', 1);"><div id="elh_kp_clientes_numtelefono2" class="kp_clientes_numtelefono2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefono2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numtelefono2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numtelefono2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->emailcliente->Visible) { // emailcliente ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->emailcliente) == "") { ?>
		<th data-name="emailcliente" class="<?php echo $kp_clientes_list->emailcliente->headerCellClass() ?>"><div id="elh_kp_clientes_emailcliente" class="kp_clientes_emailcliente"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->emailcliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emailcliente" class="<?php echo $kp_clientes_list->emailcliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->emailcliente) ?>', 1);"><div id="elh_kp_clientes_emailcliente" class="kp_clientes_emailcliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->emailcliente->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->emailcliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->emailcliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->nomclienteaut->Visible) { // nomclienteaut ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->nomclienteaut) == "") { ?>
		<th data-name="nomclienteaut" class="<?php echo $kp_clientes_list->nomclienteaut->headerCellClass() ?>"><div id="elh_kp_clientes_nomclienteaut" class="kp_clientes_nomclienteaut"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->nomclienteaut->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomclienteaut" class="<?php echo $kp_clientes_list->nomclienteaut->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->nomclienteaut) ?>', 1);"><div id="elh_kp_clientes_nomclienteaut" class="kp_clientes_nomclienteaut">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->nomclienteaut->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->nomclienteaut->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->nomclienteaut->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numtelefonoaut->Visible) { // numtelefonoaut ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numtelefonoaut) == "") { ?>
		<th data-name="numtelefonoaut" class="<?php echo $kp_clientes_list->numtelefonoaut->headerCellClass() ?>"><div id="elh_kp_clientes_numtelefonoaut" class="kp_clientes_numtelefonoaut"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefonoaut->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numtelefonoaut" class="<?php echo $kp_clientes_list->numtelefonoaut->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numtelefonoaut) ?>', 1);"><div id="elh_kp_clientes_numtelefonoaut" class="kp_clientes_numtelefonoaut">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numtelefonoaut->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numtelefonoaut->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numtelefonoaut->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->numdniaut->Visible) { // numdniaut ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->numdniaut) == "") { ?>
		<th data-name="numdniaut" class="<?php echo $kp_clientes_list->numdniaut->headerCellClass() ?>"><div id="elh_kp_clientes_numdniaut" class="kp_clientes_numdniaut"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->numdniaut->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numdniaut" class="<?php echo $kp_clientes_list->numdniaut->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->numdniaut) ?>', 1);"><div id="elh_kp_clientes_numdniaut" class="kp_clientes_numdniaut">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->numdniaut->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->numdniaut->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->numdniaut->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kp_clientes_list->fecha_reg->Visible) { // fecha_reg ?>
	<?php if ($kp_clientes_list->SortUrl($kp_clientes_list->fecha_reg) == "") { ?>
		<th data-name="fecha_reg" class="<?php echo $kp_clientes_list->fecha_reg->headerCellClass() ?>"><div id="elh_kp_clientes_fecha_reg" class="kp_clientes_fecha_reg"><div class="ew-table-header-caption"><?php echo $kp_clientes_list->fecha_reg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha_reg" class="<?php echo $kp_clientes_list->fecha_reg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kp_clientes_list->SortUrl($kp_clientes_list->fecha_reg) ?>', 1);"><div id="elh_kp_clientes_fecha_reg" class="kp_clientes_fecha_reg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kp_clientes_list->fecha_reg->caption() ?></span><span class="ew-table-header-sort"><?php if ($kp_clientes_list->fecha_reg->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kp_clientes_list->fecha_reg->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kp_clientes_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kp_clientes_list->ExportAll && $kp_clientes_list->isExport()) {
	$kp_clientes_list->StopRecord = $kp_clientes_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kp_clientes_list->TotalRecords > $kp_clientes_list->StartRecord + $kp_clientes_list->DisplayRecords - 1)
		$kp_clientes_list->StopRecord = $kp_clientes_list->StartRecord + $kp_clientes_list->DisplayRecords - 1;
	else
		$kp_clientes_list->StopRecord = $kp_clientes_list->TotalRecords;
}
$kp_clientes_list->RecordCount = $kp_clientes_list->StartRecord - 1;
if ($kp_clientes_list->Recordset && !$kp_clientes_list->Recordset->EOF) {
	$kp_clientes_list->Recordset->moveFirst();
	$selectLimit = $kp_clientes_list->UseSelectLimit;
	if (!$selectLimit && $kp_clientes_list->StartRecord > 1)
		$kp_clientes_list->Recordset->move($kp_clientes_list->StartRecord - 1);
} elseif (!$kp_clientes->AllowAddDeleteRow && $kp_clientes_list->StopRecord == 0) {
	$kp_clientes_list->StopRecord = $kp_clientes->GridAddRowCount;
}

// Initialize aggregate
$kp_clientes->RowType = ROWTYPE_AGGREGATEINIT;
$kp_clientes->resetAttributes();
$kp_clientes_list->renderRow();
while ($kp_clientes_list->RecordCount < $kp_clientes_list->StopRecord) {
	$kp_clientes_list->RecordCount++;
	if ($kp_clientes_list->RecordCount >= $kp_clientes_list->StartRecord) {
		$kp_clientes_list->RowCount++;

		// Set up key count
		$kp_clientes_list->KeyCount = $kp_clientes_list->RowIndex;

		// Init row class and style
		$kp_clientes->resetAttributes();
		$kp_clientes->CssClass = "";
		if ($kp_clientes_list->isGridAdd()) {
		} else {
			$kp_clientes_list->loadRowValues($kp_clientes_list->Recordset); // Load row values
		}
		$kp_clientes->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kp_clientes->RowAttrs->merge(["data-rowindex" => $kp_clientes_list->RowCount, "id" => "r" . $kp_clientes_list->RowCount . "_kp_clientes", "data-rowtype" => $kp_clientes->RowType]);

		// Render row
		$kp_clientes_list->renderRow();

		// Render list options
		$kp_clientes_list->renderListOptions();
?>
	<tr <?php echo $kp_clientes->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kp_clientes_list->ListOptions->render("body", "left", $kp_clientes_list->RowCount);
?>
	<?php if ($kp_clientes_list->id_reg->Visible) { // id_reg ?>
		<td data-name="id_reg" <?php echo $kp_clientes_list->id_reg->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_id_reg" class="kp_clientes_id_reg">
<span<?php echo $kp_clientes_list->id_reg->viewAttributes() ?>><?php echo $kp_clientes_list->id_reg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $kp_clientes_list->estado->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_estado" class="kp_clientes_estado">
<span<?php echo $kp_clientes_list->estado->viewAttributes() ?>><?php echo $kp_clientes_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->idempresa->Visible) { // idempresa ?>
		<td data-name="idempresa" <?php echo $kp_clientes_list->idempresa->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_idempresa" class="kp_clientes_idempresa">
<span<?php echo $kp_clientes_list->idempresa->viewAttributes() ?>><?php echo $kp_clientes_list->idempresa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->codcliente->Visible) { // codcliente ?>
		<td data-name="codcliente" <?php echo $kp_clientes_list->codcliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_codcliente" class="kp_clientes_codcliente">
<span<?php echo $kp_clientes_list->codcliente->viewAttributes() ?>><?php echo $kp_clientes_list->codcliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->codclienteemp->Visible) { // codclienteemp ?>
		<td data-name="codclienteemp" <?php echo $kp_clientes_list->codclienteemp->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_codclienteemp" class="kp_clientes_codclienteemp">
<span<?php echo $kp_clientes_list->codclienteemp->viewAttributes() ?>><?php echo $kp_clientes_list->codclienteemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->tipocliente->Visible) { // tipocliente ?>
		<td data-name="tipocliente" <?php echo $kp_clientes_list->tipocliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_tipocliente" class="kp_clientes_tipocliente">
<span<?php echo $kp_clientes_list->tipocliente->viewAttributes() ?>><?php echo $kp_clientes_list->tipocliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numruc->Visible) { // numruc ?>
		<td data-name="numruc" <?php echo $kp_clientes_list->numruc->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numruc" class="kp_clientes_numruc">
<span<?php echo $kp_clientes_list->numruc->viewAttributes() ?>><?php echo $kp_clientes_list->numruc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numdni->Visible) { // numdni ?>
		<td data-name="numdni" <?php echo $kp_clientes_list->numdni->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numdni" class="kp_clientes_numdni">
<span<?php echo $kp_clientes_list->numdni->viewAttributes() ?>><?php echo $kp_clientes_list->numdni->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->nomcliente->Visible) { // nomcliente ?>
		<td data-name="nomcliente" <?php echo $kp_clientes_list->nomcliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_nomcliente" class="kp_clientes_nomcliente">
<span<?php echo $kp_clientes_list->nomcliente->viewAttributes() ?>><?php echo $kp_clientes_list->nomcliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->nomclientecorp->Visible) { // nomclientecorp ?>
		<td data-name="nomclientecorp" <?php echo $kp_clientes_list->nomclientecorp->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_nomclientecorp" class="kp_clientes_nomclientecorp">
<span<?php echo $kp_clientes_list->nomclientecorp->viewAttributes() ?>><?php echo $kp_clientes_list->nomclientecorp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->dircliente->Visible) { // dircliente ?>
		<td data-name="dircliente" <?php echo $kp_clientes_list->dircliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_dircliente" class="kp_clientes_dircliente">
<span<?php echo $kp_clientes_list->dircliente->viewAttributes() ?>><?php echo $kp_clientes_list->dircliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->dirclientefis->Visible) { // dirclientefis ?>
		<td data-name="dirclientefis" <?php echo $kp_clientes_list->dirclientefis->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_dirclientefis" class="kp_clientes_dirclientefis">
<span<?php echo $kp_clientes_list->dirclientefis->viewAttributes() ?>><?php echo $kp_clientes_list->dirclientefis->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->refcliente->Visible) { // refcliente ?>
		<td data-name="refcliente" <?php echo $kp_clientes_list->refcliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_refcliente" class="kp_clientes_refcliente">
<span<?php echo $kp_clientes_list->refcliente->viewAttributes() ?>><?php echo $kp_clientes_list->refcliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->coddpto->Visible) { // coddpto ?>
		<td data-name="coddpto" <?php echo $kp_clientes_list->coddpto->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_coddpto" class="kp_clientes_coddpto">
<span<?php echo $kp_clientes_list->coddpto->viewAttributes() ?>><?php echo $kp_clientes_list->coddpto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->codprov->Visible) { // codprov ?>
		<td data-name="codprov" <?php echo $kp_clientes_list->codprov->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_codprov" class="kp_clientes_codprov">
<span<?php echo $kp_clientes_list->codprov->viewAttributes() ?>><?php echo $kp_clientes_list->codprov->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->coddist->Visible) { // coddist ?>
		<td data-name="coddist" <?php echo $kp_clientes_list->coddist->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_coddist" class="kp_clientes_coddist">
<span<?php echo $kp_clientes_list->coddist->viewAttributes() ?>><?php echo $kp_clientes_list->coddist->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->codubigeo->Visible) { // codubigeo ?>
		<td data-name="codubigeo" <?php echo $kp_clientes_list->codubigeo->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_codubigeo" class="kp_clientes_codubigeo">
<span<?php echo $kp_clientes_list->codubigeo->viewAttributes() ?>><?php echo $kp_clientes_list->codubigeo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numtelefono->Visible) { // numtelefono ?>
		<td data-name="numtelefono" <?php echo $kp_clientes_list->numtelefono->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numtelefono" class="kp_clientes_numtelefono">
<span<?php echo $kp_clientes_list->numtelefono->viewAttributes() ?>><?php echo $kp_clientes_list->numtelefono->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numtelefono2->Visible) { // numtelefono2 ?>
		<td data-name="numtelefono2" <?php echo $kp_clientes_list->numtelefono2->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numtelefono2" class="kp_clientes_numtelefono2">
<span<?php echo $kp_clientes_list->numtelefono2->viewAttributes() ?>><?php echo $kp_clientes_list->numtelefono2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->emailcliente->Visible) { // emailcliente ?>
		<td data-name="emailcliente" <?php echo $kp_clientes_list->emailcliente->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_emailcliente" class="kp_clientes_emailcliente">
<span<?php echo $kp_clientes_list->emailcliente->viewAttributes() ?>><?php echo $kp_clientes_list->emailcliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->nomclienteaut->Visible) { // nomclienteaut ?>
		<td data-name="nomclienteaut" <?php echo $kp_clientes_list->nomclienteaut->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_nomclienteaut" class="kp_clientes_nomclienteaut">
<span<?php echo $kp_clientes_list->nomclienteaut->viewAttributes() ?>><?php echo $kp_clientes_list->nomclienteaut->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numtelefonoaut->Visible) { // numtelefonoaut ?>
		<td data-name="numtelefonoaut" <?php echo $kp_clientes_list->numtelefonoaut->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numtelefonoaut" class="kp_clientes_numtelefonoaut">
<span<?php echo $kp_clientes_list->numtelefonoaut->viewAttributes() ?>><?php echo $kp_clientes_list->numtelefonoaut->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->numdniaut->Visible) { // numdniaut ?>
		<td data-name="numdniaut" <?php echo $kp_clientes_list->numdniaut->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_numdniaut" class="kp_clientes_numdniaut">
<span<?php echo $kp_clientes_list->numdniaut->viewAttributes() ?>><?php echo $kp_clientes_list->numdniaut->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kp_clientes_list->fecha_reg->Visible) { // fecha_reg ?>
		<td data-name="fecha_reg" <?php echo $kp_clientes_list->fecha_reg->cellAttributes() ?>>
<span id="el<?php echo $kp_clientes_list->RowCount ?>_kp_clientes_fecha_reg" class="kp_clientes_fecha_reg">
<span<?php echo $kp_clientes_list->fecha_reg->viewAttributes() ?>><?php echo $kp_clientes_list->fecha_reg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kp_clientes_list->ListOptions->render("body", "right", $kp_clientes_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kp_clientes_list->isGridAdd())
		$kp_clientes_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kp_clientes->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kp_clientes_list->Recordset)
	$kp_clientes_list->Recordset->Close();
?>
<?php if (!$kp_clientes_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kp_clientes_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kp_clientes_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kp_clientes_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kp_clientes_list->TotalRecords == 0 && !$kp_clientes->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kp_clientes_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kp_clientes_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_clientes_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_clientes_list->terminate();
?>