<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_perfiles_edit = new kp_perfiles_edit();

// Run the page
$kp_perfiles_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_perfiles_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fkp_perfilesedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fkp_perfilesedit = currentForm = new ew.Form("fkp_perfilesedit", "edit");

	// Validate form
	fkp_perfilesedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($kp_perfiles_edit->idperfil->Required) { ?>
				elm = this.getElements("x" + infix + "_idperfil");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $kp_perfiles_edit->idperfil->caption(), $kp_perfiles_edit->idperfil->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($kp_perfiles_edit->descripcionperfil->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcionperfil");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $kp_perfiles_edit->descripcionperfil->caption(), $kp_perfiles_edit->descripcionperfil->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($kp_perfiles_edit->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $kp_perfiles_edit->estado->caption(), $kp_perfiles_edit->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($kp_perfiles_edit->idempresa->Required) { ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $kp_perfiles_edit->idempresa->caption(), $kp_perfiles_edit->idempresa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($kp_perfiles_edit->idempresa->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fkp_perfilesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fkp_perfilesedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fkp_perfilesedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $kp_perfiles_edit->showPageHeader(); ?>
<?php
$kp_perfiles_edit->showMessage();
?>
<form name="fkp_perfilesedit" id="fkp_perfilesedit" class="<?php echo $kp_perfiles_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_perfiles">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$kp_perfiles_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($kp_perfiles_edit->idperfil->Visible) { // idperfil ?>
	<div id="r_idperfil" class="form-group row">
		<label id="elh_kp_perfiles_idperfil" class="<?php echo $kp_perfiles_edit->LeftColumnClass ?>"><?php echo $kp_perfiles_edit->idperfil->caption() ?><?php echo $kp_perfiles_edit->idperfil->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $kp_perfiles_edit->RightColumnClass ?>"><div <?php echo $kp_perfiles_edit->idperfil->cellAttributes() ?>>
<span id="el_kp_perfiles_idperfil">
<span<?php echo $kp_perfiles_edit->idperfil->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($kp_perfiles_edit->idperfil->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="kp_perfiles" data-field="x_idperfil" name="x_idperfil" id="x_idperfil" value="<?php echo HtmlEncode($kp_perfiles_edit->idperfil->CurrentValue) ?>">
<?php echo $kp_perfiles_edit->idperfil->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kp_perfiles_edit->descripcionperfil->Visible) { // descripcionperfil ?>
	<div id="r_descripcionperfil" class="form-group row">
		<label id="elh_kp_perfiles_descripcionperfil" for="x_descripcionperfil" class="<?php echo $kp_perfiles_edit->LeftColumnClass ?>"><?php echo $kp_perfiles_edit->descripcionperfil->caption() ?><?php echo $kp_perfiles_edit->descripcionperfil->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $kp_perfiles_edit->RightColumnClass ?>"><div <?php echo $kp_perfiles_edit->descripcionperfil->cellAttributes() ?>>
<span id="el_kp_perfiles_descripcionperfil">
<input type="text" data-table="kp_perfiles" data-field="x_descripcionperfil" name="x_descripcionperfil" id="x_descripcionperfil" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($kp_perfiles_edit->descripcionperfil->getPlaceHolder()) ?>" value="<?php echo $kp_perfiles_edit->descripcionperfil->EditValue ?>"<?php echo $kp_perfiles_edit->descripcionperfil->editAttributes() ?>>
</span>
<?php echo $kp_perfiles_edit->descripcionperfil->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kp_perfiles_edit->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_kp_perfiles_estado" for="x_estado" class="<?php echo $kp_perfiles_edit->LeftColumnClass ?>"><?php echo $kp_perfiles_edit->estado->caption() ?><?php echo $kp_perfiles_edit->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $kp_perfiles_edit->RightColumnClass ?>"><div <?php echo $kp_perfiles_edit->estado->cellAttributes() ?>>
<span id="el_kp_perfiles_estado">
<input type="text" data-table="kp_perfiles" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($kp_perfiles_edit->estado->getPlaceHolder()) ?>" value="<?php echo $kp_perfiles_edit->estado->EditValue ?>"<?php echo $kp_perfiles_edit->estado->editAttributes() ?>>
</span>
<?php echo $kp_perfiles_edit->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($kp_perfiles_edit->idempresa->Visible) { // idempresa ?>
	<div id="r_idempresa" class="form-group row">
		<label id="elh_kp_perfiles_idempresa" for="x_idempresa" class="<?php echo $kp_perfiles_edit->LeftColumnClass ?>"><?php echo $kp_perfiles_edit->idempresa->caption() ?><?php echo $kp_perfiles_edit->idempresa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $kp_perfiles_edit->RightColumnClass ?>"><div <?php echo $kp_perfiles_edit->idempresa->cellAttributes() ?>>
<span id="el_kp_perfiles_idempresa">
<input type="text" data-table="kp_perfiles" data-field="x_idempresa" name="x_idempresa" id="x_idempresa" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($kp_perfiles_edit->idempresa->getPlaceHolder()) ?>" value="<?php echo $kp_perfiles_edit->idempresa->EditValue ?>"<?php echo $kp_perfiles_edit->idempresa->editAttributes() ?>>
</span>
<?php echo $kp_perfiles_edit->idempresa->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$kp_perfiles_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $kp_perfiles_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $kp_perfiles_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$kp_perfiles_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$kp_perfiles_edit->terminate();
?>