<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kt_driver_task_list = new kt_driver_task_list();

// Run the page
$kt_driver_task_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kt_driver_task_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kt_driver_task_list->isExport()) { ?>
<script>
var fkt_driver_tasklist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fkt_driver_tasklist = currentForm = new ew.Form("fkt_driver_tasklist", "list");
	fkt_driver_tasklist.formKeyCountName = '<?php echo $kt_driver_task_list->FormKeyCountName ?>';
	loadjs.done("fkt_driver_tasklist");
});
var fkt_driver_tasklistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fkt_driver_tasklistsrch = currentSearchForm = new ew.Form("fkt_driver_tasklistsrch");

	// Dynamic selection lists
	// Filters

	fkt_driver_tasklistsrch.filterList = <?php echo $kt_driver_task_list->getFilterList() ?>;
	loadjs.done("fkt_driver_tasklistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kt_driver_task_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($kt_driver_task_list->TotalRecords > 0 && $kt_driver_task_list->ExportOptions->visible()) { ?>
<?php $kt_driver_task_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($kt_driver_task_list->ImportOptions->visible()) { ?>
<?php $kt_driver_task_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($kt_driver_task_list->SearchOptions->visible()) { ?>
<?php $kt_driver_task_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($kt_driver_task_list->FilterOptions->visible()) { ?>
<?php $kt_driver_task_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$kt_driver_task_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$kt_driver_task_list->isExport() && !$kt_driver_task->CurrentAction) { ?>
<form name="fkt_driver_tasklistsrch" id="fkt_driver_tasklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fkt_driver_tasklistsrch-search-panel" class="<?php echo $kt_driver_task_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="kt_driver_task">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $kt_driver_task_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($kt_driver_task_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($kt_driver_task_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $kt_driver_task_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($kt_driver_task_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($kt_driver_task_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($kt_driver_task_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($kt_driver_task_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $kt_driver_task_list->showPageHeader(); ?>
<?php
$kt_driver_task_list->showMessage();
?>
<?php if ($kt_driver_task_list->TotalRecords > 0 || $kt_driver_task->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($kt_driver_task_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> kt_driver_task">
<form name="fkt_driver_tasklist" id="fkt_driver_tasklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kt_driver_task">
<div id="gmp_kt_driver_task" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($kt_driver_task_list->TotalRecords > 0 || $kt_driver_task_list->isGridEdit()) { ?>
<table id="tbl_kt_driver_tasklist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$kt_driver_task->RowType = ROWTYPE_HEADER;

// Render list options
$kt_driver_task_list->renderListOptions();

// Render list options (header, left)
$kt_driver_task_list->ListOptions->render("header", "left");
?>
<?php if ($kt_driver_task_list->task_id->Visible) { // task_id ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->task_id) == "") { ?>
		<th data-name="task_id" class="<?php echo $kt_driver_task_list->task_id->headerCellClass() ?>"><div id="elh_kt_driver_task_task_id" class="kt_driver_task_task_id"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_id" class="<?php echo $kt_driver_task_list->task_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->task_id) ?>', 1);"><div id="elh_kt_driver_task_task_id" class="kt_driver_task_task_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->task_id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->task_id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->task_description->Visible) { // task_description ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->task_description) == "") { ?>
		<th data-name="task_description" class="<?php echo $kt_driver_task_list->task_description->headerCellClass() ?>"><div id="elh_kt_driver_task_task_description" class="kt_driver_task_task_description"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_description" class="<?php echo $kt_driver_task_list->task_description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->task_description) ?>', 1);"><div id="elh_kt_driver_task_task_description" class="kt_driver_task_task_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->task_description->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->task_description->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->trans_type->Visible) { // trans_type ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->trans_type) == "") { ?>
		<th data-name="trans_type" class="<?php echo $kt_driver_task_list->trans_type->headerCellClass() ?>"><div id="elh_kt_driver_task_trans_type" class="kt_driver_task_trans_type"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->trans_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trans_type" class="<?php echo $kt_driver_task_list->trans_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->trans_type) ?>', 1);"><div id="elh_kt_driver_task_trans_type" class="kt_driver_task_trans_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->trans_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->trans_type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->trans_type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->contact_number->Visible) { // contact_number ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->contact_number) == "") { ?>
		<th data-name="contact_number" class="<?php echo $kt_driver_task_list->contact_number->headerCellClass() ?>"><div id="elh_kt_driver_task_contact_number" class="kt_driver_task_contact_number"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->contact_number->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contact_number" class="<?php echo $kt_driver_task_list->contact_number->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->contact_number) ?>', 1);"><div id="elh_kt_driver_task_contact_number" class="kt_driver_task_contact_number">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->contact_number->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->contact_number->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->contact_number->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->email_address->Visible) { // email_address ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->email_address) == "") { ?>
		<th data-name="email_address" class="<?php echo $kt_driver_task_list->email_address->headerCellClass() ?>"><div id="elh_kt_driver_task_email_address" class="kt_driver_task_email_address"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->email_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="email_address" class="<?php echo $kt_driver_task_list->email_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->email_address) ?>', 1);"><div id="elh_kt_driver_task_email_address" class="kt_driver_task_email_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->email_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->email_address->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->email_address->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->customer_name->Visible) { // customer_name ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->customer_name) == "") { ?>
		<th data-name="customer_name" class="<?php echo $kt_driver_task_list->customer_name->headerCellClass() ?>"><div id="elh_kt_driver_task_customer_name" class="kt_driver_task_customer_name"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="customer_name" class="<?php echo $kt_driver_task_list->customer_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->customer_name) ?>', 1);"><div id="elh_kt_driver_task_customer_name" class="kt_driver_task_customer_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->customer_name->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->customer_name->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->delivery_date->Visible) { // delivery_date ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->delivery_date) == "") { ?>
		<th data-name="delivery_date" class="<?php echo $kt_driver_task_list->delivery_date->headerCellClass() ?>"><div id="elh_kt_driver_task_delivery_date" class="kt_driver_task_delivery_date"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->delivery_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_date" class="<?php echo $kt_driver_task_list->delivery_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->delivery_date) ?>', 1);"><div id="elh_kt_driver_task_delivery_date" class="kt_driver_task_delivery_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->delivery_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->delivery_date->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->delivery_date->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->team_id->Visible) { // team_id ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->team_id) == "") { ?>
		<th data-name="team_id" class="<?php echo $kt_driver_task_list->team_id->headerCellClass() ?>"><div id="elh_kt_driver_task_team_id" class="kt_driver_task_team_id"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->team_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="team_id" class="<?php echo $kt_driver_task_list->team_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->team_id) ?>', 1);"><div id="elh_kt_driver_task_team_id" class="kt_driver_task_team_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->team_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->team_id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->team_id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->driver_id->Visible) { // driver_id ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->driver_id) == "") { ?>
		<th data-name="driver_id" class="<?php echo $kt_driver_task_list->driver_id->headerCellClass() ?>"><div id="elh_kt_driver_task_driver_id" class="kt_driver_task_driver_id"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->driver_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver_id" class="<?php echo $kt_driver_task_list->driver_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->driver_id) ?>', 1);"><div id="elh_kt_driver_task_driver_id" class="kt_driver_task_driver_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->driver_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->driver_id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->driver_id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->task_lat->Visible) { // task_lat ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->task_lat) == "") { ?>
		<th data-name="task_lat" class="<?php echo $kt_driver_task_list->task_lat->headerCellClass() ?>"><div id="elh_kt_driver_task_task_lat" class="kt_driver_task_task_lat"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_lat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_lat" class="<?php echo $kt_driver_task_list->task_lat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->task_lat) ?>', 1);"><div id="elh_kt_driver_task_task_lat" class="kt_driver_task_task_lat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_lat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->task_lat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->task_lat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->task_lng->Visible) { // task_lng ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->task_lng) == "") { ?>
		<th data-name="task_lng" class="<?php echo $kt_driver_task_list->task_lng->headerCellClass() ?>"><div id="elh_kt_driver_task_task_lng" class="kt_driver_task_task_lng"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_lng->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_lng" class="<?php echo $kt_driver_task_list->task_lng->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->task_lng) ?>', 1);"><div id="elh_kt_driver_task_task_lng" class="kt_driver_task_task_lng">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_lng->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->task_lng->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->task_lng->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->customer_signature->Visible) { // customer_signature ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->customer_signature) == "") { ?>
		<th data-name="customer_signature" class="<?php echo $kt_driver_task_list->customer_signature->headerCellClass() ?>"><div id="elh_kt_driver_task_customer_signature" class="kt_driver_task_customer_signature"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_signature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="customer_signature" class="<?php echo $kt_driver_task_list->customer_signature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->customer_signature) ?>', 1);"><div id="elh_kt_driver_task_customer_signature" class="kt_driver_task_customer_signature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_signature->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->customer_signature->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->customer_signature->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->date_created->Visible) { // date_created ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->date_created) == "") { ?>
		<th data-name="date_created" class="<?php echo $kt_driver_task_list->date_created->headerCellClass() ?>"><div id="elh_kt_driver_task_date_created" class="kt_driver_task_date_created"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->date_created->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_created" class="<?php echo $kt_driver_task_list->date_created->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->date_created) ?>', 1);"><div id="elh_kt_driver_task_date_created" class="kt_driver_task_date_created">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->date_created->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->date_created->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->date_created->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->date_modified->Visible) { // date_modified ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->date_modified) == "") { ?>
		<th data-name="date_modified" class="<?php echo $kt_driver_task_list->date_modified->headerCellClass() ?>"><div id="elh_kt_driver_task_date_modified" class="kt_driver_task_date_modified"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->date_modified->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_modified" class="<?php echo $kt_driver_task_list->date_modified->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->date_modified) ?>', 1);"><div id="elh_kt_driver_task_date_modified" class="kt_driver_task_date_modified">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->date_modified->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->date_modified->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->date_modified->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->ip_address->Visible) { // ip_address ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->ip_address) == "") { ?>
		<th data-name="ip_address" class="<?php echo $kt_driver_task_list->ip_address->headerCellClass() ?>"><div id="elh_kt_driver_task_ip_address" class="kt_driver_task_ip_address"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->ip_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ip_address" class="<?php echo $kt_driver_task_list->ip_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->ip_address) ?>', 1);"><div id="elh_kt_driver_task_ip_address" class="kt_driver_task_ip_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->ip_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->ip_address->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->ip_address->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->auto_assign_type->Visible) { // auto_assign_type ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->auto_assign_type) == "") { ?>
		<th data-name="auto_assign_type" class="<?php echo $kt_driver_task_list->auto_assign_type->headerCellClass() ?>"><div id="elh_kt_driver_task_auto_assign_type" class="kt_driver_task_auto_assign_type"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->auto_assign_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="auto_assign_type" class="<?php echo $kt_driver_task_list->auto_assign_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->auto_assign_type) ?>', 1);"><div id="elh_kt_driver_task_auto_assign_type" class="kt_driver_task_auto_assign_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->auto_assign_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->auto_assign_type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->auto_assign_type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->assign_started->Visible) { // assign_started ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->assign_started) == "") { ?>
		<th data-name="assign_started" class="<?php echo $kt_driver_task_list->assign_started->headerCellClass() ?>"><div id="elh_kt_driver_task_assign_started" class="kt_driver_task_assign_started"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->assign_started->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="assign_started" class="<?php echo $kt_driver_task_list->assign_started->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->assign_started) ?>', 1);"><div id="elh_kt_driver_task_assign_started" class="kt_driver_task_assign_started">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->assign_started->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->assign_started->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->assign_started->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->assignment_status->Visible) { // assignment_status ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->assignment_status) == "") { ?>
		<th data-name="assignment_status" class="<?php echo $kt_driver_task_list->assignment_status->headerCellClass() ?>"><div id="elh_kt_driver_task_assignment_status" class="kt_driver_task_assignment_status"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignment_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="assignment_status" class="<?php echo $kt_driver_task_list->assignment_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->assignment_status) ?>', 1);"><div id="elh_kt_driver_task_assignment_status" class="kt_driver_task_assignment_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignment_status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->assignment_status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->assignment_status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->dropoff_contact_name->Visible) { // dropoff_contact_name ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_contact_name) == "") { ?>
		<th data-name="dropoff_contact_name" class="<?php echo $kt_driver_task_list->dropoff_contact_name->headerCellClass() ?>"><div id="elh_kt_driver_task_dropoff_contact_name" class="kt_driver_task_dropoff_contact_name"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_contact_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dropoff_contact_name" class="<?php echo $kt_driver_task_list->dropoff_contact_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_contact_name) ?>', 1);"><div id="elh_kt_driver_task_dropoff_contact_name" class="kt_driver_task_dropoff_contact_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_contact_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->dropoff_contact_name->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->dropoff_contact_name->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->dropoff_contact_number->Visible) { // dropoff_contact_number ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_contact_number) == "") { ?>
		<th data-name="dropoff_contact_number" class="<?php echo $kt_driver_task_list->dropoff_contact_number->headerCellClass() ?>"><div id="elh_kt_driver_task_dropoff_contact_number" class="kt_driver_task_dropoff_contact_number"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_contact_number->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dropoff_contact_number" class="<?php echo $kt_driver_task_list->dropoff_contact_number->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_contact_number) ?>', 1);"><div id="elh_kt_driver_task_dropoff_contact_number" class="kt_driver_task_dropoff_contact_number">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_contact_number->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->dropoff_contact_number->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->dropoff_contact_number->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->drop_address->Visible) { // drop_address ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->drop_address) == "") { ?>
		<th data-name="drop_address" class="<?php echo $kt_driver_task_list->drop_address->headerCellClass() ?>"><div id="elh_kt_driver_task_drop_address" class="kt_driver_task_drop_address"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->drop_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="drop_address" class="<?php echo $kt_driver_task_list->drop_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->drop_address) ?>', 1);"><div id="elh_kt_driver_task_drop_address" class="kt_driver_task_drop_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->drop_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->drop_address->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->drop_address->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->dropoff_task_lat->Visible) { // dropoff_task_lat ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_task_lat) == "") { ?>
		<th data-name="dropoff_task_lat" class="<?php echo $kt_driver_task_list->dropoff_task_lat->headerCellClass() ?>"><div id="elh_kt_driver_task_dropoff_task_lat" class="kt_driver_task_dropoff_task_lat"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_task_lat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dropoff_task_lat" class="<?php echo $kt_driver_task_list->dropoff_task_lat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_task_lat) ?>', 1);"><div id="elh_kt_driver_task_dropoff_task_lat" class="kt_driver_task_dropoff_task_lat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_task_lat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->dropoff_task_lat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->dropoff_task_lat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->dropoff_task_lng->Visible) { // dropoff_task_lng ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_task_lng) == "") { ?>
		<th data-name="dropoff_task_lng" class="<?php echo $kt_driver_task_list->dropoff_task_lng->headerCellClass() ?>"><div id="elh_kt_driver_task_dropoff_task_lng" class="kt_driver_task_dropoff_task_lng"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_task_lng->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dropoff_task_lng" class="<?php echo $kt_driver_task_list->dropoff_task_lng->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->dropoff_task_lng) ?>', 1);"><div id="elh_kt_driver_task_dropoff_task_lng" class="kt_driver_task_dropoff_task_lng">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->dropoff_task_lng->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->dropoff_task_lng->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->dropoff_task_lng->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->task_token->Visible) { // task_token ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->task_token) == "") { ?>
		<th data-name="task_token" class="<?php echo $kt_driver_task_list->task_token->headerCellClass() ?>"><div id="elh_kt_driver_task_task_token" class="kt_driver_task_task_token"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_token->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="task_token" class="<?php echo $kt_driver_task_list->task_token->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->task_token) ?>', 1);"><div id="elh_kt_driver_task_task_token" class="kt_driver_task_task_token">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->task_token->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->task_token->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->task_token->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->ratings->Visible) { // ratings ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->ratings) == "") { ?>
		<th data-name="ratings" class="<?php echo $kt_driver_task_list->ratings->headerCellClass() ?>"><div id="elh_kt_driver_task_ratings" class="kt_driver_task_ratings"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->ratings->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ratings" class="<?php echo $kt_driver_task_list->ratings->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->ratings) ?>', 1);"><div id="elh_kt_driver_task_ratings" class="kt_driver_task_ratings">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->ratings->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->ratings->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->ratings->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->rating_comment->Visible) { // rating_comment ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->rating_comment) == "") { ?>
		<th data-name="rating_comment" class="<?php echo $kt_driver_task_list->rating_comment->headerCellClass() ?>"><div id="elh_kt_driver_task_rating_comment" class="kt_driver_task_rating_comment"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->rating_comment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rating_comment" class="<?php echo $kt_driver_task_list->rating_comment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->rating_comment) ?>', 1);"><div id="elh_kt_driver_task_rating_comment" class="kt_driver_task_rating_comment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->rating_comment->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->rating_comment->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->rating_comment->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->critical->Visible) { // critical ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->critical) == "") { ?>
		<th data-name="critical" class="<?php echo $kt_driver_task_list->critical->headerCellClass() ?>"><div id="elh_kt_driver_task_critical" class="kt_driver_task_critical"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->critical->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="critical" class="<?php echo $kt_driver_task_list->critical->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->critical) ?>', 1);"><div id="elh_kt_driver_task_critical" class="kt_driver_task_critical">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->critical->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->critical->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->critical->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->souce_e->Visible) { // souce_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->souce_e) == "") { ?>
		<th data-name="souce_e" class="<?php echo $kt_driver_task_list->souce_e->headerCellClass() ?>"><div id="elh_kt_driver_task_souce_e" class="kt_driver_task_souce_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->souce_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="souce_e" class="<?php echo $kt_driver_task_list->souce_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->souce_e) ?>', 1);"><div id="elh_kt_driver_task_souce_e" class="kt_driver_task_souce_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->souce_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->souce_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->souce_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->shop_code_e->Visible) { // shop_code_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->shop_code_e) == "") { ?>
		<th data-name="shop_code_e" class="<?php echo $kt_driver_task_list->shop_code_e->headerCellClass() ?>"><div id="elh_kt_driver_task_shop_code_e" class="kt_driver_task_shop_code_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->shop_code_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shop_code_e" class="<?php echo $kt_driver_task_list->shop_code_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->shop_code_e) ?>', 1);"><div id="elh_kt_driver_task_shop_code_e" class="kt_driver_task_shop_code_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->shop_code_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->shop_code_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->shop_code_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Received_Channel_e->Visible) { // Received_Channel_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Received_Channel_e) == "") { ?>
		<th data-name="Received_Channel_e" class="<?php echo $kt_driver_task_list->Received_Channel_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Received_Channel_e" class="kt_driver_task_Received_Channel_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Received_Channel_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Received_Channel_e" class="<?php echo $kt_driver_task_list->Received_Channel_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Received_Channel_e) ?>', 1);"><div id="elh_kt_driver_task_Received_Channel_e" class="kt_driver_task_Received_Channel_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Received_Channel_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Received_Channel_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Received_Channel_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->PayMethod_e->Visible) { // PayMethod_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->PayMethod_e) == "") { ?>
		<th data-name="PayMethod_e" class="<?php echo $kt_driver_task_list->PayMethod_e->headerCellClass() ?>"><div id="elh_kt_driver_task_PayMethod_e" class="kt_driver_task_PayMethod_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->PayMethod_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PayMethod_e" class="<?php echo $kt_driver_task_list->PayMethod_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->PayMethod_e) ?>', 1);"><div id="elh_kt_driver_task_PayMethod_e" class="kt_driver_task_PayMethod_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->PayMethod_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->PayMethod_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->PayMethod_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Type_e->Visible) { // Type_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Type_e) == "") { ?>
		<th data-name="Type_e" class="<?php echo $kt_driver_task_list->Type_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Type_e" class="kt_driver_task_Type_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Type_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Type_e" class="<?php echo $kt_driver_task_list->Type_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Type_e) ?>', 1);"><div id="elh_kt_driver_task_Type_e" class="kt_driver_task_Type_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Type_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Type_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Type_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Request_Code_e->Visible) { // Request_Code_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Request_Code_e) == "") { ?>
		<th data-name="Request_Code_e" class="<?php echo $kt_driver_task_list->Request_Code_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Request_Code_e" class="kt_driver_task_Request_Code_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Request_Code_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Request_Code_e" class="<?php echo $kt_driver_task_list->Request_Code_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Request_Code_e) ?>', 1);"><div id="elh_kt_driver_task_Request_Code_e" class="kt_driver_task_Request_Code_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Request_Code_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Request_Code_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Request_Code_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Status_e->Visible) { // Status_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Status_e) == "") { ?>
		<th data-name="Status_e" class="<?php echo $kt_driver_task_list->Status_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Status_e" class="kt_driver_task_Status_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_e" class="<?php echo $kt_driver_task_list->Status_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Status_e) ?>', 1);"><div id="elh_kt_driver_task_Status_e" class="kt_driver_task_Status_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Status_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Status_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->PlanType_e->Visible) { // PlanType_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->PlanType_e) == "") { ?>
		<th data-name="PlanType_e" class="<?php echo $kt_driver_task_list->PlanType_e->headerCellClass() ?>"><div id="elh_kt_driver_task_PlanType_e" class="kt_driver_task_PlanType_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->PlanType_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PlanType_e" class="<?php echo $kt_driver_task_list->PlanType_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->PlanType_e) ?>', 1);"><div id="elh_kt_driver_task_PlanType_e" class="kt_driver_task_PlanType_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->PlanType_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->PlanType_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->PlanType_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Plan_e->Visible) { // Plan_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Plan_e) == "") { ?>
		<th data-name="Plan_e" class="<?php echo $kt_driver_task_list->Plan_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Plan_e" class="kt_driver_task_Plan_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Plan_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Plan_e" class="<?php echo $kt_driver_task_list->Plan_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Plan_e) ?>', 1);"><div id="elh_kt_driver_task_Plan_e" class="kt_driver_task_Plan_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Plan_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Plan_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Plan_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Isdn_e->Visible) { // Isdn_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Isdn_e) == "") { ?>
		<th data-name="Isdn_e" class="<?php echo $kt_driver_task_list->Isdn_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Isdn_e" class="kt_driver_task_Isdn_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Isdn_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Isdn_e" class="<?php echo $kt_driver_task_list->Isdn_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Isdn_e) ?>', 1);"><div id="elh_kt_driver_task_Isdn_e" class="kt_driver_task_Isdn_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Isdn_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Isdn_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Isdn_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->serial_sim_handset_e->Visible) { // serial_sim_handset_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->serial_sim_handset_e) == "") { ?>
		<th data-name="serial_sim_handset_e" class="<?php echo $kt_driver_task_list->serial_sim_handset_e->headerCellClass() ?>"><div id="elh_kt_driver_task_serial_sim_handset_e" class="kt_driver_task_serial_sim_handset_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->serial_sim_handset_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="serial_sim_handset_e" class="<?php echo $kt_driver_task_list->serial_sim_handset_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->serial_sim_handset_e) ?>', 1);"><div id="elh_kt_driver_task_serial_sim_handset_e" class="kt_driver_task_serial_sim_handset_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->serial_sim_handset_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->serial_sim_handset_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->serial_sim_handset_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->handset_e->Visible) { // handset_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->handset_e) == "") { ?>
		<th data-name="handset_e" class="<?php echo $kt_driver_task_list->handset_e->headerCellClass() ?>"><div id="elh_kt_driver_task_handset_e" class="kt_driver_task_handset_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->handset_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="handset_e" class="<?php echo $kt_driver_task_list->handset_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->handset_e) ?>', 1);"><div id="elh_kt_driver_task_handset_e" class="kt_driver_task_handset_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->handset_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->handset_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->handset_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Connect_Reason_e->Visible) { // Connect_Reason_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Connect_Reason_e) == "") { ?>
		<th data-name="Connect_Reason_e" class="<?php echo $kt_driver_task_list->Connect_Reason_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Connect_Reason_e" class="kt_driver_task_Connect_Reason_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Connect_Reason_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Connect_Reason_e" class="<?php echo $kt_driver_task_list->Connect_Reason_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Connect_Reason_e) ?>', 1);"><div id="elh_kt_driver_task_Connect_Reason_e" class="kt_driver_task_Connect_Reason_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Connect_Reason_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Connect_Reason_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Connect_Reason_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Price_e->Visible) { // Price_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Price_e) == "") { ?>
		<th data-name="Price_e" class="<?php echo $kt_driver_task_list->Price_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Price_e" class="kt_driver_task_Price_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Price_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Price_e" class="<?php echo $kt_driver_task_list->Price_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Price_e) ?>', 1);"><div id="elh_kt_driver_task_Price_e" class="kt_driver_task_Price_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Price_e->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Price_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Price_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Current_Operator_e->Visible) { // Current_Operator_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Current_Operator_e) == "") { ?>
		<th data-name="Current_Operator_e" class="<?php echo $kt_driver_task_list->Current_Operator_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Current_Operator_e" class="kt_driver_task_Current_Operator_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Current_Operator_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Current_Operator_e" class="<?php echo $kt_driver_task_list->Current_Operator_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Current_Operator_e) ?>', 1);"><div id="elh_kt_driver_task_Current_Operator_e" class="kt_driver_task_Current_Operator_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Current_Operator_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Current_Operator_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Current_Operator_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Current_Plan_Type_e->Visible) { // Current_Plan_Type_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Current_Plan_Type_e) == "") { ?>
		<th data-name="Current_Plan_Type_e" class="<?php echo $kt_driver_task_list->Current_Plan_Type_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Current_Plan_Type_e" class="kt_driver_task_Current_Plan_Type_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Current_Plan_Type_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Current_Plan_Type_e" class="<?php echo $kt_driver_task_list->Current_Plan_Type_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Current_Plan_Type_e) ?>', 1);"><div id="elh_kt_driver_task_Current_Plan_Type_e" class="kt_driver_task_Current_Plan_Type_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Current_Plan_Type_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Current_Plan_Type_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Current_Plan_Type_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Document_Number_e->Visible) { // Document_Number_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Document_Number_e) == "") { ?>
		<th data-name="Document_Number_e" class="<?php echo $kt_driver_task_list->Document_Number_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Document_Number_e" class="kt_driver_task_Document_Number_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Document_Number_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Document_Number_e" class="<?php echo $kt_driver_task_list->Document_Number_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Document_Number_e) ?>', 1);"><div id="elh_kt_driver_task_Document_Number_e" class="kt_driver_task_Document_Number_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Document_Number_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Document_Number_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Document_Number_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Document_Type_e->Visible) { // Document_Type_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Document_Type_e) == "") { ?>
		<th data-name="Document_Type_e" class="<?php echo $kt_driver_task_list->Document_Type_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Document_Type_e" class="kt_driver_task_Document_Type_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Document_Type_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Document_Type_e" class="<?php echo $kt_driver_task_list->Document_Type_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Document_Type_e) ?>', 1);"><div id="elh_kt_driver_task_Document_Type_e" class="kt_driver_task_Document_Type_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Document_Type_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Document_Type_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Document_Type_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->assignStaffCode_e->Visible) { // assignStaffCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->assignStaffCode_e) == "") { ?>
		<th data-name="assignStaffCode_e" class="<?php echo $kt_driver_task_list->assignStaffCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_assignStaffCode_e" class="kt_driver_task_assignStaffCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignStaffCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="assignStaffCode_e" class="<?php echo $kt_driver_task_list->assignStaffCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->assignStaffCode_e) ?>', 1);"><div id="elh_kt_driver_task_assignStaffCode_e" class="kt_driver_task_assignStaffCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignStaffCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->assignStaffCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->assignStaffCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Delivery_Type_e->Visible) { // Delivery_Type_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Type_e) == "") { ?>
		<th data-name="Delivery_Type_e" class="<?php echo $kt_driver_task_list->Delivery_Type_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Delivery_Type_e" class="kt_driver_task_Delivery_Type_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Type_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Delivery_Type_e" class="<?php echo $kt_driver_task_list->Delivery_Type_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Type_e) ?>', 1);"><div id="elh_kt_driver_task_Delivery_Type_e" class="kt_driver_task_Delivery_Type_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Type_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Delivery_Type_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Delivery_Type_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->assignStaffType_e->Visible) { // assignStaffType_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->assignStaffType_e) == "") { ?>
		<th data-name="assignStaffType_e" class="<?php echo $kt_driver_task_list->assignStaffType_e->headerCellClass() ?>"><div id="elh_kt_driver_task_assignStaffType_e" class="kt_driver_task_assignStaffType_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignStaffType_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="assignStaffType_e" class="<?php echo $kt_driver_task_list->assignStaffType_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->assignStaffType_e) ?>', 1);"><div id="elh_kt_driver_task_assignStaffType_e" class="kt_driver_task_assignStaffType_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->assignStaffType_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->assignStaffType_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->assignStaffType_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->receiveStaffCode_e->Visible) { // receiveStaffCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->receiveStaffCode_e) == "") { ?>
		<th data-name="receiveStaffCode_e" class="<?php echo $kt_driver_task_list->receiveStaffCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_receiveStaffCode_e" class="kt_driver_task_receiveStaffCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->receiveStaffCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiveStaffCode_e" class="<?php echo $kt_driver_task_list->receiveStaffCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->receiveStaffCode_e) ?>', 1);"><div id="elh_kt_driver_task_receiveStaffCode_e" class="kt_driver_task_receiveStaffCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->receiveStaffCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->receiveStaffCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->receiveStaffCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->receiveStaffType_e->Visible) { // receiveStaffType_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->receiveStaffType_e) == "") { ?>
		<th data-name="receiveStaffType_e" class="<?php echo $kt_driver_task_list->receiveStaffType_e->headerCellClass() ?>"><div id="elh_kt_driver_task_receiveStaffType_e" class="kt_driver_task_receiveStaffType_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->receiveStaffType_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiveStaffType_e" class="<?php echo $kt_driver_task_list->receiveStaffType_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->receiveStaffType_e) ?>', 1);"><div id="elh_kt_driver_task_receiveStaffType_e" class="kt_driver_task_receiveStaffType_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->receiveStaffType_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->receiveStaffType_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->receiveStaffType_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->connectStaffCode_e->Visible) { // connectStaffCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->connectStaffCode_e) == "") { ?>
		<th data-name="connectStaffCode_e" class="<?php echo $kt_driver_task_list->connectStaffCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_connectStaffCode_e" class="kt_driver_task_connectStaffCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->connectStaffCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="connectStaffCode_e" class="<?php echo $kt_driver_task_list->connectStaffCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->connectStaffCode_e) ?>', 1);"><div id="elh_kt_driver_task_connectStaffCode_e" class="kt_driver_task_connectStaffCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->connectStaffCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->connectStaffCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->connectStaffCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->connectStaffType_e->Visible) { // connectStaffType_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->connectStaffType_e) == "") { ?>
		<th data-name="connectStaffType_e" class="<?php echo $kt_driver_task_list->connectStaffType_e->headerCellClass() ?>"><div id="elh_kt_driver_task_connectStaffType_e" class="kt_driver_task_connectStaffType_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->connectStaffType_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="connectStaffType_e" class="<?php echo $kt_driver_task_list->connectStaffType_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->connectStaffType_e) ?>', 1);"><div id="elh_kt_driver_task_connectStaffType_e" class="kt_driver_task_connectStaffType_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->connectStaffType_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->connectStaffType_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->connectStaffType_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->shopName_e->Visible) { // shopName_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->shopName_e) == "") { ?>
		<th data-name="shopName_e" class="<?php echo $kt_driver_task_list->shopName_e->headerCellClass() ?>"><div id="elh_kt_driver_task_shopName_e" class="kt_driver_task_shopName_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->shopName_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shopName_e" class="<?php echo $kt_driver_task_list->shopName_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->shopName_e) ?>', 1);"><div id="elh_kt_driver_task_shopName_e" class="kt_driver_task_shopName_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->shopName_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->shopName_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->shopName_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->saleOrderCode_e->Visible) { // saleOrderCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderCode_e) == "") { ?>
		<th data-name="saleOrderCode_e" class="<?php echo $kt_driver_task_list->saleOrderCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_saleOrderCode_e" class="kt_driver_task_saleOrderCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="saleOrderCode_e" class="<?php echo $kt_driver_task_list->saleOrderCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderCode_e) ?>', 1);"><div id="elh_kt_driver_task_saleOrderCode_e" class="kt_driver_task_saleOrderCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->saleOrderCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->saleOrderCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->consultantCode_e->Visible) { // consultantCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->consultantCode_e) == "") { ?>
		<th data-name="consultantCode_e" class="<?php echo $kt_driver_task_list->consultantCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_consultantCode_e" class="kt_driver_task_consultantCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consultantCode_e" class="<?php echo $kt_driver_task_list->consultantCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->consultantCode_e) ?>', 1);"><div id="elh_kt_driver_task_consultantCode_e" class="kt_driver_task_consultantCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->consultantCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->consultantCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->consultantName_e->Visible) { // consultantName_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->consultantName_e) == "") { ?>
		<th data-name="consultantName_e" class="<?php echo $kt_driver_task_list->consultantName_e->headerCellClass() ?>"><div id="elh_kt_driver_task_consultantName_e" class="kt_driver_task_consultantName_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantName_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consultantName_e" class="<?php echo $kt_driver_task_list->consultantName_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->consultantName_e) ?>', 1);"><div id="elh_kt_driver_task_consultantName_e" class="kt_driver_task_consultantName_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantName_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->consultantName_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->consultantName_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->consultantType_e->Visible) { // consultantType_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->consultantType_e) == "") { ?>
		<th data-name="consultantType_e" class="<?php echo $kt_driver_task_list->consultantType_e->headerCellClass() ?>"><div id="elh_kt_driver_task_consultantType_e" class="kt_driver_task_consultantType_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantType_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consultantType_e" class="<?php echo $kt_driver_task_list->consultantType_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->consultantType_e) ?>', 1);"><div id="elh_kt_driver_task_consultantType_e" class="kt_driver_task_consultantType_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->consultantType_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->consultantType_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->consultantType_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->created_By_e->Visible) { // created_By_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->created_By_e) == "") { ?>
		<th data-name="created_By_e" class="<?php echo $kt_driver_task_list->created_By_e->headerCellClass() ?>"><div id="elh_kt_driver_task_created_By_e" class="kt_driver_task_created_By_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->created_By_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="created_By_e" class="<?php echo $kt_driver_task_list->created_By_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->created_By_e) ?>', 1);"><div id="elh_kt_driver_task_created_By_e" class="kt_driver_task_created_By_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->created_By_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->created_By_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->created_By_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->createdBranch_e->Visible) { // createdBranch_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->createdBranch_e) == "") { ?>
		<th data-name="createdBranch_e" class="<?php echo $kt_driver_task_list->createdBranch_e->headerCellClass() ?>"><div id="elh_kt_driver_task_createdBranch_e" class="kt_driver_task_createdBranch_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->createdBranch_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="createdBranch_e" class="<?php echo $kt_driver_task_list->createdBranch_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->createdBranch_e) ?>', 1);"><div id="elh_kt_driver_task_createdBranch_e" class="kt_driver_task_createdBranch_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->createdBranch_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->createdBranch_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->createdBranch_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->generated_Code_By_e->Visible) { // generated_Code_By_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->generated_Code_By_e) == "") { ?>
		<th data-name="generated_Code_By_e" class="<?php echo $kt_driver_task_list->generated_Code_By_e->headerCellClass() ?>"><div id="elh_kt_driver_task_generated_Code_By_e" class="kt_driver_task_generated_Code_By_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->generated_Code_By_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="generated_Code_By_e" class="<?php echo $kt_driver_task_list->generated_Code_By_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->generated_Code_By_e) ?>', 1);"><div id="elh_kt_driver_task_generated_Code_By_e" class="kt_driver_task_generated_Code_By_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->generated_Code_By_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->generated_Code_By_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->generated_Code_By_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->approve_Paid_By_e->Visible) { // approve_Paid_By_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->approve_Paid_By_e) == "") { ?>
		<th data-name="approve_Paid_By_e" class="<?php echo $kt_driver_task_list->approve_Paid_By_e->headerCellClass() ?>"><div id="elh_kt_driver_task_approve_Paid_By_e" class="kt_driver_task_approve_Paid_By_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->approve_Paid_By_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="approve_Paid_By_e" class="<?php echo $kt_driver_task_list->approve_Paid_By_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->approve_Paid_By_e) ?>', 1);"><div id="elh_kt_driver_task_approve_Paid_By_e" class="kt_driver_task_approve_Paid_By_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->approve_Paid_By_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->approve_Paid_By_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->approve_Paid_By_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Delivery_Note_e->Visible) { // Delivery_Note_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Note_e) == "") { ?>
		<th data-name="Delivery_Note_e" class="<?php echo $kt_driver_task_list->Delivery_Note_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Delivery_Note_e" class="kt_driver_task_Delivery_Note_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Note_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Delivery_Note_e" class="<?php echo $kt_driver_task_list->Delivery_Note_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Note_e) ?>', 1);"><div id="elh_kt_driver_task_Delivery_Note_e" class="kt_driver_task_Delivery_Note_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Note_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Delivery_Note_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Delivery_Note_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Delivery_Code_e->Visible) { // Delivery_Code_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Code_e) == "") { ?>
		<th data-name="Delivery_Code_e" class="<?php echo $kt_driver_task_list->Delivery_Code_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Delivery_Code_e" class="kt_driver_task_Delivery_Code_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Code_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Delivery_Code_e" class="<?php echo $kt_driver_task_list->Delivery_Code_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Delivery_Code_e) ?>', 1);"><div id="elh_kt_driver_task_Delivery_Code_e" class="kt_driver_task_Delivery_Code_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Delivery_Code_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Delivery_Code_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Delivery_Code_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Customer_Note_e->Visible) { // Customer_Note_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Customer_Note_e) == "") { ?>
		<th data-name="Customer_Note_e" class="<?php echo $kt_driver_task_list->Customer_Note_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Customer_Note_e" class="kt_driver_task_Customer_Note_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Customer_Note_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Customer_Note_e" class="<?php echo $kt_driver_task_list->Customer_Note_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Customer_Note_e) ?>', 1);"><div id="elh_kt_driver_task_Customer_Note_e" class="kt_driver_task_Customer_Note_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Customer_Note_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Customer_Note_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Customer_Note_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->saleOrderCreateDate_e->Visible) { // saleOrderCreateDate_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderCreateDate_e) == "") { ?>
		<th data-name="saleOrderCreateDate_e" class="<?php echo $kt_driver_task_list->saleOrderCreateDate_e->headerCellClass() ?>"><div id="elh_kt_driver_task_saleOrderCreateDate_e" class="kt_driver_task_saleOrderCreateDate_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderCreateDate_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="saleOrderCreateDate_e" class="<?php echo $kt_driver_task_list->saleOrderCreateDate_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderCreateDate_e) ?>', 1);"><div id="elh_kt_driver_task_saleOrderCreateDate_e" class="kt_driver_task_saleOrderCreateDate_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderCreateDate_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->saleOrderCreateDate_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->saleOrderCreateDate_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->saleOrderPayDate_e->Visible) { // saleOrderPayDate_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderPayDate_e) == "") { ?>
		<th data-name="saleOrderPayDate_e" class="<?php echo $kt_driver_task_list->saleOrderPayDate_e->headerCellClass() ?>"><div id="elh_kt_driver_task_saleOrderPayDate_e" class="kt_driver_task_saleOrderPayDate_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderPayDate_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="saleOrderPayDate_e" class="<?php echo $kt_driver_task_list->saleOrderPayDate_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->saleOrderPayDate_e) ?>', 1);"><div id="elh_kt_driver_task_saleOrderPayDate_e" class="kt_driver_task_saleOrderPayDate_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->saleOrderPayDate_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->saleOrderPayDate_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->saleOrderPayDate_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Time_of_Procesing_e->Visible) { // Time_of_Procesing_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_Procesing_e) == "") { ?>
		<th data-name="Time_of_Procesing_e" class="<?php echo $kt_driver_task_list->Time_of_Procesing_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Time_of_Procesing_e" class="kt_driver_task_Time_of_Procesing_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_Procesing_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Time_of_Procesing_e" class="<?php echo $kt_driver_task_list->Time_of_Procesing_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_Procesing_e) ?>', 1);"><div id="elh_kt_driver_task_Time_of_Procesing_e" class="kt_driver_task_Time_of_Procesing_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_Procesing_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Time_of_Procesing_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Time_of_Procesing_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Time_of_new_e->Visible) { // Time_of_new_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_new_e) == "") { ?>
		<th data-name="Time_of_new_e" class="<?php echo $kt_driver_task_list->Time_of_new_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Time_of_new_e" class="kt_driver_task_Time_of_new_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_new_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Time_of_new_e" class="<?php echo $kt_driver_task_list->Time_of_new_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_new_e) ?>', 1);"><div id="elh_kt_driver_task_Time_of_new_e" class="kt_driver_task_Time_of_new_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_new_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Time_of_new_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Time_of_new_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Time_of_Finished_e->Visible) { // Time_of_Finished_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_Finished_e) == "") { ?>
		<th data-name="Time_of_Finished_e" class="<?php echo $kt_driver_task_list->Time_of_Finished_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Time_of_Finished_e" class="kt_driver_task_Time_of_Finished_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_Finished_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Time_of_Finished_e" class="<?php echo $kt_driver_task_list->Time_of_Finished_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Time_of_Finished_e) ?>', 1);"><div id="elh_kt_driver_task_Time_of_Finished_e" class="kt_driver_task_Time_of_Finished_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Time_of_Finished_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Time_of_Finished_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Time_of_Finished_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->KPI_CC_Hour_e->Visible) { // KPI_CC_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_CC_Hour_e) == "") { ?>
		<th data-name="KPI_CC_Hour_e" class="<?php echo $kt_driver_task_list->KPI_CC_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_KPI_CC_Hour_e" class="kt_driver_task_KPI_CC_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_CC_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KPI_CC_Hour_e" class="<?php echo $kt_driver_task_list->KPI_CC_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_CC_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_KPI_CC_Hour_e" class="kt_driver_task_KPI_CC_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_CC_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->KPI_CC_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->KPI_CC_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->KPI_NEW_Hour_e->Visible) { // KPI_NEW_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_NEW_Hour_e) == "") { ?>
		<th data-name="KPI_NEW_Hour_e" class="<?php echo $kt_driver_task_list->KPI_NEW_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_KPI_NEW_Hour_e" class="kt_driver_task_KPI_NEW_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_NEW_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KPI_NEW_Hour_e" class="<?php echo $kt_driver_task_list->KPI_NEW_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_NEW_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_KPI_NEW_Hour_e" class="kt_driver_task_KPI_NEW_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_NEW_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->KPI_NEW_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->KPI_NEW_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->KPI_PROCESING_Hour_e->Visible) { // KPI_PROCESING_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_PROCESING_Hour_e) == "") { ?>
		<th data-name="KPI_PROCESING_Hour_e" class="<?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_KPI_PROCESING_Hour_e" class="kt_driver_task_KPI_PROCESING_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KPI_PROCESING_Hour_e" class="<?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_PROCESING_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_KPI_PROCESING_Hour_e" class="kt_driver_task_KPI_PROCESING_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->KPI_PROCESING_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->KPI_PROCESING_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->KPI_ALL_Hour_e->Visible) { // KPI_ALL_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_ALL_Hour_e) == "") { ?>
		<th data-name="KPI_ALL_Hour_e" class="<?php echo $kt_driver_task_list->KPI_ALL_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_KPI_ALL_Hour_e" class="kt_driver_task_KPI_ALL_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_ALL_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KPI_ALL_Hour_e" class="<?php echo $kt_driver_task_list->KPI_ALL_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->KPI_ALL_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_KPI_ALL_Hour_e" class="kt_driver_task_KPI_ALL_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->KPI_ALL_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->KPI_ALL_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->KPI_ALL_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Kpi_Register_Hour_e->Visible) { // Kpi_Register_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Kpi_Register_Hour_e) == "") { ?>
		<th data-name="Kpi_Register_Hour_e" class="<?php echo $kt_driver_task_list->Kpi_Register_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Kpi_Register_Hour_e" class="kt_driver_task_Kpi_Register_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Kpi_Register_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kpi_Register_Hour_e" class="<?php echo $kt_driver_task_list->Kpi_Register_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Kpi_Register_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_Kpi_Register_Hour_e" class="kt_driver_task_Kpi_Register_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Kpi_Register_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Kpi_Register_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Kpi_Register_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Kpi_Bitel_Hour_e->Visible) { // Kpi_Bitel_Hour_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Kpi_Bitel_Hour_e) == "") { ?>
		<th data-name="Kpi_Bitel_Hour_e" class="<?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Kpi_Bitel_Hour_e" class="kt_driver_task_Kpi_Bitel_Hour_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kpi_Bitel_Hour_e" class="<?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Kpi_Bitel_Hour_e) ?>', 1);"><div id="elh_kt_driver_task_Kpi_Bitel_Hour_e" class="kt_driver_task_Kpi_Bitel_Hour_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Kpi_Bitel_Hour_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Kpi_Bitel_Hour_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->AmountGB_e->Visible) { // AmountGB_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->AmountGB_e) == "") { ?>
		<th data-name="AmountGB_e" class="<?php echo $kt_driver_task_list->AmountGB_e->headerCellClass() ?>"><div id="elh_kt_driver_task_AmountGB_e" class="kt_driver_task_AmountGB_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->AmountGB_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AmountGB_e" class="<?php echo $kt_driver_task_list->AmountGB_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->AmountGB_e) ?>', 1);"><div id="elh_kt_driver_task_AmountGB_e" class="kt_driver_task_AmountGB_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->AmountGB_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->AmountGB_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->AmountGB_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Price_1_e->Visible) { // Price_1_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Price_1_e) == "") { ?>
		<th data-name="Price_1_e" class="<?php echo $kt_driver_task_list->Price_1_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Price_1_e" class="kt_driver_task_Price_1_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Price_1_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Price_1_e" class="<?php echo $kt_driver_task_list->Price_1_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Price_1_e) ?>', 1);"><div id="elh_kt_driver_task_Price_1_e" class="kt_driver_task_Price_1_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Price_1_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Price_1_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Price_1_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Status_1_e->Visible) { // Status_1_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Status_1_e) == "") { ?>
		<th data-name="Status_1_e" class="<?php echo $kt_driver_task_list->Status_1_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Status_1_e" class="kt_driver_task_Status_1_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_1_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_1_e" class="<?php echo $kt_driver_task_list->Status_1_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Status_1_e) ?>', 1);"><div id="elh_kt_driver_task_Status_1_e" class="kt_driver_task_Status_1_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_1_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Status_1_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Status_1_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Registered_Date_e->Visible) { // Registered_Date_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Registered_Date_e) == "") { ?>
		<th data-name="Registered_Date_e" class="<?php echo $kt_driver_task_list->Registered_Date_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Registered_Date_e" class="kt_driver_task_Registered_Date_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Registered_Date_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Registered_Date_e" class="<?php echo $kt_driver_task_list->Registered_Date_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Registered_Date_e) ?>', 1);"><div id="elh_kt_driver_task_Registered_Date_e" class="kt_driver_task_Registered_Date_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Registered_Date_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Registered_Date_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Registered_Date_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Sumary_e->Visible) { // Sumary_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Sumary_e) == "") { ?>
		<th data-name="Sumary_e" class="<?php echo $kt_driver_task_list->Sumary_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Sumary_e" class="kt_driver_task_Sumary_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Sumary_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Sumary_e" class="<?php echo $kt_driver_task_list->Sumary_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Sumary_e) ?>', 1);"><div id="elh_kt_driver_task_Sumary_e" class="kt_driver_task_Sumary_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Sumary_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Sumary_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Sumary_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Plans_e->Visible) { // Plans_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Plans_e) == "") { ?>
		<th data-name="Plans_e" class="<?php echo $kt_driver_task_list->Plans_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Plans_e" class="kt_driver_task_Plans_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Plans_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Plans_e" class="<?php echo $kt_driver_task_list->Plans_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Plans_e) ?>', 1);"><div id="elh_kt_driver_task_Plans_e" class="kt_driver_task_Plans_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Plans_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Plans_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Plans_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Isdns_e->Visible) { // Isdns_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Isdns_e) == "") { ?>
		<th data-name="Isdns_e" class="<?php echo $kt_driver_task_list->Isdns_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Isdns_e" class="kt_driver_task_Isdns_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Isdns_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Isdns_e" class="<?php echo $kt_driver_task_list->Isdns_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Isdns_e) ?>', 1);"><div id="elh_kt_driver_task_Isdns_e" class="kt_driver_task_Isdns_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Isdns_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Isdns_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Isdns_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->PlanTypes_e->Visible) { // PlanTypes_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->PlanTypes_e) == "") { ?>
		<th data-name="PlanTypes_e" class="<?php echo $kt_driver_task_list->PlanTypes_e->headerCellClass() ?>"><div id="elh_kt_driver_task_PlanTypes_e" class="kt_driver_task_PlanTypes_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->PlanTypes_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PlanTypes_e" class="<?php echo $kt_driver_task_list->PlanTypes_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->PlanTypes_e) ?>', 1);"><div id="elh_kt_driver_task_PlanTypes_e" class="kt_driver_task_PlanTypes_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->PlanTypes_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->PlanTypes_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->PlanTypes_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Serials_e->Visible) { // Serials_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Serials_e) == "") { ?>
		<th data-name="Serials_e" class="<?php echo $kt_driver_task_list->Serials_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Serials_e" class="kt_driver_task_Serials_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Serials_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Serials_e" class="<?php echo $kt_driver_task_list->Serials_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Serials_e) ?>', 1);"><div id="elh_kt_driver_task_Serials_e" class="kt_driver_task_Serials_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Serials_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Serials_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Serials_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Status_2_e->Visible) { // Status_2_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Status_2_e) == "") { ?>
		<th data-name="Status_2_e" class="<?php echo $kt_driver_task_list->Status_2_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Status_2_e" class="kt_driver_task_Status_2_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_2_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_2_e" class="<?php echo $kt_driver_task_list->Status_2_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Status_2_e) ?>', 1);"><div id="elh_kt_driver_task_Status_2_e" class="kt_driver_task_Status_2_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_2_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Status_2_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Status_2_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Registered_Date_2_e->Visible) { // Registered_Date_2_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Registered_Date_2_e) == "") { ?>
		<th data-name="Registered_Date_2_e" class="<?php echo $kt_driver_task_list->Registered_Date_2_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Registered_Date_2_e" class="kt_driver_task_Registered_Date_2_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Registered_Date_2_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Registered_Date_2_e" class="<?php echo $kt_driver_task_list->Registered_Date_2_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Registered_Date_2_e) ?>', 1);"><div id="elh_kt_driver_task_Registered_Date_2_e" class="kt_driver_task_Registered_Date_2_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Registered_Date_2_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Registered_Date_2_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Registered_Date_2_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Summary_2_e->Visible) { // Summary_2_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Summary_2_e) == "") { ?>
		<th data-name="Summary_2_e" class="<?php echo $kt_driver_task_list->Summary_2_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Summary_2_e" class="kt_driver_task_Summary_2_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Summary_2_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Summary_2_e" class="<?php echo $kt_driver_task_list->Summary_2_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Summary_2_e) ?>', 1);"><div id="elh_kt_driver_task_Summary_2_e" class="kt_driver_task_Summary_2_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Summary_2_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Summary_2_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Summary_2_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->serial_2_e->Visible) { // serial_2_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->serial_2_e) == "") { ?>
		<th data-name="serial_2_e" class="<?php echo $kt_driver_task_list->serial_2_e->headerCellClass() ?>"><div id="elh_kt_driver_task_serial_2_e" class="kt_driver_task_serial_2_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->serial_2_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="serial_2_e" class="<?php echo $kt_driver_task_list->serial_2_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->serial_2_e) ?>', 1);"><div id="elh_kt_driver_task_serial_2_e" class="kt_driver_task_serial_2_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->serial_2_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->serial_2_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->serial_2_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->HandsetCode_e->Visible) { // HandsetCode_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->HandsetCode_e) == "") { ?>
		<th data-name="HandsetCode_e" class="<?php echo $kt_driver_task_list->HandsetCode_e->headerCellClass() ?>"><div id="elh_kt_driver_task_HandsetCode_e" class="kt_driver_task_HandsetCode_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->HandsetCode_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HandsetCode_e" class="<?php echo $kt_driver_task_list->HandsetCode_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->HandsetCode_e) ?>', 1);"><div id="elh_kt_driver_task_HandsetCode_e" class="kt_driver_task_HandsetCode_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->HandsetCode_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->HandsetCode_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->HandsetCode_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->HandsetName_e->Visible) { // HandsetName_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->HandsetName_e) == "") { ?>
		<th data-name="HandsetName_e" class="<?php echo $kt_driver_task_list->HandsetName_e->headerCellClass() ?>"><div id="elh_kt_driver_task_HandsetName_e" class="kt_driver_task_HandsetName_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->HandsetName_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HandsetName_e" class="<?php echo $kt_driver_task_list->HandsetName_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->HandsetName_e) ?>', 1);"><div id="elh_kt_driver_task_HandsetName_e" class="kt_driver_task_HandsetName_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->HandsetName_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->HandsetName_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->HandsetName_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Status_3_e->Visible) { // Status_3_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Status_3_e) == "") { ?>
		<th data-name="Status_3_e" class="<?php echo $kt_driver_task_list->Status_3_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Status_3_e" class="kt_driver_task_Status_3_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_3_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_3_e" class="<?php echo $kt_driver_task_list->Status_3_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Status_3_e) ?>', 1);"><div id="elh_kt_driver_task_Status_3_e" class="kt_driver_task_Status_3_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_3_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Status_3_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Status_3_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Summary_3_e->Visible) { // Summary_3_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Summary_3_e) == "") { ?>
		<th data-name="Summary_3_e" class="<?php echo $kt_driver_task_list->Summary_3_e->headerCellClass() ?>"><div id="elh_kt_driver_task_Summary_3_e" class="kt_driver_task_Summary_3_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Summary_3_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Summary_3_e" class="<?php echo $kt_driver_task_list->Summary_3_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Summary_3_e) ?>', 1);"><div id="elh_kt_driver_task_Summary_3_e" class="kt_driver_task_Summary_3_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Summary_3_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Summary_3_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Summary_3_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->fecha_activa_e->Visible) { // fecha_activa_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->fecha_activa_e) == "") { ?>
		<th data-name="fecha_activa_e" class="<?php echo $kt_driver_task_list->fecha_activa_e->headerCellClass() ?>"><div id="elh_kt_driver_task_fecha_activa_e" class="kt_driver_task_fecha_activa_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->fecha_activa_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha_activa_e" class="<?php echo $kt_driver_task_list->fecha_activa_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->fecha_activa_e) ?>', 1);"><div id="elh_kt_driver_task_fecha_activa_e" class="kt_driver_task_fecha_activa_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->fecha_activa_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->fecha_activa_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->fecha_activa_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->mes_activa_e->Visible) { // mes_activa_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->mes_activa_e) == "") { ?>
		<th data-name="mes_activa_e" class="<?php echo $kt_driver_task_list->mes_activa_e->headerCellClass() ?>"><div id="elh_kt_driver_task_mes_activa_e" class="kt_driver_task_mes_activa_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->mes_activa_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mes_activa_e" class="<?php echo $kt_driver_task_list->mes_activa_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->mes_activa_e) ?>', 1);"><div id="elh_kt_driver_task_mes_activa_e" class="kt_driver_task_mes_activa_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->mes_activa_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->mes_activa_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->mes_activa_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->SOURCE_OUT_e->Visible) { // SOURCE_OUT_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->SOURCE_OUT_e) == "") { ?>
		<th data-name="SOURCE_OUT_e" class="<?php echo $kt_driver_task_list->SOURCE_OUT_e->headerCellClass() ?>"><div id="elh_kt_driver_task_SOURCE_OUT_e" class="kt_driver_task_SOURCE_OUT_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->SOURCE_OUT_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SOURCE_OUT_e" class="<?php echo $kt_driver_task_list->SOURCE_OUT_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->SOURCE_OUT_e) ?>', 1);"><div id="elh_kt_driver_task_SOURCE_OUT_e" class="kt_driver_task_SOURCE_OUT_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->SOURCE_OUT_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->SOURCE_OUT_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->SOURCE_OUT_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->fecha_crea_e->Visible) { // fecha_crea_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->fecha_crea_e) == "") { ?>
		<th data-name="fecha_crea_e" class="<?php echo $kt_driver_task_list->fecha_crea_e->headerCellClass() ?>"><div id="elh_kt_driver_task_fecha_crea_e" class="kt_driver_task_fecha_crea_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->fecha_crea_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha_crea_e" class="<?php echo $kt_driver_task_list->fecha_crea_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->fecha_crea_e) ?>', 1);"><div id="elh_kt_driver_task_fecha_crea_e" class="kt_driver_task_fecha_crea_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->fecha_crea_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->fecha_crea_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->fecha_crea_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->mes_crea_e->Visible) { // mes_crea_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->mes_crea_e) == "") { ?>
		<th data-name="mes_crea_e" class="<?php echo $kt_driver_task_list->mes_crea_e->headerCellClass() ?>"><div id="elh_kt_driver_task_mes_crea_e" class="kt_driver_task_mes_crea_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->mes_crea_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mes_crea_e" class="<?php echo $kt_driver_task_list->mes_crea_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->mes_crea_e) ?>', 1);"><div id="elh_kt_driver_task_mes_crea_e" class="kt_driver_task_mes_crea_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->mes_crea_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->mes_crea_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->mes_crea_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->moto_e->Visible) { // moto_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->moto_e) == "") { ?>
		<th data-name="moto_e" class="<?php echo $kt_driver_task_list->moto_e->headerCellClass() ?>"><div id="elh_kt_driver_task_moto_e" class="kt_driver_task_moto_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->moto_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="moto_e" class="<?php echo $kt_driver_task_list->moto_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->moto_e) ?>', 1);"><div id="elh_kt_driver_task_moto_e" class="kt_driver_task_moto_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->moto_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->moto_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->moto_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->customer_id->Visible) { // customer_id ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->customer_id) == "") { ?>
		<th data-name="customer_id" class="<?php echo $kt_driver_task_list->customer_id->headerCellClass() ?>"><div id="elh_kt_driver_task_customer_id" class="kt_driver_task_customer_id"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="customer_id" class="<?php echo $kt_driver_task_list->customer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->customer_id) ?>', 1);"><div id="elh_kt_driver_task_customer_id" class="kt_driver_task_customer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->customer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->customer_id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->customer_id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->status->Visible) { // status ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->status) == "") { ?>
		<th data-name="status" class="<?php echo $kt_driver_task_list->status->headerCellClass() ?>"><div id="elh_kt_driver_task_status" class="kt_driver_task_status"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $kt_driver_task_list->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->status) ?>', 1);"><div id="elh_kt_driver_task_status" class="kt_driver_task_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->branch_e->Visible) { // branch_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->branch_e) == "") { ?>
		<th data-name="branch_e" class="<?php echo $kt_driver_task_list->branch_e->headerCellClass() ?>"><div id="elh_kt_driver_task_branch_e" class="kt_driver_task_branch_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->branch_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="branch_e" class="<?php echo $kt_driver_task_list->branch_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->branch_e) ?>', 1);"><div id="elh_kt_driver_task_branch_e" class="kt_driver_task_branch_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->branch_e->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->branch_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->branch_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->CreatedTime_e->Visible) { // CreatedTime_e ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->CreatedTime_e) == "") { ?>
		<th data-name="CreatedTime_e" class="<?php echo $kt_driver_task_list->CreatedTime_e->headerCellClass() ?>"><div id="elh_kt_driver_task_CreatedTime_e" class="kt_driver_task_CreatedTime_e"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->CreatedTime_e->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CreatedTime_e" class="<?php echo $kt_driver_task_list->CreatedTime_e->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->CreatedTime_e) ?>', 1);"><div id="elh_kt_driver_task_CreatedTime_e" class="kt_driver_task_CreatedTime_e">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->CreatedTime_e->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->CreatedTime_e->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->CreatedTime_e->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($kt_driver_task_list->Status_n->Visible) { // Status_n ?>
	<?php if ($kt_driver_task_list->SortUrl($kt_driver_task_list->Status_n) == "") { ?>
		<th data-name="Status_n" class="<?php echo $kt_driver_task_list->Status_n->headerCellClass() ?>"><div id="elh_kt_driver_task_Status_n" class="kt_driver_task_Status_n"><div class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_n" class="<?php echo $kt_driver_task_list->Status_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $kt_driver_task_list->SortUrl($kt_driver_task_list->Status_n) ?>', 1);"><div id="elh_kt_driver_task_Status_n" class="kt_driver_task_Status_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $kt_driver_task_list->Status_n->caption() ?></span><span class="ew-table-header-sort"><?php if ($kt_driver_task_list->Status_n->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($kt_driver_task_list->Status_n->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$kt_driver_task_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($kt_driver_task_list->ExportAll && $kt_driver_task_list->isExport()) {
	$kt_driver_task_list->StopRecord = $kt_driver_task_list->TotalRecords;
} else {

	// Set the last record to display
	if ($kt_driver_task_list->TotalRecords > $kt_driver_task_list->StartRecord + $kt_driver_task_list->DisplayRecords - 1)
		$kt_driver_task_list->StopRecord = $kt_driver_task_list->StartRecord + $kt_driver_task_list->DisplayRecords - 1;
	else
		$kt_driver_task_list->StopRecord = $kt_driver_task_list->TotalRecords;
}
$kt_driver_task_list->RecordCount = $kt_driver_task_list->StartRecord - 1;
if ($kt_driver_task_list->Recordset && !$kt_driver_task_list->Recordset->EOF) {
	$kt_driver_task_list->Recordset->moveFirst();
	$selectLimit = $kt_driver_task_list->UseSelectLimit;
	if (!$selectLimit && $kt_driver_task_list->StartRecord > 1)
		$kt_driver_task_list->Recordset->move($kt_driver_task_list->StartRecord - 1);
} elseif (!$kt_driver_task->AllowAddDeleteRow && $kt_driver_task_list->StopRecord == 0) {
	$kt_driver_task_list->StopRecord = $kt_driver_task->GridAddRowCount;
}

// Initialize aggregate
$kt_driver_task->RowType = ROWTYPE_AGGREGATEINIT;
$kt_driver_task->resetAttributes();
$kt_driver_task_list->renderRow();
while ($kt_driver_task_list->RecordCount < $kt_driver_task_list->StopRecord) {
	$kt_driver_task_list->RecordCount++;
	if ($kt_driver_task_list->RecordCount >= $kt_driver_task_list->StartRecord) {
		$kt_driver_task_list->RowCount++;

		// Set up key count
		$kt_driver_task_list->KeyCount = $kt_driver_task_list->RowIndex;

		// Init row class and style
		$kt_driver_task->resetAttributes();
		$kt_driver_task->CssClass = "";
		if ($kt_driver_task_list->isGridAdd()) {
		} else {
			$kt_driver_task_list->loadRowValues($kt_driver_task_list->Recordset); // Load row values
		}
		$kt_driver_task->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$kt_driver_task->RowAttrs->merge(["data-rowindex" => $kt_driver_task_list->RowCount, "id" => "r" . $kt_driver_task_list->RowCount . "_kt_driver_task", "data-rowtype" => $kt_driver_task->RowType]);

		// Render row
		$kt_driver_task_list->renderRow();

		// Render list options
		$kt_driver_task_list->renderListOptions();
?>
	<tr <?php echo $kt_driver_task->rowAttributes() ?>>
<?php

// Render list options (body, left)
$kt_driver_task_list->ListOptions->render("body", "left", $kt_driver_task_list->RowCount);
?>
	<?php if ($kt_driver_task_list->task_id->Visible) { // task_id ?>
		<td data-name="task_id" <?php echo $kt_driver_task_list->task_id->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_task_id" class="kt_driver_task_task_id">
<span<?php echo $kt_driver_task_list->task_id->viewAttributes() ?>><?php echo $kt_driver_task_list->task_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->task_description->Visible) { // task_description ?>
		<td data-name="task_description" <?php echo $kt_driver_task_list->task_description->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_task_description" class="kt_driver_task_task_description">
<span<?php echo $kt_driver_task_list->task_description->viewAttributes() ?>><?php echo $kt_driver_task_list->task_description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->trans_type->Visible) { // trans_type ?>
		<td data-name="trans_type" <?php echo $kt_driver_task_list->trans_type->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_trans_type" class="kt_driver_task_trans_type">
<span<?php echo $kt_driver_task_list->trans_type->viewAttributes() ?>><?php echo $kt_driver_task_list->trans_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->contact_number->Visible) { // contact_number ?>
		<td data-name="contact_number" <?php echo $kt_driver_task_list->contact_number->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_contact_number" class="kt_driver_task_contact_number">
<span<?php echo $kt_driver_task_list->contact_number->viewAttributes() ?>><?php echo $kt_driver_task_list->contact_number->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->email_address->Visible) { // email_address ?>
		<td data-name="email_address" <?php echo $kt_driver_task_list->email_address->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_email_address" class="kt_driver_task_email_address">
<span<?php echo $kt_driver_task_list->email_address->viewAttributes() ?>><?php echo $kt_driver_task_list->email_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->customer_name->Visible) { // customer_name ?>
		<td data-name="customer_name" <?php echo $kt_driver_task_list->customer_name->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_customer_name" class="kt_driver_task_customer_name">
<span<?php echo $kt_driver_task_list->customer_name->viewAttributes() ?>><?php echo $kt_driver_task_list->customer_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->delivery_date->Visible) { // delivery_date ?>
		<td data-name="delivery_date" <?php echo $kt_driver_task_list->delivery_date->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_delivery_date" class="kt_driver_task_delivery_date">
<span<?php echo $kt_driver_task_list->delivery_date->viewAttributes() ?>><?php echo $kt_driver_task_list->delivery_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->team_id->Visible) { // team_id ?>
		<td data-name="team_id" <?php echo $kt_driver_task_list->team_id->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_team_id" class="kt_driver_task_team_id">
<span<?php echo $kt_driver_task_list->team_id->viewAttributes() ?>><?php echo $kt_driver_task_list->team_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->driver_id->Visible) { // driver_id ?>
		<td data-name="driver_id" <?php echo $kt_driver_task_list->driver_id->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_driver_id" class="kt_driver_task_driver_id">
<span<?php echo $kt_driver_task_list->driver_id->viewAttributes() ?>><?php echo $kt_driver_task_list->driver_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->task_lat->Visible) { // task_lat ?>
		<td data-name="task_lat" <?php echo $kt_driver_task_list->task_lat->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_task_lat" class="kt_driver_task_task_lat">
<span<?php echo $kt_driver_task_list->task_lat->viewAttributes() ?>><?php echo $kt_driver_task_list->task_lat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->task_lng->Visible) { // task_lng ?>
		<td data-name="task_lng" <?php echo $kt_driver_task_list->task_lng->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_task_lng" class="kt_driver_task_task_lng">
<span<?php echo $kt_driver_task_list->task_lng->viewAttributes() ?>><?php echo $kt_driver_task_list->task_lng->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->customer_signature->Visible) { // customer_signature ?>
		<td data-name="customer_signature" <?php echo $kt_driver_task_list->customer_signature->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_customer_signature" class="kt_driver_task_customer_signature">
<span<?php echo $kt_driver_task_list->customer_signature->viewAttributes() ?>><?php echo $kt_driver_task_list->customer_signature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->date_created->Visible) { // date_created ?>
		<td data-name="date_created" <?php echo $kt_driver_task_list->date_created->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_date_created" class="kt_driver_task_date_created">
<span<?php echo $kt_driver_task_list->date_created->viewAttributes() ?>><?php echo $kt_driver_task_list->date_created->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->date_modified->Visible) { // date_modified ?>
		<td data-name="date_modified" <?php echo $kt_driver_task_list->date_modified->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_date_modified" class="kt_driver_task_date_modified">
<span<?php echo $kt_driver_task_list->date_modified->viewAttributes() ?>><?php echo $kt_driver_task_list->date_modified->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->ip_address->Visible) { // ip_address ?>
		<td data-name="ip_address" <?php echo $kt_driver_task_list->ip_address->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_ip_address" class="kt_driver_task_ip_address">
<span<?php echo $kt_driver_task_list->ip_address->viewAttributes() ?>><?php echo $kt_driver_task_list->ip_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->auto_assign_type->Visible) { // auto_assign_type ?>
		<td data-name="auto_assign_type" <?php echo $kt_driver_task_list->auto_assign_type->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_auto_assign_type" class="kt_driver_task_auto_assign_type">
<span<?php echo $kt_driver_task_list->auto_assign_type->viewAttributes() ?>><?php echo $kt_driver_task_list->auto_assign_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->assign_started->Visible) { // assign_started ?>
		<td data-name="assign_started" <?php echo $kt_driver_task_list->assign_started->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_assign_started" class="kt_driver_task_assign_started">
<span<?php echo $kt_driver_task_list->assign_started->viewAttributes() ?>><?php echo $kt_driver_task_list->assign_started->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->assignment_status->Visible) { // assignment_status ?>
		<td data-name="assignment_status" <?php echo $kt_driver_task_list->assignment_status->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_assignment_status" class="kt_driver_task_assignment_status">
<span<?php echo $kt_driver_task_list->assignment_status->viewAttributes() ?>><?php echo $kt_driver_task_list->assignment_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->dropoff_contact_name->Visible) { // dropoff_contact_name ?>
		<td data-name="dropoff_contact_name" <?php echo $kt_driver_task_list->dropoff_contact_name->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_dropoff_contact_name" class="kt_driver_task_dropoff_contact_name">
<span<?php echo $kt_driver_task_list->dropoff_contact_name->viewAttributes() ?>><?php echo $kt_driver_task_list->dropoff_contact_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->dropoff_contact_number->Visible) { // dropoff_contact_number ?>
		<td data-name="dropoff_contact_number" <?php echo $kt_driver_task_list->dropoff_contact_number->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_dropoff_contact_number" class="kt_driver_task_dropoff_contact_number">
<span<?php echo $kt_driver_task_list->dropoff_contact_number->viewAttributes() ?>><?php echo $kt_driver_task_list->dropoff_contact_number->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->drop_address->Visible) { // drop_address ?>
		<td data-name="drop_address" <?php echo $kt_driver_task_list->drop_address->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_drop_address" class="kt_driver_task_drop_address">
<span<?php echo $kt_driver_task_list->drop_address->viewAttributes() ?>><?php echo $kt_driver_task_list->drop_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->dropoff_task_lat->Visible) { // dropoff_task_lat ?>
		<td data-name="dropoff_task_lat" <?php echo $kt_driver_task_list->dropoff_task_lat->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_dropoff_task_lat" class="kt_driver_task_dropoff_task_lat">
<span<?php echo $kt_driver_task_list->dropoff_task_lat->viewAttributes() ?>><?php echo $kt_driver_task_list->dropoff_task_lat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->dropoff_task_lng->Visible) { // dropoff_task_lng ?>
		<td data-name="dropoff_task_lng" <?php echo $kt_driver_task_list->dropoff_task_lng->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_dropoff_task_lng" class="kt_driver_task_dropoff_task_lng">
<span<?php echo $kt_driver_task_list->dropoff_task_lng->viewAttributes() ?>><?php echo $kt_driver_task_list->dropoff_task_lng->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->task_token->Visible) { // task_token ?>
		<td data-name="task_token" <?php echo $kt_driver_task_list->task_token->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_task_token" class="kt_driver_task_task_token">
<span<?php echo $kt_driver_task_list->task_token->viewAttributes() ?>><?php echo $kt_driver_task_list->task_token->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->ratings->Visible) { // ratings ?>
		<td data-name="ratings" <?php echo $kt_driver_task_list->ratings->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_ratings" class="kt_driver_task_ratings">
<span<?php echo $kt_driver_task_list->ratings->viewAttributes() ?>><?php echo $kt_driver_task_list->ratings->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->rating_comment->Visible) { // rating_comment ?>
		<td data-name="rating_comment" <?php echo $kt_driver_task_list->rating_comment->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_rating_comment" class="kt_driver_task_rating_comment">
<span<?php echo $kt_driver_task_list->rating_comment->viewAttributes() ?>><?php echo $kt_driver_task_list->rating_comment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->critical->Visible) { // critical ?>
		<td data-name="critical" <?php echo $kt_driver_task_list->critical->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_critical" class="kt_driver_task_critical">
<span<?php echo $kt_driver_task_list->critical->viewAttributes() ?>><?php echo $kt_driver_task_list->critical->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->souce_e->Visible) { // souce_e ?>
		<td data-name="souce_e" <?php echo $kt_driver_task_list->souce_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_souce_e" class="kt_driver_task_souce_e">
<span<?php echo $kt_driver_task_list->souce_e->viewAttributes() ?>><?php echo $kt_driver_task_list->souce_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->shop_code_e->Visible) { // shop_code_e ?>
		<td data-name="shop_code_e" <?php echo $kt_driver_task_list->shop_code_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_shop_code_e" class="kt_driver_task_shop_code_e">
<span<?php echo $kt_driver_task_list->shop_code_e->viewAttributes() ?>><?php echo $kt_driver_task_list->shop_code_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Received_Channel_e->Visible) { // Received_Channel_e ?>
		<td data-name="Received_Channel_e" <?php echo $kt_driver_task_list->Received_Channel_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Received_Channel_e" class="kt_driver_task_Received_Channel_e">
<span<?php echo $kt_driver_task_list->Received_Channel_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Received_Channel_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->PayMethod_e->Visible) { // PayMethod_e ?>
		<td data-name="PayMethod_e" <?php echo $kt_driver_task_list->PayMethod_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_PayMethod_e" class="kt_driver_task_PayMethod_e">
<span<?php echo $kt_driver_task_list->PayMethod_e->viewAttributes() ?>><?php echo $kt_driver_task_list->PayMethod_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Type_e->Visible) { // Type_e ?>
		<td data-name="Type_e" <?php echo $kt_driver_task_list->Type_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Type_e" class="kt_driver_task_Type_e">
<span<?php echo $kt_driver_task_list->Type_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Type_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Request_Code_e->Visible) { // Request_Code_e ?>
		<td data-name="Request_Code_e" <?php echo $kt_driver_task_list->Request_Code_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Request_Code_e" class="kt_driver_task_Request_Code_e">
<span<?php echo $kt_driver_task_list->Request_Code_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Request_Code_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Status_e->Visible) { // Status_e ?>
		<td data-name="Status_e" <?php echo $kt_driver_task_list->Status_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Status_e" class="kt_driver_task_Status_e">
<span<?php echo $kt_driver_task_list->Status_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Status_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->PlanType_e->Visible) { // PlanType_e ?>
		<td data-name="PlanType_e" <?php echo $kt_driver_task_list->PlanType_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_PlanType_e" class="kt_driver_task_PlanType_e">
<span<?php echo $kt_driver_task_list->PlanType_e->viewAttributes() ?>><?php echo $kt_driver_task_list->PlanType_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Plan_e->Visible) { // Plan_e ?>
		<td data-name="Plan_e" <?php echo $kt_driver_task_list->Plan_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Plan_e" class="kt_driver_task_Plan_e">
<span<?php echo $kt_driver_task_list->Plan_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Plan_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Isdn_e->Visible) { // Isdn_e ?>
		<td data-name="Isdn_e" <?php echo $kt_driver_task_list->Isdn_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Isdn_e" class="kt_driver_task_Isdn_e">
<span<?php echo $kt_driver_task_list->Isdn_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Isdn_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->serial_sim_handset_e->Visible) { // serial_sim_handset_e ?>
		<td data-name="serial_sim_handset_e" <?php echo $kt_driver_task_list->serial_sim_handset_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_serial_sim_handset_e" class="kt_driver_task_serial_sim_handset_e">
<span<?php echo $kt_driver_task_list->serial_sim_handset_e->viewAttributes() ?>><?php echo $kt_driver_task_list->serial_sim_handset_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->handset_e->Visible) { // handset_e ?>
		<td data-name="handset_e" <?php echo $kt_driver_task_list->handset_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_handset_e" class="kt_driver_task_handset_e">
<span<?php echo $kt_driver_task_list->handset_e->viewAttributes() ?>><?php echo $kt_driver_task_list->handset_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Connect_Reason_e->Visible) { // Connect_Reason_e ?>
		<td data-name="Connect_Reason_e" <?php echo $kt_driver_task_list->Connect_Reason_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Connect_Reason_e" class="kt_driver_task_Connect_Reason_e">
<span<?php echo $kt_driver_task_list->Connect_Reason_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Connect_Reason_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Price_e->Visible) { // Price_e ?>
		<td data-name="Price_e" <?php echo $kt_driver_task_list->Price_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Price_e" class="kt_driver_task_Price_e">
<span<?php echo $kt_driver_task_list->Price_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Price_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Current_Operator_e->Visible) { // Current_Operator_e ?>
		<td data-name="Current_Operator_e" <?php echo $kt_driver_task_list->Current_Operator_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Current_Operator_e" class="kt_driver_task_Current_Operator_e">
<span<?php echo $kt_driver_task_list->Current_Operator_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Current_Operator_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Current_Plan_Type_e->Visible) { // Current_Plan_Type_e ?>
		<td data-name="Current_Plan_Type_e" <?php echo $kt_driver_task_list->Current_Plan_Type_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Current_Plan_Type_e" class="kt_driver_task_Current_Plan_Type_e">
<span<?php echo $kt_driver_task_list->Current_Plan_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Current_Plan_Type_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Document_Number_e->Visible) { // Document_Number_e ?>
		<td data-name="Document_Number_e" <?php echo $kt_driver_task_list->Document_Number_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Document_Number_e" class="kt_driver_task_Document_Number_e">
<span<?php echo $kt_driver_task_list->Document_Number_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Document_Number_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Document_Type_e->Visible) { // Document_Type_e ?>
		<td data-name="Document_Type_e" <?php echo $kt_driver_task_list->Document_Type_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Document_Type_e" class="kt_driver_task_Document_Type_e">
<span<?php echo $kt_driver_task_list->Document_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Document_Type_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->assignStaffCode_e->Visible) { // assignStaffCode_e ?>
		<td data-name="assignStaffCode_e" <?php echo $kt_driver_task_list->assignStaffCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_assignStaffCode_e" class="kt_driver_task_assignStaffCode_e">
<span<?php echo $kt_driver_task_list->assignStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->assignStaffCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Delivery_Type_e->Visible) { // Delivery_Type_e ?>
		<td data-name="Delivery_Type_e" <?php echo $kt_driver_task_list->Delivery_Type_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Delivery_Type_e" class="kt_driver_task_Delivery_Type_e">
<span<?php echo $kt_driver_task_list->Delivery_Type_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Delivery_Type_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->assignStaffType_e->Visible) { // assignStaffType_e ?>
		<td data-name="assignStaffType_e" <?php echo $kt_driver_task_list->assignStaffType_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_assignStaffType_e" class="kt_driver_task_assignStaffType_e">
<span<?php echo $kt_driver_task_list->assignStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_list->assignStaffType_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->receiveStaffCode_e->Visible) { // receiveStaffCode_e ?>
		<td data-name="receiveStaffCode_e" <?php echo $kt_driver_task_list->receiveStaffCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_receiveStaffCode_e" class="kt_driver_task_receiveStaffCode_e">
<span<?php echo $kt_driver_task_list->receiveStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->receiveStaffCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->receiveStaffType_e->Visible) { // receiveStaffType_e ?>
		<td data-name="receiveStaffType_e" <?php echo $kt_driver_task_list->receiveStaffType_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_receiveStaffType_e" class="kt_driver_task_receiveStaffType_e">
<span<?php echo $kt_driver_task_list->receiveStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_list->receiveStaffType_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->connectStaffCode_e->Visible) { // connectStaffCode_e ?>
		<td data-name="connectStaffCode_e" <?php echo $kt_driver_task_list->connectStaffCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_connectStaffCode_e" class="kt_driver_task_connectStaffCode_e">
<span<?php echo $kt_driver_task_list->connectStaffCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->connectStaffCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->connectStaffType_e->Visible) { // connectStaffType_e ?>
		<td data-name="connectStaffType_e" <?php echo $kt_driver_task_list->connectStaffType_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_connectStaffType_e" class="kt_driver_task_connectStaffType_e">
<span<?php echo $kt_driver_task_list->connectStaffType_e->viewAttributes() ?>><?php echo $kt_driver_task_list->connectStaffType_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->shopName_e->Visible) { // shopName_e ?>
		<td data-name="shopName_e" <?php echo $kt_driver_task_list->shopName_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_shopName_e" class="kt_driver_task_shopName_e">
<span<?php echo $kt_driver_task_list->shopName_e->viewAttributes() ?>><?php echo $kt_driver_task_list->shopName_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->saleOrderCode_e->Visible) { // saleOrderCode_e ?>
		<td data-name="saleOrderCode_e" <?php echo $kt_driver_task_list->saleOrderCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_saleOrderCode_e" class="kt_driver_task_saleOrderCode_e">
<span<?php echo $kt_driver_task_list->saleOrderCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->saleOrderCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->consultantCode_e->Visible) { // consultantCode_e ?>
		<td data-name="consultantCode_e" <?php echo $kt_driver_task_list->consultantCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_consultantCode_e" class="kt_driver_task_consultantCode_e">
<span<?php echo $kt_driver_task_list->consultantCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->consultantCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->consultantName_e->Visible) { // consultantName_e ?>
		<td data-name="consultantName_e" <?php echo $kt_driver_task_list->consultantName_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_consultantName_e" class="kt_driver_task_consultantName_e">
<span<?php echo $kt_driver_task_list->consultantName_e->viewAttributes() ?>><?php echo $kt_driver_task_list->consultantName_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->consultantType_e->Visible) { // consultantType_e ?>
		<td data-name="consultantType_e" <?php echo $kt_driver_task_list->consultantType_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_consultantType_e" class="kt_driver_task_consultantType_e">
<span<?php echo $kt_driver_task_list->consultantType_e->viewAttributes() ?>><?php echo $kt_driver_task_list->consultantType_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->created_By_e->Visible) { // created_By_e ?>
		<td data-name="created_By_e" <?php echo $kt_driver_task_list->created_By_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_created_By_e" class="kt_driver_task_created_By_e">
<span<?php echo $kt_driver_task_list->created_By_e->viewAttributes() ?>><?php echo $kt_driver_task_list->created_By_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->createdBranch_e->Visible) { // createdBranch_e ?>
		<td data-name="createdBranch_e" <?php echo $kt_driver_task_list->createdBranch_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_createdBranch_e" class="kt_driver_task_createdBranch_e">
<span<?php echo $kt_driver_task_list->createdBranch_e->viewAttributes() ?>><?php echo $kt_driver_task_list->createdBranch_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->generated_Code_By_e->Visible) { // generated_Code_By_e ?>
		<td data-name="generated_Code_By_e" <?php echo $kt_driver_task_list->generated_Code_By_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_generated_Code_By_e" class="kt_driver_task_generated_Code_By_e">
<span<?php echo $kt_driver_task_list->generated_Code_By_e->viewAttributes() ?>><?php echo $kt_driver_task_list->generated_Code_By_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->approve_Paid_By_e->Visible) { // approve_Paid_By_e ?>
		<td data-name="approve_Paid_By_e" <?php echo $kt_driver_task_list->approve_Paid_By_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_approve_Paid_By_e" class="kt_driver_task_approve_Paid_By_e">
<span<?php echo $kt_driver_task_list->approve_Paid_By_e->viewAttributes() ?>><?php echo $kt_driver_task_list->approve_Paid_By_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Delivery_Note_e->Visible) { // Delivery_Note_e ?>
		<td data-name="Delivery_Note_e" <?php echo $kt_driver_task_list->Delivery_Note_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Delivery_Note_e" class="kt_driver_task_Delivery_Note_e">
<span<?php echo $kt_driver_task_list->Delivery_Note_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Delivery_Note_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Delivery_Code_e->Visible) { // Delivery_Code_e ?>
		<td data-name="Delivery_Code_e" <?php echo $kt_driver_task_list->Delivery_Code_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Delivery_Code_e" class="kt_driver_task_Delivery_Code_e">
<span<?php echo $kt_driver_task_list->Delivery_Code_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Delivery_Code_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Customer_Note_e->Visible) { // Customer_Note_e ?>
		<td data-name="Customer_Note_e" <?php echo $kt_driver_task_list->Customer_Note_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Customer_Note_e" class="kt_driver_task_Customer_Note_e">
<span<?php echo $kt_driver_task_list->Customer_Note_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Customer_Note_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->saleOrderCreateDate_e->Visible) { // saleOrderCreateDate_e ?>
		<td data-name="saleOrderCreateDate_e" <?php echo $kt_driver_task_list->saleOrderCreateDate_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_saleOrderCreateDate_e" class="kt_driver_task_saleOrderCreateDate_e">
<span<?php echo $kt_driver_task_list->saleOrderCreateDate_e->viewAttributes() ?>><?php echo $kt_driver_task_list->saleOrderCreateDate_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->saleOrderPayDate_e->Visible) { // saleOrderPayDate_e ?>
		<td data-name="saleOrderPayDate_e" <?php echo $kt_driver_task_list->saleOrderPayDate_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_saleOrderPayDate_e" class="kt_driver_task_saleOrderPayDate_e">
<span<?php echo $kt_driver_task_list->saleOrderPayDate_e->viewAttributes() ?>><?php echo $kt_driver_task_list->saleOrderPayDate_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Time_of_Procesing_e->Visible) { // Time_of_Procesing_e ?>
		<td data-name="Time_of_Procesing_e" <?php echo $kt_driver_task_list->Time_of_Procesing_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Time_of_Procesing_e" class="kt_driver_task_Time_of_Procesing_e">
<span<?php echo $kt_driver_task_list->Time_of_Procesing_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Time_of_Procesing_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Time_of_new_e->Visible) { // Time_of_new_e ?>
		<td data-name="Time_of_new_e" <?php echo $kt_driver_task_list->Time_of_new_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Time_of_new_e" class="kt_driver_task_Time_of_new_e">
<span<?php echo $kt_driver_task_list->Time_of_new_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Time_of_new_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Time_of_Finished_e->Visible) { // Time_of_Finished_e ?>
		<td data-name="Time_of_Finished_e" <?php echo $kt_driver_task_list->Time_of_Finished_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Time_of_Finished_e" class="kt_driver_task_Time_of_Finished_e">
<span<?php echo $kt_driver_task_list->Time_of_Finished_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Time_of_Finished_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->KPI_CC_Hour_e->Visible) { // KPI_CC_Hour_e ?>
		<td data-name="KPI_CC_Hour_e" <?php echo $kt_driver_task_list->KPI_CC_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_KPI_CC_Hour_e" class="kt_driver_task_KPI_CC_Hour_e">
<span<?php echo $kt_driver_task_list->KPI_CC_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->KPI_CC_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->KPI_NEW_Hour_e->Visible) { // KPI_NEW_Hour_e ?>
		<td data-name="KPI_NEW_Hour_e" <?php echo $kt_driver_task_list->KPI_NEW_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_KPI_NEW_Hour_e" class="kt_driver_task_KPI_NEW_Hour_e">
<span<?php echo $kt_driver_task_list->KPI_NEW_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->KPI_NEW_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->KPI_PROCESING_Hour_e->Visible) { // KPI_PROCESING_Hour_e ?>
		<td data-name="KPI_PROCESING_Hour_e" <?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_KPI_PROCESING_Hour_e" class="kt_driver_task_KPI_PROCESING_Hour_e">
<span<?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->KPI_PROCESING_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->KPI_ALL_Hour_e->Visible) { // KPI_ALL_Hour_e ?>
		<td data-name="KPI_ALL_Hour_e" <?php echo $kt_driver_task_list->KPI_ALL_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_KPI_ALL_Hour_e" class="kt_driver_task_KPI_ALL_Hour_e">
<span<?php echo $kt_driver_task_list->KPI_ALL_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->KPI_ALL_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Kpi_Register_Hour_e->Visible) { // Kpi_Register_Hour_e ?>
		<td data-name="Kpi_Register_Hour_e" <?php echo $kt_driver_task_list->Kpi_Register_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Kpi_Register_Hour_e" class="kt_driver_task_Kpi_Register_Hour_e">
<span<?php echo $kt_driver_task_list->Kpi_Register_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Kpi_Register_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Kpi_Bitel_Hour_e->Visible) { // Kpi_Bitel_Hour_e ?>
		<td data-name="Kpi_Bitel_Hour_e" <?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Kpi_Bitel_Hour_e" class="kt_driver_task_Kpi_Bitel_Hour_e">
<span<?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Kpi_Bitel_Hour_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->AmountGB_e->Visible) { // AmountGB_e ?>
		<td data-name="AmountGB_e" <?php echo $kt_driver_task_list->AmountGB_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_AmountGB_e" class="kt_driver_task_AmountGB_e">
<span<?php echo $kt_driver_task_list->AmountGB_e->viewAttributes() ?>><?php echo $kt_driver_task_list->AmountGB_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Price_1_e->Visible) { // Price_1_e ?>
		<td data-name="Price_1_e" <?php echo $kt_driver_task_list->Price_1_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Price_1_e" class="kt_driver_task_Price_1_e">
<span<?php echo $kt_driver_task_list->Price_1_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Price_1_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Status_1_e->Visible) { // Status_1_e ?>
		<td data-name="Status_1_e" <?php echo $kt_driver_task_list->Status_1_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Status_1_e" class="kt_driver_task_Status_1_e">
<span<?php echo $kt_driver_task_list->Status_1_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Status_1_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Registered_Date_e->Visible) { // Registered_Date_e ?>
		<td data-name="Registered_Date_e" <?php echo $kt_driver_task_list->Registered_Date_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Registered_Date_e" class="kt_driver_task_Registered_Date_e">
<span<?php echo $kt_driver_task_list->Registered_Date_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Registered_Date_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Sumary_e->Visible) { // Sumary_e ?>
		<td data-name="Sumary_e" <?php echo $kt_driver_task_list->Sumary_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Sumary_e" class="kt_driver_task_Sumary_e">
<span<?php echo $kt_driver_task_list->Sumary_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Sumary_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Plans_e->Visible) { // Plans_e ?>
		<td data-name="Plans_e" <?php echo $kt_driver_task_list->Plans_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Plans_e" class="kt_driver_task_Plans_e">
<span<?php echo $kt_driver_task_list->Plans_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Plans_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Isdns_e->Visible) { // Isdns_e ?>
		<td data-name="Isdns_e" <?php echo $kt_driver_task_list->Isdns_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Isdns_e" class="kt_driver_task_Isdns_e">
<span<?php echo $kt_driver_task_list->Isdns_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Isdns_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->PlanTypes_e->Visible) { // PlanTypes_e ?>
		<td data-name="PlanTypes_e" <?php echo $kt_driver_task_list->PlanTypes_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_PlanTypes_e" class="kt_driver_task_PlanTypes_e">
<span<?php echo $kt_driver_task_list->PlanTypes_e->viewAttributes() ?>><?php echo $kt_driver_task_list->PlanTypes_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Serials_e->Visible) { // Serials_e ?>
		<td data-name="Serials_e" <?php echo $kt_driver_task_list->Serials_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Serials_e" class="kt_driver_task_Serials_e">
<span<?php echo $kt_driver_task_list->Serials_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Serials_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Status_2_e->Visible) { // Status_2_e ?>
		<td data-name="Status_2_e" <?php echo $kt_driver_task_list->Status_2_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Status_2_e" class="kt_driver_task_Status_2_e">
<span<?php echo $kt_driver_task_list->Status_2_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Status_2_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Registered_Date_2_e->Visible) { // Registered_Date_2_e ?>
		<td data-name="Registered_Date_2_e" <?php echo $kt_driver_task_list->Registered_Date_2_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Registered_Date_2_e" class="kt_driver_task_Registered_Date_2_e">
<span<?php echo $kt_driver_task_list->Registered_Date_2_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Registered_Date_2_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Summary_2_e->Visible) { // Summary_2_e ?>
		<td data-name="Summary_2_e" <?php echo $kt_driver_task_list->Summary_2_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Summary_2_e" class="kt_driver_task_Summary_2_e">
<span<?php echo $kt_driver_task_list->Summary_2_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Summary_2_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->serial_2_e->Visible) { // serial_2_e ?>
		<td data-name="serial_2_e" <?php echo $kt_driver_task_list->serial_2_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_serial_2_e" class="kt_driver_task_serial_2_e">
<span<?php echo $kt_driver_task_list->serial_2_e->viewAttributes() ?>><?php echo $kt_driver_task_list->serial_2_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->HandsetCode_e->Visible) { // HandsetCode_e ?>
		<td data-name="HandsetCode_e" <?php echo $kt_driver_task_list->HandsetCode_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_HandsetCode_e" class="kt_driver_task_HandsetCode_e">
<span<?php echo $kt_driver_task_list->HandsetCode_e->viewAttributes() ?>><?php echo $kt_driver_task_list->HandsetCode_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->HandsetName_e->Visible) { // HandsetName_e ?>
		<td data-name="HandsetName_e" <?php echo $kt_driver_task_list->HandsetName_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_HandsetName_e" class="kt_driver_task_HandsetName_e">
<span<?php echo $kt_driver_task_list->HandsetName_e->viewAttributes() ?>><?php echo $kt_driver_task_list->HandsetName_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Status_3_e->Visible) { // Status_3_e ?>
		<td data-name="Status_3_e" <?php echo $kt_driver_task_list->Status_3_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Status_3_e" class="kt_driver_task_Status_3_e">
<span<?php echo $kt_driver_task_list->Status_3_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Status_3_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Summary_3_e->Visible) { // Summary_3_e ?>
		<td data-name="Summary_3_e" <?php echo $kt_driver_task_list->Summary_3_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Summary_3_e" class="kt_driver_task_Summary_3_e">
<span<?php echo $kt_driver_task_list->Summary_3_e->viewAttributes() ?>><?php echo $kt_driver_task_list->Summary_3_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->fecha_activa_e->Visible) { // fecha_activa_e ?>
		<td data-name="fecha_activa_e" <?php echo $kt_driver_task_list->fecha_activa_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_fecha_activa_e" class="kt_driver_task_fecha_activa_e">
<span<?php echo $kt_driver_task_list->fecha_activa_e->viewAttributes() ?>><?php echo $kt_driver_task_list->fecha_activa_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->mes_activa_e->Visible) { // mes_activa_e ?>
		<td data-name="mes_activa_e" <?php echo $kt_driver_task_list->mes_activa_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_mes_activa_e" class="kt_driver_task_mes_activa_e">
<span<?php echo $kt_driver_task_list->mes_activa_e->viewAttributes() ?>><?php echo $kt_driver_task_list->mes_activa_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->SOURCE_OUT_e->Visible) { // SOURCE_OUT_e ?>
		<td data-name="SOURCE_OUT_e" <?php echo $kt_driver_task_list->SOURCE_OUT_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_SOURCE_OUT_e" class="kt_driver_task_SOURCE_OUT_e">
<span<?php echo $kt_driver_task_list->SOURCE_OUT_e->viewAttributes() ?>><?php echo $kt_driver_task_list->SOURCE_OUT_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->fecha_crea_e->Visible) { // fecha_crea_e ?>
		<td data-name="fecha_crea_e" <?php echo $kt_driver_task_list->fecha_crea_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_fecha_crea_e" class="kt_driver_task_fecha_crea_e">
<span<?php echo $kt_driver_task_list->fecha_crea_e->viewAttributes() ?>><?php echo $kt_driver_task_list->fecha_crea_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->mes_crea_e->Visible) { // mes_crea_e ?>
		<td data-name="mes_crea_e" <?php echo $kt_driver_task_list->mes_crea_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_mes_crea_e" class="kt_driver_task_mes_crea_e">
<span<?php echo $kt_driver_task_list->mes_crea_e->viewAttributes() ?>><?php echo $kt_driver_task_list->mes_crea_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->moto_e->Visible) { // moto_e ?>
		<td data-name="moto_e" <?php echo $kt_driver_task_list->moto_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_moto_e" class="kt_driver_task_moto_e">
<span<?php echo $kt_driver_task_list->moto_e->viewAttributes() ?>><?php echo $kt_driver_task_list->moto_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->customer_id->Visible) { // customer_id ?>
		<td data-name="customer_id" <?php echo $kt_driver_task_list->customer_id->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_customer_id" class="kt_driver_task_customer_id">
<span<?php echo $kt_driver_task_list->customer_id->viewAttributes() ?>><?php echo $kt_driver_task_list->customer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->status->Visible) { // status ?>
		<td data-name="status" <?php echo $kt_driver_task_list->status->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_status" class="kt_driver_task_status">
<span<?php echo $kt_driver_task_list->status->viewAttributes() ?>><?php echo $kt_driver_task_list->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->branch_e->Visible) { // branch_e ?>
		<td data-name="branch_e" <?php echo $kt_driver_task_list->branch_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_branch_e" class="kt_driver_task_branch_e">
<span<?php echo $kt_driver_task_list->branch_e->viewAttributes() ?>><?php echo $kt_driver_task_list->branch_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->CreatedTime_e->Visible) { // CreatedTime_e ?>
		<td data-name="CreatedTime_e" <?php echo $kt_driver_task_list->CreatedTime_e->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_CreatedTime_e" class="kt_driver_task_CreatedTime_e">
<span<?php echo $kt_driver_task_list->CreatedTime_e->viewAttributes() ?>><?php echo $kt_driver_task_list->CreatedTime_e->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($kt_driver_task_list->Status_n->Visible) { // Status_n ?>
		<td data-name="Status_n" <?php echo $kt_driver_task_list->Status_n->cellAttributes() ?>>
<span id="el<?php echo $kt_driver_task_list->RowCount ?>_kt_driver_task_Status_n" class="kt_driver_task_Status_n">
<span<?php echo $kt_driver_task_list->Status_n->viewAttributes() ?>><?php echo $kt_driver_task_list->Status_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$kt_driver_task_list->ListOptions->render("body", "right", $kt_driver_task_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$kt_driver_task_list->isGridAdd())
		$kt_driver_task_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$kt_driver_task->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($kt_driver_task_list->Recordset)
	$kt_driver_task_list->Recordset->Close();
?>
<?php if (!$kt_driver_task_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$kt_driver_task_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $kt_driver_task_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $kt_driver_task_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($kt_driver_task_list->TotalRecords == 0 && !$kt_driver_task->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $kt_driver_task_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$kt_driver_task_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kt_driver_task_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kt_driver_task_list->terminate();
?>