<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lotes_list = new lotes_list();

// Run the page
$lotes_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lotes_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$lotes_list->isExport()) { ?>
<script>
var floteslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	floteslist = currentForm = new ew.Form("floteslist", "list");
	floteslist.formKeyCountName = '<?php echo $lotes_list->FormKeyCountName ?>';
	loadjs.done("floteslist");
});
var floteslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	floteslistsrch = currentSearchForm = new ew.Form("floteslistsrch");

	// Dynamic selection lists
	// Filters

	floteslistsrch.filterList = <?php echo $lotes_list->getFilterList() ?>;
	loadjs.done("floteslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$lotes_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($lotes_list->TotalRecords > 0 && $lotes_list->ExportOptions->visible()) { ?>
<?php $lotes_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($lotes_list->ImportOptions->visible()) { ?>
<?php $lotes_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($lotes_list->SearchOptions->visible()) { ?>
<?php $lotes_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($lotes_list->FilterOptions->visible()) { ?>
<?php $lotes_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$lotes_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$lotes_list->isExport() && !$lotes->CurrentAction) { ?>
<form name="floteslistsrch" id="floteslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="floteslistsrch-search-panel" class="<?php echo $lotes_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="lotes">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $lotes_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($lotes_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($lotes_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $lotes_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($lotes_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($lotes_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($lotes_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($lotes_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $lotes_list->showPageHeader(); ?>
<?php
$lotes_list->showMessage();
?>
<?php if ($lotes_list->TotalRecords > 0 || $lotes->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lotes_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lotes">
<form name="floteslist" id="floteslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lotes">
<div id="gmp_lotes" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($lotes_list->TotalRecords > 0 || $lotes_list->isGridEdit()) { ?>
<table id="tbl_loteslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lotes->RowType = ROWTYPE_HEADER;

// Render list options
$lotes_list->renderListOptions();

// Render list options (header, left)
$lotes_list->ListOptions->render("header", "left");
?>
<?php if ($lotes_list->id_producto->Visible) { // id_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->id_producto) == "") { ?>
		<th data-name="id_producto" class="<?php echo $lotes_list->id_producto->headerCellClass() ?>"><div id="elh_lotes_id_producto" class="lotes_id_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->id_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_producto" class="<?php echo $lotes_list->id_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->id_producto) ?>', 1);"><div id="elh_lotes_id_producto" class="lotes_id_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->id_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->id_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->id_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->id_proyecto->Visible) { // id_proyecto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->id_proyecto) == "") { ?>
		<th data-name="id_proyecto" class="<?php echo $lotes_list->id_proyecto->headerCellClass() ?>"><div id="elh_lotes_id_proyecto" class="lotes_id_proyecto"><div class="ew-table-header-caption"><?php echo $lotes_list->id_proyecto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_proyecto" class="<?php echo $lotes_list->id_proyecto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->id_proyecto) ?>', 1);"><div id="elh_lotes_id_proyecto" class="lotes_id_proyecto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->id_proyecto->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->id_proyecto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->id_proyecto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->codigo_producto->Visible) { // codigo_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->codigo_producto) == "") { ?>
		<th data-name="codigo_producto" class="<?php echo $lotes_list->codigo_producto->headerCellClass() ?>"><div id="elh_lotes_codigo_producto" class="lotes_codigo_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->codigo_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo_producto" class="<?php echo $lotes_list->codigo_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->codigo_producto) ?>', 1);"><div id="elh_lotes_codigo_producto" class="lotes_codigo_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->codigo_producto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->codigo_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->codigo_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->nombre_producto->Visible) { // nombre_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->nombre_producto) == "") { ?>
		<th data-name="nombre_producto" class="<?php echo $lotes_list->nombre_producto->headerCellClass() ?>"><div id="elh_lotes_nombre_producto" class="lotes_nombre_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->nombre_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre_producto" class="<?php echo $lotes_list->nombre_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->nombre_producto) ?>', 1);"><div id="elh_lotes_nombre_producto" class="lotes_nombre_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->nombre_producto->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->nombre_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->nombre_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->status_producto->Visible) { // status_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->status_producto) == "") { ?>
		<th data-name="status_producto" class="<?php echo $lotes_list->status_producto->headerCellClass() ?>"><div id="elh_lotes_status_producto" class="lotes_status_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->status_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_producto" class="<?php echo $lotes_list->status_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->status_producto) ?>', 1);"><div id="elh_lotes_status_producto" class="lotes_status_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->status_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->status_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->status_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->date_added->Visible) { // date_added ?>
	<?php if ($lotes_list->SortUrl($lotes_list->date_added) == "") { ?>
		<th data-name="date_added" class="<?php echo $lotes_list->date_added->headerCellClass() ?>"><div id="elh_lotes_date_added" class="lotes_date_added"><div class="ew-table-header-caption"><?php echo $lotes_list->date_added->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_added" class="<?php echo $lotes_list->date_added->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->date_added) ?>', 1);"><div id="elh_lotes_date_added" class="lotes_date_added">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->date_added->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->date_added->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->date_added->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->precio_producto->Visible) { // precio_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->precio_producto) == "") { ?>
		<th data-name="precio_producto" class="<?php echo $lotes_list->precio_producto->headerCellClass() ?>"><div id="elh_lotes_precio_producto" class="lotes_precio_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->precio_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio_producto" class="<?php echo $lotes_list->precio_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->precio_producto) ?>', 1);"><div id="elh_lotes_precio_producto" class="lotes_precio_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->precio_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->precio_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->precio_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->costo_producto->Visible) { // costo_producto ?>
	<?php if ($lotes_list->SortUrl($lotes_list->costo_producto) == "") { ?>
		<th data-name="costo_producto" class="<?php echo $lotes_list->costo_producto->headerCellClass() ?>"><div id="elh_lotes_costo_producto" class="lotes_costo_producto"><div class="ew-table-header-caption"><?php echo $lotes_list->costo_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="costo_producto" class="<?php echo $lotes_list->costo_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->costo_producto) ?>', 1);"><div id="elh_lotes_costo_producto" class="lotes_costo_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->costo_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->costo_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->costo_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->mon_costo->Visible) { // mon_costo ?>
	<?php if ($lotes_list->SortUrl($lotes_list->mon_costo) == "") { ?>
		<th data-name="mon_costo" class="<?php echo $lotes_list->mon_costo->headerCellClass() ?>"><div id="elh_lotes_mon_costo" class="lotes_mon_costo"><div class="ew-table-header-caption"><?php echo $lotes_list->mon_costo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mon_costo" class="<?php echo $lotes_list->mon_costo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->mon_costo) ?>', 1);"><div id="elh_lotes_mon_costo" class="lotes_mon_costo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->mon_costo->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->mon_costo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->mon_costo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->mon_venta->Visible) { // mon_venta ?>
	<?php if ($lotes_list->SortUrl($lotes_list->mon_venta) == "") { ?>
		<th data-name="mon_venta" class="<?php echo $lotes_list->mon_venta->headerCellClass() ?>"><div id="elh_lotes_mon_venta" class="lotes_mon_venta"><div class="ew-table-header-caption"><?php echo $lotes_list->mon_venta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mon_venta" class="<?php echo $lotes_list->mon_venta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->mon_venta) ?>', 1);"><div id="elh_lotes_mon_venta" class="lotes_mon_venta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->mon_venta->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->mon_venta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->mon_venta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->marca->Visible) { // marca ?>
	<?php if ($lotes_list->SortUrl($lotes_list->marca) == "") { ?>
		<th data-name="marca" class="<?php echo $lotes_list->marca->headerCellClass() ?>"><div id="elh_lotes_marca" class="lotes_marca"><div class="ew-table-header-caption"><?php echo $lotes_list->marca->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marca" class="<?php echo $lotes_list->marca->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->marca) ?>', 1);"><div id="elh_lotes_marca" class="lotes_marca">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->marca->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->marca->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->marca->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->modelo->Visible) { // modelo ?>
	<?php if ($lotes_list->SortUrl($lotes_list->modelo) == "") { ?>
		<th data-name="modelo" class="<?php echo $lotes_list->modelo->headerCellClass() ?>"><div id="elh_lotes_modelo" class="lotes_modelo"><div class="ew-table-header-caption"><?php echo $lotes_list->modelo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="modelo" class="<?php echo $lotes_list->modelo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->modelo) ?>', 1);"><div id="elh_lotes_modelo" class="lotes_modelo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->modelo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->modelo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->modelo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->color->Visible) { // color ?>
	<?php if ($lotes_list->SortUrl($lotes_list->color) == "") { ?>
		<th data-name="color" class="<?php echo $lotes_list->color->headerCellClass() ?>"><div id="elh_lotes_color" class="lotes_color"><div class="ew-table-header-caption"><?php echo $lotes_list->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $lotes_list->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->color) ?>', 1);"><div id="elh_lotes_color" class="lotes_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->color->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->color->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b1->Visible) { // b1 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b1) == "") { ?>
		<th data-name="b1" class="<?php echo $lotes_list->b1->headerCellClass() ?>"><div id="elh_lotes_b1" class="lotes_b1"><div class="ew-table-header-caption"><?php echo $lotes_list->b1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b1" class="<?php echo $lotes_list->b1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b1) ?>', 1);"><div id="elh_lotes_b1" class="lotes_b1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b1->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b2->Visible) { // b2 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b2) == "") { ?>
		<th data-name="b2" class="<?php echo $lotes_list->b2->headerCellClass() ?>"><div id="elh_lotes_b2" class="lotes_b2"><div class="ew-table-header-caption"><?php echo $lotes_list->b2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b2" class="<?php echo $lotes_list->b2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b2) ?>', 1);"><div id="elh_lotes_b2" class="lotes_b2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b2->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b3->Visible) { // b3 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b3) == "") { ?>
		<th data-name="b3" class="<?php echo $lotes_list->b3->headerCellClass() ?>"><div id="elh_lotes_b3" class="lotes_b3"><div class="ew-table-header-caption"><?php echo $lotes_list->b3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b3" class="<?php echo $lotes_list->b3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b3) ?>', 1);"><div id="elh_lotes_b3" class="lotes_b3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b3->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b4->Visible) { // b4 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b4) == "") { ?>
		<th data-name="b4" class="<?php echo $lotes_list->b4->headerCellClass() ?>"><div id="elh_lotes_b4" class="lotes_b4"><div class="ew-table-header-caption"><?php echo $lotes_list->b4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b4" class="<?php echo $lotes_list->b4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b4) ?>', 1);"><div id="elh_lotes_b4" class="lotes_b4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b4->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b4->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b4->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b5->Visible) { // b5 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b5) == "") { ?>
		<th data-name="b5" class="<?php echo $lotes_list->b5->headerCellClass() ?>"><div id="elh_lotes_b5" class="lotes_b5"><div class="ew-table-header-caption"><?php echo $lotes_list->b5->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b5" class="<?php echo $lotes_list->b5->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b5) ?>', 1);"><div id="elh_lotes_b5" class="lotes_b5">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b5->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b5->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b5->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->b6->Visible) { // b6 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->b6) == "") { ?>
		<th data-name="b6" class="<?php echo $lotes_list->b6->headerCellClass() ?>"><div id="elh_lotes_b6" class="lotes_b6"><div class="ew-table-header-caption"><?php echo $lotes_list->b6->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b6" class="<?php echo $lotes_list->b6->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->b6) ?>', 1);"><div id="elh_lotes_b6" class="lotes_b6">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->b6->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->b6->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->b6->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->cat_pro->Visible) { // cat_pro ?>
	<?php if ($lotes_list->SortUrl($lotes_list->cat_pro) == "") { ?>
		<th data-name="cat_pro" class="<?php echo $lotes_list->cat_pro->headerCellClass() ?>"><div id="elh_lotes_cat_pro" class="lotes_cat_pro"><div class="ew-table-header-caption"><?php echo $lotes_list->cat_pro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cat_pro" class="<?php echo $lotes_list->cat_pro->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->cat_pro) ?>', 1);"><div id="elh_lotes_cat_pro" class="lotes_cat_pro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->cat_pro->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->cat_pro->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->cat_pro->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->pro_ser->Visible) { // pro_ser ?>
	<?php if ($lotes_list->SortUrl($lotes_list->pro_ser) == "") { ?>
		<th data-name="pro_ser" class="<?php echo $lotes_list->pro_ser->headerCellClass() ?>"><div id="elh_lotes_pro_ser" class="lotes_pro_ser"><div class="ew-table-header-caption"><?php echo $lotes_list->pro_ser->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pro_ser" class="<?php echo $lotes_list->pro_ser->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->pro_ser) ?>', 1);"><div id="elh_lotes_pro_ser" class="lotes_pro_ser">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->pro_ser->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->pro_ser->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->pro_ser->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->foto1->Visible) { // foto1 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->foto1) == "") { ?>
		<th data-name="foto1" class="<?php echo $lotes_list->foto1->headerCellClass() ?>"><div id="elh_lotes_foto1" class="lotes_foto1"><div class="ew-table-header-caption"><?php echo $lotes_list->foto1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto1" class="<?php echo $lotes_list->foto1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->foto1) ?>', 1);"><div id="elh_lotes_foto1" class="lotes_foto1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->foto1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->foto1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->foto1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->foto2->Visible) { // foto2 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->foto2) == "") { ?>
		<th data-name="foto2" class="<?php echo $lotes_list->foto2->headerCellClass() ?>"><div id="elh_lotes_foto2" class="lotes_foto2"><div class="ew-table-header-caption"><?php echo $lotes_list->foto2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto2" class="<?php echo $lotes_list->foto2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->foto2) ?>', 1);"><div id="elh_lotes_foto2" class="lotes_foto2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->foto2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->foto2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->foto2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->foto3->Visible) { // foto3 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->foto3) == "") { ?>
		<th data-name="foto3" class="<?php echo $lotes_list->foto3->headerCellClass() ?>"><div id="elh_lotes_foto3" class="lotes_foto3"><div class="ew-table-header-caption"><?php echo $lotes_list->foto3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto3" class="<?php echo $lotes_list->foto3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->foto3) ?>', 1);"><div id="elh_lotes_foto3" class="lotes_foto3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->foto3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->foto3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->foto3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->foto4->Visible) { // foto4 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->foto4) == "") { ?>
		<th data-name="foto4" class="<?php echo $lotes_list->foto4->headerCellClass() ?>"><div id="elh_lotes_foto4" class="lotes_foto4"><div class="ew-table-header-caption"><?php echo $lotes_list->foto4->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="foto4" class="<?php echo $lotes_list->foto4->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->foto4) ?>', 1);"><div id="elh_lotes_foto4" class="lotes_foto4">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->foto4->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->foto4->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->foto4->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->web->Visible) { // web ?>
	<?php if ($lotes_list->SortUrl($lotes_list->web) == "") { ?>
		<th data-name="web" class="<?php echo $lotes_list->web->headerCellClass() ?>"><div id="elh_lotes_web" class="lotes_web"><div class="ew-table-header-caption"><?php echo $lotes_list->web->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="web" class="<?php echo $lotes_list->web->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->web) ?>', 1);"><div id="elh_lotes_web" class="lotes_web">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->web->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->web->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->web->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->pre_web->Visible) { // pre_web ?>
	<?php if ($lotes_list->SortUrl($lotes_list->pre_web) == "") { ?>
		<th data-name="pre_web" class="<?php echo $lotes_list->pre_web->headerCellClass() ?>"><div id="elh_lotes_pre_web" class="lotes_pre_web"><div class="ew-table-header-caption"><?php echo $lotes_list->pre_web->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pre_web" class="<?php echo $lotes_list->pre_web->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->pre_web) ?>', 1);"><div id="elh_lotes_pre_web" class="lotes_pre_web">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->pre_web->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->pre_web->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->pre_web->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->megusta->Visible) { // megusta ?>
	<?php if ($lotes_list->SortUrl($lotes_list->megusta) == "") { ?>
		<th data-name="megusta" class="<?php echo $lotes_list->megusta->headerCellClass() ?>"><div id="elh_lotes_megusta" class="lotes_megusta"><div class="ew-table-header-caption"><?php echo $lotes_list->megusta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="megusta" class="<?php echo $lotes_list->megusta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->megusta) ?>', 1);"><div id="elh_lotes_megusta" class="lotes_megusta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->megusta->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->megusta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->megusta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->nomegusta->Visible) { // nomegusta ?>
	<?php if ($lotes_list->SortUrl($lotes_list->nomegusta) == "") { ?>
		<th data-name="nomegusta" class="<?php echo $lotes_list->nomegusta->headerCellClass() ?>"><div id="elh_lotes_nomegusta" class="lotes_nomegusta"><div class="ew-table-header-caption"><?php echo $lotes_list->nomegusta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nomegusta" class="<?php echo $lotes_list->nomegusta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->nomegusta) ?>', 1);"><div id="elh_lotes_nomegusta" class="lotes_nomegusta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->nomegusta->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->nomegusta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->nomegusta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->precio2->Visible) { // precio2 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->precio2) == "") { ?>
		<th data-name="precio2" class="<?php echo $lotes_list->precio2->headerCellClass() ?>"><div id="elh_lotes_precio2" class="lotes_precio2"><div class="ew-table-header-caption"><?php echo $lotes_list->precio2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio2" class="<?php echo $lotes_list->precio2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->precio2) ?>', 1);"><div id="elh_lotes_precio2" class="lotes_precio2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->precio2->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->precio2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->precio2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->precio3->Visible) { // precio3 ?>
	<?php if ($lotes_list->SortUrl($lotes_list->precio3) == "") { ?>
		<th data-name="precio3" class="<?php echo $lotes_list->precio3->headerCellClass() ?>"><div id="elh_lotes_precio3" class="lotes_precio3"><div class="ew-table-header-caption"><?php echo $lotes_list->precio3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="precio3" class="<?php echo $lotes_list->precio3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->precio3) ?>', 1);"><div id="elh_lotes_precio3" class="lotes_precio3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->precio3->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->precio3->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->precio3->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->und_pro->Visible) { // und_pro ?>
	<?php if ($lotes_list->SortUrl($lotes_list->und_pro) == "") { ?>
		<th data-name="und_pro" class="<?php echo $lotes_list->und_pro->headerCellClass() ?>"><div id="elh_lotes_und_pro" class="lotes_und_pro"><div class="ew-table-header-caption"><?php echo $lotes_list->und_pro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="und_pro" class="<?php echo $lotes_list->und_pro->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->und_pro) ?>', 1);"><div id="elh_lotes_und_pro" class="lotes_und_pro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->und_pro->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->und_pro->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->und_pro->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->barras->Visible) { // barras ?>
	<?php if ($lotes_list->SortUrl($lotes_list->barras) == "") { ?>
		<th data-name="barras" class="<?php echo $lotes_list->barras->headerCellClass() ?>"><div id="elh_lotes_barras" class="lotes_barras"><div class="ew-table-header-caption"><?php echo $lotes_list->barras->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="barras" class="<?php echo $lotes_list->barras->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->barras) ?>', 1);"><div id="elh_lotes_barras" class="lotes_barras">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->barras->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->barras->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->barras->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->stockmin->Visible) { // stockmin ?>
	<?php if ($lotes_list->SortUrl($lotes_list->stockmin) == "") { ?>
		<th data-name="stockmin" class="<?php echo $lotes_list->stockmin->headerCellClass() ?>"><div id="elh_lotes_stockmin" class="lotes_stockmin"><div class="ew-table-header-caption"><?php echo $lotes_list->stockmin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stockmin" class="<?php echo $lotes_list->stockmin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->stockmin) ?>', 1);"><div id="elh_lotes_stockmin" class="lotes_stockmin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->stockmin->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->stockmin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->stockmin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->id_grupo->Visible) { // id_grupo ?>
	<?php if ($lotes_list->SortUrl($lotes_list->id_grupo) == "") { ?>
		<th data-name="id_grupo" class="<?php echo $lotes_list->id_grupo->headerCellClass() ?>"><div id="elh_lotes_id_grupo" class="lotes_id_grupo"><div class="ew-table-header-caption"><?php echo $lotes_list->id_grupo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_grupo" class="<?php echo $lotes_list->id_grupo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->id_grupo) ?>', 1);"><div id="elh_lotes_id_grupo" class="lotes_id_grupo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->id_grupo->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->id_grupo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->id_grupo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->talla->Visible) { // talla ?>
	<?php if ($lotes_list->SortUrl($lotes_list->talla) == "") { ?>
		<th data-name="talla" class="<?php echo $lotes_list->talla->headerCellClass() ?>"><div id="elh_lotes_talla" class="lotes_talla"><div class="ew-table-header-caption"><?php echo $lotes_list->talla->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="talla" class="<?php echo $lotes_list->talla->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->talla) ?>', 1);"><div id="elh_lotes_talla" class="lotes_talla">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->talla->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->talla->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->talla->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->mostrarcolor->Visible) { // mostrarcolor ?>
	<?php if ($lotes_list->SortUrl($lotes_list->mostrarcolor) == "") { ?>
		<th data-name="mostrarcolor" class="<?php echo $lotes_list->mostrarcolor->headerCellClass() ?>"><div id="elh_lotes_mostrarcolor" class="lotes_mostrarcolor"><div class="ew-table-header-caption"><?php echo $lotes_list->mostrarcolor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mostrarcolor" class="<?php echo $lotes_list->mostrarcolor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->mostrarcolor) ?>', 1);"><div id="elh_lotes_mostrarcolor" class="lotes_mostrarcolor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->mostrarcolor->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->mostrarcolor->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->mostrarcolor->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->lote->Visible) { // lote ?>
	<?php if ($lotes_list->SortUrl($lotes_list->lote) == "") { ?>
		<th data-name="lote" class="<?php echo $lotes_list->lote->headerCellClass() ?>"><div id="elh_lotes_lote" class="lotes_lote"><div class="ew-table-header-caption"><?php echo $lotes_list->lote->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lote" class="<?php echo $lotes_list->lote->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->lote) ?>', 1);"><div id="elh_lotes_lote" class="lotes_lote">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->lote->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->lote->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->lote->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->manzana->Visible) { // manzana ?>
	<?php if ($lotes_list->SortUrl($lotes_list->manzana) == "") { ?>
		<th data-name="manzana" class="<?php echo $lotes_list->manzana->headerCellClass() ?>"><div id="elh_lotes_manzana" class="lotes_manzana"><div class="ew-table-header-caption"><?php echo $lotes_list->manzana->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="manzana" class="<?php echo $lotes_list->manzana->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->manzana) ?>', 1);"><div id="elh_lotes_manzana" class="lotes_manzana">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->manzana->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->manzana->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->manzana->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->etapa->Visible) { // etapa ?>
	<?php if ($lotes_list->SortUrl($lotes_list->etapa) == "") { ?>
		<th data-name="etapa" class="<?php echo $lotes_list->etapa->headerCellClass() ?>"><div id="elh_lotes_etapa" class="lotes_etapa"><div class="ew-table-header-caption"><?php echo $lotes_list->etapa->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="etapa" class="<?php echo $lotes_list->etapa->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->etapa) ?>', 1);"><div id="elh_lotes_etapa" class="lotes_etapa">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->etapa->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->etapa->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->etapa->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->estado->Visible) { // estado ?>
	<?php if ($lotes_list->SortUrl($lotes_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $lotes_list->estado->headerCellClass() ?>"><div id="elh_lotes_estado" class="lotes_estado"><div class="ew-table-header-caption"><?php echo $lotes_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $lotes_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->estado) ?>', 1);"><div id="elh_lotes_estado" class="lotes_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->icon->Visible) { // icon ?>
	<?php if ($lotes_list->SortUrl($lotes_list->icon) == "") { ?>
		<th data-name="icon" class="<?php echo $lotes_list->icon->headerCellClass() ?>"><div id="elh_lotes_icon" class="lotes_icon"><div class="ew-table-header-caption"><?php echo $lotes_list->icon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="icon" class="<?php echo $lotes_list->icon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->icon) ?>', 1);"><div id="elh_lotes_icon" class="lotes_icon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->icon->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->icon->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->icon->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->topy->Visible) { // topy ?>
	<?php if ($lotes_list->SortUrl($lotes_list->topy) == "") { ?>
		<th data-name="topy" class="<?php echo $lotes_list->topy->headerCellClass() ?>"><div id="elh_lotes_topy" class="lotes_topy"><div class="ew-table-header-caption"><?php echo $lotes_list->topy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="topy" class="<?php echo $lotes_list->topy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->topy) ?>', 1);"><div id="elh_lotes_topy" class="lotes_topy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->topy->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->topy->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->topy->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->leftx->Visible) { // leftx ?>
	<?php if ($lotes_list->SortUrl($lotes_list->leftx) == "") { ?>
		<th data-name="leftx" class="<?php echo $lotes_list->leftx->headerCellClass() ?>"><div id="elh_lotes_leftx" class="lotes_leftx"><div class="ew-table-header-caption"><?php echo $lotes_list->leftx->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="leftx" class="<?php echo $lotes_list->leftx->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->leftx) ?>', 1);"><div id="elh_lotes_leftx" class="lotes_leftx">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->leftx->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->leftx->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->leftx->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->codlogin->Visible) { // codlogin ?>
	<?php if ($lotes_list->SortUrl($lotes_list->codlogin) == "") { ?>
		<th data-name="codlogin" class="<?php echo $lotes_list->codlogin->headerCellClass() ?>"><div id="elh_lotes_codlogin" class="lotes_codlogin"><div class="ew-table-header-caption"><?php echo $lotes_list->codlogin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codlogin" class="<?php echo $lotes_list->codlogin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->codlogin) ?>', 1);"><div id="elh_lotes_codlogin" class="lotes_codlogin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->codlogin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->codlogin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->codlogin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lotes_list->id_cliente->Visible) { // id_cliente ?>
	<?php if ($lotes_list->SortUrl($lotes_list->id_cliente) == "") { ?>
		<th data-name="id_cliente" class="<?php echo $lotes_list->id_cliente->headerCellClass() ?>"><div id="elh_lotes_id_cliente" class="lotes_id_cliente"><div class="ew-table-header-caption"><?php echo $lotes_list->id_cliente->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_cliente" class="<?php echo $lotes_list->id_cliente->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $lotes_list->SortUrl($lotes_list->id_cliente) ?>', 1);"><div id="elh_lotes_id_cliente" class="lotes_id_cliente">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lotes_list->id_cliente->caption() ?></span><span class="ew-table-header-sort"><?php if ($lotes_list->id_cliente->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($lotes_list->id_cliente->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lotes_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($lotes_list->ExportAll && $lotes_list->isExport()) {
	$lotes_list->StopRecord = $lotes_list->TotalRecords;
} else {

	// Set the last record to display
	if ($lotes_list->TotalRecords > $lotes_list->StartRecord + $lotes_list->DisplayRecords - 1)
		$lotes_list->StopRecord = $lotes_list->StartRecord + $lotes_list->DisplayRecords - 1;
	else
		$lotes_list->StopRecord = $lotes_list->TotalRecords;
}
$lotes_list->RecordCount = $lotes_list->StartRecord - 1;
if ($lotes_list->Recordset && !$lotes_list->Recordset->EOF) {
	$lotes_list->Recordset->moveFirst();
	$selectLimit = $lotes_list->UseSelectLimit;
	if (!$selectLimit && $lotes_list->StartRecord > 1)
		$lotes_list->Recordset->move($lotes_list->StartRecord - 1);
} elseif (!$lotes->AllowAddDeleteRow && $lotes_list->StopRecord == 0) {
	$lotes_list->StopRecord = $lotes->GridAddRowCount;
}

// Initialize aggregate
$lotes->RowType = ROWTYPE_AGGREGATEINIT;
$lotes->resetAttributes();
$lotes_list->renderRow();
while ($lotes_list->RecordCount < $lotes_list->StopRecord) {
	$lotes_list->RecordCount++;
	if ($lotes_list->RecordCount >= $lotes_list->StartRecord) {
		$lotes_list->RowCount++;

		// Set up key count
		$lotes_list->KeyCount = $lotes_list->RowIndex;

		// Init row class and style
		$lotes->resetAttributes();
		$lotes->CssClass = "";
		if ($lotes_list->isGridAdd()) {
		} else {
			$lotes_list->loadRowValues($lotes_list->Recordset); // Load row values
		}
		$lotes->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$lotes->RowAttrs->merge(["data-rowindex" => $lotes_list->RowCount, "id" => "r" . $lotes_list->RowCount . "_lotes", "data-rowtype" => $lotes->RowType]);

		// Render row
		$lotes_list->renderRow();

		// Render list options
		$lotes_list->renderListOptions();
?>
	<tr <?php echo $lotes->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lotes_list->ListOptions->render("body", "left", $lotes_list->RowCount);
?>
	<?php if ($lotes_list->id_producto->Visible) { // id_producto ?>
		<td data-name="id_producto" <?php echo $lotes_list->id_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_id_producto" class="lotes_id_producto">
<span<?php echo $lotes_list->id_producto->viewAttributes() ?>><?php echo $lotes_list->id_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->id_proyecto->Visible) { // id_proyecto ?>
		<td data-name="id_proyecto" <?php echo $lotes_list->id_proyecto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_id_proyecto" class="lotes_id_proyecto">
<span<?php echo $lotes_list->id_proyecto->viewAttributes() ?>><?php echo $lotes_list->id_proyecto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->codigo_producto->Visible) { // codigo_producto ?>
		<td data-name="codigo_producto" <?php echo $lotes_list->codigo_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_codigo_producto" class="lotes_codigo_producto">
<span<?php echo $lotes_list->codigo_producto->viewAttributes() ?>><?php echo $lotes_list->codigo_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->nombre_producto->Visible) { // nombre_producto ?>
		<td data-name="nombre_producto" <?php echo $lotes_list->nombre_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_nombre_producto" class="lotes_nombre_producto">
<span<?php echo $lotes_list->nombre_producto->viewAttributes() ?>><?php echo $lotes_list->nombre_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->status_producto->Visible) { // status_producto ?>
		<td data-name="status_producto" <?php echo $lotes_list->status_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_status_producto" class="lotes_status_producto">
<span<?php echo $lotes_list->status_producto->viewAttributes() ?>><?php echo $lotes_list->status_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->date_added->Visible) { // date_added ?>
		<td data-name="date_added" <?php echo $lotes_list->date_added->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_date_added" class="lotes_date_added">
<span<?php echo $lotes_list->date_added->viewAttributes() ?>><?php echo $lotes_list->date_added->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->precio_producto->Visible) { // precio_producto ?>
		<td data-name="precio_producto" <?php echo $lotes_list->precio_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_precio_producto" class="lotes_precio_producto">
<span<?php echo $lotes_list->precio_producto->viewAttributes() ?>><?php echo $lotes_list->precio_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->costo_producto->Visible) { // costo_producto ?>
		<td data-name="costo_producto" <?php echo $lotes_list->costo_producto->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_costo_producto" class="lotes_costo_producto">
<span<?php echo $lotes_list->costo_producto->viewAttributes() ?>><?php echo $lotes_list->costo_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->mon_costo->Visible) { // mon_costo ?>
		<td data-name="mon_costo" <?php echo $lotes_list->mon_costo->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_mon_costo" class="lotes_mon_costo">
<span<?php echo $lotes_list->mon_costo->viewAttributes() ?>><?php echo $lotes_list->mon_costo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->mon_venta->Visible) { // mon_venta ?>
		<td data-name="mon_venta" <?php echo $lotes_list->mon_venta->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_mon_venta" class="lotes_mon_venta">
<span<?php echo $lotes_list->mon_venta->viewAttributes() ?>><?php echo $lotes_list->mon_venta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->marca->Visible) { // marca ?>
		<td data-name="marca" <?php echo $lotes_list->marca->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_marca" class="lotes_marca">
<span<?php echo $lotes_list->marca->viewAttributes() ?>><?php echo $lotes_list->marca->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->modelo->Visible) { // modelo ?>
		<td data-name="modelo" <?php echo $lotes_list->modelo->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_modelo" class="lotes_modelo">
<span<?php echo $lotes_list->modelo->viewAttributes() ?>><?php echo $lotes_list->modelo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->color->Visible) { // color ?>
		<td data-name="color" <?php echo $lotes_list->color->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_color" class="lotes_color">
<span<?php echo $lotes_list->color->viewAttributes() ?>><?php echo $lotes_list->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b1->Visible) { // b1 ?>
		<td data-name="b1" <?php echo $lotes_list->b1->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b1" class="lotes_b1">
<span<?php echo $lotes_list->b1->viewAttributes() ?>><?php echo $lotes_list->b1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b2->Visible) { // b2 ?>
		<td data-name="b2" <?php echo $lotes_list->b2->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b2" class="lotes_b2">
<span<?php echo $lotes_list->b2->viewAttributes() ?>><?php echo $lotes_list->b2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b3->Visible) { // b3 ?>
		<td data-name="b3" <?php echo $lotes_list->b3->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b3" class="lotes_b3">
<span<?php echo $lotes_list->b3->viewAttributes() ?>><?php echo $lotes_list->b3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b4->Visible) { // b4 ?>
		<td data-name="b4" <?php echo $lotes_list->b4->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b4" class="lotes_b4">
<span<?php echo $lotes_list->b4->viewAttributes() ?>><?php echo $lotes_list->b4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b5->Visible) { // b5 ?>
		<td data-name="b5" <?php echo $lotes_list->b5->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b5" class="lotes_b5">
<span<?php echo $lotes_list->b5->viewAttributes() ?>><?php echo $lotes_list->b5->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->b6->Visible) { // b6 ?>
		<td data-name="b6" <?php echo $lotes_list->b6->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_b6" class="lotes_b6">
<span<?php echo $lotes_list->b6->viewAttributes() ?>><?php echo $lotes_list->b6->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->cat_pro->Visible) { // cat_pro ?>
		<td data-name="cat_pro" <?php echo $lotes_list->cat_pro->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_cat_pro" class="lotes_cat_pro">
<span<?php echo $lotes_list->cat_pro->viewAttributes() ?>><?php echo $lotes_list->cat_pro->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->pro_ser->Visible) { // pro_ser ?>
		<td data-name="pro_ser" <?php echo $lotes_list->pro_ser->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_pro_ser" class="lotes_pro_ser">
<span<?php echo $lotes_list->pro_ser->viewAttributes() ?>><?php echo $lotes_list->pro_ser->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->foto1->Visible) { // foto1 ?>
		<td data-name="foto1" <?php echo $lotes_list->foto1->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_foto1" class="lotes_foto1">
<span<?php echo $lotes_list->foto1->viewAttributes() ?>><?php echo $lotes_list->foto1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->foto2->Visible) { // foto2 ?>
		<td data-name="foto2" <?php echo $lotes_list->foto2->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_foto2" class="lotes_foto2">
<span<?php echo $lotes_list->foto2->viewAttributes() ?>><?php echo $lotes_list->foto2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->foto3->Visible) { // foto3 ?>
		<td data-name="foto3" <?php echo $lotes_list->foto3->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_foto3" class="lotes_foto3">
<span<?php echo $lotes_list->foto3->viewAttributes() ?>><?php echo $lotes_list->foto3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->foto4->Visible) { // foto4 ?>
		<td data-name="foto4" <?php echo $lotes_list->foto4->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_foto4" class="lotes_foto4">
<span<?php echo $lotes_list->foto4->viewAttributes() ?>><?php echo $lotes_list->foto4->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->web->Visible) { // web ?>
		<td data-name="web" <?php echo $lotes_list->web->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_web" class="lotes_web">
<span<?php echo $lotes_list->web->viewAttributes() ?>><?php echo $lotes_list->web->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->pre_web->Visible) { // pre_web ?>
		<td data-name="pre_web" <?php echo $lotes_list->pre_web->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_pre_web" class="lotes_pre_web">
<span<?php echo $lotes_list->pre_web->viewAttributes() ?>><?php echo $lotes_list->pre_web->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->megusta->Visible) { // megusta ?>
		<td data-name="megusta" <?php echo $lotes_list->megusta->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_megusta" class="lotes_megusta">
<span<?php echo $lotes_list->megusta->viewAttributes() ?>><?php echo $lotes_list->megusta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->nomegusta->Visible) { // nomegusta ?>
		<td data-name="nomegusta" <?php echo $lotes_list->nomegusta->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_nomegusta" class="lotes_nomegusta">
<span<?php echo $lotes_list->nomegusta->viewAttributes() ?>><?php echo $lotes_list->nomegusta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->precio2->Visible) { // precio2 ?>
		<td data-name="precio2" <?php echo $lotes_list->precio2->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_precio2" class="lotes_precio2">
<span<?php echo $lotes_list->precio2->viewAttributes() ?>><?php echo $lotes_list->precio2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->precio3->Visible) { // precio3 ?>
		<td data-name="precio3" <?php echo $lotes_list->precio3->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_precio3" class="lotes_precio3">
<span<?php echo $lotes_list->precio3->viewAttributes() ?>><?php echo $lotes_list->precio3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->und_pro->Visible) { // und_pro ?>
		<td data-name="und_pro" <?php echo $lotes_list->und_pro->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_und_pro" class="lotes_und_pro">
<span<?php echo $lotes_list->und_pro->viewAttributes() ?>><?php echo $lotes_list->und_pro->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->barras->Visible) { // barras ?>
		<td data-name="barras" <?php echo $lotes_list->barras->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_barras" class="lotes_barras">
<span<?php echo $lotes_list->barras->viewAttributes() ?>><?php echo $lotes_list->barras->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->stockmin->Visible) { // stockmin ?>
		<td data-name="stockmin" <?php echo $lotes_list->stockmin->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_stockmin" class="lotes_stockmin">
<span<?php echo $lotes_list->stockmin->viewAttributes() ?>><?php echo $lotes_list->stockmin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->id_grupo->Visible) { // id_grupo ?>
		<td data-name="id_grupo" <?php echo $lotes_list->id_grupo->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_id_grupo" class="lotes_id_grupo">
<span<?php echo $lotes_list->id_grupo->viewAttributes() ?>><?php echo $lotes_list->id_grupo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->talla->Visible) { // talla ?>
		<td data-name="talla" <?php echo $lotes_list->talla->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_talla" class="lotes_talla">
<span<?php echo $lotes_list->talla->viewAttributes() ?>><?php echo $lotes_list->talla->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->mostrarcolor->Visible) { // mostrarcolor ?>
		<td data-name="mostrarcolor" <?php echo $lotes_list->mostrarcolor->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_mostrarcolor" class="lotes_mostrarcolor">
<span<?php echo $lotes_list->mostrarcolor->viewAttributes() ?>><?php echo $lotes_list->mostrarcolor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->lote->Visible) { // lote ?>
		<td data-name="lote" <?php echo $lotes_list->lote->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_lote" class="lotes_lote">
<span<?php echo $lotes_list->lote->viewAttributes() ?>><?php echo $lotes_list->lote->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->manzana->Visible) { // manzana ?>
		<td data-name="manzana" <?php echo $lotes_list->manzana->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_manzana" class="lotes_manzana">
<span<?php echo $lotes_list->manzana->viewAttributes() ?>><?php echo $lotes_list->manzana->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->etapa->Visible) { // etapa ?>
		<td data-name="etapa" <?php echo $lotes_list->etapa->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_etapa" class="lotes_etapa">
<span<?php echo $lotes_list->etapa->viewAttributes() ?>><?php echo $lotes_list->etapa->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $lotes_list->estado->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_estado" class="lotes_estado">
<span<?php echo $lotes_list->estado->viewAttributes() ?>><?php echo $lotes_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->icon->Visible) { // icon ?>
		<td data-name="icon" <?php echo $lotes_list->icon->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_icon" class="lotes_icon">
<span<?php echo $lotes_list->icon->viewAttributes() ?>><?php echo $lotes_list->icon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->topy->Visible) { // topy ?>
		<td data-name="topy" <?php echo $lotes_list->topy->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_topy" class="lotes_topy">
<span<?php echo $lotes_list->topy->viewAttributes() ?>><?php echo $lotes_list->topy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->leftx->Visible) { // leftx ?>
		<td data-name="leftx" <?php echo $lotes_list->leftx->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_leftx" class="lotes_leftx">
<span<?php echo $lotes_list->leftx->viewAttributes() ?>><?php echo $lotes_list->leftx->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->codlogin->Visible) { // codlogin ?>
		<td data-name="codlogin" <?php echo $lotes_list->codlogin->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_codlogin" class="lotes_codlogin">
<span<?php echo $lotes_list->codlogin->viewAttributes() ?>><?php echo $lotes_list->codlogin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lotes_list->id_cliente->Visible) { // id_cliente ?>
		<td data-name="id_cliente" <?php echo $lotes_list->id_cliente->cellAttributes() ?>>
<span id="el<?php echo $lotes_list->RowCount ?>_lotes_id_cliente" class="lotes_id_cliente">
<span<?php echo $lotes_list->id_cliente->viewAttributes() ?>><?php echo $lotes_list->id_cliente->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lotes_list->ListOptions->render("body", "right", $lotes_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$lotes_list->isGridAdd())
		$lotes_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$lotes->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($lotes_list->Recordset)
	$lotes_list->Recordset->Close();
?>
<?php if (!$lotes_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$lotes_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $lotes_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lotes_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lotes_list->TotalRecords == 0 && !$lotes->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lotes_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lotes_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$lotes_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$lotes_list->terminate();
?>