<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$pais_list = new pais_list();

// Run the page
$pais_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pais_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$pais_list->isExport()) { ?>
<script>
var fpaislist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fpaislist = currentForm = new ew.Form("fpaislist", "list");
	fpaislist.formKeyCountName = '<?php echo $pais_list->FormKeyCountName ?>';
	loadjs.done("fpaislist");
});
var fpaislistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fpaislistsrch = currentSearchForm = new ew.Form("fpaislistsrch");

	// Dynamic selection lists
	// Filters

	fpaislistsrch.filterList = <?php echo $pais_list->getFilterList() ?>;
	loadjs.done("fpaislistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$pais_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($pais_list->TotalRecords > 0 && $pais_list->ExportOptions->visible()) { ?>
<?php $pais_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($pais_list->ImportOptions->visible()) { ?>
<?php $pais_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($pais_list->SearchOptions->visible()) { ?>
<?php $pais_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($pais_list->FilterOptions->visible()) { ?>
<?php $pais_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$pais_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$pais_list->isExport() && !$pais->CurrentAction) { ?>
<form name="fpaislistsrch" id="fpaislistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fpaislistsrch-search-panel" class="<?php echo $pais_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="pais">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $pais_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($pais_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($pais_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $pais_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($pais_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($pais_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($pais_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($pais_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $pais_list->showPageHeader(); ?>
<?php
$pais_list->showMessage();
?>
<?php if ($pais_list->TotalRecords > 0 || $pais->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($pais_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> pais">
<form name="fpaislist" id="fpaislist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="pais">
<div id="gmp_pais" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($pais_list->TotalRecords > 0 || $pais_list->isGridEdit()) { ?>
<table id="tbl_paislist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$pais->RowType = ROWTYPE_HEADER;

// Render list options
$pais_list->renderListOptions();

// Render list options (header, left)
$pais_list->ListOptions->render("header", "left");
?>
<?php if ($pais_list->id->Visible) { // id ?>
	<?php if ($pais_list->SortUrl($pais_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $pais_list->id->headerCellClass() ?>"><div id="elh_pais_id" class="pais_id"><div class="ew-table-header-caption"><?php echo $pais_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $pais_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $pais_list->SortUrl($pais_list->id) ?>', 1);"><div id="elh_pais_id" class="pais_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pais_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($pais_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($pais_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pais_list->iso->Visible) { // iso ?>
	<?php if ($pais_list->SortUrl($pais_list->iso) == "") { ?>
		<th data-name="iso" class="<?php echo $pais_list->iso->headerCellClass() ?>"><div id="elh_pais_iso" class="pais_iso"><div class="ew-table-header-caption"><?php echo $pais_list->iso->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iso" class="<?php echo $pais_list->iso->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $pais_list->SortUrl($pais_list->iso) ?>', 1);"><div id="elh_pais_iso" class="pais_iso">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pais_list->iso->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pais_list->iso->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($pais_list->iso->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($pais_list->nombre->Visible) { // nombre ?>
	<?php if ($pais_list->SortUrl($pais_list->nombre) == "") { ?>
		<th data-name="nombre" class="<?php echo $pais_list->nombre->headerCellClass() ?>"><div id="elh_pais_nombre" class="pais_nombre"><div class="ew-table-header-caption"><?php echo $pais_list->nombre->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre" class="<?php echo $pais_list->nombre->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $pais_list->SortUrl($pais_list->nombre) ?>', 1);"><div id="elh_pais_nombre" class="pais_nombre">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $pais_list->nombre->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($pais_list->nombre->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($pais_list->nombre->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$pais_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($pais_list->ExportAll && $pais_list->isExport()) {
	$pais_list->StopRecord = $pais_list->TotalRecords;
} else {

	// Set the last record to display
	if ($pais_list->TotalRecords > $pais_list->StartRecord + $pais_list->DisplayRecords - 1)
		$pais_list->StopRecord = $pais_list->StartRecord + $pais_list->DisplayRecords - 1;
	else
		$pais_list->StopRecord = $pais_list->TotalRecords;
}
$pais_list->RecordCount = $pais_list->StartRecord - 1;
if ($pais_list->Recordset && !$pais_list->Recordset->EOF) {
	$pais_list->Recordset->moveFirst();
	$selectLimit = $pais_list->UseSelectLimit;
	if (!$selectLimit && $pais_list->StartRecord > 1)
		$pais_list->Recordset->move($pais_list->StartRecord - 1);
} elseif (!$pais->AllowAddDeleteRow && $pais_list->StopRecord == 0) {
	$pais_list->StopRecord = $pais->GridAddRowCount;
}

// Initialize aggregate
$pais->RowType = ROWTYPE_AGGREGATEINIT;
$pais->resetAttributes();
$pais_list->renderRow();
while ($pais_list->RecordCount < $pais_list->StopRecord) {
	$pais_list->RecordCount++;
	if ($pais_list->RecordCount >= $pais_list->StartRecord) {
		$pais_list->RowCount++;

		// Set up key count
		$pais_list->KeyCount = $pais_list->RowIndex;

		// Init row class and style
		$pais->resetAttributes();
		$pais->CssClass = "";
		if ($pais_list->isGridAdd()) {
		} else {
			$pais_list->loadRowValues($pais_list->Recordset); // Load row values
		}
		$pais->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$pais->RowAttrs->merge(["data-rowindex" => $pais_list->RowCount, "id" => "r" . $pais_list->RowCount . "_pais", "data-rowtype" => $pais->RowType]);

		// Render row
		$pais_list->renderRow();

		// Render list options
		$pais_list->renderListOptions();
?>
	<tr <?php echo $pais->rowAttributes() ?>>
<?php

// Render list options (body, left)
$pais_list->ListOptions->render("body", "left", $pais_list->RowCount);
?>
	<?php if ($pais_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $pais_list->id->cellAttributes() ?>>
<span id="el<?php echo $pais_list->RowCount ?>_pais_id" class="pais_id">
<span<?php echo $pais_list->id->viewAttributes() ?>><?php echo $pais_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pais_list->iso->Visible) { // iso ?>
		<td data-name="iso" <?php echo $pais_list->iso->cellAttributes() ?>>
<span id="el<?php echo $pais_list->RowCount ?>_pais_iso" class="pais_iso">
<span<?php echo $pais_list->iso->viewAttributes() ?>><?php echo $pais_list->iso->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($pais_list->nombre->Visible) { // nombre ?>
		<td data-name="nombre" <?php echo $pais_list->nombre->cellAttributes() ?>>
<span id="el<?php echo $pais_list->RowCount ?>_pais_nombre" class="pais_nombre">
<span<?php echo $pais_list->nombre->viewAttributes() ?>><?php echo $pais_list->nombre->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$pais_list->ListOptions->render("body", "right", $pais_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$pais_list->isGridAdd())
		$pais_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$pais->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($pais_list->Recordset)
	$pais_list->Recordset->Close();
?>
<?php if (!$pais_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$pais_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $pais_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $pais_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($pais_list->TotalRecords == 0 && !$pais->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $pais_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$pais_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$pais_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$pais_list->terminate();
?>