<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$procesos_nuevo_edit = new procesos_nuevo_edit();

// Run the page
$procesos_nuevo_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$procesos_nuevo_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fprocesos_nuevoedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fprocesos_nuevoedit = currentForm = new ew.Form("fprocesos_nuevoedit", "edit");

	// Validate form
	fprocesos_nuevoedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($procesos_nuevo_edit->codigo->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->codigo->caption(), $procesos_nuevo_edit->codigo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->codigo_proceso->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_proceso");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->codigo_proceso->caption(), $procesos_nuevo_edit->codigo_proceso->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_codigo_proceso");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($procesos_nuevo_edit->codigo_proceso->errorMessage()) ?>");
			<?php if ($procesos_nuevo_edit->no->Required) { ?>
				elm = this.getElements("x" + infix + "_no");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->no->caption(), $procesos_nuevo_edit->no->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_no");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($procesos_nuevo_edit->no->errorMessage()) ?>");
			<?php if ($procesos_nuevo_edit->usuarios->Required) { ?>
				elm = this.getElements("x" + infix + "_usuarios");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->usuarios->caption(), $procesos_nuevo_edit->usuarios->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_usuarios");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($procesos_nuevo_edit->usuarios->errorMessage()) ?>");
			<?php if ($procesos_nuevo_edit->SEC_EJEC->Required) { ?>
				elm = this.getElements("x" + infix + "_SEC_EJEC");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SEC_EJEC->caption(), $procesos_nuevo_edit->SEC_EJEC->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIPO_MODALIDAD->Required) { ?>
				elm = this.getElements("x" + infix + "_TIPO_MODALIDAD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIPO_MODALIDAD->caption(), $procesos_nuevo_edit->TIPO_MODALIDAD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->SECUENCIA->Required) { ?>
				elm = this.getElements("x" + infix + "_SECUENCIA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SECUENCIA->caption(), $procesos_nuevo_edit->SECUENCIA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->AMBIENTE->Required) { ?>
				elm = this.getElements("x" + infix + "_AMBIENTE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->AMBIENTE->caption(), $procesos_nuevo_edit->AMBIENTE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->RUC_ENTIDAD->Required) { ?>
				elm = this.getElements("x" + infix + "_RUC_ENTIDAD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->RUC_ENTIDAD->caption(), $procesos_nuevo_edit->RUC_ENTIDAD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->LOCAL->Required) { ?>
				elm = this.getElements("x" + infix + "_LOCAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->LOCAL->caption(), $procesos_nuevo_edit->LOCAL->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DEPARTAMENTO->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPARTAMENTO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DEPARTAMENTO->caption(), $procesos_nuevo_edit->DEPARTAMENTO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PROVINCIA->Required) { ?>
				elm = this.getElements("x" + infix + "_PROVINCIA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PROVINCIA->caption(), $procesos_nuevo_edit->PROVINCIA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DISTRITO->Required) { ?>
				elm = this.getElements("x" + infix + "_DISTRITO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DISTRITO->caption(), $procesos_nuevo_edit->DISTRITO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->AREA->Required) { ?>
				elm = this.getElements("x" + infix + "_AREA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->AREA->caption(), $procesos_nuevo_edit->AREA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->OFICINA->Required) { ?>
				elm = this.getElements("x" + infix + "_OFICINA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->OFICINA->caption(), $procesos_nuevo_edit->OFICINA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PISO_OFICINA->Required) { ?>
				elm = this.getElements("x" + infix + "_PISO_OFICINA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PISO_OFICINA->caption(), $procesos_nuevo_edit->PISO_OFICINA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_DOC_IDENT_PERSONAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->caption(), $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->APELLIDO_PATERNO->Required) { ?>
				elm = this.getElements("x" + infix + "_APELLIDO_PATERNO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->APELLIDO_PATERNO->caption(), $procesos_nuevo_edit->APELLIDO_PATERNO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->APELLIDO_MATERNO->Required) { ?>
				elm = this.getElements("x" + infix + "_APELLIDO_MATERNO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->APELLIDO_MATERNO->caption(), $procesos_nuevo_edit->APELLIDO_MATERNO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NOMBRES->Required) { ?>
				elm = this.getElements("x" + infix + "_NOMBRES");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NOMBRES->caption(), $procesos_nuevo_edit->NOMBRES->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->OPERATIVO->Required) { ?>
				elm = this.getElements("x" + infix + "_OPERATIVO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->OPERATIVO->caption(), $procesos_nuevo_edit->OPERATIVO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->Required) { ?>
				elm = this.getElements("x" + infix + "_TIPO_DOC_IDENTIDAD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->caption(), $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->MODALIDAD_CONTRATO->Required) { ?>
				elm = this.getElements("x" + infix + "_MODALIDAD_CONTRATO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->MODALIDAD_CONTRATO->caption(), $procesos_nuevo_edit->MODALIDAD_CONTRATO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CODIGO_PATRIMONIAL->Required) { ?>
				elm = this.getElements("x" + infix + "_CODIGO_PATRIMONIAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CODIGO_PATRIMONIAL->caption(), $procesos_nuevo_edit->CODIGO_PATRIMONIAL->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DENOMINACION_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_DENOMINACION_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DENOMINACION_BIEN->caption(), $procesos_nuevo_edit->DENOMINACION_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIPO_CAUSAL_ALTA->Required) { ?>
				elm = this.getElements("x" + infix + "_TIPO_CAUSAL_ALTA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->caption(), $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_DOC_ADQUISICION->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_DOC_ADQUISICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_DOC_ADQUISICION->caption(), $procesos_nuevo_edit->NRO_DOC_ADQUISICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_ADQUISICION->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_ADQUISICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_ADQUISICION->caption(), $procesos_nuevo_edit->FECHA_ADQUISICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->VALOR_ADQUISICION->Required) { ?>
				elm = this.getElements("x" + infix + "_VALOR_ADQUISICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->VALOR_ADQUISICION->caption(), $procesos_nuevo_edit->VALOR_ADQUISICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_DEPRECIACION->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_DEPRECIACION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_DEPRECIACION->caption(), $procesos_nuevo_edit->FECHA_DEPRECIACION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->Required) { ?>
				elm = this.getElements("x" + infix + "_VALOR_DEPREC_EJERCICIO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->caption(), $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->Required) { ?>
				elm = this.getElements("x" + infix + "_VALOR_DEPREC_ACUMULADO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->caption(), $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->VALOR_NETO->Required) { ?>
				elm = this.getElements("x" + infix + "_VALOR_NETO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->VALOR_NETO->caption(), $procesos_nuevo_edit->VALOR_NETO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIP_USO_CUENTA->Required) { ?>
				elm = this.getElements("x" + infix + "_TIP_USO_CUENTA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIP_USO_CUENTA->caption(), $procesos_nuevo_edit->TIP_USO_CUENTA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIPO_CUENTA->Required) { ?>
				elm = this.getElements("x" + infix + "_TIPO_CUENTA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIPO_CUENTA->caption(), $procesos_nuevo_edit->TIPO_CUENTA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_CUENTA_CONTABLE->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_CUENTA_CONTABLE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->caption(), $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CTA_CON_SEGURO->Required) { ?>
				elm = this.getElements("x" + infix + "_CTA_CON_SEGURO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CTA_CON_SEGURO->caption(), $procesos_nuevo_edit->CTA_CON_SEGURO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ESTADO_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_ESTADO_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ESTADO_BIEN->caption(), $procesos_nuevo_edit->ESTADO_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CONDICION->Required) { ?>
				elm = this.getElements("x" + infix + "_CONDICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CONDICION->caption(), $procesos_nuevo_edit->CONDICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->MARCA->Required) { ?>
				elm = this.getElements("x" + infix + "_MARCA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->MARCA->caption(), $procesos_nuevo_edit->MARCA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->MODELO->Required) { ?>
				elm = this.getElements("x" + infix + "_MODELO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->MODELO->caption(), $procesos_nuevo_edit->MODELO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->TIPO->Required) { ?>
				elm = this.getElements("x" + infix + "_TIPO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->TIPO->caption(), $procesos_nuevo_edit->TIPO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->COLOR->Required) { ?>
				elm = this.getElements("x" + infix + "_COLOR");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->COLOR->caption(), $procesos_nuevo_edit->COLOR->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->SERIE->Required) { ?>
				elm = this.getElements("x" + infix + "_SERIE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SERIE->caption(), $procesos_nuevo_edit->SERIE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DIMENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_DIMENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DIMENSION->caption(), $procesos_nuevo_edit->DIMENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PLACA->Required) { ?>
				elm = this.getElements("x" + infix + "_PLACA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PLACA->caption(), $procesos_nuevo_edit->PLACA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_MOTOR->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_MOTOR");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_MOTOR->caption(), $procesos_nuevo_edit->NRO_MOTOR->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_CHASIS->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_CHASIS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_CHASIS->caption(), $procesos_nuevo_edit->NRO_CHASIS->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->MATRICULA->Required) { ?>
				elm = this.getElements("x" + infix + "_MATRICULA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->MATRICULA->caption(), $procesos_nuevo_edit->MATRICULA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ANIO_FABRICACION->Required) { ?>
				elm = this.getElements("x" + infix + "_ANIO_FABRICACION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ANIO_FABRICACION->caption(), $procesos_nuevo_edit->ANIO_FABRICACION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->LONGITUD->Required) { ?>
				elm = this.getElements("x" + infix + "_LONGITUD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->LONGITUD->caption(), $procesos_nuevo_edit->LONGITUD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ALTURA->Required) { ?>
				elm = this.getElements("x" + infix + "_ALTURA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ALTURA->caption(), $procesos_nuevo_edit->ALTURA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ANCHO->Required) { ?>
				elm = this.getElements("x" + infix + "_ANCHO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ANCHO->caption(), $procesos_nuevo_edit->ANCHO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->RAZA->Required) { ?>
				elm = this.getElements("x" + infix + "_RAZA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->RAZA->caption(), $procesos_nuevo_edit->RAZA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ESPECIE->Required) { ?>
				elm = this.getElements("x" + infix + "_ESPECIE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ESPECIE->caption(), $procesos_nuevo_edit->ESPECIE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->EDAD->Required) { ?>
				elm = this.getElements("x" + infix + "_EDAD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->EDAD->caption(), $procesos_nuevo_edit->EDAD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_PAIS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PAIS->caption(), $procesos_nuevo_edit->PAIS->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->OTRAS_CARACT->Required) { ?>
				elm = this.getElements("x" + infix + "_OTRAS_CARACT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->OTRAS_CARACT->caption(), $procesos_nuevo_edit->OTRAS_CARACT->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_DESCRIPCION_UBICACION_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->caption(), $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CAUSAL_BAJA->Required) { ?>
				elm = this.getElements("x" + infix + "_CAUSAL_BAJA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CAUSAL_BAJA->caption(), $procesos_nuevo_edit->CAUSAL_BAJA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_RESOLUCION_BAJA->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_RESOLUCION_BAJA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->caption(), $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_BAJA->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_BAJA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_BAJA->caption(), $procesos_nuevo_edit->FECHA_BAJA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_ACTO_DISPOSICION_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->caption(), $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NRO_RESOLUCION_DISP->Required) { ?>
				elm = this.getElements("x" + infix + "_NRO_RESOLUCION_DISP");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NRO_RESOLUCION_DISP->caption(), $procesos_nuevo_edit->NRO_RESOLUCION_DISP->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_DISPOSICION->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_DISPOSICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_DISPOSICION->caption(), $procesos_nuevo_edit->FECHA_DISPOSICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Required) { ?>
				elm = this.getElements("x" + infix + "_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption(), $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_MOTIVO_ELIMINACION_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->caption(), $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->Required) { ?>
				elm = this.getElements("x" + infix + "_ACTO_ADMINISTRACION_BIEN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->caption(), $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->Required) { ?>
				elm = this.getElements("x" + infix + "_NUM_RESOLUCION_ADMINISTRACION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->caption(), $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_ADMINISTRACION->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_ADMINISTRACION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_ADMINISTRACION->caption(), $procesos_nuevo_edit->FECHA_ADMINISTRACION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_VENC_ACTO_ADMIN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->caption(), $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Required) { ?>
				elm = this.getElements("x" + infix + "_ENTIDAD_BENEFICIADA_ACTO_ADMIN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption(), $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DOC_ALTA_SBN->Required) { ?>
				elm = this.getElements("x" + infix + "_DOC_ALTA_SBN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DOC_ALTA_SBN->caption(), $procesos_nuevo_edit->DOC_ALTA_SBN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DOC_BAJA_SBN->Required) { ?>
				elm = this.getElements("x" + infix + "_DOC_BAJA_SBN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DOC_BAJA_SBN->caption(), $procesos_nuevo_edit->DOC_BAJA_SBN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->DEPENDENCIAS->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPENDENCIAS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->DEPENDENCIAS->caption(), $procesos_nuevo_edit->DEPENDENCIAS->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NUMERO_FICHA->Required) { ?>
				elm = this.getElements("x" + infix + "_NUMERO_FICHA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NUMERO_FICHA->caption(), $procesos_nuevo_edit->NUMERO_FICHA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CODIGO_INTERNO->Required) { ?>
				elm = this.getElements("x" + infix + "_CODIGO_INTERNO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CODIGO_INTERNO->caption(), $procesos_nuevo_edit->CODIGO_INTERNO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ESTADO->Required) { ?>
				elm = this.getElements("x" + infix + "_ESTADO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ESTADO->caption(), $procesos_nuevo_edit->ESTADO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->USO->Required) { ?>
				elm = this.getElements("x" + infix + "_USO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->USO->caption(), $procesos_nuevo_edit->USO->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->STICKER->Required) { ?>
				elm = this.getElements("x" + infix + "_STICKER");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->STICKER->caption(), $procesos_nuevo_edit->STICKER->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->SEDE->Required) { ?>
				elm = this.getElements("x" + infix + "_SEDE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SEDE->caption(), $procesos_nuevo_edit->SEDE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->SBN->Required) { ?>
				elm = this.getElements("x" + infix + "_SBN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SBN->caption(), $procesos_nuevo_edit->SBN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->ETIQUETA->Required) { ?>
				elm = this.getElements("x" + infix + "_ETIQUETA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->ETIQUETA->caption(), $procesos_nuevo_edit->ETIQUETA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Required) { ?>
				elm = this.getElements("x" + infix + "_NOMBRE_BENEFICIARIO_ACTO_ADMIN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption(), $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PLACA_RODAJE->Required) { ?>
				elm = this.getElements("x" + infix + "_PLACA_RODAJE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PLACA_RODAJE->caption(), $procesos_nuevo_edit->PLACA_RODAJE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CODIGO_ACTUAL->Required) { ?>
				elm = this.getElements("x" + infix + "_CODIGO_ACTUAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CODIGO_ACTUAL->caption(), $procesos_nuevo_edit->CODIGO_ACTUAL->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->CODIGO_ANTERIOR->Required) { ?>
				elm = this.getElements("x" + infix + "_CODIGO_ANTERIOR");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->CODIGO_ANTERIOR->caption(), $procesos_nuevo_edit->CODIGO_ANTERIOR->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->PROPIEDAD->Required) { ?>
				elm = this.getElements("x" + infix + "_PROPIEDAD");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->PROPIEDAD->caption(), $procesos_nuevo_edit->PROPIEDAD->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->SITUACION->Required) { ?>
				elm = this.getElements("x" + infix + "_SITUACION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->SITUACION->caption(), $procesos_nuevo_edit->SITUACION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->OBSERVACIONES->Required) { ?>
				elm = this.getElements("x" + infix + "_OBSERVACIONES");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->OBSERVACIONES->caption(), $procesos_nuevo_edit->OBSERVACIONES->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($procesos_nuevo_edit->FECHA_REGISTRO->Required) { ?>
				elm = this.getElements("x" + infix + "_FECHA_REGISTRO");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $procesos_nuevo_edit->FECHA_REGISTRO->caption(), $procesos_nuevo_edit->FECHA_REGISTRO->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_FECHA_REGISTRO");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($procesos_nuevo_edit->FECHA_REGISTRO->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fprocesos_nuevoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fprocesos_nuevoedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fprocesos_nuevoedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $procesos_nuevo_edit->showPageHeader(); ?>
<?php
$procesos_nuevo_edit->showMessage();
?>
<form name="fprocesos_nuevoedit" id="fprocesos_nuevoedit" class="<?php echo $procesos_nuevo_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="procesos_nuevo">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$procesos_nuevo_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($procesos_nuevo_edit->codigo->Visible) { // codigo ?>
	<div id="r_codigo" class="form-group row">
		<label id="elh_procesos_nuevo_codigo" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->codigo->caption() ?><?php echo $procesos_nuevo_edit->codigo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->codigo->cellAttributes() ?>>
<span id="el_procesos_nuevo_codigo">
<span<?php echo $procesos_nuevo_edit->codigo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($procesos_nuevo_edit->codigo->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="procesos_nuevo" data-field="x_codigo" name="x_codigo" id="x_codigo" value="<?php echo HtmlEncode($procesos_nuevo_edit->codigo->CurrentValue) ?>">
<?php echo $procesos_nuevo_edit->codigo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->codigo_proceso->Visible) { // codigo_proceso ?>
	<div id="r_codigo_proceso" class="form-group row">
		<label id="elh_procesos_nuevo_codigo_proceso" for="x_codigo_proceso" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->codigo_proceso->caption() ?><?php echo $procesos_nuevo_edit->codigo_proceso->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->codigo_proceso->cellAttributes() ?>>
<span id="el_procesos_nuevo_codigo_proceso">
<input type="text" data-table="procesos_nuevo" data-field="x_codigo_proceso" name="x_codigo_proceso" id="x_codigo_proceso" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->codigo_proceso->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->codigo_proceso->EditValue ?>"<?php echo $procesos_nuevo_edit->codigo_proceso->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->codigo_proceso->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label id="elh_procesos_nuevo_no" for="x_no" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->no->caption() ?><?php echo $procesos_nuevo_edit->no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->no->cellAttributes() ?>>
<span id="el_procesos_nuevo_no">
<input type="text" data-table="procesos_nuevo" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->no->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->no->EditValue ?>"<?php echo $procesos_nuevo_edit->no->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->usuarios->Visible) { // usuarios ?>
	<div id="r_usuarios" class="form-group row">
		<label id="elh_procesos_nuevo_usuarios" for="x_usuarios" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->usuarios->caption() ?><?php echo $procesos_nuevo_edit->usuarios->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->usuarios->cellAttributes() ?>>
<span id="el_procesos_nuevo_usuarios">
<input type="text" data-table="procesos_nuevo" data-field="x_usuarios" name="x_usuarios" id="x_usuarios" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->usuarios->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->usuarios->EditValue ?>"<?php echo $procesos_nuevo_edit->usuarios->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->usuarios->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SEC_EJEC->Visible) { // SEC_EJEC ?>
	<div id="r_SEC_EJEC" class="form-group row">
		<label id="elh_procesos_nuevo_SEC_EJEC" for="x_SEC_EJEC" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SEC_EJEC->caption() ?><?php echo $procesos_nuevo_edit->SEC_EJEC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SEC_EJEC->cellAttributes() ?>>
<span id="el_procesos_nuevo_SEC_EJEC">
<input type="text" data-table="procesos_nuevo" data-field="x_SEC_EJEC" name="x_SEC_EJEC" id="x_SEC_EJEC" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SEC_EJEC->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SEC_EJEC->EditValue ?>"<?php echo $procesos_nuevo_edit->SEC_EJEC->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SEC_EJEC->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIPO_MODALIDAD->Visible) { // TIPO_MODALIDAD ?>
	<div id="r_TIPO_MODALIDAD" class="form-group row">
		<label id="elh_procesos_nuevo_TIPO_MODALIDAD" for="x_TIPO_MODALIDAD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->caption() ?><?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIPO_MODALIDAD">
<input type="text" data-table="procesos_nuevo" data-field="x_TIPO_MODALIDAD" name="x_TIPO_MODALIDAD" id="x_TIPO_MODALIDAD" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIPO_MODALIDAD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->EditValue ?>"<?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIPO_MODALIDAD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SECUENCIA->Visible) { // SECUENCIA ?>
	<div id="r_SECUENCIA" class="form-group row">
		<label id="elh_procesos_nuevo_SECUENCIA" for="x_SECUENCIA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SECUENCIA->caption() ?><?php echo $procesos_nuevo_edit->SECUENCIA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SECUENCIA->cellAttributes() ?>>
<span id="el_procesos_nuevo_SECUENCIA">
<input type="text" data-table="procesos_nuevo" data-field="x_SECUENCIA" name="x_SECUENCIA" id="x_SECUENCIA" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SECUENCIA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SECUENCIA->EditValue ?>"<?php echo $procesos_nuevo_edit->SECUENCIA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SECUENCIA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->AMBIENTE->Visible) { // AMBIENTE ?>
	<div id="r_AMBIENTE" class="form-group row">
		<label id="elh_procesos_nuevo_AMBIENTE" for="x_AMBIENTE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->AMBIENTE->caption() ?><?php echo $procesos_nuevo_edit->AMBIENTE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->AMBIENTE->cellAttributes() ?>>
<span id="el_procesos_nuevo_AMBIENTE">
<input type="text" data-table="procesos_nuevo" data-field="x_AMBIENTE" name="x_AMBIENTE" id="x_AMBIENTE" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->AMBIENTE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->AMBIENTE->EditValue ?>"<?php echo $procesos_nuevo_edit->AMBIENTE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->AMBIENTE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->RUC_ENTIDAD->Visible) { // RUC_ENTIDAD ?>
	<div id="r_RUC_ENTIDAD" class="form-group row">
		<label id="elh_procesos_nuevo_RUC_ENTIDAD" for="x_RUC_ENTIDAD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->RUC_ENTIDAD->caption() ?><?php echo $procesos_nuevo_edit->RUC_ENTIDAD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->RUC_ENTIDAD->cellAttributes() ?>>
<span id="el_procesos_nuevo_RUC_ENTIDAD">
<input type="text" data-table="procesos_nuevo" data-field="x_RUC_ENTIDAD" name="x_RUC_ENTIDAD" id="x_RUC_ENTIDAD" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->RUC_ENTIDAD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->RUC_ENTIDAD->EditValue ?>"<?php echo $procesos_nuevo_edit->RUC_ENTIDAD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->RUC_ENTIDAD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->LOCAL->Visible) { // LOCAL ?>
	<div id="r_LOCAL" class="form-group row">
		<label id="elh_procesos_nuevo_LOCAL" for="x_LOCAL" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->LOCAL->caption() ?><?php echo $procesos_nuevo_edit->LOCAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->LOCAL->cellAttributes() ?>>
<span id="el_procesos_nuevo_LOCAL">
<input type="text" data-table="procesos_nuevo" data-field="x_LOCAL" name="x_LOCAL" id="x_LOCAL" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->LOCAL->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->LOCAL->EditValue ?>"<?php echo $procesos_nuevo_edit->LOCAL->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->LOCAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DEPARTAMENTO->Visible) { // DEPARTAMENTO ?>
	<div id="r_DEPARTAMENTO" class="form-group row">
		<label id="elh_procesos_nuevo_DEPARTAMENTO" for="x_DEPARTAMENTO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DEPARTAMENTO->caption() ?><?php echo $procesos_nuevo_edit->DEPARTAMENTO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DEPARTAMENTO->cellAttributes() ?>>
<span id="el_procesos_nuevo_DEPARTAMENTO">
<input type="text" data-table="procesos_nuevo" data-field="x_DEPARTAMENTO" name="x_DEPARTAMENTO" id="x_DEPARTAMENTO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DEPARTAMENTO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DEPARTAMENTO->EditValue ?>"<?php echo $procesos_nuevo_edit->DEPARTAMENTO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DEPARTAMENTO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PROVINCIA->Visible) { // PROVINCIA ?>
	<div id="r_PROVINCIA" class="form-group row">
		<label id="elh_procesos_nuevo_PROVINCIA" for="x_PROVINCIA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PROVINCIA->caption() ?><?php echo $procesos_nuevo_edit->PROVINCIA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PROVINCIA->cellAttributes() ?>>
<span id="el_procesos_nuevo_PROVINCIA">
<input type="text" data-table="procesos_nuevo" data-field="x_PROVINCIA" name="x_PROVINCIA" id="x_PROVINCIA" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PROVINCIA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PROVINCIA->EditValue ?>"<?php echo $procesos_nuevo_edit->PROVINCIA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PROVINCIA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DISTRITO->Visible) { // DISTRITO ?>
	<div id="r_DISTRITO" class="form-group row">
		<label id="elh_procesos_nuevo_DISTRITO" for="x_DISTRITO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DISTRITO->caption() ?><?php echo $procesos_nuevo_edit->DISTRITO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DISTRITO->cellAttributes() ?>>
<span id="el_procesos_nuevo_DISTRITO">
<input type="text" data-table="procesos_nuevo" data-field="x_DISTRITO" name="x_DISTRITO" id="x_DISTRITO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DISTRITO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DISTRITO->EditValue ?>"<?php echo $procesos_nuevo_edit->DISTRITO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DISTRITO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->AREA->Visible) { // AREA ?>
	<div id="r_AREA" class="form-group row">
		<label id="elh_procesos_nuevo_AREA" for="x_AREA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->AREA->caption() ?><?php echo $procesos_nuevo_edit->AREA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->AREA->cellAttributes() ?>>
<span id="el_procesos_nuevo_AREA">
<input type="text" data-table="procesos_nuevo" data-field="x_AREA" name="x_AREA" id="x_AREA" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->AREA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->AREA->EditValue ?>"<?php echo $procesos_nuevo_edit->AREA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->AREA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->OFICINA->Visible) { // OFICINA ?>
	<div id="r_OFICINA" class="form-group row">
		<label id="elh_procesos_nuevo_OFICINA" for="x_OFICINA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->OFICINA->caption() ?><?php echo $procesos_nuevo_edit->OFICINA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->OFICINA->cellAttributes() ?>>
<span id="el_procesos_nuevo_OFICINA">
<input type="text" data-table="procesos_nuevo" data-field="x_OFICINA" name="x_OFICINA" id="x_OFICINA" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->OFICINA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->OFICINA->EditValue ?>"<?php echo $procesos_nuevo_edit->OFICINA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->OFICINA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PISO_OFICINA->Visible) { // PISO_OFICINA ?>
	<div id="r_PISO_OFICINA" class="form-group row">
		<label id="elh_procesos_nuevo_PISO_OFICINA" for="x_PISO_OFICINA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PISO_OFICINA->caption() ?><?php echo $procesos_nuevo_edit->PISO_OFICINA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PISO_OFICINA->cellAttributes() ?>>
<span id="el_procesos_nuevo_PISO_OFICINA">
<input type="text" data-table="procesos_nuevo" data-field="x_PISO_OFICINA" name="x_PISO_OFICINA" id="x_PISO_OFICINA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PISO_OFICINA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PISO_OFICINA->EditValue ?>"<?php echo $procesos_nuevo_edit->PISO_OFICINA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PISO_OFICINA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->Visible) { // NRO_DOC_IDENT_PERSONAL ?>
	<div id="r_NRO_DOC_IDENT_PERSONAL" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_DOC_IDENT_PERSONAL" for="x_NRO_DOC_IDENT_PERSONAL" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->caption() ?><?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_DOC_IDENT_PERSONAL">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_DOC_IDENT_PERSONAL" name="x_NRO_DOC_IDENT_PERSONAL" id="x_NRO_DOC_IDENT_PERSONAL" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_DOC_IDENT_PERSONAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->APELLIDO_PATERNO->Visible) { // APELLIDO_PATERNO ?>
	<div id="r_APELLIDO_PATERNO" class="form-group row">
		<label id="elh_procesos_nuevo_APELLIDO_PATERNO" for="x_APELLIDO_PATERNO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->caption() ?><?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->cellAttributes() ?>>
<span id="el_procesos_nuevo_APELLIDO_PATERNO">
<input type="text" data-table="procesos_nuevo" data-field="x_APELLIDO_PATERNO" name="x_APELLIDO_PATERNO" id="x_APELLIDO_PATERNO" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->APELLIDO_PATERNO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->EditValue ?>"<?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->APELLIDO_PATERNO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->APELLIDO_MATERNO->Visible) { // APELLIDO_MATERNO ?>
	<div id="r_APELLIDO_MATERNO" class="form-group row">
		<label id="elh_procesos_nuevo_APELLIDO_MATERNO" for="x_APELLIDO_MATERNO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->caption() ?><?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->cellAttributes() ?>>
<span id="el_procesos_nuevo_APELLIDO_MATERNO">
<input type="text" data-table="procesos_nuevo" data-field="x_APELLIDO_MATERNO" name="x_APELLIDO_MATERNO" id="x_APELLIDO_MATERNO" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->APELLIDO_MATERNO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->EditValue ?>"<?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->APELLIDO_MATERNO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NOMBRES->Visible) { // NOMBRES ?>
	<div id="r_NOMBRES" class="form-group row">
		<label id="elh_procesos_nuevo_NOMBRES" for="x_NOMBRES" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NOMBRES->caption() ?><?php echo $procesos_nuevo_edit->NOMBRES->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NOMBRES->cellAttributes() ?>>
<span id="el_procesos_nuevo_NOMBRES">
<input type="text" data-table="procesos_nuevo" data-field="x_NOMBRES" name="x_NOMBRES" id="x_NOMBRES" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NOMBRES->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NOMBRES->EditValue ?>"<?php echo $procesos_nuevo_edit->NOMBRES->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NOMBRES->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->OPERATIVO->Visible) { // OPERATIVO ?>
	<div id="r_OPERATIVO" class="form-group row">
		<label id="elh_procesos_nuevo_OPERATIVO" for="x_OPERATIVO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->OPERATIVO->caption() ?><?php echo $procesos_nuevo_edit->OPERATIVO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->OPERATIVO->cellAttributes() ?>>
<span id="el_procesos_nuevo_OPERATIVO">
<input type="text" data-table="procesos_nuevo" data-field="x_OPERATIVO" name="x_OPERATIVO" id="x_OPERATIVO" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->OPERATIVO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->OPERATIVO->EditValue ?>"<?php echo $procesos_nuevo_edit->OPERATIVO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->OPERATIVO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->Visible) { // TIPO_DOC_IDENTIDAD ?>
	<div id="r_TIPO_DOC_IDENTIDAD" class="form-group row">
		<label id="elh_procesos_nuevo_TIPO_DOC_IDENTIDAD" for="x_TIPO_DOC_IDENTIDAD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->caption() ?><?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIPO_DOC_IDENTIDAD">
<input type="text" data-table="procesos_nuevo" data-field="x_TIPO_DOC_IDENTIDAD" name="x_TIPO_DOC_IDENTIDAD" id="x_TIPO_DOC_IDENTIDAD" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->EditValue ?>"<?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIPO_DOC_IDENTIDAD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->MODALIDAD_CONTRATO->Visible) { // MODALIDAD_CONTRATO ?>
	<div id="r_MODALIDAD_CONTRATO" class="form-group row">
		<label id="elh_procesos_nuevo_MODALIDAD_CONTRATO" for="x_MODALIDAD_CONTRATO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->caption() ?><?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->cellAttributes() ?>>
<span id="el_procesos_nuevo_MODALIDAD_CONTRATO">
<input type="text" data-table="procesos_nuevo" data-field="x_MODALIDAD_CONTRATO" name="x_MODALIDAD_CONTRATO" id="x_MODALIDAD_CONTRATO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->MODALIDAD_CONTRATO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->EditValue ?>"<?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->MODALIDAD_CONTRATO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CODIGO_PATRIMONIAL->Visible) { // CODIGO_PATRIMONIAL ?>
	<div id="r_CODIGO_PATRIMONIAL" class="form-group row">
		<label id="elh_procesos_nuevo_CODIGO_PATRIMONIAL" for="x_CODIGO_PATRIMONIAL" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->caption() ?><?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->cellAttributes() ?>>
<span id="el_procesos_nuevo_CODIGO_PATRIMONIAL">
<input type="text" data-table="procesos_nuevo" data-field="x_CODIGO_PATRIMONIAL" name="x_CODIGO_PATRIMONIAL" id="x_CODIGO_PATRIMONIAL" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CODIGO_PATRIMONIAL->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->EditValue ?>"<?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CODIGO_PATRIMONIAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DENOMINACION_BIEN->Visible) { // DENOMINACION_BIEN ?>
	<div id="r_DENOMINACION_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_DENOMINACION_BIEN" for="x_DENOMINACION_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->caption() ?><?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_DENOMINACION_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_DENOMINACION_BIEN" name="x_DENOMINACION_BIEN" id="x_DENOMINACION_BIEN" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DENOMINACION_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DENOMINACION_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIPO_CAUSAL_ALTA->Visible) { // TIPO_CAUSAL_ALTA ?>
	<div id="r_TIPO_CAUSAL_ALTA" class="form-group row">
		<label id="elh_procesos_nuevo_TIPO_CAUSAL_ALTA" for="x_TIPO_CAUSAL_ALTA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->caption() ?><?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIPO_CAUSAL_ALTA">
<input type="text" data-table="procesos_nuevo" data-field="x_TIPO_CAUSAL_ALTA" name="x_TIPO_CAUSAL_ALTA" id="x_TIPO_CAUSAL_ALTA" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIPO_CAUSAL_ALTA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->EditValue ?>"<?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIPO_CAUSAL_ALTA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_DOC_ADQUISICION->Visible) { // NRO_DOC_ADQUISICION ?>
	<div id="r_NRO_DOC_ADQUISICION" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_DOC_ADQUISICION" for="x_NRO_DOC_ADQUISICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->caption() ?><?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_DOC_ADQUISICION">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_DOC_ADQUISICION" name="x_NRO_DOC_ADQUISICION" id="x_NRO_DOC_ADQUISICION" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_DOC_ADQUISICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_DOC_ADQUISICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_ADQUISICION->Visible) { // FECHA_ADQUISICION ?>
	<div id="r_FECHA_ADQUISICION" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_ADQUISICION" for="x_FECHA_ADQUISICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->caption() ?><?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_ADQUISICION">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_ADQUISICION" name="x_FECHA_ADQUISICION" id="x_FECHA_ADQUISICION" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_ADQUISICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_ADQUISICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->VALOR_ADQUISICION->Visible) { // VALOR_ADQUISICION ?>
	<div id="r_VALOR_ADQUISICION" class="form-group row">
		<label id="elh_procesos_nuevo_VALOR_ADQUISICION" for="x_VALOR_ADQUISICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->caption() ?><?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_VALOR_ADQUISICION">
<input type="text" data-table="procesos_nuevo" data-field="x_VALOR_ADQUISICION" name="x_VALOR_ADQUISICION" id="x_VALOR_ADQUISICION" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->VALOR_ADQUISICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->EditValue ?>"<?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->VALOR_ADQUISICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_DEPRECIACION->Visible) { // FECHA_DEPRECIACION ?>
	<div id="r_FECHA_DEPRECIACION" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_DEPRECIACION" for="x_FECHA_DEPRECIACION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->caption() ?><?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_DEPRECIACION">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_DEPRECIACION" name="x_FECHA_DEPRECIACION" id="x_FECHA_DEPRECIACION" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_DEPRECIACION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_DEPRECIACION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->Visible) { // VALOR_DEPREC_EJERCICIO ?>
	<div id="r_VALOR_DEPREC_EJERCICIO" class="form-group row">
		<label id="elh_procesos_nuevo_VALOR_DEPREC_EJERCICIO" for="x_VALOR_DEPREC_EJERCICIO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->caption() ?><?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->cellAttributes() ?>>
<span id="el_procesos_nuevo_VALOR_DEPREC_EJERCICIO">
<input type="text" data-table="procesos_nuevo" data-field="x_VALOR_DEPREC_EJERCICIO" name="x_VALOR_DEPREC_EJERCICIO" id="x_VALOR_DEPREC_EJERCICIO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->EditValue ?>"<?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->VALOR_DEPREC_EJERCICIO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->Visible) { // VALOR_DEPREC_ACUMULADO ?>
	<div id="r_VALOR_DEPREC_ACUMULADO" class="form-group row">
		<label id="elh_procesos_nuevo_VALOR_DEPREC_ACUMULADO" for="x_VALOR_DEPREC_ACUMULADO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->caption() ?><?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->cellAttributes() ?>>
<span id="el_procesos_nuevo_VALOR_DEPREC_ACUMULADO">
<input type="text" data-table="procesos_nuevo" data-field="x_VALOR_DEPREC_ACUMULADO" name="x_VALOR_DEPREC_ACUMULADO" id="x_VALOR_DEPREC_ACUMULADO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->EditValue ?>"<?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->VALOR_DEPREC_ACUMULADO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->VALOR_NETO->Visible) { // VALOR_NETO ?>
	<div id="r_VALOR_NETO" class="form-group row">
		<label id="elh_procesos_nuevo_VALOR_NETO" for="x_VALOR_NETO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->VALOR_NETO->caption() ?><?php echo $procesos_nuevo_edit->VALOR_NETO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->VALOR_NETO->cellAttributes() ?>>
<span id="el_procesos_nuevo_VALOR_NETO">
<input type="text" data-table="procesos_nuevo" data-field="x_VALOR_NETO" name="x_VALOR_NETO" id="x_VALOR_NETO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->VALOR_NETO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->VALOR_NETO->EditValue ?>"<?php echo $procesos_nuevo_edit->VALOR_NETO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->VALOR_NETO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIP_USO_CUENTA->Visible) { // TIP_USO_CUENTA ?>
	<div id="r_TIP_USO_CUENTA" class="form-group row">
		<label id="elh_procesos_nuevo_TIP_USO_CUENTA" for="x_TIP_USO_CUENTA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->caption() ?><?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIP_USO_CUENTA">
<input type="text" data-table="procesos_nuevo" data-field="x_TIP_USO_CUENTA" name="x_TIP_USO_CUENTA" id="x_TIP_USO_CUENTA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIP_USO_CUENTA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->EditValue ?>"<?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIP_USO_CUENTA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIPO_CUENTA->Visible) { // TIPO_CUENTA ?>
	<div id="r_TIPO_CUENTA" class="form-group row">
		<label id="elh_procesos_nuevo_TIPO_CUENTA" for="x_TIPO_CUENTA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIPO_CUENTA->caption() ?><?php echo $procesos_nuevo_edit->TIPO_CUENTA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIPO_CUENTA->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIPO_CUENTA">
<input type="text" data-table="procesos_nuevo" data-field="x_TIPO_CUENTA" name="x_TIPO_CUENTA" id="x_TIPO_CUENTA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIPO_CUENTA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIPO_CUENTA->EditValue ?>"<?php echo $procesos_nuevo_edit->TIPO_CUENTA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIPO_CUENTA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_CUENTA_CONTABLE->Visible) { // NRO_CUENTA_CONTABLE ?>
	<div id="r_NRO_CUENTA_CONTABLE" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_CUENTA_CONTABLE" for="x_NRO_CUENTA_CONTABLE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->caption() ?><?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_CUENTA_CONTABLE">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_CUENTA_CONTABLE" name="x_NRO_CUENTA_CONTABLE" id="x_NRO_CUENTA_CONTABLE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_CUENTA_CONTABLE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_CUENTA_CONTABLE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CTA_CON_SEGURO->Visible) { // CTA_CON_SEGURO ?>
	<div id="r_CTA_CON_SEGURO" class="form-group row">
		<label id="elh_procesos_nuevo_CTA_CON_SEGURO" for="x_CTA_CON_SEGURO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->caption() ?><?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->cellAttributes() ?>>
<span id="el_procesos_nuevo_CTA_CON_SEGURO">
<input type="text" data-table="procesos_nuevo" data-field="x_CTA_CON_SEGURO" name="x_CTA_CON_SEGURO" id="x_CTA_CON_SEGURO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CTA_CON_SEGURO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->EditValue ?>"<?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CTA_CON_SEGURO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ESTADO_BIEN->Visible) { // ESTADO_BIEN ?>
	<div id="r_ESTADO_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_ESTADO_BIEN" for="x_ESTADO_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ESTADO_BIEN->caption() ?><?php echo $procesos_nuevo_edit->ESTADO_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ESTADO_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_ESTADO_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_ESTADO_BIEN" name="x_ESTADO_BIEN" id="x_ESTADO_BIEN" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ESTADO_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ESTADO_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->ESTADO_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ESTADO_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CONDICION->Visible) { // CONDICION ?>
	<div id="r_CONDICION" class="form-group row">
		<label id="elh_procesos_nuevo_CONDICION" for="x_CONDICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CONDICION->caption() ?><?php echo $procesos_nuevo_edit->CONDICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CONDICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_CONDICION">
<input type="text" data-table="procesos_nuevo" data-field="x_CONDICION" name="x_CONDICION" id="x_CONDICION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CONDICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CONDICION->EditValue ?>"<?php echo $procesos_nuevo_edit->CONDICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CONDICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->MARCA->Visible) { // MARCA ?>
	<div id="r_MARCA" class="form-group row">
		<label id="elh_procesos_nuevo_MARCA" for="x_MARCA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->MARCA->caption() ?><?php echo $procesos_nuevo_edit->MARCA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->MARCA->cellAttributes() ?>>
<span id="el_procesos_nuevo_MARCA">
<input type="text" data-table="procesos_nuevo" data-field="x_MARCA" name="x_MARCA" id="x_MARCA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->MARCA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->MARCA->EditValue ?>"<?php echo $procesos_nuevo_edit->MARCA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->MARCA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->MODELO->Visible) { // MODELO ?>
	<div id="r_MODELO" class="form-group row">
		<label id="elh_procesos_nuevo_MODELO" for="x_MODELO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->MODELO->caption() ?><?php echo $procesos_nuevo_edit->MODELO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->MODELO->cellAttributes() ?>>
<span id="el_procesos_nuevo_MODELO">
<input type="text" data-table="procesos_nuevo" data-field="x_MODELO" name="x_MODELO" id="x_MODELO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->MODELO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->MODELO->EditValue ?>"<?php echo $procesos_nuevo_edit->MODELO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->MODELO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->TIPO->Visible) { // TIPO ?>
	<div id="r_TIPO" class="form-group row">
		<label id="elh_procesos_nuevo_TIPO" for="x_TIPO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->TIPO->caption() ?><?php echo $procesos_nuevo_edit->TIPO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->TIPO->cellAttributes() ?>>
<span id="el_procesos_nuevo_TIPO">
<input type="text" data-table="procesos_nuevo" data-field="x_TIPO" name="x_TIPO" id="x_TIPO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->TIPO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->TIPO->EditValue ?>"<?php echo $procesos_nuevo_edit->TIPO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->TIPO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->COLOR->Visible) { // COLOR ?>
	<div id="r_COLOR" class="form-group row">
		<label id="elh_procesos_nuevo_COLOR" for="x_COLOR" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->COLOR->caption() ?><?php echo $procesos_nuevo_edit->COLOR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->COLOR->cellAttributes() ?>>
<span id="el_procesos_nuevo_COLOR">
<input type="text" data-table="procesos_nuevo" data-field="x_COLOR" name="x_COLOR" id="x_COLOR" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->COLOR->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->COLOR->EditValue ?>"<?php echo $procesos_nuevo_edit->COLOR->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->COLOR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SERIE->Visible) { // SERIE ?>
	<div id="r_SERIE" class="form-group row">
		<label id="elh_procesos_nuevo_SERIE" for="x_SERIE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SERIE->caption() ?><?php echo $procesos_nuevo_edit->SERIE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SERIE->cellAttributes() ?>>
<span id="el_procesos_nuevo_SERIE">
<input type="text" data-table="procesos_nuevo" data-field="x_SERIE" name="x_SERIE" id="x_SERIE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SERIE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SERIE->EditValue ?>"<?php echo $procesos_nuevo_edit->SERIE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SERIE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DIMENSION->Visible) { // DIMENSION ?>
	<div id="r_DIMENSION" class="form-group row">
		<label id="elh_procesos_nuevo_DIMENSION" for="x_DIMENSION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DIMENSION->caption() ?><?php echo $procesos_nuevo_edit->DIMENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DIMENSION->cellAttributes() ?>>
<span id="el_procesos_nuevo_DIMENSION">
<input type="text" data-table="procesos_nuevo" data-field="x_DIMENSION" name="x_DIMENSION" id="x_DIMENSION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DIMENSION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DIMENSION->EditValue ?>"<?php echo $procesos_nuevo_edit->DIMENSION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DIMENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PLACA->Visible) { // PLACA ?>
	<div id="r_PLACA" class="form-group row">
		<label id="elh_procesos_nuevo_PLACA" for="x_PLACA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PLACA->caption() ?><?php echo $procesos_nuevo_edit->PLACA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PLACA->cellAttributes() ?>>
<span id="el_procesos_nuevo_PLACA">
<input type="text" data-table="procesos_nuevo" data-field="x_PLACA" name="x_PLACA" id="x_PLACA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PLACA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PLACA->EditValue ?>"<?php echo $procesos_nuevo_edit->PLACA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PLACA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_MOTOR->Visible) { // NRO_MOTOR ?>
	<div id="r_NRO_MOTOR" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_MOTOR" for="x_NRO_MOTOR" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_MOTOR->caption() ?><?php echo $procesos_nuevo_edit->NRO_MOTOR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_MOTOR->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_MOTOR">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_MOTOR" name="x_NRO_MOTOR" id="x_NRO_MOTOR" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_MOTOR->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_MOTOR->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_MOTOR->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_MOTOR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_CHASIS->Visible) { // NRO_CHASIS ?>
	<div id="r_NRO_CHASIS" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_CHASIS" for="x_NRO_CHASIS" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_CHASIS->caption() ?><?php echo $procesos_nuevo_edit->NRO_CHASIS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_CHASIS->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_CHASIS">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_CHASIS" name="x_NRO_CHASIS" id="x_NRO_CHASIS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_CHASIS->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_CHASIS->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_CHASIS->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_CHASIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->MATRICULA->Visible) { // MATRICULA ?>
	<div id="r_MATRICULA" class="form-group row">
		<label id="elh_procesos_nuevo_MATRICULA" for="x_MATRICULA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->MATRICULA->caption() ?><?php echo $procesos_nuevo_edit->MATRICULA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->MATRICULA->cellAttributes() ?>>
<span id="el_procesos_nuevo_MATRICULA">
<input type="text" data-table="procesos_nuevo" data-field="x_MATRICULA" name="x_MATRICULA" id="x_MATRICULA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->MATRICULA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->MATRICULA->EditValue ?>"<?php echo $procesos_nuevo_edit->MATRICULA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->MATRICULA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ANIO_FABRICACION->Visible) { // ANIO_FABRICACION ?>
	<div id="r_ANIO_FABRICACION" class="form-group row">
		<label id="elh_procesos_nuevo_ANIO_FABRICACION" for="x_ANIO_FABRICACION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ANIO_FABRICACION->caption() ?><?php echo $procesos_nuevo_edit->ANIO_FABRICACION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ANIO_FABRICACION->cellAttributes() ?>>
<span id="el_procesos_nuevo_ANIO_FABRICACION">
<input type="text" data-table="procesos_nuevo" data-field="x_ANIO_FABRICACION" name="x_ANIO_FABRICACION" id="x_ANIO_FABRICACION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ANIO_FABRICACION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ANIO_FABRICACION->EditValue ?>"<?php echo $procesos_nuevo_edit->ANIO_FABRICACION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ANIO_FABRICACION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->LONGITUD->Visible) { // LONGITUD ?>
	<div id="r_LONGITUD" class="form-group row">
		<label id="elh_procesos_nuevo_LONGITUD" for="x_LONGITUD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->LONGITUD->caption() ?><?php echo $procesos_nuevo_edit->LONGITUD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->LONGITUD->cellAttributes() ?>>
<span id="el_procesos_nuevo_LONGITUD">
<input type="text" data-table="procesos_nuevo" data-field="x_LONGITUD" name="x_LONGITUD" id="x_LONGITUD" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->LONGITUD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->LONGITUD->EditValue ?>"<?php echo $procesos_nuevo_edit->LONGITUD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->LONGITUD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ALTURA->Visible) { // ALTURA ?>
	<div id="r_ALTURA" class="form-group row">
		<label id="elh_procesos_nuevo_ALTURA" for="x_ALTURA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ALTURA->caption() ?><?php echo $procesos_nuevo_edit->ALTURA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ALTURA->cellAttributes() ?>>
<span id="el_procesos_nuevo_ALTURA">
<input type="text" data-table="procesos_nuevo" data-field="x_ALTURA" name="x_ALTURA" id="x_ALTURA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ALTURA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ALTURA->EditValue ?>"<?php echo $procesos_nuevo_edit->ALTURA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ALTURA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ANCHO->Visible) { // ANCHO ?>
	<div id="r_ANCHO" class="form-group row">
		<label id="elh_procesos_nuevo_ANCHO" for="x_ANCHO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ANCHO->caption() ?><?php echo $procesos_nuevo_edit->ANCHO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ANCHO->cellAttributes() ?>>
<span id="el_procesos_nuevo_ANCHO">
<input type="text" data-table="procesos_nuevo" data-field="x_ANCHO" name="x_ANCHO" id="x_ANCHO" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ANCHO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ANCHO->EditValue ?>"<?php echo $procesos_nuevo_edit->ANCHO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ANCHO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->RAZA->Visible) { // RAZA ?>
	<div id="r_RAZA" class="form-group row">
		<label id="elh_procesos_nuevo_RAZA" for="x_RAZA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->RAZA->caption() ?><?php echo $procesos_nuevo_edit->RAZA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->RAZA->cellAttributes() ?>>
<span id="el_procesos_nuevo_RAZA">
<input type="text" data-table="procesos_nuevo" data-field="x_RAZA" name="x_RAZA" id="x_RAZA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->RAZA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->RAZA->EditValue ?>"<?php echo $procesos_nuevo_edit->RAZA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->RAZA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ESPECIE->Visible) { // ESPECIE ?>
	<div id="r_ESPECIE" class="form-group row">
		<label id="elh_procesos_nuevo_ESPECIE" for="x_ESPECIE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ESPECIE->caption() ?><?php echo $procesos_nuevo_edit->ESPECIE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ESPECIE->cellAttributes() ?>>
<span id="el_procesos_nuevo_ESPECIE">
<input type="text" data-table="procesos_nuevo" data-field="x_ESPECIE" name="x_ESPECIE" id="x_ESPECIE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ESPECIE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ESPECIE->EditValue ?>"<?php echo $procesos_nuevo_edit->ESPECIE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ESPECIE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->EDAD->Visible) { // EDAD ?>
	<div id="r_EDAD" class="form-group row">
		<label id="elh_procesos_nuevo_EDAD" for="x_EDAD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->EDAD->caption() ?><?php echo $procesos_nuevo_edit->EDAD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->EDAD->cellAttributes() ?>>
<span id="el_procesos_nuevo_EDAD">
<input type="text" data-table="procesos_nuevo" data-field="x_EDAD" name="x_EDAD" id="x_EDAD" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->EDAD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->EDAD->EditValue ?>"<?php echo $procesos_nuevo_edit->EDAD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->EDAD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PAIS->Visible) { // PAIS ?>
	<div id="r_PAIS" class="form-group row">
		<label id="elh_procesos_nuevo_PAIS" for="x_PAIS" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PAIS->caption() ?><?php echo $procesos_nuevo_edit->PAIS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PAIS->cellAttributes() ?>>
<span id="el_procesos_nuevo_PAIS">
<input type="text" data-table="procesos_nuevo" data-field="x_PAIS" name="x_PAIS" id="x_PAIS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PAIS->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PAIS->EditValue ?>"<?php echo $procesos_nuevo_edit->PAIS->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->OTRAS_CARACT->Visible) { // OTRAS_CARACT ?>
	<div id="r_OTRAS_CARACT" class="form-group row">
		<label id="elh_procesos_nuevo_OTRAS_CARACT" for="x_OTRAS_CARACT" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->OTRAS_CARACT->caption() ?><?php echo $procesos_nuevo_edit->OTRAS_CARACT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->OTRAS_CARACT->cellAttributes() ?>>
<span id="el_procesos_nuevo_OTRAS_CARACT">
<input type="text" data-table="procesos_nuevo" data-field="x_OTRAS_CARACT" name="x_OTRAS_CARACT" id="x_OTRAS_CARACT" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->OTRAS_CARACT->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->OTRAS_CARACT->EditValue ?>"<?php echo $procesos_nuevo_edit->OTRAS_CARACT->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->OTRAS_CARACT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->Visible) { // DESCRIPCION_UBICACION_BIEN ?>
	<div id="r_DESCRIPCION_UBICACION_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_DESCRIPCION_UBICACION_BIEN" for="x_DESCRIPCION_UBICACION_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->caption() ?><?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_DESCRIPCION_UBICACION_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_DESCRIPCION_UBICACION_BIEN" name="x_DESCRIPCION_UBICACION_BIEN" id="x_DESCRIPCION_UBICACION_BIEN" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DESCRIPCION_UBICACION_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CAUSAL_BAJA->Visible) { // CAUSAL_BAJA ?>
	<div id="r_CAUSAL_BAJA" class="form-group row">
		<label id="elh_procesos_nuevo_CAUSAL_BAJA" for="x_CAUSAL_BAJA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CAUSAL_BAJA->caption() ?><?php echo $procesos_nuevo_edit->CAUSAL_BAJA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CAUSAL_BAJA->cellAttributes() ?>>
<span id="el_procesos_nuevo_CAUSAL_BAJA">
<input type="text" data-table="procesos_nuevo" data-field="x_CAUSAL_BAJA" name="x_CAUSAL_BAJA" id="x_CAUSAL_BAJA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CAUSAL_BAJA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CAUSAL_BAJA->EditValue ?>"<?php echo $procesos_nuevo_edit->CAUSAL_BAJA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CAUSAL_BAJA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_RESOLUCION_BAJA->Visible) { // NRO_RESOLUCION_BAJA ?>
	<div id="r_NRO_RESOLUCION_BAJA" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_RESOLUCION_BAJA" for="x_NRO_RESOLUCION_BAJA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->caption() ?><?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_RESOLUCION_BAJA">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_RESOLUCION_BAJA" name="x_NRO_RESOLUCION_BAJA" id="x_NRO_RESOLUCION_BAJA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_RESOLUCION_BAJA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_BAJA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_BAJA->Visible) { // FECHA_BAJA ?>
	<div id="r_FECHA_BAJA" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_BAJA" for="x_FECHA_BAJA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_BAJA->caption() ?><?php echo $procesos_nuevo_edit->FECHA_BAJA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_BAJA->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_BAJA">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_BAJA" name="x_FECHA_BAJA" id="x_FECHA_BAJA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_BAJA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_BAJA->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_BAJA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_BAJA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->Visible) { // ACTO_DISPOSICION_BIEN ?>
	<div id="r_ACTO_DISPOSICION_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_ACTO_DISPOSICION_BIEN" for="x_ACTO_DISPOSICION_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->caption() ?><?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_ACTO_DISPOSICION_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_ACTO_DISPOSICION_BIEN" name="x_ACTO_DISPOSICION_BIEN" id="x_ACTO_DISPOSICION_BIEN" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ACTO_DISPOSICION_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NRO_RESOLUCION_DISP->Visible) { // NRO_RESOLUCION_DISP ?>
	<div id="r_NRO_RESOLUCION_DISP" class="form-group row">
		<label id="elh_procesos_nuevo_NRO_RESOLUCION_DISP" for="x_NRO_RESOLUCION_DISP" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->caption() ?><?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->cellAttributes() ?>>
<span id="el_procesos_nuevo_NRO_RESOLUCION_DISP">
<input type="text" data-table="procesos_nuevo" data-field="x_NRO_RESOLUCION_DISP" name="x_NRO_RESOLUCION_DISP" id="x_NRO_RESOLUCION_DISP" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NRO_RESOLUCION_DISP->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->EditValue ?>"<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NRO_RESOLUCION_DISP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_DISPOSICION->Visible) { // FECHA_DISPOSICION ?>
	<div id="r_FECHA_DISPOSICION" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_DISPOSICION" for="x_FECHA_DISPOSICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->caption() ?><?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_DISPOSICION">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_DISPOSICION" name="x_FECHA_DISPOSICION" id="x_FECHA_DISPOSICION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_DISPOSICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_DISPOSICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Visible) { // ENTIDAD_BENEFICIADA_ACTO_DISPOSICION ?>
	<div id="r_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="form-group row">
		<label id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" for="x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->caption() ?><?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->cellAttributes() ?>>
<span id="el_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION">
<input type="text" data-table="procesos_nuevo" data-field="x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" name="x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" id="x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->EditValue ?>"<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->Visible) { // MOTIVO_ELIMINACION_BIEN ?>
	<div id="r_MOTIVO_ELIMINACION_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_MOTIVO_ELIMINACION_BIEN" for="x_MOTIVO_ELIMINACION_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->caption() ?><?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_MOTIVO_ELIMINACION_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_MOTIVO_ELIMINACION_BIEN" name="x_MOTIVO_ELIMINACION_BIEN" id="x_MOTIVO_ELIMINACION_BIEN" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->MOTIVO_ELIMINACION_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->Visible) { // ACTO_ADMINISTRACION_BIEN ?>
	<div id="r_ACTO_ADMINISTRACION_BIEN" class="form-group row">
		<label id="elh_procesos_nuevo_ACTO_ADMINISTRACION_BIEN" for="x_ACTO_ADMINISTRACION_BIEN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->caption() ?><?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->cellAttributes() ?>>
<span id="el_procesos_nuevo_ACTO_ADMINISTRACION_BIEN">
<input type="text" data-table="procesos_nuevo" data-field="x_ACTO_ADMINISTRACION_BIEN" name="x_ACTO_ADMINISTRACION_BIEN" id="x_ACTO_ADMINISTRACION_BIEN" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->EditValue ?>"<?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ACTO_ADMINISTRACION_BIEN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->Visible) { // NUM_RESOLUCION_ADMINISTRACION ?>
	<div id="r_NUM_RESOLUCION_ADMINISTRACION" class="form-group row">
		<label id="elh_procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION" for="x_NUM_RESOLUCION_ADMINISTRACION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->caption() ?><?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->cellAttributes() ?>>
<span id="el_procesos_nuevo_NUM_RESOLUCION_ADMINISTRACION">
<input type="text" data-table="procesos_nuevo" data-field="x_NUM_RESOLUCION_ADMINISTRACION" name="x_NUM_RESOLUCION_ADMINISTRACION" id="x_NUM_RESOLUCION_ADMINISTRACION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->EditValue ?>"<?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NUM_RESOLUCION_ADMINISTRACION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_ADMINISTRACION->Visible) { // FECHA_ADMINISTRACION ?>
	<div id="r_FECHA_ADMINISTRACION" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_ADMINISTRACION" for="x_FECHA_ADMINISTRACION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->caption() ?><?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_ADMINISTRACION">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_ADMINISTRACION" name="x_FECHA_ADMINISTRACION" id="x_FECHA_ADMINISTRACION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_ADMINISTRACION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_ADMINISTRACION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->Visible) { // FECHA_VENC_ACTO_ADMIN ?>
	<div id="r_FECHA_VENC_ACTO_ADMIN" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_VENC_ACTO_ADMIN" for="x_FECHA_VENC_ACTO_ADMIN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->caption() ?><?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_VENC_ACTO_ADMIN">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_VENC_ACTO_ADMIN" name="x_FECHA_VENC_ACTO_ADMIN" id="x_FECHA_VENC_ACTO_ADMIN" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->FECHA_VENC_ACTO_ADMIN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Visible) { // ENTIDAD_BENEFICIADA_ACTO_ADMIN ?>
	<div id="r_ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="form-group row">
		<label id="elh_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN" for="x_ENTIDAD_BENEFICIADA_ACTO_ADMIN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->caption() ?><?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->cellAttributes() ?>>
<span id="el_procesos_nuevo_ENTIDAD_BENEFICIADA_ACTO_ADMIN">
<input type="text" data-table="procesos_nuevo" data-field="x_ENTIDAD_BENEFICIADA_ACTO_ADMIN" name="x_ENTIDAD_BENEFICIADA_ACTO_ADMIN" id="x_ENTIDAD_BENEFICIADA_ACTO_ADMIN" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->EditValue ?>"<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DOC_ALTA_SBN->Visible) { // DOC_ALTA_SBN ?>
	<div id="r_DOC_ALTA_SBN" class="form-group row">
		<label id="elh_procesos_nuevo_DOC_ALTA_SBN" for="x_DOC_ALTA_SBN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->caption() ?><?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->cellAttributes() ?>>
<span id="el_procesos_nuevo_DOC_ALTA_SBN">
<input type="text" data-table="procesos_nuevo" data-field="x_DOC_ALTA_SBN" name="x_DOC_ALTA_SBN" id="x_DOC_ALTA_SBN" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DOC_ALTA_SBN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->EditValue ?>"<?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DOC_ALTA_SBN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DOC_BAJA_SBN->Visible) { // DOC_BAJA_SBN ?>
	<div id="r_DOC_BAJA_SBN" class="form-group row">
		<label id="elh_procesos_nuevo_DOC_BAJA_SBN" for="x_DOC_BAJA_SBN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->caption() ?><?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->cellAttributes() ?>>
<span id="el_procesos_nuevo_DOC_BAJA_SBN">
<input type="text" data-table="procesos_nuevo" data-field="x_DOC_BAJA_SBN" name="x_DOC_BAJA_SBN" id="x_DOC_BAJA_SBN" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DOC_BAJA_SBN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->EditValue ?>"<?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DOC_BAJA_SBN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->DEPENDENCIAS->Visible) { // DEPENDENCIAS ?>
	<div id="r_DEPENDENCIAS" class="form-group row">
		<label id="elh_procesos_nuevo_DEPENDENCIAS" for="x_DEPENDENCIAS" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->DEPENDENCIAS->caption() ?><?php echo $procesos_nuevo_edit->DEPENDENCIAS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->DEPENDENCIAS->cellAttributes() ?>>
<span id="el_procesos_nuevo_DEPENDENCIAS">
<input type="text" data-table="procesos_nuevo" data-field="x_DEPENDENCIAS" name="x_DEPENDENCIAS" id="x_DEPENDENCIAS" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->DEPENDENCIAS->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->DEPENDENCIAS->EditValue ?>"<?php echo $procesos_nuevo_edit->DEPENDENCIAS->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->DEPENDENCIAS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NUMERO_FICHA->Visible) { // NUMERO_FICHA ?>
	<div id="r_NUMERO_FICHA" class="form-group row">
		<label id="elh_procesos_nuevo_NUMERO_FICHA" for="x_NUMERO_FICHA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NUMERO_FICHA->caption() ?><?php echo $procesos_nuevo_edit->NUMERO_FICHA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NUMERO_FICHA->cellAttributes() ?>>
<span id="el_procesos_nuevo_NUMERO_FICHA">
<input type="text" data-table="procesos_nuevo" data-field="x_NUMERO_FICHA" name="x_NUMERO_FICHA" id="x_NUMERO_FICHA" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NUMERO_FICHA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NUMERO_FICHA->EditValue ?>"<?php echo $procesos_nuevo_edit->NUMERO_FICHA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NUMERO_FICHA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CODIGO_INTERNO->Visible) { // CODIGO_INTERNO ?>
	<div id="r_CODIGO_INTERNO" class="form-group row">
		<label id="elh_procesos_nuevo_CODIGO_INTERNO" for="x_CODIGO_INTERNO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CODIGO_INTERNO->caption() ?><?php echo $procesos_nuevo_edit->CODIGO_INTERNO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CODIGO_INTERNO->cellAttributes() ?>>
<span id="el_procesos_nuevo_CODIGO_INTERNO">
<input type="text" data-table="procesos_nuevo" data-field="x_CODIGO_INTERNO" name="x_CODIGO_INTERNO" id="x_CODIGO_INTERNO" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CODIGO_INTERNO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CODIGO_INTERNO->EditValue ?>"<?php echo $procesos_nuevo_edit->CODIGO_INTERNO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CODIGO_INTERNO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ESTADO->Visible) { // ESTADO ?>
	<div id="r_ESTADO" class="form-group row">
		<label id="elh_procesos_nuevo_ESTADO" for="x_ESTADO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ESTADO->caption() ?><?php echo $procesos_nuevo_edit->ESTADO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ESTADO->cellAttributes() ?>>
<span id="el_procesos_nuevo_ESTADO">
<input type="text" data-table="procesos_nuevo" data-field="x_ESTADO" name="x_ESTADO" id="x_ESTADO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ESTADO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ESTADO->EditValue ?>"<?php echo $procesos_nuevo_edit->ESTADO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ESTADO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->USO->Visible) { // USO ?>
	<div id="r_USO" class="form-group row">
		<label id="elh_procesos_nuevo_USO" for="x_USO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->USO->caption() ?><?php echo $procesos_nuevo_edit->USO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->USO->cellAttributes() ?>>
<span id="el_procesos_nuevo_USO">
<input type="text" data-table="procesos_nuevo" data-field="x_USO" name="x_USO" id="x_USO" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->USO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->USO->EditValue ?>"<?php echo $procesos_nuevo_edit->USO->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->USO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->STICKER->Visible) { // STICKER ?>
	<div id="r_STICKER" class="form-group row">
		<label id="elh_procesos_nuevo_STICKER" for="x_STICKER" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->STICKER->caption() ?><?php echo $procesos_nuevo_edit->STICKER->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->STICKER->cellAttributes() ?>>
<span id="el_procesos_nuevo_STICKER">
<input type="text" data-table="procesos_nuevo" data-field="x_STICKER" name="x_STICKER" id="x_STICKER" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->STICKER->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->STICKER->EditValue ?>"<?php echo $procesos_nuevo_edit->STICKER->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->STICKER->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SEDE->Visible) { // SEDE ?>
	<div id="r_SEDE" class="form-group row">
		<label id="elh_procesos_nuevo_SEDE" for="x_SEDE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SEDE->caption() ?><?php echo $procesos_nuevo_edit->SEDE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SEDE->cellAttributes() ?>>
<span id="el_procesos_nuevo_SEDE">
<input type="text" data-table="procesos_nuevo" data-field="x_SEDE" name="x_SEDE" id="x_SEDE" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SEDE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SEDE->EditValue ?>"<?php echo $procesos_nuevo_edit->SEDE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SEDE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SBN->Visible) { // SBN ?>
	<div id="r_SBN" class="form-group row">
		<label id="elh_procesos_nuevo_SBN" for="x_SBN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SBN->caption() ?><?php echo $procesos_nuevo_edit->SBN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SBN->cellAttributes() ?>>
<span id="el_procesos_nuevo_SBN">
<input type="text" data-table="procesos_nuevo" data-field="x_SBN" name="x_SBN" id="x_SBN" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SBN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SBN->EditValue ?>"<?php echo $procesos_nuevo_edit->SBN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SBN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->ETIQUETA->Visible) { // ETIQUETA ?>
	<div id="r_ETIQUETA" class="form-group row">
		<label id="elh_procesos_nuevo_ETIQUETA" for="x_ETIQUETA" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->ETIQUETA->caption() ?><?php echo $procesos_nuevo_edit->ETIQUETA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->ETIQUETA->cellAttributes() ?>>
<span id="el_procesos_nuevo_ETIQUETA">
<input type="text" data-table="procesos_nuevo" data-field="x_ETIQUETA" name="x_ETIQUETA" id="x_ETIQUETA" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->ETIQUETA->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->ETIQUETA->EditValue ?>"<?php echo $procesos_nuevo_edit->ETIQUETA->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->ETIQUETA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Visible) { // NOMBRE_BENEFICIARIO_ACTO_ADMIN ?>
	<div id="r_NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="form-group row">
		<label id="elh_procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN" for="x_NOMBRE_BENEFICIARIO_ACTO_ADMIN" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->caption() ?><?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->cellAttributes() ?>>
<span id="el_procesos_nuevo_NOMBRE_BENEFICIARIO_ACTO_ADMIN">
<input type="text" data-table="procesos_nuevo" data-field="x_NOMBRE_BENEFICIARIO_ACTO_ADMIN" name="x_NOMBRE_BENEFICIARIO_ACTO_ADMIN" id="x_NOMBRE_BENEFICIARIO_ACTO_ADMIN" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->EditValue ?>"<?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PLACA_RODAJE->Visible) { // PLACA_RODAJE ?>
	<div id="r_PLACA_RODAJE" class="form-group row">
		<label id="elh_procesos_nuevo_PLACA_RODAJE" for="x_PLACA_RODAJE" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PLACA_RODAJE->caption() ?><?php echo $procesos_nuevo_edit->PLACA_RODAJE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PLACA_RODAJE->cellAttributes() ?>>
<span id="el_procesos_nuevo_PLACA_RODAJE">
<input type="text" data-table="procesos_nuevo" data-field="x_PLACA_RODAJE" name="x_PLACA_RODAJE" id="x_PLACA_RODAJE" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PLACA_RODAJE->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PLACA_RODAJE->EditValue ?>"<?php echo $procesos_nuevo_edit->PLACA_RODAJE->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PLACA_RODAJE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CODIGO_ACTUAL->Visible) { // CODIGO_ACTUAL ?>
	<div id="r_CODIGO_ACTUAL" class="form-group row">
		<label id="elh_procesos_nuevo_CODIGO_ACTUAL" for="x_CODIGO_ACTUAL" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->caption() ?><?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->cellAttributes() ?>>
<span id="el_procesos_nuevo_CODIGO_ACTUAL">
<input type="text" data-table="procesos_nuevo" data-field="x_CODIGO_ACTUAL" name="x_CODIGO_ACTUAL" id="x_CODIGO_ACTUAL" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CODIGO_ACTUAL->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->EditValue ?>"<?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CODIGO_ACTUAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->CODIGO_ANTERIOR->Visible) { // CODIGO_ANTERIOR ?>
	<div id="r_CODIGO_ANTERIOR" class="form-group row">
		<label id="elh_procesos_nuevo_CODIGO_ANTERIOR" for="x_CODIGO_ANTERIOR" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->caption() ?><?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->cellAttributes() ?>>
<span id="el_procesos_nuevo_CODIGO_ANTERIOR">
<input type="text" data-table="procesos_nuevo" data-field="x_CODIGO_ANTERIOR" name="x_CODIGO_ANTERIOR" id="x_CODIGO_ANTERIOR" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->CODIGO_ANTERIOR->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->EditValue ?>"<?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->CODIGO_ANTERIOR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->PROPIEDAD->Visible) { // PROPIEDAD ?>
	<div id="r_PROPIEDAD" class="form-group row">
		<label id="elh_procesos_nuevo_PROPIEDAD" for="x_PROPIEDAD" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->PROPIEDAD->caption() ?><?php echo $procesos_nuevo_edit->PROPIEDAD->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->PROPIEDAD->cellAttributes() ?>>
<span id="el_procesos_nuevo_PROPIEDAD">
<input type="text" data-table="procesos_nuevo" data-field="x_PROPIEDAD" name="x_PROPIEDAD" id="x_PROPIEDAD" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->PROPIEDAD->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->PROPIEDAD->EditValue ?>"<?php echo $procesos_nuevo_edit->PROPIEDAD->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->PROPIEDAD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->SITUACION->Visible) { // SITUACION ?>
	<div id="r_SITUACION" class="form-group row">
		<label id="elh_procesos_nuevo_SITUACION" for="x_SITUACION" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->SITUACION->caption() ?><?php echo $procesos_nuevo_edit->SITUACION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->SITUACION->cellAttributes() ?>>
<span id="el_procesos_nuevo_SITUACION">
<input type="text" data-table="procesos_nuevo" data-field="x_SITUACION" name="x_SITUACION" id="x_SITUACION" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->SITUACION->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->SITUACION->EditValue ?>"<?php echo $procesos_nuevo_edit->SITUACION->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->SITUACION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->OBSERVACIONES->Visible) { // OBSERVACIONES ?>
	<div id="r_OBSERVACIONES" class="form-group row">
		<label id="elh_procesos_nuevo_OBSERVACIONES" for="x_OBSERVACIONES" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->OBSERVACIONES->caption() ?><?php echo $procesos_nuevo_edit->OBSERVACIONES->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->OBSERVACIONES->cellAttributes() ?>>
<span id="el_procesos_nuevo_OBSERVACIONES">
<input type="text" data-table="procesos_nuevo" data-field="x_OBSERVACIONES" name="x_OBSERVACIONES" id="x_OBSERVACIONES" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->OBSERVACIONES->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->OBSERVACIONES->EditValue ?>"<?php echo $procesos_nuevo_edit->OBSERVACIONES->editAttributes() ?>>
</span>
<?php echo $procesos_nuevo_edit->OBSERVACIONES->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($procesos_nuevo_edit->FECHA_REGISTRO->Visible) { // FECHA_REGISTRO ?>
	<div id="r_FECHA_REGISTRO" class="form-group row">
		<label id="elh_procesos_nuevo_FECHA_REGISTRO" for="x_FECHA_REGISTRO" class="<?php echo $procesos_nuevo_edit->LeftColumnClass ?>"><?php echo $procesos_nuevo_edit->FECHA_REGISTRO->caption() ?><?php echo $procesos_nuevo_edit->FECHA_REGISTRO->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $procesos_nuevo_edit->RightColumnClass ?>"><div <?php echo $procesos_nuevo_edit->FECHA_REGISTRO->cellAttributes() ?>>
<span id="el_procesos_nuevo_FECHA_REGISTRO">
<input type="text" data-table="procesos_nuevo" data-field="x_FECHA_REGISTRO" name="x_FECHA_REGISTRO" id="x_FECHA_REGISTRO" maxlength="19" placeholder="<?php echo HtmlEncode($procesos_nuevo_edit->FECHA_REGISTRO->getPlaceHolder()) ?>" value="<?php echo $procesos_nuevo_edit->FECHA_REGISTRO->EditValue ?>"<?php echo $procesos_nuevo_edit->FECHA_REGISTRO->editAttributes() ?>>
<?php if (!$procesos_nuevo_edit->FECHA_REGISTRO->ReadOnly && !$procesos_nuevo_edit->FECHA_REGISTRO->Disabled && !isset($procesos_nuevo_edit->FECHA_REGISTRO->EditAttrs["readonly"]) && !isset($procesos_nuevo_edit->FECHA_REGISTRO->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprocesos_nuevoedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fprocesos_nuevoedit", "x_FECHA_REGISTRO", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $procesos_nuevo_edit->FECHA_REGISTRO->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$procesos_nuevo_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $procesos_nuevo_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $procesos_nuevo_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$procesos_nuevo_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$procesos_nuevo_edit->terminate();
?>