<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$categories_add = new categories_add();

// Run the page
$categories_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$categories_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fcategoriesadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fcategoriesadd = currentForm = new ew.Form("fcategoriesadd", "add");

	// Validate form
	fcategoriesadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($categories_add->courses_id->Required) { ?>
				elm = this.getElements("x" + infix + "_courses_id");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_add->courses_id->caption(), $categories_add->courses_id->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_courses_id");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_add->courses_id->errorMessage()) ?>");
			<?php if ($categories_add->category_name->Required) { ?>
				elm = this.getElements("x" + infix + "_category_name");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_add->category_name->caption(), $categories_add->category_name->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($categories_add->description->Required) { ?>
				elm = this.getElements("x" + infix + "_description");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_add->description->caption(), $categories_add->description->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($categories_add->time->Required) { ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_add->time->caption(), $categories_add->time->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_time");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_add->time->errorMessage()) ?>");
			<?php if ($categories_add->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $categories_add->estado->caption(), $categories_add->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($categories_add->estado->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fcategoriesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fcategoriesadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fcategoriesadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $categories_add->showPageHeader(); ?>
<?php
$categories_add->showMessage();
?>
<form name="fcategoriesadd" id="fcategoriesadd" class="<?php echo $categories_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="categories">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$categories_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($categories_add->courses_id->Visible) { // courses_id ?>
	<div id="r_courses_id" class="form-group row">
		<label id="elh_categories_courses_id" for="x_courses_id" class="<?php echo $categories_add->LeftColumnClass ?>"><?php echo $categories_add->courses_id->caption() ?><?php echo $categories_add->courses_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_add->RightColumnClass ?>"><div <?php echo $categories_add->courses_id->cellAttributes() ?>>
<span id="el_categories_courses_id">
<input type="text" data-table="categories" data-field="x_courses_id" name="x_courses_id" id="x_courses_id" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_add->courses_id->getPlaceHolder()) ?>" value="<?php echo $categories_add->courses_id->EditValue ?>"<?php echo $categories_add->courses_id->editAttributes() ?>>
</span>
<?php echo $categories_add->courses_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_add->category_name->Visible) { // category_name ?>
	<div id="r_category_name" class="form-group row">
		<label id="elh_categories_category_name" for="x_category_name" class="<?php echo $categories_add->LeftColumnClass ?>"><?php echo $categories_add->category_name->caption() ?><?php echo $categories_add->category_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_add->RightColumnClass ?>"><div <?php echo $categories_add->category_name->cellAttributes() ?>>
<span id="el_categories_category_name">
<input type="text" data-table="categories" data-field="x_category_name" name="x_category_name" id="x_category_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($categories_add->category_name->getPlaceHolder()) ?>" value="<?php echo $categories_add->category_name->EditValue ?>"<?php echo $categories_add->category_name->editAttributes() ?>>
</span>
<?php echo $categories_add->category_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_add->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_categories_description" for="x_description" class="<?php echo $categories_add->LeftColumnClass ?>"><?php echo $categories_add->description->caption() ?><?php echo $categories_add->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_add->RightColumnClass ?>"><div <?php echo $categories_add->description->cellAttributes() ?>>
<span id="el_categories_description">
<input type="text" data-table="categories" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($categories_add->description->getPlaceHolder()) ?>" value="<?php echo $categories_add->description->EditValue ?>"<?php echo $categories_add->description->editAttributes() ?>>
</span>
<?php echo $categories_add->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_add->time->Visible) { // time ?>
	<div id="r_time" class="form-group row">
		<label id="elh_categories_time" for="x_time" class="<?php echo $categories_add->LeftColumnClass ?>"><?php echo $categories_add->time->caption() ?><?php echo $categories_add->time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_add->RightColumnClass ?>"><div <?php echo $categories_add->time->cellAttributes() ?>>
<span id="el_categories_time">
<input type="text" data-table="categories" data-field="x_time" name="x_time" id="x_time" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_add->time->getPlaceHolder()) ?>" value="<?php echo $categories_add->time->EditValue ?>"<?php echo $categories_add->time->editAttributes() ?>>
</span>
<?php echo $categories_add->time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($categories_add->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_categories_estado" for="x_estado" class="<?php echo $categories_add->LeftColumnClass ?>"><?php echo $categories_add->estado->caption() ?><?php echo $categories_add->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $categories_add->RightColumnClass ?>"><div <?php echo $categories_add->estado->cellAttributes() ?>>
<span id="el_categories_estado">
<input type="text" data-table="categories" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($categories_add->estado->getPlaceHolder()) ?>" value="<?php echo $categories_add->estado->EditValue ?>"<?php echo $categories_add->estado->editAttributes() ?>>
</span>
<?php echo $categories_add->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$categories_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $categories_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $categories_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$categories_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$categories_add->terminate();
?>