<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class bkp_master_articulos_view extends bkp_master_articulos
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'bkp_master_articulos';

	// Page object name
	public $PageObjName = "bkp_master_articulos_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bkp_master_articulos)
		if (!isset($GLOBALS["bkp_master_articulos"]) || get_class($GLOBALS["bkp_master_articulos"]) == PROJECT_NAMESPACE . "bkp_master_articulos") {
			$GLOBALS["bkp_master_articulos"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bkp_master_articulos"];
		}
		$keyUrl = "";
		if (Get("id_reg") !== NULL) {
			$this->RecKey["id_reg"] = Get("id_reg");
			$keyUrl .= "&amp;id_reg=" . urlencode($this->RecKey["id_reg"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bkp_master_articulos');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $bkp_master_articulos;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($bkp_master_articulos);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bkp_master_articulosview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_reg'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_reg->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bkp_master_articuloslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_reg->setVisibility();
		$this->idempresa->setVisibility();
		$this->idarticuloemp->setVisibility();
		$this->codproveedor->setVisibility();
		$this->estado->setVisibility();
		$this->coddum->setVisibility();
		$this->descripcion->setVisibility();
		$this->descripcioncorta->setVisibility();
		$this->idcategoria->setVisibility();
		$this->articuloaltura->setVisibility();
		$this->articuloancho->setVisibility();
		$this->articulolargo->setVisibility();
		$this->articulopeso->setVisibility();
		$this->articulocosto->setVisibility();
		$this->cajaaltura->setVisibility();
		$this->cajaancho->setVisibility();
		$this->cajalargo->setVisibility();
		$this->cajapeso->setVisibility();
		$this->numpiezas->setVisibility();
		$this->unidadcaja->setVisibility();
		$this->diasventa->setVisibility();
		$this->fecha_reg->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id_reg") !== NULL) {
				$this->id_reg->setQueryStringValue(Get("id_reg"));
				$this->RecKey["id_reg"] = $this->id_reg->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id_reg->setQueryStringValue(Key(0));
				$this->RecKey["id_reg"] = $this->id_reg->QueryStringValue;
			} elseif (Post("id_reg") !== NULL) {
				$this->id_reg->setFormValue(Post("id_reg"));
				$this->RecKey["id_reg"] = $this->id_reg->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id_reg->setFormValue(Route(2));
				$this->RecKey["id_reg"] = $this->id_reg->FormValue;
			} else {
				$returnUrl = "bkp_master_articuloslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = $this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "bkp_master_articuloslist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "bkp_master_articuloslist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl != "" && $Security->isLoggedIn());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->isLoggedIn());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl != "" && $Security->isLoggedIn());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl != "" && $Security->isLoggedIn());

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_reg->setDbValue($row['id_reg']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->idarticuloemp->setDbValue($row['idarticuloemp']);
		$this->codproveedor->setDbValue($row['codproveedor']);
		$this->estado->setDbValue($row['estado']);
		$this->coddum->setDbValue($row['coddum']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcioncorta->setDbValue($row['descripcioncorta']);
		$this->idcategoria->setDbValue($row['idcategoria']);
		$this->articuloaltura->setDbValue($row['articuloaltura']);
		$this->articuloancho->setDbValue($row['articuloancho']);
		$this->articulolargo->setDbValue($row['articulolargo']);
		$this->articulopeso->setDbValue($row['articulopeso']);
		$this->articulocosto->setDbValue($row['articulocosto']);
		$this->cajaaltura->setDbValue($row['cajaaltura']);
		$this->cajaancho->setDbValue($row['cajaancho']);
		$this->cajalargo->setDbValue($row['cajalargo']);
		$this->cajapeso->setDbValue($row['cajapeso']);
		$this->numpiezas->setDbValue($row['numpiezas']);
		$this->unidadcaja->setDbValue($row['unidadcaja']);
		$this->diasventa->setDbValue($row['diasventa']);
		$this->fecha_reg->setDbValue($row['fecha_reg']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_reg'] = NULL;
		$row['idempresa'] = NULL;
		$row['idarticuloemp'] = NULL;
		$row['codproveedor'] = NULL;
		$row['estado'] = NULL;
		$row['coddum'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcioncorta'] = NULL;
		$row['idcategoria'] = NULL;
		$row['articuloaltura'] = NULL;
		$row['articuloancho'] = NULL;
		$row['articulolargo'] = NULL;
		$row['articulopeso'] = NULL;
		$row['articulocosto'] = NULL;
		$row['cajaaltura'] = NULL;
		$row['cajaancho'] = NULL;
		$row['cajalargo'] = NULL;
		$row['cajapeso'] = NULL;
		$row['numpiezas'] = NULL;
		$row['unidadcaja'] = NULL;
		$row['diasventa'] = NULL;
		$row['fecha_reg'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->articuloaltura->FormValue == $this->articuloaltura->CurrentValue && is_numeric(ConvertToFloatString($this->articuloaltura->CurrentValue)))
			$this->articuloaltura->CurrentValue = ConvertToFloatString($this->articuloaltura->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articuloancho->FormValue == $this->articuloancho->CurrentValue && is_numeric(ConvertToFloatString($this->articuloancho->CurrentValue)))
			$this->articuloancho->CurrentValue = ConvertToFloatString($this->articuloancho->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulolargo->FormValue == $this->articulolargo->CurrentValue && is_numeric(ConvertToFloatString($this->articulolargo->CurrentValue)))
			$this->articulolargo->CurrentValue = ConvertToFloatString($this->articulolargo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulopeso->FormValue == $this->articulopeso->CurrentValue && is_numeric(ConvertToFloatString($this->articulopeso->CurrentValue)))
			$this->articulopeso->CurrentValue = ConvertToFloatString($this->articulopeso->CurrentValue);

		// Convert decimal values if posted back
		if ($this->articulocosto->FormValue == $this->articulocosto->CurrentValue && is_numeric(ConvertToFloatString($this->articulocosto->CurrentValue)))
			$this->articulocosto->CurrentValue = ConvertToFloatString($this->articulocosto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajaaltura->FormValue == $this->cajaaltura->CurrentValue && is_numeric(ConvertToFloatString($this->cajaaltura->CurrentValue)))
			$this->cajaaltura->CurrentValue = ConvertToFloatString($this->cajaaltura->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajaancho->FormValue == $this->cajaancho->CurrentValue && is_numeric(ConvertToFloatString($this->cajaancho->CurrentValue)))
			$this->cajaancho->CurrentValue = ConvertToFloatString($this->cajaancho->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajalargo->FormValue == $this->cajalargo->CurrentValue && is_numeric(ConvertToFloatString($this->cajalargo->CurrentValue)))
			$this->cajalargo->CurrentValue = ConvertToFloatString($this->cajalargo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cajapeso->FormValue == $this->cajapeso->CurrentValue && is_numeric(ConvertToFloatString($this->cajapeso->CurrentValue)))
			$this->cajapeso->CurrentValue = ConvertToFloatString($this->cajapeso->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_reg
		// idempresa
		// idarticuloemp
		// codproveedor
		// estado
		// coddum
		// descripcion
		// descripcioncorta
		// idcategoria
		// articuloaltura
		// articuloancho
		// articulolargo
		// articulopeso
		// articulocosto
		// cajaaltura
		// cajaancho
		// cajalargo
		// cajapeso
		// numpiezas
		// unidadcaja
		// diasventa
		// fecha_reg

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_reg
			$this->id_reg->ViewValue = $this->id_reg->CurrentValue;
			$this->id_reg->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// idarticuloemp
			$this->idarticuloemp->ViewValue = $this->idarticuloemp->CurrentValue;
			$this->idarticuloemp->ViewCustomAttributes = "";

			// codproveedor
			$this->codproveedor->ViewValue = $this->codproveedor->CurrentValue;
			$this->codproveedor->ViewValue = FormatNumber($this->codproveedor->ViewValue, 0, -2, -2, -2);
			$this->codproveedor->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewCustomAttributes = "";

			// coddum
			$this->coddum->ViewValue = $this->coddum->CurrentValue;
			$this->coddum->ViewCustomAttributes = "";

			// descripcion
			$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
			$this->descripcion->ViewCustomAttributes = "";

			// descripcioncorta
			$this->descripcioncorta->ViewValue = $this->descripcioncorta->CurrentValue;
			$this->descripcioncorta->ViewCustomAttributes = "";

			// idcategoria
			$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
			$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
			$this->idcategoria->ViewCustomAttributes = "";

			// articuloaltura
			$this->articuloaltura->ViewValue = $this->articuloaltura->CurrentValue;
			$this->articuloaltura->ViewValue = FormatNumber($this->articuloaltura->ViewValue, 2, -2, -2, -2);
			$this->articuloaltura->ViewCustomAttributes = "";

			// articuloancho
			$this->articuloancho->ViewValue = $this->articuloancho->CurrentValue;
			$this->articuloancho->ViewValue = FormatNumber($this->articuloancho->ViewValue, 2, -2, -2, -2);
			$this->articuloancho->ViewCustomAttributes = "";

			// articulolargo
			$this->articulolargo->ViewValue = $this->articulolargo->CurrentValue;
			$this->articulolargo->ViewValue = FormatNumber($this->articulolargo->ViewValue, 2, -2, -2, -2);
			$this->articulolargo->ViewCustomAttributes = "";

			// articulopeso
			$this->articulopeso->ViewValue = $this->articulopeso->CurrentValue;
			$this->articulopeso->ViewValue = FormatNumber($this->articulopeso->ViewValue, 2, -2, -2, -2);
			$this->articulopeso->ViewCustomAttributes = "";

			// articulocosto
			$this->articulocosto->ViewValue = $this->articulocosto->CurrentValue;
			$this->articulocosto->ViewValue = FormatNumber($this->articulocosto->ViewValue, 2, -2, -2, -2);
			$this->articulocosto->ViewCustomAttributes = "";

			// cajaaltura
			$this->cajaaltura->ViewValue = $this->cajaaltura->CurrentValue;
			$this->cajaaltura->ViewValue = FormatNumber($this->cajaaltura->ViewValue, 2, -2, -2, -2);
			$this->cajaaltura->ViewCustomAttributes = "";

			// cajaancho
			$this->cajaancho->ViewValue = $this->cajaancho->CurrentValue;
			$this->cajaancho->ViewValue = FormatNumber($this->cajaancho->ViewValue, 2, -2, -2, -2);
			$this->cajaancho->ViewCustomAttributes = "";

			// cajalargo
			$this->cajalargo->ViewValue = $this->cajalargo->CurrentValue;
			$this->cajalargo->ViewValue = FormatNumber($this->cajalargo->ViewValue, 2, -2, -2, -2);
			$this->cajalargo->ViewCustomAttributes = "";

			// cajapeso
			$this->cajapeso->ViewValue = $this->cajapeso->CurrentValue;
			$this->cajapeso->ViewValue = FormatNumber($this->cajapeso->ViewValue, 2, -2, -2, -2);
			$this->cajapeso->ViewCustomAttributes = "";

			// numpiezas
			$this->numpiezas->ViewValue = $this->numpiezas->CurrentValue;
			$this->numpiezas->ViewValue = FormatNumber($this->numpiezas->ViewValue, 0, -2, -2, -2);
			$this->numpiezas->ViewCustomAttributes = "";

			// unidadcaja
			$this->unidadcaja->ViewValue = $this->unidadcaja->CurrentValue;
			$this->unidadcaja->ViewValue = FormatNumber($this->unidadcaja->ViewValue, 0, -2, -2, -2);
			$this->unidadcaja->ViewCustomAttributes = "";

			// diasventa
			$this->diasventa->ViewValue = $this->diasventa->CurrentValue;
			$this->diasventa->ViewCustomAttributes = "";

			// fecha_reg
			$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
			$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
			$this->fecha_reg->ViewCustomAttributes = "";

			// id_reg
			$this->id_reg->LinkCustomAttributes = "";
			$this->id_reg->HrefValue = "";
			$this->id_reg->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// idarticuloemp
			$this->idarticuloemp->LinkCustomAttributes = "";
			$this->idarticuloemp->HrefValue = "";
			$this->idarticuloemp->TooltipValue = "";

			// codproveedor
			$this->codproveedor->LinkCustomAttributes = "";
			$this->codproveedor->HrefValue = "";
			$this->codproveedor->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// coddum
			$this->coddum->LinkCustomAttributes = "";
			$this->coddum->HrefValue = "";
			$this->coddum->TooltipValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";
			$this->descripcion->TooltipValue = "";

			// descripcioncorta
			$this->descripcioncorta->LinkCustomAttributes = "";
			$this->descripcioncorta->HrefValue = "";
			$this->descripcioncorta->TooltipValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";
			$this->idcategoria->TooltipValue = "";

			// articuloaltura
			$this->articuloaltura->LinkCustomAttributes = "";
			$this->articuloaltura->HrefValue = "";
			$this->articuloaltura->TooltipValue = "";

			// articuloancho
			$this->articuloancho->LinkCustomAttributes = "";
			$this->articuloancho->HrefValue = "";
			$this->articuloancho->TooltipValue = "";

			// articulolargo
			$this->articulolargo->LinkCustomAttributes = "";
			$this->articulolargo->HrefValue = "";
			$this->articulolargo->TooltipValue = "";

			// articulopeso
			$this->articulopeso->LinkCustomAttributes = "";
			$this->articulopeso->HrefValue = "";
			$this->articulopeso->TooltipValue = "";

			// articulocosto
			$this->articulocosto->LinkCustomAttributes = "";
			$this->articulocosto->HrefValue = "";
			$this->articulocosto->TooltipValue = "";

			// cajaaltura
			$this->cajaaltura->LinkCustomAttributes = "";
			$this->cajaaltura->HrefValue = "";
			$this->cajaaltura->TooltipValue = "";

			// cajaancho
			$this->cajaancho->LinkCustomAttributes = "";
			$this->cajaancho->HrefValue = "";
			$this->cajaancho->TooltipValue = "";

			// cajalargo
			$this->cajalargo->LinkCustomAttributes = "";
			$this->cajalargo->HrefValue = "";
			$this->cajalargo->TooltipValue = "";

			// cajapeso
			$this->cajapeso->LinkCustomAttributes = "";
			$this->cajapeso->HrefValue = "";
			$this->cajapeso->TooltipValue = "";

			// numpiezas
			$this->numpiezas->LinkCustomAttributes = "";
			$this->numpiezas->HrefValue = "";
			$this->numpiezas->TooltipValue = "";

			// unidadcaja
			$this->unidadcaja->LinkCustomAttributes = "";
			$this->unidadcaja->HrefValue = "";
			$this->unidadcaja->TooltipValue = "";

			// diasventa
			$this->diasventa->LinkCustomAttributes = "";
			$this->diasventa->HrefValue = "";
			$this->diasventa->TooltipValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
			$this->fecha_reg->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bkp_master_articuloslist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>