<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class clientes_add extends clientes
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'clientes';

	// Page object name
	public $PageObjName = "clientes_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (clientes)
		if (!isset($GLOBALS["clientes"]) || get_class($GLOBALS["clientes"]) == PROJECT_NAMESPACE . "clientes") {
			$GLOBALS["clientes"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["clientes"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'clientes');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $clientes;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($clientes);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "clientesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_cliente'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_cliente->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("clienteslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_cliente->Visible = FALSE;
		$this->nombre_cliente->setVisibility();
		$this->telefono_cliente->setVisibility();
		$this->email_cliente->setVisibility();
		$this->direccion_cliente->setVisibility();
		$this->status_cliente->setVisibility();
		$this->date_added->setVisibility();
		$this->doc->setVisibility();
		$this->vendedor->setVisibility();
		$this->pais->setVisibility();
		$this->departamento->setVisibility();
		$this->provincia->setVisibility();
		$this->distrito->setVisibility();
		$this->cuenta->setVisibility();
		$this->tipo1->setVisibility();
		$this->tienda->setVisibility();
		$this->users->setVisibility();
		$this->deuda->setVisibility();
		$this->debe->setVisibility();
		$this->tipo_documento->setVisibility();
		$this->n_documento->setVisibility();
		$this->deuda1->setVisibility();
		$this->debe1->setVisibility();
		$this->tipo->setVisibility();
		$this->estado->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id_cliente") !== NULL) {
				$this->id_cliente->setQueryStringValue(Get("id_cliente"));
				$this->setKey("id_cliente", $this->id_cliente->CurrentValue); // Set up key
			} else {
				$this->setKey("id_cliente", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("clienteslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "clienteslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "clientesview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id_cliente->CurrentValue = NULL;
		$this->id_cliente->OldValue = $this->id_cliente->CurrentValue;
		$this->nombre_cliente->CurrentValue = NULL;
		$this->nombre_cliente->OldValue = $this->nombre_cliente->CurrentValue;
		$this->telefono_cliente->CurrentValue = NULL;
		$this->telefono_cliente->OldValue = $this->telefono_cliente->CurrentValue;
		$this->email_cliente->CurrentValue = NULL;
		$this->email_cliente->OldValue = $this->email_cliente->CurrentValue;
		$this->direccion_cliente->CurrentValue = NULL;
		$this->direccion_cliente->OldValue = $this->direccion_cliente->CurrentValue;
		$this->status_cliente->CurrentValue = NULL;
		$this->status_cliente->OldValue = $this->status_cliente->CurrentValue;
		$this->date_added->CurrentValue = NULL;
		$this->date_added->OldValue = $this->date_added->CurrentValue;
		$this->doc->CurrentValue = NULL;
		$this->doc->OldValue = $this->doc->CurrentValue;
		$this->vendedor->CurrentValue = NULL;
		$this->vendedor->OldValue = $this->vendedor->CurrentValue;
		$this->pais->CurrentValue = NULL;
		$this->pais->OldValue = $this->pais->CurrentValue;
		$this->departamento->CurrentValue = NULL;
		$this->departamento->OldValue = $this->departamento->CurrentValue;
		$this->provincia->CurrentValue = NULL;
		$this->provincia->OldValue = $this->provincia->CurrentValue;
		$this->distrito->CurrentValue = NULL;
		$this->distrito->OldValue = $this->distrito->CurrentValue;
		$this->cuenta->CurrentValue = NULL;
		$this->cuenta->OldValue = $this->cuenta->CurrentValue;
		$this->tipo1->CurrentValue = NULL;
		$this->tipo1->OldValue = $this->tipo1->CurrentValue;
		$this->tienda->CurrentValue = NULL;
		$this->tienda->OldValue = $this->tienda->CurrentValue;
		$this->users->CurrentValue = NULL;
		$this->users->OldValue = $this->users->CurrentValue;
		$this->deuda->CurrentValue = NULL;
		$this->deuda->OldValue = $this->deuda->CurrentValue;
		$this->debe->CurrentValue = NULL;
		$this->debe->OldValue = $this->debe->CurrentValue;
		$this->tipo_documento->CurrentValue = NULL;
		$this->tipo_documento->OldValue = $this->tipo_documento->CurrentValue;
		$this->n_documento->CurrentValue = NULL;
		$this->n_documento->OldValue = $this->n_documento->CurrentValue;
		$this->deuda1->CurrentValue = NULL;
		$this->deuda1->OldValue = $this->deuda1->CurrentValue;
		$this->debe1->CurrentValue = NULL;
		$this->debe1->OldValue = $this->debe1->CurrentValue;
		$this->tipo->CurrentValue = 1;
		$this->estado->CurrentValue = 1;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'nombre_cliente' first before field var 'x_nombre_cliente'
		$val = $CurrentForm->hasValue("nombre_cliente") ? $CurrentForm->getValue("nombre_cliente") : $CurrentForm->getValue("x_nombre_cliente");
		if (!$this->nombre_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombre_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->nombre_cliente->setFormValue($val);
		}

		// Check field name 'telefono_cliente' first before field var 'x_telefono_cliente'
		$val = $CurrentForm->hasValue("telefono_cliente") ? $CurrentForm->getValue("telefono_cliente") : $CurrentForm->getValue("x_telefono_cliente");
		if (!$this->telefono_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->telefono_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->telefono_cliente->setFormValue($val);
		}

		// Check field name 'email_cliente' first before field var 'x_email_cliente'
		$val = $CurrentForm->hasValue("email_cliente") ? $CurrentForm->getValue("email_cliente") : $CurrentForm->getValue("x_email_cliente");
		if (!$this->email_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->email_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->email_cliente->setFormValue($val);
		}

		// Check field name 'direccion_cliente' first before field var 'x_direccion_cliente'
		$val = $CurrentForm->hasValue("direccion_cliente") ? $CurrentForm->getValue("direccion_cliente") : $CurrentForm->getValue("x_direccion_cliente");
		if (!$this->direccion_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->direccion_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->direccion_cliente->setFormValue($val);
		}

		// Check field name 'status_cliente' first before field var 'x_status_cliente'
		$val = $CurrentForm->hasValue("status_cliente") ? $CurrentForm->getValue("status_cliente") : $CurrentForm->getValue("x_status_cliente");
		if (!$this->status_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->status_cliente->setFormValue($val);
		}

		// Check field name 'date_added' first before field var 'x_date_added'
		$val = $CurrentForm->hasValue("date_added") ? $CurrentForm->getValue("date_added") : $CurrentForm->getValue("x_date_added");
		if (!$this->date_added->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date_added->Visible = FALSE; // Disable update for API request
			else
				$this->date_added->setFormValue($val);
			$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		}

		// Check field name 'doc' first before field var 'x_doc'
		$val = $CurrentForm->hasValue("doc") ? $CurrentForm->getValue("doc") : $CurrentForm->getValue("x_doc");
		if (!$this->doc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->doc->Visible = FALSE; // Disable update for API request
			else
				$this->doc->setFormValue($val);
		}

		// Check field name 'vendedor' first before field var 'x_vendedor'
		$val = $CurrentForm->hasValue("vendedor") ? $CurrentForm->getValue("vendedor") : $CurrentForm->getValue("x_vendedor");
		if (!$this->vendedor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vendedor->Visible = FALSE; // Disable update for API request
			else
				$this->vendedor->setFormValue($val);
		}

		// Check field name 'pais' first before field var 'x_pais'
		$val = $CurrentForm->hasValue("pais") ? $CurrentForm->getValue("pais") : $CurrentForm->getValue("x_pais");
		if (!$this->pais->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pais->Visible = FALSE; // Disable update for API request
			else
				$this->pais->setFormValue($val);
		}

		// Check field name 'departamento' first before field var 'x_departamento'
		$val = $CurrentForm->hasValue("departamento") ? $CurrentForm->getValue("departamento") : $CurrentForm->getValue("x_departamento");
		if (!$this->departamento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->departamento->Visible = FALSE; // Disable update for API request
			else
				$this->departamento->setFormValue($val);
		}

		// Check field name 'provincia' first before field var 'x_provincia'
		$val = $CurrentForm->hasValue("provincia") ? $CurrentForm->getValue("provincia") : $CurrentForm->getValue("x_provincia");
		if (!$this->provincia->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->provincia->Visible = FALSE; // Disable update for API request
			else
				$this->provincia->setFormValue($val);
		}

		// Check field name 'distrito' first before field var 'x_distrito'
		$val = $CurrentForm->hasValue("distrito") ? $CurrentForm->getValue("distrito") : $CurrentForm->getValue("x_distrito");
		if (!$this->distrito->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->distrito->Visible = FALSE; // Disable update for API request
			else
				$this->distrito->setFormValue($val);
		}

		// Check field name 'cuenta' first before field var 'x_cuenta'
		$val = $CurrentForm->hasValue("cuenta") ? $CurrentForm->getValue("cuenta") : $CurrentForm->getValue("x_cuenta");
		if (!$this->cuenta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cuenta->Visible = FALSE; // Disable update for API request
			else
				$this->cuenta->setFormValue($val);
		}

		// Check field name 'tipo1' first before field var 'x_tipo1'
		$val = $CurrentForm->hasValue("tipo1") ? $CurrentForm->getValue("tipo1") : $CurrentForm->getValue("x_tipo1");
		if (!$this->tipo1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo1->Visible = FALSE; // Disable update for API request
			else
				$this->tipo1->setFormValue($val);
		}

		// Check field name 'tienda' first before field var 'x_tienda'
		$val = $CurrentForm->hasValue("tienda") ? $CurrentForm->getValue("tienda") : $CurrentForm->getValue("x_tienda");
		if (!$this->tienda->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tienda->Visible = FALSE; // Disable update for API request
			else
				$this->tienda->setFormValue($val);
		}

		// Check field name 'users' first before field var 'x_users'
		$val = $CurrentForm->hasValue("users") ? $CurrentForm->getValue("users") : $CurrentForm->getValue("x_users");
		if (!$this->users->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->users->Visible = FALSE; // Disable update for API request
			else
				$this->users->setFormValue($val);
		}

		// Check field name 'deuda' first before field var 'x_deuda'
		$val = $CurrentForm->hasValue("deuda") ? $CurrentForm->getValue("deuda") : $CurrentForm->getValue("x_deuda");
		if (!$this->deuda->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deuda->Visible = FALSE; // Disable update for API request
			else
				$this->deuda->setFormValue($val);
		}

		// Check field name 'debe' first before field var 'x_debe'
		$val = $CurrentForm->hasValue("debe") ? $CurrentForm->getValue("debe") : $CurrentForm->getValue("x_debe");
		if (!$this->debe->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->debe->Visible = FALSE; // Disable update for API request
			else
				$this->debe->setFormValue($val);
		}

		// Check field name 'tipo_documento' first before field var 'x_tipo_documento'
		$val = $CurrentForm->hasValue("tipo_documento") ? $CurrentForm->getValue("tipo_documento") : $CurrentForm->getValue("x_tipo_documento");
		if (!$this->tipo_documento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_documento->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_documento->setFormValue($val);
		}

		// Check field name 'n_documento' first before field var 'x_n_documento'
		$val = $CurrentForm->hasValue("n_documento") ? $CurrentForm->getValue("n_documento") : $CurrentForm->getValue("x_n_documento");
		if (!$this->n_documento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->n_documento->Visible = FALSE; // Disable update for API request
			else
				$this->n_documento->setFormValue($val);
		}

		// Check field name 'deuda1' first before field var 'x_deuda1'
		$val = $CurrentForm->hasValue("deuda1") ? $CurrentForm->getValue("deuda1") : $CurrentForm->getValue("x_deuda1");
		if (!$this->deuda1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deuda1->Visible = FALSE; // Disable update for API request
			else
				$this->deuda1->setFormValue($val);
		}

		// Check field name 'debe1' first before field var 'x_debe1'
		$val = $CurrentForm->hasValue("debe1") ? $CurrentForm->getValue("debe1") : $CurrentForm->getValue("x_debe1");
		if (!$this->debe1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->debe1->Visible = FALSE; // Disable update for API request
			else
				$this->debe1->setFormValue($val);
		}

		// Check field name 'tipo' first before field var 'x_tipo'
		$val = $CurrentForm->hasValue("tipo") ? $CurrentForm->getValue("tipo") : $CurrentForm->getValue("x_tipo");
		if (!$this->tipo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo->Visible = FALSE; // Disable update for API request
			else
				$this->tipo->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'id_cliente' first before field var 'x_id_cliente'
		$val = $CurrentForm->hasValue("id_cliente") ? $CurrentForm->getValue("id_cliente") : $CurrentForm->getValue("x_id_cliente");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->nombre_cliente->CurrentValue = $this->nombre_cliente->FormValue;
		$this->telefono_cliente->CurrentValue = $this->telefono_cliente->FormValue;
		$this->email_cliente->CurrentValue = $this->email_cliente->FormValue;
		$this->direccion_cliente->CurrentValue = $this->direccion_cliente->FormValue;
		$this->status_cliente->CurrentValue = $this->status_cliente->FormValue;
		$this->date_added->CurrentValue = $this->date_added->FormValue;
		$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		$this->doc->CurrentValue = $this->doc->FormValue;
		$this->vendedor->CurrentValue = $this->vendedor->FormValue;
		$this->pais->CurrentValue = $this->pais->FormValue;
		$this->departamento->CurrentValue = $this->departamento->FormValue;
		$this->provincia->CurrentValue = $this->provincia->FormValue;
		$this->distrito->CurrentValue = $this->distrito->FormValue;
		$this->cuenta->CurrentValue = $this->cuenta->FormValue;
		$this->tipo1->CurrentValue = $this->tipo1->FormValue;
		$this->tienda->CurrentValue = $this->tienda->FormValue;
		$this->users->CurrentValue = $this->users->FormValue;
		$this->deuda->CurrentValue = $this->deuda->FormValue;
		$this->debe->CurrentValue = $this->debe->FormValue;
		$this->tipo_documento->CurrentValue = $this->tipo_documento->FormValue;
		$this->n_documento->CurrentValue = $this->n_documento->FormValue;
		$this->deuda1->CurrentValue = $this->deuda1->FormValue;
		$this->debe1->CurrentValue = $this->debe1->FormValue;
		$this->tipo->CurrentValue = $this->tipo->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_cliente->setDbValue($row['id_cliente']);
		$this->nombre_cliente->setDbValue($row['nombre_cliente']);
		$this->telefono_cliente->setDbValue($row['telefono_cliente']);
		$this->email_cliente->setDbValue($row['email_cliente']);
		$this->direccion_cliente->setDbValue($row['direccion_cliente']);
		$this->status_cliente->setDbValue($row['status_cliente']);
		$this->date_added->setDbValue($row['date_added']);
		$this->doc->setDbValue($row['doc']);
		$this->vendedor->setDbValue($row['vendedor']);
		$this->pais->setDbValue($row['pais']);
		$this->departamento->setDbValue($row['departamento']);
		$this->provincia->setDbValue($row['provincia']);
		$this->distrito->setDbValue($row['distrito']);
		$this->cuenta->setDbValue($row['cuenta']);
		$this->tipo1->setDbValue($row['tipo1']);
		$this->tienda->setDbValue($row['tienda']);
		$this->users->setDbValue($row['users']);
		$this->deuda->setDbValue($row['deuda']);
		$this->debe->setDbValue($row['debe']);
		$this->tipo_documento->setDbValue($row['tipo_documento']);
		$this->n_documento->setDbValue($row['n_documento']);
		$this->deuda1->setDbValue($row['deuda1']);
		$this->debe1->setDbValue($row['debe1']);
		$this->tipo->setDbValue($row['tipo']);
		$this->estado->setDbValue($row['estado']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id_cliente'] = $this->id_cliente->CurrentValue;
		$row['nombre_cliente'] = $this->nombre_cliente->CurrentValue;
		$row['telefono_cliente'] = $this->telefono_cliente->CurrentValue;
		$row['email_cliente'] = $this->email_cliente->CurrentValue;
		$row['direccion_cliente'] = $this->direccion_cliente->CurrentValue;
		$row['status_cliente'] = $this->status_cliente->CurrentValue;
		$row['date_added'] = $this->date_added->CurrentValue;
		$row['doc'] = $this->doc->CurrentValue;
		$row['vendedor'] = $this->vendedor->CurrentValue;
		$row['pais'] = $this->pais->CurrentValue;
		$row['departamento'] = $this->departamento->CurrentValue;
		$row['provincia'] = $this->provincia->CurrentValue;
		$row['distrito'] = $this->distrito->CurrentValue;
		$row['cuenta'] = $this->cuenta->CurrentValue;
		$row['tipo1'] = $this->tipo1->CurrentValue;
		$row['tienda'] = $this->tienda->CurrentValue;
		$row['users'] = $this->users->CurrentValue;
		$row['deuda'] = $this->deuda->CurrentValue;
		$row['debe'] = $this->debe->CurrentValue;
		$row['tipo_documento'] = $this->tipo_documento->CurrentValue;
		$row['n_documento'] = $this->n_documento->CurrentValue;
		$row['deuda1'] = $this->deuda1->CurrentValue;
		$row['debe1'] = $this->debe1->CurrentValue;
		$row['tipo'] = $this->tipo->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_cliente")) != "")
			$this->id_cliente->OldValue = $this->getKey("id_cliente"); // id_cliente
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->deuda->FormValue == $this->deuda->CurrentValue && is_numeric(ConvertToFloatString($this->deuda->CurrentValue)))
			$this->deuda->CurrentValue = ConvertToFloatString($this->deuda->CurrentValue);

		// Convert decimal values if posted back
		if ($this->debe->FormValue == $this->debe->CurrentValue && is_numeric(ConvertToFloatString($this->debe->CurrentValue)))
			$this->debe->CurrentValue = ConvertToFloatString($this->debe->CurrentValue);

		// Convert decimal values if posted back
		if ($this->deuda1->FormValue == $this->deuda1->CurrentValue && is_numeric(ConvertToFloatString($this->deuda1->CurrentValue)))
			$this->deuda1->CurrentValue = ConvertToFloatString($this->deuda1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->debe1->FormValue == $this->debe1->CurrentValue && is_numeric(ConvertToFloatString($this->debe1->CurrentValue)))
			$this->debe1->CurrentValue = ConvertToFloatString($this->debe1->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_cliente
		// nombre_cliente
		// telefono_cliente
		// email_cliente
		// direccion_cliente
		// status_cliente
		// date_added
		// doc
		// vendedor
		// pais
		// departamento
		// provincia
		// distrito
		// cuenta
		// tipo1
		// tienda
		// users
		// deuda
		// debe
		// tipo_documento
		// n_documento
		// deuda1
		// debe1
		// tipo
		// estado

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_cliente
			$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
			$this->id_cliente->ViewCustomAttributes = "";

			// nombre_cliente
			$this->nombre_cliente->ViewValue = $this->nombre_cliente->CurrentValue;
			$this->nombre_cliente->ViewCustomAttributes = "";

			// telefono_cliente
			$this->telefono_cliente->ViewValue = $this->telefono_cliente->CurrentValue;
			$this->telefono_cliente->ViewCustomAttributes = "";

			// email_cliente
			$this->email_cliente->ViewValue = $this->email_cliente->CurrentValue;
			$this->email_cliente->ViewCustomAttributes = "";

			// direccion_cliente
			$this->direccion_cliente->ViewValue = $this->direccion_cliente->CurrentValue;
			$this->direccion_cliente->ViewCustomAttributes = "";

			// status_cliente
			$this->status_cliente->ViewValue = $this->status_cliente->CurrentValue;
			$this->status_cliente->ViewValue = FormatNumber($this->status_cliente->ViewValue, 0, -2, -2, -2);
			$this->status_cliente->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// doc
			$this->doc->ViewValue = $this->doc->CurrentValue;
			$this->doc->ViewCustomAttributes = "";

			// vendedor
			$this->vendedor->ViewValue = $this->vendedor->CurrentValue;
			$this->vendedor->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// departamento
			$this->departamento->ViewValue = $this->departamento->CurrentValue;
			$this->departamento->ViewCustomAttributes = "";

			// provincia
			$this->provincia->ViewValue = $this->provincia->CurrentValue;
			$this->provincia->ViewCustomAttributes = "";

			// distrito
			$this->distrito->ViewValue = $this->distrito->CurrentValue;
			$this->distrito->ViewCustomAttributes = "";

			// cuenta
			$this->cuenta->ViewValue = $this->cuenta->CurrentValue;
			$this->cuenta->ViewCustomAttributes = "";

			// tipo1
			$this->tipo1->ViewValue = $this->tipo1->CurrentValue;
			$this->tipo1->ViewValue = FormatNumber($this->tipo1->ViewValue, 0, -2, -2, -2);
			$this->tipo1->ViewCustomAttributes = "";

			// tienda
			$this->tienda->ViewValue = $this->tienda->CurrentValue;
			$this->tienda->ViewValue = FormatNumber($this->tienda->ViewValue, 0, -2, -2, -2);
			$this->tienda->ViewCustomAttributes = "";

			// users
			$this->users->ViewValue = $this->users->CurrentValue;
			$this->users->ViewValue = FormatNumber($this->users->ViewValue, 0, -2, -2, -2);
			$this->users->ViewCustomAttributes = "";

			// deuda
			$this->deuda->ViewValue = $this->deuda->CurrentValue;
			$this->deuda->ViewValue = FormatNumber($this->deuda->ViewValue, 2, -2, -2, -2);
			$this->deuda->ViewCustomAttributes = "";

			// debe
			$this->debe->ViewValue = $this->debe->CurrentValue;
			$this->debe->ViewValue = FormatNumber($this->debe->ViewValue, 2, -2, -2, -2);
			$this->debe->ViewCustomAttributes = "";

			// tipo_documento
			$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
			$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
			$this->tipo_documento->ViewCustomAttributes = "";

			// n_documento
			$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
			$this->n_documento->ViewCustomAttributes = "";

			// deuda1
			$this->deuda1->ViewValue = $this->deuda1->CurrentValue;
			$this->deuda1->ViewValue = FormatNumber($this->deuda1->ViewValue, 2, -2, -2, -2);
			$this->deuda1->ViewCustomAttributes = "";

			// debe1
			$this->debe1->ViewValue = $this->debe1->CurrentValue;
			$this->debe1->ViewValue = FormatNumber($this->debe1->ViewValue, 2, -2, -2, -2);
			$this->debe1->ViewCustomAttributes = "";

			// tipo
			$this->tipo->ViewValue = $this->tipo->CurrentValue;
			$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
			$this->tipo->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// nombre_cliente
			$this->nombre_cliente->LinkCustomAttributes = "";
			$this->nombre_cliente->HrefValue = "";
			$this->nombre_cliente->TooltipValue = "";

			// telefono_cliente
			$this->telefono_cliente->LinkCustomAttributes = "";
			$this->telefono_cliente->HrefValue = "";
			$this->telefono_cliente->TooltipValue = "";

			// email_cliente
			$this->email_cliente->LinkCustomAttributes = "";
			$this->email_cliente->HrefValue = "";
			$this->email_cliente->TooltipValue = "";

			// direccion_cliente
			$this->direccion_cliente->LinkCustomAttributes = "";
			$this->direccion_cliente->HrefValue = "";
			$this->direccion_cliente->TooltipValue = "";

			// status_cliente
			$this->status_cliente->LinkCustomAttributes = "";
			$this->status_cliente->HrefValue = "";
			$this->status_cliente->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// doc
			$this->doc->LinkCustomAttributes = "";
			$this->doc->HrefValue = "";
			$this->doc->TooltipValue = "";

			// vendedor
			$this->vendedor->LinkCustomAttributes = "";
			$this->vendedor->HrefValue = "";
			$this->vendedor->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";
			$this->departamento->TooltipValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";
			$this->provincia->TooltipValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";
			$this->distrito->TooltipValue = "";

			// cuenta
			$this->cuenta->LinkCustomAttributes = "";
			$this->cuenta->HrefValue = "";
			$this->cuenta->TooltipValue = "";

			// tipo1
			$this->tipo1->LinkCustomAttributes = "";
			$this->tipo1->HrefValue = "";
			$this->tipo1->TooltipValue = "";

			// tienda
			$this->tienda->LinkCustomAttributes = "";
			$this->tienda->HrefValue = "";
			$this->tienda->TooltipValue = "";

			// users
			$this->users->LinkCustomAttributes = "";
			$this->users->HrefValue = "";
			$this->users->TooltipValue = "";

			// deuda
			$this->deuda->LinkCustomAttributes = "";
			$this->deuda->HrefValue = "";
			$this->deuda->TooltipValue = "";

			// debe
			$this->debe->LinkCustomAttributes = "";
			$this->debe->HrefValue = "";
			$this->debe->TooltipValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";
			$this->tipo_documento->TooltipValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";
			$this->n_documento->TooltipValue = "";

			// deuda1
			$this->deuda1->LinkCustomAttributes = "";
			$this->deuda1->HrefValue = "";
			$this->deuda1->TooltipValue = "";

			// debe1
			$this->debe1->LinkCustomAttributes = "";
			$this->debe1->HrefValue = "";
			$this->debe1->TooltipValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";
			$this->tipo->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// nombre_cliente
			$this->nombre_cliente->EditAttrs["class"] = "form-control";
			$this->nombre_cliente->EditCustomAttributes = "";
			if (!$this->nombre_cliente->Raw)
				$this->nombre_cliente->CurrentValue = HtmlDecode($this->nombre_cliente->CurrentValue);
			$this->nombre_cliente->EditValue = HtmlEncode($this->nombre_cliente->CurrentValue);
			$this->nombre_cliente->PlaceHolder = RemoveHtml($this->nombre_cliente->caption());

			// telefono_cliente
			$this->telefono_cliente->EditAttrs["class"] = "form-control";
			$this->telefono_cliente->EditCustomAttributes = "";
			if (!$this->telefono_cliente->Raw)
				$this->telefono_cliente->CurrentValue = HtmlDecode($this->telefono_cliente->CurrentValue);
			$this->telefono_cliente->EditValue = HtmlEncode($this->telefono_cliente->CurrentValue);
			$this->telefono_cliente->PlaceHolder = RemoveHtml($this->telefono_cliente->caption());

			// email_cliente
			$this->email_cliente->EditAttrs["class"] = "form-control";
			$this->email_cliente->EditCustomAttributes = "";
			if (!$this->email_cliente->Raw)
				$this->email_cliente->CurrentValue = HtmlDecode($this->email_cliente->CurrentValue);
			$this->email_cliente->EditValue = HtmlEncode($this->email_cliente->CurrentValue);
			$this->email_cliente->PlaceHolder = RemoveHtml($this->email_cliente->caption());

			// direccion_cliente
			$this->direccion_cliente->EditAttrs["class"] = "form-control";
			$this->direccion_cliente->EditCustomAttributes = "";
			if (!$this->direccion_cliente->Raw)
				$this->direccion_cliente->CurrentValue = HtmlDecode($this->direccion_cliente->CurrentValue);
			$this->direccion_cliente->EditValue = HtmlEncode($this->direccion_cliente->CurrentValue);
			$this->direccion_cliente->PlaceHolder = RemoveHtml($this->direccion_cliente->caption());

			// status_cliente
			$this->status_cliente->EditAttrs["class"] = "form-control";
			$this->status_cliente->EditCustomAttributes = "";
			$this->status_cliente->EditValue = HtmlEncode($this->status_cliente->CurrentValue);
			$this->status_cliente->PlaceHolder = RemoveHtml($this->status_cliente->caption());

			// date_added
			$this->date_added->EditAttrs["class"] = "form-control";
			$this->date_added->EditCustomAttributes = "";
			$this->date_added->EditValue = HtmlEncode(FormatDateTime($this->date_added->CurrentValue, 8));
			$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

			// doc
			$this->doc->EditAttrs["class"] = "form-control";
			$this->doc->EditCustomAttributes = "";
			if (!$this->doc->Raw)
				$this->doc->CurrentValue = HtmlDecode($this->doc->CurrentValue);
			$this->doc->EditValue = HtmlEncode($this->doc->CurrentValue);
			$this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

			// vendedor
			$this->vendedor->EditAttrs["class"] = "form-control";
			$this->vendedor->EditCustomAttributes = "";
			if (!$this->vendedor->Raw)
				$this->vendedor->CurrentValue = HtmlDecode($this->vendedor->CurrentValue);
			$this->vendedor->EditValue = HtmlEncode($this->vendedor->CurrentValue);
			$this->vendedor->PlaceHolder = RemoveHtml($this->vendedor->caption());

			// pais
			$this->pais->EditAttrs["class"] = "form-control";
			$this->pais->EditCustomAttributes = "";
			$this->pais->EditValue = HtmlEncode($this->pais->CurrentValue);
			$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

			// departamento
			$this->departamento->EditAttrs["class"] = "form-control";
			$this->departamento->EditCustomAttributes = "";
			$this->departamento->EditValue = HtmlEncode($this->departamento->CurrentValue);
			$this->departamento->PlaceHolder = RemoveHtml($this->departamento->caption());

			// provincia
			$this->provincia->EditAttrs["class"] = "form-control";
			$this->provincia->EditCustomAttributes = "";
			$this->provincia->EditValue = HtmlEncode($this->provincia->CurrentValue);
			$this->provincia->PlaceHolder = RemoveHtml($this->provincia->caption());

			// distrito
			$this->distrito->EditAttrs["class"] = "form-control";
			$this->distrito->EditCustomAttributes = "";
			$this->distrito->EditValue = HtmlEncode($this->distrito->CurrentValue);
			$this->distrito->PlaceHolder = RemoveHtml($this->distrito->caption());

			// cuenta
			$this->cuenta->EditAttrs["class"] = "form-control";
			$this->cuenta->EditCustomAttributes = "";
			$this->cuenta->EditValue = HtmlEncode($this->cuenta->CurrentValue);
			$this->cuenta->PlaceHolder = RemoveHtml($this->cuenta->caption());

			// tipo1
			$this->tipo1->EditAttrs["class"] = "form-control";
			$this->tipo1->EditCustomAttributes = "";
			$this->tipo1->EditValue = HtmlEncode($this->tipo1->CurrentValue);
			$this->tipo1->PlaceHolder = RemoveHtml($this->tipo1->caption());

			// tienda
			$this->tienda->EditAttrs["class"] = "form-control";
			$this->tienda->EditCustomAttributes = "";
			$this->tienda->EditValue = HtmlEncode($this->tienda->CurrentValue);
			$this->tienda->PlaceHolder = RemoveHtml($this->tienda->caption());

			// users
			$this->users->EditAttrs["class"] = "form-control";
			$this->users->EditCustomAttributes = "";
			$this->users->EditValue = HtmlEncode($this->users->CurrentValue);
			$this->users->PlaceHolder = RemoveHtml($this->users->caption());

			// deuda
			$this->deuda->EditAttrs["class"] = "form-control";
			$this->deuda->EditCustomAttributes = "";
			$this->deuda->EditValue = HtmlEncode($this->deuda->CurrentValue);
			$this->deuda->PlaceHolder = RemoveHtml($this->deuda->caption());
			if (strval($this->deuda->EditValue) != "" && is_numeric($this->deuda->EditValue))
				$this->deuda->EditValue = FormatNumber($this->deuda->EditValue, -2, -2, -2, -2);
			

			// debe
			$this->debe->EditAttrs["class"] = "form-control";
			$this->debe->EditCustomAttributes = "";
			$this->debe->EditValue = HtmlEncode($this->debe->CurrentValue);
			$this->debe->PlaceHolder = RemoveHtml($this->debe->caption());
			if (strval($this->debe->EditValue) != "" && is_numeric($this->debe->EditValue))
				$this->debe->EditValue = FormatNumber($this->debe->EditValue, -2, -2, -2, -2);
			

			// tipo_documento
			$this->tipo_documento->EditAttrs["class"] = "form-control";
			$this->tipo_documento->EditCustomAttributes = "";
			$this->tipo_documento->EditValue = HtmlEncode($this->tipo_documento->CurrentValue);
			$this->tipo_documento->PlaceHolder = RemoveHtml($this->tipo_documento->caption());

			// n_documento
			$this->n_documento->EditAttrs["class"] = "form-control";
			$this->n_documento->EditCustomAttributes = "";
			if (!$this->n_documento->Raw)
				$this->n_documento->CurrentValue = HtmlDecode($this->n_documento->CurrentValue);
			$this->n_documento->EditValue = HtmlEncode($this->n_documento->CurrentValue);
			$this->n_documento->PlaceHolder = RemoveHtml($this->n_documento->caption());

			// deuda1
			$this->deuda1->EditAttrs["class"] = "form-control";
			$this->deuda1->EditCustomAttributes = "";
			$this->deuda1->EditValue = HtmlEncode($this->deuda1->CurrentValue);
			$this->deuda1->PlaceHolder = RemoveHtml($this->deuda1->caption());
			if (strval($this->deuda1->EditValue) != "" && is_numeric($this->deuda1->EditValue))
				$this->deuda1->EditValue = FormatNumber($this->deuda1->EditValue, -2, -2, -2, -2);
			

			// debe1
			$this->debe1->EditAttrs["class"] = "form-control";
			$this->debe1->EditCustomAttributes = "";
			$this->debe1->EditValue = HtmlEncode($this->debe1->CurrentValue);
			$this->debe1->PlaceHolder = RemoveHtml($this->debe1->caption());
			if (strval($this->debe1->EditValue) != "" && is_numeric($this->debe1->EditValue))
				$this->debe1->EditValue = FormatNumber($this->debe1->EditValue, -2, -2, -2, -2);
			

			// tipo
			$this->tipo->EditAttrs["class"] = "form-control";
			$this->tipo->EditCustomAttributes = "";
			$this->tipo->EditValue = HtmlEncode($this->tipo->CurrentValue);
			$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// Add refer script
			// nombre_cliente

			$this->nombre_cliente->LinkCustomAttributes = "";
			$this->nombre_cliente->HrefValue = "";

			// telefono_cliente
			$this->telefono_cliente->LinkCustomAttributes = "";
			$this->telefono_cliente->HrefValue = "";

			// email_cliente
			$this->email_cliente->LinkCustomAttributes = "";
			$this->email_cliente->HrefValue = "";

			// direccion_cliente
			$this->direccion_cliente->LinkCustomAttributes = "";
			$this->direccion_cliente->HrefValue = "";

			// status_cliente
			$this->status_cliente->LinkCustomAttributes = "";
			$this->status_cliente->HrefValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";

			// doc
			$this->doc->LinkCustomAttributes = "";
			$this->doc->HrefValue = "";

			// vendedor
			$this->vendedor->LinkCustomAttributes = "";
			$this->vendedor->HrefValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";

			// departamento
			$this->departamento->LinkCustomAttributes = "";
			$this->departamento->HrefValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";

			// distrito
			$this->distrito->LinkCustomAttributes = "";
			$this->distrito->HrefValue = "";

			// cuenta
			$this->cuenta->LinkCustomAttributes = "";
			$this->cuenta->HrefValue = "";

			// tipo1
			$this->tipo1->LinkCustomAttributes = "";
			$this->tipo1->HrefValue = "";

			// tienda
			$this->tienda->LinkCustomAttributes = "";
			$this->tienda->HrefValue = "";

			// users
			$this->users->LinkCustomAttributes = "";
			$this->users->HrefValue = "";

			// deuda
			$this->deuda->LinkCustomAttributes = "";
			$this->deuda->HrefValue = "";

			// debe
			$this->debe->LinkCustomAttributes = "";
			$this->debe->HrefValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";

			// deuda1
			$this->deuda1->LinkCustomAttributes = "";
			$this->deuda1->HrefValue = "";

			// debe1
			$this->debe1->LinkCustomAttributes = "";
			$this->debe1->HrefValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->nombre_cliente->Required) {
			if (!$this->nombre_cliente->IsDetailKey && $this->nombre_cliente->FormValue != NULL && $this->nombre_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombre_cliente->caption(), $this->nombre_cliente->RequiredErrorMessage));
			}
		}
		if ($this->telefono_cliente->Required) {
			if (!$this->telefono_cliente->IsDetailKey && $this->telefono_cliente->FormValue != NULL && $this->telefono_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->telefono_cliente->caption(), $this->telefono_cliente->RequiredErrorMessage));
			}
		}
		if ($this->email_cliente->Required) {
			if (!$this->email_cliente->IsDetailKey && $this->email_cliente->FormValue != NULL && $this->email_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->email_cliente->caption(), $this->email_cliente->RequiredErrorMessage));
			}
		}
		if ($this->direccion_cliente->Required) {
			if (!$this->direccion_cliente->IsDetailKey && $this->direccion_cliente->FormValue != NULL && $this->direccion_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->direccion_cliente->caption(), $this->direccion_cliente->RequiredErrorMessage));
			}
		}
		if ($this->status_cliente->Required) {
			if (!$this->status_cliente->IsDetailKey && $this->status_cliente->FormValue != NULL && $this->status_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_cliente->caption(), $this->status_cliente->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status_cliente->FormValue)) {
			AddMessage($FormError, $this->status_cliente->errorMessage());
		}
		if ($this->date_added->Required) {
			if (!$this->date_added->IsDetailKey && $this->date_added->FormValue != NULL && $this->date_added->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_added->caption(), $this->date_added->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date_added->FormValue)) {
			AddMessage($FormError, $this->date_added->errorMessage());
		}
		if ($this->doc->Required) {
			if (!$this->doc->IsDetailKey && $this->doc->FormValue != NULL && $this->doc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->doc->caption(), $this->doc->RequiredErrorMessage));
			}
		}
		if ($this->vendedor->Required) {
			if (!$this->vendedor->IsDetailKey && $this->vendedor->FormValue != NULL && $this->vendedor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vendedor->caption(), $this->vendedor->RequiredErrorMessage));
			}
		}
		if ($this->pais->Required) {
			if (!$this->pais->IsDetailKey && $this->pais->FormValue != NULL && $this->pais->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pais->caption(), $this->pais->RequiredErrorMessage));
			}
		}
		if ($this->departamento->Required) {
			if (!$this->departamento->IsDetailKey && $this->departamento->FormValue != NULL && $this->departamento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->departamento->caption(), $this->departamento->RequiredErrorMessage));
			}
		}
		if ($this->provincia->Required) {
			if (!$this->provincia->IsDetailKey && $this->provincia->FormValue != NULL && $this->provincia->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->provincia->caption(), $this->provincia->RequiredErrorMessage));
			}
		}
		if ($this->distrito->Required) {
			if (!$this->distrito->IsDetailKey && $this->distrito->FormValue != NULL && $this->distrito->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->distrito->caption(), $this->distrito->RequiredErrorMessage));
			}
		}
		if ($this->cuenta->Required) {
			if (!$this->cuenta->IsDetailKey && $this->cuenta->FormValue != NULL && $this->cuenta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cuenta->caption(), $this->cuenta->RequiredErrorMessage));
			}
		}
		if ($this->tipo1->Required) {
			if (!$this->tipo1->IsDetailKey && $this->tipo1->FormValue != NULL && $this->tipo1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo1->caption(), $this->tipo1->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo1->FormValue)) {
			AddMessage($FormError, $this->tipo1->errorMessage());
		}
		if ($this->tienda->Required) {
			if (!$this->tienda->IsDetailKey && $this->tienda->FormValue != NULL && $this->tienda->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tienda->caption(), $this->tienda->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tienda->FormValue)) {
			AddMessage($FormError, $this->tienda->errorMessage());
		}
		if ($this->users->Required) {
			if (!$this->users->IsDetailKey && $this->users->FormValue != NULL && $this->users->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->users->caption(), $this->users->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->users->FormValue)) {
			AddMessage($FormError, $this->users->errorMessage());
		}
		if ($this->deuda->Required) {
			if (!$this->deuda->IsDetailKey && $this->deuda->FormValue != NULL && $this->deuda->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deuda->caption(), $this->deuda->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->deuda->FormValue)) {
			AddMessage($FormError, $this->deuda->errorMessage());
		}
		if ($this->debe->Required) {
			if (!$this->debe->IsDetailKey && $this->debe->FormValue != NULL && $this->debe->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->debe->caption(), $this->debe->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->debe->FormValue)) {
			AddMessage($FormError, $this->debe->errorMessage());
		}
		if ($this->tipo_documento->Required) {
			if (!$this->tipo_documento->IsDetailKey && $this->tipo_documento->FormValue != NULL && $this->tipo_documento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_documento->caption(), $this->tipo_documento->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_documento->FormValue)) {
			AddMessage($FormError, $this->tipo_documento->errorMessage());
		}
		if ($this->n_documento->Required) {
			if (!$this->n_documento->IsDetailKey && $this->n_documento->FormValue != NULL && $this->n_documento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->n_documento->caption(), $this->n_documento->RequiredErrorMessage));
			}
		}
		if ($this->deuda1->Required) {
			if (!$this->deuda1->IsDetailKey && $this->deuda1->FormValue != NULL && $this->deuda1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deuda1->caption(), $this->deuda1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->deuda1->FormValue)) {
			AddMessage($FormError, $this->deuda1->errorMessage());
		}
		if ($this->debe1->Required) {
			if (!$this->debe1->IsDetailKey && $this->debe1->FormValue != NULL && $this->debe1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->debe1->caption(), $this->debe1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->debe1->FormValue)) {
			AddMessage($FormError, $this->debe1->errorMessage());
		}
		if ($this->tipo->Required) {
			if (!$this->tipo->IsDetailKey && $this->tipo->FormValue != NULL && $this->tipo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo->caption(), $this->tipo->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo->FormValue)) {
			AddMessage($FormError, $this->tipo->errorMessage());
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// nombre_cliente
		$this->nombre_cliente->setDbValueDef($rsnew, $this->nombre_cliente->CurrentValue, "", FALSE);

		// telefono_cliente
		$this->telefono_cliente->setDbValueDef($rsnew, $this->telefono_cliente->CurrentValue, "", FALSE);

		// email_cliente
		$this->email_cliente->setDbValueDef($rsnew, $this->email_cliente->CurrentValue, "", FALSE);

		// direccion_cliente
		$this->direccion_cliente->setDbValueDef($rsnew, $this->direccion_cliente->CurrentValue, NULL, FALSE);

		// status_cliente
		$this->status_cliente->setDbValueDef($rsnew, $this->status_cliente->CurrentValue, NULL, FALSE);

		// date_added
		$this->date_added->setDbValueDef($rsnew, UnFormatDateTime($this->date_added->CurrentValue, 0), NULL, FALSE);

		// doc
		$this->doc->setDbValueDef($rsnew, $this->doc->CurrentValue, NULL, FALSE);

		// vendedor
		$this->vendedor->setDbValueDef($rsnew, $this->vendedor->CurrentValue, NULL, FALSE);

		// pais
		$this->pais->setDbValueDef($rsnew, $this->pais->CurrentValue, NULL, FALSE);

		// departamento
		$this->departamento->setDbValueDef($rsnew, $this->departamento->CurrentValue, NULL, FALSE);

		// provincia
		$this->provincia->setDbValueDef($rsnew, $this->provincia->CurrentValue, NULL, FALSE);

		// distrito
		$this->distrito->setDbValueDef($rsnew, $this->distrito->CurrentValue, NULL, FALSE);

		// cuenta
		$this->cuenta->setDbValueDef($rsnew, $this->cuenta->CurrentValue, NULL, FALSE);

		// tipo1
		$this->tipo1->setDbValueDef($rsnew, $this->tipo1->CurrentValue, NULL, FALSE);

		// tienda
		$this->tienda->setDbValueDef($rsnew, $this->tienda->CurrentValue, NULL, FALSE);

		// users
		$this->users->setDbValueDef($rsnew, $this->users->CurrentValue, NULL, FALSE);

		// deuda
		$this->deuda->setDbValueDef($rsnew, $this->deuda->CurrentValue, NULL, FALSE);

		// debe
		$this->debe->setDbValueDef($rsnew, $this->debe->CurrentValue, NULL, FALSE);

		// tipo_documento
		$this->tipo_documento->setDbValueDef($rsnew, $this->tipo_documento->CurrentValue, NULL, FALSE);

		// n_documento
		$this->n_documento->setDbValueDef($rsnew, $this->n_documento->CurrentValue, NULL, FALSE);

		// deuda1
		$this->deuda1->setDbValueDef($rsnew, $this->deuda1->CurrentValue, NULL, FALSE);

		// debe1
		$this->debe1->setDbValueDef($rsnew, $this->debe1->CurrentValue, NULL, FALSE);

		// tipo
		$this->tipo->setDbValueDef($rsnew, $this->tipo->CurrentValue, NULL, strval($this->tipo->CurrentValue) == "");

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, 0, strval($this->estado->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clienteslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>