<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class detalle_cuota_add extends detalle_cuota
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'detalle_cuota';

	// Page object name
	public $PageObjName = "detalle_cuota_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (detalle_cuota)
		if (!isset($GLOBALS["detalle_cuota"]) || get_class($GLOBALS["detalle_cuota"]) == PROJECT_NAMESPACE . "detalle_cuota") {
			$GLOBALS["detalle_cuota"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["detalle_cuota"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'detalle_cuota');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $detalle_cuota;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($detalle_cuota);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "detalle_cuotaview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_detallecuota'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_detallecuota->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("detalle_cuotalist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_detallecuota->Visible = FALSE;
		$this->id_producto->setVisibility();
		$this->id_cuota->setVisibility();
		$this->num_plazos->setVisibility();
		$this->monto_pagar->setVisibility();
		$this->fecha_pago->setVisibility();
		$this->estado->setVisibility();
		$this->metodo_pago->setVisibility();
		$this->monto_deposito->setVisibility();
		$this->cuenta_banco->setVisibility();
		$this->tipo_transferencia->setVisibility();
		$this->numero_operacion->setVisibility();
		$this->fecha_deposito->setVisibility();
		$this->referencia->setVisibility();
		$this->imagen->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id_detallecuota") !== NULL) {
				$this->id_detallecuota->setQueryStringValue(Get("id_detallecuota"));
				$this->setKey("id_detallecuota", $this->id_detallecuota->CurrentValue); // Set up key
			} else {
				$this->setKey("id_detallecuota", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("detalle_cuotalist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "detalle_cuotalist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "detalle_cuotaview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id_detallecuota->CurrentValue = NULL;
		$this->id_detallecuota->OldValue = $this->id_detallecuota->CurrentValue;
		$this->id_producto->CurrentValue = NULL;
		$this->id_producto->OldValue = $this->id_producto->CurrentValue;
		$this->id_cuota->CurrentValue = NULL;
		$this->id_cuota->OldValue = $this->id_cuota->CurrentValue;
		$this->num_plazos->CurrentValue = NULL;
		$this->num_plazos->OldValue = $this->num_plazos->CurrentValue;
		$this->monto_pagar->CurrentValue = NULL;
		$this->monto_pagar->OldValue = $this->monto_pagar->CurrentValue;
		$this->fecha_pago->CurrentValue = NULL;
		$this->fecha_pago->OldValue = $this->fecha_pago->CurrentValue;
		$this->estado->CurrentValue = 1;
		$this->metodo_pago->CurrentValue = 0;
		$this->monto_deposito->CurrentValue = NULL;
		$this->monto_deposito->OldValue = $this->monto_deposito->CurrentValue;
		$this->cuenta_banco->CurrentValue = NULL;
		$this->cuenta_banco->OldValue = $this->cuenta_banco->CurrentValue;
		$this->tipo_transferencia->CurrentValue = 0;
		$this->numero_operacion->CurrentValue = NULL;
		$this->numero_operacion->OldValue = $this->numero_operacion->CurrentValue;
		$this->fecha_deposito->CurrentValue = NULL;
		$this->fecha_deposito->OldValue = $this->fecha_deposito->CurrentValue;
		$this->referencia->CurrentValue = NULL;
		$this->referencia->OldValue = $this->referencia->CurrentValue;
		$this->imagen->CurrentValue = NULL;
		$this->imagen->OldValue = $this->imagen->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id_producto' first before field var 'x_id_producto'
		$val = $CurrentForm->hasValue("id_producto") ? $CurrentForm->getValue("id_producto") : $CurrentForm->getValue("x_id_producto");
		if (!$this->id_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_producto->Visible = FALSE; // Disable update for API request
			else
				$this->id_producto->setFormValue($val);
		}

		// Check field name 'id_cuota' first before field var 'x_id_cuota'
		$val = $CurrentForm->hasValue("id_cuota") ? $CurrentForm->getValue("id_cuota") : $CurrentForm->getValue("x_id_cuota");
		if (!$this->id_cuota->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_cuota->Visible = FALSE; // Disable update for API request
			else
				$this->id_cuota->setFormValue($val);
		}

		// Check field name 'num_plazos' first before field var 'x_num_plazos'
		$val = $CurrentForm->hasValue("num_plazos") ? $CurrentForm->getValue("num_plazos") : $CurrentForm->getValue("x_num_plazos");
		if (!$this->num_plazos->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->num_plazos->Visible = FALSE; // Disable update for API request
			else
				$this->num_plazos->setFormValue($val);
		}

		// Check field name 'monto_pagar' first before field var 'x_monto_pagar'
		$val = $CurrentForm->hasValue("monto_pagar") ? $CurrentForm->getValue("monto_pagar") : $CurrentForm->getValue("x_monto_pagar");
		if (!$this->monto_pagar->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->monto_pagar->Visible = FALSE; // Disable update for API request
			else
				$this->monto_pagar->setFormValue($val);
		}

		// Check field name 'fecha_pago' first before field var 'x_fecha_pago'
		$val = $CurrentForm->hasValue("fecha_pago") ? $CurrentForm->getValue("fecha_pago") : $CurrentForm->getValue("x_fecha_pago");
		if (!$this->fecha_pago->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_pago->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_pago->setFormValue($val);
			$this->fecha_pago->CurrentValue = UnFormatDateTime($this->fecha_pago->CurrentValue, 0);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'metodo_pago' first before field var 'x_metodo_pago'
		$val = $CurrentForm->hasValue("metodo_pago") ? $CurrentForm->getValue("metodo_pago") : $CurrentForm->getValue("x_metodo_pago");
		if (!$this->metodo_pago->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->metodo_pago->Visible = FALSE; // Disable update for API request
			else
				$this->metodo_pago->setFormValue($val);
		}

		// Check field name 'monto_deposito' first before field var 'x_monto_deposito'
		$val = $CurrentForm->hasValue("monto_deposito") ? $CurrentForm->getValue("monto_deposito") : $CurrentForm->getValue("x_monto_deposito");
		if (!$this->monto_deposito->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->monto_deposito->Visible = FALSE; // Disable update for API request
			else
				$this->monto_deposito->setFormValue($val);
		}

		// Check field name 'cuenta_banco' first before field var 'x_cuenta_banco'
		$val = $CurrentForm->hasValue("cuenta_banco") ? $CurrentForm->getValue("cuenta_banco") : $CurrentForm->getValue("x_cuenta_banco");
		if (!$this->cuenta_banco->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cuenta_banco->Visible = FALSE; // Disable update for API request
			else
				$this->cuenta_banco->setFormValue($val);
		}

		// Check field name 'tipo_transferencia' first before field var 'x_tipo_transferencia'
		$val = $CurrentForm->hasValue("tipo_transferencia") ? $CurrentForm->getValue("tipo_transferencia") : $CurrentForm->getValue("x_tipo_transferencia");
		if (!$this->tipo_transferencia->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_transferencia->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_transferencia->setFormValue($val);
		}

		// Check field name 'numero_operacion' first before field var 'x_numero_operacion'
		$val = $CurrentForm->hasValue("numero_operacion") ? $CurrentForm->getValue("numero_operacion") : $CurrentForm->getValue("x_numero_operacion");
		if (!$this->numero_operacion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->numero_operacion->Visible = FALSE; // Disable update for API request
			else
				$this->numero_operacion->setFormValue($val);
		}

		// Check field name 'fecha_deposito' first before field var 'x_fecha_deposito'
		$val = $CurrentForm->hasValue("fecha_deposito") ? $CurrentForm->getValue("fecha_deposito") : $CurrentForm->getValue("x_fecha_deposito");
		if (!$this->fecha_deposito->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_deposito->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_deposito->setFormValue($val);
			$this->fecha_deposito->CurrentValue = UnFormatDateTime($this->fecha_deposito->CurrentValue, 0);
		}

		// Check field name 'referencia' first before field var 'x_referencia'
		$val = $CurrentForm->hasValue("referencia") ? $CurrentForm->getValue("referencia") : $CurrentForm->getValue("x_referencia");
		if (!$this->referencia->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->referencia->Visible = FALSE; // Disable update for API request
			else
				$this->referencia->setFormValue($val);
		}

		// Check field name 'imagen' first before field var 'x_imagen'
		$val = $CurrentForm->hasValue("imagen") ? $CurrentForm->getValue("imagen") : $CurrentForm->getValue("x_imagen");
		if (!$this->imagen->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->imagen->Visible = FALSE; // Disable update for API request
			else
				$this->imagen->setFormValue($val);
		}

		// Check field name 'id_detallecuota' first before field var 'x_id_detallecuota'
		$val = $CurrentForm->hasValue("id_detallecuota") ? $CurrentForm->getValue("id_detallecuota") : $CurrentForm->getValue("x_id_detallecuota");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id_producto->CurrentValue = $this->id_producto->FormValue;
		$this->id_cuota->CurrentValue = $this->id_cuota->FormValue;
		$this->num_plazos->CurrentValue = $this->num_plazos->FormValue;
		$this->monto_pagar->CurrentValue = $this->monto_pagar->FormValue;
		$this->fecha_pago->CurrentValue = $this->fecha_pago->FormValue;
		$this->fecha_pago->CurrentValue = UnFormatDateTime($this->fecha_pago->CurrentValue, 0);
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->metodo_pago->CurrentValue = $this->metodo_pago->FormValue;
		$this->monto_deposito->CurrentValue = $this->monto_deposito->FormValue;
		$this->cuenta_banco->CurrentValue = $this->cuenta_banco->FormValue;
		$this->tipo_transferencia->CurrentValue = $this->tipo_transferencia->FormValue;
		$this->numero_operacion->CurrentValue = $this->numero_operacion->FormValue;
		$this->fecha_deposito->CurrentValue = $this->fecha_deposito->FormValue;
		$this->fecha_deposito->CurrentValue = UnFormatDateTime($this->fecha_deposito->CurrentValue, 0);
		$this->referencia->CurrentValue = $this->referencia->FormValue;
		$this->imagen->CurrentValue = $this->imagen->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_detallecuota->setDbValue($row['id_detallecuota']);
		$this->id_producto->setDbValue($row['id_producto']);
		$this->id_cuota->setDbValue($row['id_cuota']);
		$this->num_plazos->setDbValue($row['num_plazos']);
		$this->monto_pagar->setDbValue($row['monto_pagar']);
		$this->fecha_pago->setDbValue($row['fecha_pago']);
		$this->estado->setDbValue($row['estado']);
		$this->metodo_pago->setDbValue($row['metodo_pago']);
		$this->monto_deposito->setDbValue($row['monto_deposito']);
		$this->cuenta_banco->setDbValue($row['cuenta_banco']);
		$this->tipo_transferencia->setDbValue($row['tipo_transferencia']);
		$this->numero_operacion->setDbValue($row['numero_operacion']);
		$this->fecha_deposito->setDbValue($row['fecha_deposito']);
		$this->referencia->setDbValue($row['referencia']);
		$this->imagen->setDbValue($row['imagen']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id_detallecuota'] = $this->id_detallecuota->CurrentValue;
		$row['id_producto'] = $this->id_producto->CurrentValue;
		$row['id_cuota'] = $this->id_cuota->CurrentValue;
		$row['num_plazos'] = $this->num_plazos->CurrentValue;
		$row['monto_pagar'] = $this->monto_pagar->CurrentValue;
		$row['fecha_pago'] = $this->fecha_pago->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		$row['metodo_pago'] = $this->metodo_pago->CurrentValue;
		$row['monto_deposito'] = $this->monto_deposito->CurrentValue;
		$row['cuenta_banco'] = $this->cuenta_banco->CurrentValue;
		$row['tipo_transferencia'] = $this->tipo_transferencia->CurrentValue;
		$row['numero_operacion'] = $this->numero_operacion->CurrentValue;
		$row['fecha_deposito'] = $this->fecha_deposito->CurrentValue;
		$row['referencia'] = $this->referencia->CurrentValue;
		$row['imagen'] = $this->imagen->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_detallecuota")) != "")
			$this->id_detallecuota->OldValue = $this->getKey("id_detallecuota"); // id_detallecuota
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->monto_pagar->FormValue == $this->monto_pagar->CurrentValue && is_numeric(ConvertToFloatString($this->monto_pagar->CurrentValue)))
			$this->monto_pagar->CurrentValue = ConvertToFloatString($this->monto_pagar->CurrentValue);

		// Convert decimal values if posted back
		if ($this->monto_deposito->FormValue == $this->monto_deposito->CurrentValue && is_numeric(ConvertToFloatString($this->monto_deposito->CurrentValue)))
			$this->monto_deposito->CurrentValue = ConvertToFloatString($this->monto_deposito->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_detallecuota
		// id_producto
		// id_cuota
		// num_plazos
		// monto_pagar
		// fecha_pago
		// estado
		// metodo_pago
		// monto_deposito
		// cuenta_banco
		// tipo_transferencia
		// numero_operacion
		// fecha_deposito
		// referencia
		// imagen

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_detallecuota
			$this->id_detallecuota->ViewValue = $this->id_detallecuota->CurrentValue;
			$this->id_detallecuota->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
			$this->id_producto->ViewCustomAttributes = "";

			// id_cuota
			$this->id_cuota->ViewValue = $this->id_cuota->CurrentValue;
			$this->id_cuota->ViewValue = FormatNumber($this->id_cuota->ViewValue, 0, -2, -2, -2);
			$this->id_cuota->ViewCustomAttributes = "";

			// num_plazos
			$this->num_plazos->ViewValue = $this->num_plazos->CurrentValue;
			$this->num_plazos->ViewValue = FormatNumber($this->num_plazos->ViewValue, 0, -2, -2, -2);
			$this->num_plazos->ViewCustomAttributes = "";

			// monto_pagar
			$this->monto_pagar->ViewValue = $this->monto_pagar->CurrentValue;
			$this->monto_pagar->ViewValue = FormatNumber($this->monto_pagar->ViewValue, 2, -2, -2, -2);
			$this->monto_pagar->ViewCustomAttributes = "";

			// fecha_pago
			$this->fecha_pago->ViewValue = $this->fecha_pago->CurrentValue;
			$this->fecha_pago->ViewValue = FormatDateTime($this->fecha_pago->ViewValue, 0);
			$this->fecha_pago->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// metodo_pago
			$this->metodo_pago->ViewValue = $this->metodo_pago->CurrentValue;
			$this->metodo_pago->ViewValue = FormatNumber($this->metodo_pago->ViewValue, 0, -2, -2, -2);
			$this->metodo_pago->ViewCustomAttributes = "";

			// monto_deposito
			$this->monto_deposito->ViewValue = $this->monto_deposito->CurrentValue;
			$this->monto_deposito->ViewValue = FormatNumber($this->monto_deposito->ViewValue, 2, -2, -2, -2);
			$this->monto_deposito->ViewCustomAttributes = "";

			// cuenta_banco
			$this->cuenta_banco->ViewValue = $this->cuenta_banco->CurrentValue;
			$this->cuenta_banco->ViewCustomAttributes = "";

			// tipo_transferencia
			$this->tipo_transferencia->ViewValue = $this->tipo_transferencia->CurrentValue;
			$this->tipo_transferencia->ViewValue = FormatNumber($this->tipo_transferencia->ViewValue, 0, -2, -2, -2);
			$this->tipo_transferencia->ViewCustomAttributes = "";

			// numero_operacion
			$this->numero_operacion->ViewValue = $this->numero_operacion->CurrentValue;
			$this->numero_operacion->ViewCustomAttributes = "";

			// fecha_deposito
			$this->fecha_deposito->ViewValue = $this->fecha_deposito->CurrentValue;
			$this->fecha_deposito->ViewValue = FormatDateTime($this->fecha_deposito->ViewValue, 0);
			$this->fecha_deposito->ViewCustomAttributes = "";

			// referencia
			$this->referencia->ViewValue = $this->referencia->CurrentValue;
			$this->referencia->ViewCustomAttributes = "";

			// imagen
			$this->imagen->ViewValue = $this->imagen->CurrentValue;
			$this->imagen->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// id_cuota
			$this->id_cuota->LinkCustomAttributes = "";
			$this->id_cuota->HrefValue = "";
			$this->id_cuota->TooltipValue = "";

			// num_plazos
			$this->num_plazos->LinkCustomAttributes = "";
			$this->num_plazos->HrefValue = "";
			$this->num_plazos->TooltipValue = "";

			// monto_pagar
			$this->monto_pagar->LinkCustomAttributes = "";
			$this->monto_pagar->HrefValue = "";
			$this->monto_pagar->TooltipValue = "";

			// fecha_pago
			$this->fecha_pago->LinkCustomAttributes = "";
			$this->fecha_pago->HrefValue = "";
			$this->fecha_pago->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// metodo_pago
			$this->metodo_pago->LinkCustomAttributes = "";
			$this->metodo_pago->HrefValue = "";
			$this->metodo_pago->TooltipValue = "";

			// monto_deposito
			$this->monto_deposito->LinkCustomAttributes = "";
			$this->monto_deposito->HrefValue = "";
			$this->monto_deposito->TooltipValue = "";

			// cuenta_banco
			$this->cuenta_banco->LinkCustomAttributes = "";
			$this->cuenta_banco->HrefValue = "";
			$this->cuenta_banco->TooltipValue = "";

			// tipo_transferencia
			$this->tipo_transferencia->LinkCustomAttributes = "";
			$this->tipo_transferencia->HrefValue = "";
			$this->tipo_transferencia->TooltipValue = "";

			// numero_operacion
			$this->numero_operacion->LinkCustomAttributes = "";
			$this->numero_operacion->HrefValue = "";
			$this->numero_operacion->TooltipValue = "";

			// fecha_deposito
			$this->fecha_deposito->LinkCustomAttributes = "";
			$this->fecha_deposito->HrefValue = "";
			$this->fecha_deposito->TooltipValue = "";

			// referencia
			$this->referencia->LinkCustomAttributes = "";
			$this->referencia->HrefValue = "";
			$this->referencia->TooltipValue = "";

			// imagen
			$this->imagen->LinkCustomAttributes = "";
			$this->imagen->HrefValue = "";
			$this->imagen->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id_producto
			$this->id_producto->EditAttrs["class"] = "form-control";
			$this->id_producto->EditCustomAttributes = "";
			$this->id_producto->EditValue = HtmlEncode($this->id_producto->CurrentValue);
			$this->id_producto->PlaceHolder = RemoveHtml($this->id_producto->caption());

			// id_cuota
			$this->id_cuota->EditAttrs["class"] = "form-control";
			$this->id_cuota->EditCustomAttributes = "";
			$this->id_cuota->EditValue = HtmlEncode($this->id_cuota->CurrentValue);
			$this->id_cuota->PlaceHolder = RemoveHtml($this->id_cuota->caption());

			// num_plazos
			$this->num_plazos->EditAttrs["class"] = "form-control";
			$this->num_plazos->EditCustomAttributes = "";
			$this->num_plazos->EditValue = HtmlEncode($this->num_plazos->CurrentValue);
			$this->num_plazos->PlaceHolder = RemoveHtml($this->num_plazos->caption());

			// monto_pagar
			$this->monto_pagar->EditAttrs["class"] = "form-control";
			$this->monto_pagar->EditCustomAttributes = "";
			$this->monto_pagar->EditValue = HtmlEncode($this->monto_pagar->CurrentValue);
			$this->monto_pagar->PlaceHolder = RemoveHtml($this->monto_pagar->caption());
			if (strval($this->monto_pagar->EditValue) != "" && is_numeric($this->monto_pagar->EditValue))
				$this->monto_pagar->EditValue = FormatNumber($this->monto_pagar->EditValue, -2, -2, -2, -2);
			

			// fecha_pago
			$this->fecha_pago->EditAttrs["class"] = "form-control";
			$this->fecha_pago->EditCustomAttributes = "";
			$this->fecha_pago->EditValue = HtmlEncode(FormatDateTime($this->fecha_pago->CurrentValue, 8));
			$this->fecha_pago->PlaceHolder = RemoveHtml($this->fecha_pago->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// metodo_pago
			$this->metodo_pago->EditAttrs["class"] = "form-control";
			$this->metodo_pago->EditCustomAttributes = "";
			$this->metodo_pago->EditValue = HtmlEncode($this->metodo_pago->CurrentValue);
			$this->metodo_pago->PlaceHolder = RemoveHtml($this->metodo_pago->caption());

			// monto_deposito
			$this->monto_deposito->EditAttrs["class"] = "form-control";
			$this->monto_deposito->EditCustomAttributes = "";
			$this->monto_deposito->EditValue = HtmlEncode($this->monto_deposito->CurrentValue);
			$this->monto_deposito->PlaceHolder = RemoveHtml($this->monto_deposito->caption());
			if (strval($this->monto_deposito->EditValue) != "" && is_numeric($this->monto_deposito->EditValue))
				$this->monto_deposito->EditValue = FormatNumber($this->monto_deposito->EditValue, -2, -2, -2, -2);
			

			// cuenta_banco
			$this->cuenta_banco->EditAttrs["class"] = "form-control";
			$this->cuenta_banco->EditCustomAttributes = "";
			if (!$this->cuenta_banco->Raw)
				$this->cuenta_banco->CurrentValue = HtmlDecode($this->cuenta_banco->CurrentValue);
			$this->cuenta_banco->EditValue = HtmlEncode($this->cuenta_banco->CurrentValue);
			$this->cuenta_banco->PlaceHolder = RemoveHtml($this->cuenta_banco->caption());

			// tipo_transferencia
			$this->tipo_transferencia->EditAttrs["class"] = "form-control";
			$this->tipo_transferencia->EditCustomAttributes = "";
			$this->tipo_transferencia->EditValue = HtmlEncode($this->tipo_transferencia->CurrentValue);
			$this->tipo_transferencia->PlaceHolder = RemoveHtml($this->tipo_transferencia->caption());

			// numero_operacion
			$this->numero_operacion->EditAttrs["class"] = "form-control";
			$this->numero_operacion->EditCustomAttributes = "";
			if (!$this->numero_operacion->Raw)
				$this->numero_operacion->CurrentValue = HtmlDecode($this->numero_operacion->CurrentValue);
			$this->numero_operacion->EditValue = HtmlEncode($this->numero_operacion->CurrentValue);
			$this->numero_operacion->PlaceHolder = RemoveHtml($this->numero_operacion->caption());

			// fecha_deposito
			$this->fecha_deposito->EditAttrs["class"] = "form-control";
			$this->fecha_deposito->EditCustomAttributes = "";
			$this->fecha_deposito->EditValue = HtmlEncode(FormatDateTime($this->fecha_deposito->CurrentValue, 8));
			$this->fecha_deposito->PlaceHolder = RemoveHtml($this->fecha_deposito->caption());

			// referencia
			$this->referencia->EditAttrs["class"] = "form-control";
			$this->referencia->EditCustomAttributes = "";
			if (!$this->referencia->Raw)
				$this->referencia->CurrentValue = HtmlDecode($this->referencia->CurrentValue);
			$this->referencia->EditValue = HtmlEncode($this->referencia->CurrentValue);
			$this->referencia->PlaceHolder = RemoveHtml($this->referencia->caption());

			// imagen
			$this->imagen->EditAttrs["class"] = "form-control";
			$this->imagen->EditCustomAttributes = "";
			$this->imagen->EditValue = HtmlEncode($this->imagen->CurrentValue);
			$this->imagen->PlaceHolder = RemoveHtml($this->imagen->caption());

			// Add refer script
			// id_producto

			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";

			// id_cuota
			$this->id_cuota->LinkCustomAttributes = "";
			$this->id_cuota->HrefValue = "";

			// num_plazos
			$this->num_plazos->LinkCustomAttributes = "";
			$this->num_plazos->HrefValue = "";

			// monto_pagar
			$this->monto_pagar->LinkCustomAttributes = "";
			$this->monto_pagar->HrefValue = "";

			// fecha_pago
			$this->fecha_pago->LinkCustomAttributes = "";
			$this->fecha_pago->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// metodo_pago
			$this->metodo_pago->LinkCustomAttributes = "";
			$this->metodo_pago->HrefValue = "";

			// monto_deposito
			$this->monto_deposito->LinkCustomAttributes = "";
			$this->monto_deposito->HrefValue = "";

			// cuenta_banco
			$this->cuenta_banco->LinkCustomAttributes = "";
			$this->cuenta_banco->HrefValue = "";

			// tipo_transferencia
			$this->tipo_transferencia->LinkCustomAttributes = "";
			$this->tipo_transferencia->HrefValue = "";

			// numero_operacion
			$this->numero_operacion->LinkCustomAttributes = "";
			$this->numero_operacion->HrefValue = "";

			// fecha_deposito
			$this->fecha_deposito->LinkCustomAttributes = "";
			$this->fecha_deposito->HrefValue = "";

			// referencia
			$this->referencia->LinkCustomAttributes = "";
			$this->referencia->HrefValue = "";

			// imagen
			$this->imagen->LinkCustomAttributes = "";
			$this->imagen->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->id_producto->Required) {
			if (!$this->id_producto->IsDetailKey && $this->id_producto->FormValue != NULL && $this->id_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_producto->caption(), $this->id_producto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_producto->FormValue)) {
			AddMessage($FormError, $this->id_producto->errorMessage());
		}
		if ($this->id_cuota->Required) {
			if (!$this->id_cuota->IsDetailKey && $this->id_cuota->FormValue != NULL && $this->id_cuota->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_cuota->caption(), $this->id_cuota->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_cuota->FormValue)) {
			AddMessage($FormError, $this->id_cuota->errorMessage());
		}
		if ($this->num_plazos->Required) {
			if (!$this->num_plazos->IsDetailKey && $this->num_plazos->FormValue != NULL && $this->num_plazos->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->num_plazos->caption(), $this->num_plazos->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->num_plazos->FormValue)) {
			AddMessage($FormError, $this->num_plazos->errorMessage());
		}
		if ($this->monto_pagar->Required) {
			if (!$this->monto_pagar->IsDetailKey && $this->monto_pagar->FormValue != NULL && $this->monto_pagar->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->monto_pagar->caption(), $this->monto_pagar->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->monto_pagar->FormValue)) {
			AddMessage($FormError, $this->monto_pagar->errorMessage());
		}
		if ($this->fecha_pago->Required) {
			if (!$this->fecha_pago->IsDetailKey && $this->fecha_pago->FormValue != NULL && $this->fecha_pago->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_pago->caption(), $this->fecha_pago->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha_pago->FormValue)) {
			AddMessage($FormError, $this->fecha_pago->errorMessage());
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->metodo_pago->Required) {
			if (!$this->metodo_pago->IsDetailKey && $this->metodo_pago->FormValue != NULL && $this->metodo_pago->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->metodo_pago->caption(), $this->metodo_pago->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->metodo_pago->FormValue)) {
			AddMessage($FormError, $this->metodo_pago->errorMessage());
		}
		if ($this->monto_deposito->Required) {
			if (!$this->monto_deposito->IsDetailKey && $this->monto_deposito->FormValue != NULL && $this->monto_deposito->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->monto_deposito->caption(), $this->monto_deposito->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->monto_deposito->FormValue)) {
			AddMessage($FormError, $this->monto_deposito->errorMessage());
		}
		if ($this->cuenta_banco->Required) {
			if (!$this->cuenta_banco->IsDetailKey && $this->cuenta_banco->FormValue != NULL && $this->cuenta_banco->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cuenta_banco->caption(), $this->cuenta_banco->RequiredErrorMessage));
			}
		}
		if ($this->tipo_transferencia->Required) {
			if (!$this->tipo_transferencia->IsDetailKey && $this->tipo_transferencia->FormValue != NULL && $this->tipo_transferencia->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_transferencia->caption(), $this->tipo_transferencia->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_transferencia->FormValue)) {
			AddMessage($FormError, $this->tipo_transferencia->errorMessage());
		}
		if ($this->numero_operacion->Required) {
			if (!$this->numero_operacion->IsDetailKey && $this->numero_operacion->FormValue != NULL && $this->numero_operacion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->numero_operacion->caption(), $this->numero_operacion->RequiredErrorMessage));
			}
		}
		if ($this->fecha_deposito->Required) {
			if (!$this->fecha_deposito->IsDetailKey && $this->fecha_deposito->FormValue != NULL && $this->fecha_deposito->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_deposito->caption(), $this->fecha_deposito->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha_deposito->FormValue)) {
			AddMessage($FormError, $this->fecha_deposito->errorMessage());
		}
		if ($this->referencia->Required) {
			if (!$this->referencia->IsDetailKey && $this->referencia->FormValue != NULL && $this->referencia->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->referencia->caption(), $this->referencia->RequiredErrorMessage));
			}
		}
		if ($this->imagen->Required) {
			if (!$this->imagen->IsDetailKey && $this->imagen->FormValue != NULL && $this->imagen->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->imagen->caption(), $this->imagen->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// id_producto
		$this->id_producto->setDbValueDef($rsnew, $this->id_producto->CurrentValue, NULL, FALSE);

		// id_cuota
		$this->id_cuota->setDbValueDef($rsnew, $this->id_cuota->CurrentValue, NULL, FALSE);

		// num_plazos
		$this->num_plazos->setDbValueDef($rsnew, $this->num_plazos->CurrentValue, NULL, FALSE);

		// monto_pagar
		$this->monto_pagar->setDbValueDef($rsnew, $this->monto_pagar->CurrentValue, NULL, FALSE);

		// fecha_pago
		$this->fecha_pago->setDbValueDef($rsnew, UnFormatDateTime($this->fecha_pago->CurrentValue, 0), NULL, FALSE);

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, 0, strval($this->estado->CurrentValue) == "");

		// metodo_pago
		$this->metodo_pago->setDbValueDef($rsnew, $this->metodo_pago->CurrentValue, NULL, strval($this->metodo_pago->CurrentValue) == "");

		// monto_deposito
		$this->monto_deposito->setDbValueDef($rsnew, $this->monto_deposito->CurrentValue, NULL, FALSE);

		// cuenta_banco
		$this->cuenta_banco->setDbValueDef($rsnew, $this->cuenta_banco->CurrentValue, NULL, FALSE);

		// tipo_transferencia
		$this->tipo_transferencia->setDbValueDef($rsnew, $this->tipo_transferencia->CurrentValue, NULL, strval($this->tipo_transferencia->CurrentValue) == "");

		// numero_operacion
		$this->numero_operacion->setDbValueDef($rsnew, $this->numero_operacion->CurrentValue, NULL, FALSE);

		// fecha_deposito
		$this->fecha_deposito->setDbValueDef($rsnew, UnFormatDateTime($this->fecha_deposito->CurrentValue, 0), NULL, FALSE);

		// referencia
		$this->referencia->setDbValueDef($rsnew, $this->referencia->CurrentValue, NULL, FALSE);

		// imagen
		$this->imagen->setDbValueDef($rsnew, $this->imagen->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("detalle_cuotalist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>