<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class interesados_delete extends interesados
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'interesados';

	// Page object name
	public $PageObjName = "interesados_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (interesados)
		if (!isset($GLOBALS["interesados"]) || get_class($GLOBALS["interesados"]) == PROJECT_NAMESPACE . "interesados") {
			$GLOBALS["interesados"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["interesados"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'interesados');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $interesados;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($interesados);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idinteresado'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idinteresado->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("interesadoslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idinteresado->setVisibility();
		$this->id_usuarioencargado->setVisibility();
		$this->fecha->setVisibility();
		$this->_email->setVisibility();
		$this->cursos->setVisibility();
		$this->categorias->setVisibility();
		$this->nombres->setVisibility();
		$this->apellidos->setVisibility();
		$this->direccion->setVisibility();
		$this->ciudad->setVisibility();
		$this->provincia->setVisibility();
		$this->pais->setVisibility();
		$this->telefono->setVisibility();
		$this->tipo_certificado->setVisibility();
		$this->tipo_pago->setVisibility();
		$this->nombretarjeta->setVisibility();
		$this->numerotarjeta->setVisibility();
		$this->mes->setVisibility();
		$this->anio->setVisibility();
		$this->tipo_tarjeta->setVisibility();
		$this->nombrepaypal->setVisibility();
		$this->montopaypal->setVisibility();
		$this->emailpaypal->setVisibility();
		$this->don->setVisibility();
		$this->tipo_condicion->setVisibility();
		$this->acciones->setVisibility();
		$this->solicitud->setVisibility();
		$this->examen->setVisibility();
		$this->estado->setVisibility();
		$this->tipo->setVisibility();
		$this->codigo_certificado->setVisibility();
		$this->estado_entrega->setVisibility();
		$this->idioma->setVisibility();
		$this->tipo_documento->setVisibility();
		$this->n_documento->setVisibility();
		$this->condicion1->setVisibility();
		$this->condicion2->setVisibility();
		$this->consulta->setVisibility();
		$this->status->setVisibility();
		$this->codlogin->setVisibility();
		$this->idproyecto->setVisibility();
		$this->id_producto->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("interesadoslist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("interesadoslist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idinteresado->setDbValue($row['idinteresado']);
		$this->id_usuarioencargado->setDbValue($row['id_usuarioencargado']);
		$this->fecha->setDbValue($row['fecha']);
		$this->_email->setDbValue($row['email']);
		$this->cursos->setDbValue($row['cursos']);
		$this->categorias->setDbValue($row['categorias']);
		$this->nombres->setDbValue($row['nombres']);
		$this->apellidos->setDbValue($row['apellidos']);
		$this->direccion->setDbValue($row['direccion']);
		$this->ciudad->setDbValue($row['ciudad']);
		$this->provincia->setDbValue($row['provincia']);
		$this->pais->setDbValue($row['pais']);
		$this->telefono->setDbValue($row['telefono']);
		$this->tipo_certificado->setDbValue($row['tipo_certificado']);
		$this->tipo_pago->setDbValue($row['tipo_pago']);
		$this->nombretarjeta->setDbValue($row['nombretarjeta']);
		$this->numerotarjeta->setDbValue($row['numerotarjeta']);
		$this->mes->setDbValue($row['mes']);
		$this->anio->setDbValue($row['anio']);
		$this->tipo_tarjeta->setDbValue($row['tipo_tarjeta']);
		$this->nombrepaypal->setDbValue($row['nombrepaypal']);
		$this->montopaypal->setDbValue($row['montopaypal']);
		$this->emailpaypal->setDbValue($row['emailpaypal']);
		$this->don->setDbValue($row['don']);
		$this->tipo_condicion->setDbValue($row['tipo_condicion']);
		$this->acciones->setDbValue($row['acciones']);
		$this->solicitud->setDbValue($row['solicitud']);
		$this->examen->setDbValue($row['examen']);
		$this->estado->setDbValue($row['estado']);
		$this->tipo->setDbValue($row['tipo']);
		$this->codigo_certificado->setDbValue($row['codigo_certificado']);
		$this->estado_entrega->setDbValue($row['estado_entrega']);
		$this->idioma->setDbValue($row['idioma']);
		$this->tipo_documento->setDbValue($row['tipo_documento']);
		$this->n_documento->setDbValue($row['n_documento']);
		$this->condicion1->setDbValue($row['condicion1']);
		$this->condicion2->setDbValue($row['condicion2']);
		$this->consulta->setDbValue($row['consulta']);
		$this->status->setDbValue($row['status']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->idproyecto->setDbValue($row['idproyecto']);
		$this->id_producto->setDbValue($row['id_producto']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idinteresado'] = NULL;
		$row['id_usuarioencargado'] = NULL;
		$row['fecha'] = NULL;
		$row['email'] = NULL;
		$row['cursos'] = NULL;
		$row['categorias'] = NULL;
		$row['nombres'] = NULL;
		$row['apellidos'] = NULL;
		$row['direccion'] = NULL;
		$row['ciudad'] = NULL;
		$row['provincia'] = NULL;
		$row['pais'] = NULL;
		$row['telefono'] = NULL;
		$row['tipo_certificado'] = NULL;
		$row['tipo_pago'] = NULL;
		$row['nombretarjeta'] = NULL;
		$row['numerotarjeta'] = NULL;
		$row['mes'] = NULL;
		$row['anio'] = NULL;
		$row['tipo_tarjeta'] = NULL;
		$row['nombrepaypal'] = NULL;
		$row['montopaypal'] = NULL;
		$row['emailpaypal'] = NULL;
		$row['don'] = NULL;
		$row['tipo_condicion'] = NULL;
		$row['acciones'] = NULL;
		$row['solicitud'] = NULL;
		$row['examen'] = NULL;
		$row['estado'] = NULL;
		$row['tipo'] = NULL;
		$row['codigo_certificado'] = NULL;
		$row['estado_entrega'] = NULL;
		$row['idioma'] = NULL;
		$row['tipo_documento'] = NULL;
		$row['n_documento'] = NULL;
		$row['condicion1'] = NULL;
		$row['condicion2'] = NULL;
		$row['consulta'] = NULL;
		$row['status'] = NULL;
		$row['codlogin'] = NULL;
		$row['idproyecto'] = NULL;
		$row['id_producto'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->examen->FormValue == $this->examen->CurrentValue && is_numeric(ConvertToFloatString($this->examen->CurrentValue)))
			$this->examen->CurrentValue = ConvertToFloatString($this->examen->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idinteresado
		// id_usuarioencargado
		// fecha
		// email
		// cursos
		// categorias
		// nombres
		// apellidos
		// direccion
		// ciudad
		// provincia
		// pais
		// telefono
		// tipo_certificado
		// tipo_pago
		// nombretarjeta
		// numerotarjeta
		// mes
		// anio
		// tipo_tarjeta
		// nombrepaypal
		// montopaypal
		// emailpaypal
		// don
		// tipo_condicion
		// acciones
		// solicitud
		// examen
		// estado
		// tipo
		// codigo_certificado
		// estado_entrega
		// idioma
		// tipo_documento
		// n_documento
		// condicion1
		// condicion2
		// consulta
		// status
		// codlogin
		// idproyecto
		// id_producto

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idinteresado
			$this->idinteresado->ViewValue = $this->idinteresado->CurrentValue;
			$this->idinteresado->ViewCustomAttributes = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->ViewValue = $this->id_usuarioencargado->CurrentValue;
			$this->id_usuarioencargado->ViewValue = FormatNumber($this->id_usuarioencargado->ViewValue, 0, -2, -2, -2);
			$this->id_usuarioencargado->ViewCustomAttributes = "";

			// fecha
			$this->fecha->ViewValue = $this->fecha->CurrentValue;
			$this->fecha->ViewValue = FormatDateTime($this->fecha->ViewValue, 0);
			$this->fecha->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// cursos
			$this->cursos->ViewValue = $this->cursos->CurrentValue;
			$this->cursos->ViewValue = FormatNumber($this->cursos->ViewValue, 0, -2, -2, -2);
			$this->cursos->ViewCustomAttributes = "";

			// categorias
			$this->categorias->ViewValue = $this->categorias->CurrentValue;
			$this->categorias->ViewValue = FormatNumber($this->categorias->ViewValue, 0, -2, -2, -2);
			$this->categorias->ViewCustomAttributes = "";

			// nombres
			$this->nombres->ViewValue = $this->nombres->CurrentValue;
			$this->nombres->ViewCustomAttributes = "";

			// apellidos
			$this->apellidos->ViewValue = $this->apellidos->CurrentValue;
			$this->apellidos->ViewCustomAttributes = "";

			// direccion
			$this->direccion->ViewValue = $this->direccion->CurrentValue;
			$this->direccion->ViewCustomAttributes = "";

			// ciudad
			$this->ciudad->ViewValue = $this->ciudad->CurrentValue;
			$this->ciudad->ViewCustomAttributes = "";

			// provincia
			$this->provincia->ViewValue = $this->provincia->CurrentValue;
			$this->provincia->ViewCustomAttributes = "";

			// pais
			$this->pais->ViewValue = $this->pais->CurrentValue;
			$this->pais->ViewCustomAttributes = "";

			// telefono
			$this->telefono->ViewValue = $this->telefono->CurrentValue;
			$this->telefono->ViewCustomAttributes = "";

			// tipo_certificado
			$this->tipo_certificado->ViewValue = $this->tipo_certificado->CurrentValue;
			$this->tipo_certificado->ViewValue = FormatNumber($this->tipo_certificado->ViewValue, 0, -2, -2, -2);
			$this->tipo_certificado->ViewCustomAttributes = "";

			// tipo_pago
			$this->tipo_pago->ViewValue = $this->tipo_pago->CurrentValue;
			$this->tipo_pago->ViewValue = FormatNumber($this->tipo_pago->ViewValue, 0, -2, -2, -2);
			$this->tipo_pago->ViewCustomAttributes = "";

			// nombretarjeta
			$this->nombretarjeta->ViewValue = $this->nombretarjeta->CurrentValue;
			$this->nombretarjeta->ViewCustomAttributes = "";

			// numerotarjeta
			$this->numerotarjeta->ViewValue = $this->numerotarjeta->CurrentValue;
			$this->numerotarjeta->ViewCustomAttributes = "";

			// mes
			$this->mes->ViewValue = $this->mes->CurrentValue;
			$this->mes->ViewCustomAttributes = "";

			// anio
			$this->anio->ViewValue = $this->anio->CurrentValue;
			$this->anio->ViewCustomAttributes = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->ViewValue = $this->tipo_tarjeta->CurrentValue;
			$this->tipo_tarjeta->ViewCustomAttributes = "";

			// nombrepaypal
			$this->nombrepaypal->ViewValue = $this->nombrepaypal->CurrentValue;
			$this->nombrepaypal->ViewCustomAttributes = "";

			// montopaypal
			$this->montopaypal->ViewValue = $this->montopaypal->CurrentValue;
			$this->montopaypal->ViewCustomAttributes = "";

			// emailpaypal
			$this->emailpaypal->ViewValue = $this->emailpaypal->CurrentValue;
			$this->emailpaypal->ViewCustomAttributes = "";

			// don
			$this->don->ViewValue = $this->don->CurrentValue;
			$this->don->ViewCustomAttributes = "";

			// tipo_condicion
			$this->tipo_condicion->ViewValue = $this->tipo_condicion->CurrentValue;
			$this->tipo_condicion->ViewValue = FormatNumber($this->tipo_condicion->ViewValue, 0, -2, -2, -2);
			$this->tipo_condicion->ViewCustomAttributes = "";

			// acciones
			$this->acciones->ViewValue = $this->acciones->CurrentValue;
			$this->acciones->ViewValue = FormatNumber($this->acciones->ViewValue, 0, -2, -2, -2);
			$this->acciones->ViewCustomAttributes = "";

			// solicitud
			$this->solicitud->ViewValue = $this->solicitud->CurrentValue;
			$this->solicitud->ViewValue = FormatNumber($this->solicitud->ViewValue, 0, -2, -2, -2);
			$this->solicitud->ViewCustomAttributes = "";

			// examen
			$this->examen->ViewValue = $this->examen->CurrentValue;
			$this->examen->ViewValue = FormatNumber($this->examen->ViewValue, 2, -2, -2, -2);
			$this->examen->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// tipo
			$this->tipo->ViewValue = $this->tipo->CurrentValue;
			$this->tipo->ViewValue = FormatNumber($this->tipo->ViewValue, 0, -2, -2, -2);
			$this->tipo->ViewCustomAttributes = "";

			// codigo_certificado
			$this->codigo_certificado->ViewValue = $this->codigo_certificado->CurrentValue;
			$this->codigo_certificado->ViewCustomAttributes = "";

			// estado_entrega
			$this->estado_entrega->ViewValue = $this->estado_entrega->CurrentValue;
			$this->estado_entrega->ViewValue = FormatNumber($this->estado_entrega->ViewValue, 0, -2, -2, -2);
			$this->estado_entrega->ViewCustomAttributes = "";

			// idioma
			$this->idioma->ViewValue = $this->idioma->CurrentValue;
			$this->idioma->ViewValue = FormatNumber($this->idioma->ViewValue, 0, -2, -2, -2);
			$this->idioma->ViewCustomAttributes = "";

			// tipo_documento
			$this->tipo_documento->ViewValue = $this->tipo_documento->CurrentValue;
			$this->tipo_documento->ViewValue = FormatNumber($this->tipo_documento->ViewValue, 0, -2, -2, -2);
			$this->tipo_documento->ViewCustomAttributes = "";

			// n_documento
			$this->n_documento->ViewValue = $this->n_documento->CurrentValue;
			$this->n_documento->ViewValue = FormatNumber($this->n_documento->ViewValue, 0, -2, -2, -2);
			$this->n_documento->ViewCustomAttributes = "";

			// condicion1
			$this->condicion1->ViewValue = $this->condicion1->CurrentValue;
			$this->condicion1->ViewValue = FormatNumber($this->condicion1->ViewValue, 0, -2, -2, -2);
			$this->condicion1->ViewCustomAttributes = "";

			// condicion2
			$this->condicion2->ViewValue = $this->condicion2->CurrentValue;
			$this->condicion2->ViewValue = FormatNumber($this->condicion2->ViewValue, 0, -2, -2, -2);
			$this->condicion2->ViewCustomAttributes = "";

			// consulta
			$this->consulta->ViewValue = $this->consulta->CurrentValue;
			$this->consulta->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// idproyecto
			$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
			$this->idproyecto->ViewValue = FormatNumber($this->idproyecto->ViewValue, 0, -2, -2, -2);
			$this->idproyecto->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewValue = FormatNumber($this->id_producto->ViewValue, 0, -2, -2, -2);
			$this->id_producto->ViewCustomAttributes = "";

			// idinteresado
			$this->idinteresado->LinkCustomAttributes = "";
			$this->idinteresado->HrefValue = "";
			$this->idinteresado->TooltipValue = "";

			// id_usuarioencargado
			$this->id_usuarioencargado->LinkCustomAttributes = "";
			$this->id_usuarioencargado->HrefValue = "";
			$this->id_usuarioencargado->TooltipValue = "";

			// fecha
			$this->fecha->LinkCustomAttributes = "";
			$this->fecha->HrefValue = "";
			$this->fecha->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// cursos
			$this->cursos->LinkCustomAttributes = "";
			$this->cursos->HrefValue = "";
			$this->cursos->TooltipValue = "";

			// categorias
			$this->categorias->LinkCustomAttributes = "";
			$this->categorias->HrefValue = "";
			$this->categorias->TooltipValue = "";

			// nombres
			$this->nombres->LinkCustomAttributes = "";
			$this->nombres->HrefValue = "";
			$this->nombres->TooltipValue = "";

			// apellidos
			$this->apellidos->LinkCustomAttributes = "";
			$this->apellidos->HrefValue = "";
			$this->apellidos->TooltipValue = "";

			// direccion
			$this->direccion->LinkCustomAttributes = "";
			$this->direccion->HrefValue = "";
			$this->direccion->TooltipValue = "";

			// ciudad
			$this->ciudad->LinkCustomAttributes = "";
			$this->ciudad->HrefValue = "";
			$this->ciudad->TooltipValue = "";

			// provincia
			$this->provincia->LinkCustomAttributes = "";
			$this->provincia->HrefValue = "";
			$this->provincia->TooltipValue = "";

			// pais
			$this->pais->LinkCustomAttributes = "";
			$this->pais->HrefValue = "";
			$this->pais->TooltipValue = "";

			// telefono
			$this->telefono->LinkCustomAttributes = "";
			$this->telefono->HrefValue = "";
			$this->telefono->TooltipValue = "";

			// tipo_certificado
			$this->tipo_certificado->LinkCustomAttributes = "";
			$this->tipo_certificado->HrefValue = "";
			$this->tipo_certificado->TooltipValue = "";

			// tipo_pago
			$this->tipo_pago->LinkCustomAttributes = "";
			$this->tipo_pago->HrefValue = "";
			$this->tipo_pago->TooltipValue = "";

			// nombretarjeta
			$this->nombretarjeta->LinkCustomAttributes = "";
			$this->nombretarjeta->HrefValue = "";
			$this->nombretarjeta->TooltipValue = "";

			// numerotarjeta
			$this->numerotarjeta->LinkCustomAttributes = "";
			$this->numerotarjeta->HrefValue = "";
			$this->numerotarjeta->TooltipValue = "";

			// mes
			$this->mes->LinkCustomAttributes = "";
			$this->mes->HrefValue = "";
			$this->mes->TooltipValue = "";

			// anio
			$this->anio->LinkCustomAttributes = "";
			$this->anio->HrefValue = "";
			$this->anio->TooltipValue = "";

			// tipo_tarjeta
			$this->tipo_tarjeta->LinkCustomAttributes = "";
			$this->tipo_tarjeta->HrefValue = "";
			$this->tipo_tarjeta->TooltipValue = "";

			// nombrepaypal
			$this->nombrepaypal->LinkCustomAttributes = "";
			$this->nombrepaypal->HrefValue = "";
			$this->nombrepaypal->TooltipValue = "";

			// montopaypal
			$this->montopaypal->LinkCustomAttributes = "";
			$this->montopaypal->HrefValue = "";
			$this->montopaypal->TooltipValue = "";

			// emailpaypal
			$this->emailpaypal->LinkCustomAttributes = "";
			$this->emailpaypal->HrefValue = "";
			$this->emailpaypal->TooltipValue = "";

			// don
			$this->don->LinkCustomAttributes = "";
			$this->don->HrefValue = "";
			$this->don->TooltipValue = "";

			// tipo_condicion
			$this->tipo_condicion->LinkCustomAttributes = "";
			$this->tipo_condicion->HrefValue = "";
			$this->tipo_condicion->TooltipValue = "";

			// acciones
			$this->acciones->LinkCustomAttributes = "";
			$this->acciones->HrefValue = "";
			$this->acciones->TooltipValue = "";

			// solicitud
			$this->solicitud->LinkCustomAttributes = "";
			$this->solicitud->HrefValue = "";
			$this->solicitud->TooltipValue = "";

			// examen
			$this->examen->LinkCustomAttributes = "";
			$this->examen->HrefValue = "";
			$this->examen->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";
			$this->tipo->TooltipValue = "";

			// codigo_certificado
			$this->codigo_certificado->LinkCustomAttributes = "";
			$this->codigo_certificado->HrefValue = "";
			$this->codigo_certificado->TooltipValue = "";

			// estado_entrega
			$this->estado_entrega->LinkCustomAttributes = "";
			$this->estado_entrega->HrefValue = "";
			$this->estado_entrega->TooltipValue = "";

			// idioma
			$this->idioma->LinkCustomAttributes = "";
			$this->idioma->HrefValue = "";
			$this->idioma->TooltipValue = "";

			// tipo_documento
			$this->tipo_documento->LinkCustomAttributes = "";
			$this->tipo_documento->HrefValue = "";
			$this->tipo_documento->TooltipValue = "";

			// n_documento
			$this->n_documento->LinkCustomAttributes = "";
			$this->n_documento->HrefValue = "";
			$this->n_documento->TooltipValue = "";

			// condicion1
			$this->condicion1->LinkCustomAttributes = "";
			$this->condicion1->HrefValue = "";
			$this->condicion1->TooltipValue = "";

			// condicion2
			$this->condicion2->LinkCustomAttributes = "";
			$this->condicion2->HrefValue = "";
			$this->condicion2->TooltipValue = "";

			// consulta
			$this->consulta->LinkCustomAttributes = "";
			$this->consulta->HrefValue = "";
			$this->consulta->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// idproyecto
			$this->idproyecto->LinkCustomAttributes = "";
			$this->idproyecto->HrefValue = "";
			$this->idproyecto->TooltipValue = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['idinteresado'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("interesadoslist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>