<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kp_proyecto_add extends kp_proyecto
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kp_proyecto';

	// Page object name
	public $PageObjName = "kp_proyecto_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kp_proyecto)
		if (!isset($GLOBALS["kp_proyecto"]) || get_class($GLOBALS["kp_proyecto"]) == PROJECT_NAMESPACE . "kp_proyecto") {
			$GLOBALS["kp_proyecto"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kp_proyecto"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kp_proyecto');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kp_proyecto;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kp_proyecto);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "kp_proyectoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idproyecto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idproyecto->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kp_proyectolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idproyecto->Visible = FALSE;
		$this->titulo->setVisibility();
		$this->nombre->setVisibility();
		$this->descproyecto->setVisibility();
		$this->ubicacion->setVisibility();
		$this->cuotas->setVisibility();
		$this->foto->setVisibility();
		$this->video->setVisibility();
		$this->estado->setVisibility();
		$this->status->setVisibility();
		$this->idcategoria->setVisibility();
		$this->descuento->setVisibility();
		$this->precio->setVisibility();
		$this->tipo_entrega->setVisibility();
		$this->metros_cuadrados->setVisibility();
		$this->url->setVisibility();
		$this->idempresa->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("idproyecto") !== NULL) {
				$this->idproyecto->setQueryStringValue(Get("idproyecto"));
				$this->setKey("idproyecto", $this->idproyecto->CurrentValue); // Set up key
			} else {
				$this->setKey("idproyecto", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("kp_proyectolist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "kp_proyectolist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "kp_proyectoview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->idproyecto->CurrentValue = NULL;
		$this->idproyecto->OldValue = $this->idproyecto->CurrentValue;
		$this->titulo->CurrentValue = NULL;
		$this->titulo->OldValue = $this->titulo->CurrentValue;
		$this->nombre->CurrentValue = NULL;
		$this->nombre->OldValue = $this->nombre->CurrentValue;
		$this->descproyecto->CurrentValue = NULL;
		$this->descproyecto->OldValue = $this->descproyecto->CurrentValue;
		$this->ubicacion->CurrentValue = NULL;
		$this->ubicacion->OldValue = $this->ubicacion->CurrentValue;
		$this->cuotas->CurrentValue = NULL;
		$this->cuotas->OldValue = $this->cuotas->CurrentValue;
		$this->foto->CurrentValue = NULL;
		$this->foto->OldValue = $this->foto->CurrentValue;
		$this->video->CurrentValue = NULL;
		$this->video->OldValue = $this->video->CurrentValue;
		$this->estado->CurrentValue = 1;
		$this->status->CurrentValue = 1;
		$this->idcategoria->CurrentValue = NULL;
		$this->idcategoria->OldValue = $this->idcategoria->CurrentValue;
		$this->descuento->CurrentValue = NULL;
		$this->descuento->OldValue = $this->descuento->CurrentValue;
		$this->precio->CurrentValue = NULL;
		$this->precio->OldValue = $this->precio->CurrentValue;
		$this->tipo_entrega->CurrentValue = NULL;
		$this->tipo_entrega->OldValue = $this->tipo_entrega->CurrentValue;
		$this->metros_cuadrados->CurrentValue = NULL;
		$this->metros_cuadrados->OldValue = $this->metros_cuadrados->CurrentValue;
		$this->url->CurrentValue = NULL;
		$this->url->OldValue = $this->url->CurrentValue;
		$this->idempresa->CurrentValue = NULL;
		$this->idempresa->OldValue = $this->idempresa->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'titulo' first before field var 'x_titulo'
		$val = $CurrentForm->hasValue("titulo") ? $CurrentForm->getValue("titulo") : $CurrentForm->getValue("x_titulo");
		if (!$this->titulo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->titulo->Visible = FALSE; // Disable update for API request
			else
				$this->titulo->setFormValue($val);
		}

		// Check field name 'nombre' first before field var 'x_nombre'
		$val = $CurrentForm->hasValue("nombre") ? $CurrentForm->getValue("nombre") : $CurrentForm->getValue("x_nombre");
		if (!$this->nombre->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombre->Visible = FALSE; // Disable update for API request
			else
				$this->nombre->setFormValue($val);
		}

		// Check field name 'descproyecto' first before field var 'x_descproyecto'
		$val = $CurrentForm->hasValue("descproyecto") ? $CurrentForm->getValue("descproyecto") : $CurrentForm->getValue("x_descproyecto");
		if (!$this->descproyecto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descproyecto->Visible = FALSE; // Disable update for API request
			else
				$this->descproyecto->setFormValue($val);
		}

		// Check field name 'ubicacion' first before field var 'x_ubicacion'
		$val = $CurrentForm->hasValue("ubicacion") ? $CurrentForm->getValue("ubicacion") : $CurrentForm->getValue("x_ubicacion");
		if (!$this->ubicacion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ubicacion->Visible = FALSE; // Disable update for API request
			else
				$this->ubicacion->setFormValue($val);
		}

		// Check field name 'cuotas' first before field var 'x_cuotas'
		$val = $CurrentForm->hasValue("cuotas") ? $CurrentForm->getValue("cuotas") : $CurrentForm->getValue("x_cuotas");
		if (!$this->cuotas->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cuotas->Visible = FALSE; // Disable update for API request
			else
				$this->cuotas->setFormValue($val);
		}

		// Check field name 'foto' first before field var 'x_foto'
		$val = $CurrentForm->hasValue("foto") ? $CurrentForm->getValue("foto") : $CurrentForm->getValue("x_foto");
		if (!$this->foto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto->Visible = FALSE; // Disable update for API request
			else
				$this->foto->setFormValue($val);
		}

		// Check field name 'video' first before field var 'x_video'
		$val = $CurrentForm->hasValue("video") ? $CurrentForm->getValue("video") : $CurrentForm->getValue("x_video");
		if (!$this->video->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->video->Visible = FALSE; // Disable update for API request
			else
				$this->video->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'idcategoria' first before field var 'x_idcategoria'
		$val = $CurrentForm->hasValue("idcategoria") ? $CurrentForm->getValue("idcategoria") : $CurrentForm->getValue("x_idcategoria");
		if (!$this->idcategoria->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idcategoria->Visible = FALSE; // Disable update for API request
			else
				$this->idcategoria->setFormValue($val);
		}

		// Check field name 'descuento' first before field var 'x_descuento'
		$val = $CurrentForm->hasValue("descuento") ? $CurrentForm->getValue("descuento") : $CurrentForm->getValue("x_descuento");
		if (!$this->descuento->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descuento->Visible = FALSE; // Disable update for API request
			else
				$this->descuento->setFormValue($val);
		}

		// Check field name 'precio' first before field var 'x_precio'
		$val = $CurrentForm->hasValue("precio") ? $CurrentForm->getValue("precio") : $CurrentForm->getValue("x_precio");
		if (!$this->precio->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio->Visible = FALSE; // Disable update for API request
			else
				$this->precio->setFormValue($val);
		}

		// Check field name 'tipo_entrega' first before field var 'x_tipo_entrega'
		$val = $CurrentForm->hasValue("tipo_entrega") ? $CurrentForm->getValue("tipo_entrega") : $CurrentForm->getValue("x_tipo_entrega");
		if (!$this->tipo_entrega->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_entrega->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_entrega->setFormValue($val);
		}

		// Check field name 'metros_cuadrados' first before field var 'x_metros_cuadrados'
		$val = $CurrentForm->hasValue("metros_cuadrados") ? $CurrentForm->getValue("metros_cuadrados") : $CurrentForm->getValue("x_metros_cuadrados");
		if (!$this->metros_cuadrados->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->metros_cuadrados->Visible = FALSE; // Disable update for API request
			else
				$this->metros_cuadrados->setFormValue($val);
		}

		// Check field name 'url' first before field var 'x_url'
		$val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
		if (!$this->url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->url->Visible = FALSE; // Disable update for API request
			else
				$this->url->setFormValue($val);
		}

		// Check field name 'idempresa' first before field var 'x_idempresa'
		$val = $CurrentForm->hasValue("idempresa") ? $CurrentForm->getValue("idempresa") : $CurrentForm->getValue("x_idempresa");
		if (!$this->idempresa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idempresa->Visible = FALSE; // Disable update for API request
			else
				$this->idempresa->setFormValue($val);
		}

		// Check field name 'idproyecto' first before field var 'x_idproyecto'
		$val = $CurrentForm->hasValue("idproyecto") ? $CurrentForm->getValue("idproyecto") : $CurrentForm->getValue("x_idproyecto");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->titulo->CurrentValue = $this->titulo->FormValue;
		$this->nombre->CurrentValue = $this->nombre->FormValue;
		$this->descproyecto->CurrentValue = $this->descproyecto->FormValue;
		$this->ubicacion->CurrentValue = $this->ubicacion->FormValue;
		$this->cuotas->CurrentValue = $this->cuotas->FormValue;
		$this->foto->CurrentValue = $this->foto->FormValue;
		$this->video->CurrentValue = $this->video->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->idcategoria->CurrentValue = $this->idcategoria->FormValue;
		$this->descuento->CurrentValue = $this->descuento->FormValue;
		$this->precio->CurrentValue = $this->precio->FormValue;
		$this->tipo_entrega->CurrentValue = $this->tipo_entrega->FormValue;
		$this->metros_cuadrados->CurrentValue = $this->metros_cuadrados->FormValue;
		$this->url->CurrentValue = $this->url->FormValue;
		$this->idempresa->CurrentValue = $this->idempresa->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idproyecto->setDbValue($row['idproyecto']);
		$this->titulo->setDbValue($row['titulo']);
		$this->nombre->setDbValue($row['nombre']);
		$this->descproyecto->setDbValue($row['descproyecto']);
		$this->ubicacion->setDbValue($row['ubicacion']);
		$this->cuotas->setDbValue($row['cuotas']);
		$this->foto->setDbValue($row['foto']);
		$this->video->setDbValue($row['video']);
		$this->estado->setDbValue($row['estado']);
		$this->status->setDbValue($row['status']);
		$this->idcategoria->setDbValue($row['idcategoria']);
		$this->descuento->setDbValue($row['descuento']);
		$this->precio->setDbValue($row['precio']);
		$this->tipo_entrega->setDbValue($row['tipo_entrega']);
		$this->metros_cuadrados->setDbValue($row['metros_cuadrados']);
		$this->url->setDbValue($row['url']);
		$this->idempresa->setDbValue($row['idempresa']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['idproyecto'] = $this->idproyecto->CurrentValue;
		$row['titulo'] = $this->titulo->CurrentValue;
		$row['nombre'] = $this->nombre->CurrentValue;
		$row['descproyecto'] = $this->descproyecto->CurrentValue;
		$row['ubicacion'] = $this->ubicacion->CurrentValue;
		$row['cuotas'] = $this->cuotas->CurrentValue;
		$row['foto'] = $this->foto->CurrentValue;
		$row['video'] = $this->video->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['idcategoria'] = $this->idcategoria->CurrentValue;
		$row['descuento'] = $this->descuento->CurrentValue;
		$row['precio'] = $this->precio->CurrentValue;
		$row['tipo_entrega'] = $this->tipo_entrega->CurrentValue;
		$row['metros_cuadrados'] = $this->metros_cuadrados->CurrentValue;
		$row['url'] = $this->url->CurrentValue;
		$row['idempresa'] = $this->idempresa->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idproyecto")) != "")
			$this->idproyecto->OldValue = $this->getKey("idproyecto"); // idproyecto
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->descuento->FormValue == $this->descuento->CurrentValue && is_numeric(ConvertToFloatString($this->descuento->CurrentValue)))
			$this->descuento->CurrentValue = ConvertToFloatString($this->descuento->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio->FormValue == $this->precio->CurrentValue && is_numeric(ConvertToFloatString($this->precio->CurrentValue)))
			$this->precio->CurrentValue = ConvertToFloatString($this->precio->CurrentValue);

		// Convert decimal values if posted back
		if ($this->metros_cuadrados->FormValue == $this->metros_cuadrados->CurrentValue && is_numeric(ConvertToFloatString($this->metros_cuadrados->CurrentValue)))
			$this->metros_cuadrados->CurrentValue = ConvertToFloatString($this->metros_cuadrados->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idproyecto
		// titulo
		// nombre
		// descproyecto
		// ubicacion
		// cuotas
		// foto
		// video
		// estado
		// status
		// idcategoria
		// descuento
		// precio
		// tipo_entrega
		// metros_cuadrados
		// url
		// idempresa

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idproyecto
			$this->idproyecto->ViewValue = $this->idproyecto->CurrentValue;
			$this->idproyecto->ViewCustomAttributes = "";

			// titulo
			$this->titulo->ViewValue = $this->titulo->CurrentValue;
			$this->titulo->ViewCustomAttributes = "";

			// nombre
			$this->nombre->ViewValue = $this->nombre->CurrentValue;
			$this->nombre->ViewCustomAttributes = "";

			// descproyecto
			$this->descproyecto->ViewValue = $this->descproyecto->CurrentValue;
			$this->descproyecto->ViewCustomAttributes = "";

			// ubicacion
			$this->ubicacion->ViewValue = $this->ubicacion->CurrentValue;
			$this->ubicacion->ViewCustomAttributes = "";

			// cuotas
			$this->cuotas->ViewValue = $this->cuotas->CurrentValue;
			$this->cuotas->ViewValue = FormatNumber($this->cuotas->ViewValue, 0, -2, -2, -2);
			$this->cuotas->ViewCustomAttributes = "";

			// foto
			$this->foto->ViewValue = $this->foto->CurrentValue;
			$this->foto->ViewCustomAttributes = "";

			// video
			$this->video->ViewValue = $this->video->CurrentValue;
			$this->video->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// idcategoria
			$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
			$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
			$this->idcategoria->ViewCustomAttributes = "";

			// descuento
			$this->descuento->ViewValue = $this->descuento->CurrentValue;
			$this->descuento->ViewValue = FormatNumber($this->descuento->ViewValue, 2, -2, -2, -2);
			$this->descuento->ViewCustomAttributes = "";

			// precio
			$this->precio->ViewValue = $this->precio->CurrentValue;
			$this->precio->ViewValue = FormatNumber($this->precio->ViewValue, 2, -2, -2, -2);
			$this->precio->ViewCustomAttributes = "";

			// tipo_entrega
			$this->tipo_entrega->ViewValue = $this->tipo_entrega->CurrentValue;
			$this->tipo_entrega->ViewValue = FormatNumber($this->tipo_entrega->ViewValue, 0, -2, -2, -2);
			$this->tipo_entrega->ViewCustomAttributes = "";

			// metros_cuadrados
			$this->metros_cuadrados->ViewValue = $this->metros_cuadrados->CurrentValue;
			$this->metros_cuadrados->ViewValue = FormatNumber($this->metros_cuadrados->ViewValue, 2, -2, -2, -2);
			$this->metros_cuadrados->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// titulo
			$this->titulo->LinkCustomAttributes = "";
			$this->titulo->HrefValue = "";
			$this->titulo->TooltipValue = "";

			// nombre
			$this->nombre->LinkCustomAttributes = "";
			$this->nombre->HrefValue = "";
			$this->nombre->TooltipValue = "";

			// descproyecto
			$this->descproyecto->LinkCustomAttributes = "";
			$this->descproyecto->HrefValue = "";
			$this->descproyecto->TooltipValue = "";

			// ubicacion
			$this->ubicacion->LinkCustomAttributes = "";
			$this->ubicacion->HrefValue = "";
			$this->ubicacion->TooltipValue = "";

			// cuotas
			$this->cuotas->LinkCustomAttributes = "";
			$this->cuotas->HrefValue = "";
			$this->cuotas->TooltipValue = "";

			// foto
			$this->foto->LinkCustomAttributes = "";
			$this->foto->HrefValue = "";
			$this->foto->TooltipValue = "";

			// video
			$this->video->LinkCustomAttributes = "";
			$this->video->HrefValue = "";
			$this->video->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";
			$this->idcategoria->TooltipValue = "";

			// descuento
			$this->descuento->LinkCustomAttributes = "";
			$this->descuento->HrefValue = "";
			$this->descuento->TooltipValue = "";

			// precio
			$this->precio->LinkCustomAttributes = "";
			$this->precio->HrefValue = "";
			$this->precio->TooltipValue = "";

			// tipo_entrega
			$this->tipo_entrega->LinkCustomAttributes = "";
			$this->tipo_entrega->HrefValue = "";
			$this->tipo_entrega->TooltipValue = "";

			// metros_cuadrados
			$this->metros_cuadrados->LinkCustomAttributes = "";
			$this->metros_cuadrados->HrefValue = "";
			$this->metros_cuadrados->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// titulo
			$this->titulo->EditAttrs["class"] = "form-control";
			$this->titulo->EditCustomAttributes = "";
			if (!$this->titulo->Raw)
				$this->titulo->CurrentValue = HtmlDecode($this->titulo->CurrentValue);
			$this->titulo->EditValue = HtmlEncode($this->titulo->CurrentValue);
			$this->titulo->PlaceHolder = RemoveHtml($this->titulo->caption());

			// nombre
			$this->nombre->EditAttrs["class"] = "form-control";
			$this->nombre->EditCustomAttributes = "";
			if (!$this->nombre->Raw)
				$this->nombre->CurrentValue = HtmlDecode($this->nombre->CurrentValue);
			$this->nombre->EditValue = HtmlEncode($this->nombre->CurrentValue);
			$this->nombre->PlaceHolder = RemoveHtml($this->nombre->caption());

			// descproyecto
			$this->descproyecto->EditAttrs["class"] = "form-control";
			$this->descproyecto->EditCustomAttributes = "";
			$this->descproyecto->EditValue = HtmlEncode($this->descproyecto->CurrentValue);
			$this->descproyecto->PlaceHolder = RemoveHtml($this->descproyecto->caption());

			// ubicacion
			$this->ubicacion->EditAttrs["class"] = "form-control";
			$this->ubicacion->EditCustomAttributes = "";
			if (!$this->ubicacion->Raw)
				$this->ubicacion->CurrentValue = HtmlDecode($this->ubicacion->CurrentValue);
			$this->ubicacion->EditValue = HtmlEncode($this->ubicacion->CurrentValue);
			$this->ubicacion->PlaceHolder = RemoveHtml($this->ubicacion->caption());

			// cuotas
			$this->cuotas->EditAttrs["class"] = "form-control";
			$this->cuotas->EditCustomAttributes = "";
			$this->cuotas->EditValue = HtmlEncode($this->cuotas->CurrentValue);
			$this->cuotas->PlaceHolder = RemoveHtml($this->cuotas->caption());

			// foto
			$this->foto->EditAttrs["class"] = "form-control";
			$this->foto->EditCustomAttributes = "";
			if (!$this->foto->Raw)
				$this->foto->CurrentValue = HtmlDecode($this->foto->CurrentValue);
			$this->foto->EditValue = HtmlEncode($this->foto->CurrentValue);
			$this->foto->PlaceHolder = RemoveHtml($this->foto->caption());

			// video
			$this->video->EditAttrs["class"] = "form-control";
			$this->video->EditCustomAttributes = "";
			if (!$this->video->Raw)
				$this->video->CurrentValue = HtmlDecode($this->video->CurrentValue);
			$this->video->EditValue = HtmlEncode($this->video->CurrentValue);
			$this->video->PlaceHolder = RemoveHtml($this->video->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// idcategoria
			$this->idcategoria->EditAttrs["class"] = "form-control";
			$this->idcategoria->EditCustomAttributes = "";
			$this->idcategoria->EditValue = HtmlEncode($this->idcategoria->CurrentValue);
			$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

			// descuento
			$this->descuento->EditAttrs["class"] = "form-control";
			$this->descuento->EditCustomAttributes = "";
			$this->descuento->EditValue = HtmlEncode($this->descuento->CurrentValue);
			$this->descuento->PlaceHolder = RemoveHtml($this->descuento->caption());
			if (strval($this->descuento->EditValue) != "" && is_numeric($this->descuento->EditValue))
				$this->descuento->EditValue = FormatNumber($this->descuento->EditValue, -2, -2, -2, -2);
			

			// precio
			$this->precio->EditAttrs["class"] = "form-control";
			$this->precio->EditCustomAttributes = "";
			$this->precio->EditValue = HtmlEncode($this->precio->CurrentValue);
			$this->precio->PlaceHolder = RemoveHtml($this->precio->caption());
			if (strval($this->precio->EditValue) != "" && is_numeric($this->precio->EditValue))
				$this->precio->EditValue = FormatNumber($this->precio->EditValue, -2, -2, -2, -2);
			

			// tipo_entrega
			$this->tipo_entrega->EditAttrs["class"] = "form-control";
			$this->tipo_entrega->EditCustomAttributes = "";
			$this->tipo_entrega->EditValue = HtmlEncode($this->tipo_entrega->CurrentValue);
			$this->tipo_entrega->PlaceHolder = RemoveHtml($this->tipo_entrega->caption());

			// metros_cuadrados
			$this->metros_cuadrados->EditAttrs["class"] = "form-control";
			$this->metros_cuadrados->EditCustomAttributes = "";
			$this->metros_cuadrados->EditValue = HtmlEncode($this->metros_cuadrados->CurrentValue);
			$this->metros_cuadrados->PlaceHolder = RemoveHtml($this->metros_cuadrados->caption());
			if (strval($this->metros_cuadrados->EditValue) != "" && is_numeric($this->metros_cuadrados->EditValue))
				$this->metros_cuadrados->EditValue = FormatNumber($this->metros_cuadrados->EditValue, -2, -2, -2, -2);
			

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (!$this->url->Raw)
				$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
			$this->url->EditValue = HtmlEncode($this->url->CurrentValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());

			// idempresa
			$this->idempresa->EditAttrs["class"] = "form-control";
			$this->idempresa->EditCustomAttributes = "";
			$this->idempresa->EditValue = HtmlEncode($this->idempresa->CurrentValue);
			$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

			// Add refer script
			// titulo

			$this->titulo->LinkCustomAttributes = "";
			$this->titulo->HrefValue = "";

			// nombre
			$this->nombre->LinkCustomAttributes = "";
			$this->nombre->HrefValue = "";

			// descproyecto
			$this->descproyecto->LinkCustomAttributes = "";
			$this->descproyecto->HrefValue = "";

			// ubicacion
			$this->ubicacion->LinkCustomAttributes = "";
			$this->ubicacion->HrefValue = "";

			// cuotas
			$this->cuotas->LinkCustomAttributes = "";
			$this->cuotas->HrefValue = "";

			// foto
			$this->foto->LinkCustomAttributes = "";
			$this->foto->HrefValue = "";

			// video
			$this->video->LinkCustomAttributes = "";
			$this->video->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";

			// descuento
			$this->descuento->LinkCustomAttributes = "";
			$this->descuento->HrefValue = "";

			// precio
			$this->precio->LinkCustomAttributes = "";
			$this->precio->HrefValue = "";

			// tipo_entrega
			$this->tipo_entrega->LinkCustomAttributes = "";
			$this->tipo_entrega->HrefValue = "";

			// metros_cuadrados
			$this->metros_cuadrados->LinkCustomAttributes = "";
			$this->metros_cuadrados->HrefValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->titulo->Required) {
			if (!$this->titulo->IsDetailKey && $this->titulo->FormValue != NULL && $this->titulo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->titulo->caption(), $this->titulo->RequiredErrorMessage));
			}
		}
		if ($this->nombre->Required) {
			if (!$this->nombre->IsDetailKey && $this->nombre->FormValue != NULL && $this->nombre->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombre->caption(), $this->nombre->RequiredErrorMessage));
			}
		}
		if ($this->descproyecto->Required) {
			if (!$this->descproyecto->IsDetailKey && $this->descproyecto->FormValue != NULL && $this->descproyecto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descproyecto->caption(), $this->descproyecto->RequiredErrorMessage));
			}
		}
		if ($this->ubicacion->Required) {
			if (!$this->ubicacion->IsDetailKey && $this->ubicacion->FormValue != NULL && $this->ubicacion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ubicacion->caption(), $this->ubicacion->RequiredErrorMessage));
			}
		}
		if ($this->cuotas->Required) {
			if (!$this->cuotas->IsDetailKey && $this->cuotas->FormValue != NULL && $this->cuotas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cuotas->caption(), $this->cuotas->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cuotas->FormValue)) {
			AddMessage($FormError, $this->cuotas->errorMessage());
		}
		if ($this->foto->Required) {
			if (!$this->foto->IsDetailKey && $this->foto->FormValue != NULL && $this->foto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto->caption(), $this->foto->RequiredErrorMessage));
			}
		}
		if ($this->video->Required) {
			if (!$this->video->IsDetailKey && $this->video->FormValue != NULL && $this->video->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->video->caption(), $this->video->RequiredErrorMessage));
			}
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status->FormValue)) {
			AddMessage($FormError, $this->status->errorMessage());
		}
		if ($this->idcategoria->Required) {
			if (!$this->idcategoria->IsDetailKey && $this->idcategoria->FormValue != NULL && $this->idcategoria->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idcategoria->caption(), $this->idcategoria->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idcategoria->FormValue)) {
			AddMessage($FormError, $this->idcategoria->errorMessage());
		}
		if ($this->descuento->Required) {
			if (!$this->descuento->IsDetailKey && $this->descuento->FormValue != NULL && $this->descuento->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descuento->caption(), $this->descuento->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->descuento->FormValue)) {
			AddMessage($FormError, $this->descuento->errorMessage());
		}
		if ($this->precio->Required) {
			if (!$this->precio->IsDetailKey && $this->precio->FormValue != NULL && $this->precio->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio->caption(), $this->precio->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio->FormValue)) {
			AddMessage($FormError, $this->precio->errorMessage());
		}
		if ($this->tipo_entrega->Required) {
			if (!$this->tipo_entrega->IsDetailKey && $this->tipo_entrega->FormValue != NULL && $this->tipo_entrega->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_entrega->caption(), $this->tipo_entrega->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_entrega->FormValue)) {
			AddMessage($FormError, $this->tipo_entrega->errorMessage());
		}
		if ($this->metros_cuadrados->Required) {
			if (!$this->metros_cuadrados->IsDetailKey && $this->metros_cuadrados->FormValue != NULL && $this->metros_cuadrados->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->metros_cuadrados->caption(), $this->metros_cuadrados->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->metros_cuadrados->FormValue)) {
			AddMessage($FormError, $this->metros_cuadrados->errorMessage());
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->idempresa->Required) {
			if (!$this->idempresa->IsDetailKey && $this->idempresa->FormValue != NULL && $this->idempresa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idempresa->caption(), $this->idempresa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idempresa->FormValue)) {
			AddMessage($FormError, $this->idempresa->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// titulo
		$this->titulo->setDbValueDef($rsnew, $this->titulo->CurrentValue, NULL, FALSE);

		// nombre
		$this->nombre->setDbValueDef($rsnew, $this->nombre->CurrentValue, NULL, FALSE);

		// descproyecto
		$this->descproyecto->setDbValueDef($rsnew, $this->descproyecto->CurrentValue, NULL, FALSE);

		// ubicacion
		$this->ubicacion->setDbValueDef($rsnew, $this->ubicacion->CurrentValue, NULL, FALSE);

		// cuotas
		$this->cuotas->setDbValueDef($rsnew, $this->cuotas->CurrentValue, NULL, FALSE);

		// foto
		$this->foto->setDbValueDef($rsnew, $this->foto->CurrentValue, NULL, FALSE);

		// video
		$this->video->setDbValueDef($rsnew, $this->video->CurrentValue, NULL, FALSE);

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, strval($this->estado->CurrentValue) == "");

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, strval($this->status->CurrentValue) == "");

		// idcategoria
		$this->idcategoria->setDbValueDef($rsnew, $this->idcategoria->CurrentValue, NULL, FALSE);

		// descuento
		$this->descuento->setDbValueDef($rsnew, $this->descuento->CurrentValue, NULL, FALSE);

		// precio
		$this->precio->setDbValueDef($rsnew, $this->precio->CurrentValue, NULL, FALSE);

		// tipo_entrega
		$this->tipo_entrega->setDbValueDef($rsnew, $this->tipo_entrega->CurrentValue, NULL, FALSE);

		// metros_cuadrados
		$this->metros_cuadrados->setDbValueDef($rsnew, $this->metros_cuadrados->CurrentValue, NULL, FALSE);

		// url
		$this->url->setDbValueDef($rsnew, $this->url->CurrentValue, NULL, FALSE);

		// idempresa
		$this->idempresa->setDbValueDef($rsnew, $this->idempresa->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kp_proyectolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>