<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kp_usuarios_edit extends kp_usuarios
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kp_usuarios';

	// Page object name
	public $PageObjName = "kp_usuarios_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kp_usuarios)
		if (!isset($GLOBALS["kp_usuarios"]) || get_class($GLOBALS["kp_usuarios"]) == PROJECT_NAMESPACE . "kp_usuarios") {
			$GLOBALS["kp_usuarios"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kp_usuarios"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kp_usuarios');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kp_usuarios;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kp_usuarios);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "kp_usuariosview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idusuario'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idusuario->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kp_usuarioslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->codlogin->setVisibility();
		$this->codpassword->setVisibility();
		$this->nomusuario->setVisibility();
		$this->apeusuario->setVisibility();
		$this->tipo->setVisibility();
		$this->fecha_reg->setVisibility();
		$this->dniusuario->setVisibility();
		$this->telefonousuario->setVisibility();
		$this->celularusuario->setVisibility();
		$this->direccionusuario->setVisibility();
		$this->emailcorpusuario->setVisibility();
		$this->emailusuario->setVisibility();
		$this->iddisciplina->setVisibility();
		$this->idperfil->setVisibility();
		$this->mostrarcalendario->setVisibility();
		$this->obsusuario->setVisibility();
		$this->verificaringreso->setVisibility();
		$this->estadousuario->setVisibility();
		$this->idcategoria->setVisibility();
		$this->tipo_usuario->setVisibility();
		$this->idempresa->setVisibility();
		$this->idusuario->setVisibility();
		$this->estado->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_idusuario")) {
				$this->idusuario->setFormValue($CurrentForm->getValue("x_idusuario"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("idusuario") !== NULL) {
				$this->idusuario->setQueryStringValue(Get("idusuario"));
				$loadByQuery = TRUE;
			} else {
				$this->idusuario->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("kp_usuarioslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "kp_usuarioslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'codlogin' first before field var 'x_codlogin'
		$val = $CurrentForm->hasValue("codlogin") ? $CurrentForm->getValue("codlogin") : $CurrentForm->getValue("x_codlogin");
		if (!$this->codlogin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codlogin->Visible = FALSE; // Disable update for API request
			else
				$this->codlogin->setFormValue($val);
		}

		// Check field name 'codpassword' first before field var 'x_codpassword'
		$val = $CurrentForm->hasValue("codpassword") ? $CurrentForm->getValue("codpassword") : $CurrentForm->getValue("x_codpassword");
		if (!$this->codpassword->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codpassword->Visible = FALSE; // Disable update for API request
			else
				$this->codpassword->setFormValue($val);
		}

		// Check field name 'nomusuario' first before field var 'x_nomusuario'
		$val = $CurrentForm->hasValue("nomusuario") ? $CurrentForm->getValue("nomusuario") : $CurrentForm->getValue("x_nomusuario");
		if (!$this->nomusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomusuario->Visible = FALSE; // Disable update for API request
			else
				$this->nomusuario->setFormValue($val);
		}

		// Check field name 'apeusuario' first before field var 'x_apeusuario'
		$val = $CurrentForm->hasValue("apeusuario") ? $CurrentForm->getValue("apeusuario") : $CurrentForm->getValue("x_apeusuario");
		if (!$this->apeusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->apeusuario->Visible = FALSE; // Disable update for API request
			else
				$this->apeusuario->setFormValue($val);
		}

		// Check field name 'tipo' first before field var 'x_tipo'
		$val = $CurrentForm->hasValue("tipo") ? $CurrentForm->getValue("tipo") : $CurrentForm->getValue("x_tipo");
		if (!$this->tipo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo->Visible = FALSE; // Disable update for API request
			else
				$this->tipo->setFormValue($val);
		}

		// Check field name 'fecha_reg' first before field var 'x_fecha_reg'
		$val = $CurrentForm->hasValue("fecha_reg") ? $CurrentForm->getValue("fecha_reg") : $CurrentForm->getValue("x_fecha_reg");
		if (!$this->fecha_reg->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_reg->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_reg->setFormValue($val);
			$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
		}

		// Check field name 'dniusuario' first before field var 'x_dniusuario'
		$val = $CurrentForm->hasValue("dniusuario") ? $CurrentForm->getValue("dniusuario") : $CurrentForm->getValue("x_dniusuario");
		if (!$this->dniusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dniusuario->Visible = FALSE; // Disable update for API request
			else
				$this->dniusuario->setFormValue($val);
		}

		// Check field name 'telefonousuario' first before field var 'x_telefonousuario'
		$val = $CurrentForm->hasValue("telefonousuario") ? $CurrentForm->getValue("telefonousuario") : $CurrentForm->getValue("x_telefonousuario");
		if (!$this->telefonousuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->telefonousuario->Visible = FALSE; // Disable update for API request
			else
				$this->telefonousuario->setFormValue($val);
		}

		// Check field name 'celularusuario' first before field var 'x_celularusuario'
		$val = $CurrentForm->hasValue("celularusuario") ? $CurrentForm->getValue("celularusuario") : $CurrentForm->getValue("x_celularusuario");
		if (!$this->celularusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->celularusuario->Visible = FALSE; // Disable update for API request
			else
				$this->celularusuario->setFormValue($val);
		}

		// Check field name 'direccionusuario' first before field var 'x_direccionusuario'
		$val = $CurrentForm->hasValue("direccionusuario") ? $CurrentForm->getValue("direccionusuario") : $CurrentForm->getValue("x_direccionusuario");
		if (!$this->direccionusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->direccionusuario->Visible = FALSE; // Disable update for API request
			else
				$this->direccionusuario->setFormValue($val);
		}

		// Check field name 'emailcorpusuario' first before field var 'x_emailcorpusuario'
		$val = $CurrentForm->hasValue("emailcorpusuario") ? $CurrentForm->getValue("emailcorpusuario") : $CurrentForm->getValue("x_emailcorpusuario");
		if (!$this->emailcorpusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emailcorpusuario->Visible = FALSE; // Disable update for API request
			else
				$this->emailcorpusuario->setFormValue($val);
		}

		// Check field name 'emailusuario' first before field var 'x_emailusuario'
		$val = $CurrentForm->hasValue("emailusuario") ? $CurrentForm->getValue("emailusuario") : $CurrentForm->getValue("x_emailusuario");
		if (!$this->emailusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emailusuario->Visible = FALSE; // Disable update for API request
			else
				$this->emailusuario->setFormValue($val);
		}

		// Check field name 'iddisciplina' first before field var 'x_iddisciplina'
		$val = $CurrentForm->hasValue("iddisciplina") ? $CurrentForm->getValue("iddisciplina") : $CurrentForm->getValue("x_iddisciplina");
		if (!$this->iddisciplina->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->iddisciplina->Visible = FALSE; // Disable update for API request
			else
				$this->iddisciplina->setFormValue($val);
		}

		// Check field name 'idperfil' first before field var 'x_idperfil'
		$val = $CurrentForm->hasValue("idperfil") ? $CurrentForm->getValue("idperfil") : $CurrentForm->getValue("x_idperfil");
		if (!$this->idperfil->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idperfil->Visible = FALSE; // Disable update for API request
			else
				$this->idperfil->setFormValue($val);
		}

		// Check field name 'mostrarcalendario' first before field var 'x_mostrarcalendario'
		$val = $CurrentForm->hasValue("mostrarcalendario") ? $CurrentForm->getValue("mostrarcalendario") : $CurrentForm->getValue("x_mostrarcalendario");
		if (!$this->mostrarcalendario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mostrarcalendario->Visible = FALSE; // Disable update for API request
			else
				$this->mostrarcalendario->setFormValue($val);
		}

		// Check field name 'obsusuario' first before field var 'x_obsusuario'
		$val = $CurrentForm->hasValue("obsusuario") ? $CurrentForm->getValue("obsusuario") : $CurrentForm->getValue("x_obsusuario");
		if (!$this->obsusuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->obsusuario->Visible = FALSE; // Disable update for API request
			else
				$this->obsusuario->setFormValue($val);
		}

		// Check field name 'verificaringreso' first before field var 'x_verificaringreso'
		$val = $CurrentForm->hasValue("verificaringreso") ? $CurrentForm->getValue("verificaringreso") : $CurrentForm->getValue("x_verificaringreso");
		if (!$this->verificaringreso->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->verificaringreso->Visible = FALSE; // Disable update for API request
			else
				$this->verificaringreso->setFormValue($val);
		}

		// Check field name 'estadousuario' first before field var 'x_estadousuario'
		$val = $CurrentForm->hasValue("estadousuario") ? $CurrentForm->getValue("estadousuario") : $CurrentForm->getValue("x_estadousuario");
		if (!$this->estadousuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estadousuario->Visible = FALSE; // Disable update for API request
			else
				$this->estadousuario->setFormValue($val);
		}

		// Check field name 'idcategoria' first before field var 'x_idcategoria'
		$val = $CurrentForm->hasValue("idcategoria") ? $CurrentForm->getValue("idcategoria") : $CurrentForm->getValue("x_idcategoria");
		if (!$this->idcategoria->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idcategoria->Visible = FALSE; // Disable update for API request
			else
				$this->idcategoria->setFormValue($val);
		}

		// Check field name 'tipo_usuario' first before field var 'x_tipo_usuario'
		$val = $CurrentForm->hasValue("tipo_usuario") ? $CurrentForm->getValue("tipo_usuario") : $CurrentForm->getValue("x_tipo_usuario");
		if (!$this->tipo_usuario->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tipo_usuario->Visible = FALSE; // Disable update for API request
			else
				$this->tipo_usuario->setFormValue($val);
		}

		// Check field name 'idempresa' first before field var 'x_idempresa'
		$val = $CurrentForm->hasValue("idempresa") ? $CurrentForm->getValue("idempresa") : $CurrentForm->getValue("x_idempresa");
		if (!$this->idempresa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->idempresa->Visible = FALSE; // Disable update for API request
			else
				$this->idempresa->setFormValue($val);
		}

		// Check field name 'idusuario' first before field var 'x_idusuario'
		$val = $CurrentForm->hasValue("idusuario") ? $CurrentForm->getValue("idusuario") : $CurrentForm->getValue("x_idusuario");
		if (!$this->idusuario->IsDetailKey)
			$this->idusuario->setFormValue($val);

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->codlogin->CurrentValue = $this->codlogin->FormValue;
		$this->codpassword->CurrentValue = $this->codpassword->FormValue;
		$this->nomusuario->CurrentValue = $this->nomusuario->FormValue;
		$this->apeusuario->CurrentValue = $this->apeusuario->FormValue;
		$this->tipo->CurrentValue = $this->tipo->FormValue;
		$this->fecha_reg->CurrentValue = $this->fecha_reg->FormValue;
		$this->fecha_reg->CurrentValue = UnFormatDateTime($this->fecha_reg->CurrentValue, 0);
		$this->dniusuario->CurrentValue = $this->dniusuario->FormValue;
		$this->telefonousuario->CurrentValue = $this->telefonousuario->FormValue;
		$this->celularusuario->CurrentValue = $this->celularusuario->FormValue;
		$this->direccionusuario->CurrentValue = $this->direccionusuario->FormValue;
		$this->emailcorpusuario->CurrentValue = $this->emailcorpusuario->FormValue;
		$this->emailusuario->CurrentValue = $this->emailusuario->FormValue;
		$this->iddisciplina->CurrentValue = $this->iddisciplina->FormValue;
		$this->idperfil->CurrentValue = $this->idperfil->FormValue;
		$this->mostrarcalendario->CurrentValue = $this->mostrarcalendario->FormValue;
		$this->obsusuario->CurrentValue = $this->obsusuario->FormValue;
		$this->verificaringreso->CurrentValue = $this->verificaringreso->FormValue;
		$this->estadousuario->CurrentValue = $this->estadousuario->FormValue;
		$this->idcategoria->CurrentValue = $this->idcategoria->FormValue;
		$this->tipo_usuario->CurrentValue = $this->tipo_usuario->FormValue;
		$this->idempresa->CurrentValue = $this->idempresa->FormValue;
		$this->idusuario->CurrentValue = $this->idusuario->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->codlogin->setDbValue($row['codlogin']);
		$this->codpassword->setDbValue($row['codpassword']);
		$this->nomusuario->setDbValue($row['nomusuario']);
		$this->apeusuario->setDbValue($row['apeusuario']);
		$this->tipo->setDbValue($row['tipo']);
		$this->fecha_reg->setDbValue($row['fecha_reg']);
		$this->dniusuario->setDbValue($row['dniusuario']);
		$this->telefonousuario->setDbValue($row['telefonousuario']);
		$this->celularusuario->setDbValue($row['celularusuario']);
		$this->direccionusuario->setDbValue($row['direccionusuario']);
		$this->emailcorpusuario->setDbValue($row['emailcorpusuario']);
		$this->emailusuario->setDbValue($row['emailusuario']);
		$this->iddisciplina->setDbValue($row['iddisciplina']);
		$this->idperfil->setDbValue($row['idperfil']);
		$this->mostrarcalendario->setDbValue($row['mostrarcalendario']);
		$this->obsusuario->setDbValue($row['obsusuario']);
		$this->verificaringreso->setDbValue($row['verificaringreso']);
		$this->estadousuario->setDbValue($row['estadousuario']);
		$this->idcategoria->setDbValue($row['idcategoria']);
		$this->tipo_usuario->setDbValue($row['tipo_usuario']);
		$this->idempresa->setDbValue($row['idempresa']);
		$this->idusuario->setDbValue($row['idusuario']);
		$this->estado->setDbValue($row['estado']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['codlogin'] = NULL;
		$row['codpassword'] = NULL;
		$row['nomusuario'] = NULL;
		$row['apeusuario'] = NULL;
		$row['tipo'] = NULL;
		$row['fecha_reg'] = NULL;
		$row['dniusuario'] = NULL;
		$row['telefonousuario'] = NULL;
		$row['celularusuario'] = NULL;
		$row['direccionusuario'] = NULL;
		$row['emailcorpusuario'] = NULL;
		$row['emailusuario'] = NULL;
		$row['iddisciplina'] = NULL;
		$row['idperfil'] = NULL;
		$row['mostrarcalendario'] = NULL;
		$row['obsusuario'] = NULL;
		$row['verificaringreso'] = NULL;
		$row['estadousuario'] = NULL;
		$row['idcategoria'] = NULL;
		$row['tipo_usuario'] = NULL;
		$row['idempresa'] = NULL;
		$row['idusuario'] = NULL;
		$row['estado'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idusuario")) != "")
			$this->idusuario->OldValue = $this->getKey("idusuario"); // idusuario
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// codlogin
		// codpassword
		// nomusuario
		// apeusuario
		// tipo
		// fecha_reg
		// dniusuario
		// telefonousuario
		// celularusuario
		// direccionusuario
		// emailcorpusuario
		// emailusuario
		// iddisciplina
		// idperfil
		// mostrarcalendario
		// obsusuario
		// verificaringreso
		// estadousuario
		// idcategoria
		// tipo_usuario
		// idempresa
		// idusuario
		// estado

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// codpassword
			$this->codpassword->ViewValue = $this->codpassword->CurrentValue;
			$this->codpassword->ViewCustomAttributes = "";

			// nomusuario
			$this->nomusuario->ViewValue = $this->nomusuario->CurrentValue;
			$this->nomusuario->ViewCustomAttributes = "";

			// apeusuario
			$this->apeusuario->ViewValue = $this->apeusuario->CurrentValue;
			$this->apeusuario->ViewCustomAttributes = "";

			// tipo
			$this->tipo->ViewValue = $this->tipo->CurrentValue;
			$this->tipo->ViewCustomAttributes = "";

			// fecha_reg
			$this->fecha_reg->ViewValue = $this->fecha_reg->CurrentValue;
			$this->fecha_reg->ViewValue = FormatDateTime($this->fecha_reg->ViewValue, 0);
			$this->fecha_reg->ViewCustomAttributes = "";

			// dniusuario
			$this->dniusuario->ViewValue = $this->dniusuario->CurrentValue;
			$this->dniusuario->ViewCustomAttributes = "";

			// telefonousuario
			$this->telefonousuario->ViewValue = $this->telefonousuario->CurrentValue;
			$this->telefonousuario->ViewCustomAttributes = "";

			// celularusuario
			$this->celularusuario->ViewValue = $this->celularusuario->CurrentValue;
			$this->celularusuario->ViewCustomAttributes = "";

			// direccionusuario
			$this->direccionusuario->ViewValue = $this->direccionusuario->CurrentValue;
			$this->direccionusuario->ViewCustomAttributes = "";

			// emailcorpusuario
			$this->emailcorpusuario->ViewValue = $this->emailcorpusuario->CurrentValue;
			$this->emailcorpusuario->ViewCustomAttributes = "";

			// emailusuario
			$this->emailusuario->ViewValue = $this->emailusuario->CurrentValue;
			$this->emailusuario->ViewCustomAttributes = "";

			// iddisciplina
			$this->iddisciplina->ViewValue = $this->iddisciplina->CurrentValue;
			$this->iddisciplina->ViewValue = FormatNumber($this->iddisciplina->ViewValue, 0, -2, -2, -2);
			$this->iddisciplina->ViewCustomAttributes = "";

			// idperfil
			$this->idperfil->ViewValue = $this->idperfil->CurrentValue;
			$this->idperfil->ViewValue = FormatNumber($this->idperfil->ViewValue, 0, -2, -2, -2);
			$this->idperfil->ViewCustomAttributes = "";

			// mostrarcalendario
			$this->mostrarcalendario->ViewValue = $this->mostrarcalendario->CurrentValue;
			$this->mostrarcalendario->ViewValue = FormatNumber($this->mostrarcalendario->ViewValue, 0, -2, -2, -2);
			$this->mostrarcalendario->ViewCustomAttributes = "";

			// obsusuario
			$this->obsusuario->ViewValue = $this->obsusuario->CurrentValue;
			$this->obsusuario->ViewCustomAttributes = "";

			// verificaringreso
			$this->verificaringreso->ViewValue = $this->verificaringreso->CurrentValue;
			$this->verificaringreso->ViewValue = FormatNumber($this->verificaringreso->ViewValue, 0, -2, -2, -2);
			$this->verificaringreso->ViewCustomAttributes = "";

			// estadousuario
			$this->estadousuario->ViewValue = $this->estadousuario->CurrentValue;
			$this->estadousuario->ViewValue = FormatNumber($this->estadousuario->ViewValue, 0, -2, -2, -2);
			$this->estadousuario->ViewCustomAttributes = "";

			// idcategoria
			$this->idcategoria->ViewValue = $this->idcategoria->CurrentValue;
			$this->idcategoria->ViewValue = FormatNumber($this->idcategoria->ViewValue, 0, -2, -2, -2);
			$this->idcategoria->ViewCustomAttributes = "";

			// tipo_usuario
			$this->tipo_usuario->ViewValue = $this->tipo_usuario->CurrentValue;
			$this->tipo_usuario->ViewValue = FormatNumber($this->tipo_usuario->ViewValue, 0, -2, -2, -2);
			$this->tipo_usuario->ViewCustomAttributes = "";

			// idempresa
			$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
			$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
			$this->idempresa->ViewCustomAttributes = "";

			// idusuario
			$this->idusuario->ViewValue = $this->idusuario->CurrentValue;
			$this->idusuario->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// codpassword
			$this->codpassword->LinkCustomAttributes = "";
			$this->codpassword->HrefValue = "";
			$this->codpassword->TooltipValue = "";

			// nomusuario
			$this->nomusuario->LinkCustomAttributes = "";
			$this->nomusuario->HrefValue = "";
			$this->nomusuario->TooltipValue = "";

			// apeusuario
			$this->apeusuario->LinkCustomAttributes = "";
			$this->apeusuario->HrefValue = "";
			$this->apeusuario->TooltipValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";
			$this->tipo->TooltipValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";
			$this->fecha_reg->TooltipValue = "";

			// dniusuario
			$this->dniusuario->LinkCustomAttributes = "";
			$this->dniusuario->HrefValue = "";
			$this->dniusuario->TooltipValue = "";

			// telefonousuario
			$this->telefonousuario->LinkCustomAttributes = "";
			$this->telefonousuario->HrefValue = "";
			$this->telefonousuario->TooltipValue = "";

			// celularusuario
			$this->celularusuario->LinkCustomAttributes = "";
			$this->celularusuario->HrefValue = "";
			$this->celularusuario->TooltipValue = "";

			// direccionusuario
			$this->direccionusuario->LinkCustomAttributes = "";
			$this->direccionusuario->HrefValue = "";
			$this->direccionusuario->TooltipValue = "";

			// emailcorpusuario
			$this->emailcorpusuario->LinkCustomAttributes = "";
			$this->emailcorpusuario->HrefValue = "";
			$this->emailcorpusuario->TooltipValue = "";

			// emailusuario
			$this->emailusuario->LinkCustomAttributes = "";
			$this->emailusuario->HrefValue = "";
			$this->emailusuario->TooltipValue = "";

			// iddisciplina
			$this->iddisciplina->LinkCustomAttributes = "";
			$this->iddisciplina->HrefValue = "";
			$this->iddisciplina->TooltipValue = "";

			// idperfil
			$this->idperfil->LinkCustomAttributes = "";
			$this->idperfil->HrefValue = "";
			$this->idperfil->TooltipValue = "";

			// mostrarcalendario
			$this->mostrarcalendario->LinkCustomAttributes = "";
			$this->mostrarcalendario->HrefValue = "";
			$this->mostrarcalendario->TooltipValue = "";

			// obsusuario
			$this->obsusuario->LinkCustomAttributes = "";
			$this->obsusuario->HrefValue = "";
			$this->obsusuario->TooltipValue = "";

			// verificaringreso
			$this->verificaringreso->LinkCustomAttributes = "";
			$this->verificaringreso->HrefValue = "";
			$this->verificaringreso->TooltipValue = "";

			// estadousuario
			$this->estadousuario->LinkCustomAttributes = "";
			$this->estadousuario->HrefValue = "";
			$this->estadousuario->TooltipValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";
			$this->idcategoria->TooltipValue = "";

			// tipo_usuario
			$this->tipo_usuario->LinkCustomAttributes = "";
			$this->tipo_usuario->HrefValue = "";
			$this->tipo_usuario->TooltipValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";
			$this->idempresa->TooltipValue = "";

			// idusuario
			$this->idusuario->LinkCustomAttributes = "";
			$this->idusuario->HrefValue = "";
			$this->idusuario->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// codlogin
			$this->codlogin->EditAttrs["class"] = "form-control";
			$this->codlogin->EditCustomAttributes = "";
			if (!$this->codlogin->Raw)
				$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
			$this->codlogin->EditValue = HtmlEncode($this->codlogin->CurrentValue);
			$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

			// codpassword
			$this->codpassword->EditAttrs["class"] = "form-control";
			$this->codpassword->EditCustomAttributes = "";
			if (!$this->codpassword->Raw)
				$this->codpassword->CurrentValue = HtmlDecode($this->codpassword->CurrentValue);
			$this->codpassword->EditValue = HtmlEncode($this->codpassword->CurrentValue);
			$this->codpassword->PlaceHolder = RemoveHtml($this->codpassword->caption());

			// nomusuario
			$this->nomusuario->EditAttrs["class"] = "form-control";
			$this->nomusuario->EditCustomAttributes = "";
			if (!$this->nomusuario->Raw)
				$this->nomusuario->CurrentValue = HtmlDecode($this->nomusuario->CurrentValue);
			$this->nomusuario->EditValue = HtmlEncode($this->nomusuario->CurrentValue);
			$this->nomusuario->PlaceHolder = RemoveHtml($this->nomusuario->caption());

			// apeusuario
			$this->apeusuario->EditAttrs["class"] = "form-control";
			$this->apeusuario->EditCustomAttributes = "";
			if (!$this->apeusuario->Raw)
				$this->apeusuario->CurrentValue = HtmlDecode($this->apeusuario->CurrentValue);
			$this->apeusuario->EditValue = HtmlEncode($this->apeusuario->CurrentValue);
			$this->apeusuario->PlaceHolder = RemoveHtml($this->apeusuario->caption());

			// tipo
			$this->tipo->EditAttrs["class"] = "form-control";
			$this->tipo->EditCustomAttributes = "";
			if (!$this->tipo->Raw)
				$this->tipo->CurrentValue = HtmlDecode($this->tipo->CurrentValue);
			$this->tipo->EditValue = HtmlEncode($this->tipo->CurrentValue);
			$this->tipo->PlaceHolder = RemoveHtml($this->tipo->caption());

			// fecha_reg
			$this->fecha_reg->EditAttrs["class"] = "form-control";
			$this->fecha_reg->EditCustomAttributes = "";
			$this->fecha_reg->EditValue = HtmlEncode(FormatDateTime($this->fecha_reg->CurrentValue, 8));
			$this->fecha_reg->PlaceHolder = RemoveHtml($this->fecha_reg->caption());

			// dniusuario
			$this->dniusuario->EditAttrs["class"] = "form-control";
			$this->dniusuario->EditCustomAttributes = "";
			if (!$this->dniusuario->Raw)
				$this->dniusuario->CurrentValue = HtmlDecode($this->dniusuario->CurrentValue);
			$this->dniusuario->EditValue = HtmlEncode($this->dniusuario->CurrentValue);
			$this->dniusuario->PlaceHolder = RemoveHtml($this->dniusuario->caption());

			// telefonousuario
			$this->telefonousuario->EditAttrs["class"] = "form-control";
			$this->telefonousuario->EditCustomAttributes = "";
			if (!$this->telefonousuario->Raw)
				$this->telefonousuario->CurrentValue = HtmlDecode($this->telefonousuario->CurrentValue);
			$this->telefonousuario->EditValue = HtmlEncode($this->telefonousuario->CurrentValue);
			$this->telefonousuario->PlaceHolder = RemoveHtml($this->telefonousuario->caption());

			// celularusuario
			$this->celularusuario->EditAttrs["class"] = "form-control";
			$this->celularusuario->EditCustomAttributes = "";
			if (!$this->celularusuario->Raw)
				$this->celularusuario->CurrentValue = HtmlDecode($this->celularusuario->CurrentValue);
			$this->celularusuario->EditValue = HtmlEncode($this->celularusuario->CurrentValue);
			$this->celularusuario->PlaceHolder = RemoveHtml($this->celularusuario->caption());

			// direccionusuario
			$this->direccionusuario->EditAttrs["class"] = "form-control";
			$this->direccionusuario->EditCustomAttributes = "";
			if (!$this->direccionusuario->Raw)
				$this->direccionusuario->CurrentValue = HtmlDecode($this->direccionusuario->CurrentValue);
			$this->direccionusuario->EditValue = HtmlEncode($this->direccionusuario->CurrentValue);
			$this->direccionusuario->PlaceHolder = RemoveHtml($this->direccionusuario->caption());

			// emailcorpusuario
			$this->emailcorpusuario->EditAttrs["class"] = "form-control";
			$this->emailcorpusuario->EditCustomAttributes = "";
			if (!$this->emailcorpusuario->Raw)
				$this->emailcorpusuario->CurrentValue = HtmlDecode($this->emailcorpusuario->CurrentValue);
			$this->emailcorpusuario->EditValue = HtmlEncode($this->emailcorpusuario->CurrentValue);
			$this->emailcorpusuario->PlaceHolder = RemoveHtml($this->emailcorpusuario->caption());

			// emailusuario
			$this->emailusuario->EditAttrs["class"] = "form-control";
			$this->emailusuario->EditCustomAttributes = "";
			if (!$this->emailusuario->Raw)
				$this->emailusuario->CurrentValue = HtmlDecode($this->emailusuario->CurrentValue);
			$this->emailusuario->EditValue = HtmlEncode($this->emailusuario->CurrentValue);
			$this->emailusuario->PlaceHolder = RemoveHtml($this->emailusuario->caption());

			// iddisciplina
			$this->iddisciplina->EditAttrs["class"] = "form-control";
			$this->iddisciplina->EditCustomAttributes = "";
			$this->iddisciplina->EditValue = HtmlEncode($this->iddisciplina->CurrentValue);
			$this->iddisciplina->PlaceHolder = RemoveHtml($this->iddisciplina->caption());

			// idperfil
			$this->idperfil->EditAttrs["class"] = "form-control";
			$this->idperfil->EditCustomAttributes = "";
			$this->idperfil->EditValue = HtmlEncode($this->idperfil->CurrentValue);
			$this->idperfil->PlaceHolder = RemoveHtml($this->idperfil->caption());

			// mostrarcalendario
			$this->mostrarcalendario->EditAttrs["class"] = "form-control";
			$this->mostrarcalendario->EditCustomAttributes = "";
			$this->mostrarcalendario->EditValue = HtmlEncode($this->mostrarcalendario->CurrentValue);
			$this->mostrarcalendario->PlaceHolder = RemoveHtml($this->mostrarcalendario->caption());

			// obsusuario
			$this->obsusuario->EditAttrs["class"] = "form-control";
			$this->obsusuario->EditCustomAttributes = "";
			$this->obsusuario->EditValue = HtmlEncode($this->obsusuario->CurrentValue);
			$this->obsusuario->PlaceHolder = RemoveHtml($this->obsusuario->caption());

			// verificaringreso
			$this->verificaringreso->EditAttrs["class"] = "form-control";
			$this->verificaringreso->EditCustomAttributes = "";
			$this->verificaringreso->EditValue = HtmlEncode($this->verificaringreso->CurrentValue);
			$this->verificaringreso->PlaceHolder = RemoveHtml($this->verificaringreso->caption());

			// estadousuario
			$this->estadousuario->EditAttrs["class"] = "form-control";
			$this->estadousuario->EditCustomAttributes = "";
			$this->estadousuario->EditValue = HtmlEncode($this->estadousuario->CurrentValue);
			$this->estadousuario->PlaceHolder = RemoveHtml($this->estadousuario->caption());

			// idcategoria
			$this->idcategoria->EditAttrs["class"] = "form-control";
			$this->idcategoria->EditCustomAttributes = "";
			$this->idcategoria->EditValue = HtmlEncode($this->idcategoria->CurrentValue);
			$this->idcategoria->PlaceHolder = RemoveHtml($this->idcategoria->caption());

			// tipo_usuario
			$this->tipo_usuario->EditAttrs["class"] = "form-control";
			$this->tipo_usuario->EditCustomAttributes = "";
			$this->tipo_usuario->EditValue = HtmlEncode($this->tipo_usuario->CurrentValue);
			$this->tipo_usuario->PlaceHolder = RemoveHtml($this->tipo_usuario->caption());

			// idempresa
			$this->idempresa->EditAttrs["class"] = "form-control";
			$this->idempresa->EditCustomAttributes = "";
			$this->idempresa->EditValue = HtmlEncode($this->idempresa->CurrentValue);
			$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

			// idusuario
			$this->idusuario->EditAttrs["class"] = "form-control";
			$this->idusuario->EditCustomAttributes = "";
			$this->idusuario->EditValue = $this->idusuario->CurrentValue;
			$this->idusuario->ViewCustomAttributes = "";

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// Edit refer script
			// codlogin

			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";

			// codpassword
			$this->codpassword->LinkCustomAttributes = "";
			$this->codpassword->HrefValue = "";

			// nomusuario
			$this->nomusuario->LinkCustomAttributes = "";
			$this->nomusuario->HrefValue = "";

			// apeusuario
			$this->apeusuario->LinkCustomAttributes = "";
			$this->apeusuario->HrefValue = "";

			// tipo
			$this->tipo->LinkCustomAttributes = "";
			$this->tipo->HrefValue = "";

			// fecha_reg
			$this->fecha_reg->LinkCustomAttributes = "";
			$this->fecha_reg->HrefValue = "";

			// dniusuario
			$this->dniusuario->LinkCustomAttributes = "";
			$this->dniusuario->HrefValue = "";

			// telefonousuario
			$this->telefonousuario->LinkCustomAttributes = "";
			$this->telefonousuario->HrefValue = "";

			// celularusuario
			$this->celularusuario->LinkCustomAttributes = "";
			$this->celularusuario->HrefValue = "";

			// direccionusuario
			$this->direccionusuario->LinkCustomAttributes = "";
			$this->direccionusuario->HrefValue = "";

			// emailcorpusuario
			$this->emailcorpusuario->LinkCustomAttributes = "";
			$this->emailcorpusuario->HrefValue = "";

			// emailusuario
			$this->emailusuario->LinkCustomAttributes = "";
			$this->emailusuario->HrefValue = "";

			// iddisciplina
			$this->iddisciplina->LinkCustomAttributes = "";
			$this->iddisciplina->HrefValue = "";

			// idperfil
			$this->idperfil->LinkCustomAttributes = "";
			$this->idperfil->HrefValue = "";

			// mostrarcalendario
			$this->mostrarcalendario->LinkCustomAttributes = "";
			$this->mostrarcalendario->HrefValue = "";

			// obsusuario
			$this->obsusuario->LinkCustomAttributes = "";
			$this->obsusuario->HrefValue = "";

			// verificaringreso
			$this->verificaringreso->LinkCustomAttributes = "";
			$this->verificaringreso->HrefValue = "";

			// estadousuario
			$this->estadousuario->LinkCustomAttributes = "";
			$this->estadousuario->HrefValue = "";

			// idcategoria
			$this->idcategoria->LinkCustomAttributes = "";
			$this->idcategoria->HrefValue = "";

			// tipo_usuario
			$this->tipo_usuario->LinkCustomAttributes = "";
			$this->tipo_usuario->HrefValue = "";

			// idempresa
			$this->idempresa->LinkCustomAttributes = "";
			$this->idempresa->HrefValue = "";

			// idusuario
			$this->idusuario->LinkCustomAttributes = "";
			$this->idusuario->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->codlogin->Required) {
			if (!$this->codlogin->IsDetailKey && $this->codlogin->FormValue != NULL && $this->codlogin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codlogin->caption(), $this->codlogin->RequiredErrorMessage));
			}
		}
		if ($this->codpassword->Required) {
			if (!$this->codpassword->IsDetailKey && $this->codpassword->FormValue != NULL && $this->codpassword->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codpassword->caption(), $this->codpassword->RequiredErrorMessage));
			}
		}
		if ($this->nomusuario->Required) {
			if (!$this->nomusuario->IsDetailKey && $this->nomusuario->FormValue != NULL && $this->nomusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomusuario->caption(), $this->nomusuario->RequiredErrorMessage));
			}
		}
		if ($this->apeusuario->Required) {
			if (!$this->apeusuario->IsDetailKey && $this->apeusuario->FormValue != NULL && $this->apeusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->apeusuario->caption(), $this->apeusuario->RequiredErrorMessage));
			}
		}
		if ($this->tipo->Required) {
			if (!$this->tipo->IsDetailKey && $this->tipo->FormValue != NULL && $this->tipo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo->caption(), $this->tipo->RequiredErrorMessage));
			}
		}
		if ($this->fecha_reg->Required) {
			if (!$this->fecha_reg->IsDetailKey && $this->fecha_reg->FormValue != NULL && $this->fecha_reg->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_reg->caption(), $this->fecha_reg->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fecha_reg->FormValue)) {
			AddMessage($FormError, $this->fecha_reg->errorMessage());
		}
		if ($this->dniusuario->Required) {
			if (!$this->dniusuario->IsDetailKey && $this->dniusuario->FormValue != NULL && $this->dniusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dniusuario->caption(), $this->dniusuario->RequiredErrorMessage));
			}
		}
		if ($this->telefonousuario->Required) {
			if (!$this->telefonousuario->IsDetailKey && $this->telefonousuario->FormValue != NULL && $this->telefonousuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->telefonousuario->caption(), $this->telefonousuario->RequiredErrorMessage));
			}
		}
		if ($this->celularusuario->Required) {
			if (!$this->celularusuario->IsDetailKey && $this->celularusuario->FormValue != NULL && $this->celularusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->celularusuario->caption(), $this->celularusuario->RequiredErrorMessage));
			}
		}
		if ($this->direccionusuario->Required) {
			if (!$this->direccionusuario->IsDetailKey && $this->direccionusuario->FormValue != NULL && $this->direccionusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->direccionusuario->caption(), $this->direccionusuario->RequiredErrorMessage));
			}
		}
		if ($this->emailcorpusuario->Required) {
			if (!$this->emailcorpusuario->IsDetailKey && $this->emailcorpusuario->FormValue != NULL && $this->emailcorpusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emailcorpusuario->caption(), $this->emailcorpusuario->RequiredErrorMessage));
			}
		}
		if ($this->emailusuario->Required) {
			if (!$this->emailusuario->IsDetailKey && $this->emailusuario->FormValue != NULL && $this->emailusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emailusuario->caption(), $this->emailusuario->RequiredErrorMessage));
			}
		}
		if ($this->iddisciplina->Required) {
			if (!$this->iddisciplina->IsDetailKey && $this->iddisciplina->FormValue != NULL && $this->iddisciplina->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iddisciplina->caption(), $this->iddisciplina->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->iddisciplina->FormValue)) {
			AddMessage($FormError, $this->iddisciplina->errorMessage());
		}
		if ($this->idperfil->Required) {
			if (!$this->idperfil->IsDetailKey && $this->idperfil->FormValue != NULL && $this->idperfil->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idperfil->caption(), $this->idperfil->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idperfil->FormValue)) {
			AddMessage($FormError, $this->idperfil->errorMessage());
		}
		if ($this->mostrarcalendario->Required) {
			if (!$this->mostrarcalendario->IsDetailKey && $this->mostrarcalendario->FormValue != NULL && $this->mostrarcalendario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mostrarcalendario->caption(), $this->mostrarcalendario->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mostrarcalendario->FormValue)) {
			AddMessage($FormError, $this->mostrarcalendario->errorMessage());
		}
		if ($this->obsusuario->Required) {
			if (!$this->obsusuario->IsDetailKey && $this->obsusuario->FormValue != NULL && $this->obsusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->obsusuario->caption(), $this->obsusuario->RequiredErrorMessage));
			}
		}
		if ($this->verificaringreso->Required) {
			if (!$this->verificaringreso->IsDetailKey && $this->verificaringreso->FormValue != NULL && $this->verificaringreso->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->verificaringreso->caption(), $this->verificaringreso->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->verificaringreso->FormValue)) {
			AddMessage($FormError, $this->verificaringreso->errorMessage());
		}
		if ($this->estadousuario->Required) {
			if (!$this->estadousuario->IsDetailKey && $this->estadousuario->FormValue != NULL && $this->estadousuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estadousuario->caption(), $this->estadousuario->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estadousuario->FormValue)) {
			AddMessage($FormError, $this->estadousuario->errorMessage());
		}
		if ($this->idcategoria->Required) {
			if (!$this->idcategoria->IsDetailKey && $this->idcategoria->FormValue != NULL && $this->idcategoria->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idcategoria->caption(), $this->idcategoria->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idcategoria->FormValue)) {
			AddMessage($FormError, $this->idcategoria->errorMessage());
		}
		if ($this->tipo_usuario->Required) {
			if (!$this->tipo_usuario->IsDetailKey && $this->tipo_usuario->FormValue != NULL && $this->tipo_usuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tipo_usuario->caption(), $this->tipo_usuario->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tipo_usuario->FormValue)) {
			AddMessage($FormError, $this->tipo_usuario->errorMessage());
		}
		if ($this->idempresa->Required) {
			if (!$this->idempresa->IsDetailKey && $this->idempresa->FormValue != NULL && $this->idempresa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idempresa->caption(), $this->idempresa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->idempresa->FormValue)) {
			AddMessage($FormError, $this->idempresa->errorMessage());
		}
		if ($this->idusuario->Required) {
			if (!$this->idusuario->IsDetailKey && $this->idusuario->FormValue != NULL && $this->idusuario->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idusuario->caption(), $this->idusuario->RequiredErrorMessage));
			}
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		if ($this->codlogin->CurrentValue != "") { // Check field with unique index
			$filterChk = "(`codlogin` = '" . AdjustSql($this->codlogin->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = "";
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->codlogin->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->codlogin->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// codlogin
			$this->codlogin->setDbValueDef($rsnew, $this->codlogin->CurrentValue, "", $this->codlogin->ReadOnly);

			// codpassword
			$this->codpassword->setDbValueDef($rsnew, $this->codpassword->CurrentValue, NULL, $this->codpassword->ReadOnly);

			// nomusuario
			$this->nomusuario->setDbValueDef($rsnew, $this->nomusuario->CurrentValue, NULL, $this->nomusuario->ReadOnly);

			// apeusuario
			$this->apeusuario->setDbValueDef($rsnew, $this->apeusuario->CurrentValue, "", $this->apeusuario->ReadOnly);

			// tipo
			$this->tipo->setDbValueDef($rsnew, $this->tipo->CurrentValue, NULL, $this->tipo->ReadOnly);

			// fecha_reg
			$this->fecha_reg->setDbValueDef($rsnew, UnFormatDateTime($this->fecha_reg->CurrentValue, 0), NULL, $this->fecha_reg->ReadOnly);

			// dniusuario
			$this->dniusuario->setDbValueDef($rsnew, $this->dniusuario->CurrentValue, NULL, $this->dniusuario->ReadOnly);

			// telefonousuario
			$this->telefonousuario->setDbValueDef($rsnew, $this->telefonousuario->CurrentValue, NULL, $this->telefonousuario->ReadOnly);

			// celularusuario
			$this->celularusuario->setDbValueDef($rsnew, $this->celularusuario->CurrentValue, NULL, $this->celularusuario->ReadOnly);

			// direccionusuario
			$this->direccionusuario->setDbValueDef($rsnew, $this->direccionusuario->CurrentValue, NULL, $this->direccionusuario->ReadOnly);

			// emailcorpusuario
			$this->emailcorpusuario->setDbValueDef($rsnew, $this->emailcorpusuario->CurrentValue, NULL, $this->emailcorpusuario->ReadOnly);

			// emailusuario
			$this->emailusuario->setDbValueDef($rsnew, $this->emailusuario->CurrentValue, NULL, $this->emailusuario->ReadOnly);

			// iddisciplina
			$this->iddisciplina->setDbValueDef($rsnew, $this->iddisciplina->CurrentValue, NULL, $this->iddisciplina->ReadOnly);

			// idperfil
			$this->idperfil->setDbValueDef($rsnew, $this->idperfil->CurrentValue, NULL, $this->idperfil->ReadOnly);

			// mostrarcalendario
			$this->mostrarcalendario->setDbValueDef($rsnew, $this->mostrarcalendario->CurrentValue, NULL, $this->mostrarcalendario->ReadOnly);

			// obsusuario
			$this->obsusuario->setDbValueDef($rsnew, $this->obsusuario->CurrentValue, NULL, $this->obsusuario->ReadOnly);

			// verificaringreso
			$this->verificaringreso->setDbValueDef($rsnew, $this->verificaringreso->CurrentValue, NULL, $this->verificaringreso->ReadOnly);

			// estadousuario
			$this->estadousuario->setDbValueDef($rsnew, $this->estadousuario->CurrentValue, NULL, $this->estadousuario->ReadOnly);

			// idcategoria
			$this->idcategoria->setDbValueDef($rsnew, $this->idcategoria->CurrentValue, NULL, $this->idcategoria->ReadOnly);

			// tipo_usuario
			$this->tipo_usuario->setDbValueDef($rsnew, $this->tipo_usuario->CurrentValue, NULL, $this->tipo_usuario->ReadOnly);

			// idempresa
			$this->idempresa->setDbValueDef($rsnew, $this->idempresa->CurrentValue, NULL, $this->idempresa->ReadOnly);

			// estado
			$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, $this->estado->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew); 
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kp_usuarioslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>