<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kt_driver_task_add extends kt_driver_task
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kt_driver_task';

	// Page object name
	public $PageObjName = "kt_driver_task_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kt_driver_task)
		if (!isset($GLOBALS["kt_driver_task"]) || get_class($GLOBALS["kt_driver_task"]) == PROJECT_NAMESPACE . "kt_driver_task") {
			$GLOBALS["kt_driver_task"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kt_driver_task"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kt_driver_task');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kt_driver_task;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kt_driver_task);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "kt_driver_taskview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['task_id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->task_id->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kt_driver_tasklist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->task_id->Visible = FALSE;
		$this->task_description->setVisibility();
		$this->trans_type->setVisibility();
		$this->contact_number->setVisibility();
		$this->email_address->setVisibility();
		$this->customer_name->setVisibility();
		$this->delivery_date->setVisibility();
		$this->delivery_address->setVisibility();
		$this->team_id->setVisibility();
		$this->driver_id->setVisibility();
		$this->task_lat->setVisibility();
		$this->task_lng->setVisibility();
		$this->customer_signature->setVisibility();
		$this->date_created->setVisibility();
		$this->date_modified->setVisibility();
		$this->ip_address->setVisibility();
		$this->auto_assign_type->setVisibility();
		$this->assign_started->setVisibility();
		$this->assignment_status->setVisibility();
		$this->dropoff_contact_name->setVisibility();
		$this->dropoff_contact_number->setVisibility();
		$this->drop_address->setVisibility();
		$this->dropoff_task_lat->setVisibility();
		$this->dropoff_task_lng->setVisibility();
		$this->task_token->setVisibility();
		$this->ratings->setVisibility();
		$this->rating_comment->setVisibility();
		$this->critical->setVisibility();
		$this->souce_e->setVisibility();
		$this->shop_code_e->setVisibility();
		$this->Received_Channel_e->setVisibility();
		$this->PayMethod_e->setVisibility();
		$this->Type_e->setVisibility();
		$this->Request_Code_e->setVisibility();
		$this->Status_e->setVisibility();
		$this->PlanType_e->setVisibility();
		$this->Plan_e->setVisibility();
		$this->Isdn_e->setVisibility();
		$this->serial_sim_handset_e->setVisibility();
		$this->handset_e->setVisibility();
		$this->Connect_Reason_e->setVisibility();
		$this->Price_e->setVisibility();
		$this->Current_Operator_e->setVisibility();
		$this->Current_Plan_Type_e->setVisibility();
		$this->Document_Number_e->setVisibility();
		$this->Document_Type_e->setVisibility();
		$this->assignStaffCode_e->setVisibility();
		$this->Delivery_Type_e->setVisibility();
		$this->assignStaffType_e->setVisibility();
		$this->receiveStaffCode_e->setVisibility();
		$this->receiveStaffType_e->setVisibility();
		$this->connectStaffCode_e->setVisibility();
		$this->connectStaffType_e->setVisibility();
		$this->shopName_e->setVisibility();
		$this->saleOrderCode_e->setVisibility();
		$this->consultantCode_e->setVisibility();
		$this->consultantName_e->setVisibility();
		$this->consultantType_e->setVisibility();
		$this->created_By_e->setVisibility();
		$this->createdBranch_e->setVisibility();
		$this->generated_Code_By_e->setVisibility();
		$this->approve_Paid_By_e->setVisibility();
		$this->Delivery_Note_e->setVisibility();
		$this->Delivery_Code_e->setVisibility();
		$this->Customer_Note_e->setVisibility();
		$this->saleOrderCreateDate_e->setVisibility();
		$this->saleOrderPayDate_e->setVisibility();
		$this->Time_of_Procesing_e->setVisibility();
		$this->Time_of_new_e->setVisibility();
		$this->Time_of_Finished_e->setVisibility();
		$this->KPI_CC_Hour_e->setVisibility();
		$this->KPI_NEW_Hour_e->setVisibility();
		$this->KPI_PROCESING_Hour_e->setVisibility();
		$this->KPI_ALL_Hour_e->setVisibility();
		$this->Kpi_Register_Hour_e->setVisibility();
		$this->Kpi_Bitel_Hour_e->setVisibility();
		$this->AmountGB_e->setVisibility();
		$this->Price_1_e->setVisibility();
		$this->Status_1_e->setVisibility();
		$this->Registered_Date_e->setVisibility();
		$this->Sumary_e->setVisibility();
		$this->Plans_e->setVisibility();
		$this->Isdns_e->setVisibility();
		$this->PlanTypes_e->setVisibility();
		$this->Serials_e->setVisibility();
		$this->Status_2_e->setVisibility();
		$this->Registered_Date_2_e->setVisibility();
		$this->Summary_2_e->setVisibility();
		$this->serial_2_e->setVisibility();
		$this->HandsetCode_e->setVisibility();
		$this->HandsetName_e->setVisibility();
		$this->Status_3_e->setVisibility();
		$this->Summary_3_e->setVisibility();
		$this->fecha_activa_e->setVisibility();
		$this->mes_activa_e->setVisibility();
		$this->SOURCE_OUT_e->setVisibility();
		$this->fecha_crea_e->setVisibility();
		$this->mes_crea_e->setVisibility();
		$this->moto_e->setVisibility();
		$this->customer_id->setVisibility();
		$this->status->setVisibility();
		$this->address_e->setVisibility();
		$this->branch_e->setVisibility();
		$this->CreatedTime_e->setVisibility();
		$this->Status_n->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("task_id") !== NULL) {
				$this->task_id->setQueryStringValue(Get("task_id"));
				$this->setKey("task_id", $this->task_id->CurrentValue); // Set up key
			} else {
				$this->setKey("task_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("kt_driver_tasklist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "kt_driver_tasklist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "kt_driver_taskview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->task_id->CurrentValue = NULL;
		$this->task_id->OldValue = $this->task_id->CurrentValue;
		$this->task_description->CurrentValue = NULL;
		$this->task_description->OldValue = $this->task_description->CurrentValue;
		$this->trans_type->CurrentValue = NULL;
		$this->trans_type->OldValue = $this->trans_type->CurrentValue;
		$this->contact_number->CurrentValue = NULL;
		$this->contact_number->OldValue = $this->contact_number->CurrentValue;
		$this->email_address->CurrentValue = NULL;
		$this->email_address->OldValue = $this->email_address->CurrentValue;
		$this->customer_name->CurrentValue = NULL;
		$this->customer_name->OldValue = $this->customer_name->CurrentValue;
		$this->delivery_date->CurrentValue = NULL;
		$this->delivery_date->OldValue = $this->delivery_date->CurrentValue;
		$this->delivery_address->CurrentValue = NULL;
		$this->delivery_address->OldValue = $this->delivery_address->CurrentValue;
		$this->team_id->CurrentValue = 0;
		$this->driver_id->CurrentValue = 0;
		$this->task_lat->CurrentValue = NULL;
		$this->task_lat->OldValue = $this->task_lat->CurrentValue;
		$this->task_lng->CurrentValue = NULL;
		$this->task_lng->OldValue = $this->task_lng->CurrentValue;
		$this->customer_signature->CurrentValue = NULL;
		$this->customer_signature->OldValue = $this->customer_signature->CurrentValue;
		$this->date_created->CurrentValue = NULL;
		$this->date_created->OldValue = $this->date_created->CurrentValue;
		$this->date_modified->CurrentValue = NULL;
		$this->date_modified->OldValue = $this->date_modified->CurrentValue;
		$this->ip_address->CurrentValue = NULL;
		$this->ip_address->OldValue = $this->ip_address->CurrentValue;
		$this->auto_assign_type->CurrentValue = NULL;
		$this->auto_assign_type->OldValue = $this->auto_assign_type->CurrentValue;
		$this->assign_started->CurrentValue = NULL;
		$this->assign_started->OldValue = $this->assign_started->CurrentValue;
		$this->assignment_status->CurrentValue = NULL;
		$this->assignment_status->OldValue = $this->assignment_status->CurrentValue;
		$this->dropoff_contact_name->CurrentValue = NULL;
		$this->dropoff_contact_name->OldValue = $this->dropoff_contact_name->CurrentValue;
		$this->dropoff_contact_number->CurrentValue = NULL;
		$this->dropoff_contact_number->OldValue = $this->dropoff_contact_number->CurrentValue;
		$this->drop_address->CurrentValue = NULL;
		$this->drop_address->OldValue = $this->drop_address->CurrentValue;
		$this->dropoff_task_lat->CurrentValue = NULL;
		$this->dropoff_task_lat->OldValue = $this->dropoff_task_lat->CurrentValue;
		$this->dropoff_task_lng->CurrentValue = NULL;
		$this->dropoff_task_lng->OldValue = $this->dropoff_task_lng->CurrentValue;
		$this->task_token->CurrentValue = NULL;
		$this->task_token->OldValue = $this->task_token->CurrentValue;
		$this->ratings->CurrentValue = NULL;
		$this->ratings->OldValue = $this->ratings->CurrentValue;
		$this->rating_comment->CurrentValue = NULL;
		$this->rating_comment->OldValue = $this->rating_comment->CurrentValue;
		$this->critical->CurrentValue = 1;
		$this->souce_e->CurrentValue = NULL;
		$this->souce_e->OldValue = $this->souce_e->CurrentValue;
		$this->shop_code_e->CurrentValue = NULL;
		$this->shop_code_e->OldValue = $this->shop_code_e->CurrentValue;
		$this->Received_Channel_e->CurrentValue = NULL;
		$this->Received_Channel_e->OldValue = $this->Received_Channel_e->CurrentValue;
		$this->PayMethod_e->CurrentValue = NULL;
		$this->PayMethod_e->OldValue = $this->PayMethod_e->CurrentValue;
		$this->Type_e->CurrentValue = NULL;
		$this->Type_e->OldValue = $this->Type_e->CurrentValue;
		$this->Request_Code_e->CurrentValue = NULL;
		$this->Request_Code_e->OldValue = $this->Request_Code_e->CurrentValue;
		$this->Status_e->CurrentValue = NULL;
		$this->Status_e->OldValue = $this->Status_e->CurrentValue;
		$this->PlanType_e->CurrentValue = NULL;
		$this->PlanType_e->OldValue = $this->PlanType_e->CurrentValue;
		$this->Plan_e->CurrentValue = NULL;
		$this->Plan_e->OldValue = $this->Plan_e->CurrentValue;
		$this->Isdn_e->CurrentValue = NULL;
		$this->Isdn_e->OldValue = $this->Isdn_e->CurrentValue;
		$this->serial_sim_handset_e->CurrentValue = NULL;
		$this->serial_sim_handset_e->OldValue = $this->serial_sim_handset_e->CurrentValue;
		$this->handset_e->CurrentValue = NULL;
		$this->handset_e->OldValue = $this->handset_e->CurrentValue;
		$this->Connect_Reason_e->CurrentValue = NULL;
		$this->Connect_Reason_e->OldValue = $this->Connect_Reason_e->CurrentValue;
		$this->Price_e->CurrentValue = 0.00;
		$this->Current_Operator_e->CurrentValue = NULL;
		$this->Current_Operator_e->OldValue = $this->Current_Operator_e->CurrentValue;
		$this->Current_Plan_Type_e->CurrentValue = NULL;
		$this->Current_Plan_Type_e->OldValue = $this->Current_Plan_Type_e->CurrentValue;
		$this->Document_Number_e->CurrentValue = NULL;
		$this->Document_Number_e->OldValue = $this->Document_Number_e->CurrentValue;
		$this->Document_Type_e->CurrentValue = NULL;
		$this->Document_Type_e->OldValue = $this->Document_Type_e->CurrentValue;
		$this->assignStaffCode_e->CurrentValue = NULL;
		$this->assignStaffCode_e->OldValue = $this->assignStaffCode_e->CurrentValue;
		$this->Delivery_Type_e->CurrentValue = NULL;
		$this->Delivery_Type_e->OldValue = $this->Delivery_Type_e->CurrentValue;
		$this->assignStaffType_e->CurrentValue = NULL;
		$this->assignStaffType_e->OldValue = $this->assignStaffType_e->CurrentValue;
		$this->receiveStaffCode_e->CurrentValue = NULL;
		$this->receiveStaffCode_e->OldValue = $this->receiveStaffCode_e->CurrentValue;
		$this->receiveStaffType_e->CurrentValue = NULL;
		$this->receiveStaffType_e->OldValue = $this->receiveStaffType_e->CurrentValue;
		$this->connectStaffCode_e->CurrentValue = NULL;
		$this->connectStaffCode_e->OldValue = $this->connectStaffCode_e->CurrentValue;
		$this->connectStaffType_e->CurrentValue = NULL;
		$this->connectStaffType_e->OldValue = $this->connectStaffType_e->CurrentValue;
		$this->shopName_e->CurrentValue = NULL;
		$this->shopName_e->OldValue = $this->shopName_e->CurrentValue;
		$this->saleOrderCode_e->CurrentValue = NULL;
		$this->saleOrderCode_e->OldValue = $this->saleOrderCode_e->CurrentValue;
		$this->consultantCode_e->CurrentValue = NULL;
		$this->consultantCode_e->OldValue = $this->consultantCode_e->CurrentValue;
		$this->consultantName_e->CurrentValue = NULL;
		$this->consultantName_e->OldValue = $this->consultantName_e->CurrentValue;
		$this->consultantType_e->CurrentValue = NULL;
		$this->consultantType_e->OldValue = $this->consultantType_e->CurrentValue;
		$this->created_By_e->CurrentValue = NULL;
		$this->created_By_e->OldValue = $this->created_By_e->CurrentValue;
		$this->createdBranch_e->CurrentValue = NULL;
		$this->createdBranch_e->OldValue = $this->createdBranch_e->CurrentValue;
		$this->generated_Code_By_e->CurrentValue = NULL;
		$this->generated_Code_By_e->OldValue = $this->generated_Code_By_e->CurrentValue;
		$this->approve_Paid_By_e->CurrentValue = NULL;
		$this->approve_Paid_By_e->OldValue = $this->approve_Paid_By_e->CurrentValue;
		$this->Delivery_Note_e->CurrentValue = NULL;
		$this->Delivery_Note_e->OldValue = $this->Delivery_Note_e->CurrentValue;
		$this->Delivery_Code_e->CurrentValue = NULL;
		$this->Delivery_Code_e->OldValue = $this->Delivery_Code_e->CurrentValue;
		$this->Customer_Note_e->CurrentValue = NULL;
		$this->Customer_Note_e->OldValue = $this->Customer_Note_e->CurrentValue;
		$this->saleOrderCreateDate_e->CurrentValue = NULL;
		$this->saleOrderCreateDate_e->OldValue = $this->saleOrderCreateDate_e->CurrentValue;
		$this->saleOrderPayDate_e->CurrentValue = NULL;
		$this->saleOrderPayDate_e->OldValue = $this->saleOrderPayDate_e->CurrentValue;
		$this->Time_of_Procesing_e->CurrentValue = NULL;
		$this->Time_of_Procesing_e->OldValue = $this->Time_of_Procesing_e->CurrentValue;
		$this->Time_of_new_e->CurrentValue = NULL;
		$this->Time_of_new_e->OldValue = $this->Time_of_new_e->CurrentValue;
		$this->Time_of_Finished_e->CurrentValue = NULL;
		$this->Time_of_Finished_e->OldValue = $this->Time_of_Finished_e->CurrentValue;
		$this->KPI_CC_Hour_e->CurrentValue = NULL;
		$this->KPI_CC_Hour_e->OldValue = $this->KPI_CC_Hour_e->CurrentValue;
		$this->KPI_NEW_Hour_e->CurrentValue = NULL;
		$this->KPI_NEW_Hour_e->OldValue = $this->KPI_NEW_Hour_e->CurrentValue;
		$this->KPI_PROCESING_Hour_e->CurrentValue = NULL;
		$this->KPI_PROCESING_Hour_e->OldValue = $this->KPI_PROCESING_Hour_e->CurrentValue;
		$this->KPI_ALL_Hour_e->CurrentValue = NULL;
		$this->KPI_ALL_Hour_e->OldValue = $this->KPI_ALL_Hour_e->CurrentValue;
		$this->Kpi_Register_Hour_e->CurrentValue = NULL;
		$this->Kpi_Register_Hour_e->OldValue = $this->Kpi_Register_Hour_e->CurrentValue;
		$this->Kpi_Bitel_Hour_e->CurrentValue = NULL;
		$this->Kpi_Bitel_Hour_e->OldValue = $this->Kpi_Bitel_Hour_e->CurrentValue;
		$this->AmountGB_e->CurrentValue = NULL;
		$this->AmountGB_e->OldValue = $this->AmountGB_e->CurrentValue;
		$this->Price_1_e->CurrentValue = NULL;
		$this->Price_1_e->OldValue = $this->Price_1_e->CurrentValue;
		$this->Status_1_e->CurrentValue = NULL;
		$this->Status_1_e->OldValue = $this->Status_1_e->CurrentValue;
		$this->Registered_Date_e->CurrentValue = NULL;
		$this->Registered_Date_e->OldValue = $this->Registered_Date_e->CurrentValue;
		$this->Sumary_e->CurrentValue = NULL;
		$this->Sumary_e->OldValue = $this->Sumary_e->CurrentValue;
		$this->Plans_e->CurrentValue = NULL;
		$this->Plans_e->OldValue = $this->Plans_e->CurrentValue;
		$this->Isdns_e->CurrentValue = NULL;
		$this->Isdns_e->OldValue = $this->Isdns_e->CurrentValue;
		$this->PlanTypes_e->CurrentValue = NULL;
		$this->PlanTypes_e->OldValue = $this->PlanTypes_e->CurrentValue;
		$this->Serials_e->CurrentValue = NULL;
		$this->Serials_e->OldValue = $this->Serials_e->CurrentValue;
		$this->Status_2_e->CurrentValue = NULL;
		$this->Status_2_e->OldValue = $this->Status_2_e->CurrentValue;
		$this->Registered_Date_2_e->CurrentValue = NULL;
		$this->Registered_Date_2_e->OldValue = $this->Registered_Date_2_e->CurrentValue;
		$this->Summary_2_e->CurrentValue = NULL;
		$this->Summary_2_e->OldValue = $this->Summary_2_e->CurrentValue;
		$this->serial_2_e->CurrentValue = NULL;
		$this->serial_2_e->OldValue = $this->serial_2_e->CurrentValue;
		$this->HandsetCode_e->CurrentValue = NULL;
		$this->HandsetCode_e->OldValue = $this->HandsetCode_e->CurrentValue;
		$this->HandsetName_e->CurrentValue = NULL;
		$this->HandsetName_e->OldValue = $this->HandsetName_e->CurrentValue;
		$this->Status_3_e->CurrentValue = NULL;
		$this->Status_3_e->OldValue = $this->Status_3_e->CurrentValue;
		$this->Summary_3_e->CurrentValue = NULL;
		$this->Summary_3_e->OldValue = $this->Summary_3_e->CurrentValue;
		$this->fecha_activa_e->CurrentValue = NULL;
		$this->fecha_activa_e->OldValue = $this->fecha_activa_e->CurrentValue;
		$this->mes_activa_e->CurrentValue = NULL;
		$this->mes_activa_e->OldValue = $this->mes_activa_e->CurrentValue;
		$this->SOURCE_OUT_e->CurrentValue = NULL;
		$this->SOURCE_OUT_e->OldValue = $this->SOURCE_OUT_e->CurrentValue;
		$this->fecha_crea_e->CurrentValue = NULL;
		$this->fecha_crea_e->OldValue = $this->fecha_crea_e->CurrentValue;
		$this->mes_crea_e->CurrentValue = NULL;
		$this->mes_crea_e->OldValue = $this->mes_crea_e->CurrentValue;
		$this->moto_e->CurrentValue = NULL;
		$this->moto_e->OldValue = $this->moto_e->CurrentValue;
		$this->customer_id->CurrentValue = 1;
		$this->status->CurrentValue = "unassigned";
		$this->address_e->CurrentValue = NULL;
		$this->address_e->OldValue = $this->address_e->CurrentValue;
		$this->branch_e->CurrentValue = NULL;
		$this->branch_e->OldValue = $this->branch_e->CurrentValue;
		$this->CreatedTime_e->CurrentValue = NULL;
		$this->CreatedTime_e->OldValue = $this->CreatedTime_e->CurrentValue;
		$this->Status_n->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'task_description' first before field var 'x_task_description'
		$val = $CurrentForm->hasValue("task_description") ? $CurrentForm->getValue("task_description") : $CurrentForm->getValue("x_task_description");
		if (!$this->task_description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->task_description->Visible = FALSE; // Disable update for API request
			else
				$this->task_description->setFormValue($val);
		}

		// Check field name 'trans_type' first before field var 'x_trans_type'
		$val = $CurrentForm->hasValue("trans_type") ? $CurrentForm->getValue("trans_type") : $CurrentForm->getValue("x_trans_type");
		if (!$this->trans_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->trans_type->Visible = FALSE; // Disable update for API request
			else
				$this->trans_type->setFormValue($val);
		}

		// Check field name 'contact_number' first before field var 'x_contact_number'
		$val = $CurrentForm->hasValue("contact_number") ? $CurrentForm->getValue("contact_number") : $CurrentForm->getValue("x_contact_number");
		if (!$this->contact_number->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->contact_number->Visible = FALSE; // Disable update for API request
			else
				$this->contact_number->setFormValue($val);
		}

		// Check field name 'email_address' first before field var 'x_email_address'
		$val = $CurrentForm->hasValue("email_address") ? $CurrentForm->getValue("email_address") : $CurrentForm->getValue("x_email_address");
		if (!$this->email_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->email_address->Visible = FALSE; // Disable update for API request
			else
				$this->email_address->setFormValue($val);
		}

		// Check field name 'customer_name' first before field var 'x_customer_name'
		$val = $CurrentForm->hasValue("customer_name") ? $CurrentForm->getValue("customer_name") : $CurrentForm->getValue("x_customer_name");
		if (!$this->customer_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->customer_name->Visible = FALSE; // Disable update for API request
			else
				$this->customer_name->setFormValue($val);
		}

		// Check field name 'delivery_date' first before field var 'x_delivery_date'
		$val = $CurrentForm->hasValue("delivery_date") ? $CurrentForm->getValue("delivery_date") : $CurrentForm->getValue("x_delivery_date");
		if (!$this->delivery_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_date->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_date->setFormValue($val);
			$this->delivery_date->CurrentValue = UnFormatDateTime($this->delivery_date->CurrentValue, 0);
		}

		// Check field name 'delivery_address' first before field var 'x_delivery_address'
		$val = $CurrentForm->hasValue("delivery_address") ? $CurrentForm->getValue("delivery_address") : $CurrentForm->getValue("x_delivery_address");
		if (!$this->delivery_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_address->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_address->setFormValue($val);
		}

		// Check field name 'team_id' first before field var 'x_team_id'
		$val = $CurrentForm->hasValue("team_id") ? $CurrentForm->getValue("team_id") : $CurrentForm->getValue("x_team_id");
		if (!$this->team_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->team_id->Visible = FALSE; // Disable update for API request
			else
				$this->team_id->setFormValue($val);
		}

		// Check field name 'driver_id' first before field var 'x_driver_id'
		$val = $CurrentForm->hasValue("driver_id") ? $CurrentForm->getValue("driver_id") : $CurrentForm->getValue("x_driver_id");
		if (!$this->driver_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver_id->Visible = FALSE; // Disable update for API request
			else
				$this->driver_id->setFormValue($val);
		}

		// Check field name 'task_lat' first before field var 'x_task_lat'
		$val = $CurrentForm->hasValue("task_lat") ? $CurrentForm->getValue("task_lat") : $CurrentForm->getValue("x_task_lat");
		if (!$this->task_lat->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->task_lat->Visible = FALSE; // Disable update for API request
			else
				$this->task_lat->setFormValue($val);
		}

		// Check field name 'task_lng' first before field var 'x_task_lng'
		$val = $CurrentForm->hasValue("task_lng") ? $CurrentForm->getValue("task_lng") : $CurrentForm->getValue("x_task_lng");
		if (!$this->task_lng->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->task_lng->Visible = FALSE; // Disable update for API request
			else
				$this->task_lng->setFormValue($val);
		}

		// Check field name 'customer_signature' first before field var 'x_customer_signature'
		$val = $CurrentForm->hasValue("customer_signature") ? $CurrentForm->getValue("customer_signature") : $CurrentForm->getValue("x_customer_signature");
		if (!$this->customer_signature->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->customer_signature->Visible = FALSE; // Disable update for API request
			else
				$this->customer_signature->setFormValue($val);
		}

		// Check field name 'date_created' first before field var 'x_date_created'
		$val = $CurrentForm->hasValue("date_created") ? $CurrentForm->getValue("date_created") : $CurrentForm->getValue("x_date_created");
		if (!$this->date_created->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date_created->Visible = FALSE; // Disable update for API request
			else
				$this->date_created->setFormValue($val);
			$this->date_created->CurrentValue = UnFormatDateTime($this->date_created->CurrentValue, 0);
		}

		// Check field name 'date_modified' first before field var 'x_date_modified'
		$val = $CurrentForm->hasValue("date_modified") ? $CurrentForm->getValue("date_modified") : $CurrentForm->getValue("x_date_modified");
		if (!$this->date_modified->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date_modified->Visible = FALSE; // Disable update for API request
			else
				$this->date_modified->setFormValue($val);
			$this->date_modified->CurrentValue = UnFormatDateTime($this->date_modified->CurrentValue, 0);
		}

		// Check field name 'ip_address' first before field var 'x_ip_address'
		$val = $CurrentForm->hasValue("ip_address") ? $CurrentForm->getValue("ip_address") : $CurrentForm->getValue("x_ip_address");
		if (!$this->ip_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ip_address->Visible = FALSE; // Disable update for API request
			else
				$this->ip_address->setFormValue($val);
		}

		// Check field name 'auto_assign_type' first before field var 'x_auto_assign_type'
		$val = $CurrentForm->hasValue("auto_assign_type") ? $CurrentForm->getValue("auto_assign_type") : $CurrentForm->getValue("x_auto_assign_type");
		if (!$this->auto_assign_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->auto_assign_type->Visible = FALSE; // Disable update for API request
			else
				$this->auto_assign_type->setFormValue($val);
		}

		// Check field name 'assign_started' first before field var 'x_assign_started'
		$val = $CurrentForm->hasValue("assign_started") ? $CurrentForm->getValue("assign_started") : $CurrentForm->getValue("x_assign_started");
		if (!$this->assign_started->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->assign_started->Visible = FALSE; // Disable update for API request
			else
				$this->assign_started->setFormValue($val);
			$this->assign_started->CurrentValue = UnFormatDateTime($this->assign_started->CurrentValue, 0);
		}

		// Check field name 'assignment_status' first before field var 'x_assignment_status'
		$val = $CurrentForm->hasValue("assignment_status") ? $CurrentForm->getValue("assignment_status") : $CurrentForm->getValue("x_assignment_status");
		if (!$this->assignment_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->assignment_status->Visible = FALSE; // Disable update for API request
			else
				$this->assignment_status->setFormValue($val);
		}

		// Check field name 'dropoff_contact_name' first before field var 'x_dropoff_contact_name'
		$val = $CurrentForm->hasValue("dropoff_contact_name") ? $CurrentForm->getValue("dropoff_contact_name") : $CurrentForm->getValue("x_dropoff_contact_name");
		if (!$this->dropoff_contact_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dropoff_contact_name->Visible = FALSE; // Disable update for API request
			else
				$this->dropoff_contact_name->setFormValue($val);
		}

		// Check field name 'dropoff_contact_number' first before field var 'x_dropoff_contact_number'
		$val = $CurrentForm->hasValue("dropoff_contact_number") ? $CurrentForm->getValue("dropoff_contact_number") : $CurrentForm->getValue("x_dropoff_contact_number");
		if (!$this->dropoff_contact_number->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dropoff_contact_number->Visible = FALSE; // Disable update for API request
			else
				$this->dropoff_contact_number->setFormValue($val);
		}

		// Check field name 'drop_address' first before field var 'x_drop_address'
		$val = $CurrentForm->hasValue("drop_address") ? $CurrentForm->getValue("drop_address") : $CurrentForm->getValue("x_drop_address");
		if (!$this->drop_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->drop_address->Visible = FALSE; // Disable update for API request
			else
				$this->drop_address->setFormValue($val);
		}

		// Check field name 'dropoff_task_lat' first before field var 'x_dropoff_task_lat'
		$val = $CurrentForm->hasValue("dropoff_task_lat") ? $CurrentForm->getValue("dropoff_task_lat") : $CurrentForm->getValue("x_dropoff_task_lat");
		if (!$this->dropoff_task_lat->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dropoff_task_lat->Visible = FALSE; // Disable update for API request
			else
				$this->dropoff_task_lat->setFormValue($val);
		}

		// Check field name 'dropoff_task_lng' first before field var 'x_dropoff_task_lng'
		$val = $CurrentForm->hasValue("dropoff_task_lng") ? $CurrentForm->getValue("dropoff_task_lng") : $CurrentForm->getValue("x_dropoff_task_lng");
		if (!$this->dropoff_task_lng->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dropoff_task_lng->Visible = FALSE; // Disable update for API request
			else
				$this->dropoff_task_lng->setFormValue($val);
		}

		// Check field name 'task_token' first before field var 'x_task_token'
		$val = $CurrentForm->hasValue("task_token") ? $CurrentForm->getValue("task_token") : $CurrentForm->getValue("x_task_token");
		if (!$this->task_token->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->task_token->Visible = FALSE; // Disable update for API request
			else
				$this->task_token->setFormValue($val);
		}

		// Check field name 'ratings' first before field var 'x_ratings'
		$val = $CurrentForm->hasValue("ratings") ? $CurrentForm->getValue("ratings") : $CurrentForm->getValue("x_ratings");
		if (!$this->ratings->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ratings->Visible = FALSE; // Disable update for API request
			else
				$this->ratings->setFormValue($val);
		}

		// Check field name 'rating_comment' first before field var 'x_rating_comment'
		$val = $CurrentForm->hasValue("rating_comment") ? $CurrentForm->getValue("rating_comment") : $CurrentForm->getValue("x_rating_comment");
		if (!$this->rating_comment->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rating_comment->Visible = FALSE; // Disable update for API request
			else
				$this->rating_comment->setFormValue($val);
		}

		// Check field name 'critical' first before field var 'x_critical'
		$val = $CurrentForm->hasValue("critical") ? $CurrentForm->getValue("critical") : $CurrentForm->getValue("x_critical");
		if (!$this->critical->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->critical->Visible = FALSE; // Disable update for API request
			else
				$this->critical->setFormValue($val);
		}

		// Check field name 'souce_e' first before field var 'x_souce_e'
		$val = $CurrentForm->hasValue("souce_e") ? $CurrentForm->getValue("souce_e") : $CurrentForm->getValue("x_souce_e");
		if (!$this->souce_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->souce_e->Visible = FALSE; // Disable update for API request
			else
				$this->souce_e->setFormValue($val);
		}

		// Check field name 'shop_code_e' first before field var 'x_shop_code_e'
		$val = $CurrentForm->hasValue("shop_code_e") ? $CurrentForm->getValue("shop_code_e") : $CurrentForm->getValue("x_shop_code_e");
		if (!$this->shop_code_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shop_code_e->Visible = FALSE; // Disable update for API request
			else
				$this->shop_code_e->setFormValue($val);
		}

		// Check field name 'Received_Channel_e' first before field var 'x_Received_Channel_e'
		$val = $CurrentForm->hasValue("Received_Channel_e") ? $CurrentForm->getValue("Received_Channel_e") : $CurrentForm->getValue("x_Received_Channel_e");
		if (!$this->Received_Channel_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Received_Channel_e->Visible = FALSE; // Disable update for API request
			else
				$this->Received_Channel_e->setFormValue($val);
		}

		// Check field name 'PayMethod_e' first before field var 'x_PayMethod_e'
		$val = $CurrentForm->hasValue("PayMethod_e") ? $CurrentForm->getValue("PayMethod_e") : $CurrentForm->getValue("x_PayMethod_e");
		if (!$this->PayMethod_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PayMethod_e->Visible = FALSE; // Disable update for API request
			else
				$this->PayMethod_e->setFormValue($val);
		}

		// Check field name 'Type_e' first before field var 'x_Type_e'
		$val = $CurrentForm->hasValue("Type_e") ? $CurrentForm->getValue("Type_e") : $CurrentForm->getValue("x_Type_e");
		if (!$this->Type_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Type_e->Visible = FALSE; // Disable update for API request
			else
				$this->Type_e->setFormValue($val);
		}

		// Check field name 'Request_Code_e' first before field var 'x_Request_Code_e'
		$val = $CurrentForm->hasValue("Request_Code_e") ? $CurrentForm->getValue("Request_Code_e") : $CurrentForm->getValue("x_Request_Code_e");
		if (!$this->Request_Code_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Request_Code_e->Visible = FALSE; // Disable update for API request
			else
				$this->Request_Code_e->setFormValue($val);
		}

		// Check field name 'Status_e' first before field var 'x_Status_e'
		$val = $CurrentForm->hasValue("Status_e") ? $CurrentForm->getValue("Status_e") : $CurrentForm->getValue("x_Status_e");
		if (!$this->Status_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Status_e->Visible = FALSE; // Disable update for API request
			else
				$this->Status_e->setFormValue($val);
		}

		// Check field name 'PlanType_e' first before field var 'x_PlanType_e'
		$val = $CurrentForm->hasValue("PlanType_e") ? $CurrentForm->getValue("PlanType_e") : $CurrentForm->getValue("x_PlanType_e");
		if (!$this->PlanType_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PlanType_e->Visible = FALSE; // Disable update for API request
			else
				$this->PlanType_e->setFormValue($val);
		}

		// Check field name 'Plan_e' first before field var 'x_Plan_e'
		$val = $CurrentForm->hasValue("Plan_e") ? $CurrentForm->getValue("Plan_e") : $CurrentForm->getValue("x_Plan_e");
		if (!$this->Plan_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Plan_e->Visible = FALSE; // Disable update for API request
			else
				$this->Plan_e->setFormValue($val);
		}

		// Check field name 'Isdn_e' first before field var 'x_Isdn_e'
		$val = $CurrentForm->hasValue("Isdn_e") ? $CurrentForm->getValue("Isdn_e") : $CurrentForm->getValue("x_Isdn_e");
		if (!$this->Isdn_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Isdn_e->Visible = FALSE; // Disable update for API request
			else
				$this->Isdn_e->setFormValue($val);
		}

		// Check field name 'serial_sim_handset_e' first before field var 'x_serial_sim_handset_e'
		$val = $CurrentForm->hasValue("serial_sim_handset_e") ? $CurrentForm->getValue("serial_sim_handset_e") : $CurrentForm->getValue("x_serial_sim_handset_e");
		if (!$this->serial_sim_handset_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->serial_sim_handset_e->Visible = FALSE; // Disable update for API request
			else
				$this->serial_sim_handset_e->setFormValue($val);
		}

		// Check field name 'handset_e' first before field var 'x_handset_e'
		$val = $CurrentForm->hasValue("handset_e") ? $CurrentForm->getValue("handset_e") : $CurrentForm->getValue("x_handset_e");
		if (!$this->handset_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->handset_e->Visible = FALSE; // Disable update for API request
			else
				$this->handset_e->setFormValue($val);
		}

		// Check field name 'Connect_Reason_e' first before field var 'x_Connect_Reason_e'
		$val = $CurrentForm->hasValue("Connect_Reason_e") ? $CurrentForm->getValue("Connect_Reason_e") : $CurrentForm->getValue("x_Connect_Reason_e");
		if (!$this->Connect_Reason_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Connect_Reason_e->Visible = FALSE; // Disable update for API request
			else
				$this->Connect_Reason_e->setFormValue($val);
		}

		// Check field name 'Price_e' first before field var 'x_Price_e'
		$val = $CurrentForm->hasValue("Price_e") ? $CurrentForm->getValue("Price_e") : $CurrentForm->getValue("x_Price_e");
		if (!$this->Price_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Price_e->Visible = FALSE; // Disable update for API request
			else
				$this->Price_e->setFormValue($val);
		}

		// Check field name 'Current_Operator_e' first before field var 'x_Current_Operator_e'
		$val = $CurrentForm->hasValue("Current_Operator_e") ? $CurrentForm->getValue("Current_Operator_e") : $CurrentForm->getValue("x_Current_Operator_e");
		if (!$this->Current_Operator_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Current_Operator_e->Visible = FALSE; // Disable update for API request
			else
				$this->Current_Operator_e->setFormValue($val);
		}

		// Check field name 'Current_Plan_Type_e' first before field var 'x_Current_Plan_Type_e'
		$val = $CurrentForm->hasValue("Current_Plan_Type_e") ? $CurrentForm->getValue("Current_Plan_Type_e") : $CurrentForm->getValue("x_Current_Plan_Type_e");
		if (!$this->Current_Plan_Type_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Current_Plan_Type_e->Visible = FALSE; // Disable update for API request
			else
				$this->Current_Plan_Type_e->setFormValue($val);
		}

		// Check field name 'Document_Number_e' first before field var 'x_Document_Number_e'
		$val = $CurrentForm->hasValue("Document_Number_e") ? $CurrentForm->getValue("Document_Number_e") : $CurrentForm->getValue("x_Document_Number_e");
		if (!$this->Document_Number_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Document_Number_e->Visible = FALSE; // Disable update for API request
			else
				$this->Document_Number_e->setFormValue($val);
		}

		// Check field name 'Document_Type_e' first before field var 'x_Document_Type_e'
		$val = $CurrentForm->hasValue("Document_Type_e") ? $CurrentForm->getValue("Document_Type_e") : $CurrentForm->getValue("x_Document_Type_e");
		if (!$this->Document_Type_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Document_Type_e->Visible = FALSE; // Disable update for API request
			else
				$this->Document_Type_e->setFormValue($val);
		}

		// Check field name 'assignStaffCode_e' first before field var 'x_assignStaffCode_e'
		$val = $CurrentForm->hasValue("assignStaffCode_e") ? $CurrentForm->getValue("assignStaffCode_e") : $CurrentForm->getValue("x_assignStaffCode_e");
		if (!$this->assignStaffCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->assignStaffCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->assignStaffCode_e->setFormValue($val);
		}

		// Check field name 'Delivery_Type_e' first before field var 'x_Delivery_Type_e'
		$val = $CurrentForm->hasValue("Delivery_Type_e") ? $CurrentForm->getValue("Delivery_Type_e") : $CurrentForm->getValue("x_Delivery_Type_e");
		if (!$this->Delivery_Type_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Delivery_Type_e->Visible = FALSE; // Disable update for API request
			else
				$this->Delivery_Type_e->setFormValue($val);
		}

		// Check field name 'assignStaffType_e' first before field var 'x_assignStaffType_e'
		$val = $CurrentForm->hasValue("assignStaffType_e") ? $CurrentForm->getValue("assignStaffType_e") : $CurrentForm->getValue("x_assignStaffType_e");
		if (!$this->assignStaffType_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->assignStaffType_e->Visible = FALSE; // Disable update for API request
			else
				$this->assignStaffType_e->setFormValue($val);
		}

		// Check field name 'receiveStaffCode_e' first before field var 'x_receiveStaffCode_e'
		$val = $CurrentForm->hasValue("receiveStaffCode_e") ? $CurrentForm->getValue("receiveStaffCode_e") : $CurrentForm->getValue("x_receiveStaffCode_e");
		if (!$this->receiveStaffCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->receiveStaffCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->receiveStaffCode_e->setFormValue($val);
		}

		// Check field name 'receiveStaffType_e' first before field var 'x_receiveStaffType_e'
		$val = $CurrentForm->hasValue("receiveStaffType_e") ? $CurrentForm->getValue("receiveStaffType_e") : $CurrentForm->getValue("x_receiveStaffType_e");
		if (!$this->receiveStaffType_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->receiveStaffType_e->Visible = FALSE; // Disable update for API request
			else
				$this->receiveStaffType_e->setFormValue($val);
		}

		// Check field name 'connectStaffCode_e' first before field var 'x_connectStaffCode_e'
		$val = $CurrentForm->hasValue("connectStaffCode_e") ? $CurrentForm->getValue("connectStaffCode_e") : $CurrentForm->getValue("x_connectStaffCode_e");
		if (!$this->connectStaffCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->connectStaffCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->connectStaffCode_e->setFormValue($val);
		}

		// Check field name 'connectStaffType_e' first before field var 'x_connectStaffType_e'
		$val = $CurrentForm->hasValue("connectStaffType_e") ? $CurrentForm->getValue("connectStaffType_e") : $CurrentForm->getValue("x_connectStaffType_e");
		if (!$this->connectStaffType_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->connectStaffType_e->Visible = FALSE; // Disable update for API request
			else
				$this->connectStaffType_e->setFormValue($val);
		}

		// Check field name 'shopName_e' first before field var 'x_shopName_e'
		$val = $CurrentForm->hasValue("shopName_e") ? $CurrentForm->getValue("shopName_e") : $CurrentForm->getValue("x_shopName_e");
		if (!$this->shopName_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shopName_e->Visible = FALSE; // Disable update for API request
			else
				$this->shopName_e->setFormValue($val);
		}

		// Check field name 'saleOrderCode_e' first before field var 'x_saleOrderCode_e'
		$val = $CurrentForm->hasValue("saleOrderCode_e") ? $CurrentForm->getValue("saleOrderCode_e") : $CurrentForm->getValue("x_saleOrderCode_e");
		if (!$this->saleOrderCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->saleOrderCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->saleOrderCode_e->setFormValue($val);
		}

		// Check field name 'consultantCode_e' first before field var 'x_consultantCode_e'
		$val = $CurrentForm->hasValue("consultantCode_e") ? $CurrentForm->getValue("consultantCode_e") : $CurrentForm->getValue("x_consultantCode_e");
		if (!$this->consultantCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consultantCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->consultantCode_e->setFormValue($val);
		}

		// Check field name 'consultantName_e' first before field var 'x_consultantName_e'
		$val = $CurrentForm->hasValue("consultantName_e") ? $CurrentForm->getValue("consultantName_e") : $CurrentForm->getValue("x_consultantName_e");
		if (!$this->consultantName_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consultantName_e->Visible = FALSE; // Disable update for API request
			else
				$this->consultantName_e->setFormValue($val);
		}

		// Check field name 'consultantType_e' first before field var 'x_consultantType_e'
		$val = $CurrentForm->hasValue("consultantType_e") ? $CurrentForm->getValue("consultantType_e") : $CurrentForm->getValue("x_consultantType_e");
		if (!$this->consultantType_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consultantType_e->Visible = FALSE; // Disable update for API request
			else
				$this->consultantType_e->setFormValue($val);
		}

		// Check field name 'created_By_e' first before field var 'x_created_By_e'
		$val = $CurrentForm->hasValue("created_By_e") ? $CurrentForm->getValue("created_By_e") : $CurrentForm->getValue("x_created_By_e");
		if (!$this->created_By_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->created_By_e->Visible = FALSE; // Disable update for API request
			else
				$this->created_By_e->setFormValue($val);
		}

		// Check field name 'createdBranch_e' first before field var 'x_createdBranch_e'
		$val = $CurrentForm->hasValue("createdBranch_e") ? $CurrentForm->getValue("createdBranch_e") : $CurrentForm->getValue("x_createdBranch_e");
		if (!$this->createdBranch_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->createdBranch_e->Visible = FALSE; // Disable update for API request
			else
				$this->createdBranch_e->setFormValue($val);
		}

		// Check field name 'generated_Code_By_e' first before field var 'x_generated_Code_By_e'
		$val = $CurrentForm->hasValue("generated_Code_By_e") ? $CurrentForm->getValue("generated_Code_By_e") : $CurrentForm->getValue("x_generated_Code_By_e");
		if (!$this->generated_Code_By_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->generated_Code_By_e->Visible = FALSE; // Disable update for API request
			else
				$this->generated_Code_By_e->setFormValue($val);
		}

		// Check field name 'approve_Paid_By_e' first before field var 'x_approve_Paid_By_e'
		$val = $CurrentForm->hasValue("approve_Paid_By_e") ? $CurrentForm->getValue("approve_Paid_By_e") : $CurrentForm->getValue("x_approve_Paid_By_e");
		if (!$this->approve_Paid_By_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->approve_Paid_By_e->Visible = FALSE; // Disable update for API request
			else
				$this->approve_Paid_By_e->setFormValue($val);
		}

		// Check field name 'Delivery_Note_e' first before field var 'x_Delivery_Note_e'
		$val = $CurrentForm->hasValue("Delivery_Note_e") ? $CurrentForm->getValue("Delivery_Note_e") : $CurrentForm->getValue("x_Delivery_Note_e");
		if (!$this->Delivery_Note_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Delivery_Note_e->Visible = FALSE; // Disable update for API request
			else
				$this->Delivery_Note_e->setFormValue($val);
		}

		// Check field name 'Delivery_Code_e' first before field var 'x_Delivery_Code_e'
		$val = $CurrentForm->hasValue("Delivery_Code_e") ? $CurrentForm->getValue("Delivery_Code_e") : $CurrentForm->getValue("x_Delivery_Code_e");
		if (!$this->Delivery_Code_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Delivery_Code_e->Visible = FALSE; // Disable update for API request
			else
				$this->Delivery_Code_e->setFormValue($val);
		}

		// Check field name 'Customer_Note_e' first before field var 'x_Customer_Note_e'
		$val = $CurrentForm->hasValue("Customer_Note_e") ? $CurrentForm->getValue("Customer_Note_e") : $CurrentForm->getValue("x_Customer_Note_e");
		if (!$this->Customer_Note_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Customer_Note_e->Visible = FALSE; // Disable update for API request
			else
				$this->Customer_Note_e->setFormValue($val);
		}

		// Check field name 'saleOrderCreateDate_e' first before field var 'x_saleOrderCreateDate_e'
		$val = $CurrentForm->hasValue("saleOrderCreateDate_e") ? $CurrentForm->getValue("saleOrderCreateDate_e") : $CurrentForm->getValue("x_saleOrderCreateDate_e");
		if (!$this->saleOrderCreateDate_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->saleOrderCreateDate_e->Visible = FALSE; // Disable update for API request
			else
				$this->saleOrderCreateDate_e->setFormValue($val);
		}

		// Check field name 'saleOrderPayDate_e' first before field var 'x_saleOrderPayDate_e'
		$val = $CurrentForm->hasValue("saleOrderPayDate_e") ? $CurrentForm->getValue("saleOrderPayDate_e") : $CurrentForm->getValue("x_saleOrderPayDate_e");
		if (!$this->saleOrderPayDate_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->saleOrderPayDate_e->Visible = FALSE; // Disable update for API request
			else
				$this->saleOrderPayDate_e->setFormValue($val);
		}

		// Check field name 'Time_of_Procesing_e' first before field var 'x_Time_of_Procesing_e'
		$val = $CurrentForm->hasValue("Time_of_Procesing_e") ? $CurrentForm->getValue("Time_of_Procesing_e") : $CurrentForm->getValue("x_Time_of_Procesing_e");
		if (!$this->Time_of_Procesing_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Time_of_Procesing_e->Visible = FALSE; // Disable update for API request
			else
				$this->Time_of_Procesing_e->setFormValue($val);
		}

		// Check field name 'Time_of_new_e' first before field var 'x_Time_of_new_e'
		$val = $CurrentForm->hasValue("Time_of_new_e") ? $CurrentForm->getValue("Time_of_new_e") : $CurrentForm->getValue("x_Time_of_new_e");
		if (!$this->Time_of_new_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Time_of_new_e->Visible = FALSE; // Disable update for API request
			else
				$this->Time_of_new_e->setFormValue($val);
		}

		// Check field name 'Time_of_Finished_e' first before field var 'x_Time_of_Finished_e'
		$val = $CurrentForm->hasValue("Time_of_Finished_e") ? $CurrentForm->getValue("Time_of_Finished_e") : $CurrentForm->getValue("x_Time_of_Finished_e");
		if (!$this->Time_of_Finished_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Time_of_Finished_e->Visible = FALSE; // Disable update for API request
			else
				$this->Time_of_Finished_e->setFormValue($val);
		}

		// Check field name 'KPI_CC_Hour_e' first before field var 'x_KPI_CC_Hour_e'
		$val = $CurrentForm->hasValue("KPI_CC_Hour_e") ? $CurrentForm->getValue("KPI_CC_Hour_e") : $CurrentForm->getValue("x_KPI_CC_Hour_e");
		if (!$this->KPI_CC_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->KPI_CC_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->KPI_CC_Hour_e->setFormValue($val);
		}

		// Check field name 'KPI_NEW_Hour_e' first before field var 'x_KPI_NEW_Hour_e'
		$val = $CurrentForm->hasValue("KPI_NEW_Hour_e") ? $CurrentForm->getValue("KPI_NEW_Hour_e") : $CurrentForm->getValue("x_KPI_NEW_Hour_e");
		if (!$this->KPI_NEW_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->KPI_NEW_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->KPI_NEW_Hour_e->setFormValue($val);
		}

		// Check field name 'KPI_PROCESING_Hour_e' first before field var 'x_KPI_PROCESING_Hour_e'
		$val = $CurrentForm->hasValue("KPI_PROCESING_Hour_e") ? $CurrentForm->getValue("KPI_PROCESING_Hour_e") : $CurrentForm->getValue("x_KPI_PROCESING_Hour_e");
		if (!$this->KPI_PROCESING_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->KPI_PROCESING_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->KPI_PROCESING_Hour_e->setFormValue($val);
		}

		// Check field name 'KPI_ALL_Hour_e' first before field var 'x_KPI_ALL_Hour_e'
		$val = $CurrentForm->hasValue("KPI_ALL_Hour_e") ? $CurrentForm->getValue("KPI_ALL_Hour_e") : $CurrentForm->getValue("x_KPI_ALL_Hour_e");
		if (!$this->KPI_ALL_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->KPI_ALL_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->KPI_ALL_Hour_e->setFormValue($val);
		}

		// Check field name 'Kpi_Register_Hour_e' first before field var 'x_Kpi_Register_Hour_e'
		$val = $CurrentForm->hasValue("Kpi_Register_Hour_e") ? $CurrentForm->getValue("Kpi_Register_Hour_e") : $CurrentForm->getValue("x_Kpi_Register_Hour_e");
		if (!$this->Kpi_Register_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Kpi_Register_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->Kpi_Register_Hour_e->setFormValue($val);
		}

		// Check field name 'Kpi_Bitel_Hour_e' first before field var 'x_Kpi_Bitel_Hour_e'
		$val = $CurrentForm->hasValue("Kpi_Bitel_Hour_e") ? $CurrentForm->getValue("Kpi_Bitel_Hour_e") : $CurrentForm->getValue("x_Kpi_Bitel_Hour_e");
		if (!$this->Kpi_Bitel_Hour_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Kpi_Bitel_Hour_e->Visible = FALSE; // Disable update for API request
			else
				$this->Kpi_Bitel_Hour_e->setFormValue($val);
		}

		// Check field name 'AmountGB_e' first before field var 'x_AmountGB_e'
		$val = $CurrentForm->hasValue("AmountGB_e") ? $CurrentForm->getValue("AmountGB_e") : $CurrentForm->getValue("x_AmountGB_e");
		if (!$this->AmountGB_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->AmountGB_e->Visible = FALSE; // Disable update for API request
			else
				$this->AmountGB_e->setFormValue($val);
		}

		// Check field name 'Price_1_e' first before field var 'x_Price_1_e'
		$val = $CurrentForm->hasValue("Price_1_e") ? $CurrentForm->getValue("Price_1_e") : $CurrentForm->getValue("x_Price_1_e");
		if (!$this->Price_1_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Price_1_e->Visible = FALSE; // Disable update for API request
			else
				$this->Price_1_e->setFormValue($val);
		}

		// Check field name 'Status_1_e' first before field var 'x_Status_1_e'
		$val = $CurrentForm->hasValue("Status_1_e") ? $CurrentForm->getValue("Status_1_e") : $CurrentForm->getValue("x_Status_1_e");
		if (!$this->Status_1_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Status_1_e->Visible = FALSE; // Disable update for API request
			else
				$this->Status_1_e->setFormValue($val);
		}

		// Check field name 'Registered_Date_e' first before field var 'x_Registered_Date_e'
		$val = $CurrentForm->hasValue("Registered_Date_e") ? $CurrentForm->getValue("Registered_Date_e") : $CurrentForm->getValue("x_Registered_Date_e");
		if (!$this->Registered_Date_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Registered_Date_e->Visible = FALSE; // Disable update for API request
			else
				$this->Registered_Date_e->setFormValue($val);
		}

		// Check field name 'Sumary_e' first before field var 'x_Sumary_e'
		$val = $CurrentForm->hasValue("Sumary_e") ? $CurrentForm->getValue("Sumary_e") : $CurrentForm->getValue("x_Sumary_e");
		if (!$this->Sumary_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Sumary_e->Visible = FALSE; // Disable update for API request
			else
				$this->Sumary_e->setFormValue($val);
		}

		// Check field name 'Plans_e' first before field var 'x_Plans_e'
		$val = $CurrentForm->hasValue("Plans_e") ? $CurrentForm->getValue("Plans_e") : $CurrentForm->getValue("x_Plans_e");
		if (!$this->Plans_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Plans_e->Visible = FALSE; // Disable update for API request
			else
				$this->Plans_e->setFormValue($val);
		}

		// Check field name 'Isdns_e' first before field var 'x_Isdns_e'
		$val = $CurrentForm->hasValue("Isdns_e") ? $CurrentForm->getValue("Isdns_e") : $CurrentForm->getValue("x_Isdns_e");
		if (!$this->Isdns_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Isdns_e->Visible = FALSE; // Disable update for API request
			else
				$this->Isdns_e->setFormValue($val);
		}

		// Check field name 'PlanTypes_e' first before field var 'x_PlanTypes_e'
		$val = $CurrentForm->hasValue("PlanTypes_e") ? $CurrentForm->getValue("PlanTypes_e") : $CurrentForm->getValue("x_PlanTypes_e");
		if (!$this->PlanTypes_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PlanTypes_e->Visible = FALSE; // Disable update for API request
			else
				$this->PlanTypes_e->setFormValue($val);
		}

		// Check field name 'Serials_e' first before field var 'x_Serials_e'
		$val = $CurrentForm->hasValue("Serials_e") ? $CurrentForm->getValue("Serials_e") : $CurrentForm->getValue("x_Serials_e");
		if (!$this->Serials_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Serials_e->Visible = FALSE; // Disable update for API request
			else
				$this->Serials_e->setFormValue($val);
		}

		// Check field name 'Status_2_e' first before field var 'x_Status_2_e'
		$val = $CurrentForm->hasValue("Status_2_e") ? $CurrentForm->getValue("Status_2_e") : $CurrentForm->getValue("x_Status_2_e");
		if (!$this->Status_2_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Status_2_e->Visible = FALSE; // Disable update for API request
			else
				$this->Status_2_e->setFormValue($val);
		}

		// Check field name 'Registered_Date_2_e' first before field var 'x_Registered_Date_2_e'
		$val = $CurrentForm->hasValue("Registered_Date_2_e") ? $CurrentForm->getValue("Registered_Date_2_e") : $CurrentForm->getValue("x_Registered_Date_2_e");
		if (!$this->Registered_Date_2_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Registered_Date_2_e->Visible = FALSE; // Disable update for API request
			else
				$this->Registered_Date_2_e->setFormValue($val);
		}

		// Check field name 'Summary_2_e' first before field var 'x_Summary_2_e'
		$val = $CurrentForm->hasValue("Summary_2_e") ? $CurrentForm->getValue("Summary_2_e") : $CurrentForm->getValue("x_Summary_2_e");
		if (!$this->Summary_2_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Summary_2_e->Visible = FALSE; // Disable update for API request
			else
				$this->Summary_2_e->setFormValue($val);
		}

		// Check field name 'serial_2_e' first before field var 'x_serial_2_e'
		$val = $CurrentForm->hasValue("serial_2_e") ? $CurrentForm->getValue("serial_2_e") : $CurrentForm->getValue("x_serial_2_e");
		if (!$this->serial_2_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->serial_2_e->Visible = FALSE; // Disable update for API request
			else
				$this->serial_2_e->setFormValue($val);
		}

		// Check field name 'HandsetCode_e' first before field var 'x_HandsetCode_e'
		$val = $CurrentForm->hasValue("HandsetCode_e") ? $CurrentForm->getValue("HandsetCode_e") : $CurrentForm->getValue("x_HandsetCode_e");
		if (!$this->HandsetCode_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->HandsetCode_e->Visible = FALSE; // Disable update for API request
			else
				$this->HandsetCode_e->setFormValue($val);
		}

		// Check field name 'HandsetName_e' first before field var 'x_HandsetName_e'
		$val = $CurrentForm->hasValue("HandsetName_e") ? $CurrentForm->getValue("HandsetName_e") : $CurrentForm->getValue("x_HandsetName_e");
		if (!$this->HandsetName_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->HandsetName_e->Visible = FALSE; // Disable update for API request
			else
				$this->HandsetName_e->setFormValue($val);
		}

		// Check field name 'Status_3_e' first before field var 'x_Status_3_e'
		$val = $CurrentForm->hasValue("Status_3_e") ? $CurrentForm->getValue("Status_3_e") : $CurrentForm->getValue("x_Status_3_e");
		if (!$this->Status_3_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Status_3_e->Visible = FALSE; // Disable update for API request
			else
				$this->Status_3_e->setFormValue($val);
		}

		// Check field name 'Summary_3_e' first before field var 'x_Summary_3_e'
		$val = $CurrentForm->hasValue("Summary_3_e") ? $CurrentForm->getValue("Summary_3_e") : $CurrentForm->getValue("x_Summary_3_e");
		if (!$this->Summary_3_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Summary_3_e->Visible = FALSE; // Disable update for API request
			else
				$this->Summary_3_e->setFormValue($val);
		}

		// Check field name 'fecha_activa_e' first before field var 'x_fecha_activa_e'
		$val = $CurrentForm->hasValue("fecha_activa_e") ? $CurrentForm->getValue("fecha_activa_e") : $CurrentForm->getValue("x_fecha_activa_e");
		if (!$this->fecha_activa_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_activa_e->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_activa_e->setFormValue($val);
		}

		// Check field name 'mes_activa_e' first before field var 'x_mes_activa_e'
		$val = $CurrentForm->hasValue("mes_activa_e") ? $CurrentForm->getValue("mes_activa_e") : $CurrentForm->getValue("x_mes_activa_e");
		if (!$this->mes_activa_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mes_activa_e->Visible = FALSE; // Disable update for API request
			else
				$this->mes_activa_e->setFormValue($val);
		}

		// Check field name 'SOURCE_OUT_e' first before field var 'x_SOURCE_OUT_e'
		$val = $CurrentForm->hasValue("SOURCE_OUT_e") ? $CurrentForm->getValue("SOURCE_OUT_e") : $CurrentForm->getValue("x_SOURCE_OUT_e");
		if (!$this->SOURCE_OUT_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SOURCE_OUT_e->Visible = FALSE; // Disable update for API request
			else
				$this->SOURCE_OUT_e->setFormValue($val);
		}

		// Check field name 'fecha_crea_e' first before field var 'x_fecha_crea_e'
		$val = $CurrentForm->hasValue("fecha_crea_e") ? $CurrentForm->getValue("fecha_crea_e") : $CurrentForm->getValue("x_fecha_crea_e");
		if (!$this->fecha_crea_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fecha_crea_e->Visible = FALSE; // Disable update for API request
			else
				$this->fecha_crea_e->setFormValue($val);
		}

		// Check field name 'mes_crea_e' first before field var 'x_mes_crea_e'
		$val = $CurrentForm->hasValue("mes_crea_e") ? $CurrentForm->getValue("mes_crea_e") : $CurrentForm->getValue("x_mes_crea_e");
		if (!$this->mes_crea_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mes_crea_e->Visible = FALSE; // Disable update for API request
			else
				$this->mes_crea_e->setFormValue($val);
		}

		// Check field name 'moto_e' first before field var 'x_moto_e'
		$val = $CurrentForm->hasValue("moto_e") ? $CurrentForm->getValue("moto_e") : $CurrentForm->getValue("x_moto_e");
		if (!$this->moto_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->moto_e->Visible = FALSE; // Disable update for API request
			else
				$this->moto_e->setFormValue($val);
		}

		// Check field name 'customer_id' first before field var 'x_customer_id'
		$val = $CurrentForm->hasValue("customer_id") ? $CurrentForm->getValue("customer_id") : $CurrentForm->getValue("x_customer_id");
		if (!$this->customer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->customer_id->Visible = FALSE; // Disable update for API request
			else
				$this->customer_id->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'address_e' first before field var 'x_address_e'
		$val = $CurrentForm->hasValue("address_e") ? $CurrentForm->getValue("address_e") : $CurrentForm->getValue("x_address_e");
		if (!$this->address_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address_e->Visible = FALSE; // Disable update for API request
			else
				$this->address_e->setFormValue($val);
		}

		// Check field name 'branch_e' first before field var 'x_branch_e'
		$val = $CurrentForm->hasValue("branch_e") ? $CurrentForm->getValue("branch_e") : $CurrentForm->getValue("x_branch_e");
		if (!$this->branch_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->branch_e->Visible = FALSE; // Disable update for API request
			else
				$this->branch_e->setFormValue($val);
		}

		// Check field name 'CreatedTime_e' first before field var 'x_CreatedTime_e'
		$val = $CurrentForm->hasValue("CreatedTime_e") ? $CurrentForm->getValue("CreatedTime_e") : $CurrentForm->getValue("x_CreatedTime_e");
		if (!$this->CreatedTime_e->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CreatedTime_e->Visible = FALSE; // Disable update for API request
			else
				$this->CreatedTime_e->setFormValue($val);
			$this->CreatedTime_e->CurrentValue = UnFormatDateTime($this->CreatedTime_e->CurrentValue, 0);
		}

		// Check field name 'Status_n' first before field var 'x_Status_n'
		$val = $CurrentForm->hasValue("Status_n") ? $CurrentForm->getValue("Status_n") : $CurrentForm->getValue("x_Status_n");
		if (!$this->Status_n->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Status_n->Visible = FALSE; // Disable update for API request
			else
				$this->Status_n->setFormValue($val);
		}

		// Check field name 'task_id' first before field var 'x_task_id'
		$val = $CurrentForm->hasValue("task_id") ? $CurrentForm->getValue("task_id") : $CurrentForm->getValue("x_task_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->task_description->CurrentValue = $this->task_description->FormValue;
		$this->trans_type->CurrentValue = $this->trans_type->FormValue;
		$this->contact_number->CurrentValue = $this->contact_number->FormValue;
		$this->email_address->CurrentValue = $this->email_address->FormValue;
		$this->customer_name->CurrentValue = $this->customer_name->FormValue;
		$this->delivery_date->CurrentValue = $this->delivery_date->FormValue;
		$this->delivery_date->CurrentValue = UnFormatDateTime($this->delivery_date->CurrentValue, 0);
		$this->delivery_address->CurrentValue = $this->delivery_address->FormValue;
		$this->team_id->CurrentValue = $this->team_id->FormValue;
		$this->driver_id->CurrentValue = $this->driver_id->FormValue;
		$this->task_lat->CurrentValue = $this->task_lat->FormValue;
		$this->task_lng->CurrentValue = $this->task_lng->FormValue;
		$this->customer_signature->CurrentValue = $this->customer_signature->FormValue;
		$this->date_created->CurrentValue = $this->date_created->FormValue;
		$this->date_created->CurrentValue = UnFormatDateTime($this->date_created->CurrentValue, 0);
		$this->date_modified->CurrentValue = $this->date_modified->FormValue;
		$this->date_modified->CurrentValue = UnFormatDateTime($this->date_modified->CurrentValue, 0);
		$this->ip_address->CurrentValue = $this->ip_address->FormValue;
		$this->auto_assign_type->CurrentValue = $this->auto_assign_type->FormValue;
		$this->assign_started->CurrentValue = $this->assign_started->FormValue;
		$this->assign_started->CurrentValue = UnFormatDateTime($this->assign_started->CurrentValue, 0);
		$this->assignment_status->CurrentValue = $this->assignment_status->FormValue;
		$this->dropoff_contact_name->CurrentValue = $this->dropoff_contact_name->FormValue;
		$this->dropoff_contact_number->CurrentValue = $this->dropoff_contact_number->FormValue;
		$this->drop_address->CurrentValue = $this->drop_address->FormValue;
		$this->dropoff_task_lat->CurrentValue = $this->dropoff_task_lat->FormValue;
		$this->dropoff_task_lng->CurrentValue = $this->dropoff_task_lng->FormValue;
		$this->task_token->CurrentValue = $this->task_token->FormValue;
		$this->ratings->CurrentValue = $this->ratings->FormValue;
		$this->rating_comment->CurrentValue = $this->rating_comment->FormValue;
		$this->critical->CurrentValue = $this->critical->FormValue;
		$this->souce_e->CurrentValue = $this->souce_e->FormValue;
		$this->shop_code_e->CurrentValue = $this->shop_code_e->FormValue;
		$this->Received_Channel_e->CurrentValue = $this->Received_Channel_e->FormValue;
		$this->PayMethod_e->CurrentValue = $this->PayMethod_e->FormValue;
		$this->Type_e->CurrentValue = $this->Type_e->FormValue;
		$this->Request_Code_e->CurrentValue = $this->Request_Code_e->FormValue;
		$this->Status_e->CurrentValue = $this->Status_e->FormValue;
		$this->PlanType_e->CurrentValue = $this->PlanType_e->FormValue;
		$this->Plan_e->CurrentValue = $this->Plan_e->FormValue;
		$this->Isdn_e->CurrentValue = $this->Isdn_e->FormValue;
		$this->serial_sim_handset_e->CurrentValue = $this->serial_sim_handset_e->FormValue;
		$this->handset_e->CurrentValue = $this->handset_e->FormValue;
		$this->Connect_Reason_e->CurrentValue = $this->Connect_Reason_e->FormValue;
		$this->Price_e->CurrentValue = $this->Price_e->FormValue;
		$this->Current_Operator_e->CurrentValue = $this->Current_Operator_e->FormValue;
		$this->Current_Plan_Type_e->CurrentValue = $this->Current_Plan_Type_e->FormValue;
		$this->Document_Number_e->CurrentValue = $this->Document_Number_e->FormValue;
		$this->Document_Type_e->CurrentValue = $this->Document_Type_e->FormValue;
		$this->assignStaffCode_e->CurrentValue = $this->assignStaffCode_e->FormValue;
		$this->Delivery_Type_e->CurrentValue = $this->Delivery_Type_e->FormValue;
		$this->assignStaffType_e->CurrentValue = $this->assignStaffType_e->FormValue;
		$this->receiveStaffCode_e->CurrentValue = $this->receiveStaffCode_e->FormValue;
		$this->receiveStaffType_e->CurrentValue = $this->receiveStaffType_e->FormValue;
		$this->connectStaffCode_e->CurrentValue = $this->connectStaffCode_e->FormValue;
		$this->connectStaffType_e->CurrentValue = $this->connectStaffType_e->FormValue;
		$this->shopName_e->CurrentValue = $this->shopName_e->FormValue;
		$this->saleOrderCode_e->CurrentValue = $this->saleOrderCode_e->FormValue;
		$this->consultantCode_e->CurrentValue = $this->consultantCode_e->FormValue;
		$this->consultantName_e->CurrentValue = $this->consultantName_e->FormValue;
		$this->consultantType_e->CurrentValue = $this->consultantType_e->FormValue;
		$this->created_By_e->CurrentValue = $this->created_By_e->FormValue;
		$this->createdBranch_e->CurrentValue = $this->createdBranch_e->FormValue;
		$this->generated_Code_By_e->CurrentValue = $this->generated_Code_By_e->FormValue;
		$this->approve_Paid_By_e->CurrentValue = $this->approve_Paid_By_e->FormValue;
		$this->Delivery_Note_e->CurrentValue = $this->Delivery_Note_e->FormValue;
		$this->Delivery_Code_e->CurrentValue = $this->Delivery_Code_e->FormValue;
		$this->Customer_Note_e->CurrentValue = $this->Customer_Note_e->FormValue;
		$this->saleOrderCreateDate_e->CurrentValue = $this->saleOrderCreateDate_e->FormValue;
		$this->saleOrderPayDate_e->CurrentValue = $this->saleOrderPayDate_e->FormValue;
		$this->Time_of_Procesing_e->CurrentValue = $this->Time_of_Procesing_e->FormValue;
		$this->Time_of_new_e->CurrentValue = $this->Time_of_new_e->FormValue;
		$this->Time_of_Finished_e->CurrentValue = $this->Time_of_Finished_e->FormValue;
		$this->KPI_CC_Hour_e->CurrentValue = $this->KPI_CC_Hour_e->FormValue;
		$this->KPI_NEW_Hour_e->CurrentValue = $this->KPI_NEW_Hour_e->FormValue;
		$this->KPI_PROCESING_Hour_e->CurrentValue = $this->KPI_PROCESING_Hour_e->FormValue;
		$this->KPI_ALL_Hour_e->CurrentValue = $this->KPI_ALL_Hour_e->FormValue;
		$this->Kpi_Register_Hour_e->CurrentValue = $this->Kpi_Register_Hour_e->FormValue;
		$this->Kpi_Bitel_Hour_e->CurrentValue = $this->Kpi_Bitel_Hour_e->FormValue;
		$this->AmountGB_e->CurrentValue = $this->AmountGB_e->FormValue;
		$this->Price_1_e->CurrentValue = $this->Price_1_e->FormValue;
		$this->Status_1_e->CurrentValue = $this->Status_1_e->FormValue;
		$this->Registered_Date_e->CurrentValue = $this->Registered_Date_e->FormValue;
		$this->Sumary_e->CurrentValue = $this->Sumary_e->FormValue;
		$this->Plans_e->CurrentValue = $this->Plans_e->FormValue;
		$this->Isdns_e->CurrentValue = $this->Isdns_e->FormValue;
		$this->PlanTypes_e->CurrentValue = $this->PlanTypes_e->FormValue;
		$this->Serials_e->CurrentValue = $this->Serials_e->FormValue;
		$this->Status_2_e->CurrentValue = $this->Status_2_e->FormValue;
		$this->Registered_Date_2_e->CurrentValue = $this->Registered_Date_2_e->FormValue;
		$this->Summary_2_e->CurrentValue = $this->Summary_2_e->FormValue;
		$this->serial_2_e->CurrentValue = $this->serial_2_e->FormValue;
		$this->HandsetCode_e->CurrentValue = $this->HandsetCode_e->FormValue;
		$this->HandsetName_e->CurrentValue = $this->HandsetName_e->FormValue;
		$this->Status_3_e->CurrentValue = $this->Status_3_e->FormValue;
		$this->Summary_3_e->CurrentValue = $this->Summary_3_e->FormValue;
		$this->fecha_activa_e->CurrentValue = $this->fecha_activa_e->FormValue;
		$this->mes_activa_e->CurrentValue = $this->mes_activa_e->FormValue;
		$this->SOURCE_OUT_e->CurrentValue = $this->SOURCE_OUT_e->FormValue;
		$this->fecha_crea_e->CurrentValue = $this->fecha_crea_e->FormValue;
		$this->mes_crea_e->CurrentValue = $this->mes_crea_e->FormValue;
		$this->moto_e->CurrentValue = $this->moto_e->FormValue;
		$this->customer_id->CurrentValue = $this->customer_id->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->address_e->CurrentValue = $this->address_e->FormValue;
		$this->branch_e->CurrentValue = $this->branch_e->FormValue;
		$this->CreatedTime_e->CurrentValue = $this->CreatedTime_e->FormValue;
		$this->CreatedTime_e->CurrentValue = UnFormatDateTime($this->CreatedTime_e->CurrentValue, 0);
		$this->Status_n->CurrentValue = $this->Status_n->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->task_id->setDbValue($row['task_id']);
		$this->task_description->setDbValue($row['task_description']);
		$this->trans_type->setDbValue($row['trans_type']);
		$this->contact_number->setDbValue($row['contact_number']);
		$this->email_address->setDbValue($row['email_address']);
		$this->customer_name->setDbValue($row['customer_name']);
		$this->delivery_date->setDbValue($row['delivery_date']);
		$this->delivery_address->setDbValue($row['delivery_address']);
		$this->team_id->setDbValue($row['team_id']);
		$this->driver_id->setDbValue($row['driver_id']);
		$this->task_lat->setDbValue($row['task_lat']);
		$this->task_lng->setDbValue($row['task_lng']);
		$this->customer_signature->setDbValue($row['customer_signature']);
		$this->date_created->setDbValue($row['date_created']);
		$this->date_modified->setDbValue($row['date_modified']);
		$this->ip_address->setDbValue($row['ip_address']);
		$this->auto_assign_type->setDbValue($row['auto_assign_type']);
		$this->assign_started->setDbValue($row['assign_started']);
		$this->assignment_status->setDbValue($row['assignment_status']);
		$this->dropoff_contact_name->setDbValue($row['dropoff_contact_name']);
		$this->dropoff_contact_number->setDbValue($row['dropoff_contact_number']);
		$this->drop_address->setDbValue($row['drop_address']);
		$this->dropoff_task_lat->setDbValue($row['dropoff_task_lat']);
		$this->dropoff_task_lng->setDbValue($row['dropoff_task_lng']);
		$this->task_token->setDbValue($row['task_token']);
		$this->ratings->setDbValue($row['ratings']);
		$this->rating_comment->setDbValue($row['rating_comment']);
		$this->critical->setDbValue($row['critical']);
		$this->souce_e->setDbValue($row['souce_e']);
		$this->shop_code_e->setDbValue($row['shop_code_e']);
		$this->Received_Channel_e->setDbValue($row['Received_Channel_e']);
		$this->PayMethod_e->setDbValue($row['PayMethod_e']);
		$this->Type_e->setDbValue($row['Type_e']);
		$this->Request_Code_e->setDbValue($row['Request_Code_e']);
		$this->Status_e->setDbValue($row['Status_e']);
		$this->PlanType_e->setDbValue($row['PlanType_e']);
		$this->Plan_e->setDbValue($row['Plan_e']);
		$this->Isdn_e->setDbValue($row['Isdn_e']);
		$this->serial_sim_handset_e->setDbValue($row['serial_sim_handset_e']);
		$this->handset_e->setDbValue($row['handset_e']);
		$this->Connect_Reason_e->setDbValue($row['Connect_Reason_e']);
		$this->Price_e->setDbValue($row['Price_e']);
		$this->Current_Operator_e->setDbValue($row['Current_Operator_e']);
		$this->Current_Plan_Type_e->setDbValue($row['Current_Plan_Type_e']);
		$this->Document_Number_e->setDbValue($row['Document_Number_e']);
		$this->Document_Type_e->setDbValue($row['Document_Type_e']);
		$this->assignStaffCode_e->setDbValue($row['assignStaffCode_e']);
		$this->Delivery_Type_e->setDbValue($row['Delivery_Type_e']);
		$this->assignStaffType_e->setDbValue($row['assignStaffType_e']);
		$this->receiveStaffCode_e->setDbValue($row['receiveStaffCode_e']);
		$this->receiveStaffType_e->setDbValue($row['receiveStaffType_e']);
		$this->connectStaffCode_e->setDbValue($row['connectStaffCode_e']);
		$this->connectStaffType_e->setDbValue($row['connectStaffType_e']);
		$this->shopName_e->setDbValue($row['shopName_e']);
		$this->saleOrderCode_e->setDbValue($row['saleOrderCode_e']);
		$this->consultantCode_e->setDbValue($row['consultantCode_e']);
		$this->consultantName_e->setDbValue($row['consultantName_e']);
		$this->consultantType_e->setDbValue($row['consultantType_e']);
		$this->created_By_e->setDbValue($row['created_By_e']);
		$this->createdBranch_e->setDbValue($row['createdBranch_e']);
		$this->generated_Code_By_e->setDbValue($row['generated_Code_By_e']);
		$this->approve_Paid_By_e->setDbValue($row['approve_Paid_By_e']);
		$this->Delivery_Note_e->setDbValue($row['Delivery_Note_e']);
		$this->Delivery_Code_e->setDbValue($row['Delivery_Code_e']);
		$this->Customer_Note_e->setDbValue($row['Customer_Note_e']);
		$this->saleOrderCreateDate_e->setDbValue($row['saleOrderCreateDate_e']);
		$this->saleOrderPayDate_e->setDbValue($row['saleOrderPayDate_e']);
		$this->Time_of_Procesing_e->setDbValue($row['Time_of_Procesing_e']);
		$this->Time_of_new_e->setDbValue($row['Time_of_new_e']);
		$this->Time_of_Finished_e->setDbValue($row['Time_of_Finished_e']);
		$this->KPI_CC_Hour_e->setDbValue($row['KPI_CC_Hour_e']);
		$this->KPI_NEW_Hour_e->setDbValue($row['KPI_NEW_Hour_e']);
		$this->KPI_PROCESING_Hour_e->setDbValue($row['KPI_PROCESING_Hour_e']);
		$this->KPI_ALL_Hour_e->setDbValue($row['KPI_ALL_Hour_e']);
		$this->Kpi_Register_Hour_e->setDbValue($row['Kpi_Register_Hour_e']);
		$this->Kpi_Bitel_Hour_e->setDbValue($row['Kpi_Bitel_Hour_e']);
		$this->AmountGB_e->setDbValue($row['AmountGB_e']);
		$this->Price_1_e->setDbValue($row['Price_1_e']);
		$this->Status_1_e->setDbValue($row['Status_1_e']);
		$this->Registered_Date_e->setDbValue($row['Registered_Date_e']);
		$this->Sumary_e->setDbValue($row['Sumary_e']);
		$this->Plans_e->setDbValue($row['Plans_e']);
		$this->Isdns_e->setDbValue($row['Isdns_e']);
		$this->PlanTypes_e->setDbValue($row['PlanTypes_e']);
		$this->Serials_e->setDbValue($row['Serials_e']);
		$this->Status_2_e->setDbValue($row['Status_2_e']);
		$this->Registered_Date_2_e->setDbValue($row['Registered_Date_2_e']);
		$this->Summary_2_e->setDbValue($row['Summary_2_e']);
		$this->serial_2_e->setDbValue($row['serial_2_e']);
		$this->HandsetCode_e->setDbValue($row['HandsetCode_e']);
		$this->HandsetName_e->setDbValue($row['HandsetName_e']);
		$this->Status_3_e->setDbValue($row['Status_3_e']);
		$this->Summary_3_e->setDbValue($row['Summary_3_e']);
		$this->fecha_activa_e->setDbValue($row['fecha_activa_e']);
		$this->mes_activa_e->setDbValue($row['mes_activa_e']);
		$this->SOURCE_OUT_e->setDbValue($row['SOURCE_OUT_e']);
		$this->fecha_crea_e->setDbValue($row['fecha_crea_e']);
		$this->mes_crea_e->setDbValue($row['mes_crea_e']);
		$this->moto_e->setDbValue($row['moto_e']);
		$this->customer_id->setDbValue($row['customer_id']);
		$this->status->setDbValue($row['status']);
		$this->address_e->setDbValue($row['address_e']);
		$this->branch_e->setDbValue($row['branch_e']);
		$this->CreatedTime_e->setDbValue($row['CreatedTime_e']);
		$this->Status_n->setDbValue($row['Status_n']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['task_id'] = $this->task_id->CurrentValue;
		$row['task_description'] = $this->task_description->CurrentValue;
		$row['trans_type'] = $this->trans_type->CurrentValue;
		$row['contact_number'] = $this->contact_number->CurrentValue;
		$row['email_address'] = $this->email_address->CurrentValue;
		$row['customer_name'] = $this->customer_name->CurrentValue;
		$row['delivery_date'] = $this->delivery_date->CurrentValue;
		$row['delivery_address'] = $this->delivery_address->CurrentValue;
		$row['team_id'] = $this->team_id->CurrentValue;
		$row['driver_id'] = $this->driver_id->CurrentValue;
		$row['task_lat'] = $this->task_lat->CurrentValue;
		$row['task_lng'] = $this->task_lng->CurrentValue;
		$row['customer_signature'] = $this->customer_signature->CurrentValue;
		$row['date_created'] = $this->date_created->CurrentValue;
		$row['date_modified'] = $this->date_modified->CurrentValue;
		$row['ip_address'] = $this->ip_address->CurrentValue;
		$row['auto_assign_type'] = $this->auto_assign_type->CurrentValue;
		$row['assign_started'] = $this->assign_started->CurrentValue;
		$row['assignment_status'] = $this->assignment_status->CurrentValue;
		$row['dropoff_contact_name'] = $this->dropoff_contact_name->CurrentValue;
		$row['dropoff_contact_number'] = $this->dropoff_contact_number->CurrentValue;
		$row['drop_address'] = $this->drop_address->CurrentValue;
		$row['dropoff_task_lat'] = $this->dropoff_task_lat->CurrentValue;
		$row['dropoff_task_lng'] = $this->dropoff_task_lng->CurrentValue;
		$row['task_token'] = $this->task_token->CurrentValue;
		$row['ratings'] = $this->ratings->CurrentValue;
		$row['rating_comment'] = $this->rating_comment->CurrentValue;
		$row['critical'] = $this->critical->CurrentValue;
		$row['souce_e'] = $this->souce_e->CurrentValue;
		$row['shop_code_e'] = $this->shop_code_e->CurrentValue;
		$row['Received_Channel_e'] = $this->Received_Channel_e->CurrentValue;
		$row['PayMethod_e'] = $this->PayMethod_e->CurrentValue;
		$row['Type_e'] = $this->Type_e->CurrentValue;
		$row['Request_Code_e'] = $this->Request_Code_e->CurrentValue;
		$row['Status_e'] = $this->Status_e->CurrentValue;
		$row['PlanType_e'] = $this->PlanType_e->CurrentValue;
		$row['Plan_e'] = $this->Plan_e->CurrentValue;
		$row['Isdn_e'] = $this->Isdn_e->CurrentValue;
		$row['serial_sim_handset_e'] = $this->serial_sim_handset_e->CurrentValue;
		$row['handset_e'] = $this->handset_e->CurrentValue;
		$row['Connect_Reason_e'] = $this->Connect_Reason_e->CurrentValue;
		$row['Price_e'] = $this->Price_e->CurrentValue;
		$row['Current_Operator_e'] = $this->Current_Operator_e->CurrentValue;
		$row['Current_Plan_Type_e'] = $this->Current_Plan_Type_e->CurrentValue;
		$row['Document_Number_e'] = $this->Document_Number_e->CurrentValue;
		$row['Document_Type_e'] = $this->Document_Type_e->CurrentValue;
		$row['assignStaffCode_e'] = $this->assignStaffCode_e->CurrentValue;
		$row['Delivery_Type_e'] = $this->Delivery_Type_e->CurrentValue;
		$row['assignStaffType_e'] = $this->assignStaffType_e->CurrentValue;
		$row['receiveStaffCode_e'] = $this->receiveStaffCode_e->CurrentValue;
		$row['receiveStaffType_e'] = $this->receiveStaffType_e->CurrentValue;
		$row['connectStaffCode_e'] = $this->connectStaffCode_e->CurrentValue;
		$row['connectStaffType_e'] = $this->connectStaffType_e->CurrentValue;
		$row['shopName_e'] = $this->shopName_e->CurrentValue;
		$row['saleOrderCode_e'] = $this->saleOrderCode_e->CurrentValue;
		$row['consultantCode_e'] = $this->consultantCode_e->CurrentValue;
		$row['consultantName_e'] = $this->consultantName_e->CurrentValue;
		$row['consultantType_e'] = $this->consultantType_e->CurrentValue;
		$row['created_By_e'] = $this->created_By_e->CurrentValue;
		$row['createdBranch_e'] = $this->createdBranch_e->CurrentValue;
		$row['generated_Code_By_e'] = $this->generated_Code_By_e->CurrentValue;
		$row['approve_Paid_By_e'] = $this->approve_Paid_By_e->CurrentValue;
		$row['Delivery_Note_e'] = $this->Delivery_Note_e->CurrentValue;
		$row['Delivery_Code_e'] = $this->Delivery_Code_e->CurrentValue;
		$row['Customer_Note_e'] = $this->Customer_Note_e->CurrentValue;
		$row['saleOrderCreateDate_e'] = $this->saleOrderCreateDate_e->CurrentValue;
		$row['saleOrderPayDate_e'] = $this->saleOrderPayDate_e->CurrentValue;
		$row['Time_of_Procesing_e'] = $this->Time_of_Procesing_e->CurrentValue;
		$row['Time_of_new_e'] = $this->Time_of_new_e->CurrentValue;
		$row['Time_of_Finished_e'] = $this->Time_of_Finished_e->CurrentValue;
		$row['KPI_CC_Hour_e'] = $this->KPI_CC_Hour_e->CurrentValue;
		$row['KPI_NEW_Hour_e'] = $this->KPI_NEW_Hour_e->CurrentValue;
		$row['KPI_PROCESING_Hour_e'] = $this->KPI_PROCESING_Hour_e->CurrentValue;
		$row['KPI_ALL_Hour_e'] = $this->KPI_ALL_Hour_e->CurrentValue;
		$row['Kpi_Register_Hour_e'] = $this->Kpi_Register_Hour_e->CurrentValue;
		$row['Kpi_Bitel_Hour_e'] = $this->Kpi_Bitel_Hour_e->CurrentValue;
		$row['AmountGB_e'] = $this->AmountGB_e->CurrentValue;
		$row['Price_1_e'] = $this->Price_1_e->CurrentValue;
		$row['Status_1_e'] = $this->Status_1_e->CurrentValue;
		$row['Registered_Date_e'] = $this->Registered_Date_e->CurrentValue;
		$row['Sumary_e'] = $this->Sumary_e->CurrentValue;
		$row['Plans_e'] = $this->Plans_e->CurrentValue;
		$row['Isdns_e'] = $this->Isdns_e->CurrentValue;
		$row['PlanTypes_e'] = $this->PlanTypes_e->CurrentValue;
		$row['Serials_e'] = $this->Serials_e->CurrentValue;
		$row['Status_2_e'] = $this->Status_2_e->CurrentValue;
		$row['Registered_Date_2_e'] = $this->Registered_Date_2_e->CurrentValue;
		$row['Summary_2_e'] = $this->Summary_2_e->CurrentValue;
		$row['serial_2_e'] = $this->serial_2_e->CurrentValue;
		$row['HandsetCode_e'] = $this->HandsetCode_e->CurrentValue;
		$row['HandsetName_e'] = $this->HandsetName_e->CurrentValue;
		$row['Status_3_e'] = $this->Status_3_e->CurrentValue;
		$row['Summary_3_e'] = $this->Summary_3_e->CurrentValue;
		$row['fecha_activa_e'] = $this->fecha_activa_e->CurrentValue;
		$row['mes_activa_e'] = $this->mes_activa_e->CurrentValue;
		$row['SOURCE_OUT_e'] = $this->SOURCE_OUT_e->CurrentValue;
		$row['fecha_crea_e'] = $this->fecha_crea_e->CurrentValue;
		$row['mes_crea_e'] = $this->mes_crea_e->CurrentValue;
		$row['moto_e'] = $this->moto_e->CurrentValue;
		$row['customer_id'] = $this->customer_id->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['address_e'] = $this->address_e->CurrentValue;
		$row['branch_e'] = $this->branch_e->CurrentValue;
		$row['CreatedTime_e'] = $this->CreatedTime_e->CurrentValue;
		$row['Status_n'] = $this->Status_n->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("task_id")) != "")
			$this->task_id->OldValue = $this->getKey("task_id"); // task_id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Price_e->FormValue == $this->Price_e->CurrentValue && is_numeric(ConvertToFloatString($this->Price_e->CurrentValue)))
			$this->Price_e->CurrentValue = ConvertToFloatString($this->Price_e->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// task_id
		// task_description
		// trans_type
		// contact_number
		// email_address
		// customer_name
		// delivery_date
		// delivery_address
		// team_id
		// driver_id
		// task_lat
		// task_lng
		// customer_signature
		// date_created
		// date_modified
		// ip_address
		// auto_assign_type
		// assign_started
		// assignment_status
		// dropoff_contact_name
		// dropoff_contact_number
		// drop_address
		// dropoff_task_lat
		// dropoff_task_lng
		// task_token
		// ratings
		// rating_comment
		// critical
		// souce_e
		// shop_code_e
		// Received_Channel_e
		// PayMethod_e
		// Type_e
		// Request_Code_e
		// Status_e
		// PlanType_e
		// Plan_e
		// Isdn_e
		// serial_sim_handset_e
		// handset_e
		// Connect_Reason_e
		// Price_e
		// Current_Operator_e
		// Current_Plan_Type_e
		// Document_Number_e
		// Document_Type_e
		// assignStaffCode_e
		// Delivery_Type_e
		// assignStaffType_e
		// receiveStaffCode_e
		// receiveStaffType_e
		// connectStaffCode_e
		// connectStaffType_e
		// shopName_e
		// saleOrderCode_e
		// consultantCode_e
		// consultantName_e
		// consultantType_e
		// created_By_e
		// createdBranch_e
		// generated_Code_By_e
		// approve_Paid_By_e
		// Delivery_Note_e
		// Delivery_Code_e
		// Customer_Note_e
		// saleOrderCreateDate_e
		// saleOrderPayDate_e
		// Time_of_Procesing_e
		// Time_of_new_e
		// Time_of_Finished_e
		// KPI_CC_Hour_e
		// KPI_NEW_Hour_e
		// KPI_PROCESING_Hour_e
		// KPI_ALL_Hour_e
		// Kpi_Register_Hour_e
		// Kpi_Bitel_Hour_e
		// AmountGB_e
		// Price_1_e
		// Status_1_e
		// Registered_Date_e
		// Sumary_e
		// Plans_e
		// Isdns_e
		// PlanTypes_e
		// Serials_e
		// Status_2_e
		// Registered_Date_2_e
		// Summary_2_e
		// serial_2_e
		// HandsetCode_e
		// HandsetName_e
		// Status_3_e
		// Summary_3_e
		// fecha_activa_e
		// mes_activa_e
		// SOURCE_OUT_e
		// fecha_crea_e
		// mes_crea_e
		// moto_e
		// customer_id
		// status
		// address_e
		// branch_e
		// CreatedTime_e
		// Status_n

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// task_id
			$this->task_id->ViewValue = $this->task_id->CurrentValue;
			$this->task_id->ViewCustomAttributes = "";

			// task_description
			$this->task_description->ViewValue = $this->task_description->CurrentValue;
			$this->task_description->ViewCustomAttributes = "";

			// trans_type
			$this->trans_type->ViewValue = $this->trans_type->CurrentValue;
			$this->trans_type->ViewCustomAttributes = "";

			// contact_number
			$this->contact_number->ViewValue = $this->contact_number->CurrentValue;
			$this->contact_number->ViewCustomAttributes = "";

			// email_address
			$this->email_address->ViewValue = $this->email_address->CurrentValue;
			$this->email_address->ViewCustomAttributes = "";

			// customer_name
			$this->customer_name->ViewValue = $this->customer_name->CurrentValue;
			$this->customer_name->ViewCustomAttributes = "";

			// delivery_date
			$this->delivery_date->ViewValue = $this->delivery_date->CurrentValue;
			$this->delivery_date->ViewValue = FormatDateTime($this->delivery_date->ViewValue, 0);
			$this->delivery_date->ViewCustomAttributes = "";

			// delivery_address
			$this->delivery_address->ViewValue = $this->delivery_address->CurrentValue;
			$this->delivery_address->ViewCustomAttributes = "";

			// team_id
			$this->team_id->ViewValue = $this->team_id->CurrentValue;
			$this->team_id->ViewValue = FormatNumber($this->team_id->ViewValue, 0, -2, -2, -2);
			$this->team_id->ViewCustomAttributes = "";

			// driver_id
			$this->driver_id->ViewValue = $this->driver_id->CurrentValue;
			$this->driver_id->ViewValue = FormatNumber($this->driver_id->ViewValue, 0, -2, -2, -2);
			$this->driver_id->ViewCustomAttributes = "";

			// task_lat
			$this->task_lat->ViewValue = $this->task_lat->CurrentValue;
			$this->task_lat->ViewCustomAttributes = "";

			// task_lng
			$this->task_lng->ViewValue = $this->task_lng->CurrentValue;
			$this->task_lng->ViewCustomAttributes = "";

			// customer_signature
			$this->customer_signature->ViewValue = $this->customer_signature->CurrentValue;
			$this->customer_signature->ViewCustomAttributes = "";

			// date_created
			$this->date_created->ViewValue = $this->date_created->CurrentValue;
			$this->date_created->ViewValue = FormatDateTime($this->date_created->ViewValue, 0);
			$this->date_created->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = FormatDateTime($this->date_modified->ViewValue, 0);
			$this->date_modified->ViewCustomAttributes = "";

			// ip_address
			$this->ip_address->ViewValue = $this->ip_address->CurrentValue;
			$this->ip_address->ViewCustomAttributes = "";

			// auto_assign_type
			$this->auto_assign_type->ViewValue = $this->auto_assign_type->CurrentValue;
			$this->auto_assign_type->ViewCustomAttributes = "";

			// assign_started
			$this->assign_started->ViewValue = $this->assign_started->CurrentValue;
			$this->assign_started->ViewValue = FormatDateTime($this->assign_started->ViewValue, 0);
			$this->assign_started->ViewCustomAttributes = "";

			// assignment_status
			$this->assignment_status->ViewValue = $this->assignment_status->CurrentValue;
			$this->assignment_status->ViewCustomAttributes = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->ViewValue = $this->dropoff_contact_name->CurrentValue;
			$this->dropoff_contact_name->ViewCustomAttributes = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->ViewValue = $this->dropoff_contact_number->CurrentValue;
			$this->dropoff_contact_number->ViewCustomAttributes = "";

			// drop_address
			$this->drop_address->ViewValue = $this->drop_address->CurrentValue;
			$this->drop_address->ViewCustomAttributes = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->ViewValue = $this->dropoff_task_lat->CurrentValue;
			$this->dropoff_task_lat->ViewCustomAttributes = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->ViewValue = $this->dropoff_task_lng->CurrentValue;
			$this->dropoff_task_lng->ViewCustomAttributes = "";

			// task_token
			$this->task_token->ViewValue = $this->task_token->CurrentValue;
			$this->task_token->ViewCustomAttributes = "";

			// ratings
			$this->ratings->ViewValue = $this->ratings->CurrentValue;
			$this->ratings->ViewCustomAttributes = "";

			// rating_comment
			$this->rating_comment->ViewValue = $this->rating_comment->CurrentValue;
			$this->rating_comment->ViewCustomAttributes = "";

			// critical
			$this->critical->ViewValue = $this->critical->CurrentValue;
			$this->critical->ViewValue = FormatNumber($this->critical->ViewValue, 0, -2, -2, -2);
			$this->critical->ViewCustomAttributes = "";

			// souce_e
			$this->souce_e->ViewValue = $this->souce_e->CurrentValue;
			$this->souce_e->ViewCustomAttributes = "";

			// shop_code_e
			$this->shop_code_e->ViewValue = $this->shop_code_e->CurrentValue;
			$this->shop_code_e->ViewCustomAttributes = "";

			// Received_Channel_e
			$this->Received_Channel_e->ViewValue = $this->Received_Channel_e->CurrentValue;
			$this->Received_Channel_e->ViewCustomAttributes = "";

			// PayMethod_e
			$this->PayMethod_e->ViewValue = $this->PayMethod_e->CurrentValue;
			$this->PayMethod_e->ViewCustomAttributes = "";

			// Type_e
			$this->Type_e->ViewValue = $this->Type_e->CurrentValue;
			$this->Type_e->ViewCustomAttributes = "";

			// Request_Code_e
			$this->Request_Code_e->ViewValue = $this->Request_Code_e->CurrentValue;
			$this->Request_Code_e->ViewCustomAttributes = "";

			// Status_e
			$this->Status_e->ViewValue = $this->Status_e->CurrentValue;
			$this->Status_e->ViewCustomAttributes = "";

			// PlanType_e
			$this->PlanType_e->ViewValue = $this->PlanType_e->CurrentValue;
			$this->PlanType_e->ViewCustomAttributes = "";

			// Plan_e
			$this->Plan_e->ViewValue = $this->Plan_e->CurrentValue;
			$this->Plan_e->ViewCustomAttributes = "";

			// Isdn_e
			$this->Isdn_e->ViewValue = $this->Isdn_e->CurrentValue;
			$this->Isdn_e->ViewCustomAttributes = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->ViewValue = $this->serial_sim_handset_e->CurrentValue;
			$this->serial_sim_handset_e->ViewCustomAttributes = "";

			// handset_e
			$this->handset_e->ViewValue = $this->handset_e->CurrentValue;
			$this->handset_e->ViewCustomAttributes = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->ViewValue = $this->Connect_Reason_e->CurrentValue;
			$this->Connect_Reason_e->ViewCustomAttributes = "";

			// Price_e
			$this->Price_e->ViewValue = $this->Price_e->CurrentValue;
			$this->Price_e->ViewValue = FormatNumber($this->Price_e->ViewValue, 2, -2, -2, -2);
			$this->Price_e->ViewCustomAttributes = "";

			// Current_Operator_e
			$this->Current_Operator_e->ViewValue = $this->Current_Operator_e->CurrentValue;
			$this->Current_Operator_e->ViewCustomAttributes = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->ViewValue = $this->Current_Plan_Type_e->CurrentValue;
			$this->Current_Plan_Type_e->ViewCustomAttributes = "";

			// Document_Number_e
			$this->Document_Number_e->ViewValue = $this->Document_Number_e->CurrentValue;
			$this->Document_Number_e->ViewCustomAttributes = "";

			// Document_Type_e
			$this->Document_Type_e->ViewValue = $this->Document_Type_e->CurrentValue;
			$this->Document_Type_e->ViewCustomAttributes = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->ViewValue = $this->assignStaffCode_e->CurrentValue;
			$this->assignStaffCode_e->ViewCustomAttributes = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->ViewValue = $this->Delivery_Type_e->CurrentValue;
			$this->Delivery_Type_e->ViewCustomAttributes = "";

			// assignStaffType_e
			$this->assignStaffType_e->ViewValue = $this->assignStaffType_e->CurrentValue;
			$this->assignStaffType_e->ViewCustomAttributes = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->ViewValue = $this->receiveStaffCode_e->CurrentValue;
			$this->receiveStaffCode_e->ViewCustomAttributes = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->ViewValue = $this->receiveStaffType_e->CurrentValue;
			$this->receiveStaffType_e->ViewCustomAttributes = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->ViewValue = $this->connectStaffCode_e->CurrentValue;
			$this->connectStaffCode_e->ViewCustomAttributes = "";

			// connectStaffType_e
			$this->connectStaffType_e->ViewValue = $this->connectStaffType_e->CurrentValue;
			$this->connectStaffType_e->ViewCustomAttributes = "";

			// shopName_e
			$this->shopName_e->ViewValue = $this->shopName_e->CurrentValue;
			$this->shopName_e->ViewCustomAttributes = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->ViewValue = $this->saleOrderCode_e->CurrentValue;
			$this->saleOrderCode_e->ViewCustomAttributes = "";

			// consultantCode_e
			$this->consultantCode_e->ViewValue = $this->consultantCode_e->CurrentValue;
			$this->consultantCode_e->ViewCustomAttributes = "";

			// consultantName_e
			$this->consultantName_e->ViewValue = $this->consultantName_e->CurrentValue;
			$this->consultantName_e->ViewCustomAttributes = "";

			// consultantType_e
			$this->consultantType_e->ViewValue = $this->consultantType_e->CurrentValue;
			$this->consultantType_e->ViewCustomAttributes = "";

			// created_By_e
			$this->created_By_e->ViewValue = $this->created_By_e->CurrentValue;
			$this->created_By_e->ViewCustomAttributes = "";

			// createdBranch_e
			$this->createdBranch_e->ViewValue = $this->createdBranch_e->CurrentValue;
			$this->createdBranch_e->ViewCustomAttributes = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->ViewValue = $this->generated_Code_By_e->CurrentValue;
			$this->generated_Code_By_e->ViewCustomAttributes = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->ViewValue = $this->approve_Paid_By_e->CurrentValue;
			$this->approve_Paid_By_e->ViewCustomAttributes = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->ViewValue = $this->Delivery_Note_e->CurrentValue;
			$this->Delivery_Note_e->ViewCustomAttributes = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->ViewValue = $this->Delivery_Code_e->CurrentValue;
			$this->Delivery_Code_e->ViewCustomAttributes = "";

			// Customer_Note_e
			$this->Customer_Note_e->ViewValue = $this->Customer_Note_e->CurrentValue;
			$this->Customer_Note_e->ViewCustomAttributes = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->ViewValue = $this->saleOrderCreateDate_e->CurrentValue;
			$this->saleOrderCreateDate_e->ViewCustomAttributes = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->ViewValue = $this->saleOrderPayDate_e->CurrentValue;
			$this->saleOrderPayDate_e->ViewCustomAttributes = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->ViewValue = $this->Time_of_Procesing_e->CurrentValue;
			$this->Time_of_Procesing_e->ViewCustomAttributes = "";

			// Time_of_new_e
			$this->Time_of_new_e->ViewValue = $this->Time_of_new_e->CurrentValue;
			$this->Time_of_new_e->ViewCustomAttributes = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->ViewValue = $this->Time_of_Finished_e->CurrentValue;
			$this->Time_of_Finished_e->ViewCustomAttributes = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->ViewValue = $this->KPI_CC_Hour_e->CurrentValue;
			$this->KPI_CC_Hour_e->ViewCustomAttributes = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->ViewValue = $this->KPI_NEW_Hour_e->CurrentValue;
			$this->KPI_NEW_Hour_e->ViewCustomAttributes = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->ViewValue = $this->KPI_PROCESING_Hour_e->CurrentValue;
			$this->KPI_PROCESING_Hour_e->ViewCustomAttributes = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->ViewValue = $this->KPI_ALL_Hour_e->CurrentValue;
			$this->KPI_ALL_Hour_e->ViewCustomAttributes = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->ViewValue = $this->Kpi_Register_Hour_e->CurrentValue;
			$this->Kpi_Register_Hour_e->ViewCustomAttributes = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->ViewValue = $this->Kpi_Bitel_Hour_e->CurrentValue;
			$this->Kpi_Bitel_Hour_e->ViewCustomAttributes = "";

			// AmountGB_e
			$this->AmountGB_e->ViewValue = $this->AmountGB_e->CurrentValue;
			$this->AmountGB_e->ViewCustomAttributes = "";

			// Price_1_e
			$this->Price_1_e->ViewValue = $this->Price_1_e->CurrentValue;
			$this->Price_1_e->ViewCustomAttributes = "";

			// Status_1_e
			$this->Status_1_e->ViewValue = $this->Status_1_e->CurrentValue;
			$this->Status_1_e->ViewCustomAttributes = "";

			// Registered_Date_e
			$this->Registered_Date_e->ViewValue = $this->Registered_Date_e->CurrentValue;
			$this->Registered_Date_e->ViewCustomAttributes = "";

			// Sumary_e
			$this->Sumary_e->ViewValue = $this->Sumary_e->CurrentValue;
			$this->Sumary_e->ViewCustomAttributes = "";

			// Plans_e
			$this->Plans_e->ViewValue = $this->Plans_e->CurrentValue;
			$this->Plans_e->ViewCustomAttributes = "";

			// Isdns_e
			$this->Isdns_e->ViewValue = $this->Isdns_e->CurrentValue;
			$this->Isdns_e->ViewCustomAttributes = "";

			// PlanTypes_e
			$this->PlanTypes_e->ViewValue = $this->PlanTypes_e->CurrentValue;
			$this->PlanTypes_e->ViewCustomAttributes = "";

			// Serials_e
			$this->Serials_e->ViewValue = $this->Serials_e->CurrentValue;
			$this->Serials_e->ViewCustomAttributes = "";

			// Status_2_e
			$this->Status_2_e->ViewValue = $this->Status_2_e->CurrentValue;
			$this->Status_2_e->ViewCustomAttributes = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->ViewValue = $this->Registered_Date_2_e->CurrentValue;
			$this->Registered_Date_2_e->ViewCustomAttributes = "";

			// Summary_2_e
			$this->Summary_2_e->ViewValue = $this->Summary_2_e->CurrentValue;
			$this->Summary_2_e->ViewCustomAttributes = "";

			// serial_2_e
			$this->serial_2_e->ViewValue = $this->serial_2_e->CurrentValue;
			$this->serial_2_e->ViewCustomAttributes = "";

			// HandsetCode_e
			$this->HandsetCode_e->ViewValue = $this->HandsetCode_e->CurrentValue;
			$this->HandsetCode_e->ViewCustomAttributes = "";

			// HandsetName_e
			$this->HandsetName_e->ViewValue = $this->HandsetName_e->CurrentValue;
			$this->HandsetName_e->ViewCustomAttributes = "";

			// Status_3_e
			$this->Status_3_e->ViewValue = $this->Status_3_e->CurrentValue;
			$this->Status_3_e->ViewCustomAttributes = "";

			// Summary_3_e
			$this->Summary_3_e->ViewValue = $this->Summary_3_e->CurrentValue;
			$this->Summary_3_e->ViewCustomAttributes = "";

			// fecha_activa_e
			$this->fecha_activa_e->ViewValue = $this->fecha_activa_e->CurrentValue;
			$this->fecha_activa_e->ViewCustomAttributes = "";

			// mes_activa_e
			$this->mes_activa_e->ViewValue = $this->mes_activa_e->CurrentValue;
			$this->mes_activa_e->ViewCustomAttributes = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->ViewValue = $this->SOURCE_OUT_e->CurrentValue;
			$this->SOURCE_OUT_e->ViewCustomAttributes = "";

			// fecha_crea_e
			$this->fecha_crea_e->ViewValue = $this->fecha_crea_e->CurrentValue;
			$this->fecha_crea_e->ViewCustomAttributes = "";

			// mes_crea_e
			$this->mes_crea_e->ViewValue = $this->mes_crea_e->CurrentValue;
			$this->mes_crea_e->ViewCustomAttributes = "";

			// moto_e
			$this->moto_e->ViewValue = $this->moto_e->CurrentValue;
			$this->moto_e->ViewCustomAttributes = "";

			// customer_id
			$this->customer_id->ViewValue = $this->customer_id->CurrentValue;
			$this->customer_id->ViewValue = FormatNumber($this->customer_id->ViewValue, 0, -2, -2, -2);
			$this->customer_id->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewCustomAttributes = "";

			// address_e
			$this->address_e->ViewValue = $this->address_e->CurrentValue;
			$this->address_e->ViewCustomAttributes = "";

			// branch_e
			$this->branch_e->ViewValue = $this->branch_e->CurrentValue;
			$this->branch_e->ViewCustomAttributes = "";

			// CreatedTime_e
			$this->CreatedTime_e->ViewValue = $this->CreatedTime_e->CurrentValue;
			$this->CreatedTime_e->ViewValue = FormatDateTime($this->CreatedTime_e->ViewValue, 0);
			$this->CreatedTime_e->ViewCustomAttributes = "";

			// Status_n
			$this->Status_n->ViewValue = $this->Status_n->CurrentValue;
			$this->Status_n->ViewValue = FormatNumber($this->Status_n->ViewValue, 0, -2, -2, -2);
			$this->Status_n->ViewCustomAttributes = "";

			// task_description
			$this->task_description->LinkCustomAttributes = "";
			$this->task_description->HrefValue = "";
			$this->task_description->TooltipValue = "";

			// trans_type
			$this->trans_type->LinkCustomAttributes = "";
			$this->trans_type->HrefValue = "";
			$this->trans_type->TooltipValue = "";

			// contact_number
			$this->contact_number->LinkCustomAttributes = "";
			$this->contact_number->HrefValue = "";
			$this->contact_number->TooltipValue = "";

			// email_address
			$this->email_address->LinkCustomAttributes = "";
			$this->email_address->HrefValue = "";
			$this->email_address->TooltipValue = "";

			// customer_name
			$this->customer_name->LinkCustomAttributes = "";
			$this->customer_name->HrefValue = "";
			$this->customer_name->TooltipValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";
			$this->delivery_date->TooltipValue = "";

			// delivery_address
			$this->delivery_address->LinkCustomAttributes = "";
			$this->delivery_address->HrefValue = "";
			$this->delivery_address->TooltipValue = "";

			// team_id
			$this->team_id->LinkCustomAttributes = "";
			$this->team_id->HrefValue = "";
			$this->team_id->TooltipValue = "";

			// driver_id
			$this->driver_id->LinkCustomAttributes = "";
			$this->driver_id->HrefValue = "";
			$this->driver_id->TooltipValue = "";

			// task_lat
			$this->task_lat->LinkCustomAttributes = "";
			$this->task_lat->HrefValue = "";
			$this->task_lat->TooltipValue = "";

			// task_lng
			$this->task_lng->LinkCustomAttributes = "";
			$this->task_lng->HrefValue = "";
			$this->task_lng->TooltipValue = "";

			// customer_signature
			$this->customer_signature->LinkCustomAttributes = "";
			$this->customer_signature->HrefValue = "";
			$this->customer_signature->TooltipValue = "";

			// date_created
			$this->date_created->LinkCustomAttributes = "";
			$this->date_created->HrefValue = "";
			$this->date_created->TooltipValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";
			$this->date_modified->TooltipValue = "";

			// ip_address
			$this->ip_address->LinkCustomAttributes = "";
			$this->ip_address->HrefValue = "";
			$this->ip_address->TooltipValue = "";

			// auto_assign_type
			$this->auto_assign_type->LinkCustomAttributes = "";
			$this->auto_assign_type->HrefValue = "";
			$this->auto_assign_type->TooltipValue = "";

			// assign_started
			$this->assign_started->LinkCustomAttributes = "";
			$this->assign_started->HrefValue = "";
			$this->assign_started->TooltipValue = "";

			// assignment_status
			$this->assignment_status->LinkCustomAttributes = "";
			$this->assignment_status->HrefValue = "";
			$this->assignment_status->TooltipValue = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->LinkCustomAttributes = "";
			$this->dropoff_contact_name->HrefValue = "";
			$this->dropoff_contact_name->TooltipValue = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->LinkCustomAttributes = "";
			$this->dropoff_contact_number->HrefValue = "";
			$this->dropoff_contact_number->TooltipValue = "";

			// drop_address
			$this->drop_address->LinkCustomAttributes = "";
			$this->drop_address->HrefValue = "";
			$this->drop_address->TooltipValue = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->LinkCustomAttributes = "";
			$this->dropoff_task_lat->HrefValue = "";
			$this->dropoff_task_lat->TooltipValue = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->LinkCustomAttributes = "";
			$this->dropoff_task_lng->HrefValue = "";
			$this->dropoff_task_lng->TooltipValue = "";

			// task_token
			$this->task_token->LinkCustomAttributes = "";
			$this->task_token->HrefValue = "";
			$this->task_token->TooltipValue = "";

			// ratings
			$this->ratings->LinkCustomAttributes = "";
			$this->ratings->HrefValue = "";
			$this->ratings->TooltipValue = "";

			// rating_comment
			$this->rating_comment->LinkCustomAttributes = "";
			$this->rating_comment->HrefValue = "";
			$this->rating_comment->TooltipValue = "";

			// critical
			$this->critical->LinkCustomAttributes = "";
			$this->critical->HrefValue = "";
			$this->critical->TooltipValue = "";

			// souce_e
			$this->souce_e->LinkCustomAttributes = "";
			$this->souce_e->HrefValue = "";
			$this->souce_e->TooltipValue = "";

			// shop_code_e
			$this->shop_code_e->LinkCustomAttributes = "";
			$this->shop_code_e->HrefValue = "";
			$this->shop_code_e->TooltipValue = "";

			// Received_Channel_e
			$this->Received_Channel_e->LinkCustomAttributes = "";
			$this->Received_Channel_e->HrefValue = "";
			$this->Received_Channel_e->TooltipValue = "";

			// PayMethod_e
			$this->PayMethod_e->LinkCustomAttributes = "";
			$this->PayMethod_e->HrefValue = "";
			$this->PayMethod_e->TooltipValue = "";

			// Type_e
			$this->Type_e->LinkCustomAttributes = "";
			$this->Type_e->HrefValue = "";
			$this->Type_e->TooltipValue = "";

			// Request_Code_e
			$this->Request_Code_e->LinkCustomAttributes = "";
			$this->Request_Code_e->HrefValue = "";
			$this->Request_Code_e->TooltipValue = "";

			// Status_e
			$this->Status_e->LinkCustomAttributes = "";
			$this->Status_e->HrefValue = "";
			$this->Status_e->TooltipValue = "";

			// PlanType_e
			$this->PlanType_e->LinkCustomAttributes = "";
			$this->PlanType_e->HrefValue = "";
			$this->PlanType_e->TooltipValue = "";

			// Plan_e
			$this->Plan_e->LinkCustomAttributes = "";
			$this->Plan_e->HrefValue = "";
			$this->Plan_e->TooltipValue = "";

			// Isdn_e
			$this->Isdn_e->LinkCustomAttributes = "";
			$this->Isdn_e->HrefValue = "";
			$this->Isdn_e->TooltipValue = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->LinkCustomAttributes = "";
			$this->serial_sim_handset_e->HrefValue = "";
			$this->serial_sim_handset_e->TooltipValue = "";

			// handset_e
			$this->handset_e->LinkCustomAttributes = "";
			$this->handset_e->HrefValue = "";
			$this->handset_e->TooltipValue = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->LinkCustomAttributes = "";
			$this->Connect_Reason_e->HrefValue = "";
			$this->Connect_Reason_e->TooltipValue = "";

			// Price_e
			$this->Price_e->LinkCustomAttributes = "";
			$this->Price_e->HrefValue = "";
			$this->Price_e->TooltipValue = "";

			// Current_Operator_e
			$this->Current_Operator_e->LinkCustomAttributes = "";
			$this->Current_Operator_e->HrefValue = "";
			$this->Current_Operator_e->TooltipValue = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->LinkCustomAttributes = "";
			$this->Current_Plan_Type_e->HrefValue = "";
			$this->Current_Plan_Type_e->TooltipValue = "";

			// Document_Number_e
			$this->Document_Number_e->LinkCustomAttributes = "";
			$this->Document_Number_e->HrefValue = "";
			$this->Document_Number_e->TooltipValue = "";

			// Document_Type_e
			$this->Document_Type_e->LinkCustomAttributes = "";
			$this->Document_Type_e->HrefValue = "";
			$this->Document_Type_e->TooltipValue = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->LinkCustomAttributes = "";
			$this->assignStaffCode_e->HrefValue = "";
			$this->assignStaffCode_e->TooltipValue = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->LinkCustomAttributes = "";
			$this->Delivery_Type_e->HrefValue = "";
			$this->Delivery_Type_e->TooltipValue = "";

			// assignStaffType_e
			$this->assignStaffType_e->LinkCustomAttributes = "";
			$this->assignStaffType_e->HrefValue = "";
			$this->assignStaffType_e->TooltipValue = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->LinkCustomAttributes = "";
			$this->receiveStaffCode_e->HrefValue = "";
			$this->receiveStaffCode_e->TooltipValue = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->LinkCustomAttributes = "";
			$this->receiveStaffType_e->HrefValue = "";
			$this->receiveStaffType_e->TooltipValue = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->LinkCustomAttributes = "";
			$this->connectStaffCode_e->HrefValue = "";
			$this->connectStaffCode_e->TooltipValue = "";

			// connectStaffType_e
			$this->connectStaffType_e->LinkCustomAttributes = "";
			$this->connectStaffType_e->HrefValue = "";
			$this->connectStaffType_e->TooltipValue = "";

			// shopName_e
			$this->shopName_e->LinkCustomAttributes = "";
			$this->shopName_e->HrefValue = "";
			$this->shopName_e->TooltipValue = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->LinkCustomAttributes = "";
			$this->saleOrderCode_e->HrefValue = "";
			$this->saleOrderCode_e->TooltipValue = "";

			// consultantCode_e
			$this->consultantCode_e->LinkCustomAttributes = "";
			$this->consultantCode_e->HrefValue = "";
			$this->consultantCode_e->TooltipValue = "";

			// consultantName_e
			$this->consultantName_e->LinkCustomAttributes = "";
			$this->consultantName_e->HrefValue = "";
			$this->consultantName_e->TooltipValue = "";

			// consultantType_e
			$this->consultantType_e->LinkCustomAttributes = "";
			$this->consultantType_e->HrefValue = "";
			$this->consultantType_e->TooltipValue = "";

			// created_By_e
			$this->created_By_e->LinkCustomAttributes = "";
			$this->created_By_e->HrefValue = "";
			$this->created_By_e->TooltipValue = "";

			// createdBranch_e
			$this->createdBranch_e->LinkCustomAttributes = "";
			$this->createdBranch_e->HrefValue = "";
			$this->createdBranch_e->TooltipValue = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->LinkCustomAttributes = "";
			$this->generated_Code_By_e->HrefValue = "";
			$this->generated_Code_By_e->TooltipValue = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->LinkCustomAttributes = "";
			$this->approve_Paid_By_e->HrefValue = "";
			$this->approve_Paid_By_e->TooltipValue = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->LinkCustomAttributes = "";
			$this->Delivery_Note_e->HrefValue = "";
			$this->Delivery_Note_e->TooltipValue = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->LinkCustomAttributes = "";
			$this->Delivery_Code_e->HrefValue = "";
			$this->Delivery_Code_e->TooltipValue = "";

			// Customer_Note_e
			$this->Customer_Note_e->LinkCustomAttributes = "";
			$this->Customer_Note_e->HrefValue = "";
			$this->Customer_Note_e->TooltipValue = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->LinkCustomAttributes = "";
			$this->saleOrderCreateDate_e->HrefValue = "";
			$this->saleOrderCreateDate_e->TooltipValue = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->LinkCustomAttributes = "";
			$this->saleOrderPayDate_e->HrefValue = "";
			$this->saleOrderPayDate_e->TooltipValue = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->LinkCustomAttributes = "";
			$this->Time_of_Procesing_e->HrefValue = "";
			$this->Time_of_Procesing_e->TooltipValue = "";

			// Time_of_new_e
			$this->Time_of_new_e->LinkCustomAttributes = "";
			$this->Time_of_new_e->HrefValue = "";
			$this->Time_of_new_e->TooltipValue = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->LinkCustomAttributes = "";
			$this->Time_of_Finished_e->HrefValue = "";
			$this->Time_of_Finished_e->TooltipValue = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->LinkCustomAttributes = "";
			$this->KPI_CC_Hour_e->HrefValue = "";
			$this->KPI_CC_Hour_e->TooltipValue = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->LinkCustomAttributes = "";
			$this->KPI_NEW_Hour_e->HrefValue = "";
			$this->KPI_NEW_Hour_e->TooltipValue = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->LinkCustomAttributes = "";
			$this->KPI_PROCESING_Hour_e->HrefValue = "";
			$this->KPI_PROCESING_Hour_e->TooltipValue = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->LinkCustomAttributes = "";
			$this->KPI_ALL_Hour_e->HrefValue = "";
			$this->KPI_ALL_Hour_e->TooltipValue = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Register_Hour_e->HrefValue = "";
			$this->Kpi_Register_Hour_e->TooltipValue = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Bitel_Hour_e->HrefValue = "";
			$this->Kpi_Bitel_Hour_e->TooltipValue = "";

			// AmountGB_e
			$this->AmountGB_e->LinkCustomAttributes = "";
			$this->AmountGB_e->HrefValue = "";
			$this->AmountGB_e->TooltipValue = "";

			// Price_1_e
			$this->Price_1_e->LinkCustomAttributes = "";
			$this->Price_1_e->HrefValue = "";
			$this->Price_1_e->TooltipValue = "";

			// Status_1_e
			$this->Status_1_e->LinkCustomAttributes = "";
			$this->Status_1_e->HrefValue = "";
			$this->Status_1_e->TooltipValue = "";

			// Registered_Date_e
			$this->Registered_Date_e->LinkCustomAttributes = "";
			$this->Registered_Date_e->HrefValue = "";
			$this->Registered_Date_e->TooltipValue = "";

			// Sumary_e
			$this->Sumary_e->LinkCustomAttributes = "";
			$this->Sumary_e->HrefValue = "";
			$this->Sumary_e->TooltipValue = "";

			// Plans_e
			$this->Plans_e->LinkCustomAttributes = "";
			$this->Plans_e->HrefValue = "";
			$this->Plans_e->TooltipValue = "";

			// Isdns_e
			$this->Isdns_e->LinkCustomAttributes = "";
			$this->Isdns_e->HrefValue = "";
			$this->Isdns_e->TooltipValue = "";

			// PlanTypes_e
			$this->PlanTypes_e->LinkCustomAttributes = "";
			$this->PlanTypes_e->HrefValue = "";
			$this->PlanTypes_e->TooltipValue = "";

			// Serials_e
			$this->Serials_e->LinkCustomAttributes = "";
			$this->Serials_e->HrefValue = "";
			$this->Serials_e->TooltipValue = "";

			// Status_2_e
			$this->Status_2_e->LinkCustomAttributes = "";
			$this->Status_2_e->HrefValue = "";
			$this->Status_2_e->TooltipValue = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->LinkCustomAttributes = "";
			$this->Registered_Date_2_e->HrefValue = "";
			$this->Registered_Date_2_e->TooltipValue = "";

			// Summary_2_e
			$this->Summary_2_e->LinkCustomAttributes = "";
			$this->Summary_2_e->HrefValue = "";
			$this->Summary_2_e->TooltipValue = "";

			// serial_2_e
			$this->serial_2_e->LinkCustomAttributes = "";
			$this->serial_2_e->HrefValue = "";
			$this->serial_2_e->TooltipValue = "";

			// HandsetCode_e
			$this->HandsetCode_e->LinkCustomAttributes = "";
			$this->HandsetCode_e->HrefValue = "";
			$this->HandsetCode_e->TooltipValue = "";

			// HandsetName_e
			$this->HandsetName_e->LinkCustomAttributes = "";
			$this->HandsetName_e->HrefValue = "";
			$this->HandsetName_e->TooltipValue = "";

			// Status_3_e
			$this->Status_3_e->LinkCustomAttributes = "";
			$this->Status_3_e->HrefValue = "";
			$this->Status_3_e->TooltipValue = "";

			// Summary_3_e
			$this->Summary_3_e->LinkCustomAttributes = "";
			$this->Summary_3_e->HrefValue = "";
			$this->Summary_3_e->TooltipValue = "";

			// fecha_activa_e
			$this->fecha_activa_e->LinkCustomAttributes = "";
			$this->fecha_activa_e->HrefValue = "";
			$this->fecha_activa_e->TooltipValue = "";

			// mes_activa_e
			$this->mes_activa_e->LinkCustomAttributes = "";
			$this->mes_activa_e->HrefValue = "";
			$this->mes_activa_e->TooltipValue = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->LinkCustomAttributes = "";
			$this->SOURCE_OUT_e->HrefValue = "";
			$this->SOURCE_OUT_e->TooltipValue = "";

			// fecha_crea_e
			$this->fecha_crea_e->LinkCustomAttributes = "";
			$this->fecha_crea_e->HrefValue = "";
			$this->fecha_crea_e->TooltipValue = "";

			// mes_crea_e
			$this->mes_crea_e->LinkCustomAttributes = "";
			$this->mes_crea_e->HrefValue = "";
			$this->mes_crea_e->TooltipValue = "";

			// moto_e
			$this->moto_e->LinkCustomAttributes = "";
			$this->moto_e->HrefValue = "";
			$this->moto_e->TooltipValue = "";

			// customer_id
			$this->customer_id->LinkCustomAttributes = "";
			$this->customer_id->HrefValue = "";
			$this->customer_id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// address_e
			$this->address_e->LinkCustomAttributes = "";
			$this->address_e->HrefValue = "";
			$this->address_e->TooltipValue = "";

			// branch_e
			$this->branch_e->LinkCustomAttributes = "";
			$this->branch_e->HrefValue = "";
			$this->branch_e->TooltipValue = "";

			// CreatedTime_e
			$this->CreatedTime_e->LinkCustomAttributes = "";
			$this->CreatedTime_e->HrefValue = "";
			$this->CreatedTime_e->TooltipValue = "";

			// Status_n
			$this->Status_n->LinkCustomAttributes = "";
			$this->Status_n->HrefValue = "";
			$this->Status_n->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// task_description
			$this->task_description->EditAttrs["class"] = "form-control";
			$this->task_description->EditCustomAttributes = "";
			if (!$this->task_description->Raw)
				$this->task_description->CurrentValue = HtmlDecode($this->task_description->CurrentValue);
			$this->task_description->EditValue = HtmlEncode($this->task_description->CurrentValue);
			$this->task_description->PlaceHolder = RemoveHtml($this->task_description->caption());

			// trans_type
			$this->trans_type->EditAttrs["class"] = "form-control";
			$this->trans_type->EditCustomAttributes = "";
			if (!$this->trans_type->Raw)
				$this->trans_type->CurrentValue = HtmlDecode($this->trans_type->CurrentValue);
			$this->trans_type->EditValue = HtmlEncode($this->trans_type->CurrentValue);
			$this->trans_type->PlaceHolder = RemoveHtml($this->trans_type->caption());

			// contact_number
			$this->contact_number->EditAttrs["class"] = "form-control";
			$this->contact_number->EditCustomAttributes = "";
			if (!$this->contact_number->Raw)
				$this->contact_number->CurrentValue = HtmlDecode($this->contact_number->CurrentValue);
			$this->contact_number->EditValue = HtmlEncode($this->contact_number->CurrentValue);
			$this->contact_number->PlaceHolder = RemoveHtml($this->contact_number->caption());

			// email_address
			$this->email_address->EditAttrs["class"] = "form-control";
			$this->email_address->EditCustomAttributes = "";
			if (!$this->email_address->Raw)
				$this->email_address->CurrentValue = HtmlDecode($this->email_address->CurrentValue);
			$this->email_address->EditValue = HtmlEncode($this->email_address->CurrentValue);
			$this->email_address->PlaceHolder = RemoveHtml($this->email_address->caption());

			// customer_name
			$this->customer_name->EditAttrs["class"] = "form-control";
			$this->customer_name->EditCustomAttributes = "";
			if (!$this->customer_name->Raw)
				$this->customer_name->CurrentValue = HtmlDecode($this->customer_name->CurrentValue);
			$this->customer_name->EditValue = HtmlEncode($this->customer_name->CurrentValue);
			$this->customer_name->PlaceHolder = RemoveHtml($this->customer_name->caption());

			// delivery_date
			$this->delivery_date->EditAttrs["class"] = "form-control";
			$this->delivery_date->EditCustomAttributes = "";
			$this->delivery_date->EditValue = HtmlEncode(FormatDateTime($this->delivery_date->CurrentValue, 8));
			$this->delivery_date->PlaceHolder = RemoveHtml($this->delivery_date->caption());

			// delivery_address
			$this->delivery_address->EditAttrs["class"] = "form-control";
			$this->delivery_address->EditCustomAttributes = "";
			$this->delivery_address->EditValue = HtmlEncode($this->delivery_address->CurrentValue);
			$this->delivery_address->PlaceHolder = RemoveHtml($this->delivery_address->caption());

			// team_id
			$this->team_id->EditAttrs["class"] = "form-control";
			$this->team_id->EditCustomAttributes = "";
			$this->team_id->EditValue = HtmlEncode($this->team_id->CurrentValue);
			$this->team_id->PlaceHolder = RemoveHtml($this->team_id->caption());

			// driver_id
			$this->driver_id->EditAttrs["class"] = "form-control";
			$this->driver_id->EditCustomAttributes = "";
			$this->driver_id->EditValue = HtmlEncode($this->driver_id->CurrentValue);
			$this->driver_id->PlaceHolder = RemoveHtml($this->driver_id->caption());

			// task_lat
			$this->task_lat->EditAttrs["class"] = "form-control";
			$this->task_lat->EditCustomAttributes = "";
			if (!$this->task_lat->Raw)
				$this->task_lat->CurrentValue = HtmlDecode($this->task_lat->CurrentValue);
			$this->task_lat->EditValue = HtmlEncode($this->task_lat->CurrentValue);
			$this->task_lat->PlaceHolder = RemoveHtml($this->task_lat->caption());

			// task_lng
			$this->task_lng->EditAttrs["class"] = "form-control";
			$this->task_lng->EditCustomAttributes = "";
			if (!$this->task_lng->Raw)
				$this->task_lng->CurrentValue = HtmlDecode($this->task_lng->CurrentValue);
			$this->task_lng->EditValue = HtmlEncode($this->task_lng->CurrentValue);
			$this->task_lng->PlaceHolder = RemoveHtml($this->task_lng->caption());

			// customer_signature
			$this->customer_signature->EditAttrs["class"] = "form-control";
			$this->customer_signature->EditCustomAttributes = "";
			if (!$this->customer_signature->Raw)
				$this->customer_signature->CurrentValue = HtmlDecode($this->customer_signature->CurrentValue);
			$this->customer_signature->EditValue = HtmlEncode($this->customer_signature->CurrentValue);
			$this->customer_signature->PlaceHolder = RemoveHtml($this->customer_signature->caption());

			// date_created
			$this->date_created->EditAttrs["class"] = "form-control";
			$this->date_created->EditCustomAttributes = "";
			$this->date_created->EditValue = HtmlEncode(FormatDateTime($this->date_created->CurrentValue, 8));
			$this->date_created->PlaceHolder = RemoveHtml($this->date_created->caption());

			// date_modified
			$this->date_modified->EditAttrs["class"] = "form-control";
			$this->date_modified->EditCustomAttributes = "";
			$this->date_modified->EditValue = HtmlEncode(FormatDateTime($this->date_modified->CurrentValue, 8));
			$this->date_modified->PlaceHolder = RemoveHtml($this->date_modified->caption());

			// ip_address
			$this->ip_address->EditAttrs["class"] = "form-control";
			$this->ip_address->EditCustomAttributes = "";
			if (!$this->ip_address->Raw)
				$this->ip_address->CurrentValue = HtmlDecode($this->ip_address->CurrentValue);
			$this->ip_address->EditValue = HtmlEncode($this->ip_address->CurrentValue);
			$this->ip_address->PlaceHolder = RemoveHtml($this->ip_address->caption());

			// auto_assign_type
			$this->auto_assign_type->EditAttrs["class"] = "form-control";
			$this->auto_assign_type->EditCustomAttributes = "";
			if (!$this->auto_assign_type->Raw)
				$this->auto_assign_type->CurrentValue = HtmlDecode($this->auto_assign_type->CurrentValue);
			$this->auto_assign_type->EditValue = HtmlEncode($this->auto_assign_type->CurrentValue);
			$this->auto_assign_type->PlaceHolder = RemoveHtml($this->auto_assign_type->caption());

			// assign_started
			$this->assign_started->EditAttrs["class"] = "form-control";
			$this->assign_started->EditCustomAttributes = "";
			$this->assign_started->EditValue = HtmlEncode(FormatDateTime($this->assign_started->CurrentValue, 8));
			$this->assign_started->PlaceHolder = RemoveHtml($this->assign_started->caption());

			// assignment_status
			$this->assignment_status->EditAttrs["class"] = "form-control";
			$this->assignment_status->EditCustomAttributes = "";
			if (!$this->assignment_status->Raw)
				$this->assignment_status->CurrentValue = HtmlDecode($this->assignment_status->CurrentValue);
			$this->assignment_status->EditValue = HtmlEncode($this->assignment_status->CurrentValue);
			$this->assignment_status->PlaceHolder = RemoveHtml($this->assignment_status->caption());

			// dropoff_contact_name
			$this->dropoff_contact_name->EditAttrs["class"] = "form-control";
			$this->dropoff_contact_name->EditCustomAttributes = "";
			if (!$this->dropoff_contact_name->Raw)
				$this->dropoff_contact_name->CurrentValue = HtmlDecode($this->dropoff_contact_name->CurrentValue);
			$this->dropoff_contact_name->EditValue = HtmlEncode($this->dropoff_contact_name->CurrentValue);
			$this->dropoff_contact_name->PlaceHolder = RemoveHtml($this->dropoff_contact_name->caption());

			// dropoff_contact_number
			$this->dropoff_contact_number->EditAttrs["class"] = "form-control";
			$this->dropoff_contact_number->EditCustomAttributes = "";
			if (!$this->dropoff_contact_number->Raw)
				$this->dropoff_contact_number->CurrentValue = HtmlDecode($this->dropoff_contact_number->CurrentValue);
			$this->dropoff_contact_number->EditValue = HtmlEncode($this->dropoff_contact_number->CurrentValue);
			$this->dropoff_contact_number->PlaceHolder = RemoveHtml($this->dropoff_contact_number->caption());

			// drop_address
			$this->drop_address->EditAttrs["class"] = "form-control";
			$this->drop_address->EditCustomAttributes = "";
			if (!$this->drop_address->Raw)
				$this->drop_address->CurrentValue = HtmlDecode($this->drop_address->CurrentValue);
			$this->drop_address->EditValue = HtmlEncode($this->drop_address->CurrentValue);
			$this->drop_address->PlaceHolder = RemoveHtml($this->drop_address->caption());

			// dropoff_task_lat
			$this->dropoff_task_lat->EditAttrs["class"] = "form-control";
			$this->dropoff_task_lat->EditCustomAttributes = "";
			if (!$this->dropoff_task_lat->Raw)
				$this->dropoff_task_lat->CurrentValue = HtmlDecode($this->dropoff_task_lat->CurrentValue);
			$this->dropoff_task_lat->EditValue = HtmlEncode($this->dropoff_task_lat->CurrentValue);
			$this->dropoff_task_lat->PlaceHolder = RemoveHtml($this->dropoff_task_lat->caption());

			// dropoff_task_lng
			$this->dropoff_task_lng->EditAttrs["class"] = "form-control";
			$this->dropoff_task_lng->EditCustomAttributes = "";
			if (!$this->dropoff_task_lng->Raw)
				$this->dropoff_task_lng->CurrentValue = HtmlDecode($this->dropoff_task_lng->CurrentValue);
			$this->dropoff_task_lng->EditValue = HtmlEncode($this->dropoff_task_lng->CurrentValue);
			$this->dropoff_task_lng->PlaceHolder = RemoveHtml($this->dropoff_task_lng->caption());

			// task_token
			$this->task_token->EditAttrs["class"] = "form-control";
			$this->task_token->EditCustomAttributes = "";
			if (!$this->task_token->Raw)
				$this->task_token->CurrentValue = HtmlDecode($this->task_token->CurrentValue);
			$this->task_token->EditValue = HtmlEncode($this->task_token->CurrentValue);
			$this->task_token->PlaceHolder = RemoveHtml($this->task_token->caption());

			// ratings
			$this->ratings->EditAttrs["class"] = "form-control";
			$this->ratings->EditCustomAttributes = "";
			if (!$this->ratings->Raw)
				$this->ratings->CurrentValue = HtmlDecode($this->ratings->CurrentValue);
			$this->ratings->EditValue = HtmlEncode($this->ratings->CurrentValue);
			$this->ratings->PlaceHolder = RemoveHtml($this->ratings->caption());

			// rating_comment
			$this->rating_comment->EditAttrs["class"] = "form-control";
			$this->rating_comment->EditCustomAttributes = "";
			if (!$this->rating_comment->Raw)
				$this->rating_comment->CurrentValue = HtmlDecode($this->rating_comment->CurrentValue);
			$this->rating_comment->EditValue = HtmlEncode($this->rating_comment->CurrentValue);
			$this->rating_comment->PlaceHolder = RemoveHtml($this->rating_comment->caption());

			// critical
			$this->critical->EditAttrs["class"] = "form-control";
			$this->critical->EditCustomAttributes = "";
			$this->critical->EditValue = HtmlEncode($this->critical->CurrentValue);
			$this->critical->PlaceHolder = RemoveHtml($this->critical->caption());

			// souce_e
			$this->souce_e->EditAttrs["class"] = "form-control";
			$this->souce_e->EditCustomAttributes = "";
			if (!$this->souce_e->Raw)
				$this->souce_e->CurrentValue = HtmlDecode($this->souce_e->CurrentValue);
			$this->souce_e->EditValue = HtmlEncode($this->souce_e->CurrentValue);
			$this->souce_e->PlaceHolder = RemoveHtml($this->souce_e->caption());

			// shop_code_e
			$this->shop_code_e->EditAttrs["class"] = "form-control";
			$this->shop_code_e->EditCustomAttributes = "";
			if (!$this->shop_code_e->Raw)
				$this->shop_code_e->CurrentValue = HtmlDecode($this->shop_code_e->CurrentValue);
			$this->shop_code_e->EditValue = HtmlEncode($this->shop_code_e->CurrentValue);
			$this->shop_code_e->PlaceHolder = RemoveHtml($this->shop_code_e->caption());

			// Received_Channel_e
			$this->Received_Channel_e->EditAttrs["class"] = "form-control";
			$this->Received_Channel_e->EditCustomAttributes = "";
			if (!$this->Received_Channel_e->Raw)
				$this->Received_Channel_e->CurrentValue = HtmlDecode($this->Received_Channel_e->CurrentValue);
			$this->Received_Channel_e->EditValue = HtmlEncode($this->Received_Channel_e->CurrentValue);
			$this->Received_Channel_e->PlaceHolder = RemoveHtml($this->Received_Channel_e->caption());

			// PayMethod_e
			$this->PayMethod_e->EditAttrs["class"] = "form-control";
			$this->PayMethod_e->EditCustomAttributes = "";
			if (!$this->PayMethod_e->Raw)
				$this->PayMethod_e->CurrentValue = HtmlDecode($this->PayMethod_e->CurrentValue);
			$this->PayMethod_e->EditValue = HtmlEncode($this->PayMethod_e->CurrentValue);
			$this->PayMethod_e->PlaceHolder = RemoveHtml($this->PayMethod_e->caption());

			// Type_e
			$this->Type_e->EditAttrs["class"] = "form-control";
			$this->Type_e->EditCustomAttributes = "";
			if (!$this->Type_e->Raw)
				$this->Type_e->CurrentValue = HtmlDecode($this->Type_e->CurrentValue);
			$this->Type_e->EditValue = HtmlEncode($this->Type_e->CurrentValue);
			$this->Type_e->PlaceHolder = RemoveHtml($this->Type_e->caption());

			// Request_Code_e
			$this->Request_Code_e->EditAttrs["class"] = "form-control";
			$this->Request_Code_e->EditCustomAttributes = "";
			if (!$this->Request_Code_e->Raw)
				$this->Request_Code_e->CurrentValue = HtmlDecode($this->Request_Code_e->CurrentValue);
			$this->Request_Code_e->EditValue = HtmlEncode($this->Request_Code_e->CurrentValue);
			$this->Request_Code_e->PlaceHolder = RemoveHtml($this->Request_Code_e->caption());

			// Status_e
			$this->Status_e->EditAttrs["class"] = "form-control";
			$this->Status_e->EditCustomAttributes = "";
			if (!$this->Status_e->Raw)
				$this->Status_e->CurrentValue = HtmlDecode($this->Status_e->CurrentValue);
			$this->Status_e->EditValue = HtmlEncode($this->Status_e->CurrentValue);
			$this->Status_e->PlaceHolder = RemoveHtml($this->Status_e->caption());

			// PlanType_e
			$this->PlanType_e->EditAttrs["class"] = "form-control";
			$this->PlanType_e->EditCustomAttributes = "";
			if (!$this->PlanType_e->Raw)
				$this->PlanType_e->CurrentValue = HtmlDecode($this->PlanType_e->CurrentValue);
			$this->PlanType_e->EditValue = HtmlEncode($this->PlanType_e->CurrentValue);
			$this->PlanType_e->PlaceHolder = RemoveHtml($this->PlanType_e->caption());

			// Plan_e
			$this->Plan_e->EditAttrs["class"] = "form-control";
			$this->Plan_e->EditCustomAttributes = "";
			if (!$this->Plan_e->Raw)
				$this->Plan_e->CurrentValue = HtmlDecode($this->Plan_e->CurrentValue);
			$this->Plan_e->EditValue = HtmlEncode($this->Plan_e->CurrentValue);
			$this->Plan_e->PlaceHolder = RemoveHtml($this->Plan_e->caption());

			// Isdn_e
			$this->Isdn_e->EditAttrs["class"] = "form-control";
			$this->Isdn_e->EditCustomAttributes = "";
			if (!$this->Isdn_e->Raw)
				$this->Isdn_e->CurrentValue = HtmlDecode($this->Isdn_e->CurrentValue);
			$this->Isdn_e->EditValue = HtmlEncode($this->Isdn_e->CurrentValue);
			$this->Isdn_e->PlaceHolder = RemoveHtml($this->Isdn_e->caption());

			// serial_sim_handset_e
			$this->serial_sim_handset_e->EditAttrs["class"] = "form-control";
			$this->serial_sim_handset_e->EditCustomAttributes = "";
			if (!$this->serial_sim_handset_e->Raw)
				$this->serial_sim_handset_e->CurrentValue = HtmlDecode($this->serial_sim_handset_e->CurrentValue);
			$this->serial_sim_handset_e->EditValue = HtmlEncode($this->serial_sim_handset_e->CurrentValue);
			$this->serial_sim_handset_e->PlaceHolder = RemoveHtml($this->serial_sim_handset_e->caption());

			// handset_e
			$this->handset_e->EditAttrs["class"] = "form-control";
			$this->handset_e->EditCustomAttributes = "";
			if (!$this->handset_e->Raw)
				$this->handset_e->CurrentValue = HtmlDecode($this->handset_e->CurrentValue);
			$this->handset_e->EditValue = HtmlEncode($this->handset_e->CurrentValue);
			$this->handset_e->PlaceHolder = RemoveHtml($this->handset_e->caption());

			// Connect_Reason_e
			$this->Connect_Reason_e->EditAttrs["class"] = "form-control";
			$this->Connect_Reason_e->EditCustomAttributes = "";
			if (!$this->Connect_Reason_e->Raw)
				$this->Connect_Reason_e->CurrentValue = HtmlDecode($this->Connect_Reason_e->CurrentValue);
			$this->Connect_Reason_e->EditValue = HtmlEncode($this->Connect_Reason_e->CurrentValue);
			$this->Connect_Reason_e->PlaceHolder = RemoveHtml($this->Connect_Reason_e->caption());

			// Price_e
			$this->Price_e->EditAttrs["class"] = "form-control";
			$this->Price_e->EditCustomAttributes = "";
			$this->Price_e->EditValue = HtmlEncode($this->Price_e->CurrentValue);
			$this->Price_e->PlaceHolder = RemoveHtml($this->Price_e->caption());
			if (strval($this->Price_e->EditValue) != "" && is_numeric($this->Price_e->EditValue))
				$this->Price_e->EditValue = FormatNumber($this->Price_e->EditValue, -2, -2, -2, -2);
			

			// Current_Operator_e
			$this->Current_Operator_e->EditAttrs["class"] = "form-control";
			$this->Current_Operator_e->EditCustomAttributes = "";
			if (!$this->Current_Operator_e->Raw)
				$this->Current_Operator_e->CurrentValue = HtmlDecode($this->Current_Operator_e->CurrentValue);
			$this->Current_Operator_e->EditValue = HtmlEncode($this->Current_Operator_e->CurrentValue);
			$this->Current_Operator_e->PlaceHolder = RemoveHtml($this->Current_Operator_e->caption());

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->EditAttrs["class"] = "form-control";
			$this->Current_Plan_Type_e->EditCustomAttributes = "";
			if (!$this->Current_Plan_Type_e->Raw)
				$this->Current_Plan_Type_e->CurrentValue = HtmlDecode($this->Current_Plan_Type_e->CurrentValue);
			$this->Current_Plan_Type_e->EditValue = HtmlEncode($this->Current_Plan_Type_e->CurrentValue);
			$this->Current_Plan_Type_e->PlaceHolder = RemoveHtml($this->Current_Plan_Type_e->caption());

			// Document_Number_e
			$this->Document_Number_e->EditAttrs["class"] = "form-control";
			$this->Document_Number_e->EditCustomAttributes = "";
			if (!$this->Document_Number_e->Raw)
				$this->Document_Number_e->CurrentValue = HtmlDecode($this->Document_Number_e->CurrentValue);
			$this->Document_Number_e->EditValue = HtmlEncode($this->Document_Number_e->CurrentValue);
			$this->Document_Number_e->PlaceHolder = RemoveHtml($this->Document_Number_e->caption());

			// Document_Type_e
			$this->Document_Type_e->EditAttrs["class"] = "form-control";
			$this->Document_Type_e->EditCustomAttributes = "";
			if (!$this->Document_Type_e->Raw)
				$this->Document_Type_e->CurrentValue = HtmlDecode($this->Document_Type_e->CurrentValue);
			$this->Document_Type_e->EditValue = HtmlEncode($this->Document_Type_e->CurrentValue);
			$this->Document_Type_e->PlaceHolder = RemoveHtml($this->Document_Type_e->caption());

			// assignStaffCode_e
			$this->assignStaffCode_e->EditAttrs["class"] = "form-control";
			$this->assignStaffCode_e->EditCustomAttributes = "";
			if (!$this->assignStaffCode_e->Raw)
				$this->assignStaffCode_e->CurrentValue = HtmlDecode($this->assignStaffCode_e->CurrentValue);
			$this->assignStaffCode_e->EditValue = HtmlEncode($this->assignStaffCode_e->CurrentValue);
			$this->assignStaffCode_e->PlaceHolder = RemoveHtml($this->assignStaffCode_e->caption());

			// Delivery_Type_e
			$this->Delivery_Type_e->EditAttrs["class"] = "form-control";
			$this->Delivery_Type_e->EditCustomAttributes = "";
			if (!$this->Delivery_Type_e->Raw)
				$this->Delivery_Type_e->CurrentValue = HtmlDecode($this->Delivery_Type_e->CurrentValue);
			$this->Delivery_Type_e->EditValue = HtmlEncode($this->Delivery_Type_e->CurrentValue);
			$this->Delivery_Type_e->PlaceHolder = RemoveHtml($this->Delivery_Type_e->caption());

			// assignStaffType_e
			$this->assignStaffType_e->EditAttrs["class"] = "form-control";
			$this->assignStaffType_e->EditCustomAttributes = "";
			if (!$this->assignStaffType_e->Raw)
				$this->assignStaffType_e->CurrentValue = HtmlDecode($this->assignStaffType_e->CurrentValue);
			$this->assignStaffType_e->EditValue = HtmlEncode($this->assignStaffType_e->CurrentValue);
			$this->assignStaffType_e->PlaceHolder = RemoveHtml($this->assignStaffType_e->caption());

			// receiveStaffCode_e
			$this->receiveStaffCode_e->EditAttrs["class"] = "form-control";
			$this->receiveStaffCode_e->EditCustomAttributes = "";
			if (!$this->receiveStaffCode_e->Raw)
				$this->receiveStaffCode_e->CurrentValue = HtmlDecode($this->receiveStaffCode_e->CurrentValue);
			$this->receiveStaffCode_e->EditValue = HtmlEncode($this->receiveStaffCode_e->CurrentValue);
			$this->receiveStaffCode_e->PlaceHolder = RemoveHtml($this->receiveStaffCode_e->caption());

			// receiveStaffType_e
			$this->receiveStaffType_e->EditAttrs["class"] = "form-control";
			$this->receiveStaffType_e->EditCustomAttributes = "";
			if (!$this->receiveStaffType_e->Raw)
				$this->receiveStaffType_e->CurrentValue = HtmlDecode($this->receiveStaffType_e->CurrentValue);
			$this->receiveStaffType_e->EditValue = HtmlEncode($this->receiveStaffType_e->CurrentValue);
			$this->receiveStaffType_e->PlaceHolder = RemoveHtml($this->receiveStaffType_e->caption());

			// connectStaffCode_e
			$this->connectStaffCode_e->EditAttrs["class"] = "form-control";
			$this->connectStaffCode_e->EditCustomAttributes = "";
			if (!$this->connectStaffCode_e->Raw)
				$this->connectStaffCode_e->CurrentValue = HtmlDecode($this->connectStaffCode_e->CurrentValue);
			$this->connectStaffCode_e->EditValue = HtmlEncode($this->connectStaffCode_e->CurrentValue);
			$this->connectStaffCode_e->PlaceHolder = RemoveHtml($this->connectStaffCode_e->caption());

			// connectStaffType_e
			$this->connectStaffType_e->EditAttrs["class"] = "form-control";
			$this->connectStaffType_e->EditCustomAttributes = "";
			if (!$this->connectStaffType_e->Raw)
				$this->connectStaffType_e->CurrentValue = HtmlDecode($this->connectStaffType_e->CurrentValue);
			$this->connectStaffType_e->EditValue = HtmlEncode($this->connectStaffType_e->CurrentValue);
			$this->connectStaffType_e->PlaceHolder = RemoveHtml($this->connectStaffType_e->caption());

			// shopName_e
			$this->shopName_e->EditAttrs["class"] = "form-control";
			$this->shopName_e->EditCustomAttributes = "";
			if (!$this->shopName_e->Raw)
				$this->shopName_e->CurrentValue = HtmlDecode($this->shopName_e->CurrentValue);
			$this->shopName_e->EditValue = HtmlEncode($this->shopName_e->CurrentValue);
			$this->shopName_e->PlaceHolder = RemoveHtml($this->shopName_e->caption());

			// saleOrderCode_e
			$this->saleOrderCode_e->EditAttrs["class"] = "form-control";
			$this->saleOrderCode_e->EditCustomAttributes = "";
			if (!$this->saleOrderCode_e->Raw)
				$this->saleOrderCode_e->CurrentValue = HtmlDecode($this->saleOrderCode_e->CurrentValue);
			$this->saleOrderCode_e->EditValue = HtmlEncode($this->saleOrderCode_e->CurrentValue);
			$this->saleOrderCode_e->PlaceHolder = RemoveHtml($this->saleOrderCode_e->caption());

			// consultantCode_e
			$this->consultantCode_e->EditAttrs["class"] = "form-control";
			$this->consultantCode_e->EditCustomAttributes = "";
			if (!$this->consultantCode_e->Raw)
				$this->consultantCode_e->CurrentValue = HtmlDecode($this->consultantCode_e->CurrentValue);
			$this->consultantCode_e->EditValue = HtmlEncode($this->consultantCode_e->CurrentValue);
			$this->consultantCode_e->PlaceHolder = RemoveHtml($this->consultantCode_e->caption());

			// consultantName_e
			$this->consultantName_e->EditAttrs["class"] = "form-control";
			$this->consultantName_e->EditCustomAttributes = "";
			if (!$this->consultantName_e->Raw)
				$this->consultantName_e->CurrentValue = HtmlDecode($this->consultantName_e->CurrentValue);
			$this->consultantName_e->EditValue = HtmlEncode($this->consultantName_e->CurrentValue);
			$this->consultantName_e->PlaceHolder = RemoveHtml($this->consultantName_e->caption());

			// consultantType_e
			$this->consultantType_e->EditAttrs["class"] = "form-control";
			$this->consultantType_e->EditCustomAttributes = "";
			if (!$this->consultantType_e->Raw)
				$this->consultantType_e->CurrentValue = HtmlDecode($this->consultantType_e->CurrentValue);
			$this->consultantType_e->EditValue = HtmlEncode($this->consultantType_e->CurrentValue);
			$this->consultantType_e->PlaceHolder = RemoveHtml($this->consultantType_e->caption());

			// created_By_e
			$this->created_By_e->EditAttrs["class"] = "form-control";
			$this->created_By_e->EditCustomAttributes = "";
			if (!$this->created_By_e->Raw)
				$this->created_By_e->CurrentValue = HtmlDecode($this->created_By_e->CurrentValue);
			$this->created_By_e->EditValue = HtmlEncode($this->created_By_e->CurrentValue);
			$this->created_By_e->PlaceHolder = RemoveHtml($this->created_By_e->caption());

			// createdBranch_e
			$this->createdBranch_e->EditAttrs["class"] = "form-control";
			$this->createdBranch_e->EditCustomAttributes = "";
			if (!$this->createdBranch_e->Raw)
				$this->createdBranch_e->CurrentValue = HtmlDecode($this->createdBranch_e->CurrentValue);
			$this->createdBranch_e->EditValue = HtmlEncode($this->createdBranch_e->CurrentValue);
			$this->createdBranch_e->PlaceHolder = RemoveHtml($this->createdBranch_e->caption());

			// generated_Code_By_e
			$this->generated_Code_By_e->EditAttrs["class"] = "form-control";
			$this->generated_Code_By_e->EditCustomAttributes = "";
			if (!$this->generated_Code_By_e->Raw)
				$this->generated_Code_By_e->CurrentValue = HtmlDecode($this->generated_Code_By_e->CurrentValue);
			$this->generated_Code_By_e->EditValue = HtmlEncode($this->generated_Code_By_e->CurrentValue);
			$this->generated_Code_By_e->PlaceHolder = RemoveHtml($this->generated_Code_By_e->caption());

			// approve_Paid_By_e
			$this->approve_Paid_By_e->EditAttrs["class"] = "form-control";
			$this->approve_Paid_By_e->EditCustomAttributes = "";
			if (!$this->approve_Paid_By_e->Raw)
				$this->approve_Paid_By_e->CurrentValue = HtmlDecode($this->approve_Paid_By_e->CurrentValue);
			$this->approve_Paid_By_e->EditValue = HtmlEncode($this->approve_Paid_By_e->CurrentValue);
			$this->approve_Paid_By_e->PlaceHolder = RemoveHtml($this->approve_Paid_By_e->caption());

			// Delivery_Note_e
			$this->Delivery_Note_e->EditAttrs["class"] = "form-control";
			$this->Delivery_Note_e->EditCustomAttributes = "";
			if (!$this->Delivery_Note_e->Raw)
				$this->Delivery_Note_e->CurrentValue = HtmlDecode($this->Delivery_Note_e->CurrentValue);
			$this->Delivery_Note_e->EditValue = HtmlEncode($this->Delivery_Note_e->CurrentValue);
			$this->Delivery_Note_e->PlaceHolder = RemoveHtml($this->Delivery_Note_e->caption());

			// Delivery_Code_e
			$this->Delivery_Code_e->EditAttrs["class"] = "form-control";
			$this->Delivery_Code_e->EditCustomAttributes = "";
			if (!$this->Delivery_Code_e->Raw)
				$this->Delivery_Code_e->CurrentValue = HtmlDecode($this->Delivery_Code_e->CurrentValue);
			$this->Delivery_Code_e->EditValue = HtmlEncode($this->Delivery_Code_e->CurrentValue);
			$this->Delivery_Code_e->PlaceHolder = RemoveHtml($this->Delivery_Code_e->caption());

			// Customer_Note_e
			$this->Customer_Note_e->EditAttrs["class"] = "form-control";
			$this->Customer_Note_e->EditCustomAttributes = "";
			if (!$this->Customer_Note_e->Raw)
				$this->Customer_Note_e->CurrentValue = HtmlDecode($this->Customer_Note_e->CurrentValue);
			$this->Customer_Note_e->EditValue = HtmlEncode($this->Customer_Note_e->CurrentValue);
			$this->Customer_Note_e->PlaceHolder = RemoveHtml($this->Customer_Note_e->caption());

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->EditAttrs["class"] = "form-control";
			$this->saleOrderCreateDate_e->EditCustomAttributes = "";
			if (!$this->saleOrderCreateDate_e->Raw)
				$this->saleOrderCreateDate_e->CurrentValue = HtmlDecode($this->saleOrderCreateDate_e->CurrentValue);
			$this->saleOrderCreateDate_e->EditValue = HtmlEncode($this->saleOrderCreateDate_e->CurrentValue);
			$this->saleOrderCreateDate_e->PlaceHolder = RemoveHtml($this->saleOrderCreateDate_e->caption());

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->EditAttrs["class"] = "form-control";
			$this->saleOrderPayDate_e->EditCustomAttributes = "";
			if (!$this->saleOrderPayDate_e->Raw)
				$this->saleOrderPayDate_e->CurrentValue = HtmlDecode($this->saleOrderPayDate_e->CurrentValue);
			$this->saleOrderPayDate_e->EditValue = HtmlEncode($this->saleOrderPayDate_e->CurrentValue);
			$this->saleOrderPayDate_e->PlaceHolder = RemoveHtml($this->saleOrderPayDate_e->caption());

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->EditAttrs["class"] = "form-control";
			$this->Time_of_Procesing_e->EditCustomAttributes = "";
			if (!$this->Time_of_Procesing_e->Raw)
				$this->Time_of_Procesing_e->CurrentValue = HtmlDecode($this->Time_of_Procesing_e->CurrentValue);
			$this->Time_of_Procesing_e->EditValue = HtmlEncode($this->Time_of_Procesing_e->CurrentValue);
			$this->Time_of_Procesing_e->PlaceHolder = RemoveHtml($this->Time_of_Procesing_e->caption());

			// Time_of_new_e
			$this->Time_of_new_e->EditAttrs["class"] = "form-control";
			$this->Time_of_new_e->EditCustomAttributes = "";
			if (!$this->Time_of_new_e->Raw)
				$this->Time_of_new_e->CurrentValue = HtmlDecode($this->Time_of_new_e->CurrentValue);
			$this->Time_of_new_e->EditValue = HtmlEncode($this->Time_of_new_e->CurrentValue);
			$this->Time_of_new_e->PlaceHolder = RemoveHtml($this->Time_of_new_e->caption());

			// Time_of_Finished_e
			$this->Time_of_Finished_e->EditAttrs["class"] = "form-control";
			$this->Time_of_Finished_e->EditCustomAttributes = "";
			if (!$this->Time_of_Finished_e->Raw)
				$this->Time_of_Finished_e->CurrentValue = HtmlDecode($this->Time_of_Finished_e->CurrentValue);
			$this->Time_of_Finished_e->EditValue = HtmlEncode($this->Time_of_Finished_e->CurrentValue);
			$this->Time_of_Finished_e->PlaceHolder = RemoveHtml($this->Time_of_Finished_e->caption());

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->EditAttrs["class"] = "form-control";
			$this->KPI_CC_Hour_e->EditCustomAttributes = "";
			if (!$this->KPI_CC_Hour_e->Raw)
				$this->KPI_CC_Hour_e->CurrentValue = HtmlDecode($this->KPI_CC_Hour_e->CurrentValue);
			$this->KPI_CC_Hour_e->EditValue = HtmlEncode($this->KPI_CC_Hour_e->CurrentValue);
			$this->KPI_CC_Hour_e->PlaceHolder = RemoveHtml($this->KPI_CC_Hour_e->caption());

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->EditAttrs["class"] = "form-control";
			$this->KPI_NEW_Hour_e->EditCustomAttributes = "";
			if (!$this->KPI_NEW_Hour_e->Raw)
				$this->KPI_NEW_Hour_e->CurrentValue = HtmlDecode($this->KPI_NEW_Hour_e->CurrentValue);
			$this->KPI_NEW_Hour_e->EditValue = HtmlEncode($this->KPI_NEW_Hour_e->CurrentValue);
			$this->KPI_NEW_Hour_e->PlaceHolder = RemoveHtml($this->KPI_NEW_Hour_e->caption());

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->EditAttrs["class"] = "form-control";
			$this->KPI_PROCESING_Hour_e->EditCustomAttributes = "";
			if (!$this->KPI_PROCESING_Hour_e->Raw)
				$this->KPI_PROCESING_Hour_e->CurrentValue = HtmlDecode($this->KPI_PROCESING_Hour_e->CurrentValue);
			$this->KPI_PROCESING_Hour_e->EditValue = HtmlEncode($this->KPI_PROCESING_Hour_e->CurrentValue);
			$this->KPI_PROCESING_Hour_e->PlaceHolder = RemoveHtml($this->KPI_PROCESING_Hour_e->caption());

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->EditAttrs["class"] = "form-control";
			$this->KPI_ALL_Hour_e->EditCustomAttributes = "";
			if (!$this->KPI_ALL_Hour_e->Raw)
				$this->KPI_ALL_Hour_e->CurrentValue = HtmlDecode($this->KPI_ALL_Hour_e->CurrentValue);
			$this->KPI_ALL_Hour_e->EditValue = HtmlEncode($this->KPI_ALL_Hour_e->CurrentValue);
			$this->KPI_ALL_Hour_e->PlaceHolder = RemoveHtml($this->KPI_ALL_Hour_e->caption());

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->EditAttrs["class"] = "form-control";
			$this->Kpi_Register_Hour_e->EditCustomAttributes = "";
			if (!$this->Kpi_Register_Hour_e->Raw)
				$this->Kpi_Register_Hour_e->CurrentValue = HtmlDecode($this->Kpi_Register_Hour_e->CurrentValue);
			$this->Kpi_Register_Hour_e->EditValue = HtmlEncode($this->Kpi_Register_Hour_e->CurrentValue);
			$this->Kpi_Register_Hour_e->PlaceHolder = RemoveHtml($this->Kpi_Register_Hour_e->caption());

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->EditAttrs["class"] = "form-control";
			$this->Kpi_Bitel_Hour_e->EditCustomAttributes = "";
			if (!$this->Kpi_Bitel_Hour_e->Raw)
				$this->Kpi_Bitel_Hour_e->CurrentValue = HtmlDecode($this->Kpi_Bitel_Hour_e->CurrentValue);
			$this->Kpi_Bitel_Hour_e->EditValue = HtmlEncode($this->Kpi_Bitel_Hour_e->CurrentValue);
			$this->Kpi_Bitel_Hour_e->PlaceHolder = RemoveHtml($this->Kpi_Bitel_Hour_e->caption());

			// AmountGB_e
			$this->AmountGB_e->EditAttrs["class"] = "form-control";
			$this->AmountGB_e->EditCustomAttributes = "";
			if (!$this->AmountGB_e->Raw)
				$this->AmountGB_e->CurrentValue = HtmlDecode($this->AmountGB_e->CurrentValue);
			$this->AmountGB_e->EditValue = HtmlEncode($this->AmountGB_e->CurrentValue);
			$this->AmountGB_e->PlaceHolder = RemoveHtml($this->AmountGB_e->caption());

			// Price_1_e
			$this->Price_1_e->EditAttrs["class"] = "form-control";
			$this->Price_1_e->EditCustomAttributes = "";
			if (!$this->Price_1_e->Raw)
				$this->Price_1_e->CurrentValue = HtmlDecode($this->Price_1_e->CurrentValue);
			$this->Price_1_e->EditValue = HtmlEncode($this->Price_1_e->CurrentValue);
			$this->Price_1_e->PlaceHolder = RemoveHtml($this->Price_1_e->caption());

			// Status_1_e
			$this->Status_1_e->EditAttrs["class"] = "form-control";
			$this->Status_1_e->EditCustomAttributes = "";
			if (!$this->Status_1_e->Raw)
				$this->Status_1_e->CurrentValue = HtmlDecode($this->Status_1_e->CurrentValue);
			$this->Status_1_e->EditValue = HtmlEncode($this->Status_1_e->CurrentValue);
			$this->Status_1_e->PlaceHolder = RemoveHtml($this->Status_1_e->caption());

			// Registered_Date_e
			$this->Registered_Date_e->EditAttrs["class"] = "form-control";
			$this->Registered_Date_e->EditCustomAttributes = "";
			if (!$this->Registered_Date_e->Raw)
				$this->Registered_Date_e->CurrentValue = HtmlDecode($this->Registered_Date_e->CurrentValue);
			$this->Registered_Date_e->EditValue = HtmlEncode($this->Registered_Date_e->CurrentValue);
			$this->Registered_Date_e->PlaceHolder = RemoveHtml($this->Registered_Date_e->caption());

			// Sumary_e
			$this->Sumary_e->EditAttrs["class"] = "form-control";
			$this->Sumary_e->EditCustomAttributes = "";
			if (!$this->Sumary_e->Raw)
				$this->Sumary_e->CurrentValue = HtmlDecode($this->Sumary_e->CurrentValue);
			$this->Sumary_e->EditValue = HtmlEncode($this->Sumary_e->CurrentValue);
			$this->Sumary_e->PlaceHolder = RemoveHtml($this->Sumary_e->caption());

			// Plans_e
			$this->Plans_e->EditAttrs["class"] = "form-control";
			$this->Plans_e->EditCustomAttributes = "";
			if (!$this->Plans_e->Raw)
				$this->Plans_e->CurrentValue = HtmlDecode($this->Plans_e->CurrentValue);
			$this->Plans_e->EditValue = HtmlEncode($this->Plans_e->CurrentValue);
			$this->Plans_e->PlaceHolder = RemoveHtml($this->Plans_e->caption());

			// Isdns_e
			$this->Isdns_e->EditAttrs["class"] = "form-control";
			$this->Isdns_e->EditCustomAttributes = "";
			if (!$this->Isdns_e->Raw)
				$this->Isdns_e->CurrentValue = HtmlDecode($this->Isdns_e->CurrentValue);
			$this->Isdns_e->EditValue = HtmlEncode($this->Isdns_e->CurrentValue);
			$this->Isdns_e->PlaceHolder = RemoveHtml($this->Isdns_e->caption());

			// PlanTypes_e
			$this->PlanTypes_e->EditAttrs["class"] = "form-control";
			$this->PlanTypes_e->EditCustomAttributes = "";
			if (!$this->PlanTypes_e->Raw)
				$this->PlanTypes_e->CurrentValue = HtmlDecode($this->PlanTypes_e->CurrentValue);
			$this->PlanTypes_e->EditValue = HtmlEncode($this->PlanTypes_e->CurrentValue);
			$this->PlanTypes_e->PlaceHolder = RemoveHtml($this->PlanTypes_e->caption());

			// Serials_e
			$this->Serials_e->EditAttrs["class"] = "form-control";
			$this->Serials_e->EditCustomAttributes = "";
			if (!$this->Serials_e->Raw)
				$this->Serials_e->CurrentValue = HtmlDecode($this->Serials_e->CurrentValue);
			$this->Serials_e->EditValue = HtmlEncode($this->Serials_e->CurrentValue);
			$this->Serials_e->PlaceHolder = RemoveHtml($this->Serials_e->caption());

			// Status_2_e
			$this->Status_2_e->EditAttrs["class"] = "form-control";
			$this->Status_2_e->EditCustomAttributes = "";
			if (!$this->Status_2_e->Raw)
				$this->Status_2_e->CurrentValue = HtmlDecode($this->Status_2_e->CurrentValue);
			$this->Status_2_e->EditValue = HtmlEncode($this->Status_2_e->CurrentValue);
			$this->Status_2_e->PlaceHolder = RemoveHtml($this->Status_2_e->caption());

			// Registered_Date_2_e
			$this->Registered_Date_2_e->EditAttrs["class"] = "form-control";
			$this->Registered_Date_2_e->EditCustomAttributes = "";
			if (!$this->Registered_Date_2_e->Raw)
				$this->Registered_Date_2_e->CurrentValue = HtmlDecode($this->Registered_Date_2_e->CurrentValue);
			$this->Registered_Date_2_e->EditValue = HtmlEncode($this->Registered_Date_2_e->CurrentValue);
			$this->Registered_Date_2_e->PlaceHolder = RemoveHtml($this->Registered_Date_2_e->caption());

			// Summary_2_e
			$this->Summary_2_e->EditAttrs["class"] = "form-control";
			$this->Summary_2_e->EditCustomAttributes = "";
			if (!$this->Summary_2_e->Raw)
				$this->Summary_2_e->CurrentValue = HtmlDecode($this->Summary_2_e->CurrentValue);
			$this->Summary_2_e->EditValue = HtmlEncode($this->Summary_2_e->CurrentValue);
			$this->Summary_2_e->PlaceHolder = RemoveHtml($this->Summary_2_e->caption());

			// serial_2_e
			$this->serial_2_e->EditAttrs["class"] = "form-control";
			$this->serial_2_e->EditCustomAttributes = "";
			if (!$this->serial_2_e->Raw)
				$this->serial_2_e->CurrentValue = HtmlDecode($this->serial_2_e->CurrentValue);
			$this->serial_2_e->EditValue = HtmlEncode($this->serial_2_e->CurrentValue);
			$this->serial_2_e->PlaceHolder = RemoveHtml($this->serial_2_e->caption());

			// HandsetCode_e
			$this->HandsetCode_e->EditAttrs["class"] = "form-control";
			$this->HandsetCode_e->EditCustomAttributes = "";
			if (!$this->HandsetCode_e->Raw)
				$this->HandsetCode_e->CurrentValue = HtmlDecode($this->HandsetCode_e->CurrentValue);
			$this->HandsetCode_e->EditValue = HtmlEncode($this->HandsetCode_e->CurrentValue);
			$this->HandsetCode_e->PlaceHolder = RemoveHtml($this->HandsetCode_e->caption());

			// HandsetName_e
			$this->HandsetName_e->EditAttrs["class"] = "form-control";
			$this->HandsetName_e->EditCustomAttributes = "";
			if (!$this->HandsetName_e->Raw)
				$this->HandsetName_e->CurrentValue = HtmlDecode($this->HandsetName_e->CurrentValue);
			$this->HandsetName_e->EditValue = HtmlEncode($this->HandsetName_e->CurrentValue);
			$this->HandsetName_e->PlaceHolder = RemoveHtml($this->HandsetName_e->caption());

			// Status_3_e
			$this->Status_3_e->EditAttrs["class"] = "form-control";
			$this->Status_3_e->EditCustomAttributes = "";
			if (!$this->Status_3_e->Raw)
				$this->Status_3_e->CurrentValue = HtmlDecode($this->Status_3_e->CurrentValue);
			$this->Status_3_e->EditValue = HtmlEncode($this->Status_3_e->CurrentValue);
			$this->Status_3_e->PlaceHolder = RemoveHtml($this->Status_3_e->caption());

			// Summary_3_e
			$this->Summary_3_e->EditAttrs["class"] = "form-control";
			$this->Summary_3_e->EditCustomAttributes = "";
			if (!$this->Summary_3_e->Raw)
				$this->Summary_3_e->CurrentValue = HtmlDecode($this->Summary_3_e->CurrentValue);
			$this->Summary_3_e->EditValue = HtmlEncode($this->Summary_3_e->CurrentValue);
			$this->Summary_3_e->PlaceHolder = RemoveHtml($this->Summary_3_e->caption());

			// fecha_activa_e
			$this->fecha_activa_e->EditAttrs["class"] = "form-control";
			$this->fecha_activa_e->EditCustomAttributes = "";
			if (!$this->fecha_activa_e->Raw)
				$this->fecha_activa_e->CurrentValue = HtmlDecode($this->fecha_activa_e->CurrentValue);
			$this->fecha_activa_e->EditValue = HtmlEncode($this->fecha_activa_e->CurrentValue);
			$this->fecha_activa_e->PlaceHolder = RemoveHtml($this->fecha_activa_e->caption());

			// mes_activa_e
			$this->mes_activa_e->EditAttrs["class"] = "form-control";
			$this->mes_activa_e->EditCustomAttributes = "";
			if (!$this->mes_activa_e->Raw)
				$this->mes_activa_e->CurrentValue = HtmlDecode($this->mes_activa_e->CurrentValue);
			$this->mes_activa_e->EditValue = HtmlEncode($this->mes_activa_e->CurrentValue);
			$this->mes_activa_e->PlaceHolder = RemoveHtml($this->mes_activa_e->caption());

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->EditAttrs["class"] = "form-control";
			$this->SOURCE_OUT_e->EditCustomAttributes = "";
			if (!$this->SOURCE_OUT_e->Raw)
				$this->SOURCE_OUT_e->CurrentValue = HtmlDecode($this->SOURCE_OUT_e->CurrentValue);
			$this->SOURCE_OUT_e->EditValue = HtmlEncode($this->SOURCE_OUT_e->CurrentValue);
			$this->SOURCE_OUT_e->PlaceHolder = RemoveHtml($this->SOURCE_OUT_e->caption());

			// fecha_crea_e
			$this->fecha_crea_e->EditAttrs["class"] = "form-control";
			$this->fecha_crea_e->EditCustomAttributes = "";
			if (!$this->fecha_crea_e->Raw)
				$this->fecha_crea_e->CurrentValue = HtmlDecode($this->fecha_crea_e->CurrentValue);
			$this->fecha_crea_e->EditValue = HtmlEncode($this->fecha_crea_e->CurrentValue);
			$this->fecha_crea_e->PlaceHolder = RemoveHtml($this->fecha_crea_e->caption());

			// mes_crea_e
			$this->mes_crea_e->EditAttrs["class"] = "form-control";
			$this->mes_crea_e->EditCustomAttributes = "";
			if (!$this->mes_crea_e->Raw)
				$this->mes_crea_e->CurrentValue = HtmlDecode($this->mes_crea_e->CurrentValue);
			$this->mes_crea_e->EditValue = HtmlEncode($this->mes_crea_e->CurrentValue);
			$this->mes_crea_e->PlaceHolder = RemoveHtml($this->mes_crea_e->caption());

			// moto_e
			$this->moto_e->EditAttrs["class"] = "form-control";
			$this->moto_e->EditCustomAttributes = "";
			if (!$this->moto_e->Raw)
				$this->moto_e->CurrentValue = HtmlDecode($this->moto_e->CurrentValue);
			$this->moto_e->EditValue = HtmlEncode($this->moto_e->CurrentValue);
			$this->moto_e->PlaceHolder = RemoveHtml($this->moto_e->caption());

			// customer_id
			$this->customer_id->EditAttrs["class"] = "form-control";
			$this->customer_id->EditCustomAttributes = "";
			$this->customer_id->EditValue = HtmlEncode($this->customer_id->CurrentValue);
			$this->customer_id->PlaceHolder = RemoveHtml($this->customer_id->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (!$this->status->Raw)
				$this->status->CurrentValue = HtmlDecode($this->status->CurrentValue);
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// address_e
			$this->address_e->EditAttrs["class"] = "form-control";
			$this->address_e->EditCustomAttributes = "";
			$this->address_e->EditValue = HtmlEncode($this->address_e->CurrentValue);
			$this->address_e->PlaceHolder = RemoveHtml($this->address_e->caption());

			// branch_e
			$this->branch_e->EditAttrs["class"] = "form-control";
			$this->branch_e->EditCustomAttributes = "";
			if (!$this->branch_e->Raw)
				$this->branch_e->CurrentValue = HtmlDecode($this->branch_e->CurrentValue);
			$this->branch_e->EditValue = HtmlEncode($this->branch_e->CurrentValue);
			$this->branch_e->PlaceHolder = RemoveHtml($this->branch_e->caption());

			// CreatedTime_e
			$this->CreatedTime_e->EditAttrs["class"] = "form-control";
			$this->CreatedTime_e->EditCustomAttributes = "";
			$this->CreatedTime_e->EditValue = HtmlEncode(FormatDateTime($this->CreatedTime_e->CurrentValue, 8));
			$this->CreatedTime_e->PlaceHolder = RemoveHtml($this->CreatedTime_e->caption());

			// Status_n
			$this->Status_n->EditAttrs["class"] = "form-control";
			$this->Status_n->EditCustomAttributes = "";
			$this->Status_n->EditValue = HtmlEncode($this->Status_n->CurrentValue);
			$this->Status_n->PlaceHolder = RemoveHtml($this->Status_n->caption());

			// Add refer script
			// task_description

			$this->task_description->LinkCustomAttributes = "";
			$this->task_description->HrefValue = "";

			// trans_type
			$this->trans_type->LinkCustomAttributes = "";
			$this->trans_type->HrefValue = "";

			// contact_number
			$this->contact_number->LinkCustomAttributes = "";
			$this->contact_number->HrefValue = "";

			// email_address
			$this->email_address->LinkCustomAttributes = "";
			$this->email_address->HrefValue = "";

			// customer_name
			$this->customer_name->LinkCustomAttributes = "";
			$this->customer_name->HrefValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";

			// delivery_address
			$this->delivery_address->LinkCustomAttributes = "";
			$this->delivery_address->HrefValue = "";

			// team_id
			$this->team_id->LinkCustomAttributes = "";
			$this->team_id->HrefValue = "";

			// driver_id
			$this->driver_id->LinkCustomAttributes = "";
			$this->driver_id->HrefValue = "";

			// task_lat
			$this->task_lat->LinkCustomAttributes = "";
			$this->task_lat->HrefValue = "";

			// task_lng
			$this->task_lng->LinkCustomAttributes = "";
			$this->task_lng->HrefValue = "";

			// customer_signature
			$this->customer_signature->LinkCustomAttributes = "";
			$this->customer_signature->HrefValue = "";

			// date_created
			$this->date_created->LinkCustomAttributes = "";
			$this->date_created->HrefValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";

			// ip_address
			$this->ip_address->LinkCustomAttributes = "";
			$this->ip_address->HrefValue = "";

			// auto_assign_type
			$this->auto_assign_type->LinkCustomAttributes = "";
			$this->auto_assign_type->HrefValue = "";

			// assign_started
			$this->assign_started->LinkCustomAttributes = "";
			$this->assign_started->HrefValue = "";

			// assignment_status
			$this->assignment_status->LinkCustomAttributes = "";
			$this->assignment_status->HrefValue = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->LinkCustomAttributes = "";
			$this->dropoff_contact_name->HrefValue = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->LinkCustomAttributes = "";
			$this->dropoff_contact_number->HrefValue = "";

			// drop_address
			$this->drop_address->LinkCustomAttributes = "";
			$this->drop_address->HrefValue = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->LinkCustomAttributes = "";
			$this->dropoff_task_lat->HrefValue = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->LinkCustomAttributes = "";
			$this->dropoff_task_lng->HrefValue = "";

			// task_token
			$this->task_token->LinkCustomAttributes = "";
			$this->task_token->HrefValue = "";

			// ratings
			$this->ratings->LinkCustomAttributes = "";
			$this->ratings->HrefValue = "";

			// rating_comment
			$this->rating_comment->LinkCustomAttributes = "";
			$this->rating_comment->HrefValue = "";

			// critical
			$this->critical->LinkCustomAttributes = "";
			$this->critical->HrefValue = "";

			// souce_e
			$this->souce_e->LinkCustomAttributes = "";
			$this->souce_e->HrefValue = "";

			// shop_code_e
			$this->shop_code_e->LinkCustomAttributes = "";
			$this->shop_code_e->HrefValue = "";

			// Received_Channel_e
			$this->Received_Channel_e->LinkCustomAttributes = "";
			$this->Received_Channel_e->HrefValue = "";

			// PayMethod_e
			$this->PayMethod_e->LinkCustomAttributes = "";
			$this->PayMethod_e->HrefValue = "";

			// Type_e
			$this->Type_e->LinkCustomAttributes = "";
			$this->Type_e->HrefValue = "";

			// Request_Code_e
			$this->Request_Code_e->LinkCustomAttributes = "";
			$this->Request_Code_e->HrefValue = "";

			// Status_e
			$this->Status_e->LinkCustomAttributes = "";
			$this->Status_e->HrefValue = "";

			// PlanType_e
			$this->PlanType_e->LinkCustomAttributes = "";
			$this->PlanType_e->HrefValue = "";

			// Plan_e
			$this->Plan_e->LinkCustomAttributes = "";
			$this->Plan_e->HrefValue = "";

			// Isdn_e
			$this->Isdn_e->LinkCustomAttributes = "";
			$this->Isdn_e->HrefValue = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->LinkCustomAttributes = "";
			$this->serial_sim_handset_e->HrefValue = "";

			// handset_e
			$this->handset_e->LinkCustomAttributes = "";
			$this->handset_e->HrefValue = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->LinkCustomAttributes = "";
			$this->Connect_Reason_e->HrefValue = "";

			// Price_e
			$this->Price_e->LinkCustomAttributes = "";
			$this->Price_e->HrefValue = "";

			// Current_Operator_e
			$this->Current_Operator_e->LinkCustomAttributes = "";
			$this->Current_Operator_e->HrefValue = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->LinkCustomAttributes = "";
			$this->Current_Plan_Type_e->HrefValue = "";

			// Document_Number_e
			$this->Document_Number_e->LinkCustomAttributes = "";
			$this->Document_Number_e->HrefValue = "";

			// Document_Type_e
			$this->Document_Type_e->LinkCustomAttributes = "";
			$this->Document_Type_e->HrefValue = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->LinkCustomAttributes = "";
			$this->assignStaffCode_e->HrefValue = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->LinkCustomAttributes = "";
			$this->Delivery_Type_e->HrefValue = "";

			// assignStaffType_e
			$this->assignStaffType_e->LinkCustomAttributes = "";
			$this->assignStaffType_e->HrefValue = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->LinkCustomAttributes = "";
			$this->receiveStaffCode_e->HrefValue = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->LinkCustomAttributes = "";
			$this->receiveStaffType_e->HrefValue = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->LinkCustomAttributes = "";
			$this->connectStaffCode_e->HrefValue = "";

			// connectStaffType_e
			$this->connectStaffType_e->LinkCustomAttributes = "";
			$this->connectStaffType_e->HrefValue = "";

			// shopName_e
			$this->shopName_e->LinkCustomAttributes = "";
			$this->shopName_e->HrefValue = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->LinkCustomAttributes = "";
			$this->saleOrderCode_e->HrefValue = "";

			// consultantCode_e
			$this->consultantCode_e->LinkCustomAttributes = "";
			$this->consultantCode_e->HrefValue = "";

			// consultantName_e
			$this->consultantName_e->LinkCustomAttributes = "";
			$this->consultantName_e->HrefValue = "";

			// consultantType_e
			$this->consultantType_e->LinkCustomAttributes = "";
			$this->consultantType_e->HrefValue = "";

			// created_By_e
			$this->created_By_e->LinkCustomAttributes = "";
			$this->created_By_e->HrefValue = "";

			// createdBranch_e
			$this->createdBranch_e->LinkCustomAttributes = "";
			$this->createdBranch_e->HrefValue = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->LinkCustomAttributes = "";
			$this->generated_Code_By_e->HrefValue = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->LinkCustomAttributes = "";
			$this->approve_Paid_By_e->HrefValue = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->LinkCustomAttributes = "";
			$this->Delivery_Note_e->HrefValue = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->LinkCustomAttributes = "";
			$this->Delivery_Code_e->HrefValue = "";

			// Customer_Note_e
			$this->Customer_Note_e->LinkCustomAttributes = "";
			$this->Customer_Note_e->HrefValue = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->LinkCustomAttributes = "";
			$this->saleOrderCreateDate_e->HrefValue = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->LinkCustomAttributes = "";
			$this->saleOrderPayDate_e->HrefValue = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->LinkCustomAttributes = "";
			$this->Time_of_Procesing_e->HrefValue = "";

			// Time_of_new_e
			$this->Time_of_new_e->LinkCustomAttributes = "";
			$this->Time_of_new_e->HrefValue = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->LinkCustomAttributes = "";
			$this->Time_of_Finished_e->HrefValue = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->LinkCustomAttributes = "";
			$this->KPI_CC_Hour_e->HrefValue = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->LinkCustomAttributes = "";
			$this->KPI_NEW_Hour_e->HrefValue = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->LinkCustomAttributes = "";
			$this->KPI_PROCESING_Hour_e->HrefValue = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->LinkCustomAttributes = "";
			$this->KPI_ALL_Hour_e->HrefValue = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Register_Hour_e->HrefValue = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Bitel_Hour_e->HrefValue = "";

			// AmountGB_e
			$this->AmountGB_e->LinkCustomAttributes = "";
			$this->AmountGB_e->HrefValue = "";

			// Price_1_e
			$this->Price_1_e->LinkCustomAttributes = "";
			$this->Price_1_e->HrefValue = "";

			// Status_1_e
			$this->Status_1_e->LinkCustomAttributes = "";
			$this->Status_1_e->HrefValue = "";

			// Registered_Date_e
			$this->Registered_Date_e->LinkCustomAttributes = "";
			$this->Registered_Date_e->HrefValue = "";

			// Sumary_e
			$this->Sumary_e->LinkCustomAttributes = "";
			$this->Sumary_e->HrefValue = "";

			// Plans_e
			$this->Plans_e->LinkCustomAttributes = "";
			$this->Plans_e->HrefValue = "";

			// Isdns_e
			$this->Isdns_e->LinkCustomAttributes = "";
			$this->Isdns_e->HrefValue = "";

			// PlanTypes_e
			$this->PlanTypes_e->LinkCustomAttributes = "";
			$this->PlanTypes_e->HrefValue = "";

			// Serials_e
			$this->Serials_e->LinkCustomAttributes = "";
			$this->Serials_e->HrefValue = "";

			// Status_2_e
			$this->Status_2_e->LinkCustomAttributes = "";
			$this->Status_2_e->HrefValue = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->LinkCustomAttributes = "";
			$this->Registered_Date_2_e->HrefValue = "";

			// Summary_2_e
			$this->Summary_2_e->LinkCustomAttributes = "";
			$this->Summary_2_e->HrefValue = "";

			// serial_2_e
			$this->serial_2_e->LinkCustomAttributes = "";
			$this->serial_2_e->HrefValue = "";

			// HandsetCode_e
			$this->HandsetCode_e->LinkCustomAttributes = "";
			$this->HandsetCode_e->HrefValue = "";

			// HandsetName_e
			$this->HandsetName_e->LinkCustomAttributes = "";
			$this->HandsetName_e->HrefValue = "";

			// Status_3_e
			$this->Status_3_e->LinkCustomAttributes = "";
			$this->Status_3_e->HrefValue = "";

			// Summary_3_e
			$this->Summary_3_e->LinkCustomAttributes = "";
			$this->Summary_3_e->HrefValue = "";

			// fecha_activa_e
			$this->fecha_activa_e->LinkCustomAttributes = "";
			$this->fecha_activa_e->HrefValue = "";

			// mes_activa_e
			$this->mes_activa_e->LinkCustomAttributes = "";
			$this->mes_activa_e->HrefValue = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->LinkCustomAttributes = "";
			$this->SOURCE_OUT_e->HrefValue = "";

			// fecha_crea_e
			$this->fecha_crea_e->LinkCustomAttributes = "";
			$this->fecha_crea_e->HrefValue = "";

			// mes_crea_e
			$this->mes_crea_e->LinkCustomAttributes = "";
			$this->mes_crea_e->HrefValue = "";

			// moto_e
			$this->moto_e->LinkCustomAttributes = "";
			$this->moto_e->HrefValue = "";

			// customer_id
			$this->customer_id->LinkCustomAttributes = "";
			$this->customer_id->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// address_e
			$this->address_e->LinkCustomAttributes = "";
			$this->address_e->HrefValue = "";

			// branch_e
			$this->branch_e->LinkCustomAttributes = "";
			$this->branch_e->HrefValue = "";

			// CreatedTime_e
			$this->CreatedTime_e->LinkCustomAttributes = "";
			$this->CreatedTime_e->HrefValue = "";

			// Status_n
			$this->Status_n->LinkCustomAttributes = "";
			$this->Status_n->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->task_description->Required) {
			if (!$this->task_description->IsDetailKey && $this->task_description->FormValue != NULL && $this->task_description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->task_description->caption(), $this->task_description->RequiredErrorMessage));
			}
		}
		if ($this->trans_type->Required) {
			if (!$this->trans_type->IsDetailKey && $this->trans_type->FormValue != NULL && $this->trans_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->trans_type->caption(), $this->trans_type->RequiredErrorMessage));
			}
		}
		if ($this->contact_number->Required) {
			if (!$this->contact_number->IsDetailKey && $this->contact_number->FormValue != NULL && $this->contact_number->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->contact_number->caption(), $this->contact_number->RequiredErrorMessage));
			}
		}
		if ($this->email_address->Required) {
			if (!$this->email_address->IsDetailKey && $this->email_address->FormValue != NULL && $this->email_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->email_address->caption(), $this->email_address->RequiredErrorMessage));
			}
		}
		if ($this->customer_name->Required) {
			if (!$this->customer_name->IsDetailKey && $this->customer_name->FormValue != NULL && $this->customer_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->customer_name->caption(), $this->customer_name->RequiredErrorMessage));
			}
		}
		if ($this->delivery_date->Required) {
			if (!$this->delivery_date->IsDetailKey && $this->delivery_date->FormValue != NULL && $this->delivery_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_date->caption(), $this->delivery_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->delivery_date->FormValue)) {
			AddMessage($FormError, $this->delivery_date->errorMessage());
		}
		if ($this->delivery_address->Required) {
			if (!$this->delivery_address->IsDetailKey && $this->delivery_address->FormValue != NULL && $this->delivery_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_address->caption(), $this->delivery_address->RequiredErrorMessage));
			}
		}
		if ($this->team_id->Required) {
			if (!$this->team_id->IsDetailKey && $this->team_id->FormValue != NULL && $this->team_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->team_id->caption(), $this->team_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->team_id->FormValue)) {
			AddMessage($FormError, $this->team_id->errorMessage());
		}
		if ($this->driver_id->Required) {
			if (!$this->driver_id->IsDetailKey && $this->driver_id->FormValue != NULL && $this->driver_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_id->caption(), $this->driver_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->driver_id->FormValue)) {
			AddMessage($FormError, $this->driver_id->errorMessage());
		}
		if ($this->task_lat->Required) {
			if (!$this->task_lat->IsDetailKey && $this->task_lat->FormValue != NULL && $this->task_lat->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->task_lat->caption(), $this->task_lat->RequiredErrorMessage));
			}
		}
		if ($this->task_lng->Required) {
			if (!$this->task_lng->IsDetailKey && $this->task_lng->FormValue != NULL && $this->task_lng->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->task_lng->caption(), $this->task_lng->RequiredErrorMessage));
			}
		}
		if ($this->customer_signature->Required) {
			if (!$this->customer_signature->IsDetailKey && $this->customer_signature->FormValue != NULL && $this->customer_signature->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->customer_signature->caption(), $this->customer_signature->RequiredErrorMessage));
			}
		}
		if ($this->date_created->Required) {
			if (!$this->date_created->IsDetailKey && $this->date_created->FormValue != NULL && $this->date_created->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_created->caption(), $this->date_created->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date_created->FormValue)) {
			AddMessage($FormError, $this->date_created->errorMessage());
		}
		if ($this->date_modified->Required) {
			if (!$this->date_modified->IsDetailKey && $this->date_modified->FormValue != NULL && $this->date_modified->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_modified->caption(), $this->date_modified->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date_modified->FormValue)) {
			AddMessage($FormError, $this->date_modified->errorMessage());
		}
		if ($this->ip_address->Required) {
			if (!$this->ip_address->IsDetailKey && $this->ip_address->FormValue != NULL && $this->ip_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ip_address->caption(), $this->ip_address->RequiredErrorMessage));
			}
		}
		if ($this->auto_assign_type->Required) {
			if (!$this->auto_assign_type->IsDetailKey && $this->auto_assign_type->FormValue != NULL && $this->auto_assign_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->auto_assign_type->caption(), $this->auto_assign_type->RequiredErrorMessage));
			}
		}
		if ($this->assign_started->Required) {
			if (!$this->assign_started->IsDetailKey && $this->assign_started->FormValue != NULL && $this->assign_started->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->assign_started->caption(), $this->assign_started->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->assign_started->FormValue)) {
			AddMessage($FormError, $this->assign_started->errorMessage());
		}
		if ($this->assignment_status->Required) {
			if (!$this->assignment_status->IsDetailKey && $this->assignment_status->FormValue != NULL && $this->assignment_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->assignment_status->caption(), $this->assignment_status->RequiredErrorMessage));
			}
		}
		if ($this->dropoff_contact_name->Required) {
			if (!$this->dropoff_contact_name->IsDetailKey && $this->dropoff_contact_name->FormValue != NULL && $this->dropoff_contact_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dropoff_contact_name->caption(), $this->dropoff_contact_name->RequiredErrorMessage));
			}
		}
		if ($this->dropoff_contact_number->Required) {
			if (!$this->dropoff_contact_number->IsDetailKey && $this->dropoff_contact_number->FormValue != NULL && $this->dropoff_contact_number->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dropoff_contact_number->caption(), $this->dropoff_contact_number->RequiredErrorMessage));
			}
		}
		if ($this->drop_address->Required) {
			if (!$this->drop_address->IsDetailKey && $this->drop_address->FormValue != NULL && $this->drop_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->drop_address->caption(), $this->drop_address->RequiredErrorMessage));
			}
		}
		if ($this->dropoff_task_lat->Required) {
			if (!$this->dropoff_task_lat->IsDetailKey && $this->dropoff_task_lat->FormValue != NULL && $this->dropoff_task_lat->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dropoff_task_lat->caption(), $this->dropoff_task_lat->RequiredErrorMessage));
			}
		}
		if ($this->dropoff_task_lng->Required) {
			if (!$this->dropoff_task_lng->IsDetailKey && $this->dropoff_task_lng->FormValue != NULL && $this->dropoff_task_lng->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dropoff_task_lng->caption(), $this->dropoff_task_lng->RequiredErrorMessage));
			}
		}
		if ($this->task_token->Required) {
			if (!$this->task_token->IsDetailKey && $this->task_token->FormValue != NULL && $this->task_token->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->task_token->caption(), $this->task_token->RequiredErrorMessage));
			}
		}
		if ($this->ratings->Required) {
			if (!$this->ratings->IsDetailKey && $this->ratings->FormValue != NULL && $this->ratings->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ratings->caption(), $this->ratings->RequiredErrorMessage));
			}
		}
		if ($this->rating_comment->Required) {
			if (!$this->rating_comment->IsDetailKey && $this->rating_comment->FormValue != NULL && $this->rating_comment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rating_comment->caption(), $this->rating_comment->RequiredErrorMessage));
			}
		}
		if ($this->critical->Required) {
			if (!$this->critical->IsDetailKey && $this->critical->FormValue != NULL && $this->critical->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->critical->caption(), $this->critical->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->critical->FormValue)) {
			AddMessage($FormError, $this->critical->errorMessage());
		}
		if ($this->souce_e->Required) {
			if (!$this->souce_e->IsDetailKey && $this->souce_e->FormValue != NULL && $this->souce_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->souce_e->caption(), $this->souce_e->RequiredErrorMessage));
			}
		}
		if ($this->shop_code_e->Required) {
			if (!$this->shop_code_e->IsDetailKey && $this->shop_code_e->FormValue != NULL && $this->shop_code_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shop_code_e->caption(), $this->shop_code_e->RequiredErrorMessage));
			}
		}
		if ($this->Received_Channel_e->Required) {
			if (!$this->Received_Channel_e->IsDetailKey && $this->Received_Channel_e->FormValue != NULL && $this->Received_Channel_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Received_Channel_e->caption(), $this->Received_Channel_e->RequiredErrorMessage));
			}
		}
		if ($this->PayMethod_e->Required) {
			if (!$this->PayMethod_e->IsDetailKey && $this->PayMethod_e->FormValue != NULL && $this->PayMethod_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PayMethod_e->caption(), $this->PayMethod_e->RequiredErrorMessage));
			}
		}
		if ($this->Type_e->Required) {
			if (!$this->Type_e->IsDetailKey && $this->Type_e->FormValue != NULL && $this->Type_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Type_e->caption(), $this->Type_e->RequiredErrorMessage));
			}
		}
		if ($this->Request_Code_e->Required) {
			if (!$this->Request_Code_e->IsDetailKey && $this->Request_Code_e->FormValue != NULL && $this->Request_Code_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Request_Code_e->caption(), $this->Request_Code_e->RequiredErrorMessage));
			}
		}
		if ($this->Status_e->Required) {
			if (!$this->Status_e->IsDetailKey && $this->Status_e->FormValue != NULL && $this->Status_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_e->caption(), $this->Status_e->RequiredErrorMessage));
			}
		}
		if ($this->PlanType_e->Required) {
			if (!$this->PlanType_e->IsDetailKey && $this->PlanType_e->FormValue != NULL && $this->PlanType_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PlanType_e->caption(), $this->PlanType_e->RequiredErrorMessage));
			}
		}
		if ($this->Plan_e->Required) {
			if (!$this->Plan_e->IsDetailKey && $this->Plan_e->FormValue != NULL && $this->Plan_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Plan_e->caption(), $this->Plan_e->RequiredErrorMessage));
			}
		}
		if ($this->Isdn_e->Required) {
			if (!$this->Isdn_e->IsDetailKey && $this->Isdn_e->FormValue != NULL && $this->Isdn_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Isdn_e->caption(), $this->Isdn_e->RequiredErrorMessage));
			}
		}
		if ($this->serial_sim_handset_e->Required) {
			if (!$this->serial_sim_handset_e->IsDetailKey && $this->serial_sim_handset_e->FormValue != NULL && $this->serial_sim_handset_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->serial_sim_handset_e->caption(), $this->serial_sim_handset_e->RequiredErrorMessage));
			}
		}
		if ($this->handset_e->Required) {
			if (!$this->handset_e->IsDetailKey && $this->handset_e->FormValue != NULL && $this->handset_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->handset_e->caption(), $this->handset_e->RequiredErrorMessage));
			}
		}
		if ($this->Connect_Reason_e->Required) {
			if (!$this->Connect_Reason_e->IsDetailKey && $this->Connect_Reason_e->FormValue != NULL && $this->Connect_Reason_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Connect_Reason_e->caption(), $this->Connect_Reason_e->RequiredErrorMessage));
			}
		}
		if ($this->Price_e->Required) {
			if (!$this->Price_e->IsDetailKey && $this->Price_e->FormValue != NULL && $this->Price_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Price_e->caption(), $this->Price_e->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Price_e->FormValue)) {
			AddMessage($FormError, $this->Price_e->errorMessage());
		}
		if ($this->Current_Operator_e->Required) {
			if (!$this->Current_Operator_e->IsDetailKey && $this->Current_Operator_e->FormValue != NULL && $this->Current_Operator_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Current_Operator_e->caption(), $this->Current_Operator_e->RequiredErrorMessage));
			}
		}
		if ($this->Current_Plan_Type_e->Required) {
			if (!$this->Current_Plan_Type_e->IsDetailKey && $this->Current_Plan_Type_e->FormValue != NULL && $this->Current_Plan_Type_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Current_Plan_Type_e->caption(), $this->Current_Plan_Type_e->RequiredErrorMessage));
			}
		}
		if ($this->Document_Number_e->Required) {
			if (!$this->Document_Number_e->IsDetailKey && $this->Document_Number_e->FormValue != NULL && $this->Document_Number_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Document_Number_e->caption(), $this->Document_Number_e->RequiredErrorMessage));
			}
		}
		if ($this->Document_Type_e->Required) {
			if (!$this->Document_Type_e->IsDetailKey && $this->Document_Type_e->FormValue != NULL && $this->Document_Type_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Document_Type_e->caption(), $this->Document_Type_e->RequiredErrorMessage));
			}
		}
		if ($this->assignStaffCode_e->Required) {
			if (!$this->assignStaffCode_e->IsDetailKey && $this->assignStaffCode_e->FormValue != NULL && $this->assignStaffCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->assignStaffCode_e->caption(), $this->assignStaffCode_e->RequiredErrorMessage));
			}
		}
		if ($this->Delivery_Type_e->Required) {
			if (!$this->Delivery_Type_e->IsDetailKey && $this->Delivery_Type_e->FormValue != NULL && $this->Delivery_Type_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Delivery_Type_e->caption(), $this->Delivery_Type_e->RequiredErrorMessage));
			}
		}
		if ($this->assignStaffType_e->Required) {
			if (!$this->assignStaffType_e->IsDetailKey && $this->assignStaffType_e->FormValue != NULL && $this->assignStaffType_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->assignStaffType_e->caption(), $this->assignStaffType_e->RequiredErrorMessage));
			}
		}
		if ($this->receiveStaffCode_e->Required) {
			if (!$this->receiveStaffCode_e->IsDetailKey && $this->receiveStaffCode_e->FormValue != NULL && $this->receiveStaffCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->receiveStaffCode_e->caption(), $this->receiveStaffCode_e->RequiredErrorMessage));
			}
		}
		if ($this->receiveStaffType_e->Required) {
			if (!$this->receiveStaffType_e->IsDetailKey && $this->receiveStaffType_e->FormValue != NULL && $this->receiveStaffType_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->receiveStaffType_e->caption(), $this->receiveStaffType_e->RequiredErrorMessage));
			}
		}
		if ($this->connectStaffCode_e->Required) {
			if (!$this->connectStaffCode_e->IsDetailKey && $this->connectStaffCode_e->FormValue != NULL && $this->connectStaffCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->connectStaffCode_e->caption(), $this->connectStaffCode_e->RequiredErrorMessage));
			}
		}
		if ($this->connectStaffType_e->Required) {
			if (!$this->connectStaffType_e->IsDetailKey && $this->connectStaffType_e->FormValue != NULL && $this->connectStaffType_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->connectStaffType_e->caption(), $this->connectStaffType_e->RequiredErrorMessage));
			}
		}
		if ($this->shopName_e->Required) {
			if (!$this->shopName_e->IsDetailKey && $this->shopName_e->FormValue != NULL && $this->shopName_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shopName_e->caption(), $this->shopName_e->RequiredErrorMessage));
			}
		}
		if ($this->saleOrderCode_e->Required) {
			if (!$this->saleOrderCode_e->IsDetailKey && $this->saleOrderCode_e->FormValue != NULL && $this->saleOrderCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->saleOrderCode_e->caption(), $this->saleOrderCode_e->RequiredErrorMessage));
			}
		}
		if ($this->consultantCode_e->Required) {
			if (!$this->consultantCode_e->IsDetailKey && $this->consultantCode_e->FormValue != NULL && $this->consultantCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consultantCode_e->caption(), $this->consultantCode_e->RequiredErrorMessage));
			}
		}
		if ($this->consultantName_e->Required) {
			if (!$this->consultantName_e->IsDetailKey && $this->consultantName_e->FormValue != NULL && $this->consultantName_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consultantName_e->caption(), $this->consultantName_e->RequiredErrorMessage));
			}
		}
		if ($this->consultantType_e->Required) {
			if (!$this->consultantType_e->IsDetailKey && $this->consultantType_e->FormValue != NULL && $this->consultantType_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consultantType_e->caption(), $this->consultantType_e->RequiredErrorMessage));
			}
		}
		if ($this->created_By_e->Required) {
			if (!$this->created_By_e->IsDetailKey && $this->created_By_e->FormValue != NULL && $this->created_By_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->created_By_e->caption(), $this->created_By_e->RequiredErrorMessage));
			}
		}
		if ($this->createdBranch_e->Required) {
			if (!$this->createdBranch_e->IsDetailKey && $this->createdBranch_e->FormValue != NULL && $this->createdBranch_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->createdBranch_e->caption(), $this->createdBranch_e->RequiredErrorMessage));
			}
		}
		if ($this->generated_Code_By_e->Required) {
			if (!$this->generated_Code_By_e->IsDetailKey && $this->generated_Code_By_e->FormValue != NULL && $this->generated_Code_By_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->generated_Code_By_e->caption(), $this->generated_Code_By_e->RequiredErrorMessage));
			}
		}
		if ($this->approve_Paid_By_e->Required) {
			if (!$this->approve_Paid_By_e->IsDetailKey && $this->approve_Paid_By_e->FormValue != NULL && $this->approve_Paid_By_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->approve_Paid_By_e->caption(), $this->approve_Paid_By_e->RequiredErrorMessage));
			}
		}
		if ($this->Delivery_Note_e->Required) {
			if (!$this->Delivery_Note_e->IsDetailKey && $this->Delivery_Note_e->FormValue != NULL && $this->Delivery_Note_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Delivery_Note_e->caption(), $this->Delivery_Note_e->RequiredErrorMessage));
			}
		}
		if ($this->Delivery_Code_e->Required) {
			if (!$this->Delivery_Code_e->IsDetailKey && $this->Delivery_Code_e->FormValue != NULL && $this->Delivery_Code_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Delivery_Code_e->caption(), $this->Delivery_Code_e->RequiredErrorMessage));
			}
		}
		if ($this->Customer_Note_e->Required) {
			if (!$this->Customer_Note_e->IsDetailKey && $this->Customer_Note_e->FormValue != NULL && $this->Customer_Note_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Customer_Note_e->caption(), $this->Customer_Note_e->RequiredErrorMessage));
			}
		}
		if ($this->saleOrderCreateDate_e->Required) {
			if (!$this->saleOrderCreateDate_e->IsDetailKey && $this->saleOrderCreateDate_e->FormValue != NULL && $this->saleOrderCreateDate_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->saleOrderCreateDate_e->caption(), $this->saleOrderCreateDate_e->RequiredErrorMessage));
			}
		}
		if ($this->saleOrderPayDate_e->Required) {
			if (!$this->saleOrderPayDate_e->IsDetailKey && $this->saleOrderPayDate_e->FormValue != NULL && $this->saleOrderPayDate_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->saleOrderPayDate_e->caption(), $this->saleOrderPayDate_e->RequiredErrorMessage));
			}
		}
		if ($this->Time_of_Procesing_e->Required) {
			if (!$this->Time_of_Procesing_e->IsDetailKey && $this->Time_of_Procesing_e->FormValue != NULL && $this->Time_of_Procesing_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Time_of_Procesing_e->caption(), $this->Time_of_Procesing_e->RequiredErrorMessage));
			}
		}
		if ($this->Time_of_new_e->Required) {
			if (!$this->Time_of_new_e->IsDetailKey && $this->Time_of_new_e->FormValue != NULL && $this->Time_of_new_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Time_of_new_e->caption(), $this->Time_of_new_e->RequiredErrorMessage));
			}
		}
		if ($this->Time_of_Finished_e->Required) {
			if (!$this->Time_of_Finished_e->IsDetailKey && $this->Time_of_Finished_e->FormValue != NULL && $this->Time_of_Finished_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Time_of_Finished_e->caption(), $this->Time_of_Finished_e->RequiredErrorMessage));
			}
		}
		if ($this->KPI_CC_Hour_e->Required) {
			if (!$this->KPI_CC_Hour_e->IsDetailKey && $this->KPI_CC_Hour_e->FormValue != NULL && $this->KPI_CC_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KPI_CC_Hour_e->caption(), $this->KPI_CC_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->KPI_NEW_Hour_e->Required) {
			if (!$this->KPI_NEW_Hour_e->IsDetailKey && $this->KPI_NEW_Hour_e->FormValue != NULL && $this->KPI_NEW_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KPI_NEW_Hour_e->caption(), $this->KPI_NEW_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->KPI_PROCESING_Hour_e->Required) {
			if (!$this->KPI_PROCESING_Hour_e->IsDetailKey && $this->KPI_PROCESING_Hour_e->FormValue != NULL && $this->KPI_PROCESING_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KPI_PROCESING_Hour_e->caption(), $this->KPI_PROCESING_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->KPI_ALL_Hour_e->Required) {
			if (!$this->KPI_ALL_Hour_e->IsDetailKey && $this->KPI_ALL_Hour_e->FormValue != NULL && $this->KPI_ALL_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KPI_ALL_Hour_e->caption(), $this->KPI_ALL_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->Kpi_Register_Hour_e->Required) {
			if (!$this->Kpi_Register_Hour_e->IsDetailKey && $this->Kpi_Register_Hour_e->FormValue != NULL && $this->Kpi_Register_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kpi_Register_Hour_e->caption(), $this->Kpi_Register_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->Kpi_Bitel_Hour_e->Required) {
			if (!$this->Kpi_Bitel_Hour_e->IsDetailKey && $this->Kpi_Bitel_Hour_e->FormValue != NULL && $this->Kpi_Bitel_Hour_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kpi_Bitel_Hour_e->caption(), $this->Kpi_Bitel_Hour_e->RequiredErrorMessage));
			}
		}
		if ($this->AmountGB_e->Required) {
			if (!$this->AmountGB_e->IsDetailKey && $this->AmountGB_e->FormValue != NULL && $this->AmountGB_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->AmountGB_e->caption(), $this->AmountGB_e->RequiredErrorMessage));
			}
		}
		if ($this->Price_1_e->Required) {
			if (!$this->Price_1_e->IsDetailKey && $this->Price_1_e->FormValue != NULL && $this->Price_1_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Price_1_e->caption(), $this->Price_1_e->RequiredErrorMessage));
			}
		}
		if ($this->Status_1_e->Required) {
			if (!$this->Status_1_e->IsDetailKey && $this->Status_1_e->FormValue != NULL && $this->Status_1_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_1_e->caption(), $this->Status_1_e->RequiredErrorMessage));
			}
		}
		if ($this->Registered_Date_e->Required) {
			if (!$this->Registered_Date_e->IsDetailKey && $this->Registered_Date_e->FormValue != NULL && $this->Registered_Date_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Registered_Date_e->caption(), $this->Registered_Date_e->RequiredErrorMessage));
			}
		}
		if ($this->Sumary_e->Required) {
			if (!$this->Sumary_e->IsDetailKey && $this->Sumary_e->FormValue != NULL && $this->Sumary_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Sumary_e->caption(), $this->Sumary_e->RequiredErrorMessage));
			}
		}
		if ($this->Plans_e->Required) {
			if (!$this->Plans_e->IsDetailKey && $this->Plans_e->FormValue != NULL && $this->Plans_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Plans_e->caption(), $this->Plans_e->RequiredErrorMessage));
			}
		}
		if ($this->Isdns_e->Required) {
			if (!$this->Isdns_e->IsDetailKey && $this->Isdns_e->FormValue != NULL && $this->Isdns_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Isdns_e->caption(), $this->Isdns_e->RequiredErrorMessage));
			}
		}
		if ($this->PlanTypes_e->Required) {
			if (!$this->PlanTypes_e->IsDetailKey && $this->PlanTypes_e->FormValue != NULL && $this->PlanTypes_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PlanTypes_e->caption(), $this->PlanTypes_e->RequiredErrorMessage));
			}
		}
		if ($this->Serials_e->Required) {
			if (!$this->Serials_e->IsDetailKey && $this->Serials_e->FormValue != NULL && $this->Serials_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Serials_e->caption(), $this->Serials_e->RequiredErrorMessage));
			}
		}
		if ($this->Status_2_e->Required) {
			if (!$this->Status_2_e->IsDetailKey && $this->Status_2_e->FormValue != NULL && $this->Status_2_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_2_e->caption(), $this->Status_2_e->RequiredErrorMessage));
			}
		}
		if ($this->Registered_Date_2_e->Required) {
			if (!$this->Registered_Date_2_e->IsDetailKey && $this->Registered_Date_2_e->FormValue != NULL && $this->Registered_Date_2_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Registered_Date_2_e->caption(), $this->Registered_Date_2_e->RequiredErrorMessage));
			}
		}
		if ($this->Summary_2_e->Required) {
			if (!$this->Summary_2_e->IsDetailKey && $this->Summary_2_e->FormValue != NULL && $this->Summary_2_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Summary_2_e->caption(), $this->Summary_2_e->RequiredErrorMessage));
			}
		}
		if ($this->serial_2_e->Required) {
			if (!$this->serial_2_e->IsDetailKey && $this->serial_2_e->FormValue != NULL && $this->serial_2_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->serial_2_e->caption(), $this->serial_2_e->RequiredErrorMessage));
			}
		}
		if ($this->HandsetCode_e->Required) {
			if (!$this->HandsetCode_e->IsDetailKey && $this->HandsetCode_e->FormValue != NULL && $this->HandsetCode_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->HandsetCode_e->caption(), $this->HandsetCode_e->RequiredErrorMessage));
			}
		}
		if ($this->HandsetName_e->Required) {
			if (!$this->HandsetName_e->IsDetailKey && $this->HandsetName_e->FormValue != NULL && $this->HandsetName_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->HandsetName_e->caption(), $this->HandsetName_e->RequiredErrorMessage));
			}
		}
		if ($this->Status_3_e->Required) {
			if (!$this->Status_3_e->IsDetailKey && $this->Status_3_e->FormValue != NULL && $this->Status_3_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_3_e->caption(), $this->Status_3_e->RequiredErrorMessage));
			}
		}
		if ($this->Summary_3_e->Required) {
			if (!$this->Summary_3_e->IsDetailKey && $this->Summary_3_e->FormValue != NULL && $this->Summary_3_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Summary_3_e->caption(), $this->Summary_3_e->RequiredErrorMessage));
			}
		}
		if ($this->fecha_activa_e->Required) {
			if (!$this->fecha_activa_e->IsDetailKey && $this->fecha_activa_e->FormValue != NULL && $this->fecha_activa_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_activa_e->caption(), $this->fecha_activa_e->RequiredErrorMessage));
			}
		}
		if ($this->mes_activa_e->Required) {
			if (!$this->mes_activa_e->IsDetailKey && $this->mes_activa_e->FormValue != NULL && $this->mes_activa_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mes_activa_e->caption(), $this->mes_activa_e->RequiredErrorMessage));
			}
		}
		if ($this->SOURCE_OUT_e->Required) {
			if (!$this->SOURCE_OUT_e->IsDetailKey && $this->SOURCE_OUT_e->FormValue != NULL && $this->SOURCE_OUT_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SOURCE_OUT_e->caption(), $this->SOURCE_OUT_e->RequiredErrorMessage));
			}
		}
		if ($this->fecha_crea_e->Required) {
			if (!$this->fecha_crea_e->IsDetailKey && $this->fecha_crea_e->FormValue != NULL && $this->fecha_crea_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fecha_crea_e->caption(), $this->fecha_crea_e->RequiredErrorMessage));
			}
		}
		if ($this->mes_crea_e->Required) {
			if (!$this->mes_crea_e->IsDetailKey && $this->mes_crea_e->FormValue != NULL && $this->mes_crea_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mes_crea_e->caption(), $this->mes_crea_e->RequiredErrorMessage));
			}
		}
		if ($this->moto_e->Required) {
			if (!$this->moto_e->IsDetailKey && $this->moto_e->FormValue != NULL && $this->moto_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->moto_e->caption(), $this->moto_e->RequiredErrorMessage));
			}
		}
		if ($this->customer_id->Required) {
			if (!$this->customer_id->IsDetailKey && $this->customer_id->FormValue != NULL && $this->customer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->customer_id->caption(), $this->customer_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->customer_id->FormValue)) {
			AddMessage($FormError, $this->customer_id->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->address_e->Required) {
			if (!$this->address_e->IsDetailKey && $this->address_e->FormValue != NULL && $this->address_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address_e->caption(), $this->address_e->RequiredErrorMessage));
			}
		}
		if ($this->branch_e->Required) {
			if (!$this->branch_e->IsDetailKey && $this->branch_e->FormValue != NULL && $this->branch_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->branch_e->caption(), $this->branch_e->RequiredErrorMessage));
			}
		}
		if ($this->CreatedTime_e->Required) {
			if (!$this->CreatedTime_e->IsDetailKey && $this->CreatedTime_e->FormValue != NULL && $this->CreatedTime_e->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedTime_e->caption(), $this->CreatedTime_e->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->CreatedTime_e->FormValue)) {
			AddMessage($FormError, $this->CreatedTime_e->errorMessage());
		}
		if ($this->Status_n->Required) {
			if (!$this->Status_n->IsDetailKey && $this->Status_n->FormValue != NULL && $this->Status_n->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_n->caption(), $this->Status_n->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->Status_n->FormValue)) {
			AddMessage($FormError, $this->Status_n->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// task_description
		$this->task_description->setDbValueDef($rsnew, $this->task_description->CurrentValue, NULL, FALSE);

		// trans_type
		$this->trans_type->setDbValueDef($rsnew, $this->trans_type->CurrentValue, NULL, FALSE);

		// contact_number
		$this->contact_number->setDbValueDef($rsnew, $this->contact_number->CurrentValue, NULL, FALSE);

		// email_address
		$this->email_address->setDbValueDef($rsnew, $this->email_address->CurrentValue, NULL, FALSE);

		// customer_name
		$this->customer_name->setDbValueDef($rsnew, $this->customer_name->CurrentValue, NULL, FALSE);

		// delivery_date
		$this->delivery_date->setDbValueDef($rsnew, UnFormatDateTime($this->delivery_date->CurrentValue, 0), NULL, FALSE);

		// delivery_address
		$this->delivery_address->setDbValueDef($rsnew, $this->delivery_address->CurrentValue, NULL, FALSE);

		// team_id
		$this->team_id->setDbValueDef($rsnew, $this->team_id->CurrentValue, NULL, strval($this->team_id->CurrentValue) == "");

		// driver_id
		$this->driver_id->setDbValueDef($rsnew, $this->driver_id->CurrentValue, NULL, strval($this->driver_id->CurrentValue) == "");

		// task_lat
		$this->task_lat->setDbValueDef($rsnew, $this->task_lat->CurrentValue, NULL, FALSE);

		// task_lng
		$this->task_lng->setDbValueDef($rsnew, $this->task_lng->CurrentValue, NULL, FALSE);

		// customer_signature
		$this->customer_signature->setDbValueDef($rsnew, $this->customer_signature->CurrentValue, NULL, FALSE);

		// date_created
		$this->date_created->setDbValueDef($rsnew, UnFormatDateTime($this->date_created->CurrentValue, 0), NULL, FALSE);

		// date_modified
		$this->date_modified->setDbValueDef($rsnew, UnFormatDateTime($this->date_modified->CurrentValue, 0), NULL, FALSE);

		// ip_address
		$this->ip_address->setDbValueDef($rsnew, $this->ip_address->CurrentValue, NULL, FALSE);

		// auto_assign_type
		$this->auto_assign_type->setDbValueDef($rsnew, $this->auto_assign_type->CurrentValue, NULL, FALSE);

		// assign_started
		$this->assign_started->setDbValueDef($rsnew, UnFormatDateTime($this->assign_started->CurrentValue, 0), NULL, FALSE);

		// assignment_status
		$this->assignment_status->setDbValueDef($rsnew, $this->assignment_status->CurrentValue, NULL, FALSE);

		// dropoff_contact_name
		$this->dropoff_contact_name->setDbValueDef($rsnew, $this->dropoff_contact_name->CurrentValue, NULL, FALSE);

		// dropoff_contact_number
		$this->dropoff_contact_number->setDbValueDef($rsnew, $this->dropoff_contact_number->CurrentValue, NULL, FALSE);

		// drop_address
		$this->drop_address->setDbValueDef($rsnew, $this->drop_address->CurrentValue, NULL, FALSE);

		// dropoff_task_lat
		$this->dropoff_task_lat->setDbValueDef($rsnew, $this->dropoff_task_lat->CurrentValue, NULL, FALSE);

		// dropoff_task_lng
		$this->dropoff_task_lng->setDbValueDef($rsnew, $this->dropoff_task_lng->CurrentValue, NULL, FALSE);

		// task_token
		$this->task_token->setDbValueDef($rsnew, $this->task_token->CurrentValue, NULL, FALSE);

		// ratings
		$this->ratings->setDbValueDef($rsnew, $this->ratings->CurrentValue, NULL, FALSE);

		// rating_comment
		$this->rating_comment->setDbValueDef($rsnew, $this->rating_comment->CurrentValue, NULL, FALSE);

		// critical
		$this->critical->setDbValueDef($rsnew, $this->critical->CurrentValue, NULL, strval($this->critical->CurrentValue) == "");

		// souce_e
		$this->souce_e->setDbValueDef($rsnew, $this->souce_e->CurrentValue, NULL, FALSE);

		// shop_code_e
		$this->shop_code_e->setDbValueDef($rsnew, $this->shop_code_e->CurrentValue, NULL, FALSE);

		// Received_Channel_e
		$this->Received_Channel_e->setDbValueDef($rsnew, $this->Received_Channel_e->CurrentValue, NULL, FALSE);

		// PayMethod_e
		$this->PayMethod_e->setDbValueDef($rsnew, $this->PayMethod_e->CurrentValue, NULL, FALSE);

		// Type_e
		$this->Type_e->setDbValueDef($rsnew, $this->Type_e->CurrentValue, NULL, FALSE);

		// Request_Code_e
		$this->Request_Code_e->setDbValueDef($rsnew, $this->Request_Code_e->CurrentValue, NULL, FALSE);

		// Status_e
		$this->Status_e->setDbValueDef($rsnew, $this->Status_e->CurrentValue, NULL, FALSE);

		// PlanType_e
		$this->PlanType_e->setDbValueDef($rsnew, $this->PlanType_e->CurrentValue, NULL, FALSE);

		// Plan_e
		$this->Plan_e->setDbValueDef($rsnew, $this->Plan_e->CurrentValue, NULL, FALSE);

		// Isdn_e
		$this->Isdn_e->setDbValueDef($rsnew, $this->Isdn_e->CurrentValue, NULL, FALSE);

		// serial_sim_handset_e
		$this->serial_sim_handset_e->setDbValueDef($rsnew, $this->serial_sim_handset_e->CurrentValue, NULL, FALSE);

		// handset_e
		$this->handset_e->setDbValueDef($rsnew, $this->handset_e->CurrentValue, NULL, FALSE);

		// Connect_Reason_e
		$this->Connect_Reason_e->setDbValueDef($rsnew, $this->Connect_Reason_e->CurrentValue, NULL, FALSE);

		// Price_e
		$this->Price_e->setDbValueDef($rsnew, $this->Price_e->CurrentValue, NULL, strval($this->Price_e->CurrentValue) == "");

		// Current_Operator_e
		$this->Current_Operator_e->setDbValueDef($rsnew, $this->Current_Operator_e->CurrentValue, NULL, FALSE);

		// Current_Plan_Type_e
		$this->Current_Plan_Type_e->setDbValueDef($rsnew, $this->Current_Plan_Type_e->CurrentValue, NULL, FALSE);

		// Document_Number_e
		$this->Document_Number_e->setDbValueDef($rsnew, $this->Document_Number_e->CurrentValue, NULL, FALSE);

		// Document_Type_e
		$this->Document_Type_e->setDbValueDef($rsnew, $this->Document_Type_e->CurrentValue, NULL, FALSE);

		// assignStaffCode_e
		$this->assignStaffCode_e->setDbValueDef($rsnew, $this->assignStaffCode_e->CurrentValue, NULL, FALSE);

		// Delivery_Type_e
		$this->Delivery_Type_e->setDbValueDef($rsnew, $this->Delivery_Type_e->CurrentValue, NULL, FALSE);

		// assignStaffType_e
		$this->assignStaffType_e->setDbValueDef($rsnew, $this->assignStaffType_e->CurrentValue, NULL, FALSE);

		// receiveStaffCode_e
		$this->receiveStaffCode_e->setDbValueDef($rsnew, $this->receiveStaffCode_e->CurrentValue, NULL, FALSE);

		// receiveStaffType_e
		$this->receiveStaffType_e->setDbValueDef($rsnew, $this->receiveStaffType_e->CurrentValue, NULL, FALSE);

		// connectStaffCode_e
		$this->connectStaffCode_e->setDbValueDef($rsnew, $this->connectStaffCode_e->CurrentValue, NULL, FALSE);

		// connectStaffType_e
		$this->connectStaffType_e->setDbValueDef($rsnew, $this->connectStaffType_e->CurrentValue, NULL, FALSE);

		// shopName_e
		$this->shopName_e->setDbValueDef($rsnew, $this->shopName_e->CurrentValue, NULL, FALSE);

		// saleOrderCode_e
		$this->saleOrderCode_e->setDbValueDef($rsnew, $this->saleOrderCode_e->CurrentValue, NULL, FALSE);

		// consultantCode_e
		$this->consultantCode_e->setDbValueDef($rsnew, $this->consultantCode_e->CurrentValue, NULL, FALSE);

		// consultantName_e
		$this->consultantName_e->setDbValueDef($rsnew, $this->consultantName_e->CurrentValue, NULL, FALSE);

		// consultantType_e
		$this->consultantType_e->setDbValueDef($rsnew, $this->consultantType_e->CurrentValue, NULL, FALSE);

		// created_By_e
		$this->created_By_e->setDbValueDef($rsnew, $this->created_By_e->CurrentValue, NULL, FALSE);

		// createdBranch_e
		$this->createdBranch_e->setDbValueDef($rsnew, $this->createdBranch_e->CurrentValue, NULL, FALSE);

		// generated_Code_By_e
		$this->generated_Code_By_e->setDbValueDef($rsnew, $this->generated_Code_By_e->CurrentValue, NULL, FALSE);

		// approve_Paid_By_e
		$this->approve_Paid_By_e->setDbValueDef($rsnew, $this->approve_Paid_By_e->CurrentValue, NULL, FALSE);

		// Delivery_Note_e
		$this->Delivery_Note_e->setDbValueDef($rsnew, $this->Delivery_Note_e->CurrentValue, NULL, FALSE);

		// Delivery_Code_e
		$this->Delivery_Code_e->setDbValueDef($rsnew, $this->Delivery_Code_e->CurrentValue, NULL, FALSE);

		// Customer_Note_e
		$this->Customer_Note_e->setDbValueDef($rsnew, $this->Customer_Note_e->CurrentValue, NULL, FALSE);

		// saleOrderCreateDate_e
		$this->saleOrderCreateDate_e->setDbValueDef($rsnew, $this->saleOrderCreateDate_e->CurrentValue, NULL, FALSE);

		// saleOrderPayDate_e
		$this->saleOrderPayDate_e->setDbValueDef($rsnew, $this->saleOrderPayDate_e->CurrentValue, NULL, FALSE);

		// Time_of_Procesing_e
		$this->Time_of_Procesing_e->setDbValueDef($rsnew, $this->Time_of_Procesing_e->CurrentValue, NULL, FALSE);

		// Time_of_new_e
		$this->Time_of_new_e->setDbValueDef($rsnew, $this->Time_of_new_e->CurrentValue, NULL, FALSE);

		// Time_of_Finished_e
		$this->Time_of_Finished_e->setDbValueDef($rsnew, $this->Time_of_Finished_e->CurrentValue, NULL, FALSE);

		// KPI_CC_Hour_e
		$this->KPI_CC_Hour_e->setDbValueDef($rsnew, $this->KPI_CC_Hour_e->CurrentValue, NULL, FALSE);

		// KPI_NEW_Hour_e
		$this->KPI_NEW_Hour_e->setDbValueDef($rsnew, $this->KPI_NEW_Hour_e->CurrentValue, NULL, FALSE);

		// KPI_PROCESING_Hour_e
		$this->KPI_PROCESING_Hour_e->setDbValueDef($rsnew, $this->KPI_PROCESING_Hour_e->CurrentValue, NULL, FALSE);

		// KPI_ALL_Hour_e
		$this->KPI_ALL_Hour_e->setDbValueDef($rsnew, $this->KPI_ALL_Hour_e->CurrentValue, NULL, FALSE);

		// Kpi_Register_Hour_e
		$this->Kpi_Register_Hour_e->setDbValueDef($rsnew, $this->Kpi_Register_Hour_e->CurrentValue, NULL, FALSE);

		// Kpi_Bitel_Hour_e
		$this->Kpi_Bitel_Hour_e->setDbValueDef($rsnew, $this->Kpi_Bitel_Hour_e->CurrentValue, NULL, FALSE);

		// AmountGB_e
		$this->AmountGB_e->setDbValueDef($rsnew, $this->AmountGB_e->CurrentValue, NULL, FALSE);

		// Price_1_e
		$this->Price_1_e->setDbValueDef($rsnew, $this->Price_1_e->CurrentValue, NULL, FALSE);

		// Status_1_e
		$this->Status_1_e->setDbValueDef($rsnew, $this->Status_1_e->CurrentValue, NULL, FALSE);

		// Registered_Date_e
		$this->Registered_Date_e->setDbValueDef($rsnew, $this->Registered_Date_e->CurrentValue, NULL, FALSE);

		// Sumary_e
		$this->Sumary_e->setDbValueDef($rsnew, $this->Sumary_e->CurrentValue, NULL, FALSE);

		// Plans_e
		$this->Plans_e->setDbValueDef($rsnew, $this->Plans_e->CurrentValue, NULL, FALSE);

		// Isdns_e
		$this->Isdns_e->setDbValueDef($rsnew, $this->Isdns_e->CurrentValue, NULL, FALSE);

		// PlanTypes_e
		$this->PlanTypes_e->setDbValueDef($rsnew, $this->PlanTypes_e->CurrentValue, NULL, FALSE);

		// Serials_e
		$this->Serials_e->setDbValueDef($rsnew, $this->Serials_e->CurrentValue, NULL, FALSE);

		// Status_2_e
		$this->Status_2_e->setDbValueDef($rsnew, $this->Status_2_e->CurrentValue, NULL, FALSE);

		// Registered_Date_2_e
		$this->Registered_Date_2_e->setDbValueDef($rsnew, $this->Registered_Date_2_e->CurrentValue, NULL, FALSE);

		// Summary_2_e
		$this->Summary_2_e->setDbValueDef($rsnew, $this->Summary_2_e->CurrentValue, NULL, FALSE);

		// serial_2_e
		$this->serial_2_e->setDbValueDef($rsnew, $this->serial_2_e->CurrentValue, NULL, FALSE);

		// HandsetCode_e
		$this->HandsetCode_e->setDbValueDef($rsnew, $this->HandsetCode_e->CurrentValue, NULL, FALSE);

		// HandsetName_e
		$this->HandsetName_e->setDbValueDef($rsnew, $this->HandsetName_e->CurrentValue, NULL, FALSE);

		// Status_3_e
		$this->Status_3_e->setDbValueDef($rsnew, $this->Status_3_e->CurrentValue, NULL, FALSE);

		// Summary_3_e
		$this->Summary_3_e->setDbValueDef($rsnew, $this->Summary_3_e->CurrentValue, NULL, FALSE);

		// fecha_activa_e
		$this->fecha_activa_e->setDbValueDef($rsnew, $this->fecha_activa_e->CurrentValue, NULL, FALSE);

		// mes_activa_e
		$this->mes_activa_e->setDbValueDef($rsnew, $this->mes_activa_e->CurrentValue, NULL, FALSE);

		// SOURCE_OUT_e
		$this->SOURCE_OUT_e->setDbValueDef($rsnew, $this->SOURCE_OUT_e->CurrentValue, NULL, FALSE);

		// fecha_crea_e
		$this->fecha_crea_e->setDbValueDef($rsnew, $this->fecha_crea_e->CurrentValue, NULL, FALSE);

		// mes_crea_e
		$this->mes_crea_e->setDbValueDef($rsnew, $this->mes_crea_e->CurrentValue, NULL, FALSE);

		// moto_e
		$this->moto_e->setDbValueDef($rsnew, $this->moto_e->CurrentValue, NULL, FALSE);

		// customer_id
		$this->customer_id->setDbValueDef($rsnew, $this->customer_id->CurrentValue, NULL, strval($this->customer_id->CurrentValue) == "");

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, strval($this->status->CurrentValue) == "");

		// address_e
		$this->address_e->setDbValueDef($rsnew, $this->address_e->CurrentValue, NULL, FALSE);

		// branch_e
		$this->branch_e->setDbValueDef($rsnew, $this->branch_e->CurrentValue, NULL, FALSE);

		// CreatedTime_e
		$this->CreatedTime_e->setDbValueDef($rsnew, UnFormatDateTime($this->CreatedTime_e->CurrentValue, 0), NULL, FALSE);

		// Status_n
		$this->Status_n->setDbValueDef($rsnew, $this->Status_n->CurrentValue, NULL, strval($this->Status_n->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kt_driver_tasklist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>