<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class kt_driver_task_delete extends kt_driver_task
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'kt_driver_task';

	// Page object name
	public $PageObjName = "kt_driver_task_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (kt_driver_task)
		if (!isset($GLOBALS["kt_driver_task"]) || get_class($GLOBALS["kt_driver_task"]) == PROJECT_NAMESPACE . "kt_driver_task") {
			$GLOBALS["kt_driver_task"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["kt_driver_task"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'kt_driver_task');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $kt_driver_task;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($kt_driver_task);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['task_id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->task_id->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("kt_driver_tasklist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->task_id->setVisibility();
		$this->task_description->setVisibility();
		$this->trans_type->setVisibility();
		$this->contact_number->setVisibility();
		$this->email_address->setVisibility();
		$this->customer_name->setVisibility();
		$this->delivery_date->setVisibility();
		$this->delivery_address->Visible = FALSE;
		$this->team_id->setVisibility();
		$this->driver_id->setVisibility();
		$this->task_lat->setVisibility();
		$this->task_lng->setVisibility();
		$this->customer_signature->setVisibility();
		$this->date_created->setVisibility();
		$this->date_modified->setVisibility();
		$this->ip_address->setVisibility();
		$this->auto_assign_type->setVisibility();
		$this->assign_started->setVisibility();
		$this->assignment_status->setVisibility();
		$this->dropoff_contact_name->setVisibility();
		$this->dropoff_contact_number->setVisibility();
		$this->drop_address->setVisibility();
		$this->dropoff_task_lat->setVisibility();
		$this->dropoff_task_lng->setVisibility();
		$this->task_token->setVisibility();
		$this->ratings->setVisibility();
		$this->rating_comment->setVisibility();
		$this->critical->setVisibility();
		$this->souce_e->setVisibility();
		$this->shop_code_e->setVisibility();
		$this->Received_Channel_e->setVisibility();
		$this->PayMethod_e->setVisibility();
		$this->Type_e->setVisibility();
		$this->Request_Code_e->setVisibility();
		$this->Status_e->setVisibility();
		$this->PlanType_e->setVisibility();
		$this->Plan_e->setVisibility();
		$this->Isdn_e->setVisibility();
		$this->serial_sim_handset_e->setVisibility();
		$this->handset_e->setVisibility();
		$this->Connect_Reason_e->setVisibility();
		$this->Price_e->setVisibility();
		$this->Current_Operator_e->setVisibility();
		$this->Current_Plan_Type_e->setVisibility();
		$this->Document_Number_e->setVisibility();
		$this->Document_Type_e->setVisibility();
		$this->assignStaffCode_e->setVisibility();
		$this->Delivery_Type_e->setVisibility();
		$this->assignStaffType_e->setVisibility();
		$this->receiveStaffCode_e->setVisibility();
		$this->receiveStaffType_e->setVisibility();
		$this->connectStaffCode_e->setVisibility();
		$this->connectStaffType_e->setVisibility();
		$this->shopName_e->setVisibility();
		$this->saleOrderCode_e->setVisibility();
		$this->consultantCode_e->setVisibility();
		$this->consultantName_e->setVisibility();
		$this->consultantType_e->setVisibility();
		$this->created_By_e->setVisibility();
		$this->createdBranch_e->setVisibility();
		$this->generated_Code_By_e->setVisibility();
		$this->approve_Paid_By_e->setVisibility();
		$this->Delivery_Note_e->setVisibility();
		$this->Delivery_Code_e->setVisibility();
		$this->Customer_Note_e->setVisibility();
		$this->saleOrderCreateDate_e->setVisibility();
		$this->saleOrderPayDate_e->setVisibility();
		$this->Time_of_Procesing_e->setVisibility();
		$this->Time_of_new_e->setVisibility();
		$this->Time_of_Finished_e->setVisibility();
		$this->KPI_CC_Hour_e->setVisibility();
		$this->KPI_NEW_Hour_e->setVisibility();
		$this->KPI_PROCESING_Hour_e->setVisibility();
		$this->KPI_ALL_Hour_e->setVisibility();
		$this->Kpi_Register_Hour_e->setVisibility();
		$this->Kpi_Bitel_Hour_e->setVisibility();
		$this->AmountGB_e->setVisibility();
		$this->Price_1_e->setVisibility();
		$this->Status_1_e->setVisibility();
		$this->Registered_Date_e->setVisibility();
		$this->Sumary_e->setVisibility();
		$this->Plans_e->setVisibility();
		$this->Isdns_e->setVisibility();
		$this->PlanTypes_e->setVisibility();
		$this->Serials_e->setVisibility();
		$this->Status_2_e->setVisibility();
		$this->Registered_Date_2_e->setVisibility();
		$this->Summary_2_e->setVisibility();
		$this->serial_2_e->setVisibility();
		$this->HandsetCode_e->setVisibility();
		$this->HandsetName_e->setVisibility();
		$this->Status_3_e->setVisibility();
		$this->Summary_3_e->setVisibility();
		$this->fecha_activa_e->setVisibility();
		$this->mes_activa_e->setVisibility();
		$this->SOURCE_OUT_e->setVisibility();
		$this->fecha_crea_e->setVisibility();
		$this->mes_crea_e->setVisibility();
		$this->moto_e->setVisibility();
		$this->customer_id->setVisibility();
		$this->status->setVisibility();
		$this->address_e->Visible = FALSE;
		$this->branch_e->setVisibility();
		$this->CreatedTime_e->setVisibility();
		$this->Status_n->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("kt_driver_tasklist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("kt_driver_tasklist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->task_id->setDbValue($row['task_id']);
		$this->task_description->setDbValue($row['task_description']);
		$this->trans_type->setDbValue($row['trans_type']);
		$this->contact_number->setDbValue($row['contact_number']);
		$this->email_address->setDbValue($row['email_address']);
		$this->customer_name->setDbValue($row['customer_name']);
		$this->delivery_date->setDbValue($row['delivery_date']);
		$this->delivery_address->setDbValue($row['delivery_address']);
		$this->team_id->setDbValue($row['team_id']);
		$this->driver_id->setDbValue($row['driver_id']);
		$this->task_lat->setDbValue($row['task_lat']);
		$this->task_lng->setDbValue($row['task_lng']);
		$this->customer_signature->setDbValue($row['customer_signature']);
		$this->date_created->setDbValue($row['date_created']);
		$this->date_modified->setDbValue($row['date_modified']);
		$this->ip_address->setDbValue($row['ip_address']);
		$this->auto_assign_type->setDbValue($row['auto_assign_type']);
		$this->assign_started->setDbValue($row['assign_started']);
		$this->assignment_status->setDbValue($row['assignment_status']);
		$this->dropoff_contact_name->setDbValue($row['dropoff_contact_name']);
		$this->dropoff_contact_number->setDbValue($row['dropoff_contact_number']);
		$this->drop_address->setDbValue($row['drop_address']);
		$this->dropoff_task_lat->setDbValue($row['dropoff_task_lat']);
		$this->dropoff_task_lng->setDbValue($row['dropoff_task_lng']);
		$this->task_token->setDbValue($row['task_token']);
		$this->ratings->setDbValue($row['ratings']);
		$this->rating_comment->setDbValue($row['rating_comment']);
		$this->critical->setDbValue($row['critical']);
		$this->souce_e->setDbValue($row['souce_e']);
		$this->shop_code_e->setDbValue($row['shop_code_e']);
		$this->Received_Channel_e->setDbValue($row['Received_Channel_e']);
		$this->PayMethod_e->setDbValue($row['PayMethod_e']);
		$this->Type_e->setDbValue($row['Type_e']);
		$this->Request_Code_e->setDbValue($row['Request_Code_e']);
		$this->Status_e->setDbValue($row['Status_e']);
		$this->PlanType_e->setDbValue($row['PlanType_e']);
		$this->Plan_e->setDbValue($row['Plan_e']);
		$this->Isdn_e->setDbValue($row['Isdn_e']);
		$this->serial_sim_handset_e->setDbValue($row['serial_sim_handset_e']);
		$this->handset_e->setDbValue($row['handset_e']);
		$this->Connect_Reason_e->setDbValue($row['Connect_Reason_e']);
		$this->Price_e->setDbValue($row['Price_e']);
		$this->Current_Operator_e->setDbValue($row['Current_Operator_e']);
		$this->Current_Plan_Type_e->setDbValue($row['Current_Plan_Type_e']);
		$this->Document_Number_e->setDbValue($row['Document_Number_e']);
		$this->Document_Type_e->setDbValue($row['Document_Type_e']);
		$this->assignStaffCode_e->setDbValue($row['assignStaffCode_e']);
		$this->Delivery_Type_e->setDbValue($row['Delivery_Type_e']);
		$this->assignStaffType_e->setDbValue($row['assignStaffType_e']);
		$this->receiveStaffCode_e->setDbValue($row['receiveStaffCode_e']);
		$this->receiveStaffType_e->setDbValue($row['receiveStaffType_e']);
		$this->connectStaffCode_e->setDbValue($row['connectStaffCode_e']);
		$this->connectStaffType_e->setDbValue($row['connectStaffType_e']);
		$this->shopName_e->setDbValue($row['shopName_e']);
		$this->saleOrderCode_e->setDbValue($row['saleOrderCode_e']);
		$this->consultantCode_e->setDbValue($row['consultantCode_e']);
		$this->consultantName_e->setDbValue($row['consultantName_e']);
		$this->consultantType_e->setDbValue($row['consultantType_e']);
		$this->created_By_e->setDbValue($row['created_By_e']);
		$this->createdBranch_e->setDbValue($row['createdBranch_e']);
		$this->generated_Code_By_e->setDbValue($row['generated_Code_By_e']);
		$this->approve_Paid_By_e->setDbValue($row['approve_Paid_By_e']);
		$this->Delivery_Note_e->setDbValue($row['Delivery_Note_e']);
		$this->Delivery_Code_e->setDbValue($row['Delivery_Code_e']);
		$this->Customer_Note_e->setDbValue($row['Customer_Note_e']);
		$this->saleOrderCreateDate_e->setDbValue($row['saleOrderCreateDate_e']);
		$this->saleOrderPayDate_e->setDbValue($row['saleOrderPayDate_e']);
		$this->Time_of_Procesing_e->setDbValue($row['Time_of_Procesing_e']);
		$this->Time_of_new_e->setDbValue($row['Time_of_new_e']);
		$this->Time_of_Finished_e->setDbValue($row['Time_of_Finished_e']);
		$this->KPI_CC_Hour_e->setDbValue($row['KPI_CC_Hour_e']);
		$this->KPI_NEW_Hour_e->setDbValue($row['KPI_NEW_Hour_e']);
		$this->KPI_PROCESING_Hour_e->setDbValue($row['KPI_PROCESING_Hour_e']);
		$this->KPI_ALL_Hour_e->setDbValue($row['KPI_ALL_Hour_e']);
		$this->Kpi_Register_Hour_e->setDbValue($row['Kpi_Register_Hour_e']);
		$this->Kpi_Bitel_Hour_e->setDbValue($row['Kpi_Bitel_Hour_e']);
		$this->AmountGB_e->setDbValue($row['AmountGB_e']);
		$this->Price_1_e->setDbValue($row['Price_1_e']);
		$this->Status_1_e->setDbValue($row['Status_1_e']);
		$this->Registered_Date_e->setDbValue($row['Registered_Date_e']);
		$this->Sumary_e->setDbValue($row['Sumary_e']);
		$this->Plans_e->setDbValue($row['Plans_e']);
		$this->Isdns_e->setDbValue($row['Isdns_e']);
		$this->PlanTypes_e->setDbValue($row['PlanTypes_e']);
		$this->Serials_e->setDbValue($row['Serials_e']);
		$this->Status_2_e->setDbValue($row['Status_2_e']);
		$this->Registered_Date_2_e->setDbValue($row['Registered_Date_2_e']);
		$this->Summary_2_e->setDbValue($row['Summary_2_e']);
		$this->serial_2_e->setDbValue($row['serial_2_e']);
		$this->HandsetCode_e->setDbValue($row['HandsetCode_e']);
		$this->HandsetName_e->setDbValue($row['HandsetName_e']);
		$this->Status_3_e->setDbValue($row['Status_3_e']);
		$this->Summary_3_e->setDbValue($row['Summary_3_e']);
		$this->fecha_activa_e->setDbValue($row['fecha_activa_e']);
		$this->mes_activa_e->setDbValue($row['mes_activa_e']);
		$this->SOURCE_OUT_e->setDbValue($row['SOURCE_OUT_e']);
		$this->fecha_crea_e->setDbValue($row['fecha_crea_e']);
		$this->mes_crea_e->setDbValue($row['mes_crea_e']);
		$this->moto_e->setDbValue($row['moto_e']);
		$this->customer_id->setDbValue($row['customer_id']);
		$this->status->setDbValue($row['status']);
		$this->address_e->setDbValue($row['address_e']);
		$this->branch_e->setDbValue($row['branch_e']);
		$this->CreatedTime_e->setDbValue($row['CreatedTime_e']);
		$this->Status_n->setDbValue($row['Status_n']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['task_id'] = NULL;
		$row['task_description'] = NULL;
		$row['trans_type'] = NULL;
		$row['contact_number'] = NULL;
		$row['email_address'] = NULL;
		$row['customer_name'] = NULL;
		$row['delivery_date'] = NULL;
		$row['delivery_address'] = NULL;
		$row['team_id'] = NULL;
		$row['driver_id'] = NULL;
		$row['task_lat'] = NULL;
		$row['task_lng'] = NULL;
		$row['customer_signature'] = NULL;
		$row['date_created'] = NULL;
		$row['date_modified'] = NULL;
		$row['ip_address'] = NULL;
		$row['auto_assign_type'] = NULL;
		$row['assign_started'] = NULL;
		$row['assignment_status'] = NULL;
		$row['dropoff_contact_name'] = NULL;
		$row['dropoff_contact_number'] = NULL;
		$row['drop_address'] = NULL;
		$row['dropoff_task_lat'] = NULL;
		$row['dropoff_task_lng'] = NULL;
		$row['task_token'] = NULL;
		$row['ratings'] = NULL;
		$row['rating_comment'] = NULL;
		$row['critical'] = NULL;
		$row['souce_e'] = NULL;
		$row['shop_code_e'] = NULL;
		$row['Received_Channel_e'] = NULL;
		$row['PayMethod_e'] = NULL;
		$row['Type_e'] = NULL;
		$row['Request_Code_e'] = NULL;
		$row['Status_e'] = NULL;
		$row['PlanType_e'] = NULL;
		$row['Plan_e'] = NULL;
		$row['Isdn_e'] = NULL;
		$row['serial_sim_handset_e'] = NULL;
		$row['handset_e'] = NULL;
		$row['Connect_Reason_e'] = NULL;
		$row['Price_e'] = NULL;
		$row['Current_Operator_e'] = NULL;
		$row['Current_Plan_Type_e'] = NULL;
		$row['Document_Number_e'] = NULL;
		$row['Document_Type_e'] = NULL;
		$row['assignStaffCode_e'] = NULL;
		$row['Delivery_Type_e'] = NULL;
		$row['assignStaffType_e'] = NULL;
		$row['receiveStaffCode_e'] = NULL;
		$row['receiveStaffType_e'] = NULL;
		$row['connectStaffCode_e'] = NULL;
		$row['connectStaffType_e'] = NULL;
		$row['shopName_e'] = NULL;
		$row['saleOrderCode_e'] = NULL;
		$row['consultantCode_e'] = NULL;
		$row['consultantName_e'] = NULL;
		$row['consultantType_e'] = NULL;
		$row['created_By_e'] = NULL;
		$row['createdBranch_e'] = NULL;
		$row['generated_Code_By_e'] = NULL;
		$row['approve_Paid_By_e'] = NULL;
		$row['Delivery_Note_e'] = NULL;
		$row['Delivery_Code_e'] = NULL;
		$row['Customer_Note_e'] = NULL;
		$row['saleOrderCreateDate_e'] = NULL;
		$row['saleOrderPayDate_e'] = NULL;
		$row['Time_of_Procesing_e'] = NULL;
		$row['Time_of_new_e'] = NULL;
		$row['Time_of_Finished_e'] = NULL;
		$row['KPI_CC_Hour_e'] = NULL;
		$row['KPI_NEW_Hour_e'] = NULL;
		$row['KPI_PROCESING_Hour_e'] = NULL;
		$row['KPI_ALL_Hour_e'] = NULL;
		$row['Kpi_Register_Hour_e'] = NULL;
		$row['Kpi_Bitel_Hour_e'] = NULL;
		$row['AmountGB_e'] = NULL;
		$row['Price_1_e'] = NULL;
		$row['Status_1_e'] = NULL;
		$row['Registered_Date_e'] = NULL;
		$row['Sumary_e'] = NULL;
		$row['Plans_e'] = NULL;
		$row['Isdns_e'] = NULL;
		$row['PlanTypes_e'] = NULL;
		$row['Serials_e'] = NULL;
		$row['Status_2_e'] = NULL;
		$row['Registered_Date_2_e'] = NULL;
		$row['Summary_2_e'] = NULL;
		$row['serial_2_e'] = NULL;
		$row['HandsetCode_e'] = NULL;
		$row['HandsetName_e'] = NULL;
		$row['Status_3_e'] = NULL;
		$row['Summary_3_e'] = NULL;
		$row['fecha_activa_e'] = NULL;
		$row['mes_activa_e'] = NULL;
		$row['SOURCE_OUT_e'] = NULL;
		$row['fecha_crea_e'] = NULL;
		$row['mes_crea_e'] = NULL;
		$row['moto_e'] = NULL;
		$row['customer_id'] = NULL;
		$row['status'] = NULL;
		$row['address_e'] = NULL;
		$row['branch_e'] = NULL;
		$row['CreatedTime_e'] = NULL;
		$row['Status_n'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Price_e->FormValue == $this->Price_e->CurrentValue && is_numeric(ConvertToFloatString($this->Price_e->CurrentValue)))
			$this->Price_e->CurrentValue = ConvertToFloatString($this->Price_e->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// task_id
		// task_description
		// trans_type
		// contact_number
		// email_address
		// customer_name
		// delivery_date
		// delivery_address
		// team_id
		// driver_id
		// task_lat
		// task_lng
		// customer_signature
		// date_created
		// date_modified
		// ip_address
		// auto_assign_type
		// assign_started
		// assignment_status
		// dropoff_contact_name
		// dropoff_contact_number
		// drop_address
		// dropoff_task_lat
		// dropoff_task_lng
		// task_token
		// ratings
		// rating_comment
		// critical
		// souce_e
		// shop_code_e
		// Received_Channel_e
		// PayMethod_e
		// Type_e
		// Request_Code_e
		// Status_e
		// PlanType_e
		// Plan_e
		// Isdn_e
		// serial_sim_handset_e
		// handset_e
		// Connect_Reason_e
		// Price_e
		// Current_Operator_e
		// Current_Plan_Type_e
		// Document_Number_e
		// Document_Type_e
		// assignStaffCode_e
		// Delivery_Type_e
		// assignStaffType_e
		// receiveStaffCode_e
		// receiveStaffType_e
		// connectStaffCode_e
		// connectStaffType_e
		// shopName_e
		// saleOrderCode_e
		// consultantCode_e
		// consultantName_e
		// consultantType_e
		// created_By_e
		// createdBranch_e
		// generated_Code_By_e
		// approve_Paid_By_e
		// Delivery_Note_e
		// Delivery_Code_e
		// Customer_Note_e
		// saleOrderCreateDate_e
		// saleOrderPayDate_e
		// Time_of_Procesing_e
		// Time_of_new_e
		// Time_of_Finished_e
		// KPI_CC_Hour_e
		// KPI_NEW_Hour_e
		// KPI_PROCESING_Hour_e
		// KPI_ALL_Hour_e
		// Kpi_Register_Hour_e
		// Kpi_Bitel_Hour_e
		// AmountGB_e
		// Price_1_e
		// Status_1_e
		// Registered_Date_e
		// Sumary_e
		// Plans_e
		// Isdns_e
		// PlanTypes_e
		// Serials_e
		// Status_2_e
		// Registered_Date_2_e
		// Summary_2_e
		// serial_2_e
		// HandsetCode_e
		// HandsetName_e
		// Status_3_e
		// Summary_3_e
		// fecha_activa_e
		// mes_activa_e
		// SOURCE_OUT_e
		// fecha_crea_e
		// mes_crea_e
		// moto_e
		// customer_id
		// status
		// address_e
		// branch_e
		// CreatedTime_e
		// Status_n

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// task_id
			$this->task_id->ViewValue = $this->task_id->CurrentValue;
			$this->task_id->ViewCustomAttributes = "";

			// task_description
			$this->task_description->ViewValue = $this->task_description->CurrentValue;
			$this->task_description->ViewCustomAttributes = "";

			// trans_type
			$this->trans_type->ViewValue = $this->trans_type->CurrentValue;
			$this->trans_type->ViewCustomAttributes = "";

			// contact_number
			$this->contact_number->ViewValue = $this->contact_number->CurrentValue;
			$this->contact_number->ViewCustomAttributes = "";

			// email_address
			$this->email_address->ViewValue = $this->email_address->CurrentValue;
			$this->email_address->ViewCustomAttributes = "";

			// customer_name
			$this->customer_name->ViewValue = $this->customer_name->CurrentValue;
			$this->customer_name->ViewCustomAttributes = "";

			// delivery_date
			$this->delivery_date->ViewValue = $this->delivery_date->CurrentValue;
			$this->delivery_date->ViewValue = FormatDateTime($this->delivery_date->ViewValue, 0);
			$this->delivery_date->ViewCustomAttributes = "";

			// team_id
			$this->team_id->ViewValue = $this->team_id->CurrentValue;
			$this->team_id->ViewValue = FormatNumber($this->team_id->ViewValue, 0, -2, -2, -2);
			$this->team_id->ViewCustomAttributes = "";

			// driver_id
			$this->driver_id->ViewValue = $this->driver_id->CurrentValue;
			$this->driver_id->ViewValue = FormatNumber($this->driver_id->ViewValue, 0, -2, -2, -2);
			$this->driver_id->ViewCustomAttributes = "";

			// task_lat
			$this->task_lat->ViewValue = $this->task_lat->CurrentValue;
			$this->task_lat->ViewCustomAttributes = "";

			// task_lng
			$this->task_lng->ViewValue = $this->task_lng->CurrentValue;
			$this->task_lng->ViewCustomAttributes = "";

			// customer_signature
			$this->customer_signature->ViewValue = $this->customer_signature->CurrentValue;
			$this->customer_signature->ViewCustomAttributes = "";

			// date_created
			$this->date_created->ViewValue = $this->date_created->CurrentValue;
			$this->date_created->ViewValue = FormatDateTime($this->date_created->ViewValue, 0);
			$this->date_created->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = FormatDateTime($this->date_modified->ViewValue, 0);
			$this->date_modified->ViewCustomAttributes = "";

			// ip_address
			$this->ip_address->ViewValue = $this->ip_address->CurrentValue;
			$this->ip_address->ViewCustomAttributes = "";

			// auto_assign_type
			$this->auto_assign_type->ViewValue = $this->auto_assign_type->CurrentValue;
			$this->auto_assign_type->ViewCustomAttributes = "";

			// assign_started
			$this->assign_started->ViewValue = $this->assign_started->CurrentValue;
			$this->assign_started->ViewValue = FormatDateTime($this->assign_started->ViewValue, 0);
			$this->assign_started->ViewCustomAttributes = "";

			// assignment_status
			$this->assignment_status->ViewValue = $this->assignment_status->CurrentValue;
			$this->assignment_status->ViewCustomAttributes = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->ViewValue = $this->dropoff_contact_name->CurrentValue;
			$this->dropoff_contact_name->ViewCustomAttributes = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->ViewValue = $this->dropoff_contact_number->CurrentValue;
			$this->dropoff_contact_number->ViewCustomAttributes = "";

			// drop_address
			$this->drop_address->ViewValue = $this->drop_address->CurrentValue;
			$this->drop_address->ViewCustomAttributes = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->ViewValue = $this->dropoff_task_lat->CurrentValue;
			$this->dropoff_task_lat->ViewCustomAttributes = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->ViewValue = $this->dropoff_task_lng->CurrentValue;
			$this->dropoff_task_lng->ViewCustomAttributes = "";

			// task_token
			$this->task_token->ViewValue = $this->task_token->CurrentValue;
			$this->task_token->ViewCustomAttributes = "";

			// ratings
			$this->ratings->ViewValue = $this->ratings->CurrentValue;
			$this->ratings->ViewCustomAttributes = "";

			// rating_comment
			$this->rating_comment->ViewValue = $this->rating_comment->CurrentValue;
			$this->rating_comment->ViewCustomAttributes = "";

			// critical
			$this->critical->ViewValue = $this->critical->CurrentValue;
			$this->critical->ViewValue = FormatNumber($this->critical->ViewValue, 0, -2, -2, -2);
			$this->critical->ViewCustomAttributes = "";

			// souce_e
			$this->souce_e->ViewValue = $this->souce_e->CurrentValue;
			$this->souce_e->ViewCustomAttributes = "";

			// shop_code_e
			$this->shop_code_e->ViewValue = $this->shop_code_e->CurrentValue;
			$this->shop_code_e->ViewCustomAttributes = "";

			// Received_Channel_e
			$this->Received_Channel_e->ViewValue = $this->Received_Channel_e->CurrentValue;
			$this->Received_Channel_e->ViewCustomAttributes = "";

			// PayMethod_e
			$this->PayMethod_e->ViewValue = $this->PayMethod_e->CurrentValue;
			$this->PayMethod_e->ViewCustomAttributes = "";

			// Type_e
			$this->Type_e->ViewValue = $this->Type_e->CurrentValue;
			$this->Type_e->ViewCustomAttributes = "";

			// Request_Code_e
			$this->Request_Code_e->ViewValue = $this->Request_Code_e->CurrentValue;
			$this->Request_Code_e->ViewCustomAttributes = "";

			// Status_e
			$this->Status_e->ViewValue = $this->Status_e->CurrentValue;
			$this->Status_e->ViewCustomAttributes = "";

			// PlanType_e
			$this->PlanType_e->ViewValue = $this->PlanType_e->CurrentValue;
			$this->PlanType_e->ViewCustomAttributes = "";

			// Plan_e
			$this->Plan_e->ViewValue = $this->Plan_e->CurrentValue;
			$this->Plan_e->ViewCustomAttributes = "";

			// Isdn_e
			$this->Isdn_e->ViewValue = $this->Isdn_e->CurrentValue;
			$this->Isdn_e->ViewCustomAttributes = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->ViewValue = $this->serial_sim_handset_e->CurrentValue;
			$this->serial_sim_handset_e->ViewCustomAttributes = "";

			// handset_e
			$this->handset_e->ViewValue = $this->handset_e->CurrentValue;
			$this->handset_e->ViewCustomAttributes = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->ViewValue = $this->Connect_Reason_e->CurrentValue;
			$this->Connect_Reason_e->ViewCustomAttributes = "";

			// Price_e
			$this->Price_e->ViewValue = $this->Price_e->CurrentValue;
			$this->Price_e->ViewValue = FormatNumber($this->Price_e->ViewValue, 2, -2, -2, -2);
			$this->Price_e->ViewCustomAttributes = "";

			// Current_Operator_e
			$this->Current_Operator_e->ViewValue = $this->Current_Operator_e->CurrentValue;
			$this->Current_Operator_e->ViewCustomAttributes = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->ViewValue = $this->Current_Plan_Type_e->CurrentValue;
			$this->Current_Plan_Type_e->ViewCustomAttributes = "";

			// Document_Number_e
			$this->Document_Number_e->ViewValue = $this->Document_Number_e->CurrentValue;
			$this->Document_Number_e->ViewCustomAttributes = "";

			// Document_Type_e
			$this->Document_Type_e->ViewValue = $this->Document_Type_e->CurrentValue;
			$this->Document_Type_e->ViewCustomAttributes = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->ViewValue = $this->assignStaffCode_e->CurrentValue;
			$this->assignStaffCode_e->ViewCustomAttributes = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->ViewValue = $this->Delivery_Type_e->CurrentValue;
			$this->Delivery_Type_e->ViewCustomAttributes = "";

			// assignStaffType_e
			$this->assignStaffType_e->ViewValue = $this->assignStaffType_e->CurrentValue;
			$this->assignStaffType_e->ViewCustomAttributes = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->ViewValue = $this->receiveStaffCode_e->CurrentValue;
			$this->receiveStaffCode_e->ViewCustomAttributes = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->ViewValue = $this->receiveStaffType_e->CurrentValue;
			$this->receiveStaffType_e->ViewCustomAttributes = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->ViewValue = $this->connectStaffCode_e->CurrentValue;
			$this->connectStaffCode_e->ViewCustomAttributes = "";

			// connectStaffType_e
			$this->connectStaffType_e->ViewValue = $this->connectStaffType_e->CurrentValue;
			$this->connectStaffType_e->ViewCustomAttributes = "";

			// shopName_e
			$this->shopName_e->ViewValue = $this->shopName_e->CurrentValue;
			$this->shopName_e->ViewCustomAttributes = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->ViewValue = $this->saleOrderCode_e->CurrentValue;
			$this->saleOrderCode_e->ViewCustomAttributes = "";

			// consultantCode_e
			$this->consultantCode_e->ViewValue = $this->consultantCode_e->CurrentValue;
			$this->consultantCode_e->ViewCustomAttributes = "";

			// consultantName_e
			$this->consultantName_e->ViewValue = $this->consultantName_e->CurrentValue;
			$this->consultantName_e->ViewCustomAttributes = "";

			// consultantType_e
			$this->consultantType_e->ViewValue = $this->consultantType_e->CurrentValue;
			$this->consultantType_e->ViewCustomAttributes = "";

			// created_By_e
			$this->created_By_e->ViewValue = $this->created_By_e->CurrentValue;
			$this->created_By_e->ViewCustomAttributes = "";

			// createdBranch_e
			$this->createdBranch_e->ViewValue = $this->createdBranch_e->CurrentValue;
			$this->createdBranch_e->ViewCustomAttributes = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->ViewValue = $this->generated_Code_By_e->CurrentValue;
			$this->generated_Code_By_e->ViewCustomAttributes = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->ViewValue = $this->approve_Paid_By_e->CurrentValue;
			$this->approve_Paid_By_e->ViewCustomAttributes = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->ViewValue = $this->Delivery_Note_e->CurrentValue;
			$this->Delivery_Note_e->ViewCustomAttributes = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->ViewValue = $this->Delivery_Code_e->CurrentValue;
			$this->Delivery_Code_e->ViewCustomAttributes = "";

			// Customer_Note_e
			$this->Customer_Note_e->ViewValue = $this->Customer_Note_e->CurrentValue;
			$this->Customer_Note_e->ViewCustomAttributes = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->ViewValue = $this->saleOrderCreateDate_e->CurrentValue;
			$this->saleOrderCreateDate_e->ViewCustomAttributes = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->ViewValue = $this->saleOrderPayDate_e->CurrentValue;
			$this->saleOrderPayDate_e->ViewCustomAttributes = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->ViewValue = $this->Time_of_Procesing_e->CurrentValue;
			$this->Time_of_Procesing_e->ViewCustomAttributes = "";

			// Time_of_new_e
			$this->Time_of_new_e->ViewValue = $this->Time_of_new_e->CurrentValue;
			$this->Time_of_new_e->ViewCustomAttributes = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->ViewValue = $this->Time_of_Finished_e->CurrentValue;
			$this->Time_of_Finished_e->ViewCustomAttributes = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->ViewValue = $this->KPI_CC_Hour_e->CurrentValue;
			$this->KPI_CC_Hour_e->ViewCustomAttributes = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->ViewValue = $this->KPI_NEW_Hour_e->CurrentValue;
			$this->KPI_NEW_Hour_e->ViewCustomAttributes = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->ViewValue = $this->KPI_PROCESING_Hour_e->CurrentValue;
			$this->KPI_PROCESING_Hour_e->ViewCustomAttributes = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->ViewValue = $this->KPI_ALL_Hour_e->CurrentValue;
			$this->KPI_ALL_Hour_e->ViewCustomAttributes = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->ViewValue = $this->Kpi_Register_Hour_e->CurrentValue;
			$this->Kpi_Register_Hour_e->ViewCustomAttributes = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->ViewValue = $this->Kpi_Bitel_Hour_e->CurrentValue;
			$this->Kpi_Bitel_Hour_e->ViewCustomAttributes = "";

			// AmountGB_e
			$this->AmountGB_e->ViewValue = $this->AmountGB_e->CurrentValue;
			$this->AmountGB_e->ViewCustomAttributes = "";

			// Price_1_e
			$this->Price_1_e->ViewValue = $this->Price_1_e->CurrentValue;
			$this->Price_1_e->ViewCustomAttributes = "";

			// Status_1_e
			$this->Status_1_e->ViewValue = $this->Status_1_e->CurrentValue;
			$this->Status_1_e->ViewCustomAttributes = "";

			// Registered_Date_e
			$this->Registered_Date_e->ViewValue = $this->Registered_Date_e->CurrentValue;
			$this->Registered_Date_e->ViewCustomAttributes = "";

			// Sumary_e
			$this->Sumary_e->ViewValue = $this->Sumary_e->CurrentValue;
			$this->Sumary_e->ViewCustomAttributes = "";

			// Plans_e
			$this->Plans_e->ViewValue = $this->Plans_e->CurrentValue;
			$this->Plans_e->ViewCustomAttributes = "";

			// Isdns_e
			$this->Isdns_e->ViewValue = $this->Isdns_e->CurrentValue;
			$this->Isdns_e->ViewCustomAttributes = "";

			// PlanTypes_e
			$this->PlanTypes_e->ViewValue = $this->PlanTypes_e->CurrentValue;
			$this->PlanTypes_e->ViewCustomAttributes = "";

			// Serials_e
			$this->Serials_e->ViewValue = $this->Serials_e->CurrentValue;
			$this->Serials_e->ViewCustomAttributes = "";

			// Status_2_e
			$this->Status_2_e->ViewValue = $this->Status_2_e->CurrentValue;
			$this->Status_2_e->ViewCustomAttributes = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->ViewValue = $this->Registered_Date_2_e->CurrentValue;
			$this->Registered_Date_2_e->ViewCustomAttributes = "";

			// Summary_2_e
			$this->Summary_2_e->ViewValue = $this->Summary_2_e->CurrentValue;
			$this->Summary_2_e->ViewCustomAttributes = "";

			// serial_2_e
			$this->serial_2_e->ViewValue = $this->serial_2_e->CurrentValue;
			$this->serial_2_e->ViewCustomAttributes = "";

			// HandsetCode_e
			$this->HandsetCode_e->ViewValue = $this->HandsetCode_e->CurrentValue;
			$this->HandsetCode_e->ViewCustomAttributes = "";

			// HandsetName_e
			$this->HandsetName_e->ViewValue = $this->HandsetName_e->CurrentValue;
			$this->HandsetName_e->ViewCustomAttributes = "";

			// Status_3_e
			$this->Status_3_e->ViewValue = $this->Status_3_e->CurrentValue;
			$this->Status_3_e->ViewCustomAttributes = "";

			// Summary_3_e
			$this->Summary_3_e->ViewValue = $this->Summary_3_e->CurrentValue;
			$this->Summary_3_e->ViewCustomAttributes = "";

			// fecha_activa_e
			$this->fecha_activa_e->ViewValue = $this->fecha_activa_e->CurrentValue;
			$this->fecha_activa_e->ViewCustomAttributes = "";

			// mes_activa_e
			$this->mes_activa_e->ViewValue = $this->mes_activa_e->CurrentValue;
			$this->mes_activa_e->ViewCustomAttributes = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->ViewValue = $this->SOURCE_OUT_e->CurrentValue;
			$this->SOURCE_OUT_e->ViewCustomAttributes = "";

			// fecha_crea_e
			$this->fecha_crea_e->ViewValue = $this->fecha_crea_e->CurrentValue;
			$this->fecha_crea_e->ViewCustomAttributes = "";

			// mes_crea_e
			$this->mes_crea_e->ViewValue = $this->mes_crea_e->CurrentValue;
			$this->mes_crea_e->ViewCustomAttributes = "";

			// moto_e
			$this->moto_e->ViewValue = $this->moto_e->CurrentValue;
			$this->moto_e->ViewCustomAttributes = "";

			// customer_id
			$this->customer_id->ViewValue = $this->customer_id->CurrentValue;
			$this->customer_id->ViewValue = FormatNumber($this->customer_id->ViewValue, 0, -2, -2, -2);
			$this->customer_id->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewCustomAttributes = "";

			// branch_e
			$this->branch_e->ViewValue = $this->branch_e->CurrentValue;
			$this->branch_e->ViewCustomAttributes = "";

			// CreatedTime_e
			$this->CreatedTime_e->ViewValue = $this->CreatedTime_e->CurrentValue;
			$this->CreatedTime_e->ViewValue = FormatDateTime($this->CreatedTime_e->ViewValue, 0);
			$this->CreatedTime_e->ViewCustomAttributes = "";

			// Status_n
			$this->Status_n->ViewValue = $this->Status_n->CurrentValue;
			$this->Status_n->ViewValue = FormatNumber($this->Status_n->ViewValue, 0, -2, -2, -2);
			$this->Status_n->ViewCustomAttributes = "";

			// task_id
			$this->task_id->LinkCustomAttributes = "";
			$this->task_id->HrefValue = "";
			$this->task_id->TooltipValue = "";

			// task_description
			$this->task_description->LinkCustomAttributes = "";
			$this->task_description->HrefValue = "";
			$this->task_description->TooltipValue = "";

			// trans_type
			$this->trans_type->LinkCustomAttributes = "";
			$this->trans_type->HrefValue = "";
			$this->trans_type->TooltipValue = "";

			// contact_number
			$this->contact_number->LinkCustomAttributes = "";
			$this->contact_number->HrefValue = "";
			$this->contact_number->TooltipValue = "";

			// email_address
			$this->email_address->LinkCustomAttributes = "";
			$this->email_address->HrefValue = "";
			$this->email_address->TooltipValue = "";

			// customer_name
			$this->customer_name->LinkCustomAttributes = "";
			$this->customer_name->HrefValue = "";
			$this->customer_name->TooltipValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";
			$this->delivery_date->TooltipValue = "";

			// team_id
			$this->team_id->LinkCustomAttributes = "";
			$this->team_id->HrefValue = "";
			$this->team_id->TooltipValue = "";

			// driver_id
			$this->driver_id->LinkCustomAttributes = "";
			$this->driver_id->HrefValue = "";
			$this->driver_id->TooltipValue = "";

			// task_lat
			$this->task_lat->LinkCustomAttributes = "";
			$this->task_lat->HrefValue = "";
			$this->task_lat->TooltipValue = "";

			// task_lng
			$this->task_lng->LinkCustomAttributes = "";
			$this->task_lng->HrefValue = "";
			$this->task_lng->TooltipValue = "";

			// customer_signature
			$this->customer_signature->LinkCustomAttributes = "";
			$this->customer_signature->HrefValue = "";
			$this->customer_signature->TooltipValue = "";

			// date_created
			$this->date_created->LinkCustomAttributes = "";
			$this->date_created->HrefValue = "";
			$this->date_created->TooltipValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";
			$this->date_modified->TooltipValue = "";

			// ip_address
			$this->ip_address->LinkCustomAttributes = "";
			$this->ip_address->HrefValue = "";
			$this->ip_address->TooltipValue = "";

			// auto_assign_type
			$this->auto_assign_type->LinkCustomAttributes = "";
			$this->auto_assign_type->HrefValue = "";
			$this->auto_assign_type->TooltipValue = "";

			// assign_started
			$this->assign_started->LinkCustomAttributes = "";
			$this->assign_started->HrefValue = "";
			$this->assign_started->TooltipValue = "";

			// assignment_status
			$this->assignment_status->LinkCustomAttributes = "";
			$this->assignment_status->HrefValue = "";
			$this->assignment_status->TooltipValue = "";

			// dropoff_contact_name
			$this->dropoff_contact_name->LinkCustomAttributes = "";
			$this->dropoff_contact_name->HrefValue = "";
			$this->dropoff_contact_name->TooltipValue = "";

			// dropoff_contact_number
			$this->dropoff_contact_number->LinkCustomAttributes = "";
			$this->dropoff_contact_number->HrefValue = "";
			$this->dropoff_contact_number->TooltipValue = "";

			// drop_address
			$this->drop_address->LinkCustomAttributes = "";
			$this->drop_address->HrefValue = "";
			$this->drop_address->TooltipValue = "";

			// dropoff_task_lat
			$this->dropoff_task_lat->LinkCustomAttributes = "";
			$this->dropoff_task_lat->HrefValue = "";
			$this->dropoff_task_lat->TooltipValue = "";

			// dropoff_task_lng
			$this->dropoff_task_lng->LinkCustomAttributes = "";
			$this->dropoff_task_lng->HrefValue = "";
			$this->dropoff_task_lng->TooltipValue = "";

			// task_token
			$this->task_token->LinkCustomAttributes = "";
			$this->task_token->HrefValue = "";
			$this->task_token->TooltipValue = "";

			// ratings
			$this->ratings->LinkCustomAttributes = "";
			$this->ratings->HrefValue = "";
			$this->ratings->TooltipValue = "";

			// rating_comment
			$this->rating_comment->LinkCustomAttributes = "";
			$this->rating_comment->HrefValue = "";
			$this->rating_comment->TooltipValue = "";

			// critical
			$this->critical->LinkCustomAttributes = "";
			$this->critical->HrefValue = "";
			$this->critical->TooltipValue = "";

			// souce_e
			$this->souce_e->LinkCustomAttributes = "";
			$this->souce_e->HrefValue = "";
			$this->souce_e->TooltipValue = "";

			// shop_code_e
			$this->shop_code_e->LinkCustomAttributes = "";
			$this->shop_code_e->HrefValue = "";
			$this->shop_code_e->TooltipValue = "";

			// Received_Channel_e
			$this->Received_Channel_e->LinkCustomAttributes = "";
			$this->Received_Channel_e->HrefValue = "";
			$this->Received_Channel_e->TooltipValue = "";

			// PayMethod_e
			$this->PayMethod_e->LinkCustomAttributes = "";
			$this->PayMethod_e->HrefValue = "";
			$this->PayMethod_e->TooltipValue = "";

			// Type_e
			$this->Type_e->LinkCustomAttributes = "";
			$this->Type_e->HrefValue = "";
			$this->Type_e->TooltipValue = "";

			// Request_Code_e
			$this->Request_Code_e->LinkCustomAttributes = "";
			$this->Request_Code_e->HrefValue = "";
			$this->Request_Code_e->TooltipValue = "";

			// Status_e
			$this->Status_e->LinkCustomAttributes = "";
			$this->Status_e->HrefValue = "";
			$this->Status_e->TooltipValue = "";

			// PlanType_e
			$this->PlanType_e->LinkCustomAttributes = "";
			$this->PlanType_e->HrefValue = "";
			$this->PlanType_e->TooltipValue = "";

			// Plan_e
			$this->Plan_e->LinkCustomAttributes = "";
			$this->Plan_e->HrefValue = "";
			$this->Plan_e->TooltipValue = "";

			// Isdn_e
			$this->Isdn_e->LinkCustomAttributes = "";
			$this->Isdn_e->HrefValue = "";
			$this->Isdn_e->TooltipValue = "";

			// serial_sim_handset_e
			$this->serial_sim_handset_e->LinkCustomAttributes = "";
			$this->serial_sim_handset_e->HrefValue = "";
			$this->serial_sim_handset_e->TooltipValue = "";

			// handset_e
			$this->handset_e->LinkCustomAttributes = "";
			$this->handset_e->HrefValue = "";
			$this->handset_e->TooltipValue = "";

			// Connect_Reason_e
			$this->Connect_Reason_e->LinkCustomAttributes = "";
			$this->Connect_Reason_e->HrefValue = "";
			$this->Connect_Reason_e->TooltipValue = "";

			// Price_e
			$this->Price_e->LinkCustomAttributes = "";
			$this->Price_e->HrefValue = "";
			$this->Price_e->TooltipValue = "";

			// Current_Operator_e
			$this->Current_Operator_e->LinkCustomAttributes = "";
			$this->Current_Operator_e->HrefValue = "";
			$this->Current_Operator_e->TooltipValue = "";

			// Current_Plan_Type_e
			$this->Current_Plan_Type_e->LinkCustomAttributes = "";
			$this->Current_Plan_Type_e->HrefValue = "";
			$this->Current_Plan_Type_e->TooltipValue = "";

			// Document_Number_e
			$this->Document_Number_e->LinkCustomAttributes = "";
			$this->Document_Number_e->HrefValue = "";
			$this->Document_Number_e->TooltipValue = "";

			// Document_Type_e
			$this->Document_Type_e->LinkCustomAttributes = "";
			$this->Document_Type_e->HrefValue = "";
			$this->Document_Type_e->TooltipValue = "";

			// assignStaffCode_e
			$this->assignStaffCode_e->LinkCustomAttributes = "";
			$this->assignStaffCode_e->HrefValue = "";
			$this->assignStaffCode_e->TooltipValue = "";

			// Delivery_Type_e
			$this->Delivery_Type_e->LinkCustomAttributes = "";
			$this->Delivery_Type_e->HrefValue = "";
			$this->Delivery_Type_e->TooltipValue = "";

			// assignStaffType_e
			$this->assignStaffType_e->LinkCustomAttributes = "";
			$this->assignStaffType_e->HrefValue = "";
			$this->assignStaffType_e->TooltipValue = "";

			// receiveStaffCode_e
			$this->receiveStaffCode_e->LinkCustomAttributes = "";
			$this->receiveStaffCode_e->HrefValue = "";
			$this->receiveStaffCode_e->TooltipValue = "";

			// receiveStaffType_e
			$this->receiveStaffType_e->LinkCustomAttributes = "";
			$this->receiveStaffType_e->HrefValue = "";
			$this->receiveStaffType_e->TooltipValue = "";

			// connectStaffCode_e
			$this->connectStaffCode_e->LinkCustomAttributes = "";
			$this->connectStaffCode_e->HrefValue = "";
			$this->connectStaffCode_e->TooltipValue = "";

			// connectStaffType_e
			$this->connectStaffType_e->LinkCustomAttributes = "";
			$this->connectStaffType_e->HrefValue = "";
			$this->connectStaffType_e->TooltipValue = "";

			// shopName_e
			$this->shopName_e->LinkCustomAttributes = "";
			$this->shopName_e->HrefValue = "";
			$this->shopName_e->TooltipValue = "";

			// saleOrderCode_e
			$this->saleOrderCode_e->LinkCustomAttributes = "";
			$this->saleOrderCode_e->HrefValue = "";
			$this->saleOrderCode_e->TooltipValue = "";

			// consultantCode_e
			$this->consultantCode_e->LinkCustomAttributes = "";
			$this->consultantCode_e->HrefValue = "";
			$this->consultantCode_e->TooltipValue = "";

			// consultantName_e
			$this->consultantName_e->LinkCustomAttributes = "";
			$this->consultantName_e->HrefValue = "";
			$this->consultantName_e->TooltipValue = "";

			// consultantType_e
			$this->consultantType_e->LinkCustomAttributes = "";
			$this->consultantType_e->HrefValue = "";
			$this->consultantType_e->TooltipValue = "";

			// created_By_e
			$this->created_By_e->LinkCustomAttributes = "";
			$this->created_By_e->HrefValue = "";
			$this->created_By_e->TooltipValue = "";

			// createdBranch_e
			$this->createdBranch_e->LinkCustomAttributes = "";
			$this->createdBranch_e->HrefValue = "";
			$this->createdBranch_e->TooltipValue = "";

			// generated_Code_By_e
			$this->generated_Code_By_e->LinkCustomAttributes = "";
			$this->generated_Code_By_e->HrefValue = "";
			$this->generated_Code_By_e->TooltipValue = "";

			// approve_Paid_By_e
			$this->approve_Paid_By_e->LinkCustomAttributes = "";
			$this->approve_Paid_By_e->HrefValue = "";
			$this->approve_Paid_By_e->TooltipValue = "";

			// Delivery_Note_e
			$this->Delivery_Note_e->LinkCustomAttributes = "";
			$this->Delivery_Note_e->HrefValue = "";
			$this->Delivery_Note_e->TooltipValue = "";

			// Delivery_Code_e
			$this->Delivery_Code_e->LinkCustomAttributes = "";
			$this->Delivery_Code_e->HrefValue = "";
			$this->Delivery_Code_e->TooltipValue = "";

			// Customer_Note_e
			$this->Customer_Note_e->LinkCustomAttributes = "";
			$this->Customer_Note_e->HrefValue = "";
			$this->Customer_Note_e->TooltipValue = "";

			// saleOrderCreateDate_e
			$this->saleOrderCreateDate_e->LinkCustomAttributes = "";
			$this->saleOrderCreateDate_e->HrefValue = "";
			$this->saleOrderCreateDate_e->TooltipValue = "";

			// saleOrderPayDate_e
			$this->saleOrderPayDate_e->LinkCustomAttributes = "";
			$this->saleOrderPayDate_e->HrefValue = "";
			$this->saleOrderPayDate_e->TooltipValue = "";

			// Time_of_Procesing_e
			$this->Time_of_Procesing_e->LinkCustomAttributes = "";
			$this->Time_of_Procesing_e->HrefValue = "";
			$this->Time_of_Procesing_e->TooltipValue = "";

			// Time_of_new_e
			$this->Time_of_new_e->LinkCustomAttributes = "";
			$this->Time_of_new_e->HrefValue = "";
			$this->Time_of_new_e->TooltipValue = "";

			// Time_of_Finished_e
			$this->Time_of_Finished_e->LinkCustomAttributes = "";
			$this->Time_of_Finished_e->HrefValue = "";
			$this->Time_of_Finished_e->TooltipValue = "";

			// KPI_CC_Hour_e
			$this->KPI_CC_Hour_e->LinkCustomAttributes = "";
			$this->KPI_CC_Hour_e->HrefValue = "";
			$this->KPI_CC_Hour_e->TooltipValue = "";

			// KPI_NEW_Hour_e
			$this->KPI_NEW_Hour_e->LinkCustomAttributes = "";
			$this->KPI_NEW_Hour_e->HrefValue = "";
			$this->KPI_NEW_Hour_e->TooltipValue = "";

			// KPI_PROCESING_Hour_e
			$this->KPI_PROCESING_Hour_e->LinkCustomAttributes = "";
			$this->KPI_PROCESING_Hour_e->HrefValue = "";
			$this->KPI_PROCESING_Hour_e->TooltipValue = "";

			// KPI_ALL_Hour_e
			$this->KPI_ALL_Hour_e->LinkCustomAttributes = "";
			$this->KPI_ALL_Hour_e->HrefValue = "";
			$this->KPI_ALL_Hour_e->TooltipValue = "";

			// Kpi_Register_Hour_e
			$this->Kpi_Register_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Register_Hour_e->HrefValue = "";
			$this->Kpi_Register_Hour_e->TooltipValue = "";

			// Kpi_Bitel_Hour_e
			$this->Kpi_Bitel_Hour_e->LinkCustomAttributes = "";
			$this->Kpi_Bitel_Hour_e->HrefValue = "";
			$this->Kpi_Bitel_Hour_e->TooltipValue = "";

			// AmountGB_e
			$this->AmountGB_e->LinkCustomAttributes = "";
			$this->AmountGB_e->HrefValue = "";
			$this->AmountGB_e->TooltipValue = "";

			// Price_1_e
			$this->Price_1_e->LinkCustomAttributes = "";
			$this->Price_1_e->HrefValue = "";
			$this->Price_1_e->TooltipValue = "";

			// Status_1_e
			$this->Status_1_e->LinkCustomAttributes = "";
			$this->Status_1_e->HrefValue = "";
			$this->Status_1_e->TooltipValue = "";

			// Registered_Date_e
			$this->Registered_Date_e->LinkCustomAttributes = "";
			$this->Registered_Date_e->HrefValue = "";
			$this->Registered_Date_e->TooltipValue = "";

			// Sumary_e
			$this->Sumary_e->LinkCustomAttributes = "";
			$this->Sumary_e->HrefValue = "";
			$this->Sumary_e->TooltipValue = "";

			// Plans_e
			$this->Plans_e->LinkCustomAttributes = "";
			$this->Plans_e->HrefValue = "";
			$this->Plans_e->TooltipValue = "";

			// Isdns_e
			$this->Isdns_e->LinkCustomAttributes = "";
			$this->Isdns_e->HrefValue = "";
			$this->Isdns_e->TooltipValue = "";

			// PlanTypes_e
			$this->PlanTypes_e->LinkCustomAttributes = "";
			$this->PlanTypes_e->HrefValue = "";
			$this->PlanTypes_e->TooltipValue = "";

			// Serials_e
			$this->Serials_e->LinkCustomAttributes = "";
			$this->Serials_e->HrefValue = "";
			$this->Serials_e->TooltipValue = "";

			// Status_2_e
			$this->Status_2_e->LinkCustomAttributes = "";
			$this->Status_2_e->HrefValue = "";
			$this->Status_2_e->TooltipValue = "";

			// Registered_Date_2_e
			$this->Registered_Date_2_e->LinkCustomAttributes = "";
			$this->Registered_Date_2_e->HrefValue = "";
			$this->Registered_Date_2_e->TooltipValue = "";

			// Summary_2_e
			$this->Summary_2_e->LinkCustomAttributes = "";
			$this->Summary_2_e->HrefValue = "";
			$this->Summary_2_e->TooltipValue = "";

			// serial_2_e
			$this->serial_2_e->LinkCustomAttributes = "";
			$this->serial_2_e->HrefValue = "";
			$this->serial_2_e->TooltipValue = "";

			// HandsetCode_e
			$this->HandsetCode_e->LinkCustomAttributes = "";
			$this->HandsetCode_e->HrefValue = "";
			$this->HandsetCode_e->TooltipValue = "";

			// HandsetName_e
			$this->HandsetName_e->LinkCustomAttributes = "";
			$this->HandsetName_e->HrefValue = "";
			$this->HandsetName_e->TooltipValue = "";

			// Status_3_e
			$this->Status_3_e->LinkCustomAttributes = "";
			$this->Status_3_e->HrefValue = "";
			$this->Status_3_e->TooltipValue = "";

			// Summary_3_e
			$this->Summary_3_e->LinkCustomAttributes = "";
			$this->Summary_3_e->HrefValue = "";
			$this->Summary_3_e->TooltipValue = "";

			// fecha_activa_e
			$this->fecha_activa_e->LinkCustomAttributes = "";
			$this->fecha_activa_e->HrefValue = "";
			$this->fecha_activa_e->TooltipValue = "";

			// mes_activa_e
			$this->mes_activa_e->LinkCustomAttributes = "";
			$this->mes_activa_e->HrefValue = "";
			$this->mes_activa_e->TooltipValue = "";

			// SOURCE_OUT_e
			$this->SOURCE_OUT_e->LinkCustomAttributes = "";
			$this->SOURCE_OUT_e->HrefValue = "";
			$this->SOURCE_OUT_e->TooltipValue = "";

			// fecha_crea_e
			$this->fecha_crea_e->LinkCustomAttributes = "";
			$this->fecha_crea_e->HrefValue = "";
			$this->fecha_crea_e->TooltipValue = "";

			// mes_crea_e
			$this->mes_crea_e->LinkCustomAttributes = "";
			$this->mes_crea_e->HrefValue = "";
			$this->mes_crea_e->TooltipValue = "";

			// moto_e
			$this->moto_e->LinkCustomAttributes = "";
			$this->moto_e->HrefValue = "";
			$this->moto_e->TooltipValue = "";

			// customer_id
			$this->customer_id->LinkCustomAttributes = "";
			$this->customer_id->HrefValue = "";
			$this->customer_id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// branch_e
			$this->branch_e->LinkCustomAttributes = "";
			$this->branch_e->HrefValue = "";
			$this->branch_e->TooltipValue = "";

			// CreatedTime_e
			$this->CreatedTime_e->LinkCustomAttributes = "";
			$this->CreatedTime_e->HrefValue = "";
			$this->CreatedTime_e->TooltipValue = "";

			// Status_n
			$this->Status_n->LinkCustomAttributes = "";
			$this->Status_n->HrefValue = "";
			$this->Status_n->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['task_id'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("kt_driver_tasklist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>