<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class lotes_add extends lotes
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'lotes';

	// Page object name
	public $PageObjName = "lotes_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (lotes)
		if (!isset($GLOBALS["lotes"]) || get_class($GLOBALS["lotes"]) == PROJECT_NAMESPACE . "lotes") {
			$GLOBALS["lotes"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["lotes"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'lotes');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $lotes;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($lotes);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "lotesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("loteslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_producto->Visible = FALSE;
		$this->id_proyecto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->setVisibility();
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->setVisibility();
		$this->descripcion1->setVisibility();
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->lote->setVisibility();
		$this->manzana->setVisibility();
		$this->etapa->setVisibility();
		$this->estado->setVisibility();
		$this->icon->setVisibility();
		$this->topy->setVisibility();
		$this->leftx->setVisibility();
		$this->codlogin->setVisibility();
		$this->id_cliente->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id_producto") !== NULL) {
				$this->id_producto->setQueryStringValue(Get("id_producto"));
				$this->setKey("id_producto", $this->id_producto->CurrentValue); // Set up key
			} else {
				$this->setKey("id_producto", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("loteslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "loteslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "lotesview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id_producto->CurrentValue = NULL;
		$this->id_producto->OldValue = $this->id_producto->CurrentValue;
		$this->id_proyecto->CurrentValue = NULL;
		$this->id_proyecto->OldValue = $this->id_proyecto->CurrentValue;
		$this->codigo_producto->CurrentValue = NULL;
		$this->codigo_producto->OldValue = $this->codigo_producto->CurrentValue;
		$this->nombre_producto->CurrentValue = NULL;
		$this->nombre_producto->OldValue = $this->nombre_producto->CurrentValue;
		$this->status_producto->CurrentValue = NULL;
		$this->status_producto->OldValue = $this->status_producto->CurrentValue;
		$this->date_added->CurrentValue = NULL;
		$this->date_added->OldValue = $this->date_added->CurrentValue;
		$this->precio_producto->CurrentValue = NULL;
		$this->precio_producto->OldValue = $this->precio_producto->CurrentValue;
		$this->costo_producto->CurrentValue = NULL;
		$this->costo_producto->OldValue = $this->costo_producto->CurrentValue;
		$this->mon_costo->CurrentValue = NULL;
		$this->mon_costo->OldValue = $this->mon_costo->CurrentValue;
		$this->mon_venta->CurrentValue = NULL;
		$this->mon_venta->OldValue = $this->mon_venta->CurrentValue;
		$this->marca->CurrentValue = NULL;
		$this->marca->OldValue = $this->marca->CurrentValue;
		$this->modelo->CurrentValue = NULL;
		$this->modelo->OldValue = $this->modelo->CurrentValue;
		$this->color->CurrentValue = NULL;
		$this->color->OldValue = $this->color->CurrentValue;
		$this->b1->CurrentValue = NULL;
		$this->b1->OldValue = $this->b1->CurrentValue;
		$this->b2->CurrentValue = NULL;
		$this->b2->OldValue = $this->b2->CurrentValue;
		$this->b3->CurrentValue = NULL;
		$this->b3->OldValue = $this->b3->CurrentValue;
		$this->b4->CurrentValue = NULL;
		$this->b4->OldValue = $this->b4->CurrentValue;
		$this->b5->CurrentValue = NULL;
		$this->b5->OldValue = $this->b5->CurrentValue;
		$this->b6->CurrentValue = NULL;
		$this->b6->OldValue = $this->b6->CurrentValue;
		$this->cat_pro->CurrentValue = NULL;
		$this->cat_pro->OldValue = $this->cat_pro->CurrentValue;
		$this->pro_ser->CurrentValue = NULL;
		$this->pro_ser->OldValue = $this->pro_ser->CurrentValue;
		$this->foto1->CurrentValue = NULL;
		$this->foto1->OldValue = $this->foto1->CurrentValue;
		$this->foto2->CurrentValue = NULL;
		$this->foto2->OldValue = $this->foto2->CurrentValue;
		$this->foto3->CurrentValue = NULL;
		$this->foto3->OldValue = $this->foto3->CurrentValue;
		$this->foto4->CurrentValue = NULL;
		$this->foto4->OldValue = $this->foto4->CurrentValue;
		$this->web->CurrentValue = NULL;
		$this->web->OldValue = $this->web->CurrentValue;
		$this->pre_web->CurrentValue = NULL;
		$this->pre_web->OldValue = $this->pre_web->CurrentValue;
		$this->descripcion->CurrentValue = NULL;
		$this->descripcion->OldValue = $this->descripcion->CurrentValue;
		$this->descripcion1->CurrentValue = NULL;
		$this->descripcion1->OldValue = $this->descripcion1->CurrentValue;
		$this->megusta->CurrentValue = NULL;
		$this->megusta->OldValue = $this->megusta->CurrentValue;
		$this->nomegusta->CurrentValue = NULL;
		$this->nomegusta->OldValue = $this->nomegusta->CurrentValue;
		$this->precio2->CurrentValue = NULL;
		$this->precio2->OldValue = $this->precio2->CurrentValue;
		$this->precio3->CurrentValue = NULL;
		$this->precio3->OldValue = $this->precio3->CurrentValue;
		$this->und_pro->CurrentValue = NULL;
		$this->und_pro->OldValue = $this->und_pro->CurrentValue;
		$this->barras->CurrentValue = NULL;
		$this->barras->OldValue = $this->barras->CurrentValue;
		$this->stockmin->CurrentValue = 0.00;
		$this->id_grupo->CurrentValue = 0;
		$this->talla->CurrentValue = NULL;
		$this->talla->OldValue = $this->talla->CurrentValue;
		$this->mostrarcolor->CurrentValue = 0;
		$this->lote->CurrentValue = NULL;
		$this->lote->OldValue = $this->lote->CurrentValue;
		$this->manzana->CurrentValue = NULL;
		$this->manzana->OldValue = $this->manzana->CurrentValue;
		$this->etapa->CurrentValue = 1;
		$this->estado->CurrentValue = 1;
		$this->icon->CurrentValue = NULL;
		$this->icon->OldValue = $this->icon->CurrentValue;
		$this->topy->CurrentValue = NULL;
		$this->topy->OldValue = $this->topy->CurrentValue;
		$this->leftx->CurrentValue = NULL;
		$this->leftx->OldValue = $this->leftx->CurrentValue;
		$this->codlogin->CurrentValue = NULL;
		$this->codlogin->OldValue = $this->codlogin->CurrentValue;
		$this->id_cliente->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id_proyecto' first before field var 'x_id_proyecto'
		$val = $CurrentForm->hasValue("id_proyecto") ? $CurrentForm->getValue("id_proyecto") : $CurrentForm->getValue("x_id_proyecto");
		if (!$this->id_proyecto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_proyecto->Visible = FALSE; // Disable update for API request
			else
				$this->id_proyecto->setFormValue($val);
		}

		// Check field name 'codigo_producto' first before field var 'x_codigo_producto'
		$val = $CurrentForm->hasValue("codigo_producto") ? $CurrentForm->getValue("codigo_producto") : $CurrentForm->getValue("x_codigo_producto");
		if (!$this->codigo_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codigo_producto->Visible = FALSE; // Disable update for API request
			else
				$this->codigo_producto->setFormValue($val);
		}

		// Check field name 'nombre_producto' first before field var 'x_nombre_producto'
		$val = $CurrentForm->hasValue("nombre_producto") ? $CurrentForm->getValue("nombre_producto") : $CurrentForm->getValue("x_nombre_producto");
		if (!$this->nombre_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nombre_producto->Visible = FALSE; // Disable update for API request
			else
				$this->nombre_producto->setFormValue($val);
		}

		// Check field name 'status_producto' first before field var 'x_status_producto'
		$val = $CurrentForm->hasValue("status_producto") ? $CurrentForm->getValue("status_producto") : $CurrentForm->getValue("x_status_producto");
		if (!$this->status_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_producto->Visible = FALSE; // Disable update for API request
			else
				$this->status_producto->setFormValue($val);
		}

		// Check field name 'date_added' first before field var 'x_date_added'
		$val = $CurrentForm->hasValue("date_added") ? $CurrentForm->getValue("date_added") : $CurrentForm->getValue("x_date_added");
		if (!$this->date_added->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->date_added->Visible = FALSE; // Disable update for API request
			else
				$this->date_added->setFormValue($val);
			$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		}

		// Check field name 'precio_producto' first before field var 'x_precio_producto'
		$val = $CurrentForm->hasValue("precio_producto") ? $CurrentForm->getValue("precio_producto") : $CurrentForm->getValue("x_precio_producto");
		if (!$this->precio_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio_producto->Visible = FALSE; // Disable update for API request
			else
				$this->precio_producto->setFormValue($val);
		}

		// Check field name 'costo_producto' first before field var 'x_costo_producto'
		$val = $CurrentForm->hasValue("costo_producto") ? $CurrentForm->getValue("costo_producto") : $CurrentForm->getValue("x_costo_producto");
		if (!$this->costo_producto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->costo_producto->Visible = FALSE; // Disable update for API request
			else
				$this->costo_producto->setFormValue($val);
		}

		// Check field name 'mon_costo' first before field var 'x_mon_costo'
		$val = $CurrentForm->hasValue("mon_costo") ? $CurrentForm->getValue("mon_costo") : $CurrentForm->getValue("x_mon_costo");
		if (!$this->mon_costo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mon_costo->Visible = FALSE; // Disable update for API request
			else
				$this->mon_costo->setFormValue($val);
		}

		// Check field name 'mon_venta' first before field var 'x_mon_venta'
		$val = $CurrentForm->hasValue("mon_venta") ? $CurrentForm->getValue("mon_venta") : $CurrentForm->getValue("x_mon_venta");
		if (!$this->mon_venta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mon_venta->Visible = FALSE; // Disable update for API request
			else
				$this->mon_venta->setFormValue($val);
		}

		// Check field name 'marca' first before field var 'x_marca'
		$val = $CurrentForm->hasValue("marca") ? $CurrentForm->getValue("marca") : $CurrentForm->getValue("x_marca");
		if (!$this->marca->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->marca->Visible = FALSE; // Disable update for API request
			else
				$this->marca->setFormValue($val);
		}

		// Check field name 'modelo' first before field var 'x_modelo'
		$val = $CurrentForm->hasValue("modelo") ? $CurrentForm->getValue("modelo") : $CurrentForm->getValue("x_modelo");
		if (!$this->modelo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->modelo->Visible = FALSE; // Disable update for API request
			else
				$this->modelo->setFormValue($val);
		}

		// Check field name 'color' first before field var 'x_color'
		$val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
		if (!$this->color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color->Visible = FALSE; // Disable update for API request
			else
				$this->color->setFormValue($val);
		}

		// Check field name 'b1' first before field var 'x_b1'
		$val = $CurrentForm->hasValue("b1") ? $CurrentForm->getValue("b1") : $CurrentForm->getValue("x_b1");
		if (!$this->b1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b1->Visible = FALSE; // Disable update for API request
			else
				$this->b1->setFormValue($val);
		}

		// Check field name 'b2' first before field var 'x_b2'
		$val = $CurrentForm->hasValue("b2") ? $CurrentForm->getValue("b2") : $CurrentForm->getValue("x_b2");
		if (!$this->b2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b2->Visible = FALSE; // Disable update for API request
			else
				$this->b2->setFormValue($val);
		}

		// Check field name 'b3' first before field var 'x_b3'
		$val = $CurrentForm->hasValue("b3") ? $CurrentForm->getValue("b3") : $CurrentForm->getValue("x_b3");
		if (!$this->b3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b3->Visible = FALSE; // Disable update for API request
			else
				$this->b3->setFormValue($val);
		}

		// Check field name 'b4' first before field var 'x_b4'
		$val = $CurrentForm->hasValue("b4") ? $CurrentForm->getValue("b4") : $CurrentForm->getValue("x_b4");
		if (!$this->b4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b4->Visible = FALSE; // Disable update for API request
			else
				$this->b4->setFormValue($val);
		}

		// Check field name 'b5' first before field var 'x_b5'
		$val = $CurrentForm->hasValue("b5") ? $CurrentForm->getValue("b5") : $CurrentForm->getValue("x_b5");
		if (!$this->b5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b5->Visible = FALSE; // Disable update for API request
			else
				$this->b5->setFormValue($val);
		}

		// Check field name 'b6' first before field var 'x_b6'
		$val = $CurrentForm->hasValue("b6") ? $CurrentForm->getValue("b6") : $CurrentForm->getValue("x_b6");
		if (!$this->b6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b6->Visible = FALSE; // Disable update for API request
			else
				$this->b6->setFormValue($val);
		}

		// Check field name 'cat_pro' first before field var 'x_cat_pro'
		$val = $CurrentForm->hasValue("cat_pro") ? $CurrentForm->getValue("cat_pro") : $CurrentForm->getValue("x_cat_pro");
		if (!$this->cat_pro->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cat_pro->Visible = FALSE; // Disable update for API request
			else
				$this->cat_pro->setFormValue($val);
		}

		// Check field name 'pro_ser' first before field var 'x_pro_ser'
		$val = $CurrentForm->hasValue("pro_ser") ? $CurrentForm->getValue("pro_ser") : $CurrentForm->getValue("x_pro_ser");
		if (!$this->pro_ser->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pro_ser->Visible = FALSE; // Disable update for API request
			else
				$this->pro_ser->setFormValue($val);
		}

		// Check field name 'foto1' first before field var 'x_foto1'
		$val = $CurrentForm->hasValue("foto1") ? $CurrentForm->getValue("foto1") : $CurrentForm->getValue("x_foto1");
		if (!$this->foto1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto1->Visible = FALSE; // Disable update for API request
			else
				$this->foto1->setFormValue($val);
		}

		// Check field name 'foto2' first before field var 'x_foto2'
		$val = $CurrentForm->hasValue("foto2") ? $CurrentForm->getValue("foto2") : $CurrentForm->getValue("x_foto2");
		if (!$this->foto2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto2->Visible = FALSE; // Disable update for API request
			else
				$this->foto2->setFormValue($val);
		}

		// Check field name 'foto3' first before field var 'x_foto3'
		$val = $CurrentForm->hasValue("foto3") ? $CurrentForm->getValue("foto3") : $CurrentForm->getValue("x_foto3");
		if (!$this->foto3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto3->Visible = FALSE; // Disable update for API request
			else
				$this->foto3->setFormValue($val);
		}

		// Check field name 'foto4' first before field var 'x_foto4'
		$val = $CurrentForm->hasValue("foto4") ? $CurrentForm->getValue("foto4") : $CurrentForm->getValue("x_foto4");
		if (!$this->foto4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->foto4->Visible = FALSE; // Disable update for API request
			else
				$this->foto4->setFormValue($val);
		}

		// Check field name 'web' first before field var 'x_web'
		$val = $CurrentForm->hasValue("web") ? $CurrentForm->getValue("web") : $CurrentForm->getValue("x_web");
		if (!$this->web->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->web->Visible = FALSE; // Disable update for API request
			else
				$this->web->setFormValue($val);
		}

		// Check field name 'pre_web' first before field var 'x_pre_web'
		$val = $CurrentForm->hasValue("pre_web") ? $CurrentForm->getValue("pre_web") : $CurrentForm->getValue("x_pre_web");
		if (!$this->pre_web->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pre_web->Visible = FALSE; // Disable update for API request
			else
				$this->pre_web->setFormValue($val);
		}

		// Check field name 'descripcion' first before field var 'x_descripcion'
		$val = $CurrentForm->hasValue("descripcion") ? $CurrentForm->getValue("descripcion") : $CurrentForm->getValue("x_descripcion");
		if (!$this->descripcion->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcion->Visible = FALSE; // Disable update for API request
			else
				$this->descripcion->setFormValue($val);
		}

		// Check field name 'descripcion1' first before field var 'x_descripcion1'
		$val = $CurrentForm->hasValue("descripcion1") ? $CurrentForm->getValue("descripcion1") : $CurrentForm->getValue("x_descripcion1");
		if (!$this->descripcion1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->descripcion1->Visible = FALSE; // Disable update for API request
			else
				$this->descripcion1->setFormValue($val);
		}

		// Check field name 'megusta' first before field var 'x_megusta'
		$val = $CurrentForm->hasValue("megusta") ? $CurrentForm->getValue("megusta") : $CurrentForm->getValue("x_megusta");
		if (!$this->megusta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->megusta->Visible = FALSE; // Disable update for API request
			else
				$this->megusta->setFormValue($val);
		}

		// Check field name 'nomegusta' first before field var 'x_nomegusta'
		$val = $CurrentForm->hasValue("nomegusta") ? $CurrentForm->getValue("nomegusta") : $CurrentForm->getValue("x_nomegusta");
		if (!$this->nomegusta->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nomegusta->Visible = FALSE; // Disable update for API request
			else
				$this->nomegusta->setFormValue($val);
		}

		// Check field name 'precio2' first before field var 'x_precio2'
		$val = $CurrentForm->hasValue("precio2") ? $CurrentForm->getValue("precio2") : $CurrentForm->getValue("x_precio2");
		if (!$this->precio2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio2->Visible = FALSE; // Disable update for API request
			else
				$this->precio2->setFormValue($val);
		}

		// Check field name 'precio3' first before field var 'x_precio3'
		$val = $CurrentForm->hasValue("precio3") ? $CurrentForm->getValue("precio3") : $CurrentForm->getValue("x_precio3");
		if (!$this->precio3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->precio3->Visible = FALSE; // Disable update for API request
			else
				$this->precio3->setFormValue($val);
		}

		// Check field name 'und_pro' first before field var 'x_und_pro'
		$val = $CurrentForm->hasValue("und_pro") ? $CurrentForm->getValue("und_pro") : $CurrentForm->getValue("x_und_pro");
		if (!$this->und_pro->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->und_pro->Visible = FALSE; // Disable update for API request
			else
				$this->und_pro->setFormValue($val);
		}

		// Check field name 'barras' first before field var 'x_barras'
		$val = $CurrentForm->hasValue("barras") ? $CurrentForm->getValue("barras") : $CurrentForm->getValue("x_barras");
		if (!$this->barras->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->barras->Visible = FALSE; // Disable update for API request
			else
				$this->barras->setFormValue($val);
		}

		// Check field name 'stockmin' first before field var 'x_stockmin'
		$val = $CurrentForm->hasValue("stockmin") ? $CurrentForm->getValue("stockmin") : $CurrentForm->getValue("x_stockmin");
		if (!$this->stockmin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stockmin->Visible = FALSE; // Disable update for API request
			else
				$this->stockmin->setFormValue($val);
		}

		// Check field name 'id_grupo' first before field var 'x_id_grupo'
		$val = $CurrentForm->hasValue("id_grupo") ? $CurrentForm->getValue("id_grupo") : $CurrentForm->getValue("x_id_grupo");
		if (!$this->id_grupo->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_grupo->Visible = FALSE; // Disable update for API request
			else
				$this->id_grupo->setFormValue($val);
		}

		// Check field name 'talla' first before field var 'x_talla'
		$val = $CurrentForm->hasValue("talla") ? $CurrentForm->getValue("talla") : $CurrentForm->getValue("x_talla");
		if (!$this->talla->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->talla->Visible = FALSE; // Disable update for API request
			else
				$this->talla->setFormValue($val);
		}

		// Check field name 'mostrarcolor' first before field var 'x_mostrarcolor'
		$val = $CurrentForm->hasValue("mostrarcolor") ? $CurrentForm->getValue("mostrarcolor") : $CurrentForm->getValue("x_mostrarcolor");
		if (!$this->mostrarcolor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mostrarcolor->Visible = FALSE; // Disable update for API request
			else
				$this->mostrarcolor->setFormValue($val);
		}

		// Check field name 'lote' first before field var 'x_lote'
		$val = $CurrentForm->hasValue("lote") ? $CurrentForm->getValue("lote") : $CurrentForm->getValue("x_lote");
		if (!$this->lote->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lote->Visible = FALSE; // Disable update for API request
			else
				$this->lote->setFormValue($val);
		}

		// Check field name 'manzana' first before field var 'x_manzana'
		$val = $CurrentForm->hasValue("manzana") ? $CurrentForm->getValue("manzana") : $CurrentForm->getValue("x_manzana");
		if (!$this->manzana->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->manzana->Visible = FALSE; // Disable update for API request
			else
				$this->manzana->setFormValue($val);
		}

		// Check field name 'etapa' first before field var 'x_etapa'
		$val = $CurrentForm->hasValue("etapa") ? $CurrentForm->getValue("etapa") : $CurrentForm->getValue("x_etapa");
		if (!$this->etapa->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->etapa->Visible = FALSE; // Disable update for API request
			else
				$this->etapa->setFormValue($val);
		}

		// Check field name 'estado' first before field var 'x_estado'
		$val = $CurrentForm->hasValue("estado") ? $CurrentForm->getValue("estado") : $CurrentForm->getValue("x_estado");
		if (!$this->estado->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->estado->Visible = FALSE; // Disable update for API request
			else
				$this->estado->setFormValue($val);
		}

		// Check field name 'icon' first before field var 'x_icon'
		$val = $CurrentForm->hasValue("icon") ? $CurrentForm->getValue("icon") : $CurrentForm->getValue("x_icon");
		if (!$this->icon->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->icon->Visible = FALSE; // Disable update for API request
			else
				$this->icon->setFormValue($val);
		}

		// Check field name 'topy' first before field var 'x_topy'
		$val = $CurrentForm->hasValue("topy") ? $CurrentForm->getValue("topy") : $CurrentForm->getValue("x_topy");
		if (!$this->topy->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->topy->Visible = FALSE; // Disable update for API request
			else
				$this->topy->setFormValue($val);
		}

		// Check field name 'leftx' first before field var 'x_leftx'
		$val = $CurrentForm->hasValue("leftx") ? $CurrentForm->getValue("leftx") : $CurrentForm->getValue("x_leftx");
		if (!$this->leftx->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->leftx->Visible = FALSE; // Disable update for API request
			else
				$this->leftx->setFormValue($val);
		}

		// Check field name 'codlogin' first before field var 'x_codlogin'
		$val = $CurrentForm->hasValue("codlogin") ? $CurrentForm->getValue("codlogin") : $CurrentForm->getValue("x_codlogin");
		if (!$this->codlogin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->codlogin->Visible = FALSE; // Disable update for API request
			else
				$this->codlogin->setFormValue($val);
		}

		// Check field name 'id_cliente' first before field var 'x_id_cliente'
		$val = $CurrentForm->hasValue("id_cliente") ? $CurrentForm->getValue("id_cliente") : $CurrentForm->getValue("x_id_cliente");
		if (!$this->id_cliente->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_cliente->Visible = FALSE; // Disable update for API request
			else
				$this->id_cliente->setFormValue($val);
		}

		// Check field name 'id_producto' first before field var 'x_id_producto'
		$val = $CurrentForm->hasValue("id_producto") ? $CurrentForm->getValue("id_producto") : $CurrentForm->getValue("x_id_producto");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id_proyecto->CurrentValue = $this->id_proyecto->FormValue;
		$this->codigo_producto->CurrentValue = $this->codigo_producto->FormValue;
		$this->nombre_producto->CurrentValue = $this->nombre_producto->FormValue;
		$this->status_producto->CurrentValue = $this->status_producto->FormValue;
		$this->date_added->CurrentValue = $this->date_added->FormValue;
		$this->date_added->CurrentValue = UnFormatDateTime($this->date_added->CurrentValue, 0);
		$this->precio_producto->CurrentValue = $this->precio_producto->FormValue;
		$this->costo_producto->CurrentValue = $this->costo_producto->FormValue;
		$this->mon_costo->CurrentValue = $this->mon_costo->FormValue;
		$this->mon_venta->CurrentValue = $this->mon_venta->FormValue;
		$this->marca->CurrentValue = $this->marca->FormValue;
		$this->modelo->CurrentValue = $this->modelo->FormValue;
		$this->color->CurrentValue = $this->color->FormValue;
		$this->b1->CurrentValue = $this->b1->FormValue;
		$this->b2->CurrentValue = $this->b2->FormValue;
		$this->b3->CurrentValue = $this->b3->FormValue;
		$this->b4->CurrentValue = $this->b4->FormValue;
		$this->b5->CurrentValue = $this->b5->FormValue;
		$this->b6->CurrentValue = $this->b6->FormValue;
		$this->cat_pro->CurrentValue = $this->cat_pro->FormValue;
		$this->pro_ser->CurrentValue = $this->pro_ser->FormValue;
		$this->foto1->CurrentValue = $this->foto1->FormValue;
		$this->foto2->CurrentValue = $this->foto2->FormValue;
		$this->foto3->CurrentValue = $this->foto3->FormValue;
		$this->foto4->CurrentValue = $this->foto4->FormValue;
		$this->web->CurrentValue = $this->web->FormValue;
		$this->pre_web->CurrentValue = $this->pre_web->FormValue;
		$this->descripcion->CurrentValue = $this->descripcion->FormValue;
		$this->descripcion1->CurrentValue = $this->descripcion1->FormValue;
		$this->megusta->CurrentValue = $this->megusta->FormValue;
		$this->nomegusta->CurrentValue = $this->nomegusta->FormValue;
		$this->precio2->CurrentValue = $this->precio2->FormValue;
		$this->precio3->CurrentValue = $this->precio3->FormValue;
		$this->und_pro->CurrentValue = $this->und_pro->FormValue;
		$this->barras->CurrentValue = $this->barras->FormValue;
		$this->stockmin->CurrentValue = $this->stockmin->FormValue;
		$this->id_grupo->CurrentValue = $this->id_grupo->FormValue;
		$this->talla->CurrentValue = $this->talla->FormValue;
		$this->mostrarcolor->CurrentValue = $this->mostrarcolor->FormValue;
		$this->lote->CurrentValue = $this->lote->FormValue;
		$this->manzana->CurrentValue = $this->manzana->FormValue;
		$this->etapa->CurrentValue = $this->etapa->FormValue;
		$this->estado->CurrentValue = $this->estado->FormValue;
		$this->icon->CurrentValue = $this->icon->FormValue;
		$this->topy->CurrentValue = $this->topy->FormValue;
		$this->leftx->CurrentValue = $this->leftx->FormValue;
		$this->codlogin->CurrentValue = $this->codlogin->FormValue;
		$this->id_cliente->CurrentValue = $this->id_cliente->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->id_proyecto->setDbValue($row['id_proyecto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->lote->setDbValue($row['lote']);
		$this->manzana->setDbValue($row['manzana']);
		$this->etapa->setDbValue($row['etapa']);
		$this->estado->setDbValue($row['estado']);
		$this->icon->setDbValue($row['icon']);
		$this->topy->setDbValue($row['topy']);
		$this->leftx->setDbValue($row['leftx']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->id_cliente->setDbValue($row['id_cliente']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id_producto'] = $this->id_producto->CurrentValue;
		$row['id_proyecto'] = $this->id_proyecto->CurrentValue;
		$row['codigo_producto'] = $this->codigo_producto->CurrentValue;
		$row['nombre_producto'] = $this->nombre_producto->CurrentValue;
		$row['status_producto'] = $this->status_producto->CurrentValue;
		$row['date_added'] = $this->date_added->CurrentValue;
		$row['precio_producto'] = $this->precio_producto->CurrentValue;
		$row['costo_producto'] = $this->costo_producto->CurrentValue;
		$row['mon_costo'] = $this->mon_costo->CurrentValue;
		$row['mon_venta'] = $this->mon_venta->CurrentValue;
		$row['marca'] = $this->marca->CurrentValue;
		$row['modelo'] = $this->modelo->CurrentValue;
		$row['color'] = $this->color->CurrentValue;
		$row['b1'] = $this->b1->CurrentValue;
		$row['b2'] = $this->b2->CurrentValue;
		$row['b3'] = $this->b3->CurrentValue;
		$row['b4'] = $this->b4->CurrentValue;
		$row['b5'] = $this->b5->CurrentValue;
		$row['b6'] = $this->b6->CurrentValue;
		$row['cat_pro'] = $this->cat_pro->CurrentValue;
		$row['pro_ser'] = $this->pro_ser->CurrentValue;
		$row['foto1'] = $this->foto1->CurrentValue;
		$row['foto2'] = $this->foto2->CurrentValue;
		$row['foto3'] = $this->foto3->CurrentValue;
		$row['foto4'] = $this->foto4->CurrentValue;
		$row['web'] = $this->web->CurrentValue;
		$row['pre_web'] = $this->pre_web->CurrentValue;
		$row['descripcion'] = $this->descripcion->CurrentValue;
		$row['descripcion1'] = $this->descripcion1->CurrentValue;
		$row['megusta'] = $this->megusta->CurrentValue;
		$row['nomegusta'] = $this->nomegusta->CurrentValue;
		$row['precio2'] = $this->precio2->CurrentValue;
		$row['precio3'] = $this->precio3->CurrentValue;
		$row['und_pro'] = $this->und_pro->CurrentValue;
		$row['barras'] = $this->barras->CurrentValue;
		$row['stockmin'] = $this->stockmin->CurrentValue;
		$row['id_grupo'] = $this->id_grupo->CurrentValue;
		$row['talla'] = $this->talla->CurrentValue;
		$row['mostrarcolor'] = $this->mostrarcolor->CurrentValue;
		$row['lote'] = $this->lote->CurrentValue;
		$row['manzana'] = $this->manzana->CurrentValue;
		$row['etapa'] = $this->etapa->CurrentValue;
		$row['estado'] = $this->estado->CurrentValue;
		$row['icon'] = $this->icon->CurrentValue;
		$row['topy'] = $this->topy->CurrentValue;
		$row['leftx'] = $this->leftx->CurrentValue;
		$row['codlogin'] = $this->codlogin->CurrentValue;
		$row['id_cliente'] = $this->id_cliente->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id_producto")) != "")
			$this->id_producto->OldValue = $this->getKey("id_producto"); // id_producto
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_venta->FormValue == $this->mon_venta->CurrentValue && is_numeric(ConvertToFloatString($this->mon_venta->CurrentValue)))
			$this->mon_venta->CurrentValue = ConvertToFloatString($this->mon_venta->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// id_proyecto
		// codigo_producto
		// nombre_producto
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// lote
		// manzana
		// etapa
		// estado
		// icon
		// topy
		// leftx
		// codlogin
		// id_cliente

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// id_proyecto
			$this->id_proyecto->ViewValue = $this->id_proyecto->CurrentValue;
			$this->id_proyecto->ViewValue = FormatNumber($this->id_proyecto->ViewValue, 0, -2, -2, -2);
			$this->id_proyecto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// nombre_producto
			$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
			$this->nombre_producto->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 2, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto1
			$this->foto1->ViewValue = $this->foto1->CurrentValue;
			$this->foto1->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// descripcion
			$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
			$this->descripcion->ViewCustomAttributes = "";

			// descripcion1
			$this->descripcion1->ViewValue = $this->descripcion1->CurrentValue;
			$this->descripcion1->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// lote
			$this->lote->ViewValue = $this->lote->CurrentValue;
			$this->lote->ViewCustomAttributes = "";

			// manzana
			$this->manzana->ViewValue = $this->manzana->CurrentValue;
			$this->manzana->ViewCustomAttributes = "";

			// etapa
			$this->etapa->ViewValue = $this->etapa->CurrentValue;
			$this->etapa->ViewValue = FormatNumber($this->etapa->ViewValue, 0, -2, -2, -2);
			$this->etapa->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// icon
			$this->icon->ViewValue = $this->icon->CurrentValue;
			$this->icon->ViewCustomAttributes = "";

			// topy
			$this->topy->ViewValue = $this->topy->CurrentValue;
			$this->topy->ViewCustomAttributes = "";

			// leftx
			$this->leftx->ViewValue = $this->leftx->CurrentValue;
			$this->leftx->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// id_cliente
			$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
			$this->id_cliente->ViewValue = FormatNumber($this->id_cliente->ViewValue, 0, -2, -2, -2);
			$this->id_cliente->ViewCustomAttributes = "";

			// id_proyecto
			$this->id_proyecto->LinkCustomAttributes = "";
			$this->id_proyecto->HrefValue = "";
			$this->id_proyecto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";
			$this->nombre_producto->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";
			$this->foto1->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";
			$this->descripcion->TooltipValue = "";

			// descripcion1
			$this->descripcion1->LinkCustomAttributes = "";
			$this->descripcion1->HrefValue = "";
			$this->descripcion1->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// lote
			$this->lote->LinkCustomAttributes = "";
			$this->lote->HrefValue = "";
			$this->lote->TooltipValue = "";

			// manzana
			$this->manzana->LinkCustomAttributes = "";
			$this->manzana->HrefValue = "";
			$this->manzana->TooltipValue = "";

			// etapa
			$this->etapa->LinkCustomAttributes = "";
			$this->etapa->HrefValue = "";
			$this->etapa->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// icon
			$this->icon->LinkCustomAttributes = "";
			$this->icon->HrefValue = "";
			$this->icon->TooltipValue = "";

			// topy
			$this->topy->LinkCustomAttributes = "";
			$this->topy->HrefValue = "";
			$this->topy->TooltipValue = "";

			// leftx
			$this->leftx->LinkCustomAttributes = "";
			$this->leftx->HrefValue = "";
			$this->leftx->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// id_cliente
			$this->id_cliente->LinkCustomAttributes = "";
			$this->id_cliente->HrefValue = "";
			$this->id_cliente->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id_proyecto
			$this->id_proyecto->EditAttrs["class"] = "form-control";
			$this->id_proyecto->EditCustomAttributes = "";
			$this->id_proyecto->EditValue = HtmlEncode($this->id_proyecto->CurrentValue);
			$this->id_proyecto->PlaceHolder = RemoveHtml($this->id_proyecto->caption());

			// codigo_producto
			$this->codigo_producto->EditAttrs["class"] = "form-control";
			$this->codigo_producto->EditCustomAttributes = "";
			if (!$this->codigo_producto->Raw)
				$this->codigo_producto->CurrentValue = HtmlDecode($this->codigo_producto->CurrentValue);
			$this->codigo_producto->EditValue = HtmlEncode($this->codigo_producto->CurrentValue);
			$this->codigo_producto->PlaceHolder = RemoveHtml($this->codigo_producto->caption());

			// nombre_producto
			$this->nombre_producto->EditAttrs["class"] = "form-control";
			$this->nombre_producto->EditCustomAttributes = "";
			if (!$this->nombre_producto->Raw)
				$this->nombre_producto->CurrentValue = HtmlDecode($this->nombre_producto->CurrentValue);
			$this->nombre_producto->EditValue = HtmlEncode($this->nombre_producto->CurrentValue);
			$this->nombre_producto->PlaceHolder = RemoveHtml($this->nombre_producto->caption());

			// status_producto
			$this->status_producto->EditAttrs["class"] = "form-control";
			$this->status_producto->EditCustomAttributes = "";
			$this->status_producto->EditValue = HtmlEncode($this->status_producto->CurrentValue);
			$this->status_producto->PlaceHolder = RemoveHtml($this->status_producto->caption());

			// date_added
			$this->date_added->EditAttrs["class"] = "form-control";
			$this->date_added->EditCustomAttributes = "";
			$this->date_added->EditValue = HtmlEncode(FormatDateTime($this->date_added->CurrentValue, 8));
			$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

			// precio_producto
			$this->precio_producto->EditAttrs["class"] = "form-control";
			$this->precio_producto->EditCustomAttributes = "";
			$this->precio_producto->EditValue = HtmlEncode($this->precio_producto->CurrentValue);
			$this->precio_producto->PlaceHolder = RemoveHtml($this->precio_producto->caption());
			if (strval($this->precio_producto->EditValue) != "" && is_numeric($this->precio_producto->EditValue))
				$this->precio_producto->EditValue = FormatNumber($this->precio_producto->EditValue, -2, -2, -2, -2);
			

			// costo_producto
			$this->costo_producto->EditAttrs["class"] = "form-control";
			$this->costo_producto->EditCustomAttributes = "";
			$this->costo_producto->EditValue = HtmlEncode($this->costo_producto->CurrentValue);
			$this->costo_producto->PlaceHolder = RemoveHtml($this->costo_producto->caption());
			if (strval($this->costo_producto->EditValue) != "" && is_numeric($this->costo_producto->EditValue))
				$this->costo_producto->EditValue = FormatNumber($this->costo_producto->EditValue, -2, -2, -2, -2);
			

			// mon_costo
			$this->mon_costo->EditAttrs["class"] = "form-control";
			$this->mon_costo->EditCustomAttributes = "";
			$this->mon_costo->EditValue = HtmlEncode($this->mon_costo->CurrentValue);
			$this->mon_costo->PlaceHolder = RemoveHtml($this->mon_costo->caption());
			if (strval($this->mon_costo->EditValue) != "" && is_numeric($this->mon_costo->EditValue))
				$this->mon_costo->EditValue = FormatNumber($this->mon_costo->EditValue, -2, -2, -2, -2);
			

			// mon_venta
			$this->mon_venta->EditAttrs["class"] = "form-control";
			$this->mon_venta->EditCustomAttributes = "";
			$this->mon_venta->EditValue = HtmlEncode($this->mon_venta->CurrentValue);
			$this->mon_venta->PlaceHolder = RemoveHtml($this->mon_venta->caption());
			if (strval($this->mon_venta->EditValue) != "" && is_numeric($this->mon_venta->EditValue))
				$this->mon_venta->EditValue = FormatNumber($this->mon_venta->EditValue, -2, -2, -2, -2);
			

			// marca
			$this->marca->EditAttrs["class"] = "form-control";
			$this->marca->EditCustomAttributes = "";
			if (!$this->marca->Raw)
				$this->marca->CurrentValue = HtmlDecode($this->marca->CurrentValue);
			$this->marca->EditValue = HtmlEncode($this->marca->CurrentValue);
			$this->marca->PlaceHolder = RemoveHtml($this->marca->caption());

			// modelo
			$this->modelo->EditAttrs["class"] = "form-control";
			$this->modelo->EditCustomAttributes = "";
			if (!$this->modelo->Raw)
				$this->modelo->CurrentValue = HtmlDecode($this->modelo->CurrentValue);
			$this->modelo->EditValue = HtmlEncode($this->modelo->CurrentValue);
			$this->modelo->PlaceHolder = RemoveHtml($this->modelo->caption());

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (!$this->color->Raw)
				$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
			$this->color->EditValue = HtmlEncode($this->color->CurrentValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// b1
			$this->b1->EditAttrs["class"] = "form-control";
			$this->b1->EditCustomAttributes = "";
			$this->b1->EditValue = HtmlEncode($this->b1->CurrentValue);
			$this->b1->PlaceHolder = RemoveHtml($this->b1->caption());
			if (strval($this->b1->EditValue) != "" && is_numeric($this->b1->EditValue))
				$this->b1->EditValue = FormatNumber($this->b1->EditValue, -2, -2, -2, -2);
			

			// b2
			$this->b2->EditAttrs["class"] = "form-control";
			$this->b2->EditCustomAttributes = "";
			$this->b2->EditValue = HtmlEncode($this->b2->CurrentValue);
			$this->b2->PlaceHolder = RemoveHtml($this->b2->caption());
			if (strval($this->b2->EditValue) != "" && is_numeric($this->b2->EditValue))
				$this->b2->EditValue = FormatNumber($this->b2->EditValue, -2, -2, -2, -2);
			

			// b3
			$this->b3->EditAttrs["class"] = "form-control";
			$this->b3->EditCustomAttributes = "";
			$this->b3->EditValue = HtmlEncode($this->b3->CurrentValue);
			$this->b3->PlaceHolder = RemoveHtml($this->b3->caption());
			if (strval($this->b3->EditValue) != "" && is_numeric($this->b3->EditValue))
				$this->b3->EditValue = FormatNumber($this->b3->EditValue, -2, -2, -2, -2);
			

			// b4
			$this->b4->EditAttrs["class"] = "form-control";
			$this->b4->EditCustomAttributes = "";
			$this->b4->EditValue = HtmlEncode($this->b4->CurrentValue);
			$this->b4->PlaceHolder = RemoveHtml($this->b4->caption());
			if (strval($this->b4->EditValue) != "" && is_numeric($this->b4->EditValue))
				$this->b4->EditValue = FormatNumber($this->b4->EditValue, -2, -2, -2, -2);
			

			// b5
			$this->b5->EditAttrs["class"] = "form-control";
			$this->b5->EditCustomAttributes = "";
			$this->b5->EditValue = HtmlEncode($this->b5->CurrentValue);
			$this->b5->PlaceHolder = RemoveHtml($this->b5->caption());
			if (strval($this->b5->EditValue) != "" && is_numeric($this->b5->EditValue))
				$this->b5->EditValue = FormatNumber($this->b5->EditValue, -2, -2, -2, -2);
			

			// b6
			$this->b6->EditAttrs["class"] = "form-control";
			$this->b6->EditCustomAttributes = "";
			$this->b6->EditValue = HtmlEncode($this->b6->CurrentValue);
			$this->b6->PlaceHolder = RemoveHtml($this->b6->caption());
			if (strval($this->b6->EditValue) != "" && is_numeric($this->b6->EditValue))
				$this->b6->EditValue = FormatNumber($this->b6->EditValue, -2, -2, -2, -2);
			

			// cat_pro
			$this->cat_pro->EditAttrs["class"] = "form-control";
			$this->cat_pro->EditCustomAttributes = "";
			$this->cat_pro->EditValue = HtmlEncode($this->cat_pro->CurrentValue);
			$this->cat_pro->PlaceHolder = RemoveHtml($this->cat_pro->caption());

			// pro_ser
			$this->pro_ser->EditAttrs["class"] = "form-control";
			$this->pro_ser->EditCustomAttributes = "";
			$this->pro_ser->EditValue = HtmlEncode($this->pro_ser->CurrentValue);
			$this->pro_ser->PlaceHolder = RemoveHtml($this->pro_ser->caption());

			// foto1
			$this->foto1->EditAttrs["class"] = "form-control";
			$this->foto1->EditCustomAttributes = "";
			if (!$this->foto1->Raw)
				$this->foto1->CurrentValue = HtmlDecode($this->foto1->CurrentValue);
			$this->foto1->EditValue = HtmlEncode($this->foto1->CurrentValue);
			$this->foto1->PlaceHolder = RemoveHtml($this->foto1->caption());

			// foto2
			$this->foto2->EditAttrs["class"] = "form-control";
			$this->foto2->EditCustomAttributes = "";
			if (!$this->foto2->Raw)
				$this->foto2->CurrentValue = HtmlDecode($this->foto2->CurrentValue);
			$this->foto2->EditValue = HtmlEncode($this->foto2->CurrentValue);
			$this->foto2->PlaceHolder = RemoveHtml($this->foto2->caption());

			// foto3
			$this->foto3->EditAttrs["class"] = "form-control";
			$this->foto3->EditCustomAttributes = "";
			if (!$this->foto3->Raw)
				$this->foto3->CurrentValue = HtmlDecode($this->foto3->CurrentValue);
			$this->foto3->EditValue = HtmlEncode($this->foto3->CurrentValue);
			$this->foto3->PlaceHolder = RemoveHtml($this->foto3->caption());

			// foto4
			$this->foto4->EditAttrs["class"] = "form-control";
			$this->foto4->EditCustomAttributes = "";
			if (!$this->foto4->Raw)
				$this->foto4->CurrentValue = HtmlDecode($this->foto4->CurrentValue);
			$this->foto4->EditValue = HtmlEncode($this->foto4->CurrentValue);
			$this->foto4->PlaceHolder = RemoveHtml($this->foto4->caption());

			// web
			$this->web->EditAttrs["class"] = "form-control";
			$this->web->EditCustomAttributes = "";
			$this->web->EditValue = HtmlEncode($this->web->CurrentValue);
			$this->web->PlaceHolder = RemoveHtml($this->web->caption());

			// pre_web
			$this->pre_web->EditAttrs["class"] = "form-control";
			$this->pre_web->EditCustomAttributes = "";
			$this->pre_web->EditValue = HtmlEncode($this->pre_web->CurrentValue);
			$this->pre_web->PlaceHolder = RemoveHtml($this->pre_web->caption());
			if (strval($this->pre_web->EditValue) != "" && is_numeric($this->pre_web->EditValue))
				$this->pre_web->EditValue = FormatNumber($this->pre_web->EditValue, -2, -2, -2, -2);
			

			// descripcion
			$this->descripcion->EditAttrs["class"] = "form-control";
			$this->descripcion->EditCustomAttributes = "";
			$this->descripcion->EditValue = HtmlEncode($this->descripcion->CurrentValue);
			$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

			// descripcion1
			$this->descripcion1->EditAttrs["class"] = "form-control";
			$this->descripcion1->EditCustomAttributes = "";
			$this->descripcion1->EditValue = HtmlEncode($this->descripcion1->CurrentValue);
			$this->descripcion1->PlaceHolder = RemoveHtml($this->descripcion1->caption());

			// megusta
			$this->megusta->EditAttrs["class"] = "form-control";
			$this->megusta->EditCustomAttributes = "";
			$this->megusta->EditValue = HtmlEncode($this->megusta->CurrentValue);
			$this->megusta->PlaceHolder = RemoveHtml($this->megusta->caption());

			// nomegusta
			$this->nomegusta->EditAttrs["class"] = "form-control";
			$this->nomegusta->EditCustomAttributes = "";
			$this->nomegusta->EditValue = HtmlEncode($this->nomegusta->CurrentValue);
			$this->nomegusta->PlaceHolder = RemoveHtml($this->nomegusta->caption());

			// precio2
			$this->precio2->EditAttrs["class"] = "form-control";
			$this->precio2->EditCustomAttributes = "";
			$this->precio2->EditValue = HtmlEncode($this->precio2->CurrentValue);
			$this->precio2->PlaceHolder = RemoveHtml($this->precio2->caption());
			if (strval($this->precio2->EditValue) != "" && is_numeric($this->precio2->EditValue))
				$this->precio2->EditValue = FormatNumber($this->precio2->EditValue, -2, -2, -2, -2);
			

			// precio3
			$this->precio3->EditAttrs["class"] = "form-control";
			$this->precio3->EditCustomAttributes = "";
			$this->precio3->EditValue = HtmlEncode($this->precio3->CurrentValue);
			$this->precio3->PlaceHolder = RemoveHtml($this->precio3->caption());
			if (strval($this->precio3->EditValue) != "" && is_numeric($this->precio3->EditValue))
				$this->precio3->EditValue = FormatNumber($this->precio3->EditValue, -2, -2, -2, -2);
			

			// und_pro
			$this->und_pro->EditAttrs["class"] = "form-control";
			$this->und_pro->EditCustomAttributes = "";
			$this->und_pro->EditValue = HtmlEncode($this->und_pro->CurrentValue);
			$this->und_pro->PlaceHolder = RemoveHtml($this->und_pro->caption());

			// barras
			$this->barras->EditAttrs["class"] = "form-control";
			$this->barras->EditCustomAttributes = "";
			if (!$this->barras->Raw)
				$this->barras->CurrentValue = HtmlDecode($this->barras->CurrentValue);
			$this->barras->EditValue = HtmlEncode($this->barras->CurrentValue);
			$this->barras->PlaceHolder = RemoveHtml($this->barras->caption());

			// stockmin
			$this->stockmin->EditAttrs["class"] = "form-control";
			$this->stockmin->EditCustomAttributes = "";
			$this->stockmin->EditValue = HtmlEncode($this->stockmin->CurrentValue);
			$this->stockmin->PlaceHolder = RemoveHtml($this->stockmin->caption());
			if (strval($this->stockmin->EditValue) != "" && is_numeric($this->stockmin->EditValue))
				$this->stockmin->EditValue = FormatNumber($this->stockmin->EditValue, -2, -2, -2, -2);
			

			// id_grupo
			$this->id_grupo->EditAttrs["class"] = "form-control";
			$this->id_grupo->EditCustomAttributes = "";
			$this->id_grupo->EditValue = HtmlEncode($this->id_grupo->CurrentValue);
			$this->id_grupo->PlaceHolder = RemoveHtml($this->id_grupo->caption());

			// talla
			$this->talla->EditAttrs["class"] = "form-control";
			$this->talla->EditCustomAttributes = "";
			if (!$this->talla->Raw)
				$this->talla->CurrentValue = HtmlDecode($this->talla->CurrentValue);
			$this->talla->EditValue = HtmlEncode($this->talla->CurrentValue);
			$this->talla->PlaceHolder = RemoveHtml($this->talla->caption());

			// mostrarcolor
			$this->mostrarcolor->EditAttrs["class"] = "form-control";
			$this->mostrarcolor->EditCustomAttributes = "";
			$this->mostrarcolor->EditValue = HtmlEncode($this->mostrarcolor->CurrentValue);
			$this->mostrarcolor->PlaceHolder = RemoveHtml($this->mostrarcolor->caption());

			// lote
			$this->lote->EditAttrs["class"] = "form-control";
			$this->lote->EditCustomAttributes = "";
			if (!$this->lote->Raw)
				$this->lote->CurrentValue = HtmlDecode($this->lote->CurrentValue);
			$this->lote->EditValue = HtmlEncode($this->lote->CurrentValue);
			$this->lote->PlaceHolder = RemoveHtml($this->lote->caption());

			// manzana
			$this->manzana->EditAttrs["class"] = "form-control";
			$this->manzana->EditCustomAttributes = "";
			if (!$this->manzana->Raw)
				$this->manzana->CurrentValue = HtmlDecode($this->manzana->CurrentValue);
			$this->manzana->EditValue = HtmlEncode($this->manzana->CurrentValue);
			$this->manzana->PlaceHolder = RemoveHtml($this->manzana->caption());

			// etapa
			$this->etapa->EditAttrs["class"] = "form-control";
			$this->etapa->EditCustomAttributes = "";
			$this->etapa->EditValue = HtmlEncode($this->etapa->CurrentValue);
			$this->etapa->PlaceHolder = RemoveHtml($this->etapa->caption());

			// estado
			$this->estado->EditAttrs["class"] = "form-control";
			$this->estado->EditCustomAttributes = "";
			$this->estado->EditValue = HtmlEncode($this->estado->CurrentValue);
			$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

			// icon
			$this->icon->EditAttrs["class"] = "form-control";
			$this->icon->EditCustomAttributes = "";
			if (!$this->icon->Raw)
				$this->icon->CurrentValue = HtmlDecode($this->icon->CurrentValue);
			$this->icon->EditValue = HtmlEncode($this->icon->CurrentValue);
			$this->icon->PlaceHolder = RemoveHtml($this->icon->caption());

			// topy
			$this->topy->EditAttrs["class"] = "form-control";
			$this->topy->EditCustomAttributes = "";
			if (!$this->topy->Raw)
				$this->topy->CurrentValue = HtmlDecode($this->topy->CurrentValue);
			$this->topy->EditValue = HtmlEncode($this->topy->CurrentValue);
			$this->topy->PlaceHolder = RemoveHtml($this->topy->caption());

			// leftx
			$this->leftx->EditAttrs["class"] = "form-control";
			$this->leftx->EditCustomAttributes = "";
			if (!$this->leftx->Raw)
				$this->leftx->CurrentValue = HtmlDecode($this->leftx->CurrentValue);
			$this->leftx->EditValue = HtmlEncode($this->leftx->CurrentValue);
			$this->leftx->PlaceHolder = RemoveHtml($this->leftx->caption());

			// codlogin
			$this->codlogin->EditAttrs["class"] = "form-control";
			$this->codlogin->EditCustomAttributes = "";
			if (!$this->codlogin->Raw)
				$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
			$this->codlogin->EditValue = HtmlEncode($this->codlogin->CurrentValue);
			$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

			// id_cliente
			$this->id_cliente->EditAttrs["class"] = "form-control";
			$this->id_cliente->EditCustomAttributes = "";
			$this->id_cliente->EditValue = HtmlEncode($this->id_cliente->CurrentValue);
			$this->id_cliente->PlaceHolder = RemoveHtml($this->id_cliente->caption());

			// Add refer script
			// id_proyecto

			$this->id_proyecto->LinkCustomAttributes = "";
			$this->id_proyecto->HrefValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";

			// descripcion
			$this->descripcion->LinkCustomAttributes = "";
			$this->descripcion->HrefValue = "";

			// descripcion1
			$this->descripcion1->LinkCustomAttributes = "";
			$this->descripcion1->HrefValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";

			// lote
			$this->lote->LinkCustomAttributes = "";
			$this->lote->HrefValue = "";

			// manzana
			$this->manzana->LinkCustomAttributes = "";
			$this->manzana->HrefValue = "";

			// etapa
			$this->etapa->LinkCustomAttributes = "";
			$this->etapa->HrefValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";

			// icon
			$this->icon->LinkCustomAttributes = "";
			$this->icon->HrefValue = "";

			// topy
			$this->topy->LinkCustomAttributes = "";
			$this->topy->HrefValue = "";

			// leftx
			$this->leftx->LinkCustomAttributes = "";
			$this->leftx->HrefValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";

			// id_cliente
			$this->id_cliente->LinkCustomAttributes = "";
			$this->id_cliente->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->id_proyecto->Required) {
			if (!$this->id_proyecto->IsDetailKey && $this->id_proyecto->FormValue != NULL && $this->id_proyecto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_proyecto->caption(), $this->id_proyecto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_proyecto->FormValue)) {
			AddMessage($FormError, $this->id_proyecto->errorMessage());
		}
		if ($this->codigo_producto->Required) {
			if (!$this->codigo_producto->IsDetailKey && $this->codigo_producto->FormValue != NULL && $this->codigo_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codigo_producto->caption(), $this->codigo_producto->RequiredErrorMessage));
			}
		}
		if ($this->nombre_producto->Required) {
			if (!$this->nombre_producto->IsDetailKey && $this->nombre_producto->FormValue != NULL && $this->nombre_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nombre_producto->caption(), $this->nombre_producto->RequiredErrorMessage));
			}
		}
		if ($this->status_producto->Required) {
			if (!$this->status_producto->IsDetailKey && $this->status_producto->FormValue != NULL && $this->status_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_producto->caption(), $this->status_producto->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status_producto->FormValue)) {
			AddMessage($FormError, $this->status_producto->errorMessage());
		}
		if ($this->date_added->Required) {
			if (!$this->date_added->IsDetailKey && $this->date_added->FormValue != NULL && $this->date_added->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_added->caption(), $this->date_added->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->date_added->FormValue)) {
			AddMessage($FormError, $this->date_added->errorMessage());
		}
		if ($this->precio_producto->Required) {
			if (!$this->precio_producto->IsDetailKey && $this->precio_producto->FormValue != NULL && $this->precio_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio_producto->caption(), $this->precio_producto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio_producto->FormValue)) {
			AddMessage($FormError, $this->precio_producto->errorMessage());
		}
		if ($this->costo_producto->Required) {
			if (!$this->costo_producto->IsDetailKey && $this->costo_producto->FormValue != NULL && $this->costo_producto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->costo_producto->caption(), $this->costo_producto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->costo_producto->FormValue)) {
			AddMessage($FormError, $this->costo_producto->errorMessage());
		}
		if ($this->mon_costo->Required) {
			if (!$this->mon_costo->IsDetailKey && $this->mon_costo->FormValue != NULL && $this->mon_costo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mon_costo->caption(), $this->mon_costo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->mon_costo->FormValue)) {
			AddMessage($FormError, $this->mon_costo->errorMessage());
		}
		if ($this->mon_venta->Required) {
			if (!$this->mon_venta->IsDetailKey && $this->mon_venta->FormValue != NULL && $this->mon_venta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mon_venta->caption(), $this->mon_venta->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->mon_venta->FormValue)) {
			AddMessage($FormError, $this->mon_venta->errorMessage());
		}
		if ($this->marca->Required) {
			if (!$this->marca->IsDetailKey && $this->marca->FormValue != NULL && $this->marca->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->marca->caption(), $this->marca->RequiredErrorMessage));
			}
		}
		if ($this->modelo->Required) {
			if (!$this->modelo->IsDetailKey && $this->modelo->FormValue != NULL && $this->modelo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->modelo->caption(), $this->modelo->RequiredErrorMessage));
			}
		}
		if ($this->color->Required) {
			if (!$this->color->IsDetailKey && $this->color->FormValue != NULL && $this->color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
			}
		}
		if ($this->b1->Required) {
			if (!$this->b1->IsDetailKey && $this->b1->FormValue != NULL && $this->b1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b1->caption(), $this->b1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b1->FormValue)) {
			AddMessage($FormError, $this->b1->errorMessage());
		}
		if ($this->b2->Required) {
			if (!$this->b2->IsDetailKey && $this->b2->FormValue != NULL && $this->b2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b2->caption(), $this->b2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b2->FormValue)) {
			AddMessage($FormError, $this->b2->errorMessage());
		}
		if ($this->b3->Required) {
			if (!$this->b3->IsDetailKey && $this->b3->FormValue != NULL && $this->b3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b3->caption(), $this->b3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b3->FormValue)) {
			AddMessage($FormError, $this->b3->errorMessage());
		}
		if ($this->b4->Required) {
			if (!$this->b4->IsDetailKey && $this->b4->FormValue != NULL && $this->b4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b4->caption(), $this->b4->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b4->FormValue)) {
			AddMessage($FormError, $this->b4->errorMessage());
		}
		if ($this->b5->Required) {
			if (!$this->b5->IsDetailKey && $this->b5->FormValue != NULL && $this->b5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b5->caption(), $this->b5->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b5->FormValue)) {
			AddMessage($FormError, $this->b5->errorMessage());
		}
		if ($this->b6->Required) {
			if (!$this->b6->IsDetailKey && $this->b6->FormValue != NULL && $this->b6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b6->caption(), $this->b6->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b6->FormValue)) {
			AddMessage($FormError, $this->b6->errorMessage());
		}
		if ($this->cat_pro->Required) {
			if (!$this->cat_pro->IsDetailKey && $this->cat_pro->FormValue != NULL && $this->cat_pro->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cat_pro->caption(), $this->cat_pro->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cat_pro->FormValue)) {
			AddMessage($FormError, $this->cat_pro->errorMessage());
		}
		if ($this->pro_ser->Required) {
			if (!$this->pro_ser->IsDetailKey && $this->pro_ser->FormValue != NULL && $this->pro_ser->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pro_ser->caption(), $this->pro_ser->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pro_ser->FormValue)) {
			AddMessage($FormError, $this->pro_ser->errorMessage());
		}
		if ($this->foto1->Required) {
			if (!$this->foto1->IsDetailKey && $this->foto1->FormValue != NULL && $this->foto1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto1->caption(), $this->foto1->RequiredErrorMessage));
			}
		}
		if ($this->foto2->Required) {
			if (!$this->foto2->IsDetailKey && $this->foto2->FormValue != NULL && $this->foto2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto2->caption(), $this->foto2->RequiredErrorMessage));
			}
		}
		if ($this->foto3->Required) {
			if (!$this->foto3->IsDetailKey && $this->foto3->FormValue != NULL && $this->foto3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto3->caption(), $this->foto3->RequiredErrorMessage));
			}
		}
		if ($this->foto4->Required) {
			if (!$this->foto4->IsDetailKey && $this->foto4->FormValue != NULL && $this->foto4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->foto4->caption(), $this->foto4->RequiredErrorMessage));
			}
		}
		if ($this->web->Required) {
			if (!$this->web->IsDetailKey && $this->web->FormValue != NULL && $this->web->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->web->caption(), $this->web->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->web->FormValue)) {
			AddMessage($FormError, $this->web->errorMessage());
		}
		if ($this->pre_web->Required) {
			if (!$this->pre_web->IsDetailKey && $this->pre_web->FormValue != NULL && $this->pre_web->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pre_web->caption(), $this->pre_web->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->pre_web->FormValue)) {
			AddMessage($FormError, $this->pre_web->errorMessage());
		}
		if ($this->descripcion->Required) {
			if (!$this->descripcion->IsDetailKey && $this->descripcion->FormValue != NULL && $this->descripcion->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcion->caption(), $this->descripcion->RequiredErrorMessage));
			}
		}
		if ($this->descripcion1->Required) {
			if (!$this->descripcion1->IsDetailKey && $this->descripcion1->FormValue != NULL && $this->descripcion1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->descripcion1->caption(), $this->descripcion1->RequiredErrorMessage));
			}
		}
		if ($this->megusta->Required) {
			if (!$this->megusta->IsDetailKey && $this->megusta->FormValue != NULL && $this->megusta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->megusta->caption(), $this->megusta->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->megusta->FormValue)) {
			AddMessage($FormError, $this->megusta->errorMessage());
		}
		if ($this->nomegusta->Required) {
			if (!$this->nomegusta->IsDetailKey && $this->nomegusta->FormValue != NULL && $this->nomegusta->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nomegusta->caption(), $this->nomegusta->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->nomegusta->FormValue)) {
			AddMessage($FormError, $this->nomegusta->errorMessage());
		}
		if ($this->precio2->Required) {
			if (!$this->precio2->IsDetailKey && $this->precio2->FormValue != NULL && $this->precio2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio2->caption(), $this->precio2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio2->FormValue)) {
			AddMessage($FormError, $this->precio2->errorMessage());
		}
		if ($this->precio3->Required) {
			if (!$this->precio3->IsDetailKey && $this->precio3->FormValue != NULL && $this->precio3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->precio3->caption(), $this->precio3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->precio3->FormValue)) {
			AddMessage($FormError, $this->precio3->errorMessage());
		}
		if ($this->und_pro->Required) {
			if (!$this->und_pro->IsDetailKey && $this->und_pro->FormValue != NULL && $this->und_pro->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->und_pro->caption(), $this->und_pro->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->und_pro->FormValue)) {
			AddMessage($FormError, $this->und_pro->errorMessage());
		}
		if ($this->barras->Required) {
			if (!$this->barras->IsDetailKey && $this->barras->FormValue != NULL && $this->barras->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->barras->caption(), $this->barras->RequiredErrorMessage));
			}
		}
		if ($this->stockmin->Required) {
			if (!$this->stockmin->IsDetailKey && $this->stockmin->FormValue != NULL && $this->stockmin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stockmin->caption(), $this->stockmin->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->stockmin->FormValue)) {
			AddMessage($FormError, $this->stockmin->errorMessage());
		}
		if ($this->id_grupo->Required) {
			if (!$this->id_grupo->IsDetailKey && $this->id_grupo->FormValue != NULL && $this->id_grupo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_grupo->caption(), $this->id_grupo->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_grupo->FormValue)) {
			AddMessage($FormError, $this->id_grupo->errorMessage());
		}
		if ($this->talla->Required) {
			if (!$this->talla->IsDetailKey && $this->talla->FormValue != NULL && $this->talla->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->talla->caption(), $this->talla->RequiredErrorMessage));
			}
		}
		if ($this->mostrarcolor->Required) {
			if (!$this->mostrarcolor->IsDetailKey && $this->mostrarcolor->FormValue != NULL && $this->mostrarcolor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mostrarcolor->caption(), $this->mostrarcolor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mostrarcolor->FormValue)) {
			AddMessage($FormError, $this->mostrarcolor->errorMessage());
		}
		if ($this->lote->Required) {
			if (!$this->lote->IsDetailKey && $this->lote->FormValue != NULL && $this->lote->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lote->caption(), $this->lote->RequiredErrorMessage));
			}
		}
		if ($this->manzana->Required) {
			if (!$this->manzana->IsDetailKey && $this->manzana->FormValue != NULL && $this->manzana->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->manzana->caption(), $this->manzana->RequiredErrorMessage));
			}
		}
		if ($this->etapa->Required) {
			if (!$this->etapa->IsDetailKey && $this->etapa->FormValue != NULL && $this->etapa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->etapa->caption(), $this->etapa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->etapa->FormValue)) {
			AddMessage($FormError, $this->etapa->errorMessage());
		}
		if ($this->estado->Required) {
			if (!$this->estado->IsDetailKey && $this->estado->FormValue != NULL && $this->estado->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->estado->caption(), $this->estado->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->estado->FormValue)) {
			AddMessage($FormError, $this->estado->errorMessage());
		}
		if ($this->icon->Required) {
			if (!$this->icon->IsDetailKey && $this->icon->FormValue != NULL && $this->icon->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->icon->caption(), $this->icon->RequiredErrorMessage));
			}
		}
		if ($this->topy->Required) {
			if (!$this->topy->IsDetailKey && $this->topy->FormValue != NULL && $this->topy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->topy->caption(), $this->topy->RequiredErrorMessage));
			}
		}
		if ($this->leftx->Required) {
			if (!$this->leftx->IsDetailKey && $this->leftx->FormValue != NULL && $this->leftx->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->leftx->caption(), $this->leftx->RequiredErrorMessage));
			}
		}
		if ($this->codlogin->Required) {
			if (!$this->codlogin->IsDetailKey && $this->codlogin->FormValue != NULL && $this->codlogin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->codlogin->caption(), $this->codlogin->RequiredErrorMessage));
			}
		}
		if ($this->id_cliente->Required) {
			if (!$this->id_cliente->IsDetailKey && $this->id_cliente->FormValue != NULL && $this->id_cliente->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_cliente->caption(), $this->id_cliente->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id_cliente->FormValue)) {
			AddMessage($FormError, $this->id_cliente->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// id_proyecto
		$this->id_proyecto->setDbValueDef($rsnew, $this->id_proyecto->CurrentValue, 0, FALSE);

		// codigo_producto
		$this->codigo_producto->setDbValueDef($rsnew, $this->codigo_producto->CurrentValue, "", FALSE);

		// nombre_producto
		$this->nombre_producto->setDbValueDef($rsnew, $this->nombre_producto->CurrentValue, NULL, FALSE);

		// status_producto
		$this->status_producto->setDbValueDef($rsnew, $this->status_producto->CurrentValue, NULL, FALSE);

		// date_added
		$this->date_added->setDbValueDef($rsnew, UnFormatDateTime($this->date_added->CurrentValue, 0), NULL, FALSE);

		// precio_producto
		$this->precio_producto->setDbValueDef($rsnew, $this->precio_producto->CurrentValue, NULL, FALSE);

		// costo_producto
		$this->costo_producto->setDbValueDef($rsnew, $this->costo_producto->CurrentValue, NULL, FALSE);

		// mon_costo
		$this->mon_costo->setDbValueDef($rsnew, $this->mon_costo->CurrentValue, NULL, FALSE);

		// mon_venta
		$this->mon_venta->setDbValueDef($rsnew, $this->mon_venta->CurrentValue, NULL, FALSE);

		// marca
		$this->marca->setDbValueDef($rsnew, $this->marca->CurrentValue, NULL, FALSE);

		// modelo
		$this->modelo->setDbValueDef($rsnew, $this->modelo->CurrentValue, NULL, FALSE);

		// color
		$this->color->setDbValueDef($rsnew, $this->color->CurrentValue, NULL, FALSE);

		// b1
		$this->b1->setDbValueDef($rsnew, $this->b1->CurrentValue, NULL, FALSE);

		// b2
		$this->b2->setDbValueDef($rsnew, $this->b2->CurrentValue, NULL, FALSE);

		// b3
		$this->b3->setDbValueDef($rsnew, $this->b3->CurrentValue, NULL, FALSE);

		// b4
		$this->b4->setDbValueDef($rsnew, $this->b4->CurrentValue, NULL, FALSE);

		// b5
		$this->b5->setDbValueDef($rsnew, $this->b5->CurrentValue, NULL, FALSE);

		// b6
		$this->b6->setDbValueDef($rsnew, $this->b6->CurrentValue, NULL, FALSE);

		// cat_pro
		$this->cat_pro->setDbValueDef($rsnew, $this->cat_pro->CurrentValue, NULL, FALSE);

		// pro_ser
		$this->pro_ser->setDbValueDef($rsnew, $this->pro_ser->CurrentValue, NULL, FALSE);

		// foto1
		$this->foto1->setDbValueDef($rsnew, $this->foto1->CurrentValue, NULL, FALSE);

		// foto2
		$this->foto2->setDbValueDef($rsnew, $this->foto2->CurrentValue, NULL, FALSE);

		// foto3
		$this->foto3->setDbValueDef($rsnew, $this->foto3->CurrentValue, NULL, FALSE);

		// foto4
		$this->foto4->setDbValueDef($rsnew, $this->foto4->CurrentValue, NULL, FALSE);

		// web
		$this->web->setDbValueDef($rsnew, $this->web->CurrentValue, NULL, FALSE);

		// pre_web
		$this->pre_web->setDbValueDef($rsnew, $this->pre_web->CurrentValue, NULL, FALSE);

		// descripcion
		$this->descripcion->setDbValueDef($rsnew, $this->descripcion->CurrentValue, NULL, FALSE);

		// descripcion1
		$this->descripcion1->setDbValueDef($rsnew, $this->descripcion1->CurrentValue, NULL, FALSE);

		// megusta
		$this->megusta->setDbValueDef($rsnew, $this->megusta->CurrentValue, NULL, FALSE);

		// nomegusta
		$this->nomegusta->setDbValueDef($rsnew, $this->nomegusta->CurrentValue, NULL, FALSE);

		// precio2
		$this->precio2->setDbValueDef($rsnew, $this->precio2->CurrentValue, NULL, FALSE);

		// precio3
		$this->precio3->setDbValueDef($rsnew, $this->precio3->CurrentValue, NULL, FALSE);

		// und_pro
		$this->und_pro->setDbValueDef($rsnew, $this->und_pro->CurrentValue, NULL, FALSE);

		// barras
		$this->barras->setDbValueDef($rsnew, $this->barras->CurrentValue, NULL, FALSE);

		// stockmin
		$this->stockmin->setDbValueDef($rsnew, $this->stockmin->CurrentValue, NULL, strval($this->stockmin->CurrentValue) == "");

		// id_grupo
		$this->id_grupo->setDbValueDef($rsnew, $this->id_grupo->CurrentValue, NULL, strval($this->id_grupo->CurrentValue) == "");

		// talla
		$this->talla->setDbValueDef($rsnew, $this->talla->CurrentValue, NULL, FALSE);

		// mostrarcolor
		$this->mostrarcolor->setDbValueDef($rsnew, $this->mostrarcolor->CurrentValue, NULL, strval($this->mostrarcolor->CurrentValue) == "");

		// lote
		$this->lote->setDbValueDef($rsnew, $this->lote->CurrentValue, NULL, FALSE);

		// manzana
		$this->manzana->setDbValueDef($rsnew, $this->manzana->CurrentValue, NULL, FALSE);

		// etapa
		$this->etapa->setDbValueDef($rsnew, $this->etapa->CurrentValue, NULL, strval($this->etapa->CurrentValue) == "");

		// estado
		$this->estado->setDbValueDef($rsnew, $this->estado->CurrentValue, NULL, strval($this->estado->CurrentValue) == "");

		// icon
		$this->icon->setDbValueDef($rsnew, $this->icon->CurrentValue, NULL, FALSE);

		// topy
		$this->topy->setDbValueDef($rsnew, $this->topy->CurrentValue, NULL, FALSE);

		// leftx
		$this->leftx->setDbValueDef($rsnew, $this->leftx->CurrentValue, NULL, FALSE);

		// codlogin
		$this->codlogin->setDbValueDef($rsnew, $this->codlogin->CurrentValue, NULL, FALSE);

		// id_cliente
		$this->id_cliente->setDbValueDef($rsnew, $this->id_cliente->CurrentValue, NULL, strval($this->id_cliente->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("loteslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>