<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class lotes_delete extends lotes
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'lotes';

	// Page object name
	public $PageObjName = "lotes_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (lotes)
		if (!isset($GLOBALS["lotes"]) || get_class($GLOBALS["lotes"]) == PROJECT_NAMESPACE . "lotes") {
			$GLOBALS["lotes"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["lotes"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'lotes');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $lotes;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($lotes);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id_producto'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id_producto->Visible = FALSE;
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("loteslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id_producto->setVisibility();
		$this->id_proyecto->setVisibility();
		$this->codigo_producto->setVisibility();
		$this->nombre_producto->setVisibility();
		$this->status_producto->setVisibility();
		$this->date_added->setVisibility();
		$this->precio_producto->setVisibility();
		$this->costo_producto->setVisibility();
		$this->mon_costo->setVisibility();
		$this->mon_venta->setVisibility();
		$this->marca->setVisibility();
		$this->modelo->setVisibility();
		$this->color->setVisibility();
		$this->b1->setVisibility();
		$this->b2->setVisibility();
		$this->b3->setVisibility();
		$this->b4->setVisibility();
		$this->b5->setVisibility();
		$this->b6->setVisibility();
		$this->cat_pro->setVisibility();
		$this->pro_ser->setVisibility();
		$this->foto1->setVisibility();
		$this->foto2->setVisibility();
		$this->foto3->setVisibility();
		$this->foto4->setVisibility();
		$this->web->setVisibility();
		$this->pre_web->setVisibility();
		$this->descripcion->Visible = FALSE;
		$this->descripcion1->Visible = FALSE;
		$this->megusta->setVisibility();
		$this->nomegusta->setVisibility();
		$this->precio2->setVisibility();
		$this->precio3->setVisibility();
		$this->und_pro->setVisibility();
		$this->barras->setVisibility();
		$this->stockmin->setVisibility();
		$this->id_grupo->setVisibility();
		$this->talla->setVisibility();
		$this->mostrarcolor->setVisibility();
		$this->lote->setVisibility();
		$this->manzana->setVisibility();
		$this->etapa->setVisibility();
		$this->estado->setVisibility();
		$this->icon->setVisibility();
		$this->topy->setVisibility();
		$this->leftx->setVisibility();
		$this->codlogin->setVisibility();
		$this->id_cliente->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("loteslist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("loteslist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id_producto->setDbValue($row['id_producto']);
		$this->id_proyecto->setDbValue($row['id_proyecto']);
		$this->codigo_producto->setDbValue($row['codigo_producto']);
		$this->nombre_producto->setDbValue($row['nombre_producto']);
		$this->status_producto->setDbValue($row['status_producto']);
		$this->date_added->setDbValue($row['date_added']);
		$this->precio_producto->setDbValue($row['precio_producto']);
		$this->costo_producto->setDbValue($row['costo_producto']);
		$this->mon_costo->setDbValue($row['mon_costo']);
		$this->mon_venta->setDbValue($row['mon_venta']);
		$this->marca->setDbValue($row['marca']);
		$this->modelo->setDbValue($row['modelo']);
		$this->color->setDbValue($row['color']);
		$this->b1->setDbValue($row['b1']);
		$this->b2->setDbValue($row['b2']);
		$this->b3->setDbValue($row['b3']);
		$this->b4->setDbValue($row['b4']);
		$this->b5->setDbValue($row['b5']);
		$this->b6->setDbValue($row['b6']);
		$this->cat_pro->setDbValue($row['cat_pro']);
		$this->pro_ser->setDbValue($row['pro_ser']);
		$this->foto1->setDbValue($row['foto1']);
		$this->foto2->setDbValue($row['foto2']);
		$this->foto3->setDbValue($row['foto3']);
		$this->foto4->setDbValue($row['foto4']);
		$this->web->setDbValue($row['web']);
		$this->pre_web->setDbValue($row['pre_web']);
		$this->descripcion->setDbValue($row['descripcion']);
		$this->descripcion1->setDbValue($row['descripcion1']);
		$this->megusta->setDbValue($row['megusta']);
		$this->nomegusta->setDbValue($row['nomegusta']);
		$this->precio2->setDbValue($row['precio2']);
		$this->precio3->setDbValue($row['precio3']);
		$this->und_pro->setDbValue($row['und_pro']);
		$this->barras->setDbValue($row['barras']);
		$this->stockmin->setDbValue($row['stockmin']);
		$this->id_grupo->setDbValue($row['id_grupo']);
		$this->talla->setDbValue($row['talla']);
		$this->mostrarcolor->setDbValue($row['mostrarcolor']);
		$this->lote->setDbValue($row['lote']);
		$this->manzana->setDbValue($row['manzana']);
		$this->etapa->setDbValue($row['etapa']);
		$this->estado->setDbValue($row['estado']);
		$this->icon->setDbValue($row['icon']);
		$this->topy->setDbValue($row['topy']);
		$this->leftx->setDbValue($row['leftx']);
		$this->codlogin->setDbValue($row['codlogin']);
		$this->id_cliente->setDbValue($row['id_cliente']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id_producto'] = NULL;
		$row['id_proyecto'] = NULL;
		$row['codigo_producto'] = NULL;
		$row['nombre_producto'] = NULL;
		$row['status_producto'] = NULL;
		$row['date_added'] = NULL;
		$row['precio_producto'] = NULL;
		$row['costo_producto'] = NULL;
		$row['mon_costo'] = NULL;
		$row['mon_venta'] = NULL;
		$row['marca'] = NULL;
		$row['modelo'] = NULL;
		$row['color'] = NULL;
		$row['b1'] = NULL;
		$row['b2'] = NULL;
		$row['b3'] = NULL;
		$row['b4'] = NULL;
		$row['b5'] = NULL;
		$row['b6'] = NULL;
		$row['cat_pro'] = NULL;
		$row['pro_ser'] = NULL;
		$row['foto1'] = NULL;
		$row['foto2'] = NULL;
		$row['foto3'] = NULL;
		$row['foto4'] = NULL;
		$row['web'] = NULL;
		$row['pre_web'] = NULL;
		$row['descripcion'] = NULL;
		$row['descripcion1'] = NULL;
		$row['megusta'] = NULL;
		$row['nomegusta'] = NULL;
		$row['precio2'] = NULL;
		$row['precio3'] = NULL;
		$row['und_pro'] = NULL;
		$row['barras'] = NULL;
		$row['stockmin'] = NULL;
		$row['id_grupo'] = NULL;
		$row['talla'] = NULL;
		$row['mostrarcolor'] = NULL;
		$row['lote'] = NULL;
		$row['manzana'] = NULL;
		$row['etapa'] = NULL;
		$row['estado'] = NULL;
		$row['icon'] = NULL;
		$row['topy'] = NULL;
		$row['leftx'] = NULL;
		$row['codlogin'] = NULL;
		$row['id_cliente'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->precio_producto->FormValue == $this->precio_producto->CurrentValue && is_numeric(ConvertToFloatString($this->precio_producto->CurrentValue)))
			$this->precio_producto->CurrentValue = ConvertToFloatString($this->precio_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->costo_producto->FormValue == $this->costo_producto->CurrentValue && is_numeric(ConvertToFloatString($this->costo_producto->CurrentValue)))
			$this->costo_producto->CurrentValue = ConvertToFloatString($this->costo_producto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_costo->FormValue == $this->mon_costo->CurrentValue && is_numeric(ConvertToFloatString($this->mon_costo->CurrentValue)))
			$this->mon_costo->CurrentValue = ConvertToFloatString($this->mon_costo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mon_venta->FormValue == $this->mon_venta->CurrentValue && is_numeric(ConvertToFloatString($this->mon_venta->CurrentValue)))
			$this->mon_venta->CurrentValue = ConvertToFloatString($this->mon_venta->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b1->FormValue == $this->b1->CurrentValue && is_numeric(ConvertToFloatString($this->b1->CurrentValue)))
			$this->b1->CurrentValue = ConvertToFloatString($this->b1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b2->FormValue == $this->b2->CurrentValue && is_numeric(ConvertToFloatString($this->b2->CurrentValue)))
			$this->b2->CurrentValue = ConvertToFloatString($this->b2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b3->FormValue == $this->b3->CurrentValue && is_numeric(ConvertToFloatString($this->b3->CurrentValue)))
			$this->b3->CurrentValue = ConvertToFloatString($this->b3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b4->FormValue == $this->b4->CurrentValue && is_numeric(ConvertToFloatString($this->b4->CurrentValue)))
			$this->b4->CurrentValue = ConvertToFloatString($this->b4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b5->FormValue == $this->b5->CurrentValue && is_numeric(ConvertToFloatString($this->b5->CurrentValue)))
			$this->b5->CurrentValue = ConvertToFloatString($this->b5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b6->FormValue == $this->b6->CurrentValue && is_numeric(ConvertToFloatString($this->b6->CurrentValue)))
			$this->b6->CurrentValue = ConvertToFloatString($this->b6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pre_web->FormValue == $this->pre_web->CurrentValue && is_numeric(ConvertToFloatString($this->pre_web->CurrentValue)))
			$this->pre_web->CurrentValue = ConvertToFloatString($this->pre_web->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio2->FormValue == $this->precio2->CurrentValue && is_numeric(ConvertToFloatString($this->precio2->CurrentValue)))
			$this->precio2->CurrentValue = ConvertToFloatString($this->precio2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->precio3->FormValue == $this->precio3->CurrentValue && is_numeric(ConvertToFloatString($this->precio3->CurrentValue)))
			$this->precio3->CurrentValue = ConvertToFloatString($this->precio3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stockmin->FormValue == $this->stockmin->CurrentValue && is_numeric(ConvertToFloatString($this->stockmin->CurrentValue)))
			$this->stockmin->CurrentValue = ConvertToFloatString($this->stockmin->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id_producto
		// id_proyecto
		// codigo_producto
		// nombre_producto
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// lote
		// manzana
		// etapa
		// estado
		// icon
		// topy
		// leftx
		// codlogin
		// id_cliente

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id_producto
			$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
			$this->id_producto->ViewCustomAttributes = "";

			// id_proyecto
			$this->id_proyecto->ViewValue = $this->id_proyecto->CurrentValue;
			$this->id_proyecto->ViewValue = FormatNumber($this->id_proyecto->ViewValue, 0, -2, -2, -2);
			$this->id_proyecto->ViewCustomAttributes = "";

			// codigo_producto
			$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
			$this->codigo_producto->ViewCustomAttributes = "";

			// nombre_producto
			$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
			$this->nombre_producto->ViewCustomAttributes = "";

			// status_producto
			$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
			$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
			$this->status_producto->ViewCustomAttributes = "";

			// date_added
			$this->date_added->ViewValue = $this->date_added->CurrentValue;
			$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
			$this->date_added->ViewCustomAttributes = "";

			// precio_producto
			$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
			$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
			$this->precio_producto->ViewCustomAttributes = "";

			// costo_producto
			$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
			$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
			$this->costo_producto->ViewCustomAttributes = "";

			// mon_costo
			$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
			$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
			$this->mon_costo->ViewCustomAttributes = "";

			// mon_venta
			$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
			$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 2, -2, -2, -2);
			$this->mon_venta->ViewCustomAttributes = "";

			// marca
			$this->marca->ViewValue = $this->marca->CurrentValue;
			$this->marca->ViewCustomAttributes = "";

			// modelo
			$this->modelo->ViewValue = $this->modelo->CurrentValue;
			$this->modelo->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// b1
			$this->b1->ViewValue = $this->b1->CurrentValue;
			$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
			$this->b1->ViewCustomAttributes = "";

			// b2
			$this->b2->ViewValue = $this->b2->CurrentValue;
			$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
			$this->b2->ViewCustomAttributes = "";

			// b3
			$this->b3->ViewValue = $this->b3->CurrentValue;
			$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
			$this->b3->ViewCustomAttributes = "";

			// b4
			$this->b4->ViewValue = $this->b4->CurrentValue;
			$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
			$this->b4->ViewCustomAttributes = "";

			// b5
			$this->b5->ViewValue = $this->b5->CurrentValue;
			$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
			$this->b5->ViewCustomAttributes = "";

			// b6
			$this->b6->ViewValue = $this->b6->CurrentValue;
			$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
			$this->b6->ViewCustomAttributes = "";

			// cat_pro
			$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
			$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
			$this->cat_pro->ViewCustomAttributes = "";

			// pro_ser
			$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
			$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
			$this->pro_ser->ViewCustomAttributes = "";

			// foto1
			$this->foto1->ViewValue = $this->foto1->CurrentValue;
			$this->foto1->ViewCustomAttributes = "";

			// foto2
			$this->foto2->ViewValue = $this->foto2->CurrentValue;
			$this->foto2->ViewCustomAttributes = "";

			// foto3
			$this->foto3->ViewValue = $this->foto3->CurrentValue;
			$this->foto3->ViewCustomAttributes = "";

			// foto4
			$this->foto4->ViewValue = $this->foto4->CurrentValue;
			$this->foto4->ViewCustomAttributes = "";

			// web
			$this->web->ViewValue = $this->web->CurrentValue;
			$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
			$this->web->ViewCustomAttributes = "";

			// pre_web
			$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
			$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
			$this->pre_web->ViewCustomAttributes = "";

			// megusta
			$this->megusta->ViewValue = $this->megusta->CurrentValue;
			$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
			$this->megusta->ViewCustomAttributes = "";

			// nomegusta
			$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
			$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
			$this->nomegusta->ViewCustomAttributes = "";

			// precio2
			$this->precio2->ViewValue = $this->precio2->CurrentValue;
			$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
			$this->precio2->ViewCustomAttributes = "";

			// precio3
			$this->precio3->ViewValue = $this->precio3->CurrentValue;
			$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
			$this->precio3->ViewCustomAttributes = "";

			// und_pro
			$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
			$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
			$this->und_pro->ViewCustomAttributes = "";

			// barras
			$this->barras->ViewValue = $this->barras->CurrentValue;
			$this->barras->ViewCustomAttributes = "";

			// stockmin
			$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
			$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
			$this->stockmin->ViewCustomAttributes = "";

			// id_grupo
			$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
			$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
			$this->id_grupo->ViewCustomAttributes = "";

			// talla
			$this->talla->ViewValue = $this->talla->CurrentValue;
			$this->talla->ViewCustomAttributes = "";

			// mostrarcolor
			$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
			$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
			$this->mostrarcolor->ViewCustomAttributes = "";

			// lote
			$this->lote->ViewValue = $this->lote->CurrentValue;
			$this->lote->ViewCustomAttributes = "";

			// manzana
			$this->manzana->ViewValue = $this->manzana->CurrentValue;
			$this->manzana->ViewCustomAttributes = "";

			// etapa
			$this->etapa->ViewValue = $this->etapa->CurrentValue;
			$this->etapa->ViewValue = FormatNumber($this->etapa->ViewValue, 0, -2, -2, -2);
			$this->etapa->ViewCustomAttributes = "";

			// estado
			$this->estado->ViewValue = $this->estado->CurrentValue;
			$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
			$this->estado->ViewCustomAttributes = "";

			// icon
			$this->icon->ViewValue = $this->icon->CurrentValue;
			$this->icon->ViewCustomAttributes = "";

			// topy
			$this->topy->ViewValue = $this->topy->CurrentValue;
			$this->topy->ViewCustomAttributes = "";

			// leftx
			$this->leftx->ViewValue = $this->leftx->CurrentValue;
			$this->leftx->ViewCustomAttributes = "";

			// codlogin
			$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
			$this->codlogin->ViewCustomAttributes = "";

			// id_cliente
			$this->id_cliente->ViewValue = $this->id_cliente->CurrentValue;
			$this->id_cliente->ViewValue = FormatNumber($this->id_cliente->ViewValue, 0, -2, -2, -2);
			$this->id_cliente->ViewCustomAttributes = "";

			// id_producto
			$this->id_producto->LinkCustomAttributes = "";
			$this->id_producto->HrefValue = "";
			$this->id_producto->TooltipValue = "";

			// id_proyecto
			$this->id_proyecto->LinkCustomAttributes = "";
			$this->id_proyecto->HrefValue = "";
			$this->id_proyecto->TooltipValue = "";

			// codigo_producto
			$this->codigo_producto->LinkCustomAttributes = "";
			$this->codigo_producto->HrefValue = "";
			$this->codigo_producto->TooltipValue = "";

			// nombre_producto
			$this->nombre_producto->LinkCustomAttributes = "";
			$this->nombre_producto->HrefValue = "";
			$this->nombre_producto->TooltipValue = "";

			// status_producto
			$this->status_producto->LinkCustomAttributes = "";
			$this->status_producto->HrefValue = "";
			$this->status_producto->TooltipValue = "";

			// date_added
			$this->date_added->LinkCustomAttributes = "";
			$this->date_added->HrefValue = "";
			$this->date_added->TooltipValue = "";

			// precio_producto
			$this->precio_producto->LinkCustomAttributes = "";
			$this->precio_producto->HrefValue = "";
			$this->precio_producto->TooltipValue = "";

			// costo_producto
			$this->costo_producto->LinkCustomAttributes = "";
			$this->costo_producto->HrefValue = "";
			$this->costo_producto->TooltipValue = "";

			// mon_costo
			$this->mon_costo->LinkCustomAttributes = "";
			$this->mon_costo->HrefValue = "";
			$this->mon_costo->TooltipValue = "";

			// mon_venta
			$this->mon_venta->LinkCustomAttributes = "";
			$this->mon_venta->HrefValue = "";
			$this->mon_venta->TooltipValue = "";

			// marca
			$this->marca->LinkCustomAttributes = "";
			$this->marca->HrefValue = "";
			$this->marca->TooltipValue = "";

			// modelo
			$this->modelo->LinkCustomAttributes = "";
			$this->modelo->HrefValue = "";
			$this->modelo->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// b1
			$this->b1->LinkCustomAttributes = "";
			$this->b1->HrefValue = "";
			$this->b1->TooltipValue = "";

			// b2
			$this->b2->LinkCustomAttributes = "";
			$this->b2->HrefValue = "";
			$this->b2->TooltipValue = "";

			// b3
			$this->b3->LinkCustomAttributes = "";
			$this->b3->HrefValue = "";
			$this->b3->TooltipValue = "";

			// b4
			$this->b4->LinkCustomAttributes = "";
			$this->b4->HrefValue = "";
			$this->b4->TooltipValue = "";

			// b5
			$this->b5->LinkCustomAttributes = "";
			$this->b5->HrefValue = "";
			$this->b5->TooltipValue = "";

			// b6
			$this->b6->LinkCustomAttributes = "";
			$this->b6->HrefValue = "";
			$this->b6->TooltipValue = "";

			// cat_pro
			$this->cat_pro->LinkCustomAttributes = "";
			$this->cat_pro->HrefValue = "";
			$this->cat_pro->TooltipValue = "";

			// pro_ser
			$this->pro_ser->LinkCustomAttributes = "";
			$this->pro_ser->HrefValue = "";
			$this->pro_ser->TooltipValue = "";

			// foto1
			$this->foto1->LinkCustomAttributes = "";
			$this->foto1->HrefValue = "";
			$this->foto1->TooltipValue = "";

			// foto2
			$this->foto2->LinkCustomAttributes = "";
			$this->foto2->HrefValue = "";
			$this->foto2->TooltipValue = "";

			// foto3
			$this->foto3->LinkCustomAttributes = "";
			$this->foto3->HrefValue = "";
			$this->foto3->TooltipValue = "";

			// foto4
			$this->foto4->LinkCustomAttributes = "";
			$this->foto4->HrefValue = "";
			$this->foto4->TooltipValue = "";

			// web
			$this->web->LinkCustomAttributes = "";
			$this->web->HrefValue = "";
			$this->web->TooltipValue = "";

			// pre_web
			$this->pre_web->LinkCustomAttributes = "";
			$this->pre_web->HrefValue = "";
			$this->pre_web->TooltipValue = "";

			// megusta
			$this->megusta->LinkCustomAttributes = "";
			$this->megusta->HrefValue = "";
			$this->megusta->TooltipValue = "";

			// nomegusta
			$this->nomegusta->LinkCustomAttributes = "";
			$this->nomegusta->HrefValue = "";
			$this->nomegusta->TooltipValue = "";

			// precio2
			$this->precio2->LinkCustomAttributes = "";
			$this->precio2->HrefValue = "";
			$this->precio2->TooltipValue = "";

			// precio3
			$this->precio3->LinkCustomAttributes = "";
			$this->precio3->HrefValue = "";
			$this->precio3->TooltipValue = "";

			// und_pro
			$this->und_pro->LinkCustomAttributes = "";
			$this->und_pro->HrefValue = "";
			$this->und_pro->TooltipValue = "";

			// barras
			$this->barras->LinkCustomAttributes = "";
			$this->barras->HrefValue = "";
			$this->barras->TooltipValue = "";

			// stockmin
			$this->stockmin->LinkCustomAttributes = "";
			$this->stockmin->HrefValue = "";
			$this->stockmin->TooltipValue = "";

			// id_grupo
			$this->id_grupo->LinkCustomAttributes = "";
			$this->id_grupo->HrefValue = "";
			$this->id_grupo->TooltipValue = "";

			// talla
			$this->talla->LinkCustomAttributes = "";
			$this->talla->HrefValue = "";
			$this->talla->TooltipValue = "";

			// mostrarcolor
			$this->mostrarcolor->LinkCustomAttributes = "";
			$this->mostrarcolor->HrefValue = "";
			$this->mostrarcolor->TooltipValue = "";

			// lote
			$this->lote->LinkCustomAttributes = "";
			$this->lote->HrefValue = "";
			$this->lote->TooltipValue = "";

			// manzana
			$this->manzana->LinkCustomAttributes = "";
			$this->manzana->HrefValue = "";
			$this->manzana->TooltipValue = "";

			// etapa
			$this->etapa->LinkCustomAttributes = "";
			$this->etapa->HrefValue = "";
			$this->etapa->TooltipValue = "";

			// estado
			$this->estado->LinkCustomAttributes = "";
			$this->estado->HrefValue = "";
			$this->estado->TooltipValue = "";

			// icon
			$this->icon->LinkCustomAttributes = "";
			$this->icon->HrefValue = "";
			$this->icon->TooltipValue = "";

			// topy
			$this->topy->LinkCustomAttributes = "";
			$this->topy->HrefValue = "";
			$this->topy->TooltipValue = "";

			// leftx
			$this->leftx->LinkCustomAttributes = "";
			$this->leftx->HrefValue = "";
			$this->leftx->TooltipValue = "";

			// codlogin
			$this->codlogin->LinkCustomAttributes = "";
			$this->codlogin->HrefValue = "";
			$this->codlogin->TooltipValue = "";

			// id_cliente
			$this->id_cliente->LinkCustomAttributes = "";
			$this->id_cliente->HrefValue = "";
			$this->id_cliente->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['id_producto'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("loteslist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>