<?php
namespace PHPMaker2020\project2;

/**
 * Page class
 */
class procesos_nuevo_list extends procesos_nuevo
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{AA140015-983A-47F7-B2DB-866F9851A082}";

	// Table name
	public $TableName = 'procesos_nuevo';

	// Page object name
	public $PageObjName = "procesos_nuevo_list";

	// Grid form hidden field names
	public $FormName = "fprocesos_nuevolist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (procesos_nuevo)
		if (!isset($GLOBALS["procesos_nuevo"]) || get_class($GLOBALS["procesos_nuevo"]) == PROJECT_NAMESPACE . "procesos_nuevo") {
			$GLOBALS["procesos_nuevo"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["procesos_nuevo"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "procesos_nuevoadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "procesos_nuevodelete.php";
		$this->MultiUpdateUrl = "procesos_nuevoupdate.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'procesos_nuevo');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option fprocesos_nuevolistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $procesos_nuevo;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($procesos_nuevo);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['codigo'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->codigo->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!$this->setupApiRequest())
			return FALSE;

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API request
	public function setupApiRequest()
	{
		global $Security;

		// Check security for API request
		If (ValidApiRequest()) {
			return TRUE;
		}
		return FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (!$this->setupApiRequest()) {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->codigo->setVisibility();
		$this->codigo_proceso->setVisibility();
		$this->no->setVisibility();
		$this->usuarios->setVisibility();
		$this->SEC_EJEC->setVisibility();
		$this->TIPO_MODALIDAD->setVisibility();
		$this->SECUENCIA->setVisibility();
		$this->AMBIENTE->setVisibility();
		$this->RUC_ENTIDAD->setVisibility();
		$this->LOCAL->setVisibility();
		$this->DEPARTAMENTO->setVisibility();
		$this->PROVINCIA->setVisibility();
		$this->DISTRITO->setVisibility();
		$this->AREA->setVisibility();
		$this->OFICINA->setVisibility();
		$this->PISO_OFICINA->setVisibility();
		$this->NRO_DOC_IDENT_PERSONAL->setVisibility();
		$this->APELLIDO_PATERNO->setVisibility();
		$this->APELLIDO_MATERNO->setVisibility();
		$this->NOMBRES->setVisibility();
		$this->OPERATIVO->setVisibility();
		$this->TIPO_DOC_IDENTIDAD->setVisibility();
		$this->MODALIDAD_CONTRATO->setVisibility();
		$this->CODIGO_PATRIMONIAL->setVisibility();
		$this->DENOMINACION_BIEN->setVisibility();
		$this->TIPO_CAUSAL_ALTA->setVisibility();
		$this->NRO_DOC_ADQUISICION->setVisibility();
		$this->FECHA_ADQUISICION->setVisibility();
		$this->VALOR_ADQUISICION->setVisibility();
		$this->FECHA_DEPRECIACION->setVisibility();
		$this->VALOR_DEPREC_EJERCICIO->setVisibility();
		$this->VALOR_DEPREC_ACUMULADO->setVisibility();
		$this->VALOR_NETO->setVisibility();
		$this->TIP_USO_CUENTA->setVisibility();
		$this->TIPO_CUENTA->setVisibility();
		$this->NRO_CUENTA_CONTABLE->setVisibility();
		$this->CTA_CON_SEGURO->setVisibility();
		$this->ESTADO_BIEN->setVisibility();
		$this->CONDICION->setVisibility();
		$this->MARCA->setVisibility();
		$this->MODELO->setVisibility();
		$this->TIPO->setVisibility();
		$this->COLOR->setVisibility();
		$this->SERIE->setVisibility();
		$this->DIMENSION->setVisibility();
		$this->PLACA->setVisibility();
		$this->NRO_MOTOR->setVisibility();
		$this->NRO_CHASIS->setVisibility();
		$this->MATRICULA->setVisibility();
		$this->ANIO_FABRICACION->setVisibility();
		$this->LONGITUD->setVisibility();
		$this->ALTURA->setVisibility();
		$this->ANCHO->setVisibility();
		$this->RAZA->setVisibility();
		$this->ESPECIE->setVisibility();
		$this->EDAD->setVisibility();
		$this->PAIS->setVisibility();
		$this->OTRAS_CARACT->setVisibility();
		$this->DESCRIPCION_UBICACION_BIEN->setVisibility();
		$this->CAUSAL_BAJA->setVisibility();
		$this->NRO_RESOLUCION_BAJA->setVisibility();
		$this->FECHA_BAJA->setVisibility();
		$this->ACTO_DISPOSICION_BIEN->setVisibility();
		$this->NRO_RESOLUCION_DISP->setVisibility();
		$this->FECHA_DISPOSICION->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setVisibility();
		$this->MOTIVO_ELIMINACION_BIEN->setVisibility();
		$this->ACTO_ADMINISTRACION_BIEN->setVisibility();
		$this->NUM_RESOLUCION_ADMINISTRACION->setVisibility();
		$this->FECHA_ADMINISTRACION->setVisibility();
		$this->FECHA_VENC_ACTO_ADMIN->setVisibility();
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setVisibility();
		$this->DOC_ALTA_SBN->setVisibility();
		$this->DOC_BAJA_SBN->setVisibility();
		$this->DEPENDENCIAS->setVisibility();
		$this->NUMERO_FICHA->setVisibility();
		$this->CODIGO_INTERNO->setVisibility();
		$this->ESTADO->setVisibility();
		$this->USO->setVisibility();
		$this->STICKER->setVisibility();
		$this->SEDE->setVisibility();
		$this->SBN->setVisibility();
		$this->ETIQUETA->setVisibility();
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setVisibility();
		$this->PLACA_RODAJE->setVisibility();
		$this->CODIGO_ACTUAL->setVisibility();
		$this->CODIGO_ANTERIOR->setVisibility();
		$this->PROPIEDAD->setVisibility();
		$this->SITUACION->setVisibility();
		$this->OBSERVACIONES->setVisibility();
		$this->FECHA_REGISTRO->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->codigo->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->codigo->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->codigo->AdvancedSearch->toJson(), ","); // Field codigo
		$filterList = Concat($filterList, $this->codigo_proceso->AdvancedSearch->toJson(), ","); // Field codigo_proceso
		$filterList = Concat($filterList, $this->no->AdvancedSearch->toJson(), ","); // Field no
		$filterList = Concat($filterList, $this->usuarios->AdvancedSearch->toJson(), ","); // Field usuarios
		$filterList = Concat($filterList, $this->SEC_EJEC->AdvancedSearch->toJson(), ","); // Field SEC_EJEC
		$filterList = Concat($filterList, $this->TIPO_MODALIDAD->AdvancedSearch->toJson(), ","); // Field TIPO_MODALIDAD
		$filterList = Concat($filterList, $this->SECUENCIA->AdvancedSearch->toJson(), ","); // Field SECUENCIA
		$filterList = Concat($filterList, $this->AMBIENTE->AdvancedSearch->toJson(), ","); // Field AMBIENTE
		$filterList = Concat($filterList, $this->RUC_ENTIDAD->AdvancedSearch->toJson(), ","); // Field RUC_ENTIDAD
		$filterList = Concat($filterList, $this->LOCAL->AdvancedSearch->toJson(), ","); // Field LOCAL
		$filterList = Concat($filterList, $this->DEPARTAMENTO->AdvancedSearch->toJson(), ","); // Field DEPARTAMENTO
		$filterList = Concat($filterList, $this->PROVINCIA->AdvancedSearch->toJson(), ","); // Field PROVINCIA
		$filterList = Concat($filterList, $this->DISTRITO->AdvancedSearch->toJson(), ","); // Field DISTRITO
		$filterList = Concat($filterList, $this->AREA->AdvancedSearch->toJson(), ","); // Field AREA
		$filterList = Concat($filterList, $this->OFICINA->AdvancedSearch->toJson(), ","); // Field OFICINA
		$filterList = Concat($filterList, $this->PISO_OFICINA->AdvancedSearch->toJson(), ","); // Field PISO_OFICINA
		$filterList = Concat($filterList, $this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->toJson(), ","); // Field NRO_DOC_IDENT_PERSONAL
		$filterList = Concat($filterList, $this->APELLIDO_PATERNO->AdvancedSearch->toJson(), ","); // Field APELLIDO_PATERNO
		$filterList = Concat($filterList, $this->APELLIDO_MATERNO->AdvancedSearch->toJson(), ","); // Field APELLIDO_MATERNO
		$filterList = Concat($filterList, $this->NOMBRES->AdvancedSearch->toJson(), ","); // Field NOMBRES
		$filterList = Concat($filterList, $this->OPERATIVO->AdvancedSearch->toJson(), ","); // Field OPERATIVO
		$filterList = Concat($filterList, $this->TIPO_DOC_IDENTIDAD->AdvancedSearch->toJson(), ","); // Field TIPO_DOC_IDENTIDAD
		$filterList = Concat($filterList, $this->MODALIDAD_CONTRATO->AdvancedSearch->toJson(), ","); // Field MODALIDAD_CONTRATO
		$filterList = Concat($filterList, $this->CODIGO_PATRIMONIAL->AdvancedSearch->toJson(), ","); // Field CODIGO_PATRIMONIAL
		$filterList = Concat($filterList, $this->DENOMINACION_BIEN->AdvancedSearch->toJson(), ","); // Field DENOMINACION_BIEN
		$filterList = Concat($filterList, $this->TIPO_CAUSAL_ALTA->AdvancedSearch->toJson(), ","); // Field TIPO_CAUSAL_ALTA
		$filterList = Concat($filterList, $this->NRO_DOC_ADQUISICION->AdvancedSearch->toJson(), ","); // Field NRO_DOC_ADQUISICION
		$filterList = Concat($filterList, $this->FECHA_ADQUISICION->AdvancedSearch->toJson(), ","); // Field FECHA_ADQUISICION
		$filterList = Concat($filterList, $this->VALOR_ADQUISICION->AdvancedSearch->toJson(), ","); // Field VALOR_ADQUISICION
		$filterList = Concat($filterList, $this->FECHA_DEPRECIACION->AdvancedSearch->toJson(), ","); // Field FECHA_DEPRECIACION
		$filterList = Concat($filterList, $this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->toJson(), ","); // Field VALOR_DEPREC_EJERCICIO
		$filterList = Concat($filterList, $this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->toJson(), ","); // Field VALOR_DEPREC_ACUMULADO
		$filterList = Concat($filterList, $this->VALOR_NETO->AdvancedSearch->toJson(), ","); // Field VALOR_NETO
		$filterList = Concat($filterList, $this->TIP_USO_CUENTA->AdvancedSearch->toJson(), ","); // Field TIP_USO_CUENTA
		$filterList = Concat($filterList, $this->TIPO_CUENTA->AdvancedSearch->toJson(), ","); // Field TIPO_CUENTA
		$filterList = Concat($filterList, $this->NRO_CUENTA_CONTABLE->AdvancedSearch->toJson(), ","); // Field NRO_CUENTA_CONTABLE
		$filterList = Concat($filterList, $this->CTA_CON_SEGURO->AdvancedSearch->toJson(), ","); // Field CTA_CON_SEGURO
		$filterList = Concat($filterList, $this->ESTADO_BIEN->AdvancedSearch->toJson(), ","); // Field ESTADO_BIEN
		$filterList = Concat($filterList, $this->CONDICION->AdvancedSearch->toJson(), ","); // Field CONDICION
		$filterList = Concat($filterList, $this->MARCA->AdvancedSearch->toJson(), ","); // Field MARCA
		$filterList = Concat($filterList, $this->MODELO->AdvancedSearch->toJson(), ","); // Field MODELO
		$filterList = Concat($filterList, $this->TIPO->AdvancedSearch->toJson(), ","); // Field TIPO
		$filterList = Concat($filterList, $this->COLOR->AdvancedSearch->toJson(), ","); // Field COLOR
		$filterList = Concat($filterList, $this->SERIE->AdvancedSearch->toJson(), ","); // Field SERIE
		$filterList = Concat($filterList, $this->DIMENSION->AdvancedSearch->toJson(), ","); // Field DIMENSION
		$filterList = Concat($filterList, $this->PLACA->AdvancedSearch->toJson(), ","); // Field PLACA
		$filterList = Concat($filterList, $this->NRO_MOTOR->AdvancedSearch->toJson(), ","); // Field NRO_MOTOR
		$filterList = Concat($filterList, $this->NRO_CHASIS->AdvancedSearch->toJson(), ","); // Field NRO_CHASIS
		$filterList = Concat($filterList, $this->MATRICULA->AdvancedSearch->toJson(), ","); // Field MATRICULA
		$filterList = Concat($filterList, $this->ANIO_FABRICACION->AdvancedSearch->toJson(), ","); // Field ANIO_FABRICACION
		$filterList = Concat($filterList, $this->LONGITUD->AdvancedSearch->toJson(), ","); // Field LONGITUD
		$filterList = Concat($filterList, $this->ALTURA->AdvancedSearch->toJson(), ","); // Field ALTURA
		$filterList = Concat($filterList, $this->ANCHO->AdvancedSearch->toJson(), ","); // Field ANCHO
		$filterList = Concat($filterList, $this->RAZA->AdvancedSearch->toJson(), ","); // Field RAZA
		$filterList = Concat($filterList, $this->ESPECIE->AdvancedSearch->toJson(), ","); // Field ESPECIE
		$filterList = Concat($filterList, $this->EDAD->AdvancedSearch->toJson(), ","); // Field EDAD
		$filterList = Concat($filterList, $this->PAIS->AdvancedSearch->toJson(), ","); // Field PAIS
		$filterList = Concat($filterList, $this->OTRAS_CARACT->AdvancedSearch->toJson(), ","); // Field OTRAS_CARACT
		$filterList = Concat($filterList, $this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->toJson(), ","); // Field DESCRIPCION_UBICACION_BIEN
		$filterList = Concat($filterList, $this->CAUSAL_BAJA->AdvancedSearch->toJson(), ","); // Field CAUSAL_BAJA
		$filterList = Concat($filterList, $this->NRO_RESOLUCION_BAJA->AdvancedSearch->toJson(), ","); // Field NRO_RESOLUCION_BAJA
		$filterList = Concat($filterList, $this->FECHA_BAJA->AdvancedSearch->toJson(), ","); // Field FECHA_BAJA
		$filterList = Concat($filterList, $this->ACTO_DISPOSICION_BIEN->AdvancedSearch->toJson(), ","); // Field ACTO_DISPOSICION_BIEN
		$filterList = Concat($filterList, $this->NRO_RESOLUCION_DISP->AdvancedSearch->toJson(), ","); // Field NRO_RESOLUCION_DISP
		$filterList = Concat($filterList, $this->FECHA_DISPOSICION->AdvancedSearch->toJson(), ","); // Field FECHA_DISPOSICION
		$filterList = Concat($filterList, $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->toJson(), ","); // Field ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		$filterList = Concat($filterList, $this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->toJson(), ","); // Field MOTIVO_ELIMINACION_BIEN
		$filterList = Concat($filterList, $this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->toJson(), ","); // Field ACTO_ADMINISTRACION_BIEN
		$filterList = Concat($filterList, $this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->toJson(), ","); // Field NUM_RESOLUCION_ADMINISTRACION
		$filterList = Concat($filterList, $this->FECHA_ADMINISTRACION->AdvancedSearch->toJson(), ","); // Field FECHA_ADMINISTRACION
		$filterList = Concat($filterList, $this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->toJson(), ","); // Field FECHA_VENC_ACTO_ADMIN
		$filterList = Concat($filterList, $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->toJson(), ","); // Field ENTIDAD_BENEFICIADA_ACTO_ADMIN
		$filterList = Concat($filterList, $this->DOC_ALTA_SBN->AdvancedSearch->toJson(), ","); // Field DOC_ALTA_SBN
		$filterList = Concat($filterList, $this->DOC_BAJA_SBN->AdvancedSearch->toJson(), ","); // Field DOC_BAJA_SBN
		$filterList = Concat($filterList, $this->DEPENDENCIAS->AdvancedSearch->toJson(), ","); // Field DEPENDENCIAS
		$filterList = Concat($filterList, $this->NUMERO_FICHA->AdvancedSearch->toJson(), ","); // Field NUMERO_FICHA
		$filterList = Concat($filterList, $this->CODIGO_INTERNO->AdvancedSearch->toJson(), ","); // Field CODIGO_INTERNO
		$filterList = Concat($filterList, $this->ESTADO->AdvancedSearch->toJson(), ","); // Field ESTADO
		$filterList = Concat($filterList, $this->USO->AdvancedSearch->toJson(), ","); // Field USO
		$filterList = Concat($filterList, $this->STICKER->AdvancedSearch->toJson(), ","); // Field STICKER
		$filterList = Concat($filterList, $this->SEDE->AdvancedSearch->toJson(), ","); // Field SEDE
		$filterList = Concat($filterList, $this->SBN->AdvancedSearch->toJson(), ","); // Field SBN
		$filterList = Concat($filterList, $this->ETIQUETA->AdvancedSearch->toJson(), ","); // Field ETIQUETA
		$filterList = Concat($filterList, $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->toJson(), ","); // Field NOMBRE_BENEFICIARIO_ACTO_ADMIN
		$filterList = Concat($filterList, $this->PLACA_RODAJE->AdvancedSearch->toJson(), ","); // Field PLACA_RODAJE
		$filterList = Concat($filterList, $this->CODIGO_ACTUAL->AdvancedSearch->toJson(), ","); // Field CODIGO_ACTUAL
		$filterList = Concat($filterList, $this->CODIGO_ANTERIOR->AdvancedSearch->toJson(), ","); // Field CODIGO_ANTERIOR
		$filterList = Concat($filterList, $this->PROPIEDAD->AdvancedSearch->toJson(), ","); // Field PROPIEDAD
		$filterList = Concat($filterList, $this->SITUACION->AdvancedSearch->toJson(), ","); // Field SITUACION
		$filterList = Concat($filterList, $this->OBSERVACIONES->AdvancedSearch->toJson(), ","); // Field OBSERVACIONES
		$filterList = Concat($filterList, $this->FECHA_REGISTRO->AdvancedSearch->toJson(), ","); // Field FECHA_REGISTRO
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fprocesos_nuevolistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field codigo
		$this->codigo->AdvancedSearch->SearchValue = @$filter["x_codigo"];
		$this->codigo->AdvancedSearch->SearchOperator = @$filter["z_codigo"];
		$this->codigo->AdvancedSearch->SearchCondition = @$filter["v_codigo"];
		$this->codigo->AdvancedSearch->SearchValue2 = @$filter["y_codigo"];
		$this->codigo->AdvancedSearch->SearchOperator2 = @$filter["w_codigo"];
		$this->codigo->AdvancedSearch->save();

		// Field codigo_proceso
		$this->codigo_proceso->AdvancedSearch->SearchValue = @$filter["x_codigo_proceso"];
		$this->codigo_proceso->AdvancedSearch->SearchOperator = @$filter["z_codigo_proceso"];
		$this->codigo_proceso->AdvancedSearch->SearchCondition = @$filter["v_codigo_proceso"];
		$this->codigo_proceso->AdvancedSearch->SearchValue2 = @$filter["y_codigo_proceso"];
		$this->codigo_proceso->AdvancedSearch->SearchOperator2 = @$filter["w_codigo_proceso"];
		$this->codigo_proceso->AdvancedSearch->save();

		// Field no
		$this->no->AdvancedSearch->SearchValue = @$filter["x_no"];
		$this->no->AdvancedSearch->SearchOperator = @$filter["z_no"];
		$this->no->AdvancedSearch->SearchCondition = @$filter["v_no"];
		$this->no->AdvancedSearch->SearchValue2 = @$filter["y_no"];
		$this->no->AdvancedSearch->SearchOperator2 = @$filter["w_no"];
		$this->no->AdvancedSearch->save();

		// Field usuarios
		$this->usuarios->AdvancedSearch->SearchValue = @$filter["x_usuarios"];
		$this->usuarios->AdvancedSearch->SearchOperator = @$filter["z_usuarios"];
		$this->usuarios->AdvancedSearch->SearchCondition = @$filter["v_usuarios"];
		$this->usuarios->AdvancedSearch->SearchValue2 = @$filter["y_usuarios"];
		$this->usuarios->AdvancedSearch->SearchOperator2 = @$filter["w_usuarios"];
		$this->usuarios->AdvancedSearch->save();

		// Field SEC_EJEC
		$this->SEC_EJEC->AdvancedSearch->SearchValue = @$filter["x_SEC_EJEC"];
		$this->SEC_EJEC->AdvancedSearch->SearchOperator = @$filter["z_SEC_EJEC"];
		$this->SEC_EJEC->AdvancedSearch->SearchCondition = @$filter["v_SEC_EJEC"];
		$this->SEC_EJEC->AdvancedSearch->SearchValue2 = @$filter["y_SEC_EJEC"];
		$this->SEC_EJEC->AdvancedSearch->SearchOperator2 = @$filter["w_SEC_EJEC"];
		$this->SEC_EJEC->AdvancedSearch->save();

		// Field TIPO_MODALIDAD
		$this->TIPO_MODALIDAD->AdvancedSearch->SearchValue = @$filter["x_TIPO_MODALIDAD"];
		$this->TIPO_MODALIDAD->AdvancedSearch->SearchOperator = @$filter["z_TIPO_MODALIDAD"];
		$this->TIPO_MODALIDAD->AdvancedSearch->SearchCondition = @$filter["v_TIPO_MODALIDAD"];
		$this->TIPO_MODALIDAD->AdvancedSearch->SearchValue2 = @$filter["y_TIPO_MODALIDAD"];
		$this->TIPO_MODALIDAD->AdvancedSearch->SearchOperator2 = @$filter["w_TIPO_MODALIDAD"];
		$this->TIPO_MODALIDAD->AdvancedSearch->save();

		// Field SECUENCIA
		$this->SECUENCIA->AdvancedSearch->SearchValue = @$filter["x_SECUENCIA"];
		$this->SECUENCIA->AdvancedSearch->SearchOperator = @$filter["z_SECUENCIA"];
		$this->SECUENCIA->AdvancedSearch->SearchCondition = @$filter["v_SECUENCIA"];
		$this->SECUENCIA->AdvancedSearch->SearchValue2 = @$filter["y_SECUENCIA"];
		$this->SECUENCIA->AdvancedSearch->SearchOperator2 = @$filter["w_SECUENCIA"];
		$this->SECUENCIA->AdvancedSearch->save();

		// Field AMBIENTE
		$this->AMBIENTE->AdvancedSearch->SearchValue = @$filter["x_AMBIENTE"];
		$this->AMBIENTE->AdvancedSearch->SearchOperator = @$filter["z_AMBIENTE"];
		$this->AMBIENTE->AdvancedSearch->SearchCondition = @$filter["v_AMBIENTE"];
		$this->AMBIENTE->AdvancedSearch->SearchValue2 = @$filter["y_AMBIENTE"];
		$this->AMBIENTE->AdvancedSearch->SearchOperator2 = @$filter["w_AMBIENTE"];
		$this->AMBIENTE->AdvancedSearch->save();

		// Field RUC_ENTIDAD
		$this->RUC_ENTIDAD->AdvancedSearch->SearchValue = @$filter["x_RUC_ENTIDAD"];
		$this->RUC_ENTIDAD->AdvancedSearch->SearchOperator = @$filter["z_RUC_ENTIDAD"];
		$this->RUC_ENTIDAD->AdvancedSearch->SearchCondition = @$filter["v_RUC_ENTIDAD"];
		$this->RUC_ENTIDAD->AdvancedSearch->SearchValue2 = @$filter["y_RUC_ENTIDAD"];
		$this->RUC_ENTIDAD->AdvancedSearch->SearchOperator2 = @$filter["w_RUC_ENTIDAD"];
		$this->RUC_ENTIDAD->AdvancedSearch->save();

		// Field LOCAL
		$this->LOCAL->AdvancedSearch->SearchValue = @$filter["x_LOCAL"];
		$this->LOCAL->AdvancedSearch->SearchOperator = @$filter["z_LOCAL"];
		$this->LOCAL->AdvancedSearch->SearchCondition = @$filter["v_LOCAL"];
		$this->LOCAL->AdvancedSearch->SearchValue2 = @$filter["y_LOCAL"];
		$this->LOCAL->AdvancedSearch->SearchOperator2 = @$filter["w_LOCAL"];
		$this->LOCAL->AdvancedSearch->save();

		// Field DEPARTAMENTO
		$this->DEPARTAMENTO->AdvancedSearch->SearchValue = @$filter["x_DEPARTAMENTO"];
		$this->DEPARTAMENTO->AdvancedSearch->SearchOperator = @$filter["z_DEPARTAMENTO"];
		$this->DEPARTAMENTO->AdvancedSearch->SearchCondition = @$filter["v_DEPARTAMENTO"];
		$this->DEPARTAMENTO->AdvancedSearch->SearchValue2 = @$filter["y_DEPARTAMENTO"];
		$this->DEPARTAMENTO->AdvancedSearch->SearchOperator2 = @$filter["w_DEPARTAMENTO"];
		$this->DEPARTAMENTO->AdvancedSearch->save();

		// Field PROVINCIA
		$this->PROVINCIA->AdvancedSearch->SearchValue = @$filter["x_PROVINCIA"];
		$this->PROVINCIA->AdvancedSearch->SearchOperator = @$filter["z_PROVINCIA"];
		$this->PROVINCIA->AdvancedSearch->SearchCondition = @$filter["v_PROVINCIA"];
		$this->PROVINCIA->AdvancedSearch->SearchValue2 = @$filter["y_PROVINCIA"];
		$this->PROVINCIA->AdvancedSearch->SearchOperator2 = @$filter["w_PROVINCIA"];
		$this->PROVINCIA->AdvancedSearch->save();

		// Field DISTRITO
		$this->DISTRITO->AdvancedSearch->SearchValue = @$filter["x_DISTRITO"];
		$this->DISTRITO->AdvancedSearch->SearchOperator = @$filter["z_DISTRITO"];
		$this->DISTRITO->AdvancedSearch->SearchCondition = @$filter["v_DISTRITO"];
		$this->DISTRITO->AdvancedSearch->SearchValue2 = @$filter["y_DISTRITO"];
		$this->DISTRITO->AdvancedSearch->SearchOperator2 = @$filter["w_DISTRITO"];
		$this->DISTRITO->AdvancedSearch->save();

		// Field AREA
		$this->AREA->AdvancedSearch->SearchValue = @$filter["x_AREA"];
		$this->AREA->AdvancedSearch->SearchOperator = @$filter["z_AREA"];
		$this->AREA->AdvancedSearch->SearchCondition = @$filter["v_AREA"];
		$this->AREA->AdvancedSearch->SearchValue2 = @$filter["y_AREA"];
		$this->AREA->AdvancedSearch->SearchOperator2 = @$filter["w_AREA"];
		$this->AREA->AdvancedSearch->save();

		// Field OFICINA
		$this->OFICINA->AdvancedSearch->SearchValue = @$filter["x_OFICINA"];
		$this->OFICINA->AdvancedSearch->SearchOperator = @$filter["z_OFICINA"];
		$this->OFICINA->AdvancedSearch->SearchCondition = @$filter["v_OFICINA"];
		$this->OFICINA->AdvancedSearch->SearchValue2 = @$filter["y_OFICINA"];
		$this->OFICINA->AdvancedSearch->SearchOperator2 = @$filter["w_OFICINA"];
		$this->OFICINA->AdvancedSearch->save();

		// Field PISO_OFICINA
		$this->PISO_OFICINA->AdvancedSearch->SearchValue = @$filter["x_PISO_OFICINA"];
		$this->PISO_OFICINA->AdvancedSearch->SearchOperator = @$filter["z_PISO_OFICINA"];
		$this->PISO_OFICINA->AdvancedSearch->SearchCondition = @$filter["v_PISO_OFICINA"];
		$this->PISO_OFICINA->AdvancedSearch->SearchValue2 = @$filter["y_PISO_OFICINA"];
		$this->PISO_OFICINA->AdvancedSearch->SearchOperator2 = @$filter["w_PISO_OFICINA"];
		$this->PISO_OFICINA->AdvancedSearch->save();

		// Field NRO_DOC_IDENT_PERSONAL
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->SearchValue = @$filter["x_NRO_DOC_IDENT_PERSONAL"];
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->SearchOperator = @$filter["z_NRO_DOC_IDENT_PERSONAL"];
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->SearchCondition = @$filter["v_NRO_DOC_IDENT_PERSONAL"];
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->SearchValue2 = @$filter["y_NRO_DOC_IDENT_PERSONAL"];
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_DOC_IDENT_PERSONAL"];
		$this->NRO_DOC_IDENT_PERSONAL->AdvancedSearch->save();

		// Field APELLIDO_PATERNO
		$this->APELLIDO_PATERNO->AdvancedSearch->SearchValue = @$filter["x_APELLIDO_PATERNO"];
		$this->APELLIDO_PATERNO->AdvancedSearch->SearchOperator = @$filter["z_APELLIDO_PATERNO"];
		$this->APELLIDO_PATERNO->AdvancedSearch->SearchCondition = @$filter["v_APELLIDO_PATERNO"];
		$this->APELLIDO_PATERNO->AdvancedSearch->SearchValue2 = @$filter["y_APELLIDO_PATERNO"];
		$this->APELLIDO_PATERNO->AdvancedSearch->SearchOperator2 = @$filter["w_APELLIDO_PATERNO"];
		$this->APELLIDO_PATERNO->AdvancedSearch->save();

		// Field APELLIDO_MATERNO
		$this->APELLIDO_MATERNO->AdvancedSearch->SearchValue = @$filter["x_APELLIDO_MATERNO"];
		$this->APELLIDO_MATERNO->AdvancedSearch->SearchOperator = @$filter["z_APELLIDO_MATERNO"];
		$this->APELLIDO_MATERNO->AdvancedSearch->SearchCondition = @$filter["v_APELLIDO_MATERNO"];
		$this->APELLIDO_MATERNO->AdvancedSearch->SearchValue2 = @$filter["y_APELLIDO_MATERNO"];
		$this->APELLIDO_MATERNO->AdvancedSearch->SearchOperator2 = @$filter["w_APELLIDO_MATERNO"];
		$this->APELLIDO_MATERNO->AdvancedSearch->save();

		// Field NOMBRES
		$this->NOMBRES->AdvancedSearch->SearchValue = @$filter["x_NOMBRES"];
		$this->NOMBRES->AdvancedSearch->SearchOperator = @$filter["z_NOMBRES"];
		$this->NOMBRES->AdvancedSearch->SearchCondition = @$filter["v_NOMBRES"];
		$this->NOMBRES->AdvancedSearch->SearchValue2 = @$filter["y_NOMBRES"];
		$this->NOMBRES->AdvancedSearch->SearchOperator2 = @$filter["w_NOMBRES"];
		$this->NOMBRES->AdvancedSearch->save();

		// Field OPERATIVO
		$this->OPERATIVO->AdvancedSearch->SearchValue = @$filter["x_OPERATIVO"];
		$this->OPERATIVO->AdvancedSearch->SearchOperator = @$filter["z_OPERATIVO"];
		$this->OPERATIVO->AdvancedSearch->SearchCondition = @$filter["v_OPERATIVO"];
		$this->OPERATIVO->AdvancedSearch->SearchValue2 = @$filter["y_OPERATIVO"];
		$this->OPERATIVO->AdvancedSearch->SearchOperator2 = @$filter["w_OPERATIVO"];
		$this->OPERATIVO->AdvancedSearch->save();

		// Field TIPO_DOC_IDENTIDAD
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->SearchValue = @$filter["x_TIPO_DOC_IDENTIDAD"];
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->SearchOperator = @$filter["z_TIPO_DOC_IDENTIDAD"];
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->SearchCondition = @$filter["v_TIPO_DOC_IDENTIDAD"];
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->SearchValue2 = @$filter["y_TIPO_DOC_IDENTIDAD"];
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->SearchOperator2 = @$filter["w_TIPO_DOC_IDENTIDAD"];
		$this->TIPO_DOC_IDENTIDAD->AdvancedSearch->save();

		// Field MODALIDAD_CONTRATO
		$this->MODALIDAD_CONTRATO->AdvancedSearch->SearchValue = @$filter["x_MODALIDAD_CONTRATO"];
		$this->MODALIDAD_CONTRATO->AdvancedSearch->SearchOperator = @$filter["z_MODALIDAD_CONTRATO"];
		$this->MODALIDAD_CONTRATO->AdvancedSearch->SearchCondition = @$filter["v_MODALIDAD_CONTRATO"];
		$this->MODALIDAD_CONTRATO->AdvancedSearch->SearchValue2 = @$filter["y_MODALIDAD_CONTRATO"];
		$this->MODALIDAD_CONTRATO->AdvancedSearch->SearchOperator2 = @$filter["w_MODALIDAD_CONTRATO"];
		$this->MODALIDAD_CONTRATO->AdvancedSearch->save();

		// Field CODIGO_PATRIMONIAL
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->SearchValue = @$filter["x_CODIGO_PATRIMONIAL"];
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->SearchOperator = @$filter["z_CODIGO_PATRIMONIAL"];
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->SearchCondition = @$filter["v_CODIGO_PATRIMONIAL"];
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->SearchValue2 = @$filter["y_CODIGO_PATRIMONIAL"];
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->SearchOperator2 = @$filter["w_CODIGO_PATRIMONIAL"];
		$this->CODIGO_PATRIMONIAL->AdvancedSearch->save();

		// Field DENOMINACION_BIEN
		$this->DENOMINACION_BIEN->AdvancedSearch->SearchValue = @$filter["x_DENOMINACION_BIEN"];
		$this->DENOMINACION_BIEN->AdvancedSearch->SearchOperator = @$filter["z_DENOMINACION_BIEN"];
		$this->DENOMINACION_BIEN->AdvancedSearch->SearchCondition = @$filter["v_DENOMINACION_BIEN"];
		$this->DENOMINACION_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_DENOMINACION_BIEN"];
		$this->DENOMINACION_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_DENOMINACION_BIEN"];
		$this->DENOMINACION_BIEN->AdvancedSearch->save();

		// Field TIPO_CAUSAL_ALTA
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->SearchValue = @$filter["x_TIPO_CAUSAL_ALTA"];
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->SearchOperator = @$filter["z_TIPO_CAUSAL_ALTA"];
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->SearchCondition = @$filter["v_TIPO_CAUSAL_ALTA"];
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->SearchValue2 = @$filter["y_TIPO_CAUSAL_ALTA"];
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->SearchOperator2 = @$filter["w_TIPO_CAUSAL_ALTA"];
		$this->TIPO_CAUSAL_ALTA->AdvancedSearch->save();

		// Field NRO_DOC_ADQUISICION
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->SearchValue = @$filter["x_NRO_DOC_ADQUISICION"];
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->SearchOperator = @$filter["z_NRO_DOC_ADQUISICION"];
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->SearchCondition = @$filter["v_NRO_DOC_ADQUISICION"];
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->SearchValue2 = @$filter["y_NRO_DOC_ADQUISICION"];
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_DOC_ADQUISICION"];
		$this->NRO_DOC_ADQUISICION->AdvancedSearch->save();

		// Field FECHA_ADQUISICION
		$this->FECHA_ADQUISICION->AdvancedSearch->SearchValue = @$filter["x_FECHA_ADQUISICION"];
		$this->FECHA_ADQUISICION->AdvancedSearch->SearchOperator = @$filter["z_FECHA_ADQUISICION"];
		$this->FECHA_ADQUISICION->AdvancedSearch->SearchCondition = @$filter["v_FECHA_ADQUISICION"];
		$this->FECHA_ADQUISICION->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_ADQUISICION"];
		$this->FECHA_ADQUISICION->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_ADQUISICION"];
		$this->FECHA_ADQUISICION->AdvancedSearch->save();

		// Field VALOR_ADQUISICION
		$this->VALOR_ADQUISICION->AdvancedSearch->SearchValue = @$filter["x_VALOR_ADQUISICION"];
		$this->VALOR_ADQUISICION->AdvancedSearch->SearchOperator = @$filter["z_VALOR_ADQUISICION"];
		$this->VALOR_ADQUISICION->AdvancedSearch->SearchCondition = @$filter["v_VALOR_ADQUISICION"];
		$this->VALOR_ADQUISICION->AdvancedSearch->SearchValue2 = @$filter["y_VALOR_ADQUISICION"];
		$this->VALOR_ADQUISICION->AdvancedSearch->SearchOperator2 = @$filter["w_VALOR_ADQUISICION"];
		$this->VALOR_ADQUISICION->AdvancedSearch->save();

		// Field FECHA_DEPRECIACION
		$this->FECHA_DEPRECIACION->AdvancedSearch->SearchValue = @$filter["x_FECHA_DEPRECIACION"];
		$this->FECHA_DEPRECIACION->AdvancedSearch->SearchOperator = @$filter["z_FECHA_DEPRECIACION"];
		$this->FECHA_DEPRECIACION->AdvancedSearch->SearchCondition = @$filter["v_FECHA_DEPRECIACION"];
		$this->FECHA_DEPRECIACION->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_DEPRECIACION"];
		$this->FECHA_DEPRECIACION->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_DEPRECIACION"];
		$this->FECHA_DEPRECIACION->AdvancedSearch->save();

		// Field VALOR_DEPREC_EJERCICIO
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->SearchValue = @$filter["x_VALOR_DEPREC_EJERCICIO"];
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->SearchOperator = @$filter["z_VALOR_DEPREC_EJERCICIO"];
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->SearchCondition = @$filter["v_VALOR_DEPREC_EJERCICIO"];
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->SearchValue2 = @$filter["y_VALOR_DEPREC_EJERCICIO"];
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->SearchOperator2 = @$filter["w_VALOR_DEPREC_EJERCICIO"];
		$this->VALOR_DEPREC_EJERCICIO->AdvancedSearch->save();

		// Field VALOR_DEPREC_ACUMULADO
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->SearchValue = @$filter["x_VALOR_DEPREC_ACUMULADO"];
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->SearchOperator = @$filter["z_VALOR_DEPREC_ACUMULADO"];
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->SearchCondition = @$filter["v_VALOR_DEPREC_ACUMULADO"];
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->SearchValue2 = @$filter["y_VALOR_DEPREC_ACUMULADO"];
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->SearchOperator2 = @$filter["w_VALOR_DEPREC_ACUMULADO"];
		$this->VALOR_DEPREC_ACUMULADO->AdvancedSearch->save();

		// Field VALOR_NETO
		$this->VALOR_NETO->AdvancedSearch->SearchValue = @$filter["x_VALOR_NETO"];
		$this->VALOR_NETO->AdvancedSearch->SearchOperator = @$filter["z_VALOR_NETO"];
		$this->VALOR_NETO->AdvancedSearch->SearchCondition = @$filter["v_VALOR_NETO"];
		$this->VALOR_NETO->AdvancedSearch->SearchValue2 = @$filter["y_VALOR_NETO"];
		$this->VALOR_NETO->AdvancedSearch->SearchOperator2 = @$filter["w_VALOR_NETO"];
		$this->VALOR_NETO->AdvancedSearch->save();

		// Field TIP_USO_CUENTA
		$this->TIP_USO_CUENTA->AdvancedSearch->SearchValue = @$filter["x_TIP_USO_CUENTA"];
		$this->TIP_USO_CUENTA->AdvancedSearch->SearchOperator = @$filter["z_TIP_USO_CUENTA"];
		$this->TIP_USO_CUENTA->AdvancedSearch->SearchCondition = @$filter["v_TIP_USO_CUENTA"];
		$this->TIP_USO_CUENTA->AdvancedSearch->SearchValue2 = @$filter["y_TIP_USO_CUENTA"];
		$this->TIP_USO_CUENTA->AdvancedSearch->SearchOperator2 = @$filter["w_TIP_USO_CUENTA"];
		$this->TIP_USO_CUENTA->AdvancedSearch->save();

		// Field TIPO_CUENTA
		$this->TIPO_CUENTA->AdvancedSearch->SearchValue = @$filter["x_TIPO_CUENTA"];
		$this->TIPO_CUENTA->AdvancedSearch->SearchOperator = @$filter["z_TIPO_CUENTA"];
		$this->TIPO_CUENTA->AdvancedSearch->SearchCondition = @$filter["v_TIPO_CUENTA"];
		$this->TIPO_CUENTA->AdvancedSearch->SearchValue2 = @$filter["y_TIPO_CUENTA"];
		$this->TIPO_CUENTA->AdvancedSearch->SearchOperator2 = @$filter["w_TIPO_CUENTA"];
		$this->TIPO_CUENTA->AdvancedSearch->save();

		// Field NRO_CUENTA_CONTABLE
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->SearchValue = @$filter["x_NRO_CUENTA_CONTABLE"];
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->SearchOperator = @$filter["z_NRO_CUENTA_CONTABLE"];
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->SearchCondition = @$filter["v_NRO_CUENTA_CONTABLE"];
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->SearchValue2 = @$filter["y_NRO_CUENTA_CONTABLE"];
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_CUENTA_CONTABLE"];
		$this->NRO_CUENTA_CONTABLE->AdvancedSearch->save();

		// Field CTA_CON_SEGURO
		$this->CTA_CON_SEGURO->AdvancedSearch->SearchValue = @$filter["x_CTA_CON_SEGURO"];
		$this->CTA_CON_SEGURO->AdvancedSearch->SearchOperator = @$filter["z_CTA_CON_SEGURO"];
		$this->CTA_CON_SEGURO->AdvancedSearch->SearchCondition = @$filter["v_CTA_CON_SEGURO"];
		$this->CTA_CON_SEGURO->AdvancedSearch->SearchValue2 = @$filter["y_CTA_CON_SEGURO"];
		$this->CTA_CON_SEGURO->AdvancedSearch->SearchOperator2 = @$filter["w_CTA_CON_SEGURO"];
		$this->CTA_CON_SEGURO->AdvancedSearch->save();

		// Field ESTADO_BIEN
		$this->ESTADO_BIEN->AdvancedSearch->SearchValue = @$filter["x_ESTADO_BIEN"];
		$this->ESTADO_BIEN->AdvancedSearch->SearchOperator = @$filter["z_ESTADO_BIEN"];
		$this->ESTADO_BIEN->AdvancedSearch->SearchCondition = @$filter["v_ESTADO_BIEN"];
		$this->ESTADO_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_ESTADO_BIEN"];
		$this->ESTADO_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_ESTADO_BIEN"];
		$this->ESTADO_BIEN->AdvancedSearch->save();

		// Field CONDICION
		$this->CONDICION->AdvancedSearch->SearchValue = @$filter["x_CONDICION"];
		$this->CONDICION->AdvancedSearch->SearchOperator = @$filter["z_CONDICION"];
		$this->CONDICION->AdvancedSearch->SearchCondition = @$filter["v_CONDICION"];
		$this->CONDICION->AdvancedSearch->SearchValue2 = @$filter["y_CONDICION"];
		$this->CONDICION->AdvancedSearch->SearchOperator2 = @$filter["w_CONDICION"];
		$this->CONDICION->AdvancedSearch->save();

		// Field MARCA
		$this->MARCA->AdvancedSearch->SearchValue = @$filter["x_MARCA"];
		$this->MARCA->AdvancedSearch->SearchOperator = @$filter["z_MARCA"];
		$this->MARCA->AdvancedSearch->SearchCondition = @$filter["v_MARCA"];
		$this->MARCA->AdvancedSearch->SearchValue2 = @$filter["y_MARCA"];
		$this->MARCA->AdvancedSearch->SearchOperator2 = @$filter["w_MARCA"];
		$this->MARCA->AdvancedSearch->save();

		// Field MODELO
		$this->MODELO->AdvancedSearch->SearchValue = @$filter["x_MODELO"];
		$this->MODELO->AdvancedSearch->SearchOperator = @$filter["z_MODELO"];
		$this->MODELO->AdvancedSearch->SearchCondition = @$filter["v_MODELO"];
		$this->MODELO->AdvancedSearch->SearchValue2 = @$filter["y_MODELO"];
		$this->MODELO->AdvancedSearch->SearchOperator2 = @$filter["w_MODELO"];
		$this->MODELO->AdvancedSearch->save();

		// Field TIPO
		$this->TIPO->AdvancedSearch->SearchValue = @$filter["x_TIPO"];
		$this->TIPO->AdvancedSearch->SearchOperator = @$filter["z_TIPO"];
		$this->TIPO->AdvancedSearch->SearchCondition = @$filter["v_TIPO"];
		$this->TIPO->AdvancedSearch->SearchValue2 = @$filter["y_TIPO"];
		$this->TIPO->AdvancedSearch->SearchOperator2 = @$filter["w_TIPO"];
		$this->TIPO->AdvancedSearch->save();

		// Field COLOR
		$this->COLOR->AdvancedSearch->SearchValue = @$filter["x_COLOR"];
		$this->COLOR->AdvancedSearch->SearchOperator = @$filter["z_COLOR"];
		$this->COLOR->AdvancedSearch->SearchCondition = @$filter["v_COLOR"];
		$this->COLOR->AdvancedSearch->SearchValue2 = @$filter["y_COLOR"];
		$this->COLOR->AdvancedSearch->SearchOperator2 = @$filter["w_COLOR"];
		$this->COLOR->AdvancedSearch->save();

		// Field SERIE
		$this->SERIE->AdvancedSearch->SearchValue = @$filter["x_SERIE"];
		$this->SERIE->AdvancedSearch->SearchOperator = @$filter["z_SERIE"];
		$this->SERIE->AdvancedSearch->SearchCondition = @$filter["v_SERIE"];
		$this->SERIE->AdvancedSearch->SearchValue2 = @$filter["y_SERIE"];
		$this->SERIE->AdvancedSearch->SearchOperator2 = @$filter["w_SERIE"];
		$this->SERIE->AdvancedSearch->save();

		// Field DIMENSION
		$this->DIMENSION->AdvancedSearch->SearchValue = @$filter["x_DIMENSION"];
		$this->DIMENSION->AdvancedSearch->SearchOperator = @$filter["z_DIMENSION"];
		$this->DIMENSION->AdvancedSearch->SearchCondition = @$filter["v_DIMENSION"];
		$this->DIMENSION->AdvancedSearch->SearchValue2 = @$filter["y_DIMENSION"];
		$this->DIMENSION->AdvancedSearch->SearchOperator2 = @$filter["w_DIMENSION"];
		$this->DIMENSION->AdvancedSearch->save();

		// Field PLACA
		$this->PLACA->AdvancedSearch->SearchValue = @$filter["x_PLACA"];
		$this->PLACA->AdvancedSearch->SearchOperator = @$filter["z_PLACA"];
		$this->PLACA->AdvancedSearch->SearchCondition = @$filter["v_PLACA"];
		$this->PLACA->AdvancedSearch->SearchValue2 = @$filter["y_PLACA"];
		$this->PLACA->AdvancedSearch->SearchOperator2 = @$filter["w_PLACA"];
		$this->PLACA->AdvancedSearch->save();

		// Field NRO_MOTOR
		$this->NRO_MOTOR->AdvancedSearch->SearchValue = @$filter["x_NRO_MOTOR"];
		$this->NRO_MOTOR->AdvancedSearch->SearchOperator = @$filter["z_NRO_MOTOR"];
		$this->NRO_MOTOR->AdvancedSearch->SearchCondition = @$filter["v_NRO_MOTOR"];
		$this->NRO_MOTOR->AdvancedSearch->SearchValue2 = @$filter["y_NRO_MOTOR"];
		$this->NRO_MOTOR->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_MOTOR"];
		$this->NRO_MOTOR->AdvancedSearch->save();

		// Field NRO_CHASIS
		$this->NRO_CHASIS->AdvancedSearch->SearchValue = @$filter["x_NRO_CHASIS"];
		$this->NRO_CHASIS->AdvancedSearch->SearchOperator = @$filter["z_NRO_CHASIS"];
		$this->NRO_CHASIS->AdvancedSearch->SearchCondition = @$filter["v_NRO_CHASIS"];
		$this->NRO_CHASIS->AdvancedSearch->SearchValue2 = @$filter["y_NRO_CHASIS"];
		$this->NRO_CHASIS->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_CHASIS"];
		$this->NRO_CHASIS->AdvancedSearch->save();

		// Field MATRICULA
		$this->MATRICULA->AdvancedSearch->SearchValue = @$filter["x_MATRICULA"];
		$this->MATRICULA->AdvancedSearch->SearchOperator = @$filter["z_MATRICULA"];
		$this->MATRICULA->AdvancedSearch->SearchCondition = @$filter["v_MATRICULA"];
		$this->MATRICULA->AdvancedSearch->SearchValue2 = @$filter["y_MATRICULA"];
		$this->MATRICULA->AdvancedSearch->SearchOperator2 = @$filter["w_MATRICULA"];
		$this->MATRICULA->AdvancedSearch->save();

		// Field ANIO_FABRICACION
		$this->ANIO_FABRICACION->AdvancedSearch->SearchValue = @$filter["x_ANIO_FABRICACION"];
		$this->ANIO_FABRICACION->AdvancedSearch->SearchOperator = @$filter["z_ANIO_FABRICACION"];
		$this->ANIO_FABRICACION->AdvancedSearch->SearchCondition = @$filter["v_ANIO_FABRICACION"];
		$this->ANIO_FABRICACION->AdvancedSearch->SearchValue2 = @$filter["y_ANIO_FABRICACION"];
		$this->ANIO_FABRICACION->AdvancedSearch->SearchOperator2 = @$filter["w_ANIO_FABRICACION"];
		$this->ANIO_FABRICACION->AdvancedSearch->save();

		// Field LONGITUD
		$this->LONGITUD->AdvancedSearch->SearchValue = @$filter["x_LONGITUD"];
		$this->LONGITUD->AdvancedSearch->SearchOperator = @$filter["z_LONGITUD"];
		$this->LONGITUD->AdvancedSearch->SearchCondition = @$filter["v_LONGITUD"];
		$this->LONGITUD->AdvancedSearch->SearchValue2 = @$filter["y_LONGITUD"];
		$this->LONGITUD->AdvancedSearch->SearchOperator2 = @$filter["w_LONGITUD"];
		$this->LONGITUD->AdvancedSearch->save();

		// Field ALTURA
		$this->ALTURA->AdvancedSearch->SearchValue = @$filter["x_ALTURA"];
		$this->ALTURA->AdvancedSearch->SearchOperator = @$filter["z_ALTURA"];
		$this->ALTURA->AdvancedSearch->SearchCondition = @$filter["v_ALTURA"];
		$this->ALTURA->AdvancedSearch->SearchValue2 = @$filter["y_ALTURA"];
		$this->ALTURA->AdvancedSearch->SearchOperator2 = @$filter["w_ALTURA"];
		$this->ALTURA->AdvancedSearch->save();

		// Field ANCHO
		$this->ANCHO->AdvancedSearch->SearchValue = @$filter["x_ANCHO"];
		$this->ANCHO->AdvancedSearch->SearchOperator = @$filter["z_ANCHO"];
		$this->ANCHO->AdvancedSearch->SearchCondition = @$filter["v_ANCHO"];
		$this->ANCHO->AdvancedSearch->SearchValue2 = @$filter["y_ANCHO"];
		$this->ANCHO->AdvancedSearch->SearchOperator2 = @$filter["w_ANCHO"];
		$this->ANCHO->AdvancedSearch->save();

		// Field RAZA
		$this->RAZA->AdvancedSearch->SearchValue = @$filter["x_RAZA"];
		$this->RAZA->AdvancedSearch->SearchOperator = @$filter["z_RAZA"];
		$this->RAZA->AdvancedSearch->SearchCondition = @$filter["v_RAZA"];
		$this->RAZA->AdvancedSearch->SearchValue2 = @$filter["y_RAZA"];
		$this->RAZA->AdvancedSearch->SearchOperator2 = @$filter["w_RAZA"];
		$this->RAZA->AdvancedSearch->save();

		// Field ESPECIE
		$this->ESPECIE->AdvancedSearch->SearchValue = @$filter["x_ESPECIE"];
		$this->ESPECIE->AdvancedSearch->SearchOperator = @$filter["z_ESPECIE"];
		$this->ESPECIE->AdvancedSearch->SearchCondition = @$filter["v_ESPECIE"];
		$this->ESPECIE->AdvancedSearch->SearchValue2 = @$filter["y_ESPECIE"];
		$this->ESPECIE->AdvancedSearch->SearchOperator2 = @$filter["w_ESPECIE"];
		$this->ESPECIE->AdvancedSearch->save();

		// Field EDAD
		$this->EDAD->AdvancedSearch->SearchValue = @$filter["x_EDAD"];
		$this->EDAD->AdvancedSearch->SearchOperator = @$filter["z_EDAD"];
		$this->EDAD->AdvancedSearch->SearchCondition = @$filter["v_EDAD"];
		$this->EDAD->AdvancedSearch->SearchValue2 = @$filter["y_EDAD"];
		$this->EDAD->AdvancedSearch->SearchOperator2 = @$filter["w_EDAD"];
		$this->EDAD->AdvancedSearch->save();

		// Field PAIS
		$this->PAIS->AdvancedSearch->SearchValue = @$filter["x_PAIS"];
		$this->PAIS->AdvancedSearch->SearchOperator = @$filter["z_PAIS"];
		$this->PAIS->AdvancedSearch->SearchCondition = @$filter["v_PAIS"];
		$this->PAIS->AdvancedSearch->SearchValue2 = @$filter["y_PAIS"];
		$this->PAIS->AdvancedSearch->SearchOperator2 = @$filter["w_PAIS"];
		$this->PAIS->AdvancedSearch->save();

		// Field OTRAS_CARACT
		$this->OTRAS_CARACT->AdvancedSearch->SearchValue = @$filter["x_OTRAS_CARACT"];
		$this->OTRAS_CARACT->AdvancedSearch->SearchOperator = @$filter["z_OTRAS_CARACT"];
		$this->OTRAS_CARACT->AdvancedSearch->SearchCondition = @$filter["v_OTRAS_CARACT"];
		$this->OTRAS_CARACT->AdvancedSearch->SearchValue2 = @$filter["y_OTRAS_CARACT"];
		$this->OTRAS_CARACT->AdvancedSearch->SearchOperator2 = @$filter["w_OTRAS_CARACT"];
		$this->OTRAS_CARACT->AdvancedSearch->save();

		// Field DESCRIPCION_UBICACION_BIEN
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->SearchValue = @$filter["x_DESCRIPCION_UBICACION_BIEN"];
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->SearchOperator = @$filter["z_DESCRIPCION_UBICACION_BIEN"];
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->SearchCondition = @$filter["v_DESCRIPCION_UBICACION_BIEN"];
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_DESCRIPCION_UBICACION_BIEN"];
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_DESCRIPCION_UBICACION_BIEN"];
		$this->DESCRIPCION_UBICACION_BIEN->AdvancedSearch->save();

		// Field CAUSAL_BAJA
		$this->CAUSAL_BAJA->AdvancedSearch->SearchValue = @$filter["x_CAUSAL_BAJA"];
		$this->CAUSAL_BAJA->AdvancedSearch->SearchOperator = @$filter["z_CAUSAL_BAJA"];
		$this->CAUSAL_BAJA->AdvancedSearch->SearchCondition = @$filter["v_CAUSAL_BAJA"];
		$this->CAUSAL_BAJA->AdvancedSearch->SearchValue2 = @$filter["y_CAUSAL_BAJA"];
		$this->CAUSAL_BAJA->AdvancedSearch->SearchOperator2 = @$filter["w_CAUSAL_BAJA"];
		$this->CAUSAL_BAJA->AdvancedSearch->save();

		// Field NRO_RESOLUCION_BAJA
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->SearchValue = @$filter["x_NRO_RESOLUCION_BAJA"];
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->SearchOperator = @$filter["z_NRO_RESOLUCION_BAJA"];
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->SearchCondition = @$filter["v_NRO_RESOLUCION_BAJA"];
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->SearchValue2 = @$filter["y_NRO_RESOLUCION_BAJA"];
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_RESOLUCION_BAJA"];
		$this->NRO_RESOLUCION_BAJA->AdvancedSearch->save();

		// Field FECHA_BAJA
		$this->FECHA_BAJA->AdvancedSearch->SearchValue = @$filter["x_FECHA_BAJA"];
		$this->FECHA_BAJA->AdvancedSearch->SearchOperator = @$filter["z_FECHA_BAJA"];
		$this->FECHA_BAJA->AdvancedSearch->SearchCondition = @$filter["v_FECHA_BAJA"];
		$this->FECHA_BAJA->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_BAJA"];
		$this->FECHA_BAJA->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_BAJA"];
		$this->FECHA_BAJA->AdvancedSearch->save();

		// Field ACTO_DISPOSICION_BIEN
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->SearchValue = @$filter["x_ACTO_DISPOSICION_BIEN"];
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->SearchOperator = @$filter["z_ACTO_DISPOSICION_BIEN"];
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->SearchCondition = @$filter["v_ACTO_DISPOSICION_BIEN"];
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_ACTO_DISPOSICION_BIEN"];
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_ACTO_DISPOSICION_BIEN"];
		$this->ACTO_DISPOSICION_BIEN->AdvancedSearch->save();

		// Field NRO_RESOLUCION_DISP
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->SearchValue = @$filter["x_NRO_RESOLUCION_DISP"];
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->SearchOperator = @$filter["z_NRO_RESOLUCION_DISP"];
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->SearchCondition = @$filter["v_NRO_RESOLUCION_DISP"];
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->SearchValue2 = @$filter["y_NRO_RESOLUCION_DISP"];
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->SearchOperator2 = @$filter["w_NRO_RESOLUCION_DISP"];
		$this->NRO_RESOLUCION_DISP->AdvancedSearch->save();

		// Field FECHA_DISPOSICION
		$this->FECHA_DISPOSICION->AdvancedSearch->SearchValue = @$filter["x_FECHA_DISPOSICION"];
		$this->FECHA_DISPOSICION->AdvancedSearch->SearchOperator = @$filter["z_FECHA_DISPOSICION"];
		$this->FECHA_DISPOSICION->AdvancedSearch->SearchCondition = @$filter["v_FECHA_DISPOSICION"];
		$this->FECHA_DISPOSICION->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_DISPOSICION"];
		$this->FECHA_DISPOSICION->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_DISPOSICION"];
		$this->FECHA_DISPOSICION->AdvancedSearch->save();

		// Field ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->SearchValue = @$filter["x_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"];
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->SearchOperator = @$filter["z_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"];
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->SearchCondition = @$filter["v_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"];
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->SearchValue2 = @$filter["y_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"];
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->SearchOperator2 = @$filter["w_ENTIDAD_BENEFICIADA_ACTO_DISPOSICION"];
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->AdvancedSearch->save();

		// Field MOTIVO_ELIMINACION_BIEN
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->SearchValue = @$filter["x_MOTIVO_ELIMINACION_BIEN"];
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->SearchOperator = @$filter["z_MOTIVO_ELIMINACION_BIEN"];
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->SearchCondition = @$filter["v_MOTIVO_ELIMINACION_BIEN"];
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_MOTIVO_ELIMINACION_BIEN"];
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_MOTIVO_ELIMINACION_BIEN"];
		$this->MOTIVO_ELIMINACION_BIEN->AdvancedSearch->save();

		// Field ACTO_ADMINISTRACION_BIEN
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->SearchValue = @$filter["x_ACTO_ADMINISTRACION_BIEN"];
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->SearchOperator = @$filter["z_ACTO_ADMINISTRACION_BIEN"];
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->SearchCondition = @$filter["v_ACTO_ADMINISTRACION_BIEN"];
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->SearchValue2 = @$filter["y_ACTO_ADMINISTRACION_BIEN"];
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->SearchOperator2 = @$filter["w_ACTO_ADMINISTRACION_BIEN"];
		$this->ACTO_ADMINISTRACION_BIEN->AdvancedSearch->save();

		// Field NUM_RESOLUCION_ADMINISTRACION
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->SearchValue = @$filter["x_NUM_RESOLUCION_ADMINISTRACION"];
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->SearchOperator = @$filter["z_NUM_RESOLUCION_ADMINISTRACION"];
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->SearchCondition = @$filter["v_NUM_RESOLUCION_ADMINISTRACION"];
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->SearchValue2 = @$filter["y_NUM_RESOLUCION_ADMINISTRACION"];
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->SearchOperator2 = @$filter["w_NUM_RESOLUCION_ADMINISTRACION"];
		$this->NUM_RESOLUCION_ADMINISTRACION->AdvancedSearch->save();

		// Field FECHA_ADMINISTRACION
		$this->FECHA_ADMINISTRACION->AdvancedSearch->SearchValue = @$filter["x_FECHA_ADMINISTRACION"];
		$this->FECHA_ADMINISTRACION->AdvancedSearch->SearchOperator = @$filter["z_FECHA_ADMINISTRACION"];
		$this->FECHA_ADMINISTRACION->AdvancedSearch->SearchCondition = @$filter["v_FECHA_ADMINISTRACION"];
		$this->FECHA_ADMINISTRACION->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_ADMINISTRACION"];
		$this->FECHA_ADMINISTRACION->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_ADMINISTRACION"];
		$this->FECHA_ADMINISTRACION->AdvancedSearch->save();

		// Field FECHA_VENC_ACTO_ADMIN
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->SearchValue = @$filter["x_FECHA_VENC_ACTO_ADMIN"];
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->SearchOperator = @$filter["z_FECHA_VENC_ACTO_ADMIN"];
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->SearchCondition = @$filter["v_FECHA_VENC_ACTO_ADMIN"];
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_VENC_ACTO_ADMIN"];
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_VENC_ACTO_ADMIN"];
		$this->FECHA_VENC_ACTO_ADMIN->AdvancedSearch->save();

		// Field ENTIDAD_BENEFICIADA_ACTO_ADMIN
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->SearchValue = @$filter["x_ENTIDAD_BENEFICIADA_ACTO_ADMIN"];
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->SearchOperator = @$filter["z_ENTIDAD_BENEFICIADA_ACTO_ADMIN"];
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->SearchCondition = @$filter["v_ENTIDAD_BENEFICIADA_ACTO_ADMIN"];
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->SearchValue2 = @$filter["y_ENTIDAD_BENEFICIADA_ACTO_ADMIN"];
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->SearchOperator2 = @$filter["w_ENTIDAD_BENEFICIADA_ACTO_ADMIN"];
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->AdvancedSearch->save();

		// Field DOC_ALTA_SBN
		$this->DOC_ALTA_SBN->AdvancedSearch->SearchValue = @$filter["x_DOC_ALTA_SBN"];
		$this->DOC_ALTA_SBN->AdvancedSearch->SearchOperator = @$filter["z_DOC_ALTA_SBN"];
		$this->DOC_ALTA_SBN->AdvancedSearch->SearchCondition = @$filter["v_DOC_ALTA_SBN"];
		$this->DOC_ALTA_SBN->AdvancedSearch->SearchValue2 = @$filter["y_DOC_ALTA_SBN"];
		$this->DOC_ALTA_SBN->AdvancedSearch->SearchOperator2 = @$filter["w_DOC_ALTA_SBN"];
		$this->DOC_ALTA_SBN->AdvancedSearch->save();

		// Field DOC_BAJA_SBN
		$this->DOC_BAJA_SBN->AdvancedSearch->SearchValue = @$filter["x_DOC_BAJA_SBN"];
		$this->DOC_BAJA_SBN->AdvancedSearch->SearchOperator = @$filter["z_DOC_BAJA_SBN"];
		$this->DOC_BAJA_SBN->AdvancedSearch->SearchCondition = @$filter["v_DOC_BAJA_SBN"];
		$this->DOC_BAJA_SBN->AdvancedSearch->SearchValue2 = @$filter["y_DOC_BAJA_SBN"];
		$this->DOC_BAJA_SBN->AdvancedSearch->SearchOperator2 = @$filter["w_DOC_BAJA_SBN"];
		$this->DOC_BAJA_SBN->AdvancedSearch->save();

		// Field DEPENDENCIAS
		$this->DEPENDENCIAS->AdvancedSearch->SearchValue = @$filter["x_DEPENDENCIAS"];
		$this->DEPENDENCIAS->AdvancedSearch->SearchOperator = @$filter["z_DEPENDENCIAS"];
		$this->DEPENDENCIAS->AdvancedSearch->SearchCondition = @$filter["v_DEPENDENCIAS"];
		$this->DEPENDENCIAS->AdvancedSearch->SearchValue2 = @$filter["y_DEPENDENCIAS"];
		$this->DEPENDENCIAS->AdvancedSearch->SearchOperator2 = @$filter["w_DEPENDENCIAS"];
		$this->DEPENDENCIAS->AdvancedSearch->save();

		// Field NUMERO_FICHA
		$this->NUMERO_FICHA->AdvancedSearch->SearchValue = @$filter["x_NUMERO_FICHA"];
		$this->NUMERO_FICHA->AdvancedSearch->SearchOperator = @$filter["z_NUMERO_FICHA"];
		$this->NUMERO_FICHA->AdvancedSearch->SearchCondition = @$filter["v_NUMERO_FICHA"];
		$this->NUMERO_FICHA->AdvancedSearch->SearchValue2 = @$filter["y_NUMERO_FICHA"];
		$this->NUMERO_FICHA->AdvancedSearch->SearchOperator2 = @$filter["w_NUMERO_FICHA"];
		$this->NUMERO_FICHA->AdvancedSearch->save();

		// Field CODIGO_INTERNO
		$this->CODIGO_INTERNO->AdvancedSearch->SearchValue = @$filter["x_CODIGO_INTERNO"];
		$this->CODIGO_INTERNO->AdvancedSearch->SearchOperator = @$filter["z_CODIGO_INTERNO"];
		$this->CODIGO_INTERNO->AdvancedSearch->SearchCondition = @$filter["v_CODIGO_INTERNO"];
		$this->CODIGO_INTERNO->AdvancedSearch->SearchValue2 = @$filter["y_CODIGO_INTERNO"];
		$this->CODIGO_INTERNO->AdvancedSearch->SearchOperator2 = @$filter["w_CODIGO_INTERNO"];
		$this->CODIGO_INTERNO->AdvancedSearch->save();

		// Field ESTADO
		$this->ESTADO->AdvancedSearch->SearchValue = @$filter["x_ESTADO"];
		$this->ESTADO->AdvancedSearch->SearchOperator = @$filter["z_ESTADO"];
		$this->ESTADO->AdvancedSearch->SearchCondition = @$filter["v_ESTADO"];
		$this->ESTADO->AdvancedSearch->SearchValue2 = @$filter["y_ESTADO"];
		$this->ESTADO->AdvancedSearch->SearchOperator2 = @$filter["w_ESTADO"];
		$this->ESTADO->AdvancedSearch->save();

		// Field USO
		$this->USO->AdvancedSearch->SearchValue = @$filter["x_USO"];
		$this->USO->AdvancedSearch->SearchOperator = @$filter["z_USO"];
		$this->USO->AdvancedSearch->SearchCondition = @$filter["v_USO"];
		$this->USO->AdvancedSearch->SearchValue2 = @$filter["y_USO"];
		$this->USO->AdvancedSearch->SearchOperator2 = @$filter["w_USO"];
		$this->USO->AdvancedSearch->save();

		// Field STICKER
		$this->STICKER->AdvancedSearch->SearchValue = @$filter["x_STICKER"];
		$this->STICKER->AdvancedSearch->SearchOperator = @$filter["z_STICKER"];
		$this->STICKER->AdvancedSearch->SearchCondition = @$filter["v_STICKER"];
		$this->STICKER->AdvancedSearch->SearchValue2 = @$filter["y_STICKER"];
		$this->STICKER->AdvancedSearch->SearchOperator2 = @$filter["w_STICKER"];
		$this->STICKER->AdvancedSearch->save();

		// Field SEDE
		$this->SEDE->AdvancedSearch->SearchValue = @$filter["x_SEDE"];
		$this->SEDE->AdvancedSearch->SearchOperator = @$filter["z_SEDE"];
		$this->SEDE->AdvancedSearch->SearchCondition = @$filter["v_SEDE"];
		$this->SEDE->AdvancedSearch->SearchValue2 = @$filter["y_SEDE"];
		$this->SEDE->AdvancedSearch->SearchOperator2 = @$filter["w_SEDE"];
		$this->SEDE->AdvancedSearch->save();

		// Field SBN
		$this->SBN->AdvancedSearch->SearchValue = @$filter["x_SBN"];
		$this->SBN->AdvancedSearch->SearchOperator = @$filter["z_SBN"];
		$this->SBN->AdvancedSearch->SearchCondition = @$filter["v_SBN"];
		$this->SBN->AdvancedSearch->SearchValue2 = @$filter["y_SBN"];
		$this->SBN->AdvancedSearch->SearchOperator2 = @$filter["w_SBN"];
		$this->SBN->AdvancedSearch->save();

		// Field ETIQUETA
		$this->ETIQUETA->AdvancedSearch->SearchValue = @$filter["x_ETIQUETA"];
		$this->ETIQUETA->AdvancedSearch->SearchOperator = @$filter["z_ETIQUETA"];
		$this->ETIQUETA->AdvancedSearch->SearchCondition = @$filter["v_ETIQUETA"];
		$this->ETIQUETA->AdvancedSearch->SearchValue2 = @$filter["y_ETIQUETA"];
		$this->ETIQUETA->AdvancedSearch->SearchOperator2 = @$filter["w_ETIQUETA"];
		$this->ETIQUETA->AdvancedSearch->save();

		// Field NOMBRE_BENEFICIARIO_ACTO_ADMIN
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->SearchValue = @$filter["x_NOMBRE_BENEFICIARIO_ACTO_ADMIN"];
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->SearchOperator = @$filter["z_NOMBRE_BENEFICIARIO_ACTO_ADMIN"];
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->SearchCondition = @$filter["v_NOMBRE_BENEFICIARIO_ACTO_ADMIN"];
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->SearchValue2 = @$filter["y_NOMBRE_BENEFICIARIO_ACTO_ADMIN"];
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->SearchOperator2 = @$filter["w_NOMBRE_BENEFICIARIO_ACTO_ADMIN"];
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->AdvancedSearch->save();

		// Field PLACA_RODAJE
		$this->PLACA_RODAJE->AdvancedSearch->SearchValue = @$filter["x_PLACA_RODAJE"];
		$this->PLACA_RODAJE->AdvancedSearch->SearchOperator = @$filter["z_PLACA_RODAJE"];
		$this->PLACA_RODAJE->AdvancedSearch->SearchCondition = @$filter["v_PLACA_RODAJE"];
		$this->PLACA_RODAJE->AdvancedSearch->SearchValue2 = @$filter["y_PLACA_RODAJE"];
		$this->PLACA_RODAJE->AdvancedSearch->SearchOperator2 = @$filter["w_PLACA_RODAJE"];
		$this->PLACA_RODAJE->AdvancedSearch->save();

		// Field CODIGO_ACTUAL
		$this->CODIGO_ACTUAL->AdvancedSearch->SearchValue = @$filter["x_CODIGO_ACTUAL"];
		$this->CODIGO_ACTUAL->AdvancedSearch->SearchOperator = @$filter["z_CODIGO_ACTUAL"];
		$this->CODIGO_ACTUAL->AdvancedSearch->SearchCondition = @$filter["v_CODIGO_ACTUAL"];
		$this->CODIGO_ACTUAL->AdvancedSearch->SearchValue2 = @$filter["y_CODIGO_ACTUAL"];
		$this->CODIGO_ACTUAL->AdvancedSearch->SearchOperator2 = @$filter["w_CODIGO_ACTUAL"];
		$this->CODIGO_ACTUAL->AdvancedSearch->save();

		// Field CODIGO_ANTERIOR
		$this->CODIGO_ANTERIOR->AdvancedSearch->SearchValue = @$filter["x_CODIGO_ANTERIOR"];
		$this->CODIGO_ANTERIOR->AdvancedSearch->SearchOperator = @$filter["z_CODIGO_ANTERIOR"];
		$this->CODIGO_ANTERIOR->AdvancedSearch->SearchCondition = @$filter["v_CODIGO_ANTERIOR"];
		$this->CODIGO_ANTERIOR->AdvancedSearch->SearchValue2 = @$filter["y_CODIGO_ANTERIOR"];
		$this->CODIGO_ANTERIOR->AdvancedSearch->SearchOperator2 = @$filter["w_CODIGO_ANTERIOR"];
		$this->CODIGO_ANTERIOR->AdvancedSearch->save();

		// Field PROPIEDAD
		$this->PROPIEDAD->AdvancedSearch->SearchValue = @$filter["x_PROPIEDAD"];
		$this->PROPIEDAD->AdvancedSearch->SearchOperator = @$filter["z_PROPIEDAD"];
		$this->PROPIEDAD->AdvancedSearch->SearchCondition = @$filter["v_PROPIEDAD"];
		$this->PROPIEDAD->AdvancedSearch->SearchValue2 = @$filter["y_PROPIEDAD"];
		$this->PROPIEDAD->AdvancedSearch->SearchOperator2 = @$filter["w_PROPIEDAD"];
		$this->PROPIEDAD->AdvancedSearch->save();

		// Field SITUACION
		$this->SITUACION->AdvancedSearch->SearchValue = @$filter["x_SITUACION"];
		$this->SITUACION->AdvancedSearch->SearchOperator = @$filter["z_SITUACION"];
		$this->SITUACION->AdvancedSearch->SearchCondition = @$filter["v_SITUACION"];
		$this->SITUACION->AdvancedSearch->SearchValue2 = @$filter["y_SITUACION"];
		$this->SITUACION->AdvancedSearch->SearchOperator2 = @$filter["w_SITUACION"];
		$this->SITUACION->AdvancedSearch->save();

		// Field OBSERVACIONES
		$this->OBSERVACIONES->AdvancedSearch->SearchValue = @$filter["x_OBSERVACIONES"];
		$this->OBSERVACIONES->AdvancedSearch->SearchOperator = @$filter["z_OBSERVACIONES"];
		$this->OBSERVACIONES->AdvancedSearch->SearchCondition = @$filter["v_OBSERVACIONES"];
		$this->OBSERVACIONES->AdvancedSearch->SearchValue2 = @$filter["y_OBSERVACIONES"];
		$this->OBSERVACIONES->AdvancedSearch->SearchOperator2 = @$filter["w_OBSERVACIONES"];
		$this->OBSERVACIONES->AdvancedSearch->save();

		// Field FECHA_REGISTRO
		$this->FECHA_REGISTRO->AdvancedSearch->SearchValue = @$filter["x_FECHA_REGISTRO"];
		$this->FECHA_REGISTRO->AdvancedSearch->SearchOperator = @$filter["z_FECHA_REGISTRO"];
		$this->FECHA_REGISTRO->AdvancedSearch->SearchCondition = @$filter["v_FECHA_REGISTRO"];
		$this->FECHA_REGISTRO->AdvancedSearch->SearchValue2 = @$filter["y_FECHA_REGISTRO"];
		$this->FECHA_REGISTRO->AdvancedSearch->SearchOperator2 = @$filter["w_FECHA_REGISTRO"];
		$this->FECHA_REGISTRO->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->SEC_EJEC, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIPO_MODALIDAD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SECUENCIA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->AMBIENTE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->RUC_ENTIDAD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->LOCAL, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DEPARTAMENTO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PROVINCIA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DISTRITO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->AREA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->OFICINA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PISO_OFICINA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_DOC_IDENT_PERSONAL, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->APELLIDO_PATERNO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->APELLIDO_MATERNO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NOMBRES, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->OPERATIVO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIPO_DOC_IDENTIDAD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MODALIDAD_CONTRATO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CODIGO_PATRIMONIAL, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DENOMINACION_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIPO_CAUSAL_ALTA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_DOC_ADQUISICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_ADQUISICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->VALOR_ADQUISICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_DEPRECIACION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->VALOR_DEPREC_EJERCICIO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->VALOR_DEPREC_ACUMULADO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->VALOR_NETO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIP_USO_CUENTA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIPO_CUENTA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_CUENTA_CONTABLE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CTA_CON_SEGURO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ESTADO_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CONDICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MARCA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MODELO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TIPO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->COLOR, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SERIE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DIMENSION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PLACA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_MOTOR, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_CHASIS, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MATRICULA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ANIO_FABRICACION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->LONGITUD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ALTURA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ANCHO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->RAZA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ESPECIE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->EDAD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PAIS, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->OTRAS_CARACT, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DESCRIPCION_UBICACION_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CAUSAL_BAJA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_RESOLUCION_BAJA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_BAJA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ACTO_DISPOSICION_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NRO_RESOLUCION_DISP, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_DISPOSICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MOTIVO_ELIMINACION_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ACTO_ADMINISTRACION_BIEN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NUM_RESOLUCION_ADMINISTRACION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_ADMINISTRACION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FECHA_VENC_ACTO_ADMIN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DOC_ALTA_SBN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DOC_BAJA_SBN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->DEPENDENCIAS, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NUMERO_FICHA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CODIGO_INTERNO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ESTADO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->USO, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->STICKER, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SEDE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SBN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ETIQUETA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PLACA_RODAJE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CODIGO_ACTUAL, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CODIGO_ANTERIOR, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PROPIEDAD, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SITUACION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->OBSERVACIONES, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->codigo); // codigo
			$this->updateSort($this->codigo_proceso); // codigo_proceso
			$this->updateSort($this->no); // no
			$this->updateSort($this->usuarios); // usuarios
			$this->updateSort($this->SEC_EJEC); // SEC_EJEC
			$this->updateSort($this->TIPO_MODALIDAD); // TIPO_MODALIDAD
			$this->updateSort($this->SECUENCIA); // SECUENCIA
			$this->updateSort($this->AMBIENTE); // AMBIENTE
			$this->updateSort($this->RUC_ENTIDAD); // RUC_ENTIDAD
			$this->updateSort($this->LOCAL); // LOCAL
			$this->updateSort($this->DEPARTAMENTO); // DEPARTAMENTO
			$this->updateSort($this->PROVINCIA); // PROVINCIA
			$this->updateSort($this->DISTRITO); // DISTRITO
			$this->updateSort($this->AREA); // AREA
			$this->updateSort($this->OFICINA); // OFICINA
			$this->updateSort($this->PISO_OFICINA); // PISO_OFICINA
			$this->updateSort($this->NRO_DOC_IDENT_PERSONAL); // NRO_DOC_IDENT_PERSONAL
			$this->updateSort($this->APELLIDO_PATERNO); // APELLIDO_PATERNO
			$this->updateSort($this->APELLIDO_MATERNO); // APELLIDO_MATERNO
			$this->updateSort($this->NOMBRES); // NOMBRES
			$this->updateSort($this->OPERATIVO); // OPERATIVO
			$this->updateSort($this->TIPO_DOC_IDENTIDAD); // TIPO_DOC_IDENTIDAD
			$this->updateSort($this->MODALIDAD_CONTRATO); // MODALIDAD_CONTRATO
			$this->updateSort($this->CODIGO_PATRIMONIAL); // CODIGO_PATRIMONIAL
			$this->updateSort($this->DENOMINACION_BIEN); // DENOMINACION_BIEN
			$this->updateSort($this->TIPO_CAUSAL_ALTA); // TIPO_CAUSAL_ALTA
			$this->updateSort($this->NRO_DOC_ADQUISICION); // NRO_DOC_ADQUISICION
			$this->updateSort($this->FECHA_ADQUISICION); // FECHA_ADQUISICION
			$this->updateSort($this->VALOR_ADQUISICION); // VALOR_ADQUISICION
			$this->updateSort($this->FECHA_DEPRECIACION); // FECHA_DEPRECIACION
			$this->updateSort($this->VALOR_DEPREC_EJERCICIO); // VALOR_DEPREC_EJERCICIO
			$this->updateSort($this->VALOR_DEPREC_ACUMULADO); // VALOR_DEPREC_ACUMULADO
			$this->updateSort($this->VALOR_NETO); // VALOR_NETO
			$this->updateSort($this->TIP_USO_CUENTA); // TIP_USO_CUENTA
			$this->updateSort($this->TIPO_CUENTA); // TIPO_CUENTA
			$this->updateSort($this->NRO_CUENTA_CONTABLE); // NRO_CUENTA_CONTABLE
			$this->updateSort($this->CTA_CON_SEGURO); // CTA_CON_SEGURO
			$this->updateSort($this->ESTADO_BIEN); // ESTADO_BIEN
			$this->updateSort($this->CONDICION); // CONDICION
			$this->updateSort($this->MARCA); // MARCA
			$this->updateSort($this->MODELO); // MODELO
			$this->updateSort($this->TIPO); // TIPO
			$this->updateSort($this->COLOR); // COLOR
			$this->updateSort($this->SERIE); // SERIE
			$this->updateSort($this->DIMENSION); // DIMENSION
			$this->updateSort($this->PLACA); // PLACA
			$this->updateSort($this->NRO_MOTOR); // NRO_MOTOR
			$this->updateSort($this->NRO_CHASIS); // NRO_CHASIS
			$this->updateSort($this->MATRICULA); // MATRICULA
			$this->updateSort($this->ANIO_FABRICACION); // ANIO_FABRICACION
			$this->updateSort($this->LONGITUD); // LONGITUD
			$this->updateSort($this->ALTURA); // ALTURA
			$this->updateSort($this->ANCHO); // ANCHO
			$this->updateSort($this->RAZA); // RAZA
			$this->updateSort($this->ESPECIE); // ESPECIE
			$this->updateSort($this->EDAD); // EDAD
			$this->updateSort($this->PAIS); // PAIS
			$this->updateSort($this->OTRAS_CARACT); // OTRAS_CARACT
			$this->updateSort($this->DESCRIPCION_UBICACION_BIEN); // DESCRIPCION_UBICACION_BIEN
			$this->updateSort($this->CAUSAL_BAJA); // CAUSAL_BAJA
			$this->updateSort($this->NRO_RESOLUCION_BAJA); // NRO_RESOLUCION_BAJA
			$this->updateSort($this->FECHA_BAJA); // FECHA_BAJA
			$this->updateSort($this->ACTO_DISPOSICION_BIEN); // ACTO_DISPOSICION_BIEN
			$this->updateSort($this->NRO_RESOLUCION_DISP); // NRO_RESOLUCION_DISP
			$this->updateSort($this->FECHA_DISPOSICION); // FECHA_DISPOSICION
			$this->updateSort($this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION); // ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->updateSort($this->MOTIVO_ELIMINACION_BIEN); // MOTIVO_ELIMINACION_BIEN
			$this->updateSort($this->ACTO_ADMINISTRACION_BIEN); // ACTO_ADMINISTRACION_BIEN
			$this->updateSort($this->NUM_RESOLUCION_ADMINISTRACION); // NUM_RESOLUCION_ADMINISTRACION
			$this->updateSort($this->FECHA_ADMINISTRACION); // FECHA_ADMINISTRACION
			$this->updateSort($this->FECHA_VENC_ACTO_ADMIN); // FECHA_VENC_ACTO_ADMIN
			$this->updateSort($this->ENTIDAD_BENEFICIADA_ACTO_ADMIN); // ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->updateSort($this->DOC_ALTA_SBN); // DOC_ALTA_SBN
			$this->updateSort($this->DOC_BAJA_SBN); // DOC_BAJA_SBN
			$this->updateSort($this->DEPENDENCIAS); // DEPENDENCIAS
			$this->updateSort($this->NUMERO_FICHA); // NUMERO_FICHA
			$this->updateSort($this->CODIGO_INTERNO); // CODIGO_INTERNO
			$this->updateSort($this->ESTADO); // ESTADO
			$this->updateSort($this->USO); // USO
			$this->updateSort($this->STICKER); // STICKER
			$this->updateSort($this->SEDE); // SEDE
			$this->updateSort($this->SBN); // SBN
			$this->updateSort($this->ETIQUETA); // ETIQUETA
			$this->updateSort($this->NOMBRE_BENEFICIARIO_ACTO_ADMIN); // NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->updateSort($this->PLACA_RODAJE); // PLACA_RODAJE
			$this->updateSort($this->CODIGO_ACTUAL); // CODIGO_ACTUAL
			$this->updateSort($this->CODIGO_ANTERIOR); // CODIGO_ANTERIOR
			$this->updateSort($this->PROPIEDAD); // PROPIEDAD
			$this->updateSort($this->SITUACION); // SITUACION
			$this->updateSort($this->OBSERVACIONES); // OBSERVACIONES
			$this->updateSort($this->FECHA_REGISTRO); // FECHA_REGISTRO
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->codigo->setSort("");
				$this->codigo_proceso->setSort("");
				$this->no->setSort("");
				$this->usuarios->setSort("");
				$this->SEC_EJEC->setSort("");
				$this->TIPO_MODALIDAD->setSort("");
				$this->SECUENCIA->setSort("");
				$this->AMBIENTE->setSort("");
				$this->RUC_ENTIDAD->setSort("");
				$this->LOCAL->setSort("");
				$this->DEPARTAMENTO->setSort("");
				$this->PROVINCIA->setSort("");
				$this->DISTRITO->setSort("");
				$this->AREA->setSort("");
				$this->OFICINA->setSort("");
				$this->PISO_OFICINA->setSort("");
				$this->NRO_DOC_IDENT_PERSONAL->setSort("");
				$this->APELLIDO_PATERNO->setSort("");
				$this->APELLIDO_MATERNO->setSort("");
				$this->NOMBRES->setSort("");
				$this->OPERATIVO->setSort("");
				$this->TIPO_DOC_IDENTIDAD->setSort("");
				$this->MODALIDAD_CONTRATO->setSort("");
				$this->CODIGO_PATRIMONIAL->setSort("");
				$this->DENOMINACION_BIEN->setSort("");
				$this->TIPO_CAUSAL_ALTA->setSort("");
				$this->NRO_DOC_ADQUISICION->setSort("");
				$this->FECHA_ADQUISICION->setSort("");
				$this->VALOR_ADQUISICION->setSort("");
				$this->FECHA_DEPRECIACION->setSort("");
				$this->VALOR_DEPREC_EJERCICIO->setSort("");
				$this->VALOR_DEPREC_ACUMULADO->setSort("");
				$this->VALOR_NETO->setSort("");
				$this->TIP_USO_CUENTA->setSort("");
				$this->TIPO_CUENTA->setSort("");
				$this->NRO_CUENTA_CONTABLE->setSort("");
				$this->CTA_CON_SEGURO->setSort("");
				$this->ESTADO_BIEN->setSort("");
				$this->CONDICION->setSort("");
				$this->MARCA->setSort("");
				$this->MODELO->setSort("");
				$this->TIPO->setSort("");
				$this->COLOR->setSort("");
				$this->SERIE->setSort("");
				$this->DIMENSION->setSort("");
				$this->PLACA->setSort("");
				$this->NRO_MOTOR->setSort("");
				$this->NRO_CHASIS->setSort("");
				$this->MATRICULA->setSort("");
				$this->ANIO_FABRICACION->setSort("");
				$this->LONGITUD->setSort("");
				$this->ALTURA->setSort("");
				$this->ANCHO->setSort("");
				$this->RAZA->setSort("");
				$this->ESPECIE->setSort("");
				$this->EDAD->setSort("");
				$this->PAIS->setSort("");
				$this->OTRAS_CARACT->setSort("");
				$this->DESCRIPCION_UBICACION_BIEN->setSort("");
				$this->CAUSAL_BAJA->setSort("");
				$this->NRO_RESOLUCION_BAJA->setSort("");
				$this->FECHA_BAJA->setSort("");
				$this->ACTO_DISPOSICION_BIEN->setSort("");
				$this->NRO_RESOLUCION_DISP->setSort("");
				$this->FECHA_DISPOSICION->setSort("");
				$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setSort("");
				$this->MOTIVO_ELIMINACION_BIEN->setSort("");
				$this->ACTO_ADMINISTRACION_BIEN->setSort("");
				$this->NUM_RESOLUCION_ADMINISTRACION->setSort("");
				$this->FECHA_ADMINISTRACION->setSort("");
				$this->FECHA_VENC_ACTO_ADMIN->setSort("");
				$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setSort("");
				$this->DOC_ALTA_SBN->setSort("");
				$this->DOC_BAJA_SBN->setSort("");
				$this->DEPENDENCIAS->setSort("");
				$this->NUMERO_FICHA->setSort("");
				$this->CODIGO_INTERNO->setSort("");
				$this->ESTADO->setSort("");
				$this->USO->setSort("");
				$this->STICKER->setSort("");
				$this->SEDE->setSort("");
				$this->SBN->setSort("");
				$this->ETIQUETA->setSort("");
				$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setSort("");
				$this->PLACA_RODAJE->setSort("");
				$this->CODIGO_ACTUAL->setSort("");
				$this->CODIGO_ANTERIOR->setSort("");
				$this->PROPIEDAD->setSort("");
				$this->SITUACION->setSort("");
				$this->OBSERVACIONES->setSort("");
				$this->FECHA_REGISTRO->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->isLoggedIn();
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = $this->ListOptions["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->isLoggedIn()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = $this->ListOptions["delete"];
		if ($Security->isLoggedIn())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->codigo->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = $this->AddUrl != "" && $Security->isLoggedIn();
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fprocesos_nuevolistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fprocesos_nuevolistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.fprocesos_nuevolist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->codigo->setDbValue($row['codigo']);
		$this->codigo_proceso->setDbValue($row['codigo_proceso']);
		$this->no->setDbValue($row['no']);
		$this->usuarios->setDbValue($row['usuarios']);
		$this->SEC_EJEC->setDbValue($row['SEC_EJEC']);
		$this->TIPO_MODALIDAD->setDbValue($row['TIPO_MODALIDAD']);
		$this->SECUENCIA->setDbValue($row['SECUENCIA']);
		$this->AMBIENTE->setDbValue($row['AMBIENTE']);
		$this->RUC_ENTIDAD->setDbValue($row['RUC_ENTIDAD']);
		$this->LOCAL->setDbValue($row['LOCAL']);
		$this->DEPARTAMENTO->setDbValue($row['DEPARTAMENTO']);
		$this->PROVINCIA->setDbValue($row['PROVINCIA']);
		$this->DISTRITO->setDbValue($row['DISTRITO']);
		$this->AREA->setDbValue($row['AREA']);
		$this->OFICINA->setDbValue($row['OFICINA']);
		$this->PISO_OFICINA->setDbValue($row['PISO_OFICINA']);
		$this->NRO_DOC_IDENT_PERSONAL->setDbValue($row['NRO_DOC_IDENT_PERSONAL']);
		$this->APELLIDO_PATERNO->setDbValue($row['APELLIDO_PATERNO']);
		$this->APELLIDO_MATERNO->setDbValue($row['APELLIDO_MATERNO']);
		$this->NOMBRES->setDbValue($row['NOMBRES']);
		$this->OPERATIVO->setDbValue($row['OPERATIVO']);
		$this->TIPO_DOC_IDENTIDAD->setDbValue($row['TIPO_DOC_IDENTIDAD']);
		$this->MODALIDAD_CONTRATO->setDbValue($row['MODALIDAD_CONTRATO']);
		$this->CODIGO_PATRIMONIAL->setDbValue($row['CODIGO_PATRIMONIAL']);
		$this->DENOMINACION_BIEN->setDbValue($row['DENOMINACION_BIEN']);
		$this->TIPO_CAUSAL_ALTA->setDbValue($row['TIPO_CAUSAL_ALTA']);
		$this->NRO_DOC_ADQUISICION->setDbValue($row['NRO_DOC_ADQUISICION']);
		$this->FECHA_ADQUISICION->setDbValue($row['FECHA_ADQUISICION']);
		$this->VALOR_ADQUISICION->setDbValue($row['VALOR_ADQUISICION']);
		$this->FECHA_DEPRECIACION->setDbValue($row['FECHA_DEPRECIACION']);
		$this->VALOR_DEPREC_EJERCICIO->setDbValue($row['VALOR_DEPREC_EJERCICIO']);
		$this->VALOR_DEPREC_ACUMULADO->setDbValue($row['VALOR_DEPREC_ACUMULADO']);
		$this->VALOR_NETO->setDbValue($row['VALOR_NETO']);
		$this->TIP_USO_CUENTA->setDbValue($row['TIP_USO_CUENTA']);
		$this->TIPO_CUENTA->setDbValue($row['TIPO_CUENTA']);
		$this->NRO_CUENTA_CONTABLE->setDbValue($row['NRO_CUENTA_CONTABLE']);
		$this->CTA_CON_SEGURO->setDbValue($row['CTA_CON_SEGURO']);
		$this->ESTADO_BIEN->setDbValue($row['ESTADO_BIEN']);
		$this->CONDICION->setDbValue($row['CONDICION']);
		$this->MARCA->setDbValue($row['MARCA']);
		$this->MODELO->setDbValue($row['MODELO']);
		$this->TIPO->setDbValue($row['TIPO']);
		$this->COLOR->setDbValue($row['COLOR']);
		$this->SERIE->setDbValue($row['SERIE']);
		$this->DIMENSION->setDbValue($row['DIMENSION']);
		$this->PLACA->setDbValue($row['PLACA']);
		$this->NRO_MOTOR->setDbValue($row['NRO_MOTOR']);
		$this->NRO_CHASIS->setDbValue($row['NRO_CHASIS']);
		$this->MATRICULA->setDbValue($row['MATRICULA']);
		$this->ANIO_FABRICACION->setDbValue($row['ANIO_FABRICACION']);
		$this->LONGITUD->setDbValue($row['LONGITUD']);
		$this->ALTURA->setDbValue($row['ALTURA']);
		$this->ANCHO->setDbValue($row['ANCHO']);
		$this->RAZA->setDbValue($row['RAZA']);
		$this->ESPECIE->setDbValue($row['ESPECIE']);
		$this->EDAD->setDbValue($row['EDAD']);
		$this->PAIS->setDbValue($row['PAIS']);
		$this->OTRAS_CARACT->setDbValue($row['OTRAS_CARACT']);
		$this->DESCRIPCION_UBICACION_BIEN->setDbValue($row['DESCRIPCION_UBICACION_BIEN']);
		$this->CAUSAL_BAJA->setDbValue($row['CAUSAL_BAJA']);
		$this->NRO_RESOLUCION_BAJA->setDbValue($row['NRO_RESOLUCION_BAJA']);
		$this->FECHA_BAJA->setDbValue($row['FECHA_BAJA']);
		$this->ACTO_DISPOSICION_BIEN->setDbValue($row['ACTO_DISPOSICION_BIEN']);
		$this->NRO_RESOLUCION_DISP->setDbValue($row['NRO_RESOLUCION_DISP']);
		$this->FECHA_DISPOSICION->setDbValue($row['FECHA_DISPOSICION']);
		$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION']);
		$this->MOTIVO_ELIMINACION_BIEN->setDbValue($row['MOTIVO_ELIMINACION_BIEN']);
		$this->ACTO_ADMINISTRACION_BIEN->setDbValue($row['ACTO_ADMINISTRACION_BIEN']);
		$this->NUM_RESOLUCION_ADMINISTRACION->setDbValue($row['NUM_RESOLUCION_ADMINISTRACION']);
		$this->FECHA_ADMINISTRACION->setDbValue($row['FECHA_ADMINISTRACION']);
		$this->FECHA_VENC_ACTO_ADMIN->setDbValue($row['FECHA_VENC_ACTO_ADMIN']);
		$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->setDbValue($row['ENTIDAD_BENEFICIADA_ACTO_ADMIN']);
		$this->DOC_ALTA_SBN->setDbValue($row['DOC_ALTA_SBN']);
		$this->DOC_BAJA_SBN->setDbValue($row['DOC_BAJA_SBN']);
		$this->DEPENDENCIAS->setDbValue($row['DEPENDENCIAS']);
		$this->NUMERO_FICHA->setDbValue($row['NUMERO_FICHA']);
		$this->CODIGO_INTERNO->setDbValue($row['CODIGO_INTERNO']);
		$this->ESTADO->setDbValue($row['ESTADO']);
		$this->USO->setDbValue($row['USO']);
		$this->STICKER->setDbValue($row['STICKER']);
		$this->SEDE->setDbValue($row['SEDE']);
		$this->SBN->setDbValue($row['SBN']);
		$this->ETIQUETA->setDbValue($row['ETIQUETA']);
		$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->setDbValue($row['NOMBRE_BENEFICIARIO_ACTO_ADMIN']);
		$this->PLACA_RODAJE->setDbValue($row['PLACA_RODAJE']);
		$this->CODIGO_ACTUAL->setDbValue($row['CODIGO_ACTUAL']);
		$this->CODIGO_ANTERIOR->setDbValue($row['CODIGO_ANTERIOR']);
		$this->PROPIEDAD->setDbValue($row['PROPIEDAD']);
		$this->SITUACION->setDbValue($row['SITUACION']);
		$this->OBSERVACIONES->setDbValue($row['OBSERVACIONES']);
		$this->FECHA_REGISTRO->setDbValue($row['FECHA_REGISTRO']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['codigo'] = NULL;
		$row['codigo_proceso'] = NULL;
		$row['no'] = NULL;
		$row['usuarios'] = NULL;
		$row['SEC_EJEC'] = NULL;
		$row['TIPO_MODALIDAD'] = NULL;
		$row['SECUENCIA'] = NULL;
		$row['AMBIENTE'] = NULL;
		$row['RUC_ENTIDAD'] = NULL;
		$row['LOCAL'] = NULL;
		$row['DEPARTAMENTO'] = NULL;
		$row['PROVINCIA'] = NULL;
		$row['DISTRITO'] = NULL;
		$row['AREA'] = NULL;
		$row['OFICINA'] = NULL;
		$row['PISO_OFICINA'] = NULL;
		$row['NRO_DOC_IDENT_PERSONAL'] = NULL;
		$row['APELLIDO_PATERNO'] = NULL;
		$row['APELLIDO_MATERNO'] = NULL;
		$row['NOMBRES'] = NULL;
		$row['OPERATIVO'] = NULL;
		$row['TIPO_DOC_IDENTIDAD'] = NULL;
		$row['MODALIDAD_CONTRATO'] = NULL;
		$row['CODIGO_PATRIMONIAL'] = NULL;
		$row['DENOMINACION_BIEN'] = NULL;
		$row['TIPO_CAUSAL_ALTA'] = NULL;
		$row['NRO_DOC_ADQUISICION'] = NULL;
		$row['FECHA_ADQUISICION'] = NULL;
		$row['VALOR_ADQUISICION'] = NULL;
		$row['FECHA_DEPRECIACION'] = NULL;
		$row['VALOR_DEPREC_EJERCICIO'] = NULL;
		$row['VALOR_DEPREC_ACUMULADO'] = NULL;
		$row['VALOR_NETO'] = NULL;
		$row['TIP_USO_CUENTA'] = NULL;
		$row['TIPO_CUENTA'] = NULL;
		$row['NRO_CUENTA_CONTABLE'] = NULL;
		$row['CTA_CON_SEGURO'] = NULL;
		$row['ESTADO_BIEN'] = NULL;
		$row['CONDICION'] = NULL;
		$row['MARCA'] = NULL;
		$row['MODELO'] = NULL;
		$row['TIPO'] = NULL;
		$row['COLOR'] = NULL;
		$row['SERIE'] = NULL;
		$row['DIMENSION'] = NULL;
		$row['PLACA'] = NULL;
		$row['NRO_MOTOR'] = NULL;
		$row['NRO_CHASIS'] = NULL;
		$row['MATRICULA'] = NULL;
		$row['ANIO_FABRICACION'] = NULL;
		$row['LONGITUD'] = NULL;
		$row['ALTURA'] = NULL;
		$row['ANCHO'] = NULL;
		$row['RAZA'] = NULL;
		$row['ESPECIE'] = NULL;
		$row['EDAD'] = NULL;
		$row['PAIS'] = NULL;
		$row['OTRAS_CARACT'] = NULL;
		$row['DESCRIPCION_UBICACION_BIEN'] = NULL;
		$row['CAUSAL_BAJA'] = NULL;
		$row['NRO_RESOLUCION_BAJA'] = NULL;
		$row['FECHA_BAJA'] = NULL;
		$row['ACTO_DISPOSICION_BIEN'] = NULL;
		$row['NRO_RESOLUCION_DISP'] = NULL;
		$row['FECHA_DISPOSICION'] = NULL;
		$row['ENTIDAD_BENEFICIADA_ACTO_DISPOSICION'] = NULL;
		$row['MOTIVO_ELIMINACION_BIEN'] = NULL;
		$row['ACTO_ADMINISTRACION_BIEN'] = NULL;
		$row['NUM_RESOLUCION_ADMINISTRACION'] = NULL;
		$row['FECHA_ADMINISTRACION'] = NULL;
		$row['FECHA_VENC_ACTO_ADMIN'] = NULL;
		$row['ENTIDAD_BENEFICIADA_ACTO_ADMIN'] = NULL;
		$row['DOC_ALTA_SBN'] = NULL;
		$row['DOC_BAJA_SBN'] = NULL;
		$row['DEPENDENCIAS'] = NULL;
		$row['NUMERO_FICHA'] = NULL;
		$row['CODIGO_INTERNO'] = NULL;
		$row['ESTADO'] = NULL;
		$row['USO'] = NULL;
		$row['STICKER'] = NULL;
		$row['SEDE'] = NULL;
		$row['SBN'] = NULL;
		$row['ETIQUETA'] = NULL;
		$row['NOMBRE_BENEFICIARIO_ACTO_ADMIN'] = NULL;
		$row['PLACA_RODAJE'] = NULL;
		$row['CODIGO_ACTUAL'] = NULL;
		$row['CODIGO_ANTERIOR'] = NULL;
		$row['PROPIEDAD'] = NULL;
		$row['SITUACION'] = NULL;
		$row['OBSERVACIONES'] = NULL;
		$row['FECHA_REGISTRO'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("codigo")) != "")
			$this->codigo->OldValue = $this->getKey("codigo"); // codigo
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// codigo
		// codigo_proceso
		// no
		// usuarios
		// SEC_EJEC
		// TIPO_MODALIDAD
		// SECUENCIA
		// AMBIENTE
		// RUC_ENTIDAD
		// LOCAL
		// DEPARTAMENTO
		// PROVINCIA
		// DISTRITO
		// AREA
		// OFICINA
		// PISO_OFICINA
		// NRO_DOC_IDENT_PERSONAL
		// APELLIDO_PATERNO
		// APELLIDO_MATERNO
		// NOMBRES
		// OPERATIVO
		// TIPO_DOC_IDENTIDAD
		// MODALIDAD_CONTRATO
		// CODIGO_PATRIMONIAL
		// DENOMINACION_BIEN
		// TIPO_CAUSAL_ALTA
		// NRO_DOC_ADQUISICION
		// FECHA_ADQUISICION
		// VALOR_ADQUISICION
		// FECHA_DEPRECIACION
		// VALOR_DEPREC_EJERCICIO
		// VALOR_DEPREC_ACUMULADO
		// VALOR_NETO
		// TIP_USO_CUENTA
		// TIPO_CUENTA
		// NRO_CUENTA_CONTABLE
		// CTA_CON_SEGURO
		// ESTADO_BIEN
		// CONDICION
		// MARCA
		// MODELO
		// TIPO
		// COLOR
		// SERIE
		// DIMENSION
		// PLACA
		// NRO_MOTOR
		// NRO_CHASIS
		// MATRICULA
		// ANIO_FABRICACION
		// LONGITUD
		// ALTURA
		// ANCHO
		// RAZA
		// ESPECIE
		// EDAD
		// PAIS
		// OTRAS_CARACT
		// DESCRIPCION_UBICACION_BIEN
		// CAUSAL_BAJA
		// NRO_RESOLUCION_BAJA
		// FECHA_BAJA
		// ACTO_DISPOSICION_BIEN
		// NRO_RESOLUCION_DISP
		// FECHA_DISPOSICION
		// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
		// MOTIVO_ELIMINACION_BIEN
		// ACTO_ADMINISTRACION_BIEN
		// NUM_RESOLUCION_ADMINISTRACION
		// FECHA_ADMINISTRACION
		// FECHA_VENC_ACTO_ADMIN
		// ENTIDAD_BENEFICIADA_ACTO_ADMIN
		// DOC_ALTA_SBN
		// DOC_BAJA_SBN
		// DEPENDENCIAS
		// NUMERO_FICHA
		// CODIGO_INTERNO
		// ESTADO
		// USO
		// STICKER
		// SEDE
		// SBN
		// ETIQUETA
		// NOMBRE_BENEFICIARIO_ACTO_ADMIN
		// PLACA_RODAJE
		// CODIGO_ACTUAL
		// CODIGO_ANTERIOR
		// PROPIEDAD
		// SITUACION
		// OBSERVACIONES
		// FECHA_REGISTRO

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// codigo
			$this->codigo->ViewValue = $this->codigo->CurrentValue;
			$this->codigo->ViewCustomAttributes = "";

			// codigo_proceso
			$this->codigo_proceso->ViewValue = $this->codigo_proceso->CurrentValue;
			$this->codigo_proceso->ViewValue = FormatNumber($this->codigo_proceso->ViewValue, 0, -2, -2, -2);
			$this->codigo_proceso->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewValue = FormatNumber($this->no->ViewValue, 0, -2, -2, -2);
			$this->no->ViewCustomAttributes = "";

			// usuarios
			$this->usuarios->ViewValue = $this->usuarios->CurrentValue;
			$this->usuarios->ViewValue = FormatNumber($this->usuarios->ViewValue, 0, -2, -2, -2);
			$this->usuarios->ViewCustomAttributes = "";

			// SEC_EJEC
			$this->SEC_EJEC->ViewValue = $this->SEC_EJEC->CurrentValue;
			$this->SEC_EJEC->ViewCustomAttributes = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->ViewValue = $this->TIPO_MODALIDAD->CurrentValue;
			$this->TIPO_MODALIDAD->ViewCustomAttributes = "";

			// SECUENCIA
			$this->SECUENCIA->ViewValue = $this->SECUENCIA->CurrentValue;
			$this->SECUENCIA->ViewCustomAttributes = "";

			// AMBIENTE
			$this->AMBIENTE->ViewValue = $this->AMBIENTE->CurrentValue;
			$this->AMBIENTE->ViewCustomAttributes = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->ViewValue = $this->RUC_ENTIDAD->CurrentValue;
			$this->RUC_ENTIDAD->ViewCustomAttributes = "";

			// LOCAL
			$this->LOCAL->ViewValue = $this->LOCAL->CurrentValue;
			$this->LOCAL->ViewCustomAttributes = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->ViewValue = $this->DEPARTAMENTO->CurrentValue;
			$this->DEPARTAMENTO->ViewCustomAttributes = "";

			// PROVINCIA
			$this->PROVINCIA->ViewValue = $this->PROVINCIA->CurrentValue;
			$this->PROVINCIA->ViewCustomAttributes = "";

			// DISTRITO
			$this->DISTRITO->ViewValue = $this->DISTRITO->CurrentValue;
			$this->DISTRITO->ViewCustomAttributes = "";

			// AREA
			$this->AREA->ViewValue = $this->AREA->CurrentValue;
			$this->AREA->ViewCustomAttributes = "";

			// OFICINA
			$this->OFICINA->ViewValue = $this->OFICINA->CurrentValue;
			$this->OFICINA->ViewCustomAttributes = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->ViewValue = $this->PISO_OFICINA->CurrentValue;
			$this->PISO_OFICINA->ViewCustomAttributes = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->ViewValue = $this->NRO_DOC_IDENT_PERSONAL->CurrentValue;
			$this->NRO_DOC_IDENT_PERSONAL->ViewCustomAttributes = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->ViewValue = $this->APELLIDO_PATERNO->CurrentValue;
			$this->APELLIDO_PATERNO->ViewCustomAttributes = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->ViewValue = $this->APELLIDO_MATERNO->CurrentValue;
			$this->APELLIDO_MATERNO->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// OPERATIVO
			$this->OPERATIVO->ViewValue = $this->OPERATIVO->CurrentValue;
			$this->OPERATIVO->ViewCustomAttributes = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->ViewValue = $this->TIPO_DOC_IDENTIDAD->CurrentValue;
			$this->TIPO_DOC_IDENTIDAD->ViewCustomAttributes = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->ViewValue = $this->MODALIDAD_CONTRATO->CurrentValue;
			$this->MODALIDAD_CONTRATO->ViewCustomAttributes = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->ViewValue = $this->CODIGO_PATRIMONIAL->CurrentValue;
			$this->CODIGO_PATRIMONIAL->ViewCustomAttributes = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->ViewValue = $this->DENOMINACION_BIEN->CurrentValue;
			$this->DENOMINACION_BIEN->ViewCustomAttributes = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->ViewValue = $this->TIPO_CAUSAL_ALTA->CurrentValue;
			$this->TIPO_CAUSAL_ALTA->ViewCustomAttributes = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->ViewValue = $this->NRO_DOC_ADQUISICION->CurrentValue;
			$this->NRO_DOC_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->ViewValue = $this->FECHA_ADQUISICION->CurrentValue;
			$this->FECHA_ADQUISICION->ViewCustomAttributes = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->ViewValue = $this->VALOR_ADQUISICION->CurrentValue;
			$this->VALOR_ADQUISICION->ViewCustomAttributes = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->ViewValue = $this->FECHA_DEPRECIACION->CurrentValue;
			$this->FECHA_DEPRECIACION->ViewCustomAttributes = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->ViewValue = $this->VALOR_DEPREC_EJERCICIO->CurrentValue;
			$this->VALOR_DEPREC_EJERCICIO->ViewCustomAttributes = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->ViewValue = $this->VALOR_DEPREC_ACUMULADO->CurrentValue;
			$this->VALOR_DEPREC_ACUMULADO->ViewCustomAttributes = "";

			// VALOR_NETO
			$this->VALOR_NETO->ViewValue = $this->VALOR_NETO->CurrentValue;
			$this->VALOR_NETO->ViewCustomAttributes = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->ViewValue = $this->TIP_USO_CUENTA->CurrentValue;
			$this->TIP_USO_CUENTA->ViewCustomAttributes = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->ViewValue = $this->TIPO_CUENTA->CurrentValue;
			$this->TIPO_CUENTA->ViewCustomAttributes = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->ViewValue = $this->NRO_CUENTA_CONTABLE->CurrentValue;
			$this->NRO_CUENTA_CONTABLE->ViewCustomAttributes = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->ViewValue = $this->CTA_CON_SEGURO->CurrentValue;
			$this->CTA_CON_SEGURO->ViewCustomAttributes = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->ViewValue = $this->ESTADO_BIEN->CurrentValue;
			$this->ESTADO_BIEN->ViewCustomAttributes = "";

			// CONDICION
			$this->CONDICION->ViewValue = $this->CONDICION->CurrentValue;
			$this->CONDICION->ViewCustomAttributes = "";

			// MARCA
			$this->MARCA->ViewValue = $this->MARCA->CurrentValue;
			$this->MARCA->ViewCustomAttributes = "";

			// MODELO
			$this->MODELO->ViewValue = $this->MODELO->CurrentValue;
			$this->MODELO->ViewCustomAttributes = "";

			// TIPO
			$this->TIPO->ViewValue = $this->TIPO->CurrentValue;
			$this->TIPO->ViewCustomAttributes = "";

			// COLOR
			$this->COLOR->ViewValue = $this->COLOR->CurrentValue;
			$this->COLOR->ViewCustomAttributes = "";

			// SERIE
			$this->SERIE->ViewValue = $this->SERIE->CurrentValue;
			$this->SERIE->ViewCustomAttributes = "";

			// DIMENSION
			$this->DIMENSION->ViewValue = $this->DIMENSION->CurrentValue;
			$this->DIMENSION->ViewCustomAttributes = "";

			// PLACA
			$this->PLACA->ViewValue = $this->PLACA->CurrentValue;
			$this->PLACA->ViewCustomAttributes = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->ViewValue = $this->NRO_MOTOR->CurrentValue;
			$this->NRO_MOTOR->ViewCustomAttributes = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->ViewValue = $this->NRO_CHASIS->CurrentValue;
			$this->NRO_CHASIS->ViewCustomAttributes = "";

			// MATRICULA
			$this->MATRICULA->ViewValue = $this->MATRICULA->CurrentValue;
			$this->MATRICULA->ViewCustomAttributes = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->ViewValue = $this->ANIO_FABRICACION->CurrentValue;
			$this->ANIO_FABRICACION->ViewCustomAttributes = "";

			// LONGITUD
			$this->LONGITUD->ViewValue = $this->LONGITUD->CurrentValue;
			$this->LONGITUD->ViewCustomAttributes = "";

			// ALTURA
			$this->ALTURA->ViewValue = $this->ALTURA->CurrentValue;
			$this->ALTURA->ViewCustomAttributes = "";

			// ANCHO
			$this->ANCHO->ViewValue = $this->ANCHO->CurrentValue;
			$this->ANCHO->ViewCustomAttributes = "";

			// RAZA
			$this->RAZA->ViewValue = $this->RAZA->CurrentValue;
			$this->RAZA->ViewCustomAttributes = "";

			// ESPECIE
			$this->ESPECIE->ViewValue = $this->ESPECIE->CurrentValue;
			$this->ESPECIE->ViewCustomAttributes = "";

			// EDAD
			$this->EDAD->ViewValue = $this->EDAD->CurrentValue;
			$this->EDAD->ViewCustomAttributes = "";

			// PAIS
			$this->PAIS->ViewValue = $this->PAIS->CurrentValue;
			$this->PAIS->ViewCustomAttributes = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->ViewValue = $this->OTRAS_CARACT->CurrentValue;
			$this->OTRAS_CARACT->ViewCustomAttributes = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->ViewValue = $this->DESCRIPCION_UBICACION_BIEN->CurrentValue;
			$this->DESCRIPCION_UBICACION_BIEN->ViewCustomAttributes = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->ViewValue = $this->CAUSAL_BAJA->CurrentValue;
			$this->CAUSAL_BAJA->ViewCustomAttributes = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->ViewValue = $this->NRO_RESOLUCION_BAJA->CurrentValue;
			$this->NRO_RESOLUCION_BAJA->ViewCustomAttributes = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->ViewValue = $this->FECHA_BAJA->CurrentValue;
			$this->FECHA_BAJA->ViewCustomAttributes = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->ViewValue = $this->ACTO_DISPOSICION_BIEN->CurrentValue;
			$this->ACTO_DISPOSICION_BIEN->ViewCustomAttributes = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->ViewValue = $this->NRO_RESOLUCION_DISP->CurrentValue;
			$this->NRO_RESOLUCION_DISP->ViewCustomAttributes = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->ViewValue = $this->FECHA_DISPOSICION->CurrentValue;
			$this->FECHA_DISPOSICION->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->ViewCustomAttributes = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->ViewValue = $this->MOTIVO_ELIMINACION_BIEN->CurrentValue;
			$this->MOTIVO_ELIMINACION_BIEN->ViewCustomAttributes = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->ViewValue = $this->ACTO_ADMINISTRACION_BIEN->CurrentValue;
			$this->ACTO_ADMINISTRACION_BIEN->ViewCustomAttributes = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewValue = $this->NUM_RESOLUCION_ADMINISTRACION->CurrentValue;
			$this->NUM_RESOLUCION_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->ViewValue = $this->FECHA_ADMINISTRACION->CurrentValue;
			$this->FECHA_ADMINISTRACION->ViewCustomAttributes = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->ViewValue = $this->FECHA_VENC_ACTO_ADMIN->CurrentValue;
			$this->FECHA_VENC_ACTO_ADMIN->ViewCustomAttributes = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewValue = $this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->CurrentValue;
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->ViewCustomAttributes = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->ViewValue = $this->DOC_ALTA_SBN->CurrentValue;
			$this->DOC_ALTA_SBN->ViewCustomAttributes = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->ViewValue = $this->DOC_BAJA_SBN->CurrentValue;
			$this->DOC_BAJA_SBN->ViewCustomAttributes = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->ViewValue = $this->DEPENDENCIAS->CurrentValue;
			$this->DEPENDENCIAS->ViewCustomAttributes = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->ViewValue = $this->NUMERO_FICHA->CurrentValue;
			$this->NUMERO_FICHA->ViewCustomAttributes = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->ViewValue = $this->CODIGO_INTERNO->CurrentValue;
			$this->CODIGO_INTERNO->ViewCustomAttributes = "";

			// ESTADO
			$this->ESTADO->ViewValue = $this->ESTADO->CurrentValue;
			$this->ESTADO->ViewCustomAttributes = "";

			// USO
			$this->USO->ViewValue = $this->USO->CurrentValue;
			$this->USO->ViewCustomAttributes = "";

			// STICKER
			$this->STICKER->ViewValue = $this->STICKER->CurrentValue;
			$this->STICKER->ViewCustomAttributes = "";

			// SEDE
			$this->SEDE->ViewValue = $this->SEDE->CurrentValue;
			$this->SEDE->ViewCustomAttributes = "";

			// SBN
			$this->SBN->ViewValue = $this->SBN->CurrentValue;
			$this->SBN->ViewCustomAttributes = "";

			// ETIQUETA
			$this->ETIQUETA->ViewValue = $this->ETIQUETA->CurrentValue;
			$this->ETIQUETA->ViewCustomAttributes = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewValue = $this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->CurrentValue;
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->ViewCustomAttributes = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->ViewValue = $this->PLACA_RODAJE->CurrentValue;
			$this->PLACA_RODAJE->ViewCustomAttributes = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->ViewValue = $this->CODIGO_ACTUAL->CurrentValue;
			$this->CODIGO_ACTUAL->ViewCustomAttributes = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->ViewValue = $this->CODIGO_ANTERIOR->CurrentValue;
			$this->CODIGO_ANTERIOR->ViewCustomAttributes = "";

			// PROPIEDAD
			$this->PROPIEDAD->ViewValue = $this->PROPIEDAD->CurrentValue;
			$this->PROPIEDAD->ViewCustomAttributes = "";

			// SITUACION
			$this->SITUACION->ViewValue = $this->SITUACION->CurrentValue;
			$this->SITUACION->ViewCustomAttributes = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->ViewValue = $this->OBSERVACIONES->CurrentValue;
			$this->OBSERVACIONES->ViewCustomAttributes = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->ViewValue = $this->FECHA_REGISTRO->CurrentValue;
			$this->FECHA_REGISTRO->ViewValue = FormatDateTime($this->FECHA_REGISTRO->ViewValue, 0);
			$this->FECHA_REGISTRO->ViewCustomAttributes = "";

			// codigo
			$this->codigo->LinkCustomAttributes = "";
			$this->codigo->HrefValue = "";
			$this->codigo->TooltipValue = "";

			// codigo_proceso
			$this->codigo_proceso->LinkCustomAttributes = "";
			$this->codigo_proceso->HrefValue = "";
			$this->codigo_proceso->TooltipValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// usuarios
			$this->usuarios->LinkCustomAttributes = "";
			$this->usuarios->HrefValue = "";
			$this->usuarios->TooltipValue = "";

			// SEC_EJEC
			$this->SEC_EJEC->LinkCustomAttributes = "";
			$this->SEC_EJEC->HrefValue = "";
			$this->SEC_EJEC->TooltipValue = "";

			// TIPO_MODALIDAD
			$this->TIPO_MODALIDAD->LinkCustomAttributes = "";
			$this->TIPO_MODALIDAD->HrefValue = "";
			$this->TIPO_MODALIDAD->TooltipValue = "";

			// SECUENCIA
			$this->SECUENCIA->LinkCustomAttributes = "";
			$this->SECUENCIA->HrefValue = "";
			$this->SECUENCIA->TooltipValue = "";

			// AMBIENTE
			$this->AMBIENTE->LinkCustomAttributes = "";
			$this->AMBIENTE->HrefValue = "";
			$this->AMBIENTE->TooltipValue = "";

			// RUC_ENTIDAD
			$this->RUC_ENTIDAD->LinkCustomAttributes = "";
			$this->RUC_ENTIDAD->HrefValue = "";
			$this->RUC_ENTIDAD->TooltipValue = "";

			// LOCAL
			$this->LOCAL->LinkCustomAttributes = "";
			$this->LOCAL->HrefValue = "";
			$this->LOCAL->TooltipValue = "";

			// DEPARTAMENTO
			$this->DEPARTAMENTO->LinkCustomAttributes = "";
			$this->DEPARTAMENTO->HrefValue = "";
			$this->DEPARTAMENTO->TooltipValue = "";

			// PROVINCIA
			$this->PROVINCIA->LinkCustomAttributes = "";
			$this->PROVINCIA->HrefValue = "";
			$this->PROVINCIA->TooltipValue = "";

			// DISTRITO
			$this->DISTRITO->LinkCustomAttributes = "";
			$this->DISTRITO->HrefValue = "";
			$this->DISTRITO->TooltipValue = "";

			// AREA
			$this->AREA->LinkCustomAttributes = "";
			$this->AREA->HrefValue = "";
			$this->AREA->TooltipValue = "";

			// OFICINA
			$this->OFICINA->LinkCustomAttributes = "";
			$this->OFICINA->HrefValue = "";
			$this->OFICINA->TooltipValue = "";

			// PISO_OFICINA
			$this->PISO_OFICINA->LinkCustomAttributes = "";
			$this->PISO_OFICINA->HrefValue = "";
			$this->PISO_OFICINA->TooltipValue = "";

			// NRO_DOC_IDENT_PERSONAL
			$this->NRO_DOC_IDENT_PERSONAL->LinkCustomAttributes = "";
			$this->NRO_DOC_IDENT_PERSONAL->HrefValue = "";
			$this->NRO_DOC_IDENT_PERSONAL->TooltipValue = "";

			// APELLIDO_PATERNO
			$this->APELLIDO_PATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_PATERNO->HrefValue = "";
			$this->APELLIDO_PATERNO->TooltipValue = "";

			// APELLIDO_MATERNO
			$this->APELLIDO_MATERNO->LinkCustomAttributes = "";
			$this->APELLIDO_MATERNO->HrefValue = "";
			$this->APELLIDO_MATERNO->TooltipValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";
			$this->NOMBRES->TooltipValue = "";

			// OPERATIVO
			$this->OPERATIVO->LinkCustomAttributes = "";
			$this->OPERATIVO->HrefValue = "";
			$this->OPERATIVO->TooltipValue = "";

			// TIPO_DOC_IDENTIDAD
			$this->TIPO_DOC_IDENTIDAD->LinkCustomAttributes = "";
			$this->TIPO_DOC_IDENTIDAD->HrefValue = "";
			$this->TIPO_DOC_IDENTIDAD->TooltipValue = "";

			// MODALIDAD_CONTRATO
			$this->MODALIDAD_CONTRATO->LinkCustomAttributes = "";
			$this->MODALIDAD_CONTRATO->HrefValue = "";
			$this->MODALIDAD_CONTRATO->TooltipValue = "";

			// CODIGO_PATRIMONIAL
			$this->CODIGO_PATRIMONIAL->LinkCustomAttributes = "";
			$this->CODIGO_PATRIMONIAL->HrefValue = "";
			$this->CODIGO_PATRIMONIAL->TooltipValue = "";

			// DENOMINACION_BIEN
			$this->DENOMINACION_BIEN->LinkCustomAttributes = "";
			$this->DENOMINACION_BIEN->HrefValue = "";
			$this->DENOMINACION_BIEN->TooltipValue = "";

			// TIPO_CAUSAL_ALTA
			$this->TIPO_CAUSAL_ALTA->LinkCustomAttributes = "";
			$this->TIPO_CAUSAL_ALTA->HrefValue = "";
			$this->TIPO_CAUSAL_ALTA->TooltipValue = "";

			// NRO_DOC_ADQUISICION
			$this->NRO_DOC_ADQUISICION->LinkCustomAttributes = "";
			$this->NRO_DOC_ADQUISICION->HrefValue = "";
			$this->NRO_DOC_ADQUISICION->TooltipValue = "";

			// FECHA_ADQUISICION
			$this->FECHA_ADQUISICION->LinkCustomAttributes = "";
			$this->FECHA_ADQUISICION->HrefValue = "";
			$this->FECHA_ADQUISICION->TooltipValue = "";

			// VALOR_ADQUISICION
			$this->VALOR_ADQUISICION->LinkCustomAttributes = "";
			$this->VALOR_ADQUISICION->HrefValue = "";
			$this->VALOR_ADQUISICION->TooltipValue = "";

			// FECHA_DEPRECIACION
			$this->FECHA_DEPRECIACION->LinkCustomAttributes = "";
			$this->FECHA_DEPRECIACION->HrefValue = "";
			$this->FECHA_DEPRECIACION->TooltipValue = "";

			// VALOR_DEPREC_EJERCICIO
			$this->VALOR_DEPREC_EJERCICIO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_EJERCICIO->HrefValue = "";
			$this->VALOR_DEPREC_EJERCICIO->TooltipValue = "";

			// VALOR_DEPREC_ACUMULADO
			$this->VALOR_DEPREC_ACUMULADO->LinkCustomAttributes = "";
			$this->VALOR_DEPREC_ACUMULADO->HrefValue = "";
			$this->VALOR_DEPREC_ACUMULADO->TooltipValue = "";

			// VALOR_NETO
			$this->VALOR_NETO->LinkCustomAttributes = "";
			$this->VALOR_NETO->HrefValue = "";
			$this->VALOR_NETO->TooltipValue = "";

			// TIP_USO_CUENTA
			$this->TIP_USO_CUENTA->LinkCustomAttributes = "";
			$this->TIP_USO_CUENTA->HrefValue = "";
			$this->TIP_USO_CUENTA->TooltipValue = "";

			// TIPO_CUENTA
			$this->TIPO_CUENTA->LinkCustomAttributes = "";
			$this->TIPO_CUENTA->HrefValue = "";
			$this->TIPO_CUENTA->TooltipValue = "";

			// NRO_CUENTA_CONTABLE
			$this->NRO_CUENTA_CONTABLE->LinkCustomAttributes = "";
			$this->NRO_CUENTA_CONTABLE->HrefValue = "";
			$this->NRO_CUENTA_CONTABLE->TooltipValue = "";

			// CTA_CON_SEGURO
			$this->CTA_CON_SEGURO->LinkCustomAttributes = "";
			$this->CTA_CON_SEGURO->HrefValue = "";
			$this->CTA_CON_SEGURO->TooltipValue = "";

			// ESTADO_BIEN
			$this->ESTADO_BIEN->LinkCustomAttributes = "";
			$this->ESTADO_BIEN->HrefValue = "";
			$this->ESTADO_BIEN->TooltipValue = "";

			// CONDICION
			$this->CONDICION->LinkCustomAttributes = "";
			$this->CONDICION->HrefValue = "";
			$this->CONDICION->TooltipValue = "";

			// MARCA
			$this->MARCA->LinkCustomAttributes = "";
			$this->MARCA->HrefValue = "";
			$this->MARCA->TooltipValue = "";

			// MODELO
			$this->MODELO->LinkCustomAttributes = "";
			$this->MODELO->HrefValue = "";
			$this->MODELO->TooltipValue = "";

			// TIPO
			$this->TIPO->LinkCustomAttributes = "";
			$this->TIPO->HrefValue = "";
			$this->TIPO->TooltipValue = "";

			// COLOR
			$this->COLOR->LinkCustomAttributes = "";
			$this->COLOR->HrefValue = "";
			$this->COLOR->TooltipValue = "";

			// SERIE
			$this->SERIE->LinkCustomAttributes = "";
			$this->SERIE->HrefValue = "";
			$this->SERIE->TooltipValue = "";

			// DIMENSION
			$this->DIMENSION->LinkCustomAttributes = "";
			$this->DIMENSION->HrefValue = "";
			$this->DIMENSION->TooltipValue = "";

			// PLACA
			$this->PLACA->LinkCustomAttributes = "";
			$this->PLACA->HrefValue = "";
			$this->PLACA->TooltipValue = "";

			// NRO_MOTOR
			$this->NRO_MOTOR->LinkCustomAttributes = "";
			$this->NRO_MOTOR->HrefValue = "";
			$this->NRO_MOTOR->TooltipValue = "";

			// NRO_CHASIS
			$this->NRO_CHASIS->LinkCustomAttributes = "";
			$this->NRO_CHASIS->HrefValue = "";
			$this->NRO_CHASIS->TooltipValue = "";

			// MATRICULA
			$this->MATRICULA->LinkCustomAttributes = "";
			$this->MATRICULA->HrefValue = "";
			$this->MATRICULA->TooltipValue = "";

			// ANIO_FABRICACION
			$this->ANIO_FABRICACION->LinkCustomAttributes = "";
			$this->ANIO_FABRICACION->HrefValue = "";
			$this->ANIO_FABRICACION->TooltipValue = "";

			// LONGITUD
			$this->LONGITUD->LinkCustomAttributes = "";
			$this->LONGITUD->HrefValue = "";
			$this->LONGITUD->TooltipValue = "";

			// ALTURA
			$this->ALTURA->LinkCustomAttributes = "";
			$this->ALTURA->HrefValue = "";
			$this->ALTURA->TooltipValue = "";

			// ANCHO
			$this->ANCHO->LinkCustomAttributes = "";
			$this->ANCHO->HrefValue = "";
			$this->ANCHO->TooltipValue = "";

			// RAZA
			$this->RAZA->LinkCustomAttributes = "";
			$this->RAZA->HrefValue = "";
			$this->RAZA->TooltipValue = "";

			// ESPECIE
			$this->ESPECIE->LinkCustomAttributes = "";
			$this->ESPECIE->HrefValue = "";
			$this->ESPECIE->TooltipValue = "";

			// EDAD
			$this->EDAD->LinkCustomAttributes = "";
			$this->EDAD->HrefValue = "";
			$this->EDAD->TooltipValue = "";

			// PAIS
			$this->PAIS->LinkCustomAttributes = "";
			$this->PAIS->HrefValue = "";
			$this->PAIS->TooltipValue = "";

			// OTRAS_CARACT
			$this->OTRAS_CARACT->LinkCustomAttributes = "";
			$this->OTRAS_CARACT->HrefValue = "";
			$this->OTRAS_CARACT->TooltipValue = "";

			// DESCRIPCION_UBICACION_BIEN
			$this->DESCRIPCION_UBICACION_BIEN->LinkCustomAttributes = "";
			$this->DESCRIPCION_UBICACION_BIEN->HrefValue = "";
			$this->DESCRIPCION_UBICACION_BIEN->TooltipValue = "";

			// CAUSAL_BAJA
			$this->CAUSAL_BAJA->LinkCustomAttributes = "";
			$this->CAUSAL_BAJA->HrefValue = "";
			$this->CAUSAL_BAJA->TooltipValue = "";

			// NRO_RESOLUCION_BAJA
			$this->NRO_RESOLUCION_BAJA->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_BAJA->HrefValue = "";
			$this->NRO_RESOLUCION_BAJA->TooltipValue = "";

			// FECHA_BAJA
			$this->FECHA_BAJA->LinkCustomAttributes = "";
			$this->FECHA_BAJA->HrefValue = "";
			$this->FECHA_BAJA->TooltipValue = "";

			// ACTO_DISPOSICION_BIEN
			$this->ACTO_DISPOSICION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_DISPOSICION_BIEN->HrefValue = "";
			$this->ACTO_DISPOSICION_BIEN->TooltipValue = "";

			// NRO_RESOLUCION_DISP
			$this->NRO_RESOLUCION_DISP->LinkCustomAttributes = "";
			$this->NRO_RESOLUCION_DISP->HrefValue = "";
			$this->NRO_RESOLUCION_DISP->TooltipValue = "";

			// FECHA_DISPOSICION
			$this->FECHA_DISPOSICION->LinkCustomAttributes = "";
			$this->FECHA_DISPOSICION->HrefValue = "";
			$this->FECHA_DISPOSICION->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_DISPOSICION
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_DISPOSICION->TooltipValue = "";

			// MOTIVO_ELIMINACION_BIEN
			$this->MOTIVO_ELIMINACION_BIEN->LinkCustomAttributes = "";
			$this->MOTIVO_ELIMINACION_BIEN->HrefValue = "";
			$this->MOTIVO_ELIMINACION_BIEN->TooltipValue = "";

			// ACTO_ADMINISTRACION_BIEN
			$this->ACTO_ADMINISTRACION_BIEN->LinkCustomAttributes = "";
			$this->ACTO_ADMINISTRACION_BIEN->HrefValue = "";
			$this->ACTO_ADMINISTRACION_BIEN->TooltipValue = "";

			// NUM_RESOLUCION_ADMINISTRACION
			$this->NUM_RESOLUCION_ADMINISTRACION->LinkCustomAttributes = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->HrefValue = "";
			$this->NUM_RESOLUCION_ADMINISTRACION->TooltipValue = "";

			// FECHA_ADMINISTRACION
			$this->FECHA_ADMINISTRACION->LinkCustomAttributes = "";
			$this->FECHA_ADMINISTRACION->HrefValue = "";
			$this->FECHA_ADMINISTRACION->TooltipValue = "";

			// FECHA_VENC_ACTO_ADMIN
			$this->FECHA_VENC_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->FECHA_VENC_ACTO_ADMIN->HrefValue = "";
			$this->FECHA_VENC_ACTO_ADMIN->TooltipValue = "";

			// ENTIDAD_BENEFICIADA_ACTO_ADMIN
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->HrefValue = "";
			$this->ENTIDAD_BENEFICIADA_ACTO_ADMIN->TooltipValue = "";

			// DOC_ALTA_SBN
			$this->DOC_ALTA_SBN->LinkCustomAttributes = "";
			$this->DOC_ALTA_SBN->HrefValue = "";
			$this->DOC_ALTA_SBN->TooltipValue = "";

			// DOC_BAJA_SBN
			$this->DOC_BAJA_SBN->LinkCustomAttributes = "";
			$this->DOC_BAJA_SBN->HrefValue = "";
			$this->DOC_BAJA_SBN->TooltipValue = "";

			// DEPENDENCIAS
			$this->DEPENDENCIAS->LinkCustomAttributes = "";
			$this->DEPENDENCIAS->HrefValue = "";
			$this->DEPENDENCIAS->TooltipValue = "";

			// NUMERO_FICHA
			$this->NUMERO_FICHA->LinkCustomAttributes = "";
			$this->NUMERO_FICHA->HrefValue = "";
			$this->NUMERO_FICHA->TooltipValue = "";

			// CODIGO_INTERNO
			$this->CODIGO_INTERNO->LinkCustomAttributes = "";
			$this->CODIGO_INTERNO->HrefValue = "";
			$this->CODIGO_INTERNO->TooltipValue = "";

			// ESTADO
			$this->ESTADO->LinkCustomAttributes = "";
			$this->ESTADO->HrefValue = "";
			$this->ESTADO->TooltipValue = "";

			// USO
			$this->USO->LinkCustomAttributes = "";
			$this->USO->HrefValue = "";
			$this->USO->TooltipValue = "";

			// STICKER
			$this->STICKER->LinkCustomAttributes = "";
			$this->STICKER->HrefValue = "";
			$this->STICKER->TooltipValue = "";

			// SEDE
			$this->SEDE->LinkCustomAttributes = "";
			$this->SEDE->HrefValue = "";
			$this->SEDE->TooltipValue = "";

			// SBN
			$this->SBN->LinkCustomAttributes = "";
			$this->SBN->HrefValue = "";
			$this->SBN->TooltipValue = "";

			// ETIQUETA
			$this->ETIQUETA->LinkCustomAttributes = "";
			$this->ETIQUETA->HrefValue = "";
			$this->ETIQUETA->TooltipValue = "";

			// NOMBRE_BENEFICIARIO_ACTO_ADMIN
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->LinkCustomAttributes = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->HrefValue = "";
			$this->NOMBRE_BENEFICIARIO_ACTO_ADMIN->TooltipValue = "";

			// PLACA_RODAJE
			$this->PLACA_RODAJE->LinkCustomAttributes = "";
			$this->PLACA_RODAJE->HrefValue = "";
			$this->PLACA_RODAJE->TooltipValue = "";

			// CODIGO_ACTUAL
			$this->CODIGO_ACTUAL->LinkCustomAttributes = "";
			$this->CODIGO_ACTUAL->HrefValue = "";
			$this->CODIGO_ACTUAL->TooltipValue = "";

			// CODIGO_ANTERIOR
			$this->CODIGO_ANTERIOR->LinkCustomAttributes = "";
			$this->CODIGO_ANTERIOR->HrefValue = "";
			$this->CODIGO_ANTERIOR->TooltipValue = "";

			// PROPIEDAD
			$this->PROPIEDAD->LinkCustomAttributes = "";
			$this->PROPIEDAD->HrefValue = "";
			$this->PROPIEDAD->TooltipValue = "";

			// SITUACION
			$this->SITUACION->LinkCustomAttributes = "";
			$this->SITUACION->HrefValue = "";
			$this->SITUACION->TooltipValue = "";

			// OBSERVACIONES
			$this->OBSERVACIONES->LinkCustomAttributes = "";
			$this->OBSERVACIONES->HrefValue = "";
			$this->OBSERVACIONES->TooltipValue = "";

			// FECHA_REGISTRO
			$this->FECHA_REGISTRO->LinkCustomAttributes = "";
			$this->FECHA_REGISTRO->HrefValue = "";
			$this->FECHA_REGISTRO->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fprocesos_nuevolistsrch\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$conn = $this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			} elseif ($pageNo !== NULL) {
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>