<?php namespace PHPMaker2020\project2; ?>
<?php

/**
 * Table class for products
 */
class products extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id_producto;
	public $codigo_producto;
	public $nombre_producto;
	public $estado;
	public $status_producto;
	public $date_added;
	public $precio_producto;
	public $costo_producto;
	public $mon_costo;
	public $mon_venta;
	public $pais;
	public $departamento;
	public $distrito;
	public $localidad;
	public $zona;
	public $tipo_inmueble;
	public $tipo_negocio;
	public $tiempo_alquiler;
	public $moneda;
	public $estado_inmueble;
	public $area_construida;
	public $area_privada;
	public $area_terreno;
	public $valor_administracion;
	public $dormitorios;
	public $banios;
	public $garaje;
	public $piso;
	public $estrato;
	public $direccion;
	public $codigo_postal;
	public $mapa;
	public $latitud;
	public $longitud;
	public $opciones_mapa;
	public $red;
	public $video;
	public $disponibilidad;
	public $anio_construccion;
	public $encargado;
	public $comentario;
	public $visitas;
	public $valor_comision;
	public $tipo_comision;
	public $certificado;
	public $nombre_propietario;
	public $movil_propietario;
	public $telefono_propietario;
	public $correo_propietario;
	public $vinculo;
	public $portales;
	public $notas;
	public $marca;
	public $modelo;
	public $color;
	public $b1;
	public $b2;
	public $b3;
	public $b4;
	public $b5;
	public $b6;
	public $cat_pro;
	public $pro_ser;
	public $foto1;
	public $foto2;
	public $foto3;
	public $foto4;
	public $web;
	public $pre_web;
	public $descripcion;
	public $descripcion1;
	public $megusta;
	public $nomegusta;
	public $precio2;
	public $precio3;
	public $und_pro;
	public $barras;
	public $stockmin;
	public $id_grupo;
	public $talla;
	public $mostrarcolor;
	public $precio_mayorista;
	public $precio_vendedor;
	public $medida1;
	public $medida2;
	public $medida3;
	public $codlogin;
	public $idempresa;
	public $urlstreetview;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'products';
		$this->TableName = 'products';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`products`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id_producto
		$this->id_producto = new DbField('products', 'products', 'x_id_producto', 'id_producto', '`id_producto`', '`id_producto`', 3, 11, -1, FALSE, '`id_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id_producto->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id_producto->IsPrimaryKey = TRUE; // Primary key field
		$this->id_producto->Sortable = TRUE; // Allow sort
		$this->id_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_producto'] = &$this->id_producto;

		// codigo_producto
		$this->codigo_producto = new DbField('products', 'products', 'x_codigo_producto', 'codigo_producto', '`codigo_producto`', '`codigo_producto`', 200, 20, -1, FALSE, '`codigo_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codigo_producto->Sortable = TRUE; // Allow sort
		$this->fields['codigo_producto'] = &$this->codigo_producto;

		// nombre_producto
		$this->nombre_producto = new DbField('products', 'products', 'x_nombre_producto', 'nombre_producto', '`nombre_producto`', '`nombre_producto`', 201, 500, -1, FALSE, '`nombre_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->nombre_producto->Sortable = TRUE; // Allow sort
		$this->fields['nombre_producto'] = &$this->nombre_producto;

		// estado
		$this->estado = new DbField('products', 'products', 'x_estado', 'estado', '`estado`', '`estado`', 3, 11, -1, FALSE, '`estado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado->Sortable = TRUE; // Allow sort
		$this->estado->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['estado'] = &$this->estado;

		// status_producto
		$this->status_producto = new DbField('products', 'products', 'x_status_producto', 'status_producto', '`status_producto`', '`status_producto`', 16, 4, -1, FALSE, '`status_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status_producto->Sortable = TRUE; // Allow sort
		$this->status_producto->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status_producto'] = &$this->status_producto;

		// date_added
		$this->date_added = new DbField('products', 'products', 'x_date_added', 'date_added', '`date_added`', CastDateFieldForLike("`date_added`", 0, "DB"), 135, 19, 0, FALSE, '`date_added`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date_added->Sortable = TRUE; // Allow sort
		$this->date_added->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['date_added'] = &$this->date_added;

		// precio_producto
		$this->precio_producto = new DbField('products', 'products', 'x_precio_producto', 'precio_producto', '`precio_producto`', '`precio_producto`', 131, 12, -1, FALSE, '`precio_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio_producto->Sortable = TRUE; // Allow sort
		$this->precio_producto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio_producto'] = &$this->precio_producto;

		// costo_producto
		$this->costo_producto = new DbField('products', 'products', 'x_costo_producto', 'costo_producto', '`costo_producto`', '`costo_producto`', 131, 12, -1, FALSE, '`costo_producto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->costo_producto->Sortable = TRUE; // Allow sort
		$this->costo_producto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['costo_producto'] = &$this->costo_producto;

		// mon_costo
		$this->mon_costo = new DbField('products', 'products', 'x_mon_costo', 'mon_costo', '`mon_costo`', '`mon_costo`', 131, 6, -1, FALSE, '`mon_costo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mon_costo->Sortable = TRUE; // Allow sort
		$this->mon_costo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mon_costo'] = &$this->mon_costo;

		// mon_venta
		$this->mon_venta = new DbField('products', 'products', 'x_mon_venta', 'mon_venta', '`mon_venta`', '`mon_venta`', 3, 11, -1, FALSE, '`mon_venta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mon_venta->Sortable = TRUE; // Allow sort
		$this->mon_venta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mon_venta'] = &$this->mon_venta;

		// pais
		$this->pais = new DbField('products', 'products', 'x_pais', 'pais', '`pais`', '`pais`', 200, 250, -1, FALSE, '`pais`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pais->Sortable = TRUE; // Allow sort
		$this->fields['pais'] = &$this->pais;

		// departamento
		$this->departamento = new DbField('products', 'products', 'x_departamento', 'departamento', '`departamento`', '`departamento`', 200, 250, -1, FALSE, '`departamento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->departamento->Sortable = TRUE; // Allow sort
		$this->fields['departamento'] = &$this->departamento;

		// distrito
		$this->distrito = new DbField('products', 'products', 'x_distrito', 'distrito', '`distrito`', '`distrito`', 200, 250, -1, FALSE, '`distrito`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->distrito->Sortable = TRUE; // Allow sort
		$this->fields['distrito'] = &$this->distrito;

		// localidad
		$this->localidad = new DbField('products', 'products', 'x_localidad', 'localidad', '`localidad`', '`localidad`', 200, 250, -1, FALSE, '`localidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->localidad->Sortable = TRUE; // Allow sort
		$this->fields['localidad'] = &$this->localidad;

		// zona
		$this->zona = new DbField('products', 'products', 'x_zona', 'zona', '`zona`', '`zona`', 200, 250, -1, FALSE, '`zona`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->zona->Sortable = TRUE; // Allow sort
		$this->fields['zona'] = &$this->zona;

		// tipo_inmueble
		$this->tipo_inmueble = new DbField('products', 'products', 'x_tipo_inmueble', 'tipo_inmueble', '`tipo_inmueble`', '`tipo_inmueble`', 3, 11, -1, FALSE, '`tipo_inmueble`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_inmueble->Sortable = TRUE; // Allow sort
		$this->tipo_inmueble->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tipo_inmueble'] = &$this->tipo_inmueble;

		// tipo_negocio
		$this->tipo_negocio = new DbField('products', 'products', 'x_tipo_negocio', 'tipo_negocio', '`tipo_negocio`', '`tipo_negocio`', 200, 10, -1, FALSE, '`tipo_negocio`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_negocio->Sortable = TRUE; // Allow sort
		$this->fields['tipo_negocio'] = &$this->tipo_negocio;

		// tiempo_alquiler
		$this->tiempo_alquiler = new DbField('products', 'products', 'x_tiempo_alquiler', 'tiempo_alquiler', '`tiempo_alquiler`', '`tiempo_alquiler`', 200, 10, -1, FALSE, '`tiempo_alquiler`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tiempo_alquiler->Sortable = TRUE; // Allow sort
		$this->fields['tiempo_alquiler'] = &$this->tiempo_alquiler;

		// moneda
		$this->moneda = new DbField('products', 'products', 'x_moneda', 'moneda', '`moneda`', '`moneda`', 200, 10, -1, FALSE, '`moneda`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->moneda->Sortable = TRUE; // Allow sort
		$this->fields['moneda'] = &$this->moneda;

		// estado_inmueble
		$this->estado_inmueble = new DbField('products', 'products', 'x_estado_inmueble', 'estado_inmueble', '`estado_inmueble`', '`estado_inmueble`', 200, 10, -1, FALSE, '`estado_inmueble`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estado_inmueble->Sortable = TRUE; // Allow sort
		$this->fields['estado_inmueble'] = &$this->estado_inmueble;

		// area_construida
		$this->area_construida = new DbField('products', 'products', 'x_area_construida', 'area_construida', '`area_construida`', '`area_construida`', 200, 100, -1, FALSE, '`area_construida`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->area_construida->Sortable = TRUE; // Allow sort
		$this->fields['area_construida'] = &$this->area_construida;

		// area_privada
		$this->area_privada = new DbField('products', 'products', 'x_area_privada', 'area_privada', '`area_privada`', '`area_privada`', 200, 100, -1, FALSE, '`area_privada`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->area_privada->Sortable = TRUE; // Allow sort
		$this->fields['area_privada'] = &$this->area_privada;

		// area_terreno
		$this->area_terreno = new DbField('products', 'products', 'x_area_terreno', 'area_terreno', '`area_terreno`', '`area_terreno`', 200, 100, -1, FALSE, '`area_terreno`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->area_terreno->Sortable = TRUE; // Allow sort
		$this->fields['area_terreno'] = &$this->area_terreno;

		// valor_administracion
		$this->valor_administracion = new DbField('products', 'products', 'x_valor_administracion', 'valor_administracion', '`valor_administracion`', '`valor_administracion`', 200, 10, -1, FALSE, '`valor_administracion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->valor_administracion->Sortable = TRUE; // Allow sort
		$this->fields['valor_administracion'] = &$this->valor_administracion;

		// dormitorios
		$this->dormitorios = new DbField('products', 'products', 'x_dormitorios', 'dormitorios', '`dormitorios`', '`dormitorios`', 200, 10, -1, FALSE, '`dormitorios`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dormitorios->Sortable = TRUE; // Allow sort
		$this->fields['dormitorios'] = &$this->dormitorios;

		// banios
		$this->banios = new DbField('products', 'products', 'x_banios', 'banios', '`banios`', '`banios`', 200, 10, -1, FALSE, '`banios`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->banios->Sortable = TRUE; // Allow sort
		$this->fields['banios'] = &$this->banios;

		// garaje
		$this->garaje = new DbField('products', 'products', 'x_garaje', 'garaje', '`garaje`', '`garaje`', 200, 10, -1, FALSE, '`garaje`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->garaje->Sortable = TRUE; // Allow sort
		$this->fields['garaje'] = &$this->garaje;

		// piso
		$this->piso = new DbField('products', 'products', 'x_piso', 'piso', '`piso`', '`piso`', 200, 10, -1, FALSE, '`piso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->piso->Sortable = TRUE; // Allow sort
		$this->fields['piso'] = &$this->piso;

		// estrato
		$this->estrato = new DbField('products', 'products', 'x_estrato', 'estrato', '`estrato`', '`estrato`', 200, 10, -1, FALSE, '`estrato`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->estrato->Sortable = TRUE; // Allow sort
		$this->fields['estrato'] = &$this->estrato;

		// direccion
		$this->direccion = new DbField('products', 'products', 'x_direccion', 'direccion', '`direccion`', '`direccion`', 201, 500, -1, FALSE, '`direccion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->direccion->Sortable = TRUE; // Allow sort
		$this->fields['direccion'] = &$this->direccion;

		// codigo_postal
		$this->codigo_postal = new DbField('products', 'products', 'x_codigo_postal', 'codigo_postal', '`codigo_postal`', '`codigo_postal`', 200, 100, -1, FALSE, '`codigo_postal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codigo_postal->Sortable = TRUE; // Allow sort
		$this->fields['codigo_postal'] = &$this->codigo_postal;

		// mapa
		$this->mapa = new DbField('products', 'products', 'x_mapa', 'mapa', '`mapa`', '`mapa`', 200, 250, -1, FALSE, '`mapa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mapa->Sortable = TRUE; // Allow sort
		$this->fields['mapa'] = &$this->mapa;

		// latitud
		$this->latitud = new DbField('products', 'products', 'x_latitud', 'latitud', '`latitud`', '`latitud`', 200, 250, -1, FALSE, '`latitud`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->latitud->Sortable = TRUE; // Allow sort
		$this->fields['latitud'] = &$this->latitud;

		// longitud
		$this->longitud = new DbField('products', 'products', 'x_longitud', 'longitud', '`longitud`', '`longitud`', 200, 250, -1, FALSE, '`longitud`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->longitud->Sortable = TRUE; // Allow sort
		$this->fields['longitud'] = &$this->longitud;

		// opciones_mapa
		$this->opciones_mapa = new DbField('products', 'products', 'x_opciones_mapa', 'opciones_mapa', '`opciones_mapa`', '`opciones_mapa`', 200, 250, -1, FALSE, '`opciones_mapa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->opciones_mapa->Sortable = TRUE; // Allow sort
		$this->fields['opciones_mapa'] = &$this->opciones_mapa;

		// red
		$this->red = new DbField('products', 'products', 'x_red', 'red', '`red`', '`red`', 200, 10, -1, FALSE, '`red`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->red->Sortable = TRUE; // Allow sort
		$this->fields['red'] = &$this->red;

		// video
		$this->video = new DbField('products', 'products', 'x_video', 'video', '`video`', '`video`', 201, 350, -1, FALSE, '`video`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->video->Sortable = TRUE; // Allow sort
		$this->fields['video'] = &$this->video;

		// disponibilidad
		$this->disponibilidad = new DbField('products', 'products', 'x_disponibilidad', 'disponibilidad', '`disponibilidad`', '`disponibilidad`', 200, 10, -1, FALSE, '`disponibilidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->disponibilidad->Sortable = TRUE; // Allow sort
		$this->fields['disponibilidad'] = &$this->disponibilidad;

		// anio_construccion
		$this->anio_construccion = new DbField('products', 'products', 'x_anio_construccion', 'anio_construccion', '`anio_construccion`', '`anio_construccion`', 200, 10, -1, FALSE, '`anio_construccion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->anio_construccion->Sortable = TRUE; // Allow sort
		$this->fields['anio_construccion'] = &$this->anio_construccion;

		// encargado
		$this->encargado = new DbField('products', 'products', 'x_encargado', 'encargado', '`encargado`', '`encargado`', 200, 250, -1, FALSE, '`encargado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->encargado->Sortable = TRUE; // Allow sort
		$this->fields['encargado'] = &$this->encargado;

		// comentario
		$this->comentario = new DbField('products', 'products', 'x_comentario', 'comentario', '`comentario`', '`comentario`', 201, 65535, -1, FALSE, '`comentario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->comentario->Sortable = TRUE; // Allow sort
		$this->fields['comentario'] = &$this->comentario;

		// visitas
		$this->visitas = new DbField('products', 'products', 'x_visitas', 'visitas', '`visitas`', '`visitas`', 200, 10, -1, FALSE, '`visitas`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->visitas->Sortable = TRUE; // Allow sort
		$this->fields['visitas'] = &$this->visitas;

		// valor_comision
		$this->valor_comision = new DbField('products', 'products', 'x_valor_comision', 'valor_comision', '`valor_comision`', '`valor_comision`', 131, 11, -1, FALSE, '`valor_comision`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->valor_comision->Sortable = TRUE; // Allow sort
		$this->valor_comision->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['valor_comision'] = &$this->valor_comision;

		// tipo_comision
		$this->tipo_comision = new DbField('products', 'products', 'x_tipo_comision', 'tipo_comision', '`tipo_comision`', '`tipo_comision`', 200, 10, -1, FALSE, '`tipo_comision`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tipo_comision->Sortable = TRUE; // Allow sort
		$this->fields['tipo_comision'] = &$this->tipo_comision;

		// certificado
		$this->certificado = new DbField('products', 'products', 'x_certificado', 'certificado', '`certificado`', '`certificado`', 200, 250, -1, FALSE, '`certificado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->certificado->Sortable = TRUE; // Allow sort
		$this->fields['certificado'] = &$this->certificado;

		// nombre_propietario
		$this->nombre_propietario = new DbField('products', 'products', 'x_nombre_propietario', 'nombre_propietario', '`nombre_propietario`', '`nombre_propietario`', 200, 250, -1, FALSE, '`nombre_propietario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nombre_propietario->Sortable = TRUE; // Allow sort
		$this->fields['nombre_propietario'] = &$this->nombre_propietario;

		// movil_propietario
		$this->movil_propietario = new DbField('products', 'products', 'x_movil_propietario', 'movil_propietario', '`movil_propietario`', '`movil_propietario`', 200, 20, -1, FALSE, '`movil_propietario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->movil_propietario->Sortable = TRUE; // Allow sort
		$this->fields['movil_propietario'] = &$this->movil_propietario;

		// telefono_propietario
		$this->telefono_propietario = new DbField('products', 'products', 'x_telefono_propietario', 'telefono_propietario', '`telefono_propietario`', '`telefono_propietario`', 200, 20, -1, FALSE, '`telefono_propietario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->telefono_propietario->Sortable = TRUE; // Allow sort
		$this->fields['telefono_propietario'] = &$this->telefono_propietario;

		// correo_propietario
		$this->correo_propietario = new DbField('products', 'products', 'x_correo_propietario', 'correo_propietario', '`correo_propietario`', '`correo_propietario`', 200, 250, -1, FALSE, '`correo_propietario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->correo_propietario->Sortable = TRUE; // Allow sort
		$this->fields['correo_propietario'] = &$this->correo_propietario;

		// vinculo
		$this->vinculo = new DbField('products', 'products', 'x_vinculo', 'vinculo', '`vinculo`', '`vinculo`', 200, 250, -1, FALSE, '`vinculo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vinculo->Sortable = TRUE; // Allow sort
		$this->fields['vinculo'] = &$this->vinculo;

		// portales
		$this->portales = new DbField('products', 'products', 'x_portales', 'portales', '`portales`', '`portales`', 201, 65535, -1, FALSE, '`portales`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->portales->Sortable = TRUE; // Allow sort
		$this->fields['portales'] = &$this->portales;

		// notas
		$this->notas = new DbField('products', 'products', 'x_notas', 'notas', '`notas`', '`notas`', 200, 250, -1, FALSE, '`notas`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->notas->Sortable = TRUE; // Allow sort
		$this->fields['notas'] = &$this->notas;

		// marca
		$this->marca = new DbField('products', 'products', 'x_marca', 'marca', '`marca`', '`marca`', 200, 50, -1, FALSE, '`marca`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->marca->Sortable = TRUE; // Allow sort
		$this->fields['marca'] = &$this->marca;

		// modelo
		$this->modelo = new DbField('products', 'products', 'x_modelo', 'modelo', '`modelo`', '`modelo`', 200, 50, -1, FALSE, '`modelo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->modelo->Sortable = TRUE; // Allow sort
		$this->fields['modelo'] = &$this->modelo;

		// color
		$this->color = new DbField('products', 'products', 'x_color', 'color', '`color`', '`color`', 200, 50, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Sortable = TRUE; // Allow sort
		$this->fields['color'] = &$this->color;

		// b1
		$this->b1 = new DbField('products', 'products', 'x_b1', 'b1', '`b1`', '`b1`', 131, 12, -1, FALSE, '`b1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b1->Sortable = TRUE; // Allow sort
		$this->b1->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b1'] = &$this->b1;

		// b2
		$this->b2 = new DbField('products', 'products', 'x_b2', 'b2', '`b2`', '`b2`', 131, 12, -1, FALSE, '`b2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b2->Sortable = TRUE; // Allow sort
		$this->b2->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b2'] = &$this->b2;

		// b3
		$this->b3 = new DbField('products', 'products', 'x_b3', 'b3', '`b3`', '`b3`', 131, 12, -1, FALSE, '`b3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b3->Sortable = TRUE; // Allow sort
		$this->b3->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b3'] = &$this->b3;

		// b4
		$this->b4 = new DbField('products', 'products', 'x_b4', 'b4', '`b4`', '`b4`', 131, 12, -1, FALSE, '`b4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b4->Sortable = TRUE; // Allow sort
		$this->b4->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b4'] = &$this->b4;

		// b5
		$this->b5 = new DbField('products', 'products', 'x_b5', 'b5', '`b5`', '`b5`', 131, 12, -1, FALSE, '`b5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b5->Sortable = TRUE; // Allow sort
		$this->b5->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b5'] = &$this->b5;

		// b6
		$this->b6 = new DbField('products', 'products', 'x_b6', 'b6', '`b6`', '`b6`', 131, 12, -1, FALSE, '`b6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b6->Sortable = TRUE; // Allow sort
		$this->b6->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b6'] = &$this->b6;

		// cat_pro
		$this->cat_pro = new DbField('products', 'products', 'x_cat_pro', 'cat_pro', '`cat_pro`', '`cat_pro`', 3, 11, -1, FALSE, '`cat_pro`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cat_pro->Sortable = TRUE; // Allow sort
		$this->cat_pro->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cat_pro'] = &$this->cat_pro;

		// pro_ser
		$this->pro_ser = new DbField('products', 'products', 'x_pro_ser', 'pro_ser', '`pro_ser`', '`pro_ser`', 3, 11, -1, FALSE, '`pro_ser`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pro_ser->Sortable = TRUE; // Allow sort
		$this->pro_ser->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pro_ser'] = &$this->pro_ser;

		// foto1
		$this->foto1 = new DbField('products', 'products', 'x_foto1', 'foto1', '`foto1`', '`foto1`', 201, 65535, -1, FALSE, '`foto1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->foto1->Sortable = TRUE; // Allow sort
		$this->fields['foto1'] = &$this->foto1;

		// foto2
		$this->foto2 = new DbField('products', 'products', 'x_foto2', 'foto2', '`foto2`', '`foto2`', 200, 100, -1, FALSE, '`foto2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto2->Sortable = TRUE; // Allow sort
		$this->fields['foto2'] = &$this->foto2;

		// foto3
		$this->foto3 = new DbField('products', 'products', 'x_foto3', 'foto3', '`foto3`', '`foto3`', 200, 100, -1, FALSE, '`foto3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto3->Sortable = TRUE; // Allow sort
		$this->fields['foto3'] = &$this->foto3;

		// foto4
		$this->foto4 = new DbField('products', 'products', 'x_foto4', 'foto4', '`foto4`', '`foto4`', 200, 100, -1, FALSE, '`foto4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->foto4->Sortable = TRUE; // Allow sort
		$this->fields['foto4'] = &$this->foto4;

		// web
		$this->web = new DbField('products', 'products', 'x_web', 'web', '`web`', '`web`', 3, 11, -1, FALSE, '`web`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->web->Sortable = TRUE; // Allow sort
		$this->web->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['web'] = &$this->web;

		// pre_web
		$this->pre_web = new DbField('products', 'products', 'x_pre_web', 'pre_web', '`pre_web`', '`pre_web`', 131, 12, -1, FALSE, '`pre_web`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pre_web->Sortable = TRUE; // Allow sort
		$this->pre_web->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pre_web'] = &$this->pre_web;

		// descripcion
		$this->descripcion = new DbField('products', 'products', 'x_descripcion', 'descripcion', '`descripcion`', '`descripcion`', 201, 65535, -1, FALSE, '`descripcion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->descripcion->Sortable = TRUE; // Allow sort
		$this->fields['descripcion'] = &$this->descripcion;

		// descripcion1
		$this->descripcion1 = new DbField('products', 'products', 'x_descripcion1', 'descripcion1', '`descripcion1`', '`descripcion1`', 201, 65535, -1, FALSE, '`descripcion1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->descripcion1->Sortable = TRUE; // Allow sort
		$this->fields['descripcion1'] = &$this->descripcion1;

		// megusta
		$this->megusta = new DbField('products', 'products', 'x_megusta', 'megusta', '`megusta`', '`megusta`', 3, 11, -1, FALSE, '`megusta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->megusta->Sortable = TRUE; // Allow sort
		$this->megusta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['megusta'] = &$this->megusta;

		// nomegusta
		$this->nomegusta = new DbField('products', 'products', 'x_nomegusta', 'nomegusta', '`nomegusta`', '`nomegusta`', 3, 11, -1, FALSE, '`nomegusta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nomegusta->Sortable = TRUE; // Allow sort
		$this->nomegusta->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['nomegusta'] = &$this->nomegusta;

		// precio2
		$this->precio2 = new DbField('products', 'products', 'x_precio2', 'precio2', '`precio2`', '`precio2`', 131, 12, -1, FALSE, '`precio2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio2->Sortable = TRUE; // Allow sort
		$this->precio2->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio2'] = &$this->precio2;

		// precio3
		$this->precio3 = new DbField('products', 'products', 'x_precio3', 'precio3', '`precio3`', '`precio3`', 131, 12, -1, FALSE, '`precio3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio3->Sortable = TRUE; // Allow sort
		$this->precio3->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio3'] = &$this->precio3;

		// und_pro
		$this->und_pro = new DbField('products', 'products', 'x_und_pro', 'und_pro', '`und_pro`', '`und_pro`', 3, 11, -1, FALSE, '`und_pro`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->und_pro->Sortable = TRUE; // Allow sort
		$this->und_pro->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['und_pro'] = &$this->und_pro;

		// barras
		$this->barras = new DbField('products', 'products', 'x_barras', 'barras', '`barras`', '`barras`', 200, 20, -1, FALSE, '`barras`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->barras->Sortable = TRUE; // Allow sort
		$this->fields['barras'] = &$this->barras;

		// stockmin
		$this->stockmin = new DbField('products', 'products', 'x_stockmin', 'stockmin', '`stockmin`', '`stockmin`', 131, 10, -1, FALSE, '`stockmin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stockmin->Sortable = TRUE; // Allow sort
		$this->stockmin->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stockmin'] = &$this->stockmin;

		// id_grupo
		$this->id_grupo = new DbField('products', 'products', 'x_id_grupo', 'id_grupo', '`id_grupo`', '`id_grupo`', 3, 11, -1, FALSE, '`id_grupo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_grupo->Sortable = TRUE; // Allow sort
		$this->id_grupo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_grupo'] = &$this->id_grupo;

		// talla
		$this->talla = new DbField('products', 'products', 'x_talla', 'talla', '`talla`', '`talla`', 200, 110, -1, FALSE, '`talla`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->talla->Sortable = TRUE; // Allow sort
		$this->fields['talla'] = &$this->talla;

		// mostrarcolor
		$this->mostrarcolor = new DbField('products', 'products', 'x_mostrarcolor', 'mostrarcolor', '`mostrarcolor`', '`mostrarcolor`', 3, 11, -1, FALSE, '`mostrarcolor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mostrarcolor->Sortable = TRUE; // Allow sort
		$this->mostrarcolor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mostrarcolor'] = &$this->mostrarcolor;

		// precio_mayorista
		$this->precio_mayorista = new DbField('products', 'products', 'x_precio_mayorista', 'precio_mayorista', '`precio_mayorista`', '`precio_mayorista`', 131, 12, -1, FALSE, '`precio_mayorista`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio_mayorista->Sortable = TRUE; // Allow sort
		$this->precio_mayorista->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio_mayorista'] = &$this->precio_mayorista;

		// precio_vendedor
		$this->precio_vendedor = new DbField('products', 'products', 'x_precio_vendedor', 'precio_vendedor', '`precio_vendedor`', '`precio_vendedor`', 131, 12, -1, FALSE, '`precio_vendedor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->precio_vendedor->Sortable = TRUE; // Allow sort
		$this->precio_vendedor->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['precio_vendedor'] = &$this->precio_vendedor;

		// medida1
		$this->medida1 = new DbField('products', 'products', 'x_medida1', 'medida1', '`medida1`', '`medida1`', 200, 10, -1, FALSE, '`medida1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->medida1->Sortable = TRUE; // Allow sort
		$this->fields['medida1'] = &$this->medida1;

		// medida2
		$this->medida2 = new DbField('products', 'products', 'x_medida2', 'medida2', '`medida2`', '`medida2`', 200, 10, -1, FALSE, '`medida2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->medida2->Sortable = TRUE; // Allow sort
		$this->fields['medida2'] = &$this->medida2;

		// medida3
		$this->medida3 = new DbField('products', 'products', 'x_medida3', 'medida3', '`medida3`', '`medida3`', 200, 10, -1, FALSE, '`medida3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->medida3->Sortable = TRUE; // Allow sort
		$this->fields['medida3'] = &$this->medida3;

		// codlogin
		$this->codlogin = new DbField('products', 'products', 'x_codlogin', 'codlogin', '`codlogin`', '`codlogin`', 200, 100, -1, FALSE, '`codlogin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->codlogin->Sortable = TRUE; // Allow sort
		$this->fields['codlogin'] = &$this->codlogin;

		// idempresa
		$this->idempresa = new DbField('products', 'products', 'x_idempresa', 'idempresa', '`idempresa`', '`idempresa`', 3, 11, -1, FALSE, '`idempresa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idempresa->Sortable = TRUE; // Allow sort
		$this->idempresa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idempresa'] = &$this->idempresa;

		// urlstreetview
		$this->urlstreetview = new DbField('products', 'products', 'x_urlstreetview', 'urlstreetview', '`urlstreetview`', '`urlstreetview`', 200, 255, -1, FALSE, '`urlstreetview`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->urlstreetview->Sortable = TRUE; // Allow sort
		$this->fields['urlstreetview'] = &$this->urlstreetview;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`products`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = Config("USER_ID_ALLOW");
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id_producto->setDbValue($conn->insert_ID());
			$rs['id_producto'] = $this->id_producto->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id_producto', $rs))
				AddFilter($where, QuotedName('id_producto', $this->Dbid) . '=' . QuotedValue($rs['id_producto'], $this->id_producto->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id_producto->DbValue = $row['id_producto'];
		$this->codigo_producto->DbValue = $row['codigo_producto'];
		$this->nombre_producto->DbValue = $row['nombre_producto'];
		$this->estado->DbValue = $row['estado'];
		$this->status_producto->DbValue = $row['status_producto'];
		$this->date_added->DbValue = $row['date_added'];
		$this->precio_producto->DbValue = $row['precio_producto'];
		$this->costo_producto->DbValue = $row['costo_producto'];
		$this->mon_costo->DbValue = $row['mon_costo'];
		$this->mon_venta->DbValue = $row['mon_venta'];
		$this->pais->DbValue = $row['pais'];
		$this->departamento->DbValue = $row['departamento'];
		$this->distrito->DbValue = $row['distrito'];
		$this->localidad->DbValue = $row['localidad'];
		$this->zona->DbValue = $row['zona'];
		$this->tipo_inmueble->DbValue = $row['tipo_inmueble'];
		$this->tipo_negocio->DbValue = $row['tipo_negocio'];
		$this->tiempo_alquiler->DbValue = $row['tiempo_alquiler'];
		$this->moneda->DbValue = $row['moneda'];
		$this->estado_inmueble->DbValue = $row['estado_inmueble'];
		$this->area_construida->DbValue = $row['area_construida'];
		$this->area_privada->DbValue = $row['area_privada'];
		$this->area_terreno->DbValue = $row['area_terreno'];
		$this->valor_administracion->DbValue = $row['valor_administracion'];
		$this->dormitorios->DbValue = $row['dormitorios'];
		$this->banios->DbValue = $row['banios'];
		$this->garaje->DbValue = $row['garaje'];
		$this->piso->DbValue = $row['piso'];
		$this->estrato->DbValue = $row['estrato'];
		$this->direccion->DbValue = $row['direccion'];
		$this->codigo_postal->DbValue = $row['codigo_postal'];
		$this->mapa->DbValue = $row['mapa'];
		$this->latitud->DbValue = $row['latitud'];
		$this->longitud->DbValue = $row['longitud'];
		$this->opciones_mapa->DbValue = $row['opciones_mapa'];
		$this->red->DbValue = $row['red'];
		$this->video->DbValue = $row['video'];
		$this->disponibilidad->DbValue = $row['disponibilidad'];
		$this->anio_construccion->DbValue = $row['anio_construccion'];
		$this->encargado->DbValue = $row['encargado'];
		$this->comentario->DbValue = $row['comentario'];
		$this->visitas->DbValue = $row['visitas'];
		$this->valor_comision->DbValue = $row['valor_comision'];
		$this->tipo_comision->DbValue = $row['tipo_comision'];
		$this->certificado->DbValue = $row['certificado'];
		$this->nombre_propietario->DbValue = $row['nombre_propietario'];
		$this->movil_propietario->DbValue = $row['movil_propietario'];
		$this->telefono_propietario->DbValue = $row['telefono_propietario'];
		$this->correo_propietario->DbValue = $row['correo_propietario'];
		$this->vinculo->DbValue = $row['vinculo'];
		$this->portales->DbValue = $row['portales'];
		$this->notas->DbValue = $row['notas'];
		$this->marca->DbValue = $row['marca'];
		$this->modelo->DbValue = $row['modelo'];
		$this->color->DbValue = $row['color'];
		$this->b1->DbValue = $row['b1'];
		$this->b2->DbValue = $row['b2'];
		$this->b3->DbValue = $row['b3'];
		$this->b4->DbValue = $row['b4'];
		$this->b5->DbValue = $row['b5'];
		$this->b6->DbValue = $row['b6'];
		$this->cat_pro->DbValue = $row['cat_pro'];
		$this->pro_ser->DbValue = $row['pro_ser'];
		$this->foto1->DbValue = $row['foto1'];
		$this->foto2->DbValue = $row['foto2'];
		$this->foto3->DbValue = $row['foto3'];
		$this->foto4->DbValue = $row['foto4'];
		$this->web->DbValue = $row['web'];
		$this->pre_web->DbValue = $row['pre_web'];
		$this->descripcion->DbValue = $row['descripcion'];
		$this->descripcion1->DbValue = $row['descripcion1'];
		$this->megusta->DbValue = $row['megusta'];
		$this->nomegusta->DbValue = $row['nomegusta'];
		$this->precio2->DbValue = $row['precio2'];
		$this->precio3->DbValue = $row['precio3'];
		$this->und_pro->DbValue = $row['und_pro'];
		$this->barras->DbValue = $row['barras'];
		$this->stockmin->DbValue = $row['stockmin'];
		$this->id_grupo->DbValue = $row['id_grupo'];
		$this->talla->DbValue = $row['talla'];
		$this->mostrarcolor->DbValue = $row['mostrarcolor'];
		$this->precio_mayorista->DbValue = $row['precio_mayorista'];
		$this->precio_vendedor->DbValue = $row['precio_vendedor'];
		$this->medida1->DbValue = $row['medida1'];
		$this->medida2->DbValue = $row['medida2'];
		$this->medida3->DbValue = $row['medida3'];
		$this->codlogin->DbValue = $row['codlogin'];
		$this->idempresa->DbValue = $row['idempresa'];
		$this->urlstreetview->DbValue = $row['urlstreetview'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id_producto` = @id_producto@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('id_producto', $row) ? $row['id_producto'] : NULL;
		else
			$val = $this->id_producto->OldValue !== NULL ? $this->id_producto->OldValue : $this->id_producto->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id_producto@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "productslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "productsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "productsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "productsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "productslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("productsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("productsview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "productsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "productsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("productsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("productsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("productsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id_producto:" . JsonEncode($this->id_producto->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->id_producto->CurrentValue != NULL) {
			$url .= "id_producto=" . urlencode($this->id_producto->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id_producto") !== NULL)
				$arKeys[] = Param("id_producto");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->id_producto->CurrentValue = $key;
			else
				$this->id_producto->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id_producto->setDbValue($rs->fields('id_producto'));
		$this->codigo_producto->setDbValue($rs->fields('codigo_producto'));
		$this->nombre_producto->setDbValue($rs->fields('nombre_producto'));
		$this->estado->setDbValue($rs->fields('estado'));
		$this->status_producto->setDbValue($rs->fields('status_producto'));
		$this->date_added->setDbValue($rs->fields('date_added'));
		$this->precio_producto->setDbValue($rs->fields('precio_producto'));
		$this->costo_producto->setDbValue($rs->fields('costo_producto'));
		$this->mon_costo->setDbValue($rs->fields('mon_costo'));
		$this->mon_venta->setDbValue($rs->fields('mon_venta'));
		$this->pais->setDbValue($rs->fields('pais'));
		$this->departamento->setDbValue($rs->fields('departamento'));
		$this->distrito->setDbValue($rs->fields('distrito'));
		$this->localidad->setDbValue($rs->fields('localidad'));
		$this->zona->setDbValue($rs->fields('zona'));
		$this->tipo_inmueble->setDbValue($rs->fields('tipo_inmueble'));
		$this->tipo_negocio->setDbValue($rs->fields('tipo_negocio'));
		$this->tiempo_alquiler->setDbValue($rs->fields('tiempo_alquiler'));
		$this->moneda->setDbValue($rs->fields('moneda'));
		$this->estado_inmueble->setDbValue($rs->fields('estado_inmueble'));
		$this->area_construida->setDbValue($rs->fields('area_construida'));
		$this->area_privada->setDbValue($rs->fields('area_privada'));
		$this->area_terreno->setDbValue($rs->fields('area_terreno'));
		$this->valor_administracion->setDbValue($rs->fields('valor_administracion'));
		$this->dormitorios->setDbValue($rs->fields('dormitorios'));
		$this->banios->setDbValue($rs->fields('banios'));
		$this->garaje->setDbValue($rs->fields('garaje'));
		$this->piso->setDbValue($rs->fields('piso'));
		$this->estrato->setDbValue($rs->fields('estrato'));
		$this->direccion->setDbValue($rs->fields('direccion'));
		$this->codigo_postal->setDbValue($rs->fields('codigo_postal'));
		$this->mapa->setDbValue($rs->fields('mapa'));
		$this->latitud->setDbValue($rs->fields('latitud'));
		$this->longitud->setDbValue($rs->fields('longitud'));
		$this->opciones_mapa->setDbValue($rs->fields('opciones_mapa'));
		$this->red->setDbValue($rs->fields('red'));
		$this->video->setDbValue($rs->fields('video'));
		$this->disponibilidad->setDbValue($rs->fields('disponibilidad'));
		$this->anio_construccion->setDbValue($rs->fields('anio_construccion'));
		$this->encargado->setDbValue($rs->fields('encargado'));
		$this->comentario->setDbValue($rs->fields('comentario'));
		$this->visitas->setDbValue($rs->fields('visitas'));
		$this->valor_comision->setDbValue($rs->fields('valor_comision'));
		$this->tipo_comision->setDbValue($rs->fields('tipo_comision'));
		$this->certificado->setDbValue($rs->fields('certificado'));
		$this->nombre_propietario->setDbValue($rs->fields('nombre_propietario'));
		$this->movil_propietario->setDbValue($rs->fields('movil_propietario'));
		$this->telefono_propietario->setDbValue($rs->fields('telefono_propietario'));
		$this->correo_propietario->setDbValue($rs->fields('correo_propietario'));
		$this->vinculo->setDbValue($rs->fields('vinculo'));
		$this->portales->setDbValue($rs->fields('portales'));
		$this->notas->setDbValue($rs->fields('notas'));
		$this->marca->setDbValue($rs->fields('marca'));
		$this->modelo->setDbValue($rs->fields('modelo'));
		$this->color->setDbValue($rs->fields('color'));
		$this->b1->setDbValue($rs->fields('b1'));
		$this->b2->setDbValue($rs->fields('b2'));
		$this->b3->setDbValue($rs->fields('b3'));
		$this->b4->setDbValue($rs->fields('b4'));
		$this->b5->setDbValue($rs->fields('b5'));
		$this->b6->setDbValue($rs->fields('b6'));
		$this->cat_pro->setDbValue($rs->fields('cat_pro'));
		$this->pro_ser->setDbValue($rs->fields('pro_ser'));
		$this->foto1->setDbValue($rs->fields('foto1'));
		$this->foto2->setDbValue($rs->fields('foto2'));
		$this->foto3->setDbValue($rs->fields('foto3'));
		$this->foto4->setDbValue($rs->fields('foto4'));
		$this->web->setDbValue($rs->fields('web'));
		$this->pre_web->setDbValue($rs->fields('pre_web'));
		$this->descripcion->setDbValue($rs->fields('descripcion'));
		$this->descripcion1->setDbValue($rs->fields('descripcion1'));
		$this->megusta->setDbValue($rs->fields('megusta'));
		$this->nomegusta->setDbValue($rs->fields('nomegusta'));
		$this->precio2->setDbValue($rs->fields('precio2'));
		$this->precio3->setDbValue($rs->fields('precio3'));
		$this->und_pro->setDbValue($rs->fields('und_pro'));
		$this->barras->setDbValue($rs->fields('barras'));
		$this->stockmin->setDbValue($rs->fields('stockmin'));
		$this->id_grupo->setDbValue($rs->fields('id_grupo'));
		$this->talla->setDbValue($rs->fields('talla'));
		$this->mostrarcolor->setDbValue($rs->fields('mostrarcolor'));
		$this->precio_mayorista->setDbValue($rs->fields('precio_mayorista'));
		$this->precio_vendedor->setDbValue($rs->fields('precio_vendedor'));
		$this->medida1->setDbValue($rs->fields('medida1'));
		$this->medida2->setDbValue($rs->fields('medida2'));
		$this->medida3->setDbValue($rs->fields('medida3'));
		$this->codlogin->setDbValue($rs->fields('codlogin'));
		$this->idempresa->setDbValue($rs->fields('idempresa'));
		$this->urlstreetview->setDbValue($rs->fields('urlstreetview'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id_producto
		// codigo_producto
		// nombre_producto
		// estado
		// status_producto
		// date_added
		// precio_producto
		// costo_producto
		// mon_costo
		// mon_venta
		// pais
		// departamento
		// distrito
		// localidad
		// zona
		// tipo_inmueble
		// tipo_negocio
		// tiempo_alquiler
		// moneda
		// estado_inmueble
		// area_construida
		// area_privada
		// area_terreno
		// valor_administracion
		// dormitorios
		// banios
		// garaje
		// piso
		// estrato
		// direccion
		// codigo_postal
		// mapa
		// latitud
		// longitud
		// opciones_mapa
		// red
		// video
		// disponibilidad
		// anio_construccion
		// encargado
		// comentario
		// visitas
		// valor_comision
		// tipo_comision
		// certificado
		// nombre_propietario
		// movil_propietario
		// telefono_propietario
		// correo_propietario
		// vinculo
		// portales
		// notas
		// marca
		// modelo
		// color
		// b1
		// b2
		// b3
		// b4
		// b5
		// b6
		// cat_pro
		// pro_ser
		// foto1
		// foto2
		// foto3
		// foto4
		// web
		// pre_web
		// descripcion
		// descripcion1
		// megusta
		// nomegusta
		// precio2
		// precio3
		// und_pro
		// barras
		// stockmin
		// id_grupo
		// talla
		// mostrarcolor
		// precio_mayorista
		// precio_vendedor
		// medida1
		// medida2
		// medida3
		// codlogin
		// idempresa
		// urlstreetview
		// id_producto

		$this->id_producto->ViewValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewCustomAttributes = "";

		// codigo_producto
		$this->codigo_producto->ViewValue = $this->codigo_producto->CurrentValue;
		$this->codigo_producto->ViewCustomAttributes = "";

		// nombre_producto
		$this->nombre_producto->ViewValue = $this->nombre_producto->CurrentValue;
		$this->nombre_producto->ViewCustomAttributes = "";

		// estado
		$this->estado->ViewValue = $this->estado->CurrentValue;
		$this->estado->ViewValue = FormatNumber($this->estado->ViewValue, 0, -2, -2, -2);
		$this->estado->ViewCustomAttributes = "";

		// status_producto
		$this->status_producto->ViewValue = $this->status_producto->CurrentValue;
		$this->status_producto->ViewValue = FormatNumber($this->status_producto->ViewValue, 0, -2, -2, -2);
		$this->status_producto->ViewCustomAttributes = "";

		// date_added
		$this->date_added->ViewValue = $this->date_added->CurrentValue;
		$this->date_added->ViewValue = FormatDateTime($this->date_added->ViewValue, 0);
		$this->date_added->ViewCustomAttributes = "";

		// precio_producto
		$this->precio_producto->ViewValue = $this->precio_producto->CurrentValue;
		$this->precio_producto->ViewValue = FormatNumber($this->precio_producto->ViewValue, 2, -2, -2, -2);
		$this->precio_producto->ViewCustomAttributes = "";

		// costo_producto
		$this->costo_producto->ViewValue = $this->costo_producto->CurrentValue;
		$this->costo_producto->ViewValue = FormatNumber($this->costo_producto->ViewValue, 2, -2, -2, -2);
		$this->costo_producto->ViewCustomAttributes = "";

		// mon_costo
		$this->mon_costo->ViewValue = $this->mon_costo->CurrentValue;
		$this->mon_costo->ViewValue = FormatNumber($this->mon_costo->ViewValue, 2, -2, -2, -2);
		$this->mon_costo->ViewCustomAttributes = "";

		// mon_venta
		$this->mon_venta->ViewValue = $this->mon_venta->CurrentValue;
		$this->mon_venta->ViewValue = FormatNumber($this->mon_venta->ViewValue, 0, -2, -2, -2);
		$this->mon_venta->ViewCustomAttributes = "";

		// pais
		$this->pais->ViewValue = $this->pais->CurrentValue;
		$this->pais->ViewCustomAttributes = "";

		// departamento
		$this->departamento->ViewValue = $this->departamento->CurrentValue;
		$this->departamento->ViewCustomAttributes = "";

		// distrito
		$this->distrito->ViewValue = $this->distrito->CurrentValue;
		$this->distrito->ViewCustomAttributes = "";

		// localidad
		$this->localidad->ViewValue = $this->localidad->CurrentValue;
		$this->localidad->ViewCustomAttributes = "";

		// zona
		$this->zona->ViewValue = $this->zona->CurrentValue;
		$this->zona->ViewCustomAttributes = "";

		// tipo_inmueble
		$this->tipo_inmueble->ViewValue = $this->tipo_inmueble->CurrentValue;
		$this->tipo_inmueble->ViewValue = FormatNumber($this->tipo_inmueble->ViewValue, 0, -2, -2, -2);
		$this->tipo_inmueble->ViewCustomAttributes = "";

		// tipo_negocio
		$this->tipo_negocio->ViewValue = $this->tipo_negocio->CurrentValue;
		$this->tipo_negocio->ViewCustomAttributes = "";

		// tiempo_alquiler
		$this->tiempo_alquiler->ViewValue = $this->tiempo_alquiler->CurrentValue;
		$this->tiempo_alquiler->ViewCustomAttributes = "";

		// moneda
		$this->moneda->ViewValue = $this->moneda->CurrentValue;
		$this->moneda->ViewCustomAttributes = "";

		// estado_inmueble
		$this->estado_inmueble->ViewValue = $this->estado_inmueble->CurrentValue;
		$this->estado_inmueble->ViewCustomAttributes = "";

		// area_construida
		$this->area_construida->ViewValue = $this->area_construida->CurrentValue;
		$this->area_construida->ViewCustomAttributes = "";

		// area_privada
		$this->area_privada->ViewValue = $this->area_privada->CurrentValue;
		$this->area_privada->ViewCustomAttributes = "";

		// area_terreno
		$this->area_terreno->ViewValue = $this->area_terreno->CurrentValue;
		$this->area_terreno->ViewCustomAttributes = "";

		// valor_administracion
		$this->valor_administracion->ViewValue = $this->valor_administracion->CurrentValue;
		$this->valor_administracion->ViewCustomAttributes = "";

		// dormitorios
		$this->dormitorios->ViewValue = $this->dormitorios->CurrentValue;
		$this->dormitorios->ViewCustomAttributes = "";

		// banios
		$this->banios->ViewValue = $this->banios->CurrentValue;
		$this->banios->ViewCustomAttributes = "";

		// garaje
		$this->garaje->ViewValue = $this->garaje->CurrentValue;
		$this->garaje->ViewCustomAttributes = "";

		// piso
		$this->piso->ViewValue = $this->piso->CurrentValue;
		$this->piso->ViewCustomAttributes = "";

		// estrato
		$this->estrato->ViewValue = $this->estrato->CurrentValue;
		$this->estrato->ViewCustomAttributes = "";

		// direccion
		$this->direccion->ViewValue = $this->direccion->CurrentValue;
		$this->direccion->ViewCustomAttributes = "";

		// codigo_postal
		$this->codigo_postal->ViewValue = $this->codigo_postal->CurrentValue;
		$this->codigo_postal->ViewCustomAttributes = "";

		// mapa
		$this->mapa->ViewValue = $this->mapa->CurrentValue;
		$this->mapa->ViewCustomAttributes = "";

		// latitud
		$this->latitud->ViewValue = $this->latitud->CurrentValue;
		$this->latitud->ViewCustomAttributes = "";

		// longitud
		$this->longitud->ViewValue = $this->longitud->CurrentValue;
		$this->longitud->ViewCustomAttributes = "";

		// opciones_mapa
		$this->opciones_mapa->ViewValue = $this->opciones_mapa->CurrentValue;
		$this->opciones_mapa->ViewCustomAttributes = "";

		// red
		$this->red->ViewValue = $this->red->CurrentValue;
		$this->red->ViewCustomAttributes = "";

		// video
		$this->video->ViewValue = $this->video->CurrentValue;
		$this->video->ViewCustomAttributes = "";

		// disponibilidad
		$this->disponibilidad->ViewValue = $this->disponibilidad->CurrentValue;
		$this->disponibilidad->ViewCustomAttributes = "";

		// anio_construccion
		$this->anio_construccion->ViewValue = $this->anio_construccion->CurrentValue;
		$this->anio_construccion->ViewCustomAttributes = "";

		// encargado
		$this->encargado->ViewValue = $this->encargado->CurrentValue;
		$this->encargado->ViewCustomAttributes = "";

		// comentario
		$this->comentario->ViewValue = $this->comentario->CurrentValue;
		$this->comentario->ViewCustomAttributes = "";

		// visitas
		$this->visitas->ViewValue = $this->visitas->CurrentValue;
		$this->visitas->ViewCustomAttributes = "";

		// valor_comision
		$this->valor_comision->ViewValue = $this->valor_comision->CurrentValue;
		$this->valor_comision->ViewValue = FormatNumber($this->valor_comision->ViewValue, 2, -2, -2, -2);
		$this->valor_comision->ViewCustomAttributes = "";

		// tipo_comision
		$this->tipo_comision->ViewValue = $this->tipo_comision->CurrentValue;
		$this->tipo_comision->ViewCustomAttributes = "";

		// certificado
		$this->certificado->ViewValue = $this->certificado->CurrentValue;
		$this->certificado->ViewCustomAttributes = "";

		// nombre_propietario
		$this->nombre_propietario->ViewValue = $this->nombre_propietario->CurrentValue;
		$this->nombre_propietario->ViewCustomAttributes = "";

		// movil_propietario
		$this->movil_propietario->ViewValue = $this->movil_propietario->CurrentValue;
		$this->movil_propietario->ViewCustomAttributes = "";

		// telefono_propietario
		$this->telefono_propietario->ViewValue = $this->telefono_propietario->CurrentValue;
		$this->telefono_propietario->ViewCustomAttributes = "";

		// correo_propietario
		$this->correo_propietario->ViewValue = $this->correo_propietario->CurrentValue;
		$this->correo_propietario->ViewCustomAttributes = "";

		// vinculo
		$this->vinculo->ViewValue = $this->vinculo->CurrentValue;
		$this->vinculo->ViewCustomAttributes = "";

		// portales
		$this->portales->ViewValue = $this->portales->CurrentValue;
		$this->portales->ViewCustomAttributes = "";

		// notas
		$this->notas->ViewValue = $this->notas->CurrentValue;
		$this->notas->ViewCustomAttributes = "";

		// marca
		$this->marca->ViewValue = $this->marca->CurrentValue;
		$this->marca->ViewCustomAttributes = "";

		// modelo
		$this->modelo->ViewValue = $this->modelo->CurrentValue;
		$this->modelo->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// b1
		$this->b1->ViewValue = $this->b1->CurrentValue;
		$this->b1->ViewValue = FormatNumber($this->b1->ViewValue, 2, -2, -2, -2);
		$this->b1->ViewCustomAttributes = "";

		// b2
		$this->b2->ViewValue = $this->b2->CurrentValue;
		$this->b2->ViewValue = FormatNumber($this->b2->ViewValue, 2, -2, -2, -2);
		$this->b2->ViewCustomAttributes = "";

		// b3
		$this->b3->ViewValue = $this->b3->CurrentValue;
		$this->b3->ViewValue = FormatNumber($this->b3->ViewValue, 2, -2, -2, -2);
		$this->b3->ViewCustomAttributes = "";

		// b4
		$this->b4->ViewValue = $this->b4->CurrentValue;
		$this->b4->ViewValue = FormatNumber($this->b4->ViewValue, 2, -2, -2, -2);
		$this->b4->ViewCustomAttributes = "";

		// b5
		$this->b5->ViewValue = $this->b5->CurrentValue;
		$this->b5->ViewValue = FormatNumber($this->b5->ViewValue, 2, -2, -2, -2);
		$this->b5->ViewCustomAttributes = "";

		// b6
		$this->b6->ViewValue = $this->b6->CurrentValue;
		$this->b6->ViewValue = FormatNumber($this->b6->ViewValue, 2, -2, -2, -2);
		$this->b6->ViewCustomAttributes = "";

		// cat_pro
		$this->cat_pro->ViewValue = $this->cat_pro->CurrentValue;
		$this->cat_pro->ViewValue = FormatNumber($this->cat_pro->ViewValue, 0, -2, -2, -2);
		$this->cat_pro->ViewCustomAttributes = "";

		// pro_ser
		$this->pro_ser->ViewValue = $this->pro_ser->CurrentValue;
		$this->pro_ser->ViewValue = FormatNumber($this->pro_ser->ViewValue, 0, -2, -2, -2);
		$this->pro_ser->ViewCustomAttributes = "";

		// foto1
		$this->foto1->ViewValue = $this->foto1->CurrentValue;
		$this->foto1->ViewCustomAttributes = "";

		// foto2
		$this->foto2->ViewValue = $this->foto2->CurrentValue;
		$this->foto2->ViewCustomAttributes = "";

		// foto3
		$this->foto3->ViewValue = $this->foto3->CurrentValue;
		$this->foto3->ViewCustomAttributes = "";

		// foto4
		$this->foto4->ViewValue = $this->foto4->CurrentValue;
		$this->foto4->ViewCustomAttributes = "";

		// web
		$this->web->ViewValue = $this->web->CurrentValue;
		$this->web->ViewValue = FormatNumber($this->web->ViewValue, 0, -2, -2, -2);
		$this->web->ViewCustomAttributes = "";

		// pre_web
		$this->pre_web->ViewValue = $this->pre_web->CurrentValue;
		$this->pre_web->ViewValue = FormatNumber($this->pre_web->ViewValue, 2, -2, -2, -2);
		$this->pre_web->ViewCustomAttributes = "";

		// descripcion
		$this->descripcion->ViewValue = $this->descripcion->CurrentValue;
		$this->descripcion->ViewCustomAttributes = "";

		// descripcion1
		$this->descripcion1->ViewValue = $this->descripcion1->CurrentValue;
		$this->descripcion1->ViewCustomAttributes = "";

		// megusta
		$this->megusta->ViewValue = $this->megusta->CurrentValue;
		$this->megusta->ViewValue = FormatNumber($this->megusta->ViewValue, 0, -2, -2, -2);
		$this->megusta->ViewCustomAttributes = "";

		// nomegusta
		$this->nomegusta->ViewValue = $this->nomegusta->CurrentValue;
		$this->nomegusta->ViewValue = FormatNumber($this->nomegusta->ViewValue, 0, -2, -2, -2);
		$this->nomegusta->ViewCustomAttributes = "";

		// precio2
		$this->precio2->ViewValue = $this->precio2->CurrentValue;
		$this->precio2->ViewValue = FormatNumber($this->precio2->ViewValue, 2, -2, -2, -2);
		$this->precio2->ViewCustomAttributes = "";

		// precio3
		$this->precio3->ViewValue = $this->precio3->CurrentValue;
		$this->precio3->ViewValue = FormatNumber($this->precio3->ViewValue, 2, -2, -2, -2);
		$this->precio3->ViewCustomAttributes = "";

		// und_pro
		$this->und_pro->ViewValue = $this->und_pro->CurrentValue;
		$this->und_pro->ViewValue = FormatNumber($this->und_pro->ViewValue, 0, -2, -2, -2);
		$this->und_pro->ViewCustomAttributes = "";

		// barras
		$this->barras->ViewValue = $this->barras->CurrentValue;
		$this->barras->ViewCustomAttributes = "";

		// stockmin
		$this->stockmin->ViewValue = $this->stockmin->CurrentValue;
		$this->stockmin->ViewValue = FormatNumber($this->stockmin->ViewValue, 2, -2, -2, -2);
		$this->stockmin->ViewCustomAttributes = "";

		// id_grupo
		$this->id_grupo->ViewValue = $this->id_grupo->CurrentValue;
		$this->id_grupo->ViewValue = FormatNumber($this->id_grupo->ViewValue, 0, -2, -2, -2);
		$this->id_grupo->ViewCustomAttributes = "";

		// talla
		$this->talla->ViewValue = $this->talla->CurrentValue;
		$this->talla->ViewCustomAttributes = "";

		// mostrarcolor
		$this->mostrarcolor->ViewValue = $this->mostrarcolor->CurrentValue;
		$this->mostrarcolor->ViewValue = FormatNumber($this->mostrarcolor->ViewValue, 0, -2, -2, -2);
		$this->mostrarcolor->ViewCustomAttributes = "";

		// precio_mayorista
		$this->precio_mayorista->ViewValue = $this->precio_mayorista->CurrentValue;
		$this->precio_mayorista->ViewValue = FormatNumber($this->precio_mayorista->ViewValue, 2, -2, -2, -2);
		$this->precio_mayorista->ViewCustomAttributes = "";

		// precio_vendedor
		$this->precio_vendedor->ViewValue = $this->precio_vendedor->CurrentValue;
		$this->precio_vendedor->ViewValue = FormatNumber($this->precio_vendedor->ViewValue, 2, -2, -2, -2);
		$this->precio_vendedor->ViewCustomAttributes = "";

		// medida1
		$this->medida1->ViewValue = $this->medida1->CurrentValue;
		$this->medida1->ViewCustomAttributes = "";

		// medida2
		$this->medida2->ViewValue = $this->medida2->CurrentValue;
		$this->medida2->ViewCustomAttributes = "";

		// medida3
		$this->medida3->ViewValue = $this->medida3->CurrentValue;
		$this->medida3->ViewCustomAttributes = "";

		// codlogin
		$this->codlogin->ViewValue = $this->codlogin->CurrentValue;
		$this->codlogin->ViewCustomAttributes = "";

		// idempresa
		$this->idempresa->ViewValue = $this->idempresa->CurrentValue;
		$this->idempresa->ViewValue = FormatNumber($this->idempresa->ViewValue, 0, -2, -2, -2);
		$this->idempresa->ViewCustomAttributes = "";

		// urlstreetview
		$this->urlstreetview->ViewValue = $this->urlstreetview->CurrentValue;
		$this->urlstreetview->ViewCustomAttributes = "";

		// id_producto
		$this->id_producto->LinkCustomAttributes = "";
		$this->id_producto->HrefValue = "";
		$this->id_producto->TooltipValue = "";

		// codigo_producto
		$this->codigo_producto->LinkCustomAttributes = "";
		$this->codigo_producto->HrefValue = "";
		$this->codigo_producto->TooltipValue = "";

		// nombre_producto
		$this->nombre_producto->LinkCustomAttributes = "";
		$this->nombre_producto->HrefValue = "";
		$this->nombre_producto->TooltipValue = "";

		// estado
		$this->estado->LinkCustomAttributes = "";
		$this->estado->HrefValue = "";
		$this->estado->TooltipValue = "";

		// status_producto
		$this->status_producto->LinkCustomAttributes = "";
		$this->status_producto->HrefValue = "";
		$this->status_producto->TooltipValue = "";

		// date_added
		$this->date_added->LinkCustomAttributes = "";
		$this->date_added->HrefValue = "";
		$this->date_added->TooltipValue = "";

		// precio_producto
		$this->precio_producto->LinkCustomAttributes = "";
		$this->precio_producto->HrefValue = "";
		$this->precio_producto->TooltipValue = "";

		// costo_producto
		$this->costo_producto->LinkCustomAttributes = "";
		$this->costo_producto->HrefValue = "";
		$this->costo_producto->TooltipValue = "";

		// mon_costo
		$this->mon_costo->LinkCustomAttributes = "";
		$this->mon_costo->HrefValue = "";
		$this->mon_costo->TooltipValue = "";

		// mon_venta
		$this->mon_venta->LinkCustomAttributes = "";
		$this->mon_venta->HrefValue = "";
		$this->mon_venta->TooltipValue = "";

		// pais
		$this->pais->LinkCustomAttributes = "";
		$this->pais->HrefValue = "";
		$this->pais->TooltipValue = "";

		// departamento
		$this->departamento->LinkCustomAttributes = "";
		$this->departamento->HrefValue = "";
		$this->departamento->TooltipValue = "";

		// distrito
		$this->distrito->LinkCustomAttributes = "";
		$this->distrito->HrefValue = "";
		$this->distrito->TooltipValue = "";

		// localidad
		$this->localidad->LinkCustomAttributes = "";
		$this->localidad->HrefValue = "";
		$this->localidad->TooltipValue = "";

		// zona
		$this->zona->LinkCustomAttributes = "";
		$this->zona->HrefValue = "";
		$this->zona->TooltipValue = "";

		// tipo_inmueble
		$this->tipo_inmueble->LinkCustomAttributes = "";
		$this->tipo_inmueble->HrefValue = "";
		$this->tipo_inmueble->TooltipValue = "";

		// tipo_negocio
		$this->tipo_negocio->LinkCustomAttributes = "";
		$this->tipo_negocio->HrefValue = "";
		$this->tipo_negocio->TooltipValue = "";

		// tiempo_alquiler
		$this->tiempo_alquiler->LinkCustomAttributes = "";
		$this->tiempo_alquiler->HrefValue = "";
		$this->tiempo_alquiler->TooltipValue = "";

		// moneda
		$this->moneda->LinkCustomAttributes = "";
		$this->moneda->HrefValue = "";
		$this->moneda->TooltipValue = "";

		// estado_inmueble
		$this->estado_inmueble->LinkCustomAttributes = "";
		$this->estado_inmueble->HrefValue = "";
		$this->estado_inmueble->TooltipValue = "";

		// area_construida
		$this->area_construida->LinkCustomAttributes = "";
		$this->area_construida->HrefValue = "";
		$this->area_construida->TooltipValue = "";

		// area_privada
		$this->area_privada->LinkCustomAttributes = "";
		$this->area_privada->HrefValue = "";
		$this->area_privada->TooltipValue = "";

		// area_terreno
		$this->area_terreno->LinkCustomAttributes = "";
		$this->area_terreno->HrefValue = "";
		$this->area_terreno->TooltipValue = "";

		// valor_administracion
		$this->valor_administracion->LinkCustomAttributes = "";
		$this->valor_administracion->HrefValue = "";
		$this->valor_administracion->TooltipValue = "";

		// dormitorios
		$this->dormitorios->LinkCustomAttributes = "";
		$this->dormitorios->HrefValue = "";
		$this->dormitorios->TooltipValue = "";

		// banios
		$this->banios->LinkCustomAttributes = "";
		$this->banios->HrefValue = "";
		$this->banios->TooltipValue = "";

		// garaje
		$this->garaje->LinkCustomAttributes = "";
		$this->garaje->HrefValue = "";
		$this->garaje->TooltipValue = "";

		// piso
		$this->piso->LinkCustomAttributes = "";
		$this->piso->HrefValue = "";
		$this->piso->TooltipValue = "";

		// estrato
		$this->estrato->LinkCustomAttributes = "";
		$this->estrato->HrefValue = "";
		$this->estrato->TooltipValue = "";

		// direccion
		$this->direccion->LinkCustomAttributes = "";
		$this->direccion->HrefValue = "";
		$this->direccion->TooltipValue = "";

		// codigo_postal
		$this->codigo_postal->LinkCustomAttributes = "";
		$this->codigo_postal->HrefValue = "";
		$this->codigo_postal->TooltipValue = "";

		// mapa
		$this->mapa->LinkCustomAttributes = "";
		$this->mapa->HrefValue = "";
		$this->mapa->TooltipValue = "";

		// latitud
		$this->latitud->LinkCustomAttributes = "";
		$this->latitud->HrefValue = "";
		$this->latitud->TooltipValue = "";

		// longitud
		$this->longitud->LinkCustomAttributes = "";
		$this->longitud->HrefValue = "";
		$this->longitud->TooltipValue = "";

		// opciones_mapa
		$this->opciones_mapa->LinkCustomAttributes = "";
		$this->opciones_mapa->HrefValue = "";
		$this->opciones_mapa->TooltipValue = "";

		// red
		$this->red->LinkCustomAttributes = "";
		$this->red->HrefValue = "";
		$this->red->TooltipValue = "";

		// video
		$this->video->LinkCustomAttributes = "";
		$this->video->HrefValue = "";
		$this->video->TooltipValue = "";

		// disponibilidad
		$this->disponibilidad->LinkCustomAttributes = "";
		$this->disponibilidad->HrefValue = "";
		$this->disponibilidad->TooltipValue = "";

		// anio_construccion
		$this->anio_construccion->LinkCustomAttributes = "";
		$this->anio_construccion->HrefValue = "";
		$this->anio_construccion->TooltipValue = "";

		// encargado
		$this->encargado->LinkCustomAttributes = "";
		$this->encargado->HrefValue = "";
		$this->encargado->TooltipValue = "";

		// comentario
		$this->comentario->LinkCustomAttributes = "";
		$this->comentario->HrefValue = "";
		$this->comentario->TooltipValue = "";

		// visitas
		$this->visitas->LinkCustomAttributes = "";
		$this->visitas->HrefValue = "";
		$this->visitas->TooltipValue = "";

		// valor_comision
		$this->valor_comision->LinkCustomAttributes = "";
		$this->valor_comision->HrefValue = "";
		$this->valor_comision->TooltipValue = "";

		// tipo_comision
		$this->tipo_comision->LinkCustomAttributes = "";
		$this->tipo_comision->HrefValue = "";
		$this->tipo_comision->TooltipValue = "";

		// certificado
		$this->certificado->LinkCustomAttributes = "";
		$this->certificado->HrefValue = "";
		$this->certificado->TooltipValue = "";

		// nombre_propietario
		$this->nombre_propietario->LinkCustomAttributes = "";
		$this->nombre_propietario->HrefValue = "";
		$this->nombre_propietario->TooltipValue = "";

		// movil_propietario
		$this->movil_propietario->LinkCustomAttributes = "";
		$this->movil_propietario->HrefValue = "";
		$this->movil_propietario->TooltipValue = "";

		// telefono_propietario
		$this->telefono_propietario->LinkCustomAttributes = "";
		$this->telefono_propietario->HrefValue = "";
		$this->telefono_propietario->TooltipValue = "";

		// correo_propietario
		$this->correo_propietario->LinkCustomAttributes = "";
		$this->correo_propietario->HrefValue = "";
		$this->correo_propietario->TooltipValue = "";

		// vinculo
		$this->vinculo->LinkCustomAttributes = "";
		$this->vinculo->HrefValue = "";
		$this->vinculo->TooltipValue = "";

		// portales
		$this->portales->LinkCustomAttributes = "";
		$this->portales->HrefValue = "";
		$this->portales->TooltipValue = "";

		// notas
		$this->notas->LinkCustomAttributes = "";
		$this->notas->HrefValue = "";
		$this->notas->TooltipValue = "";

		// marca
		$this->marca->LinkCustomAttributes = "";
		$this->marca->HrefValue = "";
		$this->marca->TooltipValue = "";

		// modelo
		$this->modelo->LinkCustomAttributes = "";
		$this->modelo->HrefValue = "";
		$this->modelo->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// b1
		$this->b1->LinkCustomAttributes = "";
		$this->b1->HrefValue = "";
		$this->b1->TooltipValue = "";

		// b2
		$this->b2->LinkCustomAttributes = "";
		$this->b2->HrefValue = "";
		$this->b2->TooltipValue = "";

		// b3
		$this->b3->LinkCustomAttributes = "";
		$this->b3->HrefValue = "";
		$this->b3->TooltipValue = "";

		// b4
		$this->b4->LinkCustomAttributes = "";
		$this->b4->HrefValue = "";
		$this->b4->TooltipValue = "";

		// b5
		$this->b5->LinkCustomAttributes = "";
		$this->b5->HrefValue = "";
		$this->b5->TooltipValue = "";

		// b6
		$this->b6->LinkCustomAttributes = "";
		$this->b6->HrefValue = "";
		$this->b6->TooltipValue = "";

		// cat_pro
		$this->cat_pro->LinkCustomAttributes = "";
		$this->cat_pro->HrefValue = "";
		$this->cat_pro->TooltipValue = "";

		// pro_ser
		$this->pro_ser->LinkCustomAttributes = "";
		$this->pro_ser->HrefValue = "";
		$this->pro_ser->TooltipValue = "";

		// foto1
		$this->foto1->LinkCustomAttributes = "";
		$this->foto1->HrefValue = "";
		$this->foto1->TooltipValue = "";

		// foto2
		$this->foto2->LinkCustomAttributes = "";
		$this->foto2->HrefValue = "";
		$this->foto2->TooltipValue = "";

		// foto3
		$this->foto3->LinkCustomAttributes = "";
		$this->foto3->HrefValue = "";
		$this->foto3->TooltipValue = "";

		// foto4
		$this->foto4->LinkCustomAttributes = "";
		$this->foto4->HrefValue = "";
		$this->foto4->TooltipValue = "";

		// web
		$this->web->LinkCustomAttributes = "";
		$this->web->HrefValue = "";
		$this->web->TooltipValue = "";

		// pre_web
		$this->pre_web->LinkCustomAttributes = "";
		$this->pre_web->HrefValue = "";
		$this->pre_web->TooltipValue = "";

		// descripcion
		$this->descripcion->LinkCustomAttributes = "";
		$this->descripcion->HrefValue = "";
		$this->descripcion->TooltipValue = "";

		// descripcion1
		$this->descripcion1->LinkCustomAttributes = "";
		$this->descripcion1->HrefValue = "";
		$this->descripcion1->TooltipValue = "";

		// megusta
		$this->megusta->LinkCustomAttributes = "";
		$this->megusta->HrefValue = "";
		$this->megusta->TooltipValue = "";

		// nomegusta
		$this->nomegusta->LinkCustomAttributes = "";
		$this->nomegusta->HrefValue = "";
		$this->nomegusta->TooltipValue = "";

		// precio2
		$this->precio2->LinkCustomAttributes = "";
		$this->precio2->HrefValue = "";
		$this->precio2->TooltipValue = "";

		// precio3
		$this->precio3->LinkCustomAttributes = "";
		$this->precio3->HrefValue = "";
		$this->precio3->TooltipValue = "";

		// und_pro
		$this->und_pro->LinkCustomAttributes = "";
		$this->und_pro->HrefValue = "";
		$this->und_pro->TooltipValue = "";

		// barras
		$this->barras->LinkCustomAttributes = "";
		$this->barras->HrefValue = "";
		$this->barras->TooltipValue = "";

		// stockmin
		$this->stockmin->LinkCustomAttributes = "";
		$this->stockmin->HrefValue = "";
		$this->stockmin->TooltipValue = "";

		// id_grupo
		$this->id_grupo->LinkCustomAttributes = "";
		$this->id_grupo->HrefValue = "";
		$this->id_grupo->TooltipValue = "";

		// talla
		$this->talla->LinkCustomAttributes = "";
		$this->talla->HrefValue = "";
		$this->talla->TooltipValue = "";

		// mostrarcolor
		$this->mostrarcolor->LinkCustomAttributes = "";
		$this->mostrarcolor->HrefValue = "";
		$this->mostrarcolor->TooltipValue = "";

		// precio_mayorista
		$this->precio_mayorista->LinkCustomAttributes = "";
		$this->precio_mayorista->HrefValue = "";
		$this->precio_mayorista->TooltipValue = "";

		// precio_vendedor
		$this->precio_vendedor->LinkCustomAttributes = "";
		$this->precio_vendedor->HrefValue = "";
		$this->precio_vendedor->TooltipValue = "";

		// medida1
		$this->medida1->LinkCustomAttributes = "";
		$this->medida1->HrefValue = "";
		$this->medida1->TooltipValue = "";

		// medida2
		$this->medida2->LinkCustomAttributes = "";
		$this->medida2->HrefValue = "";
		$this->medida2->TooltipValue = "";

		// medida3
		$this->medida3->LinkCustomAttributes = "";
		$this->medida3->HrefValue = "";
		$this->medida3->TooltipValue = "";

		// codlogin
		$this->codlogin->LinkCustomAttributes = "";
		$this->codlogin->HrefValue = "";
		$this->codlogin->TooltipValue = "";

		// idempresa
		$this->idempresa->LinkCustomAttributes = "";
		$this->idempresa->HrefValue = "";
		$this->idempresa->TooltipValue = "";

		// urlstreetview
		$this->urlstreetview->LinkCustomAttributes = "";
		$this->urlstreetview->HrefValue = "";
		$this->urlstreetview->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id_producto
		$this->id_producto->EditAttrs["class"] = "form-control";
		$this->id_producto->EditCustomAttributes = "";
		$this->id_producto->EditValue = $this->id_producto->CurrentValue;
		$this->id_producto->ViewCustomAttributes = "";

		// codigo_producto
		$this->codigo_producto->EditAttrs["class"] = "form-control";
		$this->codigo_producto->EditCustomAttributes = "";
		if (!$this->codigo_producto->Raw)
			$this->codigo_producto->CurrentValue = HtmlDecode($this->codigo_producto->CurrentValue);
		$this->codigo_producto->EditValue = $this->codigo_producto->CurrentValue;
		$this->codigo_producto->PlaceHolder = RemoveHtml($this->codigo_producto->caption());

		// nombre_producto
		$this->nombre_producto->EditAttrs["class"] = "form-control";
		$this->nombre_producto->EditCustomAttributes = "";
		$this->nombre_producto->EditValue = $this->nombre_producto->CurrentValue;
		$this->nombre_producto->PlaceHolder = RemoveHtml($this->nombre_producto->caption());

		// estado
		$this->estado->EditAttrs["class"] = "form-control";
		$this->estado->EditCustomAttributes = "";
		$this->estado->EditValue = $this->estado->CurrentValue;
		$this->estado->PlaceHolder = RemoveHtml($this->estado->caption());

		// status_producto
		$this->status_producto->EditAttrs["class"] = "form-control";
		$this->status_producto->EditCustomAttributes = "";
		$this->status_producto->EditValue = $this->status_producto->CurrentValue;
		$this->status_producto->PlaceHolder = RemoveHtml($this->status_producto->caption());

		// date_added
		$this->date_added->EditAttrs["class"] = "form-control";
		$this->date_added->EditCustomAttributes = "";
		$this->date_added->EditValue = FormatDateTime($this->date_added->CurrentValue, 8);
		$this->date_added->PlaceHolder = RemoveHtml($this->date_added->caption());

		// precio_producto
		$this->precio_producto->EditAttrs["class"] = "form-control";
		$this->precio_producto->EditCustomAttributes = "";
		$this->precio_producto->EditValue = $this->precio_producto->CurrentValue;
		$this->precio_producto->PlaceHolder = RemoveHtml($this->precio_producto->caption());
		if (strval($this->precio_producto->EditValue) != "" && is_numeric($this->precio_producto->EditValue))
			$this->precio_producto->EditValue = FormatNumber($this->precio_producto->EditValue, -2, -2, -2, -2);
		

		// costo_producto
		$this->costo_producto->EditAttrs["class"] = "form-control";
		$this->costo_producto->EditCustomAttributes = "";
		$this->costo_producto->EditValue = $this->costo_producto->CurrentValue;
		$this->costo_producto->PlaceHolder = RemoveHtml($this->costo_producto->caption());
		if (strval($this->costo_producto->EditValue) != "" && is_numeric($this->costo_producto->EditValue))
			$this->costo_producto->EditValue = FormatNumber($this->costo_producto->EditValue, -2, -2, -2, -2);
		

		// mon_costo
		$this->mon_costo->EditAttrs["class"] = "form-control";
		$this->mon_costo->EditCustomAttributes = "";
		$this->mon_costo->EditValue = $this->mon_costo->CurrentValue;
		$this->mon_costo->PlaceHolder = RemoveHtml($this->mon_costo->caption());
		if (strval($this->mon_costo->EditValue) != "" && is_numeric($this->mon_costo->EditValue))
			$this->mon_costo->EditValue = FormatNumber($this->mon_costo->EditValue, -2, -2, -2, -2);
		

		// mon_venta
		$this->mon_venta->EditAttrs["class"] = "form-control";
		$this->mon_venta->EditCustomAttributes = "";
		$this->mon_venta->EditValue = $this->mon_venta->CurrentValue;
		$this->mon_venta->PlaceHolder = RemoveHtml($this->mon_venta->caption());

		// pais
		$this->pais->EditAttrs["class"] = "form-control";
		$this->pais->EditCustomAttributes = "";
		if (!$this->pais->Raw)
			$this->pais->CurrentValue = HtmlDecode($this->pais->CurrentValue);
		$this->pais->EditValue = $this->pais->CurrentValue;
		$this->pais->PlaceHolder = RemoveHtml($this->pais->caption());

		// departamento
		$this->departamento->EditAttrs["class"] = "form-control";
		$this->departamento->EditCustomAttributes = "";
		if (!$this->departamento->Raw)
			$this->departamento->CurrentValue = HtmlDecode($this->departamento->CurrentValue);
		$this->departamento->EditValue = $this->departamento->CurrentValue;
		$this->departamento->PlaceHolder = RemoveHtml($this->departamento->caption());

		// distrito
		$this->distrito->EditAttrs["class"] = "form-control";
		$this->distrito->EditCustomAttributes = "";
		if (!$this->distrito->Raw)
			$this->distrito->CurrentValue = HtmlDecode($this->distrito->CurrentValue);
		$this->distrito->EditValue = $this->distrito->CurrentValue;
		$this->distrito->PlaceHolder = RemoveHtml($this->distrito->caption());

		// localidad
		$this->localidad->EditAttrs["class"] = "form-control";
		$this->localidad->EditCustomAttributes = "";
		if (!$this->localidad->Raw)
			$this->localidad->CurrentValue = HtmlDecode($this->localidad->CurrentValue);
		$this->localidad->EditValue = $this->localidad->CurrentValue;
		$this->localidad->PlaceHolder = RemoveHtml($this->localidad->caption());

		// zona
		$this->zona->EditAttrs["class"] = "form-control";
		$this->zona->EditCustomAttributes = "";
		if (!$this->zona->Raw)
			$this->zona->CurrentValue = HtmlDecode($this->zona->CurrentValue);
		$this->zona->EditValue = $this->zona->CurrentValue;
		$this->zona->PlaceHolder = RemoveHtml($this->zona->caption());

		// tipo_inmueble
		$this->tipo_inmueble->EditAttrs["class"] = "form-control";
		$this->tipo_inmueble->EditCustomAttributes = "";
		$this->tipo_inmueble->EditValue = $this->tipo_inmueble->CurrentValue;
		$this->tipo_inmueble->PlaceHolder = RemoveHtml($this->tipo_inmueble->caption());

		// tipo_negocio
		$this->tipo_negocio->EditAttrs["class"] = "form-control";
		$this->tipo_negocio->EditCustomAttributes = "";
		if (!$this->tipo_negocio->Raw)
			$this->tipo_negocio->CurrentValue = HtmlDecode($this->tipo_negocio->CurrentValue);
		$this->tipo_negocio->EditValue = $this->tipo_negocio->CurrentValue;
		$this->tipo_negocio->PlaceHolder = RemoveHtml($this->tipo_negocio->caption());

		// tiempo_alquiler
		$this->tiempo_alquiler->EditAttrs["class"] = "form-control";
		$this->tiempo_alquiler->EditCustomAttributes = "";
		if (!$this->tiempo_alquiler->Raw)
			$this->tiempo_alquiler->CurrentValue = HtmlDecode($this->tiempo_alquiler->CurrentValue);
		$this->tiempo_alquiler->EditValue = $this->tiempo_alquiler->CurrentValue;
		$this->tiempo_alquiler->PlaceHolder = RemoveHtml($this->tiempo_alquiler->caption());

		// moneda
		$this->moneda->EditAttrs["class"] = "form-control";
		$this->moneda->EditCustomAttributes = "";
		if (!$this->moneda->Raw)
			$this->moneda->CurrentValue = HtmlDecode($this->moneda->CurrentValue);
		$this->moneda->EditValue = $this->moneda->CurrentValue;
		$this->moneda->PlaceHolder = RemoveHtml($this->moneda->caption());

		// estado_inmueble
		$this->estado_inmueble->EditAttrs["class"] = "form-control";
		$this->estado_inmueble->EditCustomAttributes = "";
		if (!$this->estado_inmueble->Raw)
			$this->estado_inmueble->CurrentValue = HtmlDecode($this->estado_inmueble->CurrentValue);
		$this->estado_inmueble->EditValue = $this->estado_inmueble->CurrentValue;
		$this->estado_inmueble->PlaceHolder = RemoveHtml($this->estado_inmueble->caption());

		// area_construida
		$this->area_construida->EditAttrs["class"] = "form-control";
		$this->area_construida->EditCustomAttributes = "";
		if (!$this->area_construida->Raw)
			$this->area_construida->CurrentValue = HtmlDecode($this->area_construida->CurrentValue);
		$this->area_construida->EditValue = $this->area_construida->CurrentValue;
		$this->area_construida->PlaceHolder = RemoveHtml($this->area_construida->caption());

		// area_privada
		$this->area_privada->EditAttrs["class"] = "form-control";
		$this->area_privada->EditCustomAttributes = "";
		if (!$this->area_privada->Raw)
			$this->area_privada->CurrentValue = HtmlDecode($this->area_privada->CurrentValue);
		$this->area_privada->EditValue = $this->area_privada->CurrentValue;
		$this->area_privada->PlaceHolder = RemoveHtml($this->area_privada->caption());

		// area_terreno
		$this->area_terreno->EditAttrs["class"] = "form-control";
		$this->area_terreno->EditCustomAttributes = "";
		if (!$this->area_terreno->Raw)
			$this->area_terreno->CurrentValue = HtmlDecode($this->area_terreno->CurrentValue);
		$this->area_terreno->EditValue = $this->area_terreno->CurrentValue;
		$this->area_terreno->PlaceHolder = RemoveHtml($this->area_terreno->caption());

		// valor_administracion
		$this->valor_administracion->EditAttrs["class"] = "form-control";
		$this->valor_administracion->EditCustomAttributes = "";
		if (!$this->valor_administracion->Raw)
			$this->valor_administracion->CurrentValue = HtmlDecode($this->valor_administracion->CurrentValue);
		$this->valor_administracion->EditValue = $this->valor_administracion->CurrentValue;
		$this->valor_administracion->PlaceHolder = RemoveHtml($this->valor_administracion->caption());

		// dormitorios
		$this->dormitorios->EditAttrs["class"] = "form-control";
		$this->dormitorios->EditCustomAttributes = "";
		if (!$this->dormitorios->Raw)
			$this->dormitorios->CurrentValue = HtmlDecode($this->dormitorios->CurrentValue);
		$this->dormitorios->EditValue = $this->dormitorios->CurrentValue;
		$this->dormitorios->PlaceHolder = RemoveHtml($this->dormitorios->caption());

		// banios
		$this->banios->EditAttrs["class"] = "form-control";
		$this->banios->EditCustomAttributes = "";
		if (!$this->banios->Raw)
			$this->banios->CurrentValue = HtmlDecode($this->banios->CurrentValue);
		$this->banios->EditValue = $this->banios->CurrentValue;
		$this->banios->PlaceHolder = RemoveHtml($this->banios->caption());

		// garaje
		$this->garaje->EditAttrs["class"] = "form-control";
		$this->garaje->EditCustomAttributes = "";
		if (!$this->garaje->Raw)
			$this->garaje->CurrentValue = HtmlDecode($this->garaje->CurrentValue);
		$this->garaje->EditValue = $this->garaje->CurrentValue;
		$this->garaje->PlaceHolder = RemoveHtml($this->garaje->caption());

		// piso
		$this->piso->EditAttrs["class"] = "form-control";
		$this->piso->EditCustomAttributes = "";
		if (!$this->piso->Raw)
			$this->piso->CurrentValue = HtmlDecode($this->piso->CurrentValue);
		$this->piso->EditValue = $this->piso->CurrentValue;
		$this->piso->PlaceHolder = RemoveHtml($this->piso->caption());

		// estrato
		$this->estrato->EditAttrs["class"] = "form-control";
		$this->estrato->EditCustomAttributes = "";
		if (!$this->estrato->Raw)
			$this->estrato->CurrentValue = HtmlDecode($this->estrato->CurrentValue);
		$this->estrato->EditValue = $this->estrato->CurrentValue;
		$this->estrato->PlaceHolder = RemoveHtml($this->estrato->caption());

		// direccion
		$this->direccion->EditAttrs["class"] = "form-control";
		$this->direccion->EditCustomAttributes = "";
		$this->direccion->EditValue = $this->direccion->CurrentValue;
		$this->direccion->PlaceHolder = RemoveHtml($this->direccion->caption());

		// codigo_postal
		$this->codigo_postal->EditAttrs["class"] = "form-control";
		$this->codigo_postal->EditCustomAttributes = "";
		if (!$this->codigo_postal->Raw)
			$this->codigo_postal->CurrentValue = HtmlDecode($this->codigo_postal->CurrentValue);
		$this->codigo_postal->EditValue = $this->codigo_postal->CurrentValue;
		$this->codigo_postal->PlaceHolder = RemoveHtml($this->codigo_postal->caption());

		// mapa
		$this->mapa->EditAttrs["class"] = "form-control";
		$this->mapa->EditCustomAttributes = "";
		if (!$this->mapa->Raw)
			$this->mapa->CurrentValue = HtmlDecode($this->mapa->CurrentValue);
		$this->mapa->EditValue = $this->mapa->CurrentValue;
		$this->mapa->PlaceHolder = RemoveHtml($this->mapa->caption());

		// latitud
		$this->latitud->EditAttrs["class"] = "form-control";
		$this->latitud->EditCustomAttributes = "";
		if (!$this->latitud->Raw)
			$this->latitud->CurrentValue = HtmlDecode($this->latitud->CurrentValue);
		$this->latitud->EditValue = $this->latitud->CurrentValue;
		$this->latitud->PlaceHolder = RemoveHtml($this->latitud->caption());

		// longitud
		$this->longitud->EditAttrs["class"] = "form-control";
		$this->longitud->EditCustomAttributes = "";
		if (!$this->longitud->Raw)
			$this->longitud->CurrentValue = HtmlDecode($this->longitud->CurrentValue);
		$this->longitud->EditValue = $this->longitud->CurrentValue;
		$this->longitud->PlaceHolder = RemoveHtml($this->longitud->caption());

		// opciones_mapa
		$this->opciones_mapa->EditAttrs["class"] = "form-control";
		$this->opciones_mapa->EditCustomAttributes = "";
		if (!$this->opciones_mapa->Raw)
			$this->opciones_mapa->CurrentValue = HtmlDecode($this->opciones_mapa->CurrentValue);
		$this->opciones_mapa->EditValue = $this->opciones_mapa->CurrentValue;
		$this->opciones_mapa->PlaceHolder = RemoveHtml($this->opciones_mapa->caption());

		// red
		$this->red->EditAttrs["class"] = "form-control";
		$this->red->EditCustomAttributes = "";
		if (!$this->red->Raw)
			$this->red->CurrentValue = HtmlDecode($this->red->CurrentValue);
		$this->red->EditValue = $this->red->CurrentValue;
		$this->red->PlaceHolder = RemoveHtml($this->red->caption());

		// video
		$this->video->EditAttrs["class"] = "form-control";
		$this->video->EditCustomAttributes = "";
		$this->video->EditValue = $this->video->CurrentValue;
		$this->video->PlaceHolder = RemoveHtml($this->video->caption());

		// disponibilidad
		$this->disponibilidad->EditAttrs["class"] = "form-control";
		$this->disponibilidad->EditCustomAttributes = "";
		if (!$this->disponibilidad->Raw)
			$this->disponibilidad->CurrentValue = HtmlDecode($this->disponibilidad->CurrentValue);
		$this->disponibilidad->EditValue = $this->disponibilidad->CurrentValue;
		$this->disponibilidad->PlaceHolder = RemoveHtml($this->disponibilidad->caption());

		// anio_construccion
		$this->anio_construccion->EditAttrs["class"] = "form-control";
		$this->anio_construccion->EditCustomAttributes = "";
		if (!$this->anio_construccion->Raw)
			$this->anio_construccion->CurrentValue = HtmlDecode($this->anio_construccion->CurrentValue);
		$this->anio_construccion->EditValue = $this->anio_construccion->CurrentValue;
		$this->anio_construccion->PlaceHolder = RemoveHtml($this->anio_construccion->caption());

		// encargado
		$this->encargado->EditAttrs["class"] = "form-control";
		$this->encargado->EditCustomAttributes = "";
		if (!$this->encargado->Raw)
			$this->encargado->CurrentValue = HtmlDecode($this->encargado->CurrentValue);
		$this->encargado->EditValue = $this->encargado->CurrentValue;
		$this->encargado->PlaceHolder = RemoveHtml($this->encargado->caption());

		// comentario
		$this->comentario->EditAttrs["class"] = "form-control";
		$this->comentario->EditCustomAttributes = "";
		$this->comentario->EditValue = $this->comentario->CurrentValue;
		$this->comentario->PlaceHolder = RemoveHtml($this->comentario->caption());

		// visitas
		$this->visitas->EditAttrs["class"] = "form-control";
		$this->visitas->EditCustomAttributes = "";
		if (!$this->visitas->Raw)
			$this->visitas->CurrentValue = HtmlDecode($this->visitas->CurrentValue);
		$this->visitas->EditValue = $this->visitas->CurrentValue;
		$this->visitas->PlaceHolder = RemoveHtml($this->visitas->caption());

		// valor_comision
		$this->valor_comision->EditAttrs["class"] = "form-control";
		$this->valor_comision->EditCustomAttributes = "";
		$this->valor_comision->EditValue = $this->valor_comision->CurrentValue;
		$this->valor_comision->PlaceHolder = RemoveHtml($this->valor_comision->caption());
		if (strval($this->valor_comision->EditValue) != "" && is_numeric($this->valor_comision->EditValue))
			$this->valor_comision->EditValue = FormatNumber($this->valor_comision->EditValue, -2, -2, -2, -2);
		

		// tipo_comision
		$this->tipo_comision->EditAttrs["class"] = "form-control";
		$this->tipo_comision->EditCustomAttributes = "";
		if (!$this->tipo_comision->Raw)
			$this->tipo_comision->CurrentValue = HtmlDecode($this->tipo_comision->CurrentValue);
		$this->tipo_comision->EditValue = $this->tipo_comision->CurrentValue;
		$this->tipo_comision->PlaceHolder = RemoveHtml($this->tipo_comision->caption());

		// certificado
		$this->certificado->EditAttrs["class"] = "form-control";
		$this->certificado->EditCustomAttributes = "";
		if (!$this->certificado->Raw)
			$this->certificado->CurrentValue = HtmlDecode($this->certificado->CurrentValue);
		$this->certificado->EditValue = $this->certificado->CurrentValue;
		$this->certificado->PlaceHolder = RemoveHtml($this->certificado->caption());

		// nombre_propietario
		$this->nombre_propietario->EditAttrs["class"] = "form-control";
		$this->nombre_propietario->EditCustomAttributes = "";
		if (!$this->nombre_propietario->Raw)
			$this->nombre_propietario->CurrentValue = HtmlDecode($this->nombre_propietario->CurrentValue);
		$this->nombre_propietario->EditValue = $this->nombre_propietario->CurrentValue;
		$this->nombre_propietario->PlaceHolder = RemoveHtml($this->nombre_propietario->caption());

		// movil_propietario
		$this->movil_propietario->EditAttrs["class"] = "form-control";
		$this->movil_propietario->EditCustomAttributes = "";
		if (!$this->movil_propietario->Raw)
			$this->movil_propietario->CurrentValue = HtmlDecode($this->movil_propietario->CurrentValue);
		$this->movil_propietario->EditValue = $this->movil_propietario->CurrentValue;
		$this->movil_propietario->PlaceHolder = RemoveHtml($this->movil_propietario->caption());

		// telefono_propietario
		$this->telefono_propietario->EditAttrs["class"] = "form-control";
		$this->telefono_propietario->EditCustomAttributes = "";
		if (!$this->telefono_propietario->Raw)
			$this->telefono_propietario->CurrentValue = HtmlDecode($this->telefono_propietario->CurrentValue);
		$this->telefono_propietario->EditValue = $this->telefono_propietario->CurrentValue;
		$this->telefono_propietario->PlaceHolder = RemoveHtml($this->telefono_propietario->caption());

		// correo_propietario
		$this->correo_propietario->EditAttrs["class"] = "form-control";
		$this->correo_propietario->EditCustomAttributes = "";
		if (!$this->correo_propietario->Raw)
			$this->correo_propietario->CurrentValue = HtmlDecode($this->correo_propietario->CurrentValue);
		$this->correo_propietario->EditValue = $this->correo_propietario->CurrentValue;
		$this->correo_propietario->PlaceHolder = RemoveHtml($this->correo_propietario->caption());

		// vinculo
		$this->vinculo->EditAttrs["class"] = "form-control";
		$this->vinculo->EditCustomAttributes = "";
		if (!$this->vinculo->Raw)
			$this->vinculo->CurrentValue = HtmlDecode($this->vinculo->CurrentValue);
		$this->vinculo->EditValue = $this->vinculo->CurrentValue;
		$this->vinculo->PlaceHolder = RemoveHtml($this->vinculo->caption());

		// portales
		$this->portales->EditAttrs["class"] = "form-control";
		$this->portales->EditCustomAttributes = "";
		$this->portales->EditValue = $this->portales->CurrentValue;
		$this->portales->PlaceHolder = RemoveHtml($this->portales->caption());

		// notas
		$this->notas->EditAttrs["class"] = "form-control";
		$this->notas->EditCustomAttributes = "";
		if (!$this->notas->Raw)
			$this->notas->CurrentValue = HtmlDecode($this->notas->CurrentValue);
		$this->notas->EditValue = $this->notas->CurrentValue;
		$this->notas->PlaceHolder = RemoveHtml($this->notas->caption());

		// marca
		$this->marca->EditAttrs["class"] = "form-control";
		$this->marca->EditCustomAttributes = "";
		if (!$this->marca->Raw)
			$this->marca->CurrentValue = HtmlDecode($this->marca->CurrentValue);
		$this->marca->EditValue = $this->marca->CurrentValue;
		$this->marca->PlaceHolder = RemoveHtml($this->marca->caption());

		// modelo
		$this->modelo->EditAttrs["class"] = "form-control";
		$this->modelo->EditCustomAttributes = "";
		if (!$this->modelo->Raw)
			$this->modelo->CurrentValue = HtmlDecode($this->modelo->CurrentValue);
		$this->modelo->EditValue = $this->modelo->CurrentValue;
		$this->modelo->PlaceHolder = RemoveHtml($this->modelo->caption());

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		if (!$this->color->Raw)
			$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->PlaceHolder = RemoveHtml($this->color->caption());

		// b1
		$this->b1->EditAttrs["class"] = "form-control";
		$this->b1->EditCustomAttributes = "";
		$this->b1->EditValue = $this->b1->CurrentValue;
		$this->b1->PlaceHolder = RemoveHtml($this->b1->caption());
		if (strval($this->b1->EditValue) != "" && is_numeric($this->b1->EditValue))
			$this->b1->EditValue = FormatNumber($this->b1->EditValue, -2, -2, -2, -2);
		

		// b2
		$this->b2->EditAttrs["class"] = "form-control";
		$this->b2->EditCustomAttributes = "";
		$this->b2->EditValue = $this->b2->CurrentValue;
		$this->b2->PlaceHolder = RemoveHtml($this->b2->caption());
		if (strval($this->b2->EditValue) != "" && is_numeric($this->b2->EditValue))
			$this->b2->EditValue = FormatNumber($this->b2->EditValue, -2, -2, -2, -2);
		

		// b3
		$this->b3->EditAttrs["class"] = "form-control";
		$this->b3->EditCustomAttributes = "";
		$this->b3->EditValue = $this->b3->CurrentValue;
		$this->b3->PlaceHolder = RemoveHtml($this->b3->caption());
		if (strval($this->b3->EditValue) != "" && is_numeric($this->b3->EditValue))
			$this->b3->EditValue = FormatNumber($this->b3->EditValue, -2, -2, -2, -2);
		

		// b4
		$this->b4->EditAttrs["class"] = "form-control";
		$this->b4->EditCustomAttributes = "";
		$this->b4->EditValue = $this->b4->CurrentValue;
		$this->b4->PlaceHolder = RemoveHtml($this->b4->caption());
		if (strval($this->b4->EditValue) != "" && is_numeric($this->b4->EditValue))
			$this->b4->EditValue = FormatNumber($this->b4->EditValue, -2, -2, -2, -2);
		

		// b5
		$this->b5->EditAttrs["class"] = "form-control";
		$this->b5->EditCustomAttributes = "";
		$this->b5->EditValue = $this->b5->CurrentValue;
		$this->b5->PlaceHolder = RemoveHtml($this->b5->caption());
		if (strval($this->b5->EditValue) != "" && is_numeric($this->b5->EditValue))
			$this->b5->EditValue = FormatNumber($this->b5->EditValue, -2, -2, -2, -2);
		

		// b6
		$this->b6->EditAttrs["class"] = "form-control";
		$this->b6->EditCustomAttributes = "";
		$this->b6->EditValue = $this->b6->CurrentValue;
		$this->b6->PlaceHolder = RemoveHtml($this->b6->caption());
		if (strval($this->b6->EditValue) != "" && is_numeric($this->b6->EditValue))
			$this->b6->EditValue = FormatNumber($this->b6->EditValue, -2, -2, -2, -2);
		

		// cat_pro
		$this->cat_pro->EditAttrs["class"] = "form-control";
		$this->cat_pro->EditCustomAttributes = "";
		$this->cat_pro->EditValue = $this->cat_pro->CurrentValue;
		$this->cat_pro->PlaceHolder = RemoveHtml($this->cat_pro->caption());

		// pro_ser
		$this->pro_ser->EditAttrs["class"] = "form-control";
		$this->pro_ser->EditCustomAttributes = "";
		$this->pro_ser->EditValue = $this->pro_ser->CurrentValue;
		$this->pro_ser->PlaceHolder = RemoveHtml($this->pro_ser->caption());

		// foto1
		$this->foto1->EditAttrs["class"] = "form-control";
		$this->foto1->EditCustomAttributes = "";
		$this->foto1->EditValue = $this->foto1->CurrentValue;
		$this->foto1->PlaceHolder = RemoveHtml($this->foto1->caption());

		// foto2
		$this->foto2->EditAttrs["class"] = "form-control";
		$this->foto2->EditCustomAttributes = "";
		if (!$this->foto2->Raw)
			$this->foto2->CurrentValue = HtmlDecode($this->foto2->CurrentValue);
		$this->foto2->EditValue = $this->foto2->CurrentValue;
		$this->foto2->PlaceHolder = RemoveHtml($this->foto2->caption());

		// foto3
		$this->foto3->EditAttrs["class"] = "form-control";
		$this->foto3->EditCustomAttributes = "";
		if (!$this->foto3->Raw)
			$this->foto3->CurrentValue = HtmlDecode($this->foto3->CurrentValue);
		$this->foto3->EditValue = $this->foto3->CurrentValue;
		$this->foto3->PlaceHolder = RemoveHtml($this->foto3->caption());

		// foto4
		$this->foto4->EditAttrs["class"] = "form-control";
		$this->foto4->EditCustomAttributes = "";
		if (!$this->foto4->Raw)
			$this->foto4->CurrentValue = HtmlDecode($this->foto4->CurrentValue);
		$this->foto4->EditValue = $this->foto4->CurrentValue;
		$this->foto4->PlaceHolder = RemoveHtml($this->foto4->caption());

		// web
		$this->web->EditAttrs["class"] = "form-control";
		$this->web->EditCustomAttributes = "";
		$this->web->EditValue = $this->web->CurrentValue;
		$this->web->PlaceHolder = RemoveHtml($this->web->caption());

		// pre_web
		$this->pre_web->EditAttrs["class"] = "form-control";
		$this->pre_web->EditCustomAttributes = "";
		$this->pre_web->EditValue = $this->pre_web->CurrentValue;
		$this->pre_web->PlaceHolder = RemoveHtml($this->pre_web->caption());
		if (strval($this->pre_web->EditValue) != "" && is_numeric($this->pre_web->EditValue))
			$this->pre_web->EditValue = FormatNumber($this->pre_web->EditValue, -2, -2, -2, -2);
		

		// descripcion
		$this->descripcion->EditAttrs["class"] = "form-control";
		$this->descripcion->EditCustomAttributes = "";
		$this->descripcion->EditValue = $this->descripcion->CurrentValue;
		$this->descripcion->PlaceHolder = RemoveHtml($this->descripcion->caption());

		// descripcion1
		$this->descripcion1->EditAttrs["class"] = "form-control";
		$this->descripcion1->EditCustomAttributes = "";
		$this->descripcion1->EditValue = $this->descripcion1->CurrentValue;
		$this->descripcion1->PlaceHolder = RemoveHtml($this->descripcion1->caption());

		// megusta
		$this->megusta->EditAttrs["class"] = "form-control";
		$this->megusta->EditCustomAttributes = "";
		$this->megusta->EditValue = $this->megusta->CurrentValue;
		$this->megusta->PlaceHolder = RemoveHtml($this->megusta->caption());

		// nomegusta
		$this->nomegusta->EditAttrs["class"] = "form-control";
		$this->nomegusta->EditCustomAttributes = "";
		$this->nomegusta->EditValue = $this->nomegusta->CurrentValue;
		$this->nomegusta->PlaceHolder = RemoveHtml($this->nomegusta->caption());

		// precio2
		$this->precio2->EditAttrs["class"] = "form-control";
		$this->precio2->EditCustomAttributes = "";
		$this->precio2->EditValue = $this->precio2->CurrentValue;
		$this->precio2->PlaceHolder = RemoveHtml($this->precio2->caption());
		if (strval($this->precio2->EditValue) != "" && is_numeric($this->precio2->EditValue))
			$this->precio2->EditValue = FormatNumber($this->precio2->EditValue, -2, -2, -2, -2);
		

		// precio3
		$this->precio3->EditAttrs["class"] = "form-control";
		$this->precio3->EditCustomAttributes = "";
		$this->precio3->EditValue = $this->precio3->CurrentValue;
		$this->precio3->PlaceHolder = RemoveHtml($this->precio3->caption());
		if (strval($this->precio3->EditValue) != "" && is_numeric($this->precio3->EditValue))
			$this->precio3->EditValue = FormatNumber($this->precio3->EditValue, -2, -2, -2, -2);
		

		// und_pro
		$this->und_pro->EditAttrs["class"] = "form-control";
		$this->und_pro->EditCustomAttributes = "";
		$this->und_pro->EditValue = $this->und_pro->CurrentValue;
		$this->und_pro->PlaceHolder = RemoveHtml($this->und_pro->caption());

		// barras
		$this->barras->EditAttrs["class"] = "form-control";
		$this->barras->EditCustomAttributes = "";
		if (!$this->barras->Raw)
			$this->barras->CurrentValue = HtmlDecode($this->barras->CurrentValue);
		$this->barras->EditValue = $this->barras->CurrentValue;
		$this->barras->PlaceHolder = RemoveHtml($this->barras->caption());

		// stockmin
		$this->stockmin->EditAttrs["class"] = "form-control";
		$this->stockmin->EditCustomAttributes = "";
		$this->stockmin->EditValue = $this->stockmin->CurrentValue;
		$this->stockmin->PlaceHolder = RemoveHtml($this->stockmin->caption());
		if (strval($this->stockmin->EditValue) != "" && is_numeric($this->stockmin->EditValue))
			$this->stockmin->EditValue = FormatNumber($this->stockmin->EditValue, -2, -2, -2, -2);
		

		// id_grupo
		$this->id_grupo->EditAttrs["class"] = "form-control";
		$this->id_grupo->EditCustomAttributes = "";
		$this->id_grupo->EditValue = $this->id_grupo->CurrentValue;
		$this->id_grupo->PlaceHolder = RemoveHtml($this->id_grupo->caption());

		// talla
		$this->talla->EditAttrs["class"] = "form-control";
		$this->talla->EditCustomAttributes = "";
		if (!$this->talla->Raw)
			$this->talla->CurrentValue = HtmlDecode($this->talla->CurrentValue);
		$this->talla->EditValue = $this->talla->CurrentValue;
		$this->talla->PlaceHolder = RemoveHtml($this->talla->caption());

		// mostrarcolor
		$this->mostrarcolor->EditAttrs["class"] = "form-control";
		$this->mostrarcolor->EditCustomAttributes = "";
		$this->mostrarcolor->EditValue = $this->mostrarcolor->CurrentValue;
		$this->mostrarcolor->PlaceHolder = RemoveHtml($this->mostrarcolor->caption());

		// precio_mayorista
		$this->precio_mayorista->EditAttrs["class"] = "form-control";
		$this->precio_mayorista->EditCustomAttributes = "";
		$this->precio_mayorista->EditValue = $this->precio_mayorista->CurrentValue;
		$this->precio_mayorista->PlaceHolder = RemoveHtml($this->precio_mayorista->caption());
		if (strval($this->precio_mayorista->EditValue) != "" && is_numeric($this->precio_mayorista->EditValue))
			$this->precio_mayorista->EditValue = FormatNumber($this->precio_mayorista->EditValue, -2, -2, -2, -2);
		

		// precio_vendedor
		$this->precio_vendedor->EditAttrs["class"] = "form-control";
		$this->precio_vendedor->EditCustomAttributes = "";
		$this->precio_vendedor->EditValue = $this->precio_vendedor->CurrentValue;
		$this->precio_vendedor->PlaceHolder = RemoveHtml($this->precio_vendedor->caption());
		if (strval($this->precio_vendedor->EditValue) != "" && is_numeric($this->precio_vendedor->EditValue))
			$this->precio_vendedor->EditValue = FormatNumber($this->precio_vendedor->EditValue, -2, -2, -2, -2);
		

		// medida1
		$this->medida1->EditAttrs["class"] = "form-control";
		$this->medida1->EditCustomAttributes = "";
		if (!$this->medida1->Raw)
			$this->medida1->CurrentValue = HtmlDecode($this->medida1->CurrentValue);
		$this->medida1->EditValue = $this->medida1->CurrentValue;
		$this->medida1->PlaceHolder = RemoveHtml($this->medida1->caption());

		// medida2
		$this->medida2->EditAttrs["class"] = "form-control";
		$this->medida2->EditCustomAttributes = "";
		if (!$this->medida2->Raw)
			$this->medida2->CurrentValue = HtmlDecode($this->medida2->CurrentValue);
		$this->medida2->EditValue = $this->medida2->CurrentValue;
		$this->medida2->PlaceHolder = RemoveHtml($this->medida2->caption());

		// medida3
		$this->medida3->EditAttrs["class"] = "form-control";
		$this->medida3->EditCustomAttributes = "";
		if (!$this->medida3->Raw)
			$this->medida3->CurrentValue = HtmlDecode($this->medida3->CurrentValue);
		$this->medida3->EditValue = $this->medida3->CurrentValue;
		$this->medida3->PlaceHolder = RemoveHtml($this->medida3->caption());

		// codlogin
		$this->codlogin->EditAttrs["class"] = "form-control";
		$this->codlogin->EditCustomAttributes = "";
		if (!$this->codlogin->Raw)
			$this->codlogin->CurrentValue = HtmlDecode($this->codlogin->CurrentValue);
		$this->codlogin->EditValue = $this->codlogin->CurrentValue;
		$this->codlogin->PlaceHolder = RemoveHtml($this->codlogin->caption());

		// idempresa
		$this->idempresa->EditAttrs["class"] = "form-control";
		$this->idempresa->EditCustomAttributes = "";
		$this->idempresa->EditValue = $this->idempresa->CurrentValue;
		$this->idempresa->PlaceHolder = RemoveHtml($this->idempresa->caption());

		// urlstreetview
		$this->urlstreetview->EditAttrs["class"] = "form-control";
		$this->urlstreetview->EditCustomAttributes = "";
		if (!$this->urlstreetview->Raw)
			$this->urlstreetview->CurrentValue = HtmlDecode($this->urlstreetview->CurrentValue);
		$this->urlstreetview->EditValue = $this->urlstreetview->CurrentValue;
		$this->urlstreetview->PlaceHolder = RemoveHtml($this->urlstreetview->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->codigo_producto);
					$doc->exportCaption($this->nombre_producto);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->status_producto);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->precio_producto);
					$doc->exportCaption($this->costo_producto);
					$doc->exportCaption($this->mon_costo);
					$doc->exportCaption($this->mon_venta);
					$doc->exportCaption($this->pais);
					$doc->exportCaption($this->departamento);
					$doc->exportCaption($this->distrito);
					$doc->exportCaption($this->localidad);
					$doc->exportCaption($this->zona);
					$doc->exportCaption($this->tipo_inmueble);
					$doc->exportCaption($this->tipo_negocio);
					$doc->exportCaption($this->tiempo_alquiler);
					$doc->exportCaption($this->moneda);
					$doc->exportCaption($this->estado_inmueble);
					$doc->exportCaption($this->area_construida);
					$doc->exportCaption($this->area_privada);
					$doc->exportCaption($this->area_terreno);
					$doc->exportCaption($this->valor_administracion);
					$doc->exportCaption($this->dormitorios);
					$doc->exportCaption($this->banios);
					$doc->exportCaption($this->garaje);
					$doc->exportCaption($this->piso);
					$doc->exportCaption($this->estrato);
					$doc->exportCaption($this->direccion);
					$doc->exportCaption($this->codigo_postal);
					$doc->exportCaption($this->mapa);
					$doc->exportCaption($this->latitud);
					$doc->exportCaption($this->longitud);
					$doc->exportCaption($this->opciones_mapa);
					$doc->exportCaption($this->red);
					$doc->exportCaption($this->video);
					$doc->exportCaption($this->disponibilidad);
					$doc->exportCaption($this->anio_construccion);
					$doc->exportCaption($this->encargado);
					$doc->exportCaption($this->comentario);
					$doc->exportCaption($this->visitas);
					$doc->exportCaption($this->valor_comision);
					$doc->exportCaption($this->tipo_comision);
					$doc->exportCaption($this->certificado);
					$doc->exportCaption($this->nombre_propietario);
					$doc->exportCaption($this->movil_propietario);
					$doc->exportCaption($this->telefono_propietario);
					$doc->exportCaption($this->correo_propietario);
					$doc->exportCaption($this->vinculo);
					$doc->exportCaption($this->portales);
					$doc->exportCaption($this->notas);
					$doc->exportCaption($this->marca);
					$doc->exportCaption($this->modelo);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->b1);
					$doc->exportCaption($this->b2);
					$doc->exportCaption($this->b3);
					$doc->exportCaption($this->b4);
					$doc->exportCaption($this->b5);
					$doc->exportCaption($this->b6);
					$doc->exportCaption($this->cat_pro);
					$doc->exportCaption($this->pro_ser);
					$doc->exportCaption($this->foto1);
					$doc->exportCaption($this->foto2);
					$doc->exportCaption($this->foto3);
					$doc->exportCaption($this->foto4);
					$doc->exportCaption($this->web);
					$doc->exportCaption($this->pre_web);
					$doc->exportCaption($this->descripcion);
					$doc->exportCaption($this->descripcion1);
					$doc->exportCaption($this->megusta);
					$doc->exportCaption($this->nomegusta);
					$doc->exportCaption($this->precio2);
					$doc->exportCaption($this->precio3);
					$doc->exportCaption($this->und_pro);
					$doc->exportCaption($this->barras);
					$doc->exportCaption($this->stockmin);
					$doc->exportCaption($this->id_grupo);
					$doc->exportCaption($this->talla);
					$doc->exportCaption($this->mostrarcolor);
					$doc->exportCaption($this->precio_mayorista);
					$doc->exportCaption($this->precio_vendedor);
					$doc->exportCaption($this->medida1);
					$doc->exportCaption($this->medida2);
					$doc->exportCaption($this->medida3);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->urlstreetview);
				} else {
					$doc->exportCaption($this->id_producto);
					$doc->exportCaption($this->codigo_producto);
					$doc->exportCaption($this->estado);
					$doc->exportCaption($this->status_producto);
					$doc->exportCaption($this->date_added);
					$doc->exportCaption($this->precio_producto);
					$doc->exportCaption($this->costo_producto);
					$doc->exportCaption($this->mon_costo);
					$doc->exportCaption($this->mon_venta);
					$doc->exportCaption($this->pais);
					$doc->exportCaption($this->departamento);
					$doc->exportCaption($this->distrito);
					$doc->exportCaption($this->localidad);
					$doc->exportCaption($this->zona);
					$doc->exportCaption($this->tipo_inmueble);
					$doc->exportCaption($this->tipo_negocio);
					$doc->exportCaption($this->tiempo_alquiler);
					$doc->exportCaption($this->moneda);
					$doc->exportCaption($this->estado_inmueble);
					$doc->exportCaption($this->area_construida);
					$doc->exportCaption($this->area_privada);
					$doc->exportCaption($this->area_terreno);
					$doc->exportCaption($this->valor_administracion);
					$doc->exportCaption($this->dormitorios);
					$doc->exportCaption($this->banios);
					$doc->exportCaption($this->garaje);
					$doc->exportCaption($this->piso);
					$doc->exportCaption($this->estrato);
					$doc->exportCaption($this->codigo_postal);
					$doc->exportCaption($this->mapa);
					$doc->exportCaption($this->latitud);
					$doc->exportCaption($this->longitud);
					$doc->exportCaption($this->opciones_mapa);
					$doc->exportCaption($this->red);
					$doc->exportCaption($this->disponibilidad);
					$doc->exportCaption($this->anio_construccion);
					$doc->exportCaption($this->encargado);
					$doc->exportCaption($this->visitas);
					$doc->exportCaption($this->valor_comision);
					$doc->exportCaption($this->tipo_comision);
					$doc->exportCaption($this->certificado);
					$doc->exportCaption($this->nombre_propietario);
					$doc->exportCaption($this->movil_propietario);
					$doc->exportCaption($this->telefono_propietario);
					$doc->exportCaption($this->correo_propietario);
					$doc->exportCaption($this->vinculo);
					$doc->exportCaption($this->notas);
					$doc->exportCaption($this->marca);
					$doc->exportCaption($this->modelo);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->b1);
					$doc->exportCaption($this->b2);
					$doc->exportCaption($this->b3);
					$doc->exportCaption($this->b4);
					$doc->exportCaption($this->b5);
					$doc->exportCaption($this->b6);
					$doc->exportCaption($this->cat_pro);
					$doc->exportCaption($this->pro_ser);
					$doc->exportCaption($this->foto2);
					$doc->exportCaption($this->foto3);
					$doc->exportCaption($this->foto4);
					$doc->exportCaption($this->web);
					$doc->exportCaption($this->pre_web);
					$doc->exportCaption($this->megusta);
					$doc->exportCaption($this->nomegusta);
					$doc->exportCaption($this->precio2);
					$doc->exportCaption($this->precio3);
					$doc->exportCaption($this->und_pro);
					$doc->exportCaption($this->barras);
					$doc->exportCaption($this->stockmin);
					$doc->exportCaption($this->id_grupo);
					$doc->exportCaption($this->talla);
					$doc->exportCaption($this->mostrarcolor);
					$doc->exportCaption($this->precio_mayorista);
					$doc->exportCaption($this->precio_vendedor);
					$doc->exportCaption($this->medida1);
					$doc->exportCaption($this->medida2);
					$doc->exportCaption($this->medida3);
					$doc->exportCaption($this->codlogin);
					$doc->exportCaption($this->idempresa);
					$doc->exportCaption($this->urlstreetview);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id_producto);
						$doc->exportField($this->codigo_producto);
						$doc->exportField($this->nombre_producto);
						$doc->exportField($this->estado);
						$doc->exportField($this->status_producto);
						$doc->exportField($this->date_added);
						$doc->exportField($this->precio_producto);
						$doc->exportField($this->costo_producto);
						$doc->exportField($this->mon_costo);
						$doc->exportField($this->mon_venta);
						$doc->exportField($this->pais);
						$doc->exportField($this->departamento);
						$doc->exportField($this->distrito);
						$doc->exportField($this->localidad);
						$doc->exportField($this->zona);
						$doc->exportField($this->tipo_inmueble);
						$doc->exportField($this->tipo_negocio);
						$doc->exportField($this->tiempo_alquiler);
						$doc->exportField($this->moneda);
						$doc->exportField($this->estado_inmueble);
						$doc->exportField($this->area_construida);
						$doc->exportField($this->area_privada);
						$doc->exportField($this->area_terreno);
						$doc->exportField($this->valor_administracion);
						$doc->exportField($this->dormitorios);
						$doc->exportField($this->banios);
						$doc->exportField($this->garaje);
						$doc->exportField($this->piso);
						$doc->exportField($this->estrato);
						$doc->exportField($this->direccion);
						$doc->exportField($this->codigo_postal);
						$doc->exportField($this->mapa);
						$doc->exportField($this->latitud);
						$doc->exportField($this->longitud);
						$doc->exportField($this->opciones_mapa);
						$doc->exportField($this->red);
						$doc->exportField($this->video);
						$doc->exportField($this->disponibilidad);
						$doc->exportField($this->anio_construccion);
						$doc->exportField($this->encargado);
						$doc->exportField($this->comentario);
						$doc->exportField($this->visitas);
						$doc->exportField($this->valor_comision);
						$doc->exportField($this->tipo_comision);
						$doc->exportField($this->certificado);
						$doc->exportField($this->nombre_propietario);
						$doc->exportField($this->movil_propietario);
						$doc->exportField($this->telefono_propietario);
						$doc->exportField($this->correo_propietario);
						$doc->exportField($this->vinculo);
						$doc->exportField($this->portales);
						$doc->exportField($this->notas);
						$doc->exportField($this->marca);
						$doc->exportField($this->modelo);
						$doc->exportField($this->color);
						$doc->exportField($this->b1);
						$doc->exportField($this->b2);
						$doc->exportField($this->b3);
						$doc->exportField($this->b4);
						$doc->exportField($this->b5);
						$doc->exportField($this->b6);
						$doc->exportField($this->cat_pro);
						$doc->exportField($this->pro_ser);
						$doc->exportField($this->foto1);
						$doc->exportField($this->foto2);
						$doc->exportField($this->foto3);
						$doc->exportField($this->foto4);
						$doc->exportField($this->web);
						$doc->exportField($this->pre_web);
						$doc->exportField($this->descripcion);
						$doc->exportField($this->descripcion1);
						$doc->exportField($this->megusta);
						$doc->exportField($this->nomegusta);
						$doc->exportField($this->precio2);
						$doc->exportField($this->precio3);
						$doc->exportField($this->und_pro);
						$doc->exportField($this->barras);
						$doc->exportField($this->stockmin);
						$doc->exportField($this->id_grupo);
						$doc->exportField($this->talla);
						$doc->exportField($this->mostrarcolor);
						$doc->exportField($this->precio_mayorista);
						$doc->exportField($this->precio_vendedor);
						$doc->exportField($this->medida1);
						$doc->exportField($this->medida2);
						$doc->exportField($this->medida3);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->urlstreetview);
					} else {
						$doc->exportField($this->id_producto);
						$doc->exportField($this->codigo_producto);
						$doc->exportField($this->estado);
						$doc->exportField($this->status_producto);
						$doc->exportField($this->date_added);
						$doc->exportField($this->precio_producto);
						$doc->exportField($this->costo_producto);
						$doc->exportField($this->mon_costo);
						$doc->exportField($this->mon_venta);
						$doc->exportField($this->pais);
						$doc->exportField($this->departamento);
						$doc->exportField($this->distrito);
						$doc->exportField($this->localidad);
						$doc->exportField($this->zona);
						$doc->exportField($this->tipo_inmueble);
						$doc->exportField($this->tipo_negocio);
						$doc->exportField($this->tiempo_alquiler);
						$doc->exportField($this->moneda);
						$doc->exportField($this->estado_inmueble);
						$doc->exportField($this->area_construida);
						$doc->exportField($this->area_privada);
						$doc->exportField($this->area_terreno);
						$doc->exportField($this->valor_administracion);
						$doc->exportField($this->dormitorios);
						$doc->exportField($this->banios);
						$doc->exportField($this->garaje);
						$doc->exportField($this->piso);
						$doc->exportField($this->estrato);
						$doc->exportField($this->codigo_postal);
						$doc->exportField($this->mapa);
						$doc->exportField($this->latitud);
						$doc->exportField($this->longitud);
						$doc->exportField($this->opciones_mapa);
						$doc->exportField($this->red);
						$doc->exportField($this->disponibilidad);
						$doc->exportField($this->anio_construccion);
						$doc->exportField($this->encargado);
						$doc->exportField($this->visitas);
						$doc->exportField($this->valor_comision);
						$doc->exportField($this->tipo_comision);
						$doc->exportField($this->certificado);
						$doc->exportField($this->nombre_propietario);
						$doc->exportField($this->movil_propietario);
						$doc->exportField($this->telefono_propietario);
						$doc->exportField($this->correo_propietario);
						$doc->exportField($this->vinculo);
						$doc->exportField($this->notas);
						$doc->exportField($this->marca);
						$doc->exportField($this->modelo);
						$doc->exportField($this->color);
						$doc->exportField($this->b1);
						$doc->exportField($this->b2);
						$doc->exportField($this->b3);
						$doc->exportField($this->b4);
						$doc->exportField($this->b5);
						$doc->exportField($this->b6);
						$doc->exportField($this->cat_pro);
						$doc->exportField($this->pro_ser);
						$doc->exportField($this->foto2);
						$doc->exportField($this->foto3);
						$doc->exportField($this->foto4);
						$doc->exportField($this->web);
						$doc->exportField($this->pre_web);
						$doc->exportField($this->megusta);
						$doc->exportField($this->nomegusta);
						$doc->exportField($this->precio2);
						$doc->exportField($this->precio3);
						$doc->exportField($this->und_pro);
						$doc->exportField($this->barras);
						$doc->exportField($this->stockmin);
						$doc->exportField($this->id_grupo);
						$doc->exportField($this->talla);
						$doc->exportField($this->mostrarcolor);
						$doc->exportField($this->precio_mayorista);
						$doc->exportField($this->precio_vendedor);
						$doc->exportField($this->medida1);
						$doc->exportField($this->medida2);
						$doc->exportField($this->medida3);
						$doc->exportField($this->codlogin);
						$doc->exportField($this->idempresa);
						$doc->exportField($this->urlstreetview);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>