<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$estados_list = new estados_list();

// Run the page
$estados_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$estados_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$estados_list->isExport()) { ?>
<script>
var festadoslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	festadoslist = currentForm = new ew.Form("festadoslist", "list");
	festadoslist.formKeyCountName = '<?php echo $estados_list->FormKeyCountName ?>';
	loadjs.done("festadoslist");
});
var festadoslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	festadoslistsrch = currentSearchForm = new ew.Form("festadoslistsrch");

	// Dynamic selection lists
	// Filters

	festadoslistsrch.filterList = <?php echo $estados_list->getFilterList() ?>;
	loadjs.done("festadoslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$estados_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($estados_list->TotalRecords > 0 && $estados_list->ExportOptions->visible()) { ?>
<?php $estados_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($estados_list->ImportOptions->visible()) { ?>
<?php $estados_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($estados_list->SearchOptions->visible()) { ?>
<?php $estados_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($estados_list->FilterOptions->visible()) { ?>
<?php $estados_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$estados_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$estados_list->isExport() && !$estados->CurrentAction) { ?>
<form name="festadoslistsrch" id="festadoslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="festadoslistsrch-search-panel" class="<?php echo $estados_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="estados">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $estados_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($estados_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($estados_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $estados_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($estados_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($estados_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($estados_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($estados_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $estados_list->showPageHeader(); ?>
<?php
$estados_list->showMessage();
?>
<?php if ($estados_list->TotalRecords > 0 || $estados->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($estados_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> estados">
<form name="festadoslist" id="festadoslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="estados">
<div id="gmp_estados" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($estados_list->TotalRecords > 0 || $estados_list->isGridEdit()) { ?>
<table id="tbl_estadoslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$estados->RowType = ROWTYPE_HEADER;

// Render list options
$estados_list->renderListOptions();

// Render list options (header, left)
$estados_list->ListOptions->render("header", "left");
?>
<?php if ($estados_list->id->Visible) { // id ?>
	<?php if ($estados_list->SortUrl($estados_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $estados_list->id->headerCellClass() ?>"><div id="elh_estados_id" class="estados_id"><div class="ew-table-header-caption"><?php echo $estados_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $estados_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $estados_list->SortUrl($estados_list->id) ?>', 1);"><div id="elh_estados_id" class="estados_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $estados_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($estados_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($estados_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($estados_list->color->Visible) { // color ?>
	<?php if ($estados_list->SortUrl($estados_list->color) == "") { ?>
		<th data-name="color" class="<?php echo $estados_list->color->headerCellClass() ?>"><div id="elh_estados_color" class="estados_color"><div class="ew-table-header-caption"><?php echo $estados_list->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $estados_list->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $estados_list->SortUrl($estados_list->color) ?>', 1);"><div id="elh_estados_color" class="estados_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $estados_list->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($estados_list->color->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($estados_list->color->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($estados_list->nombre->Visible) { // nombre ?>
	<?php if ($estados_list->SortUrl($estados_list->nombre) == "") { ?>
		<th data-name="nombre" class="<?php echo $estados_list->nombre->headerCellClass() ?>"><div id="elh_estados_nombre" class="estados_nombre"><div class="ew-table-header-caption"><?php echo $estados_list->nombre->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombre" class="<?php echo $estados_list->nombre->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $estados_list->SortUrl($estados_list->nombre) ?>', 1);"><div id="elh_estados_nombre" class="estados_nombre">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $estados_list->nombre->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($estados_list->nombre->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($estados_list->nombre->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$estados_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($estados_list->ExportAll && $estados_list->isExport()) {
	$estados_list->StopRecord = $estados_list->TotalRecords;
} else {

	// Set the last record to display
	if ($estados_list->TotalRecords > $estados_list->StartRecord + $estados_list->DisplayRecords - 1)
		$estados_list->StopRecord = $estados_list->StartRecord + $estados_list->DisplayRecords - 1;
	else
		$estados_list->StopRecord = $estados_list->TotalRecords;
}
$estados_list->RecordCount = $estados_list->StartRecord - 1;
if ($estados_list->Recordset && !$estados_list->Recordset->EOF) {
	$estados_list->Recordset->moveFirst();
	$selectLimit = $estados_list->UseSelectLimit;
	if (!$selectLimit && $estados_list->StartRecord > 1)
		$estados_list->Recordset->move($estados_list->StartRecord - 1);
} elseif (!$estados->AllowAddDeleteRow && $estados_list->StopRecord == 0) {
	$estados_list->StopRecord = $estados->GridAddRowCount;
}

// Initialize aggregate
$estados->RowType = ROWTYPE_AGGREGATEINIT;
$estados->resetAttributes();
$estados_list->renderRow();
while ($estados_list->RecordCount < $estados_list->StopRecord) {
	$estados_list->RecordCount++;
	if ($estados_list->RecordCount >= $estados_list->StartRecord) {
		$estados_list->RowCount++;

		// Set up key count
		$estados_list->KeyCount = $estados_list->RowIndex;

		// Init row class and style
		$estados->resetAttributes();
		$estados->CssClass = "";
		if ($estados_list->isGridAdd()) {
		} else {
			$estados_list->loadRowValues($estados_list->Recordset); // Load row values
		}
		$estados->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$estados->RowAttrs->merge(["data-rowindex" => $estados_list->RowCount, "id" => "r" . $estados_list->RowCount . "_estados", "data-rowtype" => $estados->RowType]);

		// Render row
		$estados_list->renderRow();

		// Render list options
		$estados_list->renderListOptions();
?>
	<tr <?php echo $estados->rowAttributes() ?>>
<?php

// Render list options (body, left)
$estados_list->ListOptions->render("body", "left", $estados_list->RowCount);
?>
	<?php if ($estados_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $estados_list->id->cellAttributes() ?>>
<span id="el<?php echo $estados_list->RowCount ?>_estados_id" class="estados_id">
<span<?php echo $estados_list->id->viewAttributes() ?>><?php echo $estados_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($estados_list->color->Visible) { // color ?>
		<td data-name="color" <?php echo $estados_list->color->cellAttributes() ?>>
<span id="el<?php echo $estados_list->RowCount ?>_estados_color" class="estados_color">
<span<?php echo $estados_list->color->viewAttributes() ?>><?php echo $estados_list->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($estados_list->nombre->Visible) { // nombre ?>
		<td data-name="nombre" <?php echo $estados_list->nombre->cellAttributes() ?>>
<span id="el<?php echo $estados_list->RowCount ?>_estados_nombre" class="estados_nombre">
<span<?php echo $estados_list->nombre->viewAttributes() ?>><?php echo $estados_list->nombre->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$estados_list->ListOptions->render("body", "right", $estados_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$estados_list->isGridAdd())
		$estados_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$estados->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($estados_list->Recordset)
	$estados_list->Recordset->Close();
?>
<?php if (!$estados_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$estados_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $estados_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $estados_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($estados_list->TotalRecords == 0 && !$estados->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $estados_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$estados_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$estados_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$estados_list->terminate();
?>