<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$estados_view = new estados_view();

// Run the page
$estados_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$estados_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$estados_view->isExport()) { ?>
<script>
var festadosview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	festadosview = currentForm = new ew.Form("festadosview", "view");
	loadjs.done("festadosview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$estados_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $estados_view->ExportOptions->render("body") ?>
<?php $estados_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $estados_view->showPageHeader(); ?>
<?php
$estados_view->showMessage();
?>
<form name="festadosview" id="festadosview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="estados">
<input type="hidden" name="modal" value="<?php echo (int)$estados_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($estados_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $estados_view->TableLeftColumnClass ?>"><span id="elh_estados_id"><?php echo $estados_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $estados_view->id->cellAttributes() ?>>
<span id="el_estados_id">
<span<?php echo $estados_view->id->viewAttributes() ?>><?php echo $estados_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($estados_view->color->Visible) { // color ?>
	<tr id="r_color">
		<td class="<?php echo $estados_view->TableLeftColumnClass ?>"><span id="elh_estados_color"><?php echo $estados_view->color->caption() ?></span></td>
		<td data-name="color" <?php echo $estados_view->color->cellAttributes() ?>>
<span id="el_estados_color">
<span<?php echo $estados_view->color->viewAttributes() ?>><?php echo $estados_view->color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($estados_view->nombre->Visible) { // nombre ?>
	<tr id="r_nombre">
		<td class="<?php echo $estados_view->TableLeftColumnClass ?>"><span id="elh_estados_nombre"><?php echo $estados_view->nombre->caption() ?></span></td>
		<td data-name="nombre" <?php echo $estados_view->nombre->cellAttributes() ?>>
<span id="el_estados_nombre">
<span<?php echo $estados_view->nombre->viewAttributes() ?>><?php echo $estados_view->nombre->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$estados_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$estados_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$estados_view->terminate();
?>