<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$interesados_list = new interesados_list();

// Run the page
$interesados_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$interesados_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$interesados_list->isExport()) { ?>
<script>
var finteresadoslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	finteresadoslist = currentForm = new ew.Form("finteresadoslist", "list");
	finteresadoslist.formKeyCountName = '<?php echo $interesados_list->FormKeyCountName ?>';
	loadjs.done("finteresadoslist");
});
var finteresadoslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	finteresadoslistsrch = currentSearchForm = new ew.Form("finteresadoslistsrch");

	// Dynamic selection lists
	// Filters

	finteresadoslistsrch.filterList = <?php echo $interesados_list->getFilterList() ?>;
	loadjs.done("finteresadoslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$interesados_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($interesados_list->TotalRecords > 0 && $interesados_list->ExportOptions->visible()) { ?>
<?php $interesados_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($interesados_list->ImportOptions->visible()) { ?>
<?php $interesados_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($interesados_list->SearchOptions->visible()) { ?>
<?php $interesados_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($interesados_list->FilterOptions->visible()) { ?>
<?php $interesados_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$interesados_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$interesados_list->isExport() && !$interesados->CurrentAction) { ?>
<form name="finteresadoslistsrch" id="finteresadoslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="finteresadoslistsrch-search-panel" class="<?php echo $interesados_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="interesados">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $interesados_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($interesados_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($interesados_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $interesados_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($interesados_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($interesados_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($interesados_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($interesados_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $interesados_list->showPageHeader(); ?>
<?php
$interesados_list->showMessage();
?>
<?php if ($interesados_list->TotalRecords > 0 || $interesados->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($interesados_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> interesados">
<form name="finteresadoslist" id="finteresadoslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="interesados">
<div id="gmp_interesados" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($interesados_list->TotalRecords > 0 || $interesados_list->isGridEdit()) { ?>
<table id="tbl_interesadoslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$interesados->RowType = ROWTYPE_HEADER;

// Render list options
$interesados_list->renderListOptions();

// Render list options (header, left)
$interesados_list->ListOptions->render("header", "left");
?>
<?php if ($interesados_list->idinteresado->Visible) { // idinteresado ?>
	<?php if ($interesados_list->SortUrl($interesados_list->idinteresado) == "") { ?>
		<th data-name="idinteresado" class="<?php echo $interesados_list->idinteresado->headerCellClass() ?>"><div id="elh_interesados_idinteresado" class="interesados_idinteresado"><div class="ew-table-header-caption"><?php echo $interesados_list->idinteresado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idinteresado" class="<?php echo $interesados_list->idinteresado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->idinteresado) ?>', 1);"><div id="elh_interesados_idinteresado" class="interesados_idinteresado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->idinteresado->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->idinteresado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->idinteresado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->id_usuarioencargado->Visible) { // id_usuarioencargado ?>
	<?php if ($interesados_list->SortUrl($interesados_list->id_usuarioencargado) == "") { ?>
		<th data-name="id_usuarioencargado" class="<?php echo $interesados_list->id_usuarioencargado->headerCellClass() ?>"><div id="elh_interesados_id_usuarioencargado" class="interesados_id_usuarioencargado"><div class="ew-table-header-caption"><?php echo $interesados_list->id_usuarioencargado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_usuarioencargado" class="<?php echo $interesados_list->id_usuarioencargado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->id_usuarioencargado) ?>', 1);"><div id="elh_interesados_id_usuarioencargado" class="interesados_id_usuarioencargado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->id_usuarioencargado->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->id_usuarioencargado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->id_usuarioencargado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->fecha->Visible) { // fecha ?>
	<?php if ($interesados_list->SortUrl($interesados_list->fecha) == "") { ?>
		<th data-name="fecha" class="<?php echo $interesados_list->fecha->headerCellClass() ?>"><div id="elh_interesados_fecha" class="interesados_fecha"><div class="ew-table-header-caption"><?php echo $interesados_list->fecha->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha" class="<?php echo $interesados_list->fecha->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->fecha) ?>', 1);"><div id="elh_interesados_fecha" class="interesados_fecha">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->fecha->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->fecha->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->fecha->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->_email->Visible) { // email ?>
	<?php if ($interesados_list->SortUrl($interesados_list->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $interesados_list->_email->headerCellClass() ?>"><div id="elh_interesados__email" class="interesados__email"><div class="ew-table-header-caption"><?php echo $interesados_list->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $interesados_list->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->_email) ?>', 1);"><div id="elh_interesados__email" class="interesados__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->_email->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->_email->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->cursos->Visible) { // cursos ?>
	<?php if ($interesados_list->SortUrl($interesados_list->cursos) == "") { ?>
		<th data-name="cursos" class="<?php echo $interesados_list->cursos->headerCellClass() ?>"><div id="elh_interesados_cursos" class="interesados_cursos"><div class="ew-table-header-caption"><?php echo $interesados_list->cursos->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cursos" class="<?php echo $interesados_list->cursos->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->cursos) ?>', 1);"><div id="elh_interesados_cursos" class="interesados_cursos">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->cursos->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->cursos->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->cursos->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->categorias->Visible) { // categorias ?>
	<?php if ($interesados_list->SortUrl($interesados_list->categorias) == "") { ?>
		<th data-name="categorias" class="<?php echo $interesados_list->categorias->headerCellClass() ?>"><div id="elh_interesados_categorias" class="interesados_categorias"><div class="ew-table-header-caption"><?php echo $interesados_list->categorias->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="categorias" class="<?php echo $interesados_list->categorias->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->categorias) ?>', 1);"><div id="elh_interesados_categorias" class="interesados_categorias">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->categorias->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->categorias->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->categorias->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->nombres->Visible) { // nombres ?>
	<?php if ($interesados_list->SortUrl($interesados_list->nombres) == "") { ?>
		<th data-name="nombres" class="<?php echo $interesados_list->nombres->headerCellClass() ?>"><div id="elh_interesados_nombres" class="interesados_nombres"><div class="ew-table-header-caption"><?php echo $interesados_list->nombres->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombres" class="<?php echo $interesados_list->nombres->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->nombres) ?>', 1);"><div id="elh_interesados_nombres" class="interesados_nombres">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->nombres->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->nombres->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->nombres->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->apellidos->Visible) { // apellidos ?>
	<?php if ($interesados_list->SortUrl($interesados_list->apellidos) == "") { ?>
		<th data-name="apellidos" class="<?php echo $interesados_list->apellidos->headerCellClass() ?>"><div id="elh_interesados_apellidos" class="interesados_apellidos"><div class="ew-table-header-caption"><?php echo $interesados_list->apellidos->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="apellidos" class="<?php echo $interesados_list->apellidos->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->apellidos) ?>', 1);"><div id="elh_interesados_apellidos" class="interesados_apellidos">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->apellidos->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->apellidos->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->apellidos->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->direccion->Visible) { // direccion ?>
	<?php if ($interesados_list->SortUrl($interesados_list->direccion) == "") { ?>
		<th data-name="direccion" class="<?php echo $interesados_list->direccion->headerCellClass() ?>"><div id="elh_interesados_direccion" class="interesados_direccion"><div class="ew-table-header-caption"><?php echo $interesados_list->direccion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="direccion" class="<?php echo $interesados_list->direccion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->direccion) ?>', 1);"><div id="elh_interesados_direccion" class="interesados_direccion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->direccion->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->direccion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->direccion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->ciudad->Visible) { // ciudad ?>
	<?php if ($interesados_list->SortUrl($interesados_list->ciudad) == "") { ?>
		<th data-name="ciudad" class="<?php echo $interesados_list->ciudad->headerCellClass() ?>"><div id="elh_interesados_ciudad" class="interesados_ciudad"><div class="ew-table-header-caption"><?php echo $interesados_list->ciudad->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ciudad" class="<?php echo $interesados_list->ciudad->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->ciudad) ?>', 1);"><div id="elh_interesados_ciudad" class="interesados_ciudad">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->ciudad->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->ciudad->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->ciudad->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->provincia->Visible) { // provincia ?>
	<?php if ($interesados_list->SortUrl($interesados_list->provincia) == "") { ?>
		<th data-name="provincia" class="<?php echo $interesados_list->provincia->headerCellClass() ?>"><div id="elh_interesados_provincia" class="interesados_provincia"><div class="ew-table-header-caption"><?php echo $interesados_list->provincia->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="provincia" class="<?php echo $interesados_list->provincia->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->provincia) ?>', 1);"><div id="elh_interesados_provincia" class="interesados_provincia">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->provincia->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->provincia->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->provincia->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->pais->Visible) { // pais ?>
	<?php if ($interesados_list->SortUrl($interesados_list->pais) == "") { ?>
		<th data-name="pais" class="<?php echo $interesados_list->pais->headerCellClass() ?>"><div id="elh_interesados_pais" class="interesados_pais"><div class="ew-table-header-caption"><?php echo $interesados_list->pais->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pais" class="<?php echo $interesados_list->pais->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->pais) ?>', 1);"><div id="elh_interesados_pais" class="interesados_pais">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->pais->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->pais->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->pais->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->telefono->Visible) { // telefono ?>
	<?php if ($interesados_list->SortUrl($interesados_list->telefono) == "") { ?>
		<th data-name="telefono" class="<?php echo $interesados_list->telefono->headerCellClass() ?>"><div id="elh_interesados_telefono" class="interesados_telefono"><div class="ew-table-header-caption"><?php echo $interesados_list->telefono->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="telefono" class="<?php echo $interesados_list->telefono->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->telefono) ?>', 1);"><div id="elh_interesados_telefono" class="interesados_telefono">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->telefono->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->telefono->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->telefono->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo_certificado->Visible) { // tipo_certificado ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo_certificado) == "") { ?>
		<th data-name="tipo_certificado" class="<?php echo $interesados_list->tipo_certificado->headerCellClass() ?>"><div id="elh_interesados_tipo_certificado" class="interesados_tipo_certificado"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo_certificado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_certificado" class="<?php echo $interesados_list->tipo_certificado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo_certificado) ?>', 1);"><div id="elh_interesados_tipo_certificado" class="interesados_tipo_certificado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo_certificado->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo_certificado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo_certificado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo_pago->Visible) { // tipo_pago ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo_pago) == "") { ?>
		<th data-name="tipo_pago" class="<?php echo $interesados_list->tipo_pago->headerCellClass() ?>"><div id="elh_interesados_tipo_pago" class="interesados_tipo_pago"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo_pago->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_pago" class="<?php echo $interesados_list->tipo_pago->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo_pago) ?>', 1);"><div id="elh_interesados_tipo_pago" class="interesados_tipo_pago">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo_pago->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo_pago->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo_pago->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->nombretarjeta->Visible) { // nombretarjeta ?>
	<?php if ($interesados_list->SortUrl($interesados_list->nombretarjeta) == "") { ?>
		<th data-name="nombretarjeta" class="<?php echo $interesados_list->nombretarjeta->headerCellClass() ?>"><div id="elh_interesados_nombretarjeta" class="interesados_nombretarjeta"><div class="ew-table-header-caption"><?php echo $interesados_list->nombretarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombretarjeta" class="<?php echo $interesados_list->nombretarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->nombretarjeta) ?>', 1);"><div id="elh_interesados_nombretarjeta" class="interesados_nombretarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->nombretarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->nombretarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->nombretarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->numerotarjeta->Visible) { // numerotarjeta ?>
	<?php if ($interesados_list->SortUrl($interesados_list->numerotarjeta) == "") { ?>
		<th data-name="numerotarjeta" class="<?php echo $interesados_list->numerotarjeta->headerCellClass() ?>"><div id="elh_interesados_numerotarjeta" class="interesados_numerotarjeta"><div class="ew-table-header-caption"><?php echo $interesados_list->numerotarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="numerotarjeta" class="<?php echo $interesados_list->numerotarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->numerotarjeta) ?>', 1);"><div id="elh_interesados_numerotarjeta" class="interesados_numerotarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->numerotarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->numerotarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->numerotarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->mes->Visible) { // mes ?>
	<?php if ($interesados_list->SortUrl($interesados_list->mes) == "") { ?>
		<th data-name="mes" class="<?php echo $interesados_list->mes->headerCellClass() ?>"><div id="elh_interesados_mes" class="interesados_mes"><div class="ew-table-header-caption"><?php echo $interesados_list->mes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mes" class="<?php echo $interesados_list->mes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->mes) ?>', 1);"><div id="elh_interesados_mes" class="interesados_mes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->mes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->mes->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->mes->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->anio->Visible) { // anio ?>
	<?php if ($interesados_list->SortUrl($interesados_list->anio) == "") { ?>
		<th data-name="anio" class="<?php echo $interesados_list->anio->headerCellClass() ?>"><div id="elh_interesados_anio" class="interesados_anio"><div class="ew-table-header-caption"><?php echo $interesados_list->anio->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="anio" class="<?php echo $interesados_list->anio->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->anio) ?>', 1);"><div id="elh_interesados_anio" class="interesados_anio">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->anio->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->anio->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->anio->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo_tarjeta->Visible) { // tipo_tarjeta ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo_tarjeta) == "") { ?>
		<th data-name="tipo_tarjeta" class="<?php echo $interesados_list->tipo_tarjeta->headerCellClass() ?>"><div id="elh_interesados_tipo_tarjeta" class="interesados_tipo_tarjeta"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo_tarjeta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_tarjeta" class="<?php echo $interesados_list->tipo_tarjeta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo_tarjeta) ?>', 1);"><div id="elh_interesados_tipo_tarjeta" class="interesados_tipo_tarjeta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo_tarjeta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo_tarjeta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo_tarjeta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->nombrepaypal->Visible) { // nombrepaypal ?>
	<?php if ($interesados_list->SortUrl($interesados_list->nombrepaypal) == "") { ?>
		<th data-name="nombrepaypal" class="<?php echo $interesados_list->nombrepaypal->headerCellClass() ?>"><div id="elh_interesados_nombrepaypal" class="interesados_nombrepaypal"><div class="ew-table-header-caption"><?php echo $interesados_list->nombrepaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nombrepaypal" class="<?php echo $interesados_list->nombrepaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->nombrepaypal) ?>', 1);"><div id="elh_interesados_nombrepaypal" class="interesados_nombrepaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->nombrepaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->nombrepaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->nombrepaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->montopaypal->Visible) { // montopaypal ?>
	<?php if ($interesados_list->SortUrl($interesados_list->montopaypal) == "") { ?>
		<th data-name="montopaypal" class="<?php echo $interesados_list->montopaypal->headerCellClass() ?>"><div id="elh_interesados_montopaypal" class="interesados_montopaypal"><div class="ew-table-header-caption"><?php echo $interesados_list->montopaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="montopaypal" class="<?php echo $interesados_list->montopaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->montopaypal) ?>', 1);"><div id="elh_interesados_montopaypal" class="interesados_montopaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->montopaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->montopaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->montopaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->emailpaypal->Visible) { // emailpaypal ?>
	<?php if ($interesados_list->SortUrl($interesados_list->emailpaypal) == "") { ?>
		<th data-name="emailpaypal" class="<?php echo $interesados_list->emailpaypal->headerCellClass() ?>"><div id="elh_interesados_emailpaypal" class="interesados_emailpaypal"><div class="ew-table-header-caption"><?php echo $interesados_list->emailpaypal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emailpaypal" class="<?php echo $interesados_list->emailpaypal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->emailpaypal) ?>', 1);"><div id="elh_interesados_emailpaypal" class="interesados_emailpaypal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->emailpaypal->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->emailpaypal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->emailpaypal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->don->Visible) { // don ?>
	<?php if ($interesados_list->SortUrl($interesados_list->don) == "") { ?>
		<th data-name="don" class="<?php echo $interesados_list->don->headerCellClass() ?>"><div id="elh_interesados_don" class="interesados_don"><div class="ew-table-header-caption"><?php echo $interesados_list->don->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="don" class="<?php echo $interesados_list->don->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->don) ?>', 1);"><div id="elh_interesados_don" class="interesados_don">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->don->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->don->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->don->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo_condicion->Visible) { // tipo_condicion ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo_condicion) == "") { ?>
		<th data-name="tipo_condicion" class="<?php echo $interesados_list->tipo_condicion->headerCellClass() ?>"><div id="elh_interesados_tipo_condicion" class="interesados_tipo_condicion"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo_condicion->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_condicion" class="<?php echo $interesados_list->tipo_condicion->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo_condicion) ?>', 1);"><div id="elh_interesados_tipo_condicion" class="interesados_tipo_condicion">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo_condicion->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo_condicion->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo_condicion->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->acciones->Visible) { // acciones ?>
	<?php if ($interesados_list->SortUrl($interesados_list->acciones) == "") { ?>
		<th data-name="acciones" class="<?php echo $interesados_list->acciones->headerCellClass() ?>"><div id="elh_interesados_acciones" class="interesados_acciones"><div class="ew-table-header-caption"><?php echo $interesados_list->acciones->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="acciones" class="<?php echo $interesados_list->acciones->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->acciones) ?>', 1);"><div id="elh_interesados_acciones" class="interesados_acciones">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->acciones->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->acciones->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->acciones->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->solicitud->Visible) { // solicitud ?>
	<?php if ($interesados_list->SortUrl($interesados_list->solicitud) == "") { ?>
		<th data-name="solicitud" class="<?php echo $interesados_list->solicitud->headerCellClass() ?>"><div id="elh_interesados_solicitud" class="interesados_solicitud"><div class="ew-table-header-caption"><?php echo $interesados_list->solicitud->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="solicitud" class="<?php echo $interesados_list->solicitud->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->solicitud) ?>', 1);"><div id="elh_interesados_solicitud" class="interesados_solicitud">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->solicitud->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->solicitud->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->solicitud->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->examen->Visible) { // examen ?>
	<?php if ($interesados_list->SortUrl($interesados_list->examen) == "") { ?>
		<th data-name="examen" class="<?php echo $interesados_list->examen->headerCellClass() ?>"><div id="elh_interesados_examen" class="interesados_examen"><div class="ew-table-header-caption"><?php echo $interesados_list->examen->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="examen" class="<?php echo $interesados_list->examen->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->examen) ?>', 1);"><div id="elh_interesados_examen" class="interesados_examen">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->examen->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->examen->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->examen->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->estado->Visible) { // estado ?>
	<?php if ($interesados_list->SortUrl($interesados_list->estado) == "") { ?>
		<th data-name="estado" class="<?php echo $interesados_list->estado->headerCellClass() ?>"><div id="elh_interesados_estado" class="interesados_estado"><div class="ew-table-header-caption"><?php echo $interesados_list->estado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado" class="<?php echo $interesados_list->estado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->estado) ?>', 1);"><div id="elh_interesados_estado" class="interesados_estado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->estado->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->estado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->estado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo->Visible) { // tipo ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo) == "") { ?>
		<th data-name="tipo" class="<?php echo $interesados_list->tipo->headerCellClass() ?>"><div id="elh_interesados_tipo" class="interesados_tipo"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo" class="<?php echo $interesados_list->tipo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo) ?>', 1);"><div id="elh_interesados_tipo" class="interesados_tipo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->codigo_certificado->Visible) { // codigo_certificado ?>
	<?php if ($interesados_list->SortUrl($interesados_list->codigo_certificado) == "") { ?>
		<th data-name="codigo_certificado" class="<?php echo $interesados_list->codigo_certificado->headerCellClass() ?>"><div id="elh_interesados_codigo_certificado" class="interesados_codigo_certificado"><div class="ew-table-header-caption"><?php echo $interesados_list->codigo_certificado->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codigo_certificado" class="<?php echo $interesados_list->codigo_certificado->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->codigo_certificado) ?>', 1);"><div id="elh_interesados_codigo_certificado" class="interesados_codigo_certificado">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->codigo_certificado->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->codigo_certificado->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->codigo_certificado->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->estado_entrega->Visible) { // estado_entrega ?>
	<?php if ($interesados_list->SortUrl($interesados_list->estado_entrega) == "") { ?>
		<th data-name="estado_entrega" class="<?php echo $interesados_list->estado_entrega->headerCellClass() ?>"><div id="elh_interesados_estado_entrega" class="interesados_estado_entrega"><div class="ew-table-header-caption"><?php echo $interesados_list->estado_entrega->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="estado_entrega" class="<?php echo $interesados_list->estado_entrega->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->estado_entrega) ?>', 1);"><div id="elh_interesados_estado_entrega" class="interesados_estado_entrega">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->estado_entrega->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->estado_entrega->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->estado_entrega->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->idioma->Visible) { // idioma ?>
	<?php if ($interesados_list->SortUrl($interesados_list->idioma) == "") { ?>
		<th data-name="idioma" class="<?php echo $interesados_list->idioma->headerCellClass() ?>"><div id="elh_interesados_idioma" class="interesados_idioma"><div class="ew-table-header-caption"><?php echo $interesados_list->idioma->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idioma" class="<?php echo $interesados_list->idioma->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->idioma) ?>', 1);"><div id="elh_interesados_idioma" class="interesados_idioma">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->idioma->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->idioma->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->idioma->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->tipo_documento->Visible) { // tipo_documento ?>
	<?php if ($interesados_list->SortUrl($interesados_list->tipo_documento) == "") { ?>
		<th data-name="tipo_documento" class="<?php echo $interesados_list->tipo_documento->headerCellClass() ?>"><div id="elh_interesados_tipo_documento" class="interesados_tipo_documento"><div class="ew-table-header-caption"><?php echo $interesados_list->tipo_documento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_documento" class="<?php echo $interesados_list->tipo_documento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->tipo_documento) ?>', 1);"><div id="elh_interesados_tipo_documento" class="interesados_tipo_documento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->tipo_documento->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->tipo_documento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->tipo_documento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->n_documento->Visible) { // n_documento ?>
	<?php if ($interesados_list->SortUrl($interesados_list->n_documento) == "") { ?>
		<th data-name="n_documento" class="<?php echo $interesados_list->n_documento->headerCellClass() ?>"><div id="elh_interesados_n_documento" class="interesados_n_documento"><div class="ew-table-header-caption"><?php echo $interesados_list->n_documento->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="n_documento" class="<?php echo $interesados_list->n_documento->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->n_documento) ?>', 1);"><div id="elh_interesados_n_documento" class="interesados_n_documento">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->n_documento->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->n_documento->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->n_documento->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->condicion1->Visible) { // condicion1 ?>
	<?php if ($interesados_list->SortUrl($interesados_list->condicion1) == "") { ?>
		<th data-name="condicion1" class="<?php echo $interesados_list->condicion1->headerCellClass() ?>"><div id="elh_interesados_condicion1" class="interesados_condicion1"><div class="ew-table-header-caption"><?php echo $interesados_list->condicion1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="condicion1" class="<?php echo $interesados_list->condicion1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->condicion1) ?>', 1);"><div id="elh_interesados_condicion1" class="interesados_condicion1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->condicion1->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->condicion1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->condicion1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->condicion2->Visible) { // condicion2 ?>
	<?php if ($interesados_list->SortUrl($interesados_list->condicion2) == "") { ?>
		<th data-name="condicion2" class="<?php echo $interesados_list->condicion2->headerCellClass() ?>"><div id="elh_interesados_condicion2" class="interesados_condicion2"><div class="ew-table-header-caption"><?php echo $interesados_list->condicion2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="condicion2" class="<?php echo $interesados_list->condicion2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->condicion2) ?>', 1);"><div id="elh_interesados_condicion2" class="interesados_condicion2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->condicion2->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->condicion2->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->condicion2->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->consulta->Visible) { // consulta ?>
	<?php if ($interesados_list->SortUrl($interesados_list->consulta) == "") { ?>
		<th data-name="consulta" class="<?php echo $interesados_list->consulta->headerCellClass() ?>"><div id="elh_interesados_consulta" class="interesados_consulta"><div class="ew-table-header-caption"><?php echo $interesados_list->consulta->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consulta" class="<?php echo $interesados_list->consulta->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->consulta) ?>', 1);"><div id="elh_interesados_consulta" class="interesados_consulta">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->consulta->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->consulta->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->consulta->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->status->Visible) { // status ?>
	<?php if ($interesados_list->SortUrl($interesados_list->status) == "") { ?>
		<th data-name="status" class="<?php echo $interesados_list->status->headerCellClass() ?>"><div id="elh_interesados_status" class="interesados_status"><div class="ew-table-header-caption"><?php echo $interesados_list->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $interesados_list->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->status) ?>', 1);"><div id="elh_interesados_status" class="interesados_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->codlogin->Visible) { // codlogin ?>
	<?php if ($interesados_list->SortUrl($interesados_list->codlogin) == "") { ?>
		<th data-name="codlogin" class="<?php echo $interesados_list->codlogin->headerCellClass() ?>"><div id="elh_interesados_codlogin" class="interesados_codlogin"><div class="ew-table-header-caption"><?php echo $interesados_list->codlogin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="codlogin" class="<?php echo $interesados_list->codlogin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->codlogin) ?>', 1);"><div id="elh_interesados_codlogin" class="interesados_codlogin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->codlogin->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->codlogin->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->codlogin->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->idproyecto->Visible) { // idproyecto ?>
	<?php if ($interesados_list->SortUrl($interesados_list->idproyecto) == "") { ?>
		<th data-name="idproyecto" class="<?php echo $interesados_list->idproyecto->headerCellClass() ?>"><div id="elh_interesados_idproyecto" class="interesados_idproyecto"><div class="ew-table-header-caption"><?php echo $interesados_list->idproyecto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idproyecto" class="<?php echo $interesados_list->idproyecto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->idproyecto) ?>', 1);"><div id="elh_interesados_idproyecto" class="interesados_idproyecto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->idproyecto->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->idproyecto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->idproyecto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($interesados_list->id_producto->Visible) { // id_producto ?>
	<?php if ($interesados_list->SortUrl($interesados_list->id_producto) == "") { ?>
		<th data-name="id_producto" class="<?php echo $interesados_list->id_producto->headerCellClass() ?>"><div id="elh_interesados_id_producto" class="interesados_id_producto"><div class="ew-table-header-caption"><?php echo $interesados_list->id_producto->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_producto" class="<?php echo $interesados_list->id_producto->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $interesados_list->SortUrl($interesados_list->id_producto) ?>', 1);"><div id="elh_interesados_id_producto" class="interesados_id_producto">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $interesados_list->id_producto->caption() ?></span><span class="ew-table-header-sort"><?php if ($interesados_list->id_producto->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($interesados_list->id_producto->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$interesados_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($interesados_list->ExportAll && $interesados_list->isExport()) {
	$interesados_list->StopRecord = $interesados_list->TotalRecords;
} else {

	// Set the last record to display
	if ($interesados_list->TotalRecords > $interesados_list->StartRecord + $interesados_list->DisplayRecords - 1)
		$interesados_list->StopRecord = $interesados_list->StartRecord + $interesados_list->DisplayRecords - 1;
	else
		$interesados_list->StopRecord = $interesados_list->TotalRecords;
}
$interesados_list->RecordCount = $interesados_list->StartRecord - 1;
if ($interesados_list->Recordset && !$interesados_list->Recordset->EOF) {
	$interesados_list->Recordset->moveFirst();
	$selectLimit = $interesados_list->UseSelectLimit;
	if (!$selectLimit && $interesados_list->StartRecord > 1)
		$interesados_list->Recordset->move($interesados_list->StartRecord - 1);
} elseif (!$interesados->AllowAddDeleteRow && $interesados_list->StopRecord == 0) {
	$interesados_list->StopRecord = $interesados->GridAddRowCount;
}

// Initialize aggregate
$interesados->RowType = ROWTYPE_AGGREGATEINIT;
$interesados->resetAttributes();
$interesados_list->renderRow();
while ($interesados_list->RecordCount < $interesados_list->StopRecord) {
	$interesados_list->RecordCount++;
	if ($interesados_list->RecordCount >= $interesados_list->StartRecord) {
		$interesados_list->RowCount++;

		// Set up key count
		$interesados_list->KeyCount = $interesados_list->RowIndex;

		// Init row class and style
		$interesados->resetAttributes();
		$interesados->CssClass = "";
		if ($interesados_list->isGridAdd()) {
		} else {
			$interesados_list->loadRowValues($interesados_list->Recordset); // Load row values
		}
		$interesados->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$interesados->RowAttrs->merge(["data-rowindex" => $interesados_list->RowCount, "id" => "r" . $interesados_list->RowCount . "_interesados", "data-rowtype" => $interesados->RowType]);

		// Render row
		$interesados_list->renderRow();

		// Render list options
		$interesados_list->renderListOptions();
?>
	<tr <?php echo $interesados->rowAttributes() ?>>
<?php

// Render list options (body, left)
$interesados_list->ListOptions->render("body", "left", $interesados_list->RowCount);
?>
	<?php if ($interesados_list->idinteresado->Visible) { // idinteresado ?>
		<td data-name="idinteresado" <?php echo $interesados_list->idinteresado->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_idinteresado" class="interesados_idinteresado">
<span<?php echo $interesados_list->idinteresado->viewAttributes() ?>><?php echo $interesados_list->idinteresado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->id_usuarioencargado->Visible) { // id_usuarioencargado ?>
		<td data-name="id_usuarioencargado" <?php echo $interesados_list->id_usuarioencargado->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_id_usuarioencargado" class="interesados_id_usuarioencargado">
<span<?php echo $interesados_list->id_usuarioencargado->viewAttributes() ?>><?php echo $interesados_list->id_usuarioencargado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->fecha->Visible) { // fecha ?>
		<td data-name="fecha" <?php echo $interesados_list->fecha->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_fecha" class="interesados_fecha">
<span<?php echo $interesados_list->fecha->viewAttributes() ?>><?php echo $interesados_list->fecha->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->_email->Visible) { // email ?>
		<td data-name="_email" <?php echo $interesados_list->_email->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados__email" class="interesados__email">
<span<?php echo $interesados_list->_email->viewAttributes() ?>><?php echo $interesados_list->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->cursos->Visible) { // cursos ?>
		<td data-name="cursos" <?php echo $interesados_list->cursos->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_cursos" class="interesados_cursos">
<span<?php echo $interesados_list->cursos->viewAttributes() ?>><?php echo $interesados_list->cursos->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->categorias->Visible) { // categorias ?>
		<td data-name="categorias" <?php echo $interesados_list->categorias->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_categorias" class="interesados_categorias">
<span<?php echo $interesados_list->categorias->viewAttributes() ?>><?php echo $interesados_list->categorias->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->nombres->Visible) { // nombres ?>
		<td data-name="nombres" <?php echo $interesados_list->nombres->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_nombres" class="interesados_nombres">
<span<?php echo $interesados_list->nombres->viewAttributes() ?>><?php echo $interesados_list->nombres->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->apellidos->Visible) { // apellidos ?>
		<td data-name="apellidos" <?php echo $interesados_list->apellidos->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_apellidos" class="interesados_apellidos">
<span<?php echo $interesados_list->apellidos->viewAttributes() ?>><?php echo $interesados_list->apellidos->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->direccion->Visible) { // direccion ?>
		<td data-name="direccion" <?php echo $interesados_list->direccion->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_direccion" class="interesados_direccion">
<span<?php echo $interesados_list->direccion->viewAttributes() ?>><?php echo $interesados_list->direccion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->ciudad->Visible) { // ciudad ?>
		<td data-name="ciudad" <?php echo $interesados_list->ciudad->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_ciudad" class="interesados_ciudad">
<span<?php echo $interesados_list->ciudad->viewAttributes() ?>><?php echo $interesados_list->ciudad->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->provincia->Visible) { // provincia ?>
		<td data-name="provincia" <?php echo $interesados_list->provincia->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_provincia" class="interesados_provincia">
<span<?php echo $interesados_list->provincia->viewAttributes() ?>><?php echo $interesados_list->provincia->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->pais->Visible) { // pais ?>
		<td data-name="pais" <?php echo $interesados_list->pais->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_pais" class="interesados_pais">
<span<?php echo $interesados_list->pais->viewAttributes() ?>><?php echo $interesados_list->pais->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->telefono->Visible) { // telefono ?>
		<td data-name="telefono" <?php echo $interesados_list->telefono->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_telefono" class="interesados_telefono">
<span<?php echo $interesados_list->telefono->viewAttributes() ?>><?php echo $interesados_list->telefono->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo_certificado->Visible) { // tipo_certificado ?>
		<td data-name="tipo_certificado" <?php echo $interesados_list->tipo_certificado->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo_certificado" class="interesados_tipo_certificado">
<span<?php echo $interesados_list->tipo_certificado->viewAttributes() ?>><?php echo $interesados_list->tipo_certificado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo_pago->Visible) { // tipo_pago ?>
		<td data-name="tipo_pago" <?php echo $interesados_list->tipo_pago->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo_pago" class="interesados_tipo_pago">
<span<?php echo $interesados_list->tipo_pago->viewAttributes() ?>><?php echo $interesados_list->tipo_pago->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->nombretarjeta->Visible) { // nombretarjeta ?>
		<td data-name="nombretarjeta" <?php echo $interesados_list->nombretarjeta->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_nombretarjeta" class="interesados_nombretarjeta">
<span<?php echo $interesados_list->nombretarjeta->viewAttributes() ?>><?php echo $interesados_list->nombretarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->numerotarjeta->Visible) { // numerotarjeta ?>
		<td data-name="numerotarjeta" <?php echo $interesados_list->numerotarjeta->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_numerotarjeta" class="interesados_numerotarjeta">
<span<?php echo $interesados_list->numerotarjeta->viewAttributes() ?>><?php echo $interesados_list->numerotarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->mes->Visible) { // mes ?>
		<td data-name="mes" <?php echo $interesados_list->mes->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_mes" class="interesados_mes">
<span<?php echo $interesados_list->mes->viewAttributes() ?>><?php echo $interesados_list->mes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->anio->Visible) { // anio ?>
		<td data-name="anio" <?php echo $interesados_list->anio->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_anio" class="interesados_anio">
<span<?php echo $interesados_list->anio->viewAttributes() ?>><?php echo $interesados_list->anio->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo_tarjeta->Visible) { // tipo_tarjeta ?>
		<td data-name="tipo_tarjeta" <?php echo $interesados_list->tipo_tarjeta->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo_tarjeta" class="interesados_tipo_tarjeta">
<span<?php echo $interesados_list->tipo_tarjeta->viewAttributes() ?>><?php echo $interesados_list->tipo_tarjeta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->nombrepaypal->Visible) { // nombrepaypal ?>
		<td data-name="nombrepaypal" <?php echo $interesados_list->nombrepaypal->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_nombrepaypal" class="interesados_nombrepaypal">
<span<?php echo $interesados_list->nombrepaypal->viewAttributes() ?>><?php echo $interesados_list->nombrepaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->montopaypal->Visible) { // montopaypal ?>
		<td data-name="montopaypal" <?php echo $interesados_list->montopaypal->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_montopaypal" class="interesados_montopaypal">
<span<?php echo $interesados_list->montopaypal->viewAttributes() ?>><?php echo $interesados_list->montopaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->emailpaypal->Visible) { // emailpaypal ?>
		<td data-name="emailpaypal" <?php echo $interesados_list->emailpaypal->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_emailpaypal" class="interesados_emailpaypal">
<span<?php echo $interesados_list->emailpaypal->viewAttributes() ?>><?php echo $interesados_list->emailpaypal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->don->Visible) { // don ?>
		<td data-name="don" <?php echo $interesados_list->don->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_don" class="interesados_don">
<span<?php echo $interesados_list->don->viewAttributes() ?>><?php echo $interesados_list->don->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo_condicion->Visible) { // tipo_condicion ?>
		<td data-name="tipo_condicion" <?php echo $interesados_list->tipo_condicion->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo_condicion" class="interesados_tipo_condicion">
<span<?php echo $interesados_list->tipo_condicion->viewAttributes() ?>><?php echo $interesados_list->tipo_condicion->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->acciones->Visible) { // acciones ?>
		<td data-name="acciones" <?php echo $interesados_list->acciones->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_acciones" class="interesados_acciones">
<span<?php echo $interesados_list->acciones->viewAttributes() ?>><?php echo $interesados_list->acciones->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->solicitud->Visible) { // solicitud ?>
		<td data-name="solicitud" <?php echo $interesados_list->solicitud->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_solicitud" class="interesados_solicitud">
<span<?php echo $interesados_list->solicitud->viewAttributes() ?>><?php echo $interesados_list->solicitud->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->examen->Visible) { // examen ?>
		<td data-name="examen" <?php echo $interesados_list->examen->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_examen" class="interesados_examen">
<span<?php echo $interesados_list->examen->viewAttributes() ?>><?php echo $interesados_list->examen->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->estado->Visible) { // estado ?>
		<td data-name="estado" <?php echo $interesados_list->estado->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_estado" class="interesados_estado">
<span<?php echo $interesados_list->estado->viewAttributes() ?>><?php echo $interesados_list->estado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo->Visible) { // tipo ?>
		<td data-name="tipo" <?php echo $interesados_list->tipo->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo" class="interesados_tipo">
<span<?php echo $interesados_list->tipo->viewAttributes() ?>><?php echo $interesados_list->tipo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->codigo_certificado->Visible) { // codigo_certificado ?>
		<td data-name="codigo_certificado" <?php echo $interesados_list->codigo_certificado->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_codigo_certificado" class="interesados_codigo_certificado">
<span<?php echo $interesados_list->codigo_certificado->viewAttributes() ?>><?php echo $interesados_list->codigo_certificado->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->estado_entrega->Visible) { // estado_entrega ?>
		<td data-name="estado_entrega" <?php echo $interesados_list->estado_entrega->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_estado_entrega" class="interesados_estado_entrega">
<span<?php echo $interesados_list->estado_entrega->viewAttributes() ?>><?php echo $interesados_list->estado_entrega->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->idioma->Visible) { // idioma ?>
		<td data-name="idioma" <?php echo $interesados_list->idioma->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_idioma" class="interesados_idioma">
<span<?php echo $interesados_list->idioma->viewAttributes() ?>><?php echo $interesados_list->idioma->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->tipo_documento->Visible) { // tipo_documento ?>
		<td data-name="tipo_documento" <?php echo $interesados_list->tipo_documento->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_tipo_documento" class="interesados_tipo_documento">
<span<?php echo $interesados_list->tipo_documento->viewAttributes() ?>><?php echo $interesados_list->tipo_documento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->n_documento->Visible) { // n_documento ?>
		<td data-name="n_documento" <?php echo $interesados_list->n_documento->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_n_documento" class="interesados_n_documento">
<span<?php echo $interesados_list->n_documento->viewAttributes() ?>><?php echo $interesados_list->n_documento->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->condicion1->Visible) { // condicion1 ?>
		<td data-name="condicion1" <?php echo $interesados_list->condicion1->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_condicion1" class="interesados_condicion1">
<span<?php echo $interesados_list->condicion1->viewAttributes() ?>><?php echo $interesados_list->condicion1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->condicion2->Visible) { // condicion2 ?>
		<td data-name="condicion2" <?php echo $interesados_list->condicion2->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_condicion2" class="interesados_condicion2">
<span<?php echo $interesados_list->condicion2->viewAttributes() ?>><?php echo $interesados_list->condicion2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->consulta->Visible) { // consulta ?>
		<td data-name="consulta" <?php echo $interesados_list->consulta->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_consulta" class="interesados_consulta">
<span<?php echo $interesados_list->consulta->viewAttributes() ?>><?php echo $interesados_list->consulta->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->status->Visible) { // status ?>
		<td data-name="status" <?php echo $interesados_list->status->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_status" class="interesados_status">
<span<?php echo $interesados_list->status->viewAttributes() ?>><?php echo $interesados_list->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->codlogin->Visible) { // codlogin ?>
		<td data-name="codlogin" <?php echo $interesados_list->codlogin->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_codlogin" class="interesados_codlogin">
<span<?php echo $interesados_list->codlogin->viewAttributes() ?>><?php echo $interesados_list->codlogin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->idproyecto->Visible) { // idproyecto ?>
		<td data-name="idproyecto" <?php echo $interesados_list->idproyecto->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_idproyecto" class="interesados_idproyecto">
<span<?php echo $interesados_list->idproyecto->viewAttributes() ?>><?php echo $interesados_list->idproyecto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($interesados_list->id_producto->Visible) { // id_producto ?>
		<td data-name="id_producto" <?php echo $interesados_list->id_producto->cellAttributes() ?>>
<span id="el<?php echo $interesados_list->RowCount ?>_interesados_id_producto" class="interesados_id_producto">
<span<?php echo $interesados_list->id_producto->viewAttributes() ?>><?php echo $interesados_list->id_producto->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$interesados_list->ListOptions->render("body", "right", $interesados_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$interesados_list->isGridAdd())
		$interesados_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$interesados->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($interesados_list->Recordset)
	$interesados_list->Recordset->Close();
?>
<?php if (!$interesados_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$interesados_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $interesados_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $interesados_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($interesados_list->TotalRecords == 0 && !$interesados->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $interesados_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$interesados_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$interesados_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$interesados_list->terminate();
?>