<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$kp_logs_view = new kp_logs_view();

// Run the page
$kp_logs_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$kp_logs_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$kp_logs_view->isExport()) { ?>
<script>
var fkp_logsview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fkp_logsview = currentForm = new ew.Form("fkp_logsview", "view");
	loadjs.done("fkp_logsview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$kp_logs_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $kp_logs_view->ExportOptions->render("body") ?>
<?php $kp_logs_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $kp_logs_view->showPageHeader(); ?>
<?php
$kp_logs_view->showMessage();
?>
<form name="fkp_logsview" id="fkp_logsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="kp_logs">
<input type="hidden" name="modal" value="<?php echo (int)$kp_logs_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($kp_logs_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_id"><?php echo $kp_logs_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $kp_logs_view->id->cellAttributes() ?>>
<span id="el_kp_logs_id">
<span<?php echo $kp_logs_view->id->viewAttributes() ?>><?php echo $kp_logs_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->tipo->Visible) { // tipo ?>
	<tr id="r_tipo">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_tipo"><?php echo $kp_logs_view->tipo->caption() ?></span></td>
		<td data-name="tipo" <?php echo $kp_logs_view->tipo->cellAttributes() ?>>
<span id="el_kp_logs_tipo">
<span<?php echo $kp_logs_view->tipo->viewAttributes() ?>><?php echo $kp_logs_view->tipo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->detalle->Visible) { // detalle ?>
	<tr id="r_detalle">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_detalle"><?php echo $kp_logs_view->detalle->caption() ?></span></td>
		<td data-name="detalle" <?php echo $kp_logs_view->detalle->cellAttributes() ?>>
<span id="el_kp_logs_detalle">
<span<?php echo $kp_logs_view->detalle->viewAttributes() ?>><?php echo $kp_logs_view->detalle->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->codlogin->Visible) { // codlogin ?>
	<tr id="r_codlogin">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_codlogin"><?php echo $kp_logs_view->codlogin->caption() ?></span></td>
		<td data-name="codlogin" <?php echo $kp_logs_view->codlogin->cellAttributes() ?>>
<span id="el_kp_logs_codlogin">
<span<?php echo $kp_logs_view->codlogin->viewAttributes() ?>><?php echo $kp_logs_view->codlogin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->ip->Visible) { // ip ?>
	<tr id="r_ip">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_ip"><?php echo $kp_logs_view->ip->caption() ?></span></td>
		<td data-name="ip" <?php echo $kp_logs_view->ip->cellAttributes() ?>>
<span id="el_kp_logs_ip">
<span<?php echo $kp_logs_view->ip->viewAttributes() ?>><?php echo $kp_logs_view->ip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->alerta->Visible) { // alerta ?>
	<tr id="r_alerta">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_alerta"><?php echo $kp_logs_view->alerta->caption() ?></span></td>
		<td data-name="alerta" <?php echo $kp_logs_view->alerta->cellAttributes() ?>>
<span id="el_kp_logs_alerta">
<span<?php echo $kp_logs_view->alerta->viewAttributes() ?>><div class="custom-control custom-checkbox d-inline-block"><input type="checkbox" id="x_alerta" class="custom-control-input" value="<?php echo $kp_logs_view->alerta->getViewValue() ?>" disabled<?php if (ConvertToBool($kp_logs_view->alerta->CurrentValue)) { ?> checked<?php } ?>><label class="custom-control-label" for="x_alerta"></label></div></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->valoranterior->Visible) { // valoranterior ?>
	<tr id="r_valoranterior">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_valoranterior"><?php echo $kp_logs_view->valoranterior->caption() ?></span></td>
		<td data-name="valoranterior" <?php echo $kp_logs_view->valoranterior->cellAttributes() ?>>
<span id="el_kp_logs_valoranterior">
<span<?php echo $kp_logs_view->valoranterior->viewAttributes() ?>><?php echo $kp_logs_view->valoranterior->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($kp_logs_view->valoractual->Visible) { // valoractual ?>
	<tr id="r_valoractual">
		<td class="<?php echo $kp_logs_view->TableLeftColumnClass ?>"><span id="elh_kp_logs_valoractual"><?php echo $kp_logs_view->valoractual->caption() ?></span></td>
		<td data-name="valoractual" <?php echo $kp_logs_view->valoractual->cellAttributes() ?>>
<span id="el_kp_logs_valoractual">
<span<?php echo $kp_logs_view->valoractual->viewAttributes() ?>><?php echo $kp_logs_view->valoractual->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$kp_logs_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$kp_logs_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$kp_logs_view->terminate();
?>