<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$products_add = new products_add();

// Run the page
$products_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$products_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fproductsadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fproductsadd = currentForm = new ew.Form("fproductsadd", "add");

	// Validate form
	fproductsadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($products_add->codigo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->codigo_producto->caption(), $products_add->codigo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->nombre_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->nombre_producto->caption(), $products_add->nombre_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->estado->Required) { ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->estado->caption(), $products_add->estado->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_estado");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->estado->errorMessage()) ?>");
			<?php if ($products_add->status_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->status_producto->caption(), $products_add->status_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_status_producto");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->status_producto->errorMessage()) ?>");
			<?php if ($products_add->date_added->Required) { ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->date_added->caption(), $products_add->date_added->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_date_added");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->date_added->errorMessage()) ?>");
			<?php if ($products_add->precio_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->precio_producto->caption(), $products_add->precio_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->precio_producto->errorMessage()) ?>");
			<?php if ($products_add->costo_producto->Required) { ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->costo_producto->caption(), $products_add->costo_producto->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_costo_producto");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->costo_producto->errorMessage()) ?>");
			<?php if ($products_add->mon_costo->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->mon_costo->caption(), $products_add->mon_costo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_costo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->mon_costo->errorMessage()) ?>");
			<?php if ($products_add->mon_venta->Required) { ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->mon_venta->caption(), $products_add->mon_venta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mon_venta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->mon_venta->errorMessage()) ?>");
			<?php if ($products_add->pais->Required) { ?>
				elm = this.getElements("x" + infix + "_pais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->pais->caption(), $products_add->pais->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->departamento->Required) { ?>
				elm = this.getElements("x" + infix + "_departamento");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->departamento->caption(), $products_add->departamento->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->distrito->Required) { ?>
				elm = this.getElements("x" + infix + "_distrito");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->distrito->caption(), $products_add->distrito->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->localidad->Required) { ?>
				elm = this.getElements("x" + infix + "_localidad");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->localidad->caption(), $products_add->localidad->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->zona->Required) { ?>
				elm = this.getElements("x" + infix + "_zona");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->zona->caption(), $products_add->zona->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->tipo_inmueble->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_inmueble");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->tipo_inmueble->caption(), $products_add->tipo_inmueble->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tipo_inmueble");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->tipo_inmueble->errorMessage()) ?>");
			<?php if ($products_add->tipo_negocio->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_negocio");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->tipo_negocio->caption(), $products_add->tipo_negocio->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->tiempo_alquiler->Required) { ?>
				elm = this.getElements("x" + infix + "_tiempo_alquiler");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->tiempo_alquiler->caption(), $products_add->tiempo_alquiler->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->moneda->Required) { ?>
				elm = this.getElements("x" + infix + "_moneda");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->moneda->caption(), $products_add->moneda->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->estado_inmueble->Required) { ?>
				elm = this.getElements("x" + infix + "_estado_inmueble");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->estado_inmueble->caption(), $products_add->estado_inmueble->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->area_construida->Required) { ?>
				elm = this.getElements("x" + infix + "_area_construida");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->area_construida->caption(), $products_add->area_construida->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->area_privada->Required) { ?>
				elm = this.getElements("x" + infix + "_area_privada");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->area_privada->caption(), $products_add->area_privada->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->area_terreno->Required) { ?>
				elm = this.getElements("x" + infix + "_area_terreno");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->area_terreno->caption(), $products_add->area_terreno->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->valor_administracion->Required) { ?>
				elm = this.getElements("x" + infix + "_valor_administracion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->valor_administracion->caption(), $products_add->valor_administracion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->dormitorios->Required) { ?>
				elm = this.getElements("x" + infix + "_dormitorios");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->dormitorios->caption(), $products_add->dormitorios->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->banios->Required) { ?>
				elm = this.getElements("x" + infix + "_banios");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->banios->caption(), $products_add->banios->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->garaje->Required) { ?>
				elm = this.getElements("x" + infix + "_garaje");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->garaje->caption(), $products_add->garaje->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->piso->Required) { ?>
				elm = this.getElements("x" + infix + "_piso");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->piso->caption(), $products_add->piso->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->estrato->Required) { ?>
				elm = this.getElements("x" + infix + "_estrato");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->estrato->caption(), $products_add->estrato->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->direccion->Required) { ?>
				elm = this.getElements("x" + infix + "_direccion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->direccion->caption(), $products_add->direccion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->codigo_postal->Required) { ?>
				elm = this.getElements("x" + infix + "_codigo_postal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->codigo_postal->caption(), $products_add->codigo_postal->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->mapa->Required) { ?>
				elm = this.getElements("x" + infix + "_mapa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->mapa->caption(), $products_add->mapa->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->latitud->Required) { ?>
				elm = this.getElements("x" + infix + "_latitud");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->latitud->caption(), $products_add->latitud->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->longitud->Required) { ?>
				elm = this.getElements("x" + infix + "_longitud");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->longitud->caption(), $products_add->longitud->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->opciones_mapa->Required) { ?>
				elm = this.getElements("x" + infix + "_opciones_mapa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->opciones_mapa->caption(), $products_add->opciones_mapa->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->red->Required) { ?>
				elm = this.getElements("x" + infix + "_red");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->red->caption(), $products_add->red->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->video->Required) { ?>
				elm = this.getElements("x" + infix + "_video");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->video->caption(), $products_add->video->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->disponibilidad->Required) { ?>
				elm = this.getElements("x" + infix + "_disponibilidad");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->disponibilidad->caption(), $products_add->disponibilidad->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->anio_construccion->Required) { ?>
				elm = this.getElements("x" + infix + "_anio_construccion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->anio_construccion->caption(), $products_add->anio_construccion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->encargado->Required) { ?>
				elm = this.getElements("x" + infix + "_encargado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->encargado->caption(), $products_add->encargado->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->comentario->Required) { ?>
				elm = this.getElements("x" + infix + "_comentario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->comentario->caption(), $products_add->comentario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->visitas->Required) { ?>
				elm = this.getElements("x" + infix + "_visitas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->visitas->caption(), $products_add->visitas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->valor_comision->Required) { ?>
				elm = this.getElements("x" + infix + "_valor_comision");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->valor_comision->caption(), $products_add->valor_comision->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_valor_comision");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->valor_comision->errorMessage()) ?>");
			<?php if ($products_add->tipo_comision->Required) { ?>
				elm = this.getElements("x" + infix + "_tipo_comision");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->tipo_comision->caption(), $products_add->tipo_comision->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->certificado->Required) { ?>
				elm = this.getElements("x" + infix + "_certificado");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->certificado->caption(), $products_add->certificado->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->nombre_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_nombre_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->nombre_propietario->caption(), $products_add->nombre_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->movil_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_movil_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->movil_propietario->caption(), $products_add->movil_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->telefono_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_telefono_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->telefono_propietario->caption(), $products_add->telefono_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->correo_propietario->Required) { ?>
				elm = this.getElements("x" + infix + "_correo_propietario");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->correo_propietario->caption(), $products_add->correo_propietario->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->vinculo->Required) { ?>
				elm = this.getElements("x" + infix + "_vinculo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->vinculo->caption(), $products_add->vinculo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->portales->Required) { ?>
				elm = this.getElements("x" + infix + "_portales");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->portales->caption(), $products_add->portales->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->notas->Required) { ?>
				elm = this.getElements("x" + infix + "_notas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->notas->caption(), $products_add->notas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->marca->Required) { ?>
				elm = this.getElements("x" + infix + "_marca");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->marca->caption(), $products_add->marca->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->modelo->Required) { ?>
				elm = this.getElements("x" + infix + "_modelo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->modelo->caption(), $products_add->modelo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->color->Required) { ?>
				elm = this.getElements("x" + infix + "_color");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->color->caption(), $products_add->color->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->b1->Required) { ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b1->caption(), $products_add->b1->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b1");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b1->errorMessage()) ?>");
			<?php if ($products_add->b2->Required) { ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b2->caption(), $products_add->b2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b2->errorMessage()) ?>");
			<?php if ($products_add->b3->Required) { ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b3->caption(), $products_add->b3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b3->errorMessage()) ?>");
			<?php if ($products_add->b4->Required) { ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b4->caption(), $products_add->b4->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b4");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b4->errorMessage()) ?>");
			<?php if ($products_add->b5->Required) { ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b5->caption(), $products_add->b5->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b5");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b5->errorMessage()) ?>");
			<?php if ($products_add->b6->Required) { ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->b6->caption(), $products_add->b6->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_b6");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->b6->errorMessage()) ?>");
			<?php if ($products_add->cat_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->cat_pro->caption(), $products_add->cat_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_cat_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->cat_pro->errorMessage()) ?>");
			<?php if ($products_add->pro_ser->Required) { ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->pro_ser->caption(), $products_add->pro_ser->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pro_ser");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->pro_ser->errorMessage()) ?>");
			<?php if ($products_add->foto1->Required) { ?>
				elm = this.getElements("x" + infix + "_foto1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->foto1->caption(), $products_add->foto1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->foto2->Required) { ?>
				elm = this.getElements("x" + infix + "_foto2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->foto2->caption(), $products_add->foto2->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->foto3->Required) { ?>
				elm = this.getElements("x" + infix + "_foto3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->foto3->caption(), $products_add->foto3->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->foto4->Required) { ?>
				elm = this.getElements("x" + infix + "_foto4");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->foto4->caption(), $products_add->foto4->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->web->Required) { ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->web->caption(), $products_add->web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_web");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->web->errorMessage()) ?>");
			<?php if ($products_add->pre_web->Required) { ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->pre_web->caption(), $products_add->pre_web->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_pre_web");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->pre_web->errorMessage()) ?>");
			<?php if ($products_add->descripcion->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->descripcion->caption(), $products_add->descripcion->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->descripcion1->Required) { ?>
				elm = this.getElements("x" + infix + "_descripcion1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->descripcion1->caption(), $products_add->descripcion1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->megusta->Required) { ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->megusta->caption(), $products_add->megusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_megusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->megusta->errorMessage()) ?>");
			<?php if ($products_add->nomegusta->Required) { ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->nomegusta->caption(), $products_add->nomegusta->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nomegusta");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->nomegusta->errorMessage()) ?>");
			<?php if ($products_add->precio2->Required) { ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->precio2->caption(), $products_add->precio2->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio2");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->precio2->errorMessage()) ?>");
			<?php if ($products_add->precio3->Required) { ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->precio3->caption(), $products_add->precio3->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio3");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->precio3->errorMessage()) ?>");
			<?php if ($products_add->und_pro->Required) { ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->und_pro->caption(), $products_add->und_pro->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_und_pro");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->und_pro->errorMessage()) ?>");
			<?php if ($products_add->barras->Required) { ?>
				elm = this.getElements("x" + infix + "_barras");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->barras->caption(), $products_add->barras->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->stockmin->Required) { ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->stockmin->caption(), $products_add->stockmin->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_stockmin");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->stockmin->errorMessage()) ?>");
			<?php if ($products_add->id_grupo->Required) { ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->id_grupo->caption(), $products_add->id_grupo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id_grupo");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->id_grupo->errorMessage()) ?>");
			<?php if ($products_add->talla->Required) { ?>
				elm = this.getElements("x" + infix + "_talla");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->talla->caption(), $products_add->talla->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->mostrarcolor->Required) { ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->mostrarcolor->caption(), $products_add->mostrarcolor->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mostrarcolor");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->mostrarcolor->errorMessage()) ?>");
			<?php if ($products_add->precio_mayorista->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_mayorista");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->precio_mayorista->caption(), $products_add->precio_mayorista->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_mayorista");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->precio_mayorista->errorMessage()) ?>");
			<?php if ($products_add->precio_vendedor->Required) { ?>
				elm = this.getElements("x" + infix + "_precio_vendedor");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->precio_vendedor->caption(), $products_add->precio_vendedor->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_precio_vendedor");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->precio_vendedor->errorMessage()) ?>");
			<?php if ($products_add->medida1->Required) { ?>
				elm = this.getElements("x" + infix + "_medida1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->medida1->caption(), $products_add->medida1->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->medida2->Required) { ?>
				elm = this.getElements("x" + infix + "_medida2");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->medida2->caption(), $products_add->medida2->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->medida3->Required) { ?>
				elm = this.getElements("x" + infix + "_medida3");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->medida3->caption(), $products_add->medida3->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->codlogin->Required) { ?>
				elm = this.getElements("x" + infix + "_codlogin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->codlogin->caption(), $products_add->codlogin->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($products_add->idempresa->Required) { ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->idempresa->caption(), $products_add->idempresa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idempresa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($products_add->idempresa->errorMessage()) ?>");
			<?php if ($products_add->urlstreetview->Required) { ?>
				elm = this.getElements("x" + infix + "_urlstreetview");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $products_add->urlstreetview->caption(), $products_add->urlstreetview->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fproductsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductsadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fproductsadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $products_add->showPageHeader(); ?>
<?php
$products_add->showMessage();
?>
<form name="fproductsadd" id="fproductsadd" class="<?php echo $products_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="products">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$products_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($products_add->codigo_producto->Visible) { // codigo_producto ?>
	<div id="r_codigo_producto" class="form-group row">
		<label id="elh_products_codigo_producto" for="x_codigo_producto" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->codigo_producto->caption() ?><?php echo $products_add->codigo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->codigo_producto->cellAttributes() ?>>
<span id="el_products_codigo_producto">
<input type="text" data-table="products" data-field="x_codigo_producto" name="x_codigo_producto" id="x_codigo_producto" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_add->codigo_producto->getPlaceHolder()) ?>" value="<?php echo $products_add->codigo_producto->EditValue ?>"<?php echo $products_add->codigo_producto->editAttributes() ?>>
</span>
<?php echo $products_add->codigo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->nombre_producto->Visible) { // nombre_producto ?>
	<div id="r_nombre_producto" class="form-group row">
		<label id="elh_products_nombre_producto" for="x_nombre_producto" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->nombre_producto->caption() ?><?php echo $products_add->nombre_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->nombre_producto->cellAttributes() ?>>
<span id="el_products_nombre_producto">
<textarea data-table="products" data-field="x_nombre_producto" name="x_nombre_producto" id="x_nombre_producto" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->nombre_producto->getPlaceHolder()) ?>"<?php echo $products_add->nombre_producto->editAttributes() ?>><?php echo $products_add->nombre_producto->EditValue ?></textarea>
</span>
<?php echo $products_add->nombre_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->estado->Visible) { // estado ?>
	<div id="r_estado" class="form-group row">
		<label id="elh_products_estado" for="x_estado" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->estado->caption() ?><?php echo $products_add->estado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->estado->cellAttributes() ?>>
<span id="el_products_estado">
<input type="text" data-table="products" data-field="x_estado" name="x_estado" id="x_estado" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->estado->getPlaceHolder()) ?>" value="<?php echo $products_add->estado->EditValue ?>"<?php echo $products_add->estado->editAttributes() ?>>
</span>
<?php echo $products_add->estado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->status_producto->Visible) { // status_producto ?>
	<div id="r_status_producto" class="form-group row">
		<label id="elh_products_status_producto" for="x_status_producto" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->status_producto->caption() ?><?php echo $products_add->status_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->status_producto->cellAttributes() ?>>
<span id="el_products_status_producto">
<input type="text" data-table="products" data-field="x_status_producto" name="x_status_producto" id="x_status_producto" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($products_add->status_producto->getPlaceHolder()) ?>" value="<?php echo $products_add->status_producto->EditValue ?>"<?php echo $products_add->status_producto->editAttributes() ?>>
</span>
<?php echo $products_add->status_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->date_added->Visible) { // date_added ?>
	<div id="r_date_added" class="form-group row">
		<label id="elh_products_date_added" for="x_date_added" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->date_added->caption() ?><?php echo $products_add->date_added->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->date_added->cellAttributes() ?>>
<span id="el_products_date_added">
<input type="text" data-table="products" data-field="x_date_added" name="x_date_added" id="x_date_added" maxlength="19" placeholder="<?php echo HtmlEncode($products_add->date_added->getPlaceHolder()) ?>" value="<?php echo $products_add->date_added->EditValue ?>"<?php echo $products_add->date_added->editAttributes() ?>>
<?php if (!$products_add->date_added->ReadOnly && !$products_add->date_added->Disabled && !isset($products_add->date_added->EditAttrs["readonly"]) && !isset($products_add->date_added->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductsadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductsadd", "x_date_added", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $products_add->date_added->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->precio_producto->Visible) { // precio_producto ?>
	<div id="r_precio_producto" class="form-group row">
		<label id="elh_products_precio_producto" for="x_precio_producto" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->precio_producto->caption() ?><?php echo $products_add->precio_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->precio_producto->cellAttributes() ?>>
<span id="el_products_precio_producto">
<input type="text" data-table="products" data-field="x_precio_producto" name="x_precio_producto" id="x_precio_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->precio_producto->getPlaceHolder()) ?>" value="<?php echo $products_add->precio_producto->EditValue ?>"<?php echo $products_add->precio_producto->editAttributes() ?>>
</span>
<?php echo $products_add->precio_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->costo_producto->Visible) { // costo_producto ?>
	<div id="r_costo_producto" class="form-group row">
		<label id="elh_products_costo_producto" for="x_costo_producto" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->costo_producto->caption() ?><?php echo $products_add->costo_producto->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->costo_producto->cellAttributes() ?>>
<span id="el_products_costo_producto">
<input type="text" data-table="products" data-field="x_costo_producto" name="x_costo_producto" id="x_costo_producto" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->costo_producto->getPlaceHolder()) ?>" value="<?php echo $products_add->costo_producto->EditValue ?>"<?php echo $products_add->costo_producto->editAttributes() ?>>
</span>
<?php echo $products_add->costo_producto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->mon_costo->Visible) { // mon_costo ?>
	<div id="r_mon_costo" class="form-group row">
		<label id="elh_products_mon_costo" for="x_mon_costo" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->mon_costo->caption() ?><?php echo $products_add->mon_costo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->mon_costo->cellAttributes() ?>>
<span id="el_products_mon_costo">
<input type="text" data-table="products" data-field="x_mon_costo" name="x_mon_costo" id="x_mon_costo" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($products_add->mon_costo->getPlaceHolder()) ?>" value="<?php echo $products_add->mon_costo->EditValue ?>"<?php echo $products_add->mon_costo->editAttributes() ?>>
</span>
<?php echo $products_add->mon_costo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->mon_venta->Visible) { // mon_venta ?>
	<div id="r_mon_venta" class="form-group row">
		<label id="elh_products_mon_venta" for="x_mon_venta" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->mon_venta->caption() ?><?php echo $products_add->mon_venta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->mon_venta->cellAttributes() ?>>
<span id="el_products_mon_venta">
<input type="text" data-table="products" data-field="x_mon_venta" name="x_mon_venta" id="x_mon_venta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->mon_venta->getPlaceHolder()) ?>" value="<?php echo $products_add->mon_venta->EditValue ?>"<?php echo $products_add->mon_venta->editAttributes() ?>>
</span>
<?php echo $products_add->mon_venta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->pais->Visible) { // pais ?>
	<div id="r_pais" class="form-group row">
		<label id="elh_products_pais" for="x_pais" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->pais->caption() ?><?php echo $products_add->pais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->pais->cellAttributes() ?>>
<span id="el_products_pais">
<input type="text" data-table="products" data-field="x_pais" name="x_pais" id="x_pais" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->pais->getPlaceHolder()) ?>" value="<?php echo $products_add->pais->EditValue ?>"<?php echo $products_add->pais->editAttributes() ?>>
</span>
<?php echo $products_add->pais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->departamento->Visible) { // departamento ?>
	<div id="r_departamento" class="form-group row">
		<label id="elh_products_departamento" for="x_departamento" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->departamento->caption() ?><?php echo $products_add->departamento->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->departamento->cellAttributes() ?>>
<span id="el_products_departamento">
<input type="text" data-table="products" data-field="x_departamento" name="x_departamento" id="x_departamento" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->departamento->getPlaceHolder()) ?>" value="<?php echo $products_add->departamento->EditValue ?>"<?php echo $products_add->departamento->editAttributes() ?>>
</span>
<?php echo $products_add->departamento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->distrito->Visible) { // distrito ?>
	<div id="r_distrito" class="form-group row">
		<label id="elh_products_distrito" for="x_distrito" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->distrito->caption() ?><?php echo $products_add->distrito->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->distrito->cellAttributes() ?>>
<span id="el_products_distrito">
<input type="text" data-table="products" data-field="x_distrito" name="x_distrito" id="x_distrito" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->distrito->getPlaceHolder()) ?>" value="<?php echo $products_add->distrito->EditValue ?>"<?php echo $products_add->distrito->editAttributes() ?>>
</span>
<?php echo $products_add->distrito->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->localidad->Visible) { // localidad ?>
	<div id="r_localidad" class="form-group row">
		<label id="elh_products_localidad" for="x_localidad" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->localidad->caption() ?><?php echo $products_add->localidad->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->localidad->cellAttributes() ?>>
<span id="el_products_localidad">
<input type="text" data-table="products" data-field="x_localidad" name="x_localidad" id="x_localidad" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->localidad->getPlaceHolder()) ?>" value="<?php echo $products_add->localidad->EditValue ?>"<?php echo $products_add->localidad->editAttributes() ?>>
</span>
<?php echo $products_add->localidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->zona->Visible) { // zona ?>
	<div id="r_zona" class="form-group row">
		<label id="elh_products_zona" for="x_zona" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->zona->caption() ?><?php echo $products_add->zona->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->zona->cellAttributes() ?>>
<span id="el_products_zona">
<input type="text" data-table="products" data-field="x_zona" name="x_zona" id="x_zona" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->zona->getPlaceHolder()) ?>" value="<?php echo $products_add->zona->EditValue ?>"<?php echo $products_add->zona->editAttributes() ?>>
</span>
<?php echo $products_add->zona->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->tipo_inmueble->Visible) { // tipo_inmueble ?>
	<div id="r_tipo_inmueble" class="form-group row">
		<label id="elh_products_tipo_inmueble" for="x_tipo_inmueble" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->tipo_inmueble->caption() ?><?php echo $products_add->tipo_inmueble->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->tipo_inmueble->cellAttributes() ?>>
<span id="el_products_tipo_inmueble">
<input type="text" data-table="products" data-field="x_tipo_inmueble" name="x_tipo_inmueble" id="x_tipo_inmueble" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->tipo_inmueble->getPlaceHolder()) ?>" value="<?php echo $products_add->tipo_inmueble->EditValue ?>"<?php echo $products_add->tipo_inmueble->editAttributes() ?>>
</span>
<?php echo $products_add->tipo_inmueble->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->tipo_negocio->Visible) { // tipo_negocio ?>
	<div id="r_tipo_negocio" class="form-group row">
		<label id="elh_products_tipo_negocio" for="x_tipo_negocio" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->tipo_negocio->caption() ?><?php echo $products_add->tipo_negocio->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->tipo_negocio->cellAttributes() ?>>
<span id="el_products_tipo_negocio">
<input type="text" data-table="products" data-field="x_tipo_negocio" name="x_tipo_negocio" id="x_tipo_negocio" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->tipo_negocio->getPlaceHolder()) ?>" value="<?php echo $products_add->tipo_negocio->EditValue ?>"<?php echo $products_add->tipo_negocio->editAttributes() ?>>
</span>
<?php echo $products_add->tipo_negocio->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->tiempo_alquiler->Visible) { // tiempo_alquiler ?>
	<div id="r_tiempo_alquiler" class="form-group row">
		<label id="elh_products_tiempo_alquiler" for="x_tiempo_alquiler" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->tiempo_alquiler->caption() ?><?php echo $products_add->tiempo_alquiler->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->tiempo_alquiler->cellAttributes() ?>>
<span id="el_products_tiempo_alquiler">
<input type="text" data-table="products" data-field="x_tiempo_alquiler" name="x_tiempo_alquiler" id="x_tiempo_alquiler" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->tiempo_alquiler->getPlaceHolder()) ?>" value="<?php echo $products_add->tiempo_alquiler->EditValue ?>"<?php echo $products_add->tiempo_alquiler->editAttributes() ?>>
</span>
<?php echo $products_add->tiempo_alquiler->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->moneda->Visible) { // moneda ?>
	<div id="r_moneda" class="form-group row">
		<label id="elh_products_moneda" for="x_moneda" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->moneda->caption() ?><?php echo $products_add->moneda->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->moneda->cellAttributes() ?>>
<span id="el_products_moneda">
<input type="text" data-table="products" data-field="x_moneda" name="x_moneda" id="x_moneda" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->moneda->getPlaceHolder()) ?>" value="<?php echo $products_add->moneda->EditValue ?>"<?php echo $products_add->moneda->editAttributes() ?>>
</span>
<?php echo $products_add->moneda->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->estado_inmueble->Visible) { // estado_inmueble ?>
	<div id="r_estado_inmueble" class="form-group row">
		<label id="elh_products_estado_inmueble" for="x_estado_inmueble" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->estado_inmueble->caption() ?><?php echo $products_add->estado_inmueble->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->estado_inmueble->cellAttributes() ?>>
<span id="el_products_estado_inmueble">
<input type="text" data-table="products" data-field="x_estado_inmueble" name="x_estado_inmueble" id="x_estado_inmueble" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->estado_inmueble->getPlaceHolder()) ?>" value="<?php echo $products_add->estado_inmueble->EditValue ?>"<?php echo $products_add->estado_inmueble->editAttributes() ?>>
</span>
<?php echo $products_add->estado_inmueble->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->area_construida->Visible) { // area_construida ?>
	<div id="r_area_construida" class="form-group row">
		<label id="elh_products_area_construida" for="x_area_construida" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->area_construida->caption() ?><?php echo $products_add->area_construida->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->area_construida->cellAttributes() ?>>
<span id="el_products_area_construida">
<input type="text" data-table="products" data-field="x_area_construida" name="x_area_construida" id="x_area_construida" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->area_construida->getPlaceHolder()) ?>" value="<?php echo $products_add->area_construida->EditValue ?>"<?php echo $products_add->area_construida->editAttributes() ?>>
</span>
<?php echo $products_add->area_construida->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->area_privada->Visible) { // area_privada ?>
	<div id="r_area_privada" class="form-group row">
		<label id="elh_products_area_privada" for="x_area_privada" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->area_privada->caption() ?><?php echo $products_add->area_privada->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->area_privada->cellAttributes() ?>>
<span id="el_products_area_privada">
<input type="text" data-table="products" data-field="x_area_privada" name="x_area_privada" id="x_area_privada" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->area_privada->getPlaceHolder()) ?>" value="<?php echo $products_add->area_privada->EditValue ?>"<?php echo $products_add->area_privada->editAttributes() ?>>
</span>
<?php echo $products_add->area_privada->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->area_terreno->Visible) { // area_terreno ?>
	<div id="r_area_terreno" class="form-group row">
		<label id="elh_products_area_terreno" for="x_area_terreno" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->area_terreno->caption() ?><?php echo $products_add->area_terreno->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->area_terreno->cellAttributes() ?>>
<span id="el_products_area_terreno">
<input type="text" data-table="products" data-field="x_area_terreno" name="x_area_terreno" id="x_area_terreno" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->area_terreno->getPlaceHolder()) ?>" value="<?php echo $products_add->area_terreno->EditValue ?>"<?php echo $products_add->area_terreno->editAttributes() ?>>
</span>
<?php echo $products_add->area_terreno->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->valor_administracion->Visible) { // valor_administracion ?>
	<div id="r_valor_administracion" class="form-group row">
		<label id="elh_products_valor_administracion" for="x_valor_administracion" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->valor_administracion->caption() ?><?php echo $products_add->valor_administracion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->valor_administracion->cellAttributes() ?>>
<span id="el_products_valor_administracion">
<input type="text" data-table="products" data-field="x_valor_administracion" name="x_valor_administracion" id="x_valor_administracion" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->valor_administracion->getPlaceHolder()) ?>" value="<?php echo $products_add->valor_administracion->EditValue ?>"<?php echo $products_add->valor_administracion->editAttributes() ?>>
</span>
<?php echo $products_add->valor_administracion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->dormitorios->Visible) { // dormitorios ?>
	<div id="r_dormitorios" class="form-group row">
		<label id="elh_products_dormitorios" for="x_dormitorios" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->dormitorios->caption() ?><?php echo $products_add->dormitorios->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->dormitorios->cellAttributes() ?>>
<span id="el_products_dormitorios">
<input type="text" data-table="products" data-field="x_dormitorios" name="x_dormitorios" id="x_dormitorios" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->dormitorios->getPlaceHolder()) ?>" value="<?php echo $products_add->dormitorios->EditValue ?>"<?php echo $products_add->dormitorios->editAttributes() ?>>
</span>
<?php echo $products_add->dormitorios->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->banios->Visible) { // banios ?>
	<div id="r_banios" class="form-group row">
		<label id="elh_products_banios" for="x_banios" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->banios->caption() ?><?php echo $products_add->banios->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->banios->cellAttributes() ?>>
<span id="el_products_banios">
<input type="text" data-table="products" data-field="x_banios" name="x_banios" id="x_banios" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->banios->getPlaceHolder()) ?>" value="<?php echo $products_add->banios->EditValue ?>"<?php echo $products_add->banios->editAttributes() ?>>
</span>
<?php echo $products_add->banios->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->garaje->Visible) { // garaje ?>
	<div id="r_garaje" class="form-group row">
		<label id="elh_products_garaje" for="x_garaje" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->garaje->caption() ?><?php echo $products_add->garaje->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->garaje->cellAttributes() ?>>
<span id="el_products_garaje">
<input type="text" data-table="products" data-field="x_garaje" name="x_garaje" id="x_garaje" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->garaje->getPlaceHolder()) ?>" value="<?php echo $products_add->garaje->EditValue ?>"<?php echo $products_add->garaje->editAttributes() ?>>
</span>
<?php echo $products_add->garaje->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->piso->Visible) { // piso ?>
	<div id="r_piso" class="form-group row">
		<label id="elh_products_piso" for="x_piso" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->piso->caption() ?><?php echo $products_add->piso->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->piso->cellAttributes() ?>>
<span id="el_products_piso">
<input type="text" data-table="products" data-field="x_piso" name="x_piso" id="x_piso" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->piso->getPlaceHolder()) ?>" value="<?php echo $products_add->piso->EditValue ?>"<?php echo $products_add->piso->editAttributes() ?>>
</span>
<?php echo $products_add->piso->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->estrato->Visible) { // estrato ?>
	<div id="r_estrato" class="form-group row">
		<label id="elh_products_estrato" for="x_estrato" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->estrato->caption() ?><?php echo $products_add->estrato->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->estrato->cellAttributes() ?>>
<span id="el_products_estrato">
<input type="text" data-table="products" data-field="x_estrato" name="x_estrato" id="x_estrato" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->estrato->getPlaceHolder()) ?>" value="<?php echo $products_add->estrato->EditValue ?>"<?php echo $products_add->estrato->editAttributes() ?>>
</span>
<?php echo $products_add->estrato->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->direccion->Visible) { // direccion ?>
	<div id="r_direccion" class="form-group row">
		<label id="elh_products_direccion" for="x_direccion" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->direccion->caption() ?><?php echo $products_add->direccion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->direccion->cellAttributes() ?>>
<span id="el_products_direccion">
<textarea data-table="products" data-field="x_direccion" name="x_direccion" id="x_direccion" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->direccion->getPlaceHolder()) ?>"<?php echo $products_add->direccion->editAttributes() ?>><?php echo $products_add->direccion->EditValue ?></textarea>
</span>
<?php echo $products_add->direccion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->codigo_postal->Visible) { // codigo_postal ?>
	<div id="r_codigo_postal" class="form-group row">
		<label id="elh_products_codigo_postal" for="x_codigo_postal" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->codigo_postal->caption() ?><?php echo $products_add->codigo_postal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->codigo_postal->cellAttributes() ?>>
<span id="el_products_codigo_postal">
<input type="text" data-table="products" data-field="x_codigo_postal" name="x_codigo_postal" id="x_codigo_postal" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->codigo_postal->getPlaceHolder()) ?>" value="<?php echo $products_add->codigo_postal->EditValue ?>"<?php echo $products_add->codigo_postal->editAttributes() ?>>
</span>
<?php echo $products_add->codigo_postal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->mapa->Visible) { // mapa ?>
	<div id="r_mapa" class="form-group row">
		<label id="elh_products_mapa" for="x_mapa" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->mapa->caption() ?><?php echo $products_add->mapa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->mapa->cellAttributes() ?>>
<span id="el_products_mapa">
<input type="text" data-table="products" data-field="x_mapa" name="x_mapa" id="x_mapa" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->mapa->getPlaceHolder()) ?>" value="<?php echo $products_add->mapa->EditValue ?>"<?php echo $products_add->mapa->editAttributes() ?>>
</span>
<?php echo $products_add->mapa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->latitud->Visible) { // latitud ?>
	<div id="r_latitud" class="form-group row">
		<label id="elh_products_latitud" for="x_latitud" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->latitud->caption() ?><?php echo $products_add->latitud->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->latitud->cellAttributes() ?>>
<span id="el_products_latitud">
<input type="text" data-table="products" data-field="x_latitud" name="x_latitud" id="x_latitud" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->latitud->getPlaceHolder()) ?>" value="<?php echo $products_add->latitud->EditValue ?>"<?php echo $products_add->latitud->editAttributes() ?>>
</span>
<?php echo $products_add->latitud->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->longitud->Visible) { // longitud ?>
	<div id="r_longitud" class="form-group row">
		<label id="elh_products_longitud" for="x_longitud" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->longitud->caption() ?><?php echo $products_add->longitud->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->longitud->cellAttributes() ?>>
<span id="el_products_longitud">
<input type="text" data-table="products" data-field="x_longitud" name="x_longitud" id="x_longitud" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->longitud->getPlaceHolder()) ?>" value="<?php echo $products_add->longitud->EditValue ?>"<?php echo $products_add->longitud->editAttributes() ?>>
</span>
<?php echo $products_add->longitud->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->opciones_mapa->Visible) { // opciones_mapa ?>
	<div id="r_opciones_mapa" class="form-group row">
		<label id="elh_products_opciones_mapa" for="x_opciones_mapa" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->opciones_mapa->caption() ?><?php echo $products_add->opciones_mapa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->opciones_mapa->cellAttributes() ?>>
<span id="el_products_opciones_mapa">
<input type="text" data-table="products" data-field="x_opciones_mapa" name="x_opciones_mapa" id="x_opciones_mapa" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->opciones_mapa->getPlaceHolder()) ?>" value="<?php echo $products_add->opciones_mapa->EditValue ?>"<?php echo $products_add->opciones_mapa->editAttributes() ?>>
</span>
<?php echo $products_add->opciones_mapa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->red->Visible) { // red ?>
	<div id="r_red" class="form-group row">
		<label id="elh_products_red" for="x_red" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->red->caption() ?><?php echo $products_add->red->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->red->cellAttributes() ?>>
<span id="el_products_red">
<input type="text" data-table="products" data-field="x_red" name="x_red" id="x_red" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->red->getPlaceHolder()) ?>" value="<?php echo $products_add->red->EditValue ?>"<?php echo $products_add->red->editAttributes() ?>>
</span>
<?php echo $products_add->red->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->video->Visible) { // video ?>
	<div id="r_video" class="form-group row">
		<label id="elh_products_video" for="x_video" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->video->caption() ?><?php echo $products_add->video->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->video->cellAttributes() ?>>
<span id="el_products_video">
<textarea data-table="products" data-field="x_video" name="x_video" id="x_video" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->video->getPlaceHolder()) ?>"<?php echo $products_add->video->editAttributes() ?>><?php echo $products_add->video->EditValue ?></textarea>
</span>
<?php echo $products_add->video->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->disponibilidad->Visible) { // disponibilidad ?>
	<div id="r_disponibilidad" class="form-group row">
		<label id="elh_products_disponibilidad" for="x_disponibilidad" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->disponibilidad->caption() ?><?php echo $products_add->disponibilidad->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->disponibilidad->cellAttributes() ?>>
<span id="el_products_disponibilidad">
<input type="text" data-table="products" data-field="x_disponibilidad" name="x_disponibilidad" id="x_disponibilidad" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->disponibilidad->getPlaceHolder()) ?>" value="<?php echo $products_add->disponibilidad->EditValue ?>"<?php echo $products_add->disponibilidad->editAttributes() ?>>
</span>
<?php echo $products_add->disponibilidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->anio_construccion->Visible) { // anio_construccion ?>
	<div id="r_anio_construccion" class="form-group row">
		<label id="elh_products_anio_construccion" for="x_anio_construccion" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->anio_construccion->caption() ?><?php echo $products_add->anio_construccion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->anio_construccion->cellAttributes() ?>>
<span id="el_products_anio_construccion">
<input type="text" data-table="products" data-field="x_anio_construccion" name="x_anio_construccion" id="x_anio_construccion" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->anio_construccion->getPlaceHolder()) ?>" value="<?php echo $products_add->anio_construccion->EditValue ?>"<?php echo $products_add->anio_construccion->editAttributes() ?>>
</span>
<?php echo $products_add->anio_construccion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->encargado->Visible) { // encargado ?>
	<div id="r_encargado" class="form-group row">
		<label id="elh_products_encargado" for="x_encargado" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->encargado->caption() ?><?php echo $products_add->encargado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->encargado->cellAttributes() ?>>
<span id="el_products_encargado">
<input type="text" data-table="products" data-field="x_encargado" name="x_encargado" id="x_encargado" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->encargado->getPlaceHolder()) ?>" value="<?php echo $products_add->encargado->EditValue ?>"<?php echo $products_add->encargado->editAttributes() ?>>
</span>
<?php echo $products_add->encargado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->comentario->Visible) { // comentario ?>
	<div id="r_comentario" class="form-group row">
		<label id="elh_products_comentario" for="x_comentario" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->comentario->caption() ?><?php echo $products_add->comentario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->comentario->cellAttributes() ?>>
<span id="el_products_comentario">
<textarea data-table="products" data-field="x_comentario" name="x_comentario" id="x_comentario" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->comentario->getPlaceHolder()) ?>"<?php echo $products_add->comentario->editAttributes() ?>><?php echo $products_add->comentario->EditValue ?></textarea>
</span>
<?php echo $products_add->comentario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->visitas->Visible) { // visitas ?>
	<div id="r_visitas" class="form-group row">
		<label id="elh_products_visitas" for="x_visitas" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->visitas->caption() ?><?php echo $products_add->visitas->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->visitas->cellAttributes() ?>>
<span id="el_products_visitas">
<input type="text" data-table="products" data-field="x_visitas" name="x_visitas" id="x_visitas" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->visitas->getPlaceHolder()) ?>" value="<?php echo $products_add->visitas->EditValue ?>"<?php echo $products_add->visitas->editAttributes() ?>>
</span>
<?php echo $products_add->visitas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->valor_comision->Visible) { // valor_comision ?>
	<div id="r_valor_comision" class="form-group row">
		<label id="elh_products_valor_comision" for="x_valor_comision" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->valor_comision->caption() ?><?php echo $products_add->valor_comision->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->valor_comision->cellAttributes() ?>>
<span id="el_products_valor_comision">
<input type="text" data-table="products" data-field="x_valor_comision" name="x_valor_comision" id="x_valor_comision" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->valor_comision->getPlaceHolder()) ?>" value="<?php echo $products_add->valor_comision->EditValue ?>"<?php echo $products_add->valor_comision->editAttributes() ?>>
</span>
<?php echo $products_add->valor_comision->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->tipo_comision->Visible) { // tipo_comision ?>
	<div id="r_tipo_comision" class="form-group row">
		<label id="elh_products_tipo_comision" for="x_tipo_comision" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->tipo_comision->caption() ?><?php echo $products_add->tipo_comision->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->tipo_comision->cellAttributes() ?>>
<span id="el_products_tipo_comision">
<input type="text" data-table="products" data-field="x_tipo_comision" name="x_tipo_comision" id="x_tipo_comision" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->tipo_comision->getPlaceHolder()) ?>" value="<?php echo $products_add->tipo_comision->EditValue ?>"<?php echo $products_add->tipo_comision->editAttributes() ?>>
</span>
<?php echo $products_add->tipo_comision->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->certificado->Visible) { // certificado ?>
	<div id="r_certificado" class="form-group row">
		<label id="elh_products_certificado" for="x_certificado" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->certificado->caption() ?><?php echo $products_add->certificado->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->certificado->cellAttributes() ?>>
<span id="el_products_certificado">
<input type="text" data-table="products" data-field="x_certificado" name="x_certificado" id="x_certificado" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->certificado->getPlaceHolder()) ?>" value="<?php echo $products_add->certificado->EditValue ?>"<?php echo $products_add->certificado->editAttributes() ?>>
</span>
<?php echo $products_add->certificado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->nombre_propietario->Visible) { // nombre_propietario ?>
	<div id="r_nombre_propietario" class="form-group row">
		<label id="elh_products_nombre_propietario" for="x_nombre_propietario" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->nombre_propietario->caption() ?><?php echo $products_add->nombre_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->nombre_propietario->cellAttributes() ?>>
<span id="el_products_nombre_propietario">
<input type="text" data-table="products" data-field="x_nombre_propietario" name="x_nombre_propietario" id="x_nombre_propietario" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->nombre_propietario->getPlaceHolder()) ?>" value="<?php echo $products_add->nombre_propietario->EditValue ?>"<?php echo $products_add->nombre_propietario->editAttributes() ?>>
</span>
<?php echo $products_add->nombre_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->movil_propietario->Visible) { // movil_propietario ?>
	<div id="r_movil_propietario" class="form-group row">
		<label id="elh_products_movil_propietario" for="x_movil_propietario" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->movil_propietario->caption() ?><?php echo $products_add->movil_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->movil_propietario->cellAttributes() ?>>
<span id="el_products_movil_propietario">
<input type="text" data-table="products" data-field="x_movil_propietario" name="x_movil_propietario" id="x_movil_propietario" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_add->movil_propietario->getPlaceHolder()) ?>" value="<?php echo $products_add->movil_propietario->EditValue ?>"<?php echo $products_add->movil_propietario->editAttributes() ?>>
</span>
<?php echo $products_add->movil_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->telefono_propietario->Visible) { // telefono_propietario ?>
	<div id="r_telefono_propietario" class="form-group row">
		<label id="elh_products_telefono_propietario" for="x_telefono_propietario" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->telefono_propietario->caption() ?><?php echo $products_add->telefono_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->telefono_propietario->cellAttributes() ?>>
<span id="el_products_telefono_propietario">
<input type="text" data-table="products" data-field="x_telefono_propietario" name="x_telefono_propietario" id="x_telefono_propietario" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_add->telefono_propietario->getPlaceHolder()) ?>" value="<?php echo $products_add->telefono_propietario->EditValue ?>"<?php echo $products_add->telefono_propietario->editAttributes() ?>>
</span>
<?php echo $products_add->telefono_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->correo_propietario->Visible) { // correo_propietario ?>
	<div id="r_correo_propietario" class="form-group row">
		<label id="elh_products_correo_propietario" for="x_correo_propietario" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->correo_propietario->caption() ?><?php echo $products_add->correo_propietario->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->correo_propietario->cellAttributes() ?>>
<span id="el_products_correo_propietario">
<input type="text" data-table="products" data-field="x_correo_propietario" name="x_correo_propietario" id="x_correo_propietario" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->correo_propietario->getPlaceHolder()) ?>" value="<?php echo $products_add->correo_propietario->EditValue ?>"<?php echo $products_add->correo_propietario->editAttributes() ?>>
</span>
<?php echo $products_add->correo_propietario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->vinculo->Visible) { // vinculo ?>
	<div id="r_vinculo" class="form-group row">
		<label id="elh_products_vinculo" for="x_vinculo" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->vinculo->caption() ?><?php echo $products_add->vinculo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->vinculo->cellAttributes() ?>>
<span id="el_products_vinculo">
<input type="text" data-table="products" data-field="x_vinculo" name="x_vinculo" id="x_vinculo" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->vinculo->getPlaceHolder()) ?>" value="<?php echo $products_add->vinculo->EditValue ?>"<?php echo $products_add->vinculo->editAttributes() ?>>
</span>
<?php echo $products_add->vinculo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->portales->Visible) { // portales ?>
	<div id="r_portales" class="form-group row">
		<label id="elh_products_portales" for="x_portales" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->portales->caption() ?><?php echo $products_add->portales->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->portales->cellAttributes() ?>>
<span id="el_products_portales">
<textarea data-table="products" data-field="x_portales" name="x_portales" id="x_portales" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->portales->getPlaceHolder()) ?>"<?php echo $products_add->portales->editAttributes() ?>><?php echo $products_add->portales->EditValue ?></textarea>
</span>
<?php echo $products_add->portales->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->notas->Visible) { // notas ?>
	<div id="r_notas" class="form-group row">
		<label id="elh_products_notas" for="x_notas" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->notas->caption() ?><?php echo $products_add->notas->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->notas->cellAttributes() ?>>
<span id="el_products_notas">
<input type="text" data-table="products" data-field="x_notas" name="x_notas" id="x_notas" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($products_add->notas->getPlaceHolder()) ?>" value="<?php echo $products_add->notas->EditValue ?>"<?php echo $products_add->notas->editAttributes() ?>>
</span>
<?php echo $products_add->notas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->marca->Visible) { // marca ?>
	<div id="r_marca" class="form-group row">
		<label id="elh_products_marca" for="x_marca" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->marca->caption() ?><?php echo $products_add->marca->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->marca->cellAttributes() ?>>
<span id="el_products_marca">
<input type="text" data-table="products" data-field="x_marca" name="x_marca" id="x_marca" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_add->marca->getPlaceHolder()) ?>" value="<?php echo $products_add->marca->EditValue ?>"<?php echo $products_add->marca->editAttributes() ?>>
</span>
<?php echo $products_add->marca->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->modelo->Visible) { // modelo ?>
	<div id="r_modelo" class="form-group row">
		<label id="elh_products_modelo" for="x_modelo" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->modelo->caption() ?><?php echo $products_add->modelo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->modelo->cellAttributes() ?>>
<span id="el_products_modelo">
<input type="text" data-table="products" data-field="x_modelo" name="x_modelo" id="x_modelo" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_add->modelo->getPlaceHolder()) ?>" value="<?php echo $products_add->modelo->EditValue ?>"<?php echo $products_add->modelo->editAttributes() ?>>
</span>
<?php echo $products_add->modelo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_products_color" for="x_color" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->color->caption() ?><?php echo $products_add->color->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->color->cellAttributes() ?>>
<span id="el_products_color">
<input type="text" data-table="products" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($products_add->color->getPlaceHolder()) ?>" value="<?php echo $products_add->color->EditValue ?>"<?php echo $products_add->color->editAttributes() ?>>
</span>
<?php echo $products_add->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b1->Visible) { // b1 ?>
	<div id="r_b1" class="form-group row">
		<label id="elh_products_b1" for="x_b1" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b1->caption() ?><?php echo $products_add->b1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b1->cellAttributes() ?>>
<span id="el_products_b1">
<input type="text" data-table="products" data-field="x_b1" name="x_b1" id="x_b1" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b1->getPlaceHolder()) ?>" value="<?php echo $products_add->b1->EditValue ?>"<?php echo $products_add->b1->editAttributes() ?>>
</span>
<?php echo $products_add->b1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b2->Visible) { // b2 ?>
	<div id="r_b2" class="form-group row">
		<label id="elh_products_b2" for="x_b2" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b2->caption() ?><?php echo $products_add->b2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b2->cellAttributes() ?>>
<span id="el_products_b2">
<input type="text" data-table="products" data-field="x_b2" name="x_b2" id="x_b2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b2->getPlaceHolder()) ?>" value="<?php echo $products_add->b2->EditValue ?>"<?php echo $products_add->b2->editAttributes() ?>>
</span>
<?php echo $products_add->b2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b3->Visible) { // b3 ?>
	<div id="r_b3" class="form-group row">
		<label id="elh_products_b3" for="x_b3" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b3->caption() ?><?php echo $products_add->b3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b3->cellAttributes() ?>>
<span id="el_products_b3">
<input type="text" data-table="products" data-field="x_b3" name="x_b3" id="x_b3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b3->getPlaceHolder()) ?>" value="<?php echo $products_add->b3->EditValue ?>"<?php echo $products_add->b3->editAttributes() ?>>
</span>
<?php echo $products_add->b3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b4->Visible) { // b4 ?>
	<div id="r_b4" class="form-group row">
		<label id="elh_products_b4" for="x_b4" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b4->caption() ?><?php echo $products_add->b4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b4->cellAttributes() ?>>
<span id="el_products_b4">
<input type="text" data-table="products" data-field="x_b4" name="x_b4" id="x_b4" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b4->getPlaceHolder()) ?>" value="<?php echo $products_add->b4->EditValue ?>"<?php echo $products_add->b4->editAttributes() ?>>
</span>
<?php echo $products_add->b4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b5->Visible) { // b5 ?>
	<div id="r_b5" class="form-group row">
		<label id="elh_products_b5" for="x_b5" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b5->caption() ?><?php echo $products_add->b5->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b5->cellAttributes() ?>>
<span id="el_products_b5">
<input type="text" data-table="products" data-field="x_b5" name="x_b5" id="x_b5" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b5->getPlaceHolder()) ?>" value="<?php echo $products_add->b5->EditValue ?>"<?php echo $products_add->b5->editAttributes() ?>>
</span>
<?php echo $products_add->b5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->b6->Visible) { // b6 ?>
	<div id="r_b6" class="form-group row">
		<label id="elh_products_b6" for="x_b6" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->b6->caption() ?><?php echo $products_add->b6->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->b6->cellAttributes() ?>>
<span id="el_products_b6">
<input type="text" data-table="products" data-field="x_b6" name="x_b6" id="x_b6" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->b6->getPlaceHolder()) ?>" value="<?php echo $products_add->b6->EditValue ?>"<?php echo $products_add->b6->editAttributes() ?>>
</span>
<?php echo $products_add->b6->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->cat_pro->Visible) { // cat_pro ?>
	<div id="r_cat_pro" class="form-group row">
		<label id="elh_products_cat_pro" for="x_cat_pro" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->cat_pro->caption() ?><?php echo $products_add->cat_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->cat_pro->cellAttributes() ?>>
<span id="el_products_cat_pro">
<input type="text" data-table="products" data-field="x_cat_pro" name="x_cat_pro" id="x_cat_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->cat_pro->getPlaceHolder()) ?>" value="<?php echo $products_add->cat_pro->EditValue ?>"<?php echo $products_add->cat_pro->editAttributes() ?>>
</span>
<?php echo $products_add->cat_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->pro_ser->Visible) { // pro_ser ?>
	<div id="r_pro_ser" class="form-group row">
		<label id="elh_products_pro_ser" for="x_pro_ser" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->pro_ser->caption() ?><?php echo $products_add->pro_ser->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->pro_ser->cellAttributes() ?>>
<span id="el_products_pro_ser">
<input type="text" data-table="products" data-field="x_pro_ser" name="x_pro_ser" id="x_pro_ser" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->pro_ser->getPlaceHolder()) ?>" value="<?php echo $products_add->pro_ser->EditValue ?>"<?php echo $products_add->pro_ser->editAttributes() ?>>
</span>
<?php echo $products_add->pro_ser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->foto1->Visible) { // foto1 ?>
	<div id="r_foto1" class="form-group row">
		<label id="elh_products_foto1" for="x_foto1" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->foto1->caption() ?><?php echo $products_add->foto1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->foto1->cellAttributes() ?>>
<span id="el_products_foto1">
<textarea data-table="products" data-field="x_foto1" name="x_foto1" id="x_foto1" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->foto1->getPlaceHolder()) ?>"<?php echo $products_add->foto1->editAttributes() ?>><?php echo $products_add->foto1->EditValue ?></textarea>
</span>
<?php echo $products_add->foto1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->foto2->Visible) { // foto2 ?>
	<div id="r_foto2" class="form-group row">
		<label id="elh_products_foto2" for="x_foto2" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->foto2->caption() ?><?php echo $products_add->foto2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->foto2->cellAttributes() ?>>
<span id="el_products_foto2">
<input type="text" data-table="products" data-field="x_foto2" name="x_foto2" id="x_foto2" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->foto2->getPlaceHolder()) ?>" value="<?php echo $products_add->foto2->EditValue ?>"<?php echo $products_add->foto2->editAttributes() ?>>
</span>
<?php echo $products_add->foto2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->foto3->Visible) { // foto3 ?>
	<div id="r_foto3" class="form-group row">
		<label id="elh_products_foto3" for="x_foto3" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->foto3->caption() ?><?php echo $products_add->foto3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->foto3->cellAttributes() ?>>
<span id="el_products_foto3">
<input type="text" data-table="products" data-field="x_foto3" name="x_foto3" id="x_foto3" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->foto3->getPlaceHolder()) ?>" value="<?php echo $products_add->foto3->EditValue ?>"<?php echo $products_add->foto3->editAttributes() ?>>
</span>
<?php echo $products_add->foto3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->foto4->Visible) { // foto4 ?>
	<div id="r_foto4" class="form-group row">
		<label id="elh_products_foto4" for="x_foto4" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->foto4->caption() ?><?php echo $products_add->foto4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->foto4->cellAttributes() ?>>
<span id="el_products_foto4">
<input type="text" data-table="products" data-field="x_foto4" name="x_foto4" id="x_foto4" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->foto4->getPlaceHolder()) ?>" value="<?php echo $products_add->foto4->EditValue ?>"<?php echo $products_add->foto4->editAttributes() ?>>
</span>
<?php echo $products_add->foto4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->web->Visible) { // web ?>
	<div id="r_web" class="form-group row">
		<label id="elh_products_web" for="x_web" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->web->caption() ?><?php echo $products_add->web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->web->cellAttributes() ?>>
<span id="el_products_web">
<input type="text" data-table="products" data-field="x_web" name="x_web" id="x_web" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->web->getPlaceHolder()) ?>" value="<?php echo $products_add->web->EditValue ?>"<?php echo $products_add->web->editAttributes() ?>>
</span>
<?php echo $products_add->web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->pre_web->Visible) { // pre_web ?>
	<div id="r_pre_web" class="form-group row">
		<label id="elh_products_pre_web" for="x_pre_web" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->pre_web->caption() ?><?php echo $products_add->pre_web->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->pre_web->cellAttributes() ?>>
<span id="el_products_pre_web">
<input type="text" data-table="products" data-field="x_pre_web" name="x_pre_web" id="x_pre_web" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->pre_web->getPlaceHolder()) ?>" value="<?php echo $products_add->pre_web->EditValue ?>"<?php echo $products_add->pre_web->editAttributes() ?>>
</span>
<?php echo $products_add->pre_web->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->descripcion->Visible) { // descripcion ?>
	<div id="r_descripcion" class="form-group row">
		<label id="elh_products_descripcion" for="x_descripcion" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->descripcion->caption() ?><?php echo $products_add->descripcion->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->descripcion->cellAttributes() ?>>
<span id="el_products_descripcion">
<textarea data-table="products" data-field="x_descripcion" name="x_descripcion" id="x_descripcion" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->descripcion->getPlaceHolder()) ?>"<?php echo $products_add->descripcion->editAttributes() ?>><?php echo $products_add->descripcion->EditValue ?></textarea>
</span>
<?php echo $products_add->descripcion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->descripcion1->Visible) { // descripcion1 ?>
	<div id="r_descripcion1" class="form-group row">
		<label id="elh_products_descripcion1" for="x_descripcion1" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->descripcion1->caption() ?><?php echo $products_add->descripcion1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->descripcion1->cellAttributes() ?>>
<span id="el_products_descripcion1">
<textarea data-table="products" data-field="x_descripcion1" name="x_descripcion1" id="x_descripcion1" cols="35" rows="4" placeholder="<?php echo HtmlEncode($products_add->descripcion1->getPlaceHolder()) ?>"<?php echo $products_add->descripcion1->editAttributes() ?>><?php echo $products_add->descripcion1->EditValue ?></textarea>
</span>
<?php echo $products_add->descripcion1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->megusta->Visible) { // megusta ?>
	<div id="r_megusta" class="form-group row">
		<label id="elh_products_megusta" for="x_megusta" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->megusta->caption() ?><?php echo $products_add->megusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->megusta->cellAttributes() ?>>
<span id="el_products_megusta">
<input type="text" data-table="products" data-field="x_megusta" name="x_megusta" id="x_megusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->megusta->getPlaceHolder()) ?>" value="<?php echo $products_add->megusta->EditValue ?>"<?php echo $products_add->megusta->editAttributes() ?>>
</span>
<?php echo $products_add->megusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->nomegusta->Visible) { // nomegusta ?>
	<div id="r_nomegusta" class="form-group row">
		<label id="elh_products_nomegusta" for="x_nomegusta" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->nomegusta->caption() ?><?php echo $products_add->nomegusta->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->nomegusta->cellAttributes() ?>>
<span id="el_products_nomegusta">
<input type="text" data-table="products" data-field="x_nomegusta" name="x_nomegusta" id="x_nomegusta" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->nomegusta->getPlaceHolder()) ?>" value="<?php echo $products_add->nomegusta->EditValue ?>"<?php echo $products_add->nomegusta->editAttributes() ?>>
</span>
<?php echo $products_add->nomegusta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->precio2->Visible) { // precio2 ?>
	<div id="r_precio2" class="form-group row">
		<label id="elh_products_precio2" for="x_precio2" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->precio2->caption() ?><?php echo $products_add->precio2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->precio2->cellAttributes() ?>>
<span id="el_products_precio2">
<input type="text" data-table="products" data-field="x_precio2" name="x_precio2" id="x_precio2" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->precio2->getPlaceHolder()) ?>" value="<?php echo $products_add->precio2->EditValue ?>"<?php echo $products_add->precio2->editAttributes() ?>>
</span>
<?php echo $products_add->precio2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->precio3->Visible) { // precio3 ?>
	<div id="r_precio3" class="form-group row">
		<label id="elh_products_precio3" for="x_precio3" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->precio3->caption() ?><?php echo $products_add->precio3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->precio3->cellAttributes() ?>>
<span id="el_products_precio3">
<input type="text" data-table="products" data-field="x_precio3" name="x_precio3" id="x_precio3" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->precio3->getPlaceHolder()) ?>" value="<?php echo $products_add->precio3->EditValue ?>"<?php echo $products_add->precio3->editAttributes() ?>>
</span>
<?php echo $products_add->precio3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->und_pro->Visible) { // und_pro ?>
	<div id="r_und_pro" class="form-group row">
		<label id="elh_products_und_pro" for="x_und_pro" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->und_pro->caption() ?><?php echo $products_add->und_pro->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->und_pro->cellAttributes() ?>>
<span id="el_products_und_pro">
<input type="text" data-table="products" data-field="x_und_pro" name="x_und_pro" id="x_und_pro" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->und_pro->getPlaceHolder()) ?>" value="<?php echo $products_add->und_pro->EditValue ?>"<?php echo $products_add->und_pro->editAttributes() ?>>
</span>
<?php echo $products_add->und_pro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->barras->Visible) { // barras ?>
	<div id="r_barras" class="form-group row">
		<label id="elh_products_barras" for="x_barras" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->barras->caption() ?><?php echo $products_add->barras->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->barras->cellAttributes() ?>>
<span id="el_products_barras">
<input type="text" data-table="products" data-field="x_barras" name="x_barras" id="x_barras" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($products_add->barras->getPlaceHolder()) ?>" value="<?php echo $products_add->barras->EditValue ?>"<?php echo $products_add->barras->editAttributes() ?>>
</span>
<?php echo $products_add->barras->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->stockmin->Visible) { // stockmin ?>
	<div id="r_stockmin" class="form-group row">
		<label id="elh_products_stockmin" for="x_stockmin" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->stockmin->caption() ?><?php echo $products_add->stockmin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->stockmin->cellAttributes() ?>>
<span id="el_products_stockmin">
<input type="text" data-table="products" data-field="x_stockmin" name="x_stockmin" id="x_stockmin" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->stockmin->getPlaceHolder()) ?>" value="<?php echo $products_add->stockmin->EditValue ?>"<?php echo $products_add->stockmin->editAttributes() ?>>
</span>
<?php echo $products_add->stockmin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->id_grupo->Visible) { // id_grupo ?>
	<div id="r_id_grupo" class="form-group row">
		<label id="elh_products_id_grupo" for="x_id_grupo" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->id_grupo->caption() ?><?php echo $products_add->id_grupo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->id_grupo->cellAttributes() ?>>
<span id="el_products_id_grupo">
<input type="text" data-table="products" data-field="x_id_grupo" name="x_id_grupo" id="x_id_grupo" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->id_grupo->getPlaceHolder()) ?>" value="<?php echo $products_add->id_grupo->EditValue ?>"<?php echo $products_add->id_grupo->editAttributes() ?>>
</span>
<?php echo $products_add->id_grupo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->talla->Visible) { // talla ?>
	<div id="r_talla" class="form-group row">
		<label id="elh_products_talla" for="x_talla" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->talla->caption() ?><?php echo $products_add->talla->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->talla->cellAttributes() ?>>
<span id="el_products_talla">
<input type="text" data-table="products" data-field="x_talla" name="x_talla" id="x_talla" size="30" maxlength="110" placeholder="<?php echo HtmlEncode($products_add->talla->getPlaceHolder()) ?>" value="<?php echo $products_add->talla->EditValue ?>"<?php echo $products_add->talla->editAttributes() ?>>
</span>
<?php echo $products_add->talla->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->mostrarcolor->Visible) { // mostrarcolor ?>
	<div id="r_mostrarcolor" class="form-group row">
		<label id="elh_products_mostrarcolor" for="x_mostrarcolor" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->mostrarcolor->caption() ?><?php echo $products_add->mostrarcolor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->mostrarcolor->cellAttributes() ?>>
<span id="el_products_mostrarcolor">
<input type="text" data-table="products" data-field="x_mostrarcolor" name="x_mostrarcolor" id="x_mostrarcolor" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->mostrarcolor->getPlaceHolder()) ?>" value="<?php echo $products_add->mostrarcolor->EditValue ?>"<?php echo $products_add->mostrarcolor->editAttributes() ?>>
</span>
<?php echo $products_add->mostrarcolor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->precio_mayorista->Visible) { // precio_mayorista ?>
	<div id="r_precio_mayorista" class="form-group row">
		<label id="elh_products_precio_mayorista" for="x_precio_mayorista" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->precio_mayorista->caption() ?><?php echo $products_add->precio_mayorista->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->precio_mayorista->cellAttributes() ?>>
<span id="el_products_precio_mayorista">
<input type="text" data-table="products" data-field="x_precio_mayorista" name="x_precio_mayorista" id="x_precio_mayorista" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->precio_mayorista->getPlaceHolder()) ?>" value="<?php echo $products_add->precio_mayorista->EditValue ?>"<?php echo $products_add->precio_mayorista->editAttributes() ?>>
</span>
<?php echo $products_add->precio_mayorista->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->precio_vendedor->Visible) { // precio_vendedor ?>
	<div id="r_precio_vendedor" class="form-group row">
		<label id="elh_products_precio_vendedor" for="x_precio_vendedor" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->precio_vendedor->caption() ?><?php echo $products_add->precio_vendedor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->precio_vendedor->cellAttributes() ?>>
<span id="el_products_precio_vendedor">
<input type="text" data-table="products" data-field="x_precio_vendedor" name="x_precio_vendedor" id="x_precio_vendedor" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($products_add->precio_vendedor->getPlaceHolder()) ?>" value="<?php echo $products_add->precio_vendedor->EditValue ?>"<?php echo $products_add->precio_vendedor->editAttributes() ?>>
</span>
<?php echo $products_add->precio_vendedor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->medida1->Visible) { // medida1 ?>
	<div id="r_medida1" class="form-group row">
		<label id="elh_products_medida1" for="x_medida1" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->medida1->caption() ?><?php echo $products_add->medida1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->medida1->cellAttributes() ?>>
<span id="el_products_medida1">
<input type="text" data-table="products" data-field="x_medida1" name="x_medida1" id="x_medida1" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->medida1->getPlaceHolder()) ?>" value="<?php echo $products_add->medida1->EditValue ?>"<?php echo $products_add->medida1->editAttributes() ?>>
</span>
<?php echo $products_add->medida1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->medida2->Visible) { // medida2 ?>
	<div id="r_medida2" class="form-group row">
		<label id="elh_products_medida2" for="x_medida2" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->medida2->caption() ?><?php echo $products_add->medida2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->medida2->cellAttributes() ?>>
<span id="el_products_medida2">
<input type="text" data-table="products" data-field="x_medida2" name="x_medida2" id="x_medida2" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->medida2->getPlaceHolder()) ?>" value="<?php echo $products_add->medida2->EditValue ?>"<?php echo $products_add->medida2->editAttributes() ?>>
</span>
<?php echo $products_add->medida2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->medida3->Visible) { // medida3 ?>
	<div id="r_medida3" class="form-group row">
		<label id="elh_products_medida3" for="x_medida3" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->medida3->caption() ?><?php echo $products_add->medida3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->medida3->cellAttributes() ?>>
<span id="el_products_medida3">
<input type="text" data-table="products" data-field="x_medida3" name="x_medida3" id="x_medida3" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($products_add->medida3->getPlaceHolder()) ?>" value="<?php echo $products_add->medida3->EditValue ?>"<?php echo $products_add->medida3->editAttributes() ?>>
</span>
<?php echo $products_add->medida3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->codlogin->Visible) { // codlogin ?>
	<div id="r_codlogin" class="form-group row">
		<label id="elh_products_codlogin" for="x_codlogin" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->codlogin->caption() ?><?php echo $products_add->codlogin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->codlogin->cellAttributes() ?>>
<span id="el_products_codlogin">
<input type="text" data-table="products" data-field="x_codlogin" name="x_codlogin" id="x_codlogin" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($products_add->codlogin->getPlaceHolder()) ?>" value="<?php echo $products_add->codlogin->EditValue ?>"<?php echo $products_add->codlogin->editAttributes() ?>>
</span>
<?php echo $products_add->codlogin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->idempresa->Visible) { // idempresa ?>
	<div id="r_idempresa" class="form-group row">
		<label id="elh_products_idempresa" for="x_idempresa" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->idempresa->caption() ?><?php echo $products_add->idempresa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->idempresa->cellAttributes() ?>>
<span id="el_products_idempresa">
<input type="text" data-table="products" data-field="x_idempresa" name="x_idempresa" id="x_idempresa" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($products_add->idempresa->getPlaceHolder()) ?>" value="<?php echo $products_add->idempresa->EditValue ?>"<?php echo $products_add->idempresa->editAttributes() ?>>
</span>
<?php echo $products_add->idempresa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($products_add->urlstreetview->Visible) { // urlstreetview ?>
	<div id="r_urlstreetview" class="form-group row">
		<label id="elh_products_urlstreetview" for="x_urlstreetview" class="<?php echo $products_add->LeftColumnClass ?>"><?php echo $products_add->urlstreetview->caption() ?><?php echo $products_add->urlstreetview->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $products_add->RightColumnClass ?>"><div <?php echo $products_add->urlstreetview->cellAttributes() ?>>
<span id="el_products_urlstreetview">
<input type="text" data-table="products" data-field="x_urlstreetview" name="x_urlstreetview" id="x_urlstreetview" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($products_add->urlstreetview->getPlaceHolder()) ?>" value="<?php echo $products_add->urlstreetview->EditValue ?>"<?php echo $products_add->urlstreetview->editAttributes() ?>>
</span>
<?php echo $products_add->urlstreetview->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$products_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $products_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $products_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$products_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$products_add->terminate();
?>