<?php
namespace PHPMaker2020\project2;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$products_view = new products_view();

// Run the page
$products_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$products_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$products_view->isExport()) { ?>
<script>
var fproductsview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fproductsview = currentForm = new ew.Form("fproductsview", "view");
	loadjs.done("fproductsview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$products_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $products_view->ExportOptions->render("body") ?>
<?php $products_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $products_view->showPageHeader(); ?>
<?php
$products_view->showMessage();
?>
<form name="fproductsview" id="fproductsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="products">
<input type="hidden" name="modal" value="<?php echo (int)$products_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($products_view->id_producto->Visible) { // id_producto ?>
	<tr id="r_id_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_id_producto"><?php echo $products_view->id_producto->caption() ?></span></td>
		<td data-name="id_producto" <?php echo $products_view->id_producto->cellAttributes() ?>>
<span id="el_products_id_producto">
<span<?php echo $products_view->id_producto->viewAttributes() ?>><?php echo $products_view->id_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->codigo_producto->Visible) { // codigo_producto ?>
	<tr id="r_codigo_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_codigo_producto"><?php echo $products_view->codigo_producto->caption() ?></span></td>
		<td data-name="codigo_producto" <?php echo $products_view->codigo_producto->cellAttributes() ?>>
<span id="el_products_codigo_producto">
<span<?php echo $products_view->codigo_producto->viewAttributes() ?>><?php echo $products_view->codigo_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->nombre_producto->Visible) { // nombre_producto ?>
	<tr id="r_nombre_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_nombre_producto"><?php echo $products_view->nombre_producto->caption() ?></span></td>
		<td data-name="nombre_producto" <?php echo $products_view->nombre_producto->cellAttributes() ?>>
<span id="el_products_nombre_producto">
<span<?php echo $products_view->nombre_producto->viewAttributes() ?>><?php echo $products_view->nombre_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->estado->Visible) { // estado ?>
	<tr id="r_estado">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_estado"><?php echo $products_view->estado->caption() ?></span></td>
		<td data-name="estado" <?php echo $products_view->estado->cellAttributes() ?>>
<span id="el_products_estado">
<span<?php echo $products_view->estado->viewAttributes() ?>><?php echo $products_view->estado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->status_producto->Visible) { // status_producto ?>
	<tr id="r_status_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_status_producto"><?php echo $products_view->status_producto->caption() ?></span></td>
		<td data-name="status_producto" <?php echo $products_view->status_producto->cellAttributes() ?>>
<span id="el_products_status_producto">
<span<?php echo $products_view->status_producto->viewAttributes() ?>><?php echo $products_view->status_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->date_added->Visible) { // date_added ?>
	<tr id="r_date_added">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_date_added"><?php echo $products_view->date_added->caption() ?></span></td>
		<td data-name="date_added" <?php echo $products_view->date_added->cellAttributes() ?>>
<span id="el_products_date_added">
<span<?php echo $products_view->date_added->viewAttributes() ?>><?php echo $products_view->date_added->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->precio_producto->Visible) { // precio_producto ?>
	<tr id="r_precio_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_precio_producto"><?php echo $products_view->precio_producto->caption() ?></span></td>
		<td data-name="precio_producto" <?php echo $products_view->precio_producto->cellAttributes() ?>>
<span id="el_products_precio_producto">
<span<?php echo $products_view->precio_producto->viewAttributes() ?>><?php echo $products_view->precio_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->costo_producto->Visible) { // costo_producto ?>
	<tr id="r_costo_producto">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_costo_producto"><?php echo $products_view->costo_producto->caption() ?></span></td>
		<td data-name="costo_producto" <?php echo $products_view->costo_producto->cellAttributes() ?>>
<span id="el_products_costo_producto">
<span<?php echo $products_view->costo_producto->viewAttributes() ?>><?php echo $products_view->costo_producto->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->mon_costo->Visible) { // mon_costo ?>
	<tr id="r_mon_costo">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_mon_costo"><?php echo $products_view->mon_costo->caption() ?></span></td>
		<td data-name="mon_costo" <?php echo $products_view->mon_costo->cellAttributes() ?>>
<span id="el_products_mon_costo">
<span<?php echo $products_view->mon_costo->viewAttributes() ?>><?php echo $products_view->mon_costo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->mon_venta->Visible) { // mon_venta ?>
	<tr id="r_mon_venta">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_mon_venta"><?php echo $products_view->mon_venta->caption() ?></span></td>
		<td data-name="mon_venta" <?php echo $products_view->mon_venta->cellAttributes() ?>>
<span id="el_products_mon_venta">
<span<?php echo $products_view->mon_venta->viewAttributes() ?>><?php echo $products_view->mon_venta->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->pais->Visible) { // pais ?>
	<tr id="r_pais">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_pais"><?php echo $products_view->pais->caption() ?></span></td>
		<td data-name="pais" <?php echo $products_view->pais->cellAttributes() ?>>
<span id="el_products_pais">
<span<?php echo $products_view->pais->viewAttributes() ?>><?php echo $products_view->pais->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->departamento->Visible) { // departamento ?>
	<tr id="r_departamento">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_departamento"><?php echo $products_view->departamento->caption() ?></span></td>
		<td data-name="departamento" <?php echo $products_view->departamento->cellAttributes() ?>>
<span id="el_products_departamento">
<span<?php echo $products_view->departamento->viewAttributes() ?>><?php echo $products_view->departamento->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->distrito->Visible) { // distrito ?>
	<tr id="r_distrito">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_distrito"><?php echo $products_view->distrito->caption() ?></span></td>
		<td data-name="distrito" <?php echo $products_view->distrito->cellAttributes() ?>>
<span id="el_products_distrito">
<span<?php echo $products_view->distrito->viewAttributes() ?>><?php echo $products_view->distrito->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->localidad->Visible) { // localidad ?>
	<tr id="r_localidad">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_localidad"><?php echo $products_view->localidad->caption() ?></span></td>
		<td data-name="localidad" <?php echo $products_view->localidad->cellAttributes() ?>>
<span id="el_products_localidad">
<span<?php echo $products_view->localidad->viewAttributes() ?>><?php echo $products_view->localidad->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->zona->Visible) { // zona ?>
	<tr id="r_zona">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_zona"><?php echo $products_view->zona->caption() ?></span></td>
		<td data-name="zona" <?php echo $products_view->zona->cellAttributes() ?>>
<span id="el_products_zona">
<span<?php echo $products_view->zona->viewAttributes() ?>><?php echo $products_view->zona->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->tipo_inmueble->Visible) { // tipo_inmueble ?>
	<tr id="r_tipo_inmueble">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_tipo_inmueble"><?php echo $products_view->tipo_inmueble->caption() ?></span></td>
		<td data-name="tipo_inmueble" <?php echo $products_view->tipo_inmueble->cellAttributes() ?>>
<span id="el_products_tipo_inmueble">
<span<?php echo $products_view->tipo_inmueble->viewAttributes() ?>><?php echo $products_view->tipo_inmueble->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->tipo_negocio->Visible) { // tipo_negocio ?>
	<tr id="r_tipo_negocio">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_tipo_negocio"><?php echo $products_view->tipo_negocio->caption() ?></span></td>
		<td data-name="tipo_negocio" <?php echo $products_view->tipo_negocio->cellAttributes() ?>>
<span id="el_products_tipo_negocio">
<span<?php echo $products_view->tipo_negocio->viewAttributes() ?>><?php echo $products_view->tipo_negocio->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->tiempo_alquiler->Visible) { // tiempo_alquiler ?>
	<tr id="r_tiempo_alquiler">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_tiempo_alquiler"><?php echo $products_view->tiempo_alquiler->caption() ?></span></td>
		<td data-name="tiempo_alquiler" <?php echo $products_view->tiempo_alquiler->cellAttributes() ?>>
<span id="el_products_tiempo_alquiler">
<span<?php echo $products_view->tiempo_alquiler->viewAttributes() ?>><?php echo $products_view->tiempo_alquiler->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->moneda->Visible) { // moneda ?>
	<tr id="r_moneda">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_moneda"><?php echo $products_view->moneda->caption() ?></span></td>
		<td data-name="moneda" <?php echo $products_view->moneda->cellAttributes() ?>>
<span id="el_products_moneda">
<span<?php echo $products_view->moneda->viewAttributes() ?>><?php echo $products_view->moneda->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->estado_inmueble->Visible) { // estado_inmueble ?>
	<tr id="r_estado_inmueble">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_estado_inmueble"><?php echo $products_view->estado_inmueble->caption() ?></span></td>
		<td data-name="estado_inmueble" <?php echo $products_view->estado_inmueble->cellAttributes() ?>>
<span id="el_products_estado_inmueble">
<span<?php echo $products_view->estado_inmueble->viewAttributes() ?>><?php echo $products_view->estado_inmueble->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->area_construida->Visible) { // area_construida ?>
	<tr id="r_area_construida">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_area_construida"><?php echo $products_view->area_construida->caption() ?></span></td>
		<td data-name="area_construida" <?php echo $products_view->area_construida->cellAttributes() ?>>
<span id="el_products_area_construida">
<span<?php echo $products_view->area_construida->viewAttributes() ?>><?php echo $products_view->area_construida->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->area_privada->Visible) { // area_privada ?>
	<tr id="r_area_privada">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_area_privada"><?php echo $products_view->area_privada->caption() ?></span></td>
		<td data-name="area_privada" <?php echo $products_view->area_privada->cellAttributes() ?>>
<span id="el_products_area_privada">
<span<?php echo $products_view->area_privada->viewAttributes() ?>><?php echo $products_view->area_privada->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->area_terreno->Visible) { // area_terreno ?>
	<tr id="r_area_terreno">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_area_terreno"><?php echo $products_view->area_terreno->caption() ?></span></td>
		<td data-name="area_terreno" <?php echo $products_view->area_terreno->cellAttributes() ?>>
<span id="el_products_area_terreno">
<span<?php echo $products_view->area_terreno->viewAttributes() ?>><?php echo $products_view->area_terreno->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->valor_administracion->Visible) { // valor_administracion ?>
	<tr id="r_valor_administracion">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_valor_administracion"><?php echo $products_view->valor_administracion->caption() ?></span></td>
		<td data-name="valor_administracion" <?php echo $products_view->valor_administracion->cellAttributes() ?>>
<span id="el_products_valor_administracion">
<span<?php echo $products_view->valor_administracion->viewAttributes() ?>><?php echo $products_view->valor_administracion->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->dormitorios->Visible) { // dormitorios ?>
	<tr id="r_dormitorios">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_dormitorios"><?php echo $products_view->dormitorios->caption() ?></span></td>
		<td data-name="dormitorios" <?php echo $products_view->dormitorios->cellAttributes() ?>>
<span id="el_products_dormitorios">
<span<?php echo $products_view->dormitorios->viewAttributes() ?>><?php echo $products_view->dormitorios->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->banios->Visible) { // banios ?>
	<tr id="r_banios">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_banios"><?php echo $products_view->banios->caption() ?></span></td>
		<td data-name="banios" <?php echo $products_view->banios->cellAttributes() ?>>
<span id="el_products_banios">
<span<?php echo $products_view->banios->viewAttributes() ?>><?php echo $products_view->banios->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->garaje->Visible) { // garaje ?>
	<tr id="r_garaje">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_garaje"><?php echo $products_view->garaje->caption() ?></span></td>
		<td data-name="garaje" <?php echo $products_view->garaje->cellAttributes() ?>>
<span id="el_products_garaje">
<span<?php echo $products_view->garaje->viewAttributes() ?>><?php echo $products_view->garaje->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->piso->Visible) { // piso ?>
	<tr id="r_piso">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_piso"><?php echo $products_view->piso->caption() ?></span></td>
		<td data-name="piso" <?php echo $products_view->piso->cellAttributes() ?>>
<span id="el_products_piso">
<span<?php echo $products_view->piso->viewAttributes() ?>><?php echo $products_view->piso->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->estrato->Visible) { // estrato ?>
	<tr id="r_estrato">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_estrato"><?php echo $products_view->estrato->caption() ?></span></td>
		<td data-name="estrato" <?php echo $products_view->estrato->cellAttributes() ?>>
<span id="el_products_estrato">
<span<?php echo $products_view->estrato->viewAttributes() ?>><?php echo $products_view->estrato->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->direccion->Visible) { // direccion ?>
	<tr id="r_direccion">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_direccion"><?php echo $products_view->direccion->caption() ?></span></td>
		<td data-name="direccion" <?php echo $products_view->direccion->cellAttributes() ?>>
<span id="el_products_direccion">
<span<?php echo $products_view->direccion->viewAttributes() ?>><?php echo $products_view->direccion->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->codigo_postal->Visible) { // codigo_postal ?>
	<tr id="r_codigo_postal">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_codigo_postal"><?php echo $products_view->codigo_postal->caption() ?></span></td>
		<td data-name="codigo_postal" <?php echo $products_view->codigo_postal->cellAttributes() ?>>
<span id="el_products_codigo_postal">
<span<?php echo $products_view->codigo_postal->viewAttributes() ?>><?php echo $products_view->codigo_postal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->mapa->Visible) { // mapa ?>
	<tr id="r_mapa">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_mapa"><?php echo $products_view->mapa->caption() ?></span></td>
		<td data-name="mapa" <?php echo $products_view->mapa->cellAttributes() ?>>
<span id="el_products_mapa">
<span<?php echo $products_view->mapa->viewAttributes() ?>><?php echo $products_view->mapa->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->latitud->Visible) { // latitud ?>
	<tr id="r_latitud">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_latitud"><?php echo $products_view->latitud->caption() ?></span></td>
		<td data-name="latitud" <?php echo $products_view->latitud->cellAttributes() ?>>
<span id="el_products_latitud">
<span<?php echo $products_view->latitud->viewAttributes() ?>><?php echo $products_view->latitud->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->longitud->Visible) { // longitud ?>
	<tr id="r_longitud">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_longitud"><?php echo $products_view->longitud->caption() ?></span></td>
		<td data-name="longitud" <?php echo $products_view->longitud->cellAttributes() ?>>
<span id="el_products_longitud">
<span<?php echo $products_view->longitud->viewAttributes() ?>><?php echo $products_view->longitud->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->opciones_mapa->Visible) { // opciones_mapa ?>
	<tr id="r_opciones_mapa">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_opciones_mapa"><?php echo $products_view->opciones_mapa->caption() ?></span></td>
		<td data-name="opciones_mapa" <?php echo $products_view->opciones_mapa->cellAttributes() ?>>
<span id="el_products_opciones_mapa">
<span<?php echo $products_view->opciones_mapa->viewAttributes() ?>><?php echo $products_view->opciones_mapa->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->red->Visible) { // red ?>
	<tr id="r_red">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_red"><?php echo $products_view->red->caption() ?></span></td>
		<td data-name="red" <?php echo $products_view->red->cellAttributes() ?>>
<span id="el_products_red">
<span<?php echo $products_view->red->viewAttributes() ?>><?php echo $products_view->red->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->video->Visible) { // video ?>
	<tr id="r_video">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_video"><?php echo $products_view->video->caption() ?></span></td>
		<td data-name="video" <?php echo $products_view->video->cellAttributes() ?>>
<span id="el_products_video">
<span<?php echo $products_view->video->viewAttributes() ?>><?php echo $products_view->video->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->disponibilidad->Visible) { // disponibilidad ?>
	<tr id="r_disponibilidad">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_disponibilidad"><?php echo $products_view->disponibilidad->caption() ?></span></td>
		<td data-name="disponibilidad" <?php echo $products_view->disponibilidad->cellAttributes() ?>>
<span id="el_products_disponibilidad">
<span<?php echo $products_view->disponibilidad->viewAttributes() ?>><?php echo $products_view->disponibilidad->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->anio_construccion->Visible) { // anio_construccion ?>
	<tr id="r_anio_construccion">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_anio_construccion"><?php echo $products_view->anio_construccion->caption() ?></span></td>
		<td data-name="anio_construccion" <?php echo $products_view->anio_construccion->cellAttributes() ?>>
<span id="el_products_anio_construccion">
<span<?php echo $products_view->anio_construccion->viewAttributes() ?>><?php echo $products_view->anio_construccion->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->encargado->Visible) { // encargado ?>
	<tr id="r_encargado">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_encargado"><?php echo $products_view->encargado->caption() ?></span></td>
		<td data-name="encargado" <?php echo $products_view->encargado->cellAttributes() ?>>
<span id="el_products_encargado">
<span<?php echo $products_view->encargado->viewAttributes() ?>><?php echo $products_view->encargado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->comentario->Visible) { // comentario ?>
	<tr id="r_comentario">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_comentario"><?php echo $products_view->comentario->caption() ?></span></td>
		<td data-name="comentario" <?php echo $products_view->comentario->cellAttributes() ?>>
<span id="el_products_comentario">
<span<?php echo $products_view->comentario->viewAttributes() ?>><?php echo $products_view->comentario->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->visitas->Visible) { // visitas ?>
	<tr id="r_visitas">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_visitas"><?php echo $products_view->visitas->caption() ?></span></td>
		<td data-name="visitas" <?php echo $products_view->visitas->cellAttributes() ?>>
<span id="el_products_visitas">
<span<?php echo $products_view->visitas->viewAttributes() ?>><?php echo $products_view->visitas->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->valor_comision->Visible) { // valor_comision ?>
	<tr id="r_valor_comision">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_valor_comision"><?php echo $products_view->valor_comision->caption() ?></span></td>
		<td data-name="valor_comision" <?php echo $products_view->valor_comision->cellAttributes() ?>>
<span id="el_products_valor_comision">
<span<?php echo $products_view->valor_comision->viewAttributes() ?>><?php echo $products_view->valor_comision->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->tipo_comision->Visible) { // tipo_comision ?>
	<tr id="r_tipo_comision">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_tipo_comision"><?php echo $products_view->tipo_comision->caption() ?></span></td>
		<td data-name="tipo_comision" <?php echo $products_view->tipo_comision->cellAttributes() ?>>
<span id="el_products_tipo_comision">
<span<?php echo $products_view->tipo_comision->viewAttributes() ?>><?php echo $products_view->tipo_comision->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->certificado->Visible) { // certificado ?>
	<tr id="r_certificado">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_certificado"><?php echo $products_view->certificado->caption() ?></span></td>
		<td data-name="certificado" <?php echo $products_view->certificado->cellAttributes() ?>>
<span id="el_products_certificado">
<span<?php echo $products_view->certificado->viewAttributes() ?>><?php echo $products_view->certificado->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->nombre_propietario->Visible) { // nombre_propietario ?>
	<tr id="r_nombre_propietario">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_nombre_propietario"><?php echo $products_view->nombre_propietario->caption() ?></span></td>
		<td data-name="nombre_propietario" <?php echo $products_view->nombre_propietario->cellAttributes() ?>>
<span id="el_products_nombre_propietario">
<span<?php echo $products_view->nombre_propietario->viewAttributes() ?>><?php echo $products_view->nombre_propietario->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->movil_propietario->Visible) { // movil_propietario ?>
	<tr id="r_movil_propietario">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_movil_propietario"><?php echo $products_view->movil_propietario->caption() ?></span></td>
		<td data-name="movil_propietario" <?php echo $products_view->movil_propietario->cellAttributes() ?>>
<span id="el_products_movil_propietario">
<span<?php echo $products_view->movil_propietario->viewAttributes() ?>><?php echo $products_view->movil_propietario->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->telefono_propietario->Visible) { // telefono_propietario ?>
	<tr id="r_telefono_propietario">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_telefono_propietario"><?php echo $products_view->telefono_propietario->caption() ?></span></td>
		<td data-name="telefono_propietario" <?php echo $products_view->telefono_propietario->cellAttributes() ?>>
<span id="el_products_telefono_propietario">
<span<?php echo $products_view->telefono_propietario->viewAttributes() ?>><?php echo $products_view->telefono_propietario->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->correo_propietario->Visible) { // correo_propietario ?>
	<tr id="r_correo_propietario">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_correo_propietario"><?php echo $products_view->correo_propietario->caption() ?></span></td>
		<td data-name="correo_propietario" <?php echo $products_view->correo_propietario->cellAttributes() ?>>
<span id="el_products_correo_propietario">
<span<?php echo $products_view->correo_propietario->viewAttributes() ?>><?php echo $products_view->correo_propietario->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->vinculo->Visible) { // vinculo ?>
	<tr id="r_vinculo">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_vinculo"><?php echo $products_view->vinculo->caption() ?></span></td>
		<td data-name="vinculo" <?php echo $products_view->vinculo->cellAttributes() ?>>
<span id="el_products_vinculo">
<span<?php echo $products_view->vinculo->viewAttributes() ?>><?php echo $products_view->vinculo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->portales->Visible) { // portales ?>
	<tr id="r_portales">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_portales"><?php echo $products_view->portales->caption() ?></span></td>
		<td data-name="portales" <?php echo $products_view->portales->cellAttributes() ?>>
<span id="el_products_portales">
<span<?php echo $products_view->portales->viewAttributes() ?>><?php echo $products_view->portales->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->notas->Visible) { // notas ?>
	<tr id="r_notas">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_notas"><?php echo $products_view->notas->caption() ?></span></td>
		<td data-name="notas" <?php echo $products_view->notas->cellAttributes() ?>>
<span id="el_products_notas">
<span<?php echo $products_view->notas->viewAttributes() ?>><?php echo $products_view->notas->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->marca->Visible) { // marca ?>
	<tr id="r_marca">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_marca"><?php echo $products_view->marca->caption() ?></span></td>
		<td data-name="marca" <?php echo $products_view->marca->cellAttributes() ?>>
<span id="el_products_marca">
<span<?php echo $products_view->marca->viewAttributes() ?>><?php echo $products_view->marca->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->modelo->Visible) { // modelo ?>
	<tr id="r_modelo">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_modelo"><?php echo $products_view->modelo->caption() ?></span></td>
		<td data-name="modelo" <?php echo $products_view->modelo->cellAttributes() ?>>
<span id="el_products_modelo">
<span<?php echo $products_view->modelo->viewAttributes() ?>><?php echo $products_view->modelo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->color->Visible) { // color ?>
	<tr id="r_color">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_color"><?php echo $products_view->color->caption() ?></span></td>
		<td data-name="color" <?php echo $products_view->color->cellAttributes() ?>>
<span id="el_products_color">
<span<?php echo $products_view->color->viewAttributes() ?>><?php echo $products_view->color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b1->Visible) { // b1 ?>
	<tr id="r_b1">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b1"><?php echo $products_view->b1->caption() ?></span></td>
		<td data-name="b1" <?php echo $products_view->b1->cellAttributes() ?>>
<span id="el_products_b1">
<span<?php echo $products_view->b1->viewAttributes() ?>><?php echo $products_view->b1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b2->Visible) { // b2 ?>
	<tr id="r_b2">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b2"><?php echo $products_view->b2->caption() ?></span></td>
		<td data-name="b2" <?php echo $products_view->b2->cellAttributes() ?>>
<span id="el_products_b2">
<span<?php echo $products_view->b2->viewAttributes() ?>><?php echo $products_view->b2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b3->Visible) { // b3 ?>
	<tr id="r_b3">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b3"><?php echo $products_view->b3->caption() ?></span></td>
		<td data-name="b3" <?php echo $products_view->b3->cellAttributes() ?>>
<span id="el_products_b3">
<span<?php echo $products_view->b3->viewAttributes() ?>><?php echo $products_view->b3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b4->Visible) { // b4 ?>
	<tr id="r_b4">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b4"><?php echo $products_view->b4->caption() ?></span></td>
		<td data-name="b4" <?php echo $products_view->b4->cellAttributes() ?>>
<span id="el_products_b4">
<span<?php echo $products_view->b4->viewAttributes() ?>><?php echo $products_view->b4->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b5->Visible) { // b5 ?>
	<tr id="r_b5">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b5"><?php echo $products_view->b5->caption() ?></span></td>
		<td data-name="b5" <?php echo $products_view->b5->cellAttributes() ?>>
<span id="el_products_b5">
<span<?php echo $products_view->b5->viewAttributes() ?>><?php echo $products_view->b5->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->b6->Visible) { // b6 ?>
	<tr id="r_b6">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_b6"><?php echo $products_view->b6->caption() ?></span></td>
		<td data-name="b6" <?php echo $products_view->b6->cellAttributes() ?>>
<span id="el_products_b6">
<span<?php echo $products_view->b6->viewAttributes() ?>><?php echo $products_view->b6->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->cat_pro->Visible) { // cat_pro ?>
	<tr id="r_cat_pro">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_cat_pro"><?php echo $products_view->cat_pro->caption() ?></span></td>
		<td data-name="cat_pro" <?php echo $products_view->cat_pro->cellAttributes() ?>>
<span id="el_products_cat_pro">
<span<?php echo $products_view->cat_pro->viewAttributes() ?>><?php echo $products_view->cat_pro->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->pro_ser->Visible) { // pro_ser ?>
	<tr id="r_pro_ser">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_pro_ser"><?php echo $products_view->pro_ser->caption() ?></span></td>
		<td data-name="pro_ser" <?php echo $products_view->pro_ser->cellAttributes() ?>>
<span id="el_products_pro_ser">
<span<?php echo $products_view->pro_ser->viewAttributes() ?>><?php echo $products_view->pro_ser->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->foto1->Visible) { // foto1 ?>
	<tr id="r_foto1">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_foto1"><?php echo $products_view->foto1->caption() ?></span></td>
		<td data-name="foto1" <?php echo $products_view->foto1->cellAttributes() ?>>
<span id="el_products_foto1">
<span<?php echo $products_view->foto1->viewAttributes() ?>><?php echo $products_view->foto1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->foto2->Visible) { // foto2 ?>
	<tr id="r_foto2">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_foto2"><?php echo $products_view->foto2->caption() ?></span></td>
		<td data-name="foto2" <?php echo $products_view->foto2->cellAttributes() ?>>
<span id="el_products_foto2">
<span<?php echo $products_view->foto2->viewAttributes() ?>><?php echo $products_view->foto2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->foto3->Visible) { // foto3 ?>
	<tr id="r_foto3">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_foto3"><?php echo $products_view->foto3->caption() ?></span></td>
		<td data-name="foto3" <?php echo $products_view->foto3->cellAttributes() ?>>
<span id="el_products_foto3">
<span<?php echo $products_view->foto3->viewAttributes() ?>><?php echo $products_view->foto3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->foto4->Visible) { // foto4 ?>
	<tr id="r_foto4">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_foto4"><?php echo $products_view->foto4->caption() ?></span></td>
		<td data-name="foto4" <?php echo $products_view->foto4->cellAttributes() ?>>
<span id="el_products_foto4">
<span<?php echo $products_view->foto4->viewAttributes() ?>><?php echo $products_view->foto4->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->web->Visible) { // web ?>
	<tr id="r_web">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_web"><?php echo $products_view->web->caption() ?></span></td>
		<td data-name="web" <?php echo $products_view->web->cellAttributes() ?>>
<span id="el_products_web">
<span<?php echo $products_view->web->viewAttributes() ?>><?php echo $products_view->web->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->pre_web->Visible) { // pre_web ?>
	<tr id="r_pre_web">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_pre_web"><?php echo $products_view->pre_web->caption() ?></span></td>
		<td data-name="pre_web" <?php echo $products_view->pre_web->cellAttributes() ?>>
<span id="el_products_pre_web">
<span<?php echo $products_view->pre_web->viewAttributes() ?>><?php echo $products_view->pre_web->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->descripcion->Visible) { // descripcion ?>
	<tr id="r_descripcion">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_descripcion"><?php echo $products_view->descripcion->caption() ?></span></td>
		<td data-name="descripcion" <?php echo $products_view->descripcion->cellAttributes() ?>>
<span id="el_products_descripcion">
<span<?php echo $products_view->descripcion->viewAttributes() ?>><?php echo $products_view->descripcion->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->descripcion1->Visible) { // descripcion1 ?>
	<tr id="r_descripcion1">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_descripcion1"><?php echo $products_view->descripcion1->caption() ?></span></td>
		<td data-name="descripcion1" <?php echo $products_view->descripcion1->cellAttributes() ?>>
<span id="el_products_descripcion1">
<span<?php echo $products_view->descripcion1->viewAttributes() ?>><?php echo $products_view->descripcion1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->megusta->Visible) { // megusta ?>
	<tr id="r_megusta">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_megusta"><?php echo $products_view->megusta->caption() ?></span></td>
		<td data-name="megusta" <?php echo $products_view->megusta->cellAttributes() ?>>
<span id="el_products_megusta">
<span<?php echo $products_view->megusta->viewAttributes() ?>><?php echo $products_view->megusta->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->nomegusta->Visible) { // nomegusta ?>
	<tr id="r_nomegusta">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_nomegusta"><?php echo $products_view->nomegusta->caption() ?></span></td>
		<td data-name="nomegusta" <?php echo $products_view->nomegusta->cellAttributes() ?>>
<span id="el_products_nomegusta">
<span<?php echo $products_view->nomegusta->viewAttributes() ?>><?php echo $products_view->nomegusta->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->precio2->Visible) { // precio2 ?>
	<tr id="r_precio2">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_precio2"><?php echo $products_view->precio2->caption() ?></span></td>
		<td data-name="precio2" <?php echo $products_view->precio2->cellAttributes() ?>>
<span id="el_products_precio2">
<span<?php echo $products_view->precio2->viewAttributes() ?>><?php echo $products_view->precio2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->precio3->Visible) { // precio3 ?>
	<tr id="r_precio3">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_precio3"><?php echo $products_view->precio3->caption() ?></span></td>
		<td data-name="precio3" <?php echo $products_view->precio3->cellAttributes() ?>>
<span id="el_products_precio3">
<span<?php echo $products_view->precio3->viewAttributes() ?>><?php echo $products_view->precio3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->und_pro->Visible) { // und_pro ?>
	<tr id="r_und_pro">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_und_pro"><?php echo $products_view->und_pro->caption() ?></span></td>
		<td data-name="und_pro" <?php echo $products_view->und_pro->cellAttributes() ?>>
<span id="el_products_und_pro">
<span<?php echo $products_view->und_pro->viewAttributes() ?>><?php echo $products_view->und_pro->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->barras->Visible) { // barras ?>
	<tr id="r_barras">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_barras"><?php echo $products_view->barras->caption() ?></span></td>
		<td data-name="barras" <?php echo $products_view->barras->cellAttributes() ?>>
<span id="el_products_barras">
<span<?php echo $products_view->barras->viewAttributes() ?>><?php echo $products_view->barras->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->stockmin->Visible) { // stockmin ?>
	<tr id="r_stockmin">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_stockmin"><?php echo $products_view->stockmin->caption() ?></span></td>
		<td data-name="stockmin" <?php echo $products_view->stockmin->cellAttributes() ?>>
<span id="el_products_stockmin">
<span<?php echo $products_view->stockmin->viewAttributes() ?>><?php echo $products_view->stockmin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->id_grupo->Visible) { // id_grupo ?>
	<tr id="r_id_grupo">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_id_grupo"><?php echo $products_view->id_grupo->caption() ?></span></td>
		<td data-name="id_grupo" <?php echo $products_view->id_grupo->cellAttributes() ?>>
<span id="el_products_id_grupo">
<span<?php echo $products_view->id_grupo->viewAttributes() ?>><?php echo $products_view->id_grupo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->talla->Visible) { // talla ?>
	<tr id="r_talla">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_talla"><?php echo $products_view->talla->caption() ?></span></td>
		<td data-name="talla" <?php echo $products_view->talla->cellAttributes() ?>>
<span id="el_products_talla">
<span<?php echo $products_view->talla->viewAttributes() ?>><?php echo $products_view->talla->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->mostrarcolor->Visible) { // mostrarcolor ?>
	<tr id="r_mostrarcolor">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_mostrarcolor"><?php echo $products_view->mostrarcolor->caption() ?></span></td>
		<td data-name="mostrarcolor" <?php echo $products_view->mostrarcolor->cellAttributes() ?>>
<span id="el_products_mostrarcolor">
<span<?php echo $products_view->mostrarcolor->viewAttributes() ?>><?php echo $products_view->mostrarcolor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->precio_mayorista->Visible) { // precio_mayorista ?>
	<tr id="r_precio_mayorista">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_precio_mayorista"><?php echo $products_view->precio_mayorista->caption() ?></span></td>
		<td data-name="precio_mayorista" <?php echo $products_view->precio_mayorista->cellAttributes() ?>>
<span id="el_products_precio_mayorista">
<span<?php echo $products_view->precio_mayorista->viewAttributes() ?>><?php echo $products_view->precio_mayorista->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->precio_vendedor->Visible) { // precio_vendedor ?>
	<tr id="r_precio_vendedor">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_precio_vendedor"><?php echo $products_view->precio_vendedor->caption() ?></span></td>
		<td data-name="precio_vendedor" <?php echo $products_view->precio_vendedor->cellAttributes() ?>>
<span id="el_products_precio_vendedor">
<span<?php echo $products_view->precio_vendedor->viewAttributes() ?>><?php echo $products_view->precio_vendedor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->medida1->Visible) { // medida1 ?>
	<tr id="r_medida1">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_medida1"><?php echo $products_view->medida1->caption() ?></span></td>
		<td data-name="medida1" <?php echo $products_view->medida1->cellAttributes() ?>>
<span id="el_products_medida1">
<span<?php echo $products_view->medida1->viewAttributes() ?>><?php echo $products_view->medida1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->medida2->Visible) { // medida2 ?>
	<tr id="r_medida2">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_medida2"><?php echo $products_view->medida2->caption() ?></span></td>
		<td data-name="medida2" <?php echo $products_view->medida2->cellAttributes() ?>>
<span id="el_products_medida2">
<span<?php echo $products_view->medida2->viewAttributes() ?>><?php echo $products_view->medida2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->medida3->Visible) { // medida3 ?>
	<tr id="r_medida3">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_medida3"><?php echo $products_view->medida3->caption() ?></span></td>
		<td data-name="medida3" <?php echo $products_view->medida3->cellAttributes() ?>>
<span id="el_products_medida3">
<span<?php echo $products_view->medida3->viewAttributes() ?>><?php echo $products_view->medida3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->codlogin->Visible) { // codlogin ?>
	<tr id="r_codlogin">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_codlogin"><?php echo $products_view->codlogin->caption() ?></span></td>
		<td data-name="codlogin" <?php echo $products_view->codlogin->cellAttributes() ?>>
<span id="el_products_codlogin">
<span<?php echo $products_view->codlogin->viewAttributes() ?>><?php echo $products_view->codlogin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->idempresa->Visible) { // idempresa ?>
	<tr id="r_idempresa">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_idempresa"><?php echo $products_view->idempresa->caption() ?></span></td>
		<td data-name="idempresa" <?php echo $products_view->idempresa->cellAttributes() ?>>
<span id="el_products_idempresa">
<span<?php echo $products_view->idempresa->viewAttributes() ?>><?php echo $products_view->idempresa->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($products_view->urlstreetview->Visible) { // urlstreetview ?>
	<tr id="r_urlstreetview">
		<td class="<?php echo $products_view->TableLeftColumnClass ?>"><span id="elh_products_urlstreetview"><?php echo $products_view->urlstreetview->caption() ?></span></td>
		<td data-name="urlstreetview" <?php echo $products_view->urlstreetview->cellAttributes() ?>>
<span id="el_products_urlstreetview">
<span<?php echo $products_view->urlstreetview->viewAttributes() ?>><?php echo $products_view->urlstreetview->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$products_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$products_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$products_view->terminate();
?>